/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import enums.MotionRestriction;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import shapes.Ellipse2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class HotSpot
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Ellipse2DExt area;
    private Point2DExt center;
    private Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    private boolean DirectionIn = false;
    private int directionInBeginTime = 0;
    private int directionInEndTime = 100;
    private DirectionInTimeType DirectionInType = DirectionInTimeType.TimeOfDepartureFromSource;
    private boolean DirectionOut = false;
    private int directionOutBeginTime = 0;
    private int directionOutEndTime = 100;
    private int numberOfVehicles = 100;
    private double radiusx;
    private double radiusy;
    private TypeSelection<VehicleType> vehicleSelection;

    public HotSpot(Point2D.Double center) {
        this.name = "Hotspot " + String.valueOf(increment++);
        this.center = new Point2DExt(center);
        this.area = new Ellipse2DExt();
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    public HotSpot(HotSpot source) {
        super(source);
        this.numberOfVehicles = source.numberOfVehicles;
        this.color = new Color(source.color.getRGB());
        this.area = new Ellipse2DExt(source.area);
        this.center = new Point2DExt(source.center);
        this.radiusx = source.radiusx;
        this.radiusy = source.radiusy;
        this.DirectionIn = source.DirectionIn;
        this.directionInBeginTime = source.directionInBeginTime;
        this.directionInEndTime = source.directionInEndTime;
        this.DirectionInType = source.DirectionInType;
        this.DirectionOut = source.DirectionOut;
        this.directionOutBeginTime = source.directionOutBeginTime;
        this.directionOutEndTime = source.directionOutEndTime;
        this.vehicleSelection = new TypeSelection<VehicleType>(source.vehicleSelection);
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (isSelected) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200));
        }
        if (this.area != null) {
            g.fill(this.area);
        }
        super.Draw(g, zoomFactor, isDeleted, isSelected);
        g.setColor(prev);
    }

    @Override
    public Rectangle2DExt getBounds() {
        Rectangle2D bounds = this.area.getBounds2D();
        return new Rectangle2DExt(bounds.getCenterX(), bounds.getCenterY(), bounds.getWidth(), bounds.getHeight());
    }

    public void createHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        Handle centerHandle = new Handle(this.center, "center", MotionRestriction.None);
        Handle XRadiusHandle = new Handle(new Point2D.Double(this.center.x + this.radiusx, this.center.y), "XRadius", MotionRestriction.Horizontal);
        Handle YRadiusHandle = new Handle(new Point2D.Double(this.center.x, this.center.y + this.radiusy), "YRadius", MotionRestriction.Vertical);
        handles.add(centerHandle);
        handles.add(XRadiusHandle);
        handles.add(YRadiusHandle);
        this.addHandles(handles);
    }

    public Ellipse2DExt getArea() {
        return this.area;
    }

    public Color getColor() {
        return this.color;
    }

    public int getDirectionInBeginTime() {
        return this.directionInBeginTime;
    }

    public int getDirectionInEndTime() {
        return this.directionInEndTime;
    }

    public DirectionInTimeType getDirectionInType() {
        return this.DirectionInType;
    }

    public int getDirectionOutBeginTime() {
        return this.directionOutBeginTime;
    }

    public int getDirectionOutEndTime() {
        return this.directionOutEndTime;
    }

    public int getNumberOfVehicles() {
        return this.numberOfVehicles;
    }

    @Override
    public String getToolTip() {
        String tooltip = "<html><b>HotSpot</b> " + this.name + "<br>" + "<b>Number of vehicles: </b> " + String.valueOf(this.numberOfVehicles) + "<br>" + "<b>Direction: </b>";
        if (this.DirectionIn) {
            tooltip = String.valueOf(tooltip) + "Incoming ";
        }
        if (this.DirectionOut) {
            tooltip = String.valueOf(tooltip) + "Outgoing ";
        }
        return tooltip;
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    @Override
    public void handleLocationChanged(Handle h) {
        if (h.getName().equals("center")) {
            this.center = new Point2DExt(h.getLocation());
            ((Handle)this.handles.get("XRadius")).setUnrestrictedLocation(new Point2D.Double(this.center.x + this.radiusx, this.center.y));
            ((Handle)this.handles.get("YRadius")).setUnrestrictedLocation(new Point2D.Double(this.center.x, this.center.y + this.radiusy));
        } else if (h.getName().equals("XRadius")) {
            this.radiusx = h.getLocation().x - this.center.x;
        } else if (h.getName().equals("YRadius")) {
            this.radiusy = h.getLocation().y - this.center.y;
        }
        this.area.setFrameFromCenter(this.center, new Point2D.Double(this.center.x + this.radiusx, this.center.y + this.radiusy));
    }

    @Override
    public boolean Hit(Point p) {
        return this.area.getBounds2D().contains(p.x, p.y) && this.area.contains(p.x, p.y);
    }

    @Override
    public boolean Hit(Rectangle transformedRectangle) {
        return this.area.intersects(transformedRectangle);
    }

    public boolean isDirectionIn() {
        return this.DirectionIn;
    }

    public boolean isDirectionOut() {
        return this.DirectionOut;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDirectionIn(boolean directionIn) {
        this.DirectionIn = directionIn;
    }

    public void setDirectionInBeginTime(int directionInBeginTime) {
        this.directionInBeginTime = directionInBeginTime;
    }

    public void setDirectionInEndTime(int directionInEndTime) {
        this.directionInEndTime = directionInEndTime;
    }

    public void setDirectionInType(DirectionInTimeType directionInType) {
        this.DirectionInType = directionInType;
    }

    public void setDirectionOut(boolean directionOut) {
        this.DirectionOut = directionOut;
    }

    public void setDirectionOutBeginTime(int directionOutBeginTime) {
        this.directionOutBeginTime = directionOutBeginTime;
    }

    public void setDirectionOutEndTime(int directionOutEndTime) {
        this.directionOutEndTime = directionOutEndTime;
    }

    public void setNumberOfVehicles(int numberOfVehicles) {
        this.numberOfVehicles = numberOfVehicles;
    }

    public void setRadius(Point2D.Double p) {
        this.radiusx = p.x - this.center.x;
        this.radiusy = p.y - this.center.y;
        this.area.setFrameFromCenter(this.center, new Point2D.Double(this.center.x + this.radiusx, this.center.y + this.radiusy));
    }

    public void setVehicleSelection(TypeSelection<VehicleType> vehicleSelection) {
        this.vehicleSelection = vehicleSelection;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new HotSpot(this);
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<hotspot name=\"" + this.name + "\" incoming=\"" + String.valueOf(this.DirectionIn) + "\" incomingTimeType=\"" + this.DirectionInType.name() + "\" incomingStartingTime=\"" + String.valueOf(this.directionInBeginTime) + "\" incomingEndingTime=\"" + String.valueOf(this.directionInEndTime) + "\" outgoing=\"" + String.valueOf(this.DirectionOut) + "\" outgoingStartingTime=\"" + String.valueOf(this.directionOutBeginTime) + "\" outgoingEndingTime=\"" + String.valueOf(this.directionOutEndTime) + "\" numberOfVehicles=\"" + String.valueOf(this.numberOfVehicles) + "\">\n");
        sb.append(XMLHelpers.vehicleSelectionToXML("vehicleSelection", this.vehicleSelection));
        sb.append("<areaShape>");
        sb.append(XMLHelpers.shapeToXML(this.area));
        sb.append("</areaShape>\n");
        sb.append("</hotspot>\n");
        return sb.toString();
    }

    public static enum DirectionInTimeType {
        TimeOfArrivalToDestination,
        TimeOfDepartureFromSource;

    }
}

