/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.defaults;

import cadyts.calibrators.Calibrator;
import cadyts.measurements.MultiLinkMeasurement;
import cadyts.measurements.SingleLinkMeasurement;
import cadyts.utilities.misc.Time;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BasicMeasurementLoader<L>
extends DefaultHandler {
    private static final String SINGLE_LINK_ELEMENT = "singlelink";
    private static final String LINK_ATTRIBUTE = "link";
    private static final String START_TIME_ATTRIBUTE = "start";
    private static final String END_TIME_ATTRIBUTE = "end";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String STDDEV_ATTRIBUTE = "stddev";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MULTI_LINK_ELEMENT = "multilink";
    private static final String DETECTIONRATE_ATTRIBUTE = "detectionrate";
    private static final String OBSERVATION_ELEMENT = "observation";
    private final Calibrator<L> calibrator;
    private MultiLinkMeasurement<L> p2pCrispMeas = null;

    public BasicMeasurementLoader(Calibrator<L> calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
    }

    public void load(String ... measurementFileNames) {
        if (measurementFileNames == null || measurementFileNames.length == 0) {
            Logger.getLogger(this.getClass().getName()).info("no measurement files specified");
            return;
        }
        String[] stringArray = measurementFileNames;
        int n = measurementFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(fileName, (DefaultHandler)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (SINGLE_LINK_ELEMENT.equals(qName)) {
            SingleLinkMeasurement.TYPE type = SingleLinkMeasurement.TYPE.valueOf(attrs.getValue(TYPE_ATTRIBUTE));
            if (SingleLinkMeasurement.TYPE.FLOW_VEH_H.equals((Object)type) || SingleLinkMeasurement.TYPE.COUNT_VEH.equals((Object)type)) {
                L link = this.label2link(attrs.getValue(LINK_ATTRIBUTE));
                double value = Double.parseDouble(attrs.getValue(VALUE_ATTRIBUTE));
                int start_s = Time.secFromStr(attrs.getValue(START_TIME_ATTRIBUTE));
                int end_s = Time.secFromStr(attrs.getValue(END_TIME_ATTRIBUTE));
                String stddevString = attrs.getValue(STDDEV_ATTRIBUTE);
                if (stddevString == null) {
                    this.calibrator.addMeasurement(link, start_s, end_s, value, type);
                } else {
                    double stddev = Double.parseDouble(stddevString);
                    this.calibrator.addMeasurement(link, start_s, end_s, value, stddev, type);
                }
            } else {
                Logger.getLogger(this.getClass().getName()).warning("skipping \"onlink\" measurement type: " + (Object)((Object)type));
            }
        } else if (MULTI_LINK_ELEMENT.equals(qName)) {
            int value = Integer.parseInt(attrs.getValue(VALUE_ATTRIBUTE));
            double detectionRate = Double.parseDouble(attrs.getValue(DETECTIONRATE_ATTRIBUTE));
            this.p2pCrispMeas = new MultiLinkMeasurement(value, detectionRate);
        } else if (OBSERVATION_ELEMENT.equals(qName)) {
            L link = this.label2link(attrs.getValue(LINK_ATTRIBUTE));
            int start_s = Time.secFromStr(attrs.getValue(START_TIME_ATTRIBUTE));
            int end_s = Time.secFromStr(attrs.getValue(END_TIME_ATTRIBUTE));
            this.p2pCrispMeas.addObservation(link, start_s, end_s);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (MULTI_LINK_ELEMENT.equals(qName)) {
            this.calibrator.addMeasurement(this.p2pCrispMeas);
            this.p2pCrispMeas = null;
        }
    }

    protected abstract L label2link(String var1);
}

