/*
 * Decompiled with CFR 0.152.
 */
package cadyts.calibrators;

import cadyts.demand.Demand;
import cadyts.demand.Plan;
import cadyts.demand.PlanStep;
import cadyts.measurements.MultiLinkMeasurement;
import cadyts.measurements.SingleLinkMeasurement;
import cadyts.supply.SimResults;
import cadyts.utilities.math.MathHelpers;
import cadyts.utilities.math.Vector;
import cadyts.utilities.misc.DynamicData;
import cadyts.utilities.misc.StatisticsTracker;
import cadyts.utilities.misc.Time;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class Analyzer<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double maxAbsPlanLambda = 15.0;
    private final Demand<L> demand;
    private StatisticsTracker statisticsTracker;
    private final List<SingleLinkMeasurement<L>> allSingleLinkMeas;
    private final List<SingleLinkMeasurement<L>> planListeningSingleLinkMeas;
    private final Map<L, List<SingleLinkMeasurement<L>>> link2meas;
    private final Set<L> observedLinks;
    private final List<MultiLinkMeasurement<L>> allMultiLinkMeas;
    private Vector matchList;
    private Vector newMatchList;

    Analyzer(int startTime_s, int binSize_s, int binCnt) {
        this.demand = new Demand(startTime_s, binSize_s, binCnt);
        this.statisticsTracker = new StatisticsTracker(null);
        this.allSingleLinkMeas = new ArrayList<SingleLinkMeasurement<L>>();
        this.planListeningSingleLinkMeas = new ArrayList<SingleLinkMeasurement<L>>();
        this.link2meas = new LinkedHashMap<L, List<SingleLinkMeasurement<L>>>();
        this.observedLinks = new LinkedHashSet<L>();
        this.allMultiLinkMeas = new ArrayList<MultiLinkMeasurement<L>>();
        this.matchList = null;
        this.newMatchList = null;
    }

    void setStatisticsFile(String statisticsFile) {
        this.statisticsTracker = new StatisticsTracker(statisticsFile);
    }

    String getStatisticsFile() {
        return this.statisticsTracker.getFileName();
    }

    int getBinSize_s() {
        return this.demand.getBinSize_s();
    }

    void freeze() {
        for (SingleLinkMeasurement<L> singleLinkMeasurement : this.allSingleLinkMeas) {
            singleLinkMeasurement.freeze();
        }
        for (MultiLinkMeasurement multiLinkMeasurement : this.allMultiLinkMeas) {
            multiLinkMeasurement.freeze();
        }
    }

    void addMeasurement(SingleLinkMeasurement<L> meas) {
        this.allSingleLinkMeas.add(meas);
        this.allocateSingleLinkMeasurement(meas);
    }

    void addMeasurement(MultiLinkMeasurement<L> meas) {
        this.allMultiLinkMeas.add(meas);
        this.observedLinks.addAll(meas.getObservedLinks());
    }

    private void allocateSingleLinkMeasurement(SingleLinkMeasurement<L> meas) {
        if (meas.isPlanListening()) {
            this.planListeningSingleLinkMeas.add(meas);
        }
        for (L link : meas.getRelevantLinks()) {
            List<SingleLinkMeasurement<L>> measList = this.link2meas.get(link);
            if (measList == null) {
                measList = new ArrayList<SingleLinkMeasurement<L>>();
                this.link2meas.put(link, measList);
            }
            measList.add(meas);
        }
    }

    private int[] indicesInMeas(Plan<L> plan) {
        int[] result = new int[this.allMultiLinkMeas.size()];
        for (PlanStep planStep : plan) {
            int m = 0;
            while (m < this.allMultiLinkMeas.size()) {
                int indexInMeas = result[m];
                MultiLinkMeasurement<L> meas = this.allMultiLinkMeas.get(m);
                if (indexInMeas < meas.size() && meas.appliesTo(indexInMeas, planStep)) {
                    int n = m;
                    result[n] = result[n] + 1;
                }
                ++m;
            }
        }
        return result;
    }

    private int numberOfMatches(int[] indicesInMeas) {
        int result = 0;
        int m = 0;
        while (m < this.allMultiLinkMeas.size()) {
            if (indicesInMeas[m] == this.allMultiLinkMeas.get(m).size()) {
                ++result;
            }
            ++m;
        }
        return result;
    }

    private List<Integer> matchingMeasurementIndices(Plan<L> plan) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] indicesInMeas = this.indicesInMeas(plan);
        int m = 0;
        while (m < this.allMultiLinkMeas.size()) {
            if (indicesInMeas[m] == this.allMultiLinkMeas.get(m).size()) {
                result.add(m);
            }
            ++m;
        }
        return result;
    }

    void notifyPlanChoice(Plan<L> plan) {
        if (plan == null) {
            return;
        }
        for (SingleLinkMeasurement<L> singleLinkMeasurement : this.planListeningSingleLinkMeas) {
            singleLinkMeasurement.notifyPlanChoice(plan);
        }
        if (this.allMultiLinkMeas.size() > 0) {
            if (this.newMatchList == null) {
                this.newMatchList = new Vector(this.allMultiLinkMeas.size());
            }
            List<Integer> list = this.matchingMeasurementIndices(plan);
            double oneByMatches = 1.0 / (double)list.size();
            for (int m : list) {
                this.newMatchList.add(m, oneByMatches);
            }
        }
        for (PlanStep planStep : plan) {
            if (!this.link2meas.keySet().contains(planStep.getLink()) && !this.observedLinks.contains(planStep.getLink())) continue;
            this.demand.add(planStep);
        }
        this.statisticsTracker.registerChoice();
    }

    double calcLinearPlanEffect(Plan<L> plan) {
        if (plan == null) {
            return 0.0;
        }
        double result = 0.0;
        for (PlanStep planStep : plan) {
            List<SingleLinkMeasurement<L>> measList = this.link2meas.get(planStep.getLink());
            if (measList == null) continue;
            for (SingleLinkMeasurement<L> meas : measList) {
                double lambda = meas.getLambda(planStep);
                this.statisticsTracker.registerLinkLambda(lambda);
                result += lambda;
            }
        }
        if (this.allMultiLinkMeas.size() > 0) {
            int[] nArray = this.indicesInMeas(plan);
            double numberOfMatches = this.numberOfMatches(nArray);
            int m = 0;
            while (m < this.allMultiLinkMeas.size()) {
                if (nArray[m] == this.allMultiLinkMeas.get(m).size()) {
                    result += this.allMultiLinkMeas.get(m).dll_dMatches() / numberOfMatches;
                }
                ++m;
            }
        }
        result = Math.min(result, 15.0);
        result = Math.max(result, -15.0);
        this.statisticsTracker.registerPlanLambda(result);
        return result;
    }

    void afterNetworkLoading(SimResults<L> simResults, String flowAnalysisFile) {
        if (flowAnalysisFile != null) {
            try {
                PrintWriter writer = new PrintWriter(flowAnalysisFile);
                writer.println("link\tstart-time\tend-time\tstart-time(sec)\tend-time(sec)\ttype\tsimulated\tmeasured\tstandard-deviation\terror\tabsolute-error\trelative-error\trelative-absolute-error");
                for (SingleLinkMeasurement<L> meas : this.allSingleLinkMeas) {
                    L link = meas.getLink();
                    SingleLinkMeasurement.TYPE type = meas.getType();
                    int start_s = meas.getStartTime_s();
                    int end_s = meas.getEndTime_s();
                    double simValue = simResults.getSimValue(link, start_s, end_s, type);
                    double measValue = meas.getMeasValue();
                    writer.print(link);
                    writer.print("\t");
                    writer.print(Time.strFromSec(start_s, ':'));
                    writer.print("\t");
                    writer.print(Time.strFromSec(end_s, ':'));
                    writer.print("\t");
                    writer.print(start_s);
                    writer.print("\t");
                    writer.print(end_s);
                    writer.print("\t");
                    writer.print((Object)type);
                    writer.print("\t");
                    writer.print(simValue);
                    writer.print("\t");
                    writer.print(measValue);
                    writer.print("\t");
                    writer.print(meas.getMeasStddev());
                    writer.print("\t");
                    writer.print(simValue - measValue);
                    writer.print("\t");
                    writer.print(Math.abs(simValue - measValue));
                    writer.print("\t");
                    writer.print((simValue - measValue) / measValue);
                    writer.print("\t");
                    writer.println(Math.abs(simValue - measValue) / measValue);
                }
                writer.flush();
                writer.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.allSingleLinkMeas.size() > 0) {
            double ll = 0.0;
            double llPredErr = 0.0;
            for (SingleLinkMeasurement<L> meas : this.allSingleLinkMeas) {
                meas.update(this.demand, simResults);
                ll += meas.getLastLL();
                llPredErr += Math.abs(meas.getLastLLPredErr());
            }
            Logger.getLogger(this.getClass().getName()).info("single-link log-likelihood is " + ll + " +/- " + llPredErr);
            this.statisticsTracker.registerSingleLinkLL(ll);
            this.statisticsTracker.registerSingleLinkLLPredError(llPredErr);
        }
        if (this.allMultiLinkMeas.size() > 0) {
            this.matchList = this.newMatchList.copy();
            this.newMatchList = null;
            int m = 0;
            while (m < this.allMultiLinkMeas.size()) {
                this.allMultiLinkMeas.get(m).update(this.matchList.get(m), this.demand, simResults);
                ++m;
            }
            double ll = 0.0;
            int m2 = 0;
            while (m2 < this.allMultiLinkMeas.size()) {
                ll += this.allMultiLinkMeas.get(m2).ll(this.matchList.get(m2));
                ++m2;
            }
            this.statisticsTracker.registerMultiLinkLL(ll);
        }
        this.statisticsTracker.writeToFile();
        this.statisticsTracker.clear();
        this.demand.clear();
        this.planListeningSingleLinkMeas.clear();
        this.link2meas.clear();
        for (SingleLinkMeasurement<L> meas : this.allSingleLinkMeas) {
            this.allocateSingleLinkMeasurement(meas);
        }
        if (this.planListeningSingleLinkMeas.size() > 0) {
            Logger.getLogger(this.getClass().getName()).info(String.valueOf(this.planListeningSingleLinkMeas.size()) + " inactive measurement(s)");
        }
    }

    DynamicData<L> getLinkCostOffsets() {
        Logger.getLogger(this.getClass().getName()).warning("experimental function, accounts only for single-link measurements");
        DynamicData<L> result = new DynamicData<L>(this.demand.getStartTime_s(), this.demand.getBinSize_s(), this.demand.getBinCnt());
        for (SingleLinkMeasurement<L> meas : this.allSingleLinkMeas) {
            int startBin = Math.max(result.bin(meas.getStartTime_s()), 0);
            int endBin = Math.min(result.bin(meas.getEndTime_s() - 1), result.getBinCnt() - 1);
            int bin = startBin;
            while (bin <= endBin) {
                double weight = MathHelpers.overlap(result.binStart_s(bin), result.binStart_s(bin) + result.getBinSize_s(), meas.getStartTime_s(), meas.getEndTime_s()) / (double)result.getBinSize_s();
                result.add(meas.getLink(), bin, weight * meas.getLambdaCoefficient(meas.getLink()));
                ++bin;
            }
        }
        return result;
    }
}

