/***************************************************************************
    smb4kbasicnetworkitem  -  This class provides the basic network item
    for the core library of Smb4K.
                             -------------------
    begin                : Do Apr 2 2009
    copyright            : (C) 2009-2012 by Alexander Reinholdt
    email                : alexander.reinholdt@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Suite 500, Boston,*
 *   MA 02110-1335, USA                                                    *
 ***************************************************************************/

#ifndef SMB4KBASICNETWORKITEM_H
#define SMB4KBASICNETWORKITEM_H

// Qt includes
#include <QtCore/QString>
#include <QtCore/QScopedPointer>
#include <QtGui/QIcon>

// KDE includes
#include <kdemacros.h>

// forward declarations
class Smb4KBasicNetworkItemPrivate;

/**
 * This is the basic class from which all other network item classes
 * are derived.
 * 
 * @author Alexander Reinholdt <alexander.reinholdt@kdemail.net>
 * @since 1.0.0
 */

class KDE_EXPORT Smb4KBasicNetworkItem
{
  public:
    /**
     * Enumeration to determine the type of the network
     * item.
     *
     * @enum Workgroup      The network item is a workgroup or domain.
     * @enum Host           The network item is a host.
     * @enum Share          The network item is a share.
     * @enum Unknown        The network item type is unknown.
     */
    enum Type { 
      Workgroup,
      Host,
      Share,
      Unknown };

    /**
     * The constructor
     */
    explicit Smb4KBasicNetworkItem( Smb4KBasicNetworkItem::Type type = Unknown );

    /**
     * The copy constructor
     */
    Smb4KBasicNetworkItem( const Smb4KBasicNetworkItem &item );
    
    /**
     * The destructor
     */
    ~Smb4KBasicNetworkItem();

    /**
     * This function returns the type of the basic network
     * item.
     *
     * @returns the type.
     */
    Type type() const;

    /**
     * With this function you can set a key, that can be used to identify
     * a certain network item.
     *
     * @param key           The key
     */
    void setKey( const QString &key );

    /**
     * This function returns the key for this network item. By default,
     * this is a random number that was generated by the constructor.
     *
     * @returns the identifying string for this item.
     */
    QString key() const;
    
    /**
     * This function sets the icon of the network item.
     * 
     * @param icon          The icon
     */
    void setIcon( const QIcon &icon );
    
    /**
     * This function returns the icon of the network item. By default, it
     * is the null icon. You must set the appropriate icon either in
     * a class that inherits this one or from somewhere else.
     * 
     * @returns the network item's icon.
     */
    QIcon icon() const;
    
  private:
    const QScopedPointer<Smb4KBasicNetworkItemPrivate> d;
};

#endif
