# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/hub_loop_markup_files.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, text structuring,
    processing, publishing, search

=end
module SiSU_Hub_Loops
  require_relative 'constants'                         # constants.rb
  require_relative 'se'                                # se.rb
    include SiSU_Env
    include SiSU_Screen
  require_relative 'hub_actions'                       # hub_actions.rb
  require_relative 'hub_options'                       # hub_options.rb
  require_relative 'dp'                                # dp.rb
    include SiSU_Param
  require_relative 'utils'                             # utils.rb
  begin
    require 'uri'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('uri NOT FOUND (LoadError)')
  end
  class OptionLoopFiles
    attr_reader :opt
    def initialize(opt)
      @opt=opt
      @r=Px[:lng_lst_rgx]
    end
    def loop_files_on_given_option
      @opt.files.each_with_index do |fno,i|
        @opt.fno,@opt.fns=fno,fno
        @opt.f_pth=@opt.f_pths[i]
        if fno !~/\.-sst$/
          @opt.pth=@opt.paths[i]
          @opt.lng=@opt.lngs[i]
        end
        @@pwd=@opt.pth
        @opt.pth=@opt.f_pths[i][:pth]
        @opt.lng=@opt.f_pths[i][:lng]
        Dir.chdir(@opt.f_pth[:pth]) #watch
        SiSU_Env::FilenameLanguageCodeInsert.new(@opt,@opt.lng).language_code_insert # ... track
        @env=SiSU_Env::InfoEnv.new(fno)
        yield
      end
    end
    def loop_files_on_given_option_bundle
      @files_bundle={}
      @opt.files.each_with_index do |fno,i|
        fn_base_bundle=fno.gsub(/(?:~(?:#{@r}))?\.ss[tm]$/,'')
        unless @files_bundle[fn_base_bundle]
          @files_bundle[fn_base_bundle]={ status: :todo }
        end
      end
      @opt.files.each_with_index do |fno,i|
        fn_base_bundle=fno.gsub(/(?:~(?:#{@r}))?\.ss[tm]$/,'')
        unless @files_bundle[fn_base_bundle][:status] == :done
          @files_bundle[fn_base_bundle][:status] = :done
          @opt.fns=fno
          @opt.fno=fno
          @opt.f_pth=@opt.f_pths[i]
          if fno !~/\.-sst$/
            @opt.pth=@opt.paths[i]
            @opt.lng=@opt.lngs[i]
          end
          @@pwd=@opt.pth
          @opt.pth=@opt.f_pths[i][:pth]
          @opt.lng=@opt.f_pths[i][:lng]
          Dir.chdir(@opt.f_pth[:pth]) #watch
          @env=SiSU_Env::InfoEnv.new(fno)
          yield
        else next
        end
      end
    end
    def manifest_on_files_translated
      number_of_files={}
      @opt.files.each_with_index do |fns,i|
        fn=fns.gsub(/(?:~(?:#{@r}))?\.ss[tm]$/,'')
        (number_of_files[fn].is_a?(Array)) \
        ? (number_of_files[fn] << i)
        : (number_of_files.store(fn,[i]))
      end
      files_translated_idx=[]
      number_of_files.each do |x|
        if x[1].length > 1
          files_translated_idx << x[1]
        end
      end
      if files_translated_idx.flatten.length > 1
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          'Manifest re-run on (currently generated) translated files',
          ''
        ).grey_title_hi unless @opt.act[:quiet][:set] ==:on
        files_translated_idx.flatten.each do |i|
          @opt.fns=@opt.files[i]
          @opt.f_pth=@opt.f_pths[i]
          if @opt.fns =~/\.-sst$/
            @opt.pth=Dir.pwd
            @opt.lng='en'
          elsif @opt.fno =~/\.txz$/
            @opt.pth=@opt.f_pths[i][:pth]
            @opt.lng=@opt.f_pths[i][:lng]
          else
            @opt.pth=@opt.f_pths[i][:pth]
            @opt.lng=@opt.f_pths[i][:lng]
          end
          @@pwd=@opt.pth
          Dir.chdir(@opt.pth) #watch
          @env=SiSU_Env::InfoEnv.new(@opt.fns)
          yield
        end
      end
    end
  end
end
__END__
