

%typemap(javaimports) itk::Functor::BitwiseNot "/**

Performs the C++ unary bitwise NOT operator.

C++ includes: itkBitwiseNotFunctor.h
*/"


%typemap(javaimports) itk::Functor::DivFloor "/**

Cast arguments to double, performs division then takes the floor.

C++ includes: itkDivideFloorFunctor.h
*/"


%typemap(javaimports) itk::Functor::DivReal "/**

Promotes arguments to real type and performs division.

C++ includes: itkDivideRealFunctor.h
*/"


%typemap(javaimports) itk::Functor::UnaryMinus "/**
C++ includes: itkUnaryMinusImageFilter.h
*/"

%javamethodmodifiers  itk::Functor::UnaryMinus::UnaryMinus "/**
itk::Functor::UnaryMinus< TInput1, TOutput >::UnaryMinus()
*/
public ";

%javamethodmodifiers  itk::Functor::UnaryMinus::~UnaryMinus "/**
itk::Functor::UnaryMinus< TInput1, TOutput >::~UnaryMinus()
*/
public ";


%typemap(javaimports) itk::HashImageFilter "/**

Generates a hash string from an image.



This class utlizes low level buffer pointer access, to work with itk::Image and itk::VectorImage. It is modeled after the access an ImageFileWriter provides to an ImageIO.
Todo
Update in-place on to default after fixing bug in InPlaceImageFilter


C++ includes: itkHashImageFilter.h
*/"

%javamethodmodifiers  itk::HashImageFilter::GetHash "/**
std::string itk::HashImageFilter< TImageType >::GetHash() const

Get the computed Hash values

*/
public ";

%javamethodmodifiers  itk::HashImageFilter::GetHashOutput "/**
HashObjectType* itk::HashImageFilter< TImageType >::GetHashOutput()
*/
public ";

%javamethodmodifiers  itk::HashImageFilter::GetHashOutput "/**
const HashObjectType* itk::HashImageFilter< TImageType >::GetHashOutput() const
*/
public ";

%javamethodmodifiers  itk::HashImageFilter::itkGetMacro "/**
itk::HashImageFilter< TImageType >::itkGetMacro(HashFunction, HashFunction)
*/
public ";

%javamethodmodifiers  itk::HashImageFilter::itkNewMacro "/**
itk::HashImageFilter< TImageType >::itkNewMacro(Self)

Method for creation through the object factory.

*/
public ";

%javamethodmodifiers  itk::HashImageFilter::itkSetMacro "/**
itk::HashImageFilter< TImageType >::itkSetMacro(HashFunction, HashFunction)

Set/Get hashing function as enumerated type

*/
public ";

%javamethodmodifiers  itk::HashImageFilter::itkTypeMacro "/**
itk::HashImageFilter< TImageType >::itkTypeMacro(HashImageFilter, CastImageFilter)

Runtime information support.

*/
public ";

%javamethodmodifiers  itk::HashImageFilter::MakeOutput "/**
virtual DataObjectPointer itk::HashImageFilter< TImageType >::MakeOutput(DataObjectPointerArraySizeType idx) ITK_OVERRIDE
*/
public ";


%typemap(javaimports) itk::ImageIOFactoryRegisterManager "/**
C++ includes: itkImageIOFactoryRegisterManager.h
*/"

%javamethodmodifiers  itk::ImageIOFactoryRegisterManager::ImageIOFactoryRegisterManager "/**
itk::ImageIOFactoryRegisterManager::ImageIOFactoryRegisterManager(void(*list[])(void))
*/
public ";

%javamethodmodifiers  itk::ImageIOFactoryRegisterManager::ImageIOFactoryRegisterManager "/**
itk::ImageIOFactoryRegisterManager::ImageIOFactoryRegisterManager(void(*list[])(void))
*/
public ";


%typemap(javaimports) itk::SliceImageFilter "/**

Slices an image based on a starting index and a stopping index, and a
step size.


This class is designed to facilitate the implementation of extended
sliced based indexing into images.

The input and output image must be of the same dimension.

The input parameters are a starting and stopping index as well as a
stepping size. The staring index indicates the first pixels to used
and for each dimension the index is incremented by the step until the
index is equal to or \"beyond\" the stopping index. If the step is
negative then the image will be revered in the dimension, and the
stopping index is expected to be less then the starting index. If the
stopping index is already beyond the starting then a image of zero
size will be returned.

The output image's starting index is always zero. The origin is the
physical location of the starting index. The output directions cosine
matrix is that of the input but with sign changes matching that of the
step's sign.


In certain combination such as with start=1, and step>1 while the
physical location of the center of the pixel remains the same, the
extent (edge to edge space) of the pixel will beyond the extent of the
original image.


C++ includes: itkSliceImageFilter.h
*/"

%javamethodmodifiers  itk::SliceImageFilter::GenerateInputRequestedRegion "/**
virtual void itk::SliceImageFilter< TInputImage, TOutputImage >::GenerateInputRequestedRegion() ITK_OVERRIDE
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::GenerateOutputInformation "/**
virtual void itk::SliceImageFilter< TInputImage, TOutputImage >::GenerateOutputInformation() ITK_OVERRIDE

SliceImageFilter produces an image which is a different resolution and with a
different pixel spacing than its input image.
See:
 ProcessObject::GenerateOutputInformaton()


*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkGetConstReferenceMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkGetConstReferenceMacro(Start, IndexType)
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkGetConstReferenceMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkGetConstReferenceMacro(Stop, IndexType)
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkGetConstReferenceMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkGetConstReferenceMacro(Step, ArrayType)
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkNewMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkNewMacro(Self)

Method for creation through the object factory.

*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkSetMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkSetMacro(Start, IndexType)

Set/Get the first index extracted from the input image

*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkSetMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkSetMacro(Stop, IndexType)

Set/Get the excluded end of the range

*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkSetMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkSetMacro(Step, ArrayType)

Set/Get the stride of indexes extracted

An exception will be generated if 0.

*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkStaticConstMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkStaticConstMacro(ImageDimension, unsigned int, TInputImage::ImageDimension)

ImageDimension enumeration.

*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkStaticConstMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkStaticConstMacro(OutputImageDimension, unsigned int, TOutputImage::ImageDimension)
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::itkTypeMacro "/**
itk::SliceImageFilter< TInputImage, TOutputImage >::itkTypeMacro(SliceImageFilter, ImageToImageFilter)

Run-time type information (and related methods).

*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::SetStart "/**
void itk::SliceImageFilter< TInputImage, TOutputImage >::SetStart(IndexValueType start)
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::SetStep "/**
void itk::SliceImageFilter< TInputImage, TOutputImage >::SetStep(int step)
*/
public ";

%javamethodmodifiers  itk::SliceImageFilter::SetStop "/**
void itk::SliceImageFilter< TInputImage, TOutputImage >::SetStop(IndexValueType stop)
*/
public ";


%typemap(javaimports) itk::TransformIOFactoryRegisterManager "/**
C++ includes: itkTransformIOFactoryRegisterManager.h
*/"

%javamethodmodifiers  itk::TransformIOFactoryRegisterManager::TransformIOFactoryRegisterManager "/**
itk::TransformIOFactoryRegisterManager::TransformIOFactoryRegisterManager(void(*list[])(void))
*/
public ";

%javamethodmodifiers  itk::TransformIOFactoryRegisterManager::TransformIOFactoryRegisterManager "/**
itk::TransformIOFactoryRegisterManager::TransformIOFactoryRegisterManager(void(*list[])(void))
*/
public ";


%typemap(javaimports) itk::simple::AbsImageFilter "/**

Computes the absolute value of each pixel.


itk::Math::abs() is used to perform the computation.

Wiki Examples:

All Examples

Compute the absolute value of an image
See:
 itk::simple::Abs for the procedural interface

 itk::AbsImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAbsImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AbsImageFilter::AbsImageFilter "/**
itk::simple::AbsImageFilter::AbsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AbsImageFilter::Execute "/**
Image itk::simple::AbsImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AbsImageFilter::GetName "/**
std::string itk::simple::AbsImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AbsImageFilter::ToString "/**
std::string itk::simple::AbsImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AbsImageFilter::~AbsImageFilter "/**
itk::simple::AbsImageFilter::~AbsImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AbsoluteValueDifferenceImageFilter "/**

Implements pixel-wise the computation of absolute value difference.


This filter is parametrized over the types of the two input images and
the type of the output image.

Numeric conversions (castings) are done by the C++ defaults.

The filter will walk over all the pixels in the two input images, and
for each one of them it will do the following:


Cast the input 1 pixel value to double .

Cast the input 2 pixel value to double .

Compute the difference of the two pixel values.

Compute the absolute value of the difference.

Cast the double value resulting from the absolute value to the pixel
type of the output image.

Store the casted value into the output image.
 The filter expects all images to have the same dimension (e.g. all
2D, or all 3D, or all ND).

Wiki Examples:

All Examples

Compute the absolute value of the difference of corresponding pixels
in two images
See:
 itk::simple::AbsoluteValueDifference for the procedural interface

 itk::AbsoluteValueDifferenceImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAbsoluteValueDifferenceImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::AbsoluteValueDifferenceImageFilter "/**
itk::simple::AbsoluteValueDifferenceImageFilter::AbsoluteValueDifferenceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::Execute "/**
Image itk::simple::AbsoluteValueDifferenceImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::Execute "/**
Image itk::simple::AbsoluteValueDifferenceImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::Execute "/**
Image itk::simple::AbsoluteValueDifferenceImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::GetName "/**
std::string itk::simple::AbsoluteValueDifferenceImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::ToString "/**
std::string itk::simple::AbsoluteValueDifferenceImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AbsoluteValueDifferenceImageFilter::~AbsoluteValueDifferenceImageFilter "/**
itk::simple::AbsoluteValueDifferenceImageFilter::~AbsoluteValueDifferenceImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AcosImageFilter "/**

Computes the inverse cosine of each pixel.


This filter is templated over the pixel type of the input image and
the pixel type of the output image.

The filter walks over all the pixels in the input image, and for each
pixel does do the following:


cast the pixel value to double ,

apply the std::acos() function to the double value

cast the double value resulting from std::acos() to the pixel type of
the output image

store the casted value into the output image.
 The filter expects both images to have the same dimension (e.g. both
2D, or both 3D, or both ND).
See:
 itk::simple::Acos for the procedural interface

 itk::AcosImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAcosImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AcosImageFilter::AcosImageFilter "/**
itk::simple::AcosImageFilter::AcosImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AcosImageFilter::Execute "/**
Image itk::simple::AcosImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AcosImageFilter::GetName "/**
std::string itk::simple::AcosImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AcosImageFilter::ToString "/**
std::string itk::simple::AcosImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AcosImageFilter::~AcosImageFilter "/**
itk::simple::AcosImageFilter::~AcosImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AdaptiveHistogramEqualizationImageFilter "/**

Power Law Adaptive Histogram Equalization.


Histogram equalization modifies the contrast in an image. The AdaptiveHistogramEqualizationImageFilter is a superset of many contrast enhancing filters. By modifying its
parameters (alpha, beta, and window), the AdaptiveHistogramEqualizationImageFilter can produce an adaptively equalized histogram or a version of unsharp
mask (local mean subtraction). Instead of applying a strict histogram
equalization in a window about a pixel, this filter prescribes a
mapping function (power law) controlled by the parameters alpha and
beta.

The parameter alpha controls how much the filter acts like the
classical histogram equalization method (alpha=0) to how much the
filter acts like an unsharp mask (alpha=1).

The parameter beta controls how much the filter acts like an unsharp
mask (beta=0) to much the filter acts like pass through (beta=1, with
alpha=1).

The parameter window controls the size of the region over which local
statistics are calculated.

By altering alpha, beta and window, a host of equalization and unsharp
masking filters is available.

The boundary condition ignores the part of the neighborhood outside
the image, and over-weights the valid part of the neighborhood.

For detail description, reference \"Adaptive Image Contrast
Enhancement using Generalizations of Histogram Equalization.\" J.Alex
Stark. IEEE Transactions on Image Processing, May 2000.

Wiki Examples:

All Examples

Adaptive histogram equalization
See:
 itk::simple::AdaptiveHistogramEqualization for the procedural interface

 itk::AdaptiveHistogramEqualizationImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAdaptiveHistogramEqualizationImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::AdaptiveHistogramEqualizationImageFilter "/**
itk::simple::AdaptiveHistogramEqualizationImageFilter::AdaptiveHistogramEqualizationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::Execute "/**
Image itk::simple::AdaptiveHistogramEqualizationImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::Execute "/**
Image itk::simple::AdaptiveHistogramEqualizationImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius, float
alpha, float beta, bool useLookupTable)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::GetAlpha "/**
float itk::simple::AdaptiveHistogramEqualizationImageFilter::GetAlpha() const

Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram
equalization (provided beta=0). Alpha = 1 produces an unsharp mask.
Default is 0.3.

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::GetBeta "/**
float itk::simple::AdaptiveHistogramEqualizationImageFilter::GetBeta() const

Set/Get the value of beta. If beta = 1 (and alpha = 1), then the
output image matches the input image. As beta approaches 0, the filter
behaves as an unsharp mask. Default is 0.3.

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::GetName "/**
std::string itk::simple::AdaptiveHistogramEqualizationImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::AdaptiveHistogramEqualizationImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::GetUseLookupTable "/**
bool itk::simple::AdaptiveHistogramEqualizationImageFilter::GetUseLookupTable() const

Set/Get whether an optimized lookup table for the intensity mapping
function is used. Default is off. Deprecated

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::SetAlpha "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::SetAlpha(float Alpha)

Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram
equalization (provided beta=0). Alpha = 1 produces an unsharp mask.
Default is 0.3.

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::SetBeta "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::SetBeta(float Beta)

Set/Get the value of beta. If beta = 1 (and alpha = 1), then the
output image matches the input image. As beta approaches 0, the filter
behaves as an unsharp mask. Default is 0.3.

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::SetRadius "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::SetRadius "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::SetUseLookupTable "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::SetUseLookupTable(bool UseLookupTable)

Set/Get whether an optimized lookup table for the intensity mapping
function is used. Default is off. Deprecated

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::ToString "/**
std::string itk::simple::AdaptiveHistogramEqualizationImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::UseLookupTableOff "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::UseLookupTableOff()
*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::UseLookupTableOn "/**
Self& itk::simple::AdaptiveHistogramEqualizationImageFilter::UseLookupTableOn()

Set the value of UseLookupTable to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::AdaptiveHistogramEqualizationImageFilter::~AdaptiveHistogramEqualizationImageFilter "/**
itk::simple::AdaptiveHistogramEqualizationImageFilter::~AdaptiveHistogramEqualizationImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AddImageFilter "/**

Pixel-wise addition of two images.


This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

The pixel type of the input 1 image must have a valid definition of
the operator+ with a pixel type of the image 2. This condition is
required because internally this filter will perform the operation


Additionally the type resulting from the sum, will be cast to the
pixel type of the output image.

The total operation over one pixel will be

For example, this filter could be used directly for adding images
whose pixels are vectors of the same dimension, and to store the
resulting vector in an output image of vector pixels.

The images to be added are set using the methods:

Additionally, this filter can be used to add a constant to every pixel
of an image by using


WARNING:
No numeric overflow checking is performed in this filter.
Wiki Examples:

All Examples

Add two images together

Add a constant to every pixel in an image
See:
 itk::simple::Add for the procedural interface

 itk::AddImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAddImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AddImageFilter::AddImageFilter "/**
itk::simple::AddImageFilter::AddImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AddImageFilter::Execute "/**
Image itk::simple::AddImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::AddImageFilter::Execute "/**
Image itk::simple::AddImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::AddImageFilter::Execute "/**
Image itk::simple::AddImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::AddImageFilter::GetName "/**
std::string itk::simple::AddImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AddImageFilter::ToString "/**
std::string itk::simple::AddImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AddImageFilter::~AddImageFilter "/**
itk::simple::AddImageFilter::~AddImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AdditiveGaussianNoiseImageFilter "/**

Alter an image with additive Gaussian white noise.


Additive Gaussian white noise can be modeled as:


$ I = I_0 + N $

where $ I $ is the observed image, $ I_0 $ is the noise-free image and $ N $ is a normally distributed random variable of mean $ \\\\mu $ and variance $ \\\\sigma^2 $ :

$ N \\\\sim \\\\mathcal{N}(\\\\mu, \\\\sigma^2) $
 The noise is independent of the pixel intensities.


Gaetan Lehmann
 This code was contributed in the Insight Journal paper \"Noise
Simulation\". https://hdl.handle.net/10380/3158
See:
 itk::simple::AdditiveGaussianNoise for the procedural interface

 itk::AdditiveGaussianNoiseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAdditiveGaussianNoiseImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::AdditiveGaussianNoiseImageFilter "/**
itk::simple::AdditiveGaussianNoiseImageFilter::AdditiveGaussianNoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::Execute "/**
Image itk::simple::AdditiveGaussianNoiseImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::Execute "/**
Image itk::simple::AdditiveGaussianNoiseImageFilter::Execute(const Image &image1, double standardDeviation, double mean, uint32_t
seed)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::GetMean "/**
double itk::simple::AdditiveGaussianNoiseImageFilter::GetMean() const

Set/Get the mean of the Gaussian distribution. Defaults to 0.0.

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::GetName "/**
std::string itk::simple::AdditiveGaussianNoiseImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::GetSeed "/**
uint32_t itk::simple::AdditiveGaussianNoiseImageFilter::GetSeed() const
*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::GetStandardDeviation "/**
double itk::simple::AdditiveGaussianNoiseImageFilter::GetStandardDeviation() const

Set/Get the standard deviation of the Gaussian distribution. Defaults
to 1.0.

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::SetMean "/**
Self& itk::simple::AdditiveGaussianNoiseImageFilter::SetMean(double Mean)

Set/Get the mean of the Gaussian distribution. Defaults to 0.0.

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::SetSeed "/**
Self& itk::simple::AdditiveGaussianNoiseImageFilter::SetSeed(uint32_t Seed)
*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::SetStandardDeviation "/**
Self& itk::simple::AdditiveGaussianNoiseImageFilter::SetStandardDeviation(double StandardDeviation)

Set/Get the standard deviation of the Gaussian distribution. Defaults
to 1.0.

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::ToString "/**
std::string itk::simple::AdditiveGaussianNoiseImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AdditiveGaussianNoiseImageFilter::~AdditiveGaussianNoiseImageFilter "/**
itk::simple::AdditiveGaussianNoiseImageFilter::~AdditiveGaussianNoiseImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AffineTransform "/**

An affine transformation about a fixed center with translation for a
2D or 3D coordinate.



See:
 itk::AffineTransform


C++ includes: sitkAffineTransform.h
*/"

%javamethodmodifiers  itk::simple::AffineTransform::AffineTransform "/**
itk::simple::AffineTransform::AffineTransform(unsigned int dimensions)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::AffineTransform "/**
itk::simple::AffineTransform::AffineTransform(const AffineTransform &)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::AffineTransform "/**
itk::simple::AffineTransform::AffineTransform(const Transform &)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::AffineTransform "/**
itk::simple::AffineTransform::AffineTransform(const std::vector< double > &matrix, const std::vector< double >
&translation, const std::vector< double > &fixedCenter=std::vector<
double >(3, 0.0))
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::GetCenter "/**
std::vector<double> itk::simple::AffineTransform::GetCenter() const
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::GetMatrix "/**
std::vector<double> itk::simple::AffineTransform::GetMatrix() const
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::GetName "/**
std::string itk::simple::AffineTransform::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::GetTranslation "/**
std::vector<double> itk::simple::AffineTransform::GetTranslation() const

parameters

*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::Rotate "/**
Self& itk::simple::AffineTransform::Rotate(int axis1, int axis2, double angle, bool pre=false)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::Scale "/**
Self& itk::simple::AffineTransform::Scale(const std::vector< double > &factor, bool pre=false)

additional methods

*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::Scale "/**
Self& itk::simple::AffineTransform::Scale(double factor, bool pre=false)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::SetCenter "/**
Self& itk::simple::AffineTransform::SetCenter(const std::vector< double > &params)

fixed parameter

*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::SetMatrix "/**
Self& itk::simple::AffineTransform::SetMatrix(const std::vector< double > &matrix)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::SetTranslation "/**
Self& itk::simple::AffineTransform::SetTranslation(const std::vector< double > &translation)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::Shear "/**
Self& itk::simple::AffineTransform::Shear(int axis1, int axis2, double coef, bool pre=false)
*/
public ";

%javamethodmodifiers  itk::simple::AffineTransform::Translate "/**
Self& itk::simple::AffineTransform::Translate(const std::vector< double > &offset, bool pre=false)
*/
public ";


%typemap(javaimports) itk::simple::AggregateLabelMapFilter "/**

Collapses all labels into the first label.


This filter takes a label map as input and visits the pixels of all
labels and assigns them to the first label of the label map. At the
end of the execution of this filter, the map will contain a single
filter.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter

 itk::simple::AggregateLabelMapFilter for the procedural interface

 itk::AggregateLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkAggregateLabelMapFilter.h
*/"

%javamethodmodifiers  itk::simple::AggregateLabelMapFilter::AggregateLabelMapFilter "/**
itk::simple::AggregateLabelMapFilter::AggregateLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AggregateLabelMapFilter::Execute "/**
Image itk::simple::AggregateLabelMapFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AggregateLabelMapFilter::GetName "/**
std::string itk::simple::AggregateLabelMapFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AggregateLabelMapFilter::ToString "/**
std::string itk::simple::AggregateLabelMapFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AggregateLabelMapFilter::~AggregateLabelMapFilter "/**
itk::simple::AggregateLabelMapFilter::~AggregateLabelMapFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AndImageFilter "/**

Implements the AND bitwise operator pixel-wise between two images.


This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Since the bitwise AND operation is only defined in C++ for integer
types, the images passed to this filter must comply with the
requirement of using integer pixel type.

The total operation over one pixel will be Where \"&\" is the bitwise AND operator in C++.

Wiki Examples:

All Examples

Binary AND two images
See:
 itk::simple::And for the procedural interface

 itk::AndImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAndImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AndImageFilter::AndImageFilter "/**
itk::simple::AndImageFilter::AndImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AndImageFilter::Execute "/**
Image itk::simple::AndImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::AndImageFilter::Execute "/**
Image itk::simple::AndImageFilter::Execute(const Image &image1, int constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::AndImageFilter::Execute "/**
Image itk::simple::AndImageFilter::Execute(int constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::AndImageFilter::GetName "/**
std::string itk::simple::AndImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AndImageFilter::ToString "/**
std::string itk::simple::AndImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AndImageFilter::~AndImageFilter "/**
itk::simple::AndImageFilter::~AndImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AntiAliasBinaryImageFilter "/**

A method for estimation of a surface from a binary volume.



This filter implements a surface-fitting method for estimation of a
surface from a binary volume. This process can be used to reduce
aliasing artifacts which result in visualization of binary partitioned
surfaces.

The binary volume (filter input) is used as a set of constraints in an
iterative relaxation process of an estimated ND surface. The surface
is described implicitly as the zero level set of a volume $ \\\\phi $ and allowed to deform under curvature flow. A set of constraints is
imposed on this movement as follows:

\\\\[ u_{i,j,k}^{n+1} = \\\\left\\\\{ \\\\begin{array}{ll}
\\\\mbox{max} (u_{i,j,k}^{n} + \\\\Delta t H_{i,j,k}^{n}, 0) &
\\\\mbox{\\\\f$B_{i,j,k} = 1\\\\f$} \\\\\\\\ \\\\mbox{min}
(u_{i,j,k}^{n} + \\\\Delta t H_{i,j,k}^{n}, 0) &
\\\\mbox{\\\\f$B_{i,j,k} = -1\\\\f$} \\\\end{array}\\\\right. \\\\]

where $ u_{i,j,k}^{n} $ is the value of $ \\\\phi $ at discrete index $ (i,j,k) $ and iteration $ n $ , $ H $ is the gradient magnitude times mean curvature of $ \\\\phi $ , and $ B $ is the binary input volume, with 1 denoting an inside pixel and -1
denoting an outside pixel.
NOTES
This implementation uses a sparse field level set solver instead of
the narrow band implementation described in the reference below, which
may introduce some differences in how fast and how accurately (in
terms of RMS error) the solution converges.
REFERENCES
Whitaker, Ross. \"Reducing Aliasing Artifacts In Iso-Surfaces of
Binary Volumes\" IEEE Volume Visualization and Graphics Symposium,
October 2000, pp.23-32.
PARAMETERS
The MaximumRMSChange parameter is used to determine when the solution
has converged. A lower value will result in a tighter-fitting
solution, but will require more computations. Too low a value could
put the solver into an infinite loop. Values should always be less
than 1.0. A value of 0.07 is a good starting estimate.

The MaximumIterations parameter can be used to halt the solution after
a specified number of iterations.
INPUT
The input is an N-dimensional image of any type. It is assumed to be a
binary image. The filter will use an isosurface value that is halfway
between the min and max values in the image. A signed data type is not
necessary for the input.
OUTPUT
The filter will output a level set image of real, signed values. The
zero crossings of this (N-dimensional) image represent the position of
the isosurface value of interest. Values outside the zero level set
are negative and values inside the zero level set are positive values.
IMPORTANT!
The output image type you use to instantiate this filter should be a
real valued scalar type. In other words: doubles or floats.
USING THIS FILTER
The filter is relatively straightforward to use. Tests and examples
exist to illustrate. The important thing is to understand the input
and output types so you can properly interperet your results.

In the common case, the only parameter that will need to be set is the
MaximumRMSChange parameter, which determines when the solver halts.
Wiki Examples:

All Examples

Anti alias a binary image
See:
 itk::simple::AntiAliasBinary for the procedural interface

 itk::AntiAliasBinaryImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAntiAliasBinaryImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::AntiAliasBinaryImageFilter "/**
itk::simple::AntiAliasBinaryImageFilter::AntiAliasBinaryImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::Execute "/**
Image itk::simple::AntiAliasBinaryImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::Execute "/**
Image itk::simple::AntiAliasBinaryImageFilter::Execute(const Image &image1, double maximumRMSError, uint32_t
numberOfIterations)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::GetElapsedIterations "/**
uint32_t itk::simple::AntiAliasBinaryImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::GetMaximumRMSError "/**
double itk::simple::AntiAliasBinaryImageFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::GetName "/**
std::string itk::simple::AntiAliasBinaryImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::AntiAliasBinaryImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::GetRMSChange "/**
double itk::simple::AntiAliasBinaryImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::SetMaximumRMSError "/**
Self& itk::simple::AntiAliasBinaryImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::SetNumberOfIterations "/**
Self& itk::simple::AntiAliasBinaryImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::ToString "/**
std::string itk::simple::AntiAliasBinaryImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AntiAliasBinaryImageFilter::~AntiAliasBinaryImageFilter "/**
itk::simple::AntiAliasBinaryImageFilter::~AntiAliasBinaryImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ApproximateSignedDistanceMapImageFilter "/**

Create a map of the approximate signed distance from the boundaries of
a binary image.


The ApproximateSignedDistanceMapImageFilter takes as input a binary image and produces a signed distance map.
Each pixel value in the output contains the approximate distance from
that pixel to the nearest \"object\" in the binary image. This filter
differs from the DanielssonDistanceMapImageFilter in that it calculates the distance to the \"object edge\" for pixels
within the object.

Negative values in the output indicate that the pixel at that position
is within an object in the input image. The absolute value of a
negative pixel represents the approximate distance to the nearest
object boundary pixel.

WARNING: This filter requires that the output type be floating-point.
Otherwise internal calculations will not be performed to the
appropriate precision, resulting in completely incorrect (read: zero-
valued) output.

The distances computed by this filter are Chamfer distances, which are
only an approximation to Euclidian distances, and are not as exact
approximations as those calculated by the DanielssonDistanceMapImageFilter . On the other hand, this filter is faster.

This filter requires that an \"inside value\" and \"outside value\" be
set as parameters. The \"inside value\" is the intensity value of the
binary image which corresponds to objects, and the \"outside value\"
is the intensity of the background. (A typical binary image often
represents objects as black (0) and background as white (usually 255),
or vice-versa.) Note that this filter is slightly faster if the inside
value is less than the outside value. Otherwise an extra iteration
through the image is required.

This filter uses the FastChamferDistanceImageFilter and the IsoContourDistanceImageFilter internally to perform the distance calculations.


See:
 DanielssonDistanceMapImageFilter

 SignedDanielssonDistanceMapImageFilter

 SignedMaurerDistanceMapImageFilter

 FastChamferDistanceImageFilter

 IsoContourDistanceImageFilter

Zach Pincus
Wiki Examples:

All Examples

Compute a distance map from objects in a binary image
See:
 itk::simple::ApproximateSignedDistanceMap for the procedural interface

 itk::ApproximateSignedDistanceMapImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkApproximateSignedDistanceMapImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::ApproximateSignedDistanceMapImageFilter "/**
itk::simple::ApproximateSignedDistanceMapImageFilter::ApproximateSignedDistanceMapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::Execute "/**
Image itk::simple::ApproximateSignedDistanceMapImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::Execute "/**
Image itk::simple::ApproximateSignedDistanceMapImageFilter::Execute(const Image &image1, double insideValue, double outsideValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::GetInsideValue "/**
double itk::simple::ApproximateSignedDistanceMapImageFilter::GetInsideValue() const

Set/Get intensity value representing the interior of objects in the
mask.

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::GetName "/**
std::string itk::simple::ApproximateSignedDistanceMapImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::GetOutsideValue "/**
double itk::simple::ApproximateSignedDistanceMapImageFilter::GetOutsideValue() const

Set/Get intensity value representing non-objects in the mask.

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::SetInsideValue "/**
Self& itk::simple::ApproximateSignedDistanceMapImageFilter::SetInsideValue(double InsideValue)

Set/Get intensity value representing the interior of objects in the
mask.

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::SetOutsideValue "/**
Self& itk::simple::ApproximateSignedDistanceMapImageFilter::SetOutsideValue(double OutsideValue)

Set/Get intensity value representing non-objects in the mask.

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::ToString "/**
std::string itk::simple::ApproximateSignedDistanceMapImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ApproximateSignedDistanceMapImageFilter::~ApproximateSignedDistanceMapImageFilter "/**
itk::simple::ApproximateSignedDistanceMapImageFilter::~ApproximateSignedDistanceMapImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AsinImageFilter "/**

Computes the sine of each pixel.


This filter is templated over the pixel type of the input image and
the pixel type of the output image.

The filter walks over all the pixels in the input image, and for each
pixel does the following:


cast the pixel value to double ,

apply the std::asin() function to the double value,

cast the double value resulting from std::asin() to the pixel type of
the output image,

store the casted value into the output image.
 The filter expects both images to have the same dimension (e.g. both
2D, or both 3D, or both ND)
See:
 itk::simple::Asin for the procedural interface

 itk::AsinImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAsinImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AsinImageFilter::AsinImageFilter "/**
itk::simple::AsinImageFilter::AsinImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AsinImageFilter::Execute "/**
Image itk::simple::AsinImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AsinImageFilter::GetName "/**
std::string itk::simple::AsinImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AsinImageFilter::ToString "/**
std::string itk::simple::AsinImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AsinImageFilter::~AsinImageFilter "/**
itk::simple::AsinImageFilter::~AsinImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::Atan2ImageFilter "/**

Computes two argument inverse tangent.


The first argument to the atan function is provided by a pixel in the
first input image (SetInput1() ) and the corresponding pixel in the
second input image (SetInput2() ) is used as the second argument.

This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Both pixel input types are cast to double in order to be used as
parameters of std::atan2() . The resulting double value is cast to the
output pixel type.

Wiki Examples:

All Examples

Compute the arctangent of each pixel.
See:
 itk::simple::Atan2 for the procedural interface

 itk::Atan2ImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAtan2ImageFilter.h
*/"

%javamethodmodifiers  itk::simple::Atan2ImageFilter::Atan2ImageFilter "/**
itk::simple::Atan2ImageFilter::Atan2ImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::Atan2ImageFilter::Execute "/**
Image itk::simple::Atan2ImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::Atan2ImageFilter::Execute "/**
Image itk::simple::Atan2ImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::Atan2ImageFilter::Execute "/**
Image itk::simple::Atan2ImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::Atan2ImageFilter::GetName "/**
std::string itk::simple::Atan2ImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::Atan2ImageFilter::ToString "/**
std::string itk::simple::Atan2ImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::Atan2ImageFilter::~Atan2ImageFilter "/**
itk::simple::Atan2ImageFilter::~Atan2ImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::AtanImageFilter "/**

Computes the one-argument inverse tangent of each pixel.


This filter is templated over the pixel type of the input image and
the pixel type of the output image.

The filter walks over all the pixels in the input image, and for each
pixel does the following:


cast the pixel value to double ,

apply the std::atan() function to the double value,

cast the double value resulting from std::atan() to the pixel type of
the output image,

store the cast value into the output image.
See:
 itk::simple::Atan for the procedural interface

 itk::AtanImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkAtanImageFilter.h
*/"

%javamethodmodifiers  itk::simple::AtanImageFilter::AtanImageFilter "/**
itk::simple::AtanImageFilter::AtanImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::AtanImageFilter::Execute "/**
Image itk::simple::AtanImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::AtanImageFilter::GetName "/**
std::string itk::simple::AtanImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::AtanImageFilter::ToString "/**
std::string itk::simple::AtanImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::AtanImageFilter::~AtanImageFilter "/**
itk::simple::AtanImageFilter::~AtanImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BSplineTransform "/**

A deformable transform over a bounded spatial domain using a BSpline
representation for a 2D or 3D coordinate space.



See:
 itk::BSplineTransform


C++ includes: sitkBSplineTransform.h
*/"

%javamethodmodifiers  itk::simple::BSplineTransform::BSplineTransform "/**
itk::simple::BSplineTransform::BSplineTransform(unsigned int dimensions, unsigned int order=3)
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::BSplineTransform "/**
itk::simple::BSplineTransform::BSplineTransform(const BSplineTransform &)
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::BSplineTransform "/**
itk::simple::BSplineTransform::BSplineTransform(const Transform &)
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetCoefficientImages "/**
std::vector<Image> itk::simple::BSplineTransform::GetCoefficientImages() const

Get a vector of the coefficient images representing the BSpline.


A lazy shallow copy of the images from ITK are performed. If they are
modified in SimpleITK a deep copy will occur. However, if the
coefficients are modified in ITK, then no copy will occur and the
images help by SimpleITK may change.

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetName "/**
std::string itk::simple::BSplineTransform::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetOrder "/**
unsigned int itk::simple::BSplineTransform::GetOrder() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetTransformDomainDirection "/**
std::vector<double> itk::simple::BSplineTransform::GetTransformDomainDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetTransformDomainMeshSize "/**
std::vector<unsigned int> itk::simple::BSplineTransform::GetTransformDomainMeshSize() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetTransformDomainOrigin "/**
std::vector<double> itk::simple::BSplineTransform::GetTransformDomainOrigin() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::GetTransformDomainPhysicalDimensions "/**
std::vector<double> itk::simple::BSplineTransform::GetTransformDomainPhysicalDimensions() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::SetTransformDomainDirection "/**
Self& itk::simple::BSplineTransform::SetTransformDomainDirection(const std::vector< double > &)

parameters fixed parameter

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::SetTransformDomainMeshSize "/**
Self& itk::simple::BSplineTransform::SetTransformDomainMeshSize(const std::vector< unsigned int > &)
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::SetTransformDomainOrigin "/**
Self& itk::simple::BSplineTransform::SetTransformDomainOrigin(const std::vector< double > &)
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransform::SetTransformDomainPhysicalDimensions "/**
Self& itk::simple::BSplineTransform::SetTransformDomainPhysicalDimensions(const std::vector< double > &)
*/
public ";


%typemap(javaimports) itk::simple::BSplineTransformInitializerFilter "/**

BSplineTransformInitializerFilter is a helper class intended to initialize the control point grid such
that it has a physically consistent definition. It sets the transform
domain origin, physical dimensions and direction from information
obtained from the image. It also sets the mesh size if asked to do so
by calling SetTransformDomainMeshSize()before calling InitializeTransform().



Luis Ibanez
 Nick Tustison
See:
 itk::simple::BSplineTransformInitializer for the procedural interface

 itk::BSplineTransformInitializer for the Doxygen on the original ITK class.


C++ includes: sitkBSplineTransformInitializerFilter.h
*/"

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::BSplineTransformInitializerFilter "/**
itk::simple::BSplineTransformInitializerFilter::BSplineTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::Execute "/**
BSplineTransform itk::simple::BSplineTransformInitializerFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::Execute "/**
BSplineTransform itk::simple::BSplineTransformInitializerFilter::Execute(const Image &image1, const std::vector< uint32_t >
&transformDomainMeshSize, unsigned int order)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::GetName "/**
std::string itk::simple::BSplineTransformInitializerFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::GetOrder "/**
unsigned int itk::simple::BSplineTransformInitializerFilter::GetOrder() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::GetTransformDomainMeshSize "/**
std::vector<uint32_t> itk::simple::BSplineTransformInitializerFilter::GetTransformDomainMeshSize() const
*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::SetOrder "/**
Self& itk::simple::BSplineTransformInitializerFilter::SetOrder(unsigned int order)

The order of the bspline in the output BSplineTransform. This value effects the number of control points.

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::SetTransformDomainMeshSize "/**
Self& itk::simple::BSplineTransformInitializerFilter::SetTransformDomainMeshSize(const std::vector< uint32_t > &TransformDomainMeshSize)

Allow the user to set the mesh size of the transform via the
initializer even though the initializer does not do anything with that
information. Defeault = 1^ImageDimension.

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::ToString "/**
std::string itk::simple::BSplineTransformInitializerFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BSplineTransformInitializerFilter::~BSplineTransformInitializerFilter "/**
itk::simple::BSplineTransformInitializerFilter::~BSplineTransformInitializerFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BilateralImageFilter "/**

Blurs an image while preserving edges.


This filter uses bilateral filtering to blur an image using both
domain and range \"neighborhoods\". Pixels that are close to a pixel
in the image domain and similar to a pixel in the image range are used
to calculate the filtered value. Two gaussian kernels (one in the
image domain and one in the image range) are used to smooth the image.
The result is an image that is smoothed in homogeneous regions yet has
edges preserved. The result is similar to anisotropic diffusion but
the implementation in non-iterative. Another benefit to bilateral
filtering is that any distance metric can be used for kernel smoothing
the image range. Hence, color images can be smoothed as vector images,
using the CIE distances between intensity values as the similarity
metric (the Gaussian kernel for the image domain is evaluated using
CIE distances). A separate version of this filter will be designed for
color and vector images.

Bilateral filtering is capable of reducing the noise in an image by an
order of magnitude while maintaining edges.

The bilateral operator used here was described by Tomasi and Manduchi
(Bilateral Filtering for Gray and ColorImages. IEEE ICCV. 1998.)


See:
 GaussianOperator

 RecursiveGaussianImageFilter

 DiscreteGaussianImageFilter

 AnisotropicDiffusionImageFilter

 Image

 Neighborhood

 NeighborhoodOperator
 TodoSupport color images

Support vector images

Wiki Examples:

All Examples

Bilateral filter an image
See:
 itk::simple::Bilateral for the procedural interface

 itk::BilateralImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBilateralImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BilateralImageFilter::BilateralImageFilter "/**
itk::simple::BilateralImageFilter::BilateralImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::Execute "/**
Image itk::simple::BilateralImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::Execute "/**
Image itk::simple::BilateralImageFilter::Execute(const Image &image1, double domainSigma, double rangeSigma, unsigned
int numberOfRangeGaussianSamples)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::GetDomainSigma "/**
double itk::simple::BilateralImageFilter::GetDomainSigma() const

Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::GetName "/**
std::string itk::simple::BilateralImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::GetNumberOfRangeGaussianSamples "/**
unsigned int itk::simple::BilateralImageFilter::GetNumberOfRangeGaussianSamples() const

Set/Get the number of samples in the approximation to the Gaussian
used for the range smoothing. Samples are only generated in the range
of [0, 4*m_RangeSigma]. Default is 100.

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::GetRangeSigma "/**
double itk::simple::BilateralImageFilter::GetRangeSigma() const

Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::SetDomainSigma "/**
Self& itk::simple::BilateralImageFilter::SetDomainSigma(double DomainSigma)

Convenience get/set methods for setting all domain parameters to the
same values.

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::SetNumberOfRangeGaussianSamples "/**
Self& itk::simple::BilateralImageFilter::SetNumberOfRangeGaussianSamples(unsigned int NumberOfRangeGaussianSamples)

Set/Get the number of samples in the approximation to the Gaussian
used for the range smoothing. Samples are only generated in the range
of [0, 4*m_RangeSigma]. Default is 100.

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::SetRangeSigma "/**
Self& itk::simple::BilateralImageFilter::SetRangeSigma(double RangeSigma)

Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::ToString "/**
std::string itk::simple::BilateralImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BilateralImageFilter::~BilateralImageFilter "/**
itk::simple::BilateralImageFilter::~BilateralImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinShrinkImageFilter "/**

Reduce the size of an image by an integer factor in each dimension
while performing averaging of an input neighborhood.


The output image size in each dimension is given by:

outputSize[j] = max( std::floor(inputSize[j]/shrinkFactor[j]), 1 );

The algorithm implemented can be describe with the following equation
for 2D: \\\\[ \\\\mathsf{I}_{out}(x_o,x_1) =
\\\\frac{\\\\sum_{i=0}^{f_0}\\\\sum_{j=0}^{f_1}\\\\mathsf{I}_{in}(f_0
x_o+i,f_1 x_1+j)}{f_0 f_1} \\\\]

This filter is implemented so that the starting extent of the first
pixel of the output matches that of the input.

The change in image geometry from a 5x5 image binned by a factor of
2x2. This code was contributed in the Insight Journal paper:
\"BinShrink: A multi-resolution filter with cache efficient
averaging\" by Lowekamp B., Chen D. https://hdl.handle.net/10380/3450
See:
 itk::simple::BinShrink for the procedural interface

 itk::BinShrinkImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinShrinkImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::BinShrinkImageFilter "/**
itk::simple::BinShrinkImageFilter::BinShrinkImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::Execute "/**
Image itk::simple::BinShrinkImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::Execute "/**
Image itk::simple::BinShrinkImageFilter::Execute(const Image &image1, const std::vector< unsigned int >
&shrinkFactors)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::GetName "/**
std::string itk::simple::BinShrinkImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::GetShrinkFactors "/**
std::vector<unsigned int> itk::simple::BinShrinkImageFilter::GetShrinkFactors() const

Get the shrink factors.

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::SetShrinkFactor "/**
Self& itk::simple::BinShrinkImageFilter::SetShrinkFactor(unsigned int s)

Custom public declarations

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::SetShrinkFactors "/**
Self& itk::simple::BinShrinkImageFilter::SetShrinkFactors(const std::vector< unsigned int > &ShrinkFactors)

Set the shrink factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::ToString "/**
std::string itk::simple::BinShrinkImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinShrinkImageFilter::~BinShrinkImageFilter "/**
itk::simple::BinShrinkImageFilter::~BinShrinkImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryClosingByReconstructionImageFilter "/**

binary closing by reconstruction of an image.


This filter removes small (i.e., smaller than the structuring element)
holes in the image. It is defined as: Closing(f) =
ReconstructionByErosion(Dilation(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 MorphologyImageFilter , ClosingByReconstructionImageFilter , BinaryOpeningByReconstructionImageFilter

 itk::simple::BinaryClosingByReconstruction for the procedural interface

 itk::BinaryClosingByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryClosingByReconstructionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::BinaryClosingByReconstructionImageFilter "/**
itk::simple::BinaryClosingByReconstructionImageFilter::BinaryClosingByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::Execute "/**
Image itk::simple::BinaryClosingByReconstructionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::Execute "/**
Image itk::simple::BinaryClosingByReconstructionImageFilter::Execute(const Image &image1, double foregroundValue, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::GetForegroundValue "/**
double itk::simple::BinaryClosingByReconstructionImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryClosingByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BinaryClosingByReconstructionImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::GetKernelType "/**
KernelEnum itk::simple::BinaryClosingByReconstructionImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::GetName "/**
std::string itk::simple::BinaryClosingByReconstructionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::BinaryClosingByReconstructionImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::ToString "/**
std::string itk::simple::BinaryClosingByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryClosingByReconstructionImageFilter::~BinaryClosingByReconstructionImageFilter "/**
itk::simple::BinaryClosingByReconstructionImageFilter::~BinaryClosingByReconstructionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryContourImageFilter "/**

Labels the pixels on the border of the objects in a binary image.


BinaryContourImageFilter takes a binary image as input, where the pixels in the objects are
the pixels with a value equal to ForegroundValue. Only the pixels on
the contours of the objects are kept. The pixels not on the border are
changed to BackgroundValue.

The connectivity can be changed to minimum or maximum connectivity
with SetFullyConnected() . Full connectivity produces thicker contours.

https://hdl.handle.net/1926/1352


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 LabelContourImageFilter BinaryErodeImageFilter SimpleContourExtractorImageFilter
Wiki Examples:

All Examples

Extract the boundaries of connected regions in a binary image

Extract the inner and outer boundaries of blobs in a binary image
See:
 itk::simple::BinaryContour for the procedural interface

 itk::BinaryContourImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryContourImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::BinaryContourImageFilter "/**
itk::simple::BinaryContourImageFilter::BinaryContourImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::Execute "/**
Image itk::simple::BinaryContourImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::Execute "/**
Image itk::simple::BinaryContourImageFilter::Execute(const Image &image1, bool fullyConnected, double backgroundValue,
double foregroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryContourImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryContourImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryContourImageFilter::GetBackgroundValue() const

Set/Get the background value used to mark the pixels not on the border
of the objects.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::GetForegroundValue "/**
double itk::simple::BinaryContourImageFilter::GetForegroundValue() const

Set/Get the foreground value used to identify the objects in the input
and output images.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryContourImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::GetName "/**
std::string itk::simple::BinaryContourImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryContourImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value used to mark the pixels not on the border
of the objects.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryContourImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the foreground value used to identify the objects in the input
and output images.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryContourImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::ToString "/**
std::string itk::simple::BinaryContourImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryContourImageFilter::~BinaryContourImageFilter "/**
itk::simple::BinaryContourImageFilter::~BinaryContourImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryDilateImageFilter "/**

Fast binary dilation.


BinaryDilateImageFilter is a binary dilation morphologic operation. This implementation is
based on the papers:

L.Vincent \"Morphological transformations of binary images with
arbitrary structuring elements\", and

N.Nikopoulos et al. \"An efficient algorithm for 3d binary
morphological transformations with 3d structuring elements for
arbitrary size and shape\". IEEE Transactions on Image Processing. Vol. 9. No. 3. 2000. pp. 283-286.

Gray scale images can be processed as binary images by selecting a
\"DilateValue\". Pixel values matching the dilate value are considered
the \"foreground\" and all other pixels are \"background\". This is
useful in processing segmented images where all pixels in segment #1
have value 1 and pixels in segment #2 have value 2, etc. A particular
\"segment number\" can be processed. DilateValue defaults to the
maximum possible value of the PixelType.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel. A reasonable choice
of structuring element is itk::BinaryBallStructuringElement .


See:
 ImageToImageFilter BinaryErodeImageFilter BinaryMorphologyImageFilter
Wiki Examples:

All Examples

Dilate a binary image
See:
 itk::simple::BinaryDilate for the procedural interface

 itk::BinaryDilateImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryDilateImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::BinaryDilateImageFilter "/**
itk::simple::BinaryDilateImageFilter::BinaryDilateImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::BoundaryToForegroundOff "/**
Self& itk::simple::BinaryDilateImageFilter::BoundaryToForegroundOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::BoundaryToForegroundOn "/**
Self& itk::simple::BinaryDilateImageFilter::BoundaryToForegroundOn()

Set the value of BoundaryToForeground to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::Execute "/**
Image itk::simple::BinaryDilateImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::Execute "/**
Image itk::simple::BinaryDilateImageFilter::Execute(const Image &image1, double backgroundValue, double foregroundValue,
bool boundaryToForeground)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryDilateImageFilter::GetBackgroundValue() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::GetBoundaryToForeground "/**
bool itk::simple::BinaryDilateImageFilter::GetBoundaryToForeground() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::GetForegroundValue "/**
double itk::simple::BinaryDilateImageFilter::GetForegroundValue() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BinaryDilateImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::GetKernelType "/**
KernelEnum itk::simple::BinaryDilateImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::GetName "/**
std::string itk::simple::BinaryDilateImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryDilateImageFilter::SetBackgroundValue(double BackgroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetBoundaryToForeground "/**
Self& itk::simple::BinaryDilateImageFilter::SetBoundaryToForeground(bool BoundaryToForeground)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryDilateImageFilter::SetForegroundValue(double ForegroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryDilateImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryDilateImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetKernelType "/**
Self& itk::simple::BinaryDilateImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::SetKernelType "/**
Self& itk::simple::BinaryDilateImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::ToString "/**
std::string itk::simple::BinaryDilateImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryDilateImageFilter::~BinaryDilateImageFilter "/**
itk::simple::BinaryDilateImageFilter::~BinaryDilateImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryErodeImageFilter "/**

Fast binary erosion.


BinaryErodeImageFilter is a binary erosion morphologic operation. This implementation is
based on the papers:

L.Vincent \"Morphological transformations of binary images with
arbitrary structuring elements\", and

N.Nikopoulos et al. \"An efficient algorithm for 3d binary
morphological transformations with 3d structuring elements for
arbitrary size and shape\". IEEE Transactions on Image Processing. Vol. 9. No. 3. 2000. pp. 283-286.

Gray scale images can be processed as binary images by selecting a
\"ErodeValue\". Pixel values matching the erode value are considered
the \"foreground\" and all other pixels are \"background\". This is
useful in processing segmented images where all pixels in segment #1
have value 1 and pixels in segment #2 have value 2, etc. A particular
\"segment number\" can be processed. ErodeValue defaults to the
maximum possible value of the PixelType. The eroded pixels will
receive the BackgroundValue (defaults to 0).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel. A reasonable choice
of structuring element is itk::BinaryBallStructuringElement .


See:
 ImageToImageFilter BinaryDilateImageFilter BinaryMorphologyImageFilter
Wiki Examples:

All Examples

Erode a binary image
See:
 itk::simple::BinaryErode for the procedural interface

 itk::BinaryErodeImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryErodeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::BinaryErodeImageFilter "/**
itk::simple::BinaryErodeImageFilter::BinaryErodeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::BoundaryToForegroundOff "/**
Self& itk::simple::BinaryErodeImageFilter::BoundaryToForegroundOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::BoundaryToForegroundOn "/**
Self& itk::simple::BinaryErodeImageFilter::BoundaryToForegroundOn()

Set the value of BoundaryToForeground to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::Execute "/**
Image itk::simple::BinaryErodeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::Execute "/**
Image itk::simple::BinaryErodeImageFilter::Execute(const Image &image1, double backgroundValue, double foregroundValue,
bool boundaryToForeground)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryErodeImageFilter::GetBackgroundValue() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::GetBoundaryToForeground "/**
bool itk::simple::BinaryErodeImageFilter::GetBoundaryToForeground() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::GetForegroundValue "/**
double itk::simple::BinaryErodeImageFilter::GetForegroundValue() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BinaryErodeImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::GetKernelType "/**
KernelEnum itk::simple::BinaryErodeImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::GetName "/**
std::string itk::simple::BinaryErodeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryErodeImageFilter::SetBackgroundValue(double BackgroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetBoundaryToForeground "/**
Self& itk::simple::BinaryErodeImageFilter::SetBoundaryToForeground(bool BoundaryToForeground)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryErodeImageFilter::SetForegroundValue(double ForegroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryErodeImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryErodeImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetKernelType "/**
Self& itk::simple::BinaryErodeImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::SetKernelType "/**
Self& itk::simple::BinaryErodeImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::ToString "/**
std::string itk::simple::BinaryErodeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryErodeImageFilter::~BinaryErodeImageFilter "/**
itk::simple::BinaryErodeImageFilter::~BinaryErodeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryFillholeImageFilter "/**

Remove holes not connected to the boundary of the image.


BinaryFillholeImageFilter fills holes in a binary image.

Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 GrayscaleFillholeImageFilter

 itk::simple::BinaryFillhole for the procedural interface

 itk::BinaryFillholeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryFillholeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::BinaryFillholeImageFilter "/**
itk::simple::BinaryFillholeImageFilter::BinaryFillholeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::Execute "/**
Image itk::simple::BinaryFillholeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::Execute "/**
Image itk::simple::BinaryFillholeImageFilter::Execute(const Image &image1, bool fullyConnected, double foregroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryFillholeImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryFillholeImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::GetForegroundValue "/**
double itk::simple::BinaryFillholeImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryFillholeImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::GetName "/**
std::string itk::simple::BinaryFillholeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryFillholeImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryFillholeImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::ToString "/**
std::string itk::simple::BinaryFillholeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryFillholeImageFilter::~BinaryFillholeImageFilter "/**
itk::simple::BinaryFillholeImageFilter::~BinaryFillholeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryGrindPeakImageFilter "/**

Remove the objects not connected to the boundary of the image.


BinaryGrindPeakImageFilter ginds peaks in a grayscale image.

Geodesic morphology and the grind peak algorithm is described in
Chapter 6 of Pierre Soille's book \"Morphological Image Analysis:
Principles and Applications\", Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 GrayscaleGrindPeakImageFilter

 itk::simple::BinaryGrindPeak for the procedural interface

 itk::BinaryGrindPeakImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryGrindPeakImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::BinaryGrindPeakImageFilter "/**
itk::simple::BinaryGrindPeakImageFilter::BinaryGrindPeakImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::Execute "/**
Image itk::simple::BinaryGrindPeakImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::Execute "/**
Image itk::simple::BinaryGrindPeakImageFilter::Execute(const Image &image1, bool fullyConnected, double foregroundValue,
double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryGrindPeakImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryGrindPeakImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryGrindPeakImageFilter::GetBackgroundValue() const

Set the value in eroded part of the image. Defaults to zero

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::GetForegroundValue "/**
double itk::simple::BinaryGrindPeakImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryGrindPeakImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::GetName "/**
std::string itk::simple::BinaryGrindPeakImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryGrindPeakImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value in eroded part of the image. Defaults to zero

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryGrindPeakImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryGrindPeakImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::ToString "/**
std::string itk::simple::BinaryGrindPeakImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryGrindPeakImageFilter::~BinaryGrindPeakImageFilter "/**
itk::simple::BinaryGrindPeakImageFilter::~BinaryGrindPeakImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryImageToLabelMapFilter "/**

Label the connected components in a binary image and produce a
collection of label objects.


BinaryImageToLabelMapFilter labels the objects in a binary image. Each distinct object is
assigned a unique label. The final object labels start with 1 and are
consecutive. Objects that are reached earlier by a raster order scan
have a lower label.

The GetOutput() function of this class returns an itk::LabelMap .

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ConnectedComponentImageFilter , LabelImageToLabelMapFilter , LabelMap , LabelObject
Wiki Examples:

All Examples

Label binary regions in an image
See:
 itk::simple::BinaryImageToLabelMapFilter for the procedural interface

 itk::BinaryImageToLabelMapFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryImageToLabelMapFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::BinaryImageToLabelMapFilter "/**
itk::simple::BinaryImageToLabelMapFilter::BinaryImageToLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::Execute "/**
Image itk::simple::BinaryImageToLabelMapFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::Execute "/**
Image itk::simple::BinaryImageToLabelMapFilter::Execute(const Image &image1, bool fullyConnected, double
inputForegroundValue, double outputBackgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryImageToLabelMapFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryImageToLabelMapFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::GetFullyConnected "/**
bool itk::simple::BinaryImageToLabelMapFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::GetInputForegroundValue "/**
double itk::simple::BinaryImageToLabelMapFilter::GetInputForegroundValue() const

Set/Get the value to be consider \"foreground\" in the input image.
Defaults to NumericTraits<InputPixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::GetName "/**
std::string itk::simple::BinaryImageToLabelMapFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::GetOutputBackgroundValue "/**
double itk::simple::BinaryImageToLabelMapFilter::GetOutputBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<OutputPixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::SetFullyConnected "/**
Self& itk::simple::BinaryImageToLabelMapFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::SetInputForegroundValue "/**
Self& itk::simple::BinaryImageToLabelMapFilter::SetInputForegroundValue(double InputForegroundValue)

Set/Get the value to be consider \"foreground\" in the input image.
Defaults to NumericTraits<InputPixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::SetOutputBackgroundValue "/**
Self& itk::simple::BinaryImageToLabelMapFilter::SetOutputBackgroundValue(double OutputBackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<OutputPixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::ToString "/**
std::string itk::simple::BinaryImageToLabelMapFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryImageToLabelMapFilter::~BinaryImageToLabelMapFilter "/**
itk::simple::BinaryImageToLabelMapFilter::~BinaryImageToLabelMapFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryMagnitudeImageFilter "/**

Computes the square root of the sum of squares of corresponding input
pixels.


This filter is templated over the types of the two input images and
the type of the output image.

Numeric conversions (castings) are done by the C++ defaults.

The filter walks over all of the pixels in the two input images, and
for each pixel does the following:


cast the input 1 pixel value to double

cast the input 2 pixel value to double

compute the sum of squares of the two pixel values

compute the square root of the sum

cast the double value resulting from std::sqrt() to the pixel type of
the output image

store the cast value into the output image.
 The filter expects all images to have the same dimension (e.g. all
2D, or all 3D, or all ND)
See:
 itk::simple::BinaryMagnitude for the procedural interface

 itk::BinaryMagnitudeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMagnitudeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryMagnitudeImageFilter::BinaryMagnitudeImageFilter "/**
itk::simple::BinaryMagnitudeImageFilter::BinaryMagnitudeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMagnitudeImageFilter::Execute "/**
Image itk::simple::BinaryMagnitudeImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMagnitudeImageFilter::GetName "/**
std::string itk::simple::BinaryMagnitudeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMagnitudeImageFilter::ToString "/**
std::string itk::simple::BinaryMagnitudeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMagnitudeImageFilter::~BinaryMagnitudeImageFilter "/**
itk::simple::BinaryMagnitudeImageFilter::~BinaryMagnitudeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryMedianImageFilter "/**

Applies a version of the median filter optimized for binary images.


This filter was contributed by Bjorn Hanch Sollie after identifying
that the generic Median filter performed unnecessary operations when
the input image is binary.

This filter computes an image where a given pixel is the median value
of the pixels in a neighborhood about the corresponding input pixel.
For the case of binary images the median can be obtained by simply
counting the neighbors that are foreground.

A median filter is one of the family of nonlinear filters. It is used
to smooth an image without being biased by outliers or shot noise.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::BinaryMedian for the procedural interface

 itk::BinaryMedianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMedianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::BinaryMedianImageFilter "/**
itk::simple::BinaryMedianImageFilter::BinaryMedianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::Execute "/**
Image itk::simple::BinaryMedianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::Execute "/**
Image itk::simple::BinaryMedianImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius,
double foregroundValue, double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryMedianImageFilter::GetBackgroundValue() const

Get the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::GetForegroundValue "/**
double itk::simple::BinaryMedianImageFilter::GetForegroundValue() const

Get the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::GetName "/**
std::string itk::simple::BinaryMedianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::BinaryMedianImageFilter::GetRadius() const

Get the radius of the neighborhood used to compute the median

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryMedianImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryMedianImageFilter::SetForegroundValue(double ForegroundValue)

Set the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::SetRadius "/**
Self& itk::simple::BinaryMedianImageFilter::SetRadius(const std::vector< unsigned int > &Radius)

Set the radius of the neighborhood used to compute the median.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::SetRadius "/**
Self& itk::simple::BinaryMedianImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::ToString "/**
std::string itk::simple::BinaryMedianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMedianImageFilter::~BinaryMedianImageFilter "/**
itk::simple::BinaryMedianImageFilter::~BinaryMedianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryMinMaxCurvatureFlowImageFilter "/**

Denoise a binary image using min/max curvature flow.


BinaryMinMaxCurvatureFlowImageFilter implements a curvature driven image denosing algorithm. This filter
assumes that the image is essentially binary: consisting of two
classes. Iso-brightness contours in the input image are viewed as a
level set. The level set is then evolved using a curvature-based speed
function:

\\\\[ I_t = F_{\\\\mbox{minmax}} |\\\\nabla I| \\\\]

where $ F_{\\\\mbox{minmax}} = \\\\min(\\\\kappa,0) $ if $ \\\\mbox{Avg}_{\\\\mbox{stencil}}(x) $ is less than or equal to $ T_{thresold} $ and $ \\\\max(\\\\kappa,0) $ , otherwise. $ \\\\kappa $ is the mean curvature of the iso-brightness contour at point $ x $ .

In min/max curvature flow, movement is turned on or off depending on
the scale of the noise one wants to remove. Switching depends on the
average image value of a region of radius $ R $ around each point. The choice of $ R $ , the stencil radius, governs the scale of the noise to be removed.

The threshold value $ T_{threshold} $ is a user specified value which discriminates between the two pixel
classes.

This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a BinaryMinMaxCurvatureFlowFunction object. A zero flux Neumann boundary condition is used when computing
derivatives near the data boundary.


WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a real type. This filter works for any dimensional images.
 Reference: \"Level Set Methods and Fast Marching Methods\", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.


See:
 BinaryMinMaxCurvatureFlowFunction

 CurvatureFlowImageFilter

 MinMaxCurvatureFlowImageFilter

 itk::simple::BinaryMinMaxCurvatureFlow for the procedural interface

 itk::BinaryMinMaxCurvatureFlowImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMinMaxCurvatureFlowImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::BinaryMinMaxCurvatureFlowImageFilter "/**
itk::simple::BinaryMinMaxCurvatureFlowImageFilter::BinaryMinMaxCurvatureFlowImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::Execute "/**
Image itk::simple::BinaryMinMaxCurvatureFlowImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::Execute "/**
Image itk::simple::BinaryMinMaxCurvatureFlowImageFilter::Execute(const Image &image1, double timeStep, uint32_t numberOfIterations,
int stencilRadius, double threshold)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetName "/**
std::string itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetStencilRadius "/**
int itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetStencilRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetThreshold "/**
double itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetThreshold() const

Set/Get the threshold value.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetTimeStep "/**
double itk::simple::BinaryMinMaxCurvatureFlowImageFilter::GetTimeStep() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetNumberOfIterations "/**
Self& itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetStencilRadius "/**
Self& itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetStencilRadius(int StencilRadius)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetThreshold "/**
Self& itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetThreshold(double Threshold)

Set/Get the threshold value.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetTimeStep "/**
Self& itk::simple::BinaryMinMaxCurvatureFlowImageFilter::SetTimeStep(double TimeStep)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::ToString "/**
std::string itk::simple::BinaryMinMaxCurvatureFlowImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMinMaxCurvatureFlowImageFilter::~BinaryMinMaxCurvatureFlowImageFilter "/**
itk::simple::BinaryMinMaxCurvatureFlowImageFilter::~BinaryMinMaxCurvatureFlowImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryMorphologicalClosingImageFilter "/**

binary morphological closing of an image.


This filter removes small (i.e., smaller than the structuring element)
holes and tube like structures in the interior or at the boundaries of
the image. The morphological closing of an image \"f\" is defined as:
Closing(f) = Erosion(Dilation(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: \"Binary
morphological closing and opening image filters\" by Lehmann G. https://hdl.handle.net/1926/141 http://www.insight-journal.org/browse/publication/58


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter

 itk::simple::BinaryMorphologicalClosing for the procedural interface

 itk::BinaryMorphologicalClosingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMorphologicalClosingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::BinaryMorphologicalClosingImageFilter "/**
itk::simple::BinaryMorphologicalClosingImageFilter::BinaryMorphologicalClosingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::Execute "/**
Image itk::simple::BinaryMorphologicalClosingImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::Execute "/**
Image itk::simple::BinaryMorphologicalClosingImageFilter::Execute(const Image &image1, double foregroundValue, bool safeBorder)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::GetForegroundValue "/**
double itk::simple::BinaryMorphologicalClosingImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BinaryMorphologicalClosingImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::GetKernelType "/**
KernelEnum itk::simple::BinaryMorphologicalClosingImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::GetName "/**
std::string itk::simple::BinaryMorphologicalClosingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::GetSafeBorder "/**
bool itk::simple::BinaryMorphologicalClosingImageFilter::GetSafeBorder() const

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SafeBorderOff "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SafeBorderOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SafeBorderOn "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SafeBorderOn()

Set the value of SafeBorder to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelType "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelType "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::SetSafeBorder "/**
Self& itk::simple::BinaryMorphologicalClosingImageFilter::SetSafeBorder(bool SafeBorder)

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::ToString "/**
std::string itk::simple::BinaryMorphologicalClosingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalClosingImageFilter::~BinaryMorphologicalClosingImageFilter "/**
itk::simple::BinaryMorphologicalClosingImageFilter::~BinaryMorphologicalClosingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryMorphologicalOpeningImageFilter "/**

binary morphological opening of an image.


This filter removes small (i.e., smaller than the structuring element)
structures in the interior or at the boundaries of the image. The
morphological opening of an image \"f\" is defined as: Opening(f) =
Dilatation(Erosion(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: \"Binary
morphological closing and opening image filters\" by Lehmann G. https://hdl.handle.net/1926/141 http://www.insight-journal.org/browse/publication/58


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter

 itk::simple::BinaryMorphologicalOpening for the procedural interface

 itk::BinaryMorphologicalOpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMorphologicalOpeningImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::BinaryMorphologicalOpeningImageFilter "/**
itk::simple::BinaryMorphologicalOpeningImageFilter::BinaryMorphologicalOpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::Execute "/**
Image itk::simple::BinaryMorphologicalOpeningImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::Execute "/**
Image itk::simple::BinaryMorphologicalOpeningImageFilter::Execute(const Image &image1, double backgroundValue, double foregroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryMorphologicalOpeningImageFilter::GetBackgroundValue() const

Set the value in eroded part of the image. Defaults to zero

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::GetForegroundValue "/**
double itk::simple::BinaryMorphologicalOpeningImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BinaryMorphologicalOpeningImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::GetKernelType "/**
KernelEnum itk::simple::BinaryMorphologicalOpeningImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::GetName "/**
std::string itk::simple::BinaryMorphologicalOpeningImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryMorphologicalOpeningImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value in eroded part of the image. Defaults to zero

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryMorphologicalOpeningImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelType "/**
Self& itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelType "/**
Self& itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::ToString "/**
std::string itk::simple::BinaryMorphologicalOpeningImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryMorphologicalOpeningImageFilter::~BinaryMorphologicalOpeningImageFilter "/**
itk::simple::BinaryMorphologicalOpeningImageFilter::~BinaryMorphologicalOpeningImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryNotImageFilter "/**

Implements the BinaryNot logical operator pixel-wise between two
images.


This class is parametrized over the types of the two input images and
the type of the output image. Numeric conversions (castings) are done
by the C++ defaults.

The total operation over one pixel will be

output_pixel = static_cast<PixelType>( input1_pixel != input2_pixel )

Where \"!=\" is the equality operator in C++.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176

Wiki Examples:

All Examples

Invert an image using the Binary Not operation
See:
 itk::simple::BinaryNot for the procedural interface

 itk::BinaryNotImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryNotImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::BinaryNotImageFilter "/**
itk::simple::BinaryNotImageFilter::BinaryNotImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::Execute "/**
Image itk::simple::BinaryNotImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::Execute "/**
Image itk::simple::BinaryNotImageFilter::Execute(const Image &image1, double foregroundValue, double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryNotImageFilter::GetBackgroundValue() const

Get the value used as \"background\". Defaults to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::GetForegroundValue "/**
double itk::simple::BinaryNotImageFilter::GetForegroundValue() const

Set/Get the value in the image considered as \"foreground\". Defaults
to maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::GetName "/**
std::string itk::simple::BinaryNotImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryNotImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value used as \"background\". Defaults to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryNotImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value in the image considered as \"foreground\". Defaults
to maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::ToString "/**
std::string itk::simple::BinaryNotImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryNotImageFilter::~BinaryNotImageFilter "/**
itk::simple::BinaryNotImageFilter::~BinaryNotImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryOpeningByReconstructionImageFilter "/**

binary morphological closing of an image.


This filter removes small (i.e., smaller than the structuring element)
objects in the image. It is defined as: Opening(f) =
ReconstructionByDilatation(Erosion(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 MorphologyImageFilter , OpeningByReconstructionImageFilter , BinaryClosingByReconstructionImageFilter

 itk::simple::BinaryOpeningByReconstruction for the procedural interface

 itk::BinaryOpeningByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryOpeningByReconstructionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::BinaryOpeningByReconstructionImageFilter "/**
itk::simple::BinaryOpeningByReconstructionImageFilter::BinaryOpeningByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::Execute "/**
Image itk::simple::BinaryOpeningByReconstructionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::Execute "/**
Image itk::simple::BinaryOpeningByReconstructionImageFilter::Execute(const Image &image1, double foregroundValue, double backgroundValue,
bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryOpeningByReconstructionImageFilter::GetBackgroundValue() const

Set the value in eroded part of the image. Defaults to zero

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::GetForegroundValue "/**
double itk::simple::BinaryOpeningByReconstructionImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryOpeningByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BinaryOpeningByReconstructionImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::GetKernelType "/**
KernelEnum itk::simple::BinaryOpeningByReconstructionImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::GetName "/**
std::string itk::simple::BinaryOpeningByReconstructionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value in eroded part of the image. Defaults to zero

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::BinaryOpeningByReconstructionImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::ToString "/**
std::string itk::simple::BinaryOpeningByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryOpeningByReconstructionImageFilter::~BinaryOpeningByReconstructionImageFilter "/**
itk::simple::BinaryOpeningByReconstructionImageFilter::~BinaryOpeningByReconstructionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryProjectionImageFilter "/**

Binary projection.


This class was contributed to the Insight Journal by Gaetan Lehmann.
The original paper can be found at https://hdl.handle.net/1926/164


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ProjectionImageFilter

 MedianProjectionImageFilter

 MeanProjectionImageFilter

 MeanProjectionImageFilter

 MaximumProjectionImageFilter

 MinimumProjectionImageFilter

 StandardDeviationProjectionImageFilter

 SumProjectionImageFilter

 itk::simple::BinaryProjection for the procedural interface

 itk::BinaryProjectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryProjectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::BinaryProjectionImageFilter "/**
itk::simple::BinaryProjectionImageFilter::BinaryProjectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::Execute "/**
Image itk::simple::BinaryProjectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::Execute "/**
Image itk::simple::BinaryProjectionImageFilter::Execute(const Image &image1, unsigned int projectionDimension, double
foregroundValue, double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryProjectionImageFilter::GetBackgroundValue() const

Get the value used as \"background\". Any pixel value which is not
DilateValue is considered background. BackgroundValue is used for
defining boundary conditions. Defaults to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::GetForegroundValue "/**
double itk::simple::BinaryProjectionImageFilter::GetForegroundValue() const

Get the value in the image considered as \"foreground\". Defaults to
maximum value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::GetName "/**
std::string itk::simple::BinaryProjectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::GetProjectionDimension "/**
unsigned int itk::simple::BinaryProjectionImageFilter::GetProjectionDimension() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryProjectionImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value used as \"background\". Any pixel value which is not
DilateValue is considered background. BackgroundValue is used for
defining boundary conditions. Defaults to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryProjectionImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as \"foreground\". Defaults to
maximum value of PixelType. Subclasses may alias this to DilateValue
or ErodeValue.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::SetProjectionDimension "/**
Self& itk::simple::BinaryProjectionImageFilter::SetProjectionDimension(unsigned int ProjectionDimension)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::ToString "/**
std::string itk::simple::BinaryProjectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryProjectionImageFilter::~BinaryProjectionImageFilter "/**
itk::simple::BinaryProjectionImageFilter::~BinaryProjectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryReconstructionByDilationImageFilter "/**

binary reconstruction by dilation of an image


Reconstruction by dilation operates on a \"marker\" image and a
\"mask\" image, and is defined as the dilation of the marker image
with respect to the mask image iterated until stability.

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book \"Morphological Image Analysis: Principles and Applications\",
Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 MorphologyImageFilter , ReconstructionByDilationImageFilter , BinaryReconstructionByErosionImageFilter

 itk::simple::BinaryReconstructionByDilation for the procedural interface

 itk::BinaryReconstructionByDilationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryReconstructionByDilationImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::BinaryReconstructionByDilationImageFilter "/**
itk::simple::BinaryReconstructionByDilationImageFilter::BinaryReconstructionByDilationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::Execute "/**
Image itk::simple::BinaryReconstructionByDilationImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::Execute "/**
Image itk::simple::BinaryReconstructionByDilationImageFilter::Execute(const Image &image1, const Image &image2, double backgroundValue,
double foregroundValue, bool fullyConnected)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryReconstructionByDilationImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryReconstructionByDilationImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryReconstructionByDilationImageFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::GetForegroundValue "/**
double itk::simple::BinaryReconstructionByDilationImageFilter::GetForegroundValue() const

Set/Get the value used as \"foreground\" in the output image. Defaults
to NumericTraits<PixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryReconstructionByDilationImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::GetName "/**
std::string itk::simple::BinaryReconstructionByDilationImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryReconstructionByDilationImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryReconstructionByDilationImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value used as \"foreground\" in the output image. Defaults
to NumericTraits<PixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryReconstructionByDilationImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::ToString "/**
std::string itk::simple::BinaryReconstructionByDilationImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByDilationImageFilter::~BinaryReconstructionByDilationImageFilter "/**
itk::simple::BinaryReconstructionByDilationImageFilter::~BinaryReconstructionByDilationImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryReconstructionByErosionImageFilter "/**

binary reconstruction by erosion of an image


Reconstruction by erosion operates on a \"marker\" image and a
\"mask\" image, and is defined as the erosion of the marker image with
respect to the mask image iterated until stability.

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book \"Morphological Image Analysis: Principles and Applications\",
Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 MorphologyImageFilter , ReconstructionByErosionImageFilter , BinaryReconstructionByDilationImageFilter

 itk::simple::BinaryReconstructionByErosion for the procedural interface

 itk::BinaryReconstructionByErosionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryReconstructionByErosionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::BinaryReconstructionByErosionImageFilter "/**
itk::simple::BinaryReconstructionByErosionImageFilter::BinaryReconstructionByErosionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::Execute "/**
Image itk::simple::BinaryReconstructionByErosionImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::Execute "/**
Image itk::simple::BinaryReconstructionByErosionImageFilter::Execute(const Image &image1, const Image &image2, double backgroundValue,
double foregroundValue, bool fullyConnected)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::FullyConnectedOff "/**
Self& itk::simple::BinaryReconstructionByErosionImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::FullyConnectedOn "/**
Self& itk::simple::BinaryReconstructionByErosionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::GetBackgroundValue "/**
double itk::simple::BinaryReconstructionByErosionImageFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::GetForegroundValue "/**
double itk::simple::BinaryReconstructionByErosionImageFilter::GetForegroundValue() const

Set/Get the value used as \"foreground\" in the output image. Defaults
to NumericTraits<PixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::GetFullyConnected "/**
bool itk::simple::BinaryReconstructionByErosionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::GetName "/**
std::string itk::simple::BinaryReconstructionByErosionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryReconstructionByErosionImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryReconstructionByErosionImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value used as \"foreground\" in the output image. Defaults
to NumericTraits<PixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::SetFullyConnected "/**
Self& itk::simple::BinaryReconstructionByErosionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::ToString "/**
std::string itk::simple::BinaryReconstructionByErosionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryReconstructionByErosionImageFilter::~BinaryReconstructionByErosionImageFilter "/**
itk::simple::BinaryReconstructionByErosionImageFilter::~BinaryReconstructionByErosionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryThinningImageFilter "/**

This filter computes one-pixel-wide edges of the input image.


This class is parametrized over the type of the input image and the
type of the output image.

The input is assumed to be a binary image. If the foreground pixels of
the input image do not have a value of 1, they are rescaled to 1
internally to simplify the computation.

The filter will produce a skeleton of the object. The output
background values are 0, and the foreground values are 1.

This filter is a sequential thinning algorithm and known to be
computational time dependable on the image size. The algorithm
corresponds with the 2D implementation described in:

Rafael C. Gonzales and Richard E. Woods. Digital Image Processing. Addison Wesley, 491-494, (1993).

To do: Make this filter ND.


See:
 MorphologyImageFilter
Wiki Examples:

All Examples

Skeletonize/thin an image
See:
 itk::simple::BinaryThinning for the procedural interface

 itk::BinaryThinningImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryThinningImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryThinningImageFilter::BinaryThinningImageFilter "/**
itk::simple::BinaryThinningImageFilter::BinaryThinningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThinningImageFilter::Execute "/**
Image itk::simple::BinaryThinningImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThinningImageFilter::GetName "/**
std::string itk::simple::BinaryThinningImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThinningImageFilter::ToString "/**
std::string itk::simple::BinaryThinningImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThinningImageFilter::~BinaryThinningImageFilter "/**
itk::simple::BinaryThinningImageFilter::~BinaryThinningImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryThresholdImageFilter "/**

Binarize an input image by thresholding.


This filter produces an output image whose pixels are either one of
two values ( OutsideValue or InsideValue ), depending on whether the
corresponding input image pixels lie between the two thresholds (
LowerThreshold and UpperThreshold ). Values equal to either threshold
is considered to be between the thresholds.

More precisely \\\\[ Output(x_i) = \\\\begin{cases} InsideValue & \\\\text{if
\\\\f$LowerThreshold \\\\leq x_i \\\\leq UpperThreshold\\\\f$}
\\\\\\\\ OutsideValue & \\\\text{otherwise} \\\\end{cases} \\\\]

This filter is templated over the input image type and the output
image type.

The filter expect both images to have the same number of dimensions.

The default values for LowerThreshold and UpperThreshold are:
LowerThreshold = NumericTraits<TInput>::NonpositiveMin() ; UpperThreshold = NumericTraits<TInput>::max() ; Therefore, generally only one of these needs to be set, depending
on whether the user wants to threshold above or below the desired
threshold.

Wiki Examples:

All Examples

Threshold an image
See:
 itk::simple::BinaryThreshold for the procedural interface

 itk::BinaryThresholdImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinaryThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::BinaryThresholdImageFilter "/**
itk::simple::BinaryThresholdImageFilter::BinaryThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::Execute "/**
Image itk::simple::BinaryThresholdImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::Execute "/**
Image itk::simple::BinaryThresholdImageFilter::Execute(const Image &image1, double lowerThreshold, double upperThreshold,
uint8_t insideValue, uint8_t outsideValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::BinaryThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::GetLowerThreshold "/**
double itk::simple::BinaryThresholdImageFilter::GetLowerThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::GetName "/**
std::string itk::simple::BinaryThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::BinaryThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::GetUpperThreshold "/**
double itk::simple::BinaryThresholdImageFilter::GetUpperThreshold() const

Get the threshold values.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::BinaryThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value. The default value NumericTraits<OutputPixelType>::max()

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::SetLowerThreshold "/**
Self& itk::simple::BinaryThresholdImageFilter::SetLowerThreshold(double LowerThreshold)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::BinaryThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::ZeroValue() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::SetUpperThreshold "/**
Self& itk::simple::BinaryThresholdImageFilter::SetUpperThreshold(double UpperThreshold)

Set the thresholds. The default lower threshold is NumericTraits<InputPixelType>::NonpositiveMin() . The default upper threshold is NumericTraits<InputPixelType>::max . An execption is thrown if the lower threshold is greater than the
upper threshold.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::ToString "/**
std::string itk::simple::BinaryThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdImageFilter::~BinaryThresholdImageFilter "/**
itk::simple::BinaryThresholdImageFilter::~BinaryThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinaryThresholdProjectionImageFilter "/**

BinaryThreshold projection.


This class was contributed to the Insight Journal by Gaetan Lehmann.
the original paper can be found at https://hdl.handle.net/1926/164


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ProjectionImageFilter

 MedianProjectionImageFilter

 MeanProjectionImageFilter

 MeanProjectionImageFilter

 MaximumProjectionImageFilter

 MinimumProjectionImageFilter

 StandardDeviationProjectionImageFilter

 SumProjectionImageFilter

 itk::simple::BinaryThresholdProjection for the procedural interface

 itk::BinaryThresholdProjectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryThresholdProjectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::BinaryThresholdProjectionImageFilter "/**
itk::simple::BinaryThresholdProjectionImageFilter::BinaryThresholdProjectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::Execute "/**
Image itk::simple::BinaryThresholdProjectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::Execute "/**
Image itk::simple::BinaryThresholdProjectionImageFilter::Execute(const Image &image1, unsigned int projectionDimension, double
thresholdValue, uint8_t foregroundValue, uint8_t backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::BinaryThresholdProjectionImageFilter::GetBackgroundValue() const

Set/Get the output value used as \"background\". Defaults to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::GetForegroundValue "/**
uint8_t itk::simple::BinaryThresholdProjectionImageFilter::GetForegroundValue() const

Set/Get the output value used as \"foreground\". Defaults to maximum
value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::GetName "/**
std::string itk::simple::BinaryThresholdProjectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::GetProjectionDimension "/**
unsigned int itk::simple::BinaryThresholdProjectionImageFilter::GetProjectionDimension() const
*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::GetThresholdValue "/**
double itk::simple::BinaryThresholdProjectionImageFilter::GetThresholdValue() const

Set/Get the input value consider as \"threshold\". Defaults to NumericTraits<InputPixelType>::max()

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::SetBackgroundValue "/**
Self& itk::simple::BinaryThresholdProjectionImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the output value used as \"background\". Defaults to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::SetForegroundValue "/**
Self& itk::simple::BinaryThresholdProjectionImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the output value used as \"foreground\". Defaults to maximum
value of PixelType.

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::SetProjectionDimension "/**
Self& itk::simple::BinaryThresholdProjectionImageFilter::SetProjectionDimension(unsigned int ProjectionDimension)
*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::SetThresholdValue "/**
Self& itk::simple::BinaryThresholdProjectionImageFilter::SetThresholdValue(double ThresholdValue)

Set/Get the input value consider as \"threshold\". Defaults to NumericTraits<InputPixelType>::max()

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::ToString "/**
std::string itk::simple::BinaryThresholdProjectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinaryThresholdProjectionImageFilter::~BinaryThresholdProjectionImageFilter "/**
itk::simple::BinaryThresholdProjectionImageFilter::~BinaryThresholdProjectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BinomialBlurImageFilter "/**

Performs a separable blur on each dimension of an image.


The binomial blur consists of a nearest neighbor average along each
image dimension. The net result after n-iterations approaches
convultion with a gaussian.

Wiki Examples:

All Examples

Blur an image
See:
 itk::simple::BinomialBlur for the procedural interface

 itk::BinomialBlurImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBinomialBlurImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::BinomialBlurImageFilter "/**
itk::simple::BinomialBlurImageFilter::BinomialBlurImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::Execute "/**
Image itk::simple::BinomialBlurImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::Execute "/**
Image itk::simple::BinomialBlurImageFilter::Execute(const Image &image1, unsigned int repetitions)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::GetName "/**
std::string itk::simple::BinomialBlurImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::GetRepetitions "/**
unsigned int itk::simple::BinomialBlurImageFilter::GetRepetitions() const

Get and set the number of times to repeat the filter.

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::SetRepetitions "/**
Self& itk::simple::BinomialBlurImageFilter::SetRepetitions(unsigned int Repetitions)

Get and set the number of times to repeat the filter.

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::ToString "/**
std::string itk::simple::BinomialBlurImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BinomialBlurImageFilter::~BinomialBlurImageFilter "/**
itk::simple::BinomialBlurImageFilter::~BinomialBlurImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BitwiseNotImageFilter "/**

Implements pixel-wise generic operation on one image.


This class is parameterized over the type of the input image and the
type of the output image. It is also parameterized by the operation to
be applied, using a Functor style.

UnaryFunctorImageFilter allows the output dimension of the filter to be larger than the input
dimension. Thus subclasses of the UnaryFunctorImageFilter (like the CastImageFilter ) can be used to promote a 2D image to a 3D image, etc.


See:
 BinaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a custom operation to each pixel in an image
See:
 itk::simple::BitwiseNot for the procedural interface

 itk::UnaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkBitwiseNotImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BitwiseNotImageFilter::BitwiseNotImageFilter "/**
itk::simple::BitwiseNotImageFilter::BitwiseNotImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BitwiseNotImageFilter::Execute "/**
Image itk::simple::BitwiseNotImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BitwiseNotImageFilter::GetName "/**
std::string itk::simple::BitwiseNotImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BitwiseNotImageFilter::ToString "/**
std::string itk::simple::BitwiseNotImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BitwiseNotImageFilter::~BitwiseNotImageFilter "/**
itk::simple::BitwiseNotImageFilter::~BitwiseNotImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BlackTopHatImageFilter "/**

Black top hat extracts local minima that are smaller than the
structuring element.


Black top hat extracts local minima that are smaller than the
structuring element. It subtracts the background from the input image.
The output of the filter transforms the black valleys into white
peaks.

Top-hats are described in Chapter 4.5 of Pierre Soille's book
\"Morphological Image Analysis: Principles and Applications\", Second
Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 itk::simple::BlackTopHat for the procedural interface

 itk::BlackTopHatImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBlackTopHatImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::BlackTopHatImageFilter "/**
itk::simple::BlackTopHatImageFilter::BlackTopHatImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::Execute "/**
Image itk::simple::BlackTopHatImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::Execute "/**
Image itk::simple::BlackTopHatImageFilter::Execute(const Image &image1, bool safeBorder)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::BlackTopHatImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::GetKernelType "/**
KernelEnum itk::simple::BlackTopHatImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::GetName "/**
std::string itk::simple::BlackTopHatImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::GetSafeBorder "/**
bool itk::simple::BlackTopHatImageFilter::GetSafeBorder() const

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SafeBorderOff "/**
Self& itk::simple::BlackTopHatImageFilter::SafeBorderOff()
*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SafeBorderOn "/**
Self& itk::simple::BlackTopHatImageFilter::SafeBorderOn()

Set the value of SafeBorder to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SetKernelRadius "/**
Self& itk::simple::BlackTopHatImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SetKernelRadius "/**
Self& itk::simple::BlackTopHatImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SetKernelType "/**
Self& itk::simple::BlackTopHatImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SetKernelType "/**
Self& itk::simple::BlackTopHatImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::SetSafeBorder "/**
Self& itk::simple::BlackTopHatImageFilter::SetSafeBorder(bool SafeBorder)

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::ToString "/**
std::string itk::simple::BlackTopHatImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BlackTopHatImageFilter::~BlackTopHatImageFilter "/**
itk::simple::BlackTopHatImageFilter::~BlackTopHatImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BoundedReciprocalImageFilter "/**

Computes 1/(1+x) for each pixel in the image.


The filter expect both the input and output images to have the same
number of dimensions, and both of a scalar image type.
See:
 itk::simple::BoundedReciprocal for the procedural interface

 itk::BoundedReciprocalImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBoundedReciprocalImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BoundedReciprocalImageFilter::BoundedReciprocalImageFilter "/**
itk::simple::BoundedReciprocalImageFilter::BoundedReciprocalImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BoundedReciprocalImageFilter::Execute "/**
Image itk::simple::BoundedReciprocalImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BoundedReciprocalImageFilter::GetName "/**
std::string itk::simple::BoundedReciprocalImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BoundedReciprocalImageFilter::ToString "/**
std::string itk::simple::BoundedReciprocalImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BoundedReciprocalImageFilter::~BoundedReciprocalImageFilter "/**
itk::simple::BoundedReciprocalImageFilter::~BoundedReciprocalImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BoxMeanImageFilter "/**

Implements a fast rectangular mean filter using the accumulator
approach.


This code was contributed in the Insight Journal paper: \"Efficient
implementation of kernel filtering\" by Beare R., Lehmann G https://hdl.handle.net/1926/555 http://www.insight-journal.org/browse/publication/160


Richard Beare

See:
 itk::simple::BoxMean for the procedural interface

 itk::BoxMeanImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBoxMeanImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::BoxMeanImageFilter "/**
itk::simple::BoxMeanImageFilter::BoxMeanImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::Execute "/**
Image itk::simple::BoxMeanImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::Execute "/**
Image itk::simple::BoxMeanImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::GetName "/**
std::string itk::simple::BoxMeanImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::BoxMeanImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::SetRadius "/**
Self& itk::simple::BoxMeanImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::SetRadius "/**
Self& itk::simple::BoxMeanImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::ToString "/**
std::string itk::simple::BoxMeanImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BoxMeanImageFilter::~BoxMeanImageFilter "/**
itk::simple::BoxMeanImageFilter::~BoxMeanImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::BoxSigmaImageFilter "/**

Implements a fast rectangular sigma filter using the accumulator
approach.


This code was contributed in the Insight Journal paper: \"Efficient
implementation of kernel filtering\" by Beare R., Lehmann G https://hdl.handle.net/1926/555 http://www.insight-journal.org/browse/publication/160


Gaetan Lehmann

See:
 itk::simple::BoxSigma for the procedural interface

 itk::BoxSigmaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBoxSigmaImageFilter.h
*/"

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::BoxSigmaImageFilter "/**
itk::simple::BoxSigmaImageFilter::BoxSigmaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::Execute "/**
Image itk::simple::BoxSigmaImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::Execute "/**
Image itk::simple::BoxSigmaImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::GetName "/**
std::string itk::simple::BoxSigmaImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::BoxSigmaImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::SetRadius "/**
Self& itk::simple::BoxSigmaImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::SetRadius "/**
Self& itk::simple::BoxSigmaImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::ToString "/**
std::string itk::simple::BoxSigmaImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::BoxSigmaImageFilter::~BoxSigmaImageFilter "/**
itk::simple::BoxSigmaImageFilter::~BoxSigmaImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CannyEdgeDetectionImageFilter "/**

This filter is an implementation of a Canny edge detector for scalar-
valued images.


Based on John Canny's paper \"A Computational Approach to Edge
Detection\"(IEEE Transactions on Pattern Analysis and Machine
Intelligence, Vol. PAMI-8, No.6, November 1986), there are four major
steps used in the edge-detection scheme: (1) Smooth the input image
with Gaussian filter. (2) Calculate the second directional derivatives
of the smoothed image. (3) Non-Maximum Suppression: the zero-crossings
of 2nd derivative are found, and the sign of third derivative is used
to find the correct extrema. (4) The hysteresis thresholding is
applied to the gradient magnitude (multiplied with zero-crossings) of
the smoothed image to find and link edges.

Inputs and Outputs
The input to this filter should be a scalar, real-valued Itk image of
arbitrary dimension. The output should also be a scalar, real-value
Itk image of the same dimensionality.
Parameters
There are four parameters for this filter that control the sub-filters
used by the algorithm.

Variance and Maximum error are used in the Gaussian smoothing of the
input image. See itkDiscreteGaussianImageFilter for information on
these parameters.

Threshold is the lowest allowed value in the output image. Its data
type is the same as the data type of the output image. Any values
below the Threshold level will be replaced with the OutsideValue
parameter value, whose default is zero.
 TodoEdge-linking will be added when an itk connected component
labeling algorithm is available.


See:
 DiscreteGaussianImageFilter

 ZeroCrossingImageFilter

 ThresholdImageFilter

 itk::simple::CannyEdgeDetection for the procedural interface

 itk::CannyEdgeDetectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCannyEdgeDetectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::CannyEdgeDetectionImageFilter "/**
itk::simple::CannyEdgeDetectionImageFilter::CannyEdgeDetectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::Execute "/**
Image itk::simple::CannyEdgeDetectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::Execute "/**
Image itk::simple::CannyEdgeDetectionImageFilter::Execute(const Image &image1, double lowerThreshold, double upperThreshold,
const std::vector< double > &variance, const std::vector< double >
&maximumError)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::GetLowerThreshold "/**
double itk::simple::CannyEdgeDetectionImageFilter::GetLowerThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::GetMaximumError "/**
std::vector<double> itk::simple::CannyEdgeDetectionImageFilter::GetMaximumError() const

Set/Get the maximum error of the Gaussian smoothing kernel in each
dimensional direction.

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::GetName "/**
std::string itk::simple::CannyEdgeDetectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::GetUpperThreshold "/**
double itk::simple::CannyEdgeDetectionImageFilter::GetUpperThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::GetVariance "/**
std::vector<double> itk::simple::CannyEdgeDetectionImageFilter::GetVariance() const

Set/Get the variance of the Gaussian smoothing filter.

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::SetLowerThreshold "/**
Self& itk::simple::CannyEdgeDetectionImageFilter::SetLowerThreshold(double LowerThreshold)
*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::SetMaximumError "/**
Self& itk::simple::CannyEdgeDetectionImageFilter::SetMaximumError(const std::vector< double > &MaximumError)

Set/Get the MaximumError parameter used by the Gaussian smoothing
filter in this algorithm

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::SetMaximumError "/**
Self& itk::simple::CannyEdgeDetectionImageFilter::SetMaximumError(double value)

Set the values of the MaximumError vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::SetUpperThreshold "/**
Self& itk::simple::CannyEdgeDetectionImageFilter::SetUpperThreshold(double UpperThreshold)

Set the Threshold value for detected edges. TODO: Document in the
ITKv4 migration guide that the SetThreshold member function was
removed from the CannyEdgeDetectionImageFilter , and that both UpperThreshold and LowerThreshold need to be set. To
get the same results as with the SetThreshold method change
\"myfilter->SetThrehsold\" to \"myfilter->SetUpperThreshold\", and add
\"myfilter->SetLowerThreshold(GetUpperThreshold()/2.0)\".

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::SetVariance "/**
Self& itk::simple::CannyEdgeDetectionImageFilter::SetVariance(const std::vector< double > &Variance)

Set/Get the variance of the Gaussian smoothing filter.

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::SetVariance "/**
Self& itk::simple::CannyEdgeDetectionImageFilter::SetVariance(double value)

Set the values of the Variance vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::ToString "/**
std::string itk::simple::CannyEdgeDetectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CannyEdgeDetectionImageFilter::~CannyEdgeDetectionImageFilter "/**
itk::simple::CannyEdgeDetectionImageFilter::~CannyEdgeDetectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CastImageFilter "/**

A hybrid cast image filter to convert images to other types of images.


Several different ITK classes are implemented under the hood, to
convert between different image types.


See:
 itk::simple::Cast for the procedural interface


C++ includes: sitkCastImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CastImageFilter::CastImageFilter "/**
itk::simple::CastImageFilter::CastImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CastImageFilter::Execute "/**
Image itk::simple::CastImageFilter::Execute(const Image &)
*/
public ";

%javamethodmodifiers  itk::simple::CastImageFilter::GetName "/**
std::string itk::simple::CastImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CastImageFilter::GetOutputPixelType "/**
PixelIDValueEnum itk::simple::CastImageFilter::GetOutputPixelType(void) const
*/
public ";

%javamethodmodifiers  itk::simple::CastImageFilter::SetOutputPixelType "/**
Self& itk::simple::CastImageFilter::SetOutputPixelType(PixelIDValueEnum pixelID)

Set/Get the output pixel type

*/
public ";

%javamethodmodifiers  itk::simple::CastImageFilter::ToString "/**
std::string itk::simple::CastImageFilter::ToString() const
*/
public ";


%typemap(javaimports) itk::simple::CenteredTransformInitializerFilter "/**

CenteredTransformInitializerFilter is a helper class intended to initialize the center of rotation and
the translation of Transforms having the center of rotation among
their parameters.


This class is connected to the fixed image, moving image and transform
involved in the registration. Two modes of operation are possible:


Geometrical,

Center of mass
 In the first mode, the geometrical center of the moving image is
passed as initial center of rotation to the transform and the vector
from the center of the fixed image to the center of the moving image
is passed as the initial translation. This mode basically assumes that
the anatomical objects to be registered are centered in their
respective images. Hence the best initial guess for the registration
is the one that superimposes those two centers.

In the second mode, the moments of gray level values are computed for
both images. The center of mass of the moving image is then used as
center of rotation. The vector between the two centers of mass is
passes as the initial translation to the transform. This second
approach assumes that the moments of the anatomical objects are
similar for both images and hence the best initial guess for
registration is to superimpose both mass centers. Note that this
assumption will probably not hold in multi-modality registration.   \\\\sa itk::CenteredTransformInitializer

C++ includes: sitkCenteredTransformInitializerFilter.h
*/"

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::CenteredTransformInitializerFilter "/**
itk::simple::CenteredTransformInitializerFilter::CenteredTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::Execute "/**
Transform itk::simple::CenteredTransformInitializerFilter::Execute(const Image &fixedImage, const Image &movingImage, const Transform
&transform)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::Execute "/**
Transform itk::simple::CenteredTransformInitializerFilter::Execute(const Image &fixedImage, const Image &movingImage, const Transform
&transform, CenteredTransformInitializerFilter::OperationModeType
operationMode)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::GeometryOn "/**
Self& itk::simple::CenteredTransformInitializerFilter::GeometryOn()

Select between using the geometrical center of the images or using the
center of mass given by the image intensities.

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::GetName "/**
std::string itk::simple::CenteredTransformInitializerFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::GetOperationMode "/**
OperationModeType itk::simple::CenteredTransformInitializerFilter::GetOperationMode() const
*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::MomentsOn "/**
Self& itk::simple::CenteredTransformInitializerFilter::MomentsOn()

Select between using the geometrical center of the images or using the
center of mass given by the image intensities.

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::SetOperationMode "/**
Self& itk::simple::CenteredTransformInitializerFilter::SetOperationMode(OperationModeType OperationMode)
*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::ToString "/**
std::string itk::simple::CenteredTransformInitializerFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CenteredTransformInitializerFilter::~CenteredTransformInitializerFilter "/**
itk::simple::CenteredTransformInitializerFilter::~CenteredTransformInitializerFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CenteredVersorTransformInitializerFilter "/**

CenteredVersorTransformInitializerFilter is a helper class intended to initialize the center of rotation,
versor, and translation of the VersorRigid3DTransform.


This class derived from the CenteredTransformInitializerand uses it in
a more constrained context. It always uses the Moments mode, and also
takes advantage of the second order moments in order to initialize the
Versorrepresenting rotation.


See:
 itk::CenteredVersorTransformInitializer for the Doxygen on the original ITK class.


C++ includes: sitkCenteredVersorTransformInitializerFilter.h
*/"

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::CenteredVersorTransformInitializerFilter "/**
itk::simple::CenteredVersorTransformInitializerFilter::CenteredVersorTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::ComputeRotationOff "/**
Self& itk::simple::CenteredVersorTransformInitializerFilter::ComputeRotationOff()
*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::ComputeRotationOn "/**
Self& itk::simple::CenteredVersorTransformInitializerFilter::ComputeRotationOn()

Set the value of ComputeRotation to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::Execute "/**
Transform itk::simple::CenteredVersorTransformInitializerFilter::Execute(const Image &fixedImage, const Image &movingImage, const Transform
&transform)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::Execute "/**
Transform itk::simple::CenteredVersorTransformInitializerFilter::Execute(const Image &fixedImage, const Image &movingImage, const Transform
&transform, bool computeRotation)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::GetComputeRotation "/**
bool itk::simple::CenteredVersorTransformInitializerFilter::GetComputeRotation() const

Enable the use of the principal axes of each image to compute an
initial rotation that will align them.

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::GetName "/**
std::string itk::simple::CenteredVersorTransformInitializerFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::SetComputeRotation "/**
Self& itk::simple::CenteredVersorTransformInitializerFilter::SetComputeRotation(bool ComputeRotation)

Enable the use of the principal axes of each image to compute an
initial rotation that will align them.

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::ToString "/**
std::string itk::simple::CenteredVersorTransformInitializerFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CenteredVersorTransformInitializerFilter::~CenteredVersorTransformInitializerFilter "/**
itk::simple::CenteredVersorTransformInitializerFilter::~CenteredVersorTransformInitializerFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ChangeLabelImageFilter "/**

Change Sets of Labels.


This filter produces an output image whose pixels are either copied
from the input if they are not being changed or are rewritten based on
the change parameters

This filter is templated over the input image type and the output
image type.

The filter expect both images to have the same number of dimensions.


Tim Kelliher. GE Research, Niskayuna, NY.

This work was supported by a grant from DARPA, executed by the U.S.
Army Medical Research and Materiel Command/TATRC Assistance Agreement,
Contract::W81XWH-05-2-0059.

See:
 itk::simple::ChangeLabel for the procedural interface

 itk::ChangeLabelImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkChangeLabelImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::ChangeLabelImageFilter "/**
itk::simple::ChangeLabelImageFilter::ChangeLabelImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::Execute "/**
Image itk::simple::ChangeLabelImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::Execute "/**
Image itk::simple::ChangeLabelImageFilter::Execute(const Image &image1, std::map< double, double > changeMap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::GetChangeMap "/**
std::map<double,double> itk::simple::ChangeLabelImageFilter::GetChangeMap() const
*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::GetName "/**
std::string itk::simple::ChangeLabelImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::SetChangeMap "/**
Self& itk::simple::ChangeLabelImageFilter::SetChangeMap(std::map< double, double > ChangeMap)

Set the entire change map

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::ToString "/**
std::string itk::simple::ChangeLabelImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelImageFilter::~ChangeLabelImageFilter "/**
itk::simple::ChangeLabelImageFilter::~ChangeLabelImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ChangeLabelLabelMapFilter "/**

Replace the label Ids of selected LabelObjects with new label Ids.


This filter takes as input a label map and a list of pairs of Label
Ids, to produce as output a new label map where the label Ids have
been replaced according to the pairs in the list.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter

 itk::simple::ChangeLabelLabelMapFilter for the procedural interface

 itk::ChangeLabelLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkChangeLabelLabelMapFilter.h
*/"

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::ChangeLabelLabelMapFilter "/**
itk::simple::ChangeLabelLabelMapFilter::ChangeLabelLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::Execute "/**
Image itk::simple::ChangeLabelLabelMapFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::Execute "/**
Image itk::simple::ChangeLabelLabelMapFilter::Execute(const Image &image1, std::map< double, double > changeMap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::GetChangeMap "/**
std::map<double,double> itk::simple::ChangeLabelLabelMapFilter::GetChangeMap() const
*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::GetName "/**
std::string itk::simple::ChangeLabelLabelMapFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::SetChangeMap "/**
Self& itk::simple::ChangeLabelLabelMapFilter::SetChangeMap(std::map< double, double > ChangeMap)
*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::ToString "/**
std::string itk::simple::ChangeLabelLabelMapFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ChangeLabelLabelMapFilter::~ChangeLabelLabelMapFilter "/**
itk::simple::ChangeLabelLabelMapFilter::~ChangeLabelLabelMapFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CheckerBoardImageFilter "/**

Combines two images in a checkerboard pattern.


CheckerBoardImageFilter takes two input images that must have the same dimension, size,
origin and spacing and produces an output image of the same size by
combinining the pixels from the two input images in a checkerboard
pattern. This filter is commonly used for visually comparing two
images, in particular for evaluating the results of an image
registration process.

This filter is implemented as a multithreaded filter. It provides a
ThreadedGenerateData() method for its implementation.

Wiki Examples:

All Examples

Combine two images by alternating blocks of a checkerboard pattern
See:
 itk::simple::CheckerBoard for the procedural interface

 itk::CheckerBoardImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkCheckerBoardImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::CheckerBoardImageFilter "/**
itk::simple::CheckerBoardImageFilter::CheckerBoardImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::Execute "/**
Image itk::simple::CheckerBoardImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::Execute "/**
Image itk::simple::CheckerBoardImageFilter::Execute(const Image &image1, const Image &image2, const std::vector< uint32_t
> &checkerPattern)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::GetCheckerPattern "/**
std::vector<uint32_t> itk::simple::CheckerBoardImageFilter::GetCheckerPattern() const

Set/Get the checker pattern array, i.e. the number of checker boxes
per image dimension.

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::GetName "/**
std::string itk::simple::CheckerBoardImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::SetCheckerPattern "/**
Self& itk::simple::CheckerBoardImageFilter::SetCheckerPattern(const std::vector< uint32_t > &CheckerPattern)

Set/Get the checker pattern array, i.e. the number of checker boxes
per image dimension.

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::SetCheckerPattern "/**
Self& itk::simple::CheckerBoardImageFilter::SetCheckerPattern(uint32_t value)

Set the values of the CheckerPattern vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::ToString "/**
std::string itk::simple::CheckerBoardImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CheckerBoardImageFilter::~CheckerBoardImageFilter "/**
itk::simple::CheckerBoardImageFilter::~CheckerBoardImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ClampImageFilter "/**

Casts input pixels to output pixel type and clamps the output pixel
values to a specified range.


Default range corresponds to the range supported by the pixel type of
the output image.

This filter is templated over the input image type and the output
image type.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 UnaryFunctorImageFilter

 CastImageFilter
Wiki Examples:

All Examples

Cast an image from one type to another but clamp to the output value
range
See:
 itk::simple::Clamp for the procedural interface

 itk::ClampImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkClampImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ClampImageFilter::ClampImageFilter "/**
itk::simple::ClampImageFilter::ClampImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::Execute "/**
Image itk::simple::ClampImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::Execute "/**
Image itk::simple::ClampImageFilter::Execute(const Image &image1, PixelIDValueEnum outputPixelType, double
lowerBound, double upperBound)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::GetLowerBound "/**
double itk::simple::ClampImageFilter::GetLowerBound() const
*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::GetName "/**
std::string itk::simple::ClampImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::GetOutputPixelType "/**
PixelIDValueEnum itk::simple::ClampImageFilter::GetOutputPixelType() const
*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::GetUpperBound "/**
double itk::simple::ClampImageFilter::GetUpperBound() const
*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::SetLowerBound "/**
Self& itk::simple::ClampImageFilter::SetLowerBound(double LowerBound)
*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::SetOutputPixelType "/**
Self& itk::simple::ClampImageFilter::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::SetUpperBound "/**
Self& itk::simple::ClampImageFilter::SetUpperBound(double UpperBound)
*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::ToString "/**
std::string itk::simple::ClampImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ClampImageFilter::~ClampImageFilter "/**
itk::simple::ClampImageFilter::~ClampImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ClosingByReconstructionImageFilter "/**

Closing by reconstruction of an image.


This filter is similar to the morphological closing, but contrary to
the mophological closing, the closing by reconstruction preserves the
shape of the components. The closing by reconstruction of an image
\"f\" is defined as:

ClosingByReconstruction(f) = ErosionByReconstruction(f, Dilation(f)).

Closing by reconstruction not only preserves structures preserved by
the dilation, but also levels raises the contrast of the darkest
regions. If PreserveIntensities is on, a subsequent reconstruction by
dilation using a marker image that is the original image for all
unaffected pixels.

Closing by reconstruction is described in Chapter 6.3.9 of Pierre
Soille's book \"Morphological Image Analysis: Principles and
Applications\", Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 GrayscaleMorphologicalClosingImageFilter

 itk::simple::ClosingByReconstruction for the procedural interface

 itk::ClosingByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkClosingByReconstructionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::ClosingByReconstructionImageFilter "/**
itk::simple::ClosingByReconstructionImageFilter::ClosingByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::Execute "/**
Image itk::simple::ClosingByReconstructionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::Execute "/**
Image itk::simple::ClosingByReconstructionImageFilter::Execute(const Image &image1, bool fullyConnected, bool preserveIntensities)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::FullyConnectedOff "/**
Self& itk::simple::ClosingByReconstructionImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::FullyConnectedOn "/**
Self& itk::simple::ClosingByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::GetFullyConnected "/**
bool itk::simple::ClosingByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::ClosingByReconstructionImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::GetKernelType "/**
KernelEnum itk::simple::ClosingByReconstructionImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::GetName "/**
std::string itk::simple::ClosingByReconstructionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::GetPreserveIntensities "/**
bool itk::simple::ClosingByReconstructionImageFilter::GetPreserveIntensities() const

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstrcution. If Off, the
output pixel contrast will be reduced.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::PreserveIntensitiesOff "/**
Self& itk::simple::ClosingByReconstructionImageFilter::PreserveIntensitiesOff()
*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::PreserveIntensitiesOn "/**
Self& itk::simple::ClosingByReconstructionImageFilter::PreserveIntensitiesOn()

Set the value of PreserveIntensities to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::SetFullyConnected "/**
Self& itk::simple::ClosingByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::ClosingByReconstructionImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::ClosingByReconstructionImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::ClosingByReconstructionImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::ClosingByReconstructionImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::SetPreserveIntensities "/**
Self& itk::simple::ClosingByReconstructionImageFilter::SetPreserveIntensities(bool PreserveIntensities)

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstrcution. If Off, the
output pixel contrast will be reduced.

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::ToString "/**
std::string itk::simple::ClosingByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ClosingByReconstructionImageFilter::~ClosingByReconstructionImageFilter "/**
itk::simple::ClosingByReconstructionImageFilter::~ClosingByReconstructionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CollidingFrontsImageFilter "/**

Selects a region of space where two independent fronts run towards
each other.


The filter can be used to quickly segment anatomical structures (e.g.
for level set initialization).

The filter uses two instances of FastMarchingUpwindGradientImageFilter to compute the gradients of arrival times of two wavefronts
propagating from two sets of seeds. The input of the filter is used as
the speed of the two wavefronts. The output is the dot product between
the two gradient vector fields.

The filter works on the following basic idea. In the regions where the
dot product between the two gradient fields is negative, the two
fronts propagate in opposite directions. In the regions where the dot
product is positive, the two fronts propagate in the same direction.
This can be used to extract the region of space between two sets of
points.

If StopOnTargets is On, then each front will stop as soon as all seeds
of the other front have been reached. This can markedly speed up the
execution of the filter, since wave propagation does not take place on
the complete image.

Optionally, a connectivity criterion can be applied to the resulting
dot product image. In this case, the only negative region in the
output image is the one connected to the seeds.


Luca Antiga Ph.D. Biomedical Technologies Laboratory, Bioengineering
Department, Mario Negri Institute, Italy.

See:
 itk::simple::CollidingFronts for the procedural interface

 itk::CollidingFrontsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCollidingFrontsImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::AddSeedPoint1 "/**
Self& itk::simple::CollidingFrontsImageFilter::AddSeedPoint1(const std::vector< unsigned int > &point)

Add SeedPoints1 point.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::AddSeedPoint2 "/**
Self& itk::simple::CollidingFrontsImageFilter::AddSeedPoint2(const std::vector< unsigned int > &point)

Add SeedPoints2 point.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::ApplyConnectivityOff "/**
Self& itk::simple::CollidingFrontsImageFilter::ApplyConnectivityOff()
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::ApplyConnectivityOn "/**
Self& itk::simple::CollidingFrontsImageFilter::ApplyConnectivityOn()

Set the value of ApplyConnectivity to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::ClearSeedPoints1 "/**
Self& itk::simple::CollidingFrontsImageFilter::ClearSeedPoints1()

Remove all SeedPoints1 points.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::ClearSeedPoints2 "/**
Self& itk::simple::CollidingFrontsImageFilter::ClearSeedPoints2()

Remove all SeedPoints2 points.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::CollidingFrontsImageFilter "/**
itk::simple::CollidingFrontsImageFilter::CollidingFrontsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::Execute "/**
Image itk::simple::CollidingFrontsImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::Execute "/**
Image itk::simple::CollidingFrontsImageFilter::Execute(const Image &image1, const std::vector< std::vector< unsigned int > >
&seedPoints1, const std::vector< std::vector< unsigned int > >
&seedPoints2, bool applyConnectivity, double negativeEpsilon, bool
stopOnTargets)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::GetApplyConnectivity "/**
bool itk::simple::CollidingFrontsImageFilter::GetApplyConnectivity() const
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::GetName "/**
std::string itk::simple::CollidingFrontsImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::GetNegativeEpsilon "/**
double itk::simple::CollidingFrontsImageFilter::GetNegativeEpsilon() const
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::GetSeedPoints1 "/**
std::vector< std::vector<unsigned int> > itk::simple::CollidingFrontsImageFilter::GetSeedPoints1() const

Get the container of Seed Points representing the first initial front.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::GetSeedPoints2 "/**
std::vector< std::vector<unsigned int> > itk::simple::CollidingFrontsImageFilter::GetSeedPoints2() const

Get the container of Seed Points representing the second initial
front.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::GetStopOnTargets "/**
bool itk::simple::CollidingFrontsImageFilter::GetStopOnTargets() const
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::SetApplyConnectivity "/**
Self& itk::simple::CollidingFrontsImageFilter::SetApplyConnectivity(bool ApplyConnectivity)
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::SetNegativeEpsilon "/**
Self& itk::simple::CollidingFrontsImageFilter::SetNegativeEpsilon(double NegativeEpsilon)
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::SetSeedPoints1 "/**
Self& itk::simple::CollidingFrontsImageFilter::SetSeedPoints1(const std::vector< std::vector< unsigned int > > &SeedPoints1)

Set the container of Seed Points representing the first initial front.
Seed points are represented as a VectorContainer of LevelSetNodes.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::SetSeedPoints2 "/**
Self& itk::simple::CollidingFrontsImageFilter::SetSeedPoints2(const std::vector< std::vector< unsigned int > > &SeedPoints2)

Set the container of Seed Points representing the second initial
front. Seed points are represented as a VectorContainer of LevelSetNodes.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::SetStopOnTargets "/**
Self& itk::simple::CollidingFrontsImageFilter::SetStopOnTargets(bool StopOnTargets)
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::StopOnTargetsOff "/**
Self& itk::simple::CollidingFrontsImageFilter::StopOnTargetsOff()
*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::StopOnTargetsOn "/**
Self& itk::simple::CollidingFrontsImageFilter::StopOnTargetsOn()

Set the value of StopOnTargets to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::ToString "/**
std::string itk::simple::CollidingFrontsImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CollidingFrontsImageFilter::~CollidingFrontsImageFilter "/**
itk::simple::CollidingFrontsImageFilter::~CollidingFrontsImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::Command "/**

An implementation of the Command design pattern for callback.


This class provides a callback mechanism for event that occur from the ProcessObject. These commands can be utilized to observe these events.

The Command can be created on the stack, and will automatically unregistered it's
self when destroyed.

For more information see the page Commands and Events for SimpleITK.

C++ includes: sitkCommand.h
*/"

%javamethodmodifiers  itk::simple::Command::Command "/**
itk::simple::Command::Command()

Default Constructor.

*/
public ";

%javamethodmodifiers  itk::simple::Command::Execute "/**
virtual void itk::simple::Command::Execute(void)

The method that defines action to be taken by the command

*/
public ";

%javamethodmodifiers  itk::simple::Command::GetName "/**
virtual std::string itk::simple::Command::GetName() const

Set/Get Command Name

*/
public ";

%javamethodmodifiers  itk::simple::Command::SetName "/**
virtual void itk::simple::Command::SetName(const std::string &name)
*/
public ";

%javamethodmodifiers  itk::simple::Command::~Command "/**
virtual itk::simple::Command::~Command(void)

Destructor.

*/
public ";


%typemap(javaimports) itk::simple::ComplexToImaginaryImageFilter "/**

Computes pixel-wise the imaginary part of a complex image.



See:
 itk::simple::ComplexToImaginary for the procedural interface

 itk::ComplexToImaginaryImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkComplexToImaginaryImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ComplexToImaginaryImageFilter::ComplexToImaginaryImageFilter "/**
itk::simple::ComplexToImaginaryImageFilter::ComplexToImaginaryImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToImaginaryImageFilter::Execute "/**
Image itk::simple::ComplexToImaginaryImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToImaginaryImageFilter::GetName "/**
std::string itk::simple::ComplexToImaginaryImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToImaginaryImageFilter::ToString "/**
std::string itk::simple::ComplexToImaginaryImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToImaginaryImageFilter::~ComplexToImaginaryImageFilter "/**
itk::simple::ComplexToImaginaryImageFilter::~ComplexToImaginaryImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ComplexToModulusImageFilter "/**

Computes pixel-wise the Modulus of a complex image.



See:
 itk::simple::ComplexToModulus for the procedural interface

 itk::ComplexToModulusImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkComplexToModulusImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ComplexToModulusImageFilter::ComplexToModulusImageFilter "/**
itk::simple::ComplexToModulusImageFilter::ComplexToModulusImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToModulusImageFilter::Execute "/**
Image itk::simple::ComplexToModulusImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToModulusImageFilter::GetName "/**
std::string itk::simple::ComplexToModulusImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToModulusImageFilter::ToString "/**
std::string itk::simple::ComplexToModulusImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToModulusImageFilter::~ComplexToModulusImageFilter "/**
itk::simple::ComplexToModulusImageFilter::~ComplexToModulusImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ComplexToPhaseImageFilter "/**

Computes pixel-wise the modulus of a complex image.



See:
 itk::simple::ComplexToPhase for the procedural interface

 itk::ComplexToPhaseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkComplexToPhaseImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ComplexToPhaseImageFilter::ComplexToPhaseImageFilter "/**
itk::simple::ComplexToPhaseImageFilter::ComplexToPhaseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToPhaseImageFilter::Execute "/**
Image itk::simple::ComplexToPhaseImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToPhaseImageFilter::GetName "/**
std::string itk::simple::ComplexToPhaseImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToPhaseImageFilter::ToString "/**
std::string itk::simple::ComplexToPhaseImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToPhaseImageFilter::~ComplexToPhaseImageFilter "/**
itk::simple::ComplexToPhaseImageFilter::~ComplexToPhaseImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ComplexToRealImageFilter "/**

Computes pixel-wise the real(x) part of a complex image.



See:
 itk::simple::ComplexToReal for the procedural interface

 itk::ComplexToRealImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkComplexToRealImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ComplexToRealImageFilter::ComplexToRealImageFilter "/**
itk::simple::ComplexToRealImageFilter::ComplexToRealImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToRealImageFilter::Execute "/**
Image itk::simple::ComplexToRealImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToRealImageFilter::GetName "/**
std::string itk::simple::ComplexToRealImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToRealImageFilter::ToString "/**
std::string itk::simple::ComplexToRealImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ComplexToRealImageFilter::~ComplexToRealImageFilter "/**
itk::simple::ComplexToRealImageFilter::~ComplexToRealImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ComposeImageFilter "/**

ComposeImageFilter combine several scalar images into a multicomponent image.


ComposeImageFilter combine several scalar images into an itk::Image of vector pixel ( itk::Vector , itk::RGBPixel , ...), of std::complex pixel, or in an itk::VectorImage .

Inputs and Usage
 All input images are expected to have the same template parameters
and have the same size and origin.

See:
 VectorImage

 VectorIndexSelectionCastImageFilter
Wiki Examples:

All Examples

Create a vector image from a collection of scalar images

Compose a vector image (with 3 components) from three scalar images

Convert a real image and an imaginary image to a complex image

See:
 itk::simple::Compose for the procedural interface


C++ includes: sitkComposeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ComposeImageFilter::ComposeImageFilter "/**
itk::simple::ComposeImageFilter::ComposeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::Execute "/**
Image itk::simple::ComposeImageFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::Execute "/**
Image itk::simple::ComposeImageFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::Execute "/**
Image itk::simple::ComposeImageFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::Execute "/**
Image itk::simple::ComposeImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::Execute "/**
Image itk::simple::ComposeImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::Execute "/**
Image itk::simple::ComposeImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::GetName "/**
std::string itk::simple::ComposeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::ToString "/**
std::string itk::simple::ComposeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ComposeImageFilter::~ComposeImageFilter "/**
itk::simple::ComposeImageFilter::~ComposeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ConfidenceConnectedImageFilter "/**

Segment pixels with similar statistics using connectivity.


This filter extracts a connected set of pixels whose pixel intensities
are consistent with the pixel statistics of a seed point. The mean and
variance across a neighborhood (8-connected, 26-connected, etc.) are
calculated for a seed point. Then pixels connected to this seed point
whose values are within the confidence interval for the seed point are
grouped. The width of the confidence interval is controlled by the
\"Multiplier\" variable (the confidence interval is the mean plus or
minus the \"Multiplier\" times the standard deviation). If the
intensity variations across a segment were gaussian, a \"Multiplier\"
setting of 2.5 would define a confidence interval wide enough to
capture 99% of samples in the segment.

After this initial segmentation is calculated, the mean and variance
are re-calculated. All the pixels in the previous segmentation are
used to calculate the mean the standard deviation (as opposed to using
the pixels in the neighborhood of the seed point). The segmentation is
then recalculated using these refined estimates for the mean and
variance of the pixel values. This process is repeated for the
specified number of iterations. Setting the \"NumberOfIterations\" to
zero stops the algorithm after the initial segmentation from the seed
point.

NOTE: the lower and upper threshold are restricted to lie within the
valid numeric limits of the input data pixel type. Also, the limits
may be adjusted to contain the seed point's intensity.

Wiki Examples:

All Examples

Segment pixels with similar statistics using connectivity
See:
 itk::simple::ConfidenceConnected for the procedural interface

 itk::ConfidenceConnectedImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkConfidenceConnectedImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::AddSeed "/**
Self& itk::simple::ConfidenceConnectedImageFilter::AddSeed(const std::vector< unsigned int > &idx)

AddSeed - Add a seed to the end of the list

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::ClearSeeds "/**
Self& itk::simple::ConfidenceConnectedImageFilter::ClearSeeds()

ClearSeeds - Clear out all seeds in the list

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::ConfidenceConnectedImageFilter "/**
itk::simple::ConfidenceConnectedImageFilter::ConfidenceConnectedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::Execute "/**
Image itk::simple::ConfidenceConnectedImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::Execute "/**
Image itk::simple::ConfidenceConnectedImageFilter::Execute(const Image &image1, const std::vector< std::vector< unsigned int > >
&seedList, unsigned int numberOfIterations, double multiplier,
unsigned int initialNeighborhoodRadius, uint8_t replaceValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetInitialNeighborhoodRadius "/**
unsigned int itk::simple::ConfidenceConnectedImageFilter::GetInitialNeighborhoodRadius() const

Get/Set the radius of the neighborhood over which the statistics are
evaluated

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetMean "/**
double itk::simple::ConfidenceConnectedImageFilter::GetMean() const

Method to get access to the mean of the pixels accepted in the output
region. This method should only be invoked after the filter has been
executed using the Update() method.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetMultiplier "/**
double itk::simple::ConfidenceConnectedImageFilter::GetMultiplier() const

Set/Get the multiplier to define the confidence interval. Multiplier
can be anything greater than zero. A typical value is 2.5

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetName "/**
std::string itk::simple::ConfidenceConnectedImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetNumberOfIterations "/**
unsigned int itk::simple::ConfidenceConnectedImageFilter::GetNumberOfIterations() const

Set/Get the number of iterations

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetReplaceValue "/**
uint8_t itk::simple::ConfidenceConnectedImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetSeedList "/**
std::vector< std::vector<unsigned int> > itk::simple::ConfidenceConnectedImageFilter::GetSeedList() const

Get SeedList

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::GetVariance "/**
double itk::simple::ConfidenceConnectedImageFilter::GetVariance() const

Method to get access to the variance of the pixels accepted in the
output region. This method should only be invoked after the filter has
been executed using the Update() method.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::SetInitialNeighborhoodRadius "/**
Self& itk::simple::ConfidenceConnectedImageFilter::SetInitialNeighborhoodRadius(unsigned int InitialNeighborhoodRadius)

Get/Set the radius of the neighborhood over which the statistics are
evaluated

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::SetMultiplier "/**
Self& itk::simple::ConfidenceConnectedImageFilter::SetMultiplier(double Multiplier)

Set/Get the multiplier to define the confidence interval. Multiplier
can be anything greater than zero. A typical value is 2.5

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::SetNumberOfIterations "/**
Self& itk::simple::ConfidenceConnectedImageFilter::SetNumberOfIterations(unsigned int NumberOfIterations)

Set/Get the number of iterations

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::SetReplaceValue "/**
Self& itk::simple::ConfidenceConnectedImageFilter::SetReplaceValue(uint8_t ReplaceValue)

Set/Get value to replace thresholded pixels

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::SetSeed "/**
Self& itk::simple::ConfidenceConnectedImageFilter::SetSeed(const std::vector< unsigned int > &idx)

SetSeed - Set list to a single seed

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::SetSeedList "/**
Self& itk::simple::ConfidenceConnectedImageFilter::SetSeedList(const std::vector< std::vector< unsigned int > > &t)

Set SeedList

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::ToString "/**
std::string itk::simple::ConfidenceConnectedImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ConfidenceConnectedImageFilter::~ConfidenceConnectedImageFilter "/**
itk::simple::ConfidenceConnectedImageFilter::~ConfidenceConnectedImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ConnectedComponentImageFilter "/**

Label the objects in a binary image.


ConnectedComponentImageFilter labels the objects in a binary image (non-zero pixels are considered
to be objects, zero-valued pixels are considered to be background).
Each distinct object is assigned a unique label. The filter
experiments with some improvements to the existing implementation, and
is based on run length encoding along raster lines. The final object
labels start with 1 and are consecutive. Objects that are reached
earlier by a raster order scan have a lower label. This is different
to the behaviour of the original connected component image filter
which did not produce consecutive labels or impose any particular
ordering.

After the filter is executed, ObjectCount holds the number of
connected components.


See:
 ImageToImageFilter
Wiki Examples:

All Examples

Label connected components in a binary image
See:
 itk::simple::ConnectedComponent for the procedural interface

 itk::ConnectedComponentImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkConnectedComponentImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::ConnectedComponentImageFilter "/**
itk::simple::ConnectedComponentImageFilter::ConnectedComponentImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::Execute "/**
Image itk::simple::ConnectedComponentImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::Execute "/**
Image itk::simple::ConnectedComponentImageFilter::Execute(const Image &image1, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::FullyConnectedOff "/**
Self& itk::simple::ConnectedComponentImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::FullyConnectedOn "/**
Self& itk::simple::ConnectedComponentImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::GetFullyConnected "/**
bool itk::simple::ConnectedComponentImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::GetName "/**
std::string itk::simple::ConnectedComponentImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::GetObjectCount "/**
uint32_t itk::simple::ConnectedComponentImageFilter::GetObjectCount() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::SetFullyConnected "/**
Self& itk::simple::ConnectedComponentImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::ToString "/**
std::string itk::simple::ConnectedComponentImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedComponentImageFilter::~ConnectedComponentImageFilter "/**
itk::simple::ConnectedComponentImageFilter::~ConnectedComponentImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ConnectedThresholdImageFilter "/**

Label pixels that are connected to a seed and lie within a range of
values.


ConnectedThresholdImageFilter labels pixels with ReplaceValue that are connected to an initial Seed
AND lie within a Lower and Upper threshold range.
See:
 itk::simple::ConnectedThreshold for the procedural interface

 itk::ConnectedThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkConnectedThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::AddSeed "/**
Self& itk::simple::ConnectedThresholdImageFilter::AddSeed(const std::vector< unsigned int > &idx)

AddSeed - Add a seed to the end of the list

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::ClearSeeds "/**
Self& itk::simple::ConnectedThresholdImageFilter::ClearSeeds()

ClearSeeds - Clear out all seeds in the list

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::ConnectedThresholdImageFilter "/**
itk::simple::ConnectedThresholdImageFilter::ConnectedThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::Execute "/**
Image itk::simple::ConnectedThresholdImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::Execute "/**
Image itk::simple::ConnectedThresholdImageFilter::Execute(const Image &image1, const std::vector< std::vector< unsigned int > >
&seedList, double lower, double upper, uint8_t replaceValue,
ConnectedThresholdImageFilter::ConnectivityType connectivity)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::GetConnectivity "/**
ConnectivityType itk::simple::ConnectedThresholdImageFilter::GetConnectivity() const

Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND)
connectivity).

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::GetLower "/**
double itk::simple::ConnectedThresholdImageFilter::GetLower() const

Get Upper and Lower Threshold inputs as values.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::GetName "/**
std::string itk::simple::ConnectedThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::GetReplaceValue "/**
uint8_t itk::simple::ConnectedThresholdImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::GetSeedList "/**
std::vector< std::vector<unsigned int> > itk::simple::ConnectedThresholdImageFilter::GetSeedList() const

Get SeedList

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::GetUpper "/**
double itk::simple::ConnectedThresholdImageFilter::GetUpper() const

Get Upper and Lower Threshold inputs as values.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::SetConnectivity "/**
Self& itk::simple::ConnectedThresholdImageFilter::SetConnectivity(ConnectivityType Connectivity)

Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND)
connectivity).

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::SetLower "/**
Self& itk::simple::ConnectedThresholdImageFilter::SetLower(double Lower)

Set Upper and Lower Threshold inputs as values

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::SetReplaceValue "/**
Self& itk::simple::ConnectedThresholdImageFilter::SetReplaceValue(uint8_t ReplaceValue)

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::SetSeed "/**
Self& itk::simple::ConnectedThresholdImageFilter::SetSeed(const std::vector< unsigned int > &idx)

SetSeed - Set list to a single seed

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::SetSeedList "/**
Self& itk::simple::ConnectedThresholdImageFilter::SetSeedList(const std::vector< std::vector< unsigned int > > &t)

Set SeedList

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::SetUpper "/**
Self& itk::simple::ConnectedThresholdImageFilter::SetUpper(double Upper)

Set Upper and Lower Threshold inputs as values

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::ToString "/**
std::string itk::simple::ConnectedThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ConnectedThresholdImageFilter::~ConnectedThresholdImageFilter "/**
itk::simple::ConnectedThresholdImageFilter::~ConnectedThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ConstantPadImageFilter "/**

Increase the image size by padding with a constant value.


ConstantPadImageFilter changes the output image region. If the output image region is larger
than the input image region, the extra pixels are filled in by a
constant value. The output image region must be specified.

Visual explanation of padding regions. This filter is implemented as a
multithreaded filter. It provides a ThreadedGenerateData() method for
its implementation.


See:
 WrapPadImageFilter , MirrorPadImageFilter
Wiki Examples:

All Examples

Pad an image with a constant value
See:
 itk::simple::ConstantPad for the procedural interface

 itk::ConstantPadImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkConstantPadImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::ConstantPadImageFilter "/**
itk::simple::ConstantPadImageFilter::ConstantPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::Execute "/**
Image itk::simple::ConstantPadImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::Execute "/**
Image itk::simple::ConstantPadImageFilter::Execute(const Image &image1, const std::vector< unsigned int >
&padLowerBound, const std::vector< unsigned int > &padUpperBound,
double constant)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::GetConstant "/**
double itk::simple::ConstantPadImageFilter::GetConstant() const

Set/Get the pad value. Default is Zero.

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::GetName "/**
std::string itk::simple::ConstantPadImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::GetPadLowerBound "/**
std::vector<unsigned int> itk::simple::ConstantPadImageFilter::GetPadLowerBound() const
*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::GetPadUpperBound "/**
std::vector<unsigned int> itk::simple::ConstantPadImageFilter::GetPadUpperBound() const
*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::SetConstant "/**
Self& itk::simple::ConstantPadImageFilter::SetConstant(double Constant)

Set/Get the pad value. Default is Zero.

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::SetPadLowerBound "/**
Self& itk::simple::ConstantPadImageFilter::SetPadLowerBound(const std::vector< unsigned int > &PadLowerBound)
*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::SetPadUpperBound "/**
Self& itk::simple::ConstantPadImageFilter::SetPadUpperBound(const std::vector< unsigned int > &PadUpperBound)
*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::ToString "/**
std::string itk::simple::ConstantPadImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ConstantPadImageFilter::~ConstantPadImageFilter "/**
itk::simple::ConstantPadImageFilter::~ConstantPadImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ConvolutionImageFilter "/**

Convolve a given image with an arbitrary image kernel.


This filter operates by centering the flipped kernel at each pixel in
the image and computing the inner product between pixel values in the
image and pixel values in the kernel. The center of the kernel is
defined as $ \\\\lfloor (2*i+s-1)/2 \\\\rfloor $ where $i$ is the index and $s$ is the size of the largest possible region of the kernel image. For
kernels with odd sizes in all dimensions, this corresponds to the
center pixel. If a dimension of the kernel image has an even size,
then the center index of the kernel in that dimension will be the
largest integral index that is less than the continuous index of the
image center.

The kernel can optionally be normalized to sum to 1 using NormalizeOn() . Normalization is off by default.


WARNING:
This filter ignores the spacing, origin, and orientation of the kernel
image and treats them as identical to those in the input image.
 This code was contributed in the Insight Journal paper:

\"Image Kernel Convolution\" by Tustison N., Gee J. https://hdl.handle.net/1926/1323 http://www.insight-journal.org/browse/publication/208


Nicholas J. Tustison
 James C. Gee

Wiki Examples:

All Examples

Convolve an image with a kernel
See:
 itk::simple::Convolution for the procedural interface

 itk::ConvolutionImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkConvolutionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::ConvolutionImageFilter "/**
itk::simple::ConvolutionImageFilter::ConvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::Execute "/**
Image itk::simple::ConvolutionImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::Execute "/**
Image itk::simple::ConvolutionImageFilter::Execute(const Image &image1, const Image &image2, bool normalize,
ConvolutionImageFilter::BoundaryConditionType boundaryCondition,
ConvolutionImageFilter::OutputRegionModeType outputRegionMode)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::GetBoundaryCondition "/**
BoundaryConditionType itk::simple::ConvolutionImageFilter::GetBoundaryCondition() const
*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::GetName "/**
std::string itk::simple::ConvolutionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::GetNormalize "/**
bool itk::simple::ConvolutionImageFilter::GetNormalize() const
*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::GetOutputRegionMode "/**
OutputRegionModeType itk::simple::ConvolutionImageFilter::GetOutputRegionMode() const
*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::NormalizeOff "/**
Self& itk::simple::ConvolutionImageFilter::NormalizeOff()
*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::NormalizeOn "/**
Self& itk::simple::ConvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::SetBoundaryCondition "/**
Self& itk::simple::ConvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::SetNormalize "/**
Self& itk::simple::ConvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::SetOutputRegionMode "/**
Self& itk::simple::ConvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::ToString "/**
std::string itk::simple::ConvolutionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ConvolutionImageFilter::~ConvolutionImageFilter "/**
itk::simple::ConvolutionImageFilter::~ConvolutionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CosImageFilter "/**

Computes the cosine of each pixel.


This filter is templated over the pixel type of the input image and
the pixel type of the output image.

The filter walks over all of the pixels in the input image, and for
each pixel does the following:


cast the pixel value to double ,

apply the std::cos() function to the double value,

cast the double value resulting from std::cos() to the pixel type of
the output image,

store the cast value into the output image.
 The filter expects both images to have the same dimension (e.g. both
2D, or both 3D, or both ND)
See:
 itk::simple::Cos for the procedural interface

 itk::CosImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCosImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CosImageFilter::CosImageFilter "/**
itk::simple::CosImageFilter::CosImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CosImageFilter::Execute "/**
Image itk::simple::CosImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CosImageFilter::GetName "/**
std::string itk::simple::CosImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CosImageFilter::ToString "/**
std::string itk::simple::CosImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CosImageFilter::~CosImageFilter "/**
itk::simple::CosImageFilter::~CosImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CropImageFilter "/**

Decrease the image size by cropping the image by an itk::Size at both the upper and lower bounds of the largest possible region.


CropImageFilter changes the image boundary of an image by removing pixels outside the
target region. The target region is not specified in advance, but
calculated in BeforeThreadedGenerateData() .

This filter uses ExtractImageFilter to perform the cropping.

Wiki Examples:

All Examples

Crop an image by specifying the region to throw away
See:
 itk::simple::Crop for the procedural interface

 itk::CropImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkCropImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CropImageFilter::CropImageFilter "/**
itk::simple::CropImageFilter::CropImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::Execute "/**
Image itk::simple::CropImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::Execute "/**
Image itk::simple::CropImageFilter::Execute(const Image &image1, const std::vector< unsigned int >
&lowerBoundaryCropSize, const std::vector< unsigned int >
&upperBoundaryCropSize)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::GetLowerBoundaryCropSize "/**
std::vector<unsigned int> itk::simple::CropImageFilter::GetLowerBoundaryCropSize() const

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::GetName "/**
std::string itk::simple::CropImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::GetUpperBoundaryCropSize "/**
std::vector<unsigned int> itk::simple::CropImageFilter::GetUpperBoundaryCropSize() const

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::SetLowerBoundaryCropSize "/**
Self& itk::simple::CropImageFilter::SetLowerBoundaryCropSize(const std::vector< unsigned int > &LowerBoundaryCropSize)

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::SetUpperBoundaryCropSize "/**
Self& itk::simple::CropImageFilter::SetUpperBoundaryCropSize(const std::vector< unsigned int > &UpperBoundaryCropSize)

Set/Get the cropping sizes for the upper and lower boundaries.

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::ToString "/**
std::string itk::simple::CropImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CropImageFilter::~CropImageFilter "/**
itk::simple::CropImageFilter::~CropImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CurvatureAnisotropicDiffusionImageFilter "/**

This filter performs anisotropic diffusion on a scalar itk::Image using the modified curvature diffusion equation (MCDE) implemented in
itkCurvatureNDAnisotropicDiffusionFunction. For detailed information
on anisotropic diffusion and the MCDE see
itkAnisotropicDiffusionFunction and
itkCurvatureNDAnisotropicDiffusionFunction.

Inputs and Outputs
The input and output to this filter must be a scalar itk::Image with numerical pixel types (float or double). A user defined type
which correctly defines arithmetic operations with floating point
accuracy should also give correct results.
Parameters
Please first read all the documentation found in AnisotropicDiffusionImageFilter and AnisotropicDiffusionFunction . Also see CurvatureNDAnisotropicDiffusionFunction .
 The default time step for this filter is set to the maximum
theoretically stable value: 0.5 / 2^N, where N is the dimensionality
of the image. For a 2D image, this means valid time steps are below
0.1250. For a 3D image, valid time steps are below 0.0625.


See:
 AnisotropicDiffusionImageFilter

 AnisotropicDiffusionFunction

 CurvatureNDAnisotropicDiffusionFunction

 itk::simple::CurvatureAnisotropicDiffusion for the procedural interface

 itk::CurvatureAnisotropicDiffusionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCurvatureAnisotropicDiffusionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::CurvatureAnisotropicDiffusionImageFilter "/**
itk::simple::CurvatureAnisotropicDiffusionImageFilter::CurvatureAnisotropicDiffusionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep "/**
double itk::simple::CurvatureAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep(Image &inImage)

This method autmatically sets the optimal timestep for an image given
its spacing.

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::Execute "/**
Image itk::simple::CurvatureAnisotropicDiffusionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::Execute "/**
Image itk::simple::CurvatureAnisotropicDiffusionImageFilter::Execute(const Image &image1, double timeStep, double conductanceParameter,
unsigned int conductanceScalingUpdateInterval, uint32_t
numberOfIterations)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetConductanceParameter "/**
double itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetConductanceParameter() const
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetConductanceScalingUpdateInterval "/**
unsigned int itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetConductanceScalingUpdateInterval() const
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetName "/**
std::string itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetTimeStep "/**
double itk::simple::CurvatureAnisotropicDiffusionImageFilter::GetTimeStep() const
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetConductanceParameter "/**
Self& itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetConductanceParameter(double ConductanceParameter)
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetConductanceScalingUpdateInterval "/**
Self& itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetConductanceScalingUpdateInterval(unsigned int ConductanceScalingUpdateInterval)
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetNumberOfIterations "/**
Self& itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetTimeStep "/**
Self& itk::simple::CurvatureAnisotropicDiffusionImageFilter::SetTimeStep(double TimeStep)
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::ToString "/**
std::string itk::simple::CurvatureAnisotropicDiffusionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureAnisotropicDiffusionImageFilter::~CurvatureAnisotropicDiffusionImageFilter "/**
itk::simple::CurvatureAnisotropicDiffusionImageFilter::~CurvatureAnisotropicDiffusionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CurvatureFlowImageFilter "/**

Denoise an image using curvature driven flow.


CurvatureFlowImageFilter implements a curvature driven image denoising algorithm. Iso-
brightness contours in the grayscale input image are viewed as a level
set. The level set is then evolved using a curvature-based speed
function:

\\\\[ I_t = \\\\kappa |\\\\nabla I| \\\\] where $ \\\\kappa $ is the curvature.

The advantage of this approach is that sharp boundaries are preserved
with smoothing occurring only within a region. However, it should be
noted that continuous application of this scheme will result in the
eventual removal of all information as each contour shrinks to zero
and disappear.

Note that unlike level set segmentation algorithms, the image to be
denoised is already the level set and can be set directly as the input
using the SetInput() method.

This filter has two parameters: the number of update iterations to be
performed and the timestep between each update.

The timestep should be \"small enough\" to ensure numerical stability.
Stability is guarantee when the timestep meets the CFL (Courant-
Friedrichs-Levy) condition. Broadly speaking, this condition ensures
that each contour does not move more than one grid position at each
timestep. In the literature, the timestep is typically user specified
and have to manually tuned to the application.

This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a CurvatureFlowFunction object. A zero flux Neumann boundary condition when computing
derivatives near the data boundary.

This filter may be streamed. To support streaming this filter produces
a padded output which takes into account edge effects. The size of the
padding is m_NumberOfIterations on each edge. Users of this filter
should only make use of the center valid central region.


WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a floating point type. This filter works for any dimensional
images.
 Reference: \"Level Set Methods and Fast Marching Methods\", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.


See:
 DenseFiniteDifferenceImageFilter

 CurvatureFlowFunction

 MinMaxCurvatureFlowImageFilter

 BinaryMinMaxCurvatureFlowImageFilter

 itk::simple::CurvatureFlow for the procedural interface

 itk::CurvatureFlowImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCurvatureFlowImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::CurvatureFlowImageFilter "/**
itk::simple::CurvatureFlowImageFilter::CurvatureFlowImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::Execute "/**
Image itk::simple::CurvatureFlowImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::Execute "/**
Image itk::simple::CurvatureFlowImageFilter::Execute(const Image &image1, double timeStep, uint32_t numberOfIterations)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::GetName "/**
std::string itk::simple::CurvatureFlowImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::CurvatureFlowImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::GetTimeStep "/**
double itk::simple::CurvatureFlowImageFilter::GetTimeStep() const

Get the timestep parameter.

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::SetNumberOfIterations "/**
Self& itk::simple::CurvatureFlowImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::SetTimeStep "/**
Self& itk::simple::CurvatureFlowImageFilter::SetTimeStep(double TimeStep)

Set the timestep parameter.

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::ToString "/**
std::string itk::simple::CurvatureFlowImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CurvatureFlowImageFilter::~CurvatureFlowImageFilter "/**
itk::simple::CurvatureFlowImageFilter::~CurvatureFlowImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::CyclicShiftImageFilter "/**

Perform a cyclic spatial shift of image intensities on the image grid.


This filter supports arbitrary cyclic shifts of pixel values on the
image grid. If the Shift is set to [xOff, yOff], the value of the
pixel at [0, 0] in the input image will be the value of the pixel in
the output image at index [xOff modulo xSize, yOff modulo ySize] where
xSize and ySize are the sizes of the image in the x and y dimensions,
respectively. If a pixel value is moved across a boundary, the pixel
value is wrapped around that boundary. For example, if the image is
40-by-40 and the Shift is [13, 47], then the value of the pixel at [0,
0] in the input image will be the value of the pixel in the output
image at index [13, 7].

Negative Shifts are supported. This filter also works with images
whose largest possible region starts at a non-zero index.
See:
 itk::simple::CyclicShift for the procedural interface

 itk::CyclicShiftImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCyclicShiftImageFilter.h
*/"

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::CyclicShiftImageFilter "/**
itk::simple::CyclicShiftImageFilter::CyclicShiftImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::Execute "/**
Image itk::simple::CyclicShiftImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::Execute "/**
Image itk::simple::CyclicShiftImageFilter::Execute(const Image &image1, const std::vector< int > &shift)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::GetName "/**
std::string itk::simple::CyclicShiftImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::GetShift "/**
std::vector<int> itk::simple::CyclicShiftImageFilter::GetShift() const

Set/get the shift. Shifts may be positive or negative.

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::SetShift "/**
Self& itk::simple::CyclicShiftImageFilter::SetShift(const std::vector< int > &Shift)

Set/get the shift. Shifts may be positive or negative.

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::SetShift "/**
Self& itk::simple::CyclicShiftImageFilter::SetShift(int value)

Set the values of the Shift vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::ToString "/**
std::string itk::simple::CyclicShiftImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::CyclicShiftImageFilter::~CyclicShiftImageFilter "/**
itk::simple::CyclicShiftImageFilter::~CyclicShiftImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DanielssonDistanceMapImageFilter "/**

This filter computes the distance map of the input image as an
approximation with pixel accuracy to the Euclidean distance.


TInputImage

Input Image Type

TOutputImage

Output Image Type

TVoronoiImage

Voronoi Image Type. Note the default value is TInputImage.

The input is assumed to contain numeric codes defining objects. The
filter will produce as output the following images:


A Voronoi partition using the same numeric codes as the input.

A distance map with the approximation to the euclidean distance. from
a particular pixel to the nearest object to this pixel in the input
image.

A vector map containing the component of the vector relating the
current pixel with the closest point of the closest object to this
pixel. Given that the components of the distance are computed in
\"pixels\", the vector is represented by an itk::Offset . That is, physical coordinates are not used.
 This filter is N-dimensional and known to be efficient in
computational time. The algorithm is the N-dimensional version of the
4SED algorithm given for two dimensions in:

Danielsson, Per-Erik. Euclidean Distance Mapping. Computer Graphics
and Image Processing 14, 227-248 (1980).
See:
 itk::simple::DanielssonDistanceMap for the procedural interface

 itk::DanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDanielssonDistanceMapImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::DanielssonDistanceMapImageFilter "/**
itk::simple::DanielssonDistanceMapImageFilter::DanielssonDistanceMapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::Execute "/**
Image itk::simple::DanielssonDistanceMapImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::Execute "/**
Image itk::simple::DanielssonDistanceMapImageFilter::Execute(const Image &image1, bool inputIsBinary, bool squaredDistance, bool
useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::GetInputIsBinary "/**
bool itk::simple::DanielssonDistanceMapImageFilter::GetInputIsBinary() const

Get if the input is binary. See SetInputIsBinary() .

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::GetName "/**
std::string itk::simple::DanielssonDistanceMapImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::GetSquaredDistance "/**
bool itk::simple::DanielssonDistanceMapImageFilter::GetSquaredDistance() const

Get the distance squared.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::GetUseImageSpacing "/**
bool itk::simple::DanielssonDistanceMapImageFilter::GetUseImageSpacing() const

Get whether spacing is used.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::InputIsBinaryOff "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::InputIsBinaryOff()
*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::InputIsBinaryOn "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::InputIsBinaryOn()

Set the value of InputIsBinary to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::SetInputIsBinary "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::SetInputIsBinary(bool InputIsBinary)

Set if the input is binary. If this variable is set, each nonzero
pixel in the input image will be given a unique numeric code to be
used by the Voronoi partition. If the image is binary but you are not
interested in the Voronoi regions of the different nonzero pixels,
then you need not set this.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::SetSquaredDistance "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::SetSquaredDistance(bool SquaredDistance)

Set if the distance should be squared.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::SetUseImageSpacing "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set if image spacing should be used in computing distances.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::SquaredDistanceOff "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::SquaredDistanceOff()
*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::SquaredDistanceOn "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::SquaredDistanceOn()

Set the value of SquaredDistance to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::ToString "/**
std::string itk::simple::DanielssonDistanceMapImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::UseImageSpacingOff "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::UseImageSpacingOn "/**
Self& itk::simple::DanielssonDistanceMapImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DanielssonDistanceMapImageFilter::~DanielssonDistanceMapImageFilter "/**
itk::simple::DanielssonDistanceMapImageFilter::~DanielssonDistanceMapImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DemonsRegistrationFilter "/**

Deformably register two images using the demons algorithm.


DemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the displacement field which will map a moving image onto
a fixed image.

A displacement field is represented as a image whose pixel type is
some vector type with at least N elements, where N is the dimension of
the fixed image. The vector type must support element access via
operator []. It is assumed that the vector elements behave like
floating point scalars.

This class is templated over the fixed image type, moving image type
and the displacement field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial displacement field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The algorithm has one parameters: the number of iteration to be
performed.

The output displacement field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


WARNING:
This filter assumes that the fixed image type, moving image type and
displacement field type all have the same number of dimensions.

See:
 DemonsRegistrationFunction

 itk::DemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkDemonsRegistrationFilter.h
*/"

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::DemonsRegistrationFilter "/**
itk::simple::DemonsRegistrationFilter::DemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::Execute "/**
Image itk::simple::DemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&initialDisplacementField)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::Execute "/**
Image itk::simple::DemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage)
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::Execute "/**
Image itk::simple::DemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&initialDisplacementField, const std::vector< double >
&standardDeviations, uint32_t numberOfIterations, double
maximumRMSError, bool useMovingImageGradient, bool
smoothDisplacementField, bool smoothUpdateField, const std::vector<
double > &updateFieldStandardDeviations, unsigned int
maximumKernelWidth, double maximumError, double
intensityDifferenceThreshold, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::Execute "/**
Image itk::simple::DemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const std::vector<
double > &standardDeviations, uint32_t numberOfIterations, double
maximumRMSError, bool useMovingImageGradient, bool
smoothDisplacementField, bool smoothUpdateField, const std::vector<
double > &updateFieldStandardDeviations, unsigned int
maximumKernelWidth, double maximumError, double
intensityDifferenceThreshold, bool useImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetElapsedIterations "/**
uint32_t itk::simple::DemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetIntensityDifferenceThreshold "/**
double itk::simple::DemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetMaximumError "/**
double itk::simple::DemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetMaximumKernelWidth "/**
unsigned int itk::simple::DemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetMaximumRMSError "/**
double itk::simple::DemonsRegistrationFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetMetric "/**
double itk::simple::DemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the the overlapping region between the two images. This
is value is only available for the previous iteration and NOT the
current iteration.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetName "/**
std::string itk::simple::DemonsRegistrationFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetNumberOfIterations "/**
uint32_t itk::simple::DemonsRegistrationFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetRMSChange "/**
double itk::simple::DemonsRegistrationFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetSmoothDisplacementField "/**
bool itk::simple::DemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetSmoothUpdateField "/**
bool itk::simple::DemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetStandardDeviations "/**
std::vector<double> itk::simple::DemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetUpdateFieldStandardDeviations "/**
std::vector<double> itk::simple::DemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetUseImageSpacing "/**
bool itk::simple::DemonsRegistrationFilter::GetUseImageSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::GetUseMovingImageGradient "/**
bool itk::simple::DemonsRegistrationFilter::GetUseMovingImageGradient() const

Switch between using the fixed image and moving image gradient for
computing the displacement field updates.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetIntensityDifferenceThreshold "/**
Self& itk::simple::DemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetMaximumError "/**
Self& itk::simple::DemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetMaximumKernelWidth "/**
Self& itk::simple::DemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetMaximumRMSError "/**
Self& itk::simple::DemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetNumberOfIterations "/**
Self& itk::simple::DemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetSmoothDisplacementField "/**
Self& itk::simple::DemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetSmoothUpdateField "/**
Self& itk::simple::DemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::DemonsRegistrationFilter::SetStandardDeviations(const std::vector< double > &StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::DemonsRegistrationFilter::SetStandardDeviations(double value)

Set the values of the StandardDeviations vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::DemonsRegistrationFilter::SetUpdateFieldStandardDeviations(const std::vector< double > &UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::DemonsRegistrationFilter::SetUpdateFieldStandardDeviations(double value)

Set the values of the UpdateFieldStandardDeviations vector all to
value

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetUseImageSpacing "/**
Self& itk::simple::DemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SetUseMovingImageGradient "/**
Self& itk::simple::DemonsRegistrationFilter::SetUseMovingImageGradient(bool UseMovingImageGradient)

Switch between using the fixed image and moving image gradient for
computing the displacement field updates.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SmoothDisplacementFieldOff "/**
Self& itk::simple::DemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SmoothDisplacementFieldOn "/**
Self& itk::simple::DemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SmoothUpdateFieldOff "/**
Self& itk::simple::DemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::SmoothUpdateFieldOn "/**
Self& itk::simple::DemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::ToString "/**
std::string itk::simple::DemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::UseImageSpacingOff "/**
Self& itk::simple::DemonsRegistrationFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::UseImageSpacingOn "/**
Self& itk::simple::DemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::UseMovingImageGradientOff "/**
Self& itk::simple::DemonsRegistrationFilter::UseMovingImageGradientOff()
*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::UseMovingImageGradientOn "/**
Self& itk::simple::DemonsRegistrationFilter::UseMovingImageGradientOn()

Set the value of UseMovingImageGradient to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DemonsRegistrationFilter::~DemonsRegistrationFilter "/**
itk::simple::DemonsRegistrationFilter::~DemonsRegistrationFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DerivativeImageFilter "/**

Computes the directional derivative of an image. The directional
derivative at each pixel location is computed by convolution with a
derivative operator of user-specified order.


SetOrder specifies the order of the derivative.

SetDirection specifies the direction of the derivative with respect to
the coordinate axes of the image.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator
Wiki Examples:

All Examples

Compute the derivative of an image in a particular direction
See:
 itk::simple::Derivative for the procedural interface

 itk::DerivativeImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkDerivativeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DerivativeImageFilter::DerivativeImageFilter "/**
itk::simple::DerivativeImageFilter::DerivativeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::Execute "/**
Image itk::simple::DerivativeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::Execute "/**
Image itk::simple::DerivativeImageFilter::Execute(const Image &image1, unsigned int direction, unsigned int order, bool
useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::GetDirection "/**
unsigned int itk::simple::DerivativeImageFilter::GetDirection() const

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::GetName "/**
std::string itk::simple::DerivativeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::GetOrder "/**
unsigned int itk::simple::DerivativeImageFilter::GetOrder() const

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::GetUseImageSpacing "/**
bool itk::simple::DerivativeImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::SetDirection "/**
Self& itk::simple::DerivativeImageFilter::SetDirection(unsigned int Direction)

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::SetOrder "/**
Self& itk::simple::DerivativeImageFilter::SetOrder(unsigned int Order)

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::SetUseImageSpacing "/**
Self& itk::simple::DerivativeImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::ToString "/**
std::string itk::simple::DerivativeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::UseImageSpacingOff "/**
Self& itk::simple::DerivativeImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::UseImageSpacingOn "/**
Self& itk::simple::DerivativeImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DerivativeImageFilter::~DerivativeImageFilter "/**
itk::simple::DerivativeImageFilter::~DerivativeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DiffeomorphicDemonsRegistrationFilter "/**

Deformably register two images using a diffeomorphic demons algorithm.


This class was contributed by Tom Vercauteren, INRIA & Mauna Kea
Technologies, based on a variation of the DemonsRegistrationFilter . The basic modification is to use diffeomorphism exponentials.

See T. Vercauteren, X. Pennec, A. Perchant and N. Ayache, \"Non-
parametric Diffeomorphic Image Registration with the Demons
Algorithm\", Proc. of MICCAI 2007.

DiffeomorphicDemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the deformation field which will map a moving image onto
a fixed image.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


Tom Vercauteren, INRIA & Mauna Kea Technologies

WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/510


See:
 DemonsRegistrationFilter

 DemonsRegistrationFunction

 itk::DiffeomorphicDemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkDiffeomorphicDemonsRegistrationFilter.h
*/"

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::DiffeomorphicDemonsRegistrationFilter "/**
itk::simple::DiffeomorphicDemonsRegistrationFilter::DiffeomorphicDemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute "/**
Image itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&initialDisplacementField)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute "/**
Image itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage)
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute "/**
Image itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&initialDisplacementField, const std::vector< double >
&standardDeviations, uint32_t numberOfIterations, double
maximumRMSError,
DiffeomorphicDemonsRegistrationFilter::UseGradientTypeType
useGradientType, bool useFirstOrderExp, double
maximumUpdateStepLength, bool smoothDisplacementField, bool
smoothUpdateField, const std::vector< double >
&updateFieldStandardDeviations, unsigned int maximumKernelWidth,
double maximumError, double intensityDifferenceThreshold, bool
useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute "/**
Image itk::simple::DiffeomorphicDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const std::vector<
double > &standardDeviations, uint32_t numberOfIterations, double
maximumRMSError,
DiffeomorphicDemonsRegistrationFilter::UseGradientTypeType
useGradientType, bool useFirstOrderExp, double
maximumUpdateStepLength, bool smoothDisplacementField, bool
smoothUpdateField, const std::vector< double >
&updateFieldStandardDeviations, unsigned int maximumKernelWidth,
double maximumError, double intensityDifferenceThreshold, bool
useImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetElapsedIterations "/**
uint32_t itk::simple::DiffeomorphicDemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetIntensityDifferenceThreshold "/**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumError "/**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumKernelWidth "/**
unsigned int itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumRMSError "/**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumUpdateStepLength "/**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMaximumUpdateStepLength() const
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMetric "/**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the the overlapping region between the two images. This
value is calculated for the current iteration

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetName "/**
std::string itk::simple::DiffeomorphicDemonsRegistrationFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetNumberOfIterations "/**
uint32_t itk::simple::DiffeomorphicDemonsRegistrationFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetRMSChange "/**
double itk::simple::DiffeomorphicDemonsRegistrationFilter::GetRMSChange() const

Set/Get the root mean squared change of the previous iteration. May
not be used by all solvers.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetSmoothDisplacementField "/**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetSmoothUpdateField "/**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetStandardDeviations "/**
std::vector<double> itk::simple::DiffeomorphicDemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUpdateFieldStandardDeviations "/**
std::vector<double> itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseFirstOrderExp "/**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseFirstOrderExp() const

Use a first-order approximation of the exponential. This amounts to
using an update rule of the type s <- s o (Id + u) instead of s <- s o
exp(u)

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseGradientType "/**
UseGradientTypeType itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseGradientType() const
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseImageSpacing "/**
bool itk::simple::DiffeomorphicDemonsRegistrationFilter::GetUseImageSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetIntensityDifferenceThreshold "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumError "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumKernelWidth "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumRMSError "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumUpdateStepLength "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetMaximumUpdateStepLength(double MaximumUpdateStepLength)

Set/Get the maximum length in terms of pixels of the vectors in the
update buffer.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetNumberOfIterations "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetSmoothDisplacementField "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetSmoothUpdateField "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetStandardDeviations(const std::vector< double > &StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetStandardDeviations(double value)

Set the values of the StandardDeviations vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(const std::vector< double > &UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(double value)

Set the values of the UpdateFieldStandardDeviations vector all to
value

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseFirstOrderExp "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseFirstOrderExp(bool UseFirstOrderExp)

Use a first-order approximation of the exponential. This amounts to
using an update rule of the type s <- s o (Id + u) instead of s <- s o
exp(u)

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseGradientType "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseGradientType(UseGradientTypeType UseGradientType)
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseImageSpacing "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothDisplacementFieldOff "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothDisplacementFieldOn "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothUpdateFieldOff "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothUpdateFieldOn "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::ToString "/**
std::string itk::simple::DiffeomorphicDemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::UseFirstOrderExpOff "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::UseFirstOrderExpOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::UseFirstOrderExpOn "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::UseFirstOrderExpOn()

Set the value of UseFirstOrderExp to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::UseImageSpacingOff "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::UseImageSpacingOn "/**
Self& itk::simple::DiffeomorphicDemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiffeomorphicDemonsRegistrationFilter::~DiffeomorphicDemonsRegistrationFilter "/**
itk::simple::DiffeomorphicDemonsRegistrationFilter::~DiffeomorphicDemonsRegistrationFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DilateObjectMorphologyImageFilter "/**

dilation of an object in an image


Dilate an image using binary morphology. Pixel values matching the
object value are considered the \"foreground\" and all other pixels
are \"background\". This is useful in processing mask images
containing only one object.

If a pixel's value is equal to the object value and the pixel is
adjacent to a non-object valued pixel, then the kernel is centered on
the object-value pixel and neighboring pixels covered by the kernel
are assigned the object value. The structuring element is assumed to
be composed of binary values (zero or one).


See:
 ObjectMorphologyImageFilter , ErodeObjectMorphologyImageFilter

 BinaryDilateImageFilter

 itk::simple::DilateObjectMorphology for the procedural interface

 itk::DilateObjectMorphologyImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDilateObjectMorphologyImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::DilateObjectMorphologyImageFilter "/**
itk::simple::DilateObjectMorphologyImageFilter::DilateObjectMorphologyImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::Execute "/**
Image itk::simple::DilateObjectMorphologyImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::Execute "/**
Image itk::simple::DilateObjectMorphologyImageFilter::Execute(const Image &image1, double objectValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::DilateObjectMorphologyImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::GetKernelType "/**
KernelEnum itk::simple::DilateObjectMorphologyImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::GetName "/**
std::string itk::simple::DilateObjectMorphologyImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::GetObjectValue "/**
double itk::simple::DilateObjectMorphologyImageFilter::GetObjectValue() const
*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::SetKernelRadius "/**
Self& itk::simple::DilateObjectMorphologyImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::SetKernelRadius "/**
Self& itk::simple::DilateObjectMorphologyImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::SetKernelType "/**
Self& itk::simple::DilateObjectMorphologyImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::SetKernelType "/**
Self& itk::simple::DilateObjectMorphologyImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::SetObjectValue "/**
Self& itk::simple::DilateObjectMorphologyImageFilter::SetObjectValue(double ObjectValue)
*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::ToString "/**
std::string itk::simple::DilateObjectMorphologyImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DilateObjectMorphologyImageFilter::~DilateObjectMorphologyImageFilter "/**
itk::simple::DilateObjectMorphologyImageFilter::~DilateObjectMorphologyImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DiscreteGaussianDerivativeImageFilter "/**

Calculates image derivatives using discrete derivative gaussian
kernels. This filter calculates Gaussian derivative by separable
convolution of an image and a discrete Gaussian derivative operator
(kernel).


The Gaussian operators used here were described by Tony Lindeberg
(Discrete Scale-Space Theory and the Scale-Space Primal Sketch.
Dissertation. Royal Institute of Technology, Stockholm, Sweden. May
1991.)

The variance or standard deviation (sigma) will be evaluated as pixel
units if SetUseImageSpacing is off (false) or as physical units if
SetUseImageSpacing is on (true, default). The variance can be set
independently in each dimension.

When the Gaussian kernel is small, this filter tends to run faster
than itk::RecursiveGaussianImageFilter .


Ivan Macia, VICOMTech, Spain, http://www.vicomtech.es
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/1290


See:
 GaussianDerivativeOperator

 Image

 Neighborhood

 NeighborhoodOperator

 itk::simple::DiscreteGaussianDerivative for the procedural interface

 itk::DiscreteGaussianDerivativeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDiscreteGaussianDerivativeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::DiscreteGaussianDerivativeImageFilter "/**
itk::simple::DiscreteGaussianDerivativeImageFilter::DiscreteGaussianDerivativeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::Execute "/**
Image itk::simple::DiscreteGaussianDerivativeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::Execute "/**
Image itk::simple::DiscreteGaussianDerivativeImageFilter::Execute(const Image &image1, const std::vector< double > &variance, const
std::vector< unsigned int > &order, unsigned int maximumKernelWidth,
double maximumError, bool useImageSpacing, bool normalizeAcrossScale)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetMaximumError "/**
double itk::simple::DiscreteGaussianDerivativeImageFilter::GetMaximumError() const

The algorithm will size the discrete kernel so that the error
resulting from truncation of the kernel is no greater than
MaximumError. The default is 0.01 in each dimension.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetMaximumKernelWidth "/**
unsigned int itk::simple::DiscreteGaussianDerivativeImageFilter::GetMaximumKernelWidth() const

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetName "/**
std::string itk::simple::DiscreteGaussianDerivativeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetNormalizeAcrossScale "/**
bool itk::simple::DiscreteGaussianDerivativeImageFilter::GetNormalizeAcrossScale() const

Set/Get the flag for calculating scale-space normalized derivatives.
Normalized derivatives are obtained multiplying by the scale parameter
t.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetOrder "/**
std::vector<unsigned int> itk::simple::DiscreteGaussianDerivativeImageFilter::GetOrder() const

Order of derivatives in each dimension. Sets the derivative order
independently for each dimension, but see also SetOrder(const unsigned int v) . The default is 1 in each dimension.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetUseImageSpacing "/**
bool itk::simple::DiscreteGaussianDerivativeImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Default is ImageSpacingOn.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::GetVariance "/**
std::vector<double> itk::simple::DiscreteGaussianDerivativeImageFilter::GetVariance() const

The variance for the discrete Gaussian kernel. Sets the variance
independently for each dimension, but see also SetVariance(const double v) . The default is 0.0 in each dimension. If UseImageSpacing is true,
the units are the physical units of your image. If UseImageSpacing is
false then the units are pixels.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::NormalizeAcrossScaleOff "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::NormalizeAcrossScaleOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::NormalizeAcrossScaleOn "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetMaximumError "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetMaximumError(double MaximumError)

Convenience Set methods for setting all dimensional parameters to the
same values.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetMaximumKernelWidth "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetNormalizeAcrossScale "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

Set/Get the flag for calculating scale-space normalized derivatives.
Normalized derivatives are obtained multiplying by the scale parameter
t.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetOrder "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetOrder(const std::vector< unsigned int > &Order)

Convenience Set methods for setting all dimensional parameters to the
same values.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetOrder "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetOrder(unsigned int value)

Set the values of the Order vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetUseImageSpacing "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Default is ImageSpacingOn.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetVariance "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetVariance(const std::vector< double > &Variance)

Convenience Set methods for setting all dimensional parameters to the
same values.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::SetVariance "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::SetVariance(double value)

Set the values of the Variance vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::ToString "/**
std::string itk::simple::DiscreteGaussianDerivativeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::UseImageSpacingOff "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::UseImageSpacingOn "/**
Self& itk::simple::DiscreteGaussianDerivativeImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianDerivativeImageFilter::~DiscreteGaussianDerivativeImageFilter "/**
itk::simple::DiscreteGaussianDerivativeImageFilter::~DiscreteGaussianDerivativeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DiscreteGaussianImageFilter "/**

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


The Gaussian operator used here was described by Tony Lindeberg
(Discrete Scale-Space Theory and the Scale-Space Primal Sketch.
Dissertation. Royal Institute of Technology, Stockholm, Sweden. May
1991.) The Gaussian kernel used here was designed so that smoothing
and derivative operations commute after discretization.

The variance or standard deviation (sigma) will be evaluated as pixel
units if SetUseImageSpacing is off (false) or as physical units if
SetUseImageSpacing is on (true, default). The variance can be set
independently in each dimension.

When the Gaussian kernel is small, this filter tends to run faster
than itk::RecursiveGaussianImageFilter .


See:
 GaussianOperator

 Image

 Neighborhood

 NeighborhoodOperator

 RecursiveGaussianImageFilter
Wiki Examples:

All Examples

Smooth an image with a discrete Gaussian filter
See:
 itk::simple::DiscreteGaussian for the procedural interface

 itk::DiscreteGaussianImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkDiscreteGaussianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::DiscreteGaussianImageFilter "/**
itk::simple::DiscreteGaussianImageFilter::DiscreteGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::Execute "/**
Image itk::simple::DiscreteGaussianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::Execute "/**
Image itk::simple::DiscreteGaussianImageFilter::Execute(const Image &image1, double variance, unsigned int
maximumKernelWidth, double maximumError, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::GetMaximumError "/**
double itk::simple::DiscreteGaussianImageFilter::GetMaximumError() const

The algorithm will size the discrete kernel so that the error
resulting from truncation of the kernel is no greater than
MaximumError. The default is 0.01 in each dimension.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::GetMaximumKernelWidth "/**
unsigned int itk::simple::DiscreteGaussianImageFilter::GetMaximumKernelWidth() const

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::GetName "/**
std::string itk::simple::DiscreteGaussianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::GetUseImageSpacing "/**
bool itk::simple::DiscreteGaussianImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::GetVariance "/**
double itk::simple::DiscreteGaussianImageFilter::GetVariance() const

The variance for the discrete Gaussian kernel. Sets the variance
independently for each dimension, but see also SetVariance(const double v) . The default is 0.0 in each dimension. If UseImageSpacing is true,
the units are the physical units of your image. If UseImageSpacing is
false then the units are pixels.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::SetMaximumError "/**
Self& itk::simple::DiscreteGaussianImageFilter::SetMaximumError(double MaximumError)
*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::SetMaximumKernelWidth "/**
Self& itk::simple::DiscreteGaussianImageFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::SetUseImageSpacing "/**
Self& itk::simple::DiscreteGaussianImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::SetVariance "/**
Self& itk::simple::DiscreteGaussianImageFilter::SetVariance(double Variance)
*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::ToString "/**
std::string itk::simple::DiscreteGaussianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::UseImageSpacingOff "/**
Self& itk::simple::DiscreteGaussianImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::UseImageSpacingOn "/**
Self& itk::simple::DiscreteGaussianImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DiscreteGaussianImageFilter::~DiscreteGaussianImageFilter "/**
itk::simple::DiscreteGaussianImageFilter::~DiscreteGaussianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DisplacementFieldJacobianDeterminantFilter "/**

Computes a scalar image from a vector image (e.g., deformation field)
input, where each output scalar at each pixel is the Jacobian
determinant of the vector field at that location. This calculation is
correct in the case where the vector image is a \"displacement\" from
the current location. The computation for the jacobian determinant is:
det[ dT/dx ] = det[ I + du/dx ].


Overview
This filter is based on itkVectorGradientMagnitudeImageFilter and
supports the m_DerivativeWeights weights for partial derivatives.
 Note that the determinant of a zero vector field is also zero,
whereas the Jacobian determinant of the corresponding identity warp
transformation is 1.0. In order to compute the effective deformation
Jacobian determinant 1.0 must be added to the diagonal elements of
Jacobian prior to taking the derivative. i.e. det([ (1.0+dx/dx) dx/dy
dx/dz ; dy/dx (1.0+dy/dy) dy/dz; dz/dx dz/dy (1.0+dz/dz) ])

Template Parameters (Input and Output)
This filter has one required template parameter which defines the
input image type. The pixel type of the input image is assumed to be a
vector (e.g., itk::Vector , itk::RGBPixel , itk::FixedArray ). The scalar type of the vector components must be castable to
floating point. Instantiating with an image of RGBPixel<unsigned
short>, for example, is allowed, but the filter will convert it to an
image of Vector<float,3> for processing.
 The second template parameter, TRealType, can be optionally specified
to define the scalar numerical type used in calculations. This is the
component type of the output image, which will be of
itk::Vector<TRealType, N>, where N is the number of channels in the
multiple component input image. The default type of TRealType is
float. For extra precision, you may safely change this parameter to
double.

The third template parameter is the output image type. The third
parameter will be automatically constructed from the first and second
parameters, so it is not necessary (or advisable) to set this
parameter explicitly. Given an M-channel input image with
dimensionality N, and a numerical type specified as TRealType, the
output image will be of type itk::Image<TRealType, N>.

Filter Parameters
The method SetUseImageSpacingOn will cause derivatives in the image to
be scaled (inversely) with the pixel size of the input image,
effectively taking derivatives in world coordinates (versus isotropic
image space). SetUseImageSpacingOff turns this functionality off.
Default is UseImageSpacingOn. The parameter UseImageSpacing can be set
directly with the method SetUseImageSpacing(bool) .
 Weights can be applied to the derivatives directly using the
SetDerivativeWeights method. Note that if UseImageSpacing is set to
TRUE (ON), then these weights will be overridden by weights derived
from the image spacing when the filter is updated. The argument to
this method is a C array of TRealValue type.

Constraints
We use vnl_det for determinent computation, which only supports square
matrices. So the vector dimension of the input image values must be
equal to the image dimensions, which is trivially true for a
deformation field that maps an n-dimensional space onto itself.
 Currently, dimensions up to and including 4 are supported. This
limitation comes from the presence of vnl_det() functions for matrices
of dimension up to 4x4.

The template parameter TRealType must be floating point (float or
double) or a user-defined \"real\" numerical type with arithmetic
operations defined sufficient to compute derivatives.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

This class was adapted by

Hans J. Johnson, The University of Iowa from code provided by
 Tom Vercauteren, INRIA & Mauna Kea Technologies

Torsten Rohlfing, Neuroscience Program, SRI International.
See:
 itk::simple::DisplacementFieldJacobianDeterminantFilter for the procedural interface

 itk::DisplacementFieldJacobianDeterminantFilter for the Doxygen on the original ITK class.


C++ includes: sitkDisplacementFieldJacobianDeterminantFilter.h
*/"

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::DisplacementFieldJacobianDeterminantFilter "/**
itk::simple::DisplacementFieldJacobianDeterminantFilter::DisplacementFieldJacobianDeterminantFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::Execute "/**
Image itk::simple::DisplacementFieldJacobianDeterminantFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::Execute "/**
Image itk::simple::DisplacementFieldJacobianDeterminantFilter::Execute(const Image &image1, bool useImageSpacing, const std::vector< double
> &derivativeWeights)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::GetDerivativeWeights "/**
std::vector<double> itk::simple::DisplacementFieldJacobianDeterminantFilter::GetDerivativeWeights() const

Directly Set/Get the array of weights used in the gradient
calculations. Note that calling UseImageSpacingOn will clobber these
values.

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::GetName "/**
std::string itk::simple::DisplacementFieldJacobianDeterminantFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::GetUseImageSpacing "/**
bool itk::simple::DisplacementFieldJacobianDeterminantFilter::GetUseImageSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::SetDerivativeWeights "/**
Self& itk::simple::DisplacementFieldJacobianDeterminantFilter::SetDerivativeWeights(const std::vector< double > &DerivativeWeights)

Directly Set/Get the array of weights used in the gradient
calculations. Note that calling UseImageSpacingOn will clobber these
values.

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::SetUseImageSpacing "/**
Self& itk::simple::DisplacementFieldJacobianDeterminantFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::ToString "/**
std::string itk::simple::DisplacementFieldJacobianDeterminantFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::UseImageSpacingOff "/**
Self& itk::simple::DisplacementFieldJacobianDeterminantFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::UseImageSpacingOn "/**
Self& itk::simple::DisplacementFieldJacobianDeterminantFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldJacobianDeterminantFilter::~DisplacementFieldJacobianDeterminantFilter "/**
itk::simple::DisplacementFieldJacobianDeterminantFilter::~DisplacementFieldJacobianDeterminantFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DisplacementFieldTransform "/**

A dense deformable transform over a bounded spatial domain for 2D or
3D coordinates space.



See:
 itk::DisplacementFieldTransform


C++ includes: sitkDisplacementFieldTransform.h
*/"

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::DisplacementFieldTransform "/**
itk::simple::DisplacementFieldTransform::DisplacementFieldTransform(unsigned int dimensions)
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::DisplacementFieldTransform "/**
itk::simple::DisplacementFieldTransform::DisplacementFieldTransform(Image &)

Consume an image to construct a displacement field transform.



WARNING:
The input displacement image is transferred to the constructed
transform object. The input image is modified to be a default
constructed Image object.
Image must be of sitkVectorFloat64 pixel type with the number of components
equal to the image dimension.

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::DisplacementFieldTransform "/**
itk::simple::DisplacementFieldTransform::DisplacementFieldTransform(const DisplacementFieldTransform &)
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::DisplacementFieldTransform "/**
itk::simple::DisplacementFieldTransform::DisplacementFieldTransform(const Transform &)
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::GetDisplacementField "/**
Image itk::simple::DisplacementFieldTransform::GetDisplacementField() const

Todo
The returned image should not directly modify the internal
displacement field.


*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::GetInverseDisplacementField "/**
Image itk::simple::DisplacementFieldTransform::GetInverseDisplacementField() const

Todo
The returned image is should not directly modify the internal
displacement field.


*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::GetName "/**
std::string itk::simple::DisplacementFieldTransform::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::SetDisplacementField "/**
Self& itk::simple::DisplacementFieldTransform::SetDisplacementField(Image &)

Consume an image, and set the displacement field.


parameters
WARNING:
The ownership of the input displacement image is transferred to the
constructed transform object. The input image is modified to be a
default constructed Image object.
Image must be of sitkVectorFloat64 pixel type with the number of components
equal to the image dimension.

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::SetInterpolator "/**
Self& itk::simple::DisplacementFieldTransform::SetInterpolator(InterpolatorEnum interp)

Set the interpolator used between the field voxels.

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::SetInverseDisplacementField "/**
Self& itk::simple::DisplacementFieldTransform::SetInverseDisplacementField(Image &)

fixed parameter

*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::SetSmoothingBSplineOnUpdate "/**
Self& itk::simple::DisplacementFieldTransform::SetSmoothingBSplineOnUpdate(const std::vector< unsigned int >
&numberOfControlPointsForUpdateField=std::vector< unsigned int >(3,
4), const std::vector< unsigned int >
&numberOfControlPointsForTotalField=std::vector< unsigned int >(3, 4),
bool enforceStationaryBoundary=true, unsigned int order=3)
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::SetSmoothingGaussianOnUpdate "/**
Self& itk::simple::DisplacementFieldTransform::SetSmoothingGaussianOnUpdate(double varianceForUpdateField=1.75, double varianceForTotalField=0.5)
*/
public ";

%javamethodmodifiers  itk::simple::DisplacementFieldTransform::SetSmoothingOff "/**
Self& itk::simple::DisplacementFieldTransform::SetSmoothingOff()
*/
public ";


%typemap(javaimports) itk::simple::DivideFloorImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::DivideFloor for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkDivideFloorImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::DivideFloorImageFilter "/**
itk::simple::DivideFloorImageFilter::DivideFloorImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::Execute "/**
Image itk::simple::DivideFloorImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::Execute "/**
Image itk::simple::DivideFloorImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::Execute "/**
Image itk::simple::DivideFloorImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::GetName "/**
std::string itk::simple::DivideFloorImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::ToString "/**
std::string itk::simple::DivideFloorImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DivideFloorImageFilter::~DivideFloorImageFilter "/**
itk::simple::DivideFloorImageFilter::~DivideFloorImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DivideImageFilter "/**

Pixel-wise division of two images.


This class is templated over the types of the two input images and the
type of the output image. When the divisor is zero, the division
result is set to the maximum number that can be represented by default
to avoid exception. Numeric conversions (castings) are done by the C++
defaults.

Wiki Examples:

All Examples

Pixel-wise division of two images
See:
 itk::simple::Divide for the procedural interface

 itk::DivideImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkDivideImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DivideImageFilter::DivideImageFilter "/**
itk::simple::DivideImageFilter::DivideImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DivideImageFilter::Execute "/**
Image itk::simple::DivideImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::DivideImageFilter::Execute "/**
Image itk::simple::DivideImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::DivideImageFilter::Execute "/**
Image itk::simple::DivideImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::DivideImageFilter::GetName "/**
std::string itk::simple::DivideImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DivideImageFilter::ToString "/**
std::string itk::simple::DivideImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DivideImageFilter::~DivideImageFilter "/**
itk::simple::DivideImageFilter::~DivideImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DivideRealImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::DivideReal for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkDivideRealImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DivideRealImageFilter::DivideRealImageFilter "/**
itk::simple::DivideRealImageFilter::DivideRealImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DivideRealImageFilter::Execute "/**
Image itk::simple::DivideRealImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::DivideRealImageFilter::Execute "/**
Image itk::simple::DivideRealImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::DivideRealImageFilter::Execute "/**
Image itk::simple::DivideRealImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::DivideRealImageFilter::GetName "/**
std::string itk::simple::DivideRealImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DivideRealImageFilter::ToString "/**
std::string itk::simple::DivideRealImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DivideRealImageFilter::~DivideRealImageFilter "/**
itk::simple::DivideRealImageFilter::~DivideRealImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::DoubleThresholdImageFilter "/**

Binarize an input image using double thresholding.


Double threshold addresses the difficulty in selecting a threshold
that will select the objects of interest without selecting extraneous
objects. Double threshold considers two threshold ranges: a narrow
range and a wide range (where the wide range encompasses the narrow
range). If the wide range was used for a traditional threshold (where
values inside the range map to the foreground and values outside the
range map to the background), many extraneous pixels may survive the
threshold operation. If the narrow range was used for a traditional
threshold, then too few pixels may survive the threshold.

Double threshold uses the narrow threshold image as a marker image and
the wide threshold image as a mask image in the geodesic dilation.
Essentially, the marker image (narrow threshold) is dilated but
constrained to lie within the mask image (wide threshold). Thus, only
the objects of interest (those pixels that survived the narrow
threshold) are extracted but the those objects appear in the final
image as they would have if the wide threshold was used.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::DoubleThreshold for the procedural interface

 itk::DoubleThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDoubleThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::DoubleThresholdImageFilter "/**
itk::simple::DoubleThresholdImageFilter::DoubleThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::Execute "/**
Image itk::simple::DoubleThresholdImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::Execute "/**
Image itk::simple::DoubleThresholdImageFilter::Execute(const Image &image1, double threshold1, double threshold2, double
threshold3, double threshold4, uint8_t insideValue, uint8_t
outsideValue, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::FullyConnectedOff "/**
Self& itk::simple::DoubleThresholdImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::FullyConnectedOn "/**
Self& itk::simple::DoubleThresholdImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetFullyConnected "/**
bool itk::simple::DoubleThresholdImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::DoubleThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetName "/**
std::string itk::simple::DoubleThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::DoubleThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetThreshold1 "/**
double itk::simple::DoubleThresholdImageFilter::GetThreshold1() const

Get the threshold values.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetThreshold2 "/**
double itk::simple::DoubleThresholdImageFilter::GetThreshold2() const

Get the threshold values.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetThreshold3 "/**
double itk::simple::DoubleThresholdImageFilter::GetThreshold3() const

Get the threshold values.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::GetThreshold4 "/**
double itk::simple::DoubleThresholdImageFilter::GetThreshold4() const

Get the threshold values.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetFullyConnected "/**
Self& itk::simple::DoubleThresholdImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::DoubleThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value. The default value NumericTraits<OutputPixelType>::max()

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::DoubleThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::ZeroValue() .

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetThreshold1 "/**
Self& itk::simple::DoubleThresholdImageFilter::SetThreshold1(double Threshold1)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetThreshold2 "/**
Self& itk::simple::DoubleThresholdImageFilter::SetThreshold2(double Threshold2)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetThreshold3 "/**
Self& itk::simple::DoubleThresholdImageFilter::SetThreshold3(double Threshold3)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::SetThreshold4 "/**
Self& itk::simple::DoubleThresholdImageFilter::SetThreshold4(double Threshold4)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits<InputPixelType>::NonpositiveMin() . The two upper thresholds default NumericTraits<InputPixelType>::max . Threshold1 <= Threshold2 <= Threshold3 <= Threshold4.

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::ToString "/**
std::string itk::simple::DoubleThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::DoubleThresholdImageFilter::~DoubleThresholdImageFilter "/**
itk::simple::DoubleThresholdImageFilter::~DoubleThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::EdgePotentialImageFilter "/**

Computes the edge potential of an image from the image gradient.


Input to this filter should be a CovariantVector image representing the image gradient.

The filter expect both the input and output images to have the same
number of dimensions, and the output to be of a scalar image type.
See:
 itk::simple::EdgePotential for the procedural interface

 itk::EdgePotentialImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkEdgePotentialImageFilter.h
*/"

%javamethodmodifiers  itk::simple::EdgePotentialImageFilter::EdgePotentialImageFilter "/**
itk::simple::EdgePotentialImageFilter::EdgePotentialImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::EdgePotentialImageFilter::Execute "/**
Image itk::simple::EdgePotentialImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::EdgePotentialImageFilter::GetName "/**
std::string itk::simple::EdgePotentialImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::EdgePotentialImageFilter::ToString "/**
std::string itk::simple::EdgePotentialImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::EdgePotentialImageFilter::~EdgePotentialImageFilter "/**
itk::simple::EdgePotentialImageFilter::~EdgePotentialImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::EqualImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::Equal for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkEqualImageFilter.h
*/"

%javamethodmodifiers  itk::simple::EqualImageFilter::EqualImageFilter "/**
itk::simple::EqualImageFilter::EqualImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::Execute "/**
Image itk::simple::EqualImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::Execute "/**
Image itk::simple::EqualImageFilter::Execute(const Image &image1, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::Execute "/**
Image itk::simple::EqualImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::Execute "/**
Image itk::simple::EqualImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::Execute "/**
Image itk::simple::EqualImageFilter::Execute(const Image &image1, double constant, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on an image and a constant with the given
parameters

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::Execute "/**
Image itk::simple::EqualImageFilter::Execute(double constant, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::EqualImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::GetForegroundValue "/**
uint8_t itk::simple::EqualImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::GetName "/**
std::string itk::simple::EqualImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::SetBackgroundValue "/**
Self& itk::simple::EqualImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::SetForegroundValue "/**
Self& itk::simple::EqualImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::ToString "/**
std::string itk::simple::EqualImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::EqualImageFilter::~EqualImageFilter "/**
itk::simple::EqualImageFilter::~EqualImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ErodeObjectMorphologyImageFilter "/**

Erosion of an object in an image.


Erosion of an image using binary morphology. Pixel values matching the
object value are considered the \"object\" and all other pixels are
\"background\". This is useful in processing mask images containing
only one object.

If the pixel covered by the center of the kernel has the pixel value
ObjectValue and the pixel is adjacent to a non-object valued pixel,
then the kernel is centered on the object-value pixel and neighboring
pixels covered by the kernel are assigned the background value. The
structuring element is assumed to be composed of binary values (zero
or one).


See:
 ObjectMorphologyImageFilter , BinaryFunctionErodeImageFilter

 BinaryErodeImageFilter

 itk::simple::ErodeObjectMorphology for the procedural interface

 itk::ErodeObjectMorphologyImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkErodeObjectMorphologyImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::ErodeObjectMorphologyImageFilter "/**
itk::simple::ErodeObjectMorphologyImageFilter::ErodeObjectMorphologyImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::Execute "/**
Image itk::simple::ErodeObjectMorphologyImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::Execute "/**
Image itk::simple::ErodeObjectMorphologyImageFilter::Execute(const Image &image1, double objectValue, double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::GetBackgroundValue "/**
double itk::simple::ErodeObjectMorphologyImageFilter::GetBackgroundValue() const

Get the value to be assigned to eroded pixels

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::ErodeObjectMorphologyImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::GetKernelType "/**
KernelEnum itk::simple::ErodeObjectMorphologyImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::GetName "/**
std::string itk::simple::ErodeObjectMorphologyImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::GetObjectValue "/**
double itk::simple::ErodeObjectMorphologyImageFilter::GetObjectValue() const
*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::SetBackgroundValue "/**
Self& itk::simple::ErodeObjectMorphologyImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value to be assigned to eroded pixels

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::SetKernelRadius "/**
Self& itk::simple::ErodeObjectMorphologyImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::SetKernelRadius "/**
Self& itk::simple::ErodeObjectMorphologyImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::SetKernelType "/**
Self& itk::simple::ErodeObjectMorphologyImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::SetKernelType "/**
Self& itk::simple::ErodeObjectMorphologyImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::SetObjectValue "/**
Self& itk::simple::ErodeObjectMorphologyImageFilter::SetObjectValue(double ObjectValue)
*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::ToString "/**
std::string itk::simple::ErodeObjectMorphologyImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ErodeObjectMorphologyImageFilter::~ErodeObjectMorphologyImageFilter "/**
itk::simple::ErodeObjectMorphologyImageFilter::~ErodeObjectMorphologyImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::Euler2DTransform "/**

A rigid 2D transform with rotation in radians around a fixed center
with translation.



See:
 itk::Euler2DTransform


C++ includes: sitkEuler2DTransform.h
*/"

%javamethodmodifiers  itk::simple::Euler2DTransform::Euler2DTransform "/**
itk::simple::Euler2DTransform::Euler2DTransform()
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::Euler2DTransform "/**
itk::simple::Euler2DTransform::Euler2DTransform(const std::vector< double > &fixedCenter, double angle=0.0, const
std::vector< double > &translation=std::vector< double >(2, 0.0))
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::Euler2DTransform "/**
itk::simple::Euler2DTransform::Euler2DTransform(const Euler2DTransform &)
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::Euler2DTransform "/**
itk::simple::Euler2DTransform::Euler2DTransform(const Transform &)
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::GetAngle "/**
double itk::simple::Euler2DTransform::GetAngle() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::GetCenter "/**
std::vector<double> itk::simple::Euler2DTransform::GetCenter() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::GetMatrix "/**
std::vector<double> itk::simple::Euler2DTransform::GetMatrix() const

additional methods

*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::GetName "/**
std::string itk::simple::Euler2DTransform::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::GetTranslation "/**
std::vector<double> itk::simple::Euler2DTransform::GetTranslation() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::SetAngle "/**
Self& itk::simple::Euler2DTransform::SetAngle(double angle)

parameter

*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::SetCenter "/**
Self& itk::simple::Euler2DTransform::SetCenter(const std::vector< double > &params)

fixed parameter

*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::SetMatrix "/**
Self& itk::simple::Euler2DTransform::SetMatrix(const std::vector< double > &matrix, double tolerance=1e-10)
*/
public ";

%javamethodmodifiers  itk::simple::Euler2DTransform::SetTranslation "/**
Self& itk::simple::Euler2DTransform::SetTranslation(const std::vector< double > &translation)
*/
public ";


%typemap(javaimports) itk::simple::Euler3DTransform "/**

A rigid 3D transform with rotation in radians around a fixed center
with translation.



See:
 itk::Euler3DTransform


C++ includes: sitkEuler3DTransform.h
*/"

%javamethodmodifiers  itk::simple::Euler3DTransform::ComputeZYXOff "/**
Self& itk::simple::Euler3DTransform::ComputeZYXOff()
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::ComputeZYXOn "/**
Self& itk::simple::Euler3DTransform::ComputeZYXOn()
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::Euler3DTransform "/**
itk::simple::Euler3DTransform::Euler3DTransform()
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::Euler3DTransform "/**
itk::simple::Euler3DTransform::Euler3DTransform(const std::vector< double > &fixedCenter, double angleX=0.0, double
angleY=0.0, double angleZ=0.0, const std::vector< double >
&translation=std::vector< double >(3, 0.0))
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::Euler3DTransform "/**
itk::simple::Euler3DTransform::Euler3DTransform(const Euler3DTransform &)
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::Euler3DTransform "/**
itk::simple::Euler3DTransform::Euler3DTransform(const Transform &)
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetAngleX "/**
double itk::simple::Euler3DTransform::GetAngleX() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetAngleY "/**
double itk::simple::Euler3DTransform::GetAngleY() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetAngleZ "/**
double itk::simple::Euler3DTransform::GetAngleZ() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetCenter "/**
std::vector<double> itk::simple::Euler3DTransform::GetCenter() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetComputeZYX "/**
bool itk::simple::Euler3DTransform::GetComputeZYX() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetMatrix "/**
std::vector<double> itk::simple::Euler3DTransform::GetMatrix() const

additional methods

*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetName "/**
std::string itk::simple::Euler3DTransform::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::GetTranslation "/**
std::vector<double> itk::simple::Euler3DTransform::GetTranslation() const
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::SetCenter "/**
Self& itk::simple::Euler3DTransform::SetCenter(const std::vector< double > &params)

fixed parameter

*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::SetComputeZYX "/**
Self& itk::simple::Euler3DTransform::SetComputeZYX(bool _arg)
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::SetMatrix "/**
Self& itk::simple::Euler3DTransform::SetMatrix(const std::vector< double > &matrix, double tolerance=1e-10)
*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::SetRotation "/**
Self& itk::simple::Euler3DTransform::SetRotation(double angleX, double angleY, double angleZ)

parameter

*/
public ";

%javamethodmodifiers  itk::simple::Euler3DTransform::SetTranslation "/**
Self& itk::simple::Euler3DTransform::SetTranslation(const std::vector< double > &translation)
*/
public ";


%typemap(javaimports) itk::simple::ExpImageFilter "/**

Computes the exponential function of each pixel.


The computation is performed using std::exp(x).
See:
 itk::simple::Exp for the procedural interface

 itk::ExpImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkExpImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ExpImageFilter::Execute "/**
Image itk::simple::ExpImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ExpImageFilter::ExpImageFilter "/**
itk::simple::ExpImageFilter::ExpImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ExpImageFilter::GetName "/**
std::string itk::simple::ExpImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ExpImageFilter::ToString "/**
std::string itk::simple::ExpImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ExpImageFilter::~ExpImageFilter "/**
itk::simple::ExpImageFilter::~ExpImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ExpNegativeImageFilter "/**

Computes the function exp(-K.x) for each input pixel.


Every output pixel is equal to std::exp(-K.x ). where x is the
intensity of the homologous input pixel, and K is a user-provided
constant.
See:
 itk::simple::ExpNegative for the procedural interface

 itk::ExpNegativeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkExpNegativeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ExpNegativeImageFilter::Execute "/**
Image itk::simple::ExpNegativeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ExpNegativeImageFilter::ExpNegativeImageFilter "/**
itk::simple::ExpNegativeImageFilter::ExpNegativeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ExpNegativeImageFilter::GetName "/**
std::string itk::simple::ExpNegativeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ExpNegativeImageFilter::ToString "/**
std::string itk::simple::ExpNegativeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ExpNegativeImageFilter::~ExpNegativeImageFilter "/**
itk::simple::ExpNegativeImageFilter::~ExpNegativeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ExpandImageFilter "/**

Expand the size of an image by an integer factor in each dimension.


ExpandImageFilter increases the size of an image by an integer factor in each dimension
using a interpolation method. The output image size in each dimension
is given by:

OutputSize[j] = InputSize[j] * ExpandFactors[j]

The output values are obtained by interpolating the input image. The
default interpolation type used is the LinearInterpolateImageFunction . The user can specify a particular interpolation function via SetInterpolator() . Note that the input interpolator must derive from base class InterpolateImageFunction .

This filter will produce an output with different pixel spacing that
its input image such that:

OutputSpacing[j] = InputSpacing[j] / ExpandFactors[j]

The filter is templated over the input image type and the output image
type.

This filter is implemented as a multithreaded filter and supports
streaming.


WARNING:
This filter only works for image with scalar pixel types. For vector
images use VectorExpandImageFilter .
 This filter assumes that the input and output image has the same
number of dimensions.


See:
 InterpolateImageFunction

 LinearInterpolationImageFunction

 VectorExpandImageFilter

 itk::simple::Expand for the procedural interface

 itk::ExpandImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkExpandImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ExpandImageFilter::Execute "/**
Image itk::simple::ExpandImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::Execute "/**
Image itk::simple::ExpandImageFilter::Execute(const Image &image1, const std::vector< unsigned int >
&expandFactors, InterpolatorEnum interpolator)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::ExpandImageFilter "/**
itk::simple::ExpandImageFilter::ExpandImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::GetExpandFactors "/**
std::vector<unsigned int> itk::simple::ExpandImageFilter::GetExpandFactors() const

Get the expand factors.

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::GetInterpolator "/**
InterpolatorEnum itk::simple::ExpandImageFilter::GetInterpolator() const

Get/Set the interpolator function.

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::GetName "/**
std::string itk::simple::ExpandImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::SetExpandFactor "/**
Self& itk::simple::ExpandImageFilter::SetExpandFactor(unsigned int e)

Custom public declarations

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::SetExpandFactors "/**
Self& itk::simple::ExpandImageFilter::SetExpandFactors(const std::vector< unsigned int > &ExpandFactors)

Set the expand factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::SetExpandFactors "/**
Self& itk::simple::ExpandImageFilter::SetExpandFactors(unsigned int value)

Set the values of the ExpandFactors vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::SetInterpolator "/**
Self& itk::simple::ExpandImageFilter::SetInterpolator(InterpolatorEnum Interpolator)

Get/Set the interpolator function.

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::ToString "/**
std::string itk::simple::ExpandImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ExpandImageFilter::~ExpandImageFilter "/**
itk::simple::ExpandImageFilter::~ExpandImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ExtractImageFilter "/**

Decrease the image size by cropping the image to the selected region
bounds.


ExtractImageFilter changes the image boundary of an image by removing pixels outside the
target region. The target region must be specified.

ExtractImageFilter also collapses dimensions so that the input image may have more
dimensions than the output image (i.e. 4-D input image to a 3-D output
image). To specify what dimensions to collapse, the ExtractionRegion
must be specified. For any dimension dim where
ExtractionRegion.Size[dim] = 0, that dimension is collapsed. The index
to collapse on is specified by ExtractionRegion.Index[dim]. For
example, we have a image 4D = a 4x4x4x4 image, and we want to get a 3D
image, 3D = a 4x4x4 image, specified as [x,y,z,2] from 4D (i.e. the
3rd \"time\" slice from 4D). The ExtractionRegion.Size = [4,4,4,0] and
ExtractionRegion.Index = [0,0,0,2].

The number of dimension in ExtractionRegion.Size and Index must = InputImageDimension. The number of non-zero dimensions in
ExtractionRegion.Size must = OutputImageDimension.

The output image produced by this filter will have the same origin as
the input image, while the ImageRegion of the output image will start at the starting index value provided
in the ExtractRegion parameter. If you are looking for a filter that
will re-compute the origin of the output image, and provide an output
image region whose index is set to zeros, then you may want to use the RegionOfInterestImageFilter . The output spacing is is simply the collapsed version of the input
spacing.

Determining the direction of the collapsed output image from an larger
dimensional input space is an ill defined problem in general. It is
required that the application developer select the desired
transformation strategy for collapsing direction cosines. It is
REQUIRED that a strategy be explicitly requested (i.e. there is no
working default). Direction Collapsing Strategies: 1)
DirectionCollapseToUnknown(); This is the default and the filter can
not run when this is set. The reason is to explicitly force the
application developer to define their desired behavior. 1)
DirectionCollapseToIdentity(); Output has identity direction no matter
what 2) DirectionCollapseToSubmatrix(); Output direction is the sub-
matrix if it is positive definite, else throw an exception.

This filter is implemented as a multithreaded filter. It provides a
ThreadedGenerateData() method for its implementation.


This filter is derived from InPlaceImageFilter . When the input to this filter matched the output requirested
region, like with streaming filter for input, then setting this filter
to run in-place will result in no copying of the bulk pixel data.

See:
 CropImageFilter
Wiki Examples:

All Examples

Crop an image by specifying the region to keep
See:
 itk::simple::Extract for the procedural interface

 itk::ExtractImageFilter<InputImageType, typename InputImageType::template Rebind for the
Doxygen on the original ITK class.



C++ includes: sitkExtractImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ExtractImageFilter::Execute "/**
Image itk::simple::ExtractImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::Execute "/**
Image itk::simple::ExtractImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &size, const
std::vector< int > &index,
ExtractImageFilter::DirectionCollapseToStrategyType
directionCollapseToStrategy)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::ExtractImageFilter "/**
itk::simple::ExtractImageFilter::ExtractImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::GetDirectionCollapseToStrategy "/**
DirectionCollapseToStrategyType itk::simple::ExtractImageFilter::GetDirectionCollapseToStrategy() const

NOTE: The SetDirectionCollapseToUknown is explicitly not defined. It
is a state that a filter can be in only when it is first instantiate
prior to being initialized. Get the currently set strategy for
collapsing directions of physical space.

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::GetIndex "/**
std::vector<int> itk::simple::ExtractImageFilter::GetIndex() const
*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::GetName "/**
std::string itk::simple::ExtractImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::GetSize "/**
std::vector<unsigned int> itk::simple::ExtractImageFilter::GetSize() const
*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::SetDirectionCollapseToStrategy "/**
Self& itk::simple::ExtractImageFilter::SetDirectionCollapseToStrategy(DirectionCollapseToStrategyType DirectionCollapseToStrategy)

     Set the strategy to be used to collapse physical space
dimensions.

itk::itkExtractImageFilter::DIRECTIONCOLLAPSETOIDENTITY Set the
strategy so that all collapsed images have an identity direction. Use
this strategy when you know that retention of the physical space
orientation of the collapsed image is not important.

itk::itkExtractImageFilter::DIRECTIONCOLLAPSETOGUESS Set the strategy
so that all collapsed images where output direction is the sub-matrix
if it is positive definite, else return identity. This is backwards
compatible with ITKv3, but is highly discouraged because the results
are difficult to anticipate under differing data scenerios.

itk::itkExtractImageFilter::DIRECTIONCOLLAPSETOSUBMATRIX Set the
strategy so that all collapsed images where output direction is the
sub-matrix if it is positive definite, else throw an exception. Use
this strategy when it is known that properly identified physical space
sub-volumes can be reliably extracted from a higher dimensional space.
For example when the application programmer knows that a 4D image is
3D+time, and that the 3D sub-space is properly defined.

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::SetIndex "/**
Self& itk::simple::ExtractImageFilter::SetIndex(const std::vector< int > &Index)

odo the internal setting of the method needs work!!!

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::SetSize "/**
Self& itk::simple::ExtractImageFilter::SetSize(const std::vector< unsigned int > &Size)
*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::ToString "/**
std::string itk::simple::ExtractImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ExtractImageFilter::~ExtractImageFilter "/**
itk::simple::ExtractImageFilter::~ExtractImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FFTConvolutionImageFilter "/**

Convolve a given image with an arbitrary image kernel using
multiplication in the Fourier domain.


This filter produces output equivalent to the output of the ConvolutionImageFilter . However, it takes advantage of the convolution theorem to
accelerate the convolution computation when the kernel is large.


WARNING:
This filter ignores the spacing, origin, and orientation of the kernel
image and treats them as identical to those in the input image.
 This code was adapted from the Insight Journal contribution:

\"FFT Based Convolution\" by Gaetan Lehmann https://hdl.handle.net/10380/3154


See:
 ConvolutionImageFilter

 itk::simple::FFTConvolution for the procedural interface

 itk::FFTConvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTConvolutionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::Execute "/**
Image itk::simple::FFTConvolutionImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::Execute "/**
Image itk::simple::FFTConvolutionImageFilter::Execute(const Image &image1, const Image &image2, bool normalize,
FFTConvolutionImageFilter::BoundaryConditionType boundaryCondition,
FFTConvolutionImageFilter::OutputRegionModeType outputRegionMode)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::FFTConvolutionImageFilter "/**
itk::simple::FFTConvolutionImageFilter::FFTConvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::GetBoundaryCondition "/**
BoundaryConditionType itk::simple::FFTConvolutionImageFilter::GetBoundaryCondition() const
*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::GetName "/**
std::string itk::simple::FFTConvolutionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::GetNormalize "/**
bool itk::simple::FFTConvolutionImageFilter::GetNormalize() const
*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::GetOutputRegionMode "/**
OutputRegionModeType itk::simple::FFTConvolutionImageFilter::GetOutputRegionMode() const
*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::NormalizeOff "/**
Self& itk::simple::FFTConvolutionImageFilter::NormalizeOff()
*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::NormalizeOn "/**
Self& itk::simple::FFTConvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::SetBoundaryCondition "/**
Self& itk::simple::FFTConvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::SetNormalize "/**
Self& itk::simple::FFTConvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::SetOutputRegionMode "/**
Self& itk::simple::FFTConvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::ToString "/**
std::string itk::simple::FFTConvolutionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FFTConvolutionImageFilter::~FFTConvolutionImageFilter "/**
itk::simple::FFTConvolutionImageFilter::~FFTConvolutionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FFTNormalizedCorrelationImageFilter "/**

Calculate normalized cross correlation using FFTs.


This filter calculates the normalized cross correlation (NCC) of two
images using FFTs instead of spatial correlation. It is much faster
than spatial correlation for reasonably large structuring elements.
This filter is a subclass of the more general MaskedFFTNormalizedCorrelationImageFilter and operates by essentially setting the masks in that algorithm to
images of ones. As described in detail in the references below, there
is no computational overhead to utilizing the more general masked
algorithm because the FFTs of the images of ones are still necessary
for the computations.

Inputs: Two images are required as inputs, fixedImage and movingImage.
In the context of correlation, inputs are often defined as: \"image\"
and \"template\". In this filter, the fixedImage plays the role of the
image, and the movingImage plays the role of the template. However,
this filter is capable of correlating any two images and is not
restricted to small movingImages (templates).

Optional parameters: The RequiredNumberOfOverlappingPixels enables the
user to specify how many voxels of the two images must overlap; any
location in the correlation map that results from fewer than this
number of voxels will be set to zero. Larger values zero-out pixels on
a larger border around the correlation image. Thus, larger values
remove less stable computations but also limit the capture range. If
RequiredNumberOfOverlappingPixels is set to 0, the default, no zeroing
will take place.

Image size: fixedImage and movingImage need not be the same size.
Furthermore, whereas some algorithms require that the \"template\" be
smaller than the \"image\" because of errors in the regions where the
two are not fully overlapping, this filter has no such restriction.

Image spacing: Since the computations are done in the pixel domain, all
input images must have the same spacing.

Outputs; The output is an image of RealPixelType that is the NCC of
the two images and its values range from -1.0 to 1.0. The size of this
NCC image is, by definition, size(fixedImage) + size(movingImage) - 1.

Example filter usage:


WARNING:
The pixel type of the output image must be of real type (float or
double). ConceptChecking is used to enforce the output pixel type. You
will get a compilation error if the pixel type of the output image is
not float or double.
 References: 1) D. Padfield. \"Masked object registration in the
Fourier domain.\" Transactions on Image Processing. 2) D. Padfield. \"Masked FFT registration\". In Proc.
Computer Vision and Pattern Recognition, 2010.


: Dirk Padfield, GE Global Research, padfield@research.ge.com

See:
 itk::simple::FFTNormalizedCorrelation for the procedural interface

 itk::FFTNormalizedCorrelationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTNormalizedCorrelationImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::Execute "/**
Image itk::simple::FFTNormalizedCorrelationImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::Execute "/**
Image itk::simple::FFTNormalizedCorrelationImageFilter::Execute(const Image &image1, const Image &image2, uint64_t
requiredNumberOfOverlappingPixels)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::FFTNormalizedCorrelationImageFilter "/**
itk::simple::FFTNormalizedCorrelationImageFilter::FFTNormalizedCorrelationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::GetName "/**
std::string itk::simple::FFTNormalizedCorrelationImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::GetRequiredNumberOfOverlappingPixels "/**
uint64_t itk::simple::FFTNormalizedCorrelationImageFilter::GetRequiredNumberOfOverlappingPixels() const
*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::SetRequiredNumberOfOverlappingPixels "/**
Self& itk::simple::FFTNormalizedCorrelationImageFilter::SetRequiredNumberOfOverlappingPixels(uint64_t RequiredNumberOfOverlappingPixels)
*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::ToString "/**
std::string itk::simple::FFTNormalizedCorrelationImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FFTNormalizedCorrelationImageFilter::~FFTNormalizedCorrelationImageFilter "/**
itk::simple::FFTNormalizedCorrelationImageFilter::~FFTNormalizedCorrelationImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FFTPadImageFilter "/**

Pad an image to make it suitable for an FFT transformation.


FFT filters usually requires a specific image size. The size is
decomposed in several prime factors, and the filter only supports
prime factors up to a maximum value. This filter automatically finds
the greatest prime factor required by the available implementation and
pads the input appropriately.

This code was adapted from the Insight Journal contribution:

\"FFT Based Convolution\" by Gaetan Lehmann https://hdl.handle.net/10380/3154


Gaetan Lehmann

See:
 FFTShiftImageFilter

 itk::simple::FFTPad for the procedural interface

 itk::FFTPadImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTPadImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FFTPadImageFilter::Execute "/**
Image itk::simple::FFTPadImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::Execute "/**
Image itk::simple::FFTPadImageFilter::Execute(const Image &image1, FFTPadImageFilter::BoundaryConditionType
boundaryCondition, int sizeGreatestPrimeFactor)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::FFTPadImageFilter "/**
itk::simple::FFTPadImageFilter::FFTPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::GetBoundaryCondition "/**
BoundaryConditionType itk::simple::FFTPadImageFilter::GetBoundaryCondition() const
*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::GetName "/**
std::string itk::simple::FFTPadImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::GetSizeGreatestPrimeFactor "/**
int itk::simple::FFTPadImageFilter::GetSizeGreatestPrimeFactor() const

Set/Get the greatest prime factor allowed on the size of the padded
image. The filter increase the size of the image to reach a size with
the greatest prime factor smaller or equal to the specified value. The
default value is 13, which is the greatest prime number for which the
FFT are precomputed in FFTW, and thus gives very good performance. A
greatest prime factor of 2 produce a size which is a power of 2, and
thus is suitable for vnl base fft filters. A greatest prime factor of
1 or less - typically 0 - disable the extra padding.

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::SetBoundaryCondition "/**
Self& itk::simple::FFTPadImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::SetSizeGreatestPrimeFactor "/**
Self& itk::simple::FFTPadImageFilter::SetSizeGreatestPrimeFactor(int SizeGreatestPrimeFactor)

Set/Get the greatest prime factor allowed on the size of the padded
image. The filter increase the size of the image to reach a size with
the greatest prime factor smaller or equal to the specified value. The
default value is 13, which is the greatest prime number for which the
FFT are precomputed in FFTW, and thus gives very good performance. A
greatest prime factor of 2 produce a size which is a power of 2, and
thus is suitable for vnl base fft filters. A greatest prime factor of
1 or less - typically 0 - disable the extra padding.

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::ToString "/**
std::string itk::simple::FFTPadImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FFTPadImageFilter::~FFTPadImageFilter "/**
itk::simple::FFTPadImageFilter::~FFTPadImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FFTShiftImageFilter "/**

Shift the zero-frequency components of a Fourier transform to the
center of the image.


The Fourier transform produces an image where the zero frequency
components are in the corner of the image, making it difficult to
understand. This filter shifts the component to the center of the
image.


For images with an odd-sized dimension, applying this filter twice
will not produce the same image as the original one without using
SetInverse(true) on one (and only one) of the two filters.
https://hdl.handle.net/1926/321


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ForwardFFTImageFilter , InverseFFTImageFilter

 itk::simple::FFTShift for the procedural interface

 itk::FFTShiftImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTShiftImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::Execute "/**
Image itk::simple::FFTShiftImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::Execute "/**
Image itk::simple::FFTShiftImageFilter::Execute(const Image &image1, bool inverse)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::FFTShiftImageFilter "/**
itk::simple::FFTShiftImageFilter::FFTShiftImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::GetInverse "/**
bool itk::simple::FFTShiftImageFilter::GetInverse() const

Set/Get whether the filter must invert the transform or not. This
option has no effect if none of the size of the input image is even,
but is required to restore the original image if at least one of the
dimensions has an odd size.

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::GetName "/**
std::string itk::simple::FFTShiftImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::InverseOff "/**
Self& itk::simple::FFTShiftImageFilter::InverseOff()
*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::InverseOn "/**
Self& itk::simple::FFTShiftImageFilter::InverseOn()

Set the value of Inverse to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::SetInverse "/**
Self& itk::simple::FFTShiftImageFilter::SetInverse(bool Inverse)

Set/Get whether the filter must invert the transform or not. This
option has no effect if none of the size of the input image is even,
but is required to restore the original image if at least one of the
dimensions has an odd size.

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::ToString "/**
std::string itk::simple::FFTShiftImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FFTShiftImageFilter::~FFTShiftImageFilter "/**
itk::simple::FFTShiftImageFilter::~FFTShiftImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FastApproximateRankImageFilter "/**

A separable rank filter.


Medians aren't separable, but if you want a large robust smoother to
be relatively quick then it is worthwhile pretending that they are.

This code was contributed in the Insight Journal paper: \"Efficient
implementation of kernel filtering\" by Beare R., Lehmann G https://hdl.handle.net/1926/555 http://www.insight-journal.org/browse/publication/160


Richard Beare

See:
 itk::simple::FastApproximateRank for the procedural interface

 itk::FastApproximateRankImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastApproximateRankImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::Execute "/**
Image itk::simple::FastApproximateRankImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::Execute "/**
Image itk::simple::FastApproximateRankImageFilter::Execute(const Image &image1, double rank, const std::vector< unsigned int >
&radius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::FastApproximateRankImageFilter "/**
itk::simple::FastApproximateRankImageFilter::FastApproximateRankImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::GetName "/**
std::string itk::simple::FastApproximateRankImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::FastApproximateRankImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::GetRank "/**
double itk::simple::FastApproximateRankImageFilter::GetRank() const
*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::SetRadius "/**
Self& itk::simple::FastApproximateRankImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::SetRadius "/**
Self& itk::simple::FastApproximateRankImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::SetRank "/**
Self& itk::simple::FastApproximateRankImageFilter::SetRank(double Rank)
*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::ToString "/**
std::string itk::simple::FastApproximateRankImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FastApproximateRankImageFilter::~FastApproximateRankImageFilter "/**
itk::simple::FastApproximateRankImageFilter::~FastApproximateRankImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FastMarchingBaseImageFilter "/**

Fast Marching Method on Image .


The speed function can be specified as a speed image or a speed
constant. The speed image is set using the method SetInput(). If the
speed image is ITK_NULLPTR, a constant speed function is used and is
specified using method the SetSpeedConstant() .

If the speed function is constant and of value one, fast marching
results is an approximate distance function from the initial alive
points.

There are two ways to specify the output image information (
LargestPossibleRegion, Spacing, Origin):


it is copied directly from the input speed image

it is specified by the user. Default values are used if the user does
not specify all the information.
 The output information is computed as follows.

If the speed image is ITK_NULLPTR or if the OverrideOutputInformation
is set to true, the output information is set from user specified
parameters. These parameters can be specified using methods


FastMarchingImageFilterBase::SetOutputRegion() ,

FastMarchingImageFilterBase::SetOutputSpacing() ,

FastMarchingImageFilterBase::SetOutputDirection() ,

FastMarchingImageFilterBase::SetOutputOrigin() .
 Else the output information is copied from the input speed image.

Implementation of this class is based on Chapter 8 of \"Level Set
Methods and Fast Marching Methods\", J.A. Sethian, Cambridge Press,
Second edition, 1999.

For an alternative implementation, see itk::FastMarchingImageFilter .

TTraits

traits


See:
 FastMarchingImageFilter

 ImageFastMarchingTraits

 ImageFastMarchingTraits2

 itk::simple::FastMarchingBase for the procedural interface

 itk::FastMarchingImageFilterBase for the Doxygen on the original ITK class.


C++ includes: sitkFastMarchingBaseImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::AddTrialPoint "/**
Self& itk::simple::FastMarchingBaseImageFilter::AddTrialPoint(std::vector< unsigned int > t)

Add trial point

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::ClearTrialPoints "/**
Self& itk::simple::FastMarchingBaseImageFilter::ClearTrialPoints()

Clear trial points

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::Execute "/**
Image itk::simple::FastMarchingBaseImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::Execute "/**
Image itk::simple::FastMarchingBaseImageFilter::Execute(const Image &, std::vector< std::vector< unsigned int > >
trialPoints, double normalizationFactor, double stoppingValue,
FastMarchingBaseImageFilter::TopologyCheckType topologyCheck)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::FastMarchingBaseImageFilter "/**
itk::simple::FastMarchingBaseImageFilter::FastMarchingBaseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::GetName "/**
std::string itk::simple::FastMarchingBaseImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::GetNormalizationFactor "/**
double itk::simple::FastMarchingBaseImageFilter::GetNormalizationFactor() const

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::GetStoppingValue "/**
double itk::simple::FastMarchingBaseImageFilter::GetStoppingValue() const

Get the Fast Marching algorithm Stopping Value.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::GetTopologyCheck "/**
TopologyCheckType itk::simple::FastMarchingBaseImageFilter::GetTopologyCheck() const
*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::GetTrialPoints "/**
std::vector< std::vector<unsigned int> > itk::simple::FastMarchingBaseImageFilter::GetTrialPoints() const

Get trial points

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::SetNormalizationFactor "/**
Self& itk::simple::FastMarchingBaseImageFilter::SetNormalizationFactor(double NormalizationFactor)

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::SetStoppingValue "/**
Self& itk::simple::FastMarchingBaseImageFilter::SetStoppingValue(double StoppingValue)

Set the Fast Marching algorithm Stopping Value. The Fast Marching
algorithm is terminated when the value of the smallest trial point is
greater than the stopping value.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::SetTopologyCheck "/**
Self& itk::simple::FastMarchingBaseImageFilter::SetTopologyCheck(TopologyCheckType TopologyCheck)
*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::SetTrialPoints "/**
Self& itk::simple::FastMarchingBaseImageFilter::SetTrialPoints(std::vector< std::vector< unsigned int > > t)

Set trial points. The default trial value (i.e. 0.0) is used for each
index.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::ToString "/**
std::string itk::simple::FastMarchingBaseImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingBaseImageFilter::~FastMarchingBaseImageFilter "/**
itk::simple::FastMarchingBaseImageFilter::~FastMarchingBaseImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FastMarchingImageFilter "/**

Solve an Eikonal equation using Fast Marching.


Fast marching solves an Eikonal equation where the speed is always
non-negative and depends on the position only. Starting from an
initial position on the front, fast marching systematically moves the
front forward one grid point at a time.

Updates are preformed using an entropy satisfy scheme where only
\"upwind\" neighborhoods are used. This implementation of Fast
Marching uses a std::priority_queue to locate the next proper grid
position to update.

Fast Marching sweeps through N grid points in (N log N) steps to
obtain the arrival time value as the front propagates through the
grid.

Implementation of this class is based on Chapter 8 of \"Level Set
Methods and Fast Marching Methods\", J.A. Sethian, Cambridge Press,
Second edition, 1999.

This class is templated over the level set image type and the speed
image type. The initial front is specified by two containers: one
containing the known points and one containing the trial points. Alive
points are those that are already part of the object, and trial points
are considered for inclusion. In order for the filter to evolve, at
least some trial points must be specified. These can for instance be
specified as the layer of pixels around the alive points.

The speed function can be specified as a speed image or a speed
constant. The speed image is set using the method SetInput() . If the
speed image is ITK_NULLPTR, a constant speed function is used and is
specified using method the SetSpeedConstant() .

If the speed function is constant and of value one, fast marching
results in an approximate distance function from the initial alive
points. FastMarchingImageFilter is used in the ReinitializeLevelSetImageFilter object to create a signed distance function from the zero level set.

The algorithm can be terminated early by setting an appropriate
stopping value. The algorithm terminates when the current arrival time
being processed is greater than the stopping value.

There are two ways to specify the output image information (
LargestPossibleRegion, Spacing, Origin): (a) it is copied directly
from the input speed image or (b) it is specified by the user. Default
values are used if the user does not specify all the information.

The output information is computed as follows. If the speed image is
ITK_NULLPTR or if the OverrideOutputInformation is set to true, the
output information is set from user specified parameters. These
parameters can be specified using methods SetOutputRegion() ,
SetOutputSpacing() , SetOutputDirection() , and SetOutputOrigin() .
Else if the speed image is not ITK_NULLPTR, the output information is
copied from the input speed image.

For an alternative implementation, see itk::FastMarchingImageFilter .

Possible Improvements: In the current implementation,
std::priority_queue only allows taking nodes out from the front and
putting nodes in from the back. To update a value already on the heap,
a new node is added to the heap. The defunct old node is left on the
heap. When it is removed from the top, it will be recognized as
invalid and not used. Future implementations can implement the heap in
a different way allowing the values to be updated. This will generally
require some sift-up and sift-down functions and an image of back-
pointers going from the image to heap in order to locate the node
which is to be updated.


See:
 FastMarchingImageFilterBase

 LevelSetTypeDefault

 itk::simple::FastMarching for the procedural interface

 itk::FastMarchingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastMarchingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::AddTrialPoint "/**
Self& itk::simple::FastMarchingImageFilter::AddTrialPoint(const std::vector< unsigned int > &point)

Add TrialPoints point.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::ClearTrialPoints "/**
Self& itk::simple::FastMarchingImageFilter::ClearTrialPoints()

Remove all TrialPoints points.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::Execute "/**
Image itk::simple::FastMarchingImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::Execute "/**
Image itk::simple::FastMarchingImageFilter::Execute(const Image &image1, const std::vector< std::vector< unsigned int > >
&trialPoints, double normalizationFactor, double stoppingValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::FastMarchingImageFilter "/**
itk::simple::FastMarchingImageFilter::FastMarchingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::GetName "/**
std::string itk::simple::FastMarchingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::GetNormalizationFactor "/**
double itk::simple::FastMarchingImageFilter::GetNormalizationFactor() const

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::GetStoppingValue "/**
double itk::simple::FastMarchingImageFilter::GetStoppingValue() const

Get the Fast Marching algorithm Stopping Value.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::GetTrialPoints "/**
std::vector< std::vector<unsigned int> > itk::simple::FastMarchingImageFilter::GetTrialPoints() const

Get the container of Trial Points representing the initial front.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::SetNormalizationFactor "/**
Self& itk::simple::FastMarchingImageFilter::SetNormalizationFactor(double NormalizationFactor)

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::SetStoppingValue "/**
Self& itk::simple::FastMarchingImageFilter::SetStoppingValue(double StoppingValue)

Set the Fast Marching algorithm Stopping Value. The Fast Marching
algorithm is terminated when the value of the smallest trial point is
greater than the stopping value.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::SetTrialPoints "/**
Self& itk::simple::FastMarchingImageFilter::SetTrialPoints(const std::vector< std::vector< unsigned int > > &TrialPoints)

Set the container of Trial Points representing the initial front.
Trial points are represented as a VectorContainer of LevelSetNodes.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::ToString "/**
std::string itk::simple::FastMarchingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingImageFilter::~FastMarchingImageFilter "/**
itk::simple::FastMarchingImageFilter::~FastMarchingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FastMarchingUpwindGradientImageFilter "/**

Generates the upwind gradient field of fast marching arrival times.


This filter adds some extra functionality to its base class. While the
solution T(x) of the Eikonal equation is being generated by the base
class with the fast marching method, the filter generates the upwind
gradient vectors of T(x), storing them in an image.

Since the Eikonal equation generates the arrival times of a wave
travelling at a given speed, the generated gradient vectors can be
interpreted as the slowness (1/velocity) vectors of the front (the
quantity inside the modulus operator in the Eikonal equation).

Gradient vectors are computed using upwind finite differences, that
is, information only propagates from points where the wavefront has
already passed. This is consistent with how the fast marching method
works.

One more extra feature is the possibility to define a set of Target
points where the propagation stops. This can be used to avoid
computing the Eikonal solution for the whole domain. The front can be
stopped either when one Target point is reached or all Target points
are reached. The propagation can stop after a time TargetOffset has
passed since the stop condition is met. This way the solution is
computed a bit downstream the Target points, so that the level sets of
T(x) corresponding to the Target are smooth.

For an alternative implementation, see itk::FastMarchingUpwindGradientImageFilterBase .


Luca Antiga Ph.D. Biomedical Technologies Laboratory, Bioengineering
Department, Mario Negri Institute, Italy.

See:
 itk::simple::FastMarchingUpwindGradient for the procedural interface

 itk::FastMarchingUpwindGradientImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastMarchingUpwindGradientImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::AddTargetPoint "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::AddTargetPoint(const std::vector< unsigned int > &point)

Add TargetPoints point.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::AddTrialPoint "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::AddTrialPoint(const std::vector< unsigned int > &point)

Add TrialPoints point.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::ClearTargetPoints "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::ClearTargetPoints()

Remove all TargetPoints points.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::ClearTrialPoints "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::ClearTrialPoints()

Remove all TrialPoints points.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::Execute "/**
Image itk::simple::FastMarchingUpwindGradientImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::Execute "/**
Image itk::simple::FastMarchingUpwindGradientImageFilter::Execute(const Image &image1, const std::vector< std::vector< unsigned int > >
&trialPoints, unsigned int numberOfTargets, const std::vector<
std::vector< unsigned int > > &targetPoints, double targetOffset,
double normalizationFactor)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::FastMarchingUpwindGradientImageFilter "/**
itk::simple::FastMarchingUpwindGradientImageFilter::FastMarchingUpwindGradientImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetGradientImage "/**
Image itk::simple::FastMarchingUpwindGradientImageFilter::GetGradientImage() const

Get the gradient image.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetName "/**
std::string itk::simple::FastMarchingUpwindGradientImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetNormalizationFactor "/**
double itk::simple::FastMarchingUpwindGradientImageFilter::GetNormalizationFactor() const

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetNumberOfTargets "/**
unsigned int itk::simple::FastMarchingUpwindGradientImageFilter::GetNumberOfTargets() const

Get the number of targets.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetOffset "/**
double itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetOffset() const

Get the TargetOffset ivar.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetPoints "/**
std::vector< std::vector<unsigned int> > itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetPoints() const

Get the container of Target Points.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetValue "/**
double itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetValue() const

Get the arrival time corresponding to the last reached target. If
TargetReachedMode is set to NoTargets, TargetValue contains the last
(aka largest) Eikonal solution value generated.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::GetTrialPoints "/**
std::vector< std::vector<unsigned int> > itk::simple::FastMarchingUpwindGradientImageFilter::GetTrialPoints() const
*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::SetNormalizationFactor "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::SetNormalizationFactor(double NormalizationFactor)

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::SetNumberOfTargets "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::SetNumberOfTargets(unsigned int NumberOfTargets)
*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::SetTargetOffset "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::SetTargetOffset(double TargetOffset)

Set how long (in terms of arrival times) after targets are reached the
front must stop. This is useful to ensure that the level set of target
arrival time is smooth.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::SetTargetPoints "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::SetTargetPoints(const std::vector< std::vector< unsigned int > > &TargetPoints)

Set the container of Target Points. If a target point is reached, the
propagation stops. Trial points are represented as a VectorContainer of LevelSetNodes.

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::SetTrialPoints "/**
Self& itk::simple::FastMarchingUpwindGradientImageFilter::SetTrialPoints(const std::vector< std::vector< unsigned int > > &TrialPoints)
*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::ToString "/**
std::string itk::simple::FastMarchingUpwindGradientImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FastMarchingUpwindGradientImageFilter::~FastMarchingUpwindGradientImageFilter "/**
itk::simple::FastMarchingUpwindGradientImageFilter::~FastMarchingUpwindGradientImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FastSymmetricForcesDemonsRegistrationFilter "/**

Deformably register two images using a symmetric forces demons
algorithm.


This class was contributed by Tom Vercauteren, INRIA & Mauna Kea
Technologies based on a variation of the DemonsRegistrationFilter .

FastSymmetricForcesDemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the deformation field which will map a moving image onto
a fixed image.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


Tom Vercauteren, INRIA & Mauna Kea Technologies
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/510


WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.

See:
 DemonsRegistrationFilter

 DemonsRegistrationFunction

 itk::FastSymmetricForcesDemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastSymmetricForcesDemonsRegistrationFilter.h
*/"

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute "/**
Image itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&initialDisplacementField)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute "/**
Image itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute "/**
Image itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&initialDisplacementField, const std::vector< double >
&standardDeviations, uint32_t numberOfIterations, double
maximumRMSError,
FastSymmetricForcesDemonsRegistrationFilter::UseGradientTypeType
useGradientType, double maximumUpdateStepLength, bool
smoothDisplacementField, bool smoothUpdateField, const std::vector<
double > &updateFieldStandardDeviations, unsigned int
maximumKernelWidth, double maximumError, double
intensityDifferenceThreshold, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute "/**
Image itk::simple::FastSymmetricForcesDemonsRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, const std::vector<
double > &standardDeviations, uint32_t numberOfIterations, double
maximumRMSError,
FastSymmetricForcesDemonsRegistrationFilter::UseGradientTypeType
useGradientType, double maximumUpdateStepLength, bool
smoothDisplacementField, bool smoothUpdateField, const std::vector<
double > &updateFieldStandardDeviations, unsigned int
maximumKernelWidth, double maximumError, double
intensityDifferenceThreshold, bool useImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::FastSymmetricForcesDemonsRegistrationFilter "/**
itk::simple::FastSymmetricForcesDemonsRegistrationFilter::FastSymmetricForcesDemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetElapsedIterations "/**
uint32_t itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetIntensityDifferenceThreshold "/**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumError "/**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumKernelWidth "/**
unsigned int itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumRMSError "/**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumUpdateStepLength "/**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMaximumUpdateStepLength() const
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMetric "/**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the the overlapping region between the two images. This
value is calculated for the current iteration

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetName "/**
std::string itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetNumberOfIterations "/**
uint32_t itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetRMSChange "/**
double itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetRMSChange() const

Set/Get the root mean squared change of the previous iteration. May
not be used by all solvers.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetSmoothDisplacementField "/**
bool itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetSmoothUpdateField "/**
bool itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetStandardDeviations "/**
std::vector<double> itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUpdateFieldStandardDeviations "/**
std::vector<double> itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUseGradientType "/**
UseGradientTypeType itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUseGradientType() const
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUseImageSpacing "/**
bool itk::simple::FastSymmetricForcesDemonsRegistrationFilter::GetUseImageSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetIntensityDifferenceThreshold "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumError "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumKernelWidth "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumRMSError "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumUpdateStepLength "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetMaximumUpdateStepLength(double MaximumUpdateStepLength)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetNumberOfIterations "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetSmoothDisplacementField "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetSmoothUpdateField "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetStandardDeviations(const std::vector< double > &StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetStandardDeviations(double value)

Set the values of the StandardDeviations vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(const std::vector< double > &UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(double value)

Set the values of the UpdateFieldStandardDeviations vector all to
value

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUseGradientType "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUseGradientType(UseGradientTypeType UseGradientType)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUseImageSpacing "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOff "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOn "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOff "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOn "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::ToString "/**
std::string itk::simple::FastSymmetricForcesDemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::UseImageSpacingOff "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::UseImageSpacingOn "/**
Self& itk::simple::FastSymmetricForcesDemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::FastSymmetricForcesDemonsRegistrationFilter::~FastSymmetricForcesDemonsRegistrationFilter "/**
itk::simple::FastSymmetricForcesDemonsRegistrationFilter::~FastSymmetricForcesDemonsRegistrationFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FlipImageFilter "/**

Flips an image across user specified axes.


FlipImageFilter flips an image across user specified axes. The flip axes are set via
method SetFlipAxes( array ) where the input is a
FixedArray<bool,ImageDimension>. The image is flipped across axes for
which array[i] is true.

In terms of grid coordinates the image is flipped within the
LargestPossibleRegion of the input image. As such, the
LargestPossibleRegion of the output image is the same as the input.

In terms of geometric coordinates, the output origin is such that the
image is flipped with respect to the coordinate axes.

Wiki Examples:

All Examples

Flip an image over specified axes
See:
 itk::simple::Flip for the procedural interface

 itk::FlipImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkFlipImageFilter.h
*/"

%javamethodmodifiers  itk::simple::FlipImageFilter::Execute "/**
Image itk::simple::FlipImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::Execute "/**
Image itk::simple::FlipImageFilter::Execute(const Image &image1, const std::vector< bool > &flipAxes, bool
flipAboutOrigin)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::FlipAboutOriginOff "/**
Self& itk::simple::FlipImageFilter::FlipAboutOriginOff()
*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::FlipAboutOriginOn "/**
Self& itk::simple::FlipImageFilter::FlipAboutOriginOn()

Set the value of FlipAboutOrigin to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::FlipImageFilter "/**
itk::simple::FlipImageFilter::FlipImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::GetFlipAboutOrigin "/**
bool itk::simple::FlipImageFilter::GetFlipAboutOrigin() const

Controls how the output origin is computed. If FlipAboutOrigin is
\"On\", the flip will occur about the origin of the axis, otherwise,
the flip will occur about the center of the axis. Default is \"On\".

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::GetFlipAxes "/**
std::vector<bool> itk::simple::FlipImageFilter::GetFlipAxes() const

Set/Get the axis to be flipped. The image is flipped along axes for
which array[i] is true. Default is false.

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::GetName "/**
std::string itk::simple::FlipImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::SetFlipAboutOrigin "/**
Self& itk::simple::FlipImageFilter::SetFlipAboutOrigin(bool FlipAboutOrigin)

Controls how the output origin is computed. If FlipAboutOrigin is
\"On\", the flip will occur about the origin of the axis, otherwise,
the flip will occur about the center of the axis. Default is \"On\".

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::SetFlipAxes "/**
Self& itk::simple::FlipImageFilter::SetFlipAxes(const std::vector< bool > &FlipAxes)

Set/Get the axis to be flipped. The image is flipped along axes for
which array[i] is true. Default is false.

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::ToString "/**
std::string itk::simple::FlipImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::FlipImageFilter::~FlipImageFilter "/**
itk::simple::FlipImageFilter::~FlipImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ForwardFFTImageFilter "/**

Base class for forward Fast Fourier Transform .


This is a base class for the \"forward\" or \"direct\" discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.

This class transforms a real input image into its full complex Fourier
transform. The Fourier transform of a real input image has Hermitian
symmetry: $ f(\\\\mathbf{x}) = f^*(-\\\\mathbf{x}) $ . That is, when the result of the transform is split in half along
the x-dimension, the values in the second half of the transform are
the complex conjugates of values in the first half reflected about the
center of the image in each dimension.

This filter works only for real single-component input image types.


See:
 InverseFFTImageFilter , FFTComplexToComplexImageFilter

 itk::simple::ForwardFFT for the procedural interface

 itk::ForwardFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkForwardFFTImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ForwardFFTImageFilter::Execute "/**
Image itk::simple::ForwardFFTImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::ForwardFFTImageFilter::ForwardFFTImageFilter "/**
itk::simple::ForwardFFTImageFilter::ForwardFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ForwardFFTImageFilter::GetName "/**
std::string itk::simple::ForwardFFTImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ForwardFFTImageFilter::ToString "/**
std::string itk::simple::ForwardFFTImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ForwardFFTImageFilter::~ForwardFFTImageFilter "/**
itk::simple::ForwardFFTImageFilter::~ForwardFFTImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::FunctionCommand "/**

A Command class which allows setting an external function, or member function.

C++ includes: sitkFunctionCommand.h
*/"

%javamethodmodifiers  itk::simple::FunctionCommand::Execute "/**
virtual void itk::simple::FunctionCommand::Execute(void)

The method that defines action to be taken by the command

*/
public ";

%javamethodmodifiers  itk::simple::FunctionCommand::FunctionCommand "/**
itk::simple::FunctionCommand::FunctionCommand()
*/
public ";

%javamethodmodifiers  itk::simple::FunctionCommand::SetCallbackFunction "/**
void itk::simple::FunctionCommand::SetCallbackFunction(T *object, void(T::*pMemberFunction)())

Generic method to set a class's member function to be called in the
Execute method.

*/
public ";

%javamethodmodifiers  itk::simple::FunctionCommand::SetCallbackFunction "/**
void itk::simple::FunctionCommand::SetCallbackFunction(void(*pFunction)())

Set a C-Style function to be called in the Execute method

*/
public ";

%javamethodmodifiers  itk::simple::FunctionCommand::SetCallbackFunction "/**
void itk::simple::FunctionCommand::SetCallbackFunction(void(*pFunction)(void *), void *clientData)

Set a C-Style function with a void* clientData as an argument. The
caller is responsible for managing the life of the clientData and that
it's valid when Execute is called with the clientData.

*/
public ";


%typemap(javaimports) itk::simple::GaborImageSource "/**

Generate an n-dimensional image of a Gabor filter.


GaborImageSource generates an image of either the real (i.e. symmetric) or complex
(i.e. antisymmetric) part of the Gabor filter with the orientation
directed along the x-axis. The GaborKernelFunction is used to evaluate the contribution along the x-axis whereas a non-
normalized 1-D Gaussian envelope provides the contribution in each of
the remaining N dimensions. Orientation can be manipulated via the Transform classes of the toolkit.

The output image may be of any dimension.

This implementation was contributed as a paper to the Insight Journal https://hdl.handle.net/1926/500
See:
 itk::simple::GaborImageSource for the procedural interface

 itk::GaborImageSource for the Doxygen on the original ITK class.


C++ includes: sitkGaborImageSource.h
*/"

%javamethodmodifiers  itk::simple::GaborImageSource::Execute "/**
Image itk::simple::GaborImageSource::Execute()

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::Execute "/**
Image itk::simple::GaborImageSource::Execute(PixelIDValueEnum outputPixelType, const std::vector< unsigned int >
&size, const std::vector< double > &sigma, const std::vector< double >
&mean, double frequency, const std::vector< double > &origin, const
std::vector< double > &spacing, std::vector< double > direction)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GaborImageSource "/**
itk::simple::GaborImageSource::GaborImageSource()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetDirection "/**
std::vector<double> itk::simple::GaborImageSource::GetDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetFrequency "/**
double itk::simple::GaborImageSource::GetFrequency() const

Set/Get the modulation frequency of the sine or cosine component.

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetMean "/**
std::vector<double> itk::simple::GaborImageSource::GetMean() const

Set/Get the mean in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetName "/**
std::string itk::simple::GaborImageSource::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetOrigin "/**
std::vector<double> itk::simple::GaborImageSource::GetOrigin() const
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetOutputPixelType "/**
PixelIDValueEnum itk::simple::GaborImageSource::GetOutputPixelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetSigma "/**
std::vector<double> itk::simple::GaborImageSource::GetSigma() const

Set/Get the the standard deviation in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetSize "/**
std::vector<unsigned int> itk::simple::GaborImageSource::GetSize() const
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::GetSpacing "/**
std::vector<double> itk::simple::GaborImageSource::GetSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetDirection "/**
Self& itk::simple::GaborImageSource::SetDirection(std::vector< double > Direction)
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetFrequency "/**
Self& itk::simple::GaborImageSource::SetFrequency(double Frequency)

Set/Get the modulation frequency of the sine or cosine component.

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetMean "/**
Self& itk::simple::GaborImageSource::SetMean(const std::vector< double > &Mean)

Set/Get the mean in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetMean "/**
Self& itk::simple::GaborImageSource::SetMean(double value)

Set the values of the Mean vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetOrigin "/**
Self& itk::simple::GaborImageSource::SetOrigin(const std::vector< double > &Origin)
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetOutputPixelType "/**
Self& itk::simple::GaborImageSource::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetSigma "/**
Self& itk::simple::GaborImageSource::SetSigma(const std::vector< double > &Sigma)

Set/Get the the standard deviation in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetSigma "/**
Self& itk::simple::GaborImageSource::SetSigma(double value)

Set the values of the Sigma vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetSize "/**
Self& itk::simple::GaborImageSource::SetSize(const std::vector< unsigned int > &Size)
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::SetSpacing "/**
Self& itk::simple::GaborImageSource::SetSpacing(const std::vector< double > &Spacing)
*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::ToString "/**
std::string itk::simple::GaborImageSource::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GaborImageSource::~GaborImageSource "/**
itk::simple::GaborImageSource::~GaborImageSource()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GaussianImageSource "/**

Generate an n-dimensional image of a Gaussian.


GaussianImageSource generates an image of a Gaussian. m_Normalized determines whether or
not the Gaussian is normalized (whether or not the sum over infinite
space is 1.0) When creating an image, it is preferable to not
normalize the Gaussian m_Scale scales the output of the Gaussian to
span a range larger than 0->1, and is typically set to the maximum
value of the output data type (for instance, 255 for uchars)

The output image may be of any dimension.
See:
 itk::simple::GaussianImageSource for the procedural interface

 itk::GaussianImageSource for the Doxygen on the original ITK class.


C++ includes: sitkGaussianImageSource.h
*/"

%javamethodmodifiers  itk::simple::GaussianImageSource::Execute "/**
Image itk::simple::GaussianImageSource::Execute()

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::Execute "/**
Image itk::simple::GaussianImageSource::Execute(PixelIDValueEnum outputPixelType, const std::vector< unsigned int >
&size, const std::vector< double > &sigma, const std::vector< double >
&mean, double scale, const std::vector< double > &origin, const
std::vector< double > &spacing, std::vector< double > direction)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GaussianImageSource "/**
itk::simple::GaussianImageSource::GaussianImageSource()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetDirection "/**
std::vector<double> itk::simple::GaussianImageSource::GetDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetMean "/**
std::vector<double> itk::simple::GaussianImageSource::GetMean() const

Set/Get the mean in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetName "/**
std::string itk::simple::GaussianImageSource::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetOrigin "/**
std::vector<double> itk::simple::GaussianImageSource::GetOrigin() const
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetOutputPixelType "/**
PixelIDValueEnum itk::simple::GaussianImageSource::GetOutputPixelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetScale "/**
double itk::simple::GaussianImageSource::GetScale() const

Gets and sets for Gaussian parameters Set/Get the scale factor to
multiply the true value of the Gaussian.

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetSigma "/**
std::vector<double> itk::simple::GaussianImageSource::GetSigma() const

Set/Get the standard deviation in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetSize "/**
std::vector<unsigned int> itk::simple::GaussianImageSource::GetSize() const
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::GetSpacing "/**
std::vector<double> itk::simple::GaussianImageSource::GetSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetDirection "/**
Self& itk::simple::GaussianImageSource::SetDirection(std::vector< double > Direction)
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetMean "/**
Self& itk::simple::GaussianImageSource::SetMean(const std::vector< double > &Mean)

Set/Get the mean in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetMean "/**
Self& itk::simple::GaussianImageSource::SetMean(double value)

Set the values of the Mean vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetOrigin "/**
Self& itk::simple::GaussianImageSource::SetOrigin(const std::vector< double > &Origin)
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetOutputPixelType "/**
Self& itk::simple::GaussianImageSource::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetScale "/**
Self& itk::simple::GaussianImageSource::SetScale(double Scale)

Gets and sets for Gaussian parameters Set/Get the scale factor to
multiply the true value of the Gaussian.

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetSigma "/**
Self& itk::simple::GaussianImageSource::SetSigma(const std::vector< double > &Sigma)

Set/Get the standard deviation in each direction.

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetSigma "/**
Self& itk::simple::GaussianImageSource::SetSigma(double value)

Set the values of the Sigma vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetSize "/**
Self& itk::simple::GaussianImageSource::SetSize(const std::vector< unsigned int > &Size)
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::SetSpacing "/**
Self& itk::simple::GaussianImageSource::SetSpacing(const std::vector< double > &Spacing)
*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::ToString "/**
std::string itk::simple::GaussianImageSource::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GaussianImageSource::~GaussianImageSource "/**
itk::simple::GaussianImageSource::~GaussianImageSource()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GenericException "/**

The base SimpleITK exception class.

C++ includes: sitkExceptionObject.h
*/"

%javamethodmodifiers  itk::simple::GenericException::GenericException "/**
itk::simple::GenericException::GenericException()
 throw ()
Default constructor. Needed to ensure the exception object can be
copied.

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GenericException "/**
itk::simple::GenericException::GenericException(const GenericException &e)
 throw ()*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GenericException "/**
itk::simple::GenericException::GenericException(const char *file, unsigned int lineNumber)
 throw ()
Constructor. Needed to ensure the exception object can be copied.

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GenericException "/**
itk::simple::GenericException::GenericException(const std::string &file, unsigned int lineNumber)
 throw ()
Constructor. Needed to ensure the exception object can be copied.

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GenericException "/**
itk::simple::GenericException::GenericException(const std::string &file, unsigned int lineNumber, const std::string
&desc)
 throw ()
Constructor. Needed to ensure the exception object can be copied.

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GetDescription "/**
virtual const char* itk::simple::GenericException::GetDescription() const
*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GetFile "/**
virtual const char* itk::simple::GenericException::GetFile() const

What file did the exception occur in?

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GetLine "/**
virtual unsigned int itk::simple::GenericException::GetLine() const

What line did the exception occur in?

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GetLocation "/**
virtual const char* itk::simple::GenericException::GetLocation() const
*/
public ";

%javamethodmodifiers  itk::simple::GenericException::GetNameOfClass "/**
virtual const char* itk::simple::GenericException::GetNameOfClass() const
*/
public ";

%javamethodmodifiers  itk::simple::GenericException::ToString "/**
std::string itk::simple::GenericException::ToString() const

Return a description of the error

*/
public ";

%javamethodmodifiers  itk::simple::GenericException::what "/**
const char* itk::simple::GenericException::what() const
 throw ()*/
public ";

%javamethodmodifiers  itk::simple::GenericException::~GenericException "/**
virtual itk::simple::GenericException::~GenericException()
 throw ( )
Virtual destructor needed for subclasses. Has to have empty throw().

*/
public ";


%typemap(javaimports) itk::simple::GeodesicActiveContourLevelSetImageFilter "/**

Segments structures in images based on a user supplied edge potential
map.


IMPORTANT
The SegmentationLevelSetImageFilter class and the GeodesicActiveContourLevelSetFunction class contain additional information necessary to gain full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. An initial
contour is propagated outwards (or inwards) until it ''sticks'' to the
shape boundaries. This is done by using a level set speed function
based on a user supplied edge potential map.
INPUTS
This filter requires two inputs. The first input is a initial level
set. The initial level set is a real image which contains the initial
contour/surface as the zero level set. For example, a signed distance
function from the initial contour/surface is typically used. Unlike
the simpler ShapeDetectionLevelSetImageFilter the initial contour does not have to lie wholly within the shape to
be segmented. The initial contour is allow to overlap the shape
boundary. The extra advection term in the update equation behaves like
a doublet and attracts the contour to the boundary. This approach for
segmentation follows that of Caselles et al (1997).

The second input is the feature image. For this filter, this is the
edge potential map. General characteristics of an edge potential map
is that it has values close to zero in regions near the edges and
values close to one inside the shape itself. Typically, the edge
potential map is compute from the image gradient, for example:
\\\\[ g(I) = 1 / ( 1 + | (\\\\nabla * G)(I)| ) \\\\] \\\\[ g(I) = \\\\exp^{-|(\\\\nabla * G)(I)|} \\\\]

where $ I $ is image intensity and $ (\\\\nabla * G) $ is the derivative of Gaussian operator.


See SegmentationLevelSetImageFilter and SparseFieldLevelSetImageFilter for more information on Inputs.
PARAMETERS
The PropagationScaling parameter can be used to switch from
propagation outwards (POSITIVE scaling parameter) versus propagating
inwards (NEGATIVE scaling parameter).
 This implementation allows the user to set the weights between the
propagation, advection and curvature term using methods SetPropagationScaling() , SetAdvectionScaling() , SetCurvatureScaling() . In general, the larger the CurvatureScaling, the smoother the
resulting contour. To follow the implementation in Caselles et al
paper, set the PropagationScaling to $ c $ (the inflation or ballon force) and AdvectionScaling and
CurvatureScaling both to 1.0.

OUTPUTS
The filter outputs a single, scalar, real-valued image. Negative
values in the output image represent the inside of the segmented
region and positive values in the image represent the outside of the
segmented region. The zero crossings of the image correspond to the
position of the propagating front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
REFERENCES

\"Geodesic Active Contours\", V. Caselles, R. Kimmel and G. Sapiro.
International Journal on Computer Vision, Vol 22, No. 1, pp 61-97,
1997

See:
 SegmentationLevelSetImageFilter

 GeodesicActiveContourLevelSetFunction

 SparseFieldLevelSetImageFilter

 itk::simple::GeodesicActiveContourLevelSet for the procedural interface

 itk::GeodesicActiveContourLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGeodesicActiveContourLevelSetImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::Execute "/**
Image itk::simple::GeodesicActiveContourLevelSetImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::Execute "/**
Image itk::simple::GeodesicActiveContourLevelSetImageFilter::Execute(const Image &image1, const Image &image2, double maximumRMSError,
double propagationScaling, double curvatureScaling, double
advectionScaling, uint32_t numberOfIterations, bool
reverseExpansionDirection)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GeodesicActiveContourLevelSetImageFilter "/**
itk::simple::GeodesicActiveContourLevelSetImageFilter::GeodesicActiveContourLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetAdvectionScaling "/**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetAdvectionScaling() const
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetCurvatureScaling "/**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetCurvatureScaling() const
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetElapsedIterations "/**
uint32_t itk::simple::GeodesicActiveContourLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetMaximumRMSError "/**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetName "/**
std::string itk::simple::GeodesicActiveContourLevelSetImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::GeodesicActiveContourLevelSetImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetPropagationScaling "/**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetPropagationScaling() const
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetReverseExpansionDirection "/**
bool itk::simple::GeodesicActiveContourLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::GetRMSChange "/**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::ReverseExpansionDirectionOff "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::ReverseExpansionDirectionOn "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::SetAdvectionScaling "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::SetAdvectionScaling(double AdvectionScaling)
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::SetCurvatureScaling "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::SetMaximumRMSError "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::SetNumberOfIterations "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::SetPropagationScaling "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::SetReverseExpansionDirection "/**
Self& itk::simple::GeodesicActiveContourLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::ToString "/**
std::string itk::simple::GeodesicActiveContourLevelSetImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GeodesicActiveContourLevelSetImageFilter::~GeodesicActiveContourLevelSetImageFilter "/**
itk::simple::GeodesicActiveContourLevelSetImageFilter::~GeodesicActiveContourLevelSetImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GradientAnisotropicDiffusionImageFilter "/**

This filter performs anisotropic diffusion on a scalar itk::Image using the classic Perona-Malik, gradient magnitude based equation
implemented in itkGradientNDAnisotropicDiffusionFunction. For detailed
information on anisotropic diffusion, see
itkAnisotropicDiffusionFunction and
itkGradientNDAnisotropicDiffusionFunction.

Inputs and Outputs
The input to this filter should be a scalar itk::Image of any dimensionality. The output image will be a diffused copy of
the input.
Parameters
Please see the description of parameters given in
itkAnisotropicDiffusionImageFilter.

See:
 AnisotropicDiffusionImageFilter

 AnisotropicDiffusionFunction

 GradientAnisotropicDiffusionFunction

 itk::simple::GradientAnisotropicDiffusion for the procedural interface

 itk::GradientAnisotropicDiffusionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGradientAnisotropicDiffusionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep "/**
double itk::simple::GradientAnisotropicDiffusionImageFilter::EstimateOptimalTimeStep(Image &inImage)

This method autmatically sets the optimal timestep for an image given
its spacing.

*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::Execute "/**
Image itk::simple::GradientAnisotropicDiffusionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::Execute "/**
Image itk::simple::GradientAnisotropicDiffusionImageFilter::Execute(const Image &image1, double timeStep, double conductanceParameter,
unsigned int conductanceScalingUpdateInterval, uint32_t
numberOfIterations)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::GetConductanceParameter "/**
double itk::simple::GradientAnisotropicDiffusionImageFilter::GetConductanceParameter() const
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::GetConductanceScalingUpdateInterval "/**
unsigned int itk::simple::GradientAnisotropicDiffusionImageFilter::GetConductanceScalingUpdateInterval() const
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::GetName "/**
std::string itk::simple::GradientAnisotropicDiffusionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::GradientAnisotropicDiffusionImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::GetTimeStep "/**
double itk::simple::GradientAnisotropicDiffusionImageFilter::GetTimeStep() const
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::GradientAnisotropicDiffusionImageFilter "/**
itk::simple::GradientAnisotropicDiffusionImageFilter::GradientAnisotropicDiffusionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::SetConductanceParameter "/**
Self& itk::simple::GradientAnisotropicDiffusionImageFilter::SetConductanceParameter(double ConductanceParameter)
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::SetConductanceScalingUpdateInterval "/**
Self& itk::simple::GradientAnisotropicDiffusionImageFilter::SetConductanceScalingUpdateInterval(unsigned int ConductanceScalingUpdateInterval)
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::SetNumberOfIterations "/**
Self& itk::simple::GradientAnisotropicDiffusionImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::SetTimeStep "/**
Self& itk::simple::GradientAnisotropicDiffusionImageFilter::SetTimeStep(double TimeStep)
*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::ToString "/**
std::string itk::simple::GradientAnisotropicDiffusionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GradientAnisotropicDiffusionImageFilter::~GradientAnisotropicDiffusionImageFilter "/**
itk::simple::GradientAnisotropicDiffusionImageFilter::~GradientAnisotropicDiffusionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GradientImageFilter "/**

Computes the gradient of an image using directional derivatives.


Computes the gradient of an image using directional derivatives. The
directional derivative at each pixel location is computed by
convolution with a first-order derivative operator.

The second template parameter defines the value type used in the
derivative operator (defaults to float). The third template parameter
defines the value type used for output image (defaults to float). The
output image is defined as a covariant vector image whose value type
is specified as this third template parameter.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::Gradient for the procedural interface

 itk::GradientImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGradientImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GradientImageFilter::Execute "/**
Image itk::simple::GradientImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::Execute "/**
Image itk::simple::GradientImageFilter::Execute(const Image &image1, bool useImageSpacing, bool useImageDirection)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::GetName "/**
std::string itk::simple::GradientImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::GetUseImageDirection "/**
bool itk::simple::GradientImageFilter::GetUseImageDirection() const

The UseImageDirection flag determines whether image derivatives are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the derivatives are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::GetUseImageSpacing "/**
bool itk::simple::GradientImageFilter::GetUseImageSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::GradientImageFilter "/**
itk::simple::GradientImageFilter::GradientImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::SetUseImageDirection "/**
Self& itk::simple::GradientImageFilter::SetUseImageDirection(bool UseImageDirection)

The UseImageDirection flag determines whether image derivatives are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the derivatives are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::SetUseImageSpacing "/**
Self& itk::simple::GradientImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::ToString "/**
std::string itk::simple::GradientImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::UseImageDirectionOff "/**
Self& itk::simple::GradientImageFilter::UseImageDirectionOff()
*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::UseImageDirectionOn "/**
Self& itk::simple::GradientImageFilter::UseImageDirectionOn()

Set the value of UseImageDirection to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::UseImageSpacingOff "/**
Self& itk::simple::GradientImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::UseImageSpacingOn "/**
Self& itk::simple::GradientImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GradientImageFilter::~GradientImageFilter "/**
itk::simple::GradientImageFilter::~GradientImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GradientMagnitudeImageFilter "/**

Computes the gradient magnitude of an image region at each pixel.



See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator
Wiki Examples:

All Examples

Compute the gradient magnitude image
See:
 itk::simple::GradientMagnitude for the procedural interface

 itk::GradientMagnitudeImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGradientMagnitudeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::Execute "/**
Image itk::simple::GradientMagnitudeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::Execute "/**
Image itk::simple::GradientMagnitudeImageFilter::Execute(const Image &image1, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::GetName "/**
std::string itk::simple::GradientMagnitudeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::GetUseImageSpacing "/**
bool itk::simple::GradientMagnitudeImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::GradientMagnitudeImageFilter "/**
itk::simple::GradientMagnitudeImageFilter::GradientMagnitudeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::SetUseImageSpacing "/**
Self& itk::simple::GradientMagnitudeImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::ToString "/**
std::string itk::simple::GradientMagnitudeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::UseImageSpacingOff "/**
Self& itk::simple::GradientMagnitudeImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::UseImageSpacingOn "/**
Self& itk::simple::GradientMagnitudeImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeImageFilter::~GradientMagnitudeImageFilter "/**
itk::simple::GradientMagnitudeImageFilter::~GradientMagnitudeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GradientMagnitudeRecursiveGaussianImageFilter "/**

Computes the Magnitude of the Gradient of an image by convolution with
the first derivative of a Gaussian.


This filter is implemented using the recursive gaussian filters

Wiki Examples:

All Examples

Find the gradient magnitude of the image first smoothed with a
Gaussian kernel
See:
 itk::simple::GradientMagnitudeRecursiveGaussian for the procedural interface

 itk::GradientMagnitudeRecursiveGaussianImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGradientMagnitudeRecursiveGaussianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::Execute "/**
Image itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::Execute "/**
Image itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::Execute(const Image &image1, double sigma, bool normalizeAcrossScale)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GetName "/**
std::string itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GetNormalizeAcrossScale "/**
bool itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GetNormalizeAcrossScale() const

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GetSigma "/**
double itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GetSigma() const

Set Sigma value. Sigma is measured in the units of image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GradientMagnitudeRecursiveGaussianImageFilter "/**
itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::GradientMagnitudeRecursiveGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::NormalizeAcrossScaleOff "/**
Self& itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::NormalizeAcrossScaleOff()
*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::NormalizeAcrossScaleOn "/**
Self& itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::SetNormalizeAcrossScale "/**
Self& itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::SetSigma "/**
Self& itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::SetSigma(double Sigma)

Set Sigma value. Sigma is measured in the units of image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::ToString "/**
std::string itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::~GradientMagnitudeRecursiveGaussianImageFilter "/**
itk::simple::GradientMagnitudeRecursiveGaussianImageFilter::~GradientMagnitudeRecursiveGaussianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GradientRecursiveGaussianImageFilter "/**

Computes the gradient of an image by convolution with the first
derivative of a Gaussian.


This filter is implemented using the recursive gaussian filters.

This filter supports both scalar and vector pixel types within the
input image, including VectorImage type.

Wiki Examples:

All Examples

Compute the gradient of an image by convolution with the first
derivative of a Gaussian
See:
 itk::simple::GradientRecursiveGaussian for the procedural interface

 itk::GradientRecursiveGaussianImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGradientRecursiveGaussianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::Execute "/**
Image itk::simple::GradientRecursiveGaussianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::Execute "/**
Image itk::simple::GradientRecursiveGaussianImageFilter::Execute(const Image &image1, double sigma, bool normalizeAcrossScale, bool
useImageDirection)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::GetName "/**
std::string itk::simple::GradientRecursiveGaussianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::GetNormalizeAcrossScale "/**
bool itk::simple::GradientRecursiveGaussianImageFilter::GetNormalizeAcrossScale() const

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::GetSigma "/**
double itk::simple::GradientRecursiveGaussianImageFilter::GetSigma() const
*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::GetUseImageDirection "/**
bool itk::simple::GradientRecursiveGaussianImageFilter::GetUseImageDirection() const

The UseImageDirection flag determines whether the gradients are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the gradients are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::GradientRecursiveGaussianImageFilter "/**
itk::simple::GradientRecursiveGaussianImageFilter::GradientRecursiveGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::NormalizeAcrossScaleOff "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::NormalizeAcrossScaleOff()
*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::NormalizeAcrossScaleOn "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::SetNormalizeAcrossScale "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::SetSigma "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::SetSigma(double Sigma)

Set Sigma value. Sigma is measured in the units of image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::SetUseImageDirection "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::SetUseImageDirection(bool UseImageDirection)

The UseImageDirection flag determines whether the gradients are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the gradients are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::ToString "/**
std::string itk::simple::GradientRecursiveGaussianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::UseImageDirectionOff "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::UseImageDirectionOff()
*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::UseImageDirectionOn "/**
Self& itk::simple::GradientRecursiveGaussianImageFilter::UseImageDirectionOn()

Set the value of UseImageDirection to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GradientRecursiveGaussianImageFilter::~GradientRecursiveGaussianImageFilter "/**
itk::simple::GradientRecursiveGaussianImageFilter::~GradientRecursiveGaussianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleConnectedClosingImageFilter "/**

Enhance pixels associated with a dark object (identified by a seed
pixel) where the dark object is surrounded by a brigher object.


GrayscaleConnectedClosingImagefilter is useful for enhancing dark
objects that are surrounded by bright borders. This filter makes it
easier to threshold the image and extract just the object of interest.

Geodesic morphology and the connected closing algorithm are described
in Chapter 6 of Pierre Soille's book \"Morphological Image Analysis:
Principles and Applications\", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleConnectedClosing for the procedural interface

 itk::GrayscaleConnectedClosingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleConnectedClosingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::Execute "/**
Image itk::simple::GrayscaleConnectedClosingImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::Execute "/**
Image itk::simple::GrayscaleConnectedClosingImageFilter::Execute(const Image &image1, const std::vector< uint32_t > &seed, bool
fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::FullyConnectedOff "/**
Self& itk::simple::GrayscaleConnectedClosingImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::FullyConnectedOn "/**
Self& itk::simple::GrayscaleConnectedClosingImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::GetFullyConnected "/**
bool itk::simple::GrayscaleConnectedClosingImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::GetName "/**
std::string itk::simple::GrayscaleConnectedClosingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::GetSeed "/**
std::vector<uint32_t> itk::simple::GrayscaleConnectedClosingImageFilter::GetSeed() const

Set/Get the seed pixel for the segmentation

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::GrayscaleConnectedClosingImageFilter "/**
itk::simple::GrayscaleConnectedClosingImageFilter::GrayscaleConnectedClosingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::SetFullyConnected "/**
Self& itk::simple::GrayscaleConnectedClosingImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::SetSeed "/**
Self& itk::simple::GrayscaleConnectedClosingImageFilter::SetSeed(const std::vector< uint32_t > &Seed)

Set/Get the seed pixel for the segmentation

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::ToString "/**
std::string itk::simple::GrayscaleConnectedClosingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedClosingImageFilter::~GrayscaleConnectedClosingImageFilter "/**
itk::simple::GrayscaleConnectedClosingImageFilter::~GrayscaleConnectedClosingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleConnectedOpeningImageFilter "/**

Enhance pixels associated with a bright object (identified by a seed
pixel) where the bright object is surrounded by a darker object.


GrayscaleConnectedOpeningImagefilter is useful for enhancing bright
objects that are surrounded by dark borders. This filter makes it
easier to threshold the image and extract just the object of interest.

Geodesic morphology and the connected opening algorithm is described
in Chapter 6 of Pierre Soille's book \"Morphological Image Analysis:
Principles and Applications\", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleConnectedOpening for the procedural interface

 itk::GrayscaleConnectedOpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleConnectedOpeningImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::Execute "/**
Image itk::simple::GrayscaleConnectedOpeningImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::Execute "/**
Image itk::simple::GrayscaleConnectedOpeningImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &seed, bool
fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::FullyConnectedOff "/**
Self& itk::simple::GrayscaleConnectedOpeningImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::FullyConnectedOn "/**
Self& itk::simple::GrayscaleConnectedOpeningImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::GetFullyConnected "/**
bool itk::simple::GrayscaleConnectedOpeningImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::GetName "/**
std::string itk::simple::GrayscaleConnectedOpeningImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::GetSeed "/**
std::vector<unsigned int> itk::simple::GrayscaleConnectedOpeningImageFilter::GetSeed() const

Set/Get the seed pixel for the segmentation

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::GrayscaleConnectedOpeningImageFilter "/**
itk::simple::GrayscaleConnectedOpeningImageFilter::GrayscaleConnectedOpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::SetFullyConnected "/**
Self& itk::simple::GrayscaleConnectedOpeningImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::SetSeed "/**
Self& itk::simple::GrayscaleConnectedOpeningImageFilter::SetSeed(const std::vector< unsigned int > &Seed)

Set/Get the seed pixel for the segmentation

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::ToString "/**
std::string itk::simple::GrayscaleConnectedOpeningImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleConnectedOpeningImageFilter::~GrayscaleConnectedOpeningImageFilter "/**
itk::simple::GrayscaleConnectedOpeningImageFilter::~GrayscaleConnectedOpeningImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleDilateImageFilter "/**

Grayscale dilation of an image.


Dilate an image using grayscale morphology. Dilation takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter
Wiki Examples:

All Examples

Dilate a grayscale image
See:
 itk::simple::GrayscaleDilate for the procedural interface

 itk::GrayscaleDilateImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGrayscaleDilateImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::Execute "/**
Image itk::simple::GrayscaleDilateImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::GrayscaleDilateImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::GetKernelType "/**
KernelEnum itk::simple::GrayscaleDilateImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::GetName "/**
std::string itk::simple::GrayscaleDilateImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::GrayscaleDilateImageFilter "/**
itk::simple::GrayscaleDilateImageFilter::GrayscaleDilateImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleDilateImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleDilateImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleDilateImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleDilateImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::ToString "/**
std::string itk::simple::GrayscaleDilateImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleDilateImageFilter::~GrayscaleDilateImageFilter "/**
itk::simple::GrayscaleDilateImageFilter::~GrayscaleDilateImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleErodeImageFilter "/**

Grayscale erosion of an image.


Erode an image using grayscale morphology. Erosion takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter
Wiki Examples:

All Examples

Erode a grayscale image
See:
 itk::simple::GrayscaleErode for the procedural interface

 itk::GrayscaleErodeImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGrayscaleErodeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::Execute "/**
Image itk::simple::GrayscaleErodeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::GrayscaleErodeImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::GetKernelType "/**
KernelEnum itk::simple::GrayscaleErodeImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::GetName "/**
std::string itk::simple::GrayscaleErodeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::GrayscaleErodeImageFilter "/**
itk::simple::GrayscaleErodeImageFilter::GrayscaleErodeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleErodeImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleErodeImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleErodeImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleErodeImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::ToString "/**
std::string itk::simple::GrayscaleErodeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleErodeImageFilter::~GrayscaleErodeImageFilter "/**
itk::simple::GrayscaleErodeImageFilter::~GrayscaleErodeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleFillholeImageFilter "/**

Remove local minima not connected to the boundary of the image.


GrayscaleFillholeImageFilter fills holes in a grayscale image. Holes are local minima in the
grayscale topography that are not connected to boundaries of the
image. Gray level values adjacent to a hole are extrapolated across
the hole.

This filter is used to smooth over local minima without affecting the
values of local maxima. If you take the difference between the output
of this filter and the original image (and perhaps threshold the
difference above a small value), you'll obtain a map of the local
minima.

This filter uses the ReconstructionByErosionImageFilter . It provides its own input as the \"mask\" input to the geodesic
erosion. The \"marker\" image for the geodesic erosion is constructed
such that boundary pixels match the boundary pixels of the input image
and the interior pixels are set to the maximum pixel value in the
input image.

Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.


See:
 ReconstructionByErosionImageFilter

 MorphologyImageFilter , GrayscaleErodeImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter

 itk::simple::GrayscaleFillhole for the procedural interface

 itk::GrayscaleFillholeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleFillholeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::Execute "/**
Image itk::simple::GrayscaleFillholeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::Execute "/**
Image itk::simple::GrayscaleFillholeImageFilter::Execute(const Image &image1, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::FullyConnectedOff "/**
Self& itk::simple::GrayscaleFillholeImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::FullyConnectedOn "/**
Self& itk::simple::GrayscaleFillholeImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::GetFullyConnected "/**
bool itk::simple::GrayscaleFillholeImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::GetName "/**
std::string itk::simple::GrayscaleFillholeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::GrayscaleFillholeImageFilter "/**
itk::simple::GrayscaleFillholeImageFilter::GrayscaleFillholeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::SetFullyConnected "/**
Self& itk::simple::GrayscaleFillholeImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::ToString "/**
std::string itk::simple::GrayscaleFillholeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleFillholeImageFilter::~GrayscaleFillholeImageFilter "/**
itk::simple::GrayscaleFillholeImageFilter::~GrayscaleFillholeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleGeodesicDilateImageFilter "/**

geodesic gray scale dilation of an image


Geodesic dilation operates on a \"marker\" image and a \"mask\" image.
The marker image is dilated using an elementary structuring element
(neighborhood of radius one using only the face connected neighbors).
The resulting image is then compared with the mask image. The output
image is the pixelwise minimum of the dilated marker image and the
mask image.

Geodesic dilation is run either one iteration or until convergence. In
the convergence case, the filter is equivalent to \"reconstruction by
dilation\". This filter is implemented to handle both scenarios. The
one iteration case is multi-threaded. The convergence case is
delegated to another instance of the same filter (but configured to
run a single iteration).

The marker image must be less than or equal to the mask image (on a
pixel by pixel basis).

Geodesic morphology is described in Chapter 6 of Pierre Soille's book
\"Morphological Image Analysis: Principles and Applications\", Second
Edition, Springer, 2003.

A noniterative version of this algorithm can be found in the ReconstructionByDilationImageFilter . This noniterative solution is much faster than the implementation
provided here. All ITK filters that previously used
GrayscaleGeodesicDiliateImageFilter as part of their implementation
have been converted to use the ReconstructionByDilationImageFilter . The GrayscaleGeodesicDilateImageFilter is maintained for backward compatibility.


See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByDilationImageFilter

 itk::simple::GrayscaleGeodesicDilate for the procedural interface

 itk::GrayscaleGeodesicDilateImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleGeodesicDilateImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::Execute "/**
Image itk::simple::GrayscaleGeodesicDilateImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::Execute "/**
Image itk::simple::GrayscaleGeodesicDilateImageFilter::Execute(const Image &image1, const Image &image2, bool runOneIteration, bool
fullyConnected)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::FullyConnectedOff "/**
Self& itk::simple::GrayscaleGeodesicDilateImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::FullyConnectedOn "/**
Self& itk::simple::GrayscaleGeodesicDilateImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::GetFullyConnected "/**
bool itk::simple::GrayscaleGeodesicDilateImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::GetName "/**
std::string itk::simple::GrayscaleGeodesicDilateImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::GetRunOneIteration "/**
bool itk::simple::GrayscaleGeodesicDilateImageFilter::GetRunOneIteration() const

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
\"reconstruction by dilation\". Default is off.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::GrayscaleGeodesicDilateImageFilter "/**
itk::simple::GrayscaleGeodesicDilateImageFilter::GrayscaleGeodesicDilateImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::RunOneIterationOff "/**
Self& itk::simple::GrayscaleGeodesicDilateImageFilter::RunOneIterationOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::RunOneIterationOn "/**
Self& itk::simple::GrayscaleGeodesicDilateImageFilter::RunOneIterationOn()

Set the value of RunOneIteration to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::SetFullyConnected "/**
Self& itk::simple::GrayscaleGeodesicDilateImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::SetRunOneIteration "/**
Self& itk::simple::GrayscaleGeodesicDilateImageFilter::SetRunOneIteration(bool RunOneIteration)

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
\"reconstruction by dilation\". Default is off.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::ToString "/**
std::string itk::simple::GrayscaleGeodesicDilateImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicDilateImageFilter::~GrayscaleGeodesicDilateImageFilter "/**
itk::simple::GrayscaleGeodesicDilateImageFilter::~GrayscaleGeodesicDilateImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleGeodesicErodeImageFilter "/**

geodesic gray scale erosion of an image


Geodesic erosion operates on a \"marker\" image and a \"mask\" image.
The marker image is eroded using an elementary structuring element
(neighborhood of radius one using only the face connected neighbors).
The resulting image is then compared with the mask image. The output
image is the pixelwise maximum of the eroded marker image and the mask
image.

Geodesic erosion is run either one iteration or until convergence. In
the convergence case, the filter is equivalent to \"reconstruction by
erosion\". This filter is implemented to handle both scenarios. The
one iteration case is multi-threaded. The convergence case is
delegated to another instance of the same filter (but configured to
run a single iteration).

The marker image must be greater than or equal to the mask image (on a
pixel by pixel basis).

Geodesic morphology is described in Chapter 6 of Pierre Soille's book
\"Morphological Image Analysis: Principles and Applications\", Second
Edition, Springer, 2003.

A noniterative version of this algorithm can be found in the ReconstructionByErosionImageFilter . This noniterative solution is much faster than the implementation
provided here. All ITK filters that previously used GrayscaleGeodesicErodeImageFilter as part of their implementation have been converted to use the ReconstructionByErosionImageFilter . The GrayscaleGeodesicErodeImageFilter is maintained for backward compatibility.


See:
 MorphologyImageFilter , GrayscaleErodeImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter , ReconstructionByErosionImageFilter

 itk::simple::GrayscaleGeodesicErode for the procedural interface

 itk::GrayscaleGeodesicErodeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleGeodesicErodeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::Execute "/**
Image itk::simple::GrayscaleGeodesicErodeImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::Execute "/**
Image itk::simple::GrayscaleGeodesicErodeImageFilter::Execute(const Image &image1, const Image &image2, bool runOneIteration, bool
fullyConnected)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::FullyConnectedOff "/**
Self& itk::simple::GrayscaleGeodesicErodeImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::FullyConnectedOn "/**
Self& itk::simple::GrayscaleGeodesicErodeImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::GetFullyConnected "/**
bool itk::simple::GrayscaleGeodesicErodeImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::GetName "/**
std::string itk::simple::GrayscaleGeodesicErodeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::GetRunOneIteration "/**
bool itk::simple::GrayscaleGeodesicErodeImageFilter::GetRunOneIteration() const

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
\"reconstruction by erosion\". Default is off.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::GrayscaleGeodesicErodeImageFilter "/**
itk::simple::GrayscaleGeodesicErodeImageFilter::GrayscaleGeodesicErodeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::RunOneIterationOff "/**
Self& itk::simple::GrayscaleGeodesicErodeImageFilter::RunOneIterationOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::RunOneIterationOn "/**
Self& itk::simple::GrayscaleGeodesicErodeImageFilter::RunOneIterationOn()

Set the value of RunOneIteration to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::SetFullyConnected "/**
Self& itk::simple::GrayscaleGeodesicErodeImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::SetRunOneIteration "/**
Self& itk::simple::GrayscaleGeodesicErodeImageFilter::SetRunOneIteration(bool RunOneIteration)

Set/Get whether the filter should run one iteration or until
convergence. When run to convergence, this filter is equivalent to
\"reconstruction by erosion\". Default is off.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::ToString "/**
std::string itk::simple::GrayscaleGeodesicErodeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGeodesicErodeImageFilter::~GrayscaleGeodesicErodeImageFilter "/**
itk::simple::GrayscaleGeodesicErodeImageFilter::~GrayscaleGeodesicErodeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleGrindPeakImageFilter "/**

Remove local maxima not connected to the boundary of the image.


GrayscaleGrindPeakImageFilter removes peaks in a grayscale image. Peaks are local maxima in the
grayscale topography that are not connected to boundaries of the
image. Gray level values adjacent to a peak are extrapolated through
the peak.

This filter is used to smooth over local maxima without affecting the
values of local minima. If you take the difference between the output
of this filter and the original image (and perhaps threshold the
difference above a small value), you'll obtain a map of the local
maxima.

This filter uses the GrayscaleGeodesicDilateImageFilter . It provides its own input as the \"mask\" input to the geodesic
erosion. The \"marker\" image for the geodesic erosion is constructed
such that boundary pixels match the boundary pixels of the input image
and the interior pixels are set to the minimum pixel value in the
input image.

This filter is the dual to the GrayscaleFillholeImageFilter which implements the Fillhole algorithm. Since it is a dual, it is
somewhat superfluous but is provided as a convenience.

Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleGrindPeak for the procedural interface

 itk::GrayscaleGrindPeakImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleGrindPeakImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::Execute "/**
Image itk::simple::GrayscaleGrindPeakImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::Execute "/**
Image itk::simple::GrayscaleGrindPeakImageFilter::Execute(const Image &image1, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::FullyConnectedOff "/**
Self& itk::simple::GrayscaleGrindPeakImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::FullyConnectedOn "/**
Self& itk::simple::GrayscaleGrindPeakImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::GetFullyConnected "/**
bool itk::simple::GrayscaleGrindPeakImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::GetName "/**
std::string itk::simple::GrayscaleGrindPeakImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::GrayscaleGrindPeakImageFilter "/**
itk::simple::GrayscaleGrindPeakImageFilter::GrayscaleGrindPeakImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::SetFullyConnected "/**
Self& itk::simple::GrayscaleGrindPeakImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::ToString "/**
std::string itk::simple::GrayscaleGrindPeakImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleGrindPeakImageFilter::~GrayscaleGrindPeakImageFilter "/**
itk::simple::GrayscaleGrindPeakImageFilter::~GrayscaleGrindPeakImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleMorphologicalClosingImageFilter "/**

gray scale dilation of an image


Erode an image using grayscale morphology. Dilation takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter

 itk::simple::GrayscaleMorphologicalClosing for the procedural interface

 itk::GrayscaleMorphologicalClosingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleMorphologicalClosingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::Execute "/**
Image itk::simple::GrayscaleMorphologicalClosingImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::Execute "/**
Image itk::simple::GrayscaleMorphologicalClosingImageFilter::Execute(const Image &image1, bool safeBorder)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::GrayscaleMorphologicalClosingImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::GetKernelType "/**
KernelEnum itk::simple::GrayscaleMorphologicalClosingImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::GetName "/**
std::string itk::simple::GrayscaleMorphologicalClosingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::GetSafeBorder "/**
bool itk::simple::GrayscaleMorphologicalClosingImageFilter::GetSafeBorder() const

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::GrayscaleMorphologicalClosingImageFilter "/**
itk::simple::GrayscaleMorphologicalClosingImageFilter::GrayscaleMorphologicalClosingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SafeBorderOff "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SafeBorderOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SafeBorderOn "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SafeBorderOn()

Set the value of SafeBorder to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::SetSafeBorder "/**
Self& itk::simple::GrayscaleMorphologicalClosingImageFilter::SetSafeBorder(bool SafeBorder)

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::ToString "/**
std::string itk::simple::GrayscaleMorphologicalClosingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalClosingImageFilter::~GrayscaleMorphologicalClosingImageFilter "/**
itk::simple::GrayscaleMorphologicalClosingImageFilter::~GrayscaleMorphologicalClosingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GrayscaleMorphologicalOpeningImageFilter "/**

gray scale dilation of an image


Dilate an image using grayscale morphology. Dilation takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleMorphologicalOpening for the procedural interface

 itk::GrayscaleMorphologicalOpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleMorphologicalOpeningImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::Execute "/**
Image itk::simple::GrayscaleMorphologicalOpeningImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::Execute "/**
Image itk::simple::GrayscaleMorphologicalOpeningImageFilter::Execute(const Image &image1, bool safeBorder)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetKernelType "/**
KernelEnum itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetName "/**
std::string itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetSafeBorder "/**
bool itk::simple::GrayscaleMorphologicalOpeningImageFilter::GetSafeBorder() const

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::GrayscaleMorphologicalOpeningImageFilter "/**
itk::simple::GrayscaleMorphologicalOpeningImageFilter::GrayscaleMorphologicalOpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SafeBorderOff "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SafeBorderOff()
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SafeBorderOn "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SafeBorderOn()

Set the value of SafeBorder to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelRadius "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelType "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetSafeBorder "/**
Self& itk::simple::GrayscaleMorphologicalOpeningImageFilter::SetSafeBorder(bool SafeBorder)

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::ToString "/**
std::string itk::simple::GrayscaleMorphologicalOpeningImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GrayscaleMorphologicalOpeningImageFilter::~GrayscaleMorphologicalOpeningImageFilter "/**
itk::simple::GrayscaleMorphologicalOpeningImageFilter::~GrayscaleMorphologicalOpeningImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GreaterEqualImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::GreaterEqual for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGreaterEqualImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::Execute "/**
Image itk::simple::GreaterEqualImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::Execute "/**
Image itk::simple::GreaterEqualImageFilter::Execute(const Image &image1, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::Execute "/**
Image itk::simple::GreaterEqualImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::Execute "/**
Image itk::simple::GreaterEqualImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::Execute "/**
Image itk::simple::GreaterEqualImageFilter::Execute(const Image &image1, double constant, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on an image and a constant with the given
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::Execute "/**
Image itk::simple::GreaterEqualImageFilter::Execute(double constant, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::GreaterEqualImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::GetForegroundValue "/**
uint8_t itk::simple::GreaterEqualImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::GetName "/**
std::string itk::simple::GreaterEqualImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::GreaterEqualImageFilter "/**
itk::simple::GreaterEqualImageFilter::GreaterEqualImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::SetBackgroundValue "/**
Self& itk::simple::GreaterEqualImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::SetForegroundValue "/**
Self& itk::simple::GreaterEqualImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::ToString "/**
std::string itk::simple::GreaterEqualImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GreaterEqualImageFilter::~GreaterEqualImageFilter "/**
itk::simple::GreaterEqualImageFilter::~GreaterEqualImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GreaterImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::Greater for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkGreaterImageFilter.h
*/"

%javamethodmodifiers  itk::simple::GreaterImageFilter::Execute "/**
Image itk::simple::GreaterImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::Execute "/**
Image itk::simple::GreaterImageFilter::Execute(const Image &image1, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::Execute "/**
Image itk::simple::GreaterImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::Execute "/**
Image itk::simple::GreaterImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::Execute "/**
Image itk::simple::GreaterImageFilter::Execute(const Image &image1, double constant, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on an image and a constant with the given
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::Execute "/**
Image itk::simple::GreaterImageFilter::Execute(double constant, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::GreaterImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::GetForegroundValue "/**
uint8_t itk::simple::GreaterImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::GetName "/**
std::string itk::simple::GreaterImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::GreaterImageFilter "/**
itk::simple::GreaterImageFilter::GreaterImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::SetBackgroundValue "/**
Self& itk::simple::GreaterImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::SetForegroundValue "/**
Self& itk::simple::GreaterImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::ToString "/**
std::string itk::simple::GreaterImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GreaterImageFilter::~GreaterImageFilter "/**
itk::simple::GreaterImageFilter::~GreaterImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::GridImageSource "/**

Generate an n-dimensional image of a grid.


GridImageSource generates an image of a grid. From the abstract... \"Certain classes
of images find disparate use amongst members of the ITK community for
such purposes as visualization, simulation, testing, etc. Currently
there exists two derived classes from the ImageSource class used for
generating specific images for various applications, viz.
RandomImageSource and GaussianImageSource . We propose to add to this
set with the class GridImageSource which, obviously enough, produces a
grid image. Such images are useful for visualizing deformation when
used in conjunction with the WarpImageFilter , simulating magnetic
resonance tagging images, or creating optical illusions with which to
amaze your friends.\"

The output image may be of any dimension.


Tustison N., Avants B., Gee J. University of Pennsylvania
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/475
See:
 itk::simple::GridImageSource for the procedural interface

 itk::GridImageSource for the Doxygen on the original ITK class.


C++ includes: sitkGridImageSource.h
*/"

%javamethodmodifiers  itk::simple::GridImageSource::Execute "/**
Image itk::simple::GridImageSource::Execute()

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::Execute "/**
Image itk::simple::GridImageSource::Execute(PixelIDValueEnum outputPixelType, const std::vector< unsigned int >
&size, const std::vector< double > &sigma, const std::vector< double >
&gridSpacing, const std::vector< double > &gridOffset, double scale,
const std::vector< double > &origin, const std::vector< double >
&spacing, std::vector< double > direction)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetDirection "/**
std::vector<double> itk::simple::GridImageSource::GetDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetGridOffset "/**
std::vector<double> itk::simple::GridImageSource::GetGridOffset() const

Set/Get the grid offset.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetGridSpacing "/**
std::vector<double> itk::simple::GridImageSource::GetGridSpacing() const

Set/Get the grid spacing of the peaks.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetName "/**
std::string itk::simple::GridImageSource::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetOrigin "/**
std::vector<double> itk::simple::GridImageSource::GetOrigin() const
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetOutputPixelType "/**
PixelIDValueEnum itk::simple::GridImageSource::GetOutputPixelType() const
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetScale "/**
double itk::simple::GridImageSource::GetScale() const

Set/Get the scale factor to multiply the true value of the grid.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetSigma "/**
std::vector<double> itk::simple::GridImageSource::GetSigma() const

Set/Get the standard deviation of the Gaussians or width of the box
functions.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetSize "/**
std::vector<unsigned int> itk::simple::GridImageSource::GetSize() const
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GetSpacing "/**
std::vector<double> itk::simple::GridImageSource::GetSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::GridImageSource "/**
itk::simple::GridImageSource::GridImageSource()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetDirection "/**
Self& itk::simple::GridImageSource::SetDirection(std::vector< double > Direction)
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetGridOffset "/**
Self& itk::simple::GridImageSource::SetGridOffset(const std::vector< double > &GridOffset)

Set/Get the grid offset.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetGridSpacing "/**
Self& itk::simple::GridImageSource::SetGridSpacing(const std::vector< double > &GridSpacing)

Set/Get the grid spacing of the peaks.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetOrigin "/**
Self& itk::simple::GridImageSource::SetOrigin(const std::vector< double > &Origin)
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetOutputPixelType "/**
Self& itk::simple::GridImageSource::SetOutputPixelType(PixelIDValueEnum OutputPixelType)
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetScale "/**
Self& itk::simple::GridImageSource::SetScale(double Scale)

Set/Get the scale factor to multiply the true value of the grid.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetSigma "/**
Self& itk::simple::GridImageSource::SetSigma(const std::vector< double > &Sigma)

Set/Get the standard deviation of the Gaussians or width of the box
functions.

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetSigma "/**
Self& itk::simple::GridImageSource::SetSigma(double value)

Set the values of the Sigma vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetSize "/**
Self& itk::simple::GridImageSource::SetSize(const std::vector< unsigned int > &Size)
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::SetSpacing "/**
Self& itk::simple::GridImageSource::SetSpacing(const std::vector< double > &Spacing)
*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::ToString "/**
std::string itk::simple::GridImageSource::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::GridImageSource::~GridImageSource "/**
itk::simple::GridImageSource::~GridImageSource()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HConcaveImageFilter "/**

Identify local minima whose depth below the baseline is greater than
h.


HConcaveImageFilter extract local minima that are more than h intensity units below the
(local) background. This has the effect of extracting objects that are
darker than the background by at least h intensity units.

This filter uses the HMinimaImageFilter .

Geodesic morphology and the H-Convex algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter , HMaximaImageFilter ,

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HConcave for the procedural interface

 itk::HConcaveImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHConcaveImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HConcaveImageFilter::Execute "/**
Image itk::simple::HConcaveImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::Execute "/**
Image itk::simple::HConcaveImageFilter::Execute(const Image &image1, double height, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::FullyConnectedOff "/**
Self& itk::simple::HConcaveImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::FullyConnectedOn "/**
Self& itk::simple::HConcaveImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::GetFullyConnected "/**
bool itk::simple::HConcaveImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::GetHeight "/**
double itk::simple::HConcaveImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::GetName "/**
std::string itk::simple::HConcaveImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::HConcaveImageFilter "/**
itk::simple::HConcaveImageFilter::HConcaveImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::SetFullyConnected "/**
Self& itk::simple::HConcaveImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::SetHeight "/**
Self& itk::simple::HConcaveImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::ToString "/**
std::string itk::simple::HConcaveImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HConcaveImageFilter::~HConcaveImageFilter "/**
itk::simple::HConcaveImageFilter::~HConcaveImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HConvexImageFilter "/**

Identify local maxima whose height above the baseline is greater than
h.


HConvexImageFilter extract local maxima that are more than h intensity units above the
(local) background. This has the effect of extracting objects that are
brighter than background by at least h intensity units.

This filter uses the HMaximaImageFilter .

Geodesic morphology and the H-Convex algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter , HMinimaImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HConvex for the procedural interface

 itk::HConvexImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHConvexImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HConvexImageFilter::Execute "/**
Image itk::simple::HConvexImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::Execute "/**
Image itk::simple::HConvexImageFilter::Execute(const Image &image1, double height, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::FullyConnectedOff "/**
Self& itk::simple::HConvexImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::FullyConnectedOn "/**
Self& itk::simple::HConvexImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::GetFullyConnected "/**
bool itk::simple::HConvexImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::GetHeight "/**
double itk::simple::HConvexImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::GetName "/**
std::string itk::simple::HConvexImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::HConvexImageFilter "/**
itk::simple::HConvexImageFilter::HConvexImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::SetFullyConnected "/**
Self& itk::simple::HConvexImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::SetHeight "/**
Self& itk::simple::HConvexImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::ToString "/**
std::string itk::simple::HConvexImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HConvexImageFilter::~HConvexImageFilter "/**
itk::simple::HConvexImageFilter::~HConvexImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HMaximaImageFilter "/**

Suppress local maxima whose height above the baseline is less than h.


HMaximaImageFilter suppresses local maxima that are less than h intensity units above
the (local) background. This has the effect of smoothing over the
\"high\" parts of the noise in the image without smoothing over large
changes in intensity (region boundaries). See the HMinimaImageFilter to suppress the local minima whose depth is less than h intensity
units below the (local) background.

If the output of HMaximaImageFilter is subtracted from the original image, the signicant \"peaks\" in the
image can be identified. This is what the HConvexImageFilter provides.

This filter uses the ReconstructionByDilationImageFilter . It provides its own input as the \"mask\" input to the geodesic
dilation. The \"marker\" image for the geodesic dilation is the input
image minus the height parameter h.

Geodesic morphology and the H-Maxima algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.

The height parameter is set using SetHeight.


See:
 ReconstructionByDilationImageFilter , HMinimaImageFilter , HConvexImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HMaxima for the procedural interface

 itk::HMaximaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHMaximaImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HMaximaImageFilter::Execute "/**
Image itk::simple::HMaximaImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::Execute "/**
Image itk::simple::HMaximaImageFilter::Execute(const Image &image1, double height)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::GetHeight "/**
double itk::simple::HMaximaImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::GetName "/**
std::string itk::simple::HMaximaImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::HMaximaImageFilter "/**
itk::simple::HMaximaImageFilter::HMaximaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::SetHeight "/**
Self& itk::simple::HMaximaImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::ToString "/**
std::string itk::simple::HMaximaImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HMaximaImageFilter::~HMaximaImageFilter "/**
itk::simple::HMaximaImageFilter::~HMaximaImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HMinimaImageFilter "/**

Suppress local minima whose depth below the baseline is less than h.


HMinimaImageFilter suppresses local minima that are less than h intensity units below
the (local) background. This has the effect of smoothing over the
\"low\" parts of the noise in the image without smoothing over large
changes in intensity (region boundaries). See the HMaximaImageFilter to suppress the local maxima whose height is less than h intensity
units above the (local) background.

If original image is subtracted from the output of HMinimaImageFilter , the signicant \"valleys\" in the image can be identified. This is
what the HConcaveImageFilter provides.

This filter uses the GrayscaleGeodesicErodeImageFilter . It provides its own input as the \"mask\" input to the geodesic
dilation. The \"marker\" image for the geodesic dilation is the input
image plus the height parameter h.

Geodesic morphology and the H-Minima algorithm is described in Chapter
6 of Pierre Soille's book \"Morphological Image Analysis: Principles
and Applications\", Second Edition, Springer, 2003.


See:
 GrayscaleGeodesicDilateImageFilter , HMinimaImageFilter , HConvexImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::HMinima for the procedural interface

 itk::HMinimaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHMinimaImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HMinimaImageFilter::Execute "/**
Image itk::simple::HMinimaImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::Execute "/**
Image itk::simple::HMinimaImageFilter::Execute(const Image &image1, double height, bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::FullyConnectedOff "/**
Self& itk::simple::HMinimaImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::FullyConnectedOn "/**
Self& itk::simple::HMinimaImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::GetFullyConnected "/**
bool itk::simple::HMinimaImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::GetHeight "/**
double itk::simple::HMinimaImageFilter::GetHeight() const

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::GetName "/**
std::string itk::simple::HMinimaImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::HMinimaImageFilter "/**
itk::simple::HMinimaImageFilter::HMinimaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::SetFullyConnected "/**
Self& itk::simple::HMinimaImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::SetHeight "/**
Self& itk::simple::HMinimaImageFilter::SetHeight(double Height)

Set/Get the height that a local maximum must be above the local
background (local contrast) in order to survive the processing. Local
maxima below this value are replaced with an estimate of the local
background.

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::ToString "/**
std::string itk::simple::HMinimaImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HMinimaImageFilter::~HMinimaImageFilter "/**
itk::simple::HMinimaImageFilter::~HMinimaImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HalfHermitianToRealInverseFFTImageFilter "/**

Base class for specialized complex-to-real inverse Fast Fourier Transform .


This is a base class for the \"inverse\" or \"reverse\" Discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.

The input to this filter is assumed to have the same format as the
output of the RealToHalfHermitianForwardFFTImageFilter . That is, the input is assumed to consist of roughly half the full
complex image resulting from a real-to-complex discrete Fourier
transform. This half is expected to be the first half of the image in
the X-dimension. Because this filter assumes that the input stores
only about half of the non-redundant complex pixels, the output is
larger in the X-dimension than it is in the input. To determine the
actual size of the output image, this filter needs additional
information in the form of a flag indicating whether the output image
has an odd size in the X-dimension. Use SetActualXDimensionIsOdd() to set this flag.


See:
 ForwardFFTImageFilter , HalfHermitianToRealInverseFFTImageFilter

 itk::simple::HalfHermitianToRealInverseFFT for the procedural interface

 itk::HalfHermitianToRealInverseFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHalfHermitianToRealInverseFFTImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::ActualXDimensionIsOddOff "/**
Self& itk::simple::HalfHermitianToRealInverseFFTImageFilter::ActualXDimensionIsOddOff()
*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::ActualXDimensionIsOddOn "/**
Self& itk::simple::HalfHermitianToRealInverseFFTImageFilter::ActualXDimensionIsOddOn()

Set the value of ActualXDimensionIsOdd to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::Execute "/**
Image itk::simple::HalfHermitianToRealInverseFFTImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::Execute "/**
Image itk::simple::HalfHermitianToRealInverseFFTImageFilter::Execute(const Image &image1, bool actualXDimensionIsOdd)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::GetActualXDimensionIsOdd "/**
bool itk::simple::HalfHermitianToRealInverseFFTImageFilter::GetActualXDimensionIsOdd() const

Was the original truncated dimension size odd?

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::GetName "/**
std::string itk::simple::HalfHermitianToRealInverseFFTImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::HalfHermitianToRealInverseFFTImageFilter "/**
itk::simple::HalfHermitianToRealInverseFFTImageFilter::HalfHermitianToRealInverseFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::SetActualXDimensionIsOdd "/**
Self& itk::simple::HalfHermitianToRealInverseFFTImageFilter::SetActualXDimensionIsOdd(bool ActualXDimensionIsOdd)

Was the original truncated dimension size odd?

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::ToString "/**
std::string itk::simple::HalfHermitianToRealInverseFFTImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HalfHermitianToRealInverseFFTImageFilter::~HalfHermitianToRealInverseFFTImageFilter "/**
itk::simple::HalfHermitianToRealInverseFFTImageFilter::~HalfHermitianToRealInverseFFTImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HashImageFilter "/**

Compute the sha1 or md5 hash of an image.



See:
 itk::simple::Hash for the procedural interface


C++ includes: sitkHashImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HashImageFilter::Execute "/**
std::string itk::simple::HashImageFilter::Execute(const Image &)
*/
public ";

%javamethodmodifiers  itk::simple::HashImageFilter::GetHashFunction "/**
HashFunction itk::simple::HashImageFilter::GetHashFunction() const
*/
public ";

%javamethodmodifiers  itk::simple::HashImageFilter::GetName "/**
std::string itk::simple::HashImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HashImageFilter::HashImageFilter "/**
itk::simple::HashImageFilter::HashImageFilter()
*/
public ";

%javamethodmodifiers  itk::simple::HashImageFilter::SetHashFunction "/**
Self& itk::simple::HashImageFilter::SetHashFunction(HashFunction hashFunction)
*/
public ";

%javamethodmodifiers  itk::simple::HashImageFilter::ToString "/**
std::string itk::simple::HashImageFilter::ToString() const
*/
public ";


%typemap(javaimports) itk::simple::HausdorffDistanceImageFilter "/**

Computes the Hausdorff distance between the set of non-zero pixels of
two images.


HausdorffDistanceImageFilter computes the distance between the set non-zero pixels of two images
using the following formula: \\\\[ H(A,B) = \\\\max(h(A,B),h(B,A)) \\\\] where \\\\[ h(A,B) = \\\\max_{a \\\\in A} \\\\min_{b \\\\in B} \\\\| a -
b\\\\| \\\\] is the directed Hausdorff distance and $A$ and $B$ are respectively the set of non-zero pixels in the first and second
input images.

In particular, this filter uses the DirectedHausdorffImageFilter
inside to compute the two directed distances and then select the
largest of the two.

The Hausdorff distance measures the degree of mismatch between two
sets and behaves like a metric over the set of all closed bounded sets
- with properties of identity, symmetry and triangle inequality.

This filter requires the largest possible region of the first image
and the same corresponding region in the second image. It behaves as
filter with two inputs and one output. Thus it can be inserted in a
pipeline with other filters. The filter passes the first input through
unmodified.

This filter is templated over the two input image types. It assume
both images have the same number of dimensions.


See:
 DirectedHausdorffDistanceImageFilter

 itk::HausdorffDistanceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHausdorffDistanceImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::Execute "/**
void itk::simple::HausdorffDistanceImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::GetAverageHausdorffDistance "/**
double itk::simple::HausdorffDistanceImageFilter::GetAverageHausdorffDistance() const

Return the computed Hausdorff distance.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::GetHausdorffDistance "/**
double itk::simple::HausdorffDistanceImageFilter::GetHausdorffDistance() const

Return the computed Hausdorff distance.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::GetName "/**
std::string itk::simple::HausdorffDistanceImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::HausdorffDistanceImageFilter "/**
itk::simple::HausdorffDistanceImageFilter::HausdorffDistanceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::ToString "/**
std::string itk::simple::HausdorffDistanceImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HausdorffDistanceImageFilter::~HausdorffDistanceImageFilter "/**
itk::simple::HausdorffDistanceImageFilter::~HausdorffDistanceImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HistogramMatchingImageFilter "/**

Normalize the grayscale values between two images by histogram
matching.


HistogramMatchingImageFilter normalizes the grayscale values of a source image based on the
grayscale values of a reference image. This filter uses a histogram
matching technique where the histograms of the two images are matched
only at a specified number of quantile values.

This filter was originally designed to normalize MR images of the same
MR protocol and same body part. The algorithm works best if background
pixels are excluded from both the source and reference histograms. A
simple background exclusion method is to exclude all pixels whose
grayscale values are smaller than the mean grayscale value. ThresholdAtMeanIntensityOn() switches on this simple background exclusion method.

The source image can be set via either SetInput() or SetSourceImage()
. The reference image can be set via SetReferenceImage() .

SetNumberOfHistogramLevels() sets the number of bins used when creating histograms of the source
and reference images. SetNumberOfMatchPoints() governs the number of quantile values to be matched.

This filter assumes that both the source and reference are of the same
type and that the input and output image type have the same number of
dimension and have scalar pixel types.

REFERENCE
Laszlo G. Nyul, Jayaram K. Udupa, and Xuan Zhang, \"New Variants of a
Method of MRI Scale Standardization\", IEEE Transactions on Medical
Imaging, 19(2):143-150, 2000.

See:
 itk::simple::HistogramMatching for the procedural interface

 itk::HistogramMatchingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHistogramMatchingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::Execute "/**
Image itk::simple::HistogramMatchingImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::Execute "/**
Image itk::simple::HistogramMatchingImageFilter::Execute(const Image &image1, const Image &image2, uint32_t
numberOfHistogramLevels, uint32_t numberOfMatchPoints, bool
thresholdAtMeanIntensity)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::GetName "/**
std::string itk::simple::HistogramMatchingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::GetNumberOfHistogramLevels "/**
uint32_t itk::simple::HistogramMatchingImageFilter::GetNumberOfHistogramLevels() const

Set/Get the number of histogram levels used.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::GetNumberOfMatchPoints "/**
uint32_t itk::simple::HistogramMatchingImageFilter::GetNumberOfMatchPoints() const

Set/Get the number of match points used.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::GetThresholdAtMeanIntensity "/**
bool itk::simple::HistogramMatchingImageFilter::GetThresholdAtMeanIntensity() const

Set/Get the threshold at mean intensity flag. If true, only source
(reference) pixels which are greater than the mean source (reference)
intensity is used in the histogram matching. If false, all pixels are
used.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::HistogramMatchingImageFilter "/**
itk::simple::HistogramMatchingImageFilter::HistogramMatchingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::SetNumberOfHistogramLevels "/**
Self& itk::simple::HistogramMatchingImageFilter::SetNumberOfHistogramLevels(uint32_t NumberOfHistogramLevels)

Set/Get the number of histogram levels used.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::SetNumberOfMatchPoints "/**
Self& itk::simple::HistogramMatchingImageFilter::SetNumberOfMatchPoints(uint32_t NumberOfMatchPoints)

Set/Get the number of match points used.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::SetThresholdAtMeanIntensity "/**
Self& itk::simple::HistogramMatchingImageFilter::SetThresholdAtMeanIntensity(bool ThresholdAtMeanIntensity)

Set/Get the threshold at mean intensity flag. If true, only source
(reference) pixels which are greater than the mean source (reference)
intensity is used in the histogram matching. If false, all pixels are
used.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::ThresholdAtMeanIntensityOff "/**
Self& itk::simple::HistogramMatchingImageFilter::ThresholdAtMeanIntensityOff()
*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::ThresholdAtMeanIntensityOn "/**
Self& itk::simple::HistogramMatchingImageFilter::ThresholdAtMeanIntensityOn()

Set the value of ThresholdAtMeanIntensity to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::ToString "/**
std::string itk::simple::HistogramMatchingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HistogramMatchingImageFilter::~HistogramMatchingImageFilter "/**
itk::simple::HistogramMatchingImageFilter::~HistogramMatchingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::HuangThresholdImageFilter "/**

Threshold an image using the Huang Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the HuangThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::HuangThreshold for the procedural interface

 itk::HuangThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHuangThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::Execute "/**
Image itk::simple::HuangThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::Execute "/**
Image itk::simple::HuangThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::Execute "/**
Image itk::simple::HuangThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::Execute "/**
Image itk::simple::HuangThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::HuangThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::HuangThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::HuangThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetName "/**
std::string itk::simple::HuangThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::HuangThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::HuangThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::GetThreshold "/**
double itk::simple::HuangThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::HuangThresholdImageFilter "/**
itk::simple::HuangThresholdImageFilter::HuangThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::HuangThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::HuangThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::HuangThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value. The default value NumericTraits<OutputPixelType>::max()

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::HuangThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::HuangThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::HuangThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins. Defaults is 128.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::HuangThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::ToString "/**
std::string itk::simple::HuangThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::HuangThresholdImageFilter::~HuangThresholdImageFilter "/**
itk::simple::HuangThresholdImageFilter::~HuangThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::Image "/**

The main Image class for SimpleITK.

C++ includes: sitkImage.h
*/"

%javamethodmodifiers  itk::simple::Image::CopyInformation "/**
void itk::simple::Image::CopyInformation(const Image &srcImage)

Copy common meta-data from an image to this one.


Copies the Origin, Spacing, and Direction from the source image to
this image. The meta-data dictionary is not copied.

It is required for the source Image's dimension and size to match, this image's attributes, otherwise an
exception will be generated.

*/
public ";

%javamethodmodifiers  itk::simple::Image::EraseMetaData "/**
bool itk::simple::Image::EraseMetaData(const std::string &key)

Remove an entry from the meta-data dictionary.


Returns true, when the value exists in the dictionary and is removed,
false otherwise.

*/
public ";

%javamethodmodifiers  itk::simple::Image::GetDepth "/**
unsigned int itk::simple::Image::GetDepth(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetDimension "/**
unsigned int itk::simple::Image::GetDimension(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetHeight "/**
unsigned int itk::simple::Image::GetHeight(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetMetaData "/**
std::string itk::simple::Image::GetMetaData(const std::string &key) const

Get the value of a meta-data dictionary entry as a string.


If the key is not in the dictionary then an exception is thrown.

string types in the dictionary are returned as their native strings.
Other types are printed to string before returning.

*/
public ";

%javamethodmodifiers  itk::simple::Image::GetMetaDataKeys "/**
std::vector<std::string> itk::simple::Image::GetMetaDataKeys(void) const

get a vector of keys in from the meta-data dictionary


Returns a vector of keys to the key/value entries in the image's meta-
data dictionary. Iterate through with these keys to get the values.

*/
public ";

%javamethodmodifiers  itk::simple::Image::GetNumberOfComponentsPerPixel "/**
unsigned int itk::simple::Image::GetNumberOfComponentsPerPixel(void) const

Get the number of components for each pixel.


For scalar images this methods returns 1. For vector images the number
of components for each pixel is returned.

*/
public ";

%javamethodmodifiers  itk::simple::Image::GetNumberOfPixels "/**
uint64_t itk::simple::Image::GetNumberOfPixels(void) const

Get the number of pixels in the image.


To Calculate the total number of values stored continuously for the
image's buffer, the NumberOfPixels should be multiplied by
NumberOfComponentsPerPixel in order to account for multiple component
images.

*/
public ";

%javamethodmodifiers  itk::simple::Image::GetPixelID "/**
PixelIDValueEnum itk::simple::Image::GetPixelID(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetPixelIDTypeAsString "/**
std::string itk::simple::Image::GetPixelIDTypeAsString(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetPixelIDValue "/**
PixelIDValueType itk::simple::Image::GetPixelIDValue(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetSize "/**
std::vector< unsigned int > itk::simple::Image::GetSize(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::GetWidth "/**
unsigned int itk::simple::Image::GetWidth(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::HasMetaDataKey "/**
bool itk::simple::Image::HasMetaDataKey(const std::string &key) const

Query the meta-data dictionary for the existence of a key.

*/
public ";

%javamethodmodifiers  itk::simple::Image::Image "/**
itk::simple::Image::Image(void)

Default constructor, creates an image of size 0.

*/
public ";

%javamethodmodifiers  itk::simple::Image::Image "/**
itk::simple::Image::Image(const Image &img)
*/
public ";

%javamethodmodifiers  itk::simple::Image::MakeUnique "/**
void itk::simple::Image::MakeUnique(void)

Performs actually coping if needed to make object unique.


The Image class by default performs lazy coping and assignment. This method
make sure that coping actually happens to the itk::Image pointed to is only pointed to by this object.

*/
public ";

%javamethodmodifiers  itk::simple::Image::SetMetaData "/**
void itk::simple::Image::SetMetaData(const std::string &key, const std::string &value)

Set an entry in the meta-data dictionary.


Replaces or creates an entry in the image's meta-data dictionary.

*/
public ";

%javamethodmodifiers  itk::simple::Image::ToString "/**
std::string itk::simple::Image::ToString(void) const
*/
public ";

%javamethodmodifiers  itk::simple::Image::TransformContinuousIndexToPhysicalPoint "/**
std::vector< double > itk::simple::Image::TransformContinuousIndexToPhysicalPoint(const std::vector< double > &index) const

Transform continuous index to physical point

*/
public ";

%javamethodmodifiers  itk::simple::Image::TransformIndexToPhysicalPoint "/**
std::vector< double > itk::simple::Image::TransformIndexToPhysicalPoint(const std::vector< int64_t > &index) const

Transform index to physical point

*/
public ";

%javamethodmodifiers  itk::simple::Image::TransformPhysicalPointToContinuousIndex "/**
std::vector< double > itk::simple::Image::TransformPhysicalPointToContinuousIndex(const std::vector< double > &point) const

Transform physical point to continuous index

*/
public ";

%javamethodmodifiers  itk::simple::Image::TransformPhysicalPointToIndex "/**
std::vector< int64_t > itk::simple::Image::TransformPhysicalPointToIndex(const std::vector< double > &point) const

Transform physical point to index

*/
public ";

%javamethodmodifiers  itk::simple::Image::~Image "/**
virtual itk::simple::Image::~Image()
*/
public ";


%typemap(javaimports) itk::simple::ImageFileReader "/**

Read a 2D or 3D image and return a smart pointer to a SimpleITK image.


This reader handles scalar and vector images and returns an image with
the same type as the file on disk.


See:
 itk::simple::ReadImage for the procedural interface


C++ includes: sitkImageFileReader.h
*/"

%javamethodmodifiers  itk::simple::ImageFileReader::Execute "/**
Image itk::simple::ImageFileReader::Execute()
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileReader::GetFileName "/**
std::string itk::simple::ImageFileReader::GetFileName() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileReader::GetName "/**
virtual std::string itk::simple::ImageFileReader::GetName() const

return user readable name fo the filter

*/
public ";

%javamethodmodifiers  itk::simple::ImageFileReader::ImageFileReader "/**
itk::simple::ImageFileReader::ImageFileReader()
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileReader::SetFileName "/**
Self& itk::simple::ImageFileReader::SetFileName(const std::string &fn)
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileReader::ToString "/**
virtual std::string itk::simple::ImageFileReader::ToString() const

Print ourselves to string

*/
public ";


%typemap(javaimports) itk::simple::ImageFileWriter "/**

Write out a SimpleITK image to the specified file location.


This writer tries to write the image out using the image's type to the
location specified in FileName. If writing fails, an ITK exception is
thrown.


See:
 itk::simple::WriteImage for the procedural interface


C++ includes: sitkImageFileWriter.h
*/"

%javamethodmodifiers  itk::simple::ImageFileWriter::Execute "/**
Self& itk::simple::ImageFileWriter::Execute(const Image &)
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileWriter::Execute "/**
Self& itk::simple::ImageFileWriter::Execute(const Image &, const std::string &inFileName, bool inUseCompression)
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileWriter::GetFileName "/**
std::string itk::simple::ImageFileWriter::GetFileName() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileWriter::GetName "/**
virtual std::string itk::simple::ImageFileWriter::GetName() const

return user readable name fo the filter

*/
public ";

%javamethodmodifiers  itk::simple::ImageFileWriter::ImageFileWriter "/**
itk::simple::ImageFileWriter::ImageFileWriter(void)
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileWriter::SetFileName "/**
Self& itk::simple::ImageFileWriter::SetFileName(const std::string &fileName)
*/
public ";

%javamethodmodifiers  itk::simple::ImageFileWriter::ToString "/**
virtual std::string itk::simple::ImageFileWriter::ToString() const

Print ourselves to string

*/
public ";


%typemap(javaimports) itk::simple::ImageFilter "/**

The base interface for SimpleITK filters that take one input image.


All SimpleITK filters which take one input image should inherit from
this class

C++ includes: sitkImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ImageFilter::ImageFilter "/**
itk::simple::ImageFilter< N >::ImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ImageFilter::~ImageFilter "/**
virtual itk::simple::ImageFilter< N >::~ImageFilter()=0

Default Destructor

*/
public ";


%typemap(javaimports) itk::simple::ImageReaderBase "/**

An abract base class for image readers.

C++ includes: sitkImageReaderBase.h
*/"

%javamethodmodifiers  itk::simple::ImageReaderBase::Execute "/**
virtual Image itk::simple::ImageReaderBase::Execute()=0
*/
public ";

%javamethodmodifiers  itk::simple::ImageReaderBase::ImageReaderBase "/**
itk::simple::ImageReaderBase::ImageReaderBase()
*/
public ";

%javamethodmodifiers  itk::simple::ImageReaderBase::ToString "/**
virtual std::string itk::simple::ImageReaderBase::ToString() const
*/
public ";


%typemap(javaimports) itk::simple::ImageRegistrationMethod "/**

An interface method to the modular ITKv4 registration framework.


This interface method class encapsulates typical registration usage by
incorporating all the necessary elements for performing a simple image
registration between two images. This method also allows for
multistage registration whereby each stage is characterized by
possibly different transforms and different image metrics. For
example, many users will want to perform a linear registration
followed by deformable registration where both stages are performed in
multiple levels. Each level can be characterized by:


the resolution of the virtual domain image (see below)

smoothing of the fixed and moving images
 Multiple stages are handled by linking multiple instantiations of
this class where the output transform is added to the optional
composite transform input.


See:
 itk::ImageRegistrationMethodv4

 itk::ImageToImageMetricv4

 itk::ObjectToObjectOptimizerBaseTemplate


C++ includes: sitkImageRegistrationMethod.h
*/"

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::Execute "/**
Transform itk::simple::ImageRegistrationMethod::Execute(const Image &fixed, const Image &moving)

Optimize the configured registration problem.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetCurrentLevel "/**
unsigned int itk::simple::ImageRegistrationMethod::GetCurrentLevel() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetMetricValue "/**
double itk::simple::ImageRegistrationMethod::GetMetricValue() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetName "/**
std::string itk::simple::ImageRegistrationMethod::GetName() const

return user readable name for the filter

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetOptimizerConvergenceValue "/**
double itk::simple::ImageRegistrationMethod::GetOptimizerConvergenceValue() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetOptimizerIteration "/**
unsigned int itk::simple::ImageRegistrationMethod::GetOptimizerIteration() const

Active measurements which can be obtained during call backs.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetOptimizerLearningRate "/**
double itk::simple::ImageRegistrationMethod::GetOptimizerLearningRate() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetOptimizerPosition "/**
std::vector<double> itk::simple::ImageRegistrationMethod::GetOptimizerPosition() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetOptimizerScales "/**
std::vector<double> itk::simple::ImageRegistrationMethod::GetOptimizerScales() const

Get the OptimizerScales.


If the scales are explicitly set then this method returns those
values. If an estimator is used then this is an active measurement
returning the scales estimated by the estimator and is only available
during execution.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::GetOptimizerStopConditionDescription "/**
std::string itk::simple::ImageRegistrationMethod::GetOptimizerStopConditionDescription() const

Measurement updated at the end of execution.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::ImageRegistrationMethod "/**
itk::simple::ImageRegistrationMethod::ImageRegistrationMethod()
*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::MetricEvaluate "/**
double itk::simple::ImageRegistrationMethod::MetricEvaluate(const Image &fixed, const Image &moving)

Get the value of the metric given the state of the method.


Passing a fixed and moving image, this method constructs and
configures a metric object to obtain the value. This will take into
consideration the current transforms, metric, interpolator, and image
masks. It does not take into consideration the sampling strategy,
smoothing sigmas, or the shrink factors.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricAsANTSNeighborhoodCorrelation "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricAsANTSNeighborhoodCorrelation(unsigned int radius)

Use normalized cross correlation using a small neighborhood for each
voxel between two images, with speed optimizations for dense
registration.



See:
 itk::ANTSNeighborhoodCorrelationImageToImageMetricv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricAsCorrelation "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricAsCorrelation()

Use negative normalized cross correlation image metric.



See:
 itk::CorrelationImageToImageMetricv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricAsDemons "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricAsDemons(double intensityDifferenceThreshold=0.001)

Use demons image metric.



See:
 itk::DemonsImageToImageMetricv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricAsJointHistogramMutualInformation "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricAsJointHistogramMutualInformation(unsigned int numberOfHistogramBins=20, double
varianceForJointPDFSmoothing=1.5)

Use mutual information between two images.



See:
 itk::JointHistogramMutualInformationImageToImageMetricv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricAsMattesMutualInformation "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricAsMattesMutualInformation(unsigned int numberOfHistogramBins=50)

Use the mutual information between two images to be registered using
the method of Mattes et al.



See:
 itk::MattesMutualInformationImageToImageMetricv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricAsMeanSquares "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricAsMeanSquares()

Use negative means squares image metric.



See:
 itk::MeanSquaresImageToImageMetricv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricFixedMask "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricFixedMask(const Image &binaryMask)

Set an image mask in order to restrict the sampled points for the
metric.


The image is expected to be in the same physical space as the
FixedImage, and if the pixel type is not UInt8 than the image will
base cast.


See:
 itk::ImageToImageMetricv4::SetFixedImageMask


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricMovingMask "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricMovingMask(const Image &binaryMask)

Set an image mask in order to restrict the sampled points for the
metric in the moving image space.


The image is expected to be in the same physical space as the
MovingImage, and if the pixel type is not UInt8 than the image will
base cast.


See:
 itk::ImageToImageMetricv4::SetMovingImageMask


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetMetricSamplingStrategy "/**
Self& itk::simple::ImageRegistrationMethod::SetMetricSamplingStrategy(MetricSamplingStrategyType strategy)

Set sampling strategy for sample generation.



See:
 itk::ImageRegistrationMethodv4::SetMetricSamplingStrategy


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsAmoeba "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsAmoeba(double simplexDelta, unsigned int numberOfIterations, double
parametersConvergenceTolerance=1e-8, double
functionConvergenceTolerance=1e-4, bool withRestarts=false)

Set optimizer to Nelder-Mead downhill simplex algorithm.



See:
 itk::AmoebaOptimizerv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsConjugateGradientLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Conjugate gradient descent optimizer with a golden section line search
for nonlinear optimization.



See:
 itk::ConjugateGradientLineSearchOptimizerv4Template


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsExhaustive "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsExhaustive(const std::vector< unsigned int > &numberOfSteps, double
stepLength=1.0)

Set the optimizer to sample the metric at regular steps.


At each iteration the GetOptimizerIteration, can be used to index into
the sampling grid along with the GetCurrentMetricValue.

The resulting transform and value at the end of execution is the best
location.

The OptimizerScales can be used to perform anisotropic sampling.


This optimizer is not suitable for use in conjunction with the
multiple scales.

See:
 itk::ExhaustiveOptimizerv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescent(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer.



See:
 itk::GradientDescentOptimizerv4Template


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsGradientDescentLineSearch(double learningRate, unsigned int numberOfIterations, double
convergenceMinimumValue=1e-6, unsigned int convergenceWindowSize=10,
double lineSearchLowerLimit=0, double lineSearchUpperLimit=5.0, double
lineSearchEpsilon=0.01, unsigned int lineSearchMaximumIterations=20,
EstimateLearningRateType estimateLearningRate=Once, double
maximumStepSizeInPhysicalUnits=0.0)

Gradient descent optimizer with a golden section line search.



See:
 itk::GradientDescentLineSearchOptimizerv4Template


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsLBFGSB(double gradientConvergenceTolerance=1e-5, unsigned int
numberOfIterations=500, unsigned int maximumNumberOfCorrections=5,
unsigned int maximumNumberOfFunctionEvaluations=2000, double
costFunctionConvergenceFactor=1e+7, double
lowerBound=std::numeric_limits< double >::min(), double
upperBound=std::numeric_limits< double >::max(), bool trace=false)

Limited memory Broyden Fletcher Goldfarb Shannon minimization with
simple bounds.


The default parameters utilize LBFGSB in unbounded mode.


See:
 itk::LBFGSBOptimizerv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsOnePlusOneEvolutionary(unsigned int numberOfIterations=100, double epsilon=1.5e-4, double
initialRadius=1.01, double growthFactor=-1.0, double
shrinkFactor=-1.0, unsigned int seed=sitkWallClock)

1+1 evolutionary optimizer strategy.


The seed parameter is used to seed the pseudo-random number generator.
If the seed parameter is 0, then the wall clock is used to seed,
otherwise the fixed seed is used for reproducible behavior.


See:
 itk::OnePlusOneEvolutionaryOptimizerv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsPowell(unsigned int numberOfIterations=100, unsigned int
maximumLineIterations=100, double stepLength=1, double
stepTolerance=1e-6, double valueTolerance=1e-6)

Powell optimization using Brent line search.



See:
 itk::PowellOptimizerv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerAsRegularStepGradientDescent(double learningRate, double minStep, unsigned int numberOfIterations,
double relaxationFactor=0.5, double gradientMagnitudeTolerance=1e-4,
EstimateLearningRateType estimateLearningRate=Never, double
maximumStepSizeInPhysicalUnits=0.0)

Regular Step Gradient descent optimizer.



See:
 itk::RegularStepGradientDescentOptimizerv4


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerScales "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerScales(const std::vector< double > &scales)

Manually set per parameter weighting for the transform parameters.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromIndexShift "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromIndexShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimate scales from maximum voxel shift in index space cause by
parameter change.



See:
 itk::RegistrationParameterScalesFromIndexShift


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromJacobian "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromJacobian(unsigned int centralRegionRadius=5)

Estimate scales from Jacobian norms.


This scales estimator works well with versor based transforms.


See:
 itk::RegistrationParameterScalesFromJacobian


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromPhysicalShift "/**
Self& itk::simple::ImageRegistrationMethod::SetOptimizerScalesFromPhysicalShift(unsigned int centralRegionRadius=5, double
smallParameterVariation=0.01)

Estimating scales of transform parameters a step sizes, from the
maximum voxel shift in physical space caused by a parameter change.



See:
 itk::RegistrationParameterScalesFromPhysicalShift


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetShrinkFactorsPerLevel "/**
Self& itk::simple::ImageRegistrationMethod::SetShrinkFactorsPerLevel(const std::vector< unsigned int > &shrinkFactors)

Set the shrink factors for each level where each level has the same
shrink factor for each dimension.



See:
 itk::ImageRegistrationMethodv4::SetShrinkFactorsPerLevel


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::SetSmoothingSigmasPerLevel "/**
Self& itk::simple::ImageRegistrationMethod::SetSmoothingSigmasPerLevel(const std::vector< double > &smoothingSigmas)

Set the sigmas of Gaussian used for smoothing at each level.



See:
 itk::ImageRegistrationMethodv4::SetSmoothingSigmasPerLevel


*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::ToString "/**
std::string itk::simple::ImageRegistrationMethod::ToString() const

Print the information about the object to a string.


If called when the process is being executed ( during a callback ),
the ITK Optimizer and Transform objects will be printed.

*/
public ";

%javamethodmodifiers  itk::simple::ImageRegistrationMethod::~ImageRegistrationMethod "/**
virtual itk::simple::ImageRegistrationMethod::~ImageRegistrationMethod()
*/
public ";


%typemap(javaimports) itk::simple::ImageSeriesReader "/**

Read series of image into a SimpleITK image.



See:
 itk::simple::ReadImage for the procedural interface


C++ includes: sitkImageSeriesReader.h
*/"

%javamethodmodifiers  itk::simple::ImageSeriesReader::Execute "/**
Image itk::simple::ImageSeriesReader::Execute()
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesReader::GetFileNames "/**
const std::vector<std::string>& itk::simple::ImageSeriesReader::GetFileNames() const
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesReader::GetName "/**
virtual std::string itk::simple::ImageSeriesReader::GetName() const

return user readable name fo the filter

*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesReader::ImageSeriesReader "/**
itk::simple::ImageSeriesReader::ImageSeriesReader()
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesReader::SetFileNames "/**
Self& itk::simple::ImageSeriesReader::SetFileNames(const std::vector< std::string > &fileNames)
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesReader::ToString "/**
virtual std::string itk::simple::ImageSeriesReader::ToString() const

Print ourselves to string

*/
public ";


%typemap(javaimports) itk::simple::ImageSeriesWriter "/**

Writer series of image from a SimpleITK image.


The ImageSeriesWriter is for writing a 3D image as a series of 2D images. A list of names
for the series of 2D images must be provided, and an exception will be
generated if the number of file names does not match the size of the
image in the z-direction.

DICOM series cannot be written with this class, as an exception will
be generated. To write a DICOM series the individual slices must be
extracted, proper DICOM tags must be added to the dictionaries, then
written with the ImageFileWriter.


See:
 itk::simple::WriteImage for the procedural interface


C++ includes: sitkImageSeriesWriter.h
*/"

%javamethodmodifiers  itk::simple::ImageSeriesWriter::Execute "/**
Self& itk::simple::ImageSeriesWriter::Execute(const Image &)
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesWriter::Execute "/**
Self& itk::simple::ImageSeriesWriter::Execute(const Image &image, const std::vector< std::string > &inFileNames,
bool inUseCompression)
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesWriter::GetName "/**
virtual std::string itk::simple::ImageSeriesWriter::GetName() const

return user readable name fo the filter

*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesWriter::ImageSeriesWriter "/**
itk::simple::ImageSeriesWriter::ImageSeriesWriter()
*/
public ";

%javamethodmodifiers  itk::simple::ImageSeriesWriter::ToString "/**
virtual std::string itk::simple::ImageSeriesWriter::ToString() const

Print ourselves to string

*/
public ";


%typemap(javaimports) itk::simple::ImportImageFilter "/**

Compose a 2D or 3D image and return a smart pointer to a SimpleITK
image.


This filter is intended to interface SimpleITK to other image
processing libraries and applications that may have their own
representation of an image class. It creates a SimpleITK image which
shares the bulk data buffer as what is set. SimpleITK will not
responsible to delete the buffer afterwards, and it buffer must remain
valid while in use.


See:
 itk::simple::ImportAsInt8, itk::simple::ImportAsUInt8, itk::simple::ImportAsInt16, itk::simple::ImportAsUInt16, itk::simple::ImportAsInt32, itk::simple::ImportAsUInt32, itk::simple::ImportAsInt64, itk::simple::ImportAsUInt64, itk::simple::ImportAsFloat, itk::simple::ImportAsDouble for the procedural interfaces.


C++ includes: sitkImportImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ImportImageFilter::Execute "/**
Image itk::simple::ImportImageFilter::Execute()
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::GetDirection "/**
const std::vector< double >& itk::simple::ImportImageFilter::GetDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::GetName "/**
virtual std::string itk::simple::ImportImageFilter::GetName() const

return user readable name fo the filter

*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::GetOrigin "/**
const std::vector< double >& itk::simple::ImportImageFilter::GetOrigin() const
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::GetSize "/**
const std::vector< unsigned int >& itk::simple::ImportImageFilter::GetSize() const
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::GetSpacing "/**
const std::vector< double >& itk::simple::ImportImageFilter::GetSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::ImportImageFilter "/**
itk::simple::ImportImageFilter::ImportImageFilter()
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsDouble "/**
Self& itk::simple::ImportImageFilter::SetBufferAsDouble(double *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsFloat "/**
Self& itk::simple::ImportImageFilter::SetBufferAsFloat(float *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsInt16 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsInt16(int16_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsInt32 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsInt32(int32_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsInt64 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsInt64(int64_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsInt8 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsInt8(int8_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsUInt16 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsUInt16(uint16_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsUInt32 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsUInt32(uint32_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsUInt64 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsUInt64(uint64_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetBufferAsUInt8 "/**
Self& itk::simple::ImportImageFilter::SetBufferAsUInt8(uint8_t *buffer, unsigned int numberOfComponents=1)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetDirection "/**
Self& itk::simple::ImportImageFilter::SetDirection(const std::vector< double > &direction)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetOrigin "/**
Self& itk::simple::ImportImageFilter::SetOrigin(const std::vector< double > &origin)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetSize "/**
Self& itk::simple::ImportImageFilter::SetSize(const std::vector< unsigned int > &size)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::SetSpacing "/**
Self& itk::simple::ImportImageFilter::SetSpacing(const std::vector< double > &spacing)
*/
public ";

%javamethodmodifiers  itk::simple::ImportImageFilter::ToString "/**
virtual std::string itk::simple::ImportImageFilter::ToString() const

Print ourselves to string

*/
public ";


%typemap(javaimports) itk::simple::IntensityWindowingImageFilter "/**

Applies a linear transformation to the intensity levels of the input Image that are inside a user-defined interval. Values below this interval
are mapped to a constant. Values over the interval are mapped to
another constant.


IntensityWindowingImageFilter applies pixel-wise a linear transformation to the intensity values of
input image pixels. The linear transformation is defined by the user
in terms of the minimum and maximum values that the output image
should have and the lower and upper limits of the intensity window of
the input image. This operation is very common in visualization, and
can also be applied as a convenient preprocessing operation for image
segmentation.

All computations are performed in the precision of the input pixel's
RealType. Before assigning the computed value to the output pixel.

Wiki Examples:

All Examples

IntensityWindowingImageFilter

See:
 RescaleIntensityImageFilter

 itk::simple::IntensityWindowing for the procedural interface

 itk::IntensityWindowingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIntensityWindowingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::Execute "/**
Image itk::simple::IntensityWindowingImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::Execute "/**
Image itk::simple::IntensityWindowingImageFilter::Execute(const Image &image1, double windowMinimum, double windowMaximum,
double outputMinimum, double outputMaximum)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::GetName "/**
std::string itk::simple::IntensityWindowingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::GetOutputMaximum "/**
double itk::simple::IntensityWindowingImageFilter::GetOutputMaximum() const

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::GetOutputMinimum "/**
double itk::simple::IntensityWindowingImageFilter::GetOutputMinimum() const

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::GetWindowMaximum "/**
double itk::simple::IntensityWindowingImageFilter::GetWindowMaximum() const

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::GetWindowMinimum "/**
double itk::simple::IntensityWindowingImageFilter::GetWindowMinimum() const

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::IntensityWindowingImageFilter "/**
itk::simple::IntensityWindowingImageFilter::IntensityWindowingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::SetOutputMaximum "/**
Self& itk::simple::IntensityWindowingImageFilter::SetOutputMaximum(double OutputMaximum)

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::SetOutputMinimum "/**
Self& itk::simple::IntensityWindowingImageFilter::SetOutputMinimum(double OutputMinimum)

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::SetWindowMaximum "/**
Self& itk::simple::IntensityWindowingImageFilter::SetWindowMaximum(double WindowMaximum)

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::SetWindowMinimum "/**
Self& itk::simple::IntensityWindowingImageFilter::SetWindowMinimum(double WindowMinimum)

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::ToString "/**
std::string itk::simple::IntensityWindowingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IntensityWindowingImageFilter::~IntensityWindowingImageFilter "/**
itk::simple::IntensityWindowingImageFilter::~IntensityWindowingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::IntermodesThresholdImageFilter "/**

Threshold an image using the Intermodes Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the IntermodesThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::IntermodesThreshold for the procedural interface

 itk::IntermodesThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIntermodesThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::Execute "/**
Image itk::simple::IntermodesThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::Execute "/**
Image itk::simple::IntermodesThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::Execute "/**
Image itk::simple::IntermodesThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::Execute "/**
Image itk::simple::IntermodesThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::IntermodesThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::IntermodesThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::IntermodesThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetName "/**
std::string itk::simple::IntermodesThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::IntermodesThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::IntermodesThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::GetThreshold "/**
double itk::simple::IntermodesThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::IntermodesThresholdImageFilter "/**
itk::simple::IntermodesThresholdImageFilter::IntermodesThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::IntermodesThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::IntermodesThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::IntermodesThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::IntermodesThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::IntermodesThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::IntermodesThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::IntermodesThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::ToString "/**
std::string itk::simple::IntermodesThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IntermodesThresholdImageFilter::~IntermodesThresholdImageFilter "/**
itk::simple::IntermodesThresholdImageFilter::~IntermodesThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::InverseDeconvolutionImageFilter "/**

The direct linear inverse deconvolution filter.


The inverse filter is the most straightforward deconvolution method.
Considering that convolution of two images in the spatial domain is
equivalent to multiplying the Fourier transform of the two images, the
inverse filter consists of inverting the multiplication. In other
words, this filter computes the following: \\\\[ hat{F}(\\\\omega) = \\\\begin{cases} G(\\\\omega) / H(\\\\omega)
& \\\\text{if \\\\f$|H(\\\\omega)| \\\\geq \\\\epsilon\\\\f$} \\\\\\\\
0 & \\\\text{otherwise} \\\\end{cases} \\\\] where $\\\\hat{F}(\\\\omega)$ is the Fourier transform of the estimate produced by this filter, $G(\\\\omega)$ is the Fourier transform of the input blurred image, $H(\\\\omega)$ is the Fourier transform of the blurring kernel, and $\\\\epsilon$ is a constant real non-negative threshold (called
KernelZeroMagnitudeThreshold in this filter) that determines when the
magnitude of a complex number is considered zero.


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
 Cory Quammen, The University of North Carolina at Chapel Hill
See:
 itk::simple::InverseDeconvolution for the procedural interface

 itk::InverseDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInverseDeconvolutionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::Execute "/**
Image itk::simple::InverseDeconvolutionImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::Execute "/**
Image itk::simple::InverseDeconvolutionImageFilter::Execute(const Image &image1, const Image &image2, double
kernelZeroMagnitudeThreshold, bool normalize,
InverseDeconvolutionImageFilter::BoundaryConditionType
boundaryCondition,
InverseDeconvolutionImageFilter::OutputRegionModeType
outputRegionMode)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::GetBoundaryCondition "/**
BoundaryConditionType itk::simple::InverseDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::GetKernelZeroMagnitudeThreshold "/**
double itk::simple::InverseDeconvolutionImageFilter::GetKernelZeroMagnitudeThreshold() const

Set/get the threshold value uused to determine whether a frequency of
the Fourier transform of the blurring kernel is considered to be zero.
Default value is 1.0e-4.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::GetName "/**
std::string itk::simple::InverseDeconvolutionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::GetNormalize "/**
bool itk::simple::InverseDeconvolutionImageFilter::GetNormalize() const
*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::GetOutputRegionMode "/**
OutputRegionModeType itk::simple::InverseDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::InverseDeconvolutionImageFilter "/**
itk::simple::InverseDeconvolutionImageFilter::InverseDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::NormalizeOff "/**
Self& itk::simple::InverseDeconvolutionImageFilter::NormalizeOff()
*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::NormalizeOn "/**
Self& itk::simple::InverseDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::SetBoundaryCondition "/**
Self& itk::simple::InverseDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::SetKernelZeroMagnitudeThreshold "/**
Self& itk::simple::InverseDeconvolutionImageFilter::SetKernelZeroMagnitudeThreshold(double KernelZeroMagnitudeThreshold)

Set/get the threshold value uused to determine whether a frequency of
the Fourier transform of the blurring kernel is considered to be zero.
Default value is 1.0e-4.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::SetNormalize "/**
Self& itk::simple::InverseDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::SetOutputRegionMode "/**
Self& itk::simple::InverseDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::ToString "/**
std::string itk::simple::InverseDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::InverseDeconvolutionImageFilter::~InverseDeconvolutionImageFilter "/**
itk::simple::InverseDeconvolutionImageFilter::~InverseDeconvolutionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::InverseDisplacementFieldImageFilter "/**

Computes the inverse of a displacement field.


InverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement
field that is its inverse. If the input displacement field was mapping
coordinates from a space A into a space B, the output of this filter
will map coordinates from the space B into the space A.

Given that both the input and output displacement field are
represented as discrete images with pixel type vector, the inverse
will be only an estimation and will probably not correspond to a
perfect inverse. The precision of the inverse can be improved at the
price of increasing the computation time and memory consumption in
this filter.

The method used for computing the inverse displacement field is to
subsample the input field using a regular grid and create Kerned-Base
Spline in which the reference landmarks are the coordinates of the
deformed point and the target landmarks are the negative of the
displacement vectors. The kernel-base spline is then used for
regularly sampling the output space and recover vector values for
every single pixel.

The subsampling factor used for the regular grid of the input field
will determine the number of landmarks in the KernelBased spline and
therefore it will have a dramatic effect on both the precision of
output displacement field and the computational time required for the
filter to complete the estimation. A large subsampling factor will
result in few landmarks in the KernelBased spline, therefore on fast
computation and low precision. A small subsampling factor will result
in a large number of landmarks in the KernelBased spline, therefore a
large memory consumption, long computation time and high precision for
the inverse estimation.

This filter expects both the input and output images to be of pixel
type Vector .
See:
 itk::simple::InverseDisplacementField for the procedural interface

 itk::InverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInverseDisplacementFieldImageFilter.h
*/"

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::Execute "/**
Image itk::simple::InverseDisplacementFieldImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::Execute "/**
Image itk::simple::InverseDisplacementFieldImageFilter::Execute(const Image &image1, const std::vector< uint32_t > &size, const
std::vector< double > &outputOrigin, const std::vector< double >
&outputSpacing, unsigned int subsamplingFactor)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::GetName "/**
std::string itk::simple::InverseDisplacementFieldImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::GetOutputOrigin "/**
std::vector<double> itk::simple::InverseDisplacementFieldImageFilter::GetOutputOrigin() const

Get the output image origin.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::GetOutputSpacing "/**
std::vector<double> itk::simple::InverseDisplacementFieldImageFilter::GetOutputSpacing() const

Get the output image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::GetSize "/**
std::vector<uint32_t> itk::simple::InverseDisplacementFieldImageFilter::GetSize() const

Get the size of the output image.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::GetSubsamplingFactor "/**
unsigned int itk::simple::InverseDisplacementFieldImageFilter::GetSubsamplingFactor() const

Set/Get the factor used for subsampling the input displacement field.
A large value in this factor will produce a fast computation of the
inverse field but with low precision. A small value of this factor
will produce a precise computation of the inverse field at the price
of large memory consumption and long computational time.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::InverseDisplacementFieldImageFilter "/**
itk::simple::InverseDisplacementFieldImageFilter::InverseDisplacementFieldImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::SetOutputOrigin "/**
Self& itk::simple::InverseDisplacementFieldImageFilter::SetOutputOrigin(const std::vector< double > &OutputOrigin)

Set the output image origin.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::SetOutputSpacing "/**
Self& itk::simple::InverseDisplacementFieldImageFilter::SetOutputSpacing(const std::vector< double > &OutputSpacing)

Set the output image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::SetReferenceImage "/**
void itk::simple::InverseDisplacementFieldImageFilter::SetReferenceImage(const Image &refImage)

This methods sets the output size, origin, and direction to that of
the provided image

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::SetSize "/**
Self& itk::simple::InverseDisplacementFieldImageFilter::SetSize(const std::vector< uint32_t > &Size)

Set the size of the output image.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::SetSubsamplingFactor "/**
Self& itk::simple::InverseDisplacementFieldImageFilter::SetSubsamplingFactor(unsigned int SubsamplingFactor)

Set/Get the factor used for subsampling the input displacement field.
A large value in this factor will produce a fast computation of the
inverse field but with low precision. A small value of this factor
will produce a precise computation of the inverse field at the price
of large memory consumption and long computational time.

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::ToString "/**
std::string itk::simple::InverseDisplacementFieldImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::InverseDisplacementFieldImageFilter::~InverseDisplacementFieldImageFilter "/**
itk::simple::InverseDisplacementFieldImageFilter::~InverseDisplacementFieldImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::InverseFFTImageFilter "/**

Base class for inverse Fast Fourier Transform .


This is a base class for the \"inverse\" or \"reverse\" Discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child available on the system when the object is
created via the object factory system.

This class transforms a full complex image with Hermitian symmetry
into its real spatial domain representation. If the input does not
have Hermitian symmetry, the imaginary component is discarded.


See:
 ForwardFFTImageFilter , InverseFFTImageFilter

 itk::simple::InverseFFT for the procedural interface

 itk::InverseFFTImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInverseFFTImageFilter.h
*/"

%javamethodmodifiers  itk::simple::InverseFFTImageFilter::Execute "/**
Image itk::simple::InverseFFTImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::InverseFFTImageFilter::GetName "/**
std::string itk::simple::InverseFFTImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::InverseFFTImageFilter::InverseFFTImageFilter "/**
itk::simple::InverseFFTImageFilter::InverseFFTImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::InverseFFTImageFilter::ToString "/**
std::string itk::simple::InverseFFTImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::InverseFFTImageFilter::~InverseFFTImageFilter "/**
itk::simple::InverseFFTImageFilter::~InverseFFTImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::InvertDisplacementFieldImageFilter "/**

Iteratively estimate the inverse field of a displacement field.



Nick Tustison
 Brian Avants
See:
 itk::simple::InvertDisplacementField for the procedural interface

 itk::InvertDisplacementFieldImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkInvertDisplacementFieldImageFilter.h
*/"

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::EnforceBoundaryConditionOff "/**
Self& itk::simple::InvertDisplacementFieldImageFilter::EnforceBoundaryConditionOff()
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::EnforceBoundaryConditionOn "/**
Self& itk::simple::InvertDisplacementFieldImageFilter::EnforceBoundaryConditionOn()

Set the value of EnforceBoundaryCondition to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::Execute "/**
Image itk::simple::InvertDisplacementFieldImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::Execute "/**
Image itk::simple::InvertDisplacementFieldImageFilter::Execute(const Image &image1, uint32_t maximumNumberOfIterations, double
maxErrorToleranceThreshold, double meanErrorToleranceThreshold, bool
enforceBoundaryCondition)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetEnforceBoundaryCondition "/**
bool itk::simple::InvertDisplacementFieldImageFilter::GetEnforceBoundaryCondition() const
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetMaxErrorNorm "/**
double itk::simple::InvertDisplacementFieldImageFilter::GetMaxErrorNorm() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetMaxErrorToleranceThreshold "/**
double itk::simple::InvertDisplacementFieldImageFilter::GetMaxErrorToleranceThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetMaximumNumberOfIterations "/**
uint32_t itk::simple::InvertDisplacementFieldImageFilter::GetMaximumNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetMeanErrorNorm "/**
double itk::simple::InvertDisplacementFieldImageFilter::GetMeanErrorNorm() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetMeanErrorToleranceThreshold "/**
double itk::simple::InvertDisplacementFieldImageFilter::GetMeanErrorToleranceThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::GetName "/**
std::string itk::simple::InvertDisplacementFieldImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::InvertDisplacementFieldImageFilter "/**
itk::simple::InvertDisplacementFieldImageFilter::InvertDisplacementFieldImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::SetEnforceBoundaryCondition "/**
Self& itk::simple::InvertDisplacementFieldImageFilter::SetEnforceBoundaryCondition(bool EnforceBoundaryCondition)
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::SetMaxErrorToleranceThreshold "/**
Self& itk::simple::InvertDisplacementFieldImageFilter::SetMaxErrorToleranceThreshold(double MaxErrorToleranceThreshold)
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::SetMaximumNumberOfIterations "/**
Self& itk::simple::InvertDisplacementFieldImageFilter::SetMaximumNumberOfIterations(uint32_t MaximumNumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::SetMeanErrorToleranceThreshold "/**
Self& itk::simple::InvertDisplacementFieldImageFilter::SetMeanErrorToleranceThreshold(double MeanErrorToleranceThreshold)
*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::ToString "/**
std::string itk::simple::InvertDisplacementFieldImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::InvertDisplacementFieldImageFilter::~InvertDisplacementFieldImageFilter "/**
itk::simple::InvertDisplacementFieldImageFilter::~InvertDisplacementFieldImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::InvertIntensityImageFilter "/**

Invert the intensity of an image.


InvertIntensityImageFilter inverts intensity of pixels by subtracting pixel value to a maximum
value. The maximum value can be set with SetMaximum and defaults the
maximum of input pixel type. This filter can be used to invert, for
example, a binary image, a distance map, etc.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 IntensityWindowingImageFilter ShiftScaleImageFilter
Wiki Examples:

All Examples

Invert an image
See:
 itk::simple::InvertIntensity for the procedural interface

 itk::InvertIntensityImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkInvertIntensityImageFilter.h
*/"

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::Execute "/**
Image itk::simple::InvertIntensityImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::Execute "/**
Image itk::simple::InvertIntensityImageFilter::Execute(const Image &image1, double maximum)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::GetMaximum "/**
double itk::simple::InvertIntensityImageFilter::GetMaximum() const

Set/Get the maximum intensity value for the inversion.

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::GetName "/**
std::string itk::simple::InvertIntensityImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::InvertIntensityImageFilter "/**
itk::simple::InvertIntensityImageFilter::InvertIntensityImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::SetMaximum "/**
Self& itk::simple::InvertIntensityImageFilter::SetMaximum(double Maximum)

Set/Get the maximum intensity value for the inversion.

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::ToString "/**
std::string itk::simple::InvertIntensityImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::InvertIntensityImageFilter::~InvertIntensityImageFilter "/**
itk::simple::InvertIntensityImageFilter::~InvertIntensityImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::IsoContourDistanceImageFilter "/**

Compute an approximate distance from an interpolated isocontour to the
close grid points.


For standard level set algorithms, it is useful to periodically
reinitialize the evolving image to prevent numerical accuracy problems
in computing derivatives. This reinitialization is done by computing a
signed distance map to the current level set. This class provides the
first step in this reinitialization by computing an estimate of the
distance from the interpolated isocontour to the pixels (or voxels)
that are close to it, i.e. for which the isocontour crosses a segment
between them and one of their direct neighbors. This class supports
narrowbanding. If the input narrowband is provided, the algorithm will
only locate the level set within the input narrowband.

Implementation of this class is based on Fast and Accurate
Redistancing for Level Set Methods `Krissian K. and Westin C.F.',
EUROCAST NeuroImaging Workshop Las Palmas Spain, Ninth International
Conference on Computer Aided Systems Theory , pages 48-51, Feb 2003.
See:
 itk::simple::IsoContourDistance for the procedural interface

 itk::IsoContourDistanceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsoContourDistanceImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::Execute "/**
Image itk::simple::IsoContourDistanceImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::Execute "/**
Image itk::simple::IsoContourDistanceImageFilter::Execute(const Image &image1, double levelSetValue, double farValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::GetFarValue "/**
double itk::simple::IsoContourDistanceImageFilter::GetFarValue() const

Set/Get the value of the level set to be located. The default value is
0.

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::GetLevelSetValue "/**
double itk::simple::IsoContourDistanceImageFilter::GetLevelSetValue() const

Set/Get the value of the level set to be located. The default value is
0.

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::GetName "/**
std::string itk::simple::IsoContourDistanceImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::IsoContourDistanceImageFilter "/**
itk::simple::IsoContourDistanceImageFilter::IsoContourDistanceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::SetFarValue "/**
Self& itk::simple::IsoContourDistanceImageFilter::SetFarValue(double FarValue)

Set/Get the value of the level set to be located. The default value is
0.

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::SetLevelSetValue "/**
Self& itk::simple::IsoContourDistanceImageFilter::SetLevelSetValue(double LevelSetValue)

Set/Get the value of the level set to be located. The default value is
0.

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::ToString "/**
std::string itk::simple::IsoContourDistanceImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IsoContourDistanceImageFilter::~IsoContourDistanceImageFilter "/**
itk::simple::IsoContourDistanceImageFilter::~IsoContourDistanceImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::IsoDataThresholdImageFilter "/**

Threshold an image using the IsoData Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the IsoDataThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::IsoDataThreshold for the procedural interface

 itk::IsoDataThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsoDataThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::Execute "/**
Image itk::simple::IsoDataThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::Execute "/**
Image itk::simple::IsoDataThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::Execute "/**
Image itk::simple::IsoDataThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::Execute "/**
Image itk::simple::IsoDataThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::IsoDataThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::IsoDataThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::IsoDataThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetName "/**
std::string itk::simple::IsoDataThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::IsoDataThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::IsoDataThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::GetThreshold "/**
double itk::simple::IsoDataThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::IsoDataThresholdImageFilter "/**
itk::simple::IsoDataThresholdImageFilter::IsoDataThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::IsoDataThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::IsoDataThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::IsoDataThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::IsoDataThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::IsoDataThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::IsoDataThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::IsoDataThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::ToString "/**
std::string itk::simple::IsoDataThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IsoDataThresholdImageFilter::~IsoDataThresholdImageFilter "/**
itk::simple::IsoDataThresholdImageFilter::~IsoDataThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::IsolatedConnectedImageFilter "/**

Label pixels that are connected to one set of seeds but not another.


IsolatedConnectedImageFilter finds the optimal threshold to separate two regions. It has two
modes, one to separate dark regions surrounded by bright regions by
automatically finding a minimum isolating upper threshold, and another
to separate bright regions surrounded by dark regions by automatically
finding a maximum lower isolating threshold. The mode can be chosen by
setting FindUpperThresholdOn() /Off(). In both cases, the isolating threshold is retrieved with GetIsolatedValue() .

The algorithm labels pixels with ReplaceValue that are connected to
Seeds1 AND NOT connected to Seeds2. When finding the threshold to
separate two dark regions surrounded by bright regions, given a fixed
lower threshold, the filter adjusts the upper threshold until the two
sets of seeds are not connected. The algorithm uses a binary search to
adjust the upper threshold, starting at Upper. The reverse is true for
finding the threshold to separate two bright regions. Lower defaults
to the smallest possible value for the InputImagePixelType, and Upper
defaults to the largest possible value for the InputImagePixelType.

The user can also supply the Lower and Upper values to restrict the
search. However, if the range is too restrictive, it could happen that
no isolating threshold can be found between the user specified Lower
and Upper values. Therefore, unless the user is sure of the bounds to
set, it is recommended that the user set these values to the lowest
and highest intensity values in the image, respectively.

The user can specify more than one seed for both regions to separate.
The algorithm will try find the threshold that ensures that all of the
first seeds are contained in the resulting segmentation and all of the
second seeds are not contained in the segmentation.

It is possible that the algorithm may not be able to find the
isolating threshold because no such threshold exists. The user can
check for this by querying the GetThresholdingFailed() flag.
See:
 itk::simple::IsolatedConnected for the procedural interface

 itk::IsolatedConnectedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsolatedConnectedImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::Execute "/**
Image itk::simple::IsolatedConnectedImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::Execute "/**
Image itk::simple::IsolatedConnectedImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &seed1, const
std::vector< unsigned int > &seed2, double lower, double upper,
uint8_t replaceValue, double isolatedValueTolerance, bool
findUpperThreshold)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::FindUpperThresholdOff "/**
Self& itk::simple::IsolatedConnectedImageFilter::FindUpperThresholdOff()
*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::FindUpperThresholdOn "/**
Self& itk::simple::IsolatedConnectedImageFilter::FindUpperThresholdOn()

Set the value of FindUpperThreshold to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetFindUpperThreshold "/**
bool itk::simple::IsolatedConnectedImageFilter::GetFindUpperThreshold() const

Set/Get whether to find an upper threshold (separating two dark
regions) or a lower threshold (separating two bright regions).

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetIsolatedValue "/**
double itk::simple::IsolatedConnectedImageFilter::GetIsolatedValue() const

Get value that isolates the two seeds.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetIsolatedValueTolerance "/**
double itk::simple::IsolatedConnectedImageFilter::GetIsolatedValueTolerance() const

Set/Get the precision required for the intensity threshold value. The
default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetLower "/**
double itk::simple::IsolatedConnectedImageFilter::GetLower() const

Set/Get the limit on the lower threshold value. The default is the
NonpositiveMin() for the InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetName "/**
std::string itk::simple::IsolatedConnectedImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetReplaceValue "/**
uint8_t itk::simple::IsolatedConnectedImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels. Pixels that lie within
the thresholds will be replaced with this value. The default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetSeed1 "/**
std::vector<unsigned int> itk::simple::IsolatedConnectedImageFilter::GetSeed1() const
*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetSeed2 "/**
std::vector<unsigned int> itk::simple::IsolatedConnectedImageFilter::GetSeed2() const
*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetThresholdingFailed "/**
bool itk::simple::IsolatedConnectedImageFilter::GetThresholdingFailed() const

Get the flag that tells whether the algorithm failed to find a
threshold.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::GetUpper "/**
double itk::simple::IsolatedConnectedImageFilter::GetUpper() const

Set/Get the limit on the upper threshold value. The default is the
max() for the InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::IsolatedConnectedImageFilter "/**
itk::simple::IsolatedConnectedImageFilter::IsolatedConnectedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetFindUpperThreshold "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetFindUpperThreshold(bool FindUpperThreshold)

Set/Get whether to find an upper threshold (separating two dark
regions) or a lower threshold (separating two bright regions).

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetIsolatedValueTolerance "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetIsolatedValueTolerance(double IsolatedValueTolerance)

Set/Get the precision required for the intensity threshold value. The
default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetLower "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetLower(double Lower)

Set/Get the limit on the lower threshold value. The default is the
NonpositiveMin() for the InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetReplaceValue "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetReplaceValue(uint8_t ReplaceValue)

Set/Get value to replace thresholded pixels. Pixels that lie within
the thresholds will be replaced with this value. The default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetSeed1 "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetSeed1(const std::vector< unsigned int > &Seed1)

DeprecatedSet seed point 1. This seed will be isolated from Seed2 (if
possible). All pixels connected to this seed will be replaced with
ReplaceValue. This method is deprecated, please use AddSeed1() .

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetSeed2 "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetSeed2(const std::vector< unsigned int > &Seed2)

DeprecatedSet seed point 2. This seed will be isolated from Seed1 (if
possible). This method is deprecated, please use AddSeed2() .

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::SetUpper "/**
Self& itk::simple::IsolatedConnectedImageFilter::SetUpper(double Upper)

Set/Get the limit on the upper threshold value. The default is the
max() for the InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::ToString "/**
std::string itk::simple::IsolatedConnectedImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedConnectedImageFilter::~IsolatedConnectedImageFilter "/**
itk::simple::IsolatedConnectedImageFilter::~IsolatedConnectedImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::IsolatedWatershedImageFilter "/**

Isolate watershed basins using two seeds.


IsolatedWatershedImageFilter labels pixels with ReplaceValue1 that are in the same watershed basin
as Seed1 AND NOT the same as Seed2. The filter adjusts the waterlevel
until the two seeds are not in different basins. The user supplies a
Watershed threshold. The algorithm uses a binary search to adjust the
upper waterlevel, starting at UpperValueLimit. UpperValueLimit
defaults to the 1.0.
See:
 itk::simple::IsolatedWatershed for the procedural interface

 itk::IsolatedWatershedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsolatedWatershedImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::Execute "/**
Image itk::simple::IsolatedWatershedImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::Execute "/**
Image itk::simple::IsolatedWatershedImageFilter::Execute(const Image &image1, const std::vector< uint32_t > &seed1, const
std::vector< uint32_t > &seed2, double threshold, double
upperValueLimit, double isolatedValueTolerance, uint8_t replaceValue1,
uint8_t replaceValue2)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetIsolatedValueTolerance "/**
double itk::simple::IsolatedWatershedImageFilter::GetIsolatedValueTolerance() const

Set/Get the precision required for the intensity threshold value. The
default is .001.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetName "/**
std::string itk::simple::IsolatedWatershedImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetReplaceValue1 "/**
uint8_t itk::simple::IsolatedWatershedImageFilter::GetReplaceValue1() const

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetReplaceValue2 "/**
uint8_t itk::simple::IsolatedWatershedImageFilter::GetReplaceValue2() const

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetSeed1 "/**
std::vector<uint32_t> itk::simple::IsolatedWatershedImageFilter::GetSeed1() const

Set seed point 1. This seed will be isolated from Seed2 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue1.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetSeed2 "/**
std::vector<uint32_t> itk::simple::IsolatedWatershedImageFilter::GetSeed2() const

Set seed point 2. This seed will be isolated from Seed1 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue2.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetThreshold "/**
double itk::simple::IsolatedWatershedImageFilter::GetThreshold() const

Set/Get the Watershed threshold. The default is 0.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::GetUpperValueLimit "/**
double itk::simple::IsolatedWatershedImageFilter::GetUpperValueLimit() const

Set/Get the limit on the upper waterlevel value. The default is 1.0.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::IsolatedWatershedImageFilter "/**
itk::simple::IsolatedWatershedImageFilter::IsolatedWatershedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetIsolatedValueTolerance "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetIsolatedValueTolerance(double IsolatedValueTolerance)

Set/Get the precision required for the intensity threshold value. The
default is .001.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetReplaceValue1 "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetReplaceValue1(uint8_t ReplaceValue1)

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetReplaceValue2 "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetReplaceValue2(uint8_t ReplaceValue2)

Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetSeed1 "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetSeed1(const std::vector< uint32_t > &Seed1)

Set seed point 1. This seed will be isolated from Seed2 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue1.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetSeed2 "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetSeed2(const std::vector< uint32_t > &Seed2)

Set seed point 2. This seed will be isolated from Seed1 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue2.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetThreshold "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetThreshold(double Threshold)

Set/Get the Watershed threshold. The default is 0.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::SetUpperValueLimit "/**
Self& itk::simple::IsolatedWatershedImageFilter::SetUpperValueLimit(double UpperValueLimit)

Set/Get the limit on the upper waterlevel value. The default is 1.0.

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::ToString "/**
std::string itk::simple::IsolatedWatershedImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IsolatedWatershedImageFilter::~IsolatedWatershedImageFilter "/**
itk::simple::IsolatedWatershedImageFilter::~IsolatedWatershedImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::IterativeInverseDisplacementFieldImageFilter "/**

Computes the inverse of a displacement field.


IterativeInverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement
field that is its inverse. If the input displacement field was mapping
coordinates from a space A into a space B, the output of this filter
will map coordinates from the space B into the space A.

The algorithm implemented in this filter uses an iterative method for
progresively refining the values of the inverse field. Starting from
the direct field, at every pixel the direct mapping of this point is
found, and a the nevative of the current displacement is stored in the
inverse field at the nearest pixel. Then, subsequent iterations verify
if any of the neigbor pixels provide a better return to the current
pixel, in which case its value is taken for updating the vector in the
inverse field.

This method was discussed in the users-list during February 2004.


Corinne Mattmann

See:
 itk::simple::IterativeInverseDisplacementField for the procedural interface

 itk::IterativeInverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIterativeInverseDisplacementFieldImageFilter.h
*/"

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::Execute "/**
Image itk::simple::IterativeInverseDisplacementFieldImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::Execute "/**
Image itk::simple::IterativeInverseDisplacementFieldImageFilter::Execute(const Image &image1, uint32_t numberOfIterations, double stopValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::GetName "/**
std::string itk::simple::IterativeInverseDisplacementFieldImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::IterativeInverseDisplacementFieldImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::GetStopValue "/**
double itk::simple::IterativeInverseDisplacementFieldImageFilter::GetStopValue() const
*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::IterativeInverseDisplacementFieldImageFilter "/**
itk::simple::IterativeInverseDisplacementFieldImageFilter::IterativeInverseDisplacementFieldImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::SetNumberOfIterations "/**
Self& itk::simple::IterativeInverseDisplacementFieldImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::SetStopValue "/**
Self& itk::simple::IterativeInverseDisplacementFieldImageFilter::SetStopValue(double StopValue)
*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::ToString "/**
std::string itk::simple::IterativeInverseDisplacementFieldImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::IterativeInverseDisplacementFieldImageFilter::~IterativeInverseDisplacementFieldImageFilter "/**
itk::simple::IterativeInverseDisplacementFieldImageFilter::~IterativeInverseDisplacementFieldImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::JoinSeriesImageFilter "/**

Join N-D images into an (N+1)-D image.


This filter is templated over the input image type and the output
image type. The pixel type of them must be the same and the input
dimension must be less than the output dimension. When the input
images are N-dimensinal, they are joined in order and the size of the
N+1'th dimension of the output is same as the number of the inputs.
The spacing and the origin (where the first input is placed) for the
N+1'th dimension is specified in this filter. The output image
informations for the first N dimensions are taken from the first
input. Note that all the inputs should have the same information.


Hideaki Hiraki
 Contributed in the users list http://public.kitware.com/pipermail/insight-
users/2004-February/006542.html


See:
 itk::simple::JoinSeries for the procedural interface


C++ includes: sitkJoinSeriesImageFilter.h
*/"

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector< Image > &images, double origin, double spacing)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, double origin, double spacing)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, double origin, double
spacing)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, double
origin, double spacing)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, double origin, double spacing)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::Execute "/**
Image itk::simple::JoinSeriesImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5, double origin, double spacing)
*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::GetName "/**
std::string itk::simple::JoinSeriesImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::GetOrigin "/**
double itk::simple::JoinSeriesImageFilter::GetOrigin() const

Set/Get origin of the new dimension

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::GetSpacing "/**
double itk::simple::JoinSeriesImageFilter::GetSpacing() const

Set/Get spacing of the new dimension

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::JoinSeriesImageFilter "/**
itk::simple::JoinSeriesImageFilter::JoinSeriesImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::SetOrigin "/**
Self& itk::simple::JoinSeriesImageFilter::SetOrigin(double Origin)

Set/Get origin of the new dimension

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::SetSpacing "/**
Self& itk::simple::JoinSeriesImageFilter::SetSpacing(double Spacing)

Set/Get spacing of the new dimension

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::ToString "/**
std::string itk::simple::JoinSeriesImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::JoinSeriesImageFilter::~JoinSeriesImageFilter "/**
itk::simple::JoinSeriesImageFilter::~JoinSeriesImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::KittlerIllingworthThresholdImageFilter "/**

Threshold an image using the KittlerIllingworth Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the KittlerIllingworthThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::KittlerIllingworthThreshold for the procedural interface

 itk::KittlerIllingworthThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkKittlerIllingworthThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::Execute "/**
Image itk::simple::KittlerIllingworthThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::Execute "/**
Image itk::simple::KittlerIllingworthThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::Execute "/**
Image itk::simple::KittlerIllingworthThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::Execute "/**
Image itk::simple::KittlerIllingworthThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::KittlerIllingworthThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::KittlerIllingworthThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::KittlerIllingworthThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetName "/**
std::string itk::simple::KittlerIllingworthThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::KittlerIllingworthThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::KittlerIllingworthThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::GetThreshold "/**
double itk::simple::KittlerIllingworthThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::KittlerIllingworthThresholdImageFilter "/**
itk::simple::KittlerIllingworthThresholdImageFilter::KittlerIllingworthThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::KittlerIllingworthThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::ToString "/**
std::string itk::simple::KittlerIllingworthThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::KittlerIllingworthThresholdImageFilter::~KittlerIllingworthThresholdImageFilter "/**
itk::simple::KittlerIllingworthThresholdImageFilter::~KittlerIllingworthThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelContourImageFilter "/**

Labels the pixels on the border of the objects in a labeled image.


LabelContourImageFilter takes a labeled image as input, where the pixels in the objects are
the pixels with a value different of the BackgroundValue. Only the
pixels on the contours of the objects are kept. The pixels not on the
border are changed to BackgroundValue. The labels of the object are
the same in the input and in the output image.

The connectivity can be changed to minimum or maximum connectivity
with SetFullyConnected() . Full connectivity produces thicker contours.

https://hdl.handle.net/1926/1352


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 BinaryContourImageFilter
Wiki Examples:

All Examples

Label the contours of connected components
See:
 itk::simple::LabelContour for the procedural interface

 itk::LabelContourImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLabelContourImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelContourImageFilter::Execute "/**
Image itk::simple::LabelContourImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::Execute "/**
Image itk::simple::LabelContourImageFilter::Execute(const Image &image1, bool fullyConnected, double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::FullyConnectedOff "/**
Self& itk::simple::LabelContourImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::FullyConnectedOn "/**
Self& itk::simple::LabelContourImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::GetBackgroundValue "/**
double itk::simple::LabelContourImageFilter::GetBackgroundValue() const

Set/Get the background value used to identify the objects and mark the
pixels not on the border of the objects.

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::GetFullyConnected "/**
bool itk::simple::LabelContourImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff.
For objects that are 1 pixel wide, use FullyConnectedOn.


*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::GetName "/**
std::string itk::simple::LabelContourImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::LabelContourImageFilter "/**
itk::simple::LabelContourImageFilter::LabelContourImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelContourImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value used to identify the objects and mark the
pixels not on the border of the objects.

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::SetFullyConnected "/**
Self& itk::simple::LabelContourImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff.
For objects that are 1 pixel wide, use FullyConnectedOn.


*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::ToString "/**
std::string itk::simple::LabelContourImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelContourImageFilter::~LabelContourImageFilter "/**
itk::simple::LabelContourImageFilter::~LabelContourImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelImageToLabelMapFilter "/**

convert a labeled image to a label collection image


LabelImageToLabelMapFilter converts a label image to a label collection image. The labels are
the same in the input and the output image.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 BinaryImageToLabelMapFilter , LabelMapToLabelImageFilter
Wiki Examples:

All Examples

Convert an itk::Image consisting of labeled regions to a LabelMap
See:
 itk::simple::LabelImageToLabelMapFilter for the procedural interface

 itk::LabelImageToLabelMapFilter for the Doxygen on the original ITK class.



C++ includes: sitkLabelImageToLabelMapFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::Execute "/**
Image itk::simple::LabelImageToLabelMapFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::Execute "/**
Image itk::simple::LabelImageToLabelMapFilter::Execute(const Image &image1, double backgroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::GetBackgroundValue "/**
double itk::simple::LabelImageToLabelMapFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::GetName "/**
std::string itk::simple::LabelImageToLabelMapFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::LabelImageToLabelMapFilter "/**
itk::simple::LabelImageToLabelMapFilter::LabelImageToLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::SetBackgroundValue "/**
Self& itk::simple::LabelImageToLabelMapFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::ToString "/**
std::string itk::simple::LabelImageToLabelMapFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelImageToLabelMapFilter::~LabelImageToLabelMapFilter "/**
itk::simple::LabelImageToLabelMapFilter::~LabelImageToLabelMapFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelIntensityStatisticsImageFilter "/**

a convenient class to convert a label image to a label map and valuate
the statistics attributes at once



Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 StatisticsLabelObject , LabelStatisticsOpeningImageFilter , LabelStatisticsOpeningImageFilter

 itk::LabelImageToStatisticsLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelIntensityStatisticsImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::ComputeFeretDiameterOff "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::ComputeFeretDiameterOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::ComputeFeretDiameterOn "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::ComputeFeretDiameterOn()

Set the value of ComputeFeretDiameter to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::ComputePerimeterOff "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::ComputePerimeterOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::ComputePerimeterOn "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::ComputePerimeterOn()

Set the value of ComputePerimeter to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::Execute "/**
void itk::simple::LabelIntensityStatisticsImageFilter::Execute(const Image &image, const Image &featureImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::Execute "/**
void itk::simple::LabelIntensityStatisticsImageFilter::Execute(const Image &image, const Image &featureImage, double
backgroundValue, bool computeFeretDiameter, bool computePerimeter,
uint32_t numberOfBins)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetBackgroundValue "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetBoundingBox "/**
std::vector<unsigned int> itk::simple::LabelIntensityStatisticsImageFilter::GetBoundingBox(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetCenterOfGravity "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetCenterOfGravity(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetCentroid "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetCentroid(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetComputeFeretDiameter "/**
bool itk::simple::LabelIntensityStatisticsImageFilter::GetComputeFeretDiameter() const

Set/Get whether the maximum Feret diameter should be computed or not.
The defaut value is false, because of the high computation time
required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetComputePerimeter "/**
bool itk::simple::LabelIntensityStatisticsImageFilter::GetComputePerimeter() const

Set/Get whether the perimeter should be computed or not. The defaut
value is false, because of the high computation time required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetElongation "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetElongation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentEllipsoidDiameter "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentEllipsoidDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentSphericalPerimeter "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentSphericalPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentSphericalRadius "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentSphericalRadius(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetFeretDiameter "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetFeretDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetFlatness "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetFlatness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetKurtosis "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetKurtosis(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetLabels "/**
std::vector<int64_t> itk::simple::LabelIntensityStatisticsImageFilter::GetLabels() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetMaximum "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMaximum(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetMaximumIndex "/**
std::vector<uint32_t> itk::simple::LabelIntensityStatisticsImageFilter::GetMaximumIndex(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetMean "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMean(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetMedian "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMedian(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetMinimum "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMinimum(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetMinimumIndex "/**
std::vector<uint32_t> itk::simple::LabelIntensityStatisticsImageFilter::GetMinimumIndex(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetName "/**
std::string itk::simple::LabelIntensityStatisticsImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfBins "/**
uint32_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfBins() const

Set/Get the number of bins in the histogram. Note that the histogram
is used to compute the median value, and that this option may have an
effect on the value of the median.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfLabels "/**
uint64_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfLabels()

Return the number of labels after execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfPixels "/**
uint64_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfPixels(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfPixelsOnBorder "/**
uint64_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfPixelsOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeter "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeterOnBorder "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeterOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeterOnBorderRatio "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeterOnBorderRatio(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetPhysicalSize "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPhysicalSize(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetPrincipalAxes "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetPrincipalAxes(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetPrincipalMoments "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetPrincipalMoments(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetRoundness "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetRoundness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetSkewness "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetSkewness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetStandardDeviation "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetStandardDeviation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetSum "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetSum(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetVariance "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetVariance(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedElongation "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedElongation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedFlatness "/**
double itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedFlatness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedPrincipalAxes "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedPrincipalAxes(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedPrincipalMoments "/**
std::vector<double> itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedPrincipalMoments(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::HasLabel "/**
double itk::simple::LabelIntensityStatisticsImageFilter::HasLabel(int64_t label)

Does the specified label exist? Can only be called after a call a call
to Update().

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::LabelIntensityStatisticsImageFilter "/**
itk::simple::LabelIntensityStatisticsImageFilter::LabelIntensityStatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::SetComputeFeretDiameter "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::SetComputeFeretDiameter(bool ComputeFeretDiameter)

Set/Get whether the maximum Feret diameter should be computed or not.
The defaut value is false, because of the high computation time
required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::SetComputePerimeter "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::SetComputePerimeter(bool ComputePerimeter)

Set/Get whether the perimeter should be computed or not. The defaut
value is false, because of the high computation time required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::SetNumberOfBins "/**
Self& itk::simple::LabelIntensityStatisticsImageFilter::SetNumberOfBins(uint32_t NumberOfBins)

Set/Get the number of bins in the histogram. Note that the histogram
is used to compute the median value, and that this option may have an
effect on the value of the median.

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::ToString "/**
std::string itk::simple::LabelIntensityStatisticsImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelIntensityStatisticsImageFilter::~LabelIntensityStatisticsImageFilter "/**
itk::simple::LabelIntensityStatisticsImageFilter::~LabelIntensityStatisticsImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelMapContourOverlayImageFilter "/**

Apply a colormap to the contours (outlines) of each object in a label
map and superimpose it on top of the feature image.


The feature image is typically the image from which the labeling was
produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.

Apply a colormap to a label map and put it on top of the input image.
The set of colors is a good selection of distinct colors. The opacity
of the label map can be defined by the user. A background label
produce a gray pixel with the same intensity than the input one.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 LabelMapOverlayImageFilter , LabelOverlayImageFilter , LabelOverlayFunctor

 LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter ,
Wiki Examples:

All Examples

Color the boundaries of labeled regions in an image
See:
 itk::simple::LabelMapContourOverlay for the procedural interface

 itk::LabelMapContourOverlayImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLabelMapContourOverlayImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::Execute "/**
Image itk::simple::LabelMapContourOverlayImageFilter::Execute(const Image &labelMapImage, const Image &featureImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::Execute "/**
Image itk::simple::LabelMapContourOverlayImageFilter::Execute(const Image &labelMapImage, const Image &featureImage, double
opacity, const std::vector< unsigned int > &dilationRadius, const
std::vector< unsigned int > &contourThickness, unsigned int
sliceDimension, LabelMapContourOverlayImageFilter::ContourTypeType
contourType, LabelMapContourOverlayImageFilter::PriorityType priority,
std::vector< uint8_t > colormap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetColormap "/**
std::vector<uint8_t> itk::simple::LabelMapContourOverlayImageFilter::GetColormap() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetContourThickness "/**
std::vector<unsigned int> itk::simple::LabelMapContourOverlayImageFilter::GetContourThickness() const

Set/Get the contour thickness - 1 by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetContourType "/**
ContourTypeType itk::simple::LabelMapContourOverlayImageFilter::GetContourType() const

Set/Get the overlay type - CONTOUR is used by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetDilationRadius "/**
std::vector<unsigned int> itk::simple::LabelMapContourOverlayImageFilter::GetDilationRadius() const

Set/Get the object dilation radius - 0 by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetName "/**
std::string itk::simple::LabelMapContourOverlayImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetOpacity "/**
double itk::simple::LabelMapContourOverlayImageFilter::GetOpacity() const

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetPriority "/**
PriorityType itk::simple::LabelMapContourOverlayImageFilter::GetPriority() const

Set/Get the object priority - HIGH_LABEL_ON_TOP by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::GetSliceDimension "/**
unsigned int itk::simple::LabelMapContourOverlayImageFilter::GetSliceDimension() const

Set/Get the slice dimension - defaults to image dimension - 1.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::LabelMapContourOverlayImageFilter "/**
itk::simple::LabelMapContourOverlayImageFilter::LabelMapContourOverlayImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetColormap "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetColormap(std::vector< uint8_t > Colormap)
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetContourThickness "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetContourThickness(const std::vector< unsigned int > &ContourThickness)

Set/Get the contour thickness - 1 by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetContourType "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetContourType(ContourTypeType ContourType)

Set/Get the overlay type - CONTOUR is used by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetDilationRadius "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetDilationRadius(const std::vector< unsigned int > &DilationRadius)

Set/Get the object dilation radius - 0 by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetDilationRadius "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetDilationRadius(unsigned int value)

Set the values of the DilationRadius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetOpacity "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetOpacity(double Opacity)

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetPriority "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetPriority(PriorityType Priority)

Set/Get the object priority - HIGH_LABEL_ON_TOP by default.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::SetSliceDimension "/**
Self& itk::simple::LabelMapContourOverlayImageFilter::SetSliceDimension(unsigned int SliceDimension)

Set/Get the slice dimension - defaults to image dimension - 1.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::ToString "/**
std::string itk::simple::LabelMapContourOverlayImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapContourOverlayImageFilter::~LabelMapContourOverlayImageFilter "/**
itk::simple::LabelMapContourOverlayImageFilter::~LabelMapContourOverlayImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelMapMaskImageFilter "/**

Mask and image with a LabelMap .


LabelMapMaskImageFilter mask the content of an input image according to the content of the
input LabelMap . The masked pixel of the input image are set to the BackgroundValue. LabelMapMaskImageFilter can keep the input image for one label only, with Negated = false
(the default) or it can mask the input image for a single label, when
Negated equals true. In Both cases, the label is set with SetLabel() .


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter

 itk::simple::LabelMapMask for the procedural interface

 itk::LabelMapMaskImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapMaskImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::CropOff "/**
Self& itk::simple::LabelMapMaskImageFilter::CropOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::CropOn "/**
Self& itk::simple::LabelMapMaskImageFilter::CropOn()

Set the value of Crop to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::Execute "/**
Image itk::simple::LabelMapMaskImageFilter::Execute(const Image &labelMapImage, const Image &featureImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::Execute "/**
Image itk::simple::LabelMapMaskImageFilter::Execute(const Image &labelMapImage, const Image &featureImage, uint64_t
label, double backgroundValue, bool negated, bool crop, const
std::vector< unsigned int > &cropBorder)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::GetBackgroundValue "/**
double itk::simple::LabelMapMaskImageFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::ZeroValue() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::GetCrop "/**
bool itk::simple::LabelMapMaskImageFilter::GetCrop() const

Set/Get whether the image size should be adjusted to the masked image
or not.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::GetCropBorder "/**
std::vector<unsigned int> itk::simple::LabelMapMaskImageFilter::GetCropBorder() const

Set/Get the boder added to the mask before the crop. The default is 0
on all the axes.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::GetLabel "/**
uint64_t itk::simple::LabelMapMaskImageFilter::GetLabel() const

The label to mask or to not mask, depending on the value of the
Negated ivar.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::GetName "/**
std::string itk::simple::LabelMapMaskImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::GetNegated "/**
bool itk::simple::LabelMapMaskImageFilter::GetNegated() const

Set/Get whether the Label should be masked or not.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::LabelMapMaskImageFilter "/**
itk::simple::LabelMapMaskImageFilter::LabelMapMaskImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::NegatedOff "/**
Self& itk::simple::LabelMapMaskImageFilter::NegatedOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::NegatedOn "/**
Self& itk::simple::LabelMapMaskImageFilter::NegatedOn()

Set the value of Negated to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelMapMaskImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::ZeroValue() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::SetCrop "/**
Self& itk::simple::LabelMapMaskImageFilter::SetCrop(bool Crop)

Set/Get whether the image size should be adjusted to the masked image
or not.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::SetCropBorder "/**
Self& itk::simple::LabelMapMaskImageFilter::SetCropBorder(const std::vector< unsigned int > &CropBorder)

Set/Get the boder added to the mask before the crop. The default is 0
on all the axes.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::SetCropBorder "/**
Self& itk::simple::LabelMapMaskImageFilter::SetCropBorder(unsigned int value)

Set the values of the CropBorder vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::SetLabel "/**
Self& itk::simple::LabelMapMaskImageFilter::SetLabel(uint64_t Label)

The label to mask or to not mask, depending on the value of the
Negated ivar.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::SetNegated "/**
Self& itk::simple::LabelMapMaskImageFilter::SetNegated(bool Negated)

Set/Get whether the Label should be masked or not.

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::ToString "/**
std::string itk::simple::LabelMapMaskImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapMaskImageFilter::~LabelMapMaskImageFilter "/**
itk::simple::LabelMapMaskImageFilter::~LabelMapMaskImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelMapOverlayImageFilter "/**

Apply a colormap to a label map and superimpose it on an image.


Apply a colormap to a label map and put it on top of the feature
image. The feature image is typically the image from which the
labeling was produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.

The set of colors is a good selection of distinct colors. The opacity
of the label map can be defined by the user. A background label
produce a gray pixel with the same intensity than the input one.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 LabelOverlayImageFilter , LabelOverlayFunctor

 LabelMapToRGBImageFilter , LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter

 itk::simple::LabelMapOverlay for the procedural interface

 itk::LabelMapOverlayImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapOverlayImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::Execute "/**
Image itk::simple::LabelMapOverlayImageFilter::Execute(const Image &labelMapImage, const Image &featureImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::Execute "/**
Image itk::simple::LabelMapOverlayImageFilter::Execute(const Image &labelMapImage, const Image &featureImage, double
opacity, std::vector< unsigned char > colormap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::GetColormap "/**
std::vector<unsigned char> itk::simple::LabelMapOverlayImageFilter::GetColormap() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::GetName "/**
std::string itk::simple::LabelMapOverlayImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::GetOpacity "/**
double itk::simple::LabelMapOverlayImageFilter::GetOpacity() const

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::LabelMapOverlayImageFilter "/**
itk::simple::LabelMapOverlayImageFilter::LabelMapOverlayImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::SetColormap "/**
Self& itk::simple::LabelMapOverlayImageFilter::SetColormap(std::vector< unsigned char > Colormap)
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::SetOpacity "/**
Self& itk::simple::LabelMapOverlayImageFilter::SetOpacity(double Opacity)

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::ToString "/**
std::string itk::simple::LabelMapOverlayImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapOverlayImageFilter::~LabelMapOverlayImageFilter "/**
itk::simple::LabelMapOverlayImageFilter::~LabelMapOverlayImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelMapToBinaryImageFilter "/**

Convert a LabelMap to a binary image.


LabelMapToBinaryImageFilter to a binary image. All the objects in the image are used as
foreground. The background values of the original binary image can be
restored by passing this image to the filter with the
SetBackgroundImage() method.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 LabelMapToLabelImageFilter , LabelMapMaskImageFilter

 itk::simple::LabelMapToBinary for the procedural interface

 itk::LabelMapToBinaryImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapToBinaryImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::Execute "/**
Image itk::simple::LabelMapToBinaryImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::Execute "/**
Image itk::simple::LabelMapToBinaryImageFilter::Execute(const Image &image1, double backgroundValue, double foregroundValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::GetBackgroundValue "/**
double itk::simple::LabelMapToBinaryImageFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::GetForegroundValue "/**
double itk::simple::LabelMapToBinaryImageFilter::GetForegroundValue() const

Set/Get the value used as \"foreground\" in the output image. Defaults
to NumericTraits<PixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::GetName "/**
std::string itk::simple::LabelMapToBinaryImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::LabelMapToBinaryImageFilter "/**
itk::simple::LabelMapToBinaryImageFilter::LabelMapToBinaryImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelMapToBinaryImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::SetForegroundValue "/**
Self& itk::simple::LabelMapToBinaryImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the value used as \"foreground\" in the output image. Defaults
to NumericTraits<PixelType>::max() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::ToString "/**
std::string itk::simple::LabelMapToBinaryImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToBinaryImageFilter::~LabelMapToBinaryImageFilter "/**
itk::simple::LabelMapToBinaryImageFilter::~LabelMapToBinaryImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelMapToLabelImageFilter "/**

Converts a LabelMap to a labeled image.


LabelMapToBinaryImageFilter to a label image.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 LabelMapToBinaryImageFilter , LabelMapMaskImageFilter
Wiki Examples:

All Examples

Convert a LabelMap to a normal image with different values representing each region
See:
 itk::simple::LabelMapToLabel for the procedural interface

 itk::LabelMapToLabelImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLabelMapToLabelImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelMapToLabelImageFilter::Execute "/**
Image itk::simple::LabelMapToLabelImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToLabelImageFilter::GetName "/**
std::string itk::simple::LabelMapToLabelImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToLabelImageFilter::LabelMapToLabelImageFilter "/**
itk::simple::LabelMapToLabelImageFilter::LabelMapToLabelImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToLabelImageFilter::ToString "/**
std::string itk::simple::LabelMapToLabelImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToLabelImageFilter::~LabelMapToLabelImageFilter "/**
itk::simple::LabelMapToLabelImageFilter::~LabelMapToLabelImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelMapToRGBImageFilter "/**

Convert a LabelMap to a colored image.



Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 LabelToRGBImageFilter , LabelToRGBFunctor

 LabelMapOverlayImageFilter , LabelMapToBinaryImageFilter , LabelMapMaskImageFilter

 itk::simple::LabelMapToRGB for the procedural interface

 itk::LabelMapToRGBImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapToRGBImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::Execute "/**
Image itk::simple::LabelMapToRGBImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::Execute "/**
Image itk::simple::LabelMapToRGBImageFilter::Execute(const Image &image1, std::vector< uint8_t > colormap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::GetColormap "/**
std::vector<uint8_t> itk::simple::LabelMapToRGBImageFilter::GetColormap() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::GetName "/**
std::string itk::simple::LabelMapToRGBImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::LabelMapToRGBImageFilter "/**
itk::simple::LabelMapToRGBImageFilter::LabelMapToRGBImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::SetColormap "/**
Self& itk::simple::LabelMapToRGBImageFilter::SetColormap(std::vector< uint8_t > Colormap)
*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::ToString "/**
std::string itk::simple::LabelMapToRGBImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelMapToRGBImageFilter::~LabelMapToRGBImageFilter "/**
itk::simple::LabelMapToRGBImageFilter::~LabelMapToRGBImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelOverlapMeasuresImageFilter "/**

Computes overlap measures between the set same set of labels of pixels
of two images. Background is assumed to be 0.


This code was contributed in the Insight Journal paper: \"Introducing
Dice, Jaccard, and Other Label Overlap Measures To ITK\" by Nicholas
J. Tustison, James C. Gee https://hdl.handle.net/10380/3141 http://www.insight-journal.org/browse/publication/707


Nicholas J. Tustison

See:
 LabelOverlapMeasuresImageFilter

 itk::LabelOverlapMeasuresImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelOverlapMeasuresImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::Execute "/**
void itk::simple::LabelOverlapMeasuresImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetDiceCoefficient "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetDiceCoefficient() const

Get the mean overlap (Dice coefficient) for the specified individual
label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetFalseNegativeError "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalseNegativeError() const

Get the false negative error for the specified individual label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetFalsePositiveError "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetFalsePositiveError() const

Get the false positive error for the specified individual label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetJaccardCoefficient "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetJaccardCoefficient() const

Get the union overlap (Jaccard coefficient) for the specified
individual label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetMeanOverlap "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetMeanOverlap() const

Get the mean overlap (Dice coefficient) for the specified individual
label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetName "/**
std::string itk::simple::LabelOverlapMeasuresImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetUnionOverlap "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetUnionOverlap() const

Get the union overlap (Jaccard coefficient) for the specified
individual label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::GetVolumeSimilarity "/**
double itk::simple::LabelOverlapMeasuresImageFilter::GetVolumeSimilarity() const

Get the volume similarity for the specified individual label.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::LabelOverlapMeasuresImageFilter "/**
itk::simple::LabelOverlapMeasuresImageFilter::LabelOverlapMeasuresImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::ToString "/**
std::string itk::simple::LabelOverlapMeasuresImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlapMeasuresImageFilter::~LabelOverlapMeasuresImageFilter "/**
itk::simple::LabelOverlapMeasuresImageFilter::~LabelOverlapMeasuresImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelOverlayImageFilter "/**

Apply a colormap to a label image and put it on top of the input
image.


Apply a colormap to a label image and put it on top of the input
image. The set of colors is a good selection of distinct colors. The
opacity of the label image can be defined by the user. The user can
also choose if the want to use a background and which label value is
the background. A background label produce a gray pixel with the same
intensity than the input one.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This class was contributed to the Insight Journal https://hdl.handle.net/1926/172


See:
 LabelToRGBImageFilter

 LabelMapOverlayImageFilter , LabelOverlayFunctor
Wiki Examples:

All Examples

Overlay a LabelMap on an image
See:
 itk::simple::LabelOverlay for the procedural interface

 itk::LabelOverlayImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLabelOverlayImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::Execute "/**
Image itk::simple::LabelOverlayImageFilter::Execute(const Image &image, const Image &labelImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::Execute "/**
Image itk::simple::LabelOverlayImageFilter::Execute(const Image &image, const Image &labelImage, double opacity, double
backgroundValue, std::vector< uint8_t > colormap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::GetBackgroundValue "/**
double itk::simple::LabelOverlayImageFilter::GetBackgroundValue() const

Set/Get the background value

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::GetColormap "/**
std::vector<uint8_t> itk::simple::LabelOverlayImageFilter::GetColormap() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::GetName "/**
std::string itk::simple::LabelOverlayImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::GetOpacity "/**
double itk::simple::LabelOverlayImageFilter::GetOpacity() const

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::LabelOverlayImageFilter "/**
itk::simple::LabelOverlayImageFilter::LabelOverlayImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelOverlayImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::SetColormap "/**
Self& itk::simple::LabelOverlayImageFilter::SetColormap(std::vector< uint8_t > Colormap)
*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::SetOpacity "/**
Self& itk::simple::LabelOverlayImageFilter::SetOpacity(double Opacity)

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::ToString "/**
std::string itk::simple::LabelOverlayImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelOverlayImageFilter::~LabelOverlayImageFilter "/**
itk::simple::LabelOverlayImageFilter::~LabelOverlayImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelShapeStatisticsImageFilter "/**

Converts a label image to a label map and valuates the shape
attributes.


A convenient class that converts a label image to a label map and
valuates the shape attribute at once.

This implementation was taken from the Insight Journal paper:

https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , LabelShapeOpeningImageFilter , LabelStatisticsOpeningImageFilter
Wiki Examples:

All Examples

Convert an itk::Image consisting of labeled regions to a ShapeLabelMap

See:
 itk::LabelImageToShapeLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelShapeStatisticsImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::ComputeFeretDiameterOff "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::ComputeFeretDiameterOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::ComputeFeretDiameterOn "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::ComputeFeretDiameterOn()

Set the value of ComputeFeretDiameter to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::ComputePerimeterOff "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::ComputePerimeterOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::ComputePerimeterOn "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::ComputePerimeterOn()

Set the value of ComputePerimeter to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::Execute "/**
void itk::simple::LabelShapeStatisticsImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::Execute "/**
void itk::simple::LabelShapeStatisticsImageFilter::Execute(const Image &image1, double backgroundValue, bool
computeFeretDiameter, bool computePerimeter)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetBackgroundValue "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetBackgroundValue() const

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetBoundingBox "/**
std::vector<unsigned int> itk::simple::LabelShapeStatisticsImageFilter::GetBoundingBox(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetCentroid "/**
std::vector<double> itk::simple::LabelShapeStatisticsImageFilter::GetCentroid(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetComputeFeretDiameter "/**
bool itk::simple::LabelShapeStatisticsImageFilter::GetComputeFeretDiameter() const

Set/Get whether the maximum Feret diameter should be computed or not.
Default value is false, because of the high computation time required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetComputePerimeter "/**
bool itk::simple::LabelShapeStatisticsImageFilter::GetComputePerimeter() const

Set/Get whether the perimeter should be computed or not. Default value
is false, because of the high computation time required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetElongation "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetElongation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentEllipsoidDiameter "/**
std::vector<double> itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentEllipsoidDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentSphericalPerimeter "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentSphericalPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentSphericalRadius "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentSphericalRadius(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetFeretDiameter "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetFeretDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetFlatness "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetFlatness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetLabels "/**
std::vector<int64_t> itk::simple::LabelShapeStatisticsImageFilter::GetLabels() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetName "/**
std::string itk::simple::LabelShapeStatisticsImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfLabels "/**
uint64_t itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfLabels()

Return the number of labels after execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfPixels "/**
uint64_t itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfPixels(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfPixelsOnBorder "/**
uint64_t itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfPixelsOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetPerimeter "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetPerimeterOnBorder "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetPerimeterOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetPerimeterOnBorderRatio "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetPerimeterOnBorderRatio(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetPhysicalSize "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetPhysicalSize(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetPrincipalAxes "/**
std::vector<double> itk::simple::LabelShapeStatisticsImageFilter::GetPrincipalAxes(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetPrincipalMoments "/**
std::vector<double> itk::simple::LabelShapeStatisticsImageFilter::GetPrincipalMoments(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::GetRoundness "/**
double itk::simple::LabelShapeStatisticsImageFilter::GetRoundness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::HasLabel "/**
double itk::simple::LabelShapeStatisticsImageFilter::HasLabel(int64_t label)

Does the specified label exist? Can only be called after a call a call
to Update().

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::LabelShapeStatisticsImageFilter "/**
itk::simple::LabelShapeStatisticsImageFilter::LabelShapeStatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as \"background\" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::SetComputeFeretDiameter "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::SetComputeFeretDiameter(bool ComputeFeretDiameter)

Set/Get whether the maximum Feret diameter should be computed or not.
Default value is false, because of the high computation time required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::SetComputePerimeter "/**
Self& itk::simple::LabelShapeStatisticsImageFilter::SetComputePerimeter(bool ComputePerimeter)

Set/Get whether the perimeter should be computed or not. Default value
is false, because of the high computation time required.

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::ToString "/**
std::string itk::simple::LabelShapeStatisticsImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelShapeStatisticsImageFilter::~LabelShapeStatisticsImageFilter "/**
itk::simple::LabelShapeStatisticsImageFilter::~LabelShapeStatisticsImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelStatisticsImageFilter "/**

Given an intensity image and a label map, compute min, max, variance
and mean of the pixels associated with each label or segment.


LabelStatisticsImageFilter computes the minimum, maximum, sum, mean, median, variance and sigma
of regions of an intensity image, where the regions are defined via a
label map (a second input). The label image should be integral type.
The filter needs all of its input image. It behaves as a filter with
an input and output. Thus it can be inserted in a pipline with other
filters and the statistics will only be recomputed if a downstream
filter changes.

Optionally, the filter also computes intensity histograms on each
object. If histograms are enabled, a median intensity value can also
be computed, although its accuracy is limited to the bin width of the
histogram. If histograms are not enabled, the median returns zero.

The filter passes its intensity input through unmodified. The filter
is threaded. It computes statistics in each thread then combines them
in its AfterThreadedGenerate method.

Wiki Examples:

All Examples

Get statistical properties of labeled regions in an image

See:
 itk::LabelStatisticsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelStatisticsImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::Execute "/**
void itk::simple::LabelStatisticsImageFilter::Execute(const Image &image, const Image &labelImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::Execute "/**
void itk::simple::LabelStatisticsImageFilter::Execute(const Image &image, const Image &labelImage, bool useHistograms)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetBoundingBox "/**
std::vector<int> itk::simple::LabelStatisticsImageFilter::GetBoundingBox(int64_t label) const

Return the computed bounding box for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetCount "/**
uint64_t itk::simple::LabelStatisticsImageFilter::GetCount(int64_t label) const

Return the number of pixels for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetLabels "/**
std::vector<int64_t> itk::simple::LabelStatisticsImageFilter::GetLabels() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetMaximum "/**
double itk::simple::LabelStatisticsImageFilter::GetMaximum(int64_t label) const

Return the computed Maximum for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetMean "/**
double itk::simple::LabelStatisticsImageFilter::GetMean(int64_t label) const

Return the computed Mean for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetMedian "/**
double itk::simple::LabelStatisticsImageFilter::GetMedian(int64_t label) const

Return the computed Median for a label. Requires histograms to be
enabled!

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetMinimum "/**
double itk::simple::LabelStatisticsImageFilter::GetMinimum(int64_t label) const

Return the computed Minimum for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetName "/**
std::string itk::simple::LabelStatisticsImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetNumberOfLabels "/**
uint64_t itk::simple::LabelStatisticsImageFilter::GetNumberOfLabels()

Return the number of labels after execution .

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetSigma "/**
double itk::simple::LabelStatisticsImageFilter::GetSigma(int64_t label) const

Return the computed Standard Deviation for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetSum "/**
double itk::simple::LabelStatisticsImageFilter::GetSum(int64_t label) const

Return the compute Sum for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetUseHistograms "/**
bool itk::simple::LabelStatisticsImageFilter::GetUseHistograms() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::GetVariance "/**
double itk::simple::LabelStatisticsImageFilter::GetVariance(int64_t label) const

Return the computed Variance for a label.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::HasLabel "/**
double itk::simple::LabelStatisticsImageFilter::HasLabel(int64_t label)

Does the specified label exist? Can only be called after a call a call
to Update().

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::LabelStatisticsImageFilter "/**
itk::simple::LabelStatisticsImageFilter::LabelStatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::SetUseHistograms "/**
Self& itk::simple::LabelStatisticsImageFilter::SetUseHistograms(bool UseHistograms)
*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::ToString "/**
std::string itk::simple::LabelStatisticsImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::UseHistogramsOff "/**
Self& itk::simple::LabelStatisticsImageFilter::UseHistogramsOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::UseHistogramsOn "/**
Self& itk::simple::LabelStatisticsImageFilter::UseHistogramsOn()

Set the value of UseHistograms to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelStatisticsImageFilter::~LabelStatisticsImageFilter "/**
itk::simple::LabelStatisticsImageFilter::~LabelStatisticsImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelToRGBImageFilter "/**

Apply a colormap to a label image.


Apply a colormap to a label image. The set of colors is a good
selection of distinct colors. The user can choose to use a background
value. In that case, a gray pixel with the same intensity than the
background label is produced.

This code was contributed in the Insight Journal paper: \"The
watershed transform in ITK - discussion and new developments\" by
Beare R., Lehmann G. https://hdl.handle.net/1926/202 http://www.insight-journal.org/browse/publication/92


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.


See:
 LabelOverlayImageFilter

 LabelMapToRGBImageFilter , LabelToRGBFunctor, ScalarToRGBPixelFunctor

 itk::simple::LabelToRGB for the procedural interface

 itk::LabelToRGBImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelToRGBImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::Execute "/**
Image itk::simple::LabelToRGBImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::Execute "/**
Image itk::simple::LabelToRGBImageFilter::Execute(const Image &image1, double backgroundValue, std::vector< uint8_t >
colormap)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::GetBackgroundValue "/**
double itk::simple::LabelToRGBImageFilter::GetBackgroundValue() const

Set/Get the background value

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::GetColormap "/**
std::vector<uint8_t> itk::simple::LabelToRGBImageFilter::GetColormap() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::GetName "/**
std::string itk::simple::LabelToRGBImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::LabelToRGBImageFilter "/**
itk::simple::LabelToRGBImageFilter::LabelToRGBImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::SetBackgroundValue "/**
Self& itk::simple::LabelToRGBImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::SetColormap "/**
Self& itk::simple::LabelToRGBImageFilter::SetColormap(std::vector< uint8_t > Colormap)
*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::ToString "/**
std::string itk::simple::LabelToRGBImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelToRGBImageFilter::~LabelToRGBImageFilter "/**
itk::simple::LabelToRGBImageFilter::~LabelToRGBImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelUniqueLabelMapFilter "/**

Make sure that the objects are not overlapping.


AttributeUniqueLabelMapFilter search the overlapping zones in the overlapping objects and keeps
only a single object on all the pixels of the image. The object to
keep is selected according to their label.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


See:
 AttributeLabelObject

 itk::simple::LabelUniqueLabelMapFilter for the procedural interface

 itk::LabelUniqueLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelUniqueLabelMapFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::Execute "/**
Image itk::simple::LabelUniqueLabelMapFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::Execute "/**
Image itk::simple::LabelUniqueLabelMapFilter::Execute(const Image &image1, bool reverseOrdering)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::GetName "/**
std::string itk::simple::LabelUniqueLabelMapFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::GetReverseOrdering "/**
bool itk::simple::LabelUniqueLabelMapFilter::GetReverseOrdering() const
*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::LabelUniqueLabelMapFilter "/**
itk::simple::LabelUniqueLabelMapFilter::LabelUniqueLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::ReverseOrderingOff "/**
Self& itk::simple::LabelUniqueLabelMapFilter::ReverseOrderingOff()
*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::ReverseOrderingOn "/**
Self& itk::simple::LabelUniqueLabelMapFilter::ReverseOrderingOn()

Set the value of ReverseOrdering to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::SetReverseOrdering "/**
Self& itk::simple::LabelUniqueLabelMapFilter::SetReverseOrdering(bool ReverseOrdering)
*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::ToString "/**
std::string itk::simple::LabelUniqueLabelMapFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelUniqueLabelMapFilter::~LabelUniqueLabelMapFilter "/**
itk::simple::LabelUniqueLabelMapFilter::~LabelUniqueLabelMapFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LabelVotingImageFilter "/**

This filter performs pixelwise voting among an arbitrary number of
input images, where each of them represents a segmentation of the same
scene (i.e., image).


Label voting is a simple method of classifier combination applied to
image segmentation. Typically, the accuracy of the combined
segmentation exceeds the accuracy of any of the input segmentations.
Voting is therefore commonly used as a way of boosting segmentation
performance.

The use of label voting for combination of multiple segmentations is
described in

T. Rohlfing and C. R. Maurer, Jr., \"Multi-classifier framework for
atlas-based image segmentation,\" Pattern Recognition Letters, 2005.

INPUTS
All input volumes to this filter must be segmentations of an image,
that is, they must have discrete pixel values where each value
represents a different segmented object.
 Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label
values must have the same meaning in all images.

OUTPUTS
The voting filter produces a single output volume. Each output pixel
contains the label that occurred most often among the labels assigned
to this pixel in all the input volumes, that is, the label that
received the maximum number of \"votes\" from the input pixels.. If
the maximum number of votes is not unique, i.e., if more than one
label have a maximum number of votes, an \"undecided\" label is
assigned to that output pixel.
 By default, the label used for undecided pixels is the maximum label
value used in the input images plus one. Since it is possible for an
image with 8 bit pixel values to use all 256 possible label values, it
is permissible to combine 8 bit (i.e., byte) images into a 16 bit
(i.e., short) output image.

PARAMETERS
The label used for \"undecided\" labels can be set using
SetLabelForUndecidedPixels. This functionality can be unset by calling
UnsetLabelForUndecidedPixels.

Torsten Rohlfing, SRI International, Neuroscience Program

See:
 itk::simple::LabelVoting for the procedural interface


C++ includes: sitkLabelVotingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const std::vector< Image > &images, uint64_t labelForUndecidedPixels)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, uint64_t labelForUndecidedPixels)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, uint64_t
labelForUndecidedPixels)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3,
uint64_t labelForUndecidedPixels)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, uint64_t labelForUndecidedPixels)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::Execute "/**
Image itk::simple::LabelVotingImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5, uint64_t labelForUndecidedPixels)
*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::GetLabelForUndecidedPixels "/**
uint64_t itk::simple::LabelVotingImageFilter::GetLabelForUndecidedPixels() const

Get label value used for undecided pixels. After updating the filter,
this function returns the actual label value used for undecided pixels
in the current output. Note that this value is overwritten when
SetLabelForUndecidedPixels is called and the new value only becomes
effective upon the next filter update.

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::GetName "/**
std::string itk::simple::LabelVotingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::LabelVotingImageFilter "/**
itk::simple::LabelVotingImageFilter::LabelVotingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::SetLabelForUndecidedPixels "/**
Self& itk::simple::LabelVotingImageFilter::SetLabelForUndecidedPixels(uint64_t LabelForUndecidedPixels)

Set label value for undecided pixels.

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::ToString "/**
std::string itk::simple::LabelVotingImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LabelVotingImageFilter::~LabelVotingImageFilter "/**
itk::simple::LabelVotingImageFilter::~LabelVotingImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LandmarkBasedTransformInitializerFilter "/**

This class computes the transform that aligns the fixed and moving
images given a set of pair landmarks. The class is templated over the Transform type as well as fixed image and moving image types. The transform
computed gives the best fit transform that maps the fixed and moving
images in a least squares sense. The indices are taken to correspond,
so point 1 in the first set will get mapped close to point 1 in the
second set, etc.

Currently, the following transforms are supported by the class: VersorRigid3DTransform Rigid2DTransform AffineTransform BSplineTransform

An equal number of fixed and moving landmarks need to be specified
using SetFixedLandmarks() and SetMovingLandmarks() . Any number of landmarks may be specified. In the case of using
Affine or BSpline transforms, each landmark pair can contribute in the
final transform based on its defined weight. Number of weights should
be equal to the number of landmarks and can be specified using SetLandmarkWeight() . By defaults are weights are set to one. Call InitializeTransform()
to initialize the transform.

The class is based in part on Hybrid/vtkLandmarkTransform originally
implemented in python by David G. Gobbi.

The solution is based on Berthold K. P. Horn (1987), \"Closed-form
solution of absolute orientation using unit quaternions,\" http://people.csail.mit.edu/bkph/papers/Absolute_Orientation.pdf

The Affine Transform initializer is based on an algorithm by H Spaeth, and is described in
the Insight Journal Article \"Affine Transformation for Landmark Based
Registration Initializer in ITK\" by Kim E.Y., Johnson H., Williams N.
available at http://midasjournal.com/browse/publication/825

Wiki Examples:

All Examples

Rigidly register one image to another using manually specified
landmarks
See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the procedural interface

 itk::LandmarkBasedTransformInitializer for the Doxygen on the original ITK class.



C++ includes: sitkLandmarkBasedTransformInitializerFilter.h
*/"

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::Execute "/**
Transform itk::simple::LandmarkBasedTransformInitializerFilter::Execute(const Transform &transform)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::Execute "/**
Transform itk::simple::LandmarkBasedTransformInitializerFilter::Execute(const Transform &transform, const std::vector< double >
&fixedLandmarks, const std::vector< double > &movingLandmarks, const
std::vector< double > &landmarkWeight, const Image &referenceImage,
unsigned int numberOfControlPoints)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::GetBSplineNumberOfControlPoints "/**
unsigned int itk::simple::LandmarkBasedTransformInitializerFilter::GetBSplineNumberOfControlPoints() const

Set/Get the number of control points

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::GetFixedLandmarks "/**
std::vector<double> itk::simple::LandmarkBasedTransformInitializerFilter::GetFixedLandmarks() const
*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::GetLandmarkWeight "/**
std::vector<double> itk::simple::LandmarkBasedTransformInitializerFilter::GetLandmarkWeight() const
*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::GetMovingLandmarks "/**
std::vector<double> itk::simple::LandmarkBasedTransformInitializerFilter::GetMovingLandmarks() const

Get the shrink factors.

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::GetName "/**
std::string itk::simple::LandmarkBasedTransformInitializerFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::GetReferenceImage "/**
Image itk::simple::LandmarkBasedTransformInitializerFilter::GetReferenceImage() const
*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::LandmarkBasedTransformInitializerFilter "/**
itk::simple::LandmarkBasedTransformInitializerFilter::LandmarkBasedTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::SetBSplineNumberOfControlPoints "/**
Self& itk::simple::LandmarkBasedTransformInitializerFilter::SetBSplineNumberOfControlPoints(unsigned int BSplineNumberOfControlPoints)

Set/Get the number of control points

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::SetFixedLandmarks "/**
Self& itk::simple::LandmarkBasedTransformInitializerFilter::SetFixedLandmarks(const std::vector< double > &FixedLandmarks)

Set the Fixed landmark point containers

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::SetLandmarkWeight "/**
Self& itk::simple::LandmarkBasedTransformInitializerFilter::SetLandmarkWeight(const std::vector< double > &LandmarkWeight)

Set the landmark weight point containers Weight includes diagonal
elements of weight matrix

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::SetMovingLandmarks "/**
Self& itk::simple::LandmarkBasedTransformInitializerFilter::SetMovingLandmarks(const std::vector< double > &MovingLandmarks)

Set the Moving landmark point containers

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::SetReferenceImage "/**
Self& itk::simple::LandmarkBasedTransformInitializerFilter::SetReferenceImage(const Image &ReferenceImage)

Set the reference image to define the parametric domain for the
BSpline transform

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::ToString "/**
std::string itk::simple::LandmarkBasedTransformInitializerFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LandmarkBasedTransformInitializerFilter::~LandmarkBasedTransformInitializerFilter "/**
itk::simple::LandmarkBasedTransformInitializerFilter::~LandmarkBasedTransformInitializerFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LandweberDeconvolutionImageFilter "/**

Deconvolve an image using the Landweber deconvolution algorithm.


This filter implements the Landweber deconvolution algorthm as defined
in Bertero M and Boccacci P, \"Introduction to Inverse Problems in
Imaging\", 1998. The algorithm assumes that the input image has been
formed by a linear shift-invariant system with a known kernel.

The Landweber algorithm converges to a solution that minimizes the sum
of squared errors $||f \\\\otimes h - g||$ where $f$ is the estimate of the unblurred image, $\\\\otimes$ is the convolution operator, $h$ is the blurring kernel, and $g$ is the blurred input image. As such, it is best suited for images
that have zero-mean Gaussian white noise.

This is the base implementation of the Landweber algorithm. It may
produce results with negative values. For a version of this algorithm
that enforces a positivity constraint on each intermediate solution,
see ProjectedLandweberDeconvolutionImageFilter .

This code was adapted from the Insight Journal contribution:

\"Deconvolution: infrastructure and reference algorithms\" by Gaetan
Lehmann https://hdl.handle.net/10380/3207


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
 Cory Quammen, The University of North Carolina at Chapel Hill


See:
 IterativeDeconvolutionImageFilter

 RichardsonLucyDeconvolutionImageFilter

 ProjectedLandweberDeconvolutionImageFilter

 itk::simple::LandweberDeconvolution for the procedural interface

 itk::LandweberDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLandweberDeconvolutionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::Execute "/**
Image itk::simple::LandweberDeconvolutionImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::Execute "/**
Image itk::simple::LandweberDeconvolutionImageFilter::Execute(const Image &image1, const Image &image2, double alpha, int
numberOfIterations, bool normalize,
LandweberDeconvolutionImageFilter::BoundaryConditionType
boundaryCondition,
LandweberDeconvolutionImageFilter::OutputRegionModeType
outputRegionMode)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::GetAlpha "/**
double itk::simple::LandweberDeconvolutionImageFilter::GetAlpha() const

Set/get relaxation factor.

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::GetBoundaryCondition "/**
BoundaryConditionType itk::simple::LandweberDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::GetName "/**
std::string itk::simple::LandweberDeconvolutionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::GetNormalize "/**
bool itk::simple::LandweberDeconvolutionImageFilter::GetNormalize() const
*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::GetNumberOfIterations "/**
int itk::simple::LandweberDeconvolutionImageFilter::GetNumberOfIterations() const

Get the number of iterations.

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::GetOutputRegionMode "/**
OutputRegionModeType itk::simple::LandweberDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::LandweberDeconvolutionImageFilter "/**
itk::simple::LandweberDeconvolutionImageFilter::LandweberDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::NormalizeOff "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::NormalizeOff()
*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::NormalizeOn "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::SetAlpha "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::SetAlpha(double Alpha)

Set/get relaxation factor.

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::SetBoundaryCondition "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::SetNormalize "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::SetNumberOfIterations "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::SetNumberOfIterations(int NumberOfIterations)

Set the number of iterations.

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::SetOutputRegionMode "/**
Self& itk::simple::LandweberDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::ToString "/**
std::string itk::simple::LandweberDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LandweberDeconvolutionImageFilter::~LandweberDeconvolutionImageFilter "/**
itk::simple::LandweberDeconvolutionImageFilter::~LandweberDeconvolutionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LaplacianImageFilter "/**

This filter computes the Laplacian of a scalar-valued image. The
Laplacian is an isotropic measure of the 2nd spatial derivative of an
image. The Laplacian of an image highlights regions of rapid intensity
change and is therefore often used for edge detection. Often, the
Laplacian is applied to an image that has first been smoothed with a
Gaussian filter in order to reduce its sensitivity to noise.


The Laplacian at each pixel location is computed by convolution with
the itk::LaplacianOperator .
Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .

WARNING:
The pixel type of the input and output images must be of real type
(float or double). ConceptChecking is used here to enforce the input
pixel type. You will get a compilation error if the pixel type of the
input and output images is not float or double.

See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 LaplacianOperator
Wiki Examples:

All Examples

Compute the Laplacian of an image
See:
 itk::simple::Laplacian for the procedural interface

 itk::LaplacianImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLaplacianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LaplacianImageFilter::Execute "/**
Image itk::simple::LaplacianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::Execute "/**
Image itk::simple::LaplacianImageFilter::Execute(const Image &image1, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::GetName "/**
std::string itk::simple::LaplacianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::GetUseImageSpacing "/**
bool itk::simple::LaplacianImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::LaplacianImageFilter "/**
itk::simple::LaplacianImageFilter::LaplacianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::SetUseImageSpacing "/**
Self& itk::simple::LaplacianImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::ToString "/**
std::string itk::simple::LaplacianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::UseImageSpacingOff "/**
Self& itk::simple::LaplacianImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::UseImageSpacingOn "/**
Self& itk::simple::LaplacianImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianImageFilter::~LaplacianImageFilter "/**
itk::simple::LaplacianImageFilter::~LaplacianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LaplacianRecursiveGaussianImageFilter "/**

Computes the Laplacian of Gaussian (LoG) of an image.


Computes the Laplacian of Gaussian (LoG) of an image by convolution
with the second derivative of a Gaussian. This filter is implemented
using the recursive gaussian filters.

Wiki Examples:

All Examples

Compute the Laplacian of Gaussian (LoG) of an image
See:
 itk::simple::LaplacianRecursiveGaussian for the procedural interface

 itk::LaplacianRecursiveGaussianImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLaplacianRecursiveGaussianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::Execute "/**
Image itk::simple::LaplacianRecursiveGaussianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::Execute "/**
Image itk::simple::LaplacianRecursiveGaussianImageFilter::Execute(const Image &image1, double sigma, bool normalizeAcrossScale)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::GetName "/**
std::string itk::simple::LaplacianRecursiveGaussianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::GetNormalizeAcrossScale "/**
bool itk::simple::LaplacianRecursiveGaussianImageFilter::GetNormalizeAcrossScale() const

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::GetSigma "/**
double itk::simple::LaplacianRecursiveGaussianImageFilter::GetSigma() const

Set Sigma value. Sigma is measured in the units of image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::LaplacianRecursiveGaussianImageFilter "/**
itk::simple::LaplacianRecursiveGaussianImageFilter::LaplacianRecursiveGaussianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::NormalizeAcrossScaleOff "/**
Self& itk::simple::LaplacianRecursiveGaussianImageFilter::NormalizeAcrossScaleOff()
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::NormalizeAcrossScaleOn "/**
Self& itk::simple::LaplacianRecursiveGaussianImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::SetNormalizeAcrossScale "/**
Self& itk::simple::LaplacianRecursiveGaussianImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

Define which normalization factor will be used for the Gaussian
See:
 RecursiveGaussianImageFilter::SetNormalizeAcrossScale


*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::SetSigma "/**
Self& itk::simple::LaplacianRecursiveGaussianImageFilter::SetSigma(double Sigma)

Set Sigma value. Sigma is measured in the units of image spacing.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::ToString "/**
std::string itk::simple::LaplacianRecursiveGaussianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianRecursiveGaussianImageFilter::~LaplacianRecursiveGaussianImageFilter "/**
itk::simple::LaplacianRecursiveGaussianImageFilter::~LaplacianRecursiveGaussianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LaplacianSegmentationLevelSetImageFilter "/**

Segments structures in images based on a second derivative image
features.


IMPORTANT
The SegmentationLevelSetImageFilter class and the LaplacianSegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is zero at image edges as detected by a Laplacian
filter. The evolving level set front will therefore tend to lock onto
zero crossings in the image. The level set front moves fastest near
edges.

The Laplacian segmentation filter is intended primarily as a tool for
refining existing segmentations. The initial isosurface (as given in
the seed input image) should ideally be very close to the segmentation
boundary of interest. The idea is that a rough segmentation can be
refined by allowing the isosurface to deform slightly to achieve a
better fit to the edge features of an image. One example of such an
application is to refine the output of a hand segmented image.

Because values in the Laplacian feature image will tend to be low
except near edge features, this filter is not effective for segmenting
large image regions from small seed surfaces.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).

The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment.
 Note that this filter does no preprocessing of the feature image
before thresholding. Because second derivative calculations are highly
sensitive to noise, isotropic or anisotropic smoothing of the feature
image can dramatically improve the results.


See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
*values in the output image are inside the segmentated region and
negative *values in the image are outside of the inside region. The
zero crossings of *the image correspond to the position of the level
set front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
This filter has no parameters other than those described in SegmentationLevelSetImageFilter .

See:
 SegmentationLevelSetImageFilter

 LaplacianSegmentationLevelSetFunction ,

 SparseFieldLevelSetImageFilter

 itk::simple::LaplacianSegmentationLevelSet for the procedural interface

 itk::LaplacianSegmentationLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLaplacianSegmentationLevelSetImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::Execute "/**
Image itk::simple::LaplacianSegmentationLevelSetImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::Execute "/**
Image itk::simple::LaplacianSegmentationLevelSetImageFilter::Execute(const Image &image1, const Image &image2, double maximumRMSError,
double propagationScaling, double curvatureScaling, uint32_t
numberOfIterations, bool reverseExpansionDirection)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetCurvatureScaling "/**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetCurvatureScaling() const
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetElapsedIterations "/**
uint32_t itk::simple::LaplacianSegmentationLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetMaximumRMSError "/**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetName "/**
std::string itk::simple::LaplacianSegmentationLevelSetImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::LaplacianSegmentationLevelSetImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetPropagationScaling "/**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetPropagationScaling() const
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetReverseExpansionDirection "/**
bool itk::simple::LaplacianSegmentationLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::GetRMSChange "/**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::LaplacianSegmentationLevelSetImageFilter "/**
itk::simple::LaplacianSegmentationLevelSetImageFilter::LaplacianSegmentationLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::ReverseExpansionDirectionOff "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::ReverseExpansionDirectionOn "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::SetCurvatureScaling "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::SetMaximumRMSError "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::SetNumberOfIterations "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::SetPropagationScaling "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::SetReverseExpansionDirection "/**
Self& itk::simple::LaplacianSegmentationLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::ToString "/**
std::string itk::simple::LaplacianSegmentationLevelSetImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSegmentationLevelSetImageFilter::~LaplacianSegmentationLevelSetImageFilter "/**
itk::simple::LaplacianSegmentationLevelSetImageFilter::~LaplacianSegmentationLevelSetImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LaplacianSharpeningImageFilter "/**

This filter sharpens an image using a Laplacian. LaplacianSharpening
highlights regions of rapid intensity change and therefore highlights
or enhances the edges. The result is an image that appears more in
focus.


The LaplacianSharpening at each pixel location is computed by
convolution with the itk::LaplacianOperator .
Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .

See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 LaplacianOperator
Wiki Examples:

All Examples

Sharpen an image
See:
 itk::simple::LaplacianSharpening for the procedural interface

 itk::LaplacianSharpeningImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLaplacianSharpeningImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::Execute "/**
Image itk::simple::LaplacianSharpeningImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::Execute "/**
Image itk::simple::LaplacianSharpeningImageFilter::Execute(const Image &image1, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::GetName "/**
std::string itk::simple::LaplacianSharpeningImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::GetUseImageSpacing "/**
bool itk::simple::LaplacianSharpeningImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::LaplacianSharpeningImageFilter "/**
itk::simple::LaplacianSharpeningImageFilter::LaplacianSharpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::SetUseImageSpacing "/**
Self& itk::simple::LaplacianSharpeningImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::ToString "/**
std::string itk::simple::LaplacianSharpeningImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::UseImageSpacingOff "/**
Self& itk::simple::LaplacianSharpeningImageFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::UseImageSpacingOn "/**
Self& itk::simple::LaplacianSharpeningImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LaplacianSharpeningImageFilter::~LaplacianSharpeningImageFilter "/**
itk::simple::LaplacianSharpeningImageFilter::~LaplacianSharpeningImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LessEqualImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::LessEqual for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLessEqualImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LessEqualImageFilter::Execute "/**
Image itk::simple::LessEqualImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::Execute "/**
Image itk::simple::LessEqualImageFilter::Execute(const Image &image1, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::Execute "/**
Image itk::simple::LessEqualImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::Execute "/**
Image itk::simple::LessEqualImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::Execute "/**
Image itk::simple::LessEqualImageFilter::Execute(const Image &image1, double constant, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on an image and a constant with the given
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::Execute "/**
Image itk::simple::LessEqualImageFilter::Execute(double constant, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::LessEqualImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::GetForegroundValue "/**
uint8_t itk::simple::LessEqualImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::GetName "/**
std::string itk::simple::LessEqualImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::LessEqualImageFilter "/**
itk::simple::LessEqualImageFilter::LessEqualImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::SetBackgroundValue "/**
Self& itk::simple::LessEqualImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::SetForegroundValue "/**
Self& itk::simple::LessEqualImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::ToString "/**
std::string itk::simple::LessEqualImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LessEqualImageFilter::~LessEqualImageFilter "/**
itk::simple::LessEqualImageFilter::~LessEqualImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LessImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::Less for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkLessImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LessImageFilter::Execute "/**
Image itk::simple::LessImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::Execute "/**
Image itk::simple::LessImageFilter::Execute(const Image &image1, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::Execute "/**
Image itk::simple::LessImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::Execute "/**
Image itk::simple::LessImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::Execute "/**
Image itk::simple::LessImageFilter::Execute(const Image &image1, double constant, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on an image and a constant with the given
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::Execute "/**
Image itk::simple::LessImageFilter::Execute(double constant, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::LessImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::GetForegroundValue "/**
uint8_t itk::simple::LessImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::GetName "/**
std::string itk::simple::LessImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::LessImageFilter "/**
itk::simple::LessImageFilter::LessImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::SetBackgroundValue "/**
Self& itk::simple::LessImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::SetForegroundValue "/**
Self& itk::simple::LessImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::ToString "/**
std::string itk::simple::LessImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LessImageFilter::~LessImageFilter "/**
itk::simple::LessImageFilter::~LessImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LevelSetMotionRegistrationFilter "/**

Deformably register two images using level set motion.


LevelSetMotionFilter implements a deformable registration algorithm
that aligns a fixed and a moving image under level set motion. The
equations of motion are similar to those of the DemonsRegistrationFilter . The main differences are: (1) Gradients of the moving image are
calculated on a smoothed image while intensity difference are measured
on the original images (2) Magnitude of the motion vector is a
function of the differences in intensity between the fixed and moving
pixel. An adaptive timestep is calculated based on the maximum motion
vector over the entire field to ensure stability. The timestep also
implictly converts the motion vector measured in units of intensity to
a vector measured in physical units. Demons, on the other hand,
defines its motion vectors as function of both the intensity
differences and gradient magnitude at each respective pixel. Consider
two separate pixels with the same intensity differences between the
corresponding fixed and moving pixel pairs. In demons, the motion
vector of the pixel over a low gradient region will be larger than the
motion vector of the pixel over a large gradient region. This leads to
an unstable vector field. In the levelset approach, the motion vectors
will be proportional to the gradients, scaled by the maximum gradient
over the entire field. The pixel with at the lower gradient position
will more less than the pixel at the higher gradient position. (3)
Gradients are calculated using minmod finite difference instead of
using central differences.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The algorithm has one parameters: the number of iteration to be
performed.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in LevelSetMotionFunction.


WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.
 Ref: B.C. Vemuri, J. Ye, Y. Chen, C.M. Leonard. \"Image registration
via level-set motion: applications to atlas-based segmentation\".
Medical Image Analysis. Vol. 7. pp. 1-20. 2003.


See:
 LevelSetMotionRegistrationFunction

 DemonsRegistrationFilter

 itk::LevelSetMotionRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkLevelSetMotionRegistrationFilter.h
*/"

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::Execute "/**
Image itk::simple::LevelSetMotionRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::Execute "/**
Image itk::simple::LevelSetMotionRegistrationFilter::Execute(const Image &fixedImage, const Image &movingImage, double
gradientSmoothingStandardDeviations, uint32_t numberOfIterations,
double maximumRMSError, const std::vector< double >
&standardDeviations, bool smoothDisplacementField, const std::vector<
double > &updateFieldStandardDeviations, bool smoothUpdateField,
unsigned int maximumKernelWidth, double maximumError, double alpha,
double intensityDifferenceThreshold, double
gradientMagnitudeThreshold, bool useImageSpacing)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetAlpha "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetAlpha() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetElapsedIterations "/**
uint32_t itk::simple::LevelSetMotionRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetGradientMagnitudeThreshold "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetGradientMagnitudeThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetGradientSmoothingStandardDeviations "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetGradientSmoothingStandardDeviations() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetIntensityDifferenceThreshold "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetMaximumError "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetMaximumKernelWidth "/**
unsigned int itk::simple::LevelSetMotionRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetMaximumRMSError "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetMaximumRMSError() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetMetric "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the the overlapping region between the two images. This
is value is only available for the previous iteration and NOT the
current iteration.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetName "/**
std::string itk::simple::LevelSetMotionRegistrationFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetNumberOfIterations "/**
uint32_t itk::simple::LevelSetMotionRegistrationFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetRMSChange "/**
double itk::simple::LevelSetMotionRegistrationFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetSmoothDisplacementField "/**
bool itk::simple::LevelSetMotionRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetSmoothUpdateField "/**
bool itk::simple::LevelSetMotionRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetStandardDeviations "/**
std::vector<double> itk::simple::LevelSetMotionRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetUpdateFieldStandardDeviations "/**
std::vector<double> itk::simple::LevelSetMotionRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::GetUseImageSpacing "/**
bool itk::simple::LevelSetMotionRegistrationFilter::GetUseImageSpacing() const
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::LevelSetMotionRegistrationFilter "/**
itk::simple::LevelSetMotionRegistrationFilter::LevelSetMotionRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetAlpha "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetAlpha(double Alpha)

Set/Get the parameter alpha. Alpha is added to the calculated gradient
magnitude prior to normalizing the gradient to protect against
numerical instability as the gradient magnitude approaches zero. This
should be set as a small fraction of the intensity dynamic range, for
instance 0.04%. Default is the absolute (not percentage) value of 0.1.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetGradientMagnitudeThreshold "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetGradientMagnitudeThreshold(double GradientMagnitudeThreshold)

Set/Get the threshold below which the gradient magnitude is considered
the zero vector. Default is 1e-9.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetGradientSmoothingStandardDeviations "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetGradientSmoothingStandardDeviations(double GradientSmoothingStandardDeviations)

Set/Get the standard deviation used for smoothing the moving image
prior to calculating gradients. The standard deviation is measured in
physical units (for instance mm). Note that this smoothing value is
not to be confused with the
PDEDeformableRegistrationFilter::SetStandardDeviations() method. The
method in PDEDeformableRegistrationFilter is for setting the smoothing parameters for regularizing the
deformation field between interations. Those smoothing parameters are
set in pixel units not physical units. Deformation field smoothing is
not done by default in LevelSetMotionRegistration. This smoothing
parameter is to condition the gradient calculation and parameter is
specified in physical units.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetIntensityDifferenceThreshold "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetMaximumError "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetMaximumKernelWidth "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetMaximumRMSError "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetNumberOfIterations "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetSmoothDisplacementField "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetSmoothUpdateField "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetStandardDeviations(const std::vector< double > &StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetStandardDeviations "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetStandardDeviations(double value)

Set the values of the StandardDeviations vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetUpdateFieldStandardDeviations(const std::vector< double > &UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetUpdateFieldStandardDeviations "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetUpdateFieldStandardDeviations(double value)

Set the values of the UpdateFieldStandardDeviations vector all to
value

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SetUseImageSpacing "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SmoothDisplacementFieldOff "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SmoothDisplacementFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SmoothDisplacementFieldOn "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SmoothUpdateFieldOff "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SmoothUpdateFieldOff()
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::SmoothUpdateFieldOn "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::ToString "/**
std::string itk::simple::LevelSetMotionRegistrationFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::UseImageSpacingOff "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::UseImageSpacingOff()
*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::UseImageSpacingOn "/**
Self& itk::simple::LevelSetMotionRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LevelSetMotionRegistrationFilter::~LevelSetMotionRegistrationFilter "/**
itk::simple::LevelSetMotionRegistrationFilter::~LevelSetMotionRegistrationFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LiThresholdImageFilter "/**

Threshold an image using the Li Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the LiThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::LiThreshold for the procedural interface

 itk::LiThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLiThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::Execute "/**
Image itk::simple::LiThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::Execute "/**
Image itk::simple::LiThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::Execute "/**
Image itk::simple::LiThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::Execute "/**
Image itk::simple::LiThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::LiThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::LiThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::LiThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetName "/**
std::string itk::simple::LiThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::LiThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::LiThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::GetThreshold "/**
double itk::simple::LiThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::LiThresholdImageFilter "/**
itk::simple::LiThresholdImageFilter::LiThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::LiThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::LiThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::LiThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::LiThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::LiThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::LiThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::LiThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::ToString "/**
std::string itk::simple::LiThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LiThresholdImageFilter::~LiThresholdImageFilter "/**
itk::simple::LiThresholdImageFilter::~LiThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::Log10ImageFilter "/**

Computes the log10 of each pixel.


The computation is performed using std::log10(x).
See:
 itk::simple::Log10 for the procedural interface

 itk::Log10ImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLog10ImageFilter.h
*/"

%javamethodmodifiers  itk::simple::Log10ImageFilter::Execute "/**
Image itk::simple::Log10ImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::Log10ImageFilter::GetName "/**
std::string itk::simple::Log10ImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::Log10ImageFilter::Log10ImageFilter "/**
itk::simple::Log10ImageFilter::Log10ImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::Log10ImageFilter::ToString "/**
std::string itk::simple::Log10ImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::Log10ImageFilter::~Log10ImageFilter "/**
itk::simple::Log10ImageFilter::~Log10ImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::LogImageFilter "/**

Computes the log() of each pixel.



See:
 itk::simple::Log for the procedural interface

 itk::LogImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLogImageFilter.h
*/"

%javamethodmodifiers  itk::simple::LogImageFilter::Execute "/**
Image itk::simple::LogImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::LogImageFilter::GetName "/**
std::string itk::simple::LogImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::LogImageFilter::LogImageFilter "/**
itk::simple::LogImageFilter::LogImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::LogImageFilter::ToString "/**
std::string itk::simple::LogImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::LogImageFilter::~LogImageFilter "/**
itk::simple::LogImageFilter::~LogImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MagnitudeAndPhaseToComplexImageFilter "/**

Implements pixel-wise conversion of magnitude and phase data into
complex voxels.


This filter is parametrized over the types of the two input images and
the type of the output image.

The filter expect all images to have the same dimension (e.g. all 2D,
or all 3D, or all ND)
See:
 itk::simple::MagnitudeAndPhaseToComplex for the procedural interface

 itk::MagnitudeAndPhaseToComplexImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMagnitudeAndPhaseToComplexImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::Execute "/**
Image itk::simple::MagnitudeAndPhaseToComplexImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::Execute "/**
Image itk::simple::MagnitudeAndPhaseToComplexImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::Execute "/**
Image itk::simple::MagnitudeAndPhaseToComplexImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::GetName "/**
std::string itk::simple::MagnitudeAndPhaseToComplexImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::MagnitudeAndPhaseToComplexImageFilter "/**
itk::simple::MagnitudeAndPhaseToComplexImageFilter::MagnitudeAndPhaseToComplexImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::ToString "/**
std::string itk::simple::MagnitudeAndPhaseToComplexImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MagnitudeAndPhaseToComplexImageFilter::~MagnitudeAndPhaseToComplexImageFilter "/**
itk::simple::MagnitudeAndPhaseToComplexImageFilter::~MagnitudeAndPhaseToComplexImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MaskImageFilter "/**

Mask an image with a mask.


This class is templated over the types of the input image type, the
mask image type and the type of the output image. Numeric conversions
(castings) are done by the C++ defaults.

The pixel type of the input 2 image must have a valid definition of
the operator != with zero. This condition is required because
internally this filter will perform the operation


The pixel from the input 1 is cast to the pixel type of the output
image.

Note that the input and the mask images must be of the same size.


WARNING:
Any pixel value other than masking value (0 by default) will not be
masked out.

See:
 MaskNegatedImageFilter
Wiki Examples:

All Examples

Apply a mask to an image
See:
 itk::simple::Mask for the procedural interface

 itk::MaskImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMaskImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MaskImageFilter::Execute "/**
Image itk::simple::MaskImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::Execute "/**
Image itk::simple::MaskImageFilter::Execute(const Image &image, const Image &maskImage, double outsideValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::GetName "/**
std::string itk::simple::MaskImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::GetOutsideValue "/**
double itk::simple::MaskImageFilter::GetOutsideValue() const
*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::MaskImageFilter "/**
itk::simple::MaskImageFilter::MaskImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::SetOutsideValue "/**
Self& itk::simple::MaskImageFilter::SetOutsideValue(double OutsideValue)

Method to explicitly set the outside value of the mask. Defaults to 0

*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::ToString "/**
std::string itk::simple::MaskImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MaskImageFilter::~MaskImageFilter "/**
itk::simple::MaskImageFilter::~MaskImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MaskNegatedImageFilter "/**

Mask an image with the negative of a mask.


This class is templated over the types of the input image type, the
mask image type and the type of the output image. Numeric conversions
(castings) are done by the C++ defaults. The pixel type of the input 2
image must have a valid definition of the operator != with zero. This
condition is required because internally this filter will perform the
operation ifpixel_from_mask_image!=0pixel_output_image=output_valueels
epixel_output_image=pixel_input_image The pixel from the input 1 is
cast to the pixel type of the output image. Note that the input and
the mask images must be of the same size.
WARNING:
Any pixel value other than 0 will not be masked out.

See:
 MaskImageFilter
Wiki Examples:

All Examples

Apply the inverse of a mask to an image

See:
 itk::simple::MaskNegated for the procedural interface

 itk::MaskNegatedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMaskNegatedImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MaskNegatedImageFilter::Execute "/**
Image itk::simple::MaskNegatedImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MaskNegatedImageFilter::GetName "/**
std::string itk::simple::MaskNegatedImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MaskNegatedImageFilter::MaskNegatedImageFilter "/**
itk::simple::MaskNegatedImageFilter::MaskNegatedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaskNegatedImageFilter::ToString "/**
std::string itk::simple::MaskNegatedImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MaskNegatedImageFilter::~MaskNegatedImageFilter "/**
itk::simple::MaskNegatedImageFilter::~MaskNegatedImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MaskedFFTNormalizedCorrelationImageFilter "/**

Calculate masked normalized cross correlation using FFTs.


This filter calculates the masked normalized cross correlation (NCC)
of two images under masks using FFTs instead of spatial correlation.
It is much faster than spatial correlation for reasonably large
structuring elements. This filter is not equivalent to simply masking
the images first and then correlating them; the latter approach yields
incorrect results because the zeros in the images still affect the
metric in the correlation process. This filter implements the masked
NCC correctly so that the masked-out regions are completely ignored.
The fundamental difference is described in detail in the references
below. If the masks are set to images of all ones, the result of this
filter is the same as standard NCC.

Inputs: Two images are required as inputs, fixedImage and movingImage,
and two are optional, fixedMask and movingMask. In the context of
correlation, inputs are often defined as: \"image\" and \"template\".
In this filter, the fixedImage plays the role of the image, and the
movingImage plays the role of the template. However, this filter is
capable of correlating any two images and is not restricted to small
movingImages (templates). In the fixedMask and movingMask, non-zero
positive values indicate locations of useful information in the
corresponding image, whereas zero and negative values indicate
locations that should be masked out (ignored). Internally, the masks
are converted to have values of only 0 and 1. For each optional mask
that is not set, the filter internally creates an image of ones, which
is equivalent to not masking the image. Thus, if both masks are not
set, the result will be equivalent to unmasked NCC. For example, if
only a mask for the fixed image is needed, the movingMask can either
not be set or can be set to an image of ones.

Optional parameters: The RequiredNumberOfOverlappingPixels enables the
user to specify the minimum number of voxels of the two masks that
must overlap; any location in the correlation map that results from
fewer than this number of voxels will be set to zero. Larger values
zero-out pixels on a larger border around the correlation image. Thus,
larger values remove less stable computations but also limit the
capture range. If RequiredNumberOfOverlappingPixels is set to 0, the
default, no zeroing will take place.

The RequiredFractionOfOverlappingPixels enables the user to specify a
fraction of the maximum number of overlapping pixels that need to
overlap; any location in the correlation map that results from fewer
than the product of this fraction and the internally computed maximum
number of overlapping pixels will be set to zero. The value ranges
between 0.0 and 1.0. This is very useful when the user does does not
know beforehand the maximum number of pixels of the masks that will
overlap. For example, when the masks have strange shapes, it is
difficult to predict how the correlation of the masks will interact
and what the maximum overlap will be. It is also useful when the mask
shapes or sizes change because it is relative to the internally
computed maximum of the overlap. Larger values zero-out pixels on a
larger border around the correlation image. Thus, larger values remove
less stable computations but also limit the capture range. Experiments
have shown that a value between 0.1 and 0.6 works well for images with
significant overlap and between 0.05 and 0.1 for images with little
overlap (such as in stitching applications). If
RequiredFractionOfOverlappingPixels is set to 0, the default, no
zeroing will take place.

The user can either specify RequiredNumberOfOverlappingPixels or
RequiredFractionOfOverlappingPixels (or both or none). Internally, the
number of required pixels resulting from both of these methods is
calculated and the one that gives the largest number of pixels is
chosen. Since these both default to 0, if a user only sets one, the
other is ignored.

Image size: fixedImage and movingImage need not be the same size, but
fixedMask must be the same size as fixedImage, and movingMask must be
the same size as movingImage. Furthermore, whereas some algorithms
require that the \"template\" be smaller than the \"image\" because of
errors in the regions where the two are not fully overlapping, this
filter has no such restriction.

Image spacing: Since the computations are done in the pixel domain, all
input images must have the same spacing.

Outputs; The output is an image of RealPixelType that is the masked
NCC of the two images and its values range from -1.0 to 1.0. The size
of this NCC image is, by definition, size(fixedImage) +
size(movingImage) - 1.

Example filter usage:


WARNING:
The pixel type of the output image must be of real type (float or
double). ConceptChecking is used to enforce the output pixel type. You
will get a compilation error if the pixel type of the output image is
not float or double.
 References: 1) D. Padfield. \"Masked object registration in the
Fourier domain.\" Transactions on Image Processing. 2) D. Padfield. \"Masked FFT registration\". In Proc.
Computer Vision and Pattern Recognition, 2010.


: Dirk Padfield, GE Global Research, padfield@research.ge.com

See:
 itk::simple::MaskedFFTNormalizedCorrelation for the procedural interface

 itk::MaskedFFTNormalizedCorrelationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMaskedFFTNormalizedCorrelationImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::Execute "/**
Image itk::simple::MaskedFFTNormalizedCorrelationImageFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&fixedImageMask, const Image &movingImageMask)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::Execute "/**
Image itk::simple::MaskedFFTNormalizedCorrelationImageFilter::Execute(const Image &fixedImage, const Image &movingImage, const Image
&fixedImageMask, const Image &movingImageMask, uint64_t
requiredNumberOfOverlappingPixels, float
requiredFractionOfOverlappingPixels)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::GetName "/**
std::string itk::simple::MaskedFFTNormalizedCorrelationImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::GetRequiredFractionOfOverlappingPixels "/**
float itk::simple::MaskedFFTNormalizedCorrelationImageFilter::GetRequiredFractionOfOverlappingPixels() const

Set and get the required fraction of overlapping pixels

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::GetRequiredNumberOfOverlappingPixels "/**
uint64_t itk::simple::MaskedFFTNormalizedCorrelationImageFilter::GetRequiredNumberOfOverlappingPixels() const

Set and get the required number of overlapping pixels

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::MaskedFFTNormalizedCorrelationImageFilter "/**
itk::simple::MaskedFFTNormalizedCorrelationImageFilter::MaskedFFTNormalizedCorrelationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::SetRequiredFractionOfOverlappingPixels "/**
Self& itk::simple::MaskedFFTNormalizedCorrelationImageFilter::SetRequiredFractionOfOverlappingPixels(float RequiredFractionOfOverlappingPixels)

Set and get the required fraction of overlapping pixels

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::SetRequiredNumberOfOverlappingPixels "/**
Self& itk::simple::MaskedFFTNormalizedCorrelationImageFilter::SetRequiredNumberOfOverlappingPixels(uint64_t RequiredNumberOfOverlappingPixels)

Set and get the required number of overlapping pixels

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::ToString "/**
std::string itk::simple::MaskedFFTNormalizedCorrelationImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MaskedFFTNormalizedCorrelationImageFilter::~MaskedFFTNormalizedCorrelationImageFilter "/**
itk::simple::MaskedFFTNormalizedCorrelationImageFilter::~MaskedFFTNormalizedCorrelationImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MaximumEntropyThresholdImageFilter "/**

Threshold an image using the MaximumEntropy Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the MaximumEntropyThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::MaximumEntropyThreshold for the procedural interface

 itk::MaximumEntropyThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMaximumEntropyThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::Execute "/**
Image itk::simple::MaximumEntropyThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::Execute "/**
Image itk::simple::MaximumEntropyThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::Execute "/**
Image itk::simple::MaximumEntropyThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::Execute "/**
Image itk::simple::MaximumEntropyThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::MaximumEntropyThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::MaximumEntropyThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::MaximumEntropyThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetName "/**
std::string itk::simple::MaximumEntropyThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::MaximumEntropyThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::MaximumEntropyThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::GetThreshold "/**
double itk::simple::MaximumEntropyThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::MaximumEntropyThresholdImageFilter "/**
itk::simple::MaximumEntropyThresholdImageFilter::MaximumEntropyThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::MaximumEntropyThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::ToString "/**
std::string itk::simple::MaximumEntropyThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MaximumEntropyThresholdImageFilter::~MaximumEntropyThresholdImageFilter "/**
itk::simple::MaximumEntropyThresholdImageFilter::~MaximumEntropyThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MaximumImageFilter "/**

Implements a pixel-wise operator Max(a,b) between two images.


The pixel values of the output image are the maximum between the
corresponding pixels of the two input images.

This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Wiki Examples:

All Examples

Pixel wise compare two input images and set the output pixel to their
max
See:
 itk::simple::Maximum for the procedural interface

 itk::MaximumImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMaximumImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MaximumImageFilter::Execute "/**
Image itk::simple::MaximumImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::MaximumImageFilter::Execute "/**
Image itk::simple::MaximumImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::MaximumImageFilter::Execute "/**
Image itk::simple::MaximumImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::MaximumImageFilter::GetName "/**
std::string itk::simple::MaximumImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MaximumImageFilter::MaximumImageFilter "/**
itk::simple::MaximumImageFilter::MaximumImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaximumImageFilter::ToString "/**
std::string itk::simple::MaximumImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MaximumImageFilter::~MaximumImageFilter "/**
itk::simple::MaximumImageFilter::~MaximumImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MaximumProjectionImageFilter "/**

Maximum projection.


This class was contributed to the insight journal by Gaetan Lehmann.
The original paper can be found at https://hdl.handle.net/1926/164


Gaetan Lehmann. Biologie du Developpement et de la reproduction, inra
de jouy-en-josas, France.

See:
 ProjectionImageFilter

 MedianProjectionImageFilter

 MeanProjectionImageFilter

 MinimumProjectionImageFilter

 StandardDeviationProjectionImageFilter

 SumProjectionImageFilter

 BinaryProjectionImageFilter

 itk::simple::MaximumProjection for the procedural interface

 itk::MaximumProjectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMaximumProjectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::Execute "/**
Image itk::simple::MaximumProjectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::Execute "/**
Image itk::simple::MaximumProjectionImageFilter::Execute(const Image &image1, unsigned int projectionDimension)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::GetName "/**
std::string itk::simple::MaximumProjectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::GetProjectionDimension "/**
unsigned int itk::simple::MaximumProjectionImageFilter::GetProjectionDimension() const
*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::MaximumProjectionImageFilter "/**
itk::simple::MaximumProjectionImageFilter::MaximumProjectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::SetProjectionDimension "/**
Self& itk::simple::MaximumProjectionImageFilter::SetProjectionDimension(unsigned int ProjectionDimension)
*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::ToString "/**
std::string itk::simple::MaximumProjectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MaximumProjectionImageFilter::~MaximumProjectionImageFilter "/**
itk::simple::MaximumProjectionImageFilter::~MaximumProjectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MeanImageFilter "/**

Applies an averaging filter to an image.


Computes an image where a given pixel is the mean value of the the
pixels in a neighborhood about the corresponding input pixel.

A mean filter is one of the family of linear filters.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator
Wiki Examples:

All Examples

Mean filter an image
See:
 itk::simple::Mean for the procedural interface

 itk::MeanImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMeanImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MeanImageFilter::Execute "/**
Image itk::simple::MeanImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::Execute "/**
Image itk::simple::MeanImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::GetName "/**
std::string itk::simple::MeanImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::MeanImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::MeanImageFilter "/**
itk::simple::MeanImageFilter::MeanImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::SetRadius "/**
Self& itk::simple::MeanImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::SetRadius "/**
Self& itk::simple::MeanImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::ToString "/**
std::string itk::simple::MeanImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MeanImageFilter::~MeanImageFilter "/**
itk::simple::MeanImageFilter::~MeanImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MeanProjectionImageFilter "/**

Mean projection.


This class was contributed to the Insight Journal by Gaetan Lehmann.
The original paper can be found at https://hdl.handle.net/1926/164


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ProjectionImageFilter

 MedianProjectionImageFilter

 MinimumProjectionImageFilter

 StandardDeviationProjectionImageFilter

 SumProjectionImageFilter

 BinaryProjectionImageFilter

 MaximumProjectionImageFilter

 itk::simple::MeanProjection for the procedural interface

 itk::MeanProjectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMeanProjectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::Execute "/**
Image itk::simple::MeanProjectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::Execute "/**
Image itk::simple::MeanProjectionImageFilter::Execute(const Image &image1, unsigned int projectionDimension)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::GetName "/**
std::string itk::simple::MeanProjectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::GetProjectionDimension "/**
unsigned int itk::simple::MeanProjectionImageFilter::GetProjectionDimension() const
*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::MeanProjectionImageFilter "/**
itk::simple::MeanProjectionImageFilter::MeanProjectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::SetProjectionDimension "/**
Self& itk::simple::MeanProjectionImageFilter::SetProjectionDimension(unsigned int ProjectionDimension)
*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::ToString "/**
std::string itk::simple::MeanProjectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MeanProjectionImageFilter::~MeanProjectionImageFilter "/**
itk::simple::MeanProjectionImageFilter::~MeanProjectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MedianImageFilter "/**

Applies a median filter to an image.


Computes an image where a given pixel is the median value of the the
pixels in a neighborhood about the corresponding input pixel.

A median filter is one of the family of nonlinear filters. It is used
to smooth an image without being biased by outliers or shot noise.

This filter requires that the input pixel type provides an operator<()
(LessThan Comparable).


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator
Wiki Examples:

All Examples

Median filter an image

Median filter an RGB image
See:
 itk::simple::Median for the procedural interface

 itk::MedianImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMedianImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MedianImageFilter::Execute "/**
Image itk::simple::MedianImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::Execute "/**
Image itk::simple::MedianImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::GetName "/**
std::string itk::simple::MedianImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::MedianImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::MedianImageFilter "/**
itk::simple::MedianImageFilter::MedianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::SetRadius "/**
Self& itk::simple::MedianImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::SetRadius "/**
Self& itk::simple::MedianImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::ToString "/**
std::string itk::simple::MedianImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MedianImageFilter::~MedianImageFilter "/**
itk::simple::MedianImageFilter::~MedianImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MedianProjectionImageFilter "/**

Median projection.


This class was contributed to the Insight Journal by Gaetan Lehmann.
The original paper can be found at https://hdl.handle.net/1926/164


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ProjectionImageFilter

 StandardDeviationProjectionImageFilter

 SumProjectionImageFilter

 BinaryProjectionImageFilter

 MaximumProjectionImageFilter

 MinimumProjectionImageFilter

 MeanProjectionImageFilter

 itk::simple::MedianProjection for the procedural interface

 itk::MedianProjectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMedianProjectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::Execute "/**
Image itk::simple::MedianProjectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::Execute "/**
Image itk::simple::MedianProjectionImageFilter::Execute(const Image &image1, unsigned int projectionDimension)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::GetName "/**
std::string itk::simple::MedianProjectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::GetProjectionDimension "/**
unsigned int itk::simple::MedianProjectionImageFilter::GetProjectionDimension() const
*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::MedianProjectionImageFilter "/**
itk::simple::MedianProjectionImageFilter::MedianProjectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::SetProjectionDimension "/**
Self& itk::simple::MedianProjectionImageFilter::SetProjectionDimension(unsigned int ProjectionDimension)
*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::ToString "/**
std::string itk::simple::MedianProjectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MedianProjectionImageFilter::~MedianProjectionImageFilter "/**
itk::simple::MedianProjectionImageFilter::~MedianProjectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MergeLabelMapFilter "/**

Merges several Label Maps.


This filter takes one or more input Label Map and merges them.

SetMethod() can be used to change how the filter manage the labels from the
different label maps. KEEP (0): MergeLabelMapFilter do its best to keep the label unchanged, but if a label is already
used in a previous label map, a new label is assigned. AGGREGATE (1):
If the same label is found several times in the label maps, the label
objects with the same label are merged. PACK (2): MergeLabelMapFilter relabel all the label objects by order of processing. No conflict can
occur. STRICT (3): MergeLabelMapFilter keeps the labels unchanged and raises an exception if the same label
is found in several images.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter

 itk::simple::MergeLabelMapFilter for the procedural interface


C++ includes: sitkMergeLabelMapFilter.h
*/"

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector< Image > &images, MergeLabelMapFilter::MethodType
method)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, MergeLabelMapFilter::MethodType method)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2,
MergeLabelMapFilter::MethodType method)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2, const Image &image3,
MergeLabelMapFilter::MethodType method)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, MergeLabelMapFilter::MethodType method)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::Execute "/**
Image itk::simple::MergeLabelMapFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5, MergeLabelMapFilter::MethodType
method)
*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::GetMethod "/**
MethodType itk::simple::MergeLabelMapFilter::GetMethod() const

Set/Get the method used to merge the label maps

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::GetName "/**
std::string itk::simple::MergeLabelMapFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::MergeLabelMapFilter "/**
itk::simple::MergeLabelMapFilter::MergeLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::SetMethod "/**
Self& itk::simple::MergeLabelMapFilter::SetMethod(MethodType Method)

Set/Get the method used to merge the label maps

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::ToString "/**
std::string itk::simple::MergeLabelMapFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MergeLabelMapFilter::~MergeLabelMapFilter "/**
itk::simple::MergeLabelMapFilter::~MergeLabelMapFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MinMaxCurvatureFlowImageFilter "/**

Denoise an image using min/max curvature flow.


MinMaxCurvatureFlowImageFilter implements a curvature driven image denoising algorithm. Iso-
brightness contours in the grayscale input image are viewed as a level
set. The level set is then evolved using a curvature-based speed
function:

\\\\[ I_t = F_{\\\\mbox{minmax}} |\\\\nabla I| \\\\]

where $ F_{\\\\mbox{minmax}} = \\\\max(\\\\kappa,0) $ if $ \\\\mbox{Avg}_{\\\\mbox{stencil}}(x) $ is less than or equal to $ T_{thresold} $ and $ \\\\min(\\\\kappa,0) $ , otherwise. $ \\\\kappa $ is the mean curvature of the iso-brightness contour at point $ x $ .

In min/max curvature flow, movement is turned on or off depending on
the scale of the noise one wants to remove. Switching depends on the
average image value of a region of radius $ R $ around each point. The choice of $ R $ , the stencil radius, governs the scale of the noise to be removed.

The threshold value $ T_{threshold} $ is the average intensity obtained in the direction perpendicular to
the gradient at point $ x $ at the extrema of the local neighborhood.

This filter make use of the multi-threaded finite difference solver
hierarchy. Updates are computed using a MinMaxCurvatureFlowFunction object. A zero flux Neumann boundary condition is used when computing
derivatives near the data boundary.


WARNING:
This filter assumes that the input and output types have the same
dimensions. This filter also requires that the output image pixels are
of a real type. This filter works for any dimensional images, however
for dimensions greater than 3D, an expensive brute-force search is
used to compute the local threshold.
 Reference: \"Level Set Methods and Fast Marching Methods\", J.A.
Sethian, Cambridge Press, Chapter 16, Second edition, 1999.


See:
 MinMaxCurvatureFlowFunction

 CurvatureFlowImageFilter

 BinaryMinMaxCurvatureFlowImageFilter

 itk::simple::MinMaxCurvatureFlow for the procedural interface

 itk::MinMaxCurvatureFlowImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMinMaxCurvatureFlowImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::Execute "/**
Image itk::simple::MinMaxCurvatureFlowImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::Execute "/**
Image itk::simple::MinMaxCurvatureFlowImageFilter::Execute(const Image &image1, double timeStep, uint32_t numberOfIterations,
int stencilRadius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::GetName "/**
std::string itk::simple::MinMaxCurvatureFlowImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::MinMaxCurvatureFlowImageFilter::GetNumberOfIterations() const
*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::GetStencilRadius "/**
int itk::simple::MinMaxCurvatureFlowImageFilter::GetStencilRadius() const

Set/Get the stencil radius.

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::GetTimeStep "/**
double itk::simple::MinMaxCurvatureFlowImageFilter::GetTimeStep() const
*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::MinMaxCurvatureFlowImageFilter "/**
itk::simple::MinMaxCurvatureFlowImageFilter::MinMaxCurvatureFlowImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::SetNumberOfIterations "/**
Self& itk::simple::MinMaxCurvatureFlowImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::SetStencilRadius "/**
Self& itk::simple::MinMaxCurvatureFlowImageFilter::SetStencilRadius(int StencilRadius)

Set/Get the stencil radius.

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::SetTimeStep "/**
Self& itk::simple::MinMaxCurvatureFlowImageFilter::SetTimeStep(double TimeStep)
*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::ToString "/**
std::string itk::simple::MinMaxCurvatureFlowImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MinMaxCurvatureFlowImageFilter::~MinMaxCurvatureFlowImageFilter "/**
itk::simple::MinMaxCurvatureFlowImageFilter::~MinMaxCurvatureFlowImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MinimumImageFilter "/**

Implements a pixel-wise operator Min(a,b) between two images.


The pixel values of the output image are the minimum between the
corresponding pixels of the two input images.

This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Wiki Examples:

All Examples

Pixel wise compare two input images and set the output pixel to their
min
See:
 itk::simple::Minimum for the procedural interface

 itk::MinimumImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMinimumImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MinimumImageFilter::Execute "/**
Image itk::simple::MinimumImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::MinimumImageFilter::Execute "/**
Image itk::simple::MinimumImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::MinimumImageFilter::Execute "/**
Image itk::simple::MinimumImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::MinimumImageFilter::GetName "/**
std::string itk::simple::MinimumImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MinimumImageFilter::MinimumImageFilter "/**
itk::simple::MinimumImageFilter::MinimumImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MinimumImageFilter::ToString "/**
std::string itk::simple::MinimumImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MinimumImageFilter::~MinimumImageFilter "/**
itk::simple::MinimumImageFilter::~MinimumImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MinimumMaximumImageFilter "/**

Computes the minimum and the maximum intensity values of an image.


It is templated over input image type only. This filter just copies
the input image through this output to be included within the
pipeline. The implementation uses the StatisticsImageFilter .


See:
 StatisticsImageFilter

 itk::MinimumMaximumImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMinimumMaximumImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::Execute "/**
void itk::simple::MinimumMaximumImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::GetMaximum "/**
double itk::simple::MinimumMaximumImageFilter::GetMaximum() const

Return the computed Maximum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::GetMinimum "/**
double itk::simple::MinimumMaximumImageFilter::GetMinimum() const

Return the computed Minimum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::GetName "/**
std::string itk::simple::MinimumMaximumImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::MinimumMaximumImageFilter "/**
itk::simple::MinimumMaximumImageFilter::MinimumMaximumImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::ToString "/**
std::string itk::simple::MinimumMaximumImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MinimumMaximumImageFilter::~MinimumMaximumImageFilter "/**
itk::simple::MinimumMaximumImageFilter::~MinimumMaximumImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MinimumProjectionImageFilter "/**

Minimum projection.


This class was contributed to the Insight Journal by Gaetan Lehmann.
The original paper can be found at https://hdl.handle.net/1926/164


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ProjectionImageFilter

 StandardDeviationProjectionImageFilter

 SumProjectionImageFilter

 BinaryProjectionImageFilter

 MaximumProjectionImageFilter

 MeanProjectionImageFilter

 itk::simple::MinimumProjection for the procedural interface

 itk::MinimumProjectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMinimumProjectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::Execute "/**
Image itk::simple::MinimumProjectionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::Execute "/**
Image itk::simple::MinimumProjectionImageFilter::Execute(const Image &image1, unsigned int projectionDimension)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::GetName "/**
std::string itk::simple::MinimumProjectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::GetProjectionDimension "/**
unsigned int itk::simple::MinimumProjectionImageFilter::GetProjectionDimension() const
*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::MinimumProjectionImageFilter "/**
itk::simple::MinimumProjectionImageFilter::MinimumProjectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::SetProjectionDimension "/**
Self& itk::simple::MinimumProjectionImageFilter::SetProjectionDimension(unsigned int ProjectionDimension)
*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::ToString "/**
std::string itk::simple::MinimumProjectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MinimumProjectionImageFilter::~MinimumProjectionImageFilter "/**
itk::simple::MinimumProjectionImageFilter::~MinimumProjectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MirrorPadImageFilter "/**

Increase the image size by padding with replicants of the input image
value.


MirrorPadImageFilter changes the image bounds of an image. Any added pixels are filled in
with a mirrored replica of the input image. For instance, if the
output image needs a pixel that is two pixels to the left of the
LargestPossibleRegion of the input image, the value assigned will be
from the pixel two pixels inside the left boundary of the
LargestPossibleRegion. The image bounds of the output must be
specified.

Visual explanation of padding regions. This filter is implemented as a
multithreaded filter. It provides a ThreadedGenerateData() method for
its implementation.


See:
 WrapPadImageFilter , ConstantPadImageFilter
Wiki Examples:

All Examples

Pad an image using mirroring over the boundaries
See:
 itk::simple::MirrorPad for the procedural interface

 itk::MirrorPadImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMirrorPadImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::Execute "/**
Image itk::simple::MirrorPadImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::Execute "/**
Image itk::simple::MirrorPadImageFilter::Execute(const Image &image1, const std::vector< unsigned int >
&padLowerBound, const std::vector< unsigned int > &padUpperBound)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::GetName "/**
std::string itk::simple::MirrorPadImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::GetPadLowerBound "/**
std::vector<unsigned int> itk::simple::MirrorPadImageFilter::GetPadLowerBound() const
*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::GetPadUpperBound "/**
std::vector<unsigned int> itk::simple::MirrorPadImageFilter::GetPadUpperBound() const
*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::MirrorPadImageFilter "/**
itk::simple::MirrorPadImageFilter::MirrorPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::SetPadLowerBound "/**
Self& itk::simple::MirrorPadImageFilter::SetPadLowerBound(const std::vector< unsigned int > &PadLowerBound)
*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::SetPadUpperBound "/**
Self& itk::simple::MirrorPadImageFilter::SetPadUpperBound(const std::vector< unsigned int > &PadUpperBound)
*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::ToString "/**
std::string itk::simple::MirrorPadImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MirrorPadImageFilter::~MirrorPadImageFilter "/**
itk::simple::MirrorPadImageFilter::~MirrorPadImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::ModulusImageFilter "/**

Computes the modulus (x % dividend) pixel-wise.


The input pixel type must support the c++ modulus operator (%).

If the dividend is zero, the maximum value will be returned.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 itk::simple::Modulus for the procedural interface

 itk::ModulusImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkModulusImageFilter.h
*/"

%javamethodmodifiers  itk::simple::ModulusImageFilter::Execute "/**
Image itk::simple::ModulusImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::ModulusImageFilter::Execute "/**
Image itk::simple::ModulusImageFilter::Execute(const Image &image1, uint32_t constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::ModulusImageFilter::Execute "/**
Image itk::simple::ModulusImageFilter::Execute(uint32_t constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::ModulusImageFilter::GetName "/**
std::string itk::simple::ModulusImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::ModulusImageFilter::ModulusImageFilter "/**
itk::simple::ModulusImageFilter::ModulusImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::ModulusImageFilter::ToString "/**
std::string itk::simple::ModulusImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::ModulusImageFilter::~ModulusImageFilter "/**
itk::simple::ModulusImageFilter::~ModulusImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MomentsThresholdImageFilter "/**

Threshold an image using the Moments Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the MomentsThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811


See:
 HistogramThresholdImageFilter

 itk::simple::MomentsThreshold for the procedural interface

 itk::MomentsThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMomentsThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::Execute "/**
Image itk::simple::MomentsThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::Execute "/**
Image itk::simple::MomentsThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::Execute "/**
Image itk::simple::MomentsThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::Execute "/**
Image itk::simple::MomentsThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::MomentsThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::MomentsThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::MomentsThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetName "/**
std::string itk::simple::MomentsThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::MomentsThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::MomentsThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::GetThreshold "/**
double itk::simple::MomentsThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::MomentsThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::MomentsThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::MomentsThresholdImageFilter "/**
itk::simple::MomentsThresholdImageFilter::MomentsThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::MomentsThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::MomentsThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::MomentsThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::MomentsThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::MomentsThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::ToString "/**
std::string itk::simple::MomentsThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MomentsThresholdImageFilter::~MomentsThresholdImageFilter "/**
itk::simple::MomentsThresholdImageFilter::~MomentsThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MorphologicalGradientImageFilter "/**

gray scale dilation of an image


Dilate an image using grayscale morphology. Dilation takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::MorphologicalGradient for the procedural interface

 itk::MorphologicalGradientImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMorphologicalGradientImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::Execute "/**
Image itk::simple::MorphologicalGradientImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::MorphologicalGradientImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::GetKernelType "/**
KernelEnum itk::simple::MorphologicalGradientImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::GetName "/**
std::string itk::simple::MorphologicalGradientImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::MorphologicalGradientImageFilter "/**
itk::simple::MorphologicalGradientImageFilter::MorphologicalGradientImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::SetKernelRadius "/**
Self& itk::simple::MorphologicalGradientImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::SetKernelRadius "/**
Self& itk::simple::MorphologicalGradientImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::SetKernelType "/**
Self& itk::simple::MorphologicalGradientImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::SetKernelType "/**
Self& itk::simple::MorphologicalGradientImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::ToString "/**
std::string itk::simple::MorphologicalGradientImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalGradientImageFilter::~MorphologicalGradientImageFilter "/**
itk::simple::MorphologicalGradientImageFilter::~MorphologicalGradientImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MorphologicalWatershedFromMarkersImageFilter "/**

Morphological watershed transform from markers.


The watershed transform is a tool for image segmentation that is fast
and flexible and potentially fairly parameter free. It was originally
derived from a geophysical model of rain falling on a terrain and a
variety of more formal definitions have been devised to allow
development of practical algorithms. If an image is considered as a
terrain and divided into catchment basins then the hope is that each
catchment basin would contain an object of interest.

The output is a label image. A label image, sometimes referred to as a
categorical image, has unique values for each region. For example, if
a watershed produces 2 regions, all pixels belonging to one region
would have value A, and all belonging to the other might have value B.
Unassigned pixels, such as watershed lines, might have the background
value (0 by convention).

The simplest way of using the watershed is to preprocess the image we
want to segment so that the boundaries of our objects are bright (e.g
apply an edge detector) and compute the watershed transform of the
edge image. Watershed lines will correspond to the boundaries and our
problem will be solved. This is rarely useful in practice because
there are always more regional minima than there are objects, either
due to noise or natural variations in the object surfaces. Therefore,
while many watershed lines do lie on significant boundaries, there are
many that don't. Various methods can be used to reduce the number of
minima in the image, like thresholding the smallest values, filtering
the minima and/or smoothing the image.

This filter use another approach to avoid the problem of over
segmentation: it let the user provide a marker image which mark the
minima in the input image and give them a label. The minima are
imposed in the input image by the markers. The labels of the output
image are the label of the marker image.

The morphological watershed transform algorithm is described in
Chapter 9.2 of Pierre Soille's book \"Morphological Image Analysis:
Principles and Applications\", Second Edition, Springer, 2003.

This code was contributed in the Insight Journal paper: \"The
watershed transform in ITK - discussion and new developments\" by
Beare R., Lehmann G. https://hdl.handle.net/1926/202 http://www.insight-journal.org/browse/publication/92


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.


See:
 WatershedImageFilter , MorphologicalWatershedImageFilter

 itk::simple::MorphologicalWatershedFromMarkers for the procedural interface

 itk::MorphologicalWatershedFromMarkersImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMorphologicalWatershedFromMarkersImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::Execute "/**
Image itk::simple::MorphologicalWatershedFromMarkersImageFilter::Execute(const Image &image, const Image &markerImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::Execute "/**
Image itk::simple::MorphologicalWatershedFromMarkersImageFilter::Execute(const Image &image, const Image &markerImage, bool markWatershedLine,
bool fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::FullyConnectedOff "/**
Self& itk::simple::MorphologicalWatershedFromMarkersImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::FullyConnectedOn "/**
Self& itk::simple::MorphologicalWatershedFromMarkersImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetFullyConnected "/**
bool itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetMarkWatershedLine "/**
bool itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetMarkWatershedLine() const

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetName "/**
std::string itk::simple::MorphologicalWatershedFromMarkersImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::MarkWatershedLineOff "/**
Self& itk::simple::MorphologicalWatershedFromMarkersImageFilter::MarkWatershedLineOff()
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::MarkWatershedLineOn "/**
Self& itk::simple::MorphologicalWatershedFromMarkersImageFilter::MarkWatershedLineOn()

Set the value of MarkWatershedLine to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::MorphologicalWatershedFromMarkersImageFilter "/**
itk::simple::MorphologicalWatershedFromMarkersImageFilter::MorphologicalWatershedFromMarkersImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::SetFullyConnected "/**
Self& itk::simple::MorphologicalWatershedFromMarkersImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::SetMarkWatershedLine "/**
Self& itk::simple::MorphologicalWatershedFromMarkersImageFilter::SetMarkWatershedLine(bool MarkWatershedLine)

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::ToString "/**
std::string itk::simple::MorphologicalWatershedFromMarkersImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedFromMarkersImageFilter::~MorphologicalWatershedFromMarkersImageFilter "/**
itk::simple::MorphologicalWatershedFromMarkersImageFilter::~MorphologicalWatershedFromMarkersImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MorphologicalWatershedImageFilter "/**

Watershed segmentation implementation with morphogical operators.


Watershed pixel are labeled 0. TOutputImage should be an integer type.
Labels of output image are in no particular order. You can reorder the
labels such that object labels are consecutive and sorted based on
object size by passing the output of this filter to a RelabelComponentImageFilter .

The morphological watershed transform algorithm is described in
Chapter 9.2 of Pierre Soille's book \"Morphological Image Analysis:
Principles and Applications\", Second Edition, Springer, 2003.

This code was contributed in the Insight Journal paper: \"The
watershed transform in ITK - discussion and new developments\" by
Beare R., Lehmann G. https://hdl.handle.net/1926/202 http://www.insight-journal.org/browse/publication/92


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 WatershedImageFilter , MorphologicalWatershedFromMarkersImageFilter

 itk::simple::MorphologicalWatershed for the procedural interface

 itk::MorphologicalWatershedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMorphologicalWatershedImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::Execute "/**
Image itk::simple::MorphologicalWatershedImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::Execute "/**
Image itk::simple::MorphologicalWatershedImageFilter::Execute(const Image &image1, double level, bool markWatershedLine, bool
fullyConnected)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::FullyConnectedOff "/**
Self& itk::simple::MorphologicalWatershedImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::FullyConnectedOn "/**
Self& itk::simple::MorphologicalWatershedImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::GetFullyConnected "/**
bool itk::simple::MorphologicalWatershedImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::GetLevel "/**
double itk::simple::MorphologicalWatershedImageFilter::GetLevel() const
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::GetMarkWatershedLine "/**
bool itk::simple::MorphologicalWatershedImageFilter::GetMarkWatershedLine() const

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::GetName "/**
std::string itk::simple::MorphologicalWatershedImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::MarkWatershedLineOff "/**
Self& itk::simple::MorphologicalWatershedImageFilter::MarkWatershedLineOff()
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::MarkWatershedLineOn "/**
Self& itk::simple::MorphologicalWatershedImageFilter::MarkWatershedLineOn()

Set the value of MarkWatershedLine to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::MorphologicalWatershedImageFilter "/**
itk::simple::MorphologicalWatershedImageFilter::MorphologicalWatershedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::SetFullyConnected "/**
Self& itk::simple::MorphologicalWatershedImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::SetLevel "/**
Self& itk::simple::MorphologicalWatershedImageFilter::SetLevel(double Level)
*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::SetMarkWatershedLine "/**
Self& itk::simple::MorphologicalWatershedImageFilter::SetMarkWatershedLine(bool MarkWatershedLine)

Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::ToString "/**
std::string itk::simple::MorphologicalWatershedImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MorphologicalWatershedImageFilter::~MorphologicalWatershedImageFilter "/**
itk::simple::MorphologicalWatershedImageFilter::~MorphologicalWatershedImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MultiLabelSTAPLEImageFilter "/**

This filter performs a pixelwise combination of an arbitrary number of
input images, where each of them represents a segmentation of the same
scene (i.e., image).


The labelings in the images are weighted relative to each other based
on their \"performance\" as estimated by an expectation-maximization
algorithm. In the process, a ground truth segmentation is estimated,
and the estimated performances of the individual segmentations are
relative to this estimated ground truth.

The algorithm is based on the binary STAPLE algorithm by Warfield et
al. as published originally in

S. Warfield, K. Zou, W. Wells, \"Validation of image segmentation and
expert quality with an expectation-maximization algorithm\" in MICCAI
2002: Fifth International Conference on Medical Image Computing and Computer-Assisted Intervention, Springer-Verlag,
Heidelberg, Germany, 2002, pp. 298-306

The multi-label algorithm implemented here is described in detail in

T. Rohlfing, D. B. Russakoff, and C. R. Maurer, Jr., \"Performance-
based classifier combination in atlas-based image segmentation using
expectation-maximization parameter estimation,\" IEEE Transactions on
Medical Imaging, vol. 23, pp. 983-994, Aug. 2004.

INPUTS
All input volumes to this filter must be segmentations of an image,
that is, they must have discrete pixel values where each value
represents a different segmented object.
 Input volumes must all contain the same size RequestedRegions. Not all input images must contain all possible labels, but all label
values must have the same meaning in all images.

The filter can optionally be provided with estimates for the a priori
class probabilities through the SetPriorProbabilities function. If no
estimate is provided, one is automatically generated by analyzing the
relative frequencies of the labels in the input images.

OUTPUTS
The filter produces a single output volume. Each output pixel contains
the label that has the highest probability of being the correct label,
based on the performance models of the individual segmentations. If
the maximum probaility is not unique, i.e., if more than one label
have a maximum probability, then an \"undecided\" label is assigned to
that output pixel.
 By default, the label used for undecided pixels is the maximum label
value used in the input images plus one. Since it is possible for an
image with 8 bit pixel values to use all 256 possible label values, it
is permissible to combine 8 bit (i.e., byte) images into a 16 bit
(i.e., short) output image.

In addition to the combined image, the estimated confusion matrices
for each of the input segmentations can be obtained through the
GetConfusionMatrix member function.

PARAMETERS
The label used for \"undecided\" labels can be set using
SetLabelForUndecidedPixels. This functionality can be unset by calling
UnsetLabelForUndecidedPixels.
 A termination threshold for the EM iteration can be defined by
calling SetTerminationUpdateThreshold. The iteration terminates once
no single parameter of any confusion matrix changes by less than this
threshold. Alternatively, a maximum number of iterations can be
specified by calling SetMaximumNumberOfIterations. The algorithm may
still terminate after a smaller number of iterations if the
termination threshold criterion is satisfied.

EVENTS
This filter invokes IterationEvent() at each iteration of the E-M
algorithm. Setting the AbortGenerateData() flag will cause the
algorithm to halt after the current iteration and produce results just
as if it had converged. The algorithm makes no attempt to report its
progress since the number of iterations needed cannot be known in
advance.

Torsten Rohlfing, SRI International, Neuroscience Program

See:
 itk::simple::MultiLabelSTAPLE for the procedural interface


C++ includes: sitkMultiLabelSTAPLEImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const std::vector< Image > &images, uint64_t labelForUndecidedPixels,
float terminationUpdateThreshold, unsigned int
maximumNumberOfIterations, std::vector< float > priorProbabilities)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, uint64_t labelForUndecidedPixels, float
terminationUpdateThreshold, unsigned int maximumNumberOfIterations,
std::vector< float > priorProbabilities)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, uint64_t
labelForUndecidedPixels, float terminationUpdateThreshold, unsigned
int maximumNumberOfIterations, std::vector< float >
priorProbabilities)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3,
uint64_t labelForUndecidedPixels, float terminationUpdateThreshold,
unsigned int maximumNumberOfIterations, std::vector< float >
priorProbabilities)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, uint64_t labelForUndecidedPixels, float
terminationUpdateThreshold, unsigned int maximumNumberOfIterations,
std::vector< float > priorProbabilities)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::Execute "/**
Image itk::simple::MultiLabelSTAPLEImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5, uint64_t labelForUndecidedPixels,
float terminationUpdateThreshold, unsigned int
maximumNumberOfIterations, std::vector< float > priorProbabilities)
*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::GetConfusionMatrix "/**
std::vector<float> itk::simple::MultiLabelSTAPLEImageFilter::GetConfusionMatrix(unsigned int input) const

Get confusion matrix for the i-th input segmentation.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::GetLabelForUndecidedPixels "/**
uint64_t itk::simple::MultiLabelSTAPLEImageFilter::GetLabelForUndecidedPixels() const

     Get label value used for undecided pixels.

After updating the filter, this function returns the actual label
value used for undecided pixels in the current output. Note that this
value is overwritten when SetLabelForUndecidedPixels is called and the
new value only becomes effective upon the next filter update.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::GetMaximumNumberOfIterations "/**
unsigned int itk::simple::MultiLabelSTAPLEImageFilter::GetMaximumNumberOfIterations() const

Set maximum number of iterations.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::GetName "/**
std::string itk::simple::MultiLabelSTAPLEImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::GetPriorProbabilities "/**
std::vector<float> itk::simple::MultiLabelSTAPLEImageFilter::GetPriorProbabilities() const

     Get prior class probabilities.

After updating the filter, this function returns the actual prior
class probabilities. If these were not previously set by a call to
SetPriorProbabilities, then they are estimated from the input
segmentations and the result is available through this function.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::GetTerminationUpdateThreshold "/**
float itk::simple::MultiLabelSTAPLEImageFilter::GetTerminationUpdateThreshold() const

Set termination threshold based on confusion matrix parameter updates.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::MultiLabelSTAPLEImageFilter "/**
itk::simple::MultiLabelSTAPLEImageFilter::MultiLabelSTAPLEImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::SetLabelForUndecidedPixels "/**
Self& itk::simple::MultiLabelSTAPLEImageFilter::SetLabelForUndecidedPixels(uint64_t LabelForUndecidedPixels)

Set label value for undecided pixels.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::SetMaximumNumberOfIterations "/**
Self& itk::simple::MultiLabelSTAPLEImageFilter::SetMaximumNumberOfIterations(unsigned int MaximumNumberOfIterations)

Set maximum number of iterations.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::SetPriorProbabilities "/**
Self& itk::simple::MultiLabelSTAPLEImageFilter::SetPriorProbabilities(std::vector< float > PriorProbabilities)

    Set manual estimates for the a priori class probabilities. The
size of the array must be greater than the value of the largest label. The index into the array corresponds to the label
value in the segmented image for the class.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::SetTerminationUpdateThreshold "/**
Self& itk::simple::MultiLabelSTAPLEImageFilter::SetTerminationUpdateThreshold(float TerminationUpdateThreshold)

Set termination threshold based on confusion matrix parameter updates.

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::ToString "/**
std::string itk::simple::MultiLabelSTAPLEImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MultiLabelSTAPLEImageFilter::~MultiLabelSTAPLEImageFilter "/**
itk::simple::MultiLabelSTAPLEImageFilter::~MultiLabelSTAPLEImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::MultiplyImageFilter "/**

Pixel-wise multiplication of two images.


This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Wiki Examples:

All Examples

Multiply two images together

Multiply every pixel in an image by a constant
See:
 itk::simple::Multiply for the procedural interface

 itk::MultiplyImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkMultiplyImageFilter.h
*/"

%javamethodmodifiers  itk::simple::MultiplyImageFilter::Execute "/**
Image itk::simple::MultiplyImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::MultiplyImageFilter::Execute "/**
Image itk::simple::MultiplyImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::MultiplyImageFilter::Execute "/**
Image itk::simple::MultiplyImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::MultiplyImageFilter::GetName "/**
std::string itk::simple::MultiplyImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::MultiplyImageFilter::MultiplyImageFilter "/**
itk::simple::MultiplyImageFilter::MultiplyImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::MultiplyImageFilter::ToString "/**
std::string itk::simple::MultiplyImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::MultiplyImageFilter::~MultiplyImageFilter "/**
itk::simple::MultiplyImageFilter::~MultiplyImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::N4BiasFieldCorrectionImageFilter "/**

Implementation of the N4 bias field correction algorithm.


The nonparametric nonuniform intensity normalization (N3) algorithm,
as introduced by Sled et al. in 1998 is a method for correcting
nonuniformity associated with MR images. The algorithm assumes a
simple parametric model (Gaussian) for the bias field and does not
require tissue class segmentation. In addition, there are only a
couple of parameters to tune with the default values performing quite
well. N3 has been publicly available as a set of perl scripts ( http://www.bic.mni.mcgill.ca/ServicesSoftwareAdvancedImageProcessingTo
ols/HomePage )

The N4 algorithm, encapsulated with this class, is a variation of the
original N3 algorithm with the additional benefits of an improved
B-spline fitting routine which allows for multiple resolutions to be
used during the correction process. We also modify the iterative
update component of algorithm such that the residual bias field is
continually updated

Notes for the user:
Since much of the image manipulation is done in the log space of the
intensities, input images with negative and small values (< 1) can
produce poor results.

The original authors recommend performing the bias field correction on
a downsampled version of the original image.

A binary mask or a weighted image can be supplied. If a binary mask is
specified, those voxels in the input image which correspond to the
voxels in the mask image are used to estimate the bias field. If a
UseMaskLabel value is set to true, only voxels in the MaskImage that
match the MaskLabel will be used; otherwise, all non-zero voxels in
the MaskImage will be masked. If a confidence image is specified, the
input voxels are weighted in the b-spline fitting routine according to
the confidence voxel values.

The filter returns the corrected image. If the bias field is wanted,
one can reconstruct it using the class
itkBSplineControlPointImageFilter. See the IJ article and the test
file for an example.

The 'Z' parameter in Sled's 1998 paper is the square root of the class
variable 'm_WienerFilterNoise'.
 The basic algorithm iterates between sharpening the intensity
histogram of the corrected input image and spatially smoothing those
results with a B-spline scalar field estimate of the bias field.


Nicholas J. Tustison
 Contributed by Nicholas J. Tustison, James C. Gee in the Insight
Journal paper: https://hdl.handle.net/10380/3053

REFERENCE
 J.G. Sled, A.P. Zijdenbos and A.C. Evans. \"A Nonparametric Method
for Automatic Correction of Intensity Nonuniformity in Data\" IEEE
Transactions on Medical Imaging, Vol 17, No 1. Feb 1998.

N.J. Tustison, B.B. Avants, P.A. Cook, Y. Zheng, A. Egan, P.A.
Yushkevich, and J.C. Gee. \"N4ITK: Improved N3 Bias Correction\" IEEE
Transactions on Medical Imaging, 29(6):1310-1320, June 2010.
See:
 itk::simple::N4BiasFieldCorrection for the procedural interface

 itk::N4BiasFieldCorrectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkN4BiasFieldCorrectionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::Execute "/**
Image itk::simple::N4BiasFieldCorrectionImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::Execute "/**
Image itk::simple::N4BiasFieldCorrectionImageFilter::Execute(const Image &image, const Image &maskImage, double
convergenceThreshold, std::vector< uint32_t >
maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum,
double wienerFilterNoise, uint32_t numberOfHistogramBins, const
std::vector< uint32_t > &numberOfControlPoints, uint32_t splineOrder)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetBiasFieldFullWidthAtHalfMaximum "/**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetBiasFieldFullWidthAtHalfMaximum() const

Get the full width at half maximum parameter characterizing the width
of the Gaussian deconvolution. Default = 0.15.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetConvergenceThreshold "/**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetConvergenceThreshold() const

Get the convergence threshold. Convergence is determined by the
coefficient of variation of the difference image between the current
bias field estimate and the previous estimate. If this value is less
than the specified threshold, the algorithm proceeds to the next
fitting level or terminates if it is at the last level.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetMaximumNumberOfIterations "/**
std::vector<uint32_t> itk::simple::N4BiasFieldCorrectionImageFilter::GetMaximumNumberOfIterations() const

Get the maximum number of iterations specified at each fitting level.
Default = 50.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetName "/**
std::string itk::simple::N4BiasFieldCorrectionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetNumberOfControlPoints "/**
std::vector<uint32_t> itk::simple::N4BiasFieldCorrectionImageFilter::GetNumberOfControlPoints() const

Get the control point grid size defining the B-spline estimate of the
scalar bias field. In each dimension, the B-spline mesh size is equal
to the number of control points in that dimension minus the spline
order. Default = 4 control points in each dimension for a mesh size of
1 in each dimension.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::N4BiasFieldCorrectionImageFilter::GetNumberOfHistogramBins() const

Get number of bins defining the log input intensity histogram. Default
= 200.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetSplineOrder "/**
uint32_t itk::simple::N4BiasFieldCorrectionImageFilter::GetSplineOrder() const

Get the spline order defining the bias field estimate. Default = 3.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::GetWienerFilterNoise "/**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetWienerFilterNoise() const

Get the noise estimate defining the Wiener filter. Default = 0.01.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::N4BiasFieldCorrectionImageFilter "/**
itk::simple::N4BiasFieldCorrectionImageFilter::N4BiasFieldCorrectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetBiasFieldFullWidthAtHalfMaximum "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetBiasFieldFullWidthAtHalfMaximum(double BiasFieldFullWidthAtHalfMaximum)

Set the full width at half maximum parameter characterizing the width
of the Gaussian deconvolution. Default = 0.15.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetConvergenceThreshold "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetConvergenceThreshold(double ConvergenceThreshold)

Set the convergence threshold. Convergence is determined by the
coefficient of variation of the difference image between the current
bias field estimate and the previous estimate. If this value is less
than the specified threshold, the algorithm proceeds to the next
fitting level or terminates if it is at the last level.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetMaximumNumberOfIterations "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetMaximumNumberOfIterations(std::vector< uint32_t > MaximumNumberOfIterations)

Set the maximum number of iterations specified at each fitting level.
Default = 50.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfControlPoints "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfControlPoints(const std::vector< uint32_t > &NumberOfControlPoints)

Set the control point grid size defining the B-spline estimate of the
scalar bias field. In each dimension, the B-spline mesh size is equal
to the number of control points in that dimension minus the spline
order. Default = 4 control points in each dimension for a mesh size of
1 in each dimension.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfControlPoints "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfControlPoints(uint32_t value)

Set the values of the NumberOfControlPoints vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set number of bins defining the log input intensity histogram. Default
= 200.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetSplineOrder "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetSplineOrder(uint32_t SplineOrder)

Set the spline order defining the bias field estimate. Default = 3.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::SetWienerFilterNoise "/**
Self& itk::simple::N4BiasFieldCorrectionImageFilter::SetWienerFilterNoise(double WienerFilterNoise)

Set the noise estimate defining the Wiener filter. Default = 0.01.

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::ToString "/**
std::string itk::simple::N4BiasFieldCorrectionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::N4BiasFieldCorrectionImageFilter::~N4BiasFieldCorrectionImageFilter "/**
itk::simple::N4BiasFieldCorrectionImageFilter::~N4BiasFieldCorrectionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NaryAddImageFilter "/**

Pixel-wise addition of N images.


This class is templated over the types of the input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

The pixel type of the input images must have a valid definition of the
operator+ with each other. This condition is required because
internally this filter will perform the operation


Additionally the type resulting from the sum, will be cast to the
pixel type of the output image.

The total operation over one pixel will be


For example, this filter could be used directly for adding images
whose pixels are vectors of the same dimension, and to store the
resulting vector in an output image of vector pixels.


WARNING:
No numeric overflow checking is performed in this filter.

See:
 itk::simple::NaryAdd for the procedural interface


C++ includes: sitkNaryAddImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NaryAddImageFilter::Execute "/**
Image itk::simple::NaryAddImageFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::Execute "/**
Image itk::simple::NaryAddImageFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::Execute "/**
Image itk::simple::NaryAddImageFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::Execute "/**
Image itk::simple::NaryAddImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::Execute "/**
Image itk::simple::NaryAddImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::Execute "/**
Image itk::simple::NaryAddImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::GetName "/**
std::string itk::simple::NaryAddImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::NaryAddImageFilter "/**
itk::simple::NaryAddImageFilter::NaryAddImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::ToString "/**
std::string itk::simple::NaryAddImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NaryAddImageFilter::~NaryAddImageFilter "/**
itk::simple::NaryAddImageFilter::~NaryAddImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NaryMaximumImageFilter "/**

Computes the pixel-wise maximum of several images.


This class is templated over the types of the input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

The pixel type of the output images must have a valid definition of
the operator<. This condition is required because internally this
filter will perform an operation similar to:

 (where current_maximum is also of type OutputPixelType)

for each of the n input images.

For example, this filter could be used directly to find a \"maximum
projection\" of a series of images, often used in preliminary analysis
of time-series data.


Zachary Pincus
 This filter was contributed by Zachary Pincus from the Department of
Biochemistry and Program in Biomedical Informatics at Stanford
University School of Medicine


See:
 itk::simple::NaryMaximum for the procedural interface


C++ includes: sitkNaryMaximumImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::Execute "/**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector< Image > &images)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::Execute "/**
Image itk::simple::NaryMaximumImageFilter::Execute(const Image &image1)
*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::Execute "/**
Image itk::simple::NaryMaximumImageFilter::Execute(const Image &image1, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::Execute "/**
Image itk::simple::NaryMaximumImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3)
*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::Execute "/**
Image itk::simple::NaryMaximumImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4)
*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::Execute "/**
Image itk::simple::NaryMaximumImageFilter::Execute(const Image &image1, const Image &image2, const Image &image3, const
Image &image4, const Image &image5)
*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::GetName "/**
std::string itk::simple::NaryMaximumImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::NaryMaximumImageFilter "/**
itk::simple::NaryMaximumImageFilter::NaryMaximumImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::ToString "/**
std::string itk::simple::NaryMaximumImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NaryMaximumImageFilter::~NaryMaximumImageFilter "/**
itk::simple::NaryMaximumImageFilter::~NaryMaximumImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NeighborhoodConnectedImageFilter "/**

Label pixels that are connected to a seed and lie within a
neighborhood.


NeighborhoodConnectedImageFilter labels pixels with ReplaceValue that are connected to an initial Seed
AND whose neighbors all lie within a Lower and Upper threshold range.
See:
 itk::simple::NeighborhoodConnected for the procedural interface

 itk::NeighborhoodConnectedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNeighborhoodConnectedImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::AddSeed "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::AddSeed(const std::vector< unsigned int > &idx)

AddSeed - Add a seed to the end of the list

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::ClearSeeds "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::ClearSeeds()

ClearSeeds - Clear out all seeds in the list

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::Execute "/**
Image itk::simple::NeighborhoodConnectedImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::Execute "/**
Image itk::simple::NeighborhoodConnectedImageFilter::Execute(const Image &image1, const std::vector< std::vector< unsigned int > >
&seedList, double lower, double upper, const std::vector< unsigned int
> &radius, double replaceValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::GetLower "/**
double itk::simple::NeighborhoodConnectedImageFilter::GetLower() const

Set/Get the lower threshold. The default is 0.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::GetName "/**
std::string itk::simple::NeighborhoodConnectedImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::NeighborhoodConnectedImageFilter::GetRadius() const

Get the radius of the neighborhood used to compute the median

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::GetReplaceValue "/**
double itk::simple::NeighborhoodConnectedImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::GetSeedList "/**
std::vector< std::vector<unsigned int> > itk::simple::NeighborhoodConnectedImageFilter::GetSeedList() const

Get SeedList

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::GetUpper "/**
double itk::simple::NeighborhoodConnectedImageFilter::GetUpper() const

Set/Get the upper threshold. The default is the largest possible value
for the InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::NeighborhoodConnectedImageFilter "/**
itk::simple::NeighborhoodConnectedImageFilter::NeighborhoodConnectedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetLower "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetLower(double Lower)

Set/Get the lower threshold. The default is 0.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetRadius "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetRadius(const std::vector< unsigned int > &Radius)

Set the radius of the neighborhood used for a mask.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetRadius "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetReplaceValue "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetReplaceValue(double ReplaceValue)

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetSeed "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetSeed(const std::vector< unsigned int > &idx)

SetSeed - Set list to a single seed

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetSeedList "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetSeedList(const std::vector< std::vector< unsigned int > > &t)

Set SeedList

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::SetUpper "/**
Self& itk::simple::NeighborhoodConnectedImageFilter::SetUpper(double Upper)

Set/Get the upper threshold. The default is the largest possible value
for the InputPixelType.

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::ToString "/**
std::string itk::simple::NeighborhoodConnectedImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NeighborhoodConnectedImageFilter::~NeighborhoodConnectedImageFilter "/**
itk::simple::NeighborhoodConnectedImageFilter::~NeighborhoodConnectedImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NoiseImageFilter "/**

Calculate the local noise in an image.


Computes an image where a given pixel is the standard deviation of the
pixels in a neighborhood about the corresponding input pixel. This
serves as an estimate of the local noise (or texture) in an image.
Currently, this noise estimate assume a piecewise constant image. This
filter should be extended to fitting a (hyper) plane to the
neighborhood and calculating the standard deviation of the residuals
to this (hyper) plane.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator
Wiki Examples:

All Examples

Compute the local noise in an image
See:
 itk::simple::Noise for the procedural interface

 itk::NoiseImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkNoiseImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NoiseImageFilter::Execute "/**
Image itk::simple::NoiseImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::Execute "/**
Image itk::simple::NoiseImageFilter::Execute(const Image &image1, const std::vector< unsigned int > &radius)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::GetName "/**
std::string itk::simple::NoiseImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::GetRadius "/**
std::vector<unsigned int> itk::simple::NoiseImageFilter::GetRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::NoiseImageFilter "/**
itk::simple::NoiseImageFilter::NoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::SetRadius "/**
Self& itk::simple::NoiseImageFilter::SetRadius(const std::vector< unsigned int > &Radius)
*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::SetRadius "/**
Self& itk::simple::NoiseImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::ToString "/**
std::string itk::simple::NoiseImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NoiseImageFilter::~NoiseImageFilter "/**
itk::simple::NoiseImageFilter::~NoiseImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NonCopyable "/**

An inheratable class to disable copying of a class.


This class disable the implicit implementations of the assignment and
copy constructor for derived classes. The instantiation of the default
implementation for either method in a derived class will result in a
compile-time error because they are private in this class. However,
this policy is not absolute for derived classes because explicit
implementation of these methods could be implemented.

An advatange this apporach has is the class heiarchy makes it obvious
what the intent is, as compared to other appoaches.

For example you should not be able to copy singleton object, because
there should only be one of them. To utilize this class just derive
from it:

C++ includes: sitkNonCopyable.h
*/"


%typemap(javaimports) itk::simple::NormalizeImageFilter "/**

Normalize an image by setting its mean to zero and variance to one.


NormalizeImageFilter shifts and scales an image so that the pixels in the image have a
zero mean and unit variance. This filter uses StatisticsImageFilter to compute the mean and variance of the input and then applies ShiftScaleImageFilter to shift and scale the pixels.

NB: since this filter normalizes the data to lie within -1 to 1,
integral types will produce an image that DOES NOT HAVE a unit
variance.


See:
 NormalizeToConstantImageFilter
Wiki Examples:

All Examples

Normalize an image
See:
 itk::simple::Normalize for the procedural interface

 itk::NormalizeImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkNormalizeImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NormalizeImageFilter::Execute "/**
Image itk::simple::NormalizeImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeImageFilter::GetName "/**
std::string itk::simple::NormalizeImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeImageFilter::NormalizeImageFilter "/**
itk::simple::NormalizeImageFilter::NormalizeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeImageFilter::ToString "/**
std::string itk::simple::NormalizeImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeImageFilter::~NormalizeImageFilter "/**
itk::simple::NormalizeImageFilter::~NormalizeImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NormalizeToConstantImageFilter "/**

Scales image pixel intensities to make the sum of all pixels equal a
user-defined constant.


The default value of the constant is 1. It can be changed with SetConstant() .

This transform is especially useful for normalizing a convolution
kernel.

This code was contributed in the Insight Journal paper: \"FFT based
convolution\" by Lehmann G. https://hdl.handle.net/10380/3154


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 NormalizeImageFilter

 StatisticsImageFilter

 DivideImageFilter
Wiki Examples:

All Examples

Scale all pixels so that their sum is a specified constant
See:
 itk::simple::NormalizeToConstant for the procedural interface

 itk::NormalizeToConstantImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkNormalizeToConstantImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::Execute "/**
Image itk::simple::NormalizeToConstantImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::Execute "/**
Image itk::simple::NormalizeToConstantImageFilter::Execute(const Image &image1, double constant)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::GetConstant "/**
double itk::simple::NormalizeToConstantImageFilter::GetConstant() const

Set/get the normalization constant.

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::GetName "/**
std::string itk::simple::NormalizeToConstantImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::NormalizeToConstantImageFilter "/**
itk::simple::NormalizeToConstantImageFilter::NormalizeToConstantImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::SetConstant "/**
Self& itk::simple::NormalizeToConstantImageFilter::SetConstant(double Constant)

Set/get the normalization constant.

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::ToString "/**
std::string itk::simple::NormalizeToConstantImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NormalizeToConstantImageFilter::~NormalizeToConstantImageFilter "/**
itk::simple::NormalizeToConstantImageFilter::~NormalizeToConstantImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NormalizedCorrelationImageFilter "/**

Computes the normalized correlation of an image and a template.


This filter calculates the normalized correlation between an image and
the template. Normalized correlation is frequently use in feature
detection because it is invariant to local changes in contrast.

The filter can be given a mask. When presented with an input image and
a mask, the normalized correlation is only calculated at those pixels
under the mask.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator
Wiki Examples:

All Examples

Normalized correlation
See:
 itk::simple::NormalizedCorrelation for the procedural interface

 itk::NormalizedCorrelationImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkNormalizedCorrelationImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NormalizedCorrelationImageFilter::Execute "/**
Image itk::simple::NormalizedCorrelationImageFilter::Execute(const Image &image, const Image &maskImage, const Image
&templateImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::NormalizedCorrelationImageFilter::GetName "/**
std::string itk::simple::NormalizedCorrelationImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NormalizedCorrelationImageFilter::NormalizedCorrelationImageFilter "/**
itk::simple::NormalizedCorrelationImageFilter::NormalizedCorrelationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NormalizedCorrelationImageFilter::ToString "/**
std::string itk::simple::NormalizedCorrelationImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NormalizedCorrelationImageFilter::~NormalizedCorrelationImageFilter "/**
itk::simple::NormalizedCorrelationImageFilter::~NormalizedCorrelationImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NotEqualImageFilter "/**

Implements pixel-wise generic operation of two images, or of an image
and a constant.


This class is parameterized over the types of the two input images and
the type of the output image. It is also parameterized by the
operation to be applied. A Functor style is used.

The constant must be of the same type than the pixel type of the
corresponding image. It is wrapped in a SimpleDataObjectDecorator so it can be updated through the pipeline. The SetConstant() and
GetConstant() methods are provided as shortcuts to set or get the
constant value without manipulating the decorator.


See:
 UnaryFunctorImageFilter TernaryFunctorImageFilter
Wiki Examples:

All Examples

Apply a predefined operation to corresponding pixels in two images

Apply a custom operation to corresponding pixels in two images
See:
 itk::simple::NotEqual for the procedural interface

 itk::BinaryFunctorImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkNotEqualImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NotEqualImageFilter::Execute "/**
Image itk::simple::NotEqualImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::Execute "/**
Image itk::simple::NotEqualImageFilter::Execute(const Image &image1, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::Execute "/**
Image itk::simple::NotEqualImageFilter::Execute(const Image &image1, double constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::Execute "/**
Image itk::simple::NotEqualImageFilter::Execute(double constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::Execute "/**
Image itk::simple::NotEqualImageFilter::Execute(const Image &image1, double constant, uint8_t backgroundValue,
uint8_t foregroundValue)

Execute the filter on an image and a constant with the given
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::Execute "/**
Image itk::simple::NotEqualImageFilter::Execute(double constant, const Image &image2, uint8_t backgroundValue,
uint8_t foregroundValue)
*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::GetBackgroundValue "/**
uint8_t itk::simple::NotEqualImageFilter::GetBackgroundValue() const

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::GetForegroundValue "/**
uint8_t itk::simple::NotEqualImageFilter::GetForegroundValue() const

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::GetName "/**
std::string itk::simple::NotEqualImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::NotEqualImageFilter "/**
itk::simple::NotEqualImageFilter::NotEqualImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::SetBackgroundValue "/**
Self& itk::simple::NotEqualImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the value used to mark the false pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::SetForegroundValue "/**
Self& itk::simple::NotEqualImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the value used to mark the true pixels of the operator.

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::ToString "/**
std::string itk::simple::NotEqualImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NotEqualImageFilter::~NotEqualImageFilter "/**
itk::simple::NotEqualImageFilter::~NotEqualImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::NotImageFilter "/**

Implements the NOT logical operator pixel-wise on an image.


This class is templated over the type of an input image and the type
of the output image. Numeric conversions (castings) are done by the
C++ defaults.

Since the logical NOT operation operates only on boolean types, the
input type must be implicitly convertible to bool, which is only
defined in C++ for integer types, the images passed to this filter
must comply with the requirement of using integer pixel type.

The total operation over one pixel will be


Where \"!\" is the unary Logical NOT operator in C++.
See:
 itk::simple::Not for the procedural interface

 itk::NotImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNotImageFilter.h
*/"

%javamethodmodifiers  itk::simple::NotImageFilter::Execute "/**
Image itk::simple::NotImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::NotImageFilter::GetName "/**
std::string itk::simple::NotImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::NotImageFilter::NotImageFilter "/**
itk::simple::NotImageFilter::NotImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::NotImageFilter::ToString "/**
std::string itk::simple::NotImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::NotImageFilter::~NotImageFilter "/**
itk::simple::NotImageFilter::~NotImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::OpeningByReconstructionImageFilter "/**

Opening by reconstruction of an image.


This filter preserves regions, in the foreground, that can completely
contain the structuring element. At the same time, this filter
eliminates all other regions of foreground pixels. Contrary to the
mophological opening, the opening by reconstruction preserves the
shape of the components that are not removed by erosion. The opening
by reconstruction of an image \"f\" is defined as:

OpeningByReconstruction(f) = DilationByRecontruction(f, Erosion(f)).

Opening by reconstruction not only removes structures destroyed by the
erosion, but also levels down the contrast of the brightest regions.
If PreserveIntensities is on, a subsequent reconstruction by dilation
using a marker image that is the original image for all unaffected
pixels.

Opening by reconstruction is described in Chapter 6.3.9 of Pierre
Soille's book \"Morphological Image Analysis: Principles and
Applications\", Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 GrayscaleMorphologicalOpeningImageFilter

 itk::simple::OpeningByReconstruction for the procedural interface

 itk::OpeningByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkOpeningByReconstructionImageFilter.h
*/"

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::Execute "/**
Image itk::simple::OpeningByReconstructionImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::Execute "/**
Image itk::simple::OpeningByReconstructionImageFilter::Execute(const Image &image1, bool fullyConnected, bool preserveIntensities)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::FullyConnectedOff "/**
Self& itk::simple::OpeningByReconstructionImageFilter::FullyConnectedOff()
*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::FullyConnectedOn "/**
Self& itk::simple::OpeningByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::GetFullyConnected "/**
bool itk::simple::OpeningByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::GetKernelRadius "/**
std::vector<uint32_t> itk::simple::OpeningByReconstructionImageFilter::GetKernelRadius() const
*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::GetKernelType "/**
KernelEnum itk::simple::OpeningByReconstructionImageFilter::GetKernelType() const
*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::GetName "/**
std::string itk::simple::OpeningByReconstructionImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::GetPreserveIntensities "/**
bool itk::simple::OpeningByReconstructionImageFilter::GetPreserveIntensities() const

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstrcution. If Off, the
output pixel contrast will be reduced.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::OpeningByReconstructionImageFilter "/**
itk::simple::OpeningByReconstructionImageFilter::OpeningByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::PreserveIntensitiesOff "/**
Self& itk::simple::OpeningByReconstructionImageFilter::PreserveIntensitiesOff()
*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::PreserveIntensitiesOn "/**
Self& itk::simple::OpeningByReconstructionImageFilter::PreserveIntensitiesOn()

Set the value of PreserveIntensities to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::SetFullyConnected "/**
Self& itk::simple::OpeningByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::OpeningByReconstructionImageFilter::SetKernelRadius(uint32_t r)

Kernel radius as a scale for isotropic structures

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::SetKernelRadius "/**
Self& itk::simple::OpeningByReconstructionImageFilter::SetKernelRadius(const std::vector< uint32_t > &r)

Set/Get the radius of the kernel structuring element as a vector.

If the dimension of the image is greater then the length of r, then
the radius will be padded. If it is less the r will be truncated.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::OpeningByReconstructionImageFilter::SetKernelType(KernelEnum t)

Set/Get the kernel or structuring elemenent used for the morphology

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::SetKernelType "/**
Self& itk::simple::OpeningByReconstructionImageFilter::SetKernelType(KernelType t)
*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::SetPreserveIntensities "/**
Self& itk::simple::OpeningByReconstructionImageFilter::SetPreserveIntensities(bool PreserveIntensities)

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstrcution. If Off, the
output pixel contrast will be reduced.

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::ToString "/**
std::string itk::simple::OpeningByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::OpeningByReconstructionImageFilter::~OpeningByReconstructionImageFilter "/**
itk::simple::OpeningByReconstructionImageFilter::~OpeningByReconstructionImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::OrImageFilter "/**

Implements the OR bitwise operator pixel-wise between two images.


This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Since the bitwise OR operation is only defined in C++ for integer
types, the images passed to this filter must comply with the
requirement of using integer pixel type.

The total operation over one pixel will be


Where \"|\" is the boolean OR operator in C++.

Wiki Examples:

All Examples

Binary OR two images
See:
 itk::simple::Or for the procedural interface

 itk::OrImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkOrImageFilter.h
*/"

%javamethodmodifiers  itk::simple::OrImageFilter::Execute "/**
Image itk::simple::OrImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::OrImageFilter::Execute "/**
Image itk::simple::OrImageFilter::Execute(const Image &image1, int constant)

Execute the filter with an image and a constant

*/
public ";

%javamethodmodifiers  itk::simple::OrImageFilter::Execute "/**
Image itk::simple::OrImageFilter::Execute(int constant, const Image &image2)
*/
public ";

%javamethodmodifiers  itk::simple::OrImageFilter::GetName "/**
std::string itk::simple::OrImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::OrImageFilter::OrImageFilter "/**
itk::simple::OrImageFilter::OrImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::OrImageFilter::ToString "/**
std::string itk::simple::OrImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::OrImageFilter::~OrImageFilter "/**
itk::simple::OrImageFilter::~OrImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::OtsuMultipleThresholdsImageFilter "/**

Threshold an image using multiple Otsu Thresholds.


This filter creates a labeled image that separates the input image
into various classes. The filter computes the thresholds using the OtsuMultipleThresholdsCalculator and applies those thresholds to the input image using the ThresholdLabelerImageFilter . The NumberOfHistogramBins and NumberOfThresholds can be set for the
Calculator. The LabelOffset can be set for the ThresholdLabelerImageFilter .

This filter also includes an option to use the valley emphasis
algorithm from H.F. Ng, \"Automatic thresholding for defect
detection\", Pattern Recognition Letters, (27): 1644-1649, 2006. The
valley emphasis algorithm is particularly effective when the object to
be thresholded is small. See the following tests for examples:
itkOtsuMultipleThresholdsImageFilterTest3 and
itkOtsuMultipleThresholdsImageFilterTest4 To use this algorithm,
simple call the setter: SetValleyEmphasis(true) It is turned off by
default.


See:
 ScalarImageToHistogramGenerator

 OtsuMultipleThresholdsCalculator

 ThresholdLabelerImageFilter

 itk::simple::OtsuMultipleThresholds for the procedural interface

 itk::OtsuMultipleThresholdsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkOtsuMultipleThresholdsImageFilter.h
*/"

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::Execute "/**
Image itk::simple::OtsuMultipleThresholdsImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::Execute "/**
Image itk::simple::OtsuMultipleThresholdsImageFilter::Execute(const Image &image1, uint8_t numberOfThresholds, uint8_t labelOffset,
uint32_t numberOfHistogramBins, bool valleyEmphasis)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::GetLabelOffset "/**
uint8_t itk::simple::OtsuMultipleThresholdsImageFilter::GetLabelOffset() const

Set/Get the offset which labels have to start from. Default is 0.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::GetName "/**
std::string itk::simple::OtsuMultipleThresholdsImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::OtsuMultipleThresholdsImageFilter::GetNumberOfHistogramBins() const

Set/Get the number of histogram bins. Default is 128.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::GetNumberOfThresholds "/**
uint8_t itk::simple::OtsuMultipleThresholdsImageFilter::GetNumberOfThresholds() const

Set/Get the number of thresholds. Default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::GetThresholds "/**
std::vector<double> itk::simple::OtsuMultipleThresholdsImageFilter::GetThresholds() const

Get the computed threshold.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::GetValleyEmphasis "/**
bool itk::simple::OtsuMultipleThresholdsImageFilter::GetValleyEmphasis() const

Set/Get the use of valley emphasis. Default is false.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::OtsuMultipleThresholdsImageFilter "/**
itk::simple::OtsuMultipleThresholdsImageFilter::OtsuMultipleThresholdsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::SetLabelOffset "/**
Self& itk::simple::OtsuMultipleThresholdsImageFilter::SetLabelOffset(uint8_t LabelOffset)

Set/Get the offset which labels have to start from. Default is 0.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::OtsuMultipleThresholdsImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins. Default is 128.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::SetNumberOfThresholds "/**
Self& itk::simple::OtsuMultipleThresholdsImageFilter::SetNumberOfThresholds(uint8_t NumberOfThresholds)

Set/Get the number of thresholds. Default is 1.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::SetValleyEmphasis "/**
Self& itk::simple::OtsuMultipleThresholdsImageFilter::SetValleyEmphasis(bool ValleyEmphasis)

Set/Get the use of valley emphasis. Default is false.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::ToString "/**
std::string itk::simple::OtsuMultipleThresholdsImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::ValleyEmphasisOff "/**
Self& itk::simple::OtsuMultipleThresholdsImageFilter::ValleyEmphasisOff()
*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::ValleyEmphasisOn "/**
Self& itk::simple::OtsuMultipleThresholdsImageFilter::ValleyEmphasisOn()

Set the value of ValleyEmphasis to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuMultipleThresholdsImageFilter::~OtsuMultipleThresholdsImageFilter "/**
itk::simple::OtsuMultipleThresholdsImageFilter::~OtsuMultipleThresholdsImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::OtsuThresholdImageFilter "/**

Threshold an image using the Otsu Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the OtsuThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare
 Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/10380/3279 or http://www.insight-journal.org/browse/publication/811

Wiki Examples:

All Examples

Separate foreground and background using Otsu's method

See:
 HistogramThresholdImageFilter

 itk::simple::OtsuThreshold for the procedural interface

 itk::OtsuThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkOtsuThresholdImageFilter.h
*/"

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::Execute "/**
Image itk::simple::OtsuThresholdImageFilter::Execute(const Image &image, const Image &maskImage)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::Execute "/**
Image itk::simple::OtsuThresholdImageFilter::Execute(const Image &image)
*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::Execute "/**
Image itk::simple::OtsuThresholdImageFilter::Execute(const Image &image, const Image &maskImage, uint8_t insideValue,
uint8_t outsideValue, uint32_t numberOfHistogramBins, bool maskOutput,
uint8_t maskValue)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::Execute "/**
Image itk::simple::OtsuThresholdImageFilter::Execute(const Image &image, uint8_t insideValue, uint8_t outsideValue,
uint32_t numberOfHistogramBins, bool maskOutput, uint8_t maskValue)
*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetInsideValue "/**
uint8_t itk::simple::OtsuThresholdImageFilter::GetInsideValue() const

Get the \"inside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetMaskOutput "/**
bool itk::simple::OtsuThresholdImageFilter::GetMaskOutput() const
*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetMaskValue "/**
uint8_t itk::simple::OtsuThresholdImageFilter::GetMaskValue() const
*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetName "/**
std::string itk::simple::OtsuThresholdImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetNumberOfHistogramBins "/**
uint32_t itk::simple::OtsuThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetOutsideValue "/**
uint8_t itk::simple::OtsuThresholdImageFilter::GetOutsideValue() const

Get the \"outside\" pixel value.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::GetThreshold "/**
double itk::simple::OtsuThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::MaskOutputOff "/**
Self& itk::simple::OtsuThresholdImageFilter::MaskOutputOff()
*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::MaskOutputOn "/**
Self& itk::simple::OtsuThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::OtsuThresholdImageFilter "/**
itk::simple::OtsuThresholdImageFilter::OtsuThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::SetInsideValue "/**
Self& itk::simple::OtsuThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the \"inside\" pixel value. The default value NumericTraits<OutputPixelType>::max()

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::SetMaskOutput "/**
Self& itk::simple::OtsuThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::SetMaskValue "/**
Self& itk::simple::OtsuThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::SetNumberOfHistogramBins "/**
Self& itk::simple::OtsuThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins. Defaults is 128.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::SetOutsideValue "/**
Self& itk::simple::OtsuThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the \"outside\" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::ToString "/**
std::string itk::simple::OtsuThresholdImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::OtsuThresholdImageFilter::~OtsuThresholdImageFilter "/**
itk::simple::OtsuThresholdImageFilter::~OtsuThresholdImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::PasteImageFilter "/**

Paste an image into another image.


PasteImageFilter allows you to take a section of one image and paste into another
image. The SetDestinationIndex() method prescribes where in the first input to start pasting data from
the second input. The SetSourceRegion method prescribes the section of
the second image to paste into the first. If the output requested
region does not include the SourceRegion after it has been
repositioned to DestinationIndex, then the output will just be a copy
of the input.

The two inputs and output image will have the same pixel type.

Wiki Examples:

All Examples

Paste a part of one image into another image
See:
 itk::simple::Paste for the procedural interface

 itk::PasteImageFilter for the Doxygen on the original ITK class.



C++ includes: sitkPasteImageFilter.h
*/"

%javamethodmodifiers  itk::simple::PasteImageFilter::Execute "/**
Image itk::simple::PasteImageFilter::Execute(const Image &image1, const Image &image2)

Execute the filter on the input images

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::Execute "/**
Image itk::simple::PasteImageFilter::Execute(const Image &image1, const Image &image2, const std::vector< unsigned
int > &sourceSize, const std::vector< int > &sourceIndex, const
std::vector< int > &destinationIndex)

Execute the filter on the input images with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::GetDestinationIndex "/**
std::vector<int> itk::simple::PasteImageFilter::GetDestinationIndex() const

Set/Get the destination index (where in the first input the second
input will be pasted.

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::GetName "/**
std::string itk::simple::PasteImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::GetSourceIndex "/**
std::vector<int> itk::simple::PasteImageFilter::GetSourceIndex() const
*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::GetSourceSize "/**
std::vector<unsigned int> itk::simple::PasteImageFilter::GetSourceSize() const
*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::PasteImageFilter "/**
itk::simple::PasteImageFilter::PasteImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::SetDestinationIndex "/**
Self& itk::simple::PasteImageFilter::SetDestinationIndex(const std::vector< int > &DestinationIndex)

Set/Get the destination index (where in the first input the second
input will be pasted.

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::SetSourceIndex "/**
Self& itk::simple::PasteImageFilter::SetSourceIndex(const std::vector< int > &SourceIndex)
*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::SetSourceSize "/**
Self& itk::simple::PasteImageFilter::SetSourceSize(const std::vector< unsigned int > &SourceSize)
*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::ToString "/**
std::string itk::simple::PasteImageFilter::ToString() const

Print ourselves out

*/
public ";

%javamethodmodifiers  itk::simple::PasteImageFilter::~PasteImageFilter "/**
itk::simple::PasteImageFilter::~PasteImageFilter()

Destructor

*/
public ";


%typemap(javaimports) itk::simple::PatchBasedDenoisingImageFilter "/**

Derived class implementing a specific patch-based denoising algorithm,
as detailed below.


This class is derived from the base class PatchBasedDenoisingBaseImageFilter ; please refer to the documentation of the base class first. This
class implements a denoising filter that uses iterative non-local, or
semi-local, weighted averaging of image patches for image denoising.
The intensity at each pixel 'p' gets updated as a weighted average of
intensities of a chosen subset of pixels from the image.

This class implements the denoising algorithm using a Gaussian kernel
function for nonparametric density estimation. The class implements a
scheme to automatically estimated the kernel bandwidth parameter
(namely, sigma) using leave-one-out cross validation. It implements
schemes for random sampling of patches non-locally (from the entire
image) as well as semi-locally (from the spatial proximity of the
pixel being denoised at the specific point in time). It implements a
specific scheme for defining patch weights (mask) as described in
Awate and Whitaker 2005 IEEE CVPR and 2006 IEEE TPAMI.


See:
 PatchBasedDenoisingBaseImageFilter

 itk::PatchBasedDenoisingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkPatchBasedDenoisingImageFilter.h
*/"

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::AlwaysTreatComponentsAsEuclideanOff "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::AlwaysTreatComponentsAsEuclideanOff()
*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::AlwaysTreatComponentsAsEuclideanOn "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::AlwaysTreatComponentsAsEuclideanOn()

Set the value of AlwaysTreatComponentsAsEuclidean to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::Execute "/**
Image itk::simple::PatchBasedDenoisingImageFilter::Execute(const Image &image1)

Execute the filter on the input image

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::Execute "/**
Image itk::simple::PatchBasedDenoisingImageFilter::Execute(const Image &image1, double kernelBandwidthSigma, uint32_t
patchRadius, uint32_t numberOfIterations, uint32_t
numberOfSamplePatches, double sampleVariance,
PatchBasedDenoisingImageFilter::NoiseModelType noiseModel, double
noiseSigma, double noiseModelFidelityWeight, bool
alwaysTreatComponentsAsEuclidean, bool kernelBandwidthEstimation,
double kernelBandwidthMultiplicationFactor, uint32_t
kernelBandwidthUpdateFrequency, double
kernelBandwidthFractionPixelsForEstimation)

Execute the filter on the input image with the given parameters

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetAlwaysTreatComponentsAsEuclidean "/**
bool itk::simple::PatchBasedDenoisingImageFilter::GetAlwaysTreatComponentsAsEuclidean() const

Set/Get flag indicating whether all components should always be
treated as if they are in euclidean space regardless of pixel type.
Defaults to false.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthEstimation "/**
bool itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthEstimation() const

Set/Get flag indicating whether kernel-bandwidth should be estimated
automatically from the image data. Defaults to true.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthFractionPixelsForEstimation "/**
double itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthFractionPixelsForEstimation() const

Set/Get the fraction of the image to use for kernel bandwidth sigma
estimation. To reduce the computational burden for computing sigma, a
small random fraction of the image pixels can be used.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthMultiplicationFactor "/**
double itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthMultiplicationFactor() const

Set/Get the kernel bandwidth sigma multiplication factor used to
modify the automatically-estimated kernel bandwidth sigma. At times,
it may be desirable to modify the value of the automatically-estimated
sigma. Typically, this number isn't very far from 1. Note: This is
used only when KernelBandwidthEstimation is True/On.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthSigma "/**
double itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthSigma() const

Set/Get initial kernel bandwidth estimate. To prevent the class from
automatically modifying this estimate, set KernelBandwidthEstimation
to false in the base class.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthUpdateFrequency "/**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetKernelBandwidthUpdateFrequency() const

Set/Get the update frequency for the kernel bandwidth estimation. An
optimal bandwidth will be re-estimated based on the denoised image
after every 'n' iterations. Must be a positive integer. Defaults to 3,
i.e. bandwidth updated after every 3 denoising iteration.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetName "/**
std::string itk::simple::PatchBasedDenoisingImageFilter::GetName() const

Name of this class

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetNoiseModel "/**
NoiseModelType itk::simple::PatchBasedDenoisingImageFilter::GetNoiseModel() const

Set/Get the noise model type. Defaults to GAUSSIAN. To use the noise
model during denoising, FidelityWeight must be positive.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetNoiseModelFidelityWeight "/**
double itk::simple::PatchBasedDenoisingImageFilter::GetNoiseModelFidelityWeight() const

Set/Get the weight on the fidelity term (penalizes deviations from the
noisy data). This option is used when a noise model is specified. This
weight controls the balance between the smoothing and the closeness to
the noisy data.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetNoiseSigma "/**
double itk::simple::PatchBasedDenoisingImageFilter::GetNoiseSigma() const
*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetNumberOfIterations "/**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetNumberOfIterations() const

Set/Get the number of denoising iterations to perform. Must be a
positive integer. Defaults to 1.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetNumberOfSamplePatches "/**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetNumberOfSamplePatches() const
*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetPatchRadius "/**
uint32_t itk::simple::PatchBasedDenoisingImageFilter::GetPatchRadius() const

Set/Get the patch radius specified in physical coordinates. Patch
radius is preferably set to an even number. Currently, only isotropic
patches in physical space are allowed; patches can be anisotropic in
voxel space.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::GetSampleVariance "/**
double itk::simple::PatchBasedDenoisingImageFilter::GetSampleVariance() const

Set/Get the variance of the domain where patches are sampled.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::KernelBandwidthEstimationOff "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::KernelBandwidthEstimationOff()
*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::KernelBandwidthEstimationOn "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::KernelBandwidthEstimationOn()

Set the value of KernelBandwidthEstimation to true or false
respectfully.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::PatchBasedDenoisingImageFilter "/**
itk::simple::PatchBasedDenoisingImageFilter::PatchBasedDenoisingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetAlwaysTreatComponentsAsEuclidean "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetAlwaysTreatComponentsAsEuclidean(bool AlwaysTreatComponentsAsEuclidean)

Set/Get flag indicating whether all components should always be
treated as if they are in euclidean space regardless of pixel type.
Defaults to false.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthEstimation "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthEstimation(bool KernelBandwidthEstimation)

Set/Get flag indicating whether kernel-bandwidth should be estimated
automatically from the image data. Defaults to true.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthFractionPixelsForEstimation "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthFractionPixelsForEstimation(double KernelBandwidthFractionPixelsForEstimation)

Set/Get the fraction of the image to use for kernel bandwidth sigma
estimation. To reduce the computational burden for computing sigma, a
small random fraction of the image pixels can be used.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthMultiplicationFactor "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthMultiplicationFactor(double KernelBandwidthMultiplicationFactor)

Set/Get the kernel bandwidth sigma multiplication factor used to
modify the automatically-estimated kernel bandwidth sigma. At times,
it may be desirable to modify the value of the automatically-estimated
sigma. Typically, this number isn't very far from 1. Note: This is
used only when KernelBandwidthEstimation is True/On.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthSigma "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthSigma(double KernelBandwidthSigma)

Set/Get initial kernel bandwidth estimate. To prevent the class from
automatically modifying this estimate, set KernelBandwidthEstimation
to false in the base class.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthUpdateFrequency "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetKernelBandwidthUpdateFrequency(uint32_t KernelBandwidthUpdateFrequency)

Set/Get the update frequency for the kernel bandwidth estimation. An
optimal bandwidth will be re-estimated based on the denoised image
after every 'n' iterations. Must be a positive integer. Defaults to 3,
i.e. bandwidth updated after every 3 denoising iteration.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetNoiseModel "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetNoiseModel(NoiseModelType NoiseModel)

Set/Get the noise model type. Defaults to GAUSSIAN. To use the noise
model during denoising, FidelityWeight must be positive.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetNoiseModelFidelityWeight "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetNoiseModelFidelityWeight(double NoiseModelFidelityWeight)

Set/Get the weight on the fidelity term (penalizes deviations from the
noisy data). This option is used when a noise model is specified. This
weight controls the balance between the smoothing and the closeness to
the noisy data.

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoisingImageFilter::SetNoiseSigma "/**
Self& itk::simple::PatchBasedDenoisingImageFilter::SetNoiseSigma(double NoiseSigma)

Set/Get the noise sigma. Used by the noise model where appropriate,
defaults to 5% of the image intensity range

*/
public ";

%javamethodmodifiers  itk::simple::PatchBasedDenoising