/* BackgroundJob.c generated by valac 0.34.4, the Vala compiler
 * generated from BackgroundJob.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* This callback is executed when an associated BackgroundJob completes.  It is called from within*/
/* the Gtk event loop, *not* the background thread's context.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define TYPE_NOTIFICATION_OBJECT (notification_object_get_type ())
#define NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_OBJECT, NotificationObject))
#define NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_OBJECT, NotificationObjectClass))
#define IS_NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_OBJECT))
#define IS_NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_OBJECT))
#define NOTIFICATION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_OBJECT, NotificationObjectClass))

typedef struct _NotificationObject NotificationObject;
typedef struct _NotificationObjectClass NotificationObjectClass;
typedef struct _NotificationObjectPrivate NotificationObjectPrivate;
typedef struct _ParamSpecNotificationObject ParamSpecNotificationObject;

#define TYPE_INTERLOCKED_NOTIFICATION_OBJECT (interlocked_notification_object_get_type ())
#define INTERLOCKED_NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObject))
#define INTERLOCKED_NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObjectClass))
#define IS_INTERLOCKED_NOTIFICATION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INTERLOCKED_NOTIFICATION_OBJECT))
#define IS_INTERLOCKED_NOTIFICATION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INTERLOCKED_NOTIFICATION_OBJECT))
#define INTERLOCKED_NOTIFICATION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObjectClass))

typedef struct _InterlockedNotificationObject InterlockedNotificationObject;
typedef struct _InterlockedNotificationObjectClass InterlockedNotificationObjectClass;
typedef struct _InterlockedNotificationObjectPrivate InterlockedNotificationObjectPrivate;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_SEMAPHORE (semaphore_get_type ())
#define SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEMAPHORE, Semaphore))
#define SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEMAPHORE, SemaphoreClass))
#define IS_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEMAPHORE))
#define IS_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEMAPHORE))
#define SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEMAPHORE, SemaphoreClass))

typedef struct _Semaphore Semaphore;
typedef struct _SemaphoreClass SemaphoreClass;
#define _abstract_semaphore_unref0(var) ((var == NULL) ? NULL : (var = (abstract_semaphore_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())

#define BACKGROUND_JOB_TYPE_NOTIFICATION_JOB (background_job_notification_job_get_type ())
#define BACKGROUND_JOB_NOTIFICATION_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJob))
#define BACKGROUND_JOB_NOTIFICATION_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJobClass))
#define BACKGROUND_JOB_IS_NOTIFICATION_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB))
#define BACKGROUND_JOB_IS_NOTIFICATION_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB))
#define BACKGROUND_JOB_NOTIFICATION_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJobClass))

typedef struct _BackgroundJobNotificationJob BackgroundJobNotificationJob;
typedef struct _BackgroundJobNotificationJobClass BackgroundJobNotificationJobClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _background_job_notification_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_notification_job_unref (var), NULL)))
#define _notification_object_unref0(var) ((var == NULL) ? NULL : (var = (notification_object_unref (var), NULL)))
typedef struct _BackgroundJobNotificationJobPrivate BackgroundJobNotificationJobPrivate;
typedef struct _BackgroundJobParamSpecNotificationJob BackgroundJobParamSpecNotificationJob;
typedef struct _ParamSpecBackgroundJob ParamSpecBackgroundJob;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);
struct _NotificationObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotificationObjectPrivate * priv;
};

struct _NotificationObjectClass {
	GTypeClass parent_class;
	void (*finalize) (NotificationObject *self);
};

struct _ParamSpecNotificationObject {
	GParamSpec parent_instance;
};

struct _InterlockedNotificationObject {
	NotificationObject parent_instance;
	InterlockedNotificationObjectPrivate * priv;
};

struct _InterlockedNotificationObjectClass {
	NotificationObjectClass parent_class;
};

struct _InterlockedNotificationObjectPrivate {
	Semaphore* semaphore;
};

typedef void (*NotificationCallback) (BackgroundJob* job, NotificationObject* user, void* user_data);
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _BackgroundJobPrivate {
	GObject* owner;
	CompletionCallback callback;
	gpointer callback_target;
	GCancellable* cancellable;
	CancellationCallback cancellation;
	gpointer cancellation_target;
	BackgroundJob* self;
	AbstractSemaphore* semaphore;
	gint completion_priority;
	gint notification_priority;
};

struct _BackgroundJobNotificationJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobNotificationJobPrivate * priv;
	NotificationCallback callback;
	gpointer callback_target;
	BackgroundJob* background_job;
	NotificationObject* user;
};

struct _BackgroundJobNotificationJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJobNotificationJob *self);
};

struct _BackgroundJobParamSpecNotificationJob {
	GParamSpec parent_instance;
};

struct _ParamSpecBackgroundJob {
	GParamSpec parent_instance;
};


static gpointer notification_object_parent_class = NULL;
static gpointer interlocked_notification_object_parent_class = NULL;
static gpointer background_job_parent_class = NULL;
static GeeArrayList* background_job_notify_queue;
static GRecMutex __lock_background_job_notify_queue = {0};
static GeeArrayList* background_job_notify_queue = NULL;
static gpointer background_job_notification_job_parent_class = NULL;

gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
gpointer notification_object_ref (gpointer instance);
void notification_object_unref (gpointer instance);
GParamSpec* param_spec_notification_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notification_object (GValue* value, gpointer v_object);
void value_take_notification_object (GValue* value, gpointer v_object);
gpointer value_get_notification_object (const GValue* value);
GType notification_object_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFICATION_OBJECT_DUMMY_PROPERTY
};
NotificationObject* notification_object_construct (GType object_type);
static void notification_object_finalize (NotificationObject* obj);
GType interlocked_notification_object_get_type (void) G_GNUC_CONST;
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
GType semaphore_get_type (void) G_GNUC_CONST;
#define INTERLOCKED_NOTIFICATION_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObjectPrivate))
enum  {
	INTERLOCKED_NOTIFICATION_OBJECT_DUMMY_PROPERTY
};
Semaphore* semaphore_new (void);
Semaphore* semaphore_construct (GType object_type);
void interlocked_notification_object_internal_wait_for_completion (InterlockedNotificationObject* self);
void abstract_semaphore_wait (AbstractSemaphore* self);
void interlocked_notification_object_internal_completed (InterlockedNotificationObject* self);
void abstract_semaphore_notify (AbstractSemaphore* self);
InterlockedNotificationObject* interlocked_notification_object_construct (GType object_type);
static void interlocked_notification_object_finalize (NotificationObject* obj);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
#define BACKGROUND_JOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BACKGROUND_JOB, BackgroundJobPrivate))
enum  {
	BACKGROUND_JOB_DUMMY_PROPERTY
};
gint background_job_job_priority_compare (BackgroundJobJobPriority self, BackgroundJobJobPriority other);
gint background_job_job_priority_compare_func (void* a, void* b);
static gpointer background_job_notification_job_ref (gpointer instance);
static void background_job_notification_job_unref (gpointer instance);
static GParamSpec* background_job_param_spec_notification_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void background_job_value_set_notification_job (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void background_job_value_take_notification_job (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer background_job_value_get_notification_job (const GValue* value) G_GNUC_UNUSED;
static GType background_job_notification_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore);
void background_job_execute (BackgroundJob* self);
static void background_job_real_execute (BackgroundJob* self);
BackgroundJobJobPriority background_job_get_priority (BackgroundJob* self);
static BackgroundJobJobPriority background_job_real_get_priority (BackgroundJob* self);
gint background_job_priority_compare_func (BackgroundJob* a, BackgroundJob* b);
gint64 background_job_priority_comparator (void* a, void* b);
void background_job_set_completion_priority (BackgroundJob* self, gint priority);
void background_job_set_notification_priority (BackgroundJob* self, gint priority);
void background_job_wait_for_completion (BackgroundJob* self);
GCancellable* background_job_get_cancellable (BackgroundJob* self);
gboolean background_job_is_cancelled (BackgroundJob* self);
void background_job_cancel (BackgroundJob* self);
void background_job_internal_notify_completion (BackgroundJob* self);
static gboolean background_job_on_notify_completion (BackgroundJob* self);
static gboolean _background_job_on_notify_completion_gsource_func (gpointer self);
void background_job_notify (BackgroundJob* self, NotificationCallback callback, void* callback_target, NotificationObject* user);
static BackgroundJobNotificationJob* background_job_notification_job_new (NotificationCallback callback, void* callback_target, BackgroundJob* background_job, NotificationObject* user);
static BackgroundJobNotificationJob* background_job_notification_job_construct (GType object_type, NotificationCallback callback, void* callback_target, BackgroundJob* background_job, NotificationObject* user);
static gboolean background_job_on_notification_ready (BackgroundJob* self);
static gboolean _background_job_on_notification_ready_gsource_func (gpointer self);
enum  {
	BACKGROUND_JOB_NOTIFICATION_JOB_DUMMY_PROPERTY
};
static void background_job_notification_job_finalize (BackgroundJobNotificationJob* obj);
static void background_job_finalize (BackgroundJob* obj);


NotificationObject* notification_object_construct (GType object_type) {
	NotificationObject* self = NULL;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = (NotificationObject*) g_type_create_instance (object_type);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self;
#line 283 "BackgroundJob.c"
}


static void value_notification_object_init (GValue* value) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	value->data[0].v_pointer = NULL;
#line 290 "BackgroundJob.c"
}


static void value_notification_object_free_value (GValue* value) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (value->data[0].v_pointer) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		notification_object_unref (value->data[0].v_pointer);
#line 299 "BackgroundJob.c"
	}
}


static void value_notification_object_copy_value (const GValue* src_value, GValue* dest_value) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (src_value->data[0].v_pointer) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		dest_value->data[0].v_pointer = notification_object_ref (src_value->data[0].v_pointer);
#line 309 "BackgroundJob.c"
	} else {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		dest_value->data[0].v_pointer = NULL;
#line 313 "BackgroundJob.c"
	}
}


static gpointer value_notification_object_peek_pointer (const GValue* value) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return value->data[0].v_pointer;
#line 321 "BackgroundJob.c"
}


static gchar* value_notification_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (collect_values[0].v_pointer) {
#line 328 "BackgroundJob.c"
		NotificationObject* object;
		object = collect_values[0].v_pointer;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (object->parent_instance.g_class == NULL) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 335 "BackgroundJob.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 339 "BackgroundJob.c"
		}
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = notification_object_ref (object);
#line 343 "BackgroundJob.c"
	} else {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 347 "BackgroundJob.c"
	}
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return NULL;
#line 351 "BackgroundJob.c"
}


static gchar* value_notification_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	NotificationObject** object_p;
	object_p = collect_values[0].v_pointer;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (!object_p) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 362 "BackgroundJob.c"
	}
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (!value->data[0].v_pointer) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = NULL;
#line 368 "BackgroundJob.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = value->data[0].v_pointer;
#line 372 "BackgroundJob.c"
	} else {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = notification_object_ref (value->data[0].v_pointer);
#line 376 "BackgroundJob.c"
	}
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return NULL;
#line 380 "BackgroundJob.c"
}


GParamSpec* param_spec_notification_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotificationObject* spec;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFICATION_OBJECT), NULL);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return G_PARAM_SPEC (spec);
#line 394 "BackgroundJob.c"
}


gpointer value_get_notification_object (const GValue* value) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFICATION_OBJECT), NULL);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return value->data[0].v_pointer;
#line 403 "BackgroundJob.c"
}


void value_set_notification_object (GValue* value, gpointer v_object) {
	NotificationObject* old;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFICATION_OBJECT));
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (v_object) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFICATION_OBJECT));
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = v_object;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		notification_object_ref (value->data[0].v_pointer);
#line 423 "BackgroundJob.c"
	} else {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 427 "BackgroundJob.c"
	}
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (old) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		notification_object_unref (old);
#line 433 "BackgroundJob.c"
	}
}


void value_take_notification_object (GValue* value, gpointer v_object) {
	NotificationObject* old;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFICATION_OBJECT));
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	old = value->data[0].v_pointer;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (v_object) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFICATION_OBJECT));
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = v_object;
#line 452 "BackgroundJob.c"
	} else {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 456 "BackgroundJob.c"
	}
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (old) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		notification_object_unref (old);
#line 462 "BackgroundJob.c"
	}
}


static void notification_object_class_init (NotificationObjectClass * klass) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	notification_object_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	((NotificationObjectClass *) klass)->finalize = notification_object_finalize;
#line 472 "BackgroundJob.c"
}


static void notification_object_instance_init (NotificationObject * self) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->ref_count = 1;
#line 479 "BackgroundJob.c"
}


static void notification_object_finalize (NotificationObject* obj) {
	NotificationObject * self;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATION_OBJECT, NotificationObject);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_signal_handlers_destroy (self);
#line 489 "BackgroundJob.c"
}


GType notification_object_get_type (void) {
	static volatile gsize notification_object_type_id__volatile = 0;
	if (g_once_init_enter (&notification_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notification_object_init, value_notification_object_free_value, value_notification_object_copy_value, value_notification_object_peek_pointer, "p", value_notification_object_collect_value, "p", value_notification_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotificationObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notification_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationObject), 0, (GInstanceInitFunc) notification_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notification_object_type_id;
		notification_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NotificationObject", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&notification_object_type_id__volatile, notification_object_type_id);
	}
	return notification_object_type_id__volatile;
}


gpointer notification_object_ref (gpointer instance) {
	NotificationObject* self;
	self = instance;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_atomic_int_inc (&self->ref_count);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return instance;
#line 514 "BackgroundJob.c"
}


void notification_object_unref (gpointer instance) {
	NotificationObject* self;
	self = instance;
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		NOTIFICATION_OBJECT_GET_CLASS (self)->finalize (self);
#line 34 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 527 "BackgroundJob.c"
	}
}


void interlocked_notification_object_internal_wait_for_completion (InterlockedNotificationObject* self) {
	Semaphore* _tmp0_ = NULL;
#line 41 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_INTERLOCKED_NOTIFICATION_OBJECT (self));
#line 42 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = self->priv->semaphore;
#line 42 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	abstract_semaphore_wait (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 540 "BackgroundJob.c"
}


void interlocked_notification_object_internal_completed (InterlockedNotificationObject* self) {
	Semaphore* _tmp0_ = NULL;
#line 46 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_INTERLOCKED_NOTIFICATION_OBJECT (self));
#line 47 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = self->priv->semaphore;
#line 47 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	abstract_semaphore_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 552 "BackgroundJob.c"
}


InterlockedNotificationObject* interlocked_notification_object_construct (GType object_type) {
	InterlockedNotificationObject* self = NULL;
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = (InterlockedNotificationObject*) notification_object_construct (object_type);
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self;
#line 562 "BackgroundJob.c"
}


static void interlocked_notification_object_class_init (InterlockedNotificationObjectClass * klass) {
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	interlocked_notification_object_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	((NotificationObjectClass *) klass)->finalize = interlocked_notification_object_finalize;
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_type_class_add_private (klass, sizeof (InterlockedNotificationObjectPrivate));
#line 573 "BackgroundJob.c"
}


static void interlocked_notification_object_instance_init (InterlockedNotificationObject * self) {
	Semaphore* _tmp0_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv = INTERLOCKED_NOTIFICATION_OBJECT_GET_PRIVATE (self);
#line 38 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = semaphore_new ();
#line 38 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->semaphore = _tmp0_;
#line 585 "BackgroundJob.c"
}


static void interlocked_notification_object_finalize (NotificationObject* obj) {
	InterlockedNotificationObject * self;
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INTERLOCKED_NOTIFICATION_OBJECT, InterlockedNotificationObject);
#line 38 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_abstract_semaphore_unref0 (self->priv->semaphore);
#line 37 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	NOTIFICATION_OBJECT_CLASS (interlocked_notification_object_parent_class)->finalize (obj);
#line 597 "BackgroundJob.c"
}


GType interlocked_notification_object_get_type (void) {
	static volatile gsize interlocked_notification_object_type_id__volatile = 0;
	if (g_once_init_enter (&interlocked_notification_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (InterlockedNotificationObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) interlocked_notification_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InterlockedNotificationObject), 0, (GInstanceInitFunc) interlocked_notification_object_instance_init, NULL };
		GType interlocked_notification_object_type_id;
		interlocked_notification_object_type_id = g_type_register_static (TYPE_NOTIFICATION_OBJECT, "InterlockedNotificationObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&interlocked_notification_object_type_id__volatile, interlocked_notification_object_type_id);
	}
	return interlocked_notification_object_type_id__volatile;
}


gint background_job_job_priority_compare (BackgroundJobJobPriority self, BackgroundJobJobPriority other) {
	gint result = 0;
	BackgroundJobJobPriority _tmp0_ = 0;
#line 75 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = other;
#line 75 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = ((gint) _tmp0_) - ((gint) self);
#line 75 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 622 "BackgroundJob.c"
}


gint background_job_job_priority_compare_func (void* a, void* b) {
	gint result = 0;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = b;
#line 79 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = a;
#line 79 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = ((gint) _tmp0_) - ((gint) _tmp1_);
#line 79 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 638 "BackgroundJob.c"
}


GType background_job_job_priority_get_type (void) {
	static volatile gsize background_job_job_priority_type_id__volatile = 0;
	if (g_once_init_enter (&background_job_job_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{BACKGROUND_JOB_JOB_PRIORITY_HIGHEST, "BACKGROUND_JOB_JOB_PRIORITY_HIGHEST", "highest"}, {BACKGROUND_JOB_JOB_PRIORITY_HIGH, "BACKGROUND_JOB_JOB_PRIORITY_HIGH", "high"}, {BACKGROUND_JOB_JOB_PRIORITY_NORMAL, "BACKGROUND_JOB_JOB_PRIORITY_NORMAL", "normal"}, {BACKGROUND_JOB_JOB_PRIORITY_LOW, "BACKGROUND_JOB_JOB_PRIORITY_LOW", "low"}, {BACKGROUND_JOB_JOB_PRIORITY_LOWEST, "BACKGROUND_JOB_JOB_PRIORITY_LOWEST", "lowest"}, {0, NULL, NULL}};
		GType background_job_job_priority_type_id;
		background_job_job_priority_type_id = g_enum_register_static ("BackgroundJobJobPriority", values);
		g_once_init_leave (&background_job_job_priority_type_id__volatile, background_job_job_priority_type_id);
	}
	return background_job_job_priority_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 116 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self ? g_object_ref (self) : NULL;
#line 657 "BackgroundJob.c"
}


static gpointer _abstract_semaphore_ref0 (gpointer self) {
#line 120 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self ? abstract_semaphore_ref (self) : NULL;
#line 664 "BackgroundJob.c"
}


BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore) {
	BackgroundJob* self = NULL;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	CompletionCallback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	CancellationCallback _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	AbstractSemaphore* _tmp6_ = NULL;
	AbstractSemaphore* _tmp7_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail ((owner == NULL) || G_IS_OBJECT (owner), NULL);
#line 113 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), NULL);
#line 113 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail ((completion_semaphore == NULL) || IS_ABSTRACT_SEMAPHORE (completion_semaphore), NULL);
#line 113 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = (BackgroundJob*) g_type_create_instance (object_type);
#line 116 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = owner;
#line 116 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 116 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_g_object_unref0 (self->priv->owner);
#line 116 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->owner = _tmp1_;
#line 117 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp2_ = callback;
#line 117 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp2__target = callback_target;
#line 117 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->callback = _tmp2_;
#line 117 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->callback_target = _tmp2__target;
#line 118 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp3_ = cancellable;
#line 118 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 118 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 118 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->cancellable = _tmp4_;
#line 119 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp5_ = cancellation;
#line 119 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp5__target = cancellation_target;
#line 119 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->cancellation = _tmp5_;
#line 119 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->cancellation_target = _tmp5__target;
#line 120 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp6_ = completion_semaphore;
#line 120 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp7_ = _abstract_semaphore_ref0 (_tmp6_);
#line 120 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_abstract_semaphore_unref0 (self->priv->semaphore);
#line 120 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->semaphore = _tmp7_;
#line 113 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self;
#line 730 "BackgroundJob.c"
}


static void background_job_real_execute (BackgroundJob* self) {
#line 123 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_critical ("Type `%s' does not implement abstract method `background_job_execute'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 123 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return;
#line 739 "BackgroundJob.c"
}


void background_job_execute (BackgroundJob* self) {
#line 123 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 123 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	BACKGROUND_JOB_GET_CLASS (self)->execute (self);
#line 748 "BackgroundJob.c"
}


static BackgroundJobJobPriority background_job_real_get_priority (BackgroundJob* self) {
	BackgroundJobJobPriority result = 0;
#line 126 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = BACKGROUND_JOB_JOB_PRIORITY_NORMAL;
#line 126 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 758 "BackgroundJob.c"
}


BackgroundJobJobPriority background_job_get_priority (BackgroundJob* self) {
#line 125 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), 0);
#line 125 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return BACKGROUND_JOB_GET_CLASS (self)->get_priority (self);
#line 767 "BackgroundJob.c"
}


gint background_job_priority_compare_func (BackgroundJob* a, BackgroundJob* b) {
	gint result = 0;
	BackgroundJob* _tmp0_ = NULL;
	BackgroundJobJobPriority _tmp1_ = 0;
	BackgroundJob* _tmp2_ = NULL;
	BackgroundJobJobPriority _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 130 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (a), 0);
#line 130 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (b), 0);
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = a;
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = background_job_get_priority (_tmp0_);
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp2_ = b;
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp3_ = background_job_get_priority (_tmp2_);
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp4_ = background_job_job_priority_compare (_tmp1_, _tmp3_);
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = _tmp4_;
#line 131 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 796 "BackgroundJob.c"
}


gint64 background_job_priority_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 136 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = a;
#line 136 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = b;
#line 136 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp2_ = background_job_priority_compare_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BACKGROUND_JOB, BackgroundJob), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 136 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = (gint64) _tmp2_;
#line 136 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 815 "BackgroundJob.c"
}


void background_job_set_completion_priority (BackgroundJob* self, gint priority) {
	gint _tmp0_ = 0;
#line 140 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 141 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = priority;
#line 141 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->completion_priority = _tmp0_;
#line 827 "BackgroundJob.c"
}


void background_job_set_notification_priority (BackgroundJob* self, gint priority) {
	gint _tmp0_ = 0;
#line 145 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 146 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = priority;
#line 146 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->notification_priority = _tmp0_;
#line 839 "BackgroundJob.c"
}


void background_job_wait_for_completion (BackgroundJob* self) {
	AbstractSemaphore* _tmp0_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 153 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = self->priv->semaphore;
#line 153 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp0_ != NULL) {
#line 851 "BackgroundJob.c"
		AbstractSemaphore* _tmp1_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp1_ = self->priv->semaphore;
#line 154 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		abstract_semaphore_wait (_tmp1_);
#line 857 "BackgroundJob.c"
	}
}


GCancellable* background_job_get_cancellable (BackgroundJob* self) {
	GCancellable* result = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), NULL);
#line 158 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = self->priv->cancellable;
#line 158 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 158 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = _tmp1_;
#line 158 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 876 "BackgroundJob.c"
}


gboolean background_job_is_cancelled (BackgroundJob* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), FALSE);
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = self->priv->cancellable;
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp1_ != NULL) {
#line 890 "BackgroundJob.c"
		GCancellable* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp2_ = self->priv->cancellable;
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp0_ = _tmp3_;
#line 899 "BackgroundJob.c"
	} else {
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp0_ = FALSE;
#line 903 "BackgroundJob.c"
	}
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = _tmp0_;
#line 162 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 909 "BackgroundJob.c"
}


void background_job_cancel (BackgroundJob* self) {
	GCancellable* _tmp0_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 166 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = self->priv->cancellable;
#line 166 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp0_ != NULL) {
#line 921 "BackgroundJob.c"
		GCancellable* _tmp1_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp1_ = self->priv->cancellable;
#line 167 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_cancellable_cancel (_tmp1_);
#line 927 "BackgroundJob.c"
	}
}


static gpointer _background_job_ref0 (gpointer self) {
#line 183 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self ? background_job_ref (self) : NULL;
#line 935 "BackgroundJob.c"
}


static gboolean _background_job_on_notify_completion_gsource_func (gpointer self) {
	gboolean result;
	result = background_job_on_notify_completion ((BackgroundJob*) self);
#line 185 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 944 "BackgroundJob.c"
}


void background_job_internal_notify_completion (BackgroundJob* self) {
	AbstractSemaphore* _tmp0_ = NULL;
	gboolean _tmp2_ = FALSE;
	CompletionCallback _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	BackgroundJob* _tmp8_ = NULL;
	gint _tmp9_ = 0;
#line 171 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 172 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = self->priv->semaphore;
#line 172 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp0_ != NULL) {
#line 963 "BackgroundJob.c"
		AbstractSemaphore* _tmp1_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp1_ = self->priv->semaphore;
#line 173 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		abstract_semaphore_notify (_tmp1_);
#line 969 "BackgroundJob.c"
	}
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp3_ = self->priv->callback;
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp3__target = self->priv->callback_target;
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp3_ == NULL) {
#line 977 "BackgroundJob.c"
		CancellationCallback _tmp4_ = NULL;
		void* _tmp4__target = NULL;
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp4_ = self->priv->cancellation;
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp4__target = self->priv->cancellation_target;
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp2_ = _tmp4_ == NULL;
#line 986 "BackgroundJob.c"
	} else {
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp2_ = FALSE;
#line 990 "BackgroundJob.c"
	}
#line 175 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp2_) {
#line 176 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		return;
#line 996 "BackgroundJob.c"
	}
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp6_ = background_job_is_cancelled (self);
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp6_) {
#line 1002 "BackgroundJob.c"
		CancellationCallback _tmp7_ = NULL;
		void* _tmp7__target = NULL;
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp7_ = self->priv->cancellation;
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp7__target = self->priv->cancellation_target;
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp5_ = _tmp7_ == NULL;
#line 1011 "BackgroundJob.c"
	} else {
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp5_ = FALSE;
#line 1015 "BackgroundJob.c"
	}
#line 178 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp5_) {
#line 179 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		return;
#line 1021 "BackgroundJob.c"
	}
#line 183 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp8_ = _background_job_ref0 (self);
#line 183 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_background_job_unref0 (self->priv->self);
#line 183 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->self = _tmp8_;
#line 185 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp9_ = self->priv->completion_priority;
#line 185 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_idle_add_full (_tmp9_, _background_job_on_notify_completion_gsource_func, background_job_ref (self), background_job_unref);
#line 1033 "BackgroundJob.c"
}


static gboolean background_job_on_notify_completion (BackgroundJob* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 188 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), FALSE);
#line 193 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = background_job_is_cancelled (self);
#line 193 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp0_) {
#line 1046 "BackgroundJob.c"
		CancellationCallback _tmp1_ = NULL;
		void* _tmp1__target = NULL;
#line 194 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp1_ = self->priv->cancellation;
#line 194 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp1__target = self->priv->cancellation_target;
#line 194 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (_tmp1_ != NULL) {
#line 1055 "BackgroundJob.c"
			CancellationCallback _tmp2_ = NULL;
			void* _tmp2__target = NULL;
#line 195 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp2_ = self->priv->cancellation;
#line 195 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp2__target = self->priv->cancellation_target;
#line 195 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp2_ (self, _tmp2__target);
#line 1064 "BackgroundJob.c"
		}
	} else {
		CompletionCallback _tmp3_ = NULL;
		void* _tmp3__target = NULL;
#line 197 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp3_ = self->priv->callback;
#line 197 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp3__target = self->priv->callback_target;
#line 197 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (_tmp3_ != NULL) {
#line 1075 "BackgroundJob.c"
			CompletionCallback _tmp4_ = NULL;
			void* _tmp4__target = NULL;
#line 198 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp4_ = self->priv->callback;
#line 198 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp4__target = self->priv->callback_target;
#line 198 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp4_ (self, _tmp4__target);
#line 1084 "BackgroundJob.c"
		}
	}
#line 202 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_background_job_unref0 (self->priv->self);
#line 202 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->self = NULL;
#line 204 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = FALSE;
#line 204 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 1095 "BackgroundJob.c"
}


static gboolean _background_job_on_notification_ready_gsource_func (gpointer self) {
	gboolean result;
	result = background_job_on_notification_ready ((BackgroundJob*) self);
#line 214 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 1104 "BackgroundJob.c"
}


static gpointer _notification_object_ref0 (gpointer self) {
#line 218 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self ? notification_object_ref (self) : NULL;
#line 1111 "BackgroundJob.c"
}


void background_job_notify (BackgroundJob* self, NotificationCallback callback, void* callback_target, NotificationObject* user) {
	gint _tmp7_ = 0;
	InterlockedNotificationObject* interlocked = NULL;
	NotificationObject* _tmp8_ = NULL;
	InterlockedNotificationObject* _tmp9_ = NULL;
	InterlockedNotificationObject* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 209 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (self));
#line 209 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail ((user == NULL) || IS_NOTIFICATION_OBJECT (user));
#line 1126 "BackgroundJob.c"
	{
		GeeArrayList* _tmp0_ = NULL;
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp0_ = background_job_notify_queue;
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_rec_mutex_lock (&__lock_background_job_notify_queue);
#line 1133 "BackgroundJob.c"
		{
			GeeArrayList* _tmp1_ = NULL;
			NotificationCallback _tmp2_ = NULL;
			void* _tmp2__target = NULL;
			NotificationObject* _tmp3_ = NULL;
			BackgroundJobNotificationJob* _tmp4_ = NULL;
			BackgroundJobNotificationJob* _tmp5_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp1_ = background_job_notify_queue;
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp2_ = callback;
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp2__target = callback_target;
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp3_ = user;
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp4_ = background_job_notification_job_new (_tmp2_, _tmp2__target, self, _tmp3_);
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp5_ = _tmp4_;
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp5_);
#line 211 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_background_job_notification_job_unref0 (_tmp5_);
#line 1157 "BackgroundJob.c"
		}
		__finally13:
		{
			GeeArrayList* _tmp6_ = NULL;
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp6_ = background_job_notify_queue;
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			g_rec_mutex_unlock (&__lock_background_job_notify_queue);
#line 1166 "BackgroundJob.c"
		}
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			g_clear_error (&_inner_error_);
#line 210 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return;
#line 1176 "BackgroundJob.c"
		}
	}
#line 214 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp7_ = self->priv->notification_priority;
#line 214 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_idle_add_full (_tmp7_, _background_job_on_notification_ready_gsource_func, background_job_ref (self), background_job_unref);
#line 218 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp8_ = user;
#line 218 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp9_ = _notification_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_INTERLOCKED_NOTIFICATION_OBJECT) ? ((InterlockedNotificationObject*) _tmp8_) : NULL);
#line 218 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	interlocked = _tmp9_;
#line 219 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp10_ = interlocked;
#line 219 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp10_ != NULL) {
#line 1193 "BackgroundJob.c"
		InterlockedNotificationObject* _tmp11_ = NULL;
#line 220 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp11_ = interlocked;
#line 220 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		interlocked_notification_object_internal_wait_for_completion (_tmp11_);
#line 1199 "BackgroundJob.c"
	}
#line 209 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_notification_object_unref0 (interlocked);
#line 1203 "BackgroundJob.c"
}


static gboolean background_job_on_notification_ready (BackgroundJob* self) {
	gboolean result = FALSE;
	BackgroundJobNotificationJob* notification_job = NULL;
	BackgroundJobNotificationJob* _tmp7_ = NULL;
	BackgroundJobNotificationJob* _tmp8_ = NULL;
	NotificationCallback _tmp9_ = NULL;
	void* _tmp9__target = NULL;
	BackgroundJobNotificationJob* _tmp10_ = NULL;
	BackgroundJob* _tmp11_ = NULL;
	BackgroundJobNotificationJob* _tmp12_ = NULL;
	NotificationObject* _tmp13_ = NULL;
	InterlockedNotificationObject* interlocked = NULL;
	BackgroundJobNotificationJob* _tmp14_ = NULL;
	NotificationObject* _tmp15_ = NULL;
	InterlockedNotificationObject* _tmp16_ = NULL;
	InterlockedNotificationObject* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (self), FALSE);
#line 226 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	notification_job = NULL;
#line 1228 "BackgroundJob.c"
	{
		GeeArrayList* _tmp0_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp0_ = background_job_notify_queue;
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_rec_mutex_lock (&__lock_background_job_notify_queue);
#line 1235 "BackgroundJob.c"
		{
			GeeArrayList* _tmp1_ = NULL;
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
#line 228 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp1_ = background_job_notify_queue;
#line 228 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 228 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp3_ = _tmp2_;
#line 228 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			if (_tmp3_ > 0) {
#line 1248 "BackgroundJob.c"
				GeeArrayList* _tmp4_ = NULL;
				gpointer _tmp5_ = NULL;
#line 229 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
				_tmp4_ = background_job_notify_queue;
#line 229 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
				_tmp5_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 229 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
				_background_job_notification_job_unref0 (notification_job);
#line 229 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
				notification_job = (BackgroundJobNotificationJob*) _tmp5_;
#line 1259 "BackgroundJob.c"
			}
		}
		__finally14:
		{
			GeeArrayList* _tmp6_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_tmp6_ = background_job_notify_queue;
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			g_rec_mutex_unlock (&__lock_background_job_notify_queue);
#line 1269 "BackgroundJob.c"
		}
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			_background_job_notification_job_unref0 (notification_job);
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			g_clear_error (&_inner_error_);
#line 227 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return FALSE;
#line 1281 "BackgroundJob.c"
		}
	}
#line 231 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp7_ = notification_job;
#line 231 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_vala_assert (_tmp7_ != NULL, "notification_job != null");
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp8_ = notification_job;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp9_ = _tmp8_->callback;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp9__target = _tmp8_->callback_target;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp10_ = notification_job;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp11_ = _tmp10_->background_job;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp12_ = notification_job;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp13_ = _tmp12_->user;
#line 233 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp9_ (_tmp11_, _tmp13_, _tmp9__target);
#line 236 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp14_ = notification_job;
#line 236 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp15_ = _tmp14_->user;
#line 236 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp16_ = _notification_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, TYPE_INTERLOCKED_NOTIFICATION_OBJECT) ? ((InterlockedNotificationObject*) _tmp15_) : NULL);
#line 236 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	interlocked = _tmp16_;
#line 237 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp17_ = interlocked;
#line 237 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (_tmp17_ != NULL) {
#line 1316 "BackgroundJob.c"
		InterlockedNotificationObject* _tmp18_ = NULL;
#line 238 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		_tmp18_ = interlocked;
#line 238 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		interlocked_notification_object_internal_completed (_tmp18_);
#line 1322 "BackgroundJob.c"
	}
#line 240 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	result = FALSE;
#line 240 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_notification_object_unref0 (interlocked);
#line 240 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_background_job_notification_job_unref0 (notification_job);
#line 240 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return result;
#line 1332 "BackgroundJob.c"
}


static BackgroundJobNotificationJob* background_job_notification_job_construct (GType object_type, NotificationCallback callback, void* callback_target, BackgroundJob* background_job, NotificationObject* user) {
	BackgroundJobNotificationJob* self = NULL;
	NotificationCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	BackgroundJob* _tmp1_ = NULL;
	BackgroundJob* _tmp2_ = NULL;
	NotificationObject* _tmp3_ = NULL;
	NotificationObject* _tmp4_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (IS_BACKGROUND_JOB (background_job), NULL);
#line 88 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail ((user == NULL) || IS_NOTIFICATION_OBJECT (user), NULL);
#line 88 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = (BackgroundJobNotificationJob*) g_type_create_instance (object_type);
#line 90 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = callback;
#line 90 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0__target = callback_target;
#line 90 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->callback = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->callback_target = _tmp0__target;
#line 91 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp1_ = background_job;
#line 91 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp2_ = _background_job_ref0 (_tmp1_);
#line 91 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_background_job_unref0 (self->background_job);
#line 91 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->background_job = _tmp2_;
#line 92 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp3_ = user;
#line 92 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp4_ = _notification_object_ref0 (_tmp3_);
#line 92 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_notification_object_unref0 (self->user);
#line 92 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->user = _tmp4_;
#line 88 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return self;
#line 1376 "BackgroundJob.c"
}


static BackgroundJobNotificationJob* background_job_notification_job_new (NotificationCallback callback, void* callback_target, BackgroundJob* background_job, NotificationObject* user) {
#line 88 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return background_job_notification_job_construct (BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, callback, callback_target, background_job, user);
#line 1383 "BackgroundJob.c"
}


static void background_job_value_notification_job_init (GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	value->data[0].v_pointer = NULL;
#line 1390 "BackgroundJob.c"
}


static void background_job_value_notification_job_free_value (GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_notification_job_unref (value->data[0].v_pointer);
#line 1399 "BackgroundJob.c"
	}
}


static void background_job_value_notification_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (src_value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		dest_value->data[0].v_pointer = background_job_notification_job_ref (src_value->data[0].v_pointer);
#line 1409 "BackgroundJob.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1413 "BackgroundJob.c"
	}
}


static gpointer background_job_value_notification_job_peek_pointer (const GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return value->data[0].v_pointer;
#line 1421 "BackgroundJob.c"
}


static gchar* background_job_value_notification_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (collect_values[0].v_pointer) {
#line 1428 "BackgroundJob.c"
		BackgroundJobNotificationJob* object;
		object = collect_values[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (object->parent_instance.g_class == NULL) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1435 "BackgroundJob.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1439 "BackgroundJob.c"
		}
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = background_job_notification_job_ref (object);
#line 1443 "BackgroundJob.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 1447 "BackgroundJob.c"
	}
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return NULL;
#line 1451 "BackgroundJob.c"
}


static gchar* background_job_value_notification_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BackgroundJobNotificationJob** object_p;
	object_p = collect_values[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (!object_p) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1462 "BackgroundJob.c"
	}
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (!value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = NULL;
#line 1468 "BackgroundJob.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = value->data[0].v_pointer;
#line 1472 "BackgroundJob.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = background_job_notification_job_ref (value->data[0].v_pointer);
#line 1476 "BackgroundJob.c"
	}
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return NULL;
#line 1480 "BackgroundJob.c"
}


static GParamSpec* background_job_param_spec_notification_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BackgroundJobParamSpecNotificationJob* spec;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB), NULL);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return G_PARAM_SPEC (spec);
#line 1494 "BackgroundJob.c"
}


static gpointer background_job_value_get_notification_job (const GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB), NULL);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return value->data[0].v_pointer;
#line 1503 "BackgroundJob.c"
}


static void background_job_value_set_notification_job (GValue* value, gpointer v_object) {
	BackgroundJobNotificationJob* old;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	old = value->data[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (v_object) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = v_object;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_notification_job_ref (value->data[0].v_pointer);
#line 1523 "BackgroundJob.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 1527 "BackgroundJob.c"
	}
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (old) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_notification_job_unref (old);
#line 1533 "BackgroundJob.c"
	}
}


static void background_job_value_take_notification_job (GValue* value, gpointer v_object) {
	BackgroundJobNotificationJob* old;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	old = value->data[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (v_object) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB));
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = v_object;
#line 1552 "BackgroundJob.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 1556 "BackgroundJob.c"
	}
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (old) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_notification_job_unref (old);
#line 1562 "BackgroundJob.c"
	}
}


static void background_job_notification_job_class_init (BackgroundJobNotificationJobClass * klass) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	background_job_notification_job_parent_class = g_type_class_peek_parent (klass);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	((BackgroundJobNotificationJobClass *) klass)->finalize = background_job_notification_job_finalize;
#line 1572 "BackgroundJob.c"
}


static void background_job_notification_job_instance_init (BackgroundJobNotificationJob * self) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->ref_count = 1;
#line 1579 "BackgroundJob.c"
}


static void background_job_notification_job_finalize (BackgroundJobNotificationJob* obj) {
	BackgroundJobNotificationJob * self;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, BackgroundJobNotificationJob);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_signal_handlers_destroy (self);
#line 85 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_background_job_unref0 (self->background_job);
#line 86 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_notification_object_unref0 (self->user);
#line 1593 "BackgroundJob.c"
}


static GType background_job_notification_job_get_type (void) {
	static volatile gsize background_job_notification_job_type_id__volatile = 0;
	if (g_once_init_enter (&background_job_notification_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { background_job_value_notification_job_init, background_job_value_notification_job_free_value, background_job_value_notification_job_copy_value, background_job_value_notification_job_peek_pointer, "p", background_job_value_notification_job_collect_value, "p", background_job_value_notification_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BackgroundJobNotificationJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_job_notification_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundJobNotificationJob), 0, (GInstanceInitFunc) background_job_notification_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType background_job_notification_job_type_id;
		background_job_notification_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackgroundJobNotificationJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&background_job_notification_job_type_id__volatile, background_job_notification_job_type_id);
	}
	return background_job_notification_job_type_id__volatile;
}


static gpointer background_job_notification_job_ref (gpointer instance) {
	BackgroundJobNotificationJob* self;
	self = instance;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_atomic_int_inc (&self->ref_count);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return instance;
#line 1618 "BackgroundJob.c"
}


static void background_job_notification_job_unref (gpointer instance) {
	BackgroundJobNotificationJob* self;
	self = instance;
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		BACKGROUND_JOB_NOTIFICATION_JOB_GET_CLASS (self)->finalize (self);
#line 83 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1631 "BackgroundJob.c"
	}
}


static void value_background_job_init (GValue* value) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	value->data[0].v_pointer = NULL;
#line 1639 "BackgroundJob.c"
}


static void value_background_job_free_value (GValue* value) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (value->data[0].v_pointer) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_unref (value->data[0].v_pointer);
#line 1648 "BackgroundJob.c"
	}
}


static void value_background_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (src_value->data[0].v_pointer) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		dest_value->data[0].v_pointer = background_job_ref (src_value->data[0].v_pointer);
#line 1658 "BackgroundJob.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1662 "BackgroundJob.c"
	}
}


static gpointer value_background_job_peek_pointer (const GValue* value) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return value->data[0].v_pointer;
#line 1670 "BackgroundJob.c"
}


static gchar* value_background_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (collect_values[0].v_pointer) {
#line 1677 "BackgroundJob.c"
		BackgroundJob* object;
		object = collect_values[0].v_pointer;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		if (object->parent_instance.g_class == NULL) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1684 "BackgroundJob.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1688 "BackgroundJob.c"
		}
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = background_job_ref (object);
#line 1692 "BackgroundJob.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 1696 "BackgroundJob.c"
	}
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return NULL;
#line 1700 "BackgroundJob.c"
}


static gchar* value_background_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BackgroundJob** object_p;
	object_p = collect_values[0].v_pointer;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (!object_p) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1711 "BackgroundJob.c"
	}
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (!value->data[0].v_pointer) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = NULL;
#line 1717 "BackgroundJob.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = value->data[0].v_pointer;
#line 1721 "BackgroundJob.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		*object_p = background_job_ref (value->data[0].v_pointer);
#line 1725 "BackgroundJob.c"
	}
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return NULL;
#line 1729 "BackgroundJob.c"
}


GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBackgroundJob* spec;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKGROUND_JOB), NULL);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return G_PARAM_SPEC (spec);
#line 1743 "BackgroundJob.c"
}


gpointer value_get_background_job (const GValue* value) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND_JOB), NULL);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return value->data[0].v_pointer;
#line 1752 "BackgroundJob.c"
}


void value_set_background_job (GValue* value, gpointer v_object) {
	BackgroundJob* old;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND_JOB));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	old = value->data[0].v_pointer;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (v_object) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKGROUND_JOB));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = v_object;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_ref (value->data[0].v_pointer);
#line 1772 "BackgroundJob.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 1776 "BackgroundJob.c"
	}
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (old) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_unref (old);
#line 1782 "BackgroundJob.c"
	}
}


void value_take_background_job (GValue* value, gpointer v_object) {
	BackgroundJob* old;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND_JOB));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	old = value->data[0].v_pointer;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (v_object) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKGROUND_JOB));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = v_object;
#line 1801 "BackgroundJob.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		value->data[0].v_pointer = NULL;
#line 1805 "BackgroundJob.c"
	}
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (old) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		background_job_unref (old);
#line 1811 "BackgroundJob.c"
	}
}


static void background_job_class_init (BackgroundJobClass * klass) {
	GeeArrayList* _tmp0_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	background_job_parent_class = g_type_class_peek_parent (klass);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	((BackgroundJobClass *) klass)->finalize = background_job_finalize;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_type_class_add_private (klass, sizeof (BackgroundJobPrivate));
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	((BackgroundJobClass *) klass)->execute = background_job_real_execute;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	((BackgroundJobClass *) klass)->get_priority = background_job_real_get_priority;
#line 96 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_rec_mutex_init (&__lock_background_job_notify_queue);
#line 96 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_tmp0_ = gee_array_list_new (BACKGROUND_JOB_TYPE_NOTIFICATION_JOB, (GBoxedCopyFunc) background_job_notification_job_ref, background_job_notification_job_unref, NULL, NULL, NULL);
#line 96 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	background_job_notify_queue = _tmp0_;
#line 1834 "BackgroundJob.c"
}


static void background_job_instance_init (BackgroundJob * self) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv = BACKGROUND_JOB_GET_PRIVATE (self);
#line 102 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->self = NULL;
#line 103 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->semaphore = NULL;
#line 110 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->completion_priority = G_PRIORITY_HIGH;
#line 111 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->priv->notification_priority = G_PRIORITY_DEFAULT_IDLE;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self->ref_count = 1;
#line 1851 "BackgroundJob.c"
}


static void background_job_finalize (BackgroundJob* obj) {
	BackgroundJob * self;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKGROUND_JOB, BackgroundJob);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_signal_handlers_destroy (self);
#line 98 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_g_object_unref0 (self->priv->owner);
#line 100 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 102 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_background_job_unref0 (self->priv->self);
#line 103 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	_abstract_semaphore_unref0 (self->priv->semaphore);
#line 1869 "BackgroundJob.c"
}


GType background_job_get_type (void) {
	static volatile gsize background_job_type_id__volatile = 0;
	if (g_once_init_enter (&background_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_background_job_init, value_background_job_free_value, value_background_job_copy_value, value_background_job_peek_pointer, "p", value_background_job_collect_value, "p", value_background_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BackgroundJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundJob), 0, (GInstanceInitFunc) background_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType background_job_type_id;
		background_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackgroundJob", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&background_job_type_id__volatile, background_job_type_id);
	}
	return background_job_type_id__volatile;
}


gpointer background_job_ref (gpointer instance) {
	BackgroundJob* self;
	self = instance;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	g_atomic_int_inc (&self->ref_count);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	return instance;
#line 1894 "BackgroundJob.c"
}


void background_job_unref (gpointer instance) {
	BackgroundJob* self;
	self = instance;
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		BACKGROUND_JOB_GET_CLASS (self)->finalize (self);
#line 65 "/home/jens/Source/shotwell/src/threads/BackgroundJob.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1907 "BackgroundJob.c"
	}
}



