#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: mason_splicing
class: CommandLineTool
cwlVersion: v1.0
doc: "Create transcripts from IN.fa using the annotations from IN.gff.  The resulting\
  \ transcripts are written to OUT.fa.\nYou can pass an optional VCF file IN.vcf and\
  \ the transcripts will be created from the haplotypes stored in the VCF file.\n\n\
  \n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Low verbosity.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Low verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Higher verbosity.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Higher verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Highest verbosity.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Highest verbosity.
  type:
  - 'null'
  - string
- default: '0'
  doc: Seed for random number generation.
  id: param_seed
  inputBinding:
    prefix: -seed
  label: Seed for random number generation.
  type:
  - 'null'
  - int
- doc: Filename for out output file
  id: param_out_filename
  inputBinding:
    prefix: -out
  label: Filename for out output file
  type: string
- default: /
  doc: String separating contig name from haplotype number.
  id: param_haplotype-name-sep
  inputBinding:
    prefix: -haplotype-name-sep
  label: String separating contig name from haplotype number.
  type:
  - 'null'
  - string
- doc: Path to input GFF or GTF file, must be sorted by reference name.
  id: param_in-gff
  inputBinding:
    prefix: -in-gff
  label: Path to input GFF or GTF file, must be sorted by reference name.
  type: File
- default: exon
  doc: Splicing will filter to the records that have this type.
  id: param_gff-type
  inputBinding:
    prefix: -gff-type
  label: Splicing will filter to the records that have this type.
  type:
  - 'null'
  - File
- default: Parent
  doc: Assign features to their parent using the tag with this name.
  id: param_gff-group-by
  inputBinding:
    prefix: -gff-group-by
  label: Assign features to their parent using the tag with this name.
  type:
  - 'null'
  - File
- doc: Path to FASTA file to read the reference from.
  id: param_input-reference
  inputBinding:
    prefix: -input-reference
  label: Path to FASTA file to read the reference from.
  type: File
- doc: Path to the VCF file with variants to apply.
  id: param_input-vcf
  inputBinding:
    prefix: -input-vcf
  label: Path to the VCF file with variants to apply.
  type:
  - 'null'
  - File
label: Generating Transcripts
outputs:
- doc: Output of materialized contigs.
  id: param_out
  label: Output of materialized contigs.
  outputBinding:
    glob: $(inputs.param_out_filename)
  type: File
