#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: mason_frag_sequencing
class: CommandLineTool
cwlVersion: v1.0
doc: "Given a FASTA file with fragments, simulate sequencing thereof.\nThis program\
  \ is a more lightweight version of mason_sequencing without support for the application\
  \ of VCF and fragment sampling.  Output of SAM is also not available.  However,\
  \ it uses the same code for the simulation of the reads as the more powerful mason_simulator.\n\
  You can use mason_frag_sequencing if you want to implement you rown fragmentation\
  \ behaviour, e.g. if you have implemented your own bias models.\n\n\n\nFor more\
  \ information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Low verbosity.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Low verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Higher verbosity.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Higher verbosity.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Highest verbosity.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Highest verbosity.
  type:
  - 'null'
  - string
- default: '0'
  doc: Seed to use for random number generator.
  id: param_seed
  inputBinding:
    prefix: -seed
  label: Seed to use for random number generator.
  type:
  - 'null'
  - int
- doc: Path to input file.
  id: param_in
  inputBinding:
    prefix: -in
  label: Path to input file.
  type: File
- doc: Filename for out output file
  id: param_out_filename
  inputBinding:
    prefix: -out
  label: Filename for out output file
  type: string
- doc: Filename for out-right output file
  id: param_out-right_filename
  inputBinding:
    prefix: -out-right
  label: Filename for out-right output file
  type:
  - 'null'
  - string
- default: 'false'
  doc: Force single-end simulation although --out-right is given.
  id: param_force-single-end
  inputBinding:
    prefix: -force-single-end
  label: Force single-end simulation although --out-right is given.
  type:
  - 'null'
  - string
- default: illumina
  doc: Set sequencing technology to simulate.
  id: param_seq-technology
  inputBinding:
    prefix: -seq-technology
  label: Set sequencing technology to simulate.
  type:
  - 'null'
  - string
- default: FR
  doc: Orientation for paired reads.  See section Read Orientation below.
  id: param_seq-mate-orientation
  inputBinding:
    prefix: -seq-mate-orientation
  label: Orientation for paired reads.  See section Read Orientation below.
  type:
  - 'null'
  - string
- default: both
  doc: Strands to simulate from, only applicable to paired sequencing simulation.
  id: param_seq-strands
  inputBinding:
    prefix: -seq-strands
  label: Strands to simulate from, only applicable to paired sequencing simulation.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Whether or not to embed read information.
  id: param_embed-read-info
  inputBinding:
    prefix: -embed-read-info
  label: Whether or not to embed read information.
  type:
  - 'null'
  - string
- default: simulated.
  doc: Read names will have this prefix.
  id: param_read-name-prefix
  inputBinding:
    prefix: -read-name-prefix
  label: Read names will have this prefix.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable BS-seq simulation.
  id: param_enable-bs-seq
  inputBinding:
    prefix: -enable-bs-seq
  label: Enable BS-seq simulation.
  type:
  - 'null'
  - string
- default: directional
  doc: Protocol to use for BS-Seq simulation.
  id: param_bs-seq-protocol
  inputBinding:
    prefix: -bs-seq-protocol
  label: Protocol to use for BS-Seq simulation.
  type:
  - 'null'
  - string
- default: '0.99'
  doc: Conversion rate for unmethylated Cs to become Ts.
  id: param_bs-seq-conversion-rate
  inputBinding:
    prefix: -bs-seq-conversion-rate
  label: Conversion rate for unmethylated Cs to become Ts.
  type:
  - 'null'
  - double
- default: '100'
  doc: Read length for Illumina simulation.
  id: param_illumina-read-length
  inputBinding:
    prefix: -illumina-read-length
  label: Read length for Illumina simulation.
  type:
  - 'null'
  - int
- doc: Path to file with Illumina error profile.  The file must be a text file with
    floating point numbers separated by space, each giving a positional error rate.
  id: param_illumina-error-profile-file
  inputBinding:
    prefix: -illumina-error-profile-file
  label: Path to file with Illumina error profile.  The file must be a text file with
    floating point numbers separated by space, each giving a positional error rate.
  type:
  - 'null'
  - File
- default: '5e-05'
  doc: Insert per-base probability for insertion in Illumina sequencing.
  id: param_illumina-prob-insert
  inputBinding:
    prefix: -illumina-prob-insert
  label: Insert per-base probability for insertion in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '5e-05'
  doc: Insert per-base probability for deletion in Illumina sequencing.
  id: param_illumina-prob-deletion
  inputBinding:
    prefix: -illumina-prob-deletion
  label: Insert per-base probability for deletion in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '1.0'
  doc: Scaling factor for Illumina mismatch probability.
  id: param_illumina-prob-mismatch-scale
  inputBinding:
    prefix: -illumina-prob-mismatch-scale
  label: Scaling factor for Illumina mismatch probability.
  type:
  - 'null'
  - double
- default: '0.004'
  doc: Average per-base mismatch probability in Illumina sequencing.
  id: param_illumina-prob-mismatch
  inputBinding:
    prefix: -illumina-prob-mismatch
  label: Average per-base mismatch probability in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '0.002'
  doc: Per-base mismatch probability of first base in Illumina sequencing.
  id: param_illumina-prob-mismatch-begin
  inputBinding:
    prefix: -illumina-prob-mismatch-begin
  label: Per-base mismatch probability of first base in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '0.012'
  doc: Per-base mismatch probability of last base in Illumina sequencing.
  id: param_illumina-prob-mismatch-end
  inputBinding:
    prefix: -illumina-prob-mismatch-end
  label: Per-base mismatch probability of last base in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '0.66'
  doc: Point where the error curve raises in relation to read length.
  id: param_illumina-position-raise
  inputBinding:
    prefix: -illumina-position-raise
  label: Point where the error curve raises in relation to read length.
  type:
  - 'null'
  - double
- default: '40.0'
  doc: Mean PHRED quality for non-mismatch bases of first base in Illumina sequencing.
  id: param_illumina-quality-mean-begin
  inputBinding:
    prefix: -illumina-quality-mean-begin
  label: Mean PHRED quality for non-mismatch bases of first base in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '39.5'
  doc: Mean PHRED quality for non-mismatch bases of last base in Illumina sequencing.
  id: param_illumina-quality-mean-end
  inputBinding:
    prefix: -illumina-quality-mean-end
  label: Mean PHRED quality for non-mismatch bases of last base in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '0.05'
  doc: Standard deviation of PHRED quality for non-mismatch bases of first base in
    Illumina sequencing.
  id: param_illumina-quality-stddev-begin
  inputBinding:
    prefix: -illumina-quality-stddev-begin
  label: Standard deviation of PHRED quality for non-mismatch bases of first base
    in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '10.0'
  doc: Standard deviation of PHRED quality for non-mismatch bases of last base in
    Illumina sequencing.
  id: param_illumina-quality-stddev-end
  inputBinding:
    prefix: -illumina-quality-stddev-end
  label: Standard deviation of PHRED quality for non-mismatch bases of last base in
    Illumina sequencing.
  type:
  - 'null'
  - double
- default: '40.0'
  doc: Mean PHRED quality for mismatch bases of first base in Illumina sequencing.
  id: param_illumina-mismatch-quality-mean-begin
  inputBinding:
    prefix: -illumina-mismatch-quality-mean-begin
  label: Mean PHRED quality for mismatch bases of first base in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '30.0'
  doc: Mean PHRED quality for mismatch bases of last base in Illumina sequencing.
  id: param_illumina-mismatch-quality-mean-end
  inputBinding:
    prefix: -illumina-mismatch-quality-mean-end
  label: Mean PHRED quality for mismatch bases of last base in Illumina sequencing.
  type:
  - 'null'
  - double
- default: '3.0'
  doc: Standard deviation of PHRED quality for mismatch bases of first base in Illumina
    sequencing.
  id: param_illumina-mismatch-quality-stddev-begin
  inputBinding:
    prefix: -illumina-mismatch-quality-stddev-begin
  label: Standard deviation of PHRED quality for mismatch bases of first base in Illumina
    sequencing.
  type:
  - 'null'
  - double
- default: '15.0'
  doc: Standard deviation of PHRED quality for mismatch bases of last base in Illumina
    sequencing.
  id: param_illumina-mismatch-quality-stddev-end
  inputBinding:
    prefix: -illumina-mismatch-quality-stddev-end
  label: Standard deviation of PHRED quality for mismatch bases of last base in Illumina
    sequencing.
  type:
  - 'null'
  - double
- doc: FASTQ file to use for a template for left-end reads.
  id: param_illumina-left-template-fastq
  inputBinding:
    prefix: -illumina-left-template-fastq
  label: FASTQ file to use for a template for left-end reads.
  type:
  - 'null'
  - File
- doc: FASTQ file to use for a template for right-end reads.
  id: param_illumina-right-template-fastq
  inputBinding:
    prefix: -illumina-right-template-fastq
  label: FASTQ file to use for a template for right-end reads.
  type:
  - 'null'
  - File
- default: normal
  doc: The model to use for sampling the Sanger read length.
  id: param_sanger-read-length-model
  inputBinding:
    prefix: -sanger-read-length-model
  label: The model to use for sampling the Sanger read length.
  type:
  - 'null'
  - string
- default: '400'
  doc: The minimal read length when the read length is sampled uniformly.
  id: param_sanger-read-length-min
  inputBinding:
    prefix: -sanger-read-length-min
  label: The minimal read length when the read length is sampled uniformly.
  type:
  - 'null'
  - int
- default: '600'
  doc: The maximal read length when the read length is sampled uniformly.
  id: param_sanger-read-length-max
  inputBinding:
    prefix: -sanger-read-length-max
  label: The maximal read length when the read length is sampled uniformly.
  type:
  - 'null'
  - int
- default: '400.0'
  doc: The mean read length when the read length is sampled with normal distribution.
  id: param_sanger-read-length-mean
  inputBinding:
    prefix: -sanger-read-length-mean
  label: The mean read length when the read length is sampled with normal distribution.
  type:
  - 'null'
  - double
- default: '40.0'
  doc: The read length standard deviation when the read length is sampled uniformly.
  id: param_sanger-read-length-error
  inputBinding:
    prefix: -sanger-read-length-error
  label: The read length standard deviation when the read length is sampled uniformly.
  type:
  - 'null'
  - double
- default: '1.0'
  doc: Scaling factor for Sanger mismatch probability.
  id: param_sanger-prob-mismatch-scale
  inputBinding:
    prefix: -sanger-prob-mismatch-scale
  label: Scaling factor for Sanger mismatch probability.
  type:
  - 'null'
  - double
- default: '0.005'
  doc: Per-base mismatch probability of first base in Sanger sequencing.
  id: param_sanger-prob-mismatch-begin
  inputBinding:
    prefix: -sanger-prob-mismatch-begin
  label: Per-base mismatch probability of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '0.001'
  doc: Per-base mismatch probability of last base in Sanger sequencing.
  id: param_sanger-prob-mismatch-end
  inputBinding:
    prefix: -sanger-prob-mismatch-end
  label: Per-base mismatch probability of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '0.0025'
  doc: Per-base insertion probability of first base in Sanger sequencing.
  id: param_sanger-prob-insertion-begin
  inputBinding:
    prefix: -sanger-prob-insertion-begin
  label: Per-base insertion probability of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '0.005'
  doc: Per-base insertion probability of last base in Sanger sequencing.
  id: param_sanger-prob-insertion-end
  inputBinding:
    prefix: -sanger-prob-insertion-end
  label: Per-base insertion probability of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '0.0025'
  doc: Per-base deletion probability of first base in Sanger sequencing.
  id: param_sanger-prob-deletion-begin
  inputBinding:
    prefix: -sanger-prob-deletion-begin
  label: Per-base deletion probability of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '0.005'
  doc: Per-base deletion probability of last base in Sanger sequencing.
  id: param_sanger-prob-deletion-end
  inputBinding:
    prefix: -sanger-prob-deletion-end
  label: Per-base deletion probability of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '40.0'
  doc: Mean PHRED quality for non-mismatch bases of first base in Sanger sequencing.
  id: param_sanger-quality-match-start-mean
  inputBinding:
    prefix: -sanger-quality-match-start-mean
  label: Mean PHRED quality for non-mismatch bases of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '39.5'
  doc: Mean PHRED quality for non-mismatch bases of last base in Sanger sequencing.
  id: param_sanger-quality-match-end-mean
  inputBinding:
    prefix: -sanger-quality-match-end-mean
  label: Mean PHRED quality for non-mismatch bases of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '0.1'
  doc: Mean PHRED quality for non-mismatch bases of first base in Sanger sequencing.
  id: param_sanger-quality-match-start-stddev
  inputBinding:
    prefix: -sanger-quality-match-start-stddev
  label: Mean PHRED quality for non-mismatch bases of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '2.0'
  doc: Mean PHRED quality for non-mismatch bases of last base in Sanger sequencing.
  id: param_sanger-quality-match-end-stddev
  inputBinding:
    prefix: -sanger-quality-match-end-stddev
  label: Mean PHRED quality for non-mismatch bases of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '30.0'
  doc: Mean PHRED quality for erroneous bases of first base in Sanger sequencing.
  id: param_sanger-quality-error-start-mean
  inputBinding:
    prefix: -sanger-quality-error-start-mean
  label: Mean PHRED quality for erroneous bases of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '20.0'
  doc: Mean PHRED quality for erroneous bases of last base in Sanger sequencing.
  id: param_sanger-quality-error-end-mean
  inputBinding:
    prefix: -sanger-quality-error-end-mean
  label: Mean PHRED quality for erroneous bases of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '2.0'
  doc: Mean PHRED quality for erroneous bases of first base in Sanger sequencing.
  id: param_sanger-quality-error-start-stddev
  inputBinding:
    prefix: -sanger-quality-error-start-stddev
  label: Mean PHRED quality for erroneous bases of first base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: '5.0'
  doc: Mean PHRED quality for erroneous bases of last base in Sanger sequencing.
  id: param_sanger-quality-error-end-stddev
  inputBinding:
    prefix: -sanger-quality-error-end-stddev
  label: Mean PHRED quality for erroneous bases of last base in Sanger sequencing.
  type:
  - 'null'
  - double
- default: normal
  doc: The model to use for sampling the 454 read length.
  id: param_454-read-length-model
  inputBinding:
    prefix: -454-read-length-model
  label: The model to use for sampling the 454 read length.
  type:
  - 'null'
  - string
- default: '10'
  doc: The minimal read length when the read length is sampled uniformly.
  id: param_454-read-length-min
  inputBinding:
    prefix: -454-read-length-min
  label: The minimal read length when the read length is sampled uniformly.
  type:
  - 'null'
  - int
- default: '600'
  doc: The maximal read length when the read length is sampled uniformly.
  id: param_454-read-length-max
  inputBinding:
    prefix: -454-read-length-max
  label: The maximal read length when the read length is sampled uniformly.
  type:
  - 'null'
  - int
- default: '400.0'
  doc: The mean read length when the read length is sampled with normal distribution.
  id: param_454-read-length-mean
  inputBinding:
    prefix: -454-read-length-mean
  label: The mean read length when the read length is sampled with normal distribution.
  type:
  - 'null'
  - double
- default: '40.0'
  doc: The read length standard deviation when the read length is sampled with normal
    distribution.
  id: param_454-read-length-stddev
  inputBinding:
    prefix: -454-read-length-stddev
  label: The read length standard deviation when the read length is sampled with normal
    distribution.
  type:
  - 'null'
  - double
- default: 'false'
  doc: For error model, if set then (sigma = k * r)) is used, otherwise (sigma = k
    * sqrt(r)).
  id: param_454-no-sqrt-in-std-dev
  inputBinding:
    prefix: -454-no-sqrt-in-std-dev
  label: For error model, if set then (sigma = k * r)) is used, otherwise (sigma =
    k * sqrt(r)).
  type:
  - 'null'
  - string
- default: '0.15'
  doc: Proportionality factor for calculating the standard deviation proportional
    to the read length.
  id: param_454-proportionality-factor
  inputBinding:
    prefix: -454-proportionality-factor
  label: Proportionality factor for calculating the standard deviation proportional
    to the read length.
  type:
  - 'null'
  - double
- default: '0.23'
  doc: Mean of lognormal distribution to use for the noise.
  id: param_454-background-noise-mean
  inputBinding:
    prefix: -454-background-noise-mean
  label: Mean of lognormal distribution to use for the noise.
  type:
  - 'null'
  - double
- default: '0.15'
  doc: Standard deviation of lognormal distribution to use for the noise.
  id: param_454-background-noise-stddev
  inputBinding:
    prefix: -454-background-noise-stddev
  label: Standard deviation of lognormal distribution to use for the noise.
  type:
  - 'null'
  - double
label: Fragment Sequencing Simulation
outputs:
- doc: Output of single-end/left end reads.
  id: param_out
  label: Output of single-end/left end reads.
  outputBinding:
    glob: $(inputs.param_out_filename)
  type: File
- doc: Output of right reads.  Giving this options enables paired-end simulation.
  id: param_out-right
  label: Output of right reads.  Giving this options enables paired-end simulation.
  outputBinding:
    glob: $(inputs.param_out-right_filename)
  type:
  - 'null'
  - File
