// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "frame3dtruecolor.h"
#include "fitsimage.h"
#include "ps.h"

Frame3dTrueColor::Frame3dTrueColor(Tcl_Interp* i, Tk_Canvas c, Tk_Item* item)
  : Frame3dBase(i,c,item), Frame3d(i,c,item), Frame3dTrue(i,c,item)
{
  colormapData = NULL;
}

Frame3dTrueColor::~Frame3dTrueColor()
{
  if (colormapData)
    delete [] colormapData;
}

void Frame3dTrueColor::buildXImage(XImage* ximage, Coord::InternalSystem sys)
{
  // we need a colorScale before we can render
  if (!validColorScale())
    return;

  unsigned char* img = fillImage(ximage->width, ximage->height, sys);
  if (img) {
    encodeTrueColor(img, ximage);
    delete [] img;
  }
}

// Commands

void Frame3dTrueColor::colormapCmd(int id, float b, float c, int i, 
				 unsigned short* index, unsigned char* cells, 
				 int cnt)
{
  cmapID = id;
  bias = b;
  contrast = c;
  invert = i;

  updateColorCells(index, cells, cnt);
  updateColorScale();
  update(BASE);
}

void Frame3dTrueColor::colormapEndCmd()
{
  update(BASE);
}
