/* rygel-media-export-query-container-factory.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-media-export-query-container-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;
typedef struct _RygelMediaExportQueryContainerFactoryPrivate RygelMediaExportQueryContainerFactoryPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_query_container_factory_properties[RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER (rygel_media_export_leaf_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainer))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_LEAF_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_LEAF_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_LEAF_QUERY_CONTAINER, RygelMediaExportLeafQueryContainerClass))

typedef struct _RygelMediaExportLeafQueryContainer RygelMediaExportLeafQueryContainer;
typedef struct _RygelMediaExportLeafQueryContainerClass RygelMediaExportLeafQueryContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER (rygel_media_export_node_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainer))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_NODE_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_NODE_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_NODE_QUERY_CONTAINER, RygelMediaExportNodeQueryContainerClass))

typedef struct _RygelMediaExportNodeQueryContainer RygelMediaExportNodeQueryContainer;
typedef struct _RygelMediaExportNodeQueryContainerClass RygelMediaExportNodeQueryContainerClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

struct _RygelMediaExportQueryContainerFactory {
	GObject parent_instance;
	RygelMediaExportQueryContainerFactoryPrivate * priv;
};

struct _RygelMediaExportQueryContainerFactoryClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportQueryContainerFactoryPrivate {
	GeeHashMap* virtual_container_map;
};


static gpointer rygel_media_export_query_container_factory_parent_class = NULL;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance;
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_instance = NULL;

GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryPrivate))
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_new (void);
static RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_construct (GType object_type);
void rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self,
                                                             gchar* * id);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self,
                                                                                    const gchar* hash);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self,
                                                                                                  const gchar* id,
                                                                                                  const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self,
                                                                                                       const gchar* definition_id,
                                                                                                       const gchar* name);
static RygelSearchExpression* rygel_media_export_query_container_factory_parse_description (const gchar* description,
                                                                                     gchar* * pattern,
                                                                                     gchar* * attribute,
                                                                                     gchar* * upnp_class,
                                                                                     gchar* * name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_new (RygelSearchExpression* expression,
                                                                                 const gchar* id,
                                                                                 const gchar* name);
RygelMediaExportLeafQueryContainer* rygel_media_export_leaf_query_container_construct (GType object_type,
                                                                                       RygelSearchExpression* expression,
                                                                                       const gchar* id,
                                                                                       const gchar* name);
GType rygel_media_export_leaf_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_new (RygelSearchExpression* expression,
                                                                                 const gchar* id,
                                                                                 const gchar* name,
                                                                                 const gchar* template,
                                                                                 const gchar* attribute);
RygelMediaExportNodeQueryContainer* rygel_media_export_node_query_container_construct (GType object_type,
                                                                                       RygelSearchExpression* expression,
                                                                                       const gchar* id,
                                                                                       const gchar* name,
                                                                                       const gchar* template,
                                                                                       const gchar* attribute);
GType rygel_media_export_node_query_container_get_type (void) G_GNUC_CONST;
static gchar* rygel_media_export_query_container_factory_map_upnp_class (const gchar* attribute);
static void rygel_media_export_query_container_factory_update_search_expression (RygelSearchExpression* * expression,
                                                                          const gchar* key,
                                                                          const gchar* value);
static void rygel_media_export_query_container_factory_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportQueryContainerFactory*
rygel_media_export_query_container_factory_get_default (void)
{
	RygelMediaExportQueryContainerFactory* result = NULL;
	RygelMediaExportQueryContainerFactory* _tmp0_;
	RygelMediaExportQueryContainerFactory* _tmp2_;
	RygelMediaExportQueryContainerFactory* _tmp3_;
	_tmp0_ = rygel_media_export_query_container_factory_instance;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		RygelMediaExportQueryContainerFactory* _tmp1_;
		_tmp1_ = rygel_media_export_query_container_factory_new ();
		_g_object_unref0 (rygel_media_export_query_container_factory_instance);
		rygel_media_export_query_container_factory_instance = _tmp1_;
	}
	_tmp2_ = rygel_media_export_query_container_factory_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static RygelMediaExportQueryContainerFactory*
rygel_media_export_query_container_factory_construct (GType object_type)
{
	RygelMediaExportQueryContainerFactory * self = NULL;
	GeeHashMap* _tmp0_;
	self = (RygelMediaExportQueryContainerFactory*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->virtual_container_map);
	self->priv->virtual_container_map = _tmp0_;
	return self;
}


static RygelMediaExportQueryContainerFactory*
rygel_media_export_query_container_factory_new (void)
{
	return rygel_media_export_query_container_factory_construct (RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY);
}


/**
     * Register a plaintext description for a query container. The passed
     * string will be modified to the checksum id of the container.
     *
     * @param id Originally contains the plaintext id which is replaced with
     *           the hashed id on return.
     */
void
rygel_media_export_query_container_factory_register_id (RygelMediaExportQueryContainerFactory* self,
                                                        gchar* * id)
{
	gchar* md5 = NULL;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*id != NULL);
	_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, *id, (gsize) -1);
	md5 = _tmp0_;
	_tmp1_ = self->priv->virtual_container_map;
	_tmp2_ = md5;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_)) {
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->virtual_container_map;
		_tmp4_ = md5;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp4_, *id);
		_tmp5_ = md5;
		g_debug ("rygel-media-export-query-container-factory.vala:61: Registering %s for" \
" %s", _tmp5_, *id);
	}
	_tmp6_ = md5;
	_tmp7_ = g_strconcat (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp6_, NULL);
	_g_free0 (*id);
	*id = _tmp7_;
	_g_free0 (md5);
}


/**
     * Get the plaintext definition from a hashed id.
     *
     * Inverse function of register_id().
     *
     * @param hash A hashed id
     * @return the plaintext defintion of the virtual folder
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch45_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally45;
	__catch45_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally45:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar*
rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self,
                                                                             const gchar* hash)
{
	gchar* result = NULL;
	gchar* id = NULL;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash != NULL, NULL);
	_tmp0_ = string_replace (hash, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	id = _tmp0_;
	_tmp1_ = self->priv->virtual_container_map;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, id);
	result = (gchar*) _tmp2_;
	_g_free0 (id);
	return result;
}


/**
     * Factory method.
     *
     * Create a QueryContainer directly from MD5 hashed id.
     *
     * @param id    The hashed id of the container
     * @param name  An the title of the container. If not supplied, it will
     *              be derived from the plain-text description of the
     *              container
     * @return A new instance of QueryContainer or null if id does not exist
     */
RygelMediaExportQueryContainer*
rygel_media_export_query_container_factory_create_from_hashed_id (RygelMediaExportQueryContainerFactory* self,
                                                                  const gchar* id,
                                                                  const gchar* name)
{
	RygelMediaExportQueryContainer* result = NULL;
	gchar* definition_id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaExportQueryContainer* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = rygel_media_export_query_container_factory_get_virtual_container_definition (self, id);
	definition_id = _tmp0_;
	_tmp1_ = definition_id;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (definition_id);
		return result;
	}
	_tmp2_ = definition_id;
	_tmp3_ = rygel_media_export_query_container_factory_create_from_description_id (self, _tmp2_, name);
	result = _tmp3_;
	_g_free0 (definition_id);
	return result;
}


/**
     * Factory method.
     *
     * Create a QueryContainer from a plain-text description string.
     *
     * @param definition Plain-text defintion of the query-container
     * @param name       The title of the container. If not supplied, it
     *                   will be derived from the plain-text description of
     *                   the container
     * @return A new instance of QueryContainer
     */
RygelMediaExportQueryContainer*
rygel_media_export_query_container_factory_create_from_description_id (RygelMediaExportQueryContainerFactory* self,
                                                                       const gchar* definition_id,
                                                                       const gchar* name)
{
	RygelMediaExportQueryContainer* result = NULL;
	gchar* title = NULL;
	gchar* _tmp0_;
	gchar* attribute = NULL;
	gchar* pattern = NULL;
	gchar* upnp_class = NULL;
	RygelMediaExportQueryContainer* container = NULL;
	gchar* id = NULL;
	gchar* _tmp1_;
	RygelSearchExpression* expression = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelSearchExpression* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (definition_id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup (name);
	title = _tmp0_;
	attribute = NULL;
	pattern = NULL;
	upnp_class = NULL;
	_tmp1_ = g_strdup (definition_id);
	id = _tmp1_;
	rygel_media_export_query_container_factory_register_id (self, &id);
	_tmp5_ = rygel_media_export_query_container_factory_parse_description (definition_id, &_tmp2_, &_tmp3_, &_tmp4_, &title);
	_g_free0 (pattern);
	pattern = _tmp2_;
	_g_free0 (attribute);
	attribute = _tmp3_;
	_g_free0 (upnp_class);
	upnp_class = _tmp4_;
	expression = _tmp5_;
	_tmp7_ = pattern;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = pattern;
		_tmp6_ = g_strcmp0 (_tmp8_, "") == 0;
	}
	if (_tmp6_) {
		RygelSearchExpression* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		RygelMediaExportLeafQueryContainer* _tmp12_;
		_tmp9_ = expression;
		_tmp10_ = id;
		_tmp11_ = title;
		_tmp12_ = rygel_media_export_leaf_query_container_new (_tmp9_, _tmp10_, _tmp11_);
		_g_object_unref0 (container);
		container = (RygelMediaExportQueryContainer*) _tmp12_;
	} else {
		RygelSearchExpression* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		RygelMediaExportNodeQueryContainer* _tmp18_;
		_tmp13_ = expression;
		_tmp14_ = id;
		_tmp15_ = title;
		_tmp16_ = pattern;
		_tmp17_ = attribute;
		_tmp18_ = rygel_media_export_node_query_container_new (_tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp17_);
		_g_object_unref0 (container);
		container = (RygelMediaExportQueryContainer*) _tmp18_;
	}
	_tmp19_ = upnp_class;
	if (_tmp19_ != NULL) {
		RygelMediaExportQueryContainer* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp20_ = container;
		_tmp21_ = upnp_class;
		rygel_media_object_set_upnp_class ((RygelMediaObject*) _tmp20_, _tmp21_);
		_tmp22_ = upnp_class;
		if (g_strcmp0 (_tmp22_, RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM) == 0) {
			RygelMediaExportQueryContainer* _tmp23_;
			_tmp23_ = container;
			rygel_media_container_set_sort_criteria ((RygelMediaContainer*) _tmp23_, RYGEL_MEDIA_CONTAINER_ALBUM_SORT_CRITERIA);
		}
	}
	result = container;
	_rygel_search_expression_unref0 (expression);
	_g_free0 (id);
	_g_free0 (upnp_class);
	_g_free0 (pattern);
	_g_free0 (attribute);
	_g_free0 (title);
	return result;
}


/**
     * Map a DIDL attribute to a UPnP container class.
     *
     * @return A matching UPnP class for the attribute or null if it can't be
     *         mapped.
     */
static gchar*
rygel_media_export_query_container_factory_map_upnp_class (const gchar* attribute)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	g_return_val_if_fail (attribute != NULL, NULL);
	_tmp0_ = attribute;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ALBUM);
				result = _tmp3_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("dc:creator")))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("upnp:artist"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_ARTIST);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("dc:genre")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (RYGEL_MEDIA_CONTAINER_MUSIC_GENRE);
				result = _tmp5_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


/**
     * Parse a plaintext container description into a search expression.
     *
     * Also generates a name for the container and other meta-data necessary
     * for node containers.
     *
     * @param description The plaintext container description
     * @param pattern     Contains the pattern used for child containers if
     *                    descrption is for a node container, null otherwise.
     * @param attribute   Contains the UPnP attribute the container describes.
     * @param name        If passed empty, name will be generated from the
     *                    description.
     * @return A SearchExpression corresponding to the non-variable part of
     *         the description.
     */
static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static RygelSearchExpression*
rygel_media_export_query_container_factory_parse_description (const gchar* description,
                                                              gchar* * pattern,
                                                              gchar* * attribute,
                                                              gchar* * upnp_class,
                                                              gchar* * name)
{
	gchar* _vala_pattern = NULL;
	gchar* _vala_attribute = NULL;
	gchar* _vala_upnp_class = NULL;
	RygelSearchExpression* result = NULL;
	gchar** args = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	RygelSearchExpression* expression = NULL;
	gpointer _tmp2_;
	RygelSearchExpression* _tmp3_;
	gint i = 0;
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (*name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (description, ",", 0);
	args = _tmp1_;
	args_length1 = _vala_array_length (_tmp0_);
	_args_size_ = args_length1;
	_tmp2_ = NULL;
	_tmp3_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_SEARCH_EXPRESSION) ? ((RygelSearchExpression*) _tmp2_) : NULL);
	expression = _tmp3_;
	_g_free0 (_vala_pattern);
	_vala_pattern = NULL;
	_g_free0 (_vala_attribute);
	_vala_attribute = NULL;
	_g_free0 (_vala_upnp_class);
	_vala_upnp_class = NULL;
	i = 0;
	while (TRUE) {
		gint _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* previous_attribute = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		const gchar* _tmp16_;
		gint _tmp41_;
		_tmp4_ = i;
		_tmp5_ = args;
		_tmp5__length1 = args_length1;
		if (!(_tmp4_ < _tmp5__length1)) {
			break;
		}
		_tmp6_ = _vala_attribute;
		_tmp7_ = g_strdup (_tmp6_);
		previous_attribute = _tmp7_;
		_tmp8_ = args;
		_tmp8__length1 = args_length1;
		_tmp9_ = i;
		_tmp10_ = _tmp8_[_tmp9_];
		_tmp11_ = string_replace (_tmp10_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
		_g_free0 (_vala_attribute);
		_vala_attribute = _tmp11_;
		_tmp12_ = _vala_attribute;
		_tmp13_ = g_uri_unescape_string (_tmp12_, NULL);
		_g_free0 (_vala_attribute);
		_vala_attribute = _tmp13_;
		_tmp14_ = args;
		_tmp14__length1 = args_length1;
		_tmp15_ = i;
		_tmp16_ = _tmp14_[_tmp15_ + 1];
		if (g_strcmp0 (_tmp16_, "?") != 0) {
			gchar** _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			const gchar* _tmp22_;
			gint _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			_tmp17_ = args;
			_tmp17__length1 = args_length1;
			_tmp18_ = i;
			_tmp19_ = _tmp17_[_tmp18_];
			_tmp20_ = args;
			_tmp20__length1 = args_length1;
			_tmp21_ = i;
			_tmp22_ = _tmp20_[_tmp21_ + 1];
			rygel_media_export_query_container_factory_update_search_expression (&expression, _tmp19_, _tmp22_);
			_tmp23_ = i;
			_tmp24_ = args;
			_tmp24__length1 = args_length1;
			if ((_tmp23_ + 2) == _tmp24__length1) {
				const gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp25_ = _vala_attribute;
				_tmp26_ = rygel_media_export_query_container_factory_map_upnp_class (_tmp25_);
				_g_free0 (_vala_upnp_class);
				_vala_upnp_class = _tmp26_;
			}
		} else {
			gchar** _tmp27_;
			gint _tmp27__length1;
			gint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gboolean _tmp35_ = FALSE;
			_tmp27_ = args;
			_tmp27__length1 = args_length1;
			_tmp28_ = i;
			_tmp29_ = g_strdup ("%s");
			_g_free0 (_tmp27_[_tmp28_ + 1]);
			_tmp27_[_tmp28_ + 1] = _tmp29_;
			_tmp30_ = _tmp27_[_tmp28_ + 1];
			_tmp31_ = args;
			_tmp31__length1 = args_length1;
			_tmp32_ = _vala_g_strjoinv (",", _tmp31_, _tmp31__length1);
			_g_free0 (_vala_pattern);
			_vala_pattern = _tmp32_;
			_tmp33_ = previous_attribute;
			_tmp34_ = rygel_media_export_query_container_factory_map_upnp_class (_tmp33_);
			_g_free0 (_vala_upnp_class);
			_vala_upnp_class = _tmp34_;
			if (g_strcmp0 (*name, "") == 0) {
				gint _tmp36_;
				_tmp36_ = i;
				_tmp35_ = _tmp36_ > 0;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				gchar** _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp37_ = args;
				_tmp37__length1 = args_length1;
				_tmp38_ = i;
				_tmp39_ = _tmp37_[_tmp38_ - 1];
				_tmp40_ = g_uri_unescape_string (_tmp39_, NULL);
				_g_free0 (*name);
				*name = _tmp40_;
			}
			_g_free0 (previous_attribute);
			break;
		}
		_tmp41_ = i;
		i = _tmp41_ + 2;
		_g_free0 (previous_attribute);
	}
	result = expression;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	if (pattern) {
		*pattern = _vala_pattern;
	} else {
		_g_free0 (_vala_pattern);
	}
	if (attribute) {
		*attribute = _vala_attribute;
	} else {
		_g_free0 (_vala_attribute);
	}
	if (upnp_class) {
		*upnp_class = _vala_upnp_class;
	} else {
		_g_free0 (_vala_upnp_class);
	}
	return result;
}


/**
     * Update a SearchExpression with a new key = value condition.
     *
     * Will modifiy the passed expression to (expression AND (key = value))
     *
     * @param expression The expression to update or null to create a new one
     * @param key        Key of the key/value condition
     * @param value      Value of the key/value condition
     */
static void
rygel_media_export_query_container_factory_update_search_expression (RygelSearchExpression* * expression,
                                                                     const gchar* key,
                                                                     const gchar* value)
{
	RygelRelationalExpression* subexpression = NULL;
	RygelRelationalExpression* _tmp0_;
	gchar* clean_key = NULL;
	gchar* _tmp1_;
	RygelRelationalExpression* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	RygelRelationalExpression* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_relational_expression_new ();
	subexpression = _tmp0_;
	_tmp1_ = string_replace (key, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	clean_key = _tmp1_;
	_tmp2_ = subexpression;
	_tmp3_ = clean_key;
	_tmp4_ = g_uri_unescape_string (_tmp3_, NULL);
	_g_free0 (((RygelSearchExpression*) _tmp2_)->operand1);
	((RygelSearchExpression*) _tmp2_)->operand1 = _tmp4_;
	_tmp5_ = subexpression;
	((RygelSearchExpression*) _tmp5_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
	_tmp6_ = subexpression;
	_tmp7_ = g_uri_unescape_string (value, NULL);
	_g_free0 (((RygelSearchExpression*) _tmp6_)->operand2);
	((RygelSearchExpression*) _tmp6_)->operand2 = _tmp7_;
	if ((*expression) != NULL) {
		RygelLogicalExpression* conjunction = NULL;
		RygelLogicalExpression* _tmp8_;
		RygelLogicalExpression* _tmp9_;
		RygelSearchExpression* _tmp10_;
		RygelLogicalExpression* _tmp11_;
		RygelRelationalExpression* _tmp12_;
		RygelSearchExpression* _tmp13_;
		RygelLogicalExpression* _tmp14_;
		RygelLogicalExpression* _tmp15_;
		RygelSearchExpression* _tmp16_;
		_tmp8_ = rygel_logical_expression_new ();
		conjunction = _tmp8_;
		_tmp9_ = conjunction;
		_tmp10_ = _rygel_search_expression_ref0 (*expression);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp9_)->operand1);
		((RygelSearchExpression*) _tmp9_)->operand1 = _tmp10_;
		_tmp11_ = conjunction;
		_tmp12_ = subexpression;
		_tmp13_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp12_);
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp11_)->operand2);
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp13_;
		_tmp14_ = conjunction;
		((RygelSearchExpression*) _tmp14_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
		_tmp15_ = conjunction;
		_tmp16_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp15_);
		_rygel_search_expression_unref0 (*expression);
		*expression = _tmp16_;
		_rygel_search_expression_unref0 (conjunction);
	} else {
		RygelRelationalExpression* _tmp17_;
		RygelSearchExpression* _tmp18_;
		_tmp17_ = subexpression;
		_tmp18_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) _tmp17_);
		_rygel_search_expression_unref0 (*expression);
		*expression = _tmp18_;
	}
	_g_free0 (clean_key);
	_rygel_search_expression_unref0 (subexpression);
}


static void
rygel_media_export_query_container_factory_class_init (RygelMediaExportQueryContainerFactoryClass * klass)
{
	rygel_media_export_query_container_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportQueryContainerFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_query_container_factory_finalize;
}


static void
rygel_media_export_query_container_factory_instance_init (RygelMediaExportQueryContainerFactory * self)
{
	self->priv = RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_PRIVATE (self);
}


static void
rygel_media_export_query_container_factory_finalize (GObject * obj)
{
	RygelMediaExportQueryContainerFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory);
	_g_object_unref0 (self->priv->virtual_container_map);
	G_OBJECT_CLASS (rygel_media_export_query_container_factory_parent_class)->finalize (obj);
}


/**
 * A helper class to create QueryContainer instances based on IDs.
 */
GType
rygel_media_export_query_container_factory_get_type (void)
{
	static volatile gsize rygel_media_export_query_container_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_query_container_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportQueryContainerFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_query_container_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportQueryContainerFactory), 0, (GInstanceInitFunc) rygel_media_export_query_container_factory_instance_init, NULL };
		GType rygel_media_export_query_container_factory_type_id;
		rygel_media_export_query_container_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportQueryContainerFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_query_container_factory_type_id__volatile, rygel_media_export_query_container_factory_type_id);
	}
	return rygel_media_export_query_container_factory_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



