/* rygel-media-export-item.c generated by valac 0.14.2, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__gst_mini_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gst_mini_object_unref0_ (var), NULL)))
#define _gst_mini_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info);
static void _gst_mini_object_unref0_ (gpointer var);
static void _g_list_free__gst_mini_object_unref0_ (GList* self);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* title;
	RygelMediaItem* item = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* mime;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	RygelMediaItem* _tmp31_;
	GFileInfo* _tmp32_;
	gint64 _tmp33_ = 0LL;
	RygelMediaItem* _tmp34_;
	GFileInfo* _tmp35_;
	guint64 _tmp36_ = 0ULL;
	RygelMediaItem* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	title = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
	mime = _tmp5_;
	_tmp6_ = mime;
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
	if (_tmp7_) {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		RygelMediaContainer* _tmp11_;
		const gchar* _tmp12_;
		RygelVideoItem* _tmp13_;
		_tmp8_ = file;
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = parent;
		_tmp12_ = title;
		_tmp13_ = rygel_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp13_;
		_g_free0 (_tmp10_);
	} else {
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = mime;
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
		if (_tmp15_) {
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			RygelMediaContainer* _tmp19_;
			const gchar* _tmp20_;
			RygelPhotoItem* _tmp21_;
			_tmp16_ = file;
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = parent;
			_tmp20_ = title;
			_tmp21_ = rygel_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp21_;
			_g_free0 (_tmp18_);
		} else {
			GFile* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			RygelMediaContainer* _tmp25_;
			const gchar* _tmp26_;
			RygelMusicItem* _tmp27_;
			_tmp22_ = file;
			_tmp23_ = rygel_media_export_media_cache_get_id (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = parent;
			_tmp26_ = title;
			_tmp27_ = rygel_music_item_new (_tmp24_, _tmp25_, _tmp26_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp27_;
			_g_free0 (_tmp24_);
		}
	}
	_tmp28_ = item;
	_tmp29_ = mime;
	_tmp30_ = g_strdup (_tmp29_);
	_g_free0 (_tmp28_->mime_type);
	_tmp28_->mime_type = _tmp30_;
	_tmp31_ = item;
	_tmp32_ = info;
	_tmp33_ = g_file_info_get_size (_tmp32_);
	rygel_media_item_set_size (_tmp31_, (gint64) _tmp33_);
	_tmp34_ = item;
	_tmp35_ = info;
	_tmp36_ = g_file_info_get_attribute_uint64 (_tmp35_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	((RygelMediaObject*) _tmp34_)->modified = _tmp36_;
	_tmp37_ = item;
	_tmp38_ = file;
	_tmp39_ = g_file_get_uri (_tmp38_);
	_tmp40_ = _tmp39_;
	rygel_media_item_add_uri (_tmp37_, _tmp40_);
	_g_free0 (_tmp40_);
	result = item;
	_g_free0 (mime);
	_g_free0 (title);
	return result;
}


static void _gst_mini_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_mini_object_unref (var), NULL));
}


static void _g_list_free__gst_mini_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gst_mini_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _gst_mini_object_ref0 (gpointer self) {
	return self ? gst_mini_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GUPnPDLNAInformation* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	GstDiscovererInfo* _tmp4_;
	GList* _tmp5_ = NULL;
	GUPnPDLNAInformation* _tmp6_;
	GstDiscovererInfo* _tmp7_;
	GstDiscovererInfo* _tmp8_;
	GList* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GList* _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp17_ = FALSE;
	GList* _tmp18_;
	gboolean _tmp22_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = dlna_info;
	_tmp3_ = gupnp_dlna_information_get_info (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gst_discoverer_info_get_audio_streams (_tmp4_);
	__g_list_free__gst_mini_object_unref0_0 (audio_streams);
	audio_streams = _tmp5_;
	_tmp6_ = dlna_info;
	_tmp7_ = gupnp_dlna_information_get_info (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gst_discoverer_info_get_video_streams (_tmp8_);
	__g_list_free__gst_mini_object_unref0_0 (video_streams);
	video_streams = _tmp9_;
	_tmp11_ = audio_streams;
	if (_tmp11_ == NULL) {
		GList* _tmp12_;
		_tmp12_ = video_streams;
		_tmp10_ = _tmp12_ == NULL;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = _tmp10_;
	if (_tmp13_) {
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp14_ = file;
		_tmp15_ = g_file_get_uri (_tmp14_);
		_tmp16_ = _tmp15_;
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp16_);
		_g_free0 (_tmp16_);
		result = NULL;
		__g_list_free__gst_mini_object_unref0_0 (video_streams);
		__g_list_free__gst_mini_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	}
	_tmp18_ = audio_streams;
	if (_tmp18_ == NULL) {
		GList* _tmp19_;
		gconstpointer _tmp20_;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = video_streams;
		_tmp20_ = _tmp19_->data;
		_tmp21_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp20_);
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp22_ = _tmp17_;
	if (_tmp22_) {
		const gchar* _tmp23_;
		RygelMediaContainer* _tmp24_;
		RygelPhotoItem* _tmp25_;
		RygelMediaItem* _tmp26_;
		GFile* _tmp27_;
		GUPnPDLNAInformation* _tmp28_;
		GList* _tmp29_;
		gconstpointer _tmp30_;
		GFileInfo* _tmp31_;
		RygelMediaItem* _tmp32_ = NULL;
		_tmp23_ = id;
		_tmp24_ = parent;
		_tmp25_ = rygel_photo_item_new (_tmp23_, _tmp24_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
		_g_object_unref0 (item);
		item = (RygelMediaItem*) _tmp25_;
		_tmp26_ = item;
		_tmp27_ = file;
		_tmp28_ = dlna_info;
		_tmp29_ = video_streams;
		_tmp30_ = _tmp29_->data;
		_tmp31_ = file_info;
		_tmp32_ = rygel_media_export_item_factory_fill_photo_item (RYGEL_IS_PHOTO_ITEM (_tmp26_) ? ((RygelPhotoItem*) _tmp26_) : NULL, _tmp27_, _tmp28_, (GstDiscovererVideoInfo*) _tmp30_, _tmp31_);
		result = _tmp32_;
		__g_list_free__gst_mini_object_unref0_0 (video_streams);
		__g_list_free__gst_mini_object_unref0_0 (audio_streams);
		_g_free0 (id);
		_g_object_unref0 (item);
		return result;
	} else {
		GList* _tmp33_;
		_tmp33_ = video_streams;
		if (_tmp33_ != NULL) {
			const gchar* _tmp34_;
			RygelMediaContainer* _tmp35_;
			RygelVideoItem* _tmp36_;
			GstDiscovererAudioInfo* _tmp37_;
			GstDiscovererAudioInfo* audio_info;
			GList* _tmp38_;
			RygelMediaItem* _tmp42_;
			GFile* _tmp43_;
			GUPnPDLNAInformation* _tmp44_;
			GList* _tmp45_;
			gconstpointer _tmp46_;
			GstDiscovererAudioInfo* _tmp47_;
			GFileInfo* _tmp48_;
			RygelMediaItem* _tmp49_ = NULL;
			_tmp34_ = id;
			_tmp35_ = parent;
			_tmp36_ = rygel_video_item_new (_tmp34_, _tmp35_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
			_g_object_unref0 (item);
			item = (RygelMediaItem*) _tmp36_;
			_tmp37_ = _gst_mini_object_ref0 (GST_IS_DISCOVERER_AUDIO_INFO (NULL) ? ((GstDiscovererAudioInfo*) NULL) : NULL);
			audio_info = _tmp37_;
			_tmp38_ = audio_streams;
			if (_tmp38_ != NULL) {
				GList* _tmp39_;
				gconstpointer _tmp40_;
				GstDiscovererAudioInfo* _tmp41_;
				_tmp39_ = audio_streams;
				_tmp40_ = _tmp39_->data;
				_tmp41_ = _gst_mini_object_ref0 ((GstDiscovererAudioInfo*) _tmp40_);
				_gst_mini_object_unref0 (audio_info);
				audio_info = _tmp41_;
			}
			_tmp42_ = item;
			_tmp43_ = file;
			_tmp44_ = dlna_info;
			_tmp45_ = video_streams;
			_tmp46_ = _tmp45_->data;
			_tmp47_ = audio_info;
			_tmp48_ = file_info;
			_tmp49_ = rygel_media_export_item_factory_fill_video_item (RYGEL_IS_VIDEO_ITEM (_tmp42_) ? ((RygelVideoItem*) _tmp42_) : NULL, _tmp43_, _tmp44_, (GstDiscovererVideoInfo*) _tmp46_, _tmp47_, _tmp48_);
			result = _tmp49_;
			_gst_mini_object_unref0 (audio_info);
			__g_list_free__gst_mini_object_unref0_0 (video_streams);
			__g_list_free__gst_mini_object_unref0_0 (audio_streams);
			_g_free0 (id);
			_g_object_unref0 (item);
			return result;
		} else {
			GList* _tmp50_;
			_tmp50_ = audio_streams;
			if (_tmp50_ != NULL) {
				const gchar* _tmp51_;
				RygelMediaContainer* _tmp52_;
				RygelMusicItem* _tmp53_;
				RygelMediaItem* _tmp54_;
				GFile* _tmp55_;
				GUPnPDLNAInformation* _tmp56_;
				GList* _tmp57_;
				gconstpointer _tmp58_;
				GFileInfo* _tmp59_;
				RygelMediaItem* _tmp60_ = NULL;
				_tmp51_ = id;
				_tmp52_ = parent;
				_tmp53_ = rygel_music_item_new (_tmp51_, _tmp52_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
				_g_object_unref0 (item);
				item = (RygelMediaItem*) _tmp53_;
				_tmp54_ = item;
				_tmp55_ = file;
				_tmp56_ = dlna_info;
				_tmp57_ = audio_streams;
				_tmp58_ = _tmp57_->data;
				_tmp59_ = file_info;
				_tmp60_ = rygel_media_export_item_factory_fill_music_item (RYGEL_IS_MUSIC_ITEM (_tmp54_) ? ((RygelMusicItem*) _tmp54_) : NULL, _tmp55_, _tmp56_, (GstDiscovererAudioInfo*) _tmp58_, _tmp59_);
				result = _tmp60_;
				__g_list_free__gst_mini_object_unref0_0 (video_streams);
				__g_list_free__gst_mini_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			} else {
				result = NULL;
				__g_list_free__gst_mini_object_unref0_0 (video_streams);
				__g_list_free__gst_mini_object_unref0_0 (audio_streams);
				_g_free0 (id);
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	__g_list_free__gst_mini_object_unref0_0 (video_streams);
	__g_list_free__gst_mini_object_unref0_0 (audio_streams);
	_g_free0 (id);
	_g_object_unref0 (item);
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info) {
	GUPnPDLNAInformation* _tmp0_;
	GstDiscovererInfo* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstClockTime _tmp3_ = 0ULL;
	GstDiscovererAudioInfo* _tmp10_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (dlna_info != NULL);
	_tmp0_ = dlna_info;
	_tmp1_ = gupnp_dlna_information_get_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gst_discoverer_info_get_duration (_tmp2_);
	if (_tmp3_ > ((GstClockTime) 0)) {
		RygelAudioItem* _tmp4_;
		GUPnPDLNAInformation* _tmp5_;
		GstDiscovererInfo* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstClockTime _tmp8_ = 0ULL;
		_tmp4_ = item;
		_tmp5_ = dlna_info;
		_tmp6_ = gupnp_dlna_information_get_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gst_discoverer_info_get_duration (_tmp7_);
		_tmp4_->duration = (glong) (_tmp8_ / GST_SECOND);
	} else {
		RygelAudioItem* _tmp9_;
		_tmp9_ = item;
		_tmp9_->duration = (glong) (-1);
	}
	_tmp10_ = audio_info;
	if (_tmp10_ != NULL) {
		GstDiscovererAudioInfo* _tmp11_;
		GstTagList* _tmp12_ = NULL;
		RygelAudioItem* _tmp18_;
		GstDiscovererAudioInfo* _tmp19_;
		guint _tmp20_ = 0U;
		RygelAudioItem* _tmp21_;
		GstDiscovererAudioInfo* _tmp22_;
		guint _tmp23_ = 0U;
		_tmp11_ = audio_info;
		_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
		if (_tmp12_ != NULL) {
			guint tmp = 0U;
			GstDiscovererAudioInfo* _tmp13_;
			GstTagList* _tmp14_ = NULL;
			guint _tmp15_ = 0U;
			RygelAudioItem* _tmp16_;
			guint _tmp17_;
			_tmp13_ = audio_info;
			_tmp14_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp13_);
			gst_tag_list_get_uint (_tmp14_, GST_TAG_BITRATE, &_tmp15_);
			tmp = _tmp15_;
			_tmp16_ = item;
			_tmp17_ = tmp;
			_tmp16_->bitrate = ((gint) _tmp17_) / 8;
		}
		_tmp18_ = item;
		_tmp19_ = audio_info;
		_tmp20_ = gst_discoverer_audio_info_get_channels (_tmp19_);
		_tmp18_->channels = (gint) _tmp20_;
		_tmp21_ = item;
		_tmp22_ = audio_info;
		_tmp23_ = gst_discoverer_audio_info_get_sample_rate (_tmp22_);
		_tmp21_->sample_freq = (gint) _tmp23_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelVideoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelVideoItem* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelVideoItem* _tmp3_;
	GFile* _tmp4_;
	GUPnPDLNAInformation* _tmp5_;
	GFileInfo* _tmp6_;
	RygelVideoItem* _tmp7_;
	GstDiscovererVideoInfo* _tmp8_;
	guint _tmp9_ = 0U;
	RygelVideoItem* _tmp10_;
	GstDiscovererVideoInfo* _tmp11_;
	guint _tmp12_ = 0U;
	RygelVideoItem* _tmp13_;
	GstDiscovererVideoInfo* _tmp14_;
	guint _tmp15_ = 0U;
	RygelVideoItem* _tmp16_;
	RygelMediaItem* _tmp17_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = dlna_info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = dlna_info;
	_tmp6_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = item;
	_tmp8_ = video_info;
	_tmp9_ = gst_discoverer_video_info_get_width (_tmp8_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp7_, (gint) _tmp9_);
	_tmp10_ = item;
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_height (_tmp11_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp10_, (gint) _tmp12_);
	_tmp13_ = item;
	_tmp14_ = video_info;
	_tmp15_ = gst_discoverer_video_info_get_depth (_tmp14_);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp13_, (gint) _tmp15_);
	_tmp16_ = item;
	_tmp17_ = _g_object_ref0 ((RygelMediaItem*) _tmp16_);
	result = _tmp17_;
	return result;
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelPhotoItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelPhotoItem* _tmp0_;
	GFile* _tmp1_;
	GUPnPDLNAInformation* _tmp2_;
	GFileInfo* _tmp3_;
	RygelPhotoItem* _tmp4_;
	GstDiscovererVideoInfo* _tmp5_;
	guint _tmp6_ = 0U;
	RygelPhotoItem* _tmp7_;
	GstDiscovererVideoInfo* _tmp8_;
	guint _tmp9_ = 0U;
	RygelPhotoItem* _tmp10_;
	GstDiscovererVideoInfo* _tmp11_;
	guint _tmp12_ = 0U;
	RygelPhotoItem* _tmp13_;
	RygelMediaItem* _tmp14_;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (video_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = file;
	_tmp2_ = dlna_info;
	_tmp3_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = item;
	_tmp5_ = video_info;
	_tmp6_ = gst_discoverer_video_info_get_width (_tmp5_);
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp4_, (gint) _tmp6_);
	_tmp7_ = item;
	_tmp8_ = video_info;
	_tmp9_ = gst_discoverer_video_info_get_height (_tmp8_);
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp7_, (gint) _tmp9_);
	_tmp10_ = item;
	_tmp11_ = video_info;
	_tmp12_ = gst_discoverer_video_info_get_depth (_tmp11_);
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp10_, (gint) _tmp12_);
	_tmp13_ = item;
	_tmp14_ = _g_object_ref0 ((RygelMediaItem*) _tmp13_);
	result = _tmp14_;
	return result;
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMusicItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMusicItem* _tmp0_;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererAudioInfo* _tmp2_;
	RygelMusicItem* _tmp3_;
	GFile* _tmp4_;
	GUPnPDLNAInformation* _tmp5_;
	GFileInfo* _tmp6_;
	GstDiscovererAudioInfo* _tmp7_;
	RygelMusicItem* _tmp54_;
	RygelMediaItem* _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (dlna_info != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = dlna_info;
	_tmp2_ = audio_info;
	rygel_media_export_item_factory_fill_audio_item (RYGEL_IS_AUDIO_ITEM (_tmp0_) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = file;
	_tmp5_ = dlna_info;
	_tmp6_ = file_info;
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp7_ = audio_info;
	if (_tmp7_ != NULL) {
		GstDiscovererAudioInfo* _tmp8_;
		GstTagList* _tmp9_ = NULL;
		GUPnPDLNAInformation* _tmp29_;
		GstDiscovererInfo* _tmp30_;
		GstDiscovererInfo* _tmp31_;
		GstTagList* _tmp32_ = NULL;
		RygelMusicItem* _tmp33_;
		gchar* _tmp34_ = NULL;
		GUPnPDLNAInformation* _tmp35_;
		GstDiscovererInfo* _tmp36_;
		GstDiscovererInfo* _tmp37_;
		GstTagList* _tmp38_ = NULL;
		RygelMusicItem* _tmp39_;
		gchar* _tmp40_ = NULL;
		GUPnPDLNAInformation* _tmp41_;
		GstDiscovererInfo* _tmp42_;
		GstDiscovererInfo* _tmp43_;
		GstTagList* _tmp44_ = NULL;
		RygelMusicItem* _tmp45_;
		gchar* _tmp46_ = NULL;
		guint tmp = 0U;
		GUPnPDLNAInformation* _tmp47_;
		GstDiscovererInfo* _tmp48_;
		GstDiscovererInfo* _tmp49_;
		GstTagList* _tmp50_ = NULL;
		guint _tmp51_ = 0U;
		RygelMusicItem* _tmp52_;
		guint _tmp53_;
		_tmp8_ = audio_info;
		_tmp9_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp8_);
		if (_tmp9_ != NULL) {
			GstBuffer* buffer = NULL;
			GstDiscovererAudioInfo* _tmp10_;
			GstTagList* _tmp11_ = NULL;
			GstBuffer* _tmp12_ = NULL;
			GstBuffer* _tmp13_;
			_tmp10_ = audio_info;
			_tmp11_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp10_);
			gst_tag_list_get_buffer (_tmp11_, GST_TAG_IMAGE, &_tmp12_);
			buffer = _tmp12_;
			_tmp13_ = buffer;
			if (_tmp13_ != NULL) {
				GstBuffer* _tmp14_;
				GstCaps* _tmp15_;
				const GstStructure* _tmp16_ = NULL;
				GstStructure* _tmp17_;
				GstStructure* structure;
				gint image_type = 0;
				const GstStructure* _tmp18_;
				gint _tmp19_ = 0;
				gint _tmp20_;
				_tmp14_ = buffer;
				_tmp15_ = _tmp14_->caps;
				_tmp16_ = gst_caps_get_structure (_tmp15_, (guint) 0);
				_tmp17_ = _gst_structure_copy0 (_tmp16_);
				structure = _tmp17_;
				_tmp18_ = structure;
				gst_structure_get_enum (_tmp18_, "image-type", GST_TYPE_TAG_IMAGE_TYPE, &_tmp19_);
				image_type = _tmp19_;
				_tmp20_ = image_type;
				switch (_tmp20_) {
					case GST_TAG_IMAGE_TYPE_UNDEFINED:
					case GST_TAG_IMAGE_TYPE_FRONT_COVER:
					{
						RygelMediaArtStore* _tmp21_ = NULL;
						RygelMediaArtStore* store;
						RygelMediaArtStore* _tmp22_;
						RygelMusicItem* _tmp23_;
						GFile* _tmp24_ = NULL;
						GFile* thumb;
						_tmp21_ = rygel_media_art_store_get_default ();
						store = _tmp21_;
						_tmp22_ = store;
						_tmp23_ = item;
						_tmp24_ = rygel_media_art_store_get_media_art_file (_tmp22_, "album", _tmp23_, TRUE);
						thumb = _tmp24_;
						{
							RygelMediaExportJPEGWriter* _tmp25_;
							RygelMediaExportJPEGWriter* writer;
							RygelMediaExportJPEGWriter* _tmp26_;
							GstBuffer* _tmp27_;
							GFile* _tmp28_;
							_tmp25_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
							writer = _tmp25_;
							if (_inner_error_ != NULL) {
								goto __catch58_g_error;
							}
							_tmp26_ = writer;
							_tmp27_ = buffer;
							_tmp28_ = thumb;
							rygel_media_export_jpeg_writer_write (_tmp26_, _tmp27_, _tmp28_);
							_g_object_unref0 (writer);
						}
						goto __finally58;
						__catch58_g_error:
						{
							GError* _error_ = NULL;
							_error_ = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (_error_);
						}
						__finally58:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (thumb);
							_g_object_unref0 (store);
							_gst_structure_free0 (structure);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_object_unref0 (thumb);
						_g_object_unref0 (store);
						break;
					}
					default:
					{
						break;
					}
				}
				_gst_structure_free0 (structure);
			}
		}
		_tmp29_ = dlna_info;
		_tmp30_ = gupnp_dlna_information_get_info (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = gst_discoverer_info_get_tags (_tmp31_);
		_tmp33_ = item;
		gst_tag_list_get_string (_tmp32_, GST_TAG_ARTIST, &_tmp34_);
		_g_free0 (_tmp33_->artist);
		_tmp33_->artist = _tmp34_;
		_tmp35_ = dlna_info;
		_tmp36_ = gupnp_dlna_information_get_info (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gst_discoverer_info_get_tags (_tmp37_);
		_tmp39_ = item;
		gst_tag_list_get_string (_tmp38_, GST_TAG_ALBUM, &_tmp40_);
		_g_free0 (_tmp39_->album);
		_tmp39_->album = _tmp40_;
		_tmp41_ = dlna_info;
		_tmp42_ = gupnp_dlna_information_get_info (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = gst_discoverer_info_get_tags (_tmp43_);
		_tmp45_ = item;
		gst_tag_list_get_string (_tmp44_, GST_TAG_GENRE, &_tmp46_);
		_g_free0 (_tmp45_->genre);
		_tmp45_->genre = _tmp46_;
		_tmp47_ = dlna_info;
		_tmp48_ = gupnp_dlna_information_get_info (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = gst_discoverer_info_get_tags (_tmp49_);
		gst_tag_list_get_uint (_tmp50_, GST_TAG_TRACK_NUMBER, &_tmp51_);
		tmp = _tmp51_;
		_tmp52_ = item;
		_tmp53_ = tmp;
		_tmp52_->track_number = (gint) _tmp53_;
	}
	_tmp54_ = item;
	_tmp55_ = _g_object_ref0 ((RygelMediaItem*) _tmp54_);
	result = _tmp55_;
	return result;
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GUPnPDLNAInformation* dlna_info, GFileInfo* file_info) {
	gchar* title;
	gboolean _tmp0_ = FALSE;
	GUPnPDLNAInformation* _tmp1_;
	GstDiscovererInfo* _tmp2_;
	GstDiscovererInfo* _tmp3_;
	GstTagList* _tmp4_ = NULL;
	gboolean _tmp11_;
	RygelMediaItem* _tmp15_;
	const gchar* _tmp16_;
	GUPnPDLNAInformation* _tmp17_;
	GstDiscovererInfo* _tmp18_;
	GstDiscovererInfo* _tmp19_;
	GstTagList* _tmp20_ = NULL;
	GFileInfo* _tmp33_;
	guint64 _tmp34_ = 0ULL;
	guint64 mtime;
	RygelMediaItem* _tmp35_;
	const gchar* _tmp36_;
	RygelMediaItem* _tmp41_;
	GFileInfo* _tmp42_;
	gint64 _tmp43_ = 0LL;
	RygelMediaItem* _tmp44_;
	guint64 _tmp45_;
	GUPnPDLNAInformation* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	RygelMediaItem* _tmp63_;
	GFile* _tmp64_;
	gchar* _tmp65_ = NULL;
	gchar* _tmp66_;
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dlna_info != NULL);
	g_return_if_fail (file_info != NULL);
	title = NULL;
	_tmp1_ = dlna_info;
	_tmp2_ = gupnp_dlna_information_get_info (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gst_discoverer_info_get_tags (_tmp3_);
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GUPnPDLNAInformation* _tmp5_;
		GstDiscovererInfo* _tmp6_;
		GstDiscovererInfo* _tmp7_;
		GstTagList* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp5_ = dlna_info;
		_tmp6_ = gupnp_dlna_information_get_info (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gst_discoverer_info_get_tags (_tmp7_);
		_tmp10_ = gst_tag_list_get_string (_tmp8_, GST_TAG_TITLE, &_tmp9_);
		_g_free0 (title);
		title = _tmp9_;
		_tmp0_ = !_tmp10_;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		GFileInfo* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp12_ = file_info;
		_tmp13_ = g_file_info_get_display_name (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (title);
		title = _tmp14_;
	}
	_tmp15_ = item;
	_tmp16_ = title;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp15_, _tmp16_);
	_tmp17_ = dlna_info;
	_tmp18_ = gupnp_dlna_information_get_info (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gst_discoverer_info_get_tags (_tmp19_);
	if (_tmp20_ != NULL) {
		GDate* date = NULL;
		GUPnPDLNAInformation* _tmp21_;
		GstDiscovererInfo* _tmp22_;
		GstDiscovererInfo* _tmp23_;
		GstTagList* _tmp24_ = NULL;
		GDate* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		_tmp21_ = dlna_info;
		_tmp22_ = gupnp_dlna_information_get_info (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = gst_discoverer_info_get_tags (_tmp23_);
		_tmp26_ = gst_tag_list_get_date (_tmp24_, GST_TAG_DATE, &_tmp25_);
		_g_free0 (date);
		date = _tmp25_;
		if (_tmp26_) {
			gchar* _tmp27_ = NULL;
			gchar* datestr;
			gint datestr_length1;
			gint _datestr_size_;
			GDate* _tmp28_;
			gchar* _tmp29_;
			gint _tmp29__length1;
			RygelMediaItem* _tmp30_;
			gchar* _tmp31_;
			gint _tmp31__length1;
			gchar* _tmp32_;
			_tmp27_ = g_new0 (gchar, 30);
			datestr = _tmp27_;
			datestr_length1 = 30;
			_datestr_size_ = datestr_length1;
			_tmp28_ = date;
			_tmp29_ = datestr;
			_tmp29__length1 = datestr_length1;
			g_date_strftime (_tmp29_, _tmp29__length1, "%F", _tmp28_);
			_tmp30_ = item;
			_tmp31_ = datestr;
			_tmp31__length1 = datestr_length1;
			_tmp32_ = g_strdup ((const gchar*) _tmp31_);
			_g_free0 (_tmp30_->date);
			_tmp30_->date = _tmp32_;
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
	_tmp33_ = file_info;
	_tmp34_ = g_file_info_get_attribute_uint64 (_tmp33_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	mtime = _tmp34_;
	_tmp35_ = item;
	_tmp36_ = _tmp35_->date;
	if (_tmp36_ == NULL) {
		guint64 _tmp37_;
		GTimeVal _tmp38_ = {0};
		GTimeVal tv;
		RygelMediaItem* _tmp39_;
		gchar* _tmp40_ = NULL;
		_tmp37_ = mtime;
		_tmp38_.tv_sec = (glong) _tmp37_;
		_tmp38_.tv_usec = (glong) 0;
		tv = _tmp38_;
		_tmp39_ = item;
		_tmp40_ = g_time_val_to_iso8601 (&tv);
		_g_free0 (_tmp39_->date);
		_tmp39_->date = _tmp40_;
	}
	_tmp41_ = item;
	_tmp42_ = file_info;
	_tmp43_ = g_file_info_get_size (_tmp42_);
	rygel_media_item_set_size (_tmp41_, (gint64) _tmp43_);
	_tmp44_ = item;
	_tmp45_ = mtime;
	((RygelMediaObject*) _tmp44_)->modified = (guint64) ((gint64) _tmp45_);
	_tmp46_ = dlna_info;
	_tmp47_ = gupnp_dlna_information_get_name (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ != NULL) {
		RygelMediaItem* _tmp49_;
		GUPnPDLNAInformation* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		RygelMediaItem* _tmp54_;
		GUPnPDLNAInformation* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp49_ = item;
		_tmp50_ = dlna_info;
		_tmp51_ = gupnp_dlna_information_get_name (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup (_tmp52_);
		_g_free0 (_tmp49_->dlna_profile);
		_tmp49_->dlna_profile = _tmp53_;
		_tmp54_ = item;
		_tmp55_ = dlna_info;
		_tmp56_ = gupnp_dlna_information_get_mime (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (_tmp54_->mime_type);
		_tmp54_->mime_type = _tmp58_;
	} else {
		RygelMediaItem* _tmp59_;
		GFileInfo* _tmp60_;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		_tmp59_ = item;
		_tmp60_ = file_info;
		_tmp61_ = g_file_info_get_content_type (_tmp60_);
		_tmp62_ = g_content_type_get_mime_type (_tmp61_);
		_g_free0 (_tmp59_->mime_type);
		_tmp59_->mime_type = _tmp62_;
	}
	_tmp63_ = item;
	_tmp64_ = file;
	_tmp65_ = g_file_get_uri (_tmp64_);
	_tmp66_ = _tmp65_;
	rygel_media_item_add_uri (_tmp63_, _tmp66_);
	_g_free0 (_tmp66_);
	_g_free0 (title);
}



