% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tp_search.R
\name{tp_search}
\alias{tp_search}
\title{Search Tropicos by scientific name, common name, or Tropicos ID.}
\usage{
tp_search(name = NULL, commonname = NULL, nameid = NULL,
  orderby = NULL, sortorder = NULL, pagesize = NULL,
  startrow = NULL, type = NULL, key = NULL, ...)
}
\arguments{
\item{name}{Your search string. For instance "poa annua". See Details.}

\item{commonname}{Your search string. For instance "annual blue grass"}

\item{nameid}{Your search string. For instance "25509881"}

\item{orderby}{Your search string. For instance "1"}

\item{sortorder}{Your search string. For instance "ascending"}

\item{pagesize}{Your search string. For instance "100"}

\item{startrow}{Your search string. For instance "1"}

\item{type}{Type of search, "wildcard" (default) will add a wildcard to the end
of your search string. "exact" will use your search string exactly.}

\item{key}{Your Tropicos API key; See \code{\link{taxize-authentication}} 
for help on authentication}

\item{...}{Further args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
List or dataframe.
}
\description{
Search Tropicos by scientific name, common name, or Tropicos ID.
}
\details{
More details on the \code{name} parameter: Tropicos will fail
if you include a period (\code{.}) in your name string, e.g., \code{var.},
so we replace periods before the request is made to the Tropicos web service.
In addition, Tropicos for some reason doesn't want to see sub-specific rank
names like \code{var}/\code{subsp}, so remove those from your query.
}
\examples{
\dontrun{
tp_search(name = 'Poa annua')
tp_search(name = 'Poa annua subsp. annua')
tp_search(name = 'Poa annua var. annua')
tp_search(name = 'Poa annua var annua')
tp_search(name = 'Poa annua annua')
}
}
\references{
\url{http://services.tropicos.org/help?method=SearchNameXml}
}
