% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyui.R
\name{withMathJax}
\alias{withMathJax}
\title{Load the MathJax library and typeset math expressions}
\usage{
withMathJax(...)
}
\arguments{
\item{...}{any HTML elements to apply MathJax to}
}
\description{
This function adds MathJax to the page and typeset the math expressions (if
found) in the content \code{...}. It only needs to be called once in an app
unless the content is rendered \emph{after} the page is loaded, e.g. via
\code{\link{renderUI}}, in which case we have to call it explicitly every
time we write math expressions to the output.
}
\examples{
withMathJax(helpText("Some math here $$\\\\alpha+\\\\beta$$"))
# now we can just write "static" content without withMathJax()
div("more math here $$\\\\sqrt{2}$$")
}

