% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{microbio_me_qiime}
\alias{microbio_me_qiime}
\title{Import microbio.me/qiime (QIIME-DB) data package}
\usage{
microbio_me_qiime(zipftp, ext = ".zip", parsef = parse_taxonomy_greengenes,
  ...)
}
\arguments{
\item{zipftp}{(Required). A character string that is the full URL
path to a zipped file that follows the file naming conventions used by 
\href{http://www.microbio.me/qiime/index.psp}{microbio.me/qiime}.
Alternatively, you can simply provide the study number
as a single \code{\link{integer}} or other single-length vector
that can be \code{\link{coerce}}d to an integer;
this function will complete the remainder of the ftp URL hosted at
\href{http://www.microbio.me/qiime/index.psp}{microbio.me/qiime}.
For example, instead of the full URL string, 
\code{"ftp://thebeast.colorado.edu/pub/QIIME_DB_Public_Studies/study_494_split_library_seqs_and_mapping.zip"},
you could simply provide \code{494} or \code{"494"}
as the first (`zipftp`) argument.}

\item{ext}{(Optional). A \code{\link{character}} string of the expected
file extension, which also indicates the compression type,
if \code{zipftp} is a study number instead of the full path. 
Note that this argument has no effect if \code{zipftp} is the full path,
in which case the file extension is read directly from the downloaded file.}

\item{parsef}{(Optional). The type of taxonomic parsing to use for the
OTU taxonomic classification, in the \code{.biom} file, if present.
This is passed on to \code{\link{import_biom}}, but unlike that function
the default parsing function is \code{\link{parse_taxonomy_greengenes}},
rather than \code{\link{parse_taxonomy_default}}, because we know
ahead of time that most (or all?) of the taxonomic classifications
in the \code{microbio.me/qiime} repository will be based on 
GreenGenes.}

\item{...}{(Optional, for advanced users). Additional arguments passed to 
\code{\link{download.file}}. This is mainly for non-standard links to
resources (in this case, a zipped file) that are not being hosted by
\href{http://www.microbio.me/qiime/index.psp}{microbio.me/qiime}.
If you are using a FTP address or study number from their servers,
then you shouldn't need to provide any additional arguments.}
}
\value{
A \code{\link{phyloseq-class}} object if possible, a component if only a 
 component could be imported, or \code{NULL} if nothing could be imported
 after unzipping the file. Keep in mind there is a specific naming-convention
 that is expected based on the current state of the
 \href{http://www.microbio.me/qiime/index.psp}{microbio.me/qiime}
 servers. Several helpful messages are \code{\link{cat}}ted to standard out
 to help let you know the ongoing status of the current 
 download and import process.
}
\description{
Originally, this function was for accessing microbiome datasets from the
\href{http://www.microbio.me/qiime/index.psp}{microbio.me/qiime}
public repository from within R.
As you can see by clicking on the above link,
the QIIME-DB sever is down indefinitely.
However, this function will remain supported here
in case the FTP server goes back up, 
and also for phyloseq users that have downloaded 
one or more data packages prior to the server going down.
}
\examples{
# This should return TRUE on your system if you have internet turned on
# and a standard R installation. Indicates whether this is likely to
# work on your system for a URL or local file, respectively.
capabilities("http/ftp"); capabilities("fifo")
# A working example with a local example file included in phyloseq
zipfile = "study_816_split_library_seqs_and_mapping.zip"
zipfile = system.file("extdata", zipfile, package="phyloseq")
tarfile = "study_816_split_library_seqs_and_mapping.tar.gz"
tarfile = system.file("extdata", tarfile, package="phyloseq")
tarps = microbio_me_qiime(tarfile)
zipps = microbio_me_qiime(zipfile) 
identical(tarps, zipps)
tarps; zipps
plot_heatmap(tarps)
# An example that used to work, before the QIIME-DB server was turned off by its host.
# # Smokers dataset
# smokezip = "ftp://thebeast.colorado.edu/pub/QIIME_DB_Public_Studies/study_524_split_library_seqs_and_mapping.zip"
# smokers1 = microbio_me_qiime(smokezip)
# # Alternatively, just use the study number
# smokers2 = microbio_me_qiime(524)
# identical(smokers1, smokers2)
}
\seealso{
See \code{\link{download.file}} and \code{\link{url}}
 for details about URL formats --
 including local file addresses -- that might work here.
 
 \code{\link{import_biom}}
 
 \code{\link{import_qiime}}
}
