// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_OZONE_GPU_THREAD_HELPER_H_
#define UI_OZONE_PUBLIC_OZONE_GPU_THREAD_HELPER_H_

#include "base/macros.h"
#include "base/memory/ref_counted.h"
#include "base/memory/scoped_ptr.h"
#include "ui/ozone/ozone_export.h"

namespace base {
class SingleThreadTaskRunner;
class Thread;
}

namespace ui {

class FakeGpuProcess;
class FakeGpuProcessHost;

// Helper class for applications that do not have a dedicated GPU channel.
//
// This sets up message forwarding between the "gpu" and "ui" threads.
class OZONE_EXPORT OzoneGpuTestHelper {
 public:
  OzoneGpuTestHelper();
  virtual ~OzoneGpuTestHelper();

  // Start processing gpu messages. The host process will be using the
  // |gpu_task_runner| to post messages intended for the GPU thread. The "gpu"
  // process will be using the |ui_task_runner| to post messages intended for
  // the "ui" thread.
  bool Initialize(
      const scoped_refptr<base::SingleThreadTaskRunner>& ui_task_runner,
      const scoped_refptr<base::SingleThreadTaskRunner>& gpu_task_runner);

 private:
  scoped_ptr<FakeGpuProcess> fake_gpu_process_;
  scoped_ptr<FakeGpuProcessHost> fake_gpu_process_host_;
  scoped_ptr<base::Thread> io_helper_thread_;

  DISALLOW_COPY_AND_ASSIGN(OzoneGpuTestHelper);
};

}  // namespace ui

#endif  // UI_OZONE_PUBLIC_OZONE_GPU_THREAD_HELPER_H_
