// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <stdlib.h>

#include "content/public/test/browser_test_utils.h"
#include "content/public/test/content_browser_test.h"
#include "content/public/test/content_browser_test_utils.h"
#include "content/public/test/test_navigation_observer.h"
#include "content/shell/browser/shell.h"

namespace content {

class ResourceLoadingBrowserTest : public ContentBrowserTest  {
};

const char kResourceLoadingNonMobilePage[] =
    "/resource_loading/resource_loading_non_mobile.html";

IN_PROC_BROWSER_TEST_F(ResourceLoadingBrowserTest,
  ResourceLoadingAvoidDoubleDownloads) {
  ASSERT_TRUE(embedded_test_server()->Start());
  GURL url = embedded_test_server()->GetURL(kResourceLoadingNonMobilePage);
  NavigateToURL(shell(), url);
  int data = -1;
  EXPECT_TRUE(ExecuteScriptAndExtractInt(shell()->web_contents(),
    "getResourceNumber()", &data));
  EXPECT_EQ(2, data);
}

} // namespace content
