# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VolumeProviderParametersAzureFile(Model):
    """This type describes a volume provided by an Azure Files file share.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. Name of the Azure storage account for the
     File Share.
    :type account_name: str
    :param account_key: Access key of the Azure storage account for the File
     Share.
    :type account_key: str
    :param share_name: Required. Name of the Azure Files file share that
     provides storage for the volume.
    :type share_name: str
    """

    _validation = {
        'account_name': {'required': True},
        'share_name': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VolumeProviderParametersAzureFile, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.account_key = kwargs.get('account_key', None)
        self.share_name = kwargs.get('share_name', None)
