# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .recovery_point_py3 import RecoveryPoint


class AzureFileShareRecoveryPoint(RecoveryPoint):
    """Azure File Share workload specific backup copy.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param recovery_point_type: Type of the backup copy. Specifies whether it
     is a crash consistent backup or app consistent.
    :type recovery_point_type: str
    :param recovery_point_time: Time at which this backup copy was created.
    :type recovery_point_time: datetime
    :param file_share_snapshot_uri: Contains Url to the snapshot of fileshare,
     if applicable
    :type file_share_snapshot_uri: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'file_share_snapshot_uri': {'key': 'fileShareSnapshotUri', 'type': 'str'},
    }

    def __init__(self, *, recovery_point_type: str=None, recovery_point_time=None, file_share_snapshot_uri: str=None, **kwargs) -> None:
        super(AzureFileShareRecoveryPoint, self).__init__(**kwargs)
        self.recovery_point_type = recovery_point_type
        self.recovery_point_time = recovery_point_time
        self.file_share_snapshot_uri = file_share_snapshot_uri
        self.object_type = 'AzureFileShareRecoveryPoint'
