# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IntegrationRuntimeSsisCatalogInfo(Model):
    """Catalog information for managed dedicated integration runtime.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param catalog_server_endpoint: The catalog database server URL.
    :type catalog_server_endpoint: str
    :param catalog_admin_user_name: The administrator user name of catalog
     database.
    :type catalog_admin_user_name: str
    :param catalog_admin_password: The password of the administrator user
     account of the catalog database.
    :type catalog_admin_password: ~azure.mgmt.datafactory.models.SecureString
    :param catalog_pricing_tier: The pricing tier for the catalog database.
     The valid values could be found in
     https://azure.microsoft.com/en-us/pricing/details/sql-database/. Possible
     values include: 'Basic', 'Standard', 'Premium', 'PremiumRS'
    :type catalog_pricing_tier: str or
     ~azure.mgmt.datafactory.models.IntegrationRuntimeSsisCatalogPricingTier
    """

    _validation = {
        'catalog_admin_user_name': {'max_length': 128, 'min_length': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_server_endpoint': {'key': 'catalogServerEndpoint', 'type': 'str'},
        'catalog_admin_user_name': {'key': 'catalogAdminUserName', 'type': 'str'},
        'catalog_admin_password': {'key': 'catalogAdminPassword', 'type': 'SecureString'},
        'catalog_pricing_tier': {'key': 'catalogPricingTier', 'type': 'str'},
    }

    def __init__(self, additional_properties=None, catalog_server_endpoint=None, catalog_admin_user_name=None, catalog_admin_password=None, catalog_pricing_tier=None):
        super(IntegrationRuntimeSsisCatalogInfo, self).__init__()
        self.additional_properties = additional_properties
        self.catalog_server_endpoint = catalog_server_endpoint
        self.catalog_admin_user_name = catalog_admin_user_name
        self.catalog_admin_password = catalog_admin_password
        self.catalog_pricing_tier = catalog_pricing_tier
