# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeAgentInformation(Model):
    """Information about the node agent.

    The Batch node agent is a program that runs on each node in the pool and
    provides Batch capability on the compute node.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of the Batch node agent running on
     the compute node. This version number can be checked against the node
     agent release notes located at
     https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md.
    :type version: str
    :param last_update_time: Required. The time when the node agent was
     updated on the compute node. This is the most recent time that the node
     agent was updated to a new version.
    :type last_update_time: datetime
    """

    _validation = {
        'version': {'required': True},
        'last_update_time': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, version: str, last_update_time, **kwargs) -> None:
        super(NodeAgentInformation, self).__init__(**kwargs)
        self.version = version
        self.last_update_time = last_update_time
