/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.ServiceType;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.filter.RegExpMatchOnPathFilter;
import thredds.crawlabledataset.filter.WildcardMatchOnPathFilter;
import ucar.nc2.ncml.Scanner;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetScannerOld
implements Scanner {
    protected static Logger logger = LoggerFactory.getLogger(DatasetScannerOld.class);
    private CrawlableDataset crawler;
    private CrawlableDatasetFilter filter;
    private boolean wantSubdirs = true;
    private long olderThan_msecs;
    private boolean debugScan = false;

    DatasetScannerOld(Element crawlableDatasetElement, String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS) {
        String crawlerClassName;
        Element crawlerObject = null;
        if (null != crawlableDatasetElement) {
            crawlerClassName = crawlableDatasetElement.getAttributeValue("className");
            crawlerObject = crawlableDatasetElement;
        } else {
            crawlerClassName = "thredds.crawlabledataset.CrawlableDatasetFile";
        }
        try {
            this.crawler = CrawlableDatasetFactory.createCrawlableDataset(dirName, crawlerClassName, crawlerObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        if (null != regexpPatternString) {
            this.filter = new RegExpMatchOnPathFilter(regexpPatternString);
        } else if (suffix != null) {
            this.filter = new WildcardMatchOnPathFilter("*" + suffix);
        }
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            this.wantSubdirs = false;
        }
        if (olderS != null) {
            try {
                TimeUnit tu = new TimeUnit(olderS);
                this.olderThan_msecs = (long)(1000.0 * tu.getValueInSeconds());
            }
            catch (Exception e) {
                logger.error("Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
    }

    @Override
    public void scanDirectory(Map<String, CrawlableDataset> map, CancelTask cancelTask) throws IOException {
        this.scanDirectory(this.crawler, new Date().getTime(), map, cancelTask);
    }

    private void scanDirectory(CrawlableDataset cd, long now, Map<String, CrawlableDataset> map, CancelTask cancelTask) throws IOException {
        if (!cd.exists() || !cd.isCollection()) {
            logger.error("scanDirectory(): the crawlableDataset to be scanned [" + cd.getPath() + "] does not exist or is not a collection.");
            return;
        }
        List<CrawlableDataset> children = cd.listDatasets();
        for (CrawlableDataset child : children) {
            if (this.debugScan && this.filter != null) {
                System.out.println("filter " + child);
            }
            if (child.isCollection() && child.exists()) {
                if (this.wantSubdirs) {
                    this.scanDirectory(child, now, map, cancelTask);
                }
            } else if (this.filter == null || this.filter.accept(child)) {
                long lastModifiedMsecs;
                Date lastModifiedDate;
                if (this.olderThan_msecs > 0L && (lastModifiedDate = child.lastModified()) != null && now - (lastModifiedMsecs = lastModifiedDate.getTime()) < this.olderThan_msecs) continue;
                map.put(child.getPath(), child);
                if (this.debugScan) {
                    System.out.println(" accept " + child.getPath());
                }
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }

    public static void main(String[] args) throws IOException {
        String cat = "http://motherlode.ucar.edu:8080/thredds/catalog/satellite/12.0/WEST-CONUS_4km/20070825/catalog.xml";
        Element config = new Element("config");
        config.setAttribute("className", "thredds.catalog.CrawlableCatalog");
        Element serviceType = new Element("serviceType");
        serviceType.addContent(ServiceType.OPENDAP.toString());
        config.addContent(serviceType);
        DatasetScannerOld crawl = new DatasetScannerOld(config, cat, null, null, "true", null);
        crawl.scanDirectory(new HashMap<String, CrawlableDataset>(), null);
    }
}

