/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import weka.associations.tertius.IndividualInstance;
import weka.associations.tertius.IndividualLiteral;
import weka.associations.tertius.Literal;
import weka.associations.tertius.Rule;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;

public abstract class LiteralSet
implements Serializable,
Cloneable,
RevisionHandler {
    private static final long serialVersionUID = 6094536488654503152L;
    private ArrayList m_literals = new ArrayList();
    private Literal m_lastLiteral = null;
    private int m_numInstances;
    private ArrayList m_counterInstances = null;
    private int m_counter;
    private int m_type = -1;

    public LiteralSet() {
    }

    public LiteralSet(Instances instances) {
        this();
        this.m_numInstances = instances.numInstances();
        this.m_counterInstances = new ArrayList(this.m_numInstances);
        Enumeration enu = instances.enumerateInstances();
        while (enu.hasMoreElements()) {
            this.m_counterInstances.add(enu.nextElement());
        }
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
            ((LiteralSet)result).m_literals = (ArrayList)this.m_literals.clone();
            if (this.m_counterInstances != null) {
                ((LiteralSet)result).m_counterInstances = (ArrayList)this.m_counterInstances.clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return result;
    }

    public void upDate(Instances instances) {
        Enumeration enu = instances.enumerateInstances();
        this.m_numInstances = instances.numInstances();
        this.m_counter = 0;
        while (enu.hasMoreElements()) {
            if (!this.counterInstance((Instance)enu.nextElement())) continue;
            ++this.m_counter;
        }
    }

    public int getCounterInstancesNumber() {
        if (this.m_counterInstances != null) {
            return this.m_counterInstances.size();
        }
        return this.m_counter;
    }

    public double getCounterInstancesFrequency() {
        return (double)this.getCounterInstancesNumber() / (double)this.m_numInstances;
    }

    public boolean overFrequencyThreshold(double minFrequency) {
        return this.getCounterInstancesFrequency() >= minFrequency;
    }

    public boolean hasMaxCounterInstances() {
        return this.getCounterInstancesNumber() == this.m_numInstances;
    }

    public void addElement(Literal element) {
        int type;
        this.m_literals.add(element);
        this.m_lastLiteral = element;
        if (element instanceof IndividualLiteral && (type = ((IndividualLiteral)element).getType()) > this.m_type) {
            this.m_type = type;
        }
        if (this.m_counterInstances != null) {
            for (int i = this.m_counterInstances.size() - 1; i >= 0; --i) {
                Instance current = (Instance)this.m_counterInstances.get(i);
                if (this.canKeep(current, element)) continue;
                this.m_counterInstances.remove(i);
            }
        }
    }

    public final boolean isEmpty() {
        return this.m_literals.size() == 0;
    }

    public final int numLiterals() {
        return this.m_literals.size();
    }

    public final Iterator enumerateLiterals() {
        return this.m_literals.iterator();
    }

    public Literal getLastLiteral() {
        return this.m_lastLiteral;
    }

    public boolean negationIncludedIn(LiteralSet otherSet) {
        Iterator iter = this.enumerateLiterals();
        while (iter.hasNext()) {
            Literal current = (Literal)iter.next();
            if (otherSet.contains(current.getNegation())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Literal lit) {
        return this.m_literals.contains(lit);
    }

    public int getType() {
        return this.m_type;
    }

    public boolean counterInstance(Instance individual, Instance part) {
        Iterator iter = this.enumerateLiterals();
        while (iter.hasNext()) {
            IndividualLiteral current = (IndividualLiteral)iter.next();
            if (current.getType() == IndividualLiteral.INDIVIDUAL_PROPERTY && !this.canKeep(individual, current)) {
                return false;
            }
            if (current.getType() != IndividualLiteral.PART_PROPERTY || this.canKeep(part, current)) continue;
            return false;
        }
        return true;
    }

    public boolean counterInstance(Instance instance) {
        if (instance instanceof IndividualInstance && this.m_type == IndividualLiteral.PART_PROPERTY) {
            Enumeration enu = ((IndividualInstance)instance).getParts().enumerateInstances();
            while (enu.hasMoreElements()) {
                if (!this.counterInstance(instance, (Instance)enu.nextElement())) continue;
                return true;
            }
            return false;
        }
        Iterator iter = this.enumerateLiterals();
        while (iter.hasNext()) {
            Literal current = (Literal)iter.next();
            if (this.canKeep(instance, current)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean canKeep(Instance var1, Literal var2);

    public abstract boolean isIncludedIn(Rule var1);

    public abstract String toString();
}

