use Test::More tests => 1;
use Test::Output;
use File::Temp 'tempdir';
use File::Copy;

my $tmp = tempdir( 'pkg-js-XXXX', TMPDIR => 1, CLEANUP => 1 );

mkdir "$tmp/debian";
copy "test/debian/copyright",        "$tmp/debian";
copy "tools/github-debian-upstream", $tmp;

my $pwd = `pwd`;
chomp $pwd;

chdir $tmp;
`git init`;
our $sub;
if ( $ENV{PKG_TEST_LOCAL} ) {
    combined_like(
        sub {
            print `sh ./github-debian-upstream`;
        },
        qr#Archive: GitHub.*Bug-Database: https://github.com/foo/bar/issues#s
    );
}
else {
    combined_like(
        sub {
            print `/usr/bin/github-debian-upstream`;
        },
        qr#Archive: GitHub.*Bug-Database: https://github.com/foo/bar/issues#s
    );
}
chdir $pwd;
