
struct nessus_plugin {
	int id;
	char * asc_id;
	char * name;
	char * md5sum;
	
	char * category;
	char * copyright;

	char * description;

	char * summary;

	char * family;
	char * version;

	char * cve;
	char * bid;
	char * xrefs;

	struct arglist * plugin_prefs;

	struct nessus_plugin * next;
	int enabled:1;
	int is_current:1;    /* used for the cache */
};



struct nessus_plugin * nessus_plugin_new(char * id, char * name, char * category, char * copyright, char * description, char * summary, char * family, char * version, char * cve, char * bid, char * xrefs);

struct nessus_plugin * nessus_plugin_get_by_name( struct nessus_plugin * plugins, char * name);
struct nessus_plugin * nessus_plugin_get_by_id( struct nessus_plugin * plugins, int id);

void nessus_plugin_set_md5sum(struct nessus_plugin * plugin, const char * md5sum);

struct nessus_plugin* nessus_plugin_duplicate(struct nessus_plugin *);

void nessus_plugin_free(struct nessus_plugin * plugins);

char * nessus_plugin_get_description(struct nessus_plugin * plugin);
