# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/whiteboard.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: whiteboard.py,v 1.21 2003/06/29 03:25:17 snowdog_ Exp $
#
# Description: This file contains some of the basic definitions for the chat
# utilities in the orpg project.
#
__version__ = "$Id: whiteboard.py,v 1.21 2003/06/29 03:25:17 snowdog_ Exp $"

from base import *
#from images import *


#MIN_STICKY_BACK = -0XFFFFFF
#MIN_STICKY_FRONT = 0xFFFFFF


##----------------------------------------
##  line object
##----------------------------------------

#FACE_NONE = 0
#FACE_NORTH = 1
#FACE_NORTHEAST = 2
#FACE_EAST = 3
#FACE_SOUTHEAST = 4
#FACE_SOUTH = 5
#FACE_SOUTHWEST = 6
#FACE_WEST = 7
#FACE_NORTHWEST = 8

#SNAPTO_ALIGN_CENTER = 0
#SNAPTO_ALIGN_TL = 1

def cmp_zorder(first,second):

    f = first.zorder
    s = second.zorder

    if f == None:
        f = 0
    if s == None:
        s = 0

    if f == s:
        value = 0
    elif f < s:
        value = -1
    else:
        value = 1

    return value

class whiteboard_line(protectable_attributes):
    def __init__(self, id,line_string,upperleft,lowerright,color="#000000",width=1):
        protectable_attributes.__init__(self)
        self._protected_attr = ["line_string","upperleft","lowerright","id","linecolor", "linewidth"]

        self.scale = 1
        self.r_h = RGBHex()
        self.linecolor = color
        self.linewidth = width
        self.lowerright = lowerright
        self.upperleft = upperleft
        self.selected = false
        self.line_string = line_string
        self.id = id
        #self._clean_all_attr()


    def set_line_props(self,line_string = "",upperleftx=0,upperlefty=0,lowerrightx=0,lowerrighty=0,color="#000000",width=1):
        self.line_string = line_string
        self.upperleft.x = upperleftx
        self.upperleft.y = upperlefty
        self.lowerright.x = lowerrightx
        self.lowerright.y = lowerrighty
        self.linecolor = color
        self.linewidth = width

    def hit_test(self, pt):
        closestpoint = 999
        xm = pt.x
        ym = pt.y
        coords = self.line_string.split(";")
        for m in range(len(coords)-2):
            xy1 = coords[m].split(",")
            x1 = int(xy1[0])
            y1 = int(xy1[1])
            xy2 = coords[m+1].split(",")
            x2 = int(xy2[0])
            y2 = int(xy2[1])
            numerator = (y1-y2)*xm +(x2-x1)*ym +(x1*y2-x2*y1)
            denominator = ((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1))**0.5
            if denominator <> 0:
                distance = abs(numerator /denominator)
                if distance < closestpoint:
                    closestpoint = distance
        margin = .5
        if closestpoint < margin:
            return closestpoint
        else:
            return -1

    def draw(self,parent, dc, op = wxCOPY):
        self.scale = parent.canvas.layers['grid'].mapscale

        pen = wxBLACK_PEN
        try:
            if self.linecolor <> "#000000":
                r,g,b = self.r_h.rgb_tuple(self.linecolor)
                color = wxColour(r,g,b)
                pen.SetColour(color)
            else:
                pen.SetColour(wxColour(0,0,0))
        except Exception,e:
                pen.SetColour(wxColour(0,0,0))
        #print self.linewidth
        pen.SetWidth( self.linewidth )
        dc.SetPen( pen )
        dc.SetBrush( wxBLACK_BRUSH )
            # draw lines

        dc.SetOptimization( true )
        dc.SetUserScale(self.scale,self.scale)
        dc.BeginDrawing()
        pointArray = self.line_string.split(";")
        x2 = y2 = -999
        for m in range(len(pointArray)-1):
            x = pointArray[m]
            points = x.split(",")
            x1 = int(points[0])
            y1 = int(points[1])
            if x2 <> -999:
                dc.DrawLine(x2,y2,x1,y1)
            x2 = x1
            y2 = y1
        dc.EndDrawing()
        pen.SetColour(wxColour(0,0,0))
        dc.SetPen(pen)
        dc.SetPen(wxNullPen)
        dc.SetBrush(wxNullBrush)
        dc.SetOptimization( false )

        #selected outline
        if self.selected:
            dc.SetPen(wxRED_PEN)
            dc.SetBrush(wxTRANSPARENT_BRUSH)
            dc.DrawLine(self.upperleft.x, self.upperleft.y, self.lowerright.x,self.scale*self.upperleft.y)
            dc.DrawLine(self.upperleft.x, self.upperleft.y,self.upperleft.x, self.scale*self.lowerright.y)
            dc.DrawLine(self.lowerright.x,self.lowerright.y, self.lowerright.x,self.scale*self.upperleft.y)
            dc.DrawLine(self.lowerright.x,self.lowerright.y, self.upperleft.x, self.scale*self.lowerright.y)

            dc.SetBrush(wxNullBrush)
            dc.SetPen(wxNullPen)

            return true
        else:
            return false

    def toxml(self, action = "update",preserve_changed=0):


        xml_str = ""

        if preserve_changed:
            original_changed = self._changed_attr()

        if action == "del":
            xml_str = "<line action='del' id='" + self.id + "'/>"
            return xml_str
        if action == "new":
            self._dirty_all_attr()

        changed = self._changed_attr()

        if changed:

            #  if there are any changes, make sure id is one of them
            if not changed.has_key("id"):
                self._dirty_attr("id")
                changed = self._changed_attr()

            xml_str = "<line"

            xml_str += " action='" + action + "'"

            for a in changed.keys():
                if a == "upperleft":
                    if not(self.upperleft is None):
                        xml_str += " upperleftx='" + str(self.upperleft.x) + "'"
                        xml_str += " upperlefty='" + str(self.upperleft.y) + "'"
                if a == "id":
                    if not (self.id is None):
                        xml_str+= " id='" + self.id + "'"
                if a == "lowerright":
                    if not(self.lowerright is None):
                        xml_str+= " lowerrightx='" + str(self.lowerright.x) + "'"
                        xml_str+= " lowerrighty='" + str(self.lowerright.y) + "'"
                if a == "line_string":
                    if not (self.line_string is None):
                        xml_str+= " line_string='" + self.line_string + "'"
                if a == "linecolor":
                    if not (self.linecolor is None):
                        xml_str += " color='" + str(self.linecolor) + "'"
                if a == "linewidth":
		    if not (self.linewidth is None):
                        xml_str += " width='" + str(self.linewidth) + "'"
            xml_str += "/>"
        self._clean_all_attr()

        if preserve_changed:
            for a in original_changed.keys():
                self._dirty_attr(a)
        return xml_str

    def takedom(self,xml_dom):
        line_string = xml_dom.getAttribute("line_string")
        upperleftx = xml_dom.getAttribute("upperleftx")
        if upperleftx <> "":
            self.upperleft.x = int(upperleftx)
            self._clean_attr("upperleft")

        upperlefty = xml_dom.getAttribute("upperlefty")
        if upperlefty <> "":
            self.upperleft.y = int(upperlefty)
            self._clean_attr("upperleft")

        lowerrightx = xml_dom.getAttribute("lowerrightx")
        if lowerrightx <> "":
            self.lowerright.x = int(lowerrightx)
            self._clean_attr("lowerright")

        lowerrighty = xml_dom.getAttribute("lowerrighty")
        if lowerrighty <> "":
            self.lowerright.y = int(lowerrighty)
            self._clean_attr("lowerright")
  
        id = xml_dom.getAttribute("id")
        if id <> "":
            self.id = id
            self._clean_attr("id")

        color = xml_dom.getAttribute("color")
        self.linecolor = color
        if color <> "":
#            r,g,b = self.r_h.rgb_tupple(color)
#            self.set_color(cmpColour(r,g,b))
            self._clean_attr("linecolor")
            
        width = xml_dom.getAttribute("width")
        self.linewidth = int(width)


##-----------------------------
## whiteboard layer
##-----------------------------
LINE_REMOVE = wxNewId()
LINE_TITLE_HACK = wxNewId()
LINE_COLOR = wxNewId()
MODE_MINI = wxNewId()
MODE_TAPE = wxNewId()
MODE = wxNewId()

line_menu_list = []
class whiteboard_layer(layer_base):

    def __init__(self, canvas):
        layer_base.__init__(self)
        self._protected_attr = ["serial_number"]
        self.canvas = canvas
        #self.drawing = false
        self.r_h = RGBHex()
        self.id = -1
        self.lines = []
        #self.line_string = "0,0;"
        #self.upperleft = wxPoint(0,0)
        #self.lowerright = wxPoint(0,0)
        self.serial_number = 0
        self.color = "#000000"
        self.width = 1
        self._clean_all_attr()
       

    def next_serial( self ):
        self.serial_number += 1
        return self.serial_number

    def get_next_highest_z(self):
        z = len(self.lines)+1
        return z


    def cleanly_collapse_zorder(self):
        #  lock the zorder stuff
        pass
#        sorted_miniatures = self.miniatures[:]
#        sorted_miniatures.sort(cmp_zorder)
#        i = 0
#        for mini in sorted_miniatures:
#            mini.zorder = i
#            i = i + 1
#            mini._clean_attr("zorder")

        #  unlock the zorder stuff



    def collapse_zorder(self):
        #  lock the zorder stuff
        pass
#        sorted_miniatures = self.miniatures[:]
#        sorted_miniatures.sort(cmp_zorder)
#        i = 0
#        for mini in sorted_miniatures:
#            if (mini.zorder != MIN_STICKY_BACK) and (mini.zorder != MIN_STICKY_FRONT):
##                print "zorder is " + str(mini.zorder) + " and is being set to " + str(i)
#                mini.zorder = i
#            else:
#                print "sticky item found having value of " + str( mini.zorder)
#            i = i + 1
        #  unlock the zorder stuff



    def rollback_serial( self ):
        self.serial_number -= 1

    def add_line(self,line_string="", upperleft= "", lowerright="",color="#000000",width=1):
        #pos = str(self.posx) + "," + str(self.posy)
        #size = str(self.sizex) + "," + str(self.sizey)
        id = self.canvas.frame.session.get_next_id()
        line = whiteboard_line(id,line_string,upperleft,lowerright,color=self.color,width=self.width)
        self.lines.append(line)
        line._dirty_all_attr()
        #print self

        xml_str = "<map><whiteboard>"
        xml_str += line.toxml("new")
        xml_str += "</whiteboard></map>"
        #print xml_str
        self.canvas.frame.session.send(xml_str)
        self.canvas.Refresh(false)

    def get_line_by_id(self,id):

        for line in self.lines:
            if line.id == id:
                return line
        return None

    def del_line(self,line):
        xml_str = "<map><whiteboard>"
        xml_str += line.toxml("del")
        xml_str += "</whiteboard></map>"
        self.canvas.frame.session.send(xml_str)
        if line:
            self.lines.remove(line)
        self.canvas.Refresh(false)
#        self.collapse_zorder()

    def draw(self,dc):
        #print self
        for m in self.lines:
            m.draw(self,dc)

    def find_line(self, pt):
        line = None
        closest = 999
        for m in self.lines:
            distance = m.hit_test(pt)
            if (distance <> -1) and (distance < closest):
                line = m
        if line:
            return line
        else:
            return None

    def setcolor(self,color):
        r,g,b = color.Get()
        self.color=self.r_h.hexstring(r,g,b)

    def sethexcolor(self,hexcolor):
        self.color=hexcolor
    
    def setwidth(self,width):
        self.width = int(width)
        #print width

    def draw_working_line(self, dc, line_string):
        scale = self.canvas.layers['grid'].mapscale

        dc.SetPen( wxBLACK_PEN )
        pen = wxBLACK_PEN
        r,g,b = self.r_h.rgb_tuple(self.color)
        color = wxColour(r,g,b)
        pen.SetColour(color)
        pen.SetWidth(self.width)
        dc.SetBrush( wxBLACK_BRUSH )
        dc.SetOptimization( true )
        dc.SetUserScale(scale,scale)
        dc.BeginDrawing()
        #pointArray = self.line_string.split(";")
        pointArray = line_string.split(";")
        x2 = y2 = -999
        for m in range(len(pointArray)-1):
            x = pointArray[m]
            points = x.split(",")
            x1 = int(points[0])
            y1 = int(points[1])
            if x2 <> -999:
                dc.DrawLine(x2,y2,x1,y1)
            x2 = x1
            y2 = y1
        dc.EndDrawing()
        dc.SetPen(wxNullPen)
        dc.SetBrush(wxNullBrush)
        dc.SetOptimization( false )

    def toxml(self,action="update"):
        """ format  """

        attributes = ""
        if action == "new":
            self._dirty_all_attr()
        changed = self._changed_attr()

        if changed:
            for a in changed.keys():
                if a == "serial_number":
                    attributes += " serial='" + str(self.serial_number) + "'"
                    self._clean_attr("serial_number")

        lines_string = ""
        if self.lines:
            for l in self.lines:
                lines_string += l.toxml(action)

        if lines_string or changed:
            s = "<whiteboard"
            s += attributes
            if lines_string:
                s += ">"
                s += lines_string
                s += "</whiteboard>"
            else:
                s+="/>"

            return s

        else:
            return ""

    def takedom(self,xml_dom):

        serial_number = xml_dom.getAttribute('serial')
        if serial_number <> "":
            self.serial_number = int(serial_number)
            self._clean_attr("serial_number")

        children = xml_dom._get_childNodes()
        for l in children:

  
  #      lines = xml_dom.getElementsByTagName("line")
  #      for l in lines:

            action = l.getAttribute("action")
            id = l.getAttribute('id')

            if action == "del":
                line = self.get_line_by_id(id)
                if line:
                    self.lines.remove(line)
                else:
                    print "Whiteboard error: Deletion of unknown line attempted."
                    #wxMessageBox("Deletion of unknown line attempted","Map Synchronization Error")


            elif action == "new":
#                pos = cmpPoint(int(c.getAttribute('posx')),int(c.getAttribute('posy')))
#                path = c.getAttribute('path')
#                label = c.getAttribute('label')
                try:
                    line_string = l.getAttribute('line_string')
                    upperleftx = l.getAttribute('upperleftx')
                    upperlefty = l.getAttribute('upperlefty')
                    lowerrightx = l.getAttribute('lowerrightx')
                    lowerrighty = l.getAttribute('lowerrighty')
                    upperleft = wxPoint(int(upperleftx),int(upperlefty))
                    lowerright = wxPoint(int(lowerrightx),int(lowerrighty))
                    color = l.getAttribute('color')
                    id = l.getAttribute('id')
                    
                    #fix problem with older clients not supplying the line weight variable
                    width = 1
                    try: width = int(l.getAttribute('width'))
                    except: pass
                    
                except:
                    line_string = upperleftx = upperlefty = lowerrightx = lowerrighty = color = 0
                    print "invalid line"
                    continue
                line = whiteboard_line(id, line_string, upperleft,lowerright,color,width)
                self.lines.append(line)

            else:
                line = self.get_line_by_id(id)
                if line:
                    line.takedom(l)
                else:
                    print "Whiteboard error: Update of unknown line attempted."
                    #wxMessageBox("Update of unknown line attempted","Map Synchronization Error")

        #self.canvas.send_map_data()
        
