/*  AudioVolumeFilterFactory.H
 *
 *  Copyright (C) 2007 Richard Spindler <richard.spindler AT gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _AUDIO_VOLUME_FILTER_FACTORY_H_
#define _AUDIO_VOLUME_FILTER_FACTORY_H_

#include "FilterFactory.H"

namespace nle
{

class Clip;
class AudioVolumeFilterFactory;

extern AudioVolumeFilterFactory* g_audioVolumeFilterFactory;

class AudioVolumeFilterFactory : public FilterFactory
{
	public:
		AudioVolumeFilterFactory();
		const char* name() { return "Audio Volume Automations"; }
		FilterBase* get( Clip* clip );
		~AudioVolumeFilterFactory() {}
		const char* identifier() { return "filter:builtin:VolumeAutomations"; }
};

} /* namespace nle */

#endif /* _AUDIO_VOLUME_FILTER_FACTORY_H_ */
