// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _CDF_MetaDataDriver_HeaderFile
#define _CDF_MetaDataDriver_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_CDF_MetaDataDriver.hxx>

#include <Standard_Transient.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_CDM_MetaData.hxx>
#include <Standard_Integer.hxx>
#include <Handle_CDM_Document.hxx>
#include <Handle_PCDM_ReferenceIterator.hxx>
class Standard_NotImplemented;
class CDM_MetaData;
class TCollection_ExtendedString;
class CDM_Document;
class PCDM_ReferenceIterator;


//! this class list the method that must be available for
//! a specific DBMS
class CDF_MetaDataDriver : public Standard_Transient
{

public:

  
  //! returns true if the MetaDataDriver can manage different
  //! versions of a Data.
  //! By default, returns Standard_False.
  Standard_EXPORT virtual   Standard_Boolean HasVersionCapability() ;
  
  //! Creates a "Depends On"  relation between two Datas.
  //! By default does nothing
  Standard_EXPORT virtual   void CreateDependsOn (const Handle(CDM_MetaData)& aFirstData, const Handle(CDM_MetaData)& aSecondData) ;
  
  Standard_EXPORT virtual   void CreateReference (const Handle(CDM_MetaData)& aFrom, const Handle(CDM_MetaData)& aTo, const Standard_Integer aReferenceIdentifier, const Standard_Integer aToDocumentVersion) ;
  
  //! by default return Standard_True.
  Standard_EXPORT virtual   Standard_Boolean HasVersion (const TCollection_ExtendedString& aFolder, const TCollection_ExtendedString& aName) ;
  
  Standard_EXPORT virtual   TCollection_ExtendedString BuildFileName (const Handle(CDM_Document)& aDocument)  = 0;
  
  //! this methods  is usefull if the name  of an  object --
  //! depends on  the metadatadriver. For  example a Driver
  //! -- based  on the operating  system can choose to  add
  //! the extension of file to create to the object.
  Standard_EXPORT virtual   TCollection_ExtendedString SetName (const Handle(CDM_Document)& aDocument, const TCollection_ExtendedString& aName) ;
  
  //! should indicate whether meta-data exist in the DBMS corresponding
  //! to the Data.
  //! aVersion may be NULL;
  Standard_EXPORT virtual   Standard_Boolean Find (const TCollection_ExtendedString& aFolder, const TCollection_ExtendedString& aName, const TCollection_ExtendedString& aVersion)  = 0;
  
  Standard_EXPORT virtual   Standard_Boolean HasReadPermission (const TCollection_ExtendedString& aFolder, const TCollection_ExtendedString& aName, const TCollection_ExtendedString& aVersion)  = 0;
  
  //! should return the MetaData stored in the DBMS with the meta-data
  //! corresponding to the Data. If the MetaDataDriver has version management capabilities
  //! the version has to be set in the returned MetaData.
  //! aVersion may be NULL
  //! MetaData is called by GetMetaData
  //! If the version is  set to NULL, MetaData should return
  //! the last version of the metadata
  Standard_EXPORT virtual   Handle(CDM_MetaData) MetaData (const TCollection_ExtendedString& aFolder, const TCollection_ExtendedString& aName, const TCollection_ExtendedString& aVersion)  = 0;
  
  //! by default returns aMetaDATA
  //! should return the MetaData stored in the DBMS with the meta-data
  //! corresponding to the path. If the MetaDataDriver has version management capabilities
  //! the version has to be set in the returned MetaData.
  //! MetaData is called by GetMetaData
  //! If the version is not included in the path , MetaData should return
  //! the last version of the metadata
  //! is deferred;
  Standard_EXPORT virtual   Handle(CDM_MetaData) LastVersion (const Handle(CDM_MetaData)& aMetaData) ;
  
  //! should create meta-data corresponding to aData and maintaining a meta-link
  //! between these meta-data and aFileName
  //! CreateMetaData is called by CreateData
  //! If the metadata-driver
  //! has version capabilities, version must be set in the returned Data.
  Standard_EXPORT virtual   Handle(CDM_MetaData) CreateMetaData (const Handle(CDM_Document)& aDocument, const TCollection_ExtendedString& aFileName)  = 0;
  
  Standard_EXPORT virtual   Standard_Boolean FindFolder (const TCollection_ExtendedString& aFolder)  = 0;
  
  Standard_EXPORT virtual   TCollection_ExtendedString DefaultFolder()  = 0;
  
  Standard_EXPORT virtual   Handle(PCDM_ReferenceIterator) ReferenceIterator() ;
  
  //! calls Find with an empty version
  Standard_EXPORT   Standard_Boolean Find (const TCollection_ExtendedString& aFolder, const TCollection_ExtendedString& aName) ;
  
  //! calls MetaData with an empty version
  Standard_EXPORT   Handle(CDM_MetaData) MetaData (const TCollection_ExtendedString& aFolder, const TCollection_ExtendedString& aName) ;




  DEFINE_STANDARD_RTTI(CDF_MetaDataDriver)

protected:

  
  Standard_EXPORT CDF_MetaDataDriver();



private: 




};







#endif // _CDF_MetaDataDriver_HeaderFile
