import test from 'ava';
import propertyValueAliases from '../index.js';

test('unicode-property-value-aliases', t => {
	t.is(
		propertyValueAliases.get('ASCII').get('N'),
		'No'
	);
	t.is(
		propertyValueAliases.get('Any').get('N'),
		'No'
	);
	t.is(
		propertyValueAliases.get('Assigned').get('N'),
		'No'
	);
	t.is(
		propertyValueAliases.get('ASCII_Hex_Digit').get('N'),
		'No'
	);
	t.is(
		propertyValueAliases.get('Age').get('1.1'),
		'V1_1'
	);
	t.is(
		propertyValueAliases.get('Alphabetic').get('False'),
		'No'
	);
	t.is(
		propertyValueAliases.get('Bidi_Class').get('AL'),
		'Arabic_Letter'
	);
	t.is(
		propertyValueAliases.get('Bidi_Control').get('T'),
		'Yes'
	);
	t.is(
		propertyValueAliases.get('Block').get('Alphabetic_PF'),
		'Alphabetic_Presentation_Forms'
	);
	t.is(
		propertyValueAliases.get('Canonical_Combining_Class').get('KV'),
		'Kana_Voicing'
	);
	t.is(
		propertyValueAliases.get('General_Category').get('L'),
		'Letter'
	);
	t.is(
		propertyValueAliases.get('General_Category').get('Lu'),
		'Uppercase_Letter'
	);
	t.is(
		propertyValueAliases.get('General_Category').get('C'),
		'Other'
	);
	t.is(
		propertyValueAliases.get('General_Category').get('Cn'),
		'Unassigned'
	);
	t.is(
		propertyValueAliases.get('Script').get('Aghb'),
		'Caucasian_Albanian'
	);
	t.is(
		propertyValueAliases.get('Script_Extensions').get('Aghb'),
		'Caucasian_Albanian'
	);
});
