#include <fe/njamd.h>
#include <fe/gui/msgbox.h>
#include <fe/gui/util.h>

/*
TODO:
1. Center the msgbox around the parent.
2. Disable the parent.
3. Add whitespace and a separating line.
*/

static void _njGUIMessageBoxOK(GtkWidget* widget, gpointer data);
static void _njGUIMessageBoxDestroyed(GtkWidget* widget, gpointer data);

void njGUIMessageBox(GtkWidget* parent, const char* text, const char* caption,
	NJMsgBoxType type)
{
	GtkWidget* msgbox;
	GtkWidget* vbox;
	GtkWidget* hbox;
	GtkWidget* textLabel;
	GtkWidget* ok;
	GtkWidget* okLabel;

	msgbox = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_modal(GTK_WINDOW(msgbox), TRUE);
	gtk_window_set_title(GTK_WINDOW(msgbox), caption);
	gtk_signal_connect(GTK_OBJECT(msgbox), "destroy",
		GTK_SIGNAL_FUNC(_njGUIMessageBoxDestroyed), (gpointer) parent);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(msgbox), vbox);

	textLabel = gtk_label_new(text);
	gtk_box_pack_start(GTK_BOX(vbox), textLabel, TRUE, FALSE, FALSE);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, FALSE);

	switch (type) {
	case NJMB_OK:
		ok = gtk_button_new();
		gtk_signal_connect(GTK_OBJECT(ok), "clicked",
			GTK_SIGNAL_FUNC(_njGUIMessageBoxOK), msgbox);

		okLabel = gtk_label_new("OK");
		gtk_container_add(GTK_CONTAINER(ok), okLabel);

		gtk_box_pack_start(GTK_BOX(hbox), ok, FALSE, FALSE, FALSE);
		break;
	}

	njCenterWindow(msgbox, parent);
	njSetModal(msgbox, parent, TRUE);

	gtk_widget_show_all(msgbox);
}

static void _njGUIMessageBoxOK(GtkWidget* widget, gpointer data)
{
	gtk_widget_destroy((GtkWidget*) data);
}

static void _njGUIMessageBoxDestroyed(GtkWidget* widget, gpointer data)
{
	njSetModal(widget, (GtkWidget*) data, FALSE);
}
