/**
 * @file portability.h
 *
 * Header file for all the weirdo portability hacks we gotta do.
 */
#ifndef __NJ_LIB_PORTABILITY_H__
#define __NJ_LIB_PORTABILITY_H__
#include <unistd.h>
#include <sys/mman.h>
#include <sys/param.h> // Stupid FBSD...
#include <sys/user.h>
#include <config.h>
#include <lib/util.h>
#include <lib/prefs.h>


/* Try to find NJ_PAGE_SIZE */
#if defined(HAVE_PAGE_SIZE)
# ifndef NJ_PAGE_SIZE
#  if defined(PAGE_SIZE)
#   define NJ_PAGE_SIZE PAGE_SIZE
#  elif defined(EXEC_PAGESIZE)
#   define NJ_PAGE_SIZE EXEC_PAGESIZE
#  elif defined(NBPG)
#   ifndef CLSIZE
#    define CLSIZE 1
#   endif
#   define NJ_PAGE_SIZE (NBPG*CLSIZE)
#  elif defined(NBPC)
#   define NJ_PAGE_SIZE (NBPC)
#  elif defined(PAGESIZE)
#   define NJ_PAGE_SIZE PAGESIZE
#  endif
# endif
#endif

#if defined(HAVE_PAGE_SHIFT)
# define NJ_PAGE_SHIFT PAGE_SHIFT
#endif

#if defined(HAVE_PAGE_MASK)
# ifdef NEGATE_PAGE_MASK
#  define NJ_PAGE_MASK			(~PAGE_MASK)
# else
#  define NJ_PAGE_MASK 			  PAGE_MASK
# endif
#endif


/* MAP ANONYMOUS */ 
#if !defined(MAP_ANONYMOUS) && defined(MAP_ANON)              
# define MAP_ANONYMOUS MAP_ANON                               
#endif                                                        
                                                              
#if defined(MAP_ANONYMOUS) && !defined(MAP_ANON)              
# define MAP_ANON MAP_ANONYMOUS                               
#endif          

#ifndef MAP_ANON
# define MAP_ANON 0
# define MAP_ANONYMOUS 0
#endif


/* Also in fe/njamd.h */
#ifndef HAVE_VSNPRINTF
# define vsnprintf(s, n, f, ap)			vsprintf(s, f, ap)
#endif

#ifndef HAVE_SNPRINTF
# define snprintf(s, n, f, ap...)		sprintf(s, f, ## ap)
#endif

extern int					__nj_anonfd;
extern nj_addr_t			__nj_sbrk0;
extern int					__nj_prot;

/* These variables are defined for portability, if the PAGE_SIZE and friends
 * aren't available as compile time constants
 */ 

#ifndef NJ_PAGE_SIZE
# if defined(DEBUG) || defined(EDBUG)
#  warning "**** Page Size undefined ****"
# endif
extern u_long                  NJ_PAGE_SIZE;
#endif

#ifndef NJ_PAGE_MASK
extern u_long                  NJ_PAGE_MASK;
#endif      

#ifndef NJ_PAGE_SHIFT
extern u_long                  NJ_PAGE_SHIFT;
#endif

void __nj_portability_bootstrap_init(void);
void __nj_portability_fini(void);
void __nj_portability_user_init(struct nj_prefs *prefs);

#endif /*portability.h */
//vim:ts=4
