/** 
 * @file heap_entry.h
 * Header for heap entry.
 *
 * Copyright (C) 2000 by Mike Perry.
 * Distributed WITHOUT WARRANTY under the GPL. See COPYING for details.
 * 
 */
#ifndef __NJ_LIB_HEAP_ENTRY_H__
#define __NJ_LIB_HEAP_ENTRY_H__
#include <lib/callstack.h>
#include <config.h>

/** Heap entry. Describes a block of memory */
struct nj_heap_entry
{
	nj_addr_t block; 			 		/**< Location of block in memory */
	struct nj_callstack freed;			/**< Free callstack */
	struct nj_callstack alloced;		/**< Allocation callstack */
	u_int  alloc_type : 2;				/**< Allocation Type */
	u_int  align_shift : 3;				/**< Logarithmic scale of alignment (max 128) */
	size_t user_len : sizeof(size_t)*8 - 5; /**< Length of the user segment (max 128M) */
};

/** @TODO writeme */
#define LOG2(x)

/** 
 * Determines if an entry is free. We store a special return address
 * (NJ_RETADDR_NOTFREE) in the freed stacktrace if an entry is not free.
 * @see __nj_new_heap_entry()
 */
#define NJ_HEAP_ENTRY_FREED(entry)		((entry)->freed.index != NJ_CALLSTACK_INDEX_NOTFREE)

#endif /* Heap entry.h */
// vim:ts=4
