/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.websvc.spi.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.tree.TreeSelectionModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;

/** Default ClientSelection panel.
 *
 * @authorMilan Kuchtiak
 */
public abstract class DefaultClientSelectionPanel
        extends InvokeOperationCookie.ClientSelectionPanel
        implements ExplorerManager.Provider {

    private ExplorerManager manager;
    private FileObject targetFile;
    private Node selectedMethod;
    private BeanTreeView treeView;
    private NodeChangeListener nodeChangeListener;

    /** Constructor for ClientSelectioPanel.
     *
     * @param targetFile fileObject representing target file
     */
    public DefaultClientSelectionPanel(FileObject targetFile) {
        this.targetFile = targetFile;
        manager = new ExplorerManager();
        initComponents();
        initUserComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblTreeView = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLblTreeView, NbBundle.getMessage(DefaultClientSelectionPanel.class, "LBL_AvailableWebServices")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 11);
        add(jLblTreeView, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLblTreeView;
    // End of variables declaration//GEN-END:variables

    private void initUserComponents() {
        treeView = new BeanTreeView();
        treeView.setRootVisible(false);
        treeView.setPopupAllowed(false);

        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(treeView, gridBagConstraints);
        jLblTreeView.setLabelFor(treeView.getViewport().getView());
        treeView.getAccessibleContext().setAccessibleName(
                NbBundle.getMessage(DefaultClientSelectionPanel.class, "ACSD_AvailableWebServicesTree"));
        treeView.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(DefaultClientSelectionPanel.class, "ACSD_AvailableWebServicesTree"));
        treeView.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    }

    @Override
    public ExplorerManager getExplorerManager() {
        return manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (nodeChangeListener == null) {
            nodeChangeListener = new NodeChangeListener();
        }
        manager.addPropertyChangeListener(nodeChangeListener);
        manager.setRootContext(getRootContext());
        treeView.expandAll();
    }

    @Override
    public void removeNotify() {
        manager.removePropertyChangeListener(nodeChangeListener);
        super.removeNotify();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == manager) {
            if (ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName())) {
                Node[] nodes = manager.getSelectedNodes();
                if (nodes != null && nodes.length > 0) {
                    Node node = nodes[0];
                    if (isClientNode(node)) {
                        // This is a method node.
                        selectedMethod = node;
                        setSelectionValid(true);
                    } else {
                        // This is not a method node.
                        selectedMethod = null;
                        setSelectionValid(false);
                    }
                }
            }
        }
    }

    @Override
    public Lookup getSelectedClient() {
        return selectedMethod.getLookup();
    }

    public final FileObject getTargetFile() {
        return targetFile;
    }

    /** Give root node for bean tree view.
     *
     * @return root node
     */
    protected abstract Node getRootContext();

    /** Check if selected node represents a client.
     *
     * @param node selected node
     * @return triue or false
     */
    protected abstract boolean isClientNode(Node node);

    private class NodeChangeListener implements PropertyChangeListener {

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == manager) {
                if (ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName())) {
                    Node[] nodes = manager.getSelectedNodes();
                    if (nodes != null && nodes.length > 0) {
                        Node node = nodes[0];
                        if (isClientNode(node)) {
                            // This is a method node.
                            selectedMethod = node;
                            setSelectionValid(true);
                        } else {
                            // This is not a method node.
                            selectedMethod = null;
                            setSelectionValid(false);
                        }
                    }
                }
            }
        }

    }

    protected BeanTreeView getTreeView() {
        return treeView;
    }

}
