// DO NOT EDIT. Generated from WebAssembly spec interpreter

let WebAssemblyText = (function() {
  let _registry = {__proto__: null};
  function normalize(file) {
    return file.split('/').reverse()[0].split('.')[0];
  }
  function require(file) {
    let name = normalize(file);
    if (!(name in _registry)) {
      throw new Error('missing module: ' + name)
    } else if (typeof _registry[name] === 'function') {


      let f = _registry[name];
      _registry[name] = function() { throw new Error('cyclic module: ' + name) };
      _registry[name] = f();
    }
    return _registry[name];
  }


  _registry['arrange'] = function() {
    let exports = {};
//////// start of arrange.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var F32                     = require("./f32");
var F64                     = require("./f64");
var I32                     = require("./i32");
var I64                     = require("./i64");
var Lib                     = require("./lib");
var List                    = require("bs-platform/lib/js/list");
var Block                   = require("bs-platform/lib/js/block");
var Curry                   = require("bs-platform/lib/js/curry");
var Types                   = require("./types");
var Buffer                  = require("bs-platform/lib/js/buffer");
var Decode                  = require("./decode");
var Encode                  = require("./encode");
var Printf                  = require("bs-platform/lib/js/printf");
var Source                  = require("./source");
var $$String                = require("bs-platform/lib/js/string");
var Values                  = require("./values");
var Caml_int32              = require("bs-platform/lib/js/caml_int32");
var Pervasives              = require("bs-platform/lib/js/pervasives");
var Caml_builtin_exceptions = require("bs-platform/lib/js/caml_builtin_exceptions");

function add_hex_char(buf, c) {
  return Curry._1(Printf.bprintf(buf, /* Format */[
                  /* Char_literal */Block.__(12, [
                      /* "\\" */92,
                      /* Int */Block.__(4, [
                          /* Int_x */6,
                          /* Lit_padding */Block.__(0, [
                              /* Zeros */2,
                              2
                            ]),
                          /* No_precision */0,
                          /* End_of_format */0
                        ])
                    ]),
                  "\\%02x"
                ]), c);
}

function add_char(buf, c) {
  if (c < /* " " */32 || c >= /* "\127" */127) {
    return add_hex_char(buf, c);
  }
  else {
    if (c === /* "\"" */34 || c === /* "\\" */92) {
      Buffer.add_char(buf, /* "\\" */92);
    }
    return Buffer.add_char(buf, c);
  }
}

function string_with(add_char, s) {
  var buf = Buffer.create(Caml_int32.imul(3, s.length) + 2 | 0);
  Buffer.add_char(buf, /* "\"" */34);
  $$String.iter(Curry._1(add_char, buf), s);
  Buffer.add_char(buf, /* "\"" */34);
  return Buffer.contents(buf);
}

function list_of_opt(param) {
  if (param) {
    return /* :: */[
            param[0],
            /* [] */0
          ];
  }
  else {
    return /* [] */0;
  }
}

function break_bytes(s) {
  var ss = Curry._2(Lib.$$String[/* breakup */0], s, 16);
  var f = function (param) {
    return /* Atom */Block.__(0, [string_with(add_hex_char, param)]);
  };
  return List.map(f, ss);
}

function decls(kind, ts) {
  var head = kind;
  var f = function (param) {
    return /* Atom */Block.__(0, [Types.string_of_value_type(param)]);
  };
  var xs = ts;
  if (xs) {
    return /* :: */[
            /* Node */Block.__(1, [
                head,
                List.map(f, xs)
              ]),
            /* [] */0
          ];
  }
  else {
    return /* [] */0;
  }
}

function func_type(param) {
  return /* Node */Block.__(1, [
            "func",
            Pervasives.$at(decls("param", param[0]), decls("result", param[1]))
          ]);
}

function limits(nat, param) {
  var xs = list_of_opt(param[/* max */1]);
  return $$String.concat(" ", /* :: */[
              Curry._1(nat, param[/* min */0]),
              List.map(nat, xs)
            ]);
}

function global_type(param) {
  var t = param[0];
  if (param[1] !== 0) {
    return /* Node */Block.__(1, [
              "mut",
              /* :: */[
                /* Atom */Block.__(0, [Types.string_of_value_type(t)]),
                /* [] */0
              ]
            ]);
  }
  else {
    return /* Atom */Block.__(0, [Types.string_of_value_type(t)]);
  }
}

function testop(_, _$1) {
  return "eqz";
}

function relop(_, param) {
  switch (param) {
    case 0 : 
        return "eq";
    case 1 : 
        return "ne";
    case 2 : 
        return "lt_s";
    case 3 : 
        return "lt_u";
    case 4 : 
        return "gt_s";
    case 5 : 
        return "gt_u";
    case 6 : 
        return "le_s";
    case 7 : 
        return "le_u";
    case 8 : 
        return "ge_s";
    case 9 : 
        return "ge_u";
    
  }
}

function unop(_, param) {
  switch (param) {
    case 0 : 
        return "clz";
    case 1 : 
        return "ctz";
    case 2 : 
        return "popcnt";
    
  }
}

function binop(_, param) {
  switch (param) {
    case 0 : 
        return "add";
    case 1 : 
        return "sub";
    case 2 : 
        return "mul";
    case 3 : 
        return "div_s";
    case 4 : 
        return "div_u";
    case 5 : 
        return "rem_s";
    case 6 : 
        return "rem_u";
    case 7 : 
        return "and";
    case 8 : 
        return "or";
    case 9 : 
        return "xor";
    case 10 : 
        return "shl";
    case 11 : 
        return "shr_s";
    case 12 : 
        return "shr_u";
    case 13 : 
        return "rotl";
    case 14 : 
        return "rotr";
    
  }
}

function cvtop(xx, param) {
  switch (param) {
    case 0 : 
        return "extend_s/i32";
    case 1 : 
        return "extend_u/i32";
    case 2 : 
        return "wrap/i64";
    case 3 : 
        return "trunc_s/f32";
    case 4 : 
        return "trunc_u/f32";
    case 5 : 
        return "trunc_s/f64";
    case 6 : 
        return "trunc_u/f64";
    case 7 : 
        return "reinterpret/f" + xx;
    
  }
}

function testop$1(_, _$1) {
  throw [
        Caml_builtin_exceptions.assert_failure,
        [
          "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/arrange.ml",
          128,
          27
        ]
      ];
}

function relop$1(_, param) {
  switch (param) {
    case 0 : 
        return "eq";
    case 1 : 
        return "ne";
    case 2 : 
        return "lt";
    case 3 : 
        return "gt";
    case 4 : 
        return "le";
    case 5 : 
        return "ge";
    
  }
}

function unop$1(_, param) {
  switch (param) {
    case 0 : 
        return "neg";
    case 1 : 
        return "abs";
    case 2 : 
        return "ceil";
    case 3 : 
        return "floor";
    case 4 : 
        return "trunc";
    case 5 : 
        return "nearest";
    case 6 : 
        return "sqrt";
    
  }
}

function binop$1(_, param) {
  switch (param) {
    case 0 : 
        return "add";
    case 1 : 
        return "sub";
    case 2 : 
        return "mul";
    case 3 : 
        return "div";
    case 4 : 
        return "min";
    case 5 : 
        return "max";
    case 6 : 
        return "copysign";
    
  }
}

function cvtop$1(xx, param) {
  switch (param) {
    case 0 : 
        return "convert_s/i32";
    case 1 : 
        return "convert_u/i32";
    case 2 : 
        return "convert_s/i64";
    case 3 : 
        return "convert_u/i64";
    case 4 : 
        return "promote/f32";
    case 5 : 
        return "demote/f64";
    case 6 : 
        return "reinterpret/i" + xx;
    
  }
}

function oper(param, op) {
  var floatop = param[1];
  var intop = param[0];
  var $js;
  switch (op.tag | 0) {
    case 0 : 
        $js = Curry._2(intop, "32", op[0]);
        break;
    case 1 : 
        $js = Curry._2(intop, "64", op[0]);
        break;
    case 2 : 
        $js = Curry._2(floatop, "32", op[0]);
        break;
    case 3 : 
        $js = Curry._2(floatop, "64", op[0]);
        break;
    
  }
  return Types.string_of_value_type(Values.type_of(op)) + ("." + $js);
}

var partial_arg = /* tuple */[
  unop,
  unop$1
];

function unop$2(param) {
  return oper(partial_arg, param);
}

var partial_arg$1 = /* tuple */[
  binop,
  binop$1
];

function binop$2(param) {
  return oper(partial_arg$1, param);
}

var partial_arg$2 = /* tuple */[
  testop,
  testop$1
];

function testop$2(param) {
  return oper(partial_arg$2, param);
}

var partial_arg$3 = /* tuple */[
  relop,
  relop$1
];

function relop$2(param) {
  return oper(partial_arg$3, param);
}

var partial_arg$4 = /* tuple */[
  cvtop,
  cvtop$1
];

function cvtop$2(param) {
  return oper(partial_arg$4, param);
}

function mem_size(param) {
  switch (param) {
    case 0 : 
        return "8";
    case 1 : 
        return "16";
    case 2 : 
        return "32";
    
  }
}

function extension(param) {
  if (param !== 0) {
    return "_u";
  }
  else {
    return "_s";
  }
}

function memop(name, param) {
  var offset = param[/* offset */2];
  var align = param[/* align */1];
  var ty = param[/* ty */0];
  return Types.string_of_value_type(ty) + ("." + (name + ((
                offset ? " offset=" + Curry._1(I32.to_string_u, offset) : ""
              ) + (
                (1 << align) === Types.size(ty) ? "" : " align=" + Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, (1 << align)))
              ))));
}

function loadop(op) {
  var match = op[/* sz */3];
  if (match) {
    var match$1 = match[0];
    return memop("load" + (mem_size(match$1[0]) + extension(match$1[1])), op);
  }
  else {
    return memop("load", op);
  }
}

function storeop(op) {
  var match = op[/* sz */3];
  if (match) {
    return memop("store" + mem_size(match[0]), op);
  }
  else {
    return memop("store", op);
  }
}

function $$var(x) {
  return Curry._1(I32.to_string_u, x[/* it */1]);
}

function constop(v) {
  return Types.string_of_value_type(Values.type_of(v[/* it */1])) + ".const";
}

function instr(e) {
  var match = e[/* it */1];
  var match$1;
  if (typeof match === "number") {
    switch (match) {
      case 0 : 
          match$1 = /* tuple */[
            "unreachable",
            /* [] */0
          ];
          break;
      case 1 : 
          match$1 = /* tuple */[
            "nop",
            /* [] */0
          ];
          break;
      case 2 : 
          match$1 = /* tuple */[
            "return",
            /* [] */0
          ];
          break;
      case 3 : 
          match$1 = /* tuple */[
            "drop",
            /* [] */0
          ];
          break;
      case 4 : 
          match$1 = /* tuple */[
            "select",
            /* [] */0
          ];
          break;
      case 5 : 
          match$1 = /* tuple */[
            "current_memory",
            /* [] */0
          ];
          break;
      case 6 : 
          match$1 = /* tuple */[
            "grow_memory",
            /* [] */0
          ];
          break;
      
    }
  }
  else {
    switch (match.tag | 0) {
      case 0 : 
          var f = function (param) {
            return /* Atom */Block.__(0, [Types.string_of_value_type(param)]);
          };
          match$1 = /* tuple */[
            "block",
            Pervasives.$at(List.map(f, match[0]), List.map(instr, match[1]))
          ];
          break;
      case 1 : 
          var f$1 = function (param) {
            return /* Atom */Block.__(0, [Types.string_of_value_type(param)]);
          };
          match$1 = /* tuple */[
            "loop",
            Pervasives.$at(List.map(f$1, match[0]), List.map(instr, match[1]))
          ];
          break;
      case 2 : 
          var f$2 = function (param) {
            return /* Atom */Block.__(0, [Types.string_of_value_type(param)]);
          };
          match$1 = /* tuple */[
            "if",
            Pervasives.$at(List.map(f$2, match[0]), /* :: */[
                  /* Node */Block.__(1, [
                      "then",
                      List.map(instr, match[1])
                    ]),
                  /* :: */[
                    /* Node */Block.__(1, [
                        "else",
                        List.map(instr, match[2])
                      ]),
                    /* [] */0
                  ]
                ])
          ];
          break;
      case 3 : 
          match$1 = /* tuple */[
            "br " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 4 : 
          match$1 = /* tuple */[
            "br_if " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 5 : 
          var xs = Pervasives.$at(match[0], /* :: */[
                match[1],
                /* [] */0
              ]);
          match$1 = /* tuple */[
            "br_table " + $$String.concat(" ", List.map($$var, xs)),
            /* [] */0
          ];
          break;
      case 6 : 
          match$1 = /* tuple */[
            "call " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 7 : 
          match$1 = /* tuple */[
            "call_indirect " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 8 : 
          match$1 = /* tuple */[
            "get_local " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 9 : 
          match$1 = /* tuple */[
            "set_local " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 10 : 
          match$1 = /* tuple */[
            "tee_local " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 11 : 
          match$1 = /* tuple */[
            "get_global " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 12 : 
          match$1 = /* tuple */[
            "set_global " + Curry._1(I32.to_string_u, match[0][/* it */1]),
            /* [] */0
          ];
          break;
      case 13 : 
          match$1 = /* tuple */[
            loadop(match[0]),
            /* [] */0
          ];
          break;
      case 14 : 
          match$1 = /* tuple */[
            storeop(match[0]),
            /* [] */0
          ];
          break;
      case 15 : 
          var lit = match[0];
          match$1 = /* tuple */[
            constop(lit) + (" " + Values.string_of_value(lit[/* it */1])),
            /* [] */0
          ];
          break;
      case 16 : 
          match$1 = /* tuple */[
            Curry._1(testop$2, match[0]),
            /* [] */0
          ];
          break;
      case 17 : 
          match$1 = /* tuple */[
            Curry._1(relop$2, match[0]),
            /* [] */0
          ];
          break;
      case 18 : 
          match$1 = /* tuple */[
            Curry._1(unop$2, match[0]),
            /* [] */0
          ];
          break;
      case 19 : 
          match$1 = /* tuple */[
            Curry._1(binop$2, match[0]),
            /* [] */0
          ];
          break;
      case 20 : 
          match$1 = /* tuple */[
            Curry._1(cvtop$2, match[0]),
            /* [] */0
          ];
          break;
      
    }
  }
  return /* Node */Block.__(1, [
            match$1[0],
            match$1[1]
          ]);
}

function func_with_name(name, f) {
  var match = f[/* it */1];
  return /* Node */Block.__(1, [
            "func" + name,
            Pervasives.$at(/* :: */[
                  /* Node */Block.__(1, [
                      "type " + Curry._1(I32.to_string_u, match[/* ftype */0][/* it */1]),
                      /* [] */0
                    ]),
                  /* [] */0
                ], Pervasives.$at(decls("local", match[/* locals */1]), List.map(instr, match[/* body */2])))
          ]);
}

function func(f) {
  return func_with_name("", f);
}

function start(x) {
  return /* Node */Block.__(1, [
            "start " + Curry._1(I32.to_string_u, x[/* it */1]),
            /* [] */0
          ]);
}

function table(off, i, tab) {
  var match = tab[/* it */1];
  var match$1 = match[/* ttype */0];
  return /* Node */Block.__(1, [
            "table $" + (Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, off + i | 0)) + (" " + limits(I32.to_string_u, match$1[0]))),
            /* :: */[
              /* Atom */Block.__(0, [Types.string_of_elem_type(match$1[1])]),
              /* [] */0
            ]
          ]);
}

function memory(off, i, mem) {
  var match = mem[/* it */1];
  return /* Node */Block.__(1, [
            "memory $" + (Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, off + i | 0)) + (" " + limits(I32.to_string_u, match[/* mtype */0][0]))),
            /* [] */0
          ]);
}

function segment(head, dat, seg) {
  var match = seg[/* it */1];
  return /* Node */Block.__(1, [
            head,
            /* :: */[
              /* Atom */Block.__(0, [Curry._1(I32.to_string_u, match[/* index */0][/* it */1])]),
              /* :: */[
                /* Node */Block.__(1, [
                    "offset",
                    List.map(instr, match[/* offset */1][/* it */1])
                  ]),
                Curry._1(dat, match[/* init */2])
              ]
            ]
          ]);
}

function elems(seg) {
  return segment("elem", function (param) {
              return List.map(function (param) {
                          return /* Atom */Block.__(0, [Curry._1(I32.to_string_u, param[/* it */1])]);
                        }, param);
            }, seg);
}

function data(seg) {
  return segment("data", break_bytes, seg);
}

function typedef(i, t) {
  return /* Node */Block.__(1, [
            "type $" + Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, i)),
            /* :: */[
              func_type(t),
              /* [] */0
            ]
          ]);
}

function import_kind(i, k) {
  var match = k[/* it */1];
  switch (match.tag | 0) {
    case 0 : 
        return /* Node */Block.__(1, [
                  "func $" + Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, i)),
                  /* :: */[
                    /* Node */Block.__(1, [
                        "type",
                        /* :: */[
                          /* Atom */Block.__(0, [Curry._1(I32.to_string_u, match[0][/* it */1])]),
                          /* [] */0
                        ]
                      ]),
                    /* [] */0
                  ]
                ]);
    case 1 : 
        return table(0, i, Source.$at$at(/* record */[/* ttype */match[0]], k[/* at */0]));
    case 2 : 
        return memory(0, i, Source.$at$at(/* record */[/* mtype */match[0]], k[/* at */0]));
    case 3 : 
        return /* Node */Block.__(1, [
                  "global $" + Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, i)),
                  /* :: */[
                    global_type(match[0]),
                    /* [] */0
                  ]
                ]);
    
  }
}

function $$import(i, im) {
  var match = im[/* it */1];
  return /* Node */Block.__(1, [
            "import",
            /* :: */[
              /* Atom */Block.__(0, [string_with(add_char, match[/* module_name */0])]),
              /* :: */[
                /* Atom */Block.__(0, [string_with(add_char, match[/* item_name */1])]),
                /* :: */[
                  import_kind(i, match[/* ikind */2]),
                  /* [] */0
                ]
              ]
            ]
          ]);
}

function export_kind(k) {
  var match = k[/* it */1];
  switch (match) {
    case 0 : 
        return "func";
    case 1 : 
        return "table";
    case 2 : 
        return "memory";
    case 3 : 
        return "global";
    
  }
}

function $$export(ex) {
  var match = ex[/* it */1];
  return /* Node */Block.__(1, [
            "export",
            /* :: */[
              /* Atom */Block.__(0, [string_with(add_char, match[/* name */0])]),
              /* :: */[
                /* Node */Block.__(1, [
                    export_kind(match[/* ekind */1]),
                    /* :: */[
                      /* Atom */Block.__(0, [Curry._1(I32.to_string_u, match[/* item */2][/* it */1])]),
                      /* [] */0
                    ]
                  ]),
                /* [] */0
              ]
            ]
          ]);
}

function var_opt(param) {
  if (param) {
    return " " + param[0][/* it */1];
  }
  else {
    return "";
  }
}

function is_func_import(im) {
  var match = im[/* it */1][/* ikind */2][/* it */1];
  if (match.tag) {
    return /* false */0;
  }
  else {
    return /* true */1;
  }
}

function is_table_import(im) {
  var match = im[/* it */1][/* ikind */2][/* it */1];
  if (match.tag === 1) {
    return /* true */1;
  }
  else {
    return /* false */0;
  }
}

function is_memory_import(im) {
  var match = im[/* it */1][/* ikind */2][/* it */1];
  if (match.tag === 2) {
    return /* true */1;
  }
  else {
    return /* false */0;
  }
}

function is_global_import(im) {
  var match = im[/* it */1][/* ikind */2][/* it */1];
  if (match.tag === 3) {
    return /* true */1;
  }
  else {
    return /* false */0;
  }
}

function module_with_var_opt(x_opt, m) {
  var func_imports = List.filter(is_func_import)(m[/* it */1][/* imports */8]);
  var table_imports = List.filter(is_table_import)(m[/* it */1][/* imports */8]);
  var memory_imports = List.filter(is_memory_import)(m[/* it */1][/* imports */8]);
  var global_imports = List.filter(is_global_import)(m[/* it */1][/* imports */8]);
  var partial_arg = List.length(table_imports);
  var f = function (param, param$1) {
    return table(partial_arg, param, param$1);
  };
  var partial_arg$1 = List.length(memory_imports);
  var f$1 = function (param, param$1) {
    return memory(partial_arg$1, param, param$1);
  };
  var partial_arg$2 = List.length(global_imports);
  var f$2 = function (param, param$1) {
    var off = partial_arg$2;
    var i = param;
    var g = param$1;
    var match = g[/* it */1];
    return /* Node */Block.__(1, [
              "global $" + Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, off + i | 0)),
              /* :: */[
                global_type(match[/* gtype */0]),
                List.map(instr, match[/* value */1][/* it */1])
              ]
            ]);
  };
  var partial_arg$3 = List.length(func_imports);
  var f$3 = function (param, param$1) {
    var off = partial_arg$3;
    var i = param;
    var f$4 = param$1;
    return func_with_name(" $" + Curry._1(I32.to_string_u, Curry._1(I32.of_int_u, off + i | 0)), f$4);
  };
  var xs = list_of_opt(m[/* it */1][/* start */5]);
  return /* Node */Block.__(1, [
            "module" + var_opt(x_opt),
            Pervasives.$at(List.mapi(typedef, m[/* it */1][/* types */0]), Pervasives.$at(List.mapi($$import, table_imports), Pervasives.$at(List.mapi($$import, memory_imports), Pervasives.$at(List.mapi($$import, global_imports), Pervasives.$at(List.mapi($$import, func_imports), Pervasives.$at(List.mapi(f, m[/* it */1][/* tables */2]), Pervasives.$at(List.mapi(f$1, m[/* it */1][/* memories */3]), Pervasives.$at(List.mapi(f$2, m[/* it */1][/* globals */1]), Pervasives.$at(List.mapi(f$3, m[/* it */1][/* funcs */4]), Pervasives.$at(List.map($$export, m[/* it */1][/* exports */9]), Pervasives.$at(List.map(start, xs), Pervasives.$at(List.map(elems, m[/* it */1][/* elems */6]), List.map(data, m[/* it */1][/* data */7])))))))))))))
          ]);
}

function module_(param) {
  return module_with_var_opt(/* None */0, param);
}

function literal(lit) {
  var match = lit[/* it */1];
  switch (match.tag | 0) {
    case 0 : 
        return /* Node */Block.__(1, [
                  "i32.const " + Curry._1(I32.to_string_s, match[0]),
                  /* [] */0
                ]);
    case 1 : 
        return /* Node */Block.__(1, [
                  "i64.const " + Curry._1(I64.to_string_s, match[0]),
                  /* [] */0
                ]);
    case 2 : 
        return /* Node */Block.__(1, [
                  "f32.const " + Curry._1(F32.to_string, match[0]),
                  /* [] */0
                ]);
    case 3 : 
        return /* Node */Block.__(1, [
                  "f64.const " + Curry._1(F64.to_string, match[0]),
                  /* [] */0
                ]);
    
  }
}

function definition(mode, x_opt, def) {
  var match = def[/* it */1];
  var exit = 0;
  exit = mode !== 564146209 && !(mode >= 983167089 && match.tag) ? 1 : 2;
  switch (exit) {
    case 1 : 
        var match$1 = def[/* it */1];
        var m;
        m = match$1.tag ? Decode.decode("", match$1[1]) : match$1[0];
        return module_with_var_opt(x_opt, m);
    case 2 : 
        var match$2 = def[/* it */1];
        var bs;
        bs = match$2.tag ? match$2[1] : Encode.encode(match$2[0]);
        var x_opt$1 = x_opt;
        var bs$1 = bs;
        return /* Node */Block.__(1, [
                  "module" + var_opt(x_opt$1),
                  break_bytes(bs$1)
                ]);
    
  }
}

function access(x_opt, name) {
  return $$String.concat(" ", /* :: */[
              var_opt(x_opt),
              /* :: */[
                string_with(add_char, name),
                /* [] */0
              ]
            ]);
}

function action(act) {
  var match = act[/* it */1];
  if (match.tag) {
    return /* Node */Block.__(1, [
              "get" + access(match[0], match[1]),
              /* [] */0
            ]);
  }
  else {
    return /* Node */Block.__(1, [
              "invoke" + access(match[0], match[1]),
              List.map(literal, match[2])
            ]);
  }
}

function script(mode, scr) {
  return List.map(function (param) {
              var mode$1 = mode;
              var cmd = param;
              var match = cmd[/* it */1];
              switch (match.tag | 0) {
                case 0 : 
                    return definition(mode$1, match[0], match[1]);
                case 1 : 
                    return /* Node */Block.__(1, [
                              "register " + (string_with(add_char, match[0]) + var_opt(match[1])),
                              /* [] */0
                            ]);
                case 2 : 
                    return action(match[0]);
                case 3 : 
                    var mode$2 = mode$1;
                    var ass = match[0];
                    var match$1 = ass[/* it */1];
                    switch (match$1.tag | 0) {
                      case 0 : 
                          return /* Node */Block.__(1, [
                                    "assert_malformed",
                                    /* :: */[
                                      definition(/* Original */983167089, /* None */0, match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      case 1 : 
                          return /* Node */Block.__(1, [
                                    "assert_invalid",
                                    /* :: */[
                                      definition(mode$2, /* None */0, match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      case 2 : 
                          return /* Node */Block.__(1, [
                                    "assert_soft_invalid",
                                    /* :: */[
                                      definition(mode$2, /* None */0, match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      case 3 : 
                          return /* Node */Block.__(1, [
                                    "assert_unlinkable",
                                    /* :: */[
                                      definition(mode$2, /* None */0, match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      case 4 : 
                          return /* Node */Block.__(1, [
                                    "assert_trap",
                                    /* :: */[
                                      definition(mode$2, /* None */0, match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      case 5 : 
                          return /* Node */Block.__(1, [
                                    "assert_return",
                                    /* :: */[
                                      action(match$1[0]),
                                      List.map(literal, match$1[1])
                                    ]
                                  ]);
                      case 6 : 
                          return /* Node */Block.__(1, [
                                    "assert_return_nan",
                                    /* :: */[
                                      action(match$1[0]),
                                      /* [] */0
                                    ]
                                  ]);
                      case 7 : 
                          return /* Node */Block.__(1, [
                                    "assert_trap",
                                    /* :: */[
                                      action(match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      case 8 : 
                          return /* Node */Block.__(1, [
                                    "assert_exhaustion",
                                    /* :: */[
                                      action(match$1[0]),
                                      /* :: */[
                                        /* Atom */Block.__(0, [string_with(add_char, match$1[1])]),
                                        /* [] */0
                                      ]
                                    ]
                                  ]);
                      
                    }
                case 4 : 
                    throw [
                          Caml_builtin_exceptions.assert_failure,
                          [
                            "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/arrange.ml",
                            435,
                            14
                          ]
                        ];
                
              }
            }, scr);
}

exports.instr   = instr;
exports.func    = func;
exports.module_ = module_;
exports.script  = script;
/* F32 Not a pure module */
//////// end of arrange.js ////////
    return exports;
  };


  _registry['array'] = function() {
    let exports = {};
//////// start of array.js ////////
'use strict';

var Curry                   = require("./curry");
var Caml_array              = require("./caml_array");
var Caml_exceptions         = require("./caml_exceptions");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function init(l, f) {
  if (l) {
    if (l < 0) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Array.init"
          ];
    }
    else {
      var res = Caml_array.caml_make_vect(l, Curry._1(f, 0));
      for(var i = 1 ,i_finish = l - 1 | 0; i <= i_finish; ++i){
        res[i] = Curry._1(f, i);
      }
      return res;
    }
  }
  else {
    return /* array */[];
  }
}

function make_matrix(sx, sy, init) {
  var res = Caml_array.caml_make_vect(sx, /* array */[]);
  for(var x = 0 ,x_finish = sx - 1 | 0; x <= x_finish; ++x){
    res[x] = Caml_array.caml_make_vect(sy, init);
  }
  return res;
}

function copy(a) {
  var l = a.length;
  if (l) {
    return Caml_array.caml_array_sub(a, 0, l);
  }
  else {
    return /* array */[];
  }
}

function append(a1, a2) {
  var l1 = a1.length;
  if (l1) {
    if (a2.length) {
      return a1.concat(a2);
    }
    else {
      return Caml_array.caml_array_sub(a1, 0, l1);
    }
  }
  else {
    return copy(a2);
  }
}

function sub(a, ofs, len) {
  if (len < 0 || ofs > (a.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Array.sub"
        ];
  }
  else {
    return Caml_array.caml_array_sub(a, ofs, len);
  }
}

function fill(a, ofs, len, v) {
  if (ofs < 0 || len < 0 || ofs > (a.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Array.fill"
        ];
  }
  else {
    for(var i = ofs ,i_finish = (ofs + len | 0) - 1 | 0; i <= i_finish; ++i){
      a[i] = v;
    }
    return /* () */0;
  }
}

function blit(a1, ofs1, a2, ofs2, len) {
  if (len < 0 || ofs1 < 0 || ofs1 > (a1.length - len | 0) || ofs2 < 0 || ofs2 > (a2.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Array.blit"
        ];
  }
  else {
    return Caml_array.caml_array_blit(a1, ofs1, a2, ofs2, len);
  }
}

function iter(f, a) {
  for(var i = 0 ,i_finish = a.length - 1 | 0; i <= i_finish; ++i){
    Curry._1(f, a[i]);
  }
  return /* () */0;
}

function map(f, a) {
  var l = a.length;
  if (l) {
    var r = Caml_array.caml_make_vect(l, Curry._1(f, a[0]));
    for(var i = 1 ,i_finish = l - 1 | 0; i <= i_finish; ++i){
      r[i] = Curry._1(f, a[i]);
    }
    return r;
  }
  else {
    return /* array */[];
  }
}

function iteri(f, a) {
  for(var i = 0 ,i_finish = a.length - 1 | 0; i <= i_finish; ++i){
    Curry._2(f, i, a[i]);
  }
  return /* () */0;
}

function mapi(f, a) {
  var l = a.length;
  if (l) {
    var r = Caml_array.caml_make_vect(l, Curry._2(f, 0, a[0]));
    for(var i = 1 ,i_finish = l - 1 | 0; i <= i_finish; ++i){
      r[i] = Curry._2(f, i, a[i]);
    }
    return r;
  }
  else {
    return /* array */[];
  }
}

function to_list(a) {
  var _i = a.length - 1 | 0;
  var _res = /* [] */0;
  while(true) {
    var res = _res;
    var i = _i;
    if (i < 0) {
      return res;
    }
    else {
      _res = /* :: */[
        a[i],
        res
      ];
      _i = i - 1 | 0;
      continue ;
      
    }
  };
}

function list_length(_accu, _param) {
  while(true) {
    var param = _param;
    var accu = _accu;
    if (param) {
      _param = param[1];
      _accu = accu + 1 | 0;
      continue ;
      
    }
    else {
      return accu;
    }
  };
}

function of_list(l) {
  if (l) {
    var a = Caml_array.caml_make_vect(list_length(0, l), l[0]);
    var _i = 1;
    var _param = l[1];
    while(true) {
      var param = _param;
      var i = _i;
      if (param) {
        a[i] = param[0];
        _param = param[1];
        _i = i + 1 | 0;
        continue ;
        
      }
      else {
        return a;
      }
    };
  }
  else {
    return /* array */[];
  }
}

function fold_left(f, x, a) {
  var r = x;
  for(var i = 0 ,i_finish = a.length - 1 | 0; i <= i_finish; ++i){
    r = Curry._2(f, r, a[i]);
  }
  return r;
}

function fold_right(f, a, x) {
  var r = x;
  for(var i = a.length - 1 | 0; i >= 0; --i){
    r = Curry._2(f, a[i], r);
  }
  return r;
}

var Bottom = Caml_exceptions.create("Array.Bottom");

function sort(cmp, a) {
  var maxson = function (l, i) {
    var i31 = ((i + i | 0) + i | 0) + 1 | 0;
    var x = i31;
    if ((i31 + 2 | 0) < l) {
      if (Curry._2(cmp, a[i31], a[i31 + 1 | 0]) < 0) {
        x = i31 + 1 | 0;
      }
      if (Curry._2(cmp, a[x], a[i31 + 2 | 0]) < 0) {
        x = i31 + 2 | 0;
      }
      return x;
    }
    else if ((i31 + 1 | 0) < l && Curry._2(cmp, a[i31], a[i31 + 1 | 0]) < 0) {
      return i31 + 1 | 0;
    }
    else if (i31 < l) {
      return i31;
    }
    else {
      throw [
            Bottom,
            i
          ];
    }
  };
  var trickle = function (l, i, e) {
    try {
      var l$1 = l;
      var _i = i;
      var e$1 = e;
      while(true) {
        var i$1 = _i;
        var j = maxson(l$1, i$1);
        if (Curry._2(cmp, a[j], e$1) > 0) {
          a[i$1] = a[j];
          _i = j;
          continue ;
          
        }
        else {
          a[i$1] = e$1;
          return /* () */0;
        }
      };
    }
    catch (exn){
      if (exn[0] === Bottom) {
        a[exn[1]] = e;
        return /* () */0;
      }
      else {
        throw exn;
      }
    }
  };
  var bubble = function (l, i) {
    try {
      var l$1 = l;
      var _i = i;
      while(true) {
        var i$1 = _i;
        var j = maxson(l$1, i$1);
        a[i$1] = a[j];
        _i = j;
        continue ;
        
      };
    }
    catch (exn){
      if (exn[0] === Bottom) {
        return exn[1];
      }
      else {
        throw exn;
      }
    }
  };
  var trickleup = function (_i, e) {
    while(true) {
      var i = _i;
      var father = (i - 1 | 0) / 3 | 0;
      if (i === father) {
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "array.ml",
                168,
                4
              ]
            ];
      }
      if (Curry._2(cmp, a[father], e) < 0) {
        a[i] = a[father];
        if (father > 0) {
          _i = father;
          continue ;
          
        }
        else {
          a[0] = e;
          return /* () */0;
        }
      }
      else {
        a[i] = e;
        return /* () */0;
      }
    };
  };
  var l = a.length;
  for(var i = ((l + 1 | 0) / 3 | 0) - 1 | 0; i >= 0; --i){
    trickle(l, i, a[i]);
  }
  for(var i$1 = l - 1 | 0; i$1 >= 2; --i$1){
    var e = a[i$1];
    a[i$1] = a[0];
    trickleup(bubble(i$1, 0), e);
  }
  if (l > 1) {
    var e$1 = a[1];
    a[1] = a[0];
    a[0] = e$1;
    return /* () */0;
  }
  else {
    return 0;
  }
}

function stable_sort(cmp, a) {
  var merge = function (src1ofs, src1len, src2, src2ofs, src2len, dst, dstofs) {
    var src1r = src1ofs + src1len | 0;
    var src2r = src2ofs + src2len | 0;
    var _i1 = src1ofs;
    var _s1 = a[src1ofs];
    var _i2 = src2ofs;
    var _s2 = src2[src2ofs];
    var _d = dstofs;
    while(true) {
      var d = _d;
      var s2 = _s2;
      var i2 = _i2;
      var s1 = _s1;
      var i1 = _i1;
      if (Curry._2(cmp, s1, s2) <= 0) {
        dst[d] = s1;
        var i1$1 = i1 + 1 | 0;
        if (i1$1 < src1r) {
          _d = d + 1 | 0;
          _s1 = a[i1$1];
          _i1 = i1$1;
          continue ;
          
        }
        else {
          return blit(src2, i2, dst, d + 1 | 0, src2r - i2 | 0);
        }
      }
      else {
        dst[d] = s2;
        var i2$1 = i2 + 1 | 0;
        if (i2$1 < src2r) {
          _d = d + 1 | 0;
          _s2 = src2[i2$1];
          _i2 = i2$1;
          continue ;
          
        }
        else {
          return blit(a, i1, dst, d + 1 | 0, src1r - i1 | 0);
        }
      }
    };
  };
  var isortto = function (srcofs, dst, dstofs, len) {
    for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
      var e = a[srcofs + i | 0];
      var j = (dstofs + i | 0) - 1 | 0;
      while(j >= dstofs && Curry._2(cmp, dst[j], e) > 0) {
        dst[j + 1 | 0] = dst[j];
        j = j - 1 | 0;
      };
      dst[j + 1 | 0] = e;
    }
    return /* () */0;
  };
  var sortto = function (srcofs, dst, dstofs, len) {
    if (len <= 5) {
      return isortto(srcofs, dst, dstofs, len);
    }
    else {
      var l1 = len / 2 | 0;
      var l2 = len - l1 | 0;
      sortto(srcofs + l1 | 0, dst, dstofs + l1 | 0, l2);
      sortto(srcofs, a, srcofs + l2 | 0, l1);
      return merge(srcofs + l2 | 0, l1, dst, dstofs + l1 | 0, l2, dst, dstofs);
    }
  };
  var l = a.length;
  if (l <= 5) {
    return isortto(0, a, 0, l);
  }
  else {
    var l1 = l / 2 | 0;
    var l2 = l - l1 | 0;
    var t = Caml_array.caml_make_vect(l2, a[0]);
    sortto(l1, t, 0, l2);
    sortto(0, a, l2, l1);
    return merge(l2, l1, t, 0, l2, a, 0);
  }
}

var create_matrix = make_matrix;

var concat = Caml_array.caml_array_concat;

var fast_sort = stable_sort;

exports.init          = init;
exports.make_matrix   = make_matrix;
exports.create_matrix = create_matrix;
exports.append        = append;
exports.concat        = concat;
exports.sub           = sub;
exports.copy          = copy;
exports.fill          = fill;
exports.blit          = blit;
exports.to_list       = to_list;
exports.of_list       = of_list;
exports.iter          = iter;
exports.map           = map;
exports.iteri         = iteri;
exports.mapi          = mapi;
exports.fold_left     = fold_left;
exports.fold_right    = fold_right;
exports.sort          = sort;
exports.stable_sort   = stable_sort;
exports.fast_sort     = fast_sort;
/* No side effect */
//////// end of array.js ////////
    return exports;
  };


  _registry['ast'] = function() {
    let exports = {};
//////// start of ast.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Lib      = require("./lib");
var Block    = require("bs-platform/lib/js/block");
var Curry    = require("bs-platform/lib/js/curry");
var Caml_obj = require("bs-platform/lib/js/caml_obj");

var IntOp = /* module */[];

var FloatOp = /* module */[];

function export_kind_of_import_kind(param) {
  switch (param.tag | 0) {
    case 0 : 
        return /* FuncExport */0;
    case 1 : 
        return /* TableExport */1;
    case 2 : 
        return /* MemoryExport */2;
    case 3 : 
        return /* GlobalExport */3;
    
  }
}

function import_type(m, im) {
  var match = im[/* it */1];
  var match$1 = match[/* ikind */2][/* it */1];
  switch (match$1.tag | 0) {
    case 0 : 
        return /* ExternalFuncType */Block.__(0, [Curry._2(Lib.List32[/* nth */1], m[/* it */1][/* types */0], match$1[0][/* it */1])]);
    case 1 : 
        return /* ExternalTableType */Block.__(1, [match$1[0]]);
    case 2 : 
        return /* ExternalMemoryType */Block.__(2, [match$1[0]]);
    case 3 : 
        return /* ExternalGlobalType */Block.__(3, [match$1[0]]);
    
  }
}

function export_type(m, ex) {
  var match = ex[/* it */1];
  var ekind = match[/* ekind */1];
  var _i = match[/* item */2][/* it */1];
  var _param = m[/* it */1][/* imports */8];
  while(true) {
    var param = _param;
    var i = _i;
    if (param) {
      var ims = param[1];
      var im = param[0];
      if (Caml_obj.caml_equal(export_kind_of_import_kind(im[/* it */1][/* ikind */2][/* it */1]), ekind[/* it */1])) {
        if (i) {
          _param = ims;
          _i = i - 1 | 0;
          continue ;
          
        }
        else {
          return import_type(m, im);
        }
      }
      else {
        _param = ims;
        continue ;
        
      }
    }
    else {
      var match$1 = ekind[/* it */1];
      switch (match$1) {
        case 0 : 
            return /* ExternalFuncType */Block.__(0, [Curry._2(Lib.List32[/* nth */1], m[/* it */1][/* types */0], Curry._2(Lib.List32[/* nth */1], m[/* it */1][/* funcs */4], i)[/* it */1][/* ftype */0][/* it */1])]);
        case 1 : 
            return /* ExternalTableType */Block.__(1, [Curry._2(Lib.List32[/* nth */1], m[/* it */1][/* tables */2], i)[/* it */1][/* ttype */0]]);
        case 2 : 
            return /* ExternalMemoryType */Block.__(2, [Curry._2(Lib.List32[/* nth */1], m[/* it */1][/* memories */3], i)[/* it */1][/* mtype */0]]);
        case 3 : 
            return /* ExternalGlobalType */Block.__(3, [Curry._2(Lib.List32[/* nth */1], m[/* it */1][/* globals */1], i)[/* it */1][/* gtype */0]]);
        
      }
    }
  };
}

var I32Op = 0;

var I64Op = 0;

var F32Op = 0;

var F64Op = 0;

var empty_module = /* record */[
  /* types : [] */0,
  /* globals : [] */0,
  /* tables : [] */0,
  /* memories : [] */0,
  /* funcs : [] */0,
  /* start : None */0,
  /* elems : [] */0,
  /* data : [] */0,
  /* imports : [] */0,
  /* exports : [] */0
];

exports.IntOp                      = IntOp;
exports.FloatOp                    = FloatOp;
exports.I32Op                      = I32Op;
exports.I64Op                      = I64Op;
exports.F32Op                      = F32Op;
exports.F64Op                      = F64Op;
exports.empty_module               = empty_module;
exports.export_kind_of_import_kind = export_kind_of_import_kind;
exports.import_type                = import_type;
exports.export_type                = export_type;
/* Lib Not a pure module */
//////// end of ast.js ////////
    return exports;
  };


  _registry['bigarray'] = function() {
    let exports = {};
//////// start of bigarray.js ////////
'use strict';

var Caml_array              = require("./caml_array");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function dims() {
  var n = function () {
      throw "caml_ba_num_dims not implemented by bucklescript yet\n";
    }();
  var d = Caml_array.caml_make_vect(n, 0);
  for(var i = 0 ,i_finish = n - 1 | 0; i <= i_finish; ++i){
    d[i] = function () {
        throw "caml_ba_dim not implemented by bucklescript yet\n";
      }();
  }
  return d;
}

function map_file(_, $staropt$star, _$1, _$2, _$3, _$4) {
  $staropt$star ? $staropt$star[0] : /* int64 */[
      /* hi */0,
      /* lo */0
    ];
  return function () {
            throw "caml_ba_map_file_bytecode not implemented by bucklescript yet\n";
          }();
}

var Genarray = /* module */[
  /* dims */dims,
  /* map_file */map_file
];

function create(_, _$1, _$2) {
  return function () {
            throw "caml_ba_create not implemented by bucklescript yet\n";
          }();
}

function of_array(kind, layout, data) {
  var ba = create(kind, layout, data.length);
  layout !== 0 ? 1 : 0;
  for(var i = 0 ,i_finish = data.length - 1 | 0; i <= i_finish; ++i){
    (function () {
          throw "caml_ba_set_1 not implemented by bucklescript yet\n";
        }());
  }
  return ba;
}

function map_file$1(fd, pos, kind, layout, shared, dim) {
  return map_file(fd, pos, kind, layout, shared, /* int array */[dim]);
}

var Array1 = /* module */[
  /* create */create,
  /* of_array */of_array,
  /* map_file */map_file$1
];

function create$1(_, _$1, _$2, _$3) {
  return function () {
            throw "caml_ba_create not implemented by bucklescript yet\n";
          }();
}

function slice_left(_, _$1) {
  return function () {
            throw "caml_ba_slice not implemented by bucklescript yet\n";
          }();
}

function slice_right(_, _$1) {
  return function () {
            throw "caml_ba_slice not implemented by bucklescript yet\n";
          }();
}

function of_array$1(kind, layout, data) {
  var dim1 = data.length;
  var dim2 = dim1 ? data[0].length : 0;
  var ba = create$1(kind, layout, dim1, dim2);
  layout !== 0 ? 1 : 0;
  for(var i = 0 ,i_finish = dim1 - 1 | 0; i <= i_finish; ++i){
    var row = data[i];
    if (row.length !== dim2) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Bigarray.Array2.of_array: non-rectangular data"
          ];
    }
    for(var j = 0 ,j_finish = dim2 - 1 | 0; j <= j_finish; ++j){
      (function () {
            throw "caml_ba_set_2 not implemented by bucklescript yet\n";
          }());
    }
  }
  return ba;
}

function map_file$2(fd, pos, kind, layout, shared, dim1, dim2) {
  return map_file(fd, pos, kind, layout, shared, /* int array */[
              dim1,
              dim2
            ]);
}

var Array2 = /* module */[
  /* create */create$1,
  /* slice_left */slice_left,
  /* slice_right */slice_right,
  /* of_array */of_array$1,
  /* map_file */map_file$2
];

function create$2(_, _$1, _$2, _$3, _$4) {
  return function () {
            throw "caml_ba_create not implemented by bucklescript yet\n";
          }();
}

function slice_left_1(_, _$1, _$2) {
  return function () {
            throw "caml_ba_slice not implemented by bucklescript yet\n";
          }();
}

function slice_right_1(_, _$1, _$2) {
  return function () {
            throw "caml_ba_slice not implemented by bucklescript yet\n";
          }();
}

function slice_left_2(_, _$1) {
  return function () {
            throw "caml_ba_slice not implemented by bucklescript yet\n";
          }();
}

function slice_right_2(_, _$1) {
  return function () {
            throw "caml_ba_slice not implemented by bucklescript yet\n";
          }();
}

function of_array$2(kind, layout, data) {
  var dim1 = data.length;
  var dim2 = dim1 ? data[0].length : 0;
  var dim3 = dim2 ? data[0][0].length : 0;
  var ba = create$2(kind, layout, dim1, dim2, dim3);
  layout !== 0 ? 1 : 0;
  for(var i = 0 ,i_finish = dim1 - 1 | 0; i <= i_finish; ++i){
    var row = data[i];
    if (row.length !== dim2) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Bigarray.Array3.of_array: non-cubic data"
          ];
    }
    for(var j = 0 ,j_finish = dim2 - 1 | 0; j <= j_finish; ++j){
      var col = row[j];
      if (col.length !== dim3) {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "Bigarray.Array3.of_array: non-cubic data"
            ];
      }
      for(var k = 0 ,k_finish = dim3 - 1 | 0; k <= k_finish; ++k){
        (function () {
              throw "caml_ba_set_3 not implemented by bucklescript yet\n";
            }());
      }
    }
  }
  return ba;
}

function map_file$3(fd, pos, kind, layout, shared, dim1, dim2, dim3) {
  return map_file(fd, pos, kind, layout, shared, /* int array */[
              dim1,
              dim2,
              dim3
            ]);
}

var Array3 = /* module */[
  /* create */create$2,
  /* slice_left_1 */slice_left_1,
  /* slice_right_1 */slice_right_1,
  /* slice_left_2 */slice_left_2,
  /* slice_right_2 */slice_right_2,
  /* of_array */of_array$2,
  /* map_file */map_file$3
];

function array1_of_genarray(a) {
  if (function () {
        throw "caml_ba_num_dims not implemented by bucklescript yet\n";
      }() === 1) {
    return a;
  }
  else {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Bigarray.array1_of_genarray"
        ];
  }
}

function array2_of_genarray(a) {
  if (function () {
        throw "caml_ba_num_dims not implemented by bucklescript yet\n";
      }() === 2) {
    return a;
  }
  else {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Bigarray.array2_of_genarray"
        ];
  }
}

function array3_of_genarray(a) {
  if (function () {
        throw "caml_ba_num_dims not implemented by bucklescript yet\n";
      }() === 3) {
    return a;
  }
  else {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Bigarray.array3_of_genarray"
        ];
  }
}

function reshape_1(_, _$1) {
  return function () {
            throw "caml_ba_reshape not implemented by bucklescript yet\n";
          }();
}

function reshape_2(_, _$1, _$2) {
  return function () {
            throw "caml_ba_reshape not implemented by bucklescript yet\n";
          }();
}

function reshape_3(_, _$1, _$2, _$3) {
  return function () {
            throw "caml_ba_reshape not implemented by bucklescript yet\n";
          }();
}

var float32 = /* Float32 */0;

var float64 = /* Float64 */1;

var complex32 = /* Complex32 */10;

var complex64 = /* Complex64 */11;

var int8_signed = /* Int8_signed */2;

var int8_unsigned = /* Int8_unsigned */3;

var int16_signed = /* Int16_signed */4;

var int16_unsigned = /* Int16_unsigned */5;

var $$int = /* Int */8;

var int32 = /* Int32 */6;

var int64 = /* Int64 */7;

var nativeint = /* Nativeint */9;

var $$char = /* Char */12;

var c_layout = /* C_layout */0;

var fortran_layout = /* Fortran_layout */1;

function reshape(_, _$1) {
  return function () {
            throw "caml_ba_reshape not implemented by bucklescript yet\n";
          }();
}

exports.float32            = float32;
exports.float64            = float64;
exports.complex32          = complex32;
exports.complex64          = complex64;
exports.int8_signed        = int8_signed;
exports.int8_unsigned      = int8_unsigned;
exports.int16_signed       = int16_signed;
exports.int16_unsigned     = int16_unsigned;
exports.$$int              = $$int;
exports.int32              = int32;
exports.int64              = int64;
exports.nativeint          = nativeint;
exports.$$char             = $$char;
exports.c_layout           = c_layout;
exports.fortran_layout     = fortran_layout;
exports.Genarray           = Genarray;
exports.Array1             = Array1;
exports.Array2             = Array2;
exports.Array3             = Array3;
exports.array1_of_genarray = array1_of_genarray;
exports.array2_of_genarray = array2_of_genarray;
exports.array3_of_genarray = array3_of_genarray;
exports.reshape            = reshape;
exports.reshape_1          = reshape_1;
exports.reshape_2          = reshape_2;
exports.reshape_3          = reshape_3;
/*  Not a pure module */
//////// end of bigarray.js ////////
    return exports;
  };


  _registry['block'] = function() {
    let exports = {};
//////// start of block.js ////////
'use strict';


function __(tag, block) {
  block.tag = tag;
  return block;
}

exports.__ = __;
/* No side effect */
//////// end of block.js ////////
    return exports;
  };


  _registry['buffer'] = function() {
    let exports = {};
//////// start of buffer.js ////////
'use strict';

var Sys                     = require("./sys");
var Bytes                   = require("./bytes");
var Curry                   = require("./curry");
var $$String                = require("./string");
var Pervasives              = require("./pervasives");
var Caml_string             = require("./caml_string");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function create(n) {
  var n$1 = n < 1 ? 1 : n;
  var n$2 = n$1 > Sys.max_string_length ? Sys.max_string_length : n$1;
  var s = Caml_string.caml_create_string(n$2);
  return /* record */[
          /* buffer */s,
          /* position */0,
          /* length */n$2,
          /* initial_buffer */s
        ];
}

function contents(b) {
  return Bytes.sub_string(b[/* buffer */0], 0, b[/* position */1]);
}

function to_bytes(b) {
  return Bytes.sub(b[/* buffer */0], 0, b[/* position */1]);
}

function sub(b, ofs, len) {
  if (ofs < 0 || len < 0 || ofs > (b[/* position */1] - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Buffer.sub"
        ];
  }
  else {
    return Bytes.sub_string(b[/* buffer */0], ofs, len);
  }
}

function blit(src, srcoff, dst, dstoff, len) {
  if (len < 0 || srcoff < 0 || srcoff > (src[/* position */1] - len | 0) || dstoff < 0 || dstoff > (dst.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Buffer.blit"
        ];
  }
  else {
    return Bytes.blit(src[/* buffer */0], srcoff, dst, dstoff, len);
  }
}

function nth(b, ofs) {
  if (ofs < 0 || ofs >= b[/* position */1]) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Buffer.nth"
        ];
  }
  else {
    return b[/* buffer */0][ofs];
  }
}

function length(b) {
  return b[/* position */1];
}

function clear(b) {
  b[/* position */1] = 0;
  return /* () */0;
}

function reset(b) {
  b[/* position */1] = 0;
  b[/* buffer */0] = b[/* initial_buffer */3];
  b[/* length */2] = b[/* buffer */0].length;
  return /* () */0;
}

function resize(b, more) {
  var len = b[/* length */2];
  var new_len = len;
  while((b[/* position */1] + more | 0) > new_len) {
    new_len = (new_len << 1);
  };
  if (new_len > Sys.max_string_length) {
    if ((b[/* position */1] + more | 0) <= Sys.max_string_length) {
      new_len = Sys.max_string_length;
    }
    else {
      throw [
            Caml_builtin_exceptions.failure,
            "Buffer.add: cannot grow buffer"
          ];
    }
  }
  var new_buffer = Caml_string.caml_create_string(new_len);
  Bytes.blit(b[/* buffer */0], 0, new_buffer, 0, b[/* position */1]);
  b[/* buffer */0] = new_buffer;
  b[/* length */2] = new_len;
  return /* () */0;
}

function add_char(b, c) {
  var pos = b[/* position */1];
  if (pos >= b[/* length */2]) {
    resize(b, 1);
  }
  b[/* buffer */0][pos] = c;
  b[/* position */1] = pos + 1 | 0;
  return /* () */0;
}

function add_substring(b, s, offset, len) {
  if (offset < 0 || len < 0 || (offset + len | 0) > s.length) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Buffer.add_substring/add_subbytes"
        ];
  }
  var new_position = b[/* position */1] + len | 0;
  if (new_position > b[/* length */2]) {
    resize(b, len);
  }
  Bytes.blit_string(s, offset, b[/* buffer */0], b[/* position */1], len);
  b[/* position */1] = new_position;
  return /* () */0;
}

function add_subbytes(b, s, offset, len) {
  return add_substring(b, Caml_string.bytes_to_string(s), offset, len);
}

function add_string(b, s) {
  var len = s.length;
  var new_position = b[/* position */1] + len | 0;
  if (new_position > b[/* length */2]) {
    resize(b, len);
  }
  Bytes.blit_string(s, 0, b[/* buffer */0], b[/* position */1], len);
  b[/* position */1] = new_position;
  return /* () */0;
}

function add_bytes(b, s) {
  return add_string(b, Caml_string.bytes_to_string(s));
}

function add_buffer(b, bs) {
  return add_subbytes(b, bs[/* buffer */0], 0, bs[/* position */1]);
}

function add_channel(b, ic, len) {
  if (len < 0 || len > Sys.max_string_length) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Buffer.add_channel"
        ];
  }
  if ((b[/* position */1] + len | 0) > b[/* length */2]) {
    resize(b, len);
  }
  Pervasives.really_input(ic, b[/* buffer */0], b[/* position */1], len);
  b[/* position */1] = b[/* position */1] + len | 0;
  return /* () */0;
}

function output_buffer(oc, b) {
  return Pervasives.output(oc, b[/* buffer */0], 0, b[/* position */1]);
}

function closing(param) {
  if (param !== 40) {
    if (param !== 123) {
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "buffer.ml",
              115,
              9
            ]
          ];
    }
    else {
      return /* "}" */125;
    }
  }
  else {
    return /* ")" */41;
  }
}

function advance_to_closing(opening, closing, k, s, start) {
  var _k = k;
  var _i = start;
  var lim = s.length;
  while(true) {
    var i = _i;
    var k$1 = _k;
    if (i >= lim) {
      throw Caml_builtin_exceptions.not_found;
    }
    else if (Caml_string.get(s, i) === opening) {
      _i = i + 1 | 0;
      _k = k$1 + 1 | 0;
      continue ;
      
    }
    else if (Caml_string.get(s, i) === closing) {
      if (k$1) {
        _i = i + 1 | 0;
        _k = k$1 - 1 | 0;
        continue ;
        
      }
      else {
        return i;
      }
    }
    else {
      _i = i + 1 | 0;
      continue ;
      
    }
  };
}

function advance_to_non_alpha(s, start) {
  var _i = start;
  var lim = s.length;
  while(true) {
    var i = _i;
    if (i >= lim) {
      return lim;
    }
    else {
      var match = Caml_string.get(s, i);
      var exit = 0;
      if (match >= 91) {
        if (match >= 97) {
          if (match >= 123) {
            return i;
          }
          else {
            exit = 1;
          }
        }
        else if (match !== 95) {
          return i;
        }
        else {
          exit = 1;
        }
      }
      else if (match >= 58) {
        if (match >= 65) {
          exit = 1;
        }
        else {
          return i;
        }
      }
      else if (match >= 48) {
        exit = 1;
      }
      else {
        return i;
      }
      if (exit === 1) {
        _i = i + 1 | 0;
        continue ;
        
      }
      
    }
  };
}

function find_ident(s, start, lim) {
  if (start >= lim) {
    throw Caml_builtin_exceptions.not_found;
  }
  else {
    var c = Caml_string.get(s, start);
    var exit = 0;
    if (c !== 40) {
      if (c !== 123) {
        var stop = advance_to_non_alpha(s, start + 1 | 0);
        return /* tuple */[
                $$String.sub(s, start, stop - start | 0),
                stop
              ];
      }
      else {
        exit = 1;
      }
    }
    else {
      exit = 1;
    }
    if (exit === 1) {
      var new_start = start + 1 | 0;
      var stop$1 = advance_to_closing(c, closing(c), 0, s, new_start);
      return /* tuple */[
              $$String.sub(s, new_start, (stop$1 - start | 0) - 1 | 0),
              stop$1 + 1 | 0
            ];
    }
    
  }
}

function add_substitute(b, f, s) {
  var lim = s.length;
  var _previous = /* " " */32;
  var _i = 0;
  while(true) {
    var i = _i;
    var previous = _previous;
    if (i < lim) {
      var current = Caml_string.get(s, i);
      if (current !== 36) {
        if (previous === /* "\\" */92) {
          add_char(b, /* "\\" */92);
          add_char(b, current);
          _i = i + 1 | 0;
          _previous = /* " " */32;
          continue ;
          
        }
        else if (current !== 92) {
          add_char(b, current);
          _i = i + 1 | 0;
          _previous = current;
          continue ;
          
        }
        else {
          _i = i + 1 | 0;
          _previous = current;
          continue ;
          
        }
      }
      else if (previous === /* "\\" */92) {
        add_char(b, current);
        _i = i + 1 | 0;
        _previous = /* " " */32;
        continue ;
        
      }
      else {
        var j = i + 1 | 0;
        var match = find_ident(s, j, lim);
        add_string(b, Curry._1(f, match[0]));
        _i = match[1];
        _previous = /* " " */32;
        continue ;
        
      }
    }
    else if (previous === /* "\\" */92) {
      return add_char(b, previous);
    }
    else {
      return 0;
    }
  };
}

exports.create         = create;
exports.contents       = contents;
exports.to_bytes       = to_bytes;
exports.sub            = sub;
exports.blit           = blit;
exports.nth            = nth;
exports.length         = length;
exports.clear          = clear;
exports.reset          = reset;
exports.add_char       = add_char;
exports.add_string     = add_string;
exports.add_bytes      = add_bytes;
exports.add_substring  = add_substring;
exports.add_subbytes   = add_subbytes;
exports.add_substitute = add_substitute;
exports.add_buffer     = add_buffer;
exports.add_channel    = add_channel;
exports.output_buffer  = output_buffer;
/* No side effect */
//////// end of buffer.js ////////
    return exports;
  };


  _registry['bytes'] = function() {
    let exports = {};
//////// start of bytes.js ////////
'use strict';

var Char                    = require("./char");
var List                    = require("./list");
var Curry                   = require("./curry");
var Caml_obj                = require("./caml_obj");
var Caml_int32              = require("./caml_int32");
var Pervasives              = require("./pervasives");
var Caml_string             = require("./caml_string");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function make(n, c) {
  var s = Caml_string.caml_create_string(n);
  Caml_string.caml_fill_string(s, 0, n, c);
  return s;
}

function init(n, f) {
  var s = Caml_string.caml_create_string(n);
  for(var i = 0 ,i_finish = n - 1 | 0; i <= i_finish; ++i){
    s[i] = Curry._1(f, i);
  }
  return s;
}

var empty = [];

function copy(s) {
  var len = s.length;
  var r = Caml_string.caml_create_string(len);
  Caml_string.caml_blit_bytes(s, 0, r, 0, len);
  return r;
}

function to_string(b) {
  return Caml_string.bytes_to_string(copy(b));
}

function of_string(s) {
  return copy(Caml_string.bytes_of_string(s));
}

function sub(s, ofs, len) {
  if (ofs < 0 || len < 0 || ofs > (s.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.sub / Bytes.sub"
        ];
  }
  else {
    var r = Caml_string.caml_create_string(len);
    Caml_string.caml_blit_bytes(s, ofs, r, 0, len);
    return r;
  }
}

function sub_string(b, ofs, len) {
  return Caml_string.bytes_to_string(sub(b, ofs, len));
}

function extend(s, left, right) {
  var len = (s.length + left | 0) + right | 0;
  var r = Caml_string.caml_create_string(len);
  var match = left < 0 ? /* tuple */[
      -left | 0,
      0
    ] : /* tuple */[
      0,
      left
    ];
  var dstoff = match[1];
  var srcoff = match[0];
  var cpylen = Pervasives.min(s.length - srcoff | 0, len - dstoff | 0);
  if (cpylen > 0) {
    Caml_string.caml_blit_bytes(s, srcoff, r, dstoff, cpylen);
  }
  return r;
}

function fill(s, ofs, len, c) {
  if (ofs < 0 || len < 0 || ofs > (s.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.fill / Bytes.fill"
        ];
  }
  else {
    return Caml_string.caml_fill_string(s, ofs, len, c);
  }
}

function blit(s1, ofs1, s2, ofs2, len) {
  if (len < 0 || ofs1 < 0 || ofs1 > (s1.length - len | 0) || ofs2 < 0 || ofs2 > (s2.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Bytes.blit"
        ];
  }
  else {
    return Caml_string.caml_blit_bytes(s1, ofs1, s2, ofs2, len);
  }
}

function blit_string(s1, ofs1, s2, ofs2, len) {
  if (len < 0 || ofs1 < 0 || ofs1 > (s1.length - len | 0) || ofs2 < 0 || ofs2 > (s2.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.blit / Bytes.blit_string"
        ];
  }
  else {
    return Caml_string.caml_blit_string(s1, ofs1, s2, ofs2, len);
  }
}

function iter(f, a) {
  for(var i = 0 ,i_finish = a.length - 1 | 0; i <= i_finish; ++i){
    Curry._1(f, a[i]);
  }
  return /* () */0;
}

function iteri(f, a) {
  for(var i = 0 ,i_finish = a.length - 1 | 0; i <= i_finish; ++i){
    Curry._2(f, i, a[i]);
  }
  return /* () */0;
}

function concat(sep, l) {
  if (l) {
    var hd = l[0];
    var num = [0];
    var len = [0];
    List.iter(function (s) {
          num[0] = num[0] + 1 | 0;
          len[0] = len[0] + s.length | 0;
          return /* () */0;
        }, l);
    var r = Caml_string.caml_create_string(len[0] + Caml_int32.imul(sep.length, num[0] - 1 | 0) | 0);
    Caml_string.caml_blit_bytes(hd, 0, r, 0, hd.length);
    var pos = [hd.length];
    List.iter(function (s) {
          Caml_string.caml_blit_bytes(sep, 0, r, pos[0], sep.length);
          pos[0] = pos[0] + sep.length | 0;
          Caml_string.caml_blit_bytes(s, 0, r, pos[0], s.length);
          pos[0] = pos[0] + s.length | 0;
          return /* () */0;
        }, l[1]);
    return r;
  }
  else {
    return empty;
  }
}

function cat(a, b) {
  return a.concat(b);
}

function is_space(param) {
  var switcher = param - 9 | 0;
  if (switcher > 4 || switcher < 0) {
    if (switcher !== 23) {
      return /* false */0;
    }
    else {
      return /* true */1;
    }
  }
  else if (switcher !== 2) {
    return /* true */1;
  }
  else {
    return /* false */0;
  }
}

function trim(s) {
  var len = s.length;
  var i = 0;
  while(i < len && is_space(s[i])) {
    i = i + 1 | 0;
  };
  var j = len - 1 | 0;
  while(j >= i && is_space(s[j])) {
    j = j - 1 | 0;
  };
  if (j >= i) {
    return sub(s, i, (j - i | 0) + 1 | 0);
  }
  else {
    return empty;
  }
}

function escaped(s) {
  var n = 0;
  for(var i = 0 ,i_finish = s.length - 1 | 0; i <= i_finish; ++i){
    var match = s[i];
    var $js;
    if (match >= 32) {
      var switcher = match - 34 | 0;
      $js = switcher > 58 || switcher < 0 ? (
          switcher >= 93 ? 4 : 1
        ) : (
          switcher > 57 || switcher < 1 ? 2 : 1
        );
    }
    else {
      $js = match >= 11 ? (
          match !== 13 ? 4 : 2
        ) : (
          match >= 8 ? 2 : 4
        );
    }
    n = n + $js | 0;
  }
  if (n === s.length) {
    return copy(s);
  }
  else {
    var s$prime = Caml_string.caml_create_string(n);
    n = 0;
    for(var i$1 = 0 ,i_finish$1 = s.length - 1 | 0; i$1 <= i_finish$1; ++i$1){
      var c = s[i$1];
      var exit = 0;
      if (c >= 35) {
        if (c !== 92) {
          if (c >= 127) {
            exit = 1;
          }
          else {
            s$prime[n] = c;
          }
        }
        else {
          exit = 2;
        }
      }
      else if (c >= 32) {
        if (c >= 34) {
          exit = 2;
        }
        else {
          s$prime[n] = c;
        }
      }
      else if (c >= 14) {
        exit = 1;
      }
      else {
        switch (c) {
          case 8 : 
              s$prime[n] = /* "\\" */92;
              n = n + 1 | 0;
              s$prime[n] = /* "b" */98;
              break;
          case 9 : 
              s$prime[n] = /* "\\" */92;
              n = n + 1 | 0;
              s$prime[n] = /* "t" */116;
              break;
          case 10 : 
              s$prime[n] = /* "\\" */92;
              n = n + 1 | 0;
              s$prime[n] = /* "n" */110;
              break;
          case 0 : 
          case 1 : 
          case 2 : 
          case 3 : 
          case 4 : 
          case 5 : 
          case 6 : 
          case 7 : 
          case 11 : 
          case 12 : 
              exit = 1;
              break;
          case 13 : 
              s$prime[n] = /* "\\" */92;
              n = n + 1 | 0;
              s$prime[n] = /* "r" */114;
              break;
          
        }
      }
      switch (exit) {
        case 1 : 
            s$prime[n] = /* "\\" */92;
            n = n + 1 | 0;
            s$prime[n] = 48 + (c / 100 | 0) | 0;
            n = n + 1 | 0;
            s$prime[n] = 48 + (c / 10 | 0) % 10 | 0;
            n = n + 1 | 0;
            s$prime[n] = 48 + c % 10 | 0;
            break;
        case 2 : 
            s$prime[n] = /* "\\" */92;
            n = n + 1 | 0;
            s$prime[n] = c;
            break;
        
      }
      n = n + 1 | 0;
    }
    return s$prime;
  }
}

function map(f, s) {
  var l = s.length;
  if (l) {
    var r = Caml_string.caml_create_string(l);
    for(var i = 0 ,i_finish = l - 1 | 0; i <= i_finish; ++i){
      r[i] = Curry._1(f, s[i]);
    }
    return r;
  }
  else {
    return s;
  }
}

function mapi(f, s) {
  var l = s.length;
  if (l) {
    var r = Caml_string.caml_create_string(l);
    for(var i = 0 ,i_finish = l - 1 | 0; i <= i_finish; ++i){
      r[i] = Curry._2(f, i, s[i]);
    }
    return r;
  }
  else {
    return s;
  }
}

function uppercase(s) {
  return map(Char.uppercase, s);
}

function lowercase(s) {
  return map(Char.lowercase, s);
}

function apply1(f, s) {
  if (s.length) {
    var r = copy(s);
    r[0] = Curry._1(f, s[0]);
    return r;
  }
  else {
    return s;
  }
}

function capitalize(s) {
  return apply1(Char.uppercase, s);
}

function uncapitalize(s) {
  return apply1(Char.lowercase, s);
}

function index_rec(s, lim, _i, c) {
  while(true) {
    var i = _i;
    if (i >= lim) {
      throw Caml_builtin_exceptions.not_found;
    }
    else if (s[i] === c) {
      return i;
    }
    else {
      _i = i + 1 | 0;
      continue ;
      
    }
  };
}

function index(s, c) {
  return index_rec(s, s.length, 0, c);
}

function index_from(s, i, c) {
  var l = s.length;
  if (i < 0 || i > l) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.index_from / Bytes.index_from"
        ];
  }
  else {
    return index_rec(s, l, i, c);
  }
}

function rindex_rec(s, _i, c) {
  while(true) {
    var i = _i;
    if (i < 0) {
      throw Caml_builtin_exceptions.not_found;
    }
    else if (s[i] === c) {
      return i;
    }
    else {
      _i = i - 1 | 0;
      continue ;
      
    }
  };
}

function rindex(s, c) {
  return rindex_rec(s, s.length - 1 | 0, c);
}

function rindex_from(s, i, c) {
  if (i < -1 || i >= s.length) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.rindex_from / Bytes.rindex_from"
        ];
  }
  else {
    return rindex_rec(s, i, c);
  }
}

function contains_from(s, i, c) {
  var l = s.length;
  if (i < 0 || i > l) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.contains_from / Bytes.contains_from"
        ];
  }
  else {
    try {
      index_rec(s, l, i, c);
      return /* true */1;
    }
    catch (exn){
      if (exn === Caml_builtin_exceptions.not_found) {
        return /* false */0;
      }
      else {
        throw exn;
      }
    }
  }
}

function contains(s, c) {
  return contains_from(s, 0, c);
}

function rcontains_from(s, i, c) {
  if (i < 0 || i >= s.length) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.rcontains_from / Bytes.rcontains_from"
        ];
  }
  else {
    try {
      rindex_rec(s, i, c);
      return /* true */1;
    }
    catch (exn){
      if (exn === Caml_builtin_exceptions.not_found) {
        return /* false */0;
      }
      else {
        throw exn;
      }
    }
  }
}

var compare = Caml_obj.caml_compare;

var unsafe_to_string = Caml_string.bytes_to_string;

var unsafe_of_string = Caml_string.bytes_of_string;

exports.make             = make;
exports.init             = init;
exports.empty            = empty;
exports.copy             = copy;
exports.of_string        = of_string;
exports.to_string        = to_string;
exports.sub              = sub;
exports.sub_string       = sub_string;
exports.extend           = extend;
exports.fill             = fill;
exports.blit             = blit;
exports.blit_string      = blit_string;
exports.concat           = concat;
exports.cat              = cat;
exports.iter             = iter;
exports.iteri            = iteri;
exports.map              = map;
exports.mapi             = mapi;
exports.trim             = trim;
exports.escaped          = escaped;
exports.index            = index;
exports.rindex           = rindex;
exports.index_from       = index_from;
exports.rindex_from      = rindex_from;
exports.contains         = contains;
exports.contains_from    = contains_from;
exports.rcontains_from   = rcontains_from;
exports.uppercase        = uppercase;
exports.lowercase        = lowercase;
exports.capitalize       = capitalize;
exports.uncapitalize     = uncapitalize;
exports.compare          = compare;
exports.unsafe_to_string = unsafe_to_string;
exports.unsafe_of_string = unsafe_of_string;
/* No side effect */
//////// end of bytes.js ////////
    return exports;
  };


  _registry['caml_array'] = function() {
    let exports = {};
//////// start of caml_array.js ////////
'use strict';


function caml_array_sub(x, offset, len) {
  var result = new Array(len);
  var j = 0;
  var i = offset;
  while(j < len) {
    result[j] = x[i];
    j = j + 1 | 0;
    i = i + 1 | 0;
  };
  return result;
}

function len(_acc, _l) {
  while(true) {
    var l = _l;
    var acc = _acc;
    if (l) {
      _l = l[1];
      _acc = l[0].length + acc | 0;
      continue ;
      
    }
    else {
      return acc;
    }
  };
}

function fill(arr, _i, _l) {
  while(true) {
    var l = _l;
    var i = _i;
    if (l) {
      var x = l[0];
      var l$1 = x.length;
      var k = i;
      var j = 0;
      while(j < l$1) {
        arr[k] = x[j];
        k = k + 1 | 0;
        j = j + 1 | 0;
      };
      _l = l[1];
      _i = k;
      continue ;
      
    }
    else {
      return /* () */0;
    }
  };
}

function caml_array_concat(l) {
  var v = len(0, l);
  var result = new Array(v);
  fill(result, 0, l);
  return result;
}

function caml_make_vect(len, init) {
  var b = new Array(len);
  for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
    b[i] = init;
  }
  return b;
}

function caml_array_blit(a1, i1, a2, i2, len) {
  if (i2 <= i1) {
    for(var j = 0 ,j_finish = len - 1 | 0; j <= j_finish; ++j){
      a2[j + i2 | 0] = a1[j + i1 | 0];
    }
    return /* () */0;
  }
  else {
    for(var j$1 = len - 1 | 0; j$1 >= 0; --j$1){
      a2[j$1 + i2 | 0] = a1[j$1 + i1 | 0];
    }
    return /* () */0;
  }
}

exports.caml_array_sub    = caml_array_sub;
exports.caml_array_concat = caml_array_concat;
exports.caml_make_vect    = caml_make_vect;
exports.caml_array_blit   = caml_array_blit;
/* No side effect */
//////// end of caml_array.js ////////
    return exports;
  };


  _registry['caml_builtin_exceptions'] = function() {
    let exports = {};
//////// start of caml_builtin_exceptions.js ////////
'use strict';


var out_of_memory = /* tuple */[
  "Out_of_memory",
  0
];

var sys_error = /* tuple */[
  "Sys_error",
  -1
];

var failure = /* tuple */[
  "Failure",
  -2
];

var invalid_argument = /* tuple */[
  "Invalid_argument",
  -3
];

var end_of_file = /* tuple */[
  "End_of_file",
  -4
];

var division_by_zero = /* tuple */[
  "Division_by_zero",
  -5
];

var not_found = /* tuple */[
  "Not_found",
  -6
];

var match_failure = /* tuple */[
  "Match_failure",
  -7
];

var stack_overflow = /* tuple */[
  "Stack_overflow",
  -8
];

var sys_blocked_io = /* tuple */[
  "Sys_blocked_io",
  -9
];

var assert_failure = /* tuple */[
  "Assert_failure",
  -10
];

var undefined_recursive_module = /* tuple */[
  "Undefined_recursive_module",
  -11
];

exports.out_of_memory              = out_of_memory;
exports.sys_error                  = sys_error;
exports.failure                    = failure;
exports.invalid_argument           = invalid_argument;
exports.end_of_file                = end_of_file;
exports.division_by_zero           = division_by_zero;
exports.not_found                  = not_found;
exports.match_failure              = match_failure;
exports.stack_overflow             = stack_overflow;
exports.sys_blocked_io             = sys_blocked_io;
exports.assert_failure             = assert_failure;
exports.undefined_recursive_module = undefined_recursive_module;
/* No side effect */
//////// end of caml_builtin_exceptions.js ////////
    return exports;
  };


  _registry['caml_bytes'] = function() {
    let exports = {};
//////// start of caml_bytes.js ////////
'use strict';

var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function get(s, i) {
  if (i < 0 || i >= s.length) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "index out of bounds"
        ];
  }
  else {
    return s[i];
  }
}

exports.get = get;
/* No side effect */
//////// end of caml_bytes.js ////////
    return exports;
  };


  _registry['caml_exceptions'] = function() {
    let exports = {};
//////// start of caml_exceptions.js ////////
'use strict';


var id = [0];

function caml_set_oo_id(b) {
  b[1] = id[0];
  id[0] += 1;
  return b;
}

function get_id() {
  id[0] += 1;
  return id[0];
}

function create(str) {
  var v_001 = get_id(/* () */0);
  var v = /* tuple */[
    str,
    v_001
  ];
  v.tag = 248;
  return v;
}

exports.caml_set_oo_id = caml_set_oo_id;
exports.get_id         = get_id;
exports.create         = create;
/* No side effect */
//////// end of caml_exceptions.js ////////
    return exports;
  };


  _registry['caml_float'] = function() {
    let exports = {};
//////// start of caml_float.js ////////
'use strict';


function caml_int32_float_of_bits(x) {
  var int32 = new Int32Array(/* array */[x]);
  var float32 = new Float32Array(int32.buffer);
  return float32[0];
}

function caml_int32_bits_of_float(x) {
  var float32 = new Float32Array(/* float array */[x]);
  return new Int32Array(float32.buffer)[0];
}

function caml_classify_float(x) {
  if (isFinite(x)) {
    if (Math.abs(x) >= 2.2250738585072014e-308) {
      return /* FP_normal */0;
    }
    else if (x !== 0) {
      return /* FP_subnormal */1;
    }
    else {
      return /* FP_zero */2;
    }
  }
  else if (isNaN(x)) {
    return /* FP_nan */4;
  }
  else {
    return /* FP_infinite */3;
  }
}

function caml_modf_float(x) {
  if (isFinite(x)) {
    var neg = +(1 / x < 0);
    var x$1 = Math.abs(x);
    var i = Math.floor(x$1);
    var f = x$1 - i;
    if (neg) {
      return /* tuple */[
              -f,
              -i
            ];
    }
    else {
      return /* tuple */[
              f,
              i
            ];
    }
  }
  else if (isNaN(x)) {
    return /* tuple */[
            NaN,
            NaN
          ];
  }
  else {
    return /* tuple */[
            1 / x,
            x
          ];
  }
}

var caml_ldexp_float = ( function (x,exp) {
    exp |= 0;
    if (exp > 1023) {
        exp -= 1023;
        x *= Math.pow(2, 1023);
        if (exp > 1023) {  // in case x is subnormal
            exp -= 1023;
            x *= Math.pow(2, 1023);
        }
    }
    if (exp < -1023) {
        exp += 1023;
        x *= Math.pow(2, -1023);
    }
    x *= Math.pow(2, exp);
    return x;
}
);

var caml_frexp_float = (function (x) {
    if ((x == 0) || !isFinite(x)) return [ x, 0];
    var neg = x < 0;
    if (neg) x = - x;
    var exp = Math.floor(Math.LOG2E*Math.log(x)) + 1;
    x *= Math.pow(2,-exp);
    if (x < 0.5) { x *= 2; exp -= 1; }
    if (neg) x = - x;
    return [x, exp];
}
);

function caml_float_compare(x, y) {
  if (x === y) {
    return 0;
  }
  else if (x < y) {
    return -1;
  }
  else if (x > y || x === x) {
    return 1;
  }
  else if (y === y) {
    return -1;
  }
  else {
    return 0;
  }
}

function caml_copysign_float(x, y) {
  var x$1 = Math.abs(x);
  var y$1 = y === 0 ? 1 / y : y;
  if (y$1 < 0) {
    return -x$1;
  }
  else {
    return x$1;
  }
}

function caml_expm1_float(x) {
  var y = Math.exp(x);
  var z = y - 1;
  if (Math.abs(x) > 1) {
    return z;
  }
  else if (z === 0) {
    return x;
  }
  else {
    return x * z / Math.log(y);
  }
}

var caml_hypot_float = ( function (x, y) {
    var x0 = Math.abs(x), y0 = Math.abs(y);
    var a = Math.max(x0, y0), b = Math.min(x0,y0) / (a?a:1);
    return a * Math.sqrt(1 + b*b);
}
);

var caml_log10_float = ( function  (x) { 
   return Math.LOG10E * Math.log(x); }
);

exports.caml_int32_float_of_bits = caml_int32_float_of_bits;
exports.caml_int32_bits_of_float = caml_int32_bits_of_float;
exports.caml_classify_float      = caml_classify_float;
exports.caml_modf_float          = caml_modf_float;
exports.caml_ldexp_float         = caml_ldexp_float;
exports.caml_frexp_float         = caml_frexp_float;
exports.caml_float_compare       = caml_float_compare;
exports.caml_copysign_float      = caml_copysign_float;
exports.caml_expm1_float         = caml_expm1_float;
exports.caml_hypot_float         = caml_hypot_float;
exports.caml_log10_float         = caml_log10_float;
/* caml_ldexp_float Not a pure module */
//////// end of caml_float.js ////////
    return exports;
  };


  _registry['caml_format'] = function() {
    let exports = {};
//////// start of caml_format.js ////////
'use strict';

var Curry                   = require("./curry");
var Caml_int32              = require("./caml_int32");
var Caml_int64              = require("./caml_int64");
var Caml_utils              = require("./caml_utils");
var Caml_string             = require("./caml_string");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function caml_failwith(s) {
  throw [
        Caml_builtin_exceptions.failure,
        s
      ];
}

function parse_digit(c) {
  if (c >= 65) {
    if (c >= 97) {
      if (c >= 123) {
        return -1;
      }
      else {
        return c - 87 | 0;
      }
    }
    else if (c >= 91) {
      return -1;
    }
    else {
      return c - 55 | 0;
    }
  }
  else if (c > 57 || c < 48) {
    return -1;
  }
  else {
    return c - /* "0" */48 | 0;
  }
}

function int_of_string_base(param) {
  switch (param) {
    case 0 : 
        return 8;
    case 1 : 
        return 16;
    case 2 : 
        return 10;
    case 3 : 
        return 2;
    
  }
}

function parse_sign_and_base(s) {
  var sign = 1;
  var base = /* Dec */2;
  var i = 0;
  if (s[i] === "-") {
    sign = -1;
    i = i + 1 | 0;
  }
  var match = s.charCodeAt(i);
  var match$1 = s.charCodeAt(i + 1 | 0);
  if (match === 48) {
    if (match$1 >= 89) {
      if (match$1 !== 98) {
        if (match$1 !== 111) {
          if (match$1 === 120) {
            base = /* Hex */1;
            i = i + 2 | 0;
          }
          
        }
        else {
          base = /* Oct */0;
          i = i + 2 | 0;
        }
      }
      else {
        base = /* Bin */3;
        i = i + 2 | 0;
      }
    }
    else if (match$1 !== 66) {
      if (match$1 !== 79) {
        if (match$1 >= 88) {
          base = /* Hex */1;
          i = i + 2 | 0;
        }
        
      }
      else {
        base = /* Oct */0;
        i = i + 2 | 0;
      }
    }
    else {
      base = /* Bin */3;
      i = i + 2 | 0;
    }
  }
  return /* tuple */[
          i,
          sign,
          base
        ];
}

function caml_int_of_string(s) {
  var match = parse_sign_and_base(s);
  var i = match[0];
  var base = int_of_string_base(match[2]);
  var threshold = 4294967295;
  var len = s.length;
  var c = i < len ? s.charCodeAt(i) : /* "\000" */0;
  var d = parse_digit(c);
  if (d < 0 || d >= base) {
    throw [
          Caml_builtin_exceptions.failure,
          "int_of_string"
        ];
  }
  var aux = function (_acc, _k) {
    while(true) {
      var k = _k;
      var acc = _acc;
      if (k === len) {
        return acc;
      }
      else {
        var a = s.charCodeAt(k);
        if (a === /* "_" */95) {
          _k = k + 1 | 0;
          continue ;
          
        }
        else {
          var v = parse_digit(a);
          if (v < 0 || v >= base) {
            throw [
                  Caml_builtin_exceptions.failure,
                  "int_of_string"
                ];
          }
          else {
            var acc$1 = base * acc + v;
            if (acc$1 > threshold) {
              throw [
                    Caml_builtin_exceptions.failure,
                    "int_of_string"
                  ];
            }
            else {
              _k = k + 1 | 0;
              _acc = acc$1;
              continue ;
              
            }
          }
        }
      }
    };
  };
  var res = match[1] * aux(d, i + 1 | 0);
  var or_res = res | 0;
  if (base === 10 && res !== or_res) {
    throw [
          Caml_builtin_exceptions.failure,
          "int_of_string"
        ];
  }
  return or_res;
}

function caml_int64_of_string(s) {
  var match = parse_sign_and_base(s);
  var hbase = match[2];
  var i = match[0];
  var base = Caml_int64.of_int32(int_of_string_base(hbase));
  var sign = Caml_int64.of_int32(match[1]);
  var threshold;
  switch (hbase) {
    case 0 : 
        threshold = /* int64 */[
          /* hi */536870911,
          /* lo */4294967295
        ];
        break;
    case 1 : 
        threshold = /* int64 */[
          /* hi */268435455,
          /* lo */4294967295
        ];
        break;
    case 2 : 
        threshold = /* int64 */[
          /* hi */429496729,
          /* lo */2576980377
        ];
        break;
    case 3 : 
        threshold = /* int64 */[
          /* hi */2147483647,
          /* lo */4294967295
        ];
        break;
    
  }
  var len = s.length;
  var c = i < len ? s.charCodeAt(i) : /* "\000" */0;
  var d = Caml_int64.of_int32(parse_digit(c));
  if (Caml_int64.lt(d, /* int64 */[
          /* hi */0,
          /* lo */0
        ]) || Caml_int64.ge(d, base)) {
    throw [
          Caml_builtin_exceptions.failure,
          "int64_of_string"
        ];
  }
  var aux = function (_acc, _k) {
    while(true) {
      var k = _k;
      var acc = _acc;
      if (k === len) {
        return acc;
      }
      else {
        var a = s.charCodeAt(k);
        if (a === /* "_" */95) {
          _k = k + 1 | 0;
          continue ;
          
        }
        else {
          var v = Caml_int64.of_int32(parse_digit(a));
          if (Caml_int64.lt(v, /* int64 */[
                  /* hi */0,
                  /* lo */0
                ]) || Caml_int64.ge(v, base)) {
            throw [
                  Caml_builtin_exceptions.failure,
                  "int64_of_string"
                ];
          }
          else {
            var acc$1 = Caml_int64.add(Caml_int64.mul(base, acc), v);
            if (Caml_int64.gt(acc$1, threshold)) {
              throw [
                    Caml_builtin_exceptions.failure,
                    "int64_of_string"
                  ];
            }
            else {
              _k = k + 1 | 0;
              _acc = acc$1;
              continue ;
              
            }
          }
        }
      }
    };
  };
  var res = Caml_int64.mul(sign, aux(d, i + 1 | 0));
  var or_res_000 = /* hi */res[0] | /* hi */0;
  var or_res_001 = /* lo */(res[1] >>> 0);
  var or_res = /* int64 */[
    or_res_000,
    or_res_001
  ];
  if (Caml_int64.eq(base, /* int64 */[
          /* hi */0,
          /* lo */10
        ]) && Caml_int64.neq(res, or_res)) {
    throw [
          Caml_builtin_exceptions.failure,
          "int64_of_string"
        ];
  }
  return or_res;
}

function int_of_base(param) {
  switch (param) {
    case 0 : 
        return 8;
    case 1 : 
        return 16;
    case 2 : 
        return 10;
    
  }
}

function lowercase(c) {
  if (c >= /* "A" */65 && c <= /* "Z" */90 || c >= /* "\192" */192 && c <= /* "\214" */214 || c >= /* "\216" */216 && c <= /* "\222" */222) {
    return c + 32 | 0;
  }
  else {
    return c;
  }
}

function parse_format(fmt) {
  var len = fmt.length;
  if (len > 31) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "format_int: format too long"
        ];
  }
  var f = /* record */[
    /* justify */"+",
    /* signstyle */"-",
    /* filter */" ",
    /* alternate : false */0,
    /* base : Dec */2,
    /* signedconv : false */0,
    /* width */0,
    /* uppercase : false */0,
    /* sign */1,
    /* prec */-1,
    /* conv */"f"
  ];
  var _i = 0;
  while(true) {
    var i = _i;
    if (i >= len) {
      return f;
    }
    else {
      var c = fmt.charCodeAt(i);
      var exit = 0;
      if (c >= 69) {
        if (c >= 88) {
          if (c >= 121) {
            exit = 1;
          }
          else {
            switch (c - 88 | 0) {
              case 0 : 
                  f[/* base */4] = /* Hex */1;
                  f[/* uppercase */7] = /* true */1;
                  _i = i + 1 | 0;
                  continue ;
                  case 13 : 
              case 14 : 
              case 15 : 
                  exit = 5;
                  break;
              case 12 : 
              case 17 : 
                  exit = 4;
                  break;
              case 23 : 
                  f[/* base */4] = /* Oct */0;
                  _i = i + 1 | 0;
                  continue ;
                  case 29 : 
                  f[/* base */4] = /* Dec */2;
                  _i = i + 1 | 0;
                  continue ;
                  case 1 : 
              case 2 : 
              case 3 : 
              case 4 : 
              case 5 : 
              case 6 : 
              case 7 : 
              case 8 : 
              case 9 : 
              case 10 : 
              case 11 : 
              case 16 : 
              case 18 : 
              case 19 : 
              case 20 : 
              case 21 : 
              case 22 : 
              case 24 : 
              case 25 : 
              case 26 : 
              case 27 : 
              case 28 : 
              case 30 : 
              case 31 : 
                  exit = 1;
                  break;
              case 32 : 
                  f[/* base */4] = /* Hex */1;
                  _i = i + 1 | 0;
                  continue ;
                  
            }
          }
        }
        else if (c >= 72) {
          exit = 1;
        }
        else {
          f[/* signedconv */5] = /* true */1;
          f[/* uppercase */7] = /* true */1;
          f[/* conv */10] = String.fromCharCode(lowercase(c));
          _i = i + 1 | 0;
          continue ;
          
        }
      }
      else {
        var switcher = c - 32 | 0;
        if (switcher > 25 || switcher < 0) {
          exit = 1;
        }
        else {
          switch (switcher) {
            case 3 : 
                f[/* alternate */3] = /* true */1;
                _i = i + 1 | 0;
                continue ;
                case 0 : 
            case 11 : 
                exit = 2;
                break;
            case 13 : 
                f[/* justify */0] = "-";
                _i = i + 1 | 0;
                continue ;
                case 14 : 
                f[/* prec */9] = 0;
                var j = i + 1 | 0;
                while((function(j){
                    return function () {
                      var w = fmt.charCodeAt(j) - /* "0" */48 | 0;
                      return +(w >= 0 && w <= 9);
                    }
                    }(j))()) {
                  f[/* prec */9] = (Caml_int32.imul(f[/* prec */9], 10) + fmt.charCodeAt(j) | 0) - /* "0" */48 | 0;
                  j = j + 1 | 0;
                };
                _i = j;
                continue ;
                case 1 : 
            case 2 : 
            case 4 : 
            case 5 : 
            case 6 : 
            case 7 : 
            case 8 : 
            case 9 : 
            case 10 : 
            case 12 : 
            case 15 : 
                exit = 1;
                break;
            case 16 : 
                f[/* filter */2] = "0";
                _i = i + 1 | 0;
                continue ;
                case 17 : 
            case 18 : 
            case 19 : 
            case 20 : 
            case 21 : 
            case 22 : 
            case 23 : 
            case 24 : 
            case 25 : 
                exit = 3;
                break;
            
          }
        }
      }
      switch (exit) {
        case 1 : 
            _i = i + 1 | 0;
            continue ;
            case 2 : 
            f[/* signstyle */1] = String.fromCharCode(c);
            _i = i + 1 | 0;
            continue ;
            case 3 : 
            f[/* width */6] = 0;
            var j$1 = i;
            while((function(j$1){
                return function () {
                  var w = fmt.charCodeAt(j$1) - /* "0" */48 | 0;
                  return +(w >= 0 && w <= 9);
                }
                }(j$1))()) {
              f[/* width */6] = (Caml_int32.imul(f[/* width */6], 10) + fmt.charCodeAt(j$1) | 0) - /* "0" */48 | 0;
              j$1 = j$1 + 1 | 0;
            };
            _i = j$1;
            continue ;
            case 4 : 
            f[/* signedconv */5] = /* true */1;
            f[/* base */4] = /* Dec */2;
            _i = i + 1 | 0;
            continue ;
            case 5 : 
            f[/* signedconv */5] = /* true */1;
            f[/* conv */10] = String.fromCharCode(c);
            _i = i + 1 | 0;
            continue ;
            
      }
    }
  };
}

function finish_formatting(param, rawbuffer) {
  var justify = param[/* justify */0];
  var signstyle = param[/* signstyle */1];
  var filter = param[/* filter */2];
  var alternate = param[/* alternate */3];
  var base = param[/* base */4];
  var signedconv = param[/* signedconv */5];
  var width = param[/* width */6];
  var uppercase = param[/* uppercase */7];
  var sign = param[/* sign */8];
  var len = rawbuffer.length;
  if (signedconv && (sign < 0 || signstyle !== "-")) {
    len = len + 1 | 0;
  }
  if (alternate) {
    if (base) {
      if (base === /* Hex */1) {
        len = len + 2 | 0;
      }
      
    }
    else {
      len = len + 1 | 0;
    }
  }
  var buffer = "";
  if (justify === "+" && filter === " ") {
    for(var i = len ,i_finish = width - 1 | 0; i <= i_finish; ++i){
      buffer = buffer + filter;
    }
  }
  if (signedconv) {
    if (sign < 0) {
      buffer = buffer + "-";
    }
    else if (signstyle !== "-") {
      buffer = buffer + signstyle;
    }
    
  }
  if (alternate && base === /* Oct */0) {
    buffer = buffer + "0";
  }
  if (alternate && base === /* Hex */1) {
    buffer = buffer + "0x";
  }
  if (justify === "+" && filter === "0") {
    for(var i$1 = len ,i_finish$1 = width - 1 | 0; i$1 <= i_finish$1; ++i$1){
      buffer = buffer + filter;
    }
  }
  buffer = uppercase ? buffer + rawbuffer.toUpperCase() : buffer + rawbuffer;
  if (justify === "-") {
    for(var i$2 = len ,i_finish$2 = width - 1 | 0; i$2 <= i_finish$2; ++i$2){
      buffer = buffer + " ";
    }
  }
  return buffer;
}

function caml_format_int(fmt, i) {
  if (fmt === "%d") {
    return "" + i;
  }
  else {
    var f = parse_format(fmt);
    var f$1 = f;
    var i$1 = i;
    var i$2 = i$1 < 0 ? (
        f$1[/* signedconv */5] ? (f$1[/* sign */8] = -1, -i$1) : (i$1 >>> 0)
      ) : i$1;
    var s = i$2.toString(int_of_base(f$1[/* base */4]));
    if (f$1[/* prec */9] >= 0) {
      f$1[/* filter */2] = " ";
      var n = f$1[/* prec */9] - s.length | 0;
      if (n > 0) {
        s = Caml_utils.repeat(n, "0") + s;
      }
      
    }
    return finish_formatting(f$1, s);
  }
}

function caml_int64_format(fmt, x) {
  var f = parse_format(fmt);
  var x$1 = f[/* signedconv */5] && Caml_int64.lt(x, /* int64 */[
        /* hi */0,
        /* lo */0
      ]) ? (f[/* sign */8] = -1, Caml_int64.neg(x)) : x;
  var s = "";
  var match = f[/* base */4];
  switch (match) {
    case 0 : 
        var wbase = /* int64 */[
          /* hi */0,
          /* lo */8
        ];
        var cvtbl = "01234567";
        if (Caml_int64.lt(x$1, /* int64 */[
                /* hi */0,
                /* lo */0
              ])) {
          var y = Caml_int64.discard_sign(x$1);
          var match$1 = Caml_int64.div_mod(y, wbase);
          var quotient = Caml_int64.add(/* int64 */[
                /* hi */268435456,
                /* lo */0
              ], match$1[0]);
          var modulus = match$1[1];
          s = Caml_string.js_string_of_char(cvtbl.charCodeAt(modulus[1] | 0)) + s;
          while(Caml_int64.neq(quotient, /* int64 */[
                  /* hi */0,
                  /* lo */0
                ])) {
            var match$2 = Caml_int64.div_mod(quotient, wbase);
            quotient = match$2[0];
            modulus = match$2[1];
            s = Caml_string.js_string_of_char(cvtbl.charCodeAt(modulus[1] | 0)) + s;
          };
        }
        else {
          var match$3 = Caml_int64.div_mod(x$1, wbase);
          var quotient$1 = match$3[0];
          var modulus$1 = match$3[1];
          s = Caml_string.js_string_of_char(cvtbl.charCodeAt(modulus$1[1] | 0)) + s;
          while(Caml_int64.neq(quotient$1, /* int64 */[
                  /* hi */0,
                  /* lo */0
                ])) {
            var match$4 = Caml_int64.div_mod(quotient$1, wbase);
            quotient$1 = match$4[0];
            modulus$1 = match$4[1];
            s = Caml_string.js_string_of_char(cvtbl.charCodeAt(modulus$1[1] | 0)) + s;
          };
        }
        break;
    case 1 : 
        s = Caml_int64.to_hex(x$1) + s;
        break;
    case 2 : 
        var wbase$1 = /* int64 */[
          /* hi */0,
          /* lo */10
        ];
        var cvtbl$1 = "0123456789";
        if (Caml_int64.lt(x$1, /* int64 */[
                /* hi */0,
                /* lo */0
              ])) {
          var y$1 = Caml_int64.discard_sign(x$1);
          var match$5 = Caml_int64.div_mod(y$1, wbase$1);
          var match$6 = Caml_int64.div_mod(Caml_int64.add(/* int64 */[
                    /* hi */0,
                    /* lo */8
                  ], match$5[1]), wbase$1);
          var quotient$2 = Caml_int64.add(Caml_int64.add(/* int64 */[
                    /* hi */214748364,
                    /* lo */3435973836
                  ], match$5[0]), match$6[0]);
          var modulus$2 = match$6[1];
          s = Caml_string.js_string_of_char(cvtbl$1.charCodeAt(modulus$2[1] | 0)) + s;
          while(Caml_int64.neq(quotient$2, /* int64 */[
                  /* hi */0,
                  /* lo */0
                ])) {
            var match$7 = Caml_int64.div_mod(quotient$2, wbase$1);
            quotient$2 = match$7[0];
            modulus$2 = match$7[1];
            s = Caml_string.js_string_of_char(cvtbl$1.charCodeAt(modulus$2[1] | 0)) + s;
          };
        }
        else {
          var match$8 = Caml_int64.div_mod(x$1, wbase$1);
          var quotient$3 = match$8[0];
          var modulus$3 = match$8[1];
          s = Caml_string.js_string_of_char(cvtbl$1.charCodeAt(modulus$3[1] | 0)) + s;
          while(Caml_int64.neq(quotient$3, /* int64 */[
                  /* hi */0,
                  /* lo */0
                ])) {
            var match$9 = Caml_int64.div_mod(quotient$3, wbase$1);
            quotient$3 = match$9[0];
            modulus$3 = match$9[1];
            s = Caml_string.js_string_of_char(cvtbl$1.charCodeAt(modulus$3[1] | 0)) + s;
          };
        }
        break;
    
  }
  if (f[/* prec */9] >= 0) {
    f[/* filter */2] = " ";
    var n = f[/* prec */9] - s.length | 0;
    if (n > 0) {
      s = Caml_utils.repeat(n, "0") + s;
    }
    
  }
  return finish_formatting(f, s);
}

function caml_format_float(fmt, x) {
  var f = parse_format(fmt);
  var prec = f[/* prec */9] < 0 ? 6 : f[/* prec */9];
  var x$1 = x < 0 ? (f[/* sign */8] = -1, -x) : x;
  var s = "";
  if (isNaN(x$1)) {
    s = "nan";
    f[/* filter */2] = " ";
  }
  else if (isFinite(x$1)) {
    var match = f[/* conv */10];
    switch (match) {
      case "e" : 
          s = x$1.toExponential(prec);
          var i = s.length;
          if (s[i - 3 | 0] === "e") {
            s = s.slice(0, i - 1 | 0) + ("0" + s.slice(i - 1 | 0));
          }
          break;
      case "f" : 
          s = x$1.toFixed(prec);
          break;
      case "g" : 
          var prec$1 = prec !== 0 ? prec : 1;
          s = x$1.toExponential(prec$1 - 1 | 0);
          var j = s.indexOf("e");
          var exp = +s.slice(j + 1 | 0);
          if (exp < -4 || x$1 >= 1e21 || x$1.toFixed(0).length > prec$1) {
            var i$1 = j - 1 | 0;
            while(s[i$1] === "0") {
              i$1 = i$1 - 1 | 0;
            };
            if (s[i$1] === ".") {
              i$1 = i$1 - 1 | 0;
            }
            s = s.slice(0, i$1 + 1 | 0) + s.slice(j);
            var i$2 = s.length;
            if (s[i$2 - 3 | 0] === "e") {
              s = s.slice(0, i$2 - 1 | 0) + ("0" + s.slice(i$2 - 1 | 0));
            }
            
          }
          else {
            var p = prec$1;
            if (exp < 0) {
              p = p - (exp + 1 | 0) | 0;
              s = x$1.toFixed(p);
            }
            else {
              while(function () {
                    s = x$1.toFixed(p);
                    return +(s.length > (prec$1 + 1 | 0));
                  }()) {
                p = p - 1 | 0;
              };
            }
            if (p !== 0) {
              var k = s.length - 1 | 0;
              while(s[k] === "0") {
                k = k - 1 | 0;
              };
              if (s[k] === ".") {
                k = k - 1 | 0;
              }
              s = s.slice(0, k + 1 | 0);
            }
            
          }
          break;
      default:
        
    }
  }
  else {
    s = "inf";
    f[/* filter */2] = " ";
  }
  return finish_formatting(f, s);
}

var float_of_string = (
  function (s, caml_failwith) {
    var res = +s;
    if ((s.length > 0) && (res === res))
        return res;
    s = s.replace(/_/g, "");
    res = +s;
    if (((s.length > 0) && (res === res)) || /^[+-]?nan$/i.test(s)) {
        return res;
    }
    ;
    if (/^ *0x[0-9a-f_]+p[+-]?[0-9_]+/i.test(s)) {
        var pidx = s.indexOf('p');
        pidx = (pidx == -1) ? s.indexOf('P') : pidx;
        var exp = +s.substring(pidx + 1);
        res = +s.substring(0, pidx);
        return res * Math.pow(2, exp);
    }
    if (/^\+?inf(inity)?$/i.test(s))
        return Infinity;
    if (/^-inf(inity)?$/i.test(s))
        return -Infinity;
    caml_failwith("float_of_string");
}

);

function caml_float_of_string(s) {
  return Curry._2(float_of_string, s, caml_failwith);
}

var caml_nativeint_format = caml_format_int;

var caml_int32_format = caml_format_int;

var caml_int32_of_string = caml_int_of_string;

var caml_nativeint_of_string = caml_int_of_string;

exports.caml_format_float        = caml_format_float;
exports.caml_format_int          = caml_format_int;
exports.caml_nativeint_format    = caml_nativeint_format;
exports.caml_int32_format        = caml_int32_format;
exports.caml_float_of_string     = caml_float_of_string;
exports.caml_int64_format        = caml_int64_format;
exports.caml_int_of_string       = caml_int_of_string;
exports.caml_int32_of_string     = caml_int32_of_string;
exports.caml_int64_of_string     = caml_int64_of_string;
exports.caml_nativeint_of_string = caml_nativeint_of_string;
/* float_of_string Not a pure module */
//////// end of caml_format.js ////////
    return exports;
  };


  _registry['caml_int32'] = function() {
    let exports = {};
//////// start of caml_int32.js ////////
'use strict';

var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function div(x, y) {
  if (y === 0) {
    throw Caml_builtin_exceptions.division_by_zero;
  }
  else {
    return x / y | 0;
  }
}

function mod_(x, y) {
  if (y === 0) {
    throw Caml_builtin_exceptions.division_by_zero;
  }
  else {
    return x % y;
  }
}

function caml_bswap16(x) {
  return ((x & 255) << 8) | ((x & 65280) >>> 8);
}

function caml_int32_bswap(x) {
  return ((x & 255) << 24) | ((x & 65280) << 8) | ((x & 16711680) >>> 8) | ((x & 4278190080) >>> 24);
}

var imul = ( Math.imul || function (x,y) {
  y |= 0; return ((((x >> 16) * y) << 16) + (x & 0xffff) * y)|0; 
}
);

var caml_nativeint_bswap = caml_int32_bswap;

exports.div                  = div;
exports.mod_                 = mod_;
exports.caml_bswap16         = caml_bswap16;
exports.caml_int32_bswap     = caml_int32_bswap;
exports.caml_nativeint_bswap = caml_nativeint_bswap;
exports.imul                 = imul;
/* imul Not a pure module */
//////// end of caml_int32.js ////////
    return exports;
  };


  _registry['caml_int64'] = function() {
    let exports = {};
//////// start of caml_int64.js ////////
'use strict';

var Caml_obj                = require("./caml_obj");
var Caml_int32              = require("./caml_int32");
var Caml_utils              = require("./caml_utils");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

var min_int = /* record */[
  /* hi */-2147483648,
  /* lo */0
];

var max_int = /* record */[
  /* hi */134217727,
  /* lo */1
];

var one = /* record */[
  /* hi */0,
  /* lo */1
];

var zero = /* record */[
  /* hi */0,
  /* lo */0
];

var neg_one = /* record */[
  /* hi */-1,
  /* lo */4294967295
];

function neg_signed(x) {
  return +((x & 2147483648) !== 0);
}

function add(param, param$1) {
  var other_low_ = param$1[/* lo */1];
  var this_low_ = param[/* lo */1];
  var lo = this_low_ + other_low_ & 4294967295;
  var overflow = neg_signed(this_low_) && (neg_signed(other_low_) || !neg_signed(lo)) || neg_signed(other_low_) && !neg_signed(lo) ? 1 : 0;
  var hi = param[/* hi */0] + param$1[/* hi */0] + overflow & 4294967295;
  return /* record */[
          /* hi */hi,
          /* lo */(lo >>> 0)
        ];
}

function not(param) {
  var hi = param[/* hi */0] ^ -1;
  var lo = param[/* lo */1] ^ -1;
  return /* record */[
          /* hi */hi,
          /* lo */(lo >>> 0)
        ];
}

function eq(x, y) {
  if (x[/* hi */0] === y[/* hi */0]) {
    return +(x[/* lo */1] === y[/* lo */1]);
  }
  else {
    return /* false */0;
  }
}

function neg(x) {
  if (eq(x, min_int)) {
    return min_int;
  }
  else {
    return add(not(x), one);
  }
}

function sub(x, y) {
  return add(x, neg(y));
}

function lsl_(x, numBits) {
  var lo = x[/* lo */1];
  if (numBits) {
    if (numBits >= 32) {
      return /* record */[
              /* hi */(lo << (numBits - 32 | 0)),
              /* lo */0
            ];
    }
    else {
      var hi = (lo >>> (32 - numBits | 0)) | (x[/* hi */0] << numBits);
      return /* record */[
              /* hi */hi,
              /* lo */((lo << numBits) >>> 0)
            ];
    }
  }
  else {
    return x;
  }
}

function lsr_(x, numBits) {
  var hi = x[/* hi */0];
  if (numBits) {
    var offset = numBits - 32 | 0;
    if (offset) {
      if (offset > 0) {
        var lo = (hi >>> offset);
        return /* record */[
                /* hi */0,
                /* lo */(lo >>> 0)
              ];
      }
      else {
        var hi$1 = (hi >>> numBits);
        var lo$1 = (hi << (-offset | 0)) | (x[/* lo */1] >>> numBits);
        return /* record */[
                /* hi */hi$1,
                /* lo */(lo$1 >>> 0)
              ];
      }
    }
    else {
      return /* record */[
              /* hi */0,
              /* lo */(hi >>> 0)
            ];
    }
  }
  else {
    return x;
  }
}

function asr_(x, numBits) {
  var hi = x[/* hi */0];
  if (numBits) {
    if (numBits < 32) {
      var hi$1 = (hi >> numBits);
      var lo = (hi << (32 - numBits | 0)) | (x[/* lo */1] >>> numBits);
      return /* record */[
              /* hi */hi$1,
              /* lo */(lo >>> 0)
            ];
    }
    else {
      var lo$1 = (hi >> (numBits - 32 | 0));
      return /* record */[
              /* hi */hi >= 0 ? 0 : -1,
              /* lo */(lo$1 >>> 0)
            ];
    }
  }
  else {
    return x;
  }
}

function is_zero(param) {
  if (param[/* hi */0] !== 0 || param[/* lo */1] !== 0) {
    return /* false */0;
  }
  else {
    return /* true */1;
  }
}

function mul(_this, _other) {
  while(true) {
    var other = _other;
    var $$this = _this;
    var exit = 0;
    var lo;
    var this_hi = $$this[/* hi */0];
    var exit$1 = 0;
    var exit$2 = 0;
    var exit$3 = 0;
    if (this_hi !== 0) {
      exit$3 = 4;
    }
    else if ($$this[/* lo */1] !== 0) {
      exit$3 = 4;
    }
    else {
      return zero;
    }
    if (exit$3 === 4) {
      if (other[/* hi */0] !== 0) {
        exit$2 = 3;
      }
      else if (other[/* lo */1] !== 0) {
        exit$2 = 3;
      }
      else {
        return zero;
      }
    }
    if (exit$2 === 3) {
      if (this_hi !== -2147483648) {
        exit$1 = 2;
      }
      else if ($$this[/* lo */1] !== 0) {
        exit$1 = 2;
      }
      else {
        lo = other[/* lo */1];
        exit = 1;
      }
    }
    if (exit$1 === 2) {
      var other_hi = other[/* hi */0];
      var lo$1 = $$this[/* lo */1];
      var exit$4 = 0;
      if (other_hi !== -2147483648) {
        exit$4 = 3;
      }
      else if (other[/* lo */1] !== 0) {
        exit$4 = 3;
      }
      else {
        lo = lo$1;
        exit = 1;
      }
      if (exit$4 === 3) {
        var other_lo = other[/* lo */1];
        if (this_hi < 0) {
          if (other_hi < 0) {
            _other = neg(other);
            _this = neg($$this);
            continue ;
            
          }
          else {
            return neg(mul(neg($$this), other));
          }
        }
        else if (other_hi < 0) {
          return neg(mul($$this, neg(other)));
        }
        else {
          var a48 = (this_hi >>> 16);
          var a32 = this_hi & 65535;
          var a16 = (lo$1 >>> 16);
          var a00 = lo$1 & 65535;
          var b48 = (other_hi >>> 16);
          var b32 = other_hi & 65535;
          var b16 = (other_lo >>> 16);
          var b00 = other_lo & 65535;
          var c48 = 0;
          var c32 = 0;
          var c16 = 0;
          var c00 = a00 * b00;
          c16 = (c00 >>> 16) + a16 * b00;
          c32 = (c16 >>> 16);
          c16 = (c16 & 65535) + a00 * b16;
          c32 = c32 + (c16 >>> 16) + a32 * b00;
          c48 = (c32 >>> 16);
          c32 = (c32 & 65535) + a16 * b16;
          c48 += (c32 >>> 16);
          c32 = (c32 & 65535) + a00 * b32;
          c48 += (c32 >>> 16);
          c32 = c32 & 65535;
          c48 = c48 + (a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48) & 65535;
          var hi = c32 | (c48 << 16);
          var lo$2 = c00 & 65535 | ((c16 & 65535) << 16);
          return /* record */[
                  /* hi */hi,
                  /* lo */(lo$2 >>> 0)
                ];
        }
      }
      
    }
    if (exit === 1) {
      if ((lo & 1) === 0) {
        return zero;
      }
      else {
        return min_int;
      }
    }
    
  };
}

function swap(param) {
  var hi = Caml_int32.caml_int32_bswap(param[/* lo */1]);
  var lo = Caml_int32.caml_int32_bswap(param[/* hi */0]);
  return /* record */[
          /* hi */hi,
          /* lo */(lo >>> 0)
        ];
}

function xor(param, param$1) {
  return /* record */[
          /* hi */param[/* hi */0] ^ param$1[/* hi */0],
          /* lo */((param[/* lo */1] ^ param$1[/* lo */1]) >>> 0)
        ];
}

function or_(param, param$1) {
  return /* record */[
          /* hi */param[/* hi */0] | param$1[/* hi */0],
          /* lo */((param[/* lo */1] | param$1[/* lo */1]) >>> 0)
        ];
}

function and_(param, param$1) {
  return /* record */[
          /* hi */param[/* hi */0] & param$1[/* hi */0],
          /* lo */((param[/* lo */1] & param$1[/* lo */1]) >>> 0)
        ];
}

function ge(param, param$1) {
  var other_hi = param$1[/* hi */0];
  var hi = param[/* hi */0];
  if (hi > other_hi) {
    return /* true */1;
  }
  else if (hi < other_hi) {
    return /* false */0;
  }
  else {
    return +(param[/* lo */1] >= param$1[/* lo */1]);
  }
}

function neq(x, y) {
  return 1 - eq(x, y);
}

function lt(x, y) {
  return 1 - ge(x, y);
}

function gt(x, y) {
  if (x[/* hi */0] > y[/* hi */0]) {
    return /* true */1;
  }
  else if (x[/* hi */0] < y[/* hi */0]) {
    return /* false */0;
  }
  else {
    return +(x[/* lo */1] > y[/* lo */1]);
  }
}

function le(x, y) {
  return 1 - gt(x, y);
}

function to_float(param) {
  return param[/* hi */0] * 4294967296 + param[/* lo */1];
}

var two_ptr_32_dbl = Math.pow(2, 32);

var two_ptr_63_dbl = Math.pow(2, 63);

var neg_two_ptr_63 = -Math.pow(2, 63);

function of_float(x) {
  if (isNaN(x) || !isFinite(x)) {
    return zero;
  }
  else if (x <= neg_two_ptr_63) {
    return min_int;
  }
  else if (x + 1 >= two_ptr_63_dbl) {
    return max_int;
  }
  else if (x < 0) {
    return neg(of_float(-x));
  }
  else {
    var hi = x / two_ptr_32_dbl | 0;
    var lo = x % two_ptr_32_dbl | 0;
    return /* record */[
            /* hi */hi,
            /* lo */(lo >>> 0)
          ];
  }
}

function div(_self, _other) {
  while(true) {
    var other = _other;
    var self = _self;
    var self_hi = self[/* hi */0];
    var exit = 0;
    var exit$1 = 0;
    if (other[/* hi */0] !== 0) {
      exit$1 = 2;
    }
    else if (other[/* lo */1] !== 0) {
      exit$1 = 2;
    }
    else {
      throw Caml_builtin_exceptions.division_by_zero;
    }
    if (exit$1 === 2) {
      if (self_hi !== -2147483648) {
        if (self_hi !== 0) {
          exit = 1;
        }
        else if (self[/* lo */1] !== 0) {
          exit = 1;
        }
        else {
          return zero;
        }
      }
      else if (self[/* lo */1] !== 0) {
        exit = 1;
      }
      else if (eq(other, one) || eq(other, neg_one)) {
        return self;
      }
      else if (eq(other, min_int)) {
        return one;
      }
      else {
        var other_hi = other[/* hi */0];
        var half_this = asr_(self, 1);
        var approx = lsl_(div(half_this, other), 1);
        var exit$2 = 0;
        if (approx[/* hi */0] !== 0) {
          exit$2 = 3;
        }
        else if (approx[/* lo */1] !== 0) {
          exit$2 = 3;
        }
        else if (other_hi < 0) {
          return one;
        }
        else {
          return neg(one);
        }
        if (exit$2 === 3) {
          var y = mul(other, approx);
          var rem = add(self, neg(y));
          return add(approx, div(rem, other));
        }
        
      }
    }
    if (exit === 1) {
      var other_hi$1 = other[/* hi */0];
      var exit$3 = 0;
      if (other_hi$1 !== -2147483648) {
        exit$3 = 2;
      }
      else if (other[/* lo */1] !== 0) {
        exit$3 = 2;
      }
      else {
        return zero;
      }
      if (exit$3 === 2) {
        if (self_hi < 0) {
          if (other_hi$1 < 0) {
            _other = neg(other);
            _self = neg(self);
            continue ;
            
          }
          else {
            return neg(div(neg(self), other));
          }
        }
        else if (other_hi$1 < 0) {
          return neg(div(self, neg(other)));
        }
        else {
          var res = zero;
          var rem$1 = self;
          while(ge(rem$1, other)) {
            var approx$1 = Math.max(1, Math.floor(to_float(rem$1) / to_float(other)));
            var log2 = Math.ceil(Math.log(approx$1) / Math.LN2);
            var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
            var approxRes = of_float(approx$1);
            var approxRem = mul(approxRes, other);
            while(approxRem[/* hi */0] < 0 || gt(approxRem, rem$1)) {
              approx$1 -= delta;
              approxRes = of_float(approx$1);
              approxRem = mul(approxRes, other);
            };
            if (is_zero(approxRes)) {
              approxRes = one;
            }
            res = add(res, approxRes);
            rem$1 = add(rem$1, neg(approxRem));
          };
          return res;
        }
      }
      
    }
    
  };
}

function mod_(self, other) {
  var y = mul(div(self, other), other);
  return add(self, neg(y));
}

function div_mod(self, other) {
  var quotient = div(self, other);
  var y = mul(quotient, other);
  return /* tuple */[
          quotient,
          add(self, neg(y))
        ];
}

function compare(self, other) {
  var v = Caml_obj.caml_nativeint_compare(self[/* hi */0], other[/* hi */0]);
  if (v) {
    return v;
  }
  else {
    return Caml_obj.caml_nativeint_compare(self[/* lo */1], other[/* lo */1]);
  }
}

function of_int32(lo) {
  return /* record */[
          /* hi */lo < 0 ? -1 : 0,
          /* lo */(lo >>> 0)
        ];
}

function to_int32(x) {
  return x[/* lo */1] | 0;
}

function to_hex(x) {
  var aux = function (v) {
    return (v >>> 0).toString(16);
  };
  var match = x[/* hi */0];
  var match$1 = x[/* lo */1];
  var exit = 0;
  if (match !== 0) {
    exit = 1;
  }
  else if (match$1 !== 0) {
    exit = 1;
  }
  else {
    return "0";
  }
  if (exit === 1) {
    if (match$1 !== 0) {
      if (match !== 0) {
        var lo = aux(x[/* lo */1]);
        var pad = 8 - lo.length | 0;
        if (pad <= 0) {
          return aux(x[/* hi */0]) + lo;
        }
        else {
          return aux(x[/* hi */0]) + (Caml_utils.repeat(pad, "0") + lo);
        }
      }
      else {
        return aux(x[/* lo */1]);
      }
    }
    else {
      return aux(x[/* hi */0]) + "00000000";
    }
  }
  
}

function discard_sign(x) {
  return /* record */[
          /* hi */2147483647 & x[/* hi */0],
          /* lo */x[/* lo */1]
        ];
}

function float_of_bits(x) {
  var int32 = new Int32Array(/* array */[
        x[/* lo */1],
        x[/* hi */0]
      ]);
  return new Float64Array(int32.buffer)[0];
}

function bits_of_float(x) {
  var to_nat = function (x) {
    return x;
  };
  var u = new Float64Array(/* float array */[x]);
  var int32 = new Int32Array(u.buffer);
  var hi = to_nat(int32[1]);
  var lo = to_nat(int32[0]);
  return /* record */[
          /* hi */hi,
          /* lo */(lo >>> 0)
        ];
}

function get64(s, i) {
  var hi = (s.charCodeAt(i + 4 | 0) << 32) | (s.charCodeAt(i + 5 | 0) << 40) | (s.charCodeAt(i + 6 | 0) << 48) | (s.charCodeAt(i + 7 | 0) << 56);
  var lo = s.charCodeAt(i) | (s.charCodeAt(i + 1 | 0) << 8) | (s.charCodeAt(i + 2 | 0) << 16) | (s.charCodeAt(i + 3 | 0) << 24);
  return /* record */[
          /* hi */hi,
          /* lo */(lo >>> 0)
        ];
}

exports.min_int       = min_int;
exports.max_int       = max_int;
exports.one           = one;
exports.zero          = zero;
exports.not           = not;
exports.of_int32      = of_int32;
exports.to_int32      = to_int32;
exports.add           = add;
exports.neg           = neg;
exports.sub           = sub;
exports.lsl_          = lsl_;
exports.lsr_          = lsr_;
exports.asr_          = asr_;
exports.is_zero       = is_zero;
exports.mul           = mul;
exports.xor           = xor;
exports.or_           = or_;
exports.and_          = and_;
exports.swap          = swap;
exports.ge            = ge;
exports.eq            = eq;
exports.neq           = neq;
exports.lt            = lt;
exports.gt            = gt;
exports.le            = le;
exports.to_float      = to_float;
exports.of_float      = of_float;
exports.div           = div;
exports.mod_          = mod_;
exports.div_mod       = div_mod;
exports.compare       = compare;
exports.to_hex        = to_hex;
exports.discard_sign  = discard_sign;
exports.float_of_bits = float_of_bits;
exports.bits_of_float = bits_of_float;
exports.get64         = get64;
/* two_ptr_32_dbl Not a pure module */
//////// end of caml_int64.js ////////
    return exports;
  };


  _registry['camlinternalFormatBasics'] = function() {
    let exports = {};
//////// start of camlinternalFormatBasics.js ////////
'use strict';

var Block = require("./block");

function erase_rel(param) {
  if (typeof param === "number") {
    return /* End_of_fmtty */0;
  }
  else {
    switch (param.tag | 0) {
      case 0 : 
          return /* Char_ty */Block.__(0, [erase_rel(param[0])]);
      case 1 : 
          return /* String_ty */Block.__(1, [erase_rel(param[0])]);
      case 2 : 
          return /* Int_ty */Block.__(2, [erase_rel(param[0])]);
      case 3 : 
          return /* Int32_ty */Block.__(3, [erase_rel(param[0])]);
      case 4 : 
          return /* Nativeint_ty */Block.__(4, [erase_rel(param[0])]);
      case 5 : 
          return /* Int64_ty */Block.__(5, [erase_rel(param[0])]);
      case 6 : 
          return /* Float_ty */Block.__(6, [erase_rel(param[0])]);
      case 7 : 
          return /* Bool_ty */Block.__(7, [erase_rel(param[0])]);
      case 8 : 
          return /* Format_arg_ty */Block.__(8, [
                    param[0],
                    erase_rel(param[1])
                  ]);
      case 9 : 
          var ty1 = param[0];
          return /* Format_subst_ty */Block.__(9, [
                    ty1,
                    ty1,
                    erase_rel(param[2])
                  ]);
      case 10 : 
          return /* Alpha_ty */Block.__(10, [erase_rel(param[0])]);
      case 11 : 
          return /* Theta_ty */Block.__(11, [erase_rel(param[0])]);
      case 12 : 
          return /* Any_ty */Block.__(12, [erase_rel(param[0])]);
      case 13 : 
          return /* Reader_ty */Block.__(13, [erase_rel(param[0])]);
      case 14 : 
          return /* Ignored_reader_ty */Block.__(14, [erase_rel(param[0])]);
      
    }
  }
}

function concat_fmtty(fmtty1, fmtty2) {
  if (typeof fmtty1 === "number") {
    return fmtty2;
  }
  else {
    switch (fmtty1.tag | 0) {
      case 0 : 
          return /* Char_ty */Block.__(0, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 1 : 
          return /* String_ty */Block.__(1, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 2 : 
          return /* Int_ty */Block.__(2, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 3 : 
          return /* Int32_ty */Block.__(3, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 4 : 
          return /* Nativeint_ty */Block.__(4, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 5 : 
          return /* Int64_ty */Block.__(5, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 6 : 
          return /* Float_ty */Block.__(6, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 7 : 
          return /* Bool_ty */Block.__(7, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 8 : 
          return /* Format_arg_ty */Block.__(8, [
                    fmtty1[0],
                    concat_fmtty(fmtty1[1], fmtty2)
                  ]);
      case 9 : 
          return /* Format_subst_ty */Block.__(9, [
                    fmtty1[0],
                    fmtty1[1],
                    concat_fmtty(fmtty1[2], fmtty2)
                  ]);
      case 10 : 
          return /* Alpha_ty */Block.__(10, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 11 : 
          return /* Theta_ty */Block.__(11, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 12 : 
          return /* Any_ty */Block.__(12, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 13 : 
          return /* Reader_ty */Block.__(13, [concat_fmtty(fmtty1[0], fmtty2)]);
      case 14 : 
          return /* Ignored_reader_ty */Block.__(14, [concat_fmtty(fmtty1[0], fmtty2)]);
      
    }
  }
}

function concat_fmt(fmt1, fmt2) {
  if (typeof fmt1 === "number") {
    return fmt2;
  }
  else {
    switch (fmt1.tag | 0) {
      case 0 : 
          return /* Char */Block.__(0, [concat_fmt(fmt1[0], fmt2)]);
      case 1 : 
          return /* Caml_char */Block.__(1, [concat_fmt(fmt1[0], fmt2)]);
      case 2 : 
          return /* String */Block.__(2, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 3 : 
          return /* Caml_string */Block.__(3, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 4 : 
          return /* Int */Block.__(4, [
                    fmt1[0],
                    fmt1[1],
                    fmt1[2],
                    concat_fmt(fmt1[3], fmt2)
                  ]);
      case 5 : 
          return /* Int32 */Block.__(5, [
                    fmt1[0],
                    fmt1[1],
                    fmt1[2],
                    concat_fmt(fmt1[3], fmt2)
                  ]);
      case 6 : 
          return /* Nativeint */Block.__(6, [
                    fmt1[0],
                    fmt1[1],
                    fmt1[2],
                    concat_fmt(fmt1[3], fmt2)
                  ]);
      case 7 : 
          return /* Int64 */Block.__(7, [
                    fmt1[0],
                    fmt1[1],
                    fmt1[2],
                    concat_fmt(fmt1[3], fmt2)
                  ]);
      case 8 : 
          return /* Float */Block.__(8, [
                    fmt1[0],
                    fmt1[1],
                    fmt1[2],
                    concat_fmt(fmt1[3], fmt2)
                  ]);
      case 9 : 
          return /* Bool */Block.__(9, [concat_fmt(fmt1[0], fmt2)]);
      case 10 : 
          return /* Flush */Block.__(10, [concat_fmt(fmt1[0], fmt2)]);
      case 11 : 
          return /* String_literal */Block.__(11, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 12 : 
          return /* Char_literal */Block.__(12, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 13 : 
          return /* Format_arg */Block.__(13, [
                    fmt1[0],
                    fmt1[1],
                    concat_fmt(fmt1[2], fmt2)
                  ]);
      case 14 : 
          return /* Format_subst */Block.__(14, [
                    fmt1[0],
                    fmt1[1],
                    concat_fmt(fmt1[2], fmt2)
                  ]);
      case 15 : 
          return /* Alpha */Block.__(15, [concat_fmt(fmt1[0], fmt2)]);
      case 16 : 
          return /* Theta */Block.__(16, [concat_fmt(fmt1[0], fmt2)]);
      case 17 : 
          return /* Formatting_lit */Block.__(17, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 18 : 
          return /* Formatting_gen */Block.__(18, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 19 : 
          return /* Reader */Block.__(19, [concat_fmt(fmt1[0], fmt2)]);
      case 20 : 
          return /* Scan_char_set */Block.__(20, [
                    fmt1[0],
                    fmt1[1],
                    concat_fmt(fmt1[2], fmt2)
                  ]);
      case 21 : 
          return /* Scan_get_counter */Block.__(21, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 22 : 
          return /* Scan_next_char */Block.__(22, [concat_fmt(fmt1[0], fmt2)]);
      case 23 : 
          return /* Ignored_param */Block.__(23, [
                    fmt1[0],
                    concat_fmt(fmt1[1], fmt2)
                  ]);
      case 24 : 
          return /* Custom */Block.__(24, [
                    fmt1[0],
                    fmt1[1],
                    concat_fmt(fmt1[2], fmt2)
                  ]);
      
    }
  }
}

exports.concat_fmtty = concat_fmtty;
exports.erase_rel    = erase_rel;
exports.concat_fmt   = concat_fmt;
/* No side effect */
//////// end of camlinternalFormatBasics.js ////////
    return exports;
  };


  _registry['camlinternalFormat'] = function() {
    let exports = {};
//////// start of camlinternalFormat.js ////////
'use strict';

var Sys                      = require("./sys");
var Char                     = require("./char");
var Block                    = require("./block");
var Bytes                    = require("./bytes");
var Curry                    = require("./curry");
var Buffer                   = require("./buffer");
var $$String                 = require("./string");
var Caml_io                  = require("./caml_io");
var Caml_obj                 = require("./caml_obj");
var Caml_bytes               = require("./caml_bytes");
var Caml_float               = require("./caml_float");
var Caml_int32               = require("./caml_int32");
var Pervasives               = require("./pervasives");
var Caml_format              = require("./caml_format");
var Caml_string              = require("./caml_string");
var Caml_exceptions          = require("./caml_exceptions");
var Caml_builtin_exceptions  = require("./caml_builtin_exceptions");
var CamlinternalFormatBasics = require("./camlinternalFormatBasics");

function create_char_set() {
  return Bytes.make(32, /* "\000" */0);
}

function add_in_char_set(char_set, c) {
  var str_ind = (c >>> 3);
  var mask = (1 << (c & 7));
  char_set[str_ind] = Pervasives.char_of_int(Caml_bytes.get(char_set, str_ind) | mask);
  return /* () */0;
}

var freeze_char_set = Bytes.to_string;

function rev_char_set(char_set) {
  var char_set$prime = Bytes.make(32, /* "\000" */0);
  for(var i = 0; i <= 31; ++i){
    char_set$prime[i] = Pervasives.char_of_int(Caml_string.get(char_set, i) ^ 255);
  }
  return Caml_string.bytes_to_string(char_set$prime);
}

function is_in_char_set(char_set, c) {
  var str_ind = (c >>> 3);
  var mask = (1 << (c & 7));
  return +((Caml_string.get(char_set, str_ind) & mask) !== 0);
}

function pad_of_pad_opt(pad_opt) {
  if (pad_opt) {
    return /* Lit_padding */Block.__(0, [
              /* Right */1,
              pad_opt[0]
            ]);
  }
  else {
    return /* No_padding */0;
  }
}

function prec_of_prec_opt(prec_opt) {
  if (prec_opt) {
    return /* Lit_precision */[prec_opt[0]];
  }
  else {
    return /* No_precision */0;
  }
}

function param_format_of_ignored_format(ign, fmt) {
  if (typeof ign === "number") {
    switch (ign) {
      case 0 : 
          return /* Param_format_EBB */[/* Char */Block.__(0, [fmt])];
      case 1 : 
          return /* Param_format_EBB */[/* Caml_char */Block.__(1, [fmt])];
      case 2 : 
          return /* Param_format_EBB */[/* Bool */Block.__(9, [fmt])];
      case 3 : 
          return /* Param_format_EBB */[/* Reader */Block.__(19, [fmt])];
      case 4 : 
          return /* Param_format_EBB */[/* Scan_next_char */Block.__(22, [fmt])];
      
    }
  }
  else {
    switch (ign.tag | 0) {
      case 0 : 
          return /* Param_format_EBB */[/* String */Block.__(2, [
                      pad_of_pad_opt(ign[0]),
                      fmt
                    ])];
      case 1 : 
          return /* Param_format_EBB */[/* Caml_string */Block.__(3, [
                      pad_of_pad_opt(ign[0]),
                      fmt
                    ])];
      case 2 : 
          return /* Param_format_EBB */[/* Int */Block.__(4, [
                      ign[0],
                      pad_of_pad_opt(ign[1]),
                      /* No_precision */0,
                      fmt
                    ])];
      case 3 : 
          return /* Param_format_EBB */[/* Int32 */Block.__(5, [
                      ign[0],
                      pad_of_pad_opt(ign[1]),
                      /* No_precision */0,
                      fmt
                    ])];
      case 4 : 
          return /* Param_format_EBB */[/* Nativeint */Block.__(6, [
                      ign[0],
                      pad_of_pad_opt(ign[1]),
                      /* No_precision */0,
                      fmt
                    ])];
      case 5 : 
          return /* Param_format_EBB */[/* Int64 */Block.__(7, [
                      ign[0],
                      pad_of_pad_opt(ign[1]),
                      /* No_precision */0,
                      fmt
                    ])];
      case 6 : 
          return /* Param_format_EBB */[/* Float */Block.__(8, [
                      /* Float_f */0,
                      pad_of_pad_opt(ign[0]),
                      prec_of_prec_opt(ign[1]),
                      fmt
                    ])];
      case 7 : 
          return /* Param_format_EBB */[/* Format_arg */Block.__(13, [
                      ign[0],
                      ign[1],
                      fmt
                    ])];
      case 8 : 
          return /* Param_format_EBB */[/* Format_subst */Block.__(14, [
                      ign[0],
                      ign[1],
                      fmt
                    ])];
      case 9 : 
          return /* Param_format_EBB */[/* Scan_char_set */Block.__(20, [
                      ign[0],
                      ign[1],
                      fmt
                    ])];
      case 10 : 
          return /* Param_format_EBB */[/* Scan_get_counter */Block.__(21, [
                      ign[0],
                      fmt
                    ])];
      
    }
  }
}

function buffer_check_size(buf, overhead) {
  var len = buf[/* bytes */1].length;
  var min_len = buf[/* ind */0] + overhead | 0;
  if (min_len > len) {
    var new_len = Pervasives.max((len << 1), min_len);
    var new_str = Caml_string.caml_create_string(new_len);
    Bytes.blit(buf[/* bytes */1], 0, new_str, 0, len);
    buf[/* bytes */1] = new_str;
    return /* () */0;
  }
  else {
    return 0;
  }
}

function buffer_add_char(buf, c) {
  buffer_check_size(buf, 1);
  buf[/* bytes */1][buf[/* ind */0]] = c;
  buf[/* ind */0] = buf[/* ind */0] + 1 | 0;
  return /* () */0;
}

function buffer_add_string(buf, s) {
  var str_len = s.length;
  buffer_check_size(buf, str_len);
  $$String.blit(s, 0, buf[/* bytes */1], buf[/* ind */0], str_len);
  buf[/* ind */0] = buf[/* ind */0] + str_len | 0;
  return /* () */0;
}

function buffer_contents(buf) {
  return Bytes.sub_string(buf[/* bytes */1], 0, buf[/* ind */0]);
}

function char_of_iconv(iconv) {
  switch (iconv) {
    case 0 : 
    case 1 : 
    case 2 : 
        return /* "d" */100;
    case 3 : 
    case 4 : 
    case 5 : 
        return /* "i" */105;
    case 6 : 
    case 7 : 
        return /* "x" */120;
    case 8 : 
    case 9 : 
        return /* "X" */88;
    case 10 : 
    case 11 : 
        return /* "o" */111;
    case 12 : 
        return /* "u" */117;
    
  }
}

function char_of_fconv(fconv) {
  switch (fconv) {
    case 0 : 
    case 1 : 
    case 2 : 
        return /* "f" */102;
    case 3 : 
    case 4 : 
    case 5 : 
        return /* "e" */101;
    case 6 : 
    case 7 : 
    case 8 : 
        return /* "E" */69;
    case 9 : 
    case 10 : 
    case 11 : 
        return /* "g" */103;
    case 12 : 
    case 13 : 
    case 14 : 
        return /* "G" */71;
    case 15 : 
        return /* "F" */70;
    
  }
}

function char_of_counter(counter) {
  switch (counter) {
    case 0 : 
        return /* "l" */108;
    case 1 : 
        return /* "n" */110;
    case 2 : 
        return /* "N" */78;
    
  }
}

function bprint_char_set(buf, char_set) {
  var print_char = function (buf, i) {
    var c = Pervasives.char_of_int(i);
    if (c !== 37) {
      if (c !== 64) {
        return buffer_add_char(buf, c);
      }
      else {
        buffer_add_char(buf, /* "%" */37);
        return buffer_add_char(buf, /* "@" */64);
      }
    }
    else {
      buffer_add_char(buf, /* "%" */37);
      return buffer_add_char(buf, /* "%" */37);
    }
  };
  var print_out = function (set, _i) {
    while(true) {
      var i = _i;
      if (i < 256) {
        if (is_in_char_set(set, Pervasives.char_of_int(i))) {
          var set$1 = set;
          var i$1 = i;
          var match = Pervasives.char_of_int(i$1);
          var switcher = match - 45 | 0;
          if (switcher > 48 || switcher < 0) {
            if (switcher >= 210) {
              return print_char(buf, 255);
            }
            else {
              return print_second(set$1, i$1 + 1 | 0);
            }
          }
          else if (switcher > 47 || switcher < 1) {
            return print_out(set$1, i$1 + 1 | 0);
          }
          else {
            return print_second(set$1, i$1 + 1 | 0);
          }
        }
        else {
          _i = i + 1 | 0;
          continue ;
          
        }
      }
      else {
        return 0;
      }
    };
  };
  var print_second = function (set, i) {
    if (is_in_char_set(set, Pervasives.char_of_int(i))) {
      var match = Pervasives.char_of_int(i);
      var exit = 0;
      var switcher = match - 45 | 0;
      if (switcher > 48 || switcher < 0) {
        if (switcher >= 210) {
          print_char(buf, 254);
          return print_char(buf, 255);
        }
        else {
          exit = 1;
        }
      }
      else if (switcher > 47 || switcher < 1) {
        if (is_in_char_set(set, Pervasives.char_of_int(i + 1 | 0))) {
          exit = 1;
        }
        else {
          print_char(buf, i - 1 | 0);
          return print_out(set, i + 1 | 0);
        }
      }
      else {
        exit = 1;
      }
      if (exit === 1) {
        if (is_in_char_set(set, Pervasives.char_of_int(i + 1 | 0))) {
          var set$1 = set;
          var i$1 = i - 1 | 0;
          var _j = i + 2 | 0;
          while(true) {
            var j = _j;
            if (j === 256 || !is_in_char_set(set$1, Pervasives.char_of_int(j))) {
              print_char(buf, i$1);
              print_char(buf, /* "-" */45);
              print_char(buf, j - 1 | 0);
              if (j < 256) {
                return print_out(set$1, j + 1 | 0);
              }
              else {
                return 0;
              }
            }
            else {
              _j = j + 1 | 0;
              continue ;
              
            }
          };
        }
        else {
          print_char(buf, i - 1 | 0);
          print_char(buf, i);
          return print_out(set, i + 2 | 0);
        }
      }
      
    }
    else {
      print_char(buf, i - 1 | 0);
      return print_out(set, i + 1 | 0);
    }
  };
  var print_start = function (set) {
    var is_alone = function (c) {
      var match_000 = Char.chr(c - 1 | 0);
      var match_001 = Char.chr(c + 1 | 0);
      if (is_in_char_set(set, c)) {
        return 1 - (is_in_char_set(set, match_000) && is_in_char_set(set, match_001));
      }
      else {
        return /* false */0;
      }
    };
    if (is_alone(/* "]" */93)) {
      buffer_add_char(buf, /* "]" */93);
    }
    print_out(set, 1);
    if (is_alone(/* "-" */45)) {
      return buffer_add_char(buf, /* "-" */45);
    }
    else {
      return 0;
    }
  };
  buffer_add_char(buf, /* "[" */91);
  print_start(is_in_char_set(char_set, /* "\000" */0) ? (buffer_add_char(buf, /* "^" */94), rev_char_set(char_set)) : char_set);
  return buffer_add_char(buf, /* "]" */93);
}

function bprint_padty(buf, padty) {
  switch (padty) {
    case 0 : 
        return buffer_add_char(buf, /* "-" */45);
    case 1 : 
        return /* () */0;
    case 2 : 
        return buffer_add_char(buf, /* "0" */48);
    
  }
}

function bprint_ignored_flag(buf, ign_flag) {
  if (ign_flag) {
    return buffer_add_char(buf, /* "_" */95);
  }
  else {
    return 0;
  }
}

function bprint_pad_opt(buf, pad_opt) {
  if (pad_opt) {
    return buffer_add_string(buf, "" + pad_opt[0]);
  }
  else {
    return /* () */0;
  }
}

function bprint_padding(buf, pad) {
  if (typeof pad === "number") {
    return /* () */0;
  }
  else {
    bprint_padty(buf, pad[0]);
    if (pad.tag) {
      return buffer_add_char(buf, /* "*" */42);
    }
    else {
      return buffer_add_string(buf, "" + pad[1]);
    }
  }
}

function bprint_precision(buf, prec) {
  if (typeof prec === "number") {
    if (prec !== 0) {
      return buffer_add_string(buf, ".*");
    }
    else {
      return /* () */0;
    }
  }
  else {
    buffer_add_char(buf, /* "." */46);
    return buffer_add_string(buf, "" + prec[0]);
  }
}

function bprint_iconv_flag(buf, iconv) {
  switch (iconv) {
    case 1 : 
    case 4 : 
        return buffer_add_char(buf, /* "+" */43);
    case 2 : 
    case 5 : 
        return buffer_add_char(buf, /* " " */32);
    case 7 : 
    case 9 : 
    case 11 : 
        return buffer_add_char(buf, /* "#" */35);
    case 0 : 
    case 3 : 
    case 6 : 
    case 8 : 
    case 10 : 
    case 12 : 
        return /* () */0;
    
  }
}

function bprint_int_fmt(buf, ign_flag, iconv, pad, prec) {
  buffer_add_char(buf, /* "%" */37);
  bprint_ignored_flag(buf, ign_flag);
  bprint_iconv_flag(buf, iconv);
  bprint_padding(buf, pad);
  bprint_precision(buf, prec);
  return buffer_add_char(buf, char_of_iconv(iconv));
}

function bprint_altint_fmt(buf, ign_flag, iconv, pad, prec, c) {
  buffer_add_char(buf, /* "%" */37);
  bprint_ignored_flag(buf, ign_flag);
  bprint_iconv_flag(buf, iconv);
  bprint_padding(buf, pad);
  bprint_precision(buf, prec);
  buffer_add_char(buf, c);
  return buffer_add_char(buf, char_of_iconv(iconv));
}

function bprint_fconv_flag(buf, fconv) {
  switch (fconv) {
    case 1 : 
    case 4 : 
    case 7 : 
    case 10 : 
    case 13 : 
        return buffer_add_char(buf, /* "+" */43);
    case 2 : 
    case 5 : 
    case 8 : 
    case 11 : 
    case 14 : 
        return buffer_add_char(buf, /* " " */32);
    case 0 : 
    case 3 : 
    case 6 : 
    case 9 : 
    case 12 : 
    case 15 : 
        return /* () */0;
    
  }
}

function bprint_float_fmt(buf, ign_flag, fconv, pad, prec) {
  buffer_add_char(buf, /* "%" */37);
  bprint_ignored_flag(buf, ign_flag);
  bprint_fconv_flag(buf, fconv);
  bprint_padding(buf, pad);
  bprint_precision(buf, prec);
  return buffer_add_char(buf, char_of_fconv(fconv));
}

function string_of_formatting_lit(formatting_lit) {
  if (typeof formatting_lit === "number") {
    switch (formatting_lit) {
      case 0 : 
          return "@]";
      case 1 : 
          return "@}";
      case 2 : 
          return "@?";
      case 3 : 
          return "@\n";
      case 4 : 
          return "@.";
      case 5 : 
          return "@@";
      case 6 : 
          return "@%";
      
    }
  }
  else {
    switch (formatting_lit.tag | 0) {
      case 0 : 
      case 1 : 
          return formatting_lit[0];
      case 2 : 
          return "@" + Caml_string.bytes_to_string(Bytes.make(1, formatting_lit[0]));
      
    }
  }
}

function string_of_formatting_gen(formatting_gen) {
  return formatting_gen[0][1];
}

function bprint_char_literal(buf, chr) {
  if (chr !== 37) {
    return buffer_add_char(buf, chr);
  }
  else {
    return buffer_add_string(buf, "%%");
  }
}

function bprint_string_literal(buf, str) {
  for(var i = 0 ,i_finish = str.length - 1 | 0; i <= i_finish; ++i){
    bprint_char_literal(buf, Caml_string.get(str, i));
  }
  return /* () */0;
}

function bprint_fmtty(buf, _fmtty) {
  while(true) {
    var fmtty = _fmtty;
    if (typeof fmtty === "number") {
      return /* () */0;
    }
    else {
      switch (fmtty.tag | 0) {
        case 0 : 
            buffer_add_string(buf, "%c");
            _fmtty = fmtty[0];
            continue ;
            case 1 : 
            buffer_add_string(buf, "%s");
            _fmtty = fmtty[0];
            continue ;
            case 2 : 
            buffer_add_string(buf, "%i");
            _fmtty = fmtty[0];
            continue ;
            case 3 : 
            buffer_add_string(buf, "%li");
            _fmtty = fmtty[0];
            continue ;
            case 4 : 
            buffer_add_string(buf, "%ni");
            _fmtty = fmtty[0];
            continue ;
            case 5 : 
            buffer_add_string(buf, "%Li");
            _fmtty = fmtty[0];
            continue ;
            case 6 : 
            buffer_add_string(buf, "%f");
            _fmtty = fmtty[0];
            continue ;
            case 7 : 
            buffer_add_string(buf, "%B");
            _fmtty = fmtty[0];
            continue ;
            case 8 : 
            buffer_add_string(buf, "%{");
            bprint_fmtty(buf, fmtty[0]);
            buffer_add_string(buf, "%}");
            _fmtty = fmtty[1];
            continue ;
            case 9 : 
            buffer_add_string(buf, "%(");
            bprint_fmtty(buf, fmtty[0]);
            buffer_add_string(buf, "%)");
            _fmtty = fmtty[2];
            continue ;
            case 10 : 
            buffer_add_string(buf, "%a");
            _fmtty = fmtty[0];
            continue ;
            case 11 : 
            buffer_add_string(buf, "%t");
            _fmtty = fmtty[0];
            continue ;
            case 12 : 
            buffer_add_string(buf, "%?");
            _fmtty = fmtty[0];
            continue ;
            case 13 : 
            buffer_add_string(buf, "%r");
            _fmtty = fmtty[0];
            continue ;
            case 14 : 
            buffer_add_string(buf, "%_r");
            _fmtty = fmtty[0];
            continue ;
            
      }
    }
  };
}

function int_of_custom_arity(param) {
  if (param) {
    return 1 + int_of_custom_arity(param[0]) | 0;
  }
  else {
    return 0;
  }
}

function bprint_fmt(buf, fmt) {
  var _fmt = fmt;
  var _ign_flag = /* false */0;
  while(true) {
    var ign_flag = _ign_flag;
    var fmt$1 = _fmt;
    if (typeof fmt$1 === "number") {
      return /* () */0;
    }
    else {
      switch (fmt$1.tag | 0) {
        case 0 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, /* "c" */99);
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 1 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, /* "C" */67);
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 2 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            bprint_padding(buf, fmt$1[0]);
            buffer_add_char(buf, /* "s" */115);
            _ign_flag = /* false */0;
            _fmt = fmt$1[1];
            continue ;
            case 3 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            bprint_padding(buf, fmt$1[0]);
            buffer_add_char(buf, /* "S" */83);
            _ign_flag = /* false */0;
            _fmt = fmt$1[1];
            continue ;
            case 4 : 
            bprint_int_fmt(buf, ign_flag, fmt$1[0], fmt$1[1], fmt$1[2]);
            _ign_flag = /* false */0;
            _fmt = fmt$1[3];
            continue ;
            case 5 : 
            bprint_altint_fmt(buf, ign_flag, fmt$1[0], fmt$1[1], fmt$1[2], /* "l" */108);
            _ign_flag = /* false */0;
            _fmt = fmt$1[3];
            continue ;
            case 6 : 
            bprint_altint_fmt(buf, ign_flag, fmt$1[0], fmt$1[1], fmt$1[2], /* "n" */110);
            _ign_flag = /* false */0;
            _fmt = fmt$1[3];
            continue ;
            case 7 : 
            bprint_altint_fmt(buf, ign_flag, fmt$1[0], fmt$1[1], fmt$1[2], /* "L" */76);
            _ign_flag = /* false */0;
            _fmt = fmt$1[3];
            continue ;
            case 8 : 
            bprint_float_fmt(buf, ign_flag, fmt$1[0], fmt$1[1], fmt$1[2]);
            _ign_flag = /* false */0;
            _fmt = fmt$1[3];
            continue ;
            case 9 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, /* "B" */66);
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 10 : 
            buffer_add_string(buf, "%!");
            _fmt = fmt$1[0];
            continue ;
            case 11 : 
            bprint_string_literal(buf, fmt$1[0]);
            _fmt = fmt$1[1];
            continue ;
            case 12 : 
            bprint_char_literal(buf, fmt$1[0]);
            _fmt = fmt$1[1];
            continue ;
            case 13 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            bprint_pad_opt(buf, fmt$1[0]);
            buffer_add_char(buf, /* "{" */123);
            bprint_fmtty(buf, fmt$1[1]);
            buffer_add_char(buf, /* "%" */37);
            buffer_add_char(buf, /* "}" */125);
            _ign_flag = /* false */0;
            _fmt = fmt$1[2];
            continue ;
            case 14 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            bprint_pad_opt(buf, fmt$1[0]);
            buffer_add_char(buf, /* "(" */40);
            bprint_fmtty(buf, fmt$1[1]);
            buffer_add_char(buf, /* "%" */37);
            buffer_add_char(buf, /* ")" */41);
            _ign_flag = /* false */0;
            _fmt = fmt$1[2];
            continue ;
            case 15 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, /* "a" */97);
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 16 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, /* "t" */116);
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 17 : 
            bprint_string_literal(buf, string_of_formatting_lit(fmt$1[0]));
            _fmt = fmt$1[1];
            continue ;
            case 18 : 
            bprint_string_literal(buf, "@{");
            bprint_string_literal(buf, string_of_formatting_gen(fmt$1[0]));
            _fmt = fmt$1[1];
            continue ;
            case 19 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, /* "r" */114);
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 20 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            bprint_pad_opt(buf, fmt$1[0]);
            bprint_char_set(buf, fmt$1[1]);
            _ign_flag = /* false */0;
            _fmt = fmt$1[2];
            continue ;
            case 21 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            buffer_add_char(buf, char_of_counter(fmt$1[0]));
            _ign_flag = /* false */0;
            _fmt = fmt$1[1];
            continue ;
            case 22 : 
            buffer_add_char(buf, /* "%" */37);
            bprint_ignored_flag(buf, ign_flag);
            bprint_string_literal(buf, "0c");
            _ign_flag = /* false */0;
            _fmt = fmt$1[0];
            continue ;
            case 23 : 
            var match = param_format_of_ignored_format(fmt$1[0], fmt$1[1]);
            _ign_flag = /* true */1;
            _fmt = match[0];
            continue ;
            case 24 : 
            for(var _i = 1 ,_i_finish = int_of_custom_arity(fmt$1[0]); _i <= _i_finish; ++_i){
              buffer_add_char(buf, /* "%" */37);
              bprint_ignored_flag(buf, ign_flag);
              buffer_add_char(buf, /* "?" */63);
            }
            _ign_flag = /* false */0;
            _fmt = fmt$1[2];
            continue ;
            
      }
    }
  };
}

function string_of_fmt(fmt) {
  var buf = /* record */[
    /* ind */0,
    /* bytes */new Array(16)
  ];
  bprint_fmt(buf, fmt);
  return buffer_contents(buf);
}

function symm(param) {
  if (typeof param === "number") {
    return /* End_of_fmtty */0;
  }
  else {
    switch (param.tag | 0) {
      case 0 : 
          return /* Char_ty */Block.__(0, [symm(param[0])]);
      case 1 : 
          return /* String_ty */Block.__(1, [symm(param[0])]);
      case 2 : 
          return /* Int_ty */Block.__(2, [symm(param[0])]);
      case 3 : 
          return /* Int32_ty */Block.__(3, [symm(param[0])]);
      case 4 : 
          return /* Nativeint_ty */Block.__(4, [symm(param[0])]);
      case 5 : 
          return /* Int64_ty */Block.__(5, [symm(param[0])]);
      case 6 : 
          return /* Float_ty */Block.__(6, [symm(param[0])]);
      case 7 : 
          return /* Bool_ty */Block.__(7, [symm(param[0])]);
      case 8 : 
          return /* Format_arg_ty */Block.__(8, [
                    param[0],
                    symm(param[1])
                  ]);
      case 9 : 
          return /* Format_subst_ty */Block.__(9, [
                    param[1],
                    param[0],
                    symm(param[2])
                  ]);
      case 10 : 
          return /* Alpha_ty */Block.__(10, [symm(param[0])]);
      case 11 : 
          return /* Theta_ty */Block.__(11, [symm(param[0])]);
      case 12 : 
          return /* Any_ty */Block.__(12, [symm(param[0])]);
      case 13 : 
          return /* Reader_ty */Block.__(13, [symm(param[0])]);
      case 14 : 
          return /* Ignored_reader_ty */Block.__(14, [symm(param[0])]);
      
    }
  }
}

function fmtty_rel_det(param) {
  if (typeof param === "number") {
    return /* tuple */[
            function () {
              return /* Refl */0;
            },
            function () {
              return /* Refl */0;
            },
            function () {
              return /* Refl */0;
            },
            function () {
              return /* Refl */0;
            }
          ];
  }
  else {
    switch (param.tag | 0) {
      case 0 : 
          var match = fmtty_rel_det(param[0]);
          var af = match[1];
          var fa = match[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af, /* Refl */0);
                    return /* Refl */0;
                  },
                  match[2],
                  match[3]
                ];
      case 1 : 
          var match$1 = fmtty_rel_det(param[0]);
          var af$1 = match$1[1];
          var fa$1 = match$1[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$1, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$1, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$1[2],
                  match$1[3]
                ];
      case 2 : 
          var match$2 = fmtty_rel_det(param[0]);
          var af$2 = match$2[1];
          var fa$2 = match$2[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$2, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$2, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$2[2],
                  match$2[3]
                ];
      case 3 : 
          var match$3 = fmtty_rel_det(param[0]);
          var af$3 = match$3[1];
          var fa$3 = match$3[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$3, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$3, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$3[2],
                  match$3[3]
                ];
      case 4 : 
          var match$4 = fmtty_rel_det(param[0]);
          var af$4 = match$4[1];
          var fa$4 = match$4[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$4, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$4, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$4[2],
                  match$4[3]
                ];
      case 5 : 
          var match$5 = fmtty_rel_det(param[0]);
          var af$5 = match$5[1];
          var fa$5 = match$5[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$5, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$5, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$5[2],
                  match$5[3]
                ];
      case 6 : 
          var match$6 = fmtty_rel_det(param[0]);
          var af$6 = match$6[1];
          var fa$6 = match$6[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$6, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$6, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$6[2],
                  match$6[3]
                ];
      case 7 : 
          var match$7 = fmtty_rel_det(param[0]);
          var af$7 = match$7[1];
          var fa$7 = match$7[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$7, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$7, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$7[2],
                  match$7[3]
                ];
      case 8 : 
          var match$8 = fmtty_rel_det(param[1]);
          var af$8 = match$8[1];
          var fa$8 = match$8[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$8, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$8, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$8[2],
                  match$8[3]
                ];
      case 9 : 
          var match$9 = fmtty_rel_det(param[2]);
          var de = match$9[3];
          var ed = match$9[2];
          var af$9 = match$9[1];
          var fa$9 = match$9[0];
          var ty = trans(symm(param[0]), param[1]);
          var match$10 = fmtty_rel_det(ty);
          var jd = match$10[3];
          var dj = match$10[2];
          var ga = match$10[1];
          var ag = match$10[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$9, /* Refl */0);
                    Curry._1(ag, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(ga, /* Refl */0);
                    Curry._1(af$9, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(ed, /* Refl */0);
                    Curry._1(dj, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(jd, /* Refl */0);
                    Curry._1(de, /* Refl */0);
                    return /* Refl */0;
                  }
                ];
      case 10 : 
          var match$11 = fmtty_rel_det(param[0]);
          var af$10 = match$11[1];
          var fa$10 = match$11[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$10, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$10, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$11[2],
                  match$11[3]
                ];
      case 11 : 
          var match$12 = fmtty_rel_det(param[0]);
          var af$11 = match$12[1];
          var fa$11 = match$12[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$11, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$11, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$12[2],
                  match$12[3]
                ];
      case 12 : 
          var match$13 = fmtty_rel_det(param[0]);
          var af$12 = match$13[1];
          var fa$12 = match$13[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$12, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$12, /* Refl */0);
                    return /* Refl */0;
                  },
                  match$13[2],
                  match$13[3]
                ];
      case 13 : 
          var match$14 = fmtty_rel_det(param[0]);
          var de$1 = match$14[3];
          var ed$1 = match$14[2];
          var af$13 = match$14[1];
          var fa$13 = match$14[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$13, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$13, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(ed$1, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(de$1, /* Refl */0);
                    return /* Refl */0;
                  }
                ];
      case 14 : 
          var match$15 = fmtty_rel_det(param[0]);
          var de$2 = match$15[3];
          var ed$2 = match$15[2];
          var af$14 = match$15[1];
          var fa$14 = match$15[0];
          return /* tuple */[
                  function () {
                    Curry._1(fa$14, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(af$14, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(ed$2, /* Refl */0);
                    return /* Refl */0;
                  },
                  function () {
                    Curry._1(de$2, /* Refl */0);
                    return /* Refl */0;
                  }
                ];
      
    }
  }
}

function trans(ty1, ty2) {
  var exit = 0;
  if (typeof ty1 === "number") {
    if (typeof ty2 === "number") {
      if (ty2) {
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                816,
                23
              ]
            ];
      }
      else {
        return /* End_of_fmtty */0;
      }
    }
    else {
      switch (ty2.tag | 0) {
        case 8 : 
            exit = 6;
            break;
        case 9 : 
            exit = 7;
            break;
        case 10 : 
            exit = 1;
            break;
        case 11 : 
            exit = 2;
            break;
        case 12 : 
            exit = 3;
            break;
        case 13 : 
            exit = 4;
            break;
        case 14 : 
            exit = 5;
            break;
        default:
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "camlinternalFormat.ml",
                  816,
                  23
                ]
              ];
      }
    }
  }
  else {
    switch (ty1.tag | 0) {
      case 0 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 0 : 
                  return /* Char_ty */Block.__(0, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 1 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 1 : 
                  return /* String_ty */Block.__(1, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 2 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 2 : 
                  return /* Int_ty */Block.__(2, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 3 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 3 : 
                  return /* Int32_ty */Block.__(3, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 4 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 4 : 
                  return /* Nativeint_ty */Block.__(4, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 5 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 5 : 
                  return /* Int64_ty */Block.__(5, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 6 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 6 : 
                  return /* Float_ty */Block.__(6, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 7 : 
          if (typeof ty2 === "number") {
            exit = 8;
          }
          else {
            switch (ty2.tag | 0) {
              case 7 : 
                  return /* Bool_ty */Block.__(7, [trans(ty1[0], ty2[0])]);
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  exit = 7;
                  break;
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              
            }
          }
          break;
      case 8 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    802,
                    26
                  ]
                ];
          }
          else {
            switch (ty2.tag | 0) {
              case 8 : 
                  return /* Format_arg_ty */Block.__(8, [
                            trans(ty1[0], ty2[0]),
                            trans(ty1[1], ty2[1])
                          ]);
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              default:
                throw [
                      Caml_builtin_exceptions.assert_failure,
                      [
                        "camlinternalFormat.ml",
                        802,
                        26
                      ]
                    ];
            }
          }
          break;
      case 9 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    812,
                    28
                  ]
                ];
          }
          else {
            switch (ty2.tag | 0) {
              case 8 : 
                  exit = 6;
                  break;
              case 9 : 
                  var ty = trans(symm(ty1[1]), ty2[0]);
                  var match = fmtty_rel_det(ty);
                  Curry._1(match[1], /* Refl */0);
                  Curry._1(match[3], /* Refl */0);
                  return /* Format_subst_ty */Block.__(9, [
                            ty1[0],
                            ty2[1],
                            trans(ty1[2], ty2[2])
                          ]);
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  exit = 5;
                  break;
              default:
                throw [
                      Caml_builtin_exceptions.assert_failure,
                      [
                        "camlinternalFormat.ml",
                        812,
                        28
                      ]
                    ];
            }
          }
          break;
      case 10 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    780,
                    21
                  ]
                ];
          }
          else if (ty2.tag === 10) {
            return /* Alpha_ty */Block.__(10, [trans(ty1[0], ty2[0])]);
          }
          else {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    780,
                    21
                  ]
                ];
          }
          break;
      case 11 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    784,
                    21
                  ]
                ];
          }
          else {
            switch (ty2.tag | 0) {
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  return /* Theta_ty */Block.__(11, [trans(ty1[0], ty2[0])]);
              default:
                throw [
                      Caml_builtin_exceptions.assert_failure,
                      [
                        "camlinternalFormat.ml",
                        784,
                        21
                      ]
                    ];
            }
          }
          break;
      case 12 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    788,
                    19
                  ]
                ];
          }
          else {
            switch (ty2.tag | 0) {
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  return /* Any_ty */Block.__(12, [trans(ty1[0], ty2[0])]);
              default:
                throw [
                      Caml_builtin_exceptions.assert_failure,
                      [
                        "camlinternalFormat.ml",
                        788,
                        19
                      ]
                    ];
            }
          }
          break;
      case 13 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    792,
                    22
                  ]
                ];
          }
          else {
            switch (ty2.tag | 0) {
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  return /* Reader_ty */Block.__(13, [trans(ty1[0], ty2[0])]);
              default:
                throw [
                      Caml_builtin_exceptions.assert_failure,
                      [
                        "camlinternalFormat.ml",
                        792,
                        22
                      ]
                    ];
            }
          }
          break;
      case 14 : 
          if (typeof ty2 === "number") {
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    797,
                    30
                  ]
                ];
          }
          else {
            switch (ty2.tag | 0) {
              case 10 : 
                  exit = 1;
                  break;
              case 11 : 
                  exit = 2;
                  break;
              case 12 : 
                  exit = 3;
                  break;
              case 13 : 
                  exit = 4;
                  break;
              case 14 : 
                  return /* Ignored_reader_ty */Block.__(14, [trans(ty1[0], ty2[0])]);
              default:
                throw [
                      Caml_builtin_exceptions.assert_failure,
                      [
                        "camlinternalFormat.ml",
                        797,
                        30
                      ]
                    ];
            }
          }
          break;
      
    }
  }
  switch (exit) {
    case 1 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                781,
                21
              ]
            ];
    case 2 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                785,
                21
              ]
            ];
    case 3 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                789,
                19
              ]
            ];
    case 4 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                793,
                22
              ]
            ];
    case 5 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                798,
                30
              ]
            ];
    case 6 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                803,
                26
              ]
            ];
    case 7 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                813,
                28
              ]
            ];
    case 8 : 
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                817,
                23
              ]
            ];
    
  }
}

function fmtty_of_formatting_gen(formatting_gen) {
  return fmtty_of_fmt(formatting_gen[0][0]);
}

function fmtty_of_fmt(_fmtty) {
  while(true) {
    var fmtty = _fmtty;
    if (typeof fmtty === "number") {
      return /* End_of_fmtty */0;
    }
    else {
      switch (fmtty.tag | 0) {
        case 2 : 
        case 3 : 
            return fmtty_of_padding_fmtty(fmtty[0], /* String_ty */Block.__(1, [fmtty_of_fmt(fmtty[1])]));
        case 4 : 
            var ty_rest = fmtty_of_fmt(fmtty[3]);
            var prec_ty = fmtty_of_precision_fmtty(fmtty[2], /* Int_ty */Block.__(2, [ty_rest]));
            return fmtty_of_padding_fmtty(fmtty[1], prec_ty);
        case 5 : 
            var ty_rest$1 = fmtty_of_fmt(fmtty[3]);
            var prec_ty$1 = fmtty_of_precision_fmtty(fmtty[2], /* Int32_ty */Block.__(3, [ty_rest$1]));
            return fmtty_of_padding_fmtty(fmtty[1], prec_ty$1);
        case 6 : 
            var ty_rest$2 = fmtty_of_fmt(fmtty[3]);
            var prec_ty$2 = fmtty_of_precision_fmtty(fmtty[2], /* Nativeint_ty */Block.__(4, [ty_rest$2]));
            return fmtty_of_padding_fmtty(fmtty[1], prec_ty$2);
        case 7 : 
            var ty_rest$3 = fmtty_of_fmt(fmtty[3]);
            var prec_ty$3 = fmtty_of_precision_fmtty(fmtty[2], /* Int64_ty */Block.__(5, [ty_rest$3]));
            return fmtty_of_padding_fmtty(fmtty[1], prec_ty$3);
        case 8 : 
            var ty_rest$4 = fmtty_of_fmt(fmtty[3]);
            var prec_ty$4 = fmtty_of_precision_fmtty(fmtty[2], /* Float_ty */Block.__(6, [ty_rest$4]));
            return fmtty_of_padding_fmtty(fmtty[1], prec_ty$4);
        case 9 : 
            return /* Bool_ty */Block.__(7, [fmtty_of_fmt(fmtty[0])]);
        case 10 : 
            _fmtty = fmtty[0];
            continue ;
            case 13 : 
            return /* Format_arg_ty */Block.__(8, [
                      fmtty[1],
                      fmtty_of_fmt(fmtty[2])
                    ]);
        case 14 : 
            var ty = fmtty[1];
            return /* Format_subst_ty */Block.__(9, [
                      ty,
                      ty,
                      fmtty_of_fmt(fmtty[2])
                    ]);
        case 15 : 
            return /* Alpha_ty */Block.__(10, [fmtty_of_fmt(fmtty[0])]);
        case 16 : 
            return /* Theta_ty */Block.__(11, [fmtty_of_fmt(fmtty[0])]);
        case 11 : 
        case 12 : 
        case 17 : 
            _fmtty = fmtty[1];
            continue ;
            case 18 : 
            return CamlinternalFormatBasics.concat_fmtty(fmtty_of_formatting_gen(fmtty[0]), fmtty_of_fmt(fmtty[1]));
        case 19 : 
            return /* Reader_ty */Block.__(13, [fmtty_of_fmt(fmtty[0])]);
        case 20 : 
            return /* String_ty */Block.__(1, [fmtty_of_fmt(fmtty[2])]);
        case 21 : 
            return /* Int_ty */Block.__(2, [fmtty_of_fmt(fmtty[1])]);
        case 0 : 
        case 1 : 
        case 22 : 
            return /* Char_ty */Block.__(0, [fmtty_of_fmt(fmtty[0])]);
        case 23 : 
            var ign = fmtty[0];
            var fmt = fmtty[1];
            if (typeof ign === "number") {
              switch (ign) {
                case 3 : 
                    return /* Ignored_reader_ty */Block.__(14, [fmtty_of_fmt(fmt)]);
                case 0 : 
                case 1 : 
                case 2 : 
                case 4 : 
                    return fmtty_of_fmt(fmt);
                
              }
            }
            else {
              switch (ign.tag | 0) {
                case 8 : 
                    return CamlinternalFormatBasics.concat_fmtty(ign[1], fmtty_of_fmt(fmt));
                case 0 : 
                case 1 : 
                case 2 : 
                case 3 : 
                case 4 : 
                case 5 : 
                case 6 : 
                case 7 : 
                case 9 : 
                case 10 : 
                    return fmtty_of_fmt(fmt);
                
              }
            }
        case 24 : 
            return fmtty_of_custom(fmtty[0], fmtty_of_fmt(fmtty[2]));
        
      }
    }
  };
}

function fmtty_of_custom(arity, fmtty) {
  if (arity) {
    return /* Any_ty */Block.__(12, [fmtty_of_custom(arity[0], fmtty)]);
  }
  else {
    return fmtty;
  }
}

function fmtty_of_padding_fmtty(pad, fmtty) {
  if (typeof pad === "number" || !pad.tag) {
    return fmtty;
  }
  else {
    return /* Int_ty */Block.__(2, [fmtty]);
  }
}

function fmtty_of_precision_fmtty(prec, fmtty) {
  if (typeof prec === "number" && prec !== 0) {
    return /* Int_ty */Block.__(2, [fmtty]);
  }
  else {
    return fmtty;
  }
}

var Type_mismatch = Caml_exceptions.create("CamlinternalFormat.Type_mismatch");

function type_padding(pad, fmtty) {
  if (typeof pad === "number") {
    return /* Padding_fmtty_EBB */[
            /* No_padding */0,
            fmtty
          ];
  }
  else if (pad.tag) {
    if (typeof fmtty === "number") {
      throw Type_mismatch;
    }
    else if (fmtty.tag === 2) {
      return /* Padding_fmtty_EBB */[
              /* Arg_padding */Block.__(1, [pad[0]]),
              fmtty[0]
            ];
    }
    else {
      throw Type_mismatch;
    }
  }
  else {
    return /* Padding_fmtty_EBB */[
            /* Lit_padding */Block.__(0, [
                pad[0],
                pad[1]
              ]),
            fmtty
          ];
  }
}

function type_padprec(pad, prec, fmtty) {
  var match = type_padding(pad, fmtty);
  if (typeof prec === "number") {
    if (prec !== 0) {
      var match$1 = match[1];
      if (typeof match$1 === "number") {
        throw Type_mismatch;
      }
      else if (match$1.tag === 2) {
        return /* Padprec_fmtty_EBB */[
                match[0],
                /* Arg_precision */1,
                match$1[0]
              ];
      }
      else {
        throw Type_mismatch;
      }
    }
    else {
      return /* Padprec_fmtty_EBB */[
              match[0],
              /* No_precision */0,
              match[1]
            ];
    }
  }
  else {
    return /* Padprec_fmtty_EBB */[
            match[0],
            /* Lit_precision */[prec[0]],
            match[1]
          ];
  }
}

function type_ignored_param_one(ign, fmt, fmtty) {
  var match = type_format_gen(fmt, fmtty);
  return /* Fmt_fmtty_EBB */[
          /* Ignored_param */Block.__(23, [
              ign,
              match[0]
            ]),
          match[1]
        ];
}

function type_format_gen(fmt, fmtty) {
  if (typeof fmt === "number") {
    return /* Fmt_fmtty_EBB */[
            /* End_of_format */0,
            fmtty
          ];
  }
  else {
    switch (fmt.tag | 0) {
      case 0 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag) {
            throw Type_mismatch;
          }
          else {
            var match = type_format_gen(fmt[0], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Char */Block.__(0, [match[0]]),
                    match[1]
                  ];
          }
          break;
      case 1 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag) {
            throw Type_mismatch;
          }
          else {
            var match$1 = type_format_gen(fmt[0], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Caml_char */Block.__(1, [match$1[0]]),
                    match$1[1]
                  ];
          }
          break;
      case 2 : 
          var match$2 = type_padding(fmt[0], fmtty);
          var match$3 = match$2[1];
          if (typeof match$3 === "number") {
            throw Type_mismatch;
          }
          else if (match$3.tag === 1) {
            var match$4 = type_format_gen(fmt[1], match$3[0]);
            return /* Fmt_fmtty_EBB */[
                    /* String */Block.__(2, [
                        match$2[0],
                        match$4[0]
                      ]),
                    match$4[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 3 : 
          var match$5 = type_padding(fmt[0], fmtty);
          var match$6 = match$5[1];
          if (typeof match$6 === "number") {
            throw Type_mismatch;
          }
          else if (match$6.tag === 1) {
            var match$7 = type_format_gen(fmt[1], match$6[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Caml_string */Block.__(3, [
                        match$5[0],
                        match$7[0]
                      ]),
                    match$7[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 4 : 
          var match$8 = type_padprec(fmt[1], fmt[2], fmtty);
          var match$9 = match$8[2];
          if (typeof match$9 === "number") {
            throw Type_mismatch;
          }
          else if (match$9.tag === 2) {
            var match$10 = type_format_gen(fmt[3], match$9[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Int */Block.__(4, [
                        fmt[0],
                        match$8[0],
                        match$8[1],
                        match$10[0]
                      ]),
                    match$10[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 5 : 
          var match$11 = type_padprec(fmt[1], fmt[2], fmtty);
          var match$12 = match$11[2];
          if (typeof match$12 === "number") {
            throw Type_mismatch;
          }
          else if (match$12.tag === 3) {
            var match$13 = type_format_gen(fmt[3], match$12[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Int32 */Block.__(5, [
                        fmt[0],
                        match$11[0],
                        match$11[1],
                        match$13[0]
                      ]),
                    match$13[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 6 : 
          var match$14 = type_padprec(fmt[1], fmt[2], fmtty);
          var match$15 = match$14[2];
          if (typeof match$15 === "number") {
            throw Type_mismatch;
          }
          else if (match$15.tag === 4) {
            var match$16 = type_format_gen(fmt[3], match$15[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Nativeint */Block.__(6, [
                        fmt[0],
                        match$14[0],
                        match$14[1],
                        match$16[0]
                      ]),
                    match$16[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 7 : 
          var match$17 = type_padprec(fmt[1], fmt[2], fmtty);
          var match$18 = match$17[2];
          if (typeof match$18 === "number") {
            throw Type_mismatch;
          }
          else if (match$18.tag === 5) {
            var match$19 = type_format_gen(fmt[3], match$18[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Int64 */Block.__(7, [
                        fmt[0],
                        match$17[0],
                        match$17[1],
                        match$19[0]
                      ]),
                    match$19[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 8 : 
          var match$20 = type_padprec(fmt[1], fmt[2], fmtty);
          var match$21 = match$20[2];
          if (typeof match$21 === "number") {
            throw Type_mismatch;
          }
          else if (match$21.tag === 6) {
            var match$22 = type_format_gen(fmt[3], match$21[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Float */Block.__(8, [
                        fmt[0],
                        match$20[0],
                        match$20[1],
                        match$22[0]
                      ]),
                    match$22[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 9 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 7) {
            var match$23 = type_format_gen(fmt[0], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Bool */Block.__(9, [match$23[0]]),
                    match$23[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 10 : 
          var match$24 = type_format_gen(fmt[0], fmtty);
          return /* Fmt_fmtty_EBB */[
                  /* Flush */Block.__(10, [match$24[0]]),
                  match$24[1]
                ];
      case 11 : 
          var match$25 = type_format_gen(fmt[1], fmtty);
          return /* Fmt_fmtty_EBB */[
                  /* String_literal */Block.__(11, [
                      fmt[0],
                      match$25[0]
                    ]),
                  match$25[1]
                ];
      case 12 : 
          var match$26 = type_format_gen(fmt[1], fmtty);
          return /* Fmt_fmtty_EBB */[
                  /* Char_literal */Block.__(12, [
                      fmt[0],
                      match$26[0]
                    ]),
                  match$26[1]
                ];
      case 13 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 8) {
            var sub_fmtty$prime = fmtty[0];
            if (Caml_obj.caml_notequal(/* Fmtty_EBB */[fmt[1]], /* Fmtty_EBB */[sub_fmtty$prime])) {
              throw Type_mismatch;
            }
            var match$27 = type_format_gen(fmt[2], fmtty[1]);
            return /* Fmt_fmtty_EBB */[
                    /* Format_arg */Block.__(13, [
                        fmt[0],
                        sub_fmtty$prime,
                        match$27[0]
                      ]),
                    match$27[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 14 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 9) {
            var sub_fmtty1 = fmtty[0];
            if (Caml_obj.caml_notequal(/* Fmtty_EBB */[CamlinternalFormatBasics.erase_rel(fmt[1])], /* Fmtty_EBB */[CamlinternalFormatBasics.erase_rel(sub_fmtty1)])) {
              throw Type_mismatch;
            }
            var match$28 = type_format_gen(fmt[2], CamlinternalFormatBasics.erase_rel(fmtty[2]));
            return /* Fmt_fmtty_EBB */[
                    /* Format_subst */Block.__(14, [
                        fmt[0],
                        sub_fmtty1,
                        match$28[0]
                      ]),
                    match$28[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 15 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 10) {
            var match$29 = type_format_gen(fmt[0], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Alpha */Block.__(15, [match$29[0]]),
                    match$29[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 16 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 11) {
            var match$30 = type_format_gen(fmt[0], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Theta */Block.__(16, [match$30[0]]),
                    match$30[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 17 : 
          var match$31 = type_format_gen(fmt[1], fmtty);
          return /* Fmt_fmtty_EBB */[
                  /* Formatting_lit */Block.__(17, [
                      fmt[0],
                      match$31[0]
                    ]),
                  match$31[1]
                ];
      case 18 : 
          var formatting_gen = fmt[0];
          var fmt0 = fmt[1];
          var fmtty0 = fmtty;
          if (formatting_gen.tag) {
            var match$32 = formatting_gen[0];
            var match$33 = type_format_gen(match$32[0], fmtty0);
            var match$34 = type_format_gen(fmt0, match$33[1]);
            return /* Fmt_fmtty_EBB */[
                    /* Formatting_gen */Block.__(18, [
                        /* Open_box */Block.__(1, [/* Format */[
                              match$33[0],
                              match$32[1]
                            ]]),
                        match$34[0]
                      ]),
                    match$34[1]
                  ];
          }
          else {
            var match$35 = formatting_gen[0];
            var match$36 = type_format_gen(match$35[0], fmtty0);
            var match$37 = type_format_gen(fmt0, match$36[1]);
            return /* Fmt_fmtty_EBB */[
                    /* Formatting_gen */Block.__(18, [
                        /* Open_tag */Block.__(0, [/* Format */[
                              match$36[0],
                              match$35[1]
                            ]]),
                        match$37[0]
                      ]),
                    match$37[1]
                  ];
          }
      case 19 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 13) {
            var match$38 = type_format_gen(fmt[0], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Reader */Block.__(19, [match$38[0]]),
                    match$38[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 20 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 1) {
            var match$39 = type_format_gen(fmt[2], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Scan_char_set */Block.__(20, [
                        fmt[0],
                        fmt[1],
                        match$39[0]
                      ]),
                    match$39[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 21 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 2) {
            var match$40 = type_format_gen(fmt[1], fmtty[0]);
            return /* Fmt_fmtty_EBB */[
                    /* Scan_get_counter */Block.__(21, [
                        fmt[0],
                        match$40[0]
                      ]),
                    match$40[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 23 : 
          var ign = fmt[0];
          var fmt$1 = fmt[1];
          var fmtty$1 = fmtty;
          if (typeof ign === "number") {
            switch (ign) {
              case 3 : 
                  if (typeof fmtty$1 === "number") {
                    throw Type_mismatch;
                  }
                  else if (fmtty$1.tag === 14) {
                    var match$41 = type_format_gen(fmt$1, fmtty$1[0]);
                    return /* Fmt_fmtty_EBB */[
                            /* Ignored_param */Block.__(23, [
                                /* Ignored_reader */3,
                                match$41[0]
                              ]),
                            match$41[1]
                          ];
                  }
                  else {
                    throw Type_mismatch;
                  }
                  break;
              case 0 : 
              case 1 : 
              case 2 : 
              case 4 : 
                  return type_ignored_param_one(ign, fmt$1, fmtty$1);
              
            }
          }
          else {
            switch (ign.tag | 0) {
              case 7 : 
                  return type_ignored_param_one(/* Ignored_format_arg */Block.__(7, [
                                ign[0],
                                ign[1]
                              ]), fmt$1, fmtty$1);
              case 8 : 
                  var match$42 = type_ignored_format_substitution(ign[1], fmt$1, fmtty$1);
                  var match$43 = match$42[1];
                  return /* Fmt_fmtty_EBB */[
                          /* Ignored_param */Block.__(23, [
                              /* Ignored_format_subst */Block.__(8, [
                                  ign[0],
                                  match$42[0]
                                ]),
                              match$43[0]
                            ]),
                          match$43[1]
                        ];
              case 0 : 
              case 1 : 
              case 2 : 
              case 3 : 
              case 4 : 
              case 5 : 
              case 6 : 
              case 9 : 
              case 10 : 
                  return type_ignored_param_one(ign, fmt$1, fmtty$1);
              
            }
          }
      case 22 : 
      case 24 : 
          throw Type_mismatch;
      
    }
  }
}

function type_ignored_format_substitution(sub_fmtty, fmt, fmtty) {
  if (typeof sub_fmtty === "number") {
    return /* Fmtty_fmt_EBB */[
            /* End_of_fmtty */0,
            type_format_gen(fmt, fmtty)
          ];
  }
  else {
    switch (sub_fmtty.tag | 0) {
      case 0 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag) {
            throw Type_mismatch;
          }
          else {
            var match = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Char_ty */Block.__(0, [match[0]]),
                    match[1]
                  ];
          }
          break;
      case 1 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 1) {
            var match$1 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* String_ty */Block.__(1, [match$1[0]]),
                    match$1[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 2 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 2) {
            var match$2 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Int_ty */Block.__(2, [match$2[0]]),
                    match$2[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 3 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 3) {
            var match$3 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Int32_ty */Block.__(3, [match$3[0]]),
                    match$3[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 4 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 4) {
            var match$4 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Nativeint_ty */Block.__(4, [match$4[0]]),
                    match$4[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 5 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 5) {
            var match$5 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Int64_ty */Block.__(5, [match$5[0]]),
                    match$5[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 6 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 6) {
            var match$6 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Float_ty */Block.__(6, [match$6[0]]),
                    match$6[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 7 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 7) {
            var match$7 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Bool_ty */Block.__(7, [match$7[0]]),
                    match$7[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 8 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 8) {
            var sub2_fmtty$prime = fmtty[0];
            if (Caml_obj.caml_notequal(/* Fmtty_EBB */[sub_fmtty[0]], /* Fmtty_EBB */[sub2_fmtty$prime])) {
              throw Type_mismatch;
            }
            var match$8 = type_ignored_format_substitution(sub_fmtty[1], fmt, fmtty[1]);
            return /* Fmtty_fmt_EBB */[
                    /* Format_arg_ty */Block.__(8, [
                        sub2_fmtty$prime,
                        match$8[0]
                      ]),
                    match$8[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 9 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 9) {
            var sub2_fmtty$prime$1 = fmtty[1];
            var sub1_fmtty$prime = fmtty[0];
            if (Caml_obj.caml_notequal(/* Fmtty_EBB */[CamlinternalFormatBasics.erase_rel(sub_fmtty[0])], /* Fmtty_EBB */[CamlinternalFormatBasics.erase_rel(sub1_fmtty$prime)])) {
              throw Type_mismatch;
            }
            if (Caml_obj.caml_notequal(/* Fmtty_EBB */[CamlinternalFormatBasics.erase_rel(sub_fmtty[1])], /* Fmtty_EBB */[CamlinternalFormatBasics.erase_rel(sub2_fmtty$prime$1)])) {
              throw Type_mismatch;
            }
            var sub_fmtty$prime = trans(symm(sub1_fmtty$prime), sub2_fmtty$prime$1);
            var match$9 = fmtty_rel_det(sub_fmtty$prime);
            Curry._1(match$9[1], /* Refl */0);
            Curry._1(match$9[3], /* Refl */0);
            var match$10 = type_ignored_format_substitution(CamlinternalFormatBasics.erase_rel(sub_fmtty[2]), fmt, fmtty[2]);
            return /* Fmtty_fmt_EBB */[
                    /* Format_subst_ty */Block.__(9, [
                        sub1_fmtty$prime,
                        sub2_fmtty$prime$1,
                        symm(match$10[0])
                      ]),
                    match$10[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 10 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 10) {
            var match$11 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Alpha_ty */Block.__(10, [match$11[0]]),
                    match$11[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 11 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 11) {
            var match$12 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Theta_ty */Block.__(11, [match$12[0]]),
                    match$12[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 12 : 
          throw Type_mismatch;
      case 13 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 13) {
            var match$13 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Reader_ty */Block.__(13, [match$13[0]]),
                    match$13[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      case 14 : 
          if (typeof fmtty === "number") {
            throw Type_mismatch;
          }
          else if (fmtty.tag === 14) {
            var match$14 = type_ignored_format_substitution(sub_fmtty[0], fmt, fmtty[0]);
            return /* Fmtty_fmt_EBB */[
                    /* Ignored_reader_ty */Block.__(14, [match$14[0]]),
                    match$14[1]
                  ];
          }
          else {
            throw Type_mismatch;
          }
          break;
      
    }
  }
}

function type_format(fmt, fmtty) {
  var match = type_format_gen(fmt, fmtty);
  if (typeof match[1] === "number") {
    return match[0];
  }
  else {
    throw Type_mismatch;
  }
}

function recast(fmt, fmtty) {
  return type_format(fmt, CamlinternalFormatBasics.erase_rel(symm(fmtty)));
}

function fix_padding(padty, width, str) {
  var len = str.length;
  var match_000 = Pervasives.abs(width);
  var match_001 = width < 0 ? /* Left */0 : padty;
  var padty$1 = match_001;
  var width$1 = match_000;
  if (width$1 <= len) {
    return str;
  }
  else {
    var res = Bytes.make(width$1, padty$1 === /* Zeros */2 ? /* "0" */48 : /* " " */32);
    switch (padty$1) {
      case 0 : 
          $$String.blit(str, 0, res, 0, len);
          break;
      case 1 : 
          $$String.blit(str, 0, res, width$1 - len | 0, len);
          break;
      case 2 : 
          if (len > 0 && (Caml_string.get(str, 0) === /* "+" */43 || Caml_string.get(str, 0) === /* "-" */45 || Caml_string.get(str, 0) === /* " " */32)) {
            res[0] = Caml_string.get(str, 0);
            $$String.blit(str, 1, res, (width$1 - len | 0) + 1 | 0, len - 1 | 0);
          }
          else if (len > 1 && Caml_string.get(str, 0) === /* "0" */48 && (Caml_string.get(str, 1) === /* "x" */120 || Caml_string.get(str, 1) === /* "X" */88)) {
            res[1] = Caml_string.get(str, 1);
            $$String.blit(str, 2, res, (width$1 - len | 0) + 2 | 0, len - 2 | 0);
          }
          else {
            $$String.blit(str, 0, res, width$1 - len | 0, len);
          }
          break;
      
    }
    return Caml_string.bytes_to_string(res);
  }
}

function fix_int_precision(prec, str) {
  var prec$1 = Pervasives.abs(prec);
  var len = str.length;
  var c = Caml_string.get(str, 0);
  var exit = 0;
  if (c >= 58) {
    if (c >= 71) {
      if (c > 102 || c < 97) {
        return str;
      }
      else {
        exit = 2;
      }
    }
    else if (c >= 65) {
      exit = 2;
    }
    else {
      return str;
    }
  }
  else if (c !== 32) {
    if (c >= 43) {
      switch (c - 43 | 0) {
        case 0 : 
        case 2 : 
            exit = 1;
            break;
        case 1 : 
        case 3 : 
        case 4 : 
            return str;
        case 5 : 
            if ((prec$1 + 2 | 0) > len && len > 1 && (Caml_string.get(str, 1) === /* "x" */120 || Caml_string.get(str, 1) === /* "X" */88)) {
              var res = Bytes.make(prec$1 + 2 | 0, /* "0" */48);
              res[1] = Caml_string.get(str, 1);
              $$String.blit(str, 2, res, (prec$1 - len | 0) + 4 | 0, len - 2 | 0);
              return Caml_string.bytes_to_string(res);
            }
            else {
              exit = 2;
            }
            break;
        case 6 : 
        case 7 : 
        case 8 : 
        case 9 : 
        case 10 : 
        case 11 : 
        case 12 : 
        case 13 : 
        case 14 : 
            exit = 2;
            break;
        
      }
    }
    else {
      return str;
    }
  }
  else {
    exit = 1;
  }
  switch (exit) {
    case 1 : 
        if ((prec$1 + 1 | 0) > len) {
          var res$1 = Bytes.make(prec$1 + 1 | 0, /* "0" */48);
          res$1[0] = c;
          $$String.blit(str, 1, res$1, (prec$1 - len | 0) + 2 | 0, len - 1 | 0);
          return Caml_string.bytes_to_string(res$1);
        }
        else {
          return str;
        }
        break;
    case 2 : 
        if (prec$1 > len) {
          var res$2 = Bytes.make(prec$1, /* "0" */48);
          $$String.blit(str, 0, res$2, prec$1 - len | 0, len);
          return Caml_string.bytes_to_string(res$2);
        }
        else {
          return str;
        }
        break;
    
  }
}

function string_to_caml_string(str) {
  return $$String.concat($$String.escaped(str), /* :: */[
              '"',
              /* :: */[
                '"',
                /* [] */0
              ]
            ]);
}

function format_of_iconv(iconv) {
  switch (iconv) {
    case 0 : 
        return "%d";
    case 1 : 
        return "%+d";
    case 2 : 
        return "% d";
    case 3 : 
        return "%i";
    case 4 : 
        return "%+i";
    case 5 : 
        return "% i";
    case 6 : 
        return "%x";
    case 7 : 
        return "%#x";
    case 8 : 
        return "%X";
    case 9 : 
        return "%#X";
    case 10 : 
        return "%o";
    case 11 : 
        return "%#o";
    case 12 : 
        return "%u";
    
  }
}

function format_of_aconv(iconv, c) {
  var seps;
  switch (iconv) {
    case 0 : 
        seps = /* :: */[
          "%",
          /* :: */[
            "d",
            /* [] */0
          ]
        ];
        break;
    case 1 : 
        seps = /* :: */[
          "%+",
          /* :: */[
            "d",
            /* [] */0
          ]
        ];
        break;
    case 2 : 
        seps = /* :: */[
          "% ",
          /* :: */[
            "d",
            /* [] */0
          ]
        ];
        break;
    case 3 : 
        seps = /* :: */[
          "%",
          /* :: */[
            "i",
            /* [] */0
          ]
        ];
        break;
    case 4 : 
        seps = /* :: */[
          "%+",
          /* :: */[
            "i",
            /* [] */0
          ]
        ];
        break;
    case 5 : 
        seps = /* :: */[
          "% ",
          /* :: */[
            "i",
            /* [] */0
          ]
        ];
        break;
    case 6 : 
        seps = /* :: */[
          "%",
          /* :: */[
            "x",
            /* [] */0
          ]
        ];
        break;
    case 7 : 
        seps = /* :: */[
          "%#",
          /* :: */[
            "x",
            /* [] */0
          ]
        ];
        break;
    case 8 : 
        seps = /* :: */[
          "%",
          /* :: */[
            "X",
            /* [] */0
          ]
        ];
        break;
    case 9 : 
        seps = /* :: */[
          "%#",
          /* :: */[
            "X",
            /* [] */0
          ]
        ];
        break;
    case 10 : 
        seps = /* :: */[
          "%",
          /* :: */[
            "o",
            /* [] */0
          ]
        ];
        break;
    case 11 : 
        seps = /* :: */[
          "%#",
          /* :: */[
            "o",
            /* [] */0
          ]
        ];
        break;
    case 12 : 
        seps = /* :: */[
          "%",
          /* :: */[
            "u",
            /* [] */0
          ]
        ];
        break;
    
  }
  return $$String.concat(Caml_string.bytes_to_string(Bytes.make(1, c)), seps);
}

function format_of_fconv(fconv, prec) {
  if (fconv === /* Float_F */15) {
    return "%.12g";
  }
  else {
    var prec$1 = Pervasives.abs(prec);
    var symb = char_of_fconv(fconv);
    var buf = /* record */[
      /* ind */0,
      /* bytes */new Array(16)
    ];
    buffer_add_char(buf, /* "%" */37);
    bprint_fconv_flag(buf, fconv);
    buffer_add_char(buf, /* "." */46);
    buffer_add_string(buf, "" + prec$1);
    buffer_add_char(buf, symb);
    return buffer_contents(buf);
  }
}

function convert_int(iconv, n) {
  return Caml_format.caml_format_int(format_of_iconv(iconv), n);
}

function convert_int32(iconv, n) {
  return Caml_format.caml_int32_format(format_of_aconv(iconv, /* "l" */108), n);
}

function convert_nativeint(iconv, n) {
  return Caml_format.caml_nativeint_format(format_of_aconv(iconv, /* "n" */110), n);
}

function convert_int64(iconv, n) {
  return Caml_format.caml_int64_format(format_of_aconv(iconv, /* "L" */76), n);
}

function convert_float(fconv, prec, x) {
  var prec$1 = Pervasives.abs(prec);
  var str = Caml_format.caml_format_float(format_of_fconv(fconv, prec$1), x);
  if (fconv !== /* Float_F */15) {
    return str;
  }
  else {
    var len = str.length;
    var is_valid = function (_i) {
      while(true) {
        var i = _i;
        if (i === len) {
          return /* false */0;
        }
        else {
          var match = Caml_string.get(str, i);
          var switcher = match - 46 | 0;
          if (switcher > 23 || switcher < 0) {
            if (switcher !== 55) {
              _i = i + 1 | 0;
              continue ;
              
            }
            else {
              return /* true */1;
            }
          }
          else if (switcher > 22 || switcher < 1) {
            return /* true */1;
          }
          else {
            _i = i + 1 | 0;
            continue ;
            
          }
        }
      };
    };
    var match = Caml_float.caml_classify_float(x);
    if (match !== 3) {
      if (match >= 4) {
        return "nan";
      }
      else if (is_valid(0)) {
        return str;
      }
      else {
        return str + ".";
      }
    }
    else if (x < 0.0) {
      return "neg_infinity";
    }
    else {
      return "infinity";
    }
  }
}

function format_caml_char(c) {
  return $$String.concat(Char.escaped(c), /* :: */[
              "'",
              /* :: */[
                "'",
                /* [] */0
              ]
            ]);
}

function string_of_fmtty(fmtty) {
  var buf = /* record */[
    /* ind */0,
    /* bytes */new Array(16)
  ];
  bprint_fmtty(buf, fmtty);
  return buffer_contents(buf);
}

function make_printf(_k, o, _acc, _fmt) {
  while(true) {
    var fmt = _fmt;
    var acc = _acc;
    var k = _k;
    if (typeof fmt === "number") {
      return Curry._2(k, o, acc);
    }
    else {
      switch (fmt.tag | 0) {
        case 0 : 
            var rest = fmt[0];
            return (function(k,acc,rest){
            return function (c) {
              var new_acc = /* Acc_data_char */Block.__(5, [
                  acc,
                  c
                ]);
              return make_printf(k, o, new_acc, rest);
            }
            }(k,acc,rest));
        case 1 : 
            var rest$1 = fmt[0];
            return (function(k,acc,rest$1){
            return function (c) {
              var new_acc_001 = format_caml_char(c);
              var new_acc = /* Acc_data_string */Block.__(4, [
                  acc,
                  new_acc_001
                ]);
              return make_printf(k, o, new_acc, rest$1);
            }
            }(k,acc,rest$1));
        case 2 : 
            return make_string_padding(k, o, acc, fmt[1], fmt[0], function (str) {
                        return str;
                      });
        case 3 : 
            return make_string_padding(k, o, acc, fmt[1], fmt[0], string_to_caml_string);
        case 4 : 
            return make_int_padding_precision(k, o, acc, fmt[3], fmt[1], fmt[2], convert_int, fmt[0]);
        case 5 : 
            return make_int_padding_precision(k, o, acc, fmt[3], fmt[1], fmt[2], convert_int32, fmt[0]);
        case 6 : 
            return make_int_padding_precision(k, o, acc, fmt[3], fmt[1], fmt[2], convert_nativeint, fmt[0]);
        case 7 : 
            return make_int_padding_precision(k, o, acc, fmt[3], fmt[1], fmt[2], convert_int64, fmt[0]);
        case 8 : 
            var k$1 = k;
            var o$1 = o;
            var acc$1 = acc;
            var fmt$1 = fmt[3];
            var pad = fmt[1];
            var prec = fmt[2];
            var fconv = fmt[0];
            if (typeof pad === "number") {
              if (typeof prec === "number") {
                if (prec !== 0) {
                  return (function(k$1,o$1,acc$1,fmt$1,fconv){
                  return function (p, x) {
                    var str = convert_float(fconv, p, x);
                    return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                  acc$1,
                                  str
                                ]), fmt$1);
                  }
                  }(k$1,o$1,acc$1,fmt$1,fconv));
                }
                else {
                  return (function(k$1,o$1,acc$1,fmt$1,fconv){
                  return function (x) {
                    var str = convert_float(fconv, 6, x);
                    return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                  acc$1,
                                  str
                                ]), fmt$1);
                  }
                  }(k$1,o$1,acc$1,fmt$1,fconv));
                }
              }
              else {
                var p = prec[0];
                return (function(k$1,o$1,acc$1,fmt$1,fconv,p){
                return function (x) {
                  var str = convert_float(fconv, p, x);
                  return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                acc$1,
                                str
                              ]), fmt$1);
                }
                }(k$1,o$1,acc$1,fmt$1,fconv,p));
              }
            }
            else if (pad.tag) {
              var padty = pad[0];
              if (typeof prec === "number") {
                if (prec !== 0) {
                  return (function(k$1,o$1,acc$1,fmt$1,fconv,padty){
                  return function (w, p, x) {
                    var str = fix_padding(padty, w, convert_float(fconv, p, x));
                    return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                  acc$1,
                                  str
                                ]), fmt$1);
                  }
                  }(k$1,o$1,acc$1,fmt$1,fconv,padty));
                }
                else {
                  return (function(k$1,o$1,acc$1,fmt$1,fconv,padty){
                  return function (w, x) {
                    var str = convert_float(fconv, 6, x);
                    var str$prime = fix_padding(padty, w, str);
                    return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                  acc$1,
                                  str$prime
                                ]), fmt$1);
                  }
                  }(k$1,o$1,acc$1,fmt$1,fconv,padty));
                }
              }
              else {
                var p$1 = prec[0];
                return (function(k$1,o$1,acc$1,fmt$1,fconv,padty,p$1){
                return function (w, x) {
                  var str = fix_padding(padty, w, convert_float(fconv, p$1, x));
                  return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                acc$1,
                                str
                              ]), fmt$1);
                }
                }(k$1,o$1,acc$1,fmt$1,fconv,padty,p$1));
              }
            }
            else {
              var w = pad[1];
              var padty$1 = pad[0];
              if (typeof prec === "number") {
                if (prec !== 0) {
                  return (function(k$1,o$1,acc$1,fmt$1,fconv,padty$1,w){
                  return function (p, x) {
                    var str = fix_padding(padty$1, w, convert_float(fconv, p, x));
                    return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                  acc$1,
                                  str
                                ]), fmt$1);
                  }
                  }(k$1,o$1,acc$1,fmt$1,fconv,padty$1,w));
                }
                else {
                  return (function(k$1,o$1,acc$1,fmt$1,fconv,padty$1,w){
                  return function (x) {
                    var str = convert_float(fconv, 6, x);
                    var str$prime = fix_padding(padty$1, w, str);
                    return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                  acc$1,
                                  str$prime
                                ]), fmt$1);
                  }
                  }(k$1,o$1,acc$1,fmt$1,fconv,padty$1,w));
                }
              }
              else {
                var p$2 = prec[0];
                return (function(k$1,o$1,acc$1,fmt$1,fconv,padty$1,w,p$2){
                return function (x) {
                  var str = fix_padding(padty$1, w, convert_float(fconv, p$2, x));
                  return make_printf(k$1, o$1, /* Acc_data_string */Block.__(4, [
                                acc$1,
                                str
                              ]), fmt$1);
                }
                }(k$1,o$1,acc$1,fmt$1,fconv,padty$1,w,p$2));
              }
            }
        case 9 : 
            var rest$2 = fmt[0];
            return (function(k,acc,rest$2){
            return function (b) {
              return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                            acc,
                            b ? "true" : "false"
                          ]), rest$2);
            }
            }(k,acc,rest$2));
        case 10 : 
            _fmt = fmt[0];
            _acc = /* Acc_flush */Block.__(7, [acc]);
            continue ;
            case 11 : 
            _fmt = fmt[1];
            _acc = /* Acc_string_literal */Block.__(2, [
                acc,
                fmt[0]
              ]);
            continue ;
            case 12 : 
            _fmt = fmt[1];
            _acc = /* Acc_char_literal */Block.__(3, [
                acc,
                fmt[0]
              ]);
            continue ;
            case 13 : 
            var rest$3 = fmt[2];
            var ty = string_of_fmtty(fmt[1]);
            return (function(k,acc,rest$3,ty){
            return function () {
              return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                            acc,
                            ty
                          ]), rest$3);
            }
            }(k,acc,rest$3,ty));
        case 14 : 
            var rest$4 = fmt[2];
            var fmtty = fmt[1];
            return (function(k,acc,fmtty,rest$4){
            return function (param) {
              return make_printf(k, o, acc, CamlinternalFormatBasics.concat_fmt(recast(param[0], fmtty), rest$4));
            }
            }(k,acc,fmtty,rest$4));
        case 15 : 
            var rest$5 = fmt[0];
            return (function(k,acc,rest$5){
            return function (f, x) {
              return make_printf(k, o, /* Acc_delay */Block.__(6, [
                            acc,
                            function (o) {
                              return Curry._2(f, o, x);
                            }
                          ]), rest$5);
            }
            }(k,acc,rest$5));
        case 16 : 
            var rest$6 = fmt[0];
            return (function(k,acc,rest$6){
            return function (f) {
              return make_printf(k, o, /* Acc_delay */Block.__(6, [
                            acc,
                            f
                          ]), rest$6);
            }
            }(k,acc,rest$6));
        case 17 : 
            _fmt = fmt[1];
            _acc = /* Acc_formatting_lit */Block.__(0, [
                acc,
                fmt[0]
              ]);
            continue ;
            case 18 : 
            var match = fmt[0];
            if (match.tag) {
              var rest$7 = fmt[1];
              var k$prime = (function(k,acc,rest$7){
              return function k$prime(koc, kacc) {
                return make_printf(k, koc, /* Acc_formatting_gen */Block.__(1, [
                              acc,
                              /* Acc_open_box */Block.__(1, [kacc])
                            ]), rest$7);
              }
              }(k,acc,rest$7));
              _fmt = match[0][0];
              _acc = /* End_of_acc */0;
              _k = k$prime;
              continue ;
              
            }
            else {
              var rest$8 = fmt[1];
              var k$prime$1 = (function(k,acc,rest$8){
              return function k$prime$1(koc, kacc) {
                return make_printf(k, koc, /* Acc_formatting_gen */Block.__(1, [
                              acc,
                              /* Acc_open_tag */Block.__(0, [kacc])
                            ]), rest$8);
              }
              }(k,acc,rest$8));
              _fmt = match[0][0];
              _acc = /* End_of_acc */0;
              _k = k$prime$1;
              continue ;
              
            }
            break;
        case 19 : 
            throw [
                  Caml_builtin_exceptions.assert_failure,
                  [
                    "camlinternalFormat.ml",
                    1449,
                    4
                  ]
                ];
        case 20 : 
            var rest$9 = fmt[2];
            var new_acc = /* Acc_invalid_arg */Block.__(8, [
                acc,
                "Printf: bad conversion %["
              ]);
            return (function(k,rest$9,new_acc){
            return function () {
              return make_printf(k, o, new_acc, rest$9);
            }
            }(k,rest$9,new_acc));
        case 21 : 
            var rest$10 = fmt[1];
            return (function(k,acc,rest$10){
            return function (n) {
              var new_acc_001 = Caml_format.caml_format_int("%u", n);
              var new_acc = /* Acc_data_string */Block.__(4, [
                  acc,
                  new_acc_001
                ]);
              return make_printf(k, o, new_acc, rest$10);
            }
            }(k,acc,rest$10));
        case 22 : 
            var rest$11 = fmt[0];
            return (function(k,acc,rest$11){
            return function (c) {
              var new_acc = /* Acc_data_char */Block.__(5, [
                  acc,
                  c
                ]);
              return make_printf(k, o, new_acc, rest$11);
            }
            }(k,acc,rest$11));
        case 23 : 
            var k$2 = k;
            var o$2 = o;
            var acc$2 = acc;
            var ign = fmt[0];
            var fmt$2 = fmt[1];
            if (typeof ign === "number") {
              switch (ign) {
                case 3 : 
                    throw [
                          Caml_builtin_exceptions.assert_failure,
                          [
                            "camlinternalFormat.ml",
                            1517,
                            39
                          ]
                        ];
                case 0 : 
                case 1 : 
                case 2 : 
                case 4 : 
                    return make_invalid_arg(k$2, o$2, acc$2, fmt$2);
                
              }
            }
            else {
              switch (ign.tag | 0) {
                case 8 : 
                    return make_from_fmtty(k$2, o$2, acc$2, ign[1], fmt$2);
                case 0 : 
                case 1 : 
                case 2 : 
                case 3 : 
                case 4 : 
                case 5 : 
                case 6 : 
                case 7 : 
                case 9 : 
                case 10 : 
                    return make_invalid_arg(k$2, o$2, acc$2, fmt$2);
                
              }
            }
        case 24 : 
            return make_custom(k, o, acc, fmt[2], fmt[0], Curry._1(fmt[1], /* () */0));
        
      }
    }
  };
}

function make_from_fmtty(k, o, acc, fmtty, fmt) {
  if (typeof fmtty === "number") {
    return make_invalid_arg(k, o, acc, fmt);
  }
  else {
    switch (fmtty.tag | 0) {
      case 0 : 
          var rest = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest, fmt);
          };
      case 1 : 
          var rest$1 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$1, fmt);
          };
      case 2 : 
          var rest$2 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$2, fmt);
          };
      case 3 : 
          var rest$3 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$3, fmt);
          };
      case 4 : 
          var rest$4 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$4, fmt);
          };
      case 5 : 
          var rest$5 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$5, fmt);
          };
      case 6 : 
          var rest$6 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$6, fmt);
          };
      case 7 : 
          var rest$7 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$7, fmt);
          };
      case 8 : 
          var rest$8 = fmtty[1];
          return function () {
            return make_from_fmtty(k, o, acc, rest$8, fmt);
          };
      case 9 : 
          var rest$9 = fmtty[2];
          var ty = trans(symm(fmtty[0]), fmtty[1]);
          return function () {
            return make_from_fmtty(k, o, acc, CamlinternalFormatBasics.concat_fmtty(ty, rest$9), fmt);
          };
      case 10 : 
          var rest$10 = fmtty[0];
          return function (_, _$1) {
            return make_from_fmtty(k, o, acc, rest$10, fmt);
          };
      case 11 : 
          var rest$11 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$11, fmt);
          };
      case 12 : 
          var rest$12 = fmtty[0];
          return function () {
            return make_from_fmtty(k, o, acc, rest$12, fmt);
          };
      case 13 : 
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "camlinternalFormat.ml",
                  1540,
                  31
                ]
              ];
      case 14 : 
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "camlinternalFormat.ml",
                  1541,
                  31
                ]
              ];
      
    }
  }
}

function make_invalid_arg(k, o, acc, fmt) {
  return make_printf(k, o, /* Acc_invalid_arg */Block.__(8, [
                acc,
                "Printf: bad conversion %_"
              ]), fmt);
}

function make_string_padding(k, o, acc, fmt, pad, trans) {
  if (typeof pad === "number") {
    return function (x) {
      var new_acc_001 = Curry._1(trans, x);
      var new_acc = /* Acc_data_string */Block.__(4, [
          acc,
          new_acc_001
        ]);
      return make_printf(k, o, new_acc, fmt);
    };
  }
  else if (pad.tag) {
    var padty = pad[0];
    return function (w, x) {
      var new_acc_001 = fix_padding(padty, w, Curry._1(trans, x));
      var new_acc = /* Acc_data_string */Block.__(4, [
          acc,
          new_acc_001
        ]);
      return make_printf(k, o, new_acc, fmt);
    };
  }
  else {
    var width = pad[1];
    var padty$1 = pad[0];
    return function (x) {
      var new_acc_001 = fix_padding(padty$1, width, Curry._1(trans, x));
      var new_acc = /* Acc_data_string */Block.__(4, [
          acc,
          new_acc_001
        ]);
      return make_printf(k, o, new_acc, fmt);
    };
  }
}

function make_int_padding_precision(k, o, acc, fmt, pad, prec, trans, iconv) {
  if (typeof pad === "number") {
    if (typeof prec === "number") {
      if (prec !== 0) {
        return function (p, x) {
          var str = fix_int_precision(p, Curry._2(trans, iconv, x));
          return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                        acc,
                        str
                      ]), fmt);
        };
      }
      else {
        return function (x) {
          var str = Curry._2(trans, iconv, x);
          return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                        acc,
                        str
                      ]), fmt);
        };
      }
    }
    else {
      var p = prec[0];
      return function (x) {
        var str = fix_int_precision(p, Curry._2(trans, iconv, x));
        return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                      acc,
                      str
                    ]), fmt);
      };
    }
  }
  else if (pad.tag) {
    var padty = pad[0];
    if (typeof prec === "number") {
      if (prec !== 0) {
        return function (w, p, x) {
          var str = fix_padding(padty, w, fix_int_precision(p, Curry._2(trans, iconv, x)));
          return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                        acc,
                        str
                      ]), fmt);
        };
      }
      else {
        return function (w, x) {
          var str = fix_padding(padty, w, Curry._2(trans, iconv, x));
          return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                        acc,
                        str
                      ]), fmt);
        };
      }
    }
    else {
      var p$1 = prec[0];
      return function (w, x) {
        var str = fix_padding(padty, w, fix_int_precision(p$1, Curry._2(trans, iconv, x)));
        return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                      acc,
                      str
                    ]), fmt);
      };
    }
  }
  else {
    var w = pad[1];
    var padty$1 = pad[0];
    if (typeof prec === "number") {
      if (prec !== 0) {
        return function (p, x) {
          var str = fix_padding(padty$1, w, fix_int_precision(p, Curry._2(trans, iconv, x)));
          return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                        acc,
                        str
                      ]), fmt);
        };
      }
      else {
        return function (x) {
          var str = fix_padding(padty$1, w, Curry._2(trans, iconv, x));
          return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                        acc,
                        str
                      ]), fmt);
        };
      }
    }
    else {
      var p$2 = prec[0];
      return function (x) {
        var str = fix_padding(padty$1, w, fix_int_precision(p$2, Curry._2(trans, iconv, x)));
        return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                      acc,
                      str
                    ]), fmt);
      };
    }
  }
}

function make_custom(k, o, acc, rest, arity, f) {
  if (arity) {
    var arity$1 = arity[0];
    return function (x) {
      return make_custom(k, o, acc, rest, arity$1, Curry._1(f, x));
    };
  }
  else {
    return make_printf(k, o, /* Acc_data_string */Block.__(4, [
                  acc,
                  f
                ]), rest);
  }
}

function output_acc(o, _acc) {
  while(true) {
    var acc = _acc;
    var exit = 0;
    if (typeof acc === "number") {
      return /* () */0;
    }
    else {
      switch (acc.tag | 0) {
        case 0 : 
            var s = string_of_formatting_lit(acc[1]);
            output_acc(o, acc[0]);
            return Pervasives.output_string(o, s);
        case 1 : 
            var match = acc[1];
            var p = acc[0];
            output_acc(o, p);
            if (match.tag) {
              Pervasives.output_string(o, "@[");
              _acc = match[0];
              continue ;
              
            }
            else {
              Pervasives.output_string(o, "@{");
              _acc = match[0];
              continue ;
              
            }
            break;
        case 2 : 
        case 4 : 
            exit = 1;
            break;
        case 3 : 
        case 5 : 
            exit = 2;
            break;
        case 6 : 
            output_acc(o, acc[0]);
            return Curry._1(acc[1], o);
        case 7 : 
            output_acc(o, acc[0]);
            return Caml_io.caml_ml_flush(o);
        case 8 : 
            output_acc(o, acc[0]);
            throw [
                  Caml_builtin_exceptions.invalid_argument,
                  acc[1]
                ];
        
      }
    }
    switch (exit) {
      case 1 : 
          output_acc(o, acc[0]);
          return Pervasives.output_string(o, acc[1]);
      case 2 : 
          output_acc(o, acc[0]);
          return Caml_io.caml_ml_output_char(o, acc[1]);
      
    }
  };
}

function bufput_acc(b, _acc) {
  while(true) {
    var acc = _acc;
    var exit = 0;
    if (typeof acc === "number") {
      return /* () */0;
    }
    else {
      switch (acc.tag | 0) {
        case 0 : 
            var s = string_of_formatting_lit(acc[1]);
            bufput_acc(b, acc[0]);
            return Buffer.add_string(b, s);
        case 1 : 
            var match = acc[1];
            var p = acc[0];
            bufput_acc(b, p);
            if (match.tag) {
              Buffer.add_string(b, "@[");
              _acc = match[0];
              continue ;
              
            }
            else {
              Buffer.add_string(b, "@{");
              _acc = match[0];
              continue ;
              
            }
            break;
        case 2 : 
        case 4 : 
            exit = 1;
            break;
        case 3 : 
        case 5 : 
            exit = 2;
            break;
        case 6 : 
            bufput_acc(b, acc[0]);
            return Curry._1(acc[1], b);
        case 7 : 
            _acc = acc[0];
            continue ;
            case 8 : 
            bufput_acc(b, acc[0]);
            throw [
                  Caml_builtin_exceptions.invalid_argument,
                  acc[1]
                ];
        
      }
    }
    switch (exit) {
      case 1 : 
          bufput_acc(b, acc[0]);
          return Buffer.add_string(b, acc[1]);
      case 2 : 
          bufput_acc(b, acc[0]);
          return Buffer.add_char(b, acc[1]);
      
    }
  };
}

function strput_acc(b, _acc) {
  while(true) {
    var acc = _acc;
    var exit = 0;
    if (typeof acc === "number") {
      return /* () */0;
    }
    else {
      switch (acc.tag | 0) {
        case 0 : 
            var s = string_of_formatting_lit(acc[1]);
            strput_acc(b, acc[0]);
            return Buffer.add_string(b, s);
        case 1 : 
            var match = acc[1];
            var p = acc[0];
            strput_acc(b, p);
            if (match.tag) {
              Buffer.add_string(b, "@[");
              _acc = match[0];
              continue ;
              
            }
            else {
              Buffer.add_string(b, "@{");
              _acc = match[0];
              continue ;
              
            }
            break;
        case 2 : 
        case 4 : 
            exit = 1;
            break;
        case 3 : 
        case 5 : 
            exit = 2;
            break;
        case 6 : 
            strput_acc(b, acc[0]);
            return Buffer.add_string(b, Curry._1(acc[1], /* () */0));
        case 7 : 
            _acc = acc[0];
            continue ;
            case 8 : 
            strput_acc(b, acc[0]);
            throw [
                  Caml_builtin_exceptions.invalid_argument,
                  acc[1]
                ];
        
      }
    }
    switch (exit) {
      case 1 : 
          strput_acc(b, acc[0]);
          return Buffer.add_string(b, acc[1]);
      case 2 : 
          strput_acc(b, acc[0]);
          return Buffer.add_char(b, acc[1]);
      
    }
  };
}

function failwith_message(param) {
  var buf = Buffer.create(256);
  var k = function (_, acc) {
    strput_acc(buf, acc);
    var s = Buffer.contents(buf);
    throw [
          Caml_builtin_exceptions.failure,
          s
        ];
  };
  return make_printf(k, /* () */0, /* End_of_acc */0, param[0]);
}

function open_box_of_string(str) {
  if (str === "") {
    return /* tuple */[
            0,
            /* Pp_box */4
          ];
  }
  else {
    var len = str.length;
    var invalid_box = function () {
      return Curry._1(failwith_message(/* Format */[
                      /* String_literal */Block.__(11, [
                          "invalid box description ",
                          /* Caml_string */Block.__(3, [
                              /* No_padding */0,
                              /* End_of_format */0
                            ])
                        ]),
                      "invalid box description %S"
                    ]), str);
    };
    var parse_spaces = function (_i) {
      while(true) {
        var i = _i;
        if (i === len) {
          return i;
        }
        else {
          var match = Caml_string.get(str, i);
          if (match !== 9) {
            if (match !== 32) {
              return i;
            }
            else {
              _i = i + 1 | 0;
              continue ;
              
            }
          }
          else {
            _i = i + 1 | 0;
            continue ;
            
          }
        }
      };
    };
    var parse_lword = function (_, _j) {
      while(true) {
        var j = _j;
        if (j === len) {
          return j;
        }
        else {
          var match = Caml_string.get(str, j);
          if (match > 122 || match < 97) {
            return j;
          }
          else {
            _j = j + 1 | 0;
            continue ;
            
          }
        }
      };
    };
    var parse_int = function (_, _j) {
      while(true) {
        var j = _j;
        if (j === len) {
          return j;
        }
        else {
          var match = Caml_string.get(str, j);
          if (match >= 48) {
            if (match >= 58) {
              return j;
            }
            else {
              _j = j + 1 | 0;
              continue ;
              
            }
          }
          else if (match !== 45) {
            return j;
          }
          else {
            _j = j + 1 | 0;
            continue ;
            
          }
        }
      };
    };
    var wstart = parse_spaces(0);
    var wend = parse_lword(wstart, wstart);
    var box_name = $$String.sub(str, wstart, wend - wstart | 0);
    var nstart = parse_spaces(wend);
    var nend = parse_int(nstart, nstart);
    var indent;
    if (nstart === nend) {
      indent = 0;
    }
    else {
      try {
        indent = Caml_format.caml_int_of_string($$String.sub(str, nstart, nend - nstart | 0));
      }
      catch (exn){
        if (exn[0] === Caml_builtin_exceptions.failure) {
          indent = invalid_box(/* () */0);
        }
        else {
          throw exn;
        }
      }
    }
    var exp_end = parse_spaces(nend);
    if (exp_end !== len) {
      invalid_box(/* () */0);
    }
    var box_type;
    switch (box_name) {
      case "" : 
      case "b" : 
          box_type = /* Pp_box */4;
          break;
      case "h" : 
          box_type = /* Pp_hbox */0;
          break;
      case "hov" : 
          box_type = /* Pp_hovbox */3;
          break;
      case "hv" : 
          box_type = /* Pp_hvbox */2;
          break;
      case "v" : 
          box_type = /* Pp_vbox */1;
          break;
      default:
        box_type = invalid_box(/* () */0);
    }
    return /* tuple */[
            indent,
            box_type
          ];
  }
}

function make_padding_fmt_ebb(pad, fmt) {
  if (typeof pad === "number") {
    return /* Padding_fmt_EBB */[
            /* No_padding */0,
            fmt
          ];
  }
  else if (pad.tag) {
    return /* Padding_fmt_EBB */[
            /* Arg_padding */Block.__(1, [pad[0]]),
            fmt
          ];
  }
  else {
    return /* Padding_fmt_EBB */[
            /* Lit_padding */Block.__(0, [
                pad[0],
                pad[1]
              ]),
            fmt
          ];
  }
}

function make_precision_fmt_ebb(prec, fmt) {
  if (typeof prec === "number") {
    if (prec !== 0) {
      return /* Precision_fmt_EBB */[
              /* Arg_precision */1,
              fmt
            ];
    }
    else {
      return /* Precision_fmt_EBB */[
              /* No_precision */0,
              fmt
            ];
    }
  }
  else {
    return /* Precision_fmt_EBB */[
            /* Lit_precision */[prec[0]],
            fmt
          ];
  }
}

function make_padprec_fmt_ebb(pad, prec, fmt) {
  var match = make_precision_fmt_ebb(prec, fmt);
  var fmt$prime = match[1];
  var prec$1 = match[0];
  if (typeof pad === "number") {
    return /* Padprec_fmt_EBB */[
            /* No_padding */0,
            prec$1,
            fmt$prime
          ];
  }
  else if (pad.tag) {
    return /* Padprec_fmt_EBB */[
            /* Arg_padding */Block.__(1, [pad[0]]),
            prec$1,
            fmt$prime
          ];
  }
  else {
    return /* Padprec_fmt_EBB */[
            /* Lit_padding */Block.__(0, [
                pad[0],
                pad[1]
              ]),
            prec$1,
            fmt$prime
          ];
  }
}

function fmt_ebb_of_string(legacy_behavior, str) {
  var legacy_behavior$1 = legacy_behavior ? legacy_behavior[0] : /* true */1;
  var invalid_format_message = function (str_ind, msg) {
    return Curry._3(failwith_message(/* Format */[
                    /* String_literal */Block.__(11, [
                        "invalid format ",
                        /* Caml_string */Block.__(3, [
                            /* No_padding */0,
                            /* String_literal */Block.__(11, [
                                ": at character number ",
                                /* Int */Block.__(4, [
                                    /* Int_d */0,
                                    /* No_padding */0,
                                    /* No_precision */0,
                                    /* String_literal */Block.__(11, [
                                        ", ",
                                        /* String */Block.__(2, [
                                            /* No_padding */0,
                                            /* End_of_format */0
                                          ])
                                      ])
                                  ])
                              ])
                          ])
                      ]),
                    "invalid format %S: at character number %d, %s"
                  ]), str, str_ind, msg);
  };
  var invalid_format_without = function (str_ind, c, s) {
    return Curry._4(failwith_message(/* Format */[
                    /* String_literal */Block.__(11, [
                        "invalid format ",
                        /* Caml_string */Block.__(3, [
                            /* No_padding */0,
                            /* String_literal */Block.__(11, [
                                ": at character number ",
                                /* Int */Block.__(4, [
                                    /* Int_d */0,
                                    /* No_padding */0,
                                    /* No_precision */0,
                                    /* String_literal */Block.__(11, [
                                        ", '",
                                        /* Char */Block.__(0, [/* String_literal */Block.__(11, [
                                                "' without ",
                                                /* String */Block.__(2, [
                                                    /* No_padding */0,
                                                    /* End_of_format */0
                                                  ])
                                              ])])
                                      ])
                                  ])
                              ])
                          ])
                      ]),
                    "invalid format %S: at character number %d, '%c' without %s"
                  ]), str, str_ind, c, s);
  };
  var expected_character = function (str_ind, expected, read) {
    return Curry._4(failwith_message(/* Format */[
                    /* String_literal */Block.__(11, [
                        "invalid format ",
                        /* Caml_string */Block.__(3, [
                            /* No_padding */0,
                            /* String_literal */Block.__(11, [
                                ": at character number ",
                                /* Int */Block.__(4, [
                                    /* Int_d */0,
                                    /* No_padding */0,
                                    /* No_precision */0,
                                    /* String_literal */Block.__(11, [
                                        ", ",
                                        /* String */Block.__(2, [
                                            /* No_padding */0,
                                            /* String_literal */Block.__(11, [
                                                " expected, read ",
                                                /* Caml_char */Block.__(1, [/* End_of_format */0])
                                              ])
                                          ])
                                      ])
                                  ])
                              ])
                          ])
                      ]),
                    "invalid format %S: at character number %d, %s expected, read %C"
                  ]), str, str_ind, expected, read);
  };
  var compute_int_conv = function (pct_ind, str_ind, _plus, _sharp, _space, symb) {
    while(true) {
      var space = _space;
      var sharp = _sharp;
      var plus = _plus;
      var exit = 0;
      var exit$1 = 0;
      if (plus !== 0) {
        if (sharp !== 0) {
          exit$1 = 2;
        }
        else if (space !== 0) {
          exit = 1;
        }
        else if (symb !== 100) {
          if (symb !== 105) {
            exit = 1;
          }
          else {
            return /* Int_pi */4;
          }
        }
        else {
          return /* Int_pd */1;
        }
      }
      else if (sharp !== 0) {
        if (space !== 0) {
          exit$1 = 2;
        }
        else if (symb !== 88) {
          if (symb !== 111) {
            if (symb !== 120) {
              exit$1 = 2;
            }
            else {
              return /* Int_Cx */7;
            }
          }
          else {
            return /* Int_Co */11;
          }
        }
        else {
          return /* Int_CX */9;
        }
      }
      else if (space !== 0) {
        if (symb !== 100) {
          if (symb !== 105) {
            exit = 1;
          }
          else {
            return /* Int_si */5;
          }
        }
        else {
          return /* Int_sd */2;
        }
      }
      else {
        var switcher = symb - 88 | 0;
        if (switcher > 32 || switcher < 0) {
          exit = 1;
        }
        else {
          switch (switcher) {
            case 0 : 
                return /* Int_X */8;
            case 12 : 
                return /* Int_d */0;
            case 17 : 
                return /* Int_i */3;
            case 23 : 
                return /* Int_o */10;
            case 29 : 
                return /* Int_u */12;
            case 1 : 
            case 2 : 
            case 3 : 
            case 4 : 
            case 5 : 
            case 6 : 
            case 7 : 
            case 8 : 
            case 9 : 
            case 10 : 
            case 11 : 
            case 13 : 
            case 14 : 
            case 15 : 
            case 16 : 
            case 18 : 
            case 19 : 
            case 20 : 
            case 21 : 
            case 22 : 
            case 24 : 
            case 25 : 
            case 26 : 
            case 27 : 
            case 28 : 
            case 30 : 
            case 31 : 
                exit = 1;
                break;
            case 32 : 
                return /* Int_x */6;
            
          }
        }
      }
      if (exit$1 === 2) {
        var exit$2 = 0;
        var switcher$1 = symb - 88 | 0;
        if (switcher$1 > 32 || switcher$1 < 0) {
          exit = 1;
        }
        else {
          switch (switcher$1) {
            case 0 : 
                if (legacy_behavior$1) {
                  return /* Int_CX */9;
                }
                else {
                  exit = 1;
                }
                break;
            case 23 : 
                if (legacy_behavior$1) {
                  return /* Int_Co */11;
                }
                else {
                  exit = 1;
                }
                break;
            case 12 : 
            case 17 : 
            case 29 : 
                exit$2 = 3;
                break;
            case 1 : 
            case 2 : 
            case 3 : 
            case 4 : 
            case 5 : 
            case 6 : 
            case 7 : 
            case 8 : 
            case 9 : 
            case 10 : 
            case 11 : 
            case 13 : 
            case 14 : 
            case 15 : 
            case 16 : 
            case 18 : 
            case 19 : 
            case 20 : 
            case 21 : 
            case 22 : 
            case 24 : 
            case 25 : 
            case 26 : 
            case 27 : 
            case 28 : 
            case 30 : 
            case 31 : 
                exit = 1;
                break;
            case 32 : 
                if (legacy_behavior$1) {
                  return /* Int_Cx */7;
                }
                else {
                  exit = 1;
                }
                break;
            
          }
        }
        if (exit$2 === 3) {
          if (legacy_behavior$1) {
            _sharp = /* false */0;
            continue ;
            
          }
          else {
            return incompatible_flag(pct_ind, str_ind, symb, "'#'");
          }
        }
        
      }
      if (exit === 1) {
        if (plus !== 0) {
          if (space !== 0) {
            if (legacy_behavior$1) {
              _space = /* false */0;
              continue ;
              
            }
            else {
              return incompatible_flag(pct_ind, str_ind, /* " " */32, "'+'");
            }
          }
          else if (legacy_behavior$1) {
            _plus = /* false */0;
            continue ;
            
          }
          else {
            return incompatible_flag(pct_ind, str_ind, symb, "'+'");
          }
        }
        else if (space !== 0) {
          if (legacy_behavior$1) {
            _space = /* false */0;
            continue ;
            
          }
          else {
            return incompatible_flag(pct_ind, str_ind, symb, "' '");
          }
        }
        else {
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "camlinternalFormat.ml",
                  2716,
                  28
                ]
              ];
        }
      }
      
    };
  };
  var incompatible_flag = function (pct_ind, str_ind, symb, option) {
    var subfmt = $$String.sub(str, pct_ind, str_ind - pct_ind | 0);
    return Curry._5(failwith_message(/* Format */[
                    /* String_literal */Block.__(11, [
                        "invalid format ",
                        /* Caml_string */Block.__(3, [
                            /* No_padding */0,
                            /* String_literal */Block.__(11, [
                                ": at character number ",
                                /* Int */Block.__(4, [
                                    /* Int_d */0,
                                    /* No_padding */0,
                                    /* No_precision */0,
                                    /* String_literal */Block.__(11, [
                                        ", ",
                                        /* String */Block.__(2, [
                                            /* No_padding */0,
                                            /* String_literal */Block.__(11, [
                                                " is incompatible with '",
                                                /* Char */Block.__(0, [/* String_literal */Block.__(11, [
                                                        "' in sub-format ",
                                                        /* Caml_string */Block.__(3, [
                                                            /* No_padding */0,
                                                            /* End_of_format */0
                                                          ])
                                                      ])])
                                              ])
                                          ])
                                      ])
                                  ])
                              ])
                          ])
                      ]),
                    "invalid format %S: at character number %d, %s is incompatible with '%c' in sub-format %S"
                  ]), str, pct_ind, option, symb, subfmt);
  };
  var parse_positive = function (_str_ind, end_ind, _acc) {
    while(true) {
      var acc = _acc;
      var str_ind = _str_ind;
      if (str_ind === end_ind) {
        invalid_format_message(end_ind, "unexpected end of format");
      }
      var c = Caml_string.get(str, str_ind);
      if (c > 57 || c < 48) {
        return /* tuple */[
                str_ind,
                acc
              ];
      }
      else {
        var new_acc = Caml_int32.imul(acc, 10) + (c - /* "0" */48 | 0) | 0;
        if (new_acc > Sys.max_string_length) {
          return Curry._3(failwith_message(/* Format */[
                          /* String_literal */Block.__(11, [
                              "invalid format ",
                              /* Caml_string */Block.__(3, [
                                  /* No_padding */0,
                                  /* String_literal */Block.__(11, [
                                      ": integer ",
                                      /* Int */Block.__(4, [
                                          /* Int_d */0,
                                          /* No_padding */0,
                                          /* No_precision */0,
                                          /* String_literal */Block.__(11, [
                                              " is greater than the limit ",
                                              /* Int */Block.__(4, [
                                                  /* Int_d */0,
                                                  /* No_padding */0,
                                                  /* No_precision */0,
                                                  /* End_of_format */0
                                                ])
                                            ])
                                        ])
                                    ])
                                ])
                            ]),
                          "invalid format %S: integer %d is greater than the limit %d"
                        ]), str, new_acc, Sys.max_string_length);
        }
        else {
          _acc = new_acc;
          _str_ind = str_ind + 1 | 0;
          continue ;
          
        }
      }
    };
  };
  var parse_after_precision = function (pct_ind, str_ind, end_ind, minus, plus, sharp, space, ign, pad, prec) {
    if (str_ind === end_ind) {
      invalid_format_message(end_ind, "unexpected end of format");
    }
    var parse_conv = function (padprec) {
      return parse_conversion(pct_ind, str_ind + 1 | 0, end_ind, plus, sharp, space, ign, pad, prec, padprec, Caml_string.get(str, str_ind));
    };
    if (typeof pad === "number") {
      var exit = 0;
      if (typeof prec === "number") {
        if (prec !== 0) {
          exit = 1;
        }
        else {
          return parse_conv(/* No_padding */0);
        }
      }
      else {
        exit = 1;
      }
      if (exit === 1) {
        if (minus !== 0) {
          if (typeof prec === "number") {
            return parse_conv(/* Arg_padding */Block.__(1, [/* Left */0]));
          }
          else {
            return parse_conv(/* Lit_padding */Block.__(0, [
                          /* Left */0,
                          prec[0]
                        ]));
          }
        }
        else if (typeof prec === "number") {
          return parse_conv(/* Arg_padding */Block.__(1, [/* Right */1]));
        }
        else {
          return parse_conv(/* Lit_padding */Block.__(0, [
                        /* Right */1,
                        prec[0]
                      ]));
        }
      }
      
    }
    else {
      return parse_conv(pad);
    }
  };
  var parse_after_padding = function (pct_ind, str_ind, end_ind, minus, plus, sharp, space, ign, pad) {
    if (str_ind === end_ind) {
      invalid_format_message(end_ind, "unexpected end of format");
    }
    var symb = Caml_string.get(str, str_ind);
    if (symb !== 46) {
      return parse_conversion(pct_ind, str_ind + 1 | 0, end_ind, plus, sharp, space, ign, pad, /* No_precision */0, pad, symb);
    }
    else {
      var pct_ind$1 = pct_ind;
      var str_ind$1 = str_ind + 1 | 0;
      var end_ind$1 = end_ind;
      var minus$1 = minus;
      var plus$1 = plus;
      var sharp$1 = sharp;
      var space$1 = space;
      var ign$1 = ign;
      var pad$1 = pad;
      if (str_ind$1 === end_ind$1) {
        invalid_format_message(end_ind$1, "unexpected end of format");
      }
      var parse_literal = function (minus, str_ind) {
        var match = parse_positive(str_ind, end_ind$1, 0);
        return parse_after_precision(pct_ind$1, match[0], end_ind$1, minus, plus$1, sharp$1, space$1, ign$1, pad$1, /* Lit_precision */[match[1]]);
      };
      var symb$1 = Caml_string.get(str, str_ind$1);
      var exit = 0;
      var exit$1 = 0;
      if (symb$1 >= 48) {
        if (symb$1 >= 58) {
          exit = 1;
        }
        else {
          return parse_literal(minus$1, str_ind$1);
        }
      }
      else if (symb$1 >= 42) {
        switch (symb$1 - 42 | 0) {
          case 0 : 
              return parse_after_precision(pct_ind$1, str_ind$1 + 1 | 0, end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, pad$1, /* Arg_precision */1);
          case 1 : 
          case 3 : 
              exit$1 = 2;
              break;
          case 2 : 
          case 4 : 
          case 5 : 
              exit = 1;
              break;
          
        }
      }
      else {
        exit = 1;
      }
      if (exit$1 === 2) {
        if (legacy_behavior$1) {
          return parse_literal(minus$1 || +(symb$1 === /* "-" */45), str_ind$1 + 1 | 0);
        }
        else {
          exit = 1;
        }
      }
      if (exit === 1) {
        if (legacy_behavior$1) {
          return parse_after_precision(pct_ind$1, str_ind$1, end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, pad$1, /* Lit_precision */[0]);
        }
        else {
          return invalid_format_without(str_ind$1 - 1 | 0, /* "." */46, "precision");
        }
      }
      
    }
  };
  var parse_literal = function (lit_start, _str_ind, end_ind) {
    while(true) {
      var str_ind = _str_ind;
      if (str_ind === end_ind) {
        return add_literal(lit_start, str_ind, /* End_of_format */0);
      }
      else {
        var match = Caml_string.get(str, str_ind);
        if (match !== 37) {
          if (match !== 64) {
            _str_ind = str_ind + 1 | 0;
            continue ;
            
          }
          else {
            var match$1 = parse_after_at(str_ind + 1 | 0, end_ind);
            return add_literal(lit_start, str_ind, match$1[0]);
          }
        }
        else {
          var match$2 = parse_format(str_ind, end_ind);
          return add_literal(lit_start, str_ind, match$2[0]);
        }
      }
    };
  };
  var parse_format = function (pct_ind, end_ind) {
    var pct_ind$1 = pct_ind;
    var str_ind = pct_ind + 1 | 0;
    var end_ind$1 = end_ind;
    if (str_ind === end_ind$1) {
      invalid_format_message(end_ind$1, "unexpected end of format");
    }
    var match = Caml_string.get(str, str_ind);
    if (match !== 95) {
      return parse_flags(pct_ind$1, str_ind, end_ind$1, /* false */0);
    }
    else {
      return parse_flags(pct_ind$1, str_ind + 1 | 0, end_ind$1, /* true */1);
    }
  };
  var parse_after_at = function (str_ind, end_ind) {
    if (str_ind === end_ind) {
      return /* Fmt_EBB */[/* Char_literal */Block.__(12, [
                  /* "@" */64,
                  /* End_of_format */0
                ])];
    }
    else {
      var c = Caml_string.get(str, str_ind);
      var exit = 0;
      if (c >= 65) {
        if (c >= 94) {
          var switcher = c - 123 | 0;
          if (switcher > 2 || switcher < 0) {
            exit = 1;
          }
          else {
            switch (switcher) {
              case 0 : 
                  return parse_tag(/* true */1, str_ind + 1 | 0, end_ind);
              case 1 : 
                  exit = 1;
                  break;
              case 2 : 
                  var beg_ind = str_ind + 1 | 0;
                  var match = parse_literal(beg_ind, beg_ind, end_ind);
                  return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                              /* Close_tag */1,
                              match[0]
                            ])];
              
            }
          }
        }
        else if (c >= 91) {
          switch (c - 91 | 0) {
            case 0 : 
                return parse_tag(/* false */0, str_ind + 1 | 0, end_ind);
            case 1 : 
                exit = 1;
                break;
            case 2 : 
                var beg_ind$1 = str_ind + 1 | 0;
                var match$1 = parse_literal(beg_ind$1, beg_ind$1, end_ind);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            /* Close_box */0,
                            match$1[0]
                          ])];
            
          }
        }
        else {
          exit = 1;
        }
      }
      else if (c !== 10) {
        if (c >= 32) {
          switch (c - 32 | 0) {
            case 0 : 
                var beg_ind$2 = str_ind + 1 | 0;
                var match$2 = parse_literal(beg_ind$2, beg_ind$2, end_ind);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            /* Break */Block.__(0, [
                                "@ ",
                                1,
                                0
                              ]),
                            match$2[0]
                          ])];
            case 5 : 
                if ((str_ind + 1 | 0) < end_ind && Caml_string.get(str, str_ind + 1 | 0) === /* "%" */37) {
                  var beg_ind$3 = str_ind + 2 | 0;
                  var match$3 = parse_literal(beg_ind$3, beg_ind$3, end_ind);
                  return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                              /* Escaped_percent */6,
                              match$3[0]
                            ])];
                }
                else {
                  var match$4 = parse_literal(str_ind, str_ind, end_ind);
                  return /* Fmt_EBB */[/* Char_literal */Block.__(12, [
                              /* "@" */64,
                              match$4[0]
                            ])];
                }
                break;
            case 12 : 
                var beg_ind$4 = str_ind + 1 | 0;
                var match$5 = parse_literal(beg_ind$4, beg_ind$4, end_ind);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            /* Break */Block.__(0, [
                                "@,",
                                0,
                                0
                              ]),
                            match$5[0]
                          ])];
            case 14 : 
                var beg_ind$5 = str_ind + 1 | 0;
                var match$6 = parse_literal(beg_ind$5, beg_ind$5, end_ind);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            /* Flush_newline */4,
                            match$6[0]
                          ])];
            case 27 : 
                var str_ind$1 = str_ind + 1 | 0;
                var end_ind$1 = end_ind;
                var match$7;
                try {
                  if (str_ind$1 === end_ind$1 || Caml_string.get(str, str_ind$1) !== /* "<" */60) {
                    throw Caml_builtin_exceptions.not_found;
                  }
                  var str_ind_1 = parse_spaces(str_ind$1 + 1 | 0, end_ind$1);
                  var match$8 = Caml_string.get(str, str_ind_1);
                  var exit$1 = 0;
                  if (match$8 >= 48) {
                    if (match$8 >= 58) {
                      throw Caml_builtin_exceptions.not_found;
                    }
                    else {
                      exit$1 = 1;
                    }
                  }
                  else if (match$8 !== 45) {
                    throw Caml_builtin_exceptions.not_found;
                  }
                  else {
                    exit$1 = 1;
                  }
                  if (exit$1 === 1) {
                    var match$9 = parse_integer(str_ind_1, end_ind$1);
                    var width = match$9[1];
                    var str_ind_3 = parse_spaces(match$9[0], end_ind$1);
                    var match$10 = Caml_string.get(str, str_ind_3);
                    var switcher$1 = match$10 - 45 | 0;
                    if (switcher$1 > 12 || switcher$1 < 0) {
                      if (switcher$1 !== 17) {
                        throw Caml_builtin_exceptions.not_found;
                      }
                      else {
                        var s = $$String.sub(str, str_ind$1 - 2 | 0, (str_ind_3 - str_ind$1 | 0) + 3 | 0);
                        match$7 = /* tuple */[
                          str_ind_3 + 1 | 0,
                          /* Break */Block.__(0, [
                              s,
                              width,
                              0
                            ])
                        ];
                      }
                    }
                    else if (switcher$1 === 2 || switcher$1 === 1) {
                      throw Caml_builtin_exceptions.not_found;
                    }
                    else {
                      var match$11 = parse_integer(str_ind_3, end_ind$1);
                      var str_ind_5 = parse_spaces(match$11[0], end_ind$1);
                      if (Caml_string.get(str, str_ind_5) !== /* ">" */62) {
                        throw Caml_builtin_exceptions.not_found;
                      }
                      var s$1 = $$String.sub(str, str_ind$1 - 2 | 0, (str_ind_5 - str_ind$1 | 0) + 3 | 0);
                      match$7 = /* tuple */[
                        str_ind_5 + 1 | 0,
                        /* Break */Block.__(0, [
                            s$1,
                            width,
                            match$11[1]
                          ])
                      ];
                    }
                  }
                  
                }
                catch (exn){
                  if (exn === Caml_builtin_exceptions.not_found) {
                    match$7 = /* tuple */[
                      str_ind$1,
                      /* Break */Block.__(0, [
                          "@;",
                          1,
                          0
                        ])
                    ];
                  }
                  else if (exn[0] === Caml_builtin_exceptions.failure) {
                    match$7 = /* tuple */[
                      str_ind$1,
                      /* Break */Block.__(0, [
                          "@;",
                          1,
                          0
                        ])
                    ];
                  }
                  else {
                    throw exn;
                  }
                }
                var next_ind = match$7[0];
                var match$12 = parse_literal(next_ind, next_ind, end_ind$1);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            match$7[1],
                            match$12[0]
                          ])];
            case 28 : 
                var str_ind$2 = str_ind + 1 | 0;
                var end_ind$2 = end_ind;
                var match$13;
                try {
                  var str_ind_1$1 = parse_spaces(str_ind$2, end_ind$2);
                  var match$14 = Caml_string.get(str, str_ind_1$1);
                  var exit$2 = 0;
                  if (match$14 >= 48) {
                    if (match$14 >= 58) {
                      match$13 = /* None */0;
                    }
                    else {
                      exit$2 = 1;
                    }
                  }
                  else if (match$14 !== 45) {
                    match$13 = /* None */0;
                  }
                  else {
                    exit$2 = 1;
                  }
                  if (exit$2 === 1) {
                    var match$15 = parse_integer(str_ind_1$1, end_ind$2);
                    var str_ind_3$1 = parse_spaces(match$15[0], end_ind$2);
                    if (Caml_string.get(str, str_ind_3$1) !== /* ">" */62) {
                      throw Caml_builtin_exceptions.not_found;
                    }
                    var s$2 = $$String.sub(str, str_ind$2 - 2 | 0, (str_ind_3$1 - str_ind$2 | 0) + 3 | 0);
                    match$13 = /* Some */[/* tuple */[
                        str_ind_3$1 + 1 | 0,
                        /* Magic_size */Block.__(1, [
                            s$2,
                            match$15[1]
                          ])
                      ]];
                  }
                  
                }
                catch (exn$1){
                  if (exn$1 === Caml_builtin_exceptions.not_found) {
                    match$13 = /* None */0;
                  }
                  else if (exn$1[0] === Caml_builtin_exceptions.failure) {
                    match$13 = /* None */0;
                  }
                  else {
                    throw exn$1;
                  }
                }
                if (match$13) {
                  var match$16 = match$13[0];
                  var next_ind$1 = match$16[0];
                  var match$17 = parse_literal(next_ind$1, next_ind$1, end_ind$2);
                  return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                              match$16[1],
                              match$17[0]
                            ])];
                }
                else {
                  var match$18 = parse_literal(str_ind$2, str_ind$2, end_ind$2);
                  return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                              /* Scan_indic */Block.__(2, [/* "<" */60]),
                              match$18[0]
                            ])];
                }
            case 1 : 
            case 2 : 
            case 3 : 
            case 4 : 
            case 6 : 
            case 7 : 
            case 8 : 
            case 9 : 
            case 10 : 
            case 11 : 
            case 13 : 
            case 15 : 
            case 16 : 
            case 17 : 
            case 18 : 
            case 19 : 
            case 20 : 
            case 21 : 
            case 22 : 
            case 23 : 
            case 24 : 
            case 25 : 
            case 26 : 
            case 29 : 
            case 30 : 
                exit = 1;
                break;
            case 31 : 
                var beg_ind$6 = str_ind + 1 | 0;
                var match$19 = parse_literal(beg_ind$6, beg_ind$6, end_ind);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            /* FFlush */2,
                            match$19[0]
                          ])];
            case 32 : 
                var beg_ind$7 = str_ind + 1 | 0;
                var match$20 = parse_literal(beg_ind$7, beg_ind$7, end_ind);
                return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                            /* Escaped_at */5,
                            match$20[0]
                          ])];
            
          }
        }
        else {
          exit = 1;
        }
      }
      else {
        var beg_ind$8 = str_ind + 1 | 0;
        var match$21 = parse_literal(beg_ind$8, beg_ind$8, end_ind);
        return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                    /* Force_newline */3,
                    match$21[0]
                  ])];
      }
      if (exit === 1) {
        var beg_ind$9 = str_ind + 1 | 0;
        var match$22 = parse_literal(beg_ind$9, beg_ind$9, end_ind);
        return /* Fmt_EBB */[/* Formatting_lit */Block.__(17, [
                    /* Scan_indic */Block.__(2, [c]),
                    match$22[0]
                  ])];
      }
      
    }
  };
  var add_literal = function (lit_start, str_ind, fmt) {
    var size = str_ind - lit_start | 0;
    if (size !== 0) {
      if (size !== 1) {
        return /* Fmt_EBB */[/* String_literal */Block.__(11, [
                    $$String.sub(str, lit_start, size),
                    fmt
                  ])];
      }
      else {
        return /* Fmt_EBB */[/* Char_literal */Block.__(12, [
                    Caml_string.get(str, lit_start),
                    fmt
                  ])];
      }
    }
    else {
      return /* Fmt_EBB */[fmt];
    }
  };
  var parse_spaces = function (_str_ind, end_ind) {
    while(true) {
      var str_ind = _str_ind;
      if (str_ind === end_ind) {
        invalid_format_message(end_ind, "unexpected end of format");
      }
      if (Caml_string.get(str, str_ind) === /* " " */32) {
        _str_ind = str_ind + 1 | 0;
        continue ;
        
      }
      else {
        return str_ind;
      }
    };
  };
  var parse_integer = function (str_ind, end_ind) {
    if (str_ind === end_ind) {
      invalid_format_message(end_ind, "unexpected end of format");
    }
    var match = Caml_string.get(str, str_ind);
    if (match >= 48) {
      if (match >= 58) {
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                2621,
                11
              ]
            ];
      }
      else {
        return parse_positive(str_ind, end_ind, 0);
      }
    }
    else if (match !== 45) {
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "camlinternalFormat.ml",
              2621,
              11
            ]
          ];
    }
    else {
      if ((str_ind + 1 | 0) === end_ind) {
        invalid_format_message(end_ind, "unexpected end of format");
      }
      var c = Caml_string.get(str, str_ind + 1 | 0);
      if (c > 57 || c < 48) {
        return expected_character(str_ind + 1 | 0, "digit", c);
      }
      else {
        var match$1 = parse_positive(str_ind + 1 | 0, end_ind, 0);
        return /* tuple */[
                match$1[0],
                -match$1[1] | 0
              ];
      }
    }
  };
  var compute_float_conv = function (pct_ind, str_ind, _plus, _space, symb) {
    while(true) {
      var space = _space;
      var plus = _plus;
      if (plus !== 0) {
        if (space !== 0) {
          if (legacy_behavior$1) {
            _space = /* false */0;
            continue ;
            
          }
          else {
            return incompatible_flag(pct_ind, str_ind, /* " " */32, "'+'");
          }
        }
        else {
          var exit = 0;
          if (symb >= 72) {
            var switcher = symb - 101 | 0;
            if (switcher > 2 || switcher < 0) {
              exit = 1;
            }
            else {
              switch (switcher) {
                case 0 : 
                    return /* Float_pe */4;
                case 1 : 
                    return /* Float_pf */1;
                case 2 : 
                    return /* Float_pg */10;
                
              }
            }
          }
          else if (symb >= 69) {
            switch (symb - 69 | 0) {
              case 0 : 
                  return /* Float_pE */7;
              case 1 : 
                  exit = 1;
                  break;
              case 2 : 
                  return /* Float_pG */13;
              
            }
          }
          else {
            exit = 1;
          }
          if (exit === 1) {
            if (legacy_behavior$1) {
              _plus = /* false */0;
              continue ;
              
            }
            else {
              return incompatible_flag(pct_ind, str_ind, symb, "'+'");
            }
          }
          
        }
      }
      else if (space !== 0) {
        var exit$1 = 0;
        if (symb >= 72) {
          var switcher$1 = symb - 101 | 0;
          if (switcher$1 > 2 || switcher$1 < 0) {
            exit$1 = 1;
          }
          else {
            switch (switcher$1) {
              case 0 : 
                  return /* Float_se */5;
              case 1 : 
                  return /* Float_sf */2;
              case 2 : 
                  return /* Float_sg */11;
              
            }
          }
        }
        else if (symb >= 69) {
          switch (symb - 69 | 0) {
            case 0 : 
                return /* Float_sE */8;
            case 1 : 
                exit$1 = 1;
                break;
            case 2 : 
                return /* Float_sG */14;
            
          }
        }
        else {
          exit$1 = 1;
        }
        if (exit$1 === 1) {
          if (legacy_behavior$1) {
            _space = /* false */0;
            continue ;
            
          }
          else {
            return incompatible_flag(pct_ind, str_ind, symb, "' '");
          }
        }
        
      }
      else if (symb >= 72) {
        var switcher$2 = symb - 101 | 0;
        if (switcher$2 > 2 || switcher$2 < 0) {
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "camlinternalFormat.ml",
                  2744,
                  25
                ]
              ];
        }
        else {
          switch (switcher$2) {
            case 0 : 
                return /* Float_e */3;
            case 1 : 
                return /* Float_f */0;
            case 2 : 
                return /* Float_g */9;
            
          }
        }
      }
      else if (symb >= 69) {
        switch (symb - 69 | 0) {
          case 0 : 
              return /* Float_E */6;
          case 1 : 
              return /* Float_F */15;
          case 2 : 
              return /* Float_G */12;
          
        }
      }
      else {
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "camlinternalFormat.ml",
                2744,
                25
              ]
            ];
      }
    };
  };
  var search_subformat_end = function (_str_ind, end_ind, c) {
    while(true) {
      var str_ind = _str_ind;
      if (str_ind === end_ind) {
        Curry._3(failwith_message(/* Format */[
                  /* String_literal */Block.__(11, [
                      "invalid format ",
                      /* Caml_string */Block.__(3, [
                          /* No_padding */0,
                          /* String_literal */Block.__(11, [
                              ': unclosed sub-format, expected "',
                              /* Char_literal */Block.__(12, [
                                  /* "%" */37,
                                  /* Char */Block.__(0, [/* String_literal */Block.__(11, [
                                          '" at character number ',
                                          /* Int */Block.__(4, [
                                              /* Int_d */0,
                                              /* No_padding */0,
                                              /* No_precision */0,
                                              /* End_of_format */0
                                            ])
                                        ])])
                                ])
                            ])
                        ])
                    ]),
                  'invalid format %S: unclosed sub-format, expected "%%%c" at character number %d'
                ]), str, c, end_ind);
      }
      var match = Caml_string.get(str, str_ind);
      if (match !== 37) {
        _str_ind = str_ind + 1 | 0;
        continue ;
        
      }
      else {
        if ((str_ind + 1 | 0) === end_ind) {
          invalid_format_message(end_ind, "unexpected end of format");
        }
        if (Caml_string.get(str, str_ind + 1 | 0) === c) {
          return str_ind;
        }
        else {
          var match$1 = Caml_string.get(str, str_ind + 1 | 0);
          var exit = 0;
          if (match$1 >= 95) {
            if (match$1 >= 123) {
              if (match$1 >= 126) {
                exit = 1;
              }
              else {
                switch (match$1 - 123 | 0) {
                  case 0 : 
                      var sub_end = search_subformat_end(str_ind + 2 | 0, end_ind, /* "}" */125);
                      _str_ind = sub_end + 2 | 0;
                      continue ;
                      case 1 : 
                      exit = 1;
                      break;
                  case 2 : 
                      return expected_character(str_ind + 1 | 0, "character ')'", /* "}" */125);
                  
                }
              }
            }
            else if (match$1 >= 96) {
              exit = 1;
            }
            else {
              if ((str_ind + 2 | 0) === end_ind) {
                invalid_format_message(end_ind, "unexpected end of format");
              }
              var match$2 = Caml_string.get(str, str_ind + 2 | 0);
              if (match$2 !== 40) {
                if (match$2 !== 123) {
                  _str_ind = str_ind + 3 | 0;
                  continue ;
                  
                }
                else {
                  var sub_end$1 = search_subformat_end(str_ind + 3 | 0, end_ind, /* "}" */125);
                  _str_ind = sub_end$1 + 2 | 0;
                  continue ;
                  
                }
              }
              else {
                var sub_end$2 = search_subformat_end(str_ind + 3 | 0, end_ind, /* ")" */41);
                _str_ind = sub_end$2 + 2 | 0;
                continue ;
                
              }
            }
          }
          else if (match$1 !== 40) {
            if (match$1 !== 41) {
              exit = 1;
            }
            else {
              return expected_character(str_ind + 1 | 0, "character '}'", /* ")" */41);
            }
          }
          else {
            var sub_end$3 = search_subformat_end(str_ind + 2 | 0, end_ind, /* ")" */41);
            _str_ind = sub_end$3 + 2 | 0;
            continue ;
            
          }
          if (exit === 1) {
            _str_ind = str_ind + 2 | 0;
            continue ;
            
          }
          
        }
      }
    };
  };
  var parse_conversion = function (pct_ind, str_ind, end_ind, plus, sharp, space, ign, pad, prec, padprec, symb) {
    var plus_used = /* false */0;
    var sharp_used = /* false */0;
    var space_used = /* false */0;
    var ign_used = [/* false */0];
    var pad_used = /* false */0;
    var prec_used = [/* false */0];
    var check_no_0 = function (symb, pad) {
      if (typeof pad === "number") {
        return pad;
      }
      else if (pad.tag) {
        if (pad[0] >= 2) {
          if (legacy_behavior$1) {
            return /* Arg_padding */Block.__(1, [/* Right */1]);
          }
          else {
            return incompatible_flag(pct_ind, str_ind, symb, "0");
          }
        }
        else {
          return pad;
        }
      }
      else if (pad[0] >= 2) {
        if (legacy_behavior$1) {
          return /* Lit_padding */Block.__(0, [
                    /* Right */1,
                    pad[1]
                  ]);
        }
        else {
          return incompatible_flag(pct_ind, str_ind, symb, "0");
        }
      }
      else {
        return pad;
      }
    };
    var opt_of_pad = function (c, pad) {
      if (typeof pad === "number") {
        return /* None */0;
      }
      else if (pad.tag) {
        return incompatible_flag(pct_ind, str_ind, c, "'*'");
      }
      else {
        switch (pad[0]) {
          case 0 : 
              if (legacy_behavior$1) {
                return /* Some */[pad[1]];
              }
              else {
                return incompatible_flag(pct_ind, str_ind, c, "'-'");
              }
          case 1 : 
              return /* Some */[pad[1]];
          case 2 : 
              if (legacy_behavior$1) {
                return /* Some */[pad[1]];
              }
              else {
                return incompatible_flag(pct_ind, str_ind, c, "'0'");
              }
          
        }
      }
    };
    var get_prec_opt = function () {
      prec_used[0] = /* true */1;
      if (typeof prec === "number") {
        if (prec !== 0) {
          return incompatible_flag(pct_ind, str_ind, /* "_" */95, "'*'");
        }
        else {
          return /* None */0;
        }
      }
      else {
        return /* Some */[prec[0]];
      }
    };
    var fmt_result;
    var exit = 0;
    var exit$1 = 0;
    var exit$2 = 0;
    if (symb >= 124) {
      exit$1 = 6;
    }
    else {
      switch (symb) {
        case 33 : 
            var match = parse_literal(str_ind, str_ind, end_ind);
            fmt_result = /* Fmt_EBB */[/* Flush */Block.__(10, [match[0]])];
            break;
        case 40 : 
            var sub_end = search_subformat_end(str_ind, end_ind, /* ")" */41);
            var beg_ind = sub_end + 2 | 0;
            var match$1 = parse_literal(beg_ind, beg_ind, end_ind);
            var fmt_rest = match$1[0];
            var match$2 = parse_literal(str_ind, str_ind, sub_end);
            var sub_fmtty = fmtty_of_fmt(match$2[0]);
            if (ign_used[0] = /* true */1, ign) {
              pad_used = /* true */1;
              var ignored_000 = opt_of_pad(/* "_" */95, pad);
              var ignored = /* Ignored_format_subst */Block.__(8, [
                  ignored_000,
                  sub_fmtty
                ]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored,
                    fmt_rest
                  ])];
            }
            else {
              pad_used = /* true */1;
              fmt_result = /* Fmt_EBB */[/* Format_subst */Block.__(14, [
                    opt_of_pad(/* "(" */40, pad),
                    sub_fmtty,
                    fmt_rest
                  ])];
            }
            break;
        case 44 : 
            fmt_result = parse_literal(str_ind, str_ind, end_ind);
            break;
        case 37 : 
        case 64 : 
            exit$1 = 4;
            break;
        case 67 : 
            var match$3 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$1 = match$3[0];
            fmt_result = (ign_used[0] = /* true */1, ign) ? /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    /* Ignored_caml_char */1,
                    fmt_rest$1
                  ])] : /* Fmt_EBB */[/* Caml_char */Block.__(1, [fmt_rest$1])];
            break;
        case 78 : 
            var match$4 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$2 = match$4[0];
            if (ign_used[0] = /* true */1, ign) {
              var ignored$1 = /* Ignored_scan_get_counter */Block.__(10, [/* Token_counter */2]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$1,
                    fmt_rest$2
                  ])];
            }
            else {
              fmt_result = /* Fmt_EBB */[/* Scan_get_counter */Block.__(21, [
                    /* Token_counter */2,
                    fmt_rest$2
                  ])];
            }
            break;
        case 83 : 
            pad_used = /* true */1;
            var pad$1 = check_no_0(symb, padprec);
            var match$5 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$3 = match$5[0];
            if (ign_used[0] = /* true */1, ign) {
              pad_used = /* true */1;
              var ignored$2 = /* Ignored_caml_string */Block.__(1, [opt_of_pad(/* "_" */95, padprec)]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$2,
                    fmt_rest$3
                  ])];
            }
            else {
              var match$6 = make_padding_fmt_ebb(pad$1, fmt_rest$3);
              fmt_result = /* Fmt_EBB */[/* Caml_string */Block.__(3, [
                    match$6[0],
                    match$6[1]
                  ])];
            }
            break;
        case 91 : 
            var match$7 = parse_char_set(str_ind, end_ind);
            var char_set = match$7[1];
            var next_ind = match$7[0];
            var match$8 = parse_literal(next_ind, next_ind, end_ind);
            var fmt_rest$4 = match$8[0];
            if (ign_used[0] = /* true */1, ign) {
              pad_used = /* true */1;
              var ignored_000$1 = opt_of_pad(/* "_" */95, pad);
              var ignored$3 = /* Ignored_scan_char_set */Block.__(9, [
                  ignored_000$1,
                  char_set
                ]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$3,
                    fmt_rest$4
                  ])];
            }
            else {
              pad_used = /* true */1;
              fmt_result = /* Fmt_EBB */[/* Scan_char_set */Block.__(20, [
                    opt_of_pad(/* "[" */91, pad),
                    char_set,
                    fmt_rest$4
                  ])];
            }
            break;
        case 32 : 
        case 35 : 
        case 43 : 
        case 45 : 
        case 95 : 
            exit$1 = 5;
            break;
        case 97 : 
            var match$9 = parse_literal(str_ind, str_ind, end_ind);
            fmt_result = /* Fmt_EBB */[/* Alpha */Block.__(15, [match$9[0]])];
            break;
        case 66 : 
        case 98 : 
            exit$1 = 3;
            break;
        case 99 : 
            var char_format = function (fmt_rest) {
              if (ign_used[0] = /* true */1, ign) {
                return /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                            /* Ignored_char */0,
                            fmt_rest
                          ])];
              }
              else {
                return /* Fmt_EBB */[/* Char */Block.__(0, [fmt_rest])];
              }
            };
            var scan_format = function (fmt_rest) {
              if (ign_used[0] = /* true */1, ign) {
                return /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                            /* Ignored_scan_next_char */4,
                            fmt_rest
                          ])];
              }
              else {
                return /* Fmt_EBB */[/* Scan_next_char */Block.__(22, [fmt_rest])];
              }
            };
            var match$10 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$5 = match$10[0];
            pad_used = /* true */1;
            var match$11 = opt_of_pad(/* "c" */99, pad);
            fmt_result = match$11 ? (
                match$11[0] !== 0 ? (
                    legacy_behavior$1 ? char_format(fmt_rest$5) : invalid_format_message(str_ind, "non-zero widths are unsupported for %c conversions")
                  ) : scan_format(fmt_rest$5)
              ) : char_format(fmt_rest$5);
            break;
        case 69 : 
        case 70 : 
        case 71 : 
        case 101 : 
        case 102 : 
        case 103 : 
            exit$1 = 2;
            break;
        case 76 : 
        case 108 : 
        case 110 : 
            exit$2 = 8;
            break;
        case 114 : 
            var match$12 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$6 = match$12[0];
            fmt_result = (ign_used[0] = /* true */1, ign) ? /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    /* Ignored_reader */3,
                    fmt_rest$6
                  ])] : /* Fmt_EBB */[/* Reader */Block.__(19, [fmt_rest$6])];
            break;
        case 115 : 
            pad_used = /* true */1;
            var pad$2 = check_no_0(symb, padprec);
            var match$13 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$7 = match$13[0];
            if (ign_used[0] = /* true */1, ign) {
              pad_used = /* true */1;
              var ignored$4 = /* Ignored_string */Block.__(0, [opt_of_pad(/* "_" */95, padprec)]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$4,
                    fmt_rest$7
                  ])];
            }
            else {
              var match$14 = make_padding_fmt_ebb(pad$2, fmt_rest$7);
              fmt_result = /* Fmt_EBB */[/* String */Block.__(2, [
                    match$14[0],
                    match$14[1]
                  ])];
            }
            break;
        case 116 : 
            var match$15 = parse_literal(str_ind, str_ind, end_ind);
            fmt_result = /* Fmt_EBB */[/* Theta */Block.__(16, [match$15[0]])];
            break;
        case 88 : 
        case 100 : 
        case 105 : 
        case 111 : 
        case 117 : 
        case 120 : 
            exit$2 = 7;
            break;
        case 0 : 
        case 1 : 
        case 2 : 
        case 3 : 
        case 4 : 
        case 5 : 
        case 6 : 
        case 7 : 
        case 8 : 
        case 9 : 
        case 10 : 
        case 11 : 
        case 12 : 
        case 13 : 
        case 14 : 
        case 15 : 
        case 16 : 
        case 17 : 
        case 18 : 
        case 19 : 
        case 20 : 
        case 21 : 
        case 22 : 
        case 23 : 
        case 24 : 
        case 25 : 
        case 26 : 
        case 27 : 
        case 28 : 
        case 29 : 
        case 30 : 
        case 31 : 
        case 34 : 
        case 36 : 
        case 38 : 
        case 39 : 
        case 41 : 
        case 42 : 
        case 46 : 
        case 47 : 
        case 48 : 
        case 49 : 
        case 50 : 
        case 51 : 
        case 52 : 
        case 53 : 
        case 54 : 
        case 55 : 
        case 56 : 
        case 57 : 
        case 58 : 
        case 59 : 
        case 60 : 
        case 61 : 
        case 62 : 
        case 63 : 
        case 65 : 
        case 68 : 
        case 72 : 
        case 73 : 
        case 74 : 
        case 75 : 
        case 77 : 
        case 79 : 
        case 80 : 
        case 81 : 
        case 82 : 
        case 84 : 
        case 85 : 
        case 86 : 
        case 87 : 
        case 89 : 
        case 90 : 
        case 92 : 
        case 93 : 
        case 94 : 
        case 96 : 
        case 104 : 
        case 106 : 
        case 107 : 
        case 109 : 
        case 112 : 
        case 113 : 
        case 118 : 
        case 119 : 
        case 121 : 
        case 122 : 
            exit$1 = 6;
            break;
        case 123 : 
            var sub_end$1 = search_subformat_end(str_ind, end_ind, /* "}" */125);
            var match$16 = parse_literal(str_ind, str_ind, sub_end$1);
            var beg_ind$1 = sub_end$1 + 2 | 0;
            var match$17 = parse_literal(beg_ind$1, beg_ind$1, end_ind);
            var fmt_rest$8 = match$17[0];
            var sub_fmtty$1 = fmtty_of_fmt(match$16[0]);
            if (ign_used[0] = /* true */1, ign) {
              pad_used = /* true */1;
              var ignored_000$2 = opt_of_pad(/* "_" */95, pad);
              var ignored$5 = /* Ignored_format_arg */Block.__(7, [
                  ignored_000$2,
                  sub_fmtty$1
                ]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$5,
                    fmt_rest$8
                  ])];
            }
            else {
              pad_used = /* true */1;
              fmt_result = /* Fmt_EBB */[/* Format_arg */Block.__(13, [
                    opt_of_pad(/* "{" */123, pad),
                    sub_fmtty$1,
                    fmt_rest$8
                  ])];
            }
            break;
        
      }
    }
    switch (exit$2) {
      case 7 : 
          plus_used = /* true */1;
          sharp_used = /* true */1;
          space_used = /* true */1;
          var iconv = compute_int_conv(pct_ind, str_ind, plus, sharp, space, symb);
          var match$18 = parse_literal(str_ind, str_ind, end_ind);
          var fmt_rest$9 = match$18[0];
          if (ign_used[0] = /* true */1, ign) {
            pad_used = /* true */1;
            var ignored_001 = opt_of_pad(/* "_" */95, pad);
            var ignored$6 = /* Ignored_int */Block.__(2, [
                iconv,
                ignored_001
              ]);
            fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                  ignored$6,
                  fmt_rest$9
                ])];
          }
          else {
            pad_used = /* true */1;
            prec_used[0] = /* true */1;
            var pad$3;
            var exit$3 = 0;
            if (typeof prec === "number" && prec === 0) {
              pad$3 = pad;
            }
            else {
              exit$3 = 9;
            }
            if (exit$3 === 9) {
              pad$3 = typeof pad === "number" ? /* No_padding */0 : (
                  pad.tag ? (
                      pad[0] >= 2 ? (
                          legacy_behavior$1 ? /* Arg_padding */Block.__(1, [/* Right */1]) : incompatible_flag(pct_ind, str_ind, /* "0" */48, "precision")
                        ) : pad
                    ) : (
                      pad[0] >= 2 ? (
                          legacy_behavior$1 ? /* Lit_padding */Block.__(0, [
                                /* Right */1,
                                pad[1]
                              ]) : incompatible_flag(pct_ind, str_ind, /* "0" */48, "precision")
                        ) : pad
                    )
                );
            }
            var match$19 = make_padprec_fmt_ebb(pad$3, (prec_used[0] = /* true */1, prec), fmt_rest$9);
            fmt_result = /* Fmt_EBB */[/* Int */Block.__(4, [
                  iconv,
                  match$19[0],
                  match$19[1],
                  match$19[2]
                ])];
          }
          break;
      case 8 : 
          if (str_ind === end_ind || !is_int_base(Caml_string.get(str, str_ind))) {
            var match$20 = parse_literal(str_ind, str_ind, end_ind);
            var fmt_rest$10 = match$20[0];
            var counter = counter_of_char(symb);
            if (ign_used[0] = /* true */1, ign) {
              var ignored$7 = /* Ignored_scan_get_counter */Block.__(10, [counter]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$7,
                    fmt_rest$10
                  ])];
            }
            else {
              fmt_result = /* Fmt_EBB */[/* Scan_get_counter */Block.__(21, [
                    counter,
                    fmt_rest$10
                  ])];
            }
          }
          else {
            exit$1 = 6;
          }
          break;
      
    }
    switch (exit$1) {
      case 2 : 
          plus_used = /* true */1;
          space_used = /* true */1;
          var fconv = compute_float_conv(pct_ind, str_ind, plus, space, symb);
          var match$21 = parse_literal(str_ind, str_ind, end_ind);
          var fmt_rest$11 = match$21[0];
          if (ign_used[0] = /* true */1, ign) {
            pad_used = /* true */1;
            var ignored_000$3 = opt_of_pad(/* "_" */95, pad);
            var ignored_001$1 = get_prec_opt(/* () */0);
            var ignored$8 = /* Ignored_float */Block.__(6, [
                ignored_000$3,
                ignored_001$1
              ]);
            fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                  ignored$8,
                  fmt_rest$11
                ])];
          }
          else {
            pad_used = /* true */1;
            var match$22 = make_padprec_fmt_ebb(pad, (prec_used[0] = /* true */1, prec), fmt_rest$11);
            fmt_result = /* Fmt_EBB */[/* Float */Block.__(8, [
                  fconv,
                  match$22[0],
                  match$22[1],
                  match$22[2]
                ])];
          }
          break;
      case 3 : 
          var match$23 = parse_literal(str_ind, str_ind, end_ind);
          var fmt_rest$12 = match$23[0];
          fmt_result = (ign_used[0] = /* true */1, ign) ? /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                  /* Ignored_bool */2,
                  fmt_rest$12
                ])] : /* Fmt_EBB */[/* Bool */Block.__(9, [fmt_rest$12])];
          break;
      case 4 : 
          var match$24 = parse_literal(str_ind, str_ind, end_ind);
          fmt_result = /* Fmt_EBB */[/* Char_literal */Block.__(12, [
                symb,
                match$24[0]
              ])];
          break;
      case 5 : 
          fmt_result = Curry._3(failwith_message(/* Format */[
                    /* String_literal */Block.__(11, [
                        "invalid format ",
                        /* Caml_string */Block.__(3, [
                            /* No_padding */0,
                            /* String_literal */Block.__(11, [
                                ": at character number ",
                                /* Int */Block.__(4, [
                                    /* Int_d */0,
                                    /* No_padding */0,
                                    /* No_precision */0,
                                    /* String_literal */Block.__(11, [
                                        ", flag ",
                                        /* Caml_char */Block.__(1, [/* String_literal */Block.__(11, [
                                                " is only allowed after the '",
                                                /* Char_literal */Block.__(12, [
                                                    /* "%" */37,
                                                    /* String_literal */Block.__(11, [
                                                        "', before padding and precision",
                                                        /* End_of_format */0
                                                      ])
                                                  ])
                                              ])])
                                      ])
                                  ])
                              ])
                          ])
                      ]),
                    "invalid format %S: at character number %d, flag %C is only allowed after the '%%', before padding and precision"
                  ]), str, pct_ind, symb);
          break;
      case 6 : 
          if (symb >= 108) {
            if (symb >= 111) {
              exit = 1;
            }
            else {
              switch (symb - 108 | 0) {
                case 0 : 
                    plus_used = /* true */1;
                    sharp_used = /* true */1;
                    space_used = /* true */1;
                    var iconv$1 = compute_int_conv(pct_ind, str_ind + 1 | 0, plus, sharp, space, Caml_string.get(str, str_ind));
                    var beg_ind$2 = str_ind + 1 | 0;
                    var match$25 = parse_literal(beg_ind$2, beg_ind$2, end_ind);
                    var fmt_rest$13 = match$25[0];
                    if (ign_used[0] = /* true */1, ign) {
                      pad_used = /* true */1;
                      var ignored_001$2 = opt_of_pad(/* "_" */95, pad);
                      var ignored$9 = /* Ignored_int32 */Block.__(3, [
                          iconv$1,
                          ignored_001$2
                        ]);
                      fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                            ignored$9,
                            fmt_rest$13
                          ])];
                    }
                    else {
                      pad_used = /* true */1;
                      var match$26 = make_padprec_fmt_ebb(pad, (prec_used[0] = /* true */1, prec), fmt_rest$13);
                      fmt_result = /* Fmt_EBB */[/* Int32 */Block.__(5, [
                            iconv$1,
                            match$26[0],
                            match$26[1],
                            match$26[2]
                          ])];
                    }
                    break;
                case 1 : 
                    exit = 1;
                    break;
                case 2 : 
                    plus_used = /* true */1;
                    sharp_used = /* true */1;
                    space_used = /* true */1;
                    var iconv$2 = compute_int_conv(pct_ind, str_ind + 1 | 0, plus, sharp, space, Caml_string.get(str, str_ind));
                    var beg_ind$3 = str_ind + 1 | 0;
                    var match$27 = parse_literal(beg_ind$3, beg_ind$3, end_ind);
                    var fmt_rest$14 = match$27[0];
                    if (ign_used[0] = /* true */1, ign) {
                      pad_used = /* true */1;
                      var ignored_001$3 = opt_of_pad(/* "_" */95, pad);
                      var ignored$10 = /* Ignored_nativeint */Block.__(4, [
                          iconv$2,
                          ignored_001$3
                        ]);
                      fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                            ignored$10,
                            fmt_rest$14
                          ])];
                    }
                    else {
                      pad_used = /* true */1;
                      var match$28 = make_padprec_fmt_ebb(pad, (prec_used[0] = /* true */1, prec), fmt_rest$14);
                      fmt_result = /* Fmt_EBB */[/* Nativeint */Block.__(6, [
                            iconv$2,
                            match$28[0],
                            match$28[1],
                            match$28[2]
                          ])];
                    }
                    break;
                
              }
            }
          }
          else if (symb !== 76) {
            exit = 1;
          }
          else {
            plus_used = /* true */1;
            sharp_used = /* true */1;
            space_used = /* true */1;
            var iconv$3 = compute_int_conv(pct_ind, str_ind + 1 | 0, plus, sharp, space, Caml_string.get(str, str_ind));
            var beg_ind$4 = str_ind + 1 | 0;
            var match$29 = parse_literal(beg_ind$4, beg_ind$4, end_ind);
            var fmt_rest$15 = match$29[0];
            if (ign_used[0] = /* true */1, ign) {
              pad_used = /* true */1;
              var ignored_001$4 = opt_of_pad(/* "_" */95, pad);
              var ignored$11 = /* Ignored_int64 */Block.__(5, [
                  iconv$3,
                  ignored_001$4
                ]);
              fmt_result = /* Fmt_EBB */[/* Ignored_param */Block.__(23, [
                    ignored$11,
                    fmt_rest$15
                  ])];
            }
            else {
              pad_used = /* true */1;
              var match$30 = make_padprec_fmt_ebb(pad, (prec_used[0] = /* true */1, prec), fmt_rest$15);
              fmt_result = /* Fmt_EBB */[/* Int64 */Block.__(7, [
                    iconv$3,
                    match$30[0],
                    match$30[1],
                    match$30[2]
                  ])];
            }
          }
          break;
      
    }
    if (exit === 1) {
      fmt_result = Curry._3(failwith_message(/* Format */[
                /* String_literal */Block.__(11, [
                    "invalid format ",
                    /* Caml_string */Block.__(3, [
                        /* No_padding */0,
                        /* String_literal */Block.__(11, [
                            ": at character number ",
                            /* Int */Block.__(4, [
                                /* Int_d */0,
                                /* No_padding */0,
                                /* No_precision */0,
                                /* String_literal */Block.__(11, [
                                    ', invalid conversion "',
                                    /* Char_literal */Block.__(12, [
                                        /* "%" */37,
                                        /* Char */Block.__(0, [/* Char_literal */Block.__(12, [
                                                /* "\"" */34,
                                                /* End_of_format */0
                                              ])])
                                      ])
                                  ])
                              ])
                          ])
                      ])
                  ]),
                'invalid format %S: at character number %d, invalid conversion "%%%c"'
              ]), str, str_ind - 1 | 0, symb);
    }
    if (!legacy_behavior$1) {
      if (!plus_used && plus) {
        incompatible_flag(pct_ind, str_ind, symb, "'+'");
      }
      if (!sharp_used && sharp) {
        incompatible_flag(pct_ind, str_ind, symb, "'#'");
      }
      if (!space_used && space) {
        incompatible_flag(pct_ind, str_ind, symb, "' '");
      }
      if (!pad_used && Caml_obj.caml_notequal(/* Padding_EBB */[pad], /* Padding_EBB */[/* No_padding */0])) {
        incompatible_flag(pct_ind, str_ind, symb, "`padding'");
      }
      if (!prec_used[0] && Caml_obj.caml_notequal(/* Precision_EBB */[prec], /* Precision_EBB */[/* No_precision */0])) {
        incompatible_flag(pct_ind, str_ind, ign ? /* "_" */95 : symb, "`precision'");
      }
      if (ign && plus) {
        incompatible_flag(pct_ind, str_ind, /* "_" */95, "'+'");
      }
      
    }
    if (!ign_used[0] && ign) {
      var exit$4 = 0;
      if (symb >= 38) {
        if (symb !== 44) {
          if (symb !== 64) {
            exit$4 = 1;
          }
          else if (!legacy_behavior$1) {
            exit$4 = 1;
          }
          
        }
        else if (!legacy_behavior$1) {
          exit$4 = 1;
        }
        
      }
      else if (symb !== 33) {
        if (symb >= 37) {
          if (!legacy_behavior$1) {
            exit$4 = 1;
          }
          
        }
        else {
          exit$4 = 1;
        }
      }
      else if (!legacy_behavior$1) {
        exit$4 = 1;
      }
      if (exit$4 === 1) {
        incompatible_flag(pct_ind, str_ind, symb, "'_'");
      }
      
    }
    return fmt_result;
  };
  var parse_flags = function (pct_ind, str_ind, end_ind, ign) {
    var zero = [/* false */0];
    var minus = [/* false */0];
    var plus = [/* false */0];
    var space = [/* false */0];
    var sharp = [/* false */0];
    var set_flag = function (str_ind, flag) {
      if (flag[0] && !legacy_behavior$1) {
        Curry._3(failwith_message(/* Format */[
                  /* String_literal */Block.__(11, [
                      "invalid format ",
                      /* Caml_string */Block.__(3, [
                          /* No_padding */0,
                          /* String_literal */Block.__(11, [
                              ": at character number ",
                              /* Int */Block.__(4, [
                                  /* Int_d */0,
                                  /* No_padding */0,
                                  /* No_precision */0,
                                  /* String_literal */Block.__(11, [
                                      ", duplicate flag ",
                                      /* Caml_char */Block.__(1, [/* End_of_format */0])
                                    ])
                                ])
                            ])
                        ])
                    ]),
                  "invalid format %S: at character number %d, duplicate flag %C"
                ]), str, str_ind, Caml_string.get(str, str_ind));
      }
      flag[0] = /* true */1;
      return /* () */0;
    };
    var _str_ind = str_ind;
    while(true) {
      var str_ind$1 = _str_ind;
      if (str_ind$1 === end_ind) {
        invalid_format_message(end_ind, "unexpected end of format");
      }
      var match = Caml_string.get(str, str_ind$1);
      var exit = 0;
      var switcher = match - 32 | 0;
      if (switcher > 16 || switcher < 0) {
        exit = 1;
      }
      else {
        switch (switcher) {
          case 0 : 
              set_flag(str_ind$1, space);
              _str_ind = str_ind$1 + 1 | 0;
              continue ;
              case 3 : 
              set_flag(str_ind$1, sharp);
              _str_ind = str_ind$1 + 1 | 0;
              continue ;
              case 11 : 
              set_flag(str_ind$1, plus);
              _str_ind = str_ind$1 + 1 | 0;
              continue ;
              case 13 : 
              set_flag(str_ind$1, minus);
              _str_ind = str_ind$1 + 1 | 0;
              continue ;
              case 1 : 
          case 2 : 
          case 4 : 
          case 5 : 
          case 6 : 
          case 7 : 
          case 8 : 
          case 9 : 
          case 10 : 
          case 12 : 
          case 14 : 
          case 15 : 
              exit = 1;
              break;
          case 16 : 
              set_flag(str_ind$1, zero);
              _str_ind = str_ind$1 + 1 | 0;
              continue ;
              
        }
      }
      if (exit === 1) {
        var pct_ind$1 = pct_ind;
        var str_ind$2 = str_ind$1;
        var end_ind$1 = end_ind;
        var zero$1 = zero[0];
        var minus$1 = minus[0];
        var plus$1 = plus[0];
        var sharp$1 = sharp[0];
        var space$1 = space[0];
        var ign$1 = ign;
        if (str_ind$2 === end_ind$1) {
          invalid_format_message(end_ind$1, "unexpected end of format");
        }
        var padty = zero$1 !== 0 ? (
            minus$1 !== 0 ? (
                legacy_behavior$1 ? /* Left */0 : incompatible_flag(pct_ind$1, str_ind$2, /* "-" */45, "0")
              ) : /* Zeros */2
          ) : (
            minus$1 !== 0 ? /* Left */0 : /* Right */1
          );
        var match$1 = Caml_string.get(str, str_ind$2);
        var exit$1 = 0;
        if (match$1 >= 48) {
          if (match$1 >= 58) {
            exit$1 = 1;
          }
          else {
            var match$2 = parse_positive(str_ind$2, end_ind$1, 0);
            return parse_after_padding(pct_ind$1, match$2[0], end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, /* Lit_padding */Block.__(0, [
                          padty,
                          match$2[1]
                        ]));
          }
        }
        else if (match$1 !== 42) {
          exit$1 = 1;
        }
        else {
          return parse_after_padding(pct_ind$1, str_ind$2 + 1 | 0, end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, /* Arg_padding */Block.__(1, [padty]));
        }
        if (exit$1 === 1) {
          switch (padty) {
            case 0 : 
                if (!legacy_behavior$1) {
                  invalid_format_without(str_ind$2 - 1 | 0, /* "-" */45, "padding");
                }
                return parse_after_padding(pct_ind$1, str_ind$2, end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, /* No_padding */0);
            case 1 : 
                return parse_after_padding(pct_ind$1, str_ind$2, end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, /* No_padding */0);
            case 2 : 
                return parse_after_padding(pct_ind$1, str_ind$2, end_ind$1, minus$1, plus$1, sharp$1, space$1, ign$1, /* Lit_padding */Block.__(0, [
                              /* Right */1,
                              0
                            ]));
            
          }
        }
        
      }
      
    };
  };
  var is_int_base = function (symb) {
    var switcher = symb - 88 | 0;
    if (switcher > 32 || switcher < 0) {
      return /* false */0;
    }
    else {
      switch (switcher) {
        case 1 : 
        case 2 : 
        case 3 : 
        case 4 : 
        case 5 : 
        case 6 : 
        case 7 : 
        case 8 : 
        case 9 : 
        case 10 : 
        case 11 : 
        case 13 : 
        case 14 : 
        case 15 : 
        case 16 : 
        case 18 : 
        case 19 : 
        case 20 : 
        case 21 : 
        case 22 : 
        case 24 : 
        case 25 : 
        case 26 : 
        case 27 : 
        case 28 : 
        case 30 : 
        case 31 : 
            return /* false */0;
        case 0 : 
        case 12 : 
        case 17 : 
        case 23 : 
        case 29 : 
        case 32 : 
            return /* true */1;
        
      }
    }
  };
  var counter_of_char = function (symb) {
    var exit = 0;
    if (symb >= 108) {
      if (symb >= 111) {
        exit = 1;
      }
      else {
        switch (symb - 108 | 0) {
          case 0 : 
              return /* Line_counter */0;
          case 1 : 
              exit = 1;
              break;
          case 2 : 
              return /* Char_counter */1;
          
        }
      }
    }
    else if (symb !== 76) {
      exit = 1;
    }
    else {
      return /* Token_counter */2;
    }
    if (exit === 1) {
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "camlinternalFormat.ml",
              2683,
              34
            ]
          ];
    }
    
  };
  var parse_char_set = function (str_ind, end_ind) {
    if (str_ind === end_ind) {
      invalid_format_message(end_ind, "unexpected end of format");
    }
    var char_set = Bytes.make(32, /* "\000" */0);
    var add_range = function (c, c$prime) {
      for(var i = c; i <= c$prime; ++i){
        add_in_char_set(char_set, Pervasives.char_of_int(i));
      }
      return /* () */0;
    };
    var fail_single_percent = function (str_ind) {
      return Curry._2(failwith_message(/* Format */[
                      /* String_literal */Block.__(11, [
                          "invalid format ",
                          /* Caml_string */Block.__(3, [
                              /* No_padding */0,
                              /* String_literal */Block.__(11, [
                                  ": '",
                                  /* Char_literal */Block.__(12, [
                                      /* "%" */37,
                                      /* String_literal */Block.__(11, [
                                          "' alone is not accepted in character sets, use ",
                                          /* Char_literal */Block.__(12, [
                                              /* "%" */37,
                                              /* Char_literal */Block.__(12, [
                                                  /* "%" */37,
                                                  /* String_literal */Block.__(11, [
                                                      " instead at position ",
                                                      /* Int */Block.__(4, [
                                                          /* Int_d */0,
                                                          /* No_padding */0,
                                                          /* No_precision */0,
                                                          /* Char_literal */Block.__(12, [
                                                              /* "." */46,
                                                              /* End_of_format */0
                                                            ])
                                                        ])
                                                    ])
                                                ])
                                            ])
                                        ])
                                    ])
                                ])
                            ])
                        ]),
                      "invalid format %S: '%%' alone is not accepted in character sets, use %%%% instead at position %d."
                    ]), str, str_ind);
    };
    var parse_char_set_after_char = function (_str_ind, end_ind, _c) {
      while(true) {
        var c = _c;
        var str_ind = _str_ind;
        if (str_ind === end_ind) {
          invalid_format_message(end_ind, "unexpected end of format");
        }
        var c$prime = Caml_string.get(str, str_ind);
        var exit = 0;
        var exit$1 = 0;
        if (c$prime >= 46) {
          if (c$prime !== 64) {
            if (c$prime !== 93) {
              exit = 1;
            }
            else {
              add_in_char_set(char_set, c);
              return str_ind + 1 | 0;
            }
          }
          else {
            exit$1 = 2;
          }
        }
        else if (c$prime !== 37) {
          if (c$prime >= 45) {
            var str_ind$1 = str_ind + 1 | 0;
            var end_ind$1 = end_ind;
            var c$1 = c;
            if (str_ind$1 === end_ind$1) {
              invalid_format_message(end_ind$1, "unexpected end of format");
            }
            var c$prime$1 = Caml_string.get(str, str_ind$1);
            if (c$prime$1 !== 37) {
              if (c$prime$1 !== 93) {
                add_range(c$1, c$prime$1);
                return parse_char_set_content(str_ind$1 + 1 | 0, end_ind$1);
              }
              else {
                add_in_char_set(char_set, c$1);
                add_in_char_set(char_set, /* "-" */45);
                return str_ind$1 + 1 | 0;
              }
            }
            else {
              if ((str_ind$1 + 1 | 0) === end_ind$1) {
                invalid_format_message(end_ind$1, "unexpected end of format");
              }
              var c$prime$2 = Caml_string.get(str, str_ind$1 + 1 | 0);
              var exit$2 = 0;
              if (c$prime$2 !== 37) {
                if (c$prime$2 !== 64) {
                  return fail_single_percent(str_ind$1);
                }
                else {
                  exit$2 = 1;
                }
              }
              else {
                exit$2 = 1;
              }
              if (exit$2 === 1) {
                add_range(c$1, c$prime$2);
                return parse_char_set_content(str_ind$1 + 2 | 0, end_ind$1);
              }
              
            }
          }
          else {
            exit = 1;
          }
        }
        else {
          exit$1 = 2;
        }
        if (exit$1 === 2) {
          if (c === /* "%" */37) {
            add_in_char_set(char_set, c$prime);
            return parse_char_set_content(str_ind + 1 | 0, end_ind);
          }
          else {
            exit = 1;
          }
        }
        if (exit === 1) {
          if (c === /* "%" */37) {
            fail_single_percent(str_ind);
          }
          add_in_char_set(char_set, c);
          _c = c$prime;
          _str_ind = str_ind + 1 | 0;
          continue ;
          
        }
        
      };
    };
    var parse_char_set_content = function (_str_ind, end_ind) {
      while(true) {
        var str_ind = _str_ind;
        if (str_ind === end_ind) {
          invalid_format_message(end_ind, "unexpected end of format");
        }
        var c = Caml_string.get(str, str_ind);
        if (c !== 45) {
          if (c !== 93) {
            return parse_char_set_after_char(str_ind + 1 | 0, end_ind, c);
          }
          else {
            return str_ind + 1 | 0;
          }
        }
        else {
          add_in_char_set(char_set, /* "-" */45);
          _str_ind = str_ind + 1 | 0;
          continue ;
          
        }
      };
    };
    var parse_char_set_start = function (str_ind, end_ind) {
      if (str_ind === end_ind) {
        invalid_format_message(end_ind, "unexpected end of format");
      }
      var c = Caml_string.get(str, str_ind);
      return parse_char_set_after_char(str_ind + 1 | 0, end_ind, c);
    };
    if (str_ind === end_ind) {
      invalid_format_message(end_ind, "unexpected end of format");
    }
    var match = Caml_string.get(str, str_ind);
    var match$1 = match !== 94 ? /* tuple */[
        str_ind,
        /* false */0
      ] : /* tuple */[
        str_ind + 1 | 0,
        /* true */1
      ];
    var next_ind = parse_char_set_start(match$1[0], end_ind);
    var char_set$1 = Bytes.to_string(char_set);
    return /* tuple */[
            next_ind,
            match$1[1] ? rev_char_set(char_set$1) : char_set$1
          ];
  };
  var check_open_box = function (fmt) {
    if (typeof fmt === "number") {
      return /* () */0;
    }
    else if (fmt.tag === 11) {
      if (typeof fmt[1] === "number") {
        try {
          open_box_of_string(fmt[0]);
          return /* () */0;
        }
        catch (exn){
          if (exn[0] === Caml_builtin_exceptions.failure) {
            return /* () */0;
          }
          else {
            throw exn;
          }
        }
      }
      else {
        return /* () */0;
      }
    }
    else {
      return /* () */0;
    }
  };
  var parse_tag = function (is_open_tag, str_ind, end_ind) {
    try {
      if (str_ind === end_ind) {
        throw Caml_builtin_exceptions.not_found;
      }
      var match = Caml_string.get(str, str_ind);
      if (match !== 60) {
        throw Caml_builtin_exceptions.not_found;
      }
      else {
        var ind = $$String.index_from(str, str_ind + 1 | 0, /* ">" */62);
        if (ind >= end_ind) {
          throw Caml_builtin_exceptions.not_found;
        }
        var sub_str = $$String.sub(str, str_ind, (ind - str_ind | 0) + 1 | 0);
        var beg_ind = ind + 1 | 0;
        var match$1 = parse_literal(beg_ind, beg_ind, end_ind);
        var match$2 = parse_literal(str_ind, str_ind, ind + 1 | 0);
        var sub_fmt = match$2[0];
        var sub_format = /* Format */[
          sub_fmt,
          sub_str
        ];
        var formatting = is_open_tag ? /* Open_tag */Block.__(0, [sub_format]) : (check_open_box(sub_fmt), /* Open_box */Block.__(1, [sub_format]));
        return /* Fmt_EBB */[/* Formatting_gen */Block.__(18, [
                    formatting,
                    match$1[0]
                  ])];
      }
    }
    catch (exn){
      if (exn === Caml_builtin_exceptions.not_found) {
        var match$3 = parse_literal(str_ind, str_ind, end_ind);
        var sub_format$1 = /* Format */[
          /* End_of_format */0,
          ""
        ];
        var formatting$1 = is_open_tag ? /* Open_tag */Block.__(0, [sub_format$1]) : /* Open_box */Block.__(1, [sub_format$1]);
        return /* Fmt_EBB */[/* Formatting_gen */Block.__(18, [
                    formatting$1,
                    match$3[0]
                  ])];
      }
      else {
        throw exn;
      }
    }
  };
  return parse_literal(0, 0, str.length);
}

function format_of_string_fmtty(str, fmtty) {
  var match = fmt_ebb_of_string(/* None */0, str);
  try {
    return /* Format */[
            type_format(match[0], fmtty),
            str
          ];
  }
  catch (exn){
    if (exn === Type_mismatch) {
      return Curry._2(failwith_message(/* Format */[
                      /* String_literal */Block.__(11, [
                          "bad input: format type mismatch between ",
                          /* Caml_string */Block.__(3, [
                              /* No_padding */0,
                              /* String_literal */Block.__(11, [
                                  " and ",
                                  /* Caml_string */Block.__(3, [
                                      /* No_padding */0,
                                      /* End_of_format */0
                                    ])
                                ])
                            ])
                        ]),
                      "bad input: format type mismatch between %S and %S"
                    ]), str, string_of_fmtty(fmtty));
    }
    else {
      throw exn;
    }
  }
}

function format_of_string_format(str, param) {
  var match = fmt_ebb_of_string(/* None */0, str);
  try {
    return /* Format */[
            type_format(match[0], fmtty_of_fmt(param[0])),
            str
          ];
  }
  catch (exn){
    if (exn === Type_mismatch) {
      return Curry._2(failwith_message(/* Format */[
                      /* String_literal */Block.__(11, [
                          "bad input: format type mismatch between ",
                          /* Caml_string */Block.__(3, [
                              /* No_padding */0,
                              /* String_literal */Block.__(11, [
                                  " and ",
                                  /* Caml_string */Block.__(3, [
                                      /* No_padding */0,
                                      /* End_of_format */0
                                    ])
                                ])
                            ])
                        ]),
                      "bad input: format type mismatch between %S and %S"
                    ]), str, param[1]);
    }
    else {
      throw exn;
    }
  }
}

exports.is_in_char_set                 = is_in_char_set;
exports.rev_char_set                   = rev_char_set;
exports.create_char_set                = create_char_set;
exports.add_in_char_set                = add_in_char_set;
exports.freeze_char_set                = freeze_char_set;
exports.param_format_of_ignored_format = param_format_of_ignored_format;
exports.make_printf                    = make_printf;
exports.output_acc                     = output_acc;
exports.bufput_acc                     = bufput_acc;
exports.strput_acc                     = strput_acc;
exports.type_format                    = type_format;
exports.fmt_ebb_of_string              = fmt_ebb_of_string;
exports.format_of_string_fmtty         = format_of_string_fmtty;
exports.format_of_string_format        = format_of_string_format;
exports.char_of_iconv                  = char_of_iconv;
exports.string_of_formatting_lit       = string_of_formatting_lit;
exports.string_of_formatting_gen       = string_of_formatting_gen;
exports.string_of_fmtty                = string_of_fmtty;
exports.string_of_fmt                  = string_of_fmt;
exports.open_box_of_string             = open_box_of_string;
exports.symm                           = symm;
exports.trans                          = trans;
exports.recast                         = recast;
/* No side effect */
//////// end of camlinternalFormat.js ////////
    return exports;
  };


  _registry['caml_io'] = function() {
    let exports = {};
//////// start of caml_io.js ////////
'use strict';

var Curry                   = require("./curry");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function $caret(prim, prim$1) {
  return prim + prim$1;
}

var stdin = undefined;

var stdout = /* record */[
  /* buffer */"",
  /* output */function (_, s) {
    var v = s.length - 1 | 0;
    if (( (typeof process !== "undefined") && process.stdout && process.stdout.write)) {
      return ( process.stdout.write )(s);
    }
    else if (s[v] === "\n") {
      console.log(s.slice(0, v));
      return /* () */0;
    }
    else {
      console.log(s);
      return /* () */0;
    }
  }
];

var stderr = /* record */[
  /* buffer */"",
  /* output */function (_, s) {
    var v = s.length - 1 | 0;
    if (s[v] === "\n") {
      console.log(s.slice(0, v));
      return /* () */0;
    }
    else {
      console.log(s);
      return /* () */0;
    }
  }
];

function caml_ml_open_descriptor_in() {
  throw [
        Caml_builtin_exceptions.failure,
        "caml_ml_open_descriptor_in not implemented"
      ];
}

function caml_ml_open_descriptor_out() {
  throw [
        Caml_builtin_exceptions.failure,
        "caml_ml_open_descriptor_out not implemented"
      ];
}

function caml_ml_flush(oc) {
  if (oc[/* buffer */0] !== "") {
    Curry._2(oc[/* output */1], oc, oc[/* buffer */0]);
    oc[/* buffer */0] = "";
    return /* () */0;
  }
  else {
    return 0;
  }
}

var node_std_output = (function (s){
   return (typeof process !== "undefined") && process.stdout && (process.stdout.write(s), true);
   }
);

function caml_ml_output(oc, str, offset, len) {
  var str$1 = offset === 0 && len === str.length ? str : str.slice(offset, len);
  if (( (typeof process !== "undefined") && process.stdout && process.stdout.write ) && oc === stdout) {
    return ( process.stdout.write )(str$1);
  }
  else {
    var id = str$1.lastIndexOf("\n");
    if (id < 0) {
      oc[/* buffer */0] = oc[/* buffer */0] + str$1;
      return /* () */0;
    }
    else {
      oc[/* buffer */0] = oc[/* buffer */0] + str$1.slice(0, id + 1 | 0);
      caml_ml_flush(oc);
      oc[/* buffer */0] = oc[/* buffer */0] + str$1.slice(id + 1 | 0);
      return /* () */0;
    }
  }
}

function caml_ml_output_char(oc, $$char) {
  return caml_ml_output(oc, String.fromCharCode($$char), 0, 1);
}

function caml_ml_input(_, _$1, _$2, _$3) {
  throw [
        Caml_builtin_exceptions.failure,
        "caml_ml_input ic not implemented"
      ];
}

function caml_ml_input_char() {
  throw [
        Caml_builtin_exceptions.failure,
        "caml_ml_input_char not implemnted"
      ];
}

function caml_ml_out_channels_list() {
  return /* :: */[
          stdout,
          /* :: */[
            stderr,
            /* [] */0
          ]
        ];
}

exports.$caret                      = $caret;
exports.stdin                       = stdin;
exports.stdout                      = stdout;
exports.stderr                      = stderr;
exports.caml_ml_open_descriptor_in  = caml_ml_open_descriptor_in;
exports.caml_ml_open_descriptor_out = caml_ml_open_descriptor_out;
exports.caml_ml_flush               = caml_ml_flush;
exports.node_std_output             = node_std_output;
exports.caml_ml_output              = caml_ml_output;
exports.caml_ml_output_char         = caml_ml_output_char;
exports.caml_ml_input               = caml_ml_input;
exports.caml_ml_input_char          = caml_ml_input_char;
exports.caml_ml_out_channels_list   = caml_ml_out_channels_list;
/* stdin Not a pure module */
//////// end of caml_io.js ////////
    return exports;
  };


  _registry['caml_lexer'] = function() {
    let exports = {};
//////// start of caml_lexer.js ////////
'use strict';

var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function fail() {
  throw [
        Caml_builtin_exceptions.failure,
        "lexing: empty token"
      ];
}

 

/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License, with    */
/*  the special exception on linking described in file ../LICENSE.     */
/*                                                                     */
/***********************************************************************/

/* $Id: lexing.c 6045 2004-01-01 16:42:43Z doligez $ */

/* The table-driven automaton for lexers generated by camllex. */

function caml_lex_array(s) {
    var l = s.length / 2;
    var a = new Array(l);
    // when s.charCodeAt(2 * i + 1 ) > 128 (0x80)
    // a[i] < 0  
    // for(var i = 0 ; i <= 0xffff; ++i) { if (i << 16 >> 16 !==i){console.log(i<<16>>16, 'vs',i)}}
    // 
    for (var i = 0; i < l; i++)
        a[i] = (s.charCodeAt(2 * i) | (s.charCodeAt(2 * i + 1) << 8)) << 16 >> 16;
    return a;
}
/**
 * external c_engine  : lex_tables -> int -> lexbuf -> int
 * lexing.ml
 * type lex_tables = {
 *   lex_base : string;
 *   lex_backtrk : string;
 *   lex_default : string;
 *   lex_trans : string;
 *   lex_check : string;
 *   lex_base_code : string;
 *   lex_backtrk_code : string;
 *   lex_default_code : string;
 *   lex_trans_code : string;
 *   lex_check_code : string;
 *   lex_code : string;
 * }
 *
 * type lexbuf = {
 *   refill_buff : lexbuf -> unit ;
 *   mutable lex_buffer : bytes;
 *   mutable lex_buffer_len : int;
 *   mutable lex_abs_pos : int;
 *   mutable lex_start_pos : int;
 *   mutable lex_curr_pos : int;
 *   mutable lex_last_pos : int;
 *   mutable lex_last_action : int;
 *   mutable lex_eof_reached : bool;
 *   mutable lex_mem : int array;
 *   mutable lex_start_p : position;
 *   mutable lex_curr_p;
 * }
 * @param tbl
 * @param start_state
 * @param lexbuf
 * @returns {any}
 */
function $$caml_lex_engine(tbl, start_state, lexbuf) {
    // Lexing.lexbuf
    var lex_buffer = 1;
    var lex_buffer_len = 2;
    var lex_start_pos = 4;
    var lex_curr_pos = 5;
    var lex_last_pos = 6;
    var lex_last_action = 7;
    var lex_eof_reached = 8;
    // Lexing.lex_tables
    var lex_base = 0;
    var lex_backtrk = 1;
    var lex_default = 2;
    var lex_trans = 3;
    var lex_check = 4;
    if (!tbl.lex_default) {
        tbl.lex_base = caml_lex_array(tbl[lex_base]);
        tbl.lex_backtrk = caml_lex_array(tbl[lex_backtrk]);
        tbl.lex_check = caml_lex_array(tbl[lex_check]);
        tbl.lex_trans = caml_lex_array(tbl[lex_trans]);
        tbl.lex_default = caml_lex_array(tbl[lex_default]);
    }
    var c;
    var state = start_state;
    //var buffer = bytes_of_string(lexbuf[lex_buffer]);
    var buffer = lexbuf[lex_buffer];
    if (state >= 0) {
        /* First entry */
        lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];
        lexbuf[lex_last_action] = -1;
    }
    else {
        /* Reentry after refill */
        state = -state - 1;
    }
    for (;;) {
        /* Lookup base address or action number for current state */
        var base = tbl.lex_base[state];
        if (base < 0)
            return -base - 1;
        /* See if it's a backtrack point */
        var backtrk = tbl.lex_backtrk[state];
        if (backtrk >= 0) {
            lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];
            lexbuf[lex_last_action] = backtrk;
        }
        /* See if we need a refill */
        if (lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len]) {
            if (lexbuf[lex_eof_reached] === 0)
                return -state - 1;
            else
                c = 256;
        }
        else {
            /* Read next input char */
            c = buffer[lexbuf[lex_curr_pos]];
            lexbuf[lex_curr_pos]++;
        }
        /* Determine next state */
        if (tbl.lex_check[base + c] === state) {
            state = tbl.lex_trans[base + c];
        }
        else {
            state = tbl.lex_default[state];
        }
        /* If no transition on this char, return to last backtrack point */
        if (state < 0) {
            lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];
            if (lexbuf[lex_last_action] == -1)
                fail();
            else
                return lexbuf[lex_last_action];
        }
        else {
            /* Erase the EOF condition only if the EOF pseudo-character was
             consumed by the automaton (i.e. there was no backtrack above)
             */
            if (c == 256)
                lexbuf[lex_eof_reached] = 0;
        }
    }
}

/***********************************************/
/* New lexer engine, with memory of positions  */
/***********************************************/

/**
 * s -> Lexing.lex_tables.lex_code
 * mem -> Lexing.lexbuf.lex_mem (* int array *)
 */          
          
function caml_lex_run_mem(s, i, mem, curr_pos) {
    for (;;) {
        var dst = s.charCodeAt(i);
        i++;
        if (dst == 0xff)
            return;
        var src = s.charCodeAt(i);
        i++;
        if (src == 0xff)
            mem[dst] = curr_pos;
        else
            mem[dst] = mem[src];
    }
}


/**
 * s -> Lexing.lex_tables.lex_code
 * mem -> Lexing.lexbuf.lex_mem (* int array *)
 */
  
function caml_lex_run_tag(s, i, mem) {
    for (;;) {
        var dst = s.charCodeAt(i);
        i++;
        if (dst == 0xff)
            return;
        var src = s.charCodeAt(i);
        i++;
        if (src == 0xff)
            mem[dst] = -1;
        else
            mem[dst] = mem[src];
    }
}
/**
 * external c_new_engine : lex_tables -> int -> lexbuf -> int = "caml_new_lex_engine"
 * @param tbl
 * @param start_state
 * @param lexbuf
 * @returns {any}
 */
function $$caml_new_lex_engine(tbl, start_state, lexbuf) {
    // Lexing.lexbuf
    var lex_buffer = 1;
    var lex_buffer_len = 2;
    var lex_start_pos = 4;
    var lex_curr_pos = 5;
    var lex_last_pos = 6;
    var lex_last_action = 7;
    var lex_eof_reached = 8;
    var lex_mem = 9;
    // Lexing.lex_tables
    var lex_base = 0;
    var lex_backtrk = 1;
    var lex_default = 2;
    var lex_trans = 3;
    var lex_check = 4;
    var lex_base_code = 5;
    var lex_backtrk_code = 6;
    var lex_default_code = 7;
    var lex_trans_code = 8;
    var lex_check_code = 9;
    var lex_code = 10;
    if (!tbl.lex_default) {
        tbl.lex_base = caml_lex_array(tbl[lex_base]);
        tbl.lex_backtrk = caml_lex_array(tbl[lex_backtrk]);
        tbl.lex_check = caml_lex_array(tbl[lex_check]);
        tbl.lex_trans = caml_lex_array(tbl[lex_trans]);
        tbl.lex_default = caml_lex_array(tbl[lex_default]);
    }
    if (!tbl.lex_default_code) {
        tbl.lex_base_code = caml_lex_array(tbl[lex_base_code]);
        tbl.lex_backtrk_code = caml_lex_array(tbl[lex_backtrk_code]);
        tbl.lex_check_code = caml_lex_array(tbl[lex_check_code]);
        tbl.lex_trans_code = caml_lex_array(tbl[lex_trans_code]);
        tbl.lex_default_code = caml_lex_array(tbl[lex_default_code]);
    }
    if (tbl.lex_code == null) {
        //tbl.lex_code = caml_bytes_of_string(tbl[lex_code]);
        tbl.lex_code = (tbl[lex_code]);
    }
    var c, state = start_state;
    //var buffer = caml_bytes_of_string(lexbuf[lex_buffer]);
    var buffer = lexbuf[lex_buffer];
    if (state >= 0) {
        /* First entry */
        lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];
        lexbuf[lex_last_action] = -1;
    }
    else {
        /* Reentry after refill */
        state = -state - 1;
    }
    for (;;) {
        /* Lookup base address or action number for current state */
        var base = tbl.lex_base[state];
        if (base < 0) {
            var pc_off = tbl.lex_base_code[state];
            caml_lex_run_tag(tbl.lex_code, pc_off, lexbuf[lex_mem]);
            return -base - 1;
        }
        /* See if it's a backtrack point */
        var backtrk = tbl.lex_backtrk[state];
        if (backtrk >= 0) {
            var pc_off = tbl.lex_backtrk_code[state];
            caml_lex_run_tag(tbl.lex_code, pc_off, lexbuf[lex_mem]);
            lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];
            lexbuf[lex_last_action] = backtrk;
        }
        /* See if we need a refill */
        if (lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len]) {
            if (lexbuf[lex_eof_reached] == 0)
                return -state - 1;
            else
                c = 256;
        }
        else {
            /* Read next input char */
            c = buffer[lexbuf[lex_curr_pos]];
            lexbuf[lex_curr_pos]++;
        }
        /* Determine next state */
        var pstate = state;
        if (tbl.lex_check[base + c] == state)
            state = tbl.lex_trans[base + c];
        else
            state = tbl.lex_default[state];
        /* If no transition on this char, return to last backtrack point */
        if (state < 0) {
            lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];
            if (lexbuf[lex_last_action] == -1)
                fail();
            else
                return lexbuf[lex_last_action];
        }
        else {
            /* If some transition, get and perform memory moves */
            var base_code = tbl.lex_base_code[pstate], pc_off;
            if (tbl.lex_check_code[base_code + c] == pstate)
                pc_off = tbl.lex_trans_code[base_code + c];
            else
                pc_off = tbl.lex_default_code[pstate];
            if (pc_off > 0)
                caml_lex_run_mem(tbl.lex_code, pc_off, lexbuf[lex_mem], lexbuf[lex_curr_pos]);
            /* Erase the EOF condition only if the EOF pseudo-character was
             consumed by the automaton (i.e. there was no backtrack above)
             */
            if (c == 256)
                lexbuf[lex_eof_reached] = 0;
        }
    }
}

;

function caml_lex_engine(prim, prim$1, prim$2) {
  return $$caml_lex_engine(prim, prim$1, prim$2);
}

function caml_new_lex_engine(prim, prim$1, prim$2) {
  return $$caml_new_lex_engine(prim, prim$1, prim$2);
}

exports.fail                = fail;
exports.caml_lex_engine     = caml_lex_engine;
exports.caml_new_lex_engine = caml_new_lex_engine;
/*  Not a pure module */
//////// end of caml_lexer.js ////////
    return exports;
  };


  _registry['caml_obj'] = function() {
    let exports = {};
//////// start of caml_obj.js ////////
'use strict';

var Block                   = require("./block");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function caml_obj_dup(x) {
  var len = x.length;
  var v = new Array(len);
  for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
    v[i] = x[i];
  }
  v.tag = x.tag | 0;
  return v;
}

function caml_obj_truncate(x, new_size) {
  var len = x.length;
  if (new_size <= 0 || new_size > len) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Obj.truncate"
        ];
  }
  else if (len !== new_size) {
    for(var i = new_size ,i_finish = len - 1 | 0; i <= i_finish; ++i){
      x[i] = 0;
    }
    x.length = new_size;
    return /* () */0;
  }
  else {
    return 0;
  }
}

function caml_lazy_make_forward(x) {
  return Block.__(250, [x]);
}

function caml_update_dummy(x, y) {
  var len = y.length;
  for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
    x[i] = y[i];
  }
  var y_tag = y.tag | 0;
  if (y_tag !== 0) {
    x.tag = y_tag;
    return /* () */0;
  }
  else {
    return 0;
  }
}

function caml_int_compare(x, y) {
  if (x < y) {
    return -1;
  }
  else if (x === y) {
    return 0;
  }
  else {
    return 1;
  }
}

function caml_compare(_a, _b) {
  while(true) {
    var b = _b;
    var a = _a;
    if (typeof a === "string") {
      var x = a;
      var y = b;
      if (x < y) {
        return -1;
      }
      else if (x === y) {
        return 0;
      }
      else {
        return 1;
      }
    }
    else if (typeof a === "number") {
      return caml_int_compare(a, b);
    }
    else if (typeof a === "boolean" || typeof a === "null" || typeof a === "undefined") {
      var x$1 = a;
      var y$1 = b;
      if (x$1 === y$1) {
        return 0;
      }
      else if (x$1 < y$1) {
        return -1;
      }
      else {
        return 1;
      }
    }
    else {
      var tag_a = a.tag | 0;
      var tag_b = b.tag | 0;
      if (tag_a === 250) {
        _a = a[0];
        continue ;
        
      }
      else if (tag_b === 250) {
        _b = b[0];
        continue ;
        
      }
      else if (tag_a === 248) {
        return caml_int_compare(a[1], b[1]);
      }
      else if (tag_a === 251) {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "equal: abstract value"
            ];
      }
      else if (tag_a !== tag_b) {
        if (tag_a < tag_b) {
          return -1;
        }
        else {
          return 1;
        }
      }
      else {
        var len_a = a.length;
        var len_b = b.length;
        if (len_a === len_b) {
          var a$1 = a;
          var b$1 = b;
          var _i = 0;
          var same_length = len_a;
          while(true) {
            var i = _i;
            if (i === same_length) {
              return 0;
            }
            else {
              var res = caml_compare(a$1[i], b$1[i]);
              if (res !== 0) {
                return res;
              }
              else {
                _i = i + 1 | 0;
                continue ;
                
              }
            }
          };
        }
        else if (len_a < len_b) {
          var a$2 = a;
          var b$2 = b;
          var _i$1 = 0;
          var short_length = len_a;
          while(true) {
            var i$1 = _i$1;
            if (i$1 === short_length) {
              return -1;
            }
            else {
              var res$1 = caml_compare(a$2[i$1], b$2[i$1]);
              if (res$1 !== 0) {
                return res$1;
              }
              else {
                _i$1 = i$1 + 1 | 0;
                continue ;
                
              }
            }
          };
        }
        else {
          var a$3 = a;
          var b$3 = b;
          var _i$2 = 0;
          var short_length$1 = len_b;
          while(true) {
            var i$2 = _i$2;
            if (i$2 === short_length$1) {
              return 1;
            }
            else {
              var res$2 = caml_compare(a$3[i$2], b$3[i$2]);
              if (res$2 !== 0) {
                return res$2;
              }
              else {
                _i$2 = i$2 + 1 | 0;
                continue ;
                
              }
            }
          };
        }
      }
    }
  };
}

function caml_equal(_a, _b) {
  while(true) {
    var b = _b;
    var a = _a;
    if (a === b) {
      return /* true */1;
    }
    else if (typeof a === "string" || typeof a === "number" || typeof a === "boolean" || typeof a === "undefined" || typeof a === "null") {
      return /* false */0;
    }
    else {
      var tag_a = a.tag | 0;
      var tag_b = b.tag | 0;
      if (tag_a === 250) {
        _a = a[0];
        continue ;
        
      }
      else if (tag_b === 250) {
        _b = b[0];
        continue ;
        
      }
      else if (tag_a === 248) {
        return +(a[1] === b[1]);
      }
      else if (tag_a === 251) {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "equal: abstract value"
            ];
      }
      else if (tag_a !== tag_b) {
        return /* false */0;
      }
      else {
        var len_a = a.length;
        var len_b = b.length;
        if (len_a === len_b) {
          var a$1 = a;
          var b$1 = b;
          var _i = 0;
          var same_length = len_a;
          while(true) {
            var i = _i;
            if (i === same_length) {
              return /* true */1;
            }
            else if (caml_equal(a$1[i], b$1[i])) {
              _i = i + 1 | 0;
              continue ;
              
            }
            else {
              return /* false */0;
            }
          };
        }
        else {
          return /* false */0;
        }
      }
    }
  };
}

function caml_notequal(a, b) {
  return 1 - caml_equal(a, b);
}

function caml_greaterequal(a, b) {
  return +(caml_compare(a, b) >= 0);
}

function caml_greaterthan(a, b) {
  return +(caml_compare(a, b) > 0);
}

function caml_lessequal(a, b) {
  return +(caml_compare(a, b) <= 0);
}

function caml_lessthan(a, b) {
  return +(caml_compare(a, b) < 0);
}

var caml_int32_compare = caml_int_compare;

var caml_nativeint_compare = caml_int_compare;

exports.caml_obj_dup           = caml_obj_dup;
exports.caml_obj_truncate      = caml_obj_truncate;
exports.caml_lazy_make_forward = caml_lazy_make_forward;
exports.caml_update_dummy      = caml_update_dummy;
exports.caml_int_compare       = caml_int_compare;
exports.caml_int32_compare     = caml_int32_compare;
exports.caml_nativeint_compare = caml_nativeint_compare;
exports.caml_compare           = caml_compare;
exports.caml_equal             = caml_equal;
exports.caml_notequal          = caml_notequal;
exports.caml_greaterequal      = caml_greaterequal;
exports.caml_greaterthan       = caml_greaterthan;
exports.caml_lessthan          = caml_lessthan;
exports.caml_lessequal         = caml_lessequal;
/* No side effect */
//////// end of caml_obj.js ////////
    return exports;
  };


  _registry['caml_oo'] = function() {
    let exports = {};
//////// start of caml_oo.js ////////
'use strict';

var Caml_array              = require("./caml_array");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

var caml_methods_cache = Caml_array.caml_make_vect(1000, 0);

function caml_get_public_method(obj, tag, cacheid) {
  var meths = obj[0];
  var offs = caml_methods_cache[cacheid];
  if (meths[offs] === tag) {
    return meths[offs - 1 | 0];
  }
  else {
    var aux = function (_i) {
      while(true) {
        var i = _i;
        if (i < 3) {
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "caml_oo.ml",
                  54,
                  20
                ]
              ];
        }
        else if (meths[i] === tag) {
          caml_methods_cache[cacheid] = i;
          return i;
        }
        else {
          _i = i - 2 | 0;
          continue ;
          
        }
      };
    };
    return meths[aux((meths[0] << 1) + 1 | 0) - 1 | 0];
  }
}

exports.caml_get_public_method = caml_get_public_method;
/* No side effect */
//////// end of caml_oo.js ////////
    return exports;
  };


  _registry['caml_parser'] = function() {
    let exports = {};
//////// start of caml_parser.js ////////
'use strict';




/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License, with    */
/*  the special exception on linking described in file ../LICENSE.     */
/*                                                                     */
/***********************************************************************/

/* $Id: parsing.c 8983 2008-08-06 09:38:25Z xleroy $ */

/* The PDA automaton for parsers generated by camlyacc */

/* The pushdown automata */

/**
 * caml_lex_array("abcd")
 * [25185, 25699]
 * @param s
 * @returns {any[]}
 * TODO: duplicated with module {!Caml_lex}
 */
function caml_lex_array(s) {
    var l = s.length / 2;
    var a = new Array(l);
    for (var i = 0; i < l; i++)
        a[i] = (s.charCodeAt(2 * i) | (s.charCodeAt(2 * i + 1) << 8)) << 16 >> 16;
    return a;
}
/**
 * Note that TS enum is not friendly to Closure compiler
 * @enum{number}
 */
var Automata = {
    START: 0,
    LOOP: 6,
    TOKEN_READ: 1,
    TEST_SHIFT: 7,
    ERROR_DETECTED: 5,
    SHIFT: 8,
    SHIFT_RECOVER: 9,
    STACK_GROWN_1: 2,
    REDUCE: 10,
    STACK_GROWN_2: 3,
    SEMANTIC_ACTION_COMPUTED: 4
};
/**
 * @enum{number}
 */
var Result = {
    READ_TOKEN: 0,
    RAISE_PARSE_ERROR: 1,
    GROW_STACKS_1: 2,
    GROW_STACKS_2: 3,
    COMPUTE_SEMANTIC_ACTION: 4,
    CALL_ERROR_FUNCTION: 5
};
var PARSER_TRACE = false;
/**
 * external parse_engine : parse_tables -> parser_env -> parser_input -> Obj.t -> parser_output
 * parsing.ml
 *
 * type parse_tables = {
 *   actions : (parser_env -> Obj.t) array
 *   transl_const : int array;
 *   transl_block : int array;
 *   lhs : string;
 *   len : string;
 *   defred : string;
 *   dgoto : string;
 *   sindex : string;
 *   rindex : string;
 *   gindex : string;
 *   tablesize : int;
 *   table : string;
 *   check : string;
 *   error_function : string -> unit;
 *   names_const : string;
 *   names_block : string
 * }
 *
 * type parser_env =
 * { mutable s_stack : int array;        (* States *)
 *  mutable v_stack : Obj.t array;      (* Semantic attributes *)
 *  mutable symb_start_stack : position array; (* Start positions *)
 *  mutable symb_end_stack : position array;   (* End positions *)
 *  mutable stacksize : int;            (* Size of the stacks *)
 *  mutable stackbase : int;            (* Base sp for current parse *)
 *  mutable curr_char : int;            (* Last token read *)
 *  mutable lval : Obj.t;               (* Its semantic attribute *)
 *  mutable symb_start : position;      (* Start pos. of the current symbol*)
 *  mutable symb_end : position;        (* End pos. of the current symbol *)
 *  mutable asp : int;                  (* The stack pointer for attributes *)
 *  mutable rule_len : int;             (* Number of rhs items in the rule *)
 *  mutable rule_number : int;          (* Rule number to reduce by *)
 *  mutable sp : int;                   (* Saved sp for parse_engine *)
 *  mutable state : int;                (* Saved state for parse_engine *)
 *  mutable errflag : int }             (* Saved error flag for parse_engine *)
 *
 *  type parser_input =
 *   | Start
 *   | Token_read
 *   | Stacks_grown_1
 *   | Stacks_grown_2
 *   | Semantic_action_computed
 *   | Error_detected

 * @param tables
 * @param env
 * @param cmd
 * @param arg
 * @returns {number}
 */
function $$caml_parse_engine(tables /* parser_table */, env /* parser_env */, cmd /* parser_input*/, arg /* Obj.t*/) {
    var ERRCODE = 256;
    //var START = 0;
    //var TOKEN_READ = 1;
    //var STACKS_GROWN_1 = 2;
    //var STACKS_GROWN_2 = 3;
    //var SEMANTIC_ACTION_COMPUTED = 4;
    //var ERROR_DETECTED = 5;
    //var loop = 6;
    //var testshift = 7;
    //var shift = 8;
    //var shift_recover = 9;
    //var reduce = 10;
    // Parsing.parser_env
    var env_s_stack = 0; // array
    var env_v_stack = 1; // array
    var env_symb_start_stack = 2; // array
    var env_symb_end_stack = 3; // array
    var env_stacksize = 4;
    var env_stackbase = 5;
    var env_curr_char = 6;
    var env_lval = 7; // Obj.t
    var env_symb_start = 8; // position
    var env_symb_end = 9; // position
    var env_asp = 10;
    var env_rule_len = 11;
    var env_rule_number = 12;
    var env_sp = 13;
    var env_state = 14;
    var env_errflag = 15;
    // Parsing.parse_tables
    // var _tbl_actions = 1;
    var tbl_transl_const = 1; // array
    var tbl_transl_block = 2; // array
    var tbl_lhs = 3;
    var tbl_len = 4;
    var tbl_defred = 5;
    var tbl_dgoto = 6;
    var tbl_sindex = 7;
    var tbl_rindex = 8;
    var tbl_gindex = 9;
    var tbl_tablesize = 10;
    var tbl_table = 11;
    var tbl_check = 12;
    // var _tbl_error_function = 14;
    // var _tbl_names_const = 15;
    // var _tbl_names_block = 16;
    if (!tables.dgoto) {
        tables.defred = caml_lex_array(tables[tbl_defred]);
        tables.sindex = caml_lex_array(tables[tbl_sindex]);
        tables.check = caml_lex_array(tables[tbl_check]);
        tables.rindex = caml_lex_array(tables[tbl_rindex]);
        tables.table = caml_lex_array(tables[tbl_table]);
        tables.len = caml_lex_array(tables[tbl_len]);
        tables.lhs = caml_lex_array(tables[tbl_lhs]);
        tables.gindex = caml_lex_array(tables[tbl_gindex]);
        tables.dgoto = caml_lex_array(tables[tbl_dgoto]);
    }
    var res;
    var n, n1, n2, state1;
    // RESTORE
    var sp = env[env_sp];
    var state = env[env_state];
    var errflag = env[env_errflag];
    exit: for (;;) {
        //console.error("State", Automata[cmd]);
        switch (cmd) {
            case Automata.START:
                state = 0;
                errflag = 0;
            // Fall through
            case Automata.LOOP:
                n = tables.defred[state];
                if (n != 0) {
                    cmd = Automata.REDUCE;
                    break;
                }
                if (env[env_curr_char] >= 0) {
                    cmd = Automata.TEST_SHIFT;
                    break;
                }
                res = Result.READ_TOKEN;
                break exit;
            /* The ML code calls the lexer and updates */
            /* symb_start and symb_end */
            case Automata.TOKEN_READ:
                if (typeof arg !== 'number') {
                    env[env_curr_char] = tables[tbl_transl_block][arg.tag | 0 /* + 1 */];
                    env[env_lval] = arg[0];
                }
                else {
                    env[env_curr_char] = tables[tbl_transl_const][arg /* + 1 */];
                    env[env_lval] = 0;
                }
                if (PARSER_TRACE) {
                    console.error("State %d, read token", state, arg);
                }
            // Fall through
            case Automata.TEST_SHIFT:
                n1 = tables.sindex[state];
                n2 = n1 + env[env_curr_char];
                if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&
                    tables.check[n2] == env[env_curr_char]) {
                    cmd = Automata.SHIFT;
                    break;
                }
                n1 = tables.rindex[state];
                n2 = n1 + env[env_curr_char];
                if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&
                    tables.check[n2] == env[env_curr_char]) {
                    n = tables.table[n2];
                    cmd = Automata.REDUCE;
                    break;
                }
                if (errflag <= 0) {
                    res = Result.CALL_ERROR_FUNCTION;
                    break exit;
                }
            // Fall through
            /* The ML code calls the error function */
            case Automata.ERROR_DETECTED:
                if (errflag < 3) {
                    errflag = 3;
                    for (;;) {
                        state1 = env[env_s_stack][sp /* + 1*/];
                        n1 = tables.sindex[state1];
                        n2 = n1 + ERRCODE;
                        if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&
                            tables.check[n2] == ERRCODE) {
                            cmd = Automata.SHIFT_RECOVER;
                            break;
                        }
                        else {
                            if (sp <= env[env_stackbase])
                                return Result.RAISE_PARSE_ERROR;
                            /* The ML code raises Parse_error */
                            sp--;
                        }
                    }
                }
                else {
                    if (env[env_curr_char] == 0)
                        return Result.RAISE_PARSE_ERROR;
                    /* The ML code raises Parse_error */
                    env[env_curr_char] = -1;
                    cmd = Automata.LOOP;
                    break;
                }
            // Fall through
            case Automata.SHIFT:
                env[env_curr_char] = -1;
                if (errflag > 0)
                    errflag--;
            // Fall through
            case Automata.SHIFT_RECOVER:
                if (PARSER_TRACE) {
                    console.error("State %d: shift to state %d", state, tables.table[n2]);
                }
                state = tables.table[n2];
                sp++;
                if (sp >= env[env_stacksize]) {
                    res = Result.GROW_STACKS_1;
                    break exit;
                }
            // Fall through
            /* The ML code resizes the stacks */
            case Automata.STACK_GROWN_1:
                env[env_s_stack][sp /* + 1 */] = state;
                env[env_v_stack][sp /* + 1 */] = env[env_lval];
                env[env_symb_start_stack][sp /* + 1 */] = env[env_symb_start];
                env[env_symb_end_stack][sp /* + 1 */] = env[env_symb_end];
                cmd = Automata.LOOP;
                break;
            case Automata.REDUCE:
                if (PARSER_TRACE) {
                    console.error("State %d : reduce by rule %d", state, n);
                }
                var m = tables.len[n];
                env[env_asp] = sp;
                env[env_rule_number] = n;
                env[env_rule_len] = m;
                sp = sp - m + 1;
                m = tables.lhs[n];
                state1 = env[env_s_stack][sp - 1]; //
                n1 = tables.gindex[m];
                n2 = n1 + state1;
                if (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize] &&
                    tables.check[n2] == state1)
                    state = tables.table[n2];
                else
                    state = tables.dgoto[m];
                if (sp >= env[env_stacksize]) {
                    res = Result.GROW_STACKS_2;
                    break exit;
                }
            // Fall through
            /* The ML code resizes the stacks */
            case Automata.STACK_GROWN_2:
                res = Result.COMPUTE_SEMANTIC_ACTION;
                break exit;
            /* The ML code calls the semantic action */
            case Automata.SEMANTIC_ACTION_COMPUTED:
                env[env_s_stack][sp /* + 1 */] = state;
                env[env_v_stack][sp /* + 1*/] = arg;
                var asp = env[env_asp];
                env[env_symb_end_stack][sp /* + 1*/] = env[env_symb_end_stack][asp /* + 1*/];
                if (sp > asp) {
                    /* This is an epsilon production. Take symb_start equal to symb_end. */
                    env[env_symb_start_stack][sp /* + 1*/] = env[env_symb_end_stack][asp /*+ 1*/];
                }
                cmd = Automata.LOOP;
                break;
            /* Should not happen */
            default:
                return Result.RAISE_PARSE_ERROR;
        }
    }
    // SAVE
    env[env_sp] = sp;
    env[env_state] = state;
    env[env_errflag] = errflag;
    return res;
}

/**
 * external set_trace: bool -> bool = "caml_set_parser_trace"
 * parsing.ml
 * @param {boolean}
 * @returns {boolean}
 */
function $$caml_set_parser_trace(v) {
    var old = PARSER_TRACE;
    PARSER_TRACE = v;
    return old;
}


;

function caml_parse_engine(prim, prim$1, prim$2, prim$3) {
  return $$caml_parse_engine(prim, prim$1, prim$2, prim$3);
}

function caml_set_parser_trace(prim) {
  return $$caml_set_parser_trace(prim);
}

exports.caml_parse_engine     = caml_parse_engine;
exports.caml_set_parser_trace = caml_set_parser_trace;
/*  Not a pure module */
//////// end of caml_parser.js ////////
    return exports;
  };


  _registry['caml_string'] = function() {
    let exports = {};
//////// start of caml_string.js ////////
'use strict';

var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function js_string_of_char(prim) {
  return String.fromCharCode(prim);
}

function caml_string_get(s, i) {
  if (i >= s.length || i < 0) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "index out of bounds"
        ];
  }
  else {
    return s.charCodeAt(i);
  }
}

function caml_create_string(len) {
  if (len < 0) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "String.create"
        ];
  }
  else {
    return new Array(len);
  }
}

function caml_string_compare(s1, s2) {
  if (s1 === s2) {
    return 0;
  }
  else if (s1 < s2) {
    return -1;
  }
  else {
    return 1;
  }
}

function caml_fill_string(s, i, l, c) {
  if (l > 0) {
    for(var k = i ,k_finish = (l + i | 0) - 1 | 0; k <= k_finish; ++k){
      s[k] = c;
    }
    return /* () */0;
  }
  else {
    return 0;
  }
}

function caml_blit_string(s1, i1, s2, i2, len) {
  if (len > 0) {
    var off1 = s1.length - i1 | 0;
    if (len <= off1) {
      for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
        s2[i2 + i | 0] = s1.charCodeAt(i1 + i | 0);
      }
      return /* () */0;
    }
    else {
      for(var i$1 = 0 ,i_finish$1 = off1 - 1 | 0; i$1 <= i_finish$1; ++i$1){
        s2[i2 + i$1 | 0] = s1.charCodeAt(i1 + i$1 | 0);
      }
      for(var i$2 = off1 ,i_finish$2 = len - 1 | 0; i$2 <= i_finish$2; ++i$2){
        s2[i2 + i$2 | 0] = /* "\000" */0;
      }
      return /* () */0;
    }
  }
  else {
    return 0;
  }
}

function caml_blit_bytes(s1, i1, s2, i2, len) {
  if (len > 0) {
    if (s1 === s2) {
      var s1$1 = s1;
      var i1$1 = i1;
      var i2$1 = i2;
      var len$1 = len;
      if (i1$1 < i2$1) {
        var range_a = (s1$1.length - i2$1 | 0) - 1 | 0;
        var range_b = len$1 - 1 | 0;
        var range = range_a > range_b ? range_b : range_a;
        for(var j = range; j >= 0; --j){
          s1$1[i2$1 + j | 0] = s1$1[i1$1 + j | 0];
        }
        return /* () */0;
      }
      else if (i1$1 > i2$1) {
        var range_a$1 = (s1$1.length - i1$1 | 0) - 1 | 0;
        var range_b$1 = len$1 - 1 | 0;
        var range$1 = range_a$1 > range_b$1 ? range_b$1 : range_a$1;
        for(var k = 0; k <= range$1; ++k){
          s1$1[i2$1 + k | 0] = s1$1[i1$1 + k | 0];
        }
        return /* () */0;
      }
      else {
        return 0;
      }
    }
    else {
      var off1 = s1.length - i1 | 0;
      if (len <= off1) {
        for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
          s2[i2 + i | 0] = s1[i1 + i | 0];
        }
        return /* () */0;
      }
      else {
        for(var i$1 = 0 ,i_finish$1 = off1 - 1 | 0; i$1 <= i_finish$1; ++i$1){
          s2[i2 + i$1 | 0] = s1[i1 + i$1 | 0];
        }
        for(var i$2 = off1 ,i_finish$2 = len - 1 | 0; i$2 <= i_finish$2; ++i$2){
          s2[i2 + i$2 | 0] = /* "\000" */0;
        }
        return /* () */0;
      }
    }
  }
  else {
    return 0;
  }
}

function bytes_of_string(s) {
  var len = s.length;
  var res = new Array(len);
  for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
    res[i] = s.charCodeAt(i);
  }
  return res;
}

function bytes_to_string(a) {
  var bytes = a;
  var i = 0;
  var len = a.length;
  var s = "";
  var s_len = len;
  if (i === 0 && len <= 4096 && len === bytes.length) {
    return String.fromCharCode.apply(null,bytes);
  }
  else {
    var offset = 0;
    while(s_len > 0) {
      var next = s_len < 1024 ? s_len : 1024;
      var tmp_bytes = new Array(next);
      caml_blit_bytes(bytes, offset, tmp_bytes, 0, next);
      s = s + String.fromCharCode.apply(null,tmp_bytes);
      s_len = s_len - next | 0;
      offset = offset + next | 0;
    };
    return s;
  }
}

function caml_string_of_char_array(chars) {
  var len = chars.length;
  var bytes = new Array(len);
  for(var i = 0 ,i_finish = len - 1 | 0; i <= i_finish; ++i){
    bytes[i] = chars[i];
  }
  return bytes_to_string(bytes);
}

function caml_is_printable(c) {
  if (c > 31) {
    return +(c < 127);
  }
  else {
    return /* false */0;
  }
}

function caml_string_get16(s, i) {
  return s.charCodeAt(i) + (s.charCodeAt(i + 1 | 0) << 8) | 0;
}

function caml_string_get32(s, i) {
  return ((s.charCodeAt(i) + (s.charCodeAt(i + 1 | 0) << 8) | 0) + (s.charCodeAt(i + 2 | 0) << 16) | 0) + (s.charCodeAt(i + 3 | 0) << 24) | 0;
}

function get(s, i) {
  if (i < 0 || i >= s.length) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "index out of bounds"
        ];
  }
  else {
    return s.charCodeAt(i);
  }
}

exports.bytes_of_string           = bytes_of_string;
exports.bytes_to_string           = bytes_to_string;
exports.caml_is_printable         = caml_is_printable;
exports.caml_string_of_char_array = caml_string_of_char_array;
exports.caml_string_get           = caml_string_get;
exports.caml_string_compare       = caml_string_compare;
exports.caml_create_string        = caml_create_string;
exports.caml_fill_string          = caml_fill_string;
exports.caml_blit_string          = caml_blit_string;
exports.caml_blit_bytes           = caml_blit_bytes;
exports.caml_string_get16         = caml_string_get16;
exports.caml_string_get32         = caml_string_get32;
exports.js_string_of_char         = js_string_of_char;
exports.get                       = get;
/* No side effect */
//////// end of caml_string.js ////////
    return exports;
  };


  _registry['caml_utils'] = function() {
    let exports = {};
//////// start of caml_utils.js ////////
'use strict';


var repeat = ( (String.prototype.repeat && function (count,self){return self.repeat(count)}) ||
                                                  function(count , self) {
        if (self.length == 0 || count == 0) {
            return '';
        }
        // Ensuring count is a 31-bit integer allows us to heavily optimize the
        // main part. But anyway, most current (August 2014) browsers can't handle
        // strings 1 << 28 chars or longer, so:
        if (self.length * count >= 1 << 28) {
            throw new RangeError('repeat count must not overflow maximum string size');
        }
        var rpt = '';
        for (;;) {
            if ((count & 1) == 1) {
                rpt += self;
            }
            count >>>= 1;
            if (count == 0) {
                break;
            }
            self += self;
        }
        return rpt;
    }
);

exports.repeat = repeat;
/* repeat Not a pure module */
//////// end of caml_utils.js ////////
    return exports;
  };


  _registry['char'] = function() {
    let exports = {};
//////// start of char.js ////////
'use strict';

var Caml_string             = require("./caml_string");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function chr(n) {
  if (n < 0 || n > 255) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Char.chr"
        ];
  }
  else {
    return n;
  }
}

function escaped(c) {
  var exit = 0;
  if (c >= 40) {
    if (c !== 92) {
      exit = c >= 127 ? 1 : 2;
    }
    else {
      return "\\\\";
    }
  }
  else if (c >= 32) {
    if (c >= 39) {
      return "\\'";
    }
    else {
      exit = 2;
    }
  }
  else if (c >= 14) {
    exit = 1;
  }
  else {
    switch (c) {
      case 8 : 
          return "\\b";
      case 9 : 
          return "\\t";
      case 10 : 
          return "\\n";
      case 0 : 
      case 1 : 
      case 2 : 
      case 3 : 
      case 4 : 
      case 5 : 
      case 6 : 
      case 7 : 
      case 11 : 
      case 12 : 
          exit = 1;
          break;
      case 13 : 
          return "\\r";
      
    }
  }
  switch (exit) {
    case 1 : 
        var s = new Array(4);
        s[0] = /* "\\" */92;
        s[1] = 48 + (c / 100 | 0) | 0;
        s[2] = 48 + (c / 10 | 0) % 10 | 0;
        s[3] = 48 + c % 10 | 0;
        return Caml_string.bytes_to_string(s);
    case 2 : 
        var s$1 = new Array(1);
        s$1[0] = c;
        return Caml_string.bytes_to_string(s$1);
    
  }
}

function lowercase(c) {
  if (c >= /* "A" */65 && c <= /* "Z" */90 || c >= /* "\192" */192 && c <= /* "\214" */214 || c >= /* "\216" */216 && c <= /* "\222" */222) {
    return c + 32 | 0;
  }
  else {
    return c;
  }
}

function uppercase(c) {
  if (c >= /* "a" */97 && c <= /* "z" */122 || c >= /* "\224" */224 && c <= /* "\246" */246 || c >= /* "\248" */248 && c <= /* "\254" */254) {
    return c - 32 | 0;
  }
  else {
    return c;
  }
}

function compare(c1, c2) {
  return c1 - c2 | 0;
}

exports.chr       = chr;
exports.escaped   = escaped;
exports.lowercase = lowercase;
exports.uppercase = uppercase;
exports.compare   = compare;
/* No side effect */
//////// end of char.js ////////
    return exports;
  };


  _registry['curry'] = function() {
    let exports = {};
//////// start of curry.js ////////
'use strict';

var Caml_oo    = require("./caml_oo");
var Caml_array = require("./caml_array");

function app(_f, _args) {
  while(true) {
    var args = _args;
    var f = _f;
    var arity = f.length;
    var arity$1 = arity ? arity : 1;
    var len = args.length;
    var d = arity$1 - len | 0;
    if (d) {
      if (d < 0) {
        _args = Caml_array.caml_array_sub(args, arity$1, -d | 0);
        _f = f.apply(null, Caml_array.caml_array_sub(args, 0, arity$1));
        continue ;
        
      }
      else {
        return (function(f,args){
        return function (x) {
          return app(f, args.concat(/* array */[x]));
        }
        }(f,args));
      }
    }
    else {
      return f.apply(null, args);
    }
  };
}

function js(label, cacheid, obj, args) {
  var meth = Caml_oo.caml_get_public_method(obj, label, cacheid);
  return app(meth, args);
}

function curry_1(o, a0, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[a0]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return o(a0);
      case 2 : 
          return function (param) {
            return o(a0, param);
          };
      case 3 : 
          return function (param, param$1) {
            return o(a0, param, param$1);
          };
      case 4 : 
          return function (param, param$1, param$2) {
            return o(a0, param, param$1, param$2);
          };
      case 5 : 
          return function (param, param$1, param$2, param$3) {
            return o(a0, param, param$1, param$2, param$3);
          };
      case 6 : 
          return function (param, param$1, param$2, param$3, param$4) {
            return o(a0, param, param$1, param$2, param$3, param$4);
          };
      case 7 : 
          return function (param, param$1, param$2, param$3, param$4, param$5) {
            return o(a0, param, param$1, param$2, param$3, param$4, param$5);
          };
      
    }
  }
}

function _1(o, a0) {
  var arity = o.length;
  if (arity === 1) {
    return o(a0);
  }
  else {
    return curry_1(o, a0, arity);
  }
}

function js1(label, cacheid, a0) {
  return _1(Caml_oo.caml_get_public_method(a0, label, cacheid), a0);
}

function __1(o) {
  var arity = o.length;
  if (arity === 1) {
    return o;
  }
  else {
    return function (a0) {
      return _1(o, a0);
    };
  }
}

function curry_2(o, a0, a1, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[a1]);
      case 2 : 
          return o(a0, a1);
      case 3 : 
          return function (param) {
            return o(a0, a1, param);
          };
      case 4 : 
          return function (param, param$1) {
            return o(a0, a1, param, param$1);
          };
      case 5 : 
          return function (param, param$1, param$2) {
            return o(a0, a1, param, param$1, param$2);
          };
      case 6 : 
          return function (param, param$1, param$2, param$3) {
            return o(a0, a1, param, param$1, param$2, param$3);
          };
      case 7 : 
          return function (param, param$1, param$2, param$3, param$4) {
            return o(a0, a1, param, param$1, param$2, param$3, param$4);
          };
      
    }
  }
}

function _2(o, a0, a1) {
  var arity = o.length;
  if (arity === 2) {
    return o(a0, a1);
  }
  else {
    return curry_2(o, a0, a1, arity);
  }
}

function js2(label, cacheid, a0, a1) {
  return _2(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1);
}

function __2(o) {
  var arity = o.length;
  if (arity === 2) {
    return o;
  }
  else {
    return function (a0, a1) {
      return _2(o, a0, a1);
    };
  }
}

function curry_3(o, a0, a1, a2, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1,
                a2
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[
                      a1,
                      a2
                    ]);
      case 2 : 
          return app(o(a0, a1), /* array */[a2]);
      case 3 : 
          return o(a0, a1, a2);
      case 4 : 
          return function (param) {
            return o(a0, a1, a2, param);
          };
      case 5 : 
          return function (param, param$1) {
            return o(a0, a1, a2, param, param$1);
          };
      case 6 : 
          return function (param, param$1, param$2) {
            return o(a0, a1, a2, param, param$1, param$2);
          };
      case 7 : 
          return function (param, param$1, param$2, param$3) {
            return o(a0, a1, a2, param, param$1, param$2, param$3);
          };
      
    }
  }
}

function _3(o, a0, a1, a2) {
  var arity = o.length;
  if (arity === 3) {
    return o(a0, a1, a2);
  }
  else {
    return curry_3(o, a0, a1, a2, arity);
  }
}

function js3(label, cacheid, a0, a1, a2) {
  return _3(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1, a2);
}

function __3(o) {
  var arity = o.length;
  if (arity === 3) {
    return o;
  }
  else {
    return function (a0, a1, a2) {
      return _3(o, a0, a1, a2);
    };
  }
}

function curry_4(o, a0, a1, a2, a3, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1,
                a2,
                a3
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[
                      a1,
                      a2,
                      a3
                    ]);
      case 2 : 
          return app(o(a0, a1), /* array */[
                      a2,
                      a3
                    ]);
      case 3 : 
          return app(o(a0, a1, a2), /* array */[a3]);
      case 4 : 
          return o(a0, a1, a2, a3);
      case 5 : 
          return function (param) {
            return o(a0, a1, a2, a3, param);
          };
      case 6 : 
          return function (param, param$1) {
            return o(a0, a1, a2, a3, param, param$1);
          };
      case 7 : 
          return function (param, param$1, param$2) {
            return o(a0, a1, a2, a3, param, param$1, param$2);
          };
      
    }
  }
}

function _4(o, a0, a1, a2, a3) {
  var arity = o.length;
  if (arity === 4) {
    return o(a0, a1, a2, a3);
  }
  else {
    return curry_4(o, a0, a1, a2, a3, arity);
  }
}

function js4(label, cacheid, a0, a1, a2, a3) {
  return _4(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1, a2, a3);
}

function __4(o) {
  var arity = o.length;
  if (arity === 4) {
    return o;
  }
  else {
    return function (a0, a1, a2, a3) {
      return _4(o, a0, a1, a2, a3);
    };
  }
}

function curry_5(o, a0, a1, a2, a3, a4, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1,
                a2,
                a3,
                a4
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[
                      a1,
                      a2,
                      a3,
                      a4
                    ]);
      case 2 : 
          return app(o(a0, a1), /* array */[
                      a2,
                      a3,
                      a4
                    ]);
      case 3 : 
          return app(o(a0, a1, a2), /* array */[
                      a3,
                      a4
                    ]);
      case 4 : 
          return app(o(a0, a1, a2, a3), /* array */[a4]);
      case 5 : 
          return o(a0, a1, a2, a3, a4);
      case 6 : 
          return function (param) {
            return o(a0, a1, a2, a3, a4, param);
          };
      case 7 : 
          return function (param, param$1) {
            return o(a0, a1, a2, a3, a4, param, param$1);
          };
      
    }
  }
}

function _5(o, a0, a1, a2, a3, a4) {
  var arity = o.length;
  if (arity === 5) {
    return o(a0, a1, a2, a3, a4);
  }
  else {
    return curry_5(o, a0, a1, a2, a3, a4, arity);
  }
}

function js5(label, cacheid, a0, a1, a2, a3, a4) {
  return _5(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1, a2, a3, a4);
}

function __5(o) {
  var arity = o.length;
  if (arity === 5) {
    return o;
  }
  else {
    return function (a0, a1, a2, a3, a4) {
      return _5(o, a0, a1, a2, a3, a4);
    };
  }
}

function curry_6(o, a0, a1, a2, a3, a4, a5, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1,
                a2,
                a3,
                a4,
                a5
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[
                      a1,
                      a2,
                      a3,
                      a4,
                      a5
                    ]);
      case 2 : 
          return app(o(a0, a1), /* array */[
                      a2,
                      a3,
                      a4,
                      a5
                    ]);
      case 3 : 
          return app(o(a0, a1, a2), /* array */[
                      a3,
                      a4,
                      a5
                    ]);
      case 4 : 
          return app(o(a0, a1, a2, a3), /* array */[
                      a4,
                      a5
                    ]);
      case 5 : 
          return app(o(a0, a1, a2, a3, a4), /* array */[a5]);
      case 6 : 
          return o(a0, a1, a2, a3, a4, a5);
      case 7 : 
          return function (param) {
            return o(a0, a1, a2, a3, a4, a5, param);
          };
      
    }
  }
}

function _6(o, a0, a1, a2, a3, a4, a5) {
  var arity = o.length;
  if (arity === 6) {
    return o(a0, a1, a2, a3, a4, a5);
  }
  else {
    return curry_6(o, a0, a1, a2, a3, a4, a5, arity);
  }
}

function js6(label, cacheid, a0, a1, a2, a3, a4, a5) {
  return _6(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1, a2, a3, a4, a5);
}

function __6(o) {
  var arity = o.length;
  if (arity === 6) {
    return o;
  }
  else {
    return function (a0, a1, a2, a3, a4, a5) {
      return _6(o, a0, a1, a2, a3, a4, a5);
    };
  }
}

function curry_7(o, a0, a1, a2, a3, a4, a5, a6, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1,
                a2,
                a3,
                a4,
                a5,
                a6
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[
                      a1,
                      a2,
                      a3,
                      a4,
                      a5,
                      a6
                    ]);
      case 2 : 
          return app(o(a0, a1), /* array */[
                      a2,
                      a3,
                      a4,
                      a5,
                      a6
                    ]);
      case 3 : 
          return app(o(a0, a1, a2), /* array */[
                      a3,
                      a4,
                      a5,
                      a6
                    ]);
      case 4 : 
          return app(o(a0, a1, a2, a3), /* array */[
                      a4,
                      a5,
                      a6
                    ]);
      case 5 : 
          return app(o(a0, a1, a2, a3, a4), /* array */[
                      a5,
                      a6
                    ]);
      case 6 : 
          return app(o(a0, a1, a2, a3, a4, a5), /* array */[a6]);
      case 7 : 
          return o(a0, a1, a2, a3, a4, a5, a6);
      
    }
  }
}

function _7(o, a0, a1, a2, a3, a4, a5, a6) {
  var arity = o.length;
  if (arity === 7) {
    return o(a0, a1, a2, a3, a4, a5, a6);
  }
  else {
    return curry_7(o, a0, a1, a2, a3, a4, a5, a6, arity);
  }
}

function js7(label, cacheid, a0, a1, a2, a3, a4, a5, a6) {
  return _7(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1, a2, a3, a4, a5, a6);
}

function __7(o) {
  var arity = o.length;
  if (arity === 7) {
    return o;
  }
  else {
    return function (a0, a1, a2, a3, a4, a5, a6) {
      return _7(o, a0, a1, a2, a3, a4, a5, a6);
    };
  }
}

function curry_8(o, a0, a1, a2, a3, a4, a5, a6, a7, arity) {
  if (arity > 7 || arity < 0) {
    return app(o, /* array */[
                a0,
                a1,
                a2,
                a3,
                a4,
                a5,
                a6,
                a7
              ]);
  }
  else {
    switch (arity) {
      case 0 : 
      case 1 : 
          return app(o(a0), /* array */[
                      a1,
                      a2,
                      a3,
                      a4,
                      a5,
                      a6,
                      a7
                    ]);
      case 2 : 
          return app(o(a0, a1), /* array */[
                      a2,
                      a3,
                      a4,
                      a5,
                      a6,
                      a7
                    ]);
      case 3 : 
          return app(o(a0, a1, a2), /* array */[
                      a3,
                      a4,
                      a5,
                      a6,
                      a7
                    ]);
      case 4 : 
          return app(o(a0, a1, a2, a3), /* array */[
                      a4,
                      a5,
                      a6,
                      a7
                    ]);
      case 5 : 
          return app(o(a0, a1, a2, a3, a4), /* array */[
                      a5,
                      a6,
                      a7
                    ]);
      case 6 : 
          return app(o(a0, a1, a2, a3, a4, a5), /* array */[
                      a6,
                      a7
                    ]);
      case 7 : 
          return app(o(a0, a1, a2, a3, a4, a5, a6), /* array */[a7]);
      
    }
  }
}

function _8(o, a0, a1, a2, a3, a4, a5, a6, a7) {
  var arity = o.length;
  if (arity === 8) {
    return o(a0, a1, a2, a3, a4, a5, a6, a7);
  }
  else {
    return curry_8(o, a0, a1, a2, a3, a4, a5, a6, a7, arity);
  }
}

function js8(label, cacheid, a0, a1, a2, a3, a4, a5, a6, a7) {
  return _8(Caml_oo.caml_get_public_method(a0, label, cacheid), a0, a1, a2, a3, a4, a5, a6, a7);
}

function __8(o) {
  var arity = o.length;
  if (arity === 8) {
    return o;
  }
  else {
    return function (a0, a1, a2, a3, a4, a5, a6, a7) {
      return _8(o, a0, a1, a2, a3, a4, a5, a6, a7);
    };
  }
}

exports.app     = app;
exports.js      = js;
exports.curry_1 = curry_1;
exports._1      = _1;
exports.js1     = js1;
exports.__1     = __1;
exports.curry_2 = curry_2;
exports._2      = _2;
exports.js2     = js2;
exports.__2     = __2;
exports.curry_3 = curry_3;
exports._3      = _3;
exports.js3     = js3;
exports.__3     = __3;
exports.curry_4 = curry_4;
exports._4      = _4;
exports.js4     = js4;
exports.__4     = __4;
exports.curry_5 = curry_5;
exports._5      = _5;
exports.js5     = js5;
exports.__5     = __5;
exports.curry_6 = curry_6;
exports._6      = _6;
exports.js6     = js6;
exports.__6     = __6;
exports.curry_7 = curry_7;
exports._7      = _7;
exports.js7     = js7;
exports.__7     = __7;
exports.curry_8 = curry_8;
exports._8      = _8;
exports.js8     = js8;
exports.__8     = __8;
/* No side effect */
//////// end of curry.js ////////
    return exports;
  };


  _registry['decode'] = function() {
    let exports = {};
//////// start of decode.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var F32             = require("./f32");
var F64             = require("./f64");
var I32             = require("./i32");
var Lib             = require("./lib");
var List            = require("bs-platform/lib/js/list");
var Block           = require("bs-platform/lib/js/block");
var Curry           = require("bs-platform/lib/js/curry");
var $$Error         = require("./error");
var Encode          = require("./encode");
var Printf          = require("bs-platform/lib/js/printf");
var Source          = require("./source");
var $$String        = require("bs-platform/lib/js/string");
var Caml_obj        = require("bs-platform/lib/js/caml_obj");
var Operators       = require("./operators");
var Caml_int64      = require("bs-platform/lib/js/caml_int64");
var Caml_string     = require("bs-platform/lib/js/caml_string");
var Caml_exceptions = require("bs-platform/lib/js/caml_exceptions");

var EOS = Caml_exceptions.create("Decode.EOS");

function stream(name, bs) {
  return /* record */[
          /* name */name,
          /* bytes */bs,
          /* pos */[0]
        ];
}

function eos(s) {
  return +(s[/* pos */2][0] === s[/* bytes */1].length);
}

function check(n, s) {
  if ((s[/* pos */2][0] + n | 0) > s[/* bytes */1].length) {
    throw EOS;
  }
  else {
    return 0;
  }
}

function skip(n, s) {
  check(n, s);
  s[/* pos */2][0] = s[/* pos */2][0] + n | 0;
  return /* () */0;
}

function read(s) {
  return Caml_string.get(s[/* bytes */1], s[/* pos */2][0]);
}

function peek(s) {
  if (eos(s)) {
    return /* None */0;
  }
  else {
    return /* Some */[read(s)];
  }
}

function get(s) {
  check(1, s);
  var b = read(s);
  skip(1, s);
  return b;
}

var Code = $$Error.Make(/* module */[]);

var Code$1 = Code[/* Error */0];

function string_of_byte(b) {
  return Curry._1(Printf.sprintf(/* Format */[
                  /* Int */Block.__(4, [
                      /* Int_x */6,
                      /* Lit_padding */Block.__(0, [
                          /* Zeros */2,
                          2
                        ]),
                      /* No_precision */0,
                      /* End_of_format */0
                    ]),
                  "%02x"
                ]), b);
}

function position(s, pos) {
  return /* record */[
          /* file */s[/* name */0],
          /* line */-1,
          /* column */pos
        ];
}

function region(s, left, right) {
  return /* record */[
          /* left */position(s, left),
          /* right */position(s, right)
        ];
}

function error(s, pos, msg) {
  throw [
        Code$1,
        region(s, pos, pos),
        msg
      ];
}

function $$require(b, s, pos, msg) {
  if (b) {
    return 0;
  }
  else {
    return error(s, pos, msg);
  }
}

function guard(f, s) {
  try {
    return Curry._1(f, s);
  }
  catch (exn){
    if (exn === EOS) {
      return error(s, s[/* bytes */1].length, "unexpected end of binary or function");
    }
    else {
      throw exn;
    }
  }
}

function get$1(param) {
  return guard(get, param);
}

function expect(b, s, msg) {
  return $$require(+(guard(get$1, s) === b), s, s[/* pos */2][0] - 1 | 0, msg);
}

function illegal(s, pos, b) {
  return error(s, pos, "illegal opcode " + string_of_byte(b));
}

function at(f, s) {
  var left = s[/* pos */2][0];
  var x = Curry._1(f, s);
  var right = s[/* pos */2][0];
  return Source.$at$at(x, region(s, left, right));
}

function u16(s) {
  var lo = guard(get, s);
  var hi = guard(get, s);
  return (hi << 8) + lo | 0;
}

function u32(s) {
  var lo = u16(s);
  var hi = u16(s);
  return lo + (hi << 16) | 0;
}

function u64(s) {
  var lo = Caml_int64.of_int32(u32(s));
  var hi = Caml_int64.of_int32(u32(s));
  return Caml_int64.add(lo, Caml_int64.lsl_(hi, 32));
}

function vuN(n, s) {
  $$require(+(n > 0), s, s[/* pos */2][0], "integer representation too long");
  var b = guard(get, s);
  $$require(+(n >= 7 || (b & 127) < (1 << n)), s, s[/* pos */2][0] - 1 | 0, "integer too large");
  var x = Caml_int64.of_int32(b & 127);
  if (b & 128) {
    return Caml_int64.or_(x, Caml_int64.lsl_(vuN(n - 7 | 0, s), 7));
  }
  else {
    return x;
  }
}

function vsN(n, s) {
  $$require(+(n > 0), s, s[/* pos */2][0], "integer representation too long");
  var b = guard(get, s);
  var mask = (-1 << n) & 127;
  $$require(+(n >= 7 || (b & mask) === 0 || (b & mask) === mask), s, s[/* pos */2][0] - 1 | 0, "integer too large");
  var x = Caml_int64.of_int32(b & 127);
  if (b & 128) {
    return Caml_int64.or_(x, Caml_int64.lsl_(vsN(n - 7 | 0, s), 7));
  }
  else if (b & 64) {
    return /* int64 */[
            /* hi */x[0] | /* hi */-1,
            /* lo */((x[1] | /* lo */4294967168) >>> 0)
          ];
  }
  else {
    return x;
  }
}

function vu32(s) {
  return vuN(32, s)[1] | 0;
}

function vs32(s) {
  return vsN(32, s)[1] | 0;
}

function vs64(s) {
  return vsN(64, s);
}

function f32(s) {
  return Curry._1(F32.of_bits, u32(s));
}

function f64(s) {
  return Curry._1(F64.of_bits, u64(s));
}

function len32(s) {
  var pos = s[/* pos */2][0];
  var n = vuN(32, s)[1] | 0;
  if (n <= s[/* bytes */1].length) {
    return n;
  }
  else {
    return error(s, pos, "length out of bounds");
  }
}

function string(s) {
  var n = len32(s);
  return guard(function (param) {
              var n$1 = n;
              var s = param;
              var i = s[/* pos */2][0];
              skip(n$1, s);
              return $$String.sub(s[/* bytes */1], i, n$1);
            }, s);
}

function list(f, n, s) {
  if (n) {
    var x = Curry._1(f, s);
    return /* :: */[
            x,
            list(f, n - 1 | 0, s)
          ];
  }
  else {
    return /* [] */0;
  }
}

function opt(f, b, s) {
  if (b) {
    return /* Some */[Curry._1(f, s)];
  }
  else {
    return /* None */0;
  }
}

function vec(f, s) {
  var n = len32(s);
  return list(f, n, s);
}

function sized(f, s) {
  var size = len32(s);
  var start = s[/* pos */2][0];
  var x = Curry._2(f, size, s);
  $$require(+(s[/* pos */2][0] === (start + size | 0)), s, start, "section size mismatch");
  return x;
}

function value_type(s) {
  var match = vsN(7, s)[1] | 0;
  var switcher = match + 4 | 0;
  if (switcher > 3 || switcher < 0) {
    return error(s, s[/* pos */2][0] - 1 | 0, "invalid value type");
  }
  else {
    switch (switcher) {
      case 0 : 
          return /* F64Type */3;
      case 1 : 
          return /* F32Type */2;
      case 2 : 
          return /* I64Type */1;
      case 3 : 
          return /* I32Type */0;
      
    }
  }
}

function elem_type(s) {
  var match = vsN(7, s)[1] | 0;
  if (match !== -16) {
    return error(s, s[/* pos */2][0] - 1 | 0, "invalid element type");
  }
  else {
    return /* AnyFuncType */0;
  }
}

function stack_type(s) {
  var match = peek(s);
  if (match) {
    if (match[0] !== 64) {
      return /* :: */[
              value_type(s),
              /* [] */0
            ];
    }
    else {
      guard(function (param) {
            return skip(1, param);
          }, s);
      return /* [] */0;
    }
  }
  else {
    return /* :: */[
            value_type(s),
            /* [] */0
          ];
  }
}

function func_type(s) {
  var match = vsN(7, s)[1] | 0;
  if (match !== -32) {
    return error(s, s[/* pos */2][0] - 1 | 0, "invalid function type");
  }
  else {
    var ins = vec(value_type, s);
    var out = vec(value_type, s);
    return /* FuncType */[
            ins,
            out
          ];
  }
}

function limits(vu, s) {
  var has_max = +((vuN(1, s)[1] | 0) === 1);
  var min = Curry._1(vu, s);
  var max = opt(vu, has_max, s);
  return /* record */[
          /* min */min,
          /* max */max
        ];
}

function table_type(s) {
  var t = elem_type(s);
  var lim = limits(vu32, s);
  return /* TableType */[
          lim,
          t
        ];
}

function memory_type(s) {
  var lim = limits(vu32, s);
  return /* MemoryType */[lim];
}

function mutability(s) {
  var match = guard(get, s);
  if (match !== 0) {
    if (match !== 1) {
      return error(s, s[/* pos */2][0] - 1 | 0, "invalid mutability");
    }
    else {
      return /* Mutable */1;
    }
  }
  else {
    return /* Immutable */0;
  }
}

function global_type(s) {
  var t = value_type(s);
  var mut = mutability(s);
  return /* GlobalType */[
          t,
          mut
        ];
}

function $$var(s) {
  return vuN(32, s)[1] | 0;
}

function memop(s) {
  var align = vuN(32, s)[1] | 0;
  $$require(Curry._2(I32.le_u, align, 32), s, s[/* pos */2][0] - 1 | 0, "invalid memop flags");
  var offset = vuN(32, s)[1] | 0;
  return /* tuple */[
          align,
          offset
        ];
}

function instr(s) {
  var pos = s[/* pos */2][0];
  var b = guard(get, s);
  if (b > 191 || b < 0) {
    return illegal(s, pos, b);
  }
  else {
    switch (b) {
      case 0 : 
          return Operators.unreachable;
      case 1 : 
          return Operators.nop;
      case 2 : 
          var ts = stack_type(s);
          var es$prime = List.rev(instr_block$prime(s, /* [] */0));
          expect(11, s, "END opcode expected");
          return Operators.block(ts, es$prime);
      case 3 : 
          var ts$1 = stack_type(s);
          var es$prime$1 = List.rev(instr_block$prime(s, /* [] */0));
          expect(11, s, "END opcode expected");
          return Operators.loop(ts$1, es$prime$1);
      case 4 : 
          var ts$2 = stack_type(s);
          var es1 = List.rev(instr_block$prime(s, /* [] */0));
          if (Caml_obj.caml_equal(peek(s), /* Some */[5])) {
            expect(5, s, "ELSE or END opcode expected");
            var es2 = List.rev(instr_block$prime(s, /* [] */0));
            expect(11, s, "END opcode expected");
            return Operators.if_(ts$2, es1, es2);
          }
          else {
            expect(11, s, "END opcode expected");
            return Operators.if_(ts$2, es1, /* [] */0);
          }
          break;
      case 5 : 
          return error(s, pos, "misplaced ELSE opcode");
      case 11 : 
          return error(s, pos, "misplaced END opcode");
      case 12 : 
          return Operators.br(at($$var, s));
      case 13 : 
          return Operators.br_if(at($$var, s));
      case 14 : 
          var xs = vec(function (param) {
                return at($$var, param);
              }, s);
          var x = at($$var, s);
          return Operators.br_table(xs, x);
      case 15 : 
          return Operators.$$return;
      case 16 : 
          return Operators.call(at($$var, s));
      case 17 : 
          var x$1 = at($$var, s);
          expect(0, s, "zero flag expected");
          return Operators.call_indirect(x$1);
      case 26 : 
          return Operators.drop;
      case 27 : 
          return Operators.select;
      case 32 : 
          return Operators.get_local(at($$var, s));
      case 33 : 
          return Operators.set_local(at($$var, s));
      case 34 : 
          return Operators.tee_local(at($$var, s));
      case 35 : 
          return Operators.get_global(at($$var, s));
      case 36 : 
          return Operators.set_global(at($$var, s));
      case 6 : 
      case 7 : 
      case 8 : 
      case 9 : 
      case 10 : 
      case 18 : 
      case 19 : 
      case 20 : 
      case 21 : 
      case 22 : 
      case 23 : 
      case 24 : 
      case 25 : 
      case 28 : 
      case 29 : 
      case 30 : 
      case 31 : 
      case 37 : 
      case 38 : 
      case 39 : 
          return illegal(s, pos, b);
      case 40 : 
          var match = memop(s);
          return Operators.i32_load(match[0], match[1]);
      case 41 : 
          var match$1 = memop(s);
          return Operators.i64_load(match$1[0], match$1[1]);
      case 42 : 
          var match$2 = memop(s);
          return Operators.f32_load(match$2[0], match$2[1]);
      case 43 : 
          var match$3 = memop(s);
          return Operators.f64_load(match$3[0], match$3[1]);
      case 44 : 
          var match$4 = memop(s);
          return Operators.i32_load8_s(match$4[0], match$4[1]);
      case 45 : 
          var match$5 = memop(s);
          return Operators.i32_load8_u(match$5[0], match$5[1]);
      case 46 : 
          var match$6 = memop(s);
          return Operators.i32_load16_s(match$6[0], match$6[1]);
      case 47 : 
          var match$7 = memop(s);
          return Operators.i32_load16_u(match$7[0], match$7[1]);
      case 48 : 
          var match$8 = memop(s);
          return Operators.i64_load8_s(match$8[0], match$8[1]);
      case 49 : 
          var match$9 = memop(s);
          return Operators.i64_load8_u(match$9[0], match$9[1]);
      case 50 : 
          var match$10 = memop(s);
          return Operators.i64_load16_s(match$10[0], match$10[1]);
      case 51 : 
          var match$11 = memop(s);
          return Operators.i64_load16_u(match$11[0], match$11[1]);
      case 52 : 
          var match$12 = memop(s);
          return Operators.i64_load32_s(match$12[0], match$12[1]);
      case 53 : 
          var match$13 = memop(s);
          return Operators.i64_load32_u(match$13[0], match$13[1]);
      case 54 : 
          var match$14 = memop(s);
          return Operators.i32_store(match$14[0], match$14[1]);
      case 55 : 
          var match$15 = memop(s);
          return Operators.i64_store(match$15[0], match$15[1]);
      case 56 : 
          var match$16 = memop(s);
          return Operators.f32_store(match$16[0], match$16[1]);
      case 57 : 
          var match$17 = memop(s);
          return Operators.f64_store(match$17[0], match$17[1]);
      case 58 : 
          var match$18 = memop(s);
          return Operators.i32_store8(match$18[0], match$18[1]);
      case 59 : 
          var match$19 = memop(s);
          return Operators.i32_store16(match$19[0], match$19[1]);
      case 60 : 
          var match$20 = memop(s);
          return Operators.i64_store8(match$20[0], match$20[1]);
      case 61 : 
          var match$21 = memop(s);
          return Operators.i64_store16(match$21[0], match$21[1]);
      case 62 : 
          var match$22 = memop(s);
          return Operators.i64_store32(match$22[0], match$22[1]);
      case 63 : 
          expect(0, s, "zero flag expected");
          return Operators.current_memory;
      case 64 : 
          expect(0, s, "zero flag expected");
          return Operators.grow_memory;
      case 65 : 
          return Operators.i32_const(at(vs32, s));
      case 66 : 
          return Operators.i64_const(at(vs64, s));
      case 67 : 
          return Operators.f32_const(at(f32, s));
      case 68 : 
          return Operators.f64_const(at(f64, s));
      case 69 : 
          return Operators.i32_eqz;
      case 70 : 
          return Operators.i32_eq;
      case 71 : 
          return Operators.i32_ne;
      case 72 : 
          return Operators.i32_lt_s;
      case 73 : 
          return Operators.i32_lt_u;
      case 74 : 
          return Operators.i32_gt_s;
      case 75 : 
          return Operators.i32_gt_u;
      case 76 : 
          return Operators.i32_le_s;
      case 77 : 
          return Operators.i32_le_u;
      case 78 : 
          return Operators.i32_ge_s;
      case 79 : 
          return Operators.i32_ge_u;
      case 80 : 
          return Operators.i64_eqz;
      case 81 : 
          return Operators.i64_eq;
      case 82 : 
          return Operators.i64_ne;
      case 83 : 
          return Operators.i64_lt_s;
      case 84 : 
          return Operators.i64_lt_u;
      case 85 : 
          return Operators.i64_gt_s;
      case 86 : 
          return Operators.i64_gt_u;
      case 87 : 
          return Operators.i64_le_s;
      case 88 : 
          return Operators.i64_le_u;
      case 89 : 
          return Operators.i64_ge_s;
      case 90 : 
          return Operators.i64_ge_u;
      case 91 : 
          return Operators.f32_eq;
      case 92 : 
          return Operators.f32_ne;
      case 93 : 
          return Operators.f32_lt;
      case 94 : 
          return Operators.f32_gt;
      case 95 : 
          return Operators.f32_le;
      case 96 : 
          return Operators.f32_ge;
      case 97 : 
          return Operators.f64_eq;
      case 98 : 
          return Operators.f64_ne;
      case 99 : 
          return Operators.f64_lt;
      case 100 : 
          return Operators.f64_gt;
      case 101 : 
          return Operators.f64_le;
      case 102 : 
          return Operators.f64_ge;
      case 103 : 
          return Operators.i32_clz;
      case 104 : 
          return Operators.i32_ctz;
      case 105 : 
          return Operators.i32_popcnt;
      case 106 : 
          return Operators.i32_add;
      case 107 : 
          return Operators.i32_sub;
      case 108 : 
          return Operators.i32_mul;
      case 109 : 
          return Operators.i32_div_s;
      case 110 : 
          return Operators.i32_div_u;
      case 111 : 
          return Operators.i32_rem_s;
      case 112 : 
          return Operators.i32_rem_u;
      case 113 : 
          return Operators.i32_and;
      case 114 : 
          return Operators.i32_or;
      case 115 : 
          return Operators.i32_xor;
      case 116 : 
          return Operators.i32_shl;
      case 117 : 
          return Operators.i32_shr_s;
      case 118 : 
          return Operators.i32_shr_u;
      case 119 : 
          return Operators.i32_rotl;
      case 120 : 
          return Operators.i32_rotr;
      case 121 : 
          return Operators.i64_clz;
      case 122 : 
          return Operators.i64_ctz;
      case 123 : 
          return Operators.i64_popcnt;
      case 124 : 
          return Operators.i64_add;
      case 125 : 
          return Operators.i64_sub;
      case 126 : 
          return Operators.i64_mul;
      case 127 : 
          return Operators.i64_div_s;
      case 128 : 
          return Operators.i64_div_u;
      case 129 : 
          return Operators.i64_rem_s;
      case 130 : 
          return Operators.i64_rem_u;
      case 131 : 
          return Operators.i64_and;
      case 132 : 
          return Operators.i64_or;
      case 133 : 
          return Operators.i64_xor;
      case 134 : 
          return Operators.i64_shl;
      case 135 : 
          return Operators.i64_shr_s;
      case 136 : 
          return Operators.i64_shr_u;
      case 137 : 
          return Operators.i64_rotl;
      case 138 : 
          return Operators.i64_rotr;
      case 139 : 
          return Operators.f32_abs;
      case 140 : 
          return Operators.f32_neg;
      case 141 : 
          return Operators.f32_ceil;
      case 142 : 
          return Operators.f32_floor;
      case 143 : 
          return Operators.f32_trunc;
      case 144 : 
          return Operators.f32_nearest;
      case 145 : 
          return Operators.f32_sqrt;
      case 146 : 
          return Operators.f32_add;
      case 147 : 
          return Operators.f32_sub;
      case 148 : 
          return Operators.f32_mul;
      case 149 : 
          return Operators.f32_div;
      case 150 : 
          return Operators.f32_min;
      case 151 : 
          return Operators.f32_max;
      case 152 : 
          return Operators.f32_copysign;
      case 153 : 
          return Operators.f64_abs;
      case 154 : 
          return Operators.f64_neg;
      case 155 : 
          return Operators.f64_ceil;
      case 156 : 
          return Operators.f64_floor;
      case 157 : 
          return Operators.f64_trunc;
      case 158 : 
          return Operators.f64_nearest;
      case 159 : 
          return Operators.f64_sqrt;
      case 160 : 
          return Operators.f64_add;
      case 161 : 
          return Operators.f64_sub;
      case 162 : 
          return Operators.f64_mul;
      case 163 : 
          return Operators.f64_div;
      case 164 : 
          return Operators.f64_min;
      case 165 : 
          return Operators.f64_max;
      case 166 : 
          return Operators.f64_copysign;
      case 167 : 
          return Operators.i32_wrap_i64;
      case 168 : 
          return Operators.i32_trunc_s_f32;
      case 169 : 
          return Operators.i32_trunc_u_f32;
      case 170 : 
          return Operators.i32_trunc_s_f64;
      case 171 : 
          return Operators.i32_trunc_u_f64;
      case 172 : 
          return Operators.i64_extend_s_i32;
      case 173 : 
          return Operators.i64_extend_u_i32;
      case 174 : 
          return Operators.i64_trunc_s_f32;
      case 175 : 
          return Operators.i64_trunc_u_f32;
      case 176 : 
          return Operators.i64_trunc_s_f64;
      case 177 : 
          return Operators.i64_trunc_u_f64;
      case 178 : 
          return Operators.f32_convert_s_i32;
      case 179 : 
          return Operators.f32_convert_u_i32;
      case 180 : 
          return Operators.f32_convert_s_i64;
      case 181 : 
          return Operators.f32_convert_u_i64;
      case 182 : 
          return Operators.f32_demote_f64;
      case 183 : 
          return Operators.f64_convert_s_i32;
      case 184 : 
          return Operators.f64_convert_u_i32;
      case 185 : 
          return Operators.f64_convert_s_i64;
      case 186 : 
          return Operators.f64_convert_u_i64;
      case 187 : 
          return Operators.f64_promote_f32;
      case 188 : 
          return Operators.i32_reinterpret_f32;
      case 189 : 
          return Operators.i64_reinterpret_f64;
      case 190 : 
          return Operators.f32_reinterpret_i32;
      case 191 : 
          return Operators.f64_reinterpret_i64;
      
    }
  }
}

function instr_block$prime(s, _es) {
  while(true) {
    var es = _es;
    var match = peek(s);
    if (match) {
      var match$1 = match[0];
      if (match$1 !== 5) {
        if (match$1 !== 11) {
          var pos = s[/* pos */2][0];
          var e$prime = instr(s);
          _es = /* :: */[
            Source.$at$at(e$prime, region(s, pos, pos)),
            es
          ];
          continue ;
          
        }
        else {
          return es;
        }
      }
      else {
        return es;
      }
    }
    else {
      return es;
    }
  };
}

function instr_block(s) {
  return List.rev(instr_block$prime(s, /* [] */0));
}

function $$const(s) {
  var c = at(instr_block, s);
  expect(11, s, "END opcode expected");
  return c;
}

function id(s) {
  var bo = peek(s);
  return Curry._2(Lib.Option[/* map */1], function (param) {
              if (param > 11 || param < 0) {
                return error(s, s[/* pos */2][0], "invalid section id");
              }
              else {
                switch (param) {
                  case 0 : 
                      return /* CustomSection */-808010220;
                  case 1 : 
                      return /* TypeSection */836501035;
                  case 2 : 
                      return /* ImportSection */696517344;
                  case 3 : 
                      return /* FuncSection */205556449;
                  case 4 : 
                      return /* TableSection */1031864215;
                  case 5 : 
                      return /* MemorySection */-840203068;
                  case 6 : 
                      return /* GlobalSection */-872313182;
                  case 7 : 
                      return /* ExportSection */-440679759;
                  case 8 : 
                      return /* StartSection */395720131;
                  case 9 : 
                      return /* ElemSection */440380662;
                  case 10 : 
                      return /* CodeSection */1021133848;
                  case 11 : 
                      return /* DataSection */66447547;
                  
                }
              }
            }, bo);
}

function section_with_size(tag, f, $$default, s) {
  var match = id(s);
  if (match && Caml_obj.caml_equal(match[0], tag)) {
    guard(get, s);
    return sized(f, s);
  }
  else {
    return $$default;
  }
}

function section(tag, f, $$default, s) {
  return section_with_size(tag, function () {
              return f;
            }, $$default, s);
}

function type_section(s) {
  return section(/* TypeSection */836501035, function (param) {
              return vec(func_type, param);
            }, /* [] */0, s);
}

function import_kind(s) {
  var match = guard(get, s);
  if (match > 3 || match < 0) {
    return error(s, s[/* pos */2][0] - 1 | 0, "invalid import kind");
  }
  else {
    switch (match) {
      case 0 : 
          return /* FuncImport */Block.__(0, [at($$var, s)]);
      case 1 : 
          return /* TableImport */Block.__(1, [table_type(s)]);
      case 2 : 
          return /* MemoryImport */Block.__(2, [memory_type(s)]);
      case 3 : 
          return /* GlobalImport */Block.__(3, [global_type(s)]);
      
    }
  }
}

function $$import(s) {
  var module_name = string(s);
  var item_name = string(s);
  var ikind = at(import_kind, s);
  return /* record */[
          /* module_name */module_name,
          /* item_name */item_name,
          /* ikind */ikind
        ];
}

function import_section(s) {
  return section(/* ImportSection */696517344, function (param) {
              return vec(function (param) {
                          return at($$import, param);
                        }, param);
            }, /* [] */0, s);
}

function func_section(s) {
  return section(/* FuncSection */205556449, function (param) {
              return vec(function (param) {
                          return at($$var, param);
                        }, param);
            }, /* [] */0, s);
}

function table(s) {
  var ttype = table_type(s);
  return /* record */[/* ttype */ttype];
}

function table_section(s) {
  return section(/* TableSection */1031864215, function (param) {
              return vec(function (param) {
                          return at(table, param);
                        }, param);
            }, /* [] */0, s);
}

function memory(s) {
  var mtype = memory_type(s);
  return /* record */[/* mtype */mtype];
}

function memory_section(s) {
  return section(/* MemorySection */-840203068, function (param) {
              return vec(function (param) {
                          return at(memory, param);
                        }, param);
            }, /* [] */0, s);
}

function global(s) {
  var gtype = global_type(s);
  var value = $$const(s);
  return /* record */[
          /* gtype */gtype,
          /* value */value
        ];
}

function global_section(s) {
  return section(/* GlobalSection */-872313182, function (param) {
              return vec(function (param) {
                          return at(global, param);
                        }, param);
            }, /* [] */0, s);
}

function export_kind(s) {
  var match = guard(get, s);
  if (match > 3 || match < 0) {
    return error(s, s[/* pos */2][0] - 1 | 0, "invalid export kind");
  }
  else {
    switch (match) {
      case 0 : 
          return /* FuncExport */0;
      case 1 : 
          return /* TableExport */1;
      case 2 : 
          return /* MemoryExport */2;
      case 3 : 
          return /* GlobalExport */3;
      
    }
  }
}

function $$export(s) {
  var name = string(s);
  var ekind = at(export_kind, s);
  var item = at($$var, s);
  return /* record */[
          /* name */name,
          /* ekind */ekind,
          /* item */item
        ];
}

function export_section(s) {
  return section(/* ExportSection */-440679759, function (param) {
              return vec(function (param) {
                          return at($$export, param);
                        }, param);
            }, /* [] */0, s);
}

function start_section(s) {
  return section(/* StartSection */395720131, function (param) {
              return /* Some */[at($$var, param)];
            }, /* None */0, s);
}

function local(s) {
  var n = len32(s);
  var t = value_type(s);
  return Curry._2(Lib.List[/* make */0], n, t);
}

function code(_, s) {
  var locals = List.flatten(vec(local, s));
  var body = List.rev(instr_block$prime(s, /* [] */0));
  expect(11, s, "END opcode expected");
  return /* record */[
          /* ftype */Source.$at$at(-1, Source.no_region),
          /* locals */locals,
          /* body */body
        ];
}

function code_section(s) {
  return section(/* CodeSection */1021133848, function (param) {
              return vec(function (param) {
                          return at(function (param) {
                                      return sized(code, param);
                                    }, param);
                        }, param);
            }, /* [] */0, s);
}

function segment(dat, s) {
  var index = at($$var, s);
  var offset = $$const(s);
  var init = Curry._1(dat, s);
  return /* record */[
          /* index */index,
          /* offset */offset,
          /* init */init
        ];
}

function table_segment(s) {
  return segment(function (param) {
              return vec(function (param) {
                          return at($$var, param);
                        }, param);
            }, s);
}

function elem_section(s) {
  return section(/* ElemSection */440380662, function (param) {
              return vec(function (param) {
                          return at(table_segment, param);
                        }, param);
            }, /* [] */0, s);
}

function memory_segment(s) {
  return segment(string, s);
}

function data_section(s) {
  return section(/* DataSection */66447547, function (param) {
              return vec(function (param) {
                          return at(memory_segment, param);
                        }, param);
            }, /* [] */0, s);
}

function custom(size, s) {
  var start = s[/* pos */2][0];
  string(s);
  var partial_arg = size - (s[/* pos */2][0] - start | 0) | 0;
  var partial_arg$1 = function (param) {
    return skip(partial_arg, param);
  };
  (function (param) {
        return guard(partial_arg$1, param);
      }(s));
  return /* true */1;
}

function custom_section(s) {
  return section_with_size(/* CustomSection */-808010220, custom, /* false */0, s);
}

function iterate(f, s) {
  while(true) {
    if (Curry._1(f, s)) {
      continue ;
      
    }
    else {
      return 0;
    }
  };
}

function module_(s) {
  var magic = u32(s);
  $$require(+(magic === 1836278016), s, 0, "magic header not detected");
  var version = u32(s);
  $$require(+(version === Encode.version), s, 4, "unknown binary version");
  iterate(custom_section, s);
  var types = type_section(s);
  iterate(custom_section, s);
  var imports = import_section(s);
  iterate(custom_section, s);
  var func_types = func_section(s);
  iterate(custom_section, s);
  var tables = table_section(s);
  iterate(custom_section, s);
  var memories = memory_section(s);
  iterate(custom_section, s);
  var globals = global_section(s);
  iterate(custom_section, s);
  var $$exports = export_section(s);
  iterate(custom_section, s);
  var start = start_section(s);
  iterate(custom_section, s);
  var elems = elem_section(s);
  iterate(custom_section, s);
  var func_bodies = code_section(s);
  iterate(custom_section, s);
  var data = data_section(s);
  iterate(custom_section, s);
  $$require(+(s[/* pos */2][0] === s[/* bytes */1].length), s, s[/* bytes */1].length, "junk after last section");
  $$require(+(List.length(func_types) === List.length(func_bodies)), s, s[/* bytes */1].length, "function and code section have inconsistent lengths");
  var funcs = List.map2(function (t, f) {
        var init = f[/* it */1];
        return Source.$at$at(/* record */[
                    /* ftype */t,
                    /* locals */init[/* locals */1],
                    /* body */init[/* body */2]
                  ], f[/* at */0]);
      }, func_types, func_bodies);
  return /* record */[
          /* types */types,
          /* globals */globals,
          /* tables */tables,
          /* memories */memories,
          /* funcs */funcs,
          /* start */start,
          /* elems */elems,
          /* data */data,
          /* imports */imports,
          /* exports */$$exports
        ];
}

function decode(name, bs) {
  return at(module_, stream(name, bs));
}

exports.Code   = Code$1;
exports.decode = decode;
/* Code Not a pure module */
//////// end of decode.js ////////
    return exports;
  };


  _registry['encode'] = function() {
    let exports = {};
//////// start of encode.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var F32                     = require("./f32");
var F64                     = require("./f64");
var Lib                     = require("./lib");
var Char                    = require("bs-platform/lib/js/char");
var List                    = require("bs-platform/lib/js/list");
var Bytes                   = require("bs-platform/lib/js/bytes");
var Curry                   = require("bs-platform/lib/js/curry");
var $$Error                 = require("./error");
var Buffer                  = require("bs-platform/lib/js/buffer");
var Source                  = require("./source");
var Caml_obj                = require("bs-platform/lib/js/caml_obj");
var Caml_int64              = require("bs-platform/lib/js/caml_int64");
var Caml_builtin_exceptions = require("bs-platform/lib/js/caml_builtin_exceptions");

var Code = $$Error.Make(/* module */[]);

var Code$1 = Code[/* Error */0];

function stream() {
  return /* record */[
          /* buf */Buffer.create(8192),
          /* patches */[/* [] */0]
        ];
}

function patch(s, pos, b) {
  s[/* patches */1][0] = /* :: */[
    /* tuple */[
      pos,
      b
    ],
    s[/* patches */1][0]
  ];
  return /* () */0;
}

function encode(m) {
  var s = stream(/* () */0);
  var u8 = function (i) {
    var b = Char.chr(i & 255);
    return Buffer.add_char(s[/* buf */0], b);
  };
  var u16 = function (i) {
    u8(i & 255);
    return u8((i >>> 8));
  };
  var u32 = function (i) {
    u16(i & 65535);
    return u16((i >> 16));
  };
  var vu64 = function (_i) {
    while(true) {
      var i = _i;
      var b = i[1] & /* lo */127 | 0;
      if (Caml_int64.le(/* int64 */[
              /* hi */0,
              /* lo */0
            ], i) && Caml_int64.lt(i, /* int64 */[
              /* hi */0,
              /* lo */128
            ])) {
        return u8(b);
      }
      else {
        u8(b | 128);
        _i = Caml_int64.lsr_(i, 7);
        continue ;
        
      }
    };
  };
  var vs64 = function (_i) {
    while(true) {
      var i = _i;
      var b = i[1] & /* lo */127 | 0;
      if (Caml_int64.le(/* int64 */[
              /* hi */-1,
              /* lo */4294967232
            ], i) && Caml_int64.lt(i, /* int64 */[
              /* hi */0,
              /* lo */64
            ])) {
        return u8(b);
      }
      else {
        u8(b | 128);
        _i = Caml_int64.asr_(i, 7);
        continue ;
        
      }
    };
  };
  var vu32 = function (i) {
    return vu64(Caml_int64.and_(Caml_int64.of_int32(i), /* int64 */[
                    /* hi */0,
                    /* lo */4294967295
                  ]));
  };
  var len = function (i) {
    if (i !== i) {
      Curry._2(Code[/* error */2], Source.no_region, "cannot encode length with more than 32 bit");
    }
    return vu32(i);
  };
  var bool = function (b) {
    var i = b ? 1 : 0;
    return vu64(Caml_int64.and_(Caml_int64.of_int32(i), /* int64 */[
                    /* hi */0,
                    /* lo */1
                  ]));
  };
  var string = function (bs) {
    len(bs.length);
    return Buffer.add_string(s[/* buf */0], bs);
  };
  var vec = function (f, xs) {
    len(List.length(xs));
    return List.iter(f, xs);
  };
  var gap32 = function () {
    var p = Buffer.length(s[/* buf */0]);
    u32(0);
    u8(0);
    return p;
  };
  var patch_gap32 = function (p, n) {
    if (n > 268435455) {
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
              80,
              6
            ]
          ];
    }
    patch(s, p, Char.chr((n | 128) & 255));
    patch(s, p + 1 | 0, Char.chr(((n >>> 7) | 128) & 255));
    patch(s, p + 2 | 0, Char.chr(((n >>> 14) | 128) & 255));
    patch(s, p + 3 | 0, Char.chr(((n >>> 21) | 128) & 255));
    return patch(s, p + 4 | 0, Char.chr((n >>> 28) & 255));
  };
  var value_type = function (param) {
    switch (param) {
      case 0 : 
          return vs64(/* int64 */[
                      /* hi */-1,
                      /* lo */4294967295
                    ]);
      case 1 : 
          return vs64(/* int64 */[
                      /* hi */-1,
                      /* lo */4294967294
                    ]);
      case 2 : 
          return vs64(/* int64 */[
                      /* hi */-1,
                      /* lo */4294967293
                    ]);
      case 3 : 
          return vs64(/* int64 */[
                      /* hi */-1,
                      /* lo */4294967292
                    ]);
      
    }
  };
  var stack_type = function (param) {
    if (param) {
      if (param[1]) {
        return Curry._2(Code[/* error */2], Source.no_region, "cannot encode stack type with arity > 1 (yet)");
      }
      else {
        return value_type(param[0]);
      }
    }
    else {
      return vs64(/* int64 */[
                  /* hi */-1,
                  /* lo */4294967232
                ]);
    }
  };
  var func_type = function (param) {
    vs64(/* int64 */[
          /* hi */-1,
          /* lo */4294967264
        ]);
    vec(value_type, param[0]);
    return vec(value_type, param[1]);
  };
  var limits = function (vu, param) {
    var max = param[/* max */1];
    bool(+(max !== /* None */0));
    Curry._1(vu, param[/* min */0]);
    return Curry._2(Lib.Option[/* app */2], vu, max);
  };
  var table_type = function (param) {
    vs64(/* int64 */[
          /* hi */-1,
          /* lo */4294967280
        ]);
    return limits(vu32, param[0]);
  };
  var memory_type = function (param) {
    return limits(vu32, param[0]);
  };
  var global_type = function (param) {
    value_type(param[0]);
    var param$1 = param[1];
    if (param$1 !== 0) {
      return u8(1);
    }
    else {
      return u8(0);
    }
  };
  var memop = function (param) {
    vu32(param[/* align */1]);
    return vu32(param[/* offset */2]);
  };
  var $$var = function (x) {
    return vu32(x[/* it */1]);
  };
  var instr = function (e) {
    var match = e[/* it */1];
    if (typeof match === "number") {
      switch (match) {
        case 0 : 
            return u8(0);
        case 1 : 
            return u8(1);
        case 2 : 
            return u8(15);
        case 3 : 
            return u8(26);
        case 4 : 
            return u8(27);
        case 5 : 
            u8(63);
            return u8(0);
        case 6 : 
            u8(64);
            return u8(0);
        
      }
    }
    else {
      switch (match.tag | 0) {
        case 0 : 
            u8(2);
            stack_type(match[0]);
            List.iter(instr, match[1]);
            return u8(11);
        case 1 : 
            u8(3);
            stack_type(match[0]);
            List.iter(instr, match[1]);
            return u8(11);
        case 2 : 
            var es2 = match[2];
            u8(4);
            stack_type(match[0]);
            List.iter(instr, match[1]);
            if (es2 !== /* [] */0) {
              u8(5);
            }
            List.iter(instr, es2);
            return u8(11);
        case 3 : 
            u8(12);
            return vu32(match[0][/* it */1]);
        case 4 : 
            u8(13);
            return vu32(match[0][/* it */1]);
        case 5 : 
            u8(14);
            vec($$var, match[0]);
            return vu32(match[1][/* it */1]);
        case 6 : 
            u8(16);
            return vu32(match[0][/* it */1]);
        case 7 : 
            u8(17);
            vu32(match[0][/* it */1]);
            return u8(0);
        case 8 : 
            u8(32);
            return vu32(match[0][/* it */1]);
        case 9 : 
            u8(33);
            return vu32(match[0][/* it */1]);
        case 10 : 
            u8(34);
            return vu32(match[0][/* it */1]);
        case 11 : 
            u8(35);
            return vu32(match[0][/* it */1]);
        case 12 : 
            u8(36);
            return vu32(match[0][/* it */1]);
        case 13 : 
            var mo = match[0];
            switch (mo[/* ty */0]) {
              case 0 : 
                  var match$1 = mo[/* sz */3];
                  if (match$1) {
                    var match$2 = match$1[0];
                    switch (match$2[0]) {
                      case 0 : 
                          if (match$2[1] !== 0) {
                            u8(45);
                            return memop(mo);
                          }
                          else {
                            u8(44);
                            return memop(mo);
                          }
                      case 1 : 
                          if (match$2[1] !== 0) {
                            u8(47);
                            return memop(mo);
                          }
                          else {
                            u8(46);
                            return memop(mo);
                          }
                      case 2 : 
                          throw [
                                Caml_builtin_exceptions.assert_failure,
                                [
                                  "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                  182,
                                  8
                                ]
                              ];
                      
                    }
                  }
                  else {
                    u8(40);
                    return memop(mo);
                  }
                  break;
              case 1 : 
                  var match$3 = mo[/* sz */3];
                  if (match$3) {
                    var match$4 = match$3[0];
                    switch (match$4[0]) {
                      case 0 : 
                          if (match$4[1] !== 0) {
                            u8(49);
                            return memop(mo);
                          }
                          else {
                            u8(48);
                            return memop(mo);
                          }
                      case 1 : 
                          if (match$4[1] !== 0) {
                            u8(51);
                            return memop(mo);
                          }
                          else {
                            u8(50);
                            return memop(mo);
                          }
                      case 2 : 
                          if (match$4[1] !== 0) {
                            u8(53);
                            return memop(mo);
                          }
                          else {
                            u8(52);
                            return memop(mo);
                          }
                      
                    }
                  }
                  else {
                    u8(41);
                    return memop(mo);
                  }
                  break;
              case 2 : 
                  if (mo[/* sz */3]) {
                    throw [
                          Caml_builtin_exceptions.assert_failure,
                          [
                            "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                            196,
                            8
                          ]
                        ];
                  }
                  else {
                    u8(42);
                    return memop(mo);
                  }
                  break;
              case 3 : 
                  if (mo[/* sz */3]) {
                    throw [
                          Caml_builtin_exceptions.assert_failure,
                          [
                            "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                            196,
                            8
                          ]
                        ];
                  }
                  else {
                    u8(43);
                    return memop(mo);
                  }
                  break;
              
            }
            break;
        case 14 : 
            var mo$1 = match[0];
            switch (mo$1[/* ty */0]) {
              case 0 : 
                  var match$5 = mo$1[/* sz */3];
                  if (match$5) {
                    switch (match$5[0]) {
                      case 0 : 
                          u8(58);
                          return memop(mo$1);
                      case 1 : 
                          u8(59);
                          return memop(mo$1);
                      case 2 : 
                          throw [
                                Caml_builtin_exceptions.assert_failure,
                                [
                                  "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                  204,
                                  52
                                ]
                              ];
                      
                    }
                  }
                  else {
                    u8(54);
                    return memop(mo$1);
                  }
                  break;
              case 1 : 
                  var match$6 = mo$1[/* sz */3];
                  if (match$6) {
                    switch (match$6[0]) {
                      case 0 : 
                          u8(60);
                          return memop(mo$1);
                      case 1 : 
                          u8(61);
                          return memop(mo$1);
                      case 2 : 
                          u8(62);
                          return memop(mo$1);
                      
                    }
                  }
                  else {
                    u8(55);
                    return memop(mo$1);
                  }
                  break;
              case 2 : 
                  if (mo$1[/* sz */3]) {
                    throw [
                          Caml_builtin_exceptions.assert_failure,
                          [
                            "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                            208,
                            58
                          ]
                        ];
                  }
                  else {
                    u8(56);
                    return memop(mo$1);
                  }
                  break;
              case 3 : 
                  if (mo$1[/* sz */3]) {
                    throw [
                          Caml_builtin_exceptions.assert_failure,
                          [
                            "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                            208,
                            58
                          ]
                        ];
                  }
                  else {
                    u8(57);
                    return memop(mo$1);
                  }
                  break;
              
            }
            break;
        case 15 : 
            var match$7 = match[0][/* it */1];
            switch (match$7.tag | 0) {
              case 0 : 
                  u8(65);
                  return vs64(Caml_int64.of_int32(match$7[0]));
              case 1 : 
                  u8(66);
                  return vs64(match$7[0]);
              case 2 : 
                  u8(67);
                  return u32(Curry._1(F32.to_bits, match$7[0]));
              case 3 : 
                  u8(68);
                  var i = Curry._1(F64.to_bits, match$7[0]);
                  u32(i[1] & /* lo */4294967295 | 0);
                  return u32(Caml_int64.asr_(i, 32)[1] | 0);
              
            }
            break;
        case 16 : 
            switch (match[0].tag | 0) {
              case 0 : 
                  return u8(69);
              case 1 : 
                  return u8(80);
              case 2 : 
                  throw [
                        Caml_builtin_exceptions.assert_failure,
                        [
                          "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                          220,
                          24
                        ]
                      ];
              case 3 : 
                  throw [
                        Caml_builtin_exceptions.assert_failure,
                        [
                          "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                          221,
                          24
                        ]
                      ];
              
            }
            break;
        case 17 : 
            var match$8 = match[0];
            switch (match$8.tag | 0) {
              case 0 : 
                  switch (match$8[0]) {
                    case 0 : 
                        return u8(70);
                    case 1 : 
                        return u8(71);
                    case 2 : 
                        return u8(72);
                    case 3 : 
                        return u8(73);
                    case 4 : 
                        return u8(74);
                    case 5 : 
                        return u8(75);
                    case 6 : 
                        return u8(76);
                    case 7 : 
                        return u8(77);
                    case 8 : 
                        return u8(78);
                    case 9 : 
                        return u8(79);
                    
                  }
                  break;
              case 1 : 
                  switch (match$8[0]) {
                    case 0 : 
                        return u8(81);
                    case 1 : 
                        return u8(82);
                    case 2 : 
                        return u8(83);
                    case 3 : 
                        return u8(84);
                    case 4 : 
                        return u8(85);
                    case 5 : 
                        return u8(86);
                    case 6 : 
                        return u8(87);
                    case 7 : 
                        return u8(88);
                    case 8 : 
                        return u8(89);
                    case 9 : 
                        return u8(90);
                    
                  }
                  break;
              case 2 : 
                  switch (match$8[0]) {
                    case 0 : 
                        return u8(91);
                    case 1 : 
                        return u8(92);
                    case 2 : 
                        return u8(93);
                    case 3 : 
                        return u8(94);
                    case 4 : 
                        return u8(95);
                    case 5 : 
                        return u8(96);
                    
                  }
                  break;
              case 3 : 
                  switch (match$8[0]) {
                    case 0 : 
                        return u8(97);
                    case 1 : 
                        return u8(98);
                    case 2 : 
                        return u8(99);
                    case 3 : 
                        return u8(100);
                    case 4 : 
                        return u8(101);
                    case 5 : 
                        return u8(102);
                    
                  }
                  break;
              
            }
            break;
        case 18 : 
            var match$9 = match[0];
            switch (match$9.tag | 0) {
              case 0 : 
                  switch (match$9[0]) {
                    case 0 : 
                        return u8(103);
                    case 1 : 
                        return u8(104);
                    case 2 : 
                        return u8(105);
                    
                  }
                  break;
              case 1 : 
                  switch (match$9[0]) {
                    case 0 : 
                        return u8(121);
                    case 1 : 
                        return u8(122);
                    case 2 : 
                        return u8(123);
                    
                  }
                  break;
              case 2 : 
                  switch (match$9[0]) {
                    case 0 : 
                        return u8(140);
                    case 1 : 
                        return u8(139);
                    case 2 : 
                        return u8(141);
                    case 3 : 
                        return u8(142);
                    case 4 : 
                        return u8(143);
                    case 5 : 
                        return u8(144);
                    case 6 : 
                        return u8(145);
                    
                  }
                  break;
              case 3 : 
                  switch (match$9[0]) {
                    case 0 : 
                        return u8(154);
                    case 1 : 
                        return u8(153);
                    case 2 : 
                        return u8(155);
                    case 3 : 
                        return u8(156);
                    case 4 : 
                        return u8(157);
                    case 5 : 
                        return u8(158);
                    case 6 : 
                        return u8(159);
                    
                  }
                  break;
              
            }
            break;
        case 19 : 
            var match$10 = match[0];
            switch (match$10.tag | 0) {
              case 0 : 
                  switch (match$10[0]) {
                    case 0 : 
                        return u8(106);
                    case 1 : 
                        return u8(107);
                    case 2 : 
                        return u8(108);
                    case 3 : 
                        return u8(109);
                    case 4 : 
                        return u8(110);
                    case 5 : 
                        return u8(111);
                    case 6 : 
                        return u8(112);
                    case 7 : 
                        return u8(113);
                    case 8 : 
                        return u8(114);
                    case 9 : 
                        return u8(115);
                    case 10 : 
                        return u8(116);
                    case 11 : 
                        return u8(117);
                    case 12 : 
                        return u8(118);
                    case 13 : 
                        return u8(119);
                    case 14 : 
                        return u8(120);
                    
                  }
                  break;
              case 1 : 
                  switch (match$10[0]) {
                    case 0 : 
                        return u8(124);
                    case 1 : 
                        return u8(125);
                    case 2 : 
                        return u8(126);
                    case 3 : 
                        return u8(127);
                    case 4 : 
                        return u8(128);
                    case 5 : 
                        return u8(129);
                    case 6 : 
                        return u8(130);
                    case 7 : 
                        return u8(131);
                    case 8 : 
                        return u8(132);
                    case 9 : 
                        return u8(133);
                    case 10 : 
                        return u8(134);
                    case 11 : 
                        return u8(135);
                    case 12 : 
                        return u8(136);
                    case 13 : 
                        return u8(137);
                    case 14 : 
                        return u8(138);
                    
                  }
                  break;
              case 2 : 
                  switch (match$10[0]) {
                    case 0 : 
                        return u8(146);
                    case 1 : 
                        return u8(147);
                    case 2 : 
                        return u8(148);
                    case 3 : 
                        return u8(149);
                    case 4 : 
                        return u8(150);
                    case 5 : 
                        return u8(151);
                    case 6 : 
                        return u8(152);
                    
                  }
                  break;
              case 3 : 
                  switch (match$10[0]) {
                    case 0 : 
                        return u8(160);
                    case 1 : 
                        return u8(161);
                    case 2 : 
                        return u8(162);
                    case 3 : 
                        return u8(163);
                    case 4 : 
                        return u8(164);
                    case 5 : 
                        return u8(165);
                    case 6 : 
                        return u8(166);
                    
                  }
                  break;
              
            }
            break;
        case 20 : 
            var match$11 = match[0];
            switch (match$11.tag | 0) {
              case 0 : 
                  switch (match$11[0]) {
                    case 0 : 
                        throw [
                              Caml_builtin_exceptions.assert_failure,
                              [
                                "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                331,
                                42
                              ]
                            ];
                    case 1 : 
                        throw [
                              Caml_builtin_exceptions.assert_failure,
                              [
                                "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                332,
                                42
                              ]
                            ];
                    case 2 : 
                        return u8(167);
                    case 3 : 
                        return u8(168);
                    case 4 : 
                        return u8(169);
                    case 5 : 
                        return u8(170);
                    case 6 : 
                        return u8(171);
                    case 7 : 
                        return u8(188);
                    
                  }
                  break;
              case 1 : 
                  switch (match$11[0]) {
                    case 0 : 
                        return u8(172);
                    case 1 : 
                        return u8(173);
                    case 2 : 
                        throw [
                              Caml_builtin_exceptions.assert_failure,
                              [
                                "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                342,
                                39
                              ]
                            ];
                    case 3 : 
                        return u8(174);
                    case 4 : 
                        return u8(175);
                    case 5 : 
                        return u8(176);
                    case 6 : 
                        return u8(177);
                    case 7 : 
                        return u8(189);
                    
                  }
                  break;
              case 2 : 
                  switch (match$11[0]) {
                    case 0 : 
                        return u8(178);
                    case 1 : 
                        return u8(179);
                    case 2 : 
                        return u8(180);
                    case 3 : 
                        return u8(181);
                    case 4 : 
                        throw [
                              Caml_builtin_exceptions.assert_failure,
                              [
                                "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                353,
                                42
                              ]
                            ];
                    case 5 : 
                        return u8(182);
                    case 6 : 
                        return u8(190);
                    
                  }
                  break;
              case 3 : 
                  switch (match$11[0]) {
                    case 0 : 
                        return u8(183);
                    case 1 : 
                        return u8(184);
                    case 2 : 
                        return u8(185);
                    case 3 : 
                        return u8(186);
                    case 4 : 
                        return u8(187);
                    case 5 : 
                        throw [
                              Caml_builtin_exceptions.assert_failure,
                              [
                                "/usr/local/google/home/rossberg/wasm/spec/interpreter/_build/jslib/src/encode.ml",
                                362,
                                41
                              ]
                            ];
                    case 6 : 
                        return u8(191);
                    
                  }
                  break;
              
            }
            break;
        
      }
    }
  };
  var $$const = function (c) {
    List.iter(instr, c[/* it */1]);
    return u8(11);
  };
  var section = function (id, f, x, needed) {
    if (needed) {
      u8(id);
      var g = gap32(/* () */0);
      var p = Buffer.length(s[/* buf */0]);
      Curry._1(f, x);
      return patch_gap32(g, Buffer.length(s[/* buf */0]) - p | 0);
    }
    else {
      return 0;
    }
  };
  var type_section = function (ts) {
    return section(1, function (param) {
                return vec(func_type, param);
              }, ts, +(ts !== /* [] */0));
  };
  var $$import = function (im) {
    var match = im[/* it */1];
    string(match[/* module_name */0]);
    string(match[/* item_name */1]);
    var k = match[/* ikind */2];
    var match$1 = k[/* it */1];
    switch (match$1.tag | 0) {
      case 0 : 
          u8(0);
          return vu32(match$1[0][/* it */1]);
      case 1 : 
          u8(1);
          return table_type(match$1[0]);
      case 2 : 
          u8(2);
          return memory_type(match$1[0]);
      case 3 : 
          u8(3);
          return global_type(match$1[0]);
      
    }
  };
  var import_section = function (ims) {
    return section(2, function (param) {
                return vec($$import, param);
              }, ims, +(ims !== /* [] */0));
  };
  var func = function (f) {
    return vu32(f[/* it */1][/* ftype */0][/* it */1]);
  };
  var func_section = function (fs) {
    return section(3, function (param) {
                return vec(func, param);
              }, fs, +(fs !== /* [] */0));
  };
  var table = function (tab) {
    var match = tab[/* it */1];
    return table_type(match[/* ttype */0]);
  };
  var table_section = function (tabs) {
    return section(4, function (param) {
                return vec(table, param);
              }, tabs, +(tabs !== /* [] */0));
  };
  var memory = function (mem) {
    var match = mem[/* it */1];
    return memory_type(match[/* mtype */0]);
  };
  var memory_section = function (mems) {
    return section(5, function (param) {
                return vec(memory, param);
              }, mems, +(mems !== /* [] */0));
  };
  var global = function (g) {
    var match = g[/* it */1];
    global_type(match[/* gtype */0]);
    return $$const(match[/* value */1]);
  };
  var global_section = function (gs) {
    return section(6, function (param) {
                return vec(global, param);
              }, gs, +(gs !== /* [] */0));
  };
  var export_kind = function (k) {
    var match = k[/* it */1];
    switch (match) {
      case 0 : 
          return u8(0);
      case 1 : 
          return u8(1);
      case 2 : 
          return u8(2);
      case 3 : 
          return u8(3);
      
    }
  };
  var $$export = function (ex) {
    var match = ex[/* it */1];
    string(match[/* name */0]);
    export_kind(match[/* ekind */1]);
    return vu32(match[/* item */2][/* it */1]);
  };
  var export_section = function (exs) {
    return section(7, function (param) {
                return vec($$export, param);
              }, exs, +(exs !== /* [] */0));
  };
  var start_section = function (xo) {
    return section(8, function (param) {
                return Curry._2(Lib.Option[/* app */2], $$var, param);
              }, xo, +(xo !== /* None */0));
  };
  var compress = function (ts) {
    var combine = function (t, ts) {
      if (ts) {
        var match = ts[0];
        if (Caml_obj.caml_equal(t, match[0])) {
          return /* :: */[
                  /* tuple */[
                    t,
                    match[1] + 1 | 0
                  ],
                  ts[1]
                ];
        }
        else {
          return /* :: */[
                  /* tuple */[
                    t,
                    1
                  ],
                  ts
                ];
        }
      }
      else {
        return /* :: */[
                /* tuple */[
                  t,
                  1
                ],
                ts
              ];
      }
    };
    return List.fold_right(combine, ts, /* [] */0);
  };
  var local = function (param) {
    len(param[1]);
    return value_type(param[0]);
  };
  var code = function (f) {
    var match = f[/* it */1];
    var g = gap32(/* () */0);
    var p = Buffer.length(s[/* buf */0]);
    vec(local, compress(match[/* locals */1]));
    List.iter(instr, match[/* body */2]);
    u8(11);
    return patch_gap32(g, Buffer.length(s[/* buf */0]) - p | 0);
  };
  var code_section = function (fs) {
    return section(10, function (param) {
                return vec(code, param);
              }, fs, +(fs !== /* [] */0));
  };
  var segment = function (dat, seg) {
    var match = seg[/* it */1];
    vu32(match[/* index */0][/* it */1]);
    $$const(match[/* offset */1]);
    return Curry._1(dat, match[/* init */2]);
  };
  var table_segment = function (seg) {
    return segment(function (param) {
                return vec($$var, param);
              }, seg);
  };
  var elem_section = function (elems) {
    return section(9, function (param) {
                return vec(table_segment, param);
              }, elems, +(elems !== /* [] */0));
  };
  var memory_segment = function (seg) {
    return segment(string, seg);
  };
  var module_ = function (m) {
    u32(1836278016);
    u32(13);
    type_section(m[/* it */1][/* types */0]);
    import_section(m[/* it */1][/* imports */8]);
    func_section(m[/* it */1][/* funcs */4]);
    table_section(m[/* it */1][/* tables */2]);
    memory_section(m[/* it */1][/* memories */3]);
    global_section(m[/* it */1][/* globals */1]);
    export_section(m[/* it */1][/* exports */9]);
    start_section(m[/* it */1][/* start */5]);
    elem_section(m[/* it */1][/* elems */6]);
    code_section(m[/* it */1][/* funcs */4]);
    var data = m[/* it */1][/* data */7];
    return section(11, function (param) {
                return vec(memory_segment, param);
              }, data, +(data !== /* [] */0));
  };
  module_(m);
  var s$1 = s;
  var bs = Buffer.to_bytes(s$1[/* buf */0]);
  List.iter(function (param) {
        bs[param[0]] = param[1];
        return /* () */0;
      }, s$1[/* patches */1][0]);
  return Bytes.to_string(bs);
}

var version = 13;

exports.Code    = Code$1;
exports.version = version;
exports.encode  = encode;
/* Code Not a pure module */
//////// end of encode.js ////////
    return exports;
  };


  _registry['error'] = function() {
    let exports = {};
//////// start of error.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Source          = require("./source");
var Caml_exceptions = require("bs-platform/lib/js/caml_exceptions");

function Make() {
  var $$Error = Caml_exceptions.create("Error.Make(*).Error");
  var warn = function (at, m) {
    console.error(Source.string_of_region(at) + (": warning: " + m));
    return /* () */0;
  };
  var error = function (at, m) {
    throw [
          $$Error,
          at,
          m
        ];
  };
  return /* module */[
          /* Error */$$Error,
          /* warn */warn,
          /* error */error
        ];
}

exports.Make = Make;
/* No side effect */
//////// end of error.js ////////
    return exports;
  };


  _registry['f32'] = function() {
    let exports = {};
//////// start of f32.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Block       = require("bs-platform/lib/js/block");
var Curry       = require("bs-platform/lib/js/curry");
var Float       = require("./float");
var Int32       = require("bs-platform/lib/js/int32");
var Printf      = require("bs-platform/lib/js/printf");
var Caml_float  = require("bs-platform/lib/js/caml_float");
var Caml_format = require("bs-platform/lib/js/caml_format");

function print_nan_significand_digits(a) {
  return Curry._1(Printf.sprintf(/* Format */[
                  /* Int32 */Block.__(5, [
                      /* Int_x */6,
                      /* No_padding */0,
                      /* No_precision */0,
                      /* End_of_format */0
                    ]),
                  "%lx"
                ]), Int32.abs(2139095040 ^ a));
}

var include = Float.Make(/* module */[
      /* pos_nan */2143289344,
      /* neg_nan */-4194304,
      /* caml_int32_bits_of_float */Caml_float.caml_int32_bits_of_float,
      /* caml_int32_float_of_bits */Caml_float.caml_int32_float_of_bits,
      /* caml_int32_of_string */Caml_format.caml_int32_of_string,
      /* to_string */Int32.to_string,
      /* %int32_and */function (prim, prim$1) {
        return prim & prim$1;
      },
      /* %int32_or */function (prim, prim$1) {
        return prim | prim$1;
      },
      /* %int32_xor */function (prim, prim$1) {
        return prim ^ prim$1;
      },
      /* min_int */Int32.min_int,
      /* max_int */Int32.max_int,
      /* zero */Int32.zero,
      /* bare_nan */2139095040,
      /* print_nan_significand_digits */print_nan_significand_digits
    ]);

var pos_nan = include[0];

var neg_nan = include[1];

var of_float = include[2];

var to_float = include[3];

var of_string = include[4];

var to_string = include[5];

var of_bits = include[6];

var to_bits = include[7];

var add = include[8];

var sub = include[9];

var mul = include[10];

var div = include[11];

var sqrt = include[12];

var min = include[13];

var max = include[14];

var ceil = include[15];

var floor = include[16];

var trunc = include[17];

var nearest = include[18];

var abs = include[19];

var neg = include[20];

var copysign = include[21];

var eq = include[22];

var ne = include[23];

var lt = include[24];

var le = include[25];

var gt = include[26];

var ge = include[27];

var zero = include[28];

exports.pos_nan   = pos_nan;
exports.neg_nan   = neg_nan;
exports.of_float  = of_float;
exports.to_float  = to_float;
exports.of_string = of_string;
exports.to_string = to_string;
exports.of_bits   = of_bits;
exports.to_bits   = to_bits;
exports.add       = add;
exports.sub       = sub;
exports.mul       = mul;
exports.div       = div;
exports.sqrt      = sqrt;
exports.min       = min;
exports.max       = max;
exports.ceil      = ceil;
exports.floor     = floor;
exports.trunc     = trunc;
exports.nearest   = nearest;
exports.abs       = abs;
exports.neg       = neg;
exports.copysign  = copysign;
exports.eq        = eq;
exports.ne        = ne;
exports.lt        = lt;
exports.le        = le;
exports.gt        = gt;
exports.ge        = ge;
exports.zero      = zero;
/* include Not a pure module */
//////// end of f32.js ////////
    return exports;
  };


  _registry['f64'] = function() {
    let exports = {};
//////// start of f64.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Block       = require("bs-platform/lib/js/block");
var Curry       = require("bs-platform/lib/js/curry");
var Float       = require("./float");
var Int64       = require("bs-platform/lib/js/int64");
var Printf      = require("bs-platform/lib/js/printf");
var Caml_int64  = require("bs-platform/lib/js/caml_int64");
var Caml_format = require("bs-platform/lib/js/caml_format");

var bare_nan = /* int64 */[
  /* hi */2146435072,
  /* lo */0
];

function print_nan_significand_digits(a) {
  return Curry._1(Printf.sprintf(/* Format */[
                  /* Int64 */Block.__(7, [
                      /* Int_x */6,
                      /* No_padding */0,
                      /* No_precision */0,
                      /* End_of_format */0
                    ]),
                  "%Lx"
                ]), Int64.abs(/* int64 */[
                  /* hi *//* hi */2146435072 ^ a[0],
                  /* lo */((/* lo */0 ^ a[1]) >>> 0)
                ]));
}

var include = Float.Make(/* module */[
      /* pos_nan : int64 */[
        /* hi */2146959360,
        /* lo */0
      ],
      /* neg_nan : int64 */[
        /* hi */-524288,
        /* lo */0
      ],
      /* caml_int64_bits_of_float */Caml_int64.bits_of_float,
      /* caml_int64_float_of_bits */Caml_int64.float_of_bits,
      /* caml_int64_of_string */Caml_format.caml_int64_of_string,
      /* to_string */Int64.to_string,
      /* %int64_and */function (prim, prim$1) {
        return /* int64 */[
                /* hi */prim[0] & prim$1[0],
                /* lo */((prim[1] & prim$1[1]) >>> 0)
              ];
      },
      /* %int64_or */function (prim, prim$1) {
        return /* int64 */[
                /* hi */prim[0] | prim$1[0],
                /* lo */((prim[1] | prim$1[1]) >>> 0)
              ];
      },
      /* %int64_xor */function (prim, prim$1) {
        return /* int64 */[
                /* hi */prim[0] ^ prim$1[0],
                /* lo */((prim[1] ^ prim$1[1]) >>> 0)
              ];
      },
      /* min_int */Int64.min_int,
      /* max_int */Int64.max_int,
      /* zero */Int64.zero,
      /* bare_nan */bare_nan,
      /* print_nan_significand_digits */print_nan_significand_digits
    ]);

var pos_nan = include[0];

var neg_nan = include[1];

var of_float = include[2];

var to_float = include[3];

var of_string = include[4];

var to_string = include[5];

var of_bits = include[6];

var to_bits = include[7];

var add = include[8];

var sub = include[9];

var mul = include[10];

var div = include[11];

var sqrt = include[12];

var min = include[13];

var max = include[14];

var ceil = include[15];

var floor = include[16];

var trunc = include[17];

var nearest = include[18];

var abs = include[19];

var neg = include[20];

var copysign = include[21];

var eq = include[22];

var ne = include[23];

var lt = include[24];

var le = include[25];

var gt = include[26];

var ge = include[27];

var zero = include[28];

exports.pos_nan   = pos_nan;
exports.neg_nan   = neg_nan;
exports.of_float  = of_float;
exports.to_float  = to_float;
exports.of_string = of_string;
exports.to_string = to_string;
exports.of_bits   = of_bits;
exports.to_bits   = to_bits;
exports.add       = add;
exports.sub       = sub;
exports.mul       = mul;
exports.div       = div;
exports.sqrt      = sqrt;
exports.min       = min;
exports.max       = max;
exports.ceil      = ceil;
exports.floor     = floor;
exports.trunc     = trunc;
exports.nearest   = nearest;
exports.abs       = abs;
exports.neg       = neg;
exports.copysign  = copysign;
exports.eq        = eq;
exports.ne        = ne;
exports.lt        = lt;
exports.le        = le;
exports.gt        = gt;
exports.ge        = ge;
exports.zero      = zero;
/* include Not a pure module */
//////// end of f64.js ////////
    return exports;
  };


  _registry['float'] = function() {
    let exports = {};
//////// start of float.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Curry                   = require("bs-platform/lib/js/curry");
var $$String                = require("bs-platform/lib/js/string");
var Caml_obj                = require("bs-platform/lib/js/caml_obj");
var Pervasives              = require("bs-platform/lib/js/pervasives");
var Caml_format             = require("bs-platform/lib/js/caml_format");
var Caml_string             = require("bs-platform/lib/js/caml_string");
var Caml_builtin_exceptions = require("bs-platform/lib/js/caml_builtin_exceptions");

function Make(Rep) {
  var pos_nan = Rep[/* pos_nan */0];
  var neg_nan = Rep[/* neg_nan */1];
  var bare_nan = Rep[/* bare_nan */12];
  var of_float = Rep[/* bits_of_float */2];
  var to_float = Rep[/* float_of_bits */3];
  var of_bits = function (x) {
    return x;
  };
  var to_bits = function (x) {
    return x;
  };
  var is_nan = function (x) {
    var xf = Curry._1(Rep[/* float_of_bits */3], x);
    return +(xf !== xf);
  };
  var canonicalize_nan = function (x) {
    return Curry._2(Rep[/* logor */7], x, Rep[/* pos_nan */0]);
  };
  var determine_binary_nan = function (x, y) {
    return canonicalize_nan(is_nan(x) ? x : (
                  is_nan(y) ? y : Rep[/* pos_nan */0]
                ));
  };
  var determine_unary_nan = function (x) {
    return canonicalize_nan(is_nan(x) ? x : Rep[/* pos_nan */0]);
  };
  var binary = function (x, op, y) {
    var xf = Curry._1(to_float, x);
    var yf = Curry._1(to_float, y);
    var t = Curry._2(op, xf, yf);
    if (t === t) {
      return Curry._1(of_float, t);
    }
    else {
      return determine_binary_nan(x, y);
    }
  };
  var unary = function (op, x) {
    var t = Curry._1(op, Curry._1(to_float, x));
    if (t === t) {
      return Curry._1(of_float, t);
    }
    else {
      return determine_unary_nan(x);
    }
  };
  var zero = Curry._1(of_float, 0.0);
  var add = function (x, y) {
    return binary(x, function (prim, prim$1) {
                return prim + prim$1;
              }, y);
  };
  var sub = function (x, y) {
    return binary(x, function (prim, prim$1) {
                return prim - prim$1;
              }, y);
  };
  var mul = function (x, y) {
    return binary(x, function (prim, prim$1) {
                return prim * prim$1;
              }, y);
  };
  var div = function (x, y) {
    return binary(x, function (prim, prim$1) {
                return prim / prim$1;
              }, y);
  };
  var sqrt = function (x) {
    return unary(function (prim) {
                return Math.sqrt(prim);
              }, x);
  };
  var ceil = function (x) {
    return unary(function (prim) {
                return Math.ceil(prim);
              }, x);
  };
  var floor = function (x) {
    return unary(function (prim) {
                return Math.floor(prim);
              }, x);
  };
  var trunc = function (x) {
    var xf = Curry._1(to_float, x);
    if (xf === 0.0) {
      return x;
    }
    else {
      var f = xf < 0.0 ? Math.ceil(xf) : Math.floor(xf);
      var result = Curry._1(of_float, f);
      if (is_nan(result)) {
        return determine_unary_nan(result);
      }
      else {
        return result;
      }
    }
  };
  var nearest = function (x) {
    var xf = Curry._1(to_float, x);
    if (xf === 0.0) {
      return x;
    }
    else {
      var u = Math.ceil(xf);
      var d = Math.floor(xf);
      var um = Math.abs(xf - u);
      var dm = Math.abs(xf - d);
      var h = u / 2;
      var u_or_d = +(um < dm || um === dm && Math.floor(h) === h);
      var f = u_or_d ? u : d;
      var result = Curry._1(of_float, f);
      if (is_nan(result)) {
        return determine_unary_nan(result);
      }
      else {
        return result;
      }
    }
  };
  var min = function (x, y) {
    var xf = Curry._1(to_float, x);
    var yf = Curry._1(to_float, y);
    if (xf === yf) {
      return Curry._2(Rep[/* logor */7], x, y);
    }
    else if (xf < yf) {
      return x;
    }
    else if (xf > yf) {
      return y;
    }
    else {
      return determine_binary_nan(x, y);
    }
  };
  var max = function (x, y) {
    var xf = Curry._1(to_float, x);
    var yf = Curry._1(to_float, y);
    if (xf === yf) {
      return Curry._2(Rep[/* logand */6], x, y);
    }
    else if (xf > yf) {
      return x;
    }
    else if (xf < yf) {
      return y;
    }
    else {
      return determine_binary_nan(x, y);
    }
  };
  var abs = function (x) {
    return Curry._2(Rep[/* logand */6], x, Rep[/* max_int */10]);
  };
  var neg = function (x) {
    return Curry._2(Rep[/* logxor */8], x, Rep[/* min_int */9]);
  };
  var copysign = function (x, y) {
    return Curry._2(Rep[/* logor */7], abs(x), Curry._2(Rep[/* logand */6], y, Rep[/* min_int */9]));
  };
  var eq = function (x, y) {
    return +(Curry._1(to_float, x) === Curry._1(to_float, y));
  };
  var ne = function (x, y) {
    return +(Curry._1(to_float, x) !== Curry._1(to_float, y));
  };
  var lt = function (x, y) {
    return +(Curry._1(to_float, x) < Curry._1(to_float, y));
  };
  var gt = function (x, y) {
    return +(Curry._1(to_float, x) > Curry._1(to_float, y));
  };
  var le = function (x, y) {
    return +(Curry._1(to_float, x) <= Curry._1(to_float, y));
  };
  var ge = function (x, y) {
    return +(Curry._1(to_float, x) >= Curry._1(to_float, y));
  };
  var of_signless_string = function (x, len) {
    if (x !== "nan" && len > 6 && $$String.sub(x, 0, 6) === "nan:0x") {
      var s = Curry._1(Rep[/* of_string */4], $$String.sub(x, 4, len - 4 | 0));
      if (Caml_obj.caml_equal(s, Rep[/* zero */11])) {
        throw [
              Caml_builtin_exceptions.failure,
              "nan payload must not be zero"
            ];
      }
      else if (Caml_obj.caml_notequal(Curry._2(Rep[/* logand */6], s, bare_nan), Rep[/* zero */11])) {
        throw [
              Caml_builtin_exceptions.failure,
              "nan payload must not overlap with exponent bits"
            ];
      }
      else if (Caml_obj.caml_lessthan(s, Rep[/* zero */11])) {
        throw [
              Caml_builtin_exceptions.failure,
              "nan payload must not overlap with sign bit"
            ];
      }
      else {
        return Curry._2(Rep[/* logor */7], s, bare_nan);
      }
    }
    else {
      return Curry._1(of_float, Caml_format.caml_float_of_string(x));
    }
  };
  var of_string = function (x) {
    var len = x.length;
    if (len > 0 && Caml_string.get(x, 0) === /* "-" */45) {
      return neg(of_signless_string($$String.sub(x, 1, len - 1 | 0), len - 1 | 0));
    }
    else if (len > 0 && Caml_string.get(x, 0) === /* "+" */43) {
      return of_signless_string($$String.sub(x, 1, len - 1 | 0), len - 1 | 0);
    }
    else {
      return of_signless_string(x, len);
    }
  };
  var to_string = function (x) {
    var a = abs(x);
    return (
            Caml_obj.caml_lessthan(x, Rep[/* zero */11]) ? "-" : ""
          ) + (
            is_nan(a) ? "nan:0x" + Curry._1(Rep[/* print_nan_significand_digits */13], a) : Pervasives.string_of_float(Curry._1(to_float, a))
          );
  };
  return /* module */[
          /* pos_nan */pos_nan,
          /* neg_nan */neg_nan,
          /* of_float */of_float,
          /* to_float */to_float,
          /* of_string */of_string,
          /* to_string */to_string,
          /* of_bits */of_bits,
          /* to_bits */to_bits,
          /* add */add,
          /* sub */sub,
          /* mul */mul,
          /* div */div,
          /* sqrt */sqrt,
          /* min */min,
          /* max */max,
          /* ceil */ceil,
          /* floor */floor,
          /* trunc */trunc,
          /* nearest */nearest,
          /* abs */abs,
          /* neg */neg,
          /* copysign */copysign,
          /* eq */eq,
          /* ne */ne,
          /* lt */lt,
          /* le */le,
          /* gt */gt,
          /* ge */ge,
          /* zero */zero
        ];
}

exports.Make = Make;
/* No side effect */
//////// end of float.js ////////
    return exports;
  };


  _registry['format'] = function() {
    let exports = {};
//////// start of format.js ////////
'use strict';

var Block                   = require("./block");
var Bytes                   = require("./bytes");
var Curry                   = require("./curry");
var Buffer                  = require("./buffer");
var $$String                = require("./string");
var Caml_io                 = require("./caml_io");
var Caml_obj                = require("./caml_obj");
var Pervasives              = require("./pervasives");
var Caml_string             = require("./caml_string");
var Caml_exceptions         = require("./caml_exceptions");
var CamlinternalFormat      = require("./camlinternalFormat");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function add_queue(x, q) {
  var c = /* Cons */[/* record */[
      /* head */x,
      /* tail : Nil */0
    ]];
  var match = q[/* insert */0];
  if (match) {
    q[/* insert */0] = c;
    match[0][/* tail */1] = c;
    return /* () */0;
  }
  else {
    q[/* insert */0] = c;
    q[/* body */1] = c;
    return /* () */0;
  }
}

var Empty_queue = Caml_exceptions.create("Format.Empty_queue");

function peek_queue(param) {
  var match = param[/* body */1];
  if (match) {
    return match[0][/* head */0];
  }
  else {
    throw Empty_queue;
  }
}

function take_queue(q) {
  var match = q[/* body */1];
  if (match) {
    var match$1 = match[0];
    var x = match$1[/* head */0];
    var tl = match$1[/* tail */1];
    q[/* body */1] = tl;
    if (!tl) {
      q[/* insert */0] = /* Nil */0;
    }
    return x;
  }
  else {
    throw Empty_queue;
  }
}

function pp_enqueue(state, token) {
  state[/* pp_right_total */12] = state[/* pp_right_total */12] + token[/* length */2] | 0;
  return add_queue(token, state[/* pp_queue */26]);
}

function pp_clear_queue(state) {
  state[/* pp_left_total */11] = 1;
  state[/* pp_right_total */12] = 1;
  var q = state[/* pp_queue */26];
  q[/* insert */0] = /* Nil */0;
  q[/* body */1] = /* Nil */0;
  return /* () */0;
}

function pp_output_string(state, s) {
  return Curry._3(state[/* pp_out_string */16], s, 0, s.length);
}

function break_new_line(state, offset, width) {
  Curry._1(state[/* pp_out_newline */18], /* () */0);
  state[/* pp_is_new_line */10] = /* true */1;
  var indent = (state[/* pp_margin */5] - width | 0) + offset | 0;
  var real_indent = Pervasives.min(state[/* pp_max_indent */7], indent);
  state[/* pp_current_indent */9] = real_indent;
  state[/* pp_space_left */8] = state[/* pp_margin */5] - state[/* pp_current_indent */9] | 0;
  return Curry._1(state[/* pp_out_spaces */19], state[/* pp_current_indent */9]);
}

function break_same_line(state, width) {
  state[/* pp_space_left */8] = state[/* pp_space_left */8] - width | 0;
  return Curry._1(state[/* pp_out_spaces */19], width);
}

function pp_force_break_line(state) {
  var match = state[/* pp_format_stack */1];
  if (match) {
    var match$1 = match[0];
    var width = match$1[1];
    var bl_ty = match$1[0];
    if (width > state[/* pp_space_left */8] && bl_ty !== 0 && bl_ty < 5) {
      return break_new_line(state, 0, width);
    }
    else {
      return 0;
    }
  }
  else {
    return Curry._1(state[/* pp_out_newline */18], /* () */0);
  }
}

function format_pp_token(state, size, param) {
  if (typeof param === "number") {
    switch (param) {
      case 0 : 
          var match = state[/* pp_tbox_stack */2];
          if (match) {
            var tabs = match[0][0];
            var add_tab = function (n, ls) {
              if (ls) {
                var x = ls[0];
                if (Caml_obj.caml_lessthan(n, x)) {
                  return /* :: */[
                          n,
                          ls
                        ];
                }
                else {
                  return /* :: */[
                          x,
                          add_tab(n, ls[1])
                        ];
                }
              }
              else {
                return /* :: */[
                        n,
                        /* [] */0
                      ];
              }
            };
            tabs[0] = add_tab(state[/* pp_margin */5] - state[/* pp_space_left */8] | 0, tabs[0]);
            return /* () */0;
          }
          else {
            return /* () */0;
          }
          break;
      case 1 : 
          var match$1 = state[/* pp_format_stack */1];
          if (match$1) {
            state[/* pp_format_stack */1] = match$1[1];
            return /* () */0;
          }
          else {
            return /* () */0;
          }
      case 2 : 
          var match$2 = state[/* pp_tbox_stack */2];
          if (match$2) {
            state[/* pp_tbox_stack */2] = match$2[1];
            return /* () */0;
          }
          else {
            return /* () */0;
          }
      case 3 : 
          var match$3 = state[/* pp_format_stack */1];
          if (match$3) {
            return break_new_line(state, 0, match$3[0][1]);
          }
          else {
            return Curry._1(state[/* pp_out_newline */18], /* () */0);
          }
      case 4 : 
          if (state[/* pp_current_indent */9] !== (state[/* pp_margin */5] - state[/* pp_space_left */8] | 0)) {
            var state$1 = state;
            var match$4 = take_queue(state$1[/* pp_queue */26]);
            var size$1 = match$4[/* elem_size */0];
            state$1[/* pp_left_total */11] = state$1[/* pp_left_total */11] - match$4[/* length */2] | 0;
            state$1[/* pp_space_left */8] = state$1[/* pp_space_left */8] + size$1 | 0;
            return /* () */0;
          }
          else {
            return 0;
          }
      case 5 : 
          var match$5 = state[/* pp_mark_stack */4];
          if (match$5) {
            var marker = Curry._1(state[/* pp_mark_close_tag */23], match$5[0]);
            pp_output_string(state, marker);
            state[/* pp_mark_stack */4] = match$5[1];
            return /* () */0;
          }
          else {
            return /* () */0;
          }
          break;
      
    }
  }
  else {
    switch (param.tag | 0) {
      case 0 : 
          state[/* pp_space_left */8] = state[/* pp_space_left */8] - size | 0;
          pp_output_string(state, param[0]);
          state[/* pp_is_new_line */10] = /* false */0;
          return /* () */0;
      case 1 : 
          var off = param[1];
          var n = param[0];
          var match$6 = state[/* pp_format_stack */1];
          if (match$6) {
            var match$7 = match$6[0];
            var width = match$7[1];
            switch (match$7[0]) {
              case 1 : 
              case 2 : 
                  return break_new_line(state, off, width);
              case 3 : 
                  if (size > state[/* pp_space_left */8]) {
                    return break_new_line(state, off, width);
                  }
                  else {
                    return break_same_line(state, n);
                  }
              case 4 : 
                  if (state[/* pp_is_new_line */10] || !(size > state[/* pp_space_left */8] || state[/* pp_current_indent */9] > ((state[/* pp_margin */5] - width | 0) + off | 0))) {
                    return break_same_line(state, n);
                  }
                  else {
                    return break_new_line(state, off, width);
                  }
              case 0 : 
              case 5 : 
                  return break_same_line(state, n);
              
            }
          }
          else {
            return /* () */0;
          }
          break;
      case 2 : 
          var insertion_point = state[/* pp_margin */5] - state[/* pp_space_left */8] | 0;
          var match$8 = state[/* pp_tbox_stack */2];
          if (match$8) {
            var tabs$1 = match$8[0][0];
            var find = function (n, _param) {
              while(true) {
                var param = _param;
                if (param) {
                  var x = param[0];
                  if (Caml_obj.caml_greaterequal(x, n)) {
                    return x;
                  }
                  else {
                    _param = param[1];
                    continue ;
                    
                  }
                }
                else {
                  throw Caml_builtin_exceptions.not_found;
                }
              };
            };
            var match$9 = tabs$1[0];
            var tab;
            if (match$9) {
              try {
                tab = find(insertion_point, tabs$1[0]);
              }
              catch (exn){
                if (exn === Caml_builtin_exceptions.not_found) {
                  tab = match$9[0];
                }
                else {
                  throw exn;
                }
              }
            }
            else {
              tab = insertion_point;
            }
            var offset = tab - insertion_point | 0;
            if (offset >= 0) {
              return break_same_line(state, offset + param[0] | 0);
            }
            else {
              return break_new_line(state, tab + param[1] | 0, state[/* pp_margin */5]);
            }
          }
          else {
            return /* () */0;
          }
          break;
      case 3 : 
          var ty = param[1];
          var insertion_point$1 = state[/* pp_margin */5] - state[/* pp_space_left */8] | 0;
          if (insertion_point$1 > state[/* pp_max_indent */7]) {
            pp_force_break_line(state);
          }
          var offset$1 = state[/* pp_space_left */8] - param[0] | 0;
          var bl_type = ty !== 1 ? (
              size > state[/* pp_space_left */8] ? ty : /* Pp_fits */5
            ) : /* Pp_vbox */1;
          state[/* pp_format_stack */1] = /* :: */[
            /* Format_elem */[
              bl_type,
              offset$1
            ],
            state[/* pp_format_stack */1]
          ];
          return /* () */0;
      case 4 : 
          state[/* pp_tbox_stack */2] = /* :: */[
            param[0],
            state[/* pp_tbox_stack */2]
          ];
          return /* () */0;
      case 5 : 
          var tag_name = param[0];
          var marker$1 = Curry._1(state[/* pp_mark_open_tag */22], tag_name);
          pp_output_string(state, marker$1);
          state[/* pp_mark_stack */4] = /* :: */[
            tag_name,
            state[/* pp_mark_stack */4]
          ];
          return /* () */0;
      
    }
  }
}

function advance_left(state) {
  try {
    var state$1 = state;
    while(true) {
      var match = peek_queue(state$1[/* pp_queue */26]);
      var size = match[/* elem_size */0];
      if (size < 0 && (state$1[/* pp_right_total */12] - state$1[/* pp_left_total */11] | 0) < state$1[/* pp_space_left */8]) {
        return 0;
      }
      else {
        take_queue(state$1[/* pp_queue */26]);
        format_pp_token(state$1, size < 0 ? 1000000010 : size, match[/* token */1]);
        state$1[/* pp_left_total */11] = match[/* length */2] + state$1[/* pp_left_total */11] | 0;
        continue ;
        
      }
    };
  }
  catch (exn){
    if (exn === Empty_queue) {
      return /* () */0;
    }
    else {
      throw exn;
    }
  }
}

function enqueue_advance(state, tok) {
  pp_enqueue(state, tok);
  return advance_left(state);
}

function enqueue_string_as(state, size, s) {
  return enqueue_advance(state, /* record */[
              /* elem_size */size,
              /* token : Pp_text */Block.__(0, [s]),
              /* length */size
            ]);
}

var q_elem = /* record */[
  /* elem_size */-1,
  /* token : Pp_text */Block.__(0, [""]),
  /* length */0
];

var scan_stack_bottom_000 = /* Scan_elem */[
  -1,
  q_elem
];

var scan_stack_bottom = /* :: */[
  scan_stack_bottom_000,
  /* [] */0
];

function set_size(state, ty) {
  var match = state[/* pp_scan_stack */0];
  if (match) {
    var match$1 = match[0];
    var queue_elem = match$1[1];
    var size = queue_elem[/* elem_size */0];
    var t = match[1];
    if (match$1[0] < state[/* pp_left_total */11]) {
      state[/* pp_scan_stack */0] = scan_stack_bottom;
      return /* () */0;
    }
    else {
      var exit = 0;
      var $js = queue_elem[/* token */1];
      if (typeof $js === "number") {
        return /* () */0;
      }
      else {
        switch ($js.tag | 0) {
          case 1 : 
          case 2 : 
              exit = 1;
              break;
          case 3 : 
              if (ty) {
                return 0;
              }
              else {
                queue_elem[/* elem_size */0] = state[/* pp_right_total */12] + size | 0;
                state[/* pp_scan_stack */0] = t;
                return /* () */0;
              }
          default:
            return /* () */0;
        }
      }
      if (exit === 1) {
        if (ty) {
          queue_elem[/* elem_size */0] = state[/* pp_right_total */12] + size | 0;
          state[/* pp_scan_stack */0] = t;
          return /* () */0;
        }
        else {
          return 0;
        }
      }
      
    }
  }
  else {
    return /* () */0;
  }
}

function scan_push(state, b, tok) {
  pp_enqueue(state, tok);
  if (b) {
    set_size(state, /* true */1);
  }
  state[/* pp_scan_stack */0] = /* :: */[
    /* Scan_elem */[
      state[/* pp_right_total */12],
      tok
    ],
    state[/* pp_scan_stack */0]
  ];
  return /* () */0;
}

function pp_open_box_gen(state, indent, br_ty) {
  state[/* pp_curr_depth */13] = state[/* pp_curr_depth */13] + 1 | 0;
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    var elem = /* record */[
      /* elem_size */-state[/* pp_right_total */12] | 0,
      /* token : Pp_begin */Block.__(3, [
          indent,
          br_ty
        ]),
      /* length */0
    ];
    return scan_push(state, /* false */0, elem);
  }
  else if (state[/* pp_curr_depth */13] === state[/* pp_max_boxes */14]) {
    var state$1 = state;
    var s = state[/* pp_ellipsis */15];
    var len = s.length;
    return enqueue_string_as(state$1, len, s);
  }
  else {
    return 0;
  }
}

function pp_close_box(state, _) {
  if (state[/* pp_curr_depth */13] > 1) {
    if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
      pp_enqueue(state, /* record */[
            /* elem_size */0,
            /* token : Pp_end */1,
            /* length */0
          ]);
      set_size(state, /* true */1);
      set_size(state, /* false */0);
    }
    state[/* pp_curr_depth */13] = state[/* pp_curr_depth */13] - 1 | 0;
    return /* () */0;
  }
  else {
    return 0;
  }
}

function pp_open_tag(state, tag_name) {
  if (state[/* pp_print_tags */20]) {
    state[/* pp_tag_stack */3] = /* :: */[
      tag_name,
      state[/* pp_tag_stack */3]
    ];
    Curry._1(state[/* pp_print_open_tag */24], tag_name);
  }
  if (state[/* pp_mark_tags */21]) {
    return pp_enqueue(state, /* record */[
                /* elem_size */0,
                /* token : Pp_open_tag */Block.__(5, [tag_name]),
                /* length */0
              ]);
  }
  else {
    return 0;
  }
}

function pp_close_tag(state, _) {
  if (state[/* pp_mark_tags */21]) {
    pp_enqueue(state, /* record */[
          /* elem_size */0,
          /* token : Pp_close_tag */5,
          /* length */0
        ]);
  }
  if (state[/* pp_print_tags */20]) {
    var match = state[/* pp_tag_stack */3];
    if (match) {
      Curry._1(state[/* pp_print_close_tag */25], match[0]);
      state[/* pp_tag_stack */3] = match[1];
      return /* () */0;
    }
    else {
      return /* () */0;
    }
  }
  else {
    return 0;
  }
}

function pp_set_print_tags(state, b) {
  state[/* pp_print_tags */20] = b;
  return /* () */0;
}

function pp_set_mark_tags(state, b) {
  state[/* pp_mark_tags */21] = b;
  return /* () */0;
}

function pp_get_print_tags(state, _) {
  return state[/* pp_print_tags */20];
}

function pp_get_mark_tags(state, _) {
  return state[/* pp_mark_tags */21];
}

function pp_set_tags(state, b) {
  state[/* pp_print_tags */20] = b;
  state[/* pp_mark_tags */21] = b;
  return /* () */0;
}

function pp_get_formatter_tag_functions(state, _) {
  return /* record */[
          /* mark_open_tag */state[/* pp_mark_open_tag */22],
          /* mark_close_tag */state[/* pp_mark_close_tag */23],
          /* print_open_tag */state[/* pp_print_open_tag */24],
          /* print_close_tag */state[/* pp_print_close_tag */25]
        ];
}

function pp_set_formatter_tag_functions(state, param) {
  state[/* pp_mark_open_tag */22] = param[/* mark_open_tag */0];
  state[/* pp_mark_close_tag */23] = param[/* mark_close_tag */1];
  state[/* pp_print_open_tag */24] = param[/* print_open_tag */2];
  state[/* pp_print_close_tag */25] = param[/* print_close_tag */3];
  return /* () */0;
}

function pp_rinit(state) {
  pp_clear_queue(state);
  state[/* pp_scan_stack */0] = scan_stack_bottom;
  state[/* pp_format_stack */1] = /* [] */0;
  state[/* pp_tbox_stack */2] = /* [] */0;
  state[/* pp_tag_stack */3] = /* [] */0;
  state[/* pp_mark_stack */4] = /* [] */0;
  state[/* pp_current_indent */9] = 0;
  state[/* pp_curr_depth */13] = 0;
  state[/* pp_space_left */8] = state[/* pp_margin */5];
  return pp_open_box_gen(state, 0, /* Pp_hovbox */3);
}

function pp_flush_queue(state, b) {
  while(state[/* pp_curr_depth */13] > 1) {
    pp_close_box(state, /* () */0);
  };
  state[/* pp_right_total */12] = 1000000010;
  advance_left(state);
  if (b) {
    Curry._1(state[/* pp_out_newline */18], /* () */0);
  }
  return pp_rinit(state);
}

function pp_print_as_size(state, size, s) {
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    return enqueue_string_as(state, size, s);
  }
  else {
    return 0;
  }
}

var pp_print_as = pp_print_as_size;

function pp_print_string(state, s) {
  return pp_print_as(state, s.length, s);
}

function pp_print_int(state, i) {
  return pp_print_string(state, "" + i);
}

function pp_print_float(state, f) {
  return pp_print_string(state, Pervasives.string_of_float(f));
}

function pp_print_bool(state, b) {
  return pp_print_string(state, b ? "true" : "false");
}

function pp_print_char(state, c) {
  return pp_print_as(state, 1, Caml_string.bytes_to_string(Bytes.make(1, c)));
}

function pp_open_hbox(state, _) {
  return pp_open_box_gen(state, 0, /* Pp_hbox */0);
}

function pp_open_vbox(state, indent) {
  return pp_open_box_gen(state, indent, /* Pp_vbox */1);
}

function pp_open_hvbox(state, indent) {
  return pp_open_box_gen(state, indent, /* Pp_hvbox */2);
}

function pp_open_hovbox(state, indent) {
  return pp_open_box_gen(state, indent, /* Pp_hovbox */3);
}

function pp_open_box(state, indent) {
  return pp_open_box_gen(state, indent, /* Pp_box */4);
}

function pp_print_newline(state, _) {
  pp_flush_queue(state, /* true */1);
  return Curry._1(state[/* pp_out_flush */17], /* () */0);
}

function pp_print_flush(state, _) {
  pp_flush_queue(state, /* false */0);
  return Curry._1(state[/* pp_out_flush */17], /* () */0);
}

function pp_force_newline(state, _) {
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    return enqueue_advance(state, /* record */[
                /* elem_size */0,
                /* token : Pp_newline */3,
                /* length */0
              ]);
  }
  else {
    return 0;
  }
}

function pp_print_if_newline(state, _) {
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    return enqueue_advance(state, /* record */[
                /* elem_size */0,
                /* token : Pp_if_newline */4,
                /* length */0
              ]);
  }
  else {
    return 0;
  }
}

function pp_print_break(state, width, offset) {
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    var elem = /* record */[
      /* elem_size */-state[/* pp_right_total */12] | 0,
      /* token : Pp_break */Block.__(1, [
          width,
          offset
        ]),
      /* length */width
    ];
    return scan_push(state, /* true */1, elem);
  }
  else {
    return 0;
  }
}

function pp_print_space(state, _) {
  return pp_print_break(state, 1, 0);
}

function pp_print_cut(state, _) {
  return pp_print_break(state, 0, 0);
}

function pp_open_tbox(state, _) {
  state[/* pp_curr_depth */13] = state[/* pp_curr_depth */13] + 1 | 0;
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    var elem = /* record */[
      /* elem_size */0,
      /* token : Pp_tbegin */Block.__(4, [/* Pp_tbox */[[/* [] */0]]]),
      /* length */0
    ];
    return enqueue_advance(state, elem);
  }
  else {
    return 0;
  }
}

function pp_close_tbox(state, _) {
  if (state[/* pp_curr_depth */13] > 1) {
    if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
      var elem = /* record */[
        /* elem_size */0,
        /* token : Pp_tend */2,
        /* length */0
      ];
      enqueue_advance(state, elem);
      state[/* pp_curr_depth */13] = state[/* pp_curr_depth */13] - 1 | 0;
      return /* () */0;
    }
    else {
      return 0;
    }
  }
  else {
    return 0;
  }
}

function pp_print_tbreak(state, width, offset) {
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    var elem = /* record */[
      /* elem_size */-state[/* pp_right_total */12] | 0,
      /* token : Pp_tbreak */Block.__(2, [
          width,
          offset
        ]),
      /* length */width
    ];
    return scan_push(state, /* true */1, elem);
  }
  else {
    return 0;
  }
}

function pp_print_tab(state, _) {
  return pp_print_tbreak(state, 0, 0);
}

function pp_set_tab(state, _) {
  if (state[/* pp_curr_depth */13] < state[/* pp_max_boxes */14]) {
    var elem = /* record */[
      /* elem_size */0,
      /* token : Pp_stab */0,
      /* length */0
    ];
    return enqueue_advance(state, elem);
  }
  else {
    return 0;
  }
}

function pp_print_list(_$staropt$star, pp_v, ppf, _param) {
  while(true) {
    var param = _param;
    var $staropt$star = _$staropt$star;
    var pp_sep = $staropt$star ? $staropt$star[0] : pp_print_cut;
    if (param) {
      var vs = param[1];
      var v = param[0];
      if (vs) {
        Curry._2(pp_v, ppf, v);
        Curry._2(pp_sep, ppf, /* () */0);
        _param = vs;
        _$staropt$star = /* Some */[pp_sep];
        continue ;
        
      }
      else {
        return Curry._2(pp_v, ppf, v);
      }
    }
    else {
      return /* () */0;
    }
  };
}

function pp_print_text(ppf, s) {
  var len = s.length;
  var left = [0];
  var right = [0];
  var flush = function () {
    pp_print_string(ppf, $$String.sub(s, left[0], right[0] - left[0] | 0));
    right[0] = right[0] + 1 | 0;
    left[0] = right[0];
    return /* () */0;
  };
  while(right[0] !== len) {
    var match = Caml_string.get(s, right[0]);
    if (match !== 10) {
      if (match !== 32) {
        right[0] = right[0] + 1 | 0;
      }
      else {
        flush(/* () */0);
        pp_print_break(ppf, 1, 0);
      }
    }
    else {
      flush(/* () */0);
      pp_force_newline(ppf, /* () */0);
    }
  };
  if (left[0] !== len) {
    return flush(/* () */0);
  }
  else {
    return 0;
  }
}

function pp_set_max_boxes(state, n) {
  if (n > 1) {
    state[/* pp_max_boxes */14] = n;
    return /* () */0;
  }
  else {
    return 0;
  }
}

function pp_get_max_boxes(state, _) {
  return state[/* pp_max_boxes */14];
}

function pp_over_max_boxes(state, _) {
  return +(state[/* pp_curr_depth */13] === state[/* pp_max_boxes */14]);
}

function pp_set_ellipsis_text(state, s) {
  state[/* pp_ellipsis */15] = s;
  return /* () */0;
}

function pp_get_ellipsis_text(state, _) {
  return state[/* pp_ellipsis */15];
}

function pp_limit(n) {
  if (n < 1000000010) {
    return n;
  }
  else {
    return 1000000009;
  }
}

function pp_set_max_indent(state, n) {
  var state$1 = state;
  var n$1 = state[/* pp_margin */5] - n | 0;
  if (n$1 >= 1) {
    var n$2 = pp_limit(n$1);
    state$1[/* pp_min_space_left */6] = n$2;
    state$1[/* pp_max_indent */7] = state$1[/* pp_margin */5] - state$1[/* pp_min_space_left */6] | 0;
    return pp_rinit(state$1);
  }
  else {
    return 0;
  }
}

function pp_get_max_indent(state, _) {
  return state[/* pp_max_indent */7];
}

function pp_set_margin(state, n) {
  if (n >= 1) {
    var n$1 = pp_limit(n);
    state[/* pp_margin */5] = n$1;
    var new_max_indent = state[/* pp_max_indent */7] <= state[/* pp_margin */5] ? state[/* pp_max_indent */7] : Pervasives.max(Pervasives.max(state[/* pp_margin */5] - state[/* pp_min_space_left */6] | 0, state[/* pp_margin */5] / 2 | 0), 1);
    return pp_set_max_indent(state, new_max_indent);
  }
  else {
    return 0;
  }
}

function pp_get_margin(state, _) {
  return state[/* pp_margin */5];
}

function pp_set_formatter_out_functions(state, param) {
  state[/* pp_out_string */16] = param[/* out_string */0];
  state[/* pp_out_flush */17] = param[/* out_flush */1];
  state[/* pp_out_newline */18] = param[/* out_newline */2];
  state[/* pp_out_spaces */19] = param[/* out_spaces */3];
  return /* () */0;
}

function pp_get_formatter_out_functions(state, _) {
  return /* record */[
          /* out_string */state[/* pp_out_string */16],
          /* out_flush */state[/* pp_out_flush */17],
          /* out_newline */state[/* pp_out_newline */18],
          /* out_spaces */state[/* pp_out_spaces */19]
        ];
}

function pp_set_formatter_output_functions(state, f, g) {
  state[/* pp_out_string */16] = f;
  state[/* pp_out_flush */17] = g;
  return /* () */0;
}

function pp_get_formatter_output_functions(state, _) {
  return /* tuple */[
          state[/* pp_out_string */16],
          state[/* pp_out_flush */17]
        ];
}

function pp_set_all_formatter_output_functions(state, f, g, h, i) {
  pp_set_formatter_output_functions(state, f, g);
  state[/* pp_out_newline */18] = h;
  state[/* pp_out_spaces */19] = i;
  return /* () */0;
}

function pp_get_all_formatter_output_functions(state, _) {
  return /* tuple */[
          state[/* pp_out_string */16],
          state[/* pp_out_flush */17],
          state[/* pp_out_newline */18],
          state[/* pp_out_spaces */19]
        ];
}

function display_newline(state, _) {
  return Curry._3(state[/* pp_out_string */16], "\n", 0, 1);
}

var blank_line = Caml_string.bytes_to_string(Bytes.make(80, /* " " */32));

function display_blanks(state, _n) {
  while(true) {
    var n = _n;
    if (n > 0) {
      if (n <= 80) {
        return Curry._3(state[/* pp_out_string */16], blank_line, 0, n);
      }
      else {
        Curry._3(state[/* pp_out_string */16], blank_line, 0, 80);
        _n = n - 80 | 0;
        continue ;
        
      }
    }
    else {
      return 0;
    }
  };
}

function pp_set_formatter_out_channel(state, os) {
  state[/* pp_out_string */16] = function (param, param$1, param$2) {
    return Pervasives.output_substring(os, param, param$1, param$2);
  };
  state[/* pp_out_flush */17] = function () {
    return Caml_io.caml_ml_flush(os);
  };
  state[/* pp_out_newline */18] = function (param) {
    return display_newline(state, param);
  };
  state[/* pp_out_spaces */19] = function (param) {
    return display_blanks(state, param);
  };
  return /* () */0;
}

function default_pp_mark_open_tag(s) {
  return "<" + (s + ">");
}

function default_pp_mark_close_tag(s) {
  return "</" + (s + ">");
}

function default_pp_print_open_tag() {
  return /* () */0;
}

function default_pp_print_close_tag() {
  return /* () */0;
}

function pp_make_formatter(f, g, h, i) {
  var pp_q = /* record */[
    /* insert : Nil */0,
    /* body : Nil */0
  ];
  var sys_tok = /* record */[
    /* elem_size */-1,
    /* token : Pp_begin */Block.__(3, [
        0,
        /* Pp_hovbox */3
      ]),
    /* length */0
  ];
  add_queue(sys_tok, pp_q);
  var sys_scan_stack_000 = /* Scan_elem */[
    1,
    sys_tok
  ];
  var sys_scan_stack = /* :: */[
    sys_scan_stack_000,
    scan_stack_bottom
  ];
  return /* record */[
          /* pp_scan_stack */sys_scan_stack,
          /* pp_format_stack : [] */0,
          /* pp_tbox_stack : [] */0,
          /* pp_tag_stack : [] */0,
          /* pp_mark_stack : [] */0,
          /* pp_margin */78,
          /* pp_min_space_left */10,
          /* pp_max_indent */68,
          /* pp_space_left */78,
          /* pp_current_indent */0,
          /* pp_is_new_line : true */1,
          /* pp_left_total */1,
          /* pp_right_total */1,
          /* pp_curr_depth */1,
          /* pp_max_boxes */Pervasives.max_int,
          /* pp_ellipsis */".",
          /* pp_out_string */f,
          /* pp_out_flush */g,
          /* pp_out_newline */h,
          /* pp_out_spaces */i,
          /* pp_print_tags : false */0,
          /* pp_mark_tags : false */0,
          /* pp_mark_open_tag */default_pp_mark_open_tag,
          /* pp_mark_close_tag */default_pp_mark_close_tag,
          /* pp_print_open_tag */default_pp_print_open_tag,
          /* pp_print_close_tag */default_pp_print_close_tag,
          /* pp_queue */pp_q
        ];
}

function make_formatter(output, flush) {
  var ppf = pp_make_formatter(output, flush, function () {
        return /* () */0;
      }, function () {
        return /* () */0;
      });
  ppf[/* pp_out_newline */18] = function (param) {
    return display_newline(ppf, param);
  };
  ppf[/* pp_out_spaces */19] = function (param) {
    return display_blanks(ppf, param);
  };
  return ppf;
}

function formatter_of_out_channel(oc) {
  return make_formatter(function (param, param$1, param$2) {
              return Pervasives.output_substring(oc, param, param$1, param$2);
            }, function () {
              return Caml_io.caml_ml_flush(oc);
            });
}

function formatter_of_buffer(b) {
  return make_formatter(function (param, param$1, param$2) {
              return Buffer.add_substring(b, param, param$1, param$2);
            }, function () {
              return /* () */0;
            });
}

var stdbuf = Buffer.create(512);

var std_formatter = formatter_of_out_channel(Pervasives.stdout);

var err_formatter = formatter_of_out_channel(Pervasives.stderr);

var str_formatter = formatter_of_buffer(stdbuf);

function flush_str_formatter() {
  pp_flush_queue(str_formatter, /* false */0);
  var s = Buffer.contents(stdbuf);
  Buffer.reset(stdbuf);
  return s;
}

function flush_buf_formatter(buf, ppf) {
  pp_flush_queue(ppf, /* false */0);
  var s = Buffer.contents(buf);
  Buffer.reset(buf);
  return s;
}

function open_hbox(param) {
  return pp_open_hbox(std_formatter, param);
}

function open_vbox(param) {
  return pp_open_vbox(std_formatter, param);
}

function open_hvbox(param) {
  return pp_open_hvbox(std_formatter, param);
}

function open_hovbox(param) {
  return pp_open_hovbox(std_formatter, param);
}

function open_box(param) {
  return pp_open_box(std_formatter, param);
}

function close_box(param) {
  return pp_close_box(std_formatter, param);
}

function open_tag(param) {
  return pp_open_tag(std_formatter, param);
}

function close_tag(param) {
  return pp_close_tag(std_formatter, param);
}

function print_as(param, param$1) {
  return pp_print_as(std_formatter, param, param$1);
}

function print_string(param) {
  return pp_print_string(std_formatter, param);
}

function print_int(param) {
  return pp_print_string(std_formatter, "" + param);
}

function print_float(param) {
  return pp_print_string(std_formatter, Pervasives.string_of_float(param));
}

function print_char(param) {
  return pp_print_char(std_formatter, param);
}

function print_bool(param) {
  return pp_print_string(std_formatter, param ? "true" : "false");
}

function print_break(param, param$1) {
  return pp_print_break(std_formatter, param, param$1);
}

function print_cut() {
  return pp_print_break(std_formatter, 0, 0);
}

function print_space() {
  return pp_print_break(std_formatter, 1, 0);
}

function force_newline(param) {
  return pp_force_newline(std_formatter, param);
}

function print_flush(param) {
  return pp_print_flush(std_formatter, param);
}

function print_newline(param) {
  return pp_print_newline(std_formatter, param);
}

function print_if_newline(param) {
  return pp_print_if_newline(std_formatter, param);
}

function open_tbox(param) {
  return pp_open_tbox(std_formatter, param);
}

function close_tbox(param) {
  return pp_close_tbox(std_formatter, param);
}

function print_tbreak(param, param$1) {
  return pp_print_tbreak(std_formatter, param, param$1);
}

function set_tab(param) {
  return pp_set_tab(std_formatter, param);
}

function print_tab() {
  return pp_print_tbreak(std_formatter, 0, 0);
}

function set_margin(param) {
  return pp_set_margin(std_formatter, param);
}

function get_margin() {
  return std_formatter[/* pp_margin */5];
}

function set_max_indent(param) {
  return pp_set_max_indent(std_formatter, param);
}

function get_max_indent() {
  return std_formatter[/* pp_max_indent */7];
}

function set_max_boxes(param) {
  return pp_set_max_boxes(std_formatter, param);
}

function get_max_boxes() {
  return std_formatter[/* pp_max_boxes */14];
}

function over_max_boxes(param) {
  return pp_over_max_boxes(std_formatter, param);
}

function set_ellipsis_text(param) {
  std_formatter[/* pp_ellipsis */15] = param;
  return /* () */0;
}

function get_ellipsis_text() {
  return std_formatter[/* pp_ellipsis */15];
}

function set_formatter_out_channel(param) {
  return pp_set_formatter_out_channel(std_formatter, param);
}

function set_formatter_out_functions(param) {
  return pp_set_formatter_out_functions(std_formatter, param);
}

function get_formatter_out_functions(param) {
  return pp_get_formatter_out_functions(std_formatter, param);
}

function set_formatter_output_functions(param, param$1) {
  return pp_set_formatter_output_functions(std_formatter, param, param$1);
}

function get_formatter_output_functions(param) {
  return pp_get_formatter_output_functions(std_formatter, param);
}

function set_all_formatter_output_functions(param, param$1, param$2, param$3) {
  return pp_set_all_formatter_output_functions(std_formatter, param, param$1, param$2, param$3);
}

function get_all_formatter_output_functions(param) {
  return pp_get_all_formatter_output_functions(std_formatter, param);
}

function set_formatter_tag_functions(param) {
  return pp_set_formatter_tag_functions(std_formatter, param);
}

function get_formatter_tag_functions(param) {
  return pp_get_formatter_tag_functions(std_formatter, param);
}

function set_print_tags(param) {
  std_formatter[/* pp_print_tags */20] = param;
  return /* () */0;
}

function get_print_tags() {
  return std_formatter[/* pp_print_tags */20];
}

function set_mark_tags(param) {
  std_formatter[/* pp_mark_tags */21] = param;
  return /* () */0;
}

function get_mark_tags() {
  return std_formatter[/* pp_mark_tags */21];
}

function set_tags(param) {
  return pp_set_tags(std_formatter, param);
}

function compute_tag(output, tag_acc) {
  var buf = Buffer.create(16);
  var ppf = formatter_of_buffer(buf);
  Curry._2(output, ppf, tag_acc);
  pp_print_flush(ppf, /* () */0);
  var len = buf[/* position */1];
  if (len < 2) {
    return Buffer.contents(buf);
  }
  else {
    return Buffer.sub(buf, 1, len - 2 | 0);
  }
}

function output_formatting_lit(ppf, fmting_lit) {
  if (typeof fmting_lit === "number") {
    switch (fmting_lit) {
      case 0 : 
          return pp_close_box(ppf, /* () */0);
      case 1 : 
          return pp_close_tag(ppf, /* () */0);
      case 2 : 
          return pp_print_flush(ppf, /* () */0);
      case 3 : 
          return pp_force_newline(ppf, /* () */0);
      case 4 : 
          return pp_print_newline(ppf, /* () */0);
      case 5 : 
          return pp_print_char(ppf, /* "@" */64);
      case 6 : 
          return pp_print_char(ppf, /* "%" */37);
      
    }
  }
  else {
    switch (fmting_lit.tag | 0) {
      case 0 : 
          return pp_print_break(ppf, fmting_lit[1], fmting_lit[2]);
      case 1 : 
          return /* () */0;
      case 2 : 
          pp_print_char(ppf, /* "@" */64);
          return pp_print_char(ppf, fmting_lit[0]);
      
    }
  }
}

function output_acc(ppf, acc) {
  var exit = 0;
  var p;
  var size;
  var s;
  var p$1;
  var size$1;
  var c;
  if (typeof acc === "number") {
    return /* () */0;
  }
  else {
    switch (acc.tag | 0) {
      case 0 : 
          output_acc(ppf, acc[0]);
          return output_formatting_lit(ppf, acc[1]);
      case 1 : 
          var match = acc[1];
          var p$2 = acc[0];
          output_acc(ppf, p$2);
          if (match.tag) {
            var match$1 = CamlinternalFormat.open_box_of_string(compute_tag(output_acc, match[0]));
            return pp_open_box_gen(ppf, match$1[0], match$1[1]);
          }
          else {
            return pp_open_tag(ppf, compute_tag(output_acc, match[0]));
          }
          break;
      case 2 : 
          var p$3 = acc[0];
          var exit$1 = 0;
          if (typeof p$3 === "number") {
            exit$1 = 3;
          }
          else if (p$3.tag) {
            exit$1 = 3;
          }
          else {
            var match$2 = p$3[1];
            if (typeof match$2 === "number") {
              exit$1 = 3;
            }
            else if (match$2.tag === 1) {
              p = p$3[0];
              size = match$2[1];
              s = acc[1];
              exit = 1;
            }
            else {
              exit$1 = 3;
            }
          }
          if (exit$1 === 3) {
            output_acc(ppf, p$3);
            return pp_print_string(ppf, acc[1]);
          }
          break;
      case 3 : 
          var p$4 = acc[0];
          var exit$2 = 0;
          if (typeof p$4 === "number") {
            exit$2 = 3;
          }
          else if (p$4.tag) {
            exit$2 = 3;
          }
          else {
            var match$3 = p$4[1];
            if (typeof match$3 === "number") {
              exit$2 = 3;
            }
            else if (match$3.tag === 1) {
              p$1 = p$4[0];
              size$1 = match$3[1];
              c = acc[1];
              exit = 2;
            }
            else {
              exit$2 = 3;
            }
          }
          if (exit$2 === 3) {
            output_acc(ppf, p$4);
            return pp_print_char(ppf, acc[1]);
          }
          break;
      case 4 : 
          var p$5 = acc[0];
          var exit$3 = 0;
          if (typeof p$5 === "number") {
            exit$3 = 3;
          }
          else if (p$5.tag) {
            exit$3 = 3;
          }
          else {
            var match$4 = p$5[1];
            if (typeof match$4 === "number") {
              exit$3 = 3;
            }
            else if (match$4.tag === 1) {
              p = p$5[0];
              size = match$4[1];
              s = acc[1];
              exit = 1;
            }
            else {
              exit$3 = 3;
            }
          }
          if (exit$3 === 3) {
            output_acc(ppf, p$5);
            return pp_print_string(ppf, acc[1]);
          }
          break;
      case 5 : 
          var p$6 = acc[0];
          var exit$4 = 0;
          if (typeof p$6 === "number") {
            exit$4 = 3;
          }
          else if (p$6.tag) {
            exit$4 = 3;
          }
          else {
            var match$5 = p$6[1];
            if (typeof match$5 === "number") {
              exit$4 = 3;
            }
            else if (match$5.tag === 1) {
              p$1 = p$6[0];
              size$1 = match$5[1];
              c = acc[1];
              exit = 2;
            }
            else {
              exit$4 = 3;
            }
          }
          if (exit$4 === 3) {
            output_acc(ppf, p$6);
            return pp_print_char(ppf, acc[1]);
          }
          break;
      case 6 : 
          output_acc(ppf, acc[0]);
          return Curry._1(acc[1], ppf);
      case 7 : 
          output_acc(ppf, acc[0]);
          return pp_print_flush(ppf, /* () */0);
      case 8 : 
          output_acc(ppf, acc[0]);
          throw [
                Caml_builtin_exceptions.invalid_argument,
                acc[1]
              ];
      
    }
  }
  switch (exit) {
    case 1 : 
        output_acc(ppf, p);
        return pp_print_as_size(ppf, size, s);
    case 2 : 
        output_acc(ppf, p$1);
        return pp_print_as_size(ppf, size$1, Caml_string.bytes_to_string(Bytes.make(1, c)));
    
  }
}

function strput_acc(ppf, acc) {
  var exit = 0;
  var p;
  var size;
  var s;
  var p$1;
  var size$1;
  var c;
  if (typeof acc === "number") {
    return /* () */0;
  }
  else {
    switch (acc.tag | 0) {
      case 0 : 
          strput_acc(ppf, acc[0]);
          return output_formatting_lit(ppf, acc[1]);
      case 1 : 
          var match = acc[1];
          var p$2 = acc[0];
          strput_acc(ppf, p$2);
          if (match.tag) {
            var match$1 = CamlinternalFormat.open_box_of_string(compute_tag(strput_acc, match[0]));
            return pp_open_box_gen(ppf, match$1[0], match$1[1]);
          }
          else {
            return pp_open_tag(ppf, compute_tag(strput_acc, match[0]));
          }
          break;
      case 2 : 
          var p$3 = acc[0];
          var exit$1 = 0;
          if (typeof p$3 === "number") {
            exit$1 = 3;
          }
          else if (p$3.tag) {
            exit$1 = 3;
          }
          else {
            var match$2 = p$3[1];
            if (typeof match$2 === "number") {
              exit$1 = 3;
            }
            else if (match$2.tag === 1) {
              p = p$3[0];
              size = match$2[1];
              s = acc[1];
              exit = 1;
            }
            else {
              exit$1 = 3;
            }
          }
          if (exit$1 === 3) {
            strput_acc(ppf, p$3);
            return pp_print_string(ppf, acc[1]);
          }
          break;
      case 3 : 
          var p$4 = acc[0];
          var exit$2 = 0;
          if (typeof p$4 === "number") {
            exit$2 = 3;
          }
          else if (p$4.tag) {
            exit$2 = 3;
          }
          else {
            var match$3 = p$4[1];
            if (typeof match$3 === "number") {
              exit$2 = 3;
            }
            else if (match$3.tag === 1) {
              p$1 = p$4[0];
              size$1 = match$3[1];
              c = acc[1];
              exit = 2;
            }
            else {
              exit$2 = 3;
            }
          }
          if (exit$2 === 3) {
            strput_acc(ppf, p$4);
            return pp_print_char(ppf, acc[1]);
          }
          break;
      case 4 : 
          var p$5 = acc[0];
          var exit$3 = 0;
          if (typeof p$5 === "number") {
            exit$3 = 3;
          }
          else if (p$5.tag) {
            exit$3 = 3;
          }
          else {
            var match$4 = p$5[1];
            if (typeof match$4 === "number") {
              exit$3 = 3;
            }
            else if (match$4.tag === 1) {
              p = p$5[0];
              size = match$4[1];
              s = acc[1];
              exit = 1;
            }
            else {
              exit$3 = 3;
            }
          }
          if (exit$3 === 3) {
            strput_acc(ppf, p$5);
            return pp_print_string(ppf, acc[1]);
          }
          break;
      case 5 : 
          var p$6 = acc[0];
          var exit$4 = 0;
          if (typeof p$6 === "number") {
            exit$4 = 3;
          }
          else if (p$6.tag) {
            exit$4 = 3;
          }
          else {
            var match$5 = p$6[1];
            if (typeof match$5 === "number") {
              exit$4 = 3;
            }
            else if (match$5.tag === 1) {
              p$1 = p$6[0];
              size$1 = match$5[1];
              c = acc[1];
              exit = 2;
            }
            else {
              exit$4 = 3;
            }
          }
          if (exit$4 === 3) {
            strput_acc(ppf, p$6);
            return pp_print_char(ppf, acc[1]);
          }
          break;
      case 6 : 
          var p$7 = acc[0];
          var exit$5 = 0;
          if (typeof p$7 === "number") {
            exit$5 = 3;
          }
          else if (p$7.tag) {
            exit$5 = 3;
          }
          else {
            var match$6 = p$7[1];
            if (typeof match$6 === "number") {
              exit$5 = 3;
            }
            else if (match$6.tag === 1) {
              strput_acc(ppf, p$7[0]);
              return pp_print_as_size(ppf, match$6[1], Curry._1(acc[1], /* () */0));
            }
            else {
              exit$5 = 3;
            }
          }
          if (exit$5 === 3) {
            strput_acc(ppf, p$7);
            return pp_print_string(ppf, Curry._1(acc[1], /* () */0));
          }
          break;
      case 7 : 
          strput_acc(ppf, acc[0]);
          return pp_print_flush(ppf, /* () */0);
      case 8 : 
          strput_acc(ppf, acc[0]);
          throw [
                Caml_builtin_exceptions.invalid_argument,
                acc[1]
              ];
      
    }
  }
  switch (exit) {
    case 1 : 
        strput_acc(ppf, p);
        return pp_print_as_size(ppf, size, s);
    case 2 : 
        strput_acc(ppf, p$1);
        return pp_print_as_size(ppf, size$1, Caml_string.bytes_to_string(Bytes.make(1, c)));
    
  }
}

function kfprintf(k, o, param) {
  return CamlinternalFormat.make_printf(function (o, acc) {
              output_acc(o, acc);
              return Curry._1(k, o);
            }, o, /* End_of_acc */0, param[0]);
}

function ikfprintf(k, x, param) {
  return CamlinternalFormat.make_printf(function (_, _$1) {
              return Curry._1(k, x);
            }, x, /* End_of_acc */0, param[0]);
}

function fprintf(ppf, fmt) {
  return kfprintf(function () {
              return /* () */0;
            }, ppf, fmt);
}

function ifprintf(ppf, fmt) {
  return ikfprintf(function () {
              return /* () */0;
            }, ppf, fmt);
}

function printf(fmt) {
  return fprintf(std_formatter, fmt);
}

function eprintf(fmt) {
  return fprintf(err_formatter, fmt);
}

function ksprintf(k, param) {
  var b = Buffer.create(512);
  var ppf = formatter_of_buffer(b);
  var k$prime = function (_, acc) {
    strput_acc(ppf, acc);
    return Curry._1(k, flush_buf_formatter(b, ppf));
  };
  return CamlinternalFormat.make_printf(k$prime, /* () */0, /* End_of_acc */0, param[0]);
}

function sprintf(fmt) {
  return ksprintf(function (s) {
              return s;
            }, fmt);
}

function asprintf(param) {
  var b = Buffer.create(512);
  var ppf = formatter_of_buffer(b);
  var k$prime = function (ppf, acc) {
    output_acc(ppf, acc);
    pp_flush_queue(ppf, /* false */0);
    return flush_buf_formatter(b, ppf);
  };
  return CamlinternalFormat.make_printf(k$prime, ppf, /* End_of_acc */0, param[0]);
}

function bprintf(b, param) {
  var k = function (ppf, acc) {
    output_acc(ppf, acc);
    return pp_flush_queue(ppf, /* false */0);
  };
  return CamlinternalFormat.make_printf(k, formatter_of_buffer(b), /* End_of_acc */0, param[0]);
}

Pervasives.at_exit(print_flush);

var kprintf = ksprintf;

exports.open_box                              = open_box;
exports.close_box                             = close_box;
exports.print_string                          = print_string;
exports.print_as                              = print_as;
exports.print_int                             = print_int;
exports.print_float                           = print_float;
exports.print_char                            = print_char;
exports.print_bool                            = print_bool;
exports.print_space                           = print_space;
exports.print_cut                             = print_cut;
exports.print_break                           = print_break;
exports.print_flush                           = print_flush;
exports.print_newline                         = print_newline;
exports.force_newline                         = force_newline;
exports.print_if_newline                      = print_if_newline;
exports.set_margin                            = set_margin;
exports.get_margin                            = get_margin;
exports.set_max_indent                        = set_max_indent;
exports.get_max_indent                        = get_max_indent;
exports.set_max_boxes                         = set_max_boxes;
exports.get_max_boxes                         = get_max_boxes;
exports.over_max_boxes                        = over_max_boxes;
exports.open_hbox                             = open_hbox;
exports.open_vbox                             = open_vbox;
exports.open_hvbox                            = open_hvbox;
exports.open_hovbox                           = open_hovbox;
exports.open_tbox                             = open_tbox;
exports.close_tbox                            = close_tbox;
exports.print_tbreak                          = print_tbreak;
exports.set_tab                               = set_tab;
exports.print_tab                             = print_tab;
exports.set_ellipsis_text                     = set_ellipsis_text;
exports.get_ellipsis_text                     = get_ellipsis_text;
exports.open_tag                              = open_tag;
exports.close_tag                             = close_tag;
exports.set_tags                              = set_tags;
exports.set_print_tags                        = set_print_tags;
exports.set_mark_tags                         = set_mark_tags;
exports.get_print_tags                        = get_print_tags;
exports.get_mark_tags                         = get_mark_tags;
exports.set_formatter_out_channel             = set_formatter_out_channel;
exports.set_formatter_output_functions        = set_formatter_output_functions;
exports.get_formatter_output_functions        = get_formatter_output_functions;
exports.set_formatter_out_functions           = set_formatter_out_functions;
exports.get_formatter_out_functions           = get_formatter_out_functions;
exports.set_formatter_tag_functions           = set_formatter_tag_functions;
exports.get_formatter_tag_functions           = get_formatter_tag_functions;
exports.formatter_of_out_channel              = formatter_of_out_channel;
exports.std_formatter                         = std_formatter;
exports.err_formatter                         = err_formatter;
exports.formatter_of_buffer                   = formatter_of_buffer;
exports.stdbuf                                = stdbuf;
exports.str_formatter                         = str_formatter;
exports.flush_str_formatter                   = flush_str_formatter;
exports.make_formatter                        = make_formatter;
exports.pp_open_hbox                          = pp_open_hbox;
exports.pp_open_vbox                          = pp_open_vbox;
exports.pp_open_hvbox                         = pp_open_hvbox;
exports.pp_open_hovbox                        = pp_open_hovbox;
exports.pp_open_box                           = pp_open_box;
exports.pp_close_box                          = pp_close_box;
exports.pp_open_tag                           = pp_open_tag;
exports.pp_close_tag                          = pp_close_tag;
exports.pp_print_string                       = pp_print_string;
exports.pp_print_as                           = pp_print_as;
exports.pp_print_int                          = pp_print_int;
exports.pp_print_float                        = pp_print_float;
exports.pp_print_char                         = pp_print_char;
exports.pp_print_bool                         = pp_print_bool;
exports.pp_print_break                        = pp_print_break;
exports.pp_print_cut                          = pp_print_cut;
exports.pp_print_space                        = pp_print_space;
exports.pp_force_newline                      = pp_force_newline;
exports.pp_print_flush                        = pp_print_flush;
exports.pp_print_newline                      = pp_print_newline;
exports.pp_print_if_newline                   = pp_print_if_newline;
exports.pp_open_tbox                          = pp_open_tbox;
exports.pp_close_tbox                         = pp_close_tbox;
exports.pp_print_tbreak                       = pp_print_tbreak;
exports.pp_set_tab                            = pp_set_tab;
exports.pp_print_tab                          = pp_print_tab;
exports.pp_set_tags                           = pp_set_tags;
exports.pp_set_print_tags                     = pp_set_print_tags;
exports.pp_set_mark_tags                      = pp_set_mark_tags;
exports.pp_get_print_tags                     = pp_get_print_tags;
exports.pp_get_mark_tags                      = pp_get_mark_tags;
exports.pp_set_margin                         = pp_set_margin;
exports.pp_get_margin                         = pp_get_margin;
exports.pp_set_max_indent                     = pp_set_max_indent;
exports.pp_get_max_indent                     = pp_get_max_indent;
exports.pp_set_max_boxes                      = pp_set_max_boxes;
exports.pp_get_max_boxes                      = pp_get_max_boxes;
exports.pp_over_max_boxes                     = pp_over_max_boxes;
exports.pp_set_ellipsis_text                  = pp_set_ellipsis_text;
exports.pp_get_ellipsis_text                  = pp_get_ellipsis_text;
exports.pp_set_formatter_out_channel          = pp_set_formatter_out_channel;
exports.pp_set_formatter_output_functions     = pp_set_formatter_output_functions;
exports.pp_get_formatter_output_functions     = pp_get_formatter_output_functions;
exports.pp_set_formatter_tag_functions        = pp_set_formatter_tag_functions;
exports.pp_get_formatter_tag_functions        = pp_get_formatter_tag_functions;
exports.pp_set_formatter_out_functions        = pp_set_formatter_out_functions;
exports.pp_get_formatter_out_functions        = pp_get_formatter_out_functions;
exports.pp_print_list                         = pp_print_list;
exports.pp_print_text                         = pp_print_text;
exports.fprintf                               = fprintf;
exports.printf                                = printf;
exports.eprintf                               = eprintf;
exports.sprintf                               = sprintf;
exports.asprintf                              = asprintf;
exports.ifprintf                              = ifprintf;
exports.kfprintf                              = kfprintf;
exports.ikfprintf                             = ikfprintf;
exports.ksprintf                              = ksprintf;
exports.bprintf                               = bprintf;
exports.kprintf                               = kprintf;
exports.set_all_formatter_output_functions    = set_all_formatter_output_functions;
exports.get_all_formatter_output_functions    = get_all_formatter_output_functions;
exports.pp_set_all_formatter_output_functions = pp_set_all_formatter_output_functions;
exports.pp_get_all_formatter_output_functions = pp_get_all_formatter_output_functions;
/* blank_line Not a pure module */
//////// end of format.js ////////
    return exports;
  };


  _registry['i32'] = function() {
    let exports = {};
//////// start of i32.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Int        = require("./int");
var Int32      = require("bs-platform/lib/js/int32");
var Caml_int32 = require("bs-platform/lib/js/caml_int32");

var include = Int.Make(/* module */[
      /* zero */Int32.zero,
      /* one */Int32.one,
      /* minus_one */Int32.minus_one,
      /* max_int */Int32.max_int,
      /* min_int */Int32.min_int,
      /* %int32_neg */function (prim) {
        return -prim | 0;
      },
      /* %int32_add */function (prim, prim$1) {
        return prim + prim$1 | 0;
      },
      /* %int32_sub */function (prim, prim$1) {
        return prim - prim$1 | 0;
      },
      /* %int32_mul */Caml_int32.imul,
      /* %int32_div */Caml_int32.div,
      /* %int32_mod */Caml_int32.mod_,
      /* %int32_and */function (prim, prim$1) {
        return prim & prim$1;
      },
      /* lognot */Int32.lognot,
      /* %int32_or */function (prim, prim$1) {
        return prim | prim$1;
      },
      /* %int32_xor */function (prim, prim$1) {
        return prim ^ prim$1;
      },
      /* %int32_lsl */function (prim, prim$1) {
        return (prim << prim$1);
      },
      /* %int32_asr */function (prim, prim$1) {
        return (prim >> prim$1);
      },
      /* %int32_lsr */function (prim, prim$1) {
        return (prim >>> prim$1) | 0;
      },
      /* %int32_of_int */function (prim) {
        return prim;
      },
      /* %int32_to_int */function (prim) {
        return prim;
      },
      /* to_string */Int32.to_string,
      /* bitwidth */32
    ]);

var of_bits = include[0];

var to_bits = include[1];

var zero = include[2];

var add = include[3];

var sub = include[4];

var mul = include[5];

var div_s = include[6];

var div_u = include[7];

var rem_s = include[8];

var rem_u = include[9];

var and_ = include[10];

var or_ = include[11];

var xor = include[12];

var shl = include[13];

var shr_s = include[14];

var shr_u = include[15];

var rotl = include[16];

var rotr = include[17];

var clz = include[18];

var ctz = include[19];

var popcnt = include[20];

var eqz = include[21];

var eq = include[22];

var ne = include[23];

var lt_s = include[24];

var lt_u = include[25];

var le_s = include[26];

var le_u = include[27];

var gt_s = include[28];

var gt_u = include[29];

var ge_s = include[30];

var ge_u = include[31];

var of_int_s = include[32];

var of_int_u = include[33];

var of_string_s = include[34];

var of_string_u = include[35];

var of_string = include[36];

var to_string_s = include[37];

var to_string_u = include[38];

exports.of_bits     = of_bits;
exports.to_bits     = to_bits;
exports.zero        = zero;
exports.add         = add;
exports.sub         = sub;
exports.mul         = mul;
exports.div_s       = div_s;
exports.div_u       = div_u;
exports.rem_s       = rem_s;
exports.rem_u       = rem_u;
exports.and_        = and_;
exports.or_         = or_;
exports.xor         = xor;
exports.shl         = shl;
exports.shr_s       = shr_s;
exports.shr_u       = shr_u;
exports.rotl        = rotl;
exports.rotr        = rotr;
exports.clz         = clz;
exports.ctz         = ctz;
exports.popcnt      = popcnt;
exports.eqz         = eqz;
exports.eq          = eq;
exports.ne          = ne;
exports.lt_s        = lt_s;
exports.lt_u        = lt_u;
exports.le_s        = le_s;
exports.le_u        = le_u;
exports.gt_s        = gt_s;
exports.gt_u        = gt_u;
exports.ge_s        = ge_s;
exports.ge_u        = ge_u;
exports.of_int_s    = of_int_s;
exports.of_int_u    = of_int_u;
exports.of_string_s = of_string_s;
exports.of_string_u = of_string_u;
exports.of_string   = of_string;
exports.to_string_s = to_string_s;
exports.to_string_u = to_string_u;
/* include Not a pure module */
//////// end of i32.js ////////
    return exports;
  };


  _registry['i64'] = function() {
    let exports = {};
//////// start of i64.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Int        = require("./int");
var Int64      = require("bs-platform/lib/js/int64");
var Caml_int64 = require("bs-platform/lib/js/caml_int64");

var include = Int.Make(/* module */[
      /* zero */Int64.zero,
      /* one */Int64.one,
      /* minus_one */Int64.minus_one,
      /* max_int */Int64.max_int,
      /* min_int */Int64.min_int,
      /* %int64_neg */Caml_int64.neg,
      /* %int64_add */Caml_int64.add,
      /* %int64_sub */Caml_int64.sub,
      /* %int64_mul */Caml_int64.mul,
      /* %int64_div */Caml_int64.div,
      /* %int64_mod */Caml_int64.mod_,
      /* %int64_and */function (prim, prim$1) {
        return /* int64 */[
                /* hi */prim[0] & prim$1[0],
                /* lo */((prim[1] & prim$1[1]) >>> 0)
              ];
      },
      /* lognot */Int64.lognot,
      /* %int64_or */function (prim, prim$1) {
        return /* int64 */[
                /* hi */prim[0] | prim$1[0],
                /* lo */((prim[1] | prim$1[1]) >>> 0)
              ];
      },
      /* %int64_xor */function (prim, prim$1) {
        return /* int64 */[
                /* hi */prim[0] ^ prim$1[0],
                /* lo */((prim[1] ^ prim$1[1]) >>> 0)
              ];
      },
      /* %int64_lsl */Caml_int64.lsl_,
      /* %int64_asr */Caml_int64.asr_,
      /* %int64_lsr */Caml_int64.lsr_,
      /* %int64_of_int */Caml_int64.of_int32,
      /* %int64_to_int */function (prim) {
        return prim[1] | 0;
      },
      /* to_string */Int64.to_string,
      /* bitwidth */64
    ]);

var of_bits = include[0];

var to_bits = include[1];

var zero = include[2];

var add = include[3];

var sub = include[4];

var mul = include[5];

var div_s = include[6];

var div_u = include[7];

var rem_s = include[8];

var rem_u = include[9];

var and_ = include[10];

var or_ = include[11];

var xor = include[12];

var shl = include[13];

var shr_s = include[14];

var shr_u = include[15];

var rotl = include[16];

var rotr = include[17];

var clz = include[18];

var ctz = include[19];

var popcnt = include[20];

var eqz = include[21];

var eq = include[22];

var ne = include[23];

var lt_s = include[24];

var lt_u = include[25];

var le_s = include[26];

var le_u = include[27];

var gt_s = include[28];

var gt_u = include[29];

var ge_s = include[30];

var ge_u = include[31];

var of_int_s = include[32];

var of_int_u = include[33];

var of_string_s = include[34];

var of_string_u = include[35];

var of_string = include[36];

var to_string_s = include[37];

var to_string_u = include[38];

exports.of_bits     = of_bits;
exports.to_bits     = to_bits;
exports.zero        = zero;
exports.add         = add;
exports.sub         = sub;
exports.mul         = mul;
exports.div_s       = div_s;
exports.div_u       = div_u;
exports.rem_s       = rem_s;
exports.rem_u       = rem_u;
exports.and_        = and_;
exports.or_         = or_;
exports.xor         = xor;
exports.shl         = shl;
exports.shr_s       = shr_s;
exports.shr_u       = shr_u;
exports.rotl        = rotl;
exports.rotr        = rotr;
exports.clz         = clz;
exports.ctz         = ctz;
exports.popcnt      = popcnt;
exports.eqz         = eqz;
exports.eq          = eq;
exports.ne          = ne;
exports.lt_s        = lt_s;
exports.lt_u        = lt_u;
exports.le_s        = le_s;
exports.le_u        = le_u;
exports.gt_s        = gt_s;
exports.gt_u        = gt_u;
exports.ge_s        = ge_s;
exports.ge_u        = ge_u;
exports.of_int_s    = of_int_s;
exports.of_int_u    = of_int_u;
exports.of_string_s = of_string_s;
exports.of_string_u = of_string_u;
exports.of_string   = of_string;
exports.to_string_s = to_string_s;
exports.to_string_u = to_string_u;
/* include Not a pure module */
//////// end of i64.js ////////
    return exports;
  };


  _registry['int32'] = function() {
    let exports = {};
//////// start of int32.js ////////
'use strict';

var Caml_obj    = require("./caml_obj");
var Caml_format = require("./caml_format");

function succ(n) {
  return n + 1 | 0;
}

function pred(n) {
  return n - 1 | 0;
}

function abs(n) {
  if (n >= 0) {
    return n;
  }
  else {
    return -n | 0;
  }
}

function lognot(n) {
  return n ^ -1;
}

function to_string(n) {
  return Caml_format.caml_int32_format("%d", n);
}

var compare = Caml_obj.caml_int32_compare;

var zero = 0;

var one = 1;

var minus_one = -1;

var max_int = 2147483647;

var min_int = -2147483648;

exports.zero      = zero;
exports.one       = one;
exports.minus_one = minus_one;
exports.succ      = succ;
exports.pred      = pred;
exports.abs       = abs;
exports.max_int   = max_int;
exports.min_int   = min_int;
exports.lognot    = lognot;
exports.to_string = to_string;
exports.compare   = compare;
/* No side effect */
//////// end of int32.js ////////
    return exports;
  };


  _registry['int64'] = function() {
    let exports = {};
//////// start of int64.js ////////
'use strict';

var Caml_int64  = require("./caml_int64");
var Caml_format = require("./caml_format");

function succ(n) {
  return Caml_int64.add(n, /* int64 */[
              /* hi */0,
              /* lo */1
            ]);
}

function pred(n) {
  return Caml_int64.sub(n, /* int64 */[
              /* hi */0,
              /* lo */1
            ]);
}

function abs(n) {
  if (Caml_int64.ge(n, /* int64 */[
          /* hi */0,
          /* lo */0
        ])) {
    return n;
  }
  else {
    return Caml_int64.neg(n);
  }
}

function lognot(n) {
  return /* int64 */[
          /* hi */n[0] ^ /* hi */-1,
          /* lo */((n[1] ^ /* lo */4294967295) >>> 0)
        ];
}

function to_string(n) {
  return Caml_format.caml_int64_format("%d", n);
}

var compare = Caml_int64.compare;

var zero = /* int64 */[
  /* hi */0,
  /* lo */0
];

var one = /* int64 */[
  /* hi */0,
  /* lo */1
];

var minus_one = /* int64 */[
  /* hi */-1,
  /* lo */4294967295
];

var max_int = /* int64 */[
  /* hi */2147483647,
  /* lo */4294967295
];

var min_int = /* int64 */[
  /* hi */-2147483648,
  /* lo */0
];

exports.zero      = zero;
exports.one       = one;
exports.minus_one = minus_one;
exports.succ      = succ;
exports.pred      = pred;
exports.abs       = abs;
exports.max_int   = max_int;
exports.min_int   = min_int;
exports.lognot    = lognot;
exports.to_string = to_string;
exports.compare   = compare;
/* No side effect */
//////// end of int64.js ////////
    return exports;
  };


  _registry['int'] = function() {
    let exports = {};
//////// start of int.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Curry         = require("bs-platform/lib/js/curry");
var Caml_obj      = require("bs-platform/lib/js/caml_obj");
var Pervasives    = require("bs-platform/lib/js/pervasives");
var Caml_string   = require("bs-platform/lib/js/caml_string");
var Numeric_error = require("./numeric_error");

function Make(Rep) {
  var cmp_u = function (x, op, y) {
    return Curry._2(op, Curry._2(Rep[/* add */6], x, Rep[/* min_int */4]), Curry._2(Rep[/* add */6], y, Rep[/* min_int */4]));
  };
  var divrem_u = function (n, d) {
    if (Caml_obj.caml_equal(d, Rep[/* zero */0])) {
      throw Numeric_error.IntegerDivideByZero;
    }
    else {
      var t = Curry._2(Rep[/* shift_right */16], d, Rep[/* bitwidth */21] - 1 | 0);
      var n$prime = Curry._2(Rep[/* logand */11], n, Curry._1(Rep[/* lognot */12], t));
      var q = Curry._2(Rep[/* shift_left */15], Curry._2(Rep[/* div */9], Curry._2(Rep[/* shift_right_logical */17], n$prime, 1), d), 1);
      var r = Curry._2(Rep[/* sub */7], n, Curry._2(Rep[/* mul */8], q, d));
      if (cmp_u(r, Caml_obj.caml_lessthan, d)) {
        return /* tuple */[
                q,
                r
              ];
      }
      else {
        return /* tuple */[
                Curry._2(Rep[/* add */6], q, Rep[/* one */1]),
                Curry._2(Rep[/* sub */7], r, d)
              ];
      }
    }
  };
  var of_bits = function (x) {
    return x;
  };
  var to_bits = function (x) {
    return x;
  };
  var zero = Rep[/* zero */0];
  var one = Rep[/* one */1];
  var ten = Curry._1(Rep[/* of_int */18], 10);
  var add = Rep[/* add */6];
  var sub = Rep[/* sub */7];
  var mul = Rep[/* mul */8];
  var div_s = function (x, y) {
    if (Caml_obj.caml_equal(y, Rep[/* zero */0])) {
      throw Numeric_error.IntegerDivideByZero;
    }
    else if (Caml_obj.caml_equal(x, Rep[/* min_int */4]) && Caml_obj.caml_equal(y, Rep[/* minus_one */2])) {
      throw Numeric_error.IntegerOverflow;
    }
    else {
      return Curry._2(Rep[/* div */9], x, y);
    }
  };
  var div_u = function (x, y) {
    return divrem_u(x, y)[0];
  };
  var rem_s = function (x, y) {
    if (Caml_obj.caml_equal(y, Rep[/* zero */0])) {
      throw Numeric_error.IntegerDivideByZero;
    }
    else {
      return Curry._2(Rep[/* rem */10], x, y);
    }
  };
  var rem_u = function (x, y) {
    return divrem_u(x, y)[1];
  };
  var and_ = Rep[/* logand */11];
  var or_ = Rep[/* logor */13];
  var xor = Rep[/* logxor */14];
  var shift = function (f, x, y) {
    return Curry._2(f, x, Curry._1(Rep[/* to_int */19], Curry._2(Rep[/* logand */11], y, Curry._1(Rep[/* of_int */18], Rep[/* bitwidth */21] - 1 | 0))));
  };
  var shl = function (x, y) {
    return shift(Rep[/* shift_left */15], x, y);
  };
  var shr_s = function (x, y) {
    return shift(Rep[/* shift_right */16], x, y);
  };
  var shr_u = function (x, y) {
    return shift(Rep[/* shift_right_logical */17], x, y);
  };
  var clamp_rotate_count = function (n) {
    return Curry._1(Rep[/* to_int */19], Curry._2(Rep[/* logand */11], n, Curry._1(Rep[/* of_int */18], Rep[/* bitwidth */21] - 1 | 0)));
  };
  var rotl = function (x, y) {
    var n = clamp_rotate_count(y);
    return Curry._2(or_, Curry._2(Rep[/* shift_left */15], x, n), Curry._2(Rep[/* shift_right_logical */17], x, Rep[/* bitwidth */21] - n | 0));
  };
  var rotr = function (x, y) {
    var n = clamp_rotate_count(y);
    return Curry._2(or_, Curry._2(Rep[/* shift_right_logical */17], x, n), Curry._2(Rep[/* shift_left */15], x, Rep[/* bitwidth */21] - n | 0));
  };
  var clz = function (x) {
    var loop = function (_acc, _n) {
      while(true) {
        var n = _n;
        var acc = _acc;
        if (Caml_obj.caml_equal(n, Rep[/* zero */0])) {
          return Rep[/* bitwidth */21];
        }
        else if (Caml_obj.caml_equal(Curry._2(and_, n, Curry._2(Rep[/* shift_left */15], Rep[/* one */1], Rep[/* bitwidth */21] - 1 | 0)), Rep[/* zero */0])) {
          _n = Curry._2(Rep[/* shift_left */15], n, 1);
          _acc = 1 + acc | 0;
          continue ;
          
        }
        else {
          return acc;
        }
      };
    };
    return Curry._1(Rep[/* of_int */18], loop(0, x));
  };
  var ctz = function (x) {
    var loop = function (_acc, _n) {
      while(true) {
        var n = _n;
        var acc = _acc;
        if (Caml_obj.caml_equal(n, Rep[/* zero */0])) {
          return Rep[/* bitwidth */21];
        }
        else if (Caml_obj.caml_equal(Curry._2(and_, n, Rep[/* one */1]), Rep[/* one */1])) {
          return acc;
        }
        else {
          _n = Curry._2(Rep[/* shift_right_logical */17], n, 1);
          _acc = 1 + acc | 0;
          continue ;
          
        }
      };
    };
    return Curry._1(Rep[/* of_int */18], loop(0, x));
  };
  var popcnt = function (x) {
    var loop = function (_acc, _i, _n) {
      while(true) {
        var n = _n;
        var i = _i;
        var acc = _acc;
        if (Caml_obj.caml_equal(n, Rep[/* zero */0])) {
          return acc;
        }
        else {
          var acc$prime = Caml_obj.caml_equal(Curry._2(and_, n, Rep[/* one */1]), Rep[/* one */1]) ? acc + 1 | 0 : acc;
          _n = Curry._2(Rep[/* shift_right_logical */17], n, 1);
          _i = i - 1 | 0;
          _acc = acc$prime;
          continue ;
          
        }
      };
    };
    return Curry._1(Rep[/* of_int */18], loop(0, Rep[/* bitwidth */21], x));
  };
  var eqz = function (x) {
    return Caml_obj.caml_equal(x, Rep[/* zero */0]);
  };
  var eq = Caml_obj.caml_equal;
  var ne = Caml_obj.caml_notequal;
  var lt_s = Caml_obj.caml_lessthan;
  var lt_u = function (x, y) {
    return cmp_u(x, Caml_obj.caml_lessthan, y);
  };
  var le_s = Caml_obj.caml_lessequal;
  var le_u = function (x, y) {
    return cmp_u(x, Caml_obj.caml_lessequal, y);
  };
  var gt_s = Caml_obj.caml_greaterthan;
  var gt_u = function (x, y) {
    return cmp_u(x, Caml_obj.caml_greaterthan, y);
  };
  var ge_s = Caml_obj.caml_greaterequal;
  var ge_u = function (x, y) {
    return cmp_u(x, Caml_obj.caml_greaterequal, y);
  };
  var of_int_s = Rep[/* of_int */18];
  var of_int_u = function (i) {
    return Curry._2(and_, Curry._1(Rep[/* of_int */18], i), Curry._2(or_, shl(Curry._1(Rep[/* of_int */18], Pervasives.max_int), one), one));
  };
  var to_string_s = Rep[/* to_string */20];
  var to_string_u = function (i) {
    if (Caml_obj.caml_greaterequal(i, Rep[/* zero */0])) {
      return Curry._1(to_string_s, i);
    }
    else {
      return Curry._1(to_string_s, div_u(i, ten)) + Curry._1(to_string_s, rem_u(i, ten));
    }
  };
  var $$require = function (b) {
    if (b) {
      return 0;
    }
    else {
      return Pervasives.failwith("of_string");
    }
  };
  var dec_digit = function (c) {
    if (c > 57 || c < 48) {
      return Pervasives.failwith("of_string");
    }
    else {
      return c - /* "0" */48 | 0;
    }
  };
  var hex_digit = function (c) {
    if (c >= 65) {
      if (c >= 97) {
        if (c >= 103) {
          return Pervasives.failwith("of_string");
        }
        else {
          return (10 + c | 0) - /* "a" */97 | 0;
        }
      }
      else if (c >= 71) {
        return Pervasives.failwith("of_string");
      }
      else {
        return (10 + c | 0) - /* "A" */65 | 0;
      }
    }
    else if (c > 57 || c < 48) {
      return Pervasives.failwith("of_string");
    }
    else {
      return c - /* "0" */48 | 0;
    }
  };
  var match = divrem_u(Rep[/* minus_one */2], ten);
  var max_lower = match[1];
  var max_upper = match[0];
  var of_string = function (s) {
    var len = s.length;
    var parse_int = function (i) {
      $$require(+((len - i | 0) > 0));
      if ((i + 2 | 0) <= len && Caml_string.get(s, i) === /* "0" */48 && Caml_string.get(s, i + 1 | 0) === /* "x" */120) {
        var _i = i + 2 | 0;
        var _num = Rep[/* zero */0];
        while(true) {
          var num = _num;
          var i$1 = _i;
          if (i$1 === len) {
            return num;
          }
          else {
            var digit = Curry._1(Rep[/* of_int */18], hex_digit(Caml_string.get(s, i$1)));
            $$require(le_u(num, shr_u(Rep[/* minus_one */2], Curry._1(Rep[/* of_int */18], 4))));
            _num = Curry._2(Rep[/* logor */13], Curry._2(Rep[/* shift_left */15], num, 4), digit);
            _i = i$1 + 1 | 0;
            continue ;
            
          }
        };
      }
      else {
        var _i$1 = i;
        var _num$1 = Rep[/* zero */0];
        while(true) {
          var num$1 = _num$1;
          var i$2 = _i$1;
          if (i$2 === len) {
            return num$1;
          }
          else {
            var digit$1 = Curry._1(Rep[/* of_int */18], dec_digit(Caml_string.get(s, i$2)));
            $$require(lt_u(num$1, max_upper) || Caml_obj.caml_equal(num$1, max_upper) && le_u(digit$1, max_lower));
            _num$1 = Curry._2(Rep[/* add */6], Curry._2(Rep[/* mul */8], num$1, ten), digit$1);
            _i$1 = i$2 + 1 | 0;
            continue ;
            
          }
        };
      }
    };
    $$require(+(len > 0));
    var match = Caml_string.get(s, 0);
    var switcher = match - 43 | 0;
    if (switcher > 2 || switcher < 0) {
      return parse_int(0);
    }
    else {
      switch (switcher) {
        case 0 : 
            return parse_int(1);
        case 1 : 
            return parse_int(0);
        case 2 : 
            var n = parse_int(1);
            $$require(Caml_obj.caml_greaterequal(Curry._2(Rep[/* sub */7], n, Rep[/* one */1]), Rep[/* minus_one */2]));
            return Curry._1(Rep[/* neg */5], n);
        
      }
    }
  };
  var of_string_s = function (s) {
    var n = of_string(s);
    $$require(+(Caml_string.get(s, 0) === /* "-" */45) || Caml_obj.caml_greaterequal(n, Rep[/* zero */0]));
    return n;
  };
  var of_string_u = function (s) {
    var n = of_string(s);
    $$require(+(Caml_string.get(s, 0) !== /* "+" */43 && Caml_string.get(s, 0) !== /* "-" */45));
    return n;
  };
  return /* module */[
          /* of_bits */of_bits,
          /* to_bits */to_bits,
          /* zero */zero,
          /* add */add,
          /* sub */sub,
          /* mul */mul,
          /* div_s */div_s,
          /* div_u */div_u,
          /* rem_s */rem_s,
          /* rem_u */rem_u,
          /* and_ */and_,
          /* or_ */or_,
          /* xor */xor,
          /* shl */shl,
          /* shr_s */shr_s,
          /* shr_u */shr_u,
          /* rotl */rotl,
          /* rotr */rotr,
          /* clz */clz,
          /* ctz */ctz,
          /* popcnt */popcnt,
          /* eqz */eqz,
          /* eq */eq,
          /* ne */ne,
          /* lt_s */lt_s,
          /* lt_u */lt_u,
          /* le_s */le_s,
          /* le_u */le_u,
          /* gt_s */gt_s,
          /* gt_u */gt_u,
          /* ge_s */ge_s,
          /* ge_u */ge_u,
          /* of_int_s */of_int_s,
          /* of_int_u */of_int_u,
          /* of_string_s */of_string_s,
          /* of_string_u */of_string_u,
          /* of_string */of_string,
          /* to_string_s */to_string_s,
          /* to_string_u */to_string_u
        ];
}

exports.Make = Make;
/* No side effect */
//////// end of int.js ////////
    return exports;
  };


  _registry['lexer'] = function() {
    let exports = {};
//////// start of lexer.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var F32                     = require("./f32");
var F64                     = require("./f64");
var I32                     = require("./i32");
var I64                     = require("./i64");
var Lib                     = require("./lib");
var Char                    = require("bs-platform/lib/js/char");
var Block                   = require("bs-platform/lib/js/block");
var Curry                   = require("bs-platform/lib/js/curry");
var Buffer                  = require("bs-platform/lib/js/buffer");
var Lexing                  = require("bs-platform/lib/js/lexing");
var Script                  = require("./script");
var Source                  = require("./source");
var $$String                = require("bs-platform/lib/js/string");
var Operators               = require("./operators");
var Caml_format             = require("bs-platform/lib/js/caml_format");
var Caml_string             = require("bs-platform/lib/js/caml_string");
var Caml_builtin_exceptions = require("bs-platform/lib/js/caml_builtin_exceptions");

function convert_pos(pos) {
  return /* record */[
          /* file */pos[/* pos_fname */0],
          /* line */pos[/* pos_lnum */1],
          /* column */pos[/* pos_cnum */3] - pos[/* pos_bol */2] | 0
        ];
}

function region(lexbuf) {
  var left = convert_pos(Lexing.lexeme_start_p(lexbuf));
  var right = convert_pos(Lexing.lexeme_end_p(lexbuf));
  return /* record */[
          /* left */left,
          /* right */right
        ];
}

function error(lexbuf, msg) {
  throw [
        Script.Syntax,
        region(lexbuf),
        msg
      ];
}

function error_nest(start, lexbuf, msg) {
  lexbuf[/* lex_start_p */10] = start;
  return error(lexbuf, msg);
}

function text(s) {
  var b = Buffer.create(s.length);
  var i = 1;
  while(i < (s.length - 1 | 0)) {
    var c;
    if (Caml_string.get(s, i) !== /* "\\" */92) {
      c = Caml_string.get(s, i);
    }
    else {
      i = i + 1 | 0;
      var d = Caml_string.get(s, i);
      var exit = 0;
      if (d >= 92) {
        if (d !== 110) {
          if (d !== 116) {
            if (d >= 93) {
              exit = 1;
            }
            else {
              c = /* "\\" */92;
            }
          }
          else {
            c = /* "\t" */9;
          }
        }
        else {
          c = /* "\n" */10;
        }
      }
      else if (d !== 34) {
        if (d !== 39) {
          exit = 1;
        }
        else {
          c = /* "'" */39;
        }
      }
      else {
        c = /* "\"" */34;
      }
      if (exit === 1) {
        i = i + 1 | 0;
        c = Char.chr(Caml_format.caml_int_of_string("0x" + ($$String.make(1, d) + $$String.make(1, Caml_string.get(s, i)))));
      }
      
    }
    Buffer.add_char(b, c);
    i = i + 1 | 0;
  };
  return Buffer.contents(b);
}

function value_type(param) {
  switch (param) {
    case "f32" : 
        return /* F32Type */2;
    case "f64" : 
        return /* F64Type */3;
    case "i32" : 
        return /* I32Type */0;
    case "i64" : 
        return /* I64Type */1;
    default:
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "text/lexer.mll",
              45,
              9
            ]
          ];
  }
}

function intop(t, i32, i64) {
  switch (t) {
    case "i32" : 
        return i32;
    case "i64" : 
        return i64;
    default:
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "text/lexer.mll",
              51,
              9
            ]
          ];
  }
}

function floatop(t, f32, f64) {
  switch (t) {
    case "f32" : 
        return f32;
    case "f64" : 
        return f64;
    default:
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "text/lexer.mll",
              57,
              9
            ]
          ];
  }
}

function numop(t, i32, i64, f32, f64) {
  switch (t) {
    case "f32" : 
        return f32;
    case "f64" : 
        return f64;
    case "i32" : 
        return i32;
    case "i64" : 
        return i64;
    default:
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "text/lexer.mll",
              65,
              9
            ]
          ];
  }
}

function memsz(sz, m8, m16, m32) {
  switch (sz) {
    case "16" : 
        return m16;
    case "32" : 
        return m32;
    case "8" : 
        return m8;
    default:
      throw [
            Caml_builtin_exceptions.assert_failure,
            [
              "text/lexer.mll",
              72,
              9
            ]
          ];
  }
}

function ext(e, s, u) {
  var switcher = e - 115 | 0;
  if (switcher > 2 || switcher < 0) {
    throw [
          Caml_builtin_exceptions.assert_failure,
          [
            "text/lexer.mll",
            78,
            9
          ]
        ];
  }
  else {
    switch (switcher) {
      case 0 : 
          return s;
      case 1 : 
          throw [
                Caml_builtin_exceptions.assert_failure,
                [
                  "text/lexer.mll",
                  78,
                  9
                ]
              ];
      case 2 : 
          return u;
      
    }
  }
}

var opt = Lib.Option[/* get */0];

var __ocaml_lex_tables = /* record */[
  /* lex_base */"\0\0o\xffp\xffq\xffr\xff\x01\0U\0\x07\0\x1b\0\x05\0o\0o\0t\0\x06\0j\0\x0e\0k\0y\0\x10\0y\0s\0\xb4\0\x01\x01z\0\xbe\0\xc5\0\x04\x01\x1a\x01\xfe\xff\x02\0s\xff\x13\0<\x01R\x01x\x01\"\0\x8f\x01\xd5\x01\x0e\x01\xee\x01/\x02>\x02U\x02\x96\x02\xa0\x02O\0D\0\xac\x02\xc2\x02\xe7\x02\0\x03&\x03L\x03z\0|\0~\0\x86\0|\0y\0\xfb\xff\x85\0\0\0\x0f\0\x87\0r\x03\x98\x03\xb1\0\xe8\xff\r\0\x10\0\xee\0\xad\0\xb6\0\xbb\0\xc2\0\x82\xff\xb4\0x\xff\0\0\x9c\x02\xb8\0\xbb\0\xf1\0\xca\0\xbf\0\xc2\0\xe3\0\xf2\0\xef\0\xe4\0\xf8\0\xeb\0\xf3\0*\x01\n\x01\xe6\0\xe8\0\xf5\0\xf7\0\xf7\0\xf5\xff\xd7\xff\xd6\xff\0\0\x01\0\x16\x01\x14\x01j\x01\x1c\0\x1a\0\x1b\x01\b\x01\xdb\xff\x19\x01\xb3\xff\xb4\xff'\x01\xb1\xff\xb2\xff3\x01\x1a\x01\x1e\x01\x1e\x01,\x01\xae\x01\x1f\0&\0\xda\xff\xcc\xffA\x01\xc3\xffV\x01\xc1\xff\xc2\xff3\x01A\x019\x01>\x01\xd5\xfff\x01h\x01\xcd\xff\xc6\xffa\x01\xcb\xffX\x01p\x01c\x01\xc9\xff\xca\xffc\x01w\x01t\x01\x84\x01r\x01\xc7\xff\xc8\xffu\x01\x85\x01y\x01|\x01{\x01\x89\x01{\x01\0\0\x90\x01*\0,\0\x97\xff\x8b\x01\xbf\xff\xc0\xff\xc5\xff\x86\x01\xc4\xff\x7f\x01\xb7\xff\xb5\xff\x9b\x01\x9c\x01\x89\x01\xaf\xff\xb0\xff\x9c\x01\xad\xff\xae\xff\xa3\x01\xa0\x01\xe3\x01\xaa\x01\xde\x01\xe1\x01\xa6\xff\xa8\x01\xba\x01\xc6\x01\xcb\x01\xb8\x01\xfd\x01\xff\x01\xcf\x01\t\x02\t\x02\f\x02\xa1\xff\x9f\xff\xda\x01\x0e\x02\x0e\x02\x11\x02\xa0\xff\x9e\xff\x18\x02~\x03\xd6\x01\xe6\x01\xdf\x01\xdb\x01\xd6\x01\xe8\x01\xe4\x01\xe7\x01\xe6\x01\xf4\x01\xe6\x01,\x02\xf6\x01'\x026\x02\x96\xff\xf8\x01\b\x02\n\x02\x15\x02\x1b\x02\b\x02M\x02O\x02&\x02]\x02_\x02\xa5\xff)\x02`\x02b\x02\xa4\xff&\x02*\x02)\x02\x86\xff.\x02\xf2\xff\xf8\xff\xf9\xff\xfa\xff\xd1\x03F\x04\xf7\xff9\x04\xa4\x047\x02r\x02u\x02z\x02\xb7\x03D\x02H\x029\x02F\x02K\x02>\x02E\x02Q\x02M\x02M\x02\xbd\x03\x97\x02T\x02x\x02F\x02t\x02^\x02R\x02g\x02\x8a\x02x\x02\xbd\x02\xbf\x02\x86\x02\xcf\x02\xca\x02\xd2\x02\x9d\xff\x9b\xff\xa4\x02\xdf\x02\xe2\x02\xef\x02\x9c\xff\x9a\xff\xaf\x02\xba\x02\xbd\x02\xb7\x02\xb8\xff\xba\x02\xd1\xff\xa9\xff\xaa\xff\xce\x02\xd7\x02\xdd\xff\xda\x02\xcb\x02\xcf\x02\xcd\x02\xdb\x02\xdc\xff\xd3\x02\xd2\xff\xbd\xff\xee\x02\xdc\x02\xd4\xff\xeb\x02\xdf\x02\xec\x02\xce\xff\t\x03\xfb\x02\xd3\xff\xbe\xff\0\x03\x02\x03\0\x03\xd0\xff\xfe\x02\x06\x03\x12\x03\xcf\xff\xfe\x02\t\x03\f\x03\xbc\xff\xba\xff\xb9\xff\f\x03\x05\x03\xbb\xff\x17\x03\x1f\x03/\x03f\x031\x03b\x03e\x03\xa3\xff\xac\xff\xa7\xff\xa8\xff1\x03-\x03(\x038\x03,\x03/\x03.\x03<\x038\x03\x8a\x03Q\x03\x88\x03\x8b\x03\x99\xff\x90\x03\x1f\x04Z\x03N\x03X\x03S\x03V\x03U\x03Q\x03a\x03\x98\x03l\x03\xad\x03\xb2\x03\xa2\xff}\x03y\x03t\x03\x84\x03}\x03\x84\x03\x83\x03\x92\x03\x8b\x03\xd1\x03\xa2\x03\xd6\x03\xd9\x03\x98\xff\xab\x03\x92\xff\x9c\x03\xa7\x03\x98\x03\xb3\x03\xaa\x03\xb2\x03\xbe\x03\xf4\xff\xbf\x03\xb9\x03\xeb\x03\x97\x04\xa2\x04\xac\x04\xb6\x04\xdc\x04\xc9\x03\xbd\x03\xbc\x03\xd9\x03\xc0\x04\xc1\x03\xc8\x03\xd6\x03\xce\x03\xce\x03\xd0\x03\xdf\x03\xd5\x03\xdc\x03\xd4\x03\xd2\x03\xf9\x03\x02\x04\x0f\x04\x80\xff\xfe\x03\x14\x04\n\x04\x0e\x04\x14\x04\x7f\xff\x13\x04\r\x04(\x04\x1f\x04\x1b\x04\x14\x04-\x04$\x04+\x041\x04~\xff*\x04.\x04*\x04.\x04?\x04?\x047\x04_\x04}\xff|\x04|\x04\x80\x04\x85\x04\x95\x04\x87\x04\x95\x04\x8f\x04{\xff\x9d\x04\x8f\x04z\xff\x99\x04\xa1\x04\x8e\x04\x91\x04\x91\x04\x9d\x04\x98\x04\x9a\x04y\xff\x9c\x04\xa6\x04\x97\x04\xf3\xff\xa1\x04\xba\x04\xc2\x04\x8c\xff\xb9\x04\xb8\x04\xb2\x04\x8a\xff\xba\x04\xc9\x04\xce\x04\xcd\x04\xc9\x04\xd5\x04\xd5\x04\xcc\x04\xd4\x04\xf1\xff\xc6\x04\xcc\x04\xcc\x04\xf0\xff\xe2\x04\x88\xff\xe5\x04\xd6\x04\xe4\x04\xdd\x04\xef\xff\xe0\x04\xe9\x04\xe5\x04\xeb\xff\xea\x04\xe1\x04\xe9\x04\xea\xff\xec\x04\xef\x04\xe1\x04\xee\xff\xe6\x04\x8e\xff\xe3\x04\xf0\x04\xf2\x04\xed\xff\xea\x04\xf3\x04\xe6\xff\x89\xff\xea\x04\xe8\x04\xe8\x04\x85\xff\xf6\x04\xf5\x04\xea\x04\xeb\x04\xef\x04\xf4\x04\xe9\xff\xf8\x04\xf1\x04\x8f\xff\xf3\x04\xf3\x04\x03\x05\xf9\x04\x83\xff\n\x05\xfd\x04\t\x05\n\x05\x02\x05\xe7\xff\x12\x05\x06\x05\x04\x05\x11\x05\x14\x05\n\x05\xe0\xff\x12\x05\x93\xff\f\x05\x14\x05\x8b\xff\b\x05\x1a\x05\x10\x05\x1e\x05\x19\x05\x1c\x05\f\x05\xe5\xff\x1a\x05\x16\x05\x14\x05\"\x05&\x05\x1c\x05\xe1\xff\x1a\x05(\x05*\x05 \x05\xde\xff\x1b\x05\x1a\x05\x91\xff&\x05 \x05\x1d\x05\x84\xff \x05'\x05(\x056\x05-\x05)\x054\x050\x05(\x056\x059\x05)\x05\xe3\xff,\x05:\x052\x05-\x05C\x056\x05@\x059\x058\x056\x050\x05\x95\xff;\x05<\x058\x05N\x05G\x05C\x05A\x05N\x05Q\x05H\x05\xe2\xffF\x05T\x05V\x05L\x05\xdf\xffB\x05[\x05N\x05W\x05P\x05O\x05M\x05G\x05\x94\xff_\x05a\x05W\x05\x8d\xffP\x05_\x05S\x05b\x05T\x05\x8c\x05\x9a\x05\xa4\x05\xae\x05\xb8\x05\xcf\x05\x82\x05~\x05\x80\x05w\xff\x83\x05\x95\x05\x8a\x05\x90\xff\x15\x06\xee\x05t\xffu\xff\x02\x06\xfb\xff\xfc\xff\xfd\xff\xce\x05\x01\0\xff\xff\xfe\xff",
  /* lex_backtrk */"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x90\0\x02\0\x02\0\xff\xff\0\0\xff\xff\xff\xff\x04\0\xff\xff\x02\0\xff\xff\xff\xff\x02\0\xff\xff\x02\0\x04\0\xff\xff\x04\0\x04\0\xff\xff\xff\xff\xff\xff\x03\0\x03\0\xff\xff\x03\0\x03\0\x03\0\xff\xff\x04\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x04\0\xff\xff\xff\xff\xff\xff\x04\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\t\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\"\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff#\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xffI\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\t\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\b\0\b\0\xff\xff\xff\xff\xff\xff\t\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xffT\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\t\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'\0'\0\xff\xff'\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x83\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x13\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1b\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff~\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xffx\0\xff\xff&\0&\0\xff\xff&\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x89\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x04\0\x04\0\xff\xff\xff\xff",
  /* lex_default */"\x01\0\0\0\0\0\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\0\0\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\0\0\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\0\0\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\0\0\0\0\xff\xff\0\0\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\0\0\0\0\0\0\x01\x01\0\x01\0\0\xff\xff\0\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\0\0\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\0\0\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\xff\xff\xa9\x02\0\0\0\0\xad\x02\0\0\0\0\0\0\xff\xff\xff\xff\0\0\0\0",
  /* lex_trans */'\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\x16\0\0\0\x06\0\0\0\0\0\0\0\x1d\0\x1c\0\xb2\x02\x19\0\0\0\x19\0O\0\xa5\0\x1b\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0>\0\x05\0\xa9\x02\x1e\0,\0?\0,\0\xd4\0N\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0&\0n\0&\0n\0\x7f\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0\x7f\0\xa7\0\xa8\0t\0q\0\x14\0\x10\0\n\0\x11\0\x0e\0\x15\0\t\0\xa4\x02\x18\0z\x02#\x02\x0f\0\x13\0\x17\0\b\0\x07\0x\x02\r\0\x0b\0\f\0\x12\0\xa8\x02y\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\x11\x02\xf4\x01\xa8\x02\xa8\x02\x96\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\x95\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02<\0\xa8\x025\0\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02`\x02\xa8\x02D\x02\xa8\x02F\x022\x02\x18\x02\x05\x02\x19\x024\x02\xfe\x01<\x005\x02\x04\x02\xe8\x01\x96\x016\0\x97\x01\x17\x02E\x02_\x027\0\x95\x01\x06\x01\xe9\x01\xfa\0\x05\x01\xff\x018\x003\x02\xea\x019\0:\0E\0;\0=\0D\x000\0/\0/\0/\0/\0/\0/\0/\0/\0/\0@\0\x02\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfd\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xf6\0L\0\xfe\0C\0I\0J\0K\0M\0\x04\x01\xc1\0B\0F\0\xba\0.\0\xb1\0\xaf\0\xad\0 \0-\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0 \0\x1f\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\x006\0\xac\0\xb2\0\x97\0\x91\0\x8f\0\x86\0w\0\x8c\0\xff\0G\0\x1f\0f\0\x96\0e\0b\0H\0\xb3\0\x8b\0y\0x\0\x1f\0c\0d\0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0`\0j\0k\0a\0o\0p\0\x80\0p\0_\0\x1f\0\xfc\0\x1f\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0s\0z\0r\0g\0{\0|\0!\0"\0"\0"\0"\0"\0"\0i\0v\0m\0u\0l\0h\0\x82\0\x83\0\x1f\0n\0\x87\0\x88\0\x81\0$\0\x89\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0\x8a\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0%\0"\0$\0$\0$\0$\0$\0$\0$\0$\0$\0$\0\x85\0\x8e\0\x84\0\x8d\0\x90\0\x92\0\x93\0$\0$\0$\0$\0)\0$\0\x95\0\xa9\0\x94\0"\0"\0"\0"\0%\0"\0~\0\x98\0}\0\x9d\0\x9a\0\x99\0\x9c\0\x7f\0\x9b\0#\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0$\0$\0$\0$\0)\0$\0\xa6\0\xab\0\xae\0\xb0\0\xb7\0\xb4\0\xb6\0\xaa\0\xb5\0#\0&\0\xfd\0&\0$\0\xbb\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\xb9\0\xbc\0\xb8\0\xbd\0\xbe\0\xbf\0\xc0\0"\0"\0"\0"\0%\0"\0$\0\xc2\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\'\0\xc3\0\xc4\0\xc5\0\xc7\0\xce\0\xc6\0\xc8\0"\0"\0"\0"\0%\0"\0\xc9\0"\0"\0"\0"\0%\0"\0\xcb\0\xcd\0\xcc\0\xca\0\xcf\0\xd1\0\xd3\0\xd2\0\xd0\0#\0\xd5\0\xaf\0\xd9\0\xda\0\xdb\0\xd8\0\x99\0\xdc\0\xe6\0"\0"\0"\0"\0%\0"\0\x96\0\xdd\0\xde\0\xdf\0\xe0\0\xe1\0\xe2\0\xe3\0\xe4\0#\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0&\0\xe5\0&\0\xe7\0\xe8\0*\0*\0*\0*\0*\0*\0*\0*\0*\0*\0\xe9\0\xea\0\xeb\0\xed\0\xf2\0\xec\0\xee\0$\0$\0$\0$\0)\0$\0*\0*\0*\0*\0*\0*\0*\0*\0*\0*\0\xef\0\xf0\0\xf1\0\xf3\0\xf4\0\xf5\0\xf7\0$\0$\0$\0$\0)\0$\0\xf8\0\xf9\0\xfb\0$\0$\0$\0$\0)\0$\0\x93\x01v\x01\x07\x01\b\x01h\x01e\x01Z\x01T\x01f\x01#\0[\x01P\x01L\x01A\x01I\x01U\x01H\x01$\0$\0$\0$\0)\0$\0g\x011\x019\x01,\x01V\x01:\x018\x01\x1a\x01\x1b\x01#\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0 \0\x1c\x01/\0/\0/\0/\0/\0/\0/\0/\0/\0/\0\x18\x01c\0\x17\x01\x1d\x01\x19\x01\x1f\x01&\x01\x1e\x01 \x01!\x01 \0\x1f\0/\0/\0/\0/\0/\0/\0/\0/\0/\0/\0\x15\x01Z\0%\x01^\0X\0T\0#\x01R\0$\x01"\x01\x16\x01\x1f\0]\0Y\0S\0V\0[\0\'\x01W\0\\\0P\0\x1f\0)\x01Q\0U\0(\x01+\x012\x002\x002\x002\x002\x002\x002\x002\x002\x002\0*\x01-\x01.\x01/\x010\x012\x01\x1f\x002\x002\x002\x002\x002\x002\0$\x006\x012\x002\x002\x002\x002\x002\x002\x002\x002\x002\x001\x007\x01@\x01>\x01;\x01<\x01=\x012\x002\x002\x002\x003\x002\0?\x012\x002\x002\x002\x002\x002\0D\x01B\x01E\x01&\0F\x01&\0$\0C\x014\x004\x004\x004\x004\x004\x004\x004\x004\x004\0G\x012\x002\x002\x002\x003\x002\x002\x002\x002\x002\x003\x002\0K\x01J\x01M\x01#\0N\x01O\x01Q\x01R\x01S\x01Y\x01X\x01W\x01]\x01$\0\\\x014\x004\x004\x004\x004\x004\x004\x004\x004\x004\0^\x012\x002\x002\x002\x003\x002\x002\x002\x002\x002\x003\x002\0_\x01`\x01a\x01#\0b\x01c\x01d\x01i\x01j\x01k\x01l\x01m\x01n\x01o\x01p\x01A\0A\0A\0A\0A\0A\0A\0A\0A\0A\0q\x012\x002\x002\x002\x003\x002\0A\0A\0A\0A\0A\0A\0r\x01s\x01t\x01#\0u\x01w\x01\x85\x01{\x01[\x01|\x01}\x01~\x01\x7f\x01\x80\x01\x81\x01A\0A\0A\0A\0A\0A\0A\0A\0A\0A\0\x82\x01A\0A\0A\0A\0A\0A\0A\0A\0A\0A\0A\0A\0Z\0\x83\x01^\0X\0\xd6\0\x84\x01R\0\x86\x01\x87\x01\x88\x01\x89\x01]\0Y\0S\0V\0[\0\x8a\x01\xd7\0\\\0P\0\x03\x01\x8b\x01\x8c\x01U\0\x8d\x01\x03\x01A\0A\0A\0A\0A\0A\0\x8e\x01\x8f\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x90\x01\x91\x01\x92\x01\x94\x01\xa5\x01\x9d\x01\x98\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x10\x01\x99\x01\x14\x01\f\x01\x0b\x01\x0f\x01\n\x01\x9a\x01\x9b\x01\x9c\x013\x01\x13\x01\r\x01\x11\x01\x9e\x01\x9f\x01\xa0\x01\t\x01\x12\x01\x0e\x015\x01\x03\x01\xa6\x01\xa7\x01\xa8\x014\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\xa9\x01\xdf\x01\xdc\x01\xd3\x01\xca\x01\xbf\x01\xb9\x01\x03\x01\xb1\x01\xb2\x01\xb3\x01\xb4\x01\xb5\x01\x03\x01\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfd\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xb6\x01\xb7\x01\xfe\0\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\xb8\x01\xba\x01\xbb\x01\xbc\x01\xbd\x01\xbe\x01\xc0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\x10\x01\xc1\x01\x14\x01z\x01\x0b\x01\x0f\x01\n\x01\xc2\x01\xc3\x01\xc4\x01\xc5\x01\x13\x01\r\x01\x11\x01\xc6\x01y\x01\xc7\x01x\x01\x12\x01\x0e\x01\xc8\x01\xc9\x01\xcb\x01\xcc\x01\xcd\x01\xce\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\xcf\x01\xd0\x01\xff\0\xd1\x01\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfd\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xfc\0\xd2\x01\xfc\0\xfe\0\xa2\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xff\xff\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xd4\x01\xd5\x01\xd6\x01\xd7\x01\xd8\x01\xd9\x01\xda\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xdb\x01\xdd\x01\xde\x01\xff\0\xe0\x01\xe1\x01\xe2\x01\xe3\x01\xe4\x01\xe5\x01\xe6\x01\xe7\x01\xf0\x01\xec\x01\xeb\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xed\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xfc\0\xa3\x01\xaa\x01\xee\x01\xef\x01\xf1\x01\xaf\x01\xf2\x01\xf3\x01\xf5\x01\xb0\x01\xf6\x01\xf7\x01\xf8\x01\xf9\x01\xac\x01\xae\x01\xab\x01\xad\x01\xfa\x01\xfb\x01\xfc\x01\xfd\x01\x02\x02\0\x02\x01\x02\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x03\x02\t\x02\x06\x02\xfd\0\x07\x02\b\x02\x0b\x02\r\x02\f\x02\x0e\x02\x0f\x02\x10\x02\x12\x02\x15\x02\x14\x02\x16\x02\x1f\x02\n\x02\x1b\x02\x1a\x02\x1e\x02\x1d\x02 \x02!\x02\x13\x02"\x02$\x02-\x02*\x02\'\x02(\x02)\x02\x1c\x02+\x02,\x02.\x02/\x020\x02%\x02&\x021\x02A\x02?\x028\x026\x027\x029\x02:\x02;\x02<\x02=\x02>\x02@\x02B\x02C\x02[\x02X\x02H\x02L\x02I\x02J\x02K\x02M\x02S\x02O\x02G\x02P\x02N\x02Q\x02R\x02T\x02U\x02V\x02W\x02Y\x02Z\x02\\\x02]\x02^\x02l\x02a\x02b\x02c\x02d\x02e\x02f\x02g\x02h\x02i\x02j\x02k\x02m\x02n\x02o\x02p\x02q\x02r\x02\xfd\0s\x02t\x02u\x02v\x02w\x02\x91\x02\x88\x02{\x02|\x02}\x02\x83\x02\x7f\x02\x80\x02\x81\x02~\x02\x82\x02\x84\x02\x85\x02\x86\x02\x87\x02\x89\x02\x8a\x02\x8b\x02\x8c\x02\x8d\x02\x8e\x02\x8f\x02\x90\x02\x92\x02\x93\x02\x94\x02\xa0\x02\x97\x02\x98\x02\x99\x02\x9a\x02\x9b\x02\x9d\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\xa1\x02\xa2\x02\xa3\x02\xa5\x02\xa6\x02\xa7\x02\xaa\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\xb3\x02\0\0\0\0\xaf\x02\0\0\0\0\0\0\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\0\0\0\0\0\0\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9e\x02\0\0\0\0\0\0\xb0\x02\0\0\0\0\0\0\0\0\0\0\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\xa8\x02\0\0\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xb1\x02\0\0\xa8\x02\xa8\x02\0\0\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\0\0\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\0\0\xa8\x02\0\0\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\0\0\xa8\x02\0\0\xa8\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xab\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xae\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  /* lex_check */"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\0\0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\0\0\xff\xff\0\0\xff\xff\0\0\xff\xff\xff\xff\xff\xff\0\0\0\0\xb1\x02\0\0\xff\xff\0\0N\0\xa4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0=\0\0\0\x05\0\x1d\0\x1f\0>\0\x1f\0D\0E\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0#\0l\0#\0m\0}\0#\0#\0#\0#\0#\0#\0#\0#\0#\0#\0~\0\xa6\0\xa7\0g\0h\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x07\0\0\0\t\0\r\0\0\0\0\0\0\0\0\0\0\0\t\0\0\0\0\0\0\0\0\0\x06\0\t\0\x06\0\x06\0\x06\0\x06\0\x06\0\x0f\0\x12\0\x06\0\x06\0\b\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\b\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0-\0\x06\0.\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\n\0\x06\0\x0b\0\x06\0\x0b\0\f\0\x0e\0\x10\0\x0e\0\f\0\x11\0\x17\0\f\0\x10\0\x13\0\x14\x005\0\x14\0\x0e\0\x0b\0\n\x006\0\x14\0\x15\0\x13\0\x17\0\x15\0\x11\x007\0\f\0\x13\x008\x009\0\x18\0:\0<\0\x18\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0?\0\0\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0\x16\0B\0G\0\x16\0\x18\0H\0I\0J\0L\0\x15\0P\0\x18\0\x18\0Q\0\x19\0S\0T\0U\0\x1a\0\x19\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0\x1a\0&\0&\0&\0&\0&\0&\0&\0&\0&\0&\0\x1b\0\x1a\0\x1b\0\x1b\0\x1b\0\x1b\0\x1b\0\x1b\0\x1b\0\x1b\0\x1b\0\x1b\0F\0V\0R\0W\0X\0Y\0[\0\\\0Z\0\x16\0F\0\x1b\0_\0W\0`\0a\0F\0R\0Z\0\\\0\\\0\x1a\0b\0c\0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0^\0i\0j\0^\0n\0o\0x\0o\0^\0\x1b\0\x16\0 \0!\0!\0!\0!\0!\0!\0!\0!\0!\0!\0q\0y\0q\0]\0z\0{\0\x1b\0!\0!\0!\0!\0!\0!\0]\0t\0k\0t\0k\0]\0w\0\x81\0 \0k\0\x86\0\x87\0w\0\"\0\x88\0\"\0\"\0\"\0\"\0\"\0\"\0\"\0\"\0\"\0\"\0\x89\0!\0!\0!\0!\0!\0!\0\"\0\"\0\"\0\"\0\"\0\"\0$\0$\0$\0$\0$\0$\0$\0$\0$\0$\0\x83\0\x8b\0\x83\0\x8c\0\x8f\0\x91\0\x92\0$\0$\0$\0$\0$\0$\0\x93\0\x96\0\x93\0\"\0\"\0\"\0\"\0\"\0\"\0|\0\x97\0|\0\x98\0\x99\0\x97\0\x9a\0|\0\x9a\0\"\0\x9d\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0$\0$\0$\0$\0$\0$\0\xa5\0\xa9\0\xad\0\xaf\0\xb2\0\xb3\0\xb4\0\xa9\0\xb4\0$\0%\0\x16\0%\0%\0\xba\0%\0%\0%\0%\0%\0%\0%\0%\0%\0%\0\xb7\0\xbb\0\xb7\0\xbc\0\xbd\0\xbe\0\xbf\0%\0%\0%\0%\0%\0%\0'\0\xc1\0'\0'\0'\0'\0'\0'\0'\0'\0'\0'\0\xc2\0\xc3\0\xc4\0\xc5\0\xc6\0\xc5\0\xc7\0'\0'\0'\0'\0'\0'\0\xc8\0%\0%\0%\0%\0%\0%\0\xc9\0\xca\0\xcb\0\xc9\0\xce\0\xcf\0\xd0\0\xd1\0\xcf\0%\0\xd4\0\xd6\0\xd8\0\xd9\0\xda\0\xd7\0\xd8\0\xdb\0\xd6\0'\0'\0'\0'\0'\0'\0\xd7\0\xdc\0\xdd\0\xde\0\xdf\0\xe0\0\xe1\0\xe2\0\xe3\0'\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0)\0\xe4\0)\0\xe6\0\xe7\0)\0)\0)\0)\0)\0)\0)\0)\0)\0)\0\xe8\0\xe9\0\xea\0\xeb\0\xec\0\xeb\0\xed\0)\0)\0)\0)\0)\0)\0*\0*\0*\0*\0*\0*\0*\0*\0*\0*\0\xee\0\xef\0\xf0\0\xf2\0\xf3\0\xf4\0\xf6\0*\0*\0*\0*\0*\0*\0\xf7\0\xf8\0\xfa\0)\0)\0)\0)\0)\0)\0\x04\x01\x05\x01\x06\x01\x07\x01\t\x01\x0b\x01\f\x01\r\x01\n\x01)\0\f\x01\x0e\x01\x0f\x01\x11\x01\x10\x01\r\x01\x10\x01*\0*\0*\0*\0*\0*\0\n\x01\x15\x01\x12\x01\x17\x01\r\x01\x12\x01\x12\x01\x19\x01\x1a\x01*\0+\0+\0+\0+\0+\0+\0+\0+\0+\0+\0,\0,\0,\0,\0,\0,\0,\0,\0,\0,\0/\0\x1b\x01/\0/\0/\0/\0/\0/\0/\0/\0/\0/\0\x16\x01\x18\x01\x16\x01\x1c\x01\x18\x01\x1d\x01\x1e\x01\x1d\x01\x1f\x01 \x010\0/\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\0\x14\x01O\0\"\x01O\0O\0O\0!\x01O\0#\x01!\x01\x14\x010\0O\0O\0O\0O\0O\0&\x01O\0O\0O\0/\0'\x01O\0O\0'\x01(\x011\x001\x001\x001\x001\x001\x001\x001\x001\x001\0)\x01,\x01-\x01.\x01/\x011\x010\x001\x001\x001\x001\x001\x001\x002\x005\x012\x002\x002\x002\x002\x002\x002\x002\x002\x002\x000\x006\x018\x019\x01:\x01;\x01<\x012\x002\x002\x002\x002\x002\0>\x011\x001\x001\x001\x001\x001\0B\x01A\x01D\x013\0E\x013\x003\0A\x013\x003\x003\x003\x003\x003\x003\x003\x003\x003\0F\x012\x002\x002\x002\x002\x002\x003\x003\x003\x003\x003\x003\0H\x01I\x01L\x012\0M\x01N\x01P\x01Q\x01R\x01T\x01U\x01V\x01Z\x014\0[\x014\x004\x004\x004\x004\x004\x004\x004\x004\x004\0]\x013\x003\x003\x003\x003\x003\x004\x004\x004\x004\x004\x004\0^\x01_\x01`\x013\0a\x01b\x01c\x01h\x01i\x01j\x01k\x01l\x01m\x01n\x01o\x01@\0@\0@\0@\0@\0@\0@\0@\0@\0@\0p\x014\x004\x004\x004\x004\x004\0@\0@\0@\0@\0@\0@\0q\x01r\x01s\x014\0t\x01v\x01x\x01y\x01z\x01{\x01|\x01}\x01~\x01\x7f\x01\x80\x01A\0A\0A\0A\0A\0A\0A\0A\0A\0A\0\x81\x01@\0@\0@\0@\0@\0@\0A\0A\0A\0A\0A\0A\0\xd5\0\x82\x01\xd5\0\xd5\0\xd5\0\x83\x01\xd5\0\x85\x01\x86\x01\x87\x01\x88\x01\xd5\0\xd5\0\xd5\0\xd5\0\xd5\0\x89\x01\xd5\0\xd5\0\xd5\0\xff\0\x8a\x01\x8b\x01\xd5\0\x8c\x01\xff\0A\0A\0A\0A\0A\0A\0\x8d\x01\x8e\x01\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\x8f\x01\x90\x01\x91\x01\x93\x01\x95\x01\x96\x01\x97\x01\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\b\x01\x98\x01\b\x01\b\x01\b\x01\b\x01\b\x01\x99\x01\x9a\x01\x9b\x01\x13\x01\b\x01\b\x01\b\x01\x9d\x01\x9e\x01\x9f\x01\b\x01\b\x01\b\x01\x13\x01\xff\0\xa5\x01\xa6\x01\xa7\x01\x13\x01\xff\0\xff\0\xff\0\xff\0\xff\0\xff\0\xa8\x01\xaa\x01\xab\x01\xac\x01\xad\x01\xae\x01\xaf\x01\xff\0\xb0\x01\xb1\x01\xb2\x01\xb3\x01\xb4\x01\xff\0\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\xb5\x01\xb6\x01\0\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\xb7\x01\xb9\x01\xba\x01\xbb\x01\xbc\x01\xbd\x01\xbf\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01w\x01\xc0\x01w\x01w\x01w\x01w\x01w\x01\xc1\x01\xc2\x01\xc3\x01\xc4\x01w\x01w\x01w\x01\xc5\x01w\x01\xc6\x01w\x01w\x01w\x01\xc7\x01\xc8\x01\xca\x01\xcb\x01\xcc\x01\xcd\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\x02\x01\xce\x01\xcf\x01\0\x01\xd0\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\x03\x01\xd1\x01\0\x01\x03\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xff\0\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xd3\x01\xd4\x01\xd5\x01\xd6\x01\xd7\x01\xd8\x01\xd9\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xda\x01\xdc\x01\xdd\x01\x03\x01\xdf\x01\xe0\x01\xe1\x01\xe2\x01\xe3\x01\xe4\x01\xe5\x01\xe6\x01\xe8\x01\xe9\x01\xea\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xec\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x03\x01\xa2\x01\xa9\x01\xed\x01\xee\x01\xf0\x01\xa9\x01\xf1\x01\xf2\x01\xf4\x01\xa9\x01\xf5\x01\xf6\x01\xf7\x01\xf8\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xf9\x01\xfa\x01\xfb\x01\xfc\x01\xfe\x01\xff\x01\0\x02\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x02\x02\x04\x02\x05\x02\0\x01\x06\x02\x07\x02\t\x02\n\x02\x0b\x02\r\x02\x0e\x02\x0f\x02\x11\x02\x12\x02\x13\x02\x15\x02\x17\x02\t\x02\x18\x02\x19\x02\x1b\x02\x1c\x02\x1f\x02 \x02\x11\x02!\x02#\x02$\x02%\x02&\x02'\x02(\x02\x18\x02*\x02+\x02-\x02.\x02/\x02#\x02#\x020\x022\x023\x024\x025\x026\x028\x029\x02:\x02;\x02<\x02=\x02?\x02A\x02B\x02D\x02E\x02F\x02G\x02H\x02I\x02J\x02L\x02M\x02N\x02F\x02O\x02L\x02P\x02Q\x02S\x02T\x02U\x02V\x02X\x02Y\x02[\x02\\\x02]\x02_\x02`\x02a\x02b\x02c\x02d\x02e\x02f\x02g\x02h\x02i\x02j\x02l\x02m\x02n\x02o\x02p\x02q\x02\x03\x01r\x02s\x02t\x02u\x02v\x02x\x02y\x02z\x02{\x02|\x02}\x02~\x02\x7f\x02\x80\x02|\x02\x81\x02\x83\x02\x84\x02\x85\x02\x86\x02\x88\x02\x89\x02\x8a\x02\x8b\x02\x8c\x02\x8d\x02\x8e\x02\x8f\x02\x91\x02\x92\x02\x93\x02\x95\x02\x96\x02\x97\x02\x98\x02\x99\x02\x9a\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9b\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9c\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9d\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\xa0\x02\xa1\x02\xa2\x02\xa4\x02\xa5\x02\xa6\x02\xa9\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\xb0\x02\xff\xff\xff\xff\xac\x02\xff\xff\xff\xff\xff\xff\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\xff\xff\xff\xff\xff\xff\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\x9e\x02\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9d\x02\xff\xff\xff\xff\xff\xff\xac\x02\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\x9f\x02\xa8\x02\xff\xff\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xac\x02\xff\xff\xa8\x02\xa8\x02\xff\xff\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xff\xff\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xff\xff\xa8\x02\xff\xff\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xa8\x02\xff\xff\xa8\x02\xff\xff\xa8\x02\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa9\x02\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xac\x02\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
  /* lex_base_code */"",
  /* lex_backtrk_code */"",
  /* lex_default_code */"",
  /* lex_trans_code */"",
  /* lex_check_code */"",
  /* lex_code */""
];

function token(lexbuf) {
  var lexbuf$1 = lexbuf;
  var ___ocaml_lex_state = 0;
  while(true) {
    var __ocaml_lex_state = ___ocaml_lex_state;
    var __ocaml_lex_state$1 = Lexing.engine(__ocaml_lex_tables, __ocaml_lex_state, lexbuf$1);
    if (__ocaml_lex_state$1 > 144 || __ocaml_lex_state$1 < 0) {
      Curry._1(lexbuf$1[/* refill_buff */0], lexbuf$1);
      ___ocaml_lex_state = __ocaml_lex_state$1;
      continue ;
      
    }
    else {
      switch (__ocaml_lex_state$1) {
        case 0 : 
            return /* LPAR */2;
        case 1 : 
            return /* RPAR */3;
        case 2 : 
            var s = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_curr_pos */5]);
            return /* NAT */Block.__(0, [s]);
        case 3 : 
            var s$1 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_curr_pos */5]);
            return /* INT */Block.__(1, [s$1]);
        case 4 : 
            var s$2 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_curr_pos */5]);
            return /* FLOAT */Block.__(2, [s$2]);
        case 5 : 
            var s$3 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_curr_pos */5]);
            return /* TEXT */Block.__(3, [text(s$3)]);
        case 6 : 
            return error(lexbuf$1, "unclosed text literal");
        case 7 : 
            return error(lexbuf$1, "illegal control character in text literal");
        case 8 : 
            return error_nest(Lexing.lexeme_end_p(lexbuf$1), lexbuf$1, "illegal escape");
        case 9 : 
            var t = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* VALUE_TYPE */Block.__(5, [value_type(t)]);
        case 10 : 
            var t$1 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONST */Block.__(10, [numop(t$1, function (s) {
                            var n = Curry._1(I32.of_string, s[/* it */1]);
                            return /* tuple */[
                                    Operators.i32_const(Source.$at$at(n, s[/* at */0])),
                                    /* I32 */Block.__(0, [n])
                                  ];
                          }, function (s) {
                            var n = Curry._1(I64.of_string, s[/* it */1]);
                            return /* tuple */[
                                    Operators.i64_const(Source.$at$at(n, s[/* at */0])),
                                    /* I64 */Block.__(1, [n])
                                  ];
                          }, function (s) {
                            var n = Curry._1(F32.of_string, s[/* it */1]);
                            return /* tuple */[
                                    Operators.f32_const(Source.$at$at(n, s[/* at */0])),
                                    /* F32 */Block.__(2, [n])
                                  ];
                          }, function (s) {
                            var n = Curry._1(F64.of_string, s[/* it */1]);
                            return /* tuple */[
                                    Operators.f64_const(Source.$at$at(n, s[/* at */0])),
                                    /* F64 */Block.__(3, [n])
                                  ];
                          })]);
        case 11 : 
            return /* ANYFUNC */0;
        case 12 : 
            return /* MUT */1;
        case 13 : 
            return /* NOP */4;
        case 14 : 
            return /* UNREACHABLE */24;
        case 15 : 
            return /* DROP */5;
        case 16 : 
            return /* BLOCK */6;
        case 17 : 
            return /* LOOP */12;
        case 18 : 
            return /* END */7;
        case 19 : 
            return /* BR */13;
        case 20 : 
            return /* BR_IF */14;
        case 21 : 
            return /* BR_TABLE */15;
        case 22 : 
            return /* RETURN */18;
        case 23 : 
            return /* IF */8;
        case 24 : 
            return /* THEN */9;
        case 25 : 
            return /* ELSE */10;
        case 26 : 
            return /* SELECT */11;
        case 27 : 
            return /* CALL */16;
        case 28 : 
            return /* CALL_INDIRECT */17;
        case 29 : 
            return /* GET_LOCAL */19;
        case 30 : 
            return /* SET_LOCAL */20;
        case 31 : 
            return /* TEE_LOCAL */21;
        case 32 : 
            return /* GET_GLOBAL */22;
        case 33 : 
            return /* SET_GLOBAL */23;
        case 34 : 
            var t$2 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* LOAD */Block.__(6, [(function(t$2){
                      return function (a, o) {
                        var partial_arg = Curry._2(opt, a, 2);
                        var partial_arg$1 = Curry._2(opt, a, 3);
                        var partial_arg$2 = Curry._2(opt, a, 2);
                        var partial_arg$3 = Curry._2(opt, a, 3);
                        return Curry._1(numop(t$2, function (param) {
                                        return Operators.i32_load(partial_arg, param);
                                      }, function (param) {
                                        return Operators.i64_load(partial_arg$1, param);
                                      }, function (param) {
                                        return Operators.f32_load(partial_arg$2, param);
                                      }, function (param) {
                                        return Operators.f64_load(partial_arg$3, param);
                                      }), o);
                      }
                      }(t$2))]);
        case 35 : 
            var t$3 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* STORE */Block.__(7, [(function(t$3){
                      return function (a, o) {
                        var partial_arg = Curry._2(opt, a, 2);
                        var partial_arg$1 = Curry._2(opt, a, 3);
                        var partial_arg$2 = Curry._2(opt, a, 2);
                        var partial_arg$3 = Curry._2(opt, a, 3);
                        return Curry._1(numop(t$3, function (param) {
                                        return Operators.i32_store(partial_arg, param);
                                      }, function (param) {
                                        return Operators.i64_store(partial_arg$1, param);
                                      }, function (param) {
                                        return Operators.f32_store(partial_arg$2, param);
                                      }, function (param) {
                                        return Operators.f64_store(partial_arg$3, param);
                                      }), o);
                      }
                      }(t$3))]);
        case 36 : 
            var t$4 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            var sz = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4] + 8 | 0, lexbuf$1[/* lex_curr_pos */5] - 2 | 0);
            var s$4 = Lexing.sub_lexeme_char(lexbuf$1, lexbuf$1[/* lex_curr_pos */5] - 1 | 0);
            if (t$4 === "i32" && sz === "32") {
              error(lexbuf$1, "unknown operator");
            }
            return /* LOAD */Block.__(6, [(function(t$4,sz,s$4){
                      return function (a, o) {
                        return intop(t$4, Curry._1(memsz(sz, Curry._1(ext(s$4, Operators.i32_load8_s, Operators.i32_load8_u), Curry._2(opt, a, 0)), Curry._1(ext(s$4, Operators.i32_load16_s, Operators.i32_load16_u), Curry._2(opt, a, 1)), function () {
                                            return Operators.unreachable;
                                          }), o), Curry._1(memsz(sz, Curry._1(ext(s$4, Operators.i64_load8_s, Operators.i64_load8_u), Curry._2(opt, a, 0)), Curry._1(ext(s$4, Operators.i64_load16_s, Operators.i64_load16_u), Curry._2(opt, a, 1)), Curry._1(ext(s$4, Operators.i64_load32_s, Operators.i64_load32_u), Curry._2(opt, a, 2))), o));
                      }
                      }(t$4,sz,s$4))]);
        case 37 : 
            var t$5 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            var sz$1 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4] + 9 | 0, lexbuf$1[/* lex_curr_pos */5]);
            if (t$5 === "i32" && sz$1 === "32") {
              error(lexbuf$1, "unknown operator");
            }
            return /* STORE */Block.__(7, [(function(t$5,sz$1){
                      return function (a, o) {
                        var partial_arg = Curry._2(opt, a, 0);
                        var partial_arg$1 = Curry._2(opt, a, 1);
                        var partial_arg$2 = Curry._2(opt, a, 0);
                        var partial_arg$3 = Curry._2(opt, a, 1);
                        var partial_arg$4 = Curry._2(opt, a, 2);
                        return intop(t$5, Curry._1(memsz(sz$1, function (param) {
                                            return Operators.i32_store8(partial_arg, param);
                                          }, function (param) {
                                            return Operators.i32_store16(partial_arg$1, param);
                                          }, function () {
                                            return Operators.unreachable;
                                          }), o), Curry._1(memsz(sz$1, function (param) {
                                            return Operators.i64_store8(partial_arg$2, param);
                                          }, function (param) {
                                            return Operators.i64_store16(partial_arg$3, param);
                                          }, function (param) {
                                            return Operators.i64_store32(partial_arg$4, param);
                                          }), o));
                      }
                      }(t$5,sz$1))]);
        case 38 : 
            var s$5 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4] + 7 | 0, lexbuf$1[/* lex_curr_pos */5]);
            return /* OFFSET_EQ_NAT */Block.__(8, [s$5]);
        case 39 : 
            var s$6 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4] + 6 | 0, lexbuf$1[/* lex_curr_pos */5]);
            return /* ALIGN_EQ_NAT */Block.__(9, [s$6]);
        case 40 : 
            var t$6 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [intop(t$6, Operators.i32_clz, Operators.i64_clz)]);
        case 41 : 
            var t$7 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [intop(t$7, Operators.i32_ctz, Operators.i64_ctz)]);
        case 42 : 
            var t$8 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [intop(t$8, Operators.i32_popcnt, Operators.i64_popcnt)]);
        case 43 : 
            var t$9 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$9, Operators.f32_neg, Operators.f64_neg)]);
        case 44 : 
            var t$10 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$10, Operators.f32_abs, Operators.f64_abs)]);
        case 45 : 
            var t$11 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$11, Operators.f32_sqrt, Operators.f64_sqrt)]);
        case 46 : 
            var t$12 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$12, Operators.f32_ceil, Operators.f64_ceil)]);
        case 47 : 
            var t$13 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$13, Operators.f32_floor, Operators.f64_floor)]);
        case 48 : 
            var t$14 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$14, Operators.f32_trunc, Operators.f64_trunc)]);
        case 49 : 
            var t$15 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* UNARY */Block.__(11, [floatop(t$15, Operators.f32_nearest, Operators.f64_nearest)]);
        case 50 : 
            var t$16 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$16, Operators.i32_add, Operators.i64_add)]);
        case 51 : 
            var t$17 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$17, Operators.i32_sub, Operators.i64_sub)]);
        case 52 : 
            var t$18 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$18, Operators.i32_mul, Operators.i64_mul)]);
        case 53 : 
            var t$19 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$19, Operators.i32_div_s, Operators.i64_div_s)]);
        case 54 : 
            var t$20 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$20, Operators.i32_div_u, Operators.i64_div_u)]);
        case 55 : 
            var t$21 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$21, Operators.i32_rem_s, Operators.i64_rem_s)]);
        case 56 : 
            var t$22 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$22, Operators.i32_rem_u, Operators.i64_rem_u)]);
        case 57 : 
            var t$23 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$23, Operators.i32_and, Operators.i64_and)]);
        case 58 : 
            var t$24 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$24, Operators.i32_or, Operators.i64_or)]);
        case 59 : 
            var t$25 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$25, Operators.i32_xor, Operators.i64_xor)]);
        case 60 : 
            var t$26 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$26, Operators.i32_shl, Operators.i64_shl)]);
        case 61 : 
            var t$27 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$27, Operators.i32_shr_s, Operators.i64_shr_s)]);
        case 62 : 
            var t$28 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$28, Operators.i32_shr_u, Operators.i64_shr_u)]);
        case 63 : 
            var t$29 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$29, Operators.i32_rotl, Operators.i64_rotl)]);
        case 64 : 
            var t$30 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [intop(t$30, Operators.i32_rotr, Operators.i64_rotr)]);
        case 65 : 
            var t$31 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$31, Operators.f32_add, Operators.f64_add)]);
        case 66 : 
            var t$32 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$32, Operators.f32_sub, Operators.f64_sub)]);
        case 67 : 
            var t$33 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$33, Operators.f32_mul, Operators.f64_mul)]);
        case 68 : 
            var t$34 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$34, Operators.f32_div, Operators.f64_div)]);
        case 69 : 
            var t$35 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$35, Operators.f32_min, Operators.f64_min)]);
        case 70 : 
            var t$36 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$36, Operators.f32_max, Operators.f64_max)]);
        case 71 : 
            var t$37 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* BINARY */Block.__(12, [floatop(t$37, Operators.f32_copysign, Operators.f64_copysign)]);
        case 72 : 
            var t$38 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* TEST */Block.__(15, [intop(t$38, Operators.i32_eqz, Operators.i64_eqz)]);
        case 73 : 
            var t$39 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$39, Operators.i32_eq, Operators.i64_eq)]);
        case 74 : 
            var t$40 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$40, Operators.i32_ne, Operators.i64_ne)]);
        case 75 : 
            var t$41 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$41, Operators.i32_lt_s, Operators.i64_lt_s)]);
        case 76 : 
            var t$42 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$42, Operators.i32_lt_u, Operators.i64_lt_u)]);
        case 77 : 
            var t$43 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$43, Operators.i32_le_s, Operators.i64_le_s)]);
        case 78 : 
            var t$44 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$44, Operators.i32_le_u, Operators.i64_le_u)]);
        case 79 : 
            var t$45 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$45, Operators.i32_gt_s, Operators.i64_gt_s)]);
        case 80 : 
            var t$46 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$46, Operators.i32_gt_u, Operators.i64_gt_u)]);
        case 81 : 
            var t$47 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$47, Operators.i32_ge_s, Operators.i64_ge_s)]);
        case 82 : 
            var t$48 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [intop(t$48, Operators.i32_ge_u, Operators.i64_ge_u)]);
        case 83 : 
            var t$49 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [floatop(t$49, Operators.f32_eq, Operators.f64_eq)]);
        case 84 : 
            var t$50 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [floatop(t$50, Operators.f32_ne, Operators.f64_ne)]);
        case 85 : 
            var t$51 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [floatop(t$51, Operators.f32_lt, Operators.f64_lt)]);
        case 86 : 
            var t$52 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [floatop(t$52, Operators.f32_le, Operators.f64_le)]);
        case 87 : 
            var t$53 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [floatop(t$53, Operators.f32_gt, Operators.f64_gt)]);
        case 88 : 
            var t$54 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* COMPARE */Block.__(13, [floatop(t$54, Operators.f32_ge, Operators.f64_ge)]);
        case 89 : 
            return /* CONVERT */Block.__(14, [Operators.i32_wrap_i64]);
        case 90 : 
            return /* CONVERT */Block.__(14, [Operators.i64_extend_s_i32]);
        case 91 : 
            return /* CONVERT */Block.__(14, [Operators.i64_extend_u_i32]);
        case 92 : 
            return /* CONVERT */Block.__(14, [Operators.f32_demote_f64]);
        case 93 : 
            return /* CONVERT */Block.__(14, [Operators.f64_promote_f32]);
        case 94 : 
            var t$55 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [intop(t$55, Operators.i32_trunc_s_f32, Operators.i64_trunc_s_f32)]);
        case 95 : 
            var t$56 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [intop(t$56, Operators.i32_trunc_u_f32, Operators.i64_trunc_u_f32)]);
        case 96 : 
            var t$57 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [intop(t$57, Operators.i32_trunc_s_f64, Operators.i64_trunc_s_f64)]);
        case 97 : 
            var t$58 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [intop(t$58, Operators.i32_trunc_u_f64, Operators.i64_trunc_u_f64)]);
        case 98 : 
            var t$59 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [floatop(t$59, Operators.f32_convert_s_i32, Operators.f64_convert_s_i32)]);
        case 99 : 
            var t$60 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [floatop(t$60, Operators.f32_convert_u_i32, Operators.f64_convert_u_i32)]);
        case 100 : 
            var t$61 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [floatop(t$61, Operators.f32_convert_s_i64, Operators.f64_convert_s_i64)]);
        case 101 : 
            var t$62 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_start_pos */4] + 3 | 0);
            return /* CONVERT */Block.__(14, [floatop(t$62, Operators.f32_convert_u_i64, Operators.f64_convert_u_i64)]);
        case 102 : 
            return /* CONVERT */Block.__(14, [Operators.f32_reinterpret_i32]);
        case 103 : 
            return /* CONVERT */Block.__(14, [Operators.f64_reinterpret_i64]);
        case 104 : 
            return /* CONVERT */Block.__(14, [Operators.i32_reinterpret_f32]);
        case 105 : 
            return /* CONVERT */Block.__(14, [Operators.i64_reinterpret_f64]);
        case 106 : 
            return /* CURRENT_MEMORY */25;
        case 107 : 
            return /* GROW_MEMORY */26;
        case 108 : 
            return /* TYPE */29;
        case 109 : 
            return /* FUNC */27;
        case 110 : 
            return /* START */28;
        case 111 : 
            return /* PARAM */30;
        case 112 : 
            return /* RESULT */31;
        case 113 : 
            return /* LOCAL */32;
        case 114 : 
            return /* GLOBAL */33;
        case 115 : 
            return /* MODULE */34;
        case 116 : 
            return /* TABLE */35;
        case 117 : 
            return /* MEMORY */37;
        case 118 : 
            return /* ELEM */36;
        case 119 : 
            return /* DATA */38;
        case 120 : 
            return /* OFFSET */39;
        case 121 : 
            return /* IMPORT */40;
        case 122 : 
            return /* EXPORT */41;
        case 123 : 
            return /* SCRIPT */42;
        case 124 : 
            return /* REGISTER */43;
        case 125 : 
            return /* INVOKE */44;
        case 126 : 
            return /* GET */45;
        case 127 : 
            return /* ASSERT_MALFORMED */46;
        case 128 : 
            return /* ASSERT_INVALID */47;
        case 129 : 
            return /* ASSERT_SOFT_INVALID */48;
        case 130 : 
            return /* ASSERT_UNLINKABLE */49;
        case 131 : 
            return /* ASSERT_RETURN */50;
        case 132 : 
            return /* ASSERT_RETURN_NAN */51;
        case 133 : 
            return /* ASSERT_TRAP */52;
        case 134 : 
            return /* ASSERT_EXHAUSTION */53;
        case 135 : 
            return /* INPUT */54;
        case 136 : 
            return /* OUTPUT */55;
        case 137 : 
            var s$7 = Lexing.sub_lexeme(lexbuf$1, lexbuf$1[/* lex_start_pos */4], lexbuf$1[/* lex_curr_pos */5]);
            return /* VAR */Block.__(4, [s$7]);
        case 140 : 
            __ocaml_lex_comment_rec(Lexing.lexeme_start_p(lexbuf$1), lexbuf$1, 684);
            return token(lexbuf$1);
        case 141 : 
            return token(lexbuf$1);
        case 139 : 
        case 142 : 
            Lexing.new_line(lexbuf$1);
            return token(lexbuf$1);
        case 138 : 
        case 143 : 
            return /* EOF */56;
        case 144 : 
            return error(lexbuf$1, "unknown operator");
        
      }
    }
  };
}

function __ocaml_lex_comment_rec(start, lexbuf, ___ocaml_lex_state) {
  while(true) {
    var __ocaml_lex_state = ___ocaml_lex_state;
    var __ocaml_lex_state$1 = Lexing.engine(__ocaml_lex_tables, __ocaml_lex_state, lexbuf);
    if (__ocaml_lex_state$1 > 4 || __ocaml_lex_state$1 < 0) {
      Curry._1(lexbuf[/* refill_buff */0], lexbuf);
      ___ocaml_lex_state = __ocaml_lex_state$1;
      continue ;
      
    }
    else {
      switch (__ocaml_lex_state$1) {
        case 0 : 
            return /* () */0;
        case 1 : 
            __ocaml_lex_comment_rec(Lexing.lexeme_start_p(lexbuf), lexbuf, 684);
            ___ocaml_lex_state = 684;
            continue ;
            case 2 : 
            Lexing.new_line(lexbuf);
            ___ocaml_lex_state = 684;
            continue ;
            case 3 : 
            return error_nest(start, lexbuf, "unclosed comment");
        case 4 : 
            ___ocaml_lex_state = 684;
            continue ;
            
      }
    }
  };
}

exports.convert_pos = convert_pos;
exports.token       = token;
/* F32 Not a pure module */
//////// end of lexer.js ////////
    return exports;
  };


  _registry['lexing'] = function() {
    let exports = {};
//////// start of lexing.js ////////
'use strict';

var Sys                     = require("./sys");
var Bytes                   = require("./bytes");
var Curry                   = require("./curry");
var Caml_bytes              = require("./caml_bytes");
var Caml_lexer              = require("./caml_lexer");
var Pervasives              = require("./pervasives");
var Caml_string             = require("./caml_string");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function engine(tbl, state, buf) {
  var result = Caml_lexer.caml_lex_engine(tbl, state, buf);
  if (result >= 0) {
    buf[/* lex_start_p */10] = buf[/* lex_curr_p */11];
    var init = buf[/* lex_curr_p */11];
    buf[/* lex_curr_p */11] = /* record */[
      /* pos_fname */init[/* pos_fname */0],
      /* pos_lnum */init[/* pos_lnum */1],
      /* pos_bol */init[/* pos_bol */2],
      /* pos_cnum */buf[/* lex_abs_pos */3] + buf[/* lex_curr_pos */5] | 0
    ];
  }
  return result;
}

function new_engine(tbl, state, buf) {
  var result = Caml_lexer.caml_new_lex_engine(tbl, state, buf);
  if (result >= 0) {
    buf[/* lex_start_p */10] = buf[/* lex_curr_p */11];
    var init = buf[/* lex_curr_p */11];
    buf[/* lex_curr_p */11] = /* record */[
      /* pos_fname */init[/* pos_fname */0],
      /* pos_lnum */init[/* pos_lnum */1],
      /* pos_bol */init[/* pos_bol */2],
      /* pos_cnum */buf[/* lex_abs_pos */3] + buf[/* lex_curr_pos */5] | 0
    ];
  }
  return result;
}

var zero_pos = /* record */[
  /* pos_fname */"",
  /* pos_lnum */1,
  /* pos_bol */0,
  /* pos_cnum */0
];

function from_function(f) {
  var partial_arg = new Array(512);
  return /* record */[
          /* refill_buff */function (param) {
            var read_fun = f;
            var aux_buffer = partial_arg;
            var lexbuf = param;
            var read = Curry._2(read_fun, aux_buffer, aux_buffer.length);
            var n = read > 0 ? read : (lexbuf[/* lex_eof_reached */8] = /* true */1, 0);
            if ((lexbuf[/* lex_buffer_len */2] + n | 0) > lexbuf[/* lex_buffer */1].length) {
              if (((lexbuf[/* lex_buffer_len */2] - lexbuf[/* lex_start_pos */4] | 0) + n | 0) <= lexbuf[/* lex_buffer */1].length) {
                Bytes.blit(lexbuf[/* lex_buffer */1], lexbuf[/* lex_start_pos */4], lexbuf[/* lex_buffer */1], 0, lexbuf[/* lex_buffer_len */2] - lexbuf[/* lex_start_pos */4] | 0);
              }
              else {
                var newlen = Pervasives.min((lexbuf[/* lex_buffer */1].length << 1), Sys.max_string_length);
                if (((lexbuf[/* lex_buffer_len */2] - lexbuf[/* lex_start_pos */4] | 0) + n | 0) > newlen) {
                  throw [
                        Caml_builtin_exceptions.failure,
                        "Lexing.lex_refill: cannot grow buffer"
                      ];
                }
                var newbuf = Caml_string.caml_create_string(newlen);
                Bytes.blit(lexbuf[/* lex_buffer */1], lexbuf[/* lex_start_pos */4], newbuf, 0, lexbuf[/* lex_buffer_len */2] - lexbuf[/* lex_start_pos */4] | 0);
                lexbuf[/* lex_buffer */1] = newbuf;
              }
              var s = lexbuf[/* lex_start_pos */4];
              lexbuf[/* lex_abs_pos */3] = lexbuf[/* lex_abs_pos */3] + s | 0;
              lexbuf[/* lex_curr_pos */5] = lexbuf[/* lex_curr_pos */5] - s | 0;
              lexbuf[/* lex_start_pos */4] = 0;
              lexbuf[/* lex_last_pos */6] = lexbuf[/* lex_last_pos */6] - s | 0;
              lexbuf[/* lex_buffer_len */2] = lexbuf[/* lex_buffer_len */2] - s | 0;
              var t = lexbuf[/* lex_mem */9];
              for(var i = 0 ,i_finish = t.length - 1 | 0; i <= i_finish; ++i){
                var v = t[i];
                if (v >= 0) {
                  t[i] = v - s | 0;
                }
                
              }
            }
            Bytes.blit(aux_buffer, 0, lexbuf[/* lex_buffer */1], lexbuf[/* lex_buffer_len */2], n);
            lexbuf[/* lex_buffer_len */2] = lexbuf[/* lex_buffer_len */2] + n | 0;
            return /* () */0;
          },
          /* lex_buffer */new Array(1024),
          /* lex_buffer_len */0,
          /* lex_abs_pos */0,
          /* lex_start_pos */0,
          /* lex_curr_pos */0,
          /* lex_last_pos */0,
          /* lex_last_action */0,
          /* lex_eof_reached : false */0,
          /* lex_mem : int array */[],
          /* lex_start_p */zero_pos,
          /* lex_curr_p */zero_pos
        ];
}

function from_channel(ic) {
  return from_function(function (buf, n) {
              return Pervasives.input(ic, buf, 0, n);
            });
}

function from_string(s) {
  return /* record */[
          /* refill_buff */function (lexbuf) {
            lexbuf[/* lex_eof_reached */8] = /* true */1;
            return /* () */0;
          },
          /* lex_buffer */Bytes.of_string(s),
          /* lex_buffer_len */s.length,
          /* lex_abs_pos */0,
          /* lex_start_pos */0,
          /* lex_curr_pos */0,
          /* lex_last_pos */0,
          /* lex_last_action */0,
          /* lex_eof_reached : true */1,
          /* lex_mem : int array */[],
          /* lex_start_p */zero_pos,
          /* lex_curr_p */zero_pos
        ];
}

function lexeme(lexbuf) {
  var len = lexbuf[/* lex_curr_pos */5] - lexbuf[/* lex_start_pos */4] | 0;
  return Bytes.sub_string(lexbuf[/* lex_buffer */1], lexbuf[/* lex_start_pos */4], len);
}

function sub_lexeme(lexbuf, i1, i2) {
  var len = i2 - i1 | 0;
  return Bytes.sub_string(lexbuf[/* lex_buffer */1], i1, len);
}

function sub_lexeme_opt(lexbuf, i1, i2) {
  if (i1 >= 0) {
    var len = i2 - i1 | 0;
    return /* Some */[Bytes.sub_string(lexbuf[/* lex_buffer */1], i1, len)];
  }
  else {
    return /* None */0;
  }
}

function sub_lexeme_char(lexbuf, i) {
  return Caml_bytes.get(lexbuf[/* lex_buffer */1], i);
}

function sub_lexeme_char_opt(lexbuf, i) {
  if (i >= 0) {
    return /* Some */[Caml_bytes.get(lexbuf[/* lex_buffer */1], i)];
  }
  else {
    return /* None */0;
  }
}

function lexeme_char(lexbuf, i) {
  return Caml_bytes.get(lexbuf[/* lex_buffer */1], lexbuf[/* lex_start_pos */4] + i | 0);
}

function lexeme_start(lexbuf) {
  return lexbuf[/* lex_start_p */10][/* pos_cnum */3];
}

function lexeme_end(lexbuf) {
  return lexbuf[/* lex_curr_p */11][/* pos_cnum */3];
}

function lexeme_start_p(lexbuf) {
  return lexbuf[/* lex_start_p */10];
}

function lexeme_end_p(lexbuf) {
  return lexbuf[/* lex_curr_p */11];
}

function new_line(lexbuf) {
  var lcp = lexbuf[/* lex_curr_p */11];
  lexbuf[/* lex_curr_p */11] = /* record */[
    /* pos_fname */lcp[/* pos_fname */0],
    /* pos_lnum */lcp[/* pos_lnum */1] + 1 | 0,
    /* pos_bol */lcp[/* pos_cnum */3],
    /* pos_cnum */lcp[/* pos_cnum */3]
  ];
  return /* () */0;
}

function flush_input(lb) {
  lb[/* lex_curr_pos */5] = 0;
  lb[/* lex_abs_pos */3] = 0;
  var init = lb[/* lex_curr_p */11];
  lb[/* lex_curr_p */11] = /* record */[
    /* pos_fname */init[/* pos_fname */0],
    /* pos_lnum */init[/* pos_lnum */1],
    /* pos_bol */init[/* pos_bol */2],
    /* pos_cnum */0
  ];
  lb[/* lex_buffer_len */2] = 0;
  return /* () */0;
}

var dummy_pos = /* record */[
  /* pos_fname */"",
  /* pos_lnum */0,
  /* pos_bol */0,
  /* pos_cnum */-1
];

exports.dummy_pos           = dummy_pos;
exports.from_channel        = from_channel;
exports.from_string         = from_string;
exports.from_function       = from_function;
exports.lexeme              = lexeme;
exports.lexeme_char         = lexeme_char;
exports.lexeme_start        = lexeme_start;
exports.lexeme_end          = lexeme_end;
exports.lexeme_start_p      = lexeme_start_p;
exports.lexeme_end_p        = lexeme_end_p;
exports.new_line            = new_line;
exports.flush_input         = flush_input;
exports.sub_lexeme          = sub_lexeme;
exports.sub_lexeme_opt      = sub_lexeme_opt;
exports.sub_lexeme_char     = sub_lexeme_char;
exports.sub_lexeme_char_opt = sub_lexeme_char_opt;
exports.engine              = engine;
exports.new_engine          = new_engine;
/* No side effect */
//////// end of lexing.js ////////
    return exports;
  };


  _registry['lib'] = function() {
    let exports = {};
//////// start of lib.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var $$Array                 = require("bs-platform/lib/js/array");
var Curry                   = require("bs-platform/lib/js/curry");
var Int32                   = require("bs-platform/lib/js/int32");
var $$String                = require("bs-platform/lib/js/string");
var Bigarray                = require("bs-platform/lib/js/bigarray");
var Caml_obj                = require("bs-platform/lib/js/caml_obj");
var Caml_array              = require("bs-platform/lib/js/caml_array");
var Caml_int64              = require("bs-platform/lib/js/caml_int64");
var Pervasives              = require("bs-platform/lib/js/pervasives");
var Caml_builtin_exceptions = require("bs-platform/lib/js/caml_builtin_exceptions");

function repeat(_n, f, x) {
  while(true) {
    var n = _n;
    if (n) {
      Curry._1(f, x);
      _n = n - 1 | 0;
      continue ;
      
    }
    else {
      return /* () */0;
    }
  };
}

var Fun = /* module */[/* repeat */repeat];

function make(n, x) {
  if (n) {
    return /* :: */[
            x,
            make(n - 1 | 0, x)
          ];
  }
  else {
    return /* [] */0;
  }
}

function table$prime(i, n, f) {
  if (i === n) {
    return /* [] */0;
  }
  else {
    return /* :: */[
            Curry._1(f, i),
            table$prime(i + 1 | 0, n, f)
          ];
  }
}

function table(n, f) {
  return table$prime(0, n, f);
}

function take(n, xs) {
  if (n !== 0) {
    if (xs) {
      if (n > 0) {
        return /* :: */[
                xs[0],
                take(n - 1 | 0, xs[1])
              ];
      }
      else {
        return Pervasives.failwith("take");
      }
    }
    else {
      return Pervasives.failwith("take");
    }
  }
  else {
    return /* [] */0;
  }
}

function drop(_n, _xs) {
  while(true) {
    var xs = _xs;
    var n = _n;
    if (n !== 0) {
      if (xs) {
        if (n > 0) {
          _xs = xs[1];
          _n = n - 1 | 0;
          continue ;
          
        }
        else {
          return Pervasives.failwith("drop");
        }
      }
      else {
        return Pervasives.failwith("drop");
      }
    }
    else {
      return xs;
    }
  };
}

function last(_param) {
  while(true) {
    var param = _param;
    if (param) {
      var xs = param[1];
      if (xs) {
        _param = xs;
        continue ;
        
      }
      else {
        return param[0];
      }
    }
    else {
      return Pervasives.failwith("last");
    }
  };
}

function split_last(param) {
  if (param) {
    var xs = param[1];
    var x = param[0];
    if (xs) {
      var match = split_last(xs);
      return /* tuple */[
              /* :: */[
                x,
                match[0]
              ],
              match[1]
            ];
    }
    else {
      return /* tuple */[
              /* [] */0,
              x
            ];
    }
  }
  else {
    return Pervasives.failwith("split_last");
  }
}

function index_of(x, xs) {
  var x$1 = x;
  var _xs = xs;
  var _i = 0;
  while(true) {
    var i = _i;
    var xs$1 = _xs;
    if (xs$1) {
      if (Caml_obj.caml_equal(x$1, xs$1[0])) {
        return /* Some */[i];
      }
      else {
        _i = i + 1 | 0;
        _xs = xs$1[1];
        continue ;
        
      }
    }
    else {
      return /* None */0;
    }
  };
}

function length(xs) {
  var _xs = xs;
  var _n = 0;
  while(true) {
    var n = _n;
    var xs$1 = _xs;
    if (xs$1) {
      if (n < Int32.max_int) {
        _n = n + 1 | 0;
        _xs = xs$1[1];
        continue ;
        
      }
      else {
        return Pervasives.failwith("length");
      }
    }
    else {
      return n;
    }
  };
}

function nth(_xs, _n) {
  while(true) {
    var n = _n;
    var xs = _xs;
    if (n !== 0) {
      if (xs) {
        if (n > 0) {
          _n = n - 1 | 0;
          _xs = xs[1];
          continue ;
          
        }
        else {
          return Pervasives.failwith("nth");
        }
      }
      else {
        return Pervasives.failwith("nth");
      }
    }
    else if (xs) {
      return xs[0];
    }
    else {
      return Pervasives.failwith("nth");
    }
  };
}

function take$1(n, xs) {
  if (n !== 0) {
    if (xs) {
      if (n > 0) {
        return /* :: */[
                xs[0],
                take$1(n - 1 | 0, xs[1])
              ];
      }
      else {
        return Pervasives.failwith("take");
      }
    }
    else {
      return Pervasives.failwith("take");
    }
  }
  else {
    return /* [] */0;
  }
}

function drop$1(_n, _xs) {
  while(true) {
    var xs = _xs;
    var n = _n;
    if (n !== 0) {
      if (xs) {
        if (n > 0) {
          _xs = xs[1];
          _n = n - 1 | 0;
          continue ;
          
        }
        else {
          return Pervasives.failwith("drop");
        }
      }
      else {
        return Pervasives.failwith("drop");
      }
    }
    else {
      return xs;
    }
  };
}

function make$1(n, x) {
  if (n < 0 || Caml_int64.gt(Caml_int64.of_int32(n), Caml_int64.of_int32(Pervasives.max_int))) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Array32.make"
        ];
  }
  return Caml_array.caml_make_vect(n, x);
}

function length$1(a) {
  return a.length;
}

function index_of_int32(i) {
  if (i < 0 || Caml_int64.gt(Caml_int64.of_int32(i), Caml_int64.of_int32(Pervasives.max_int))) {
    return -1;
  }
  else {
    return i;
  }
}

function get(a, i) {
  return a[index_of_int32(i)];
}

function set(a, i, x) {
  a[index_of_int32(i)] = x;
  return /* () */0;
}

function blit(a1, i1, a2, i2, n) {
  return $$Array.blit(a1, index_of_int32(i1), a2, index_of_int32(i2), index_of_int32(n));
}

function create(kind, layout, n) {
  if (Caml_int64.lt(n, /* int64 */[
          /* hi */0,
          /* lo */0
        ]) || Caml_int64.gt(n, Caml_int64.of_int32(Pervasives.max_int))) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "Bigarray.Array1_64.create"
        ];
  }
  return Curry._3(Bigarray.Array1[/* create */0], kind, layout, n[1] | 0);
}

function dim() {
  return Caml_int64.of_int32(function () {
                throw "caml_ba_dim_1 not implemented by bucklescript yet\n";
              }());
}

function get$1(_, _$1) {
  return function () {
            throw "caml_ba_get_1 not implemented by bucklescript yet\n";
          }();
}

function set$1(_, _$1, _$2) {
  return function () {
            throw "caml_ba_set_1 not implemented by bucklescript yet\n";
          }();
}

function sub(_, _$1, _$2) {
  return function () {
            throw "caml_ba_sub not implemented by bucklescript yet\n";
          }();
}

function get$2(o, x) {
  if (o) {
    return o[0];
  }
  else {
    return x;
  }
}

function map(f, param) {
  if (param) {
    return /* Some */[Curry._1(f, param[0])];
  }
  else {
    return /* None */0;
  }
}

function app(f, param) {
  if (param) {
    return Curry._1(f, param[0]);
  }
  else {
    return /* () */0;
  }
}

var Option = /* module */[
  /* get */get$2,
  /* map */map,
  /* app */app
];

function log2(n) {
  if (n <= 0) {
    Pervasives.failwith("log2");
  }
  var _acc = 0;
  var _n = n;
  while(true) {
    var n$1 = _n;
    var acc = _acc;
    if (n$1 === 1) {
      return acc;
    }
    else {
      _n = (n$1 >>> 1);
      _acc = acc + 1 | 0;
      continue ;
      
    }
  };
}

function is_power_of_two(n) {
  if (n < 0) {
    Pervasives.failwith("is_power_of_two");
  }
  if (n !== 0) {
    return +((n & (n - 1 | 0)) === 0);
  }
  else {
    return /* false */0;
  }
}

var Int = /* module */[
  /* log2 */log2,
  /* is_power_of_two */is_power_of_two
];

function breakup(s, n) {
  var loop = function (i) {
    var len = Pervasives.min(n, s.length - i | 0);
    if (len) {
      return /* :: */[
              $$String.sub(s, i, len),
              loop(i + len | 0)
            ];
    }
    else {
      return /* [] */0;
    }
  };
  return loop(0);
}

var $$String$1 = /* module */[/* breakup */breakup];

var List = [
  make,
  table,
  take,
  drop,
  last,
  split_last,
  index_of
];

var List32 = [
  length,
  nth,
  take$1,
  drop$1
];

var Array32 = [
  make$1,
  length$1,
  get,
  set,
  blit
];

var Bigarray$1 = [[
    create,
    dim,
    get$1,
    set$1,
    sub
  ]];

exports.Fun      = Fun;
exports.List     = List;
exports.List32   = List32;
exports.Array32  = Array32;
exports.Bigarray = Bigarray$1;
exports.Option   = Option;
exports.Int      = Int;
exports.$$String = $$String$1;
/* Bigarray Not a pure module */
//////// end of lib.js ////////
    return exports;
  };


  _registry['list'] = function() {
    let exports = {};
//////// start of list.js ////////
'use strict';

var Curry                   = require("./curry");
var Caml_obj                = require("./caml_obj");
var Pervasives              = require("./pervasives");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function length(l) {
  var _len = 0;
  var _param = l;
  while(true) {
    var param = _param;
    var len = _len;
    if (param) {
      _param = param[1];
      _len = len + 1 | 0;
      continue ;
      
    }
    else {
      return len;
    }
  };
}

function hd(param) {
  if (param) {
    return param[0];
  }
  else {
    throw [
          Caml_builtin_exceptions.failure,
          "hd"
        ];
  }
}

function tl(param) {
  if (param) {
    return param[1];
  }
  else {
    throw [
          Caml_builtin_exceptions.failure,
          "tl"
        ];
  }
}

function nth(l, n) {
  if (n < 0) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "List.nth"
        ];
  }
  else {
    var _l = l;
    var _n = n;
    while(true) {
      var n$1 = _n;
      var l$1 = _l;
      if (l$1) {
        if (n$1) {
          _n = n$1 - 1 | 0;
          _l = l$1[1];
          continue ;
          
        }
        else {
          return l$1[0];
        }
      }
      else {
        throw [
              Caml_builtin_exceptions.failure,
              "nth"
            ];
      }
    };
  }
}

function rev_append(_l1, _l2) {
  while(true) {
    var l2 = _l2;
    var l1 = _l1;
    if (l1) {
      _l2 = /* :: */[
        l1[0],
        l2
      ];
      _l1 = l1[1];
      continue ;
      
    }
    else {
      return l2;
    }
  };
}

function rev(l) {
  return rev_append(l, /* [] */0);
}

function flatten(param) {
  if (param) {
    return Pervasives.$at(param[0], flatten(param[1]));
  }
  else {
    return /* [] */0;
  }
}

function map(f, param) {
  if (param) {
    var r = Curry._1(f, param[0]);
    return /* :: */[
            r,
            map(f, param[1])
          ];
  }
  else {
    return /* [] */0;
  }
}

function mapi(i, f, param) {
  if (param) {
    var r = Curry._2(f, i, param[0]);
    return /* :: */[
            r,
            mapi(i + 1 | 0, f, param[1])
          ];
  }
  else {
    return /* [] */0;
  }
}

function mapi$1(f, l) {
  return mapi(0, f, l);
}

function rev_map(f, l) {
  var _accu = /* [] */0;
  var _param = l;
  while(true) {
    var param = _param;
    var accu = _accu;
    if (param) {
      _param = param[1];
      _accu = /* :: */[
        Curry._1(f, param[0]),
        accu
      ];
      continue ;
      
    }
    else {
      return accu;
    }
  };
}

function iter(f, _param) {
  while(true) {
    var param = _param;
    if (param) {
      Curry._1(f, param[0]);
      _param = param[1];
      continue ;
      
    }
    else {
      return /* () */0;
    }
  };
}

function iteri(f, l) {
  var _i = 0;
  var f$1 = f;
  var _param = l;
  while(true) {
    var param = _param;
    var i = _i;
    if (param) {
      Curry._2(f$1, i, param[0]);
      _param = param[1];
      _i = i + 1 | 0;
      continue ;
      
    }
    else {
      return /* () */0;
    }
  };
}

function fold_left(f, _accu, _l) {
  while(true) {
    var l = _l;
    var accu = _accu;
    if (l) {
      _l = l[1];
      _accu = Curry._2(f, accu, l[0]);
      continue ;
      
    }
    else {
      return accu;
    }
  };
}

function fold_right(f, l, accu) {
  if (l) {
    return Curry._2(f, l[0], fold_right(f, l[1], accu));
  }
  else {
    return accu;
  }
}

function map2(f, l1, l2) {
  if (l1) {
    if (l2) {
      var r = Curry._2(f, l1[0], l2[0]);
      return /* :: */[
              r,
              map2(f, l1[1], l2[1])
            ];
    }
    else {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.map2"
          ];
    }
  }
  else if (l2) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "List.map2"
        ];
  }
  else {
    return /* [] */0;
  }
}

function rev_map2(f, l1, l2) {
  var _accu = /* [] */0;
  var _l1 = l1;
  var _l2 = l2;
  while(true) {
    var l2$1 = _l2;
    var l1$1 = _l1;
    var accu = _accu;
    if (l1$1) {
      if (l2$1) {
        _l2 = l2$1[1];
        _l1 = l1$1[1];
        _accu = /* :: */[
          Curry._2(f, l1$1[0], l2$1[0]),
          accu
        ];
        continue ;
        
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "List.rev_map2"
            ];
      }
    }
    else if (l2$1) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.rev_map2"
          ];
    }
    else {
      return accu;
    }
  };
}

function iter2(f, _l1, _l2) {
  while(true) {
    var l2 = _l2;
    var l1 = _l1;
    if (l1) {
      if (l2) {
        Curry._2(f, l1[0], l2[0]);
        _l2 = l2[1];
        _l1 = l1[1];
        continue ;
        
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "List.iter2"
            ];
      }
    }
    else if (l2) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.iter2"
          ];
    }
    else {
      return /* () */0;
    }
  };
}

function fold_left2(f, _accu, _l1, _l2) {
  while(true) {
    var l2 = _l2;
    var l1 = _l1;
    var accu = _accu;
    if (l1) {
      if (l2) {
        _l2 = l2[1];
        _l1 = l1[1];
        _accu = Curry._3(f, accu, l1[0], l2[0]);
        continue ;
        
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "List.fold_left2"
            ];
      }
    }
    else if (l2) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.fold_left2"
          ];
    }
    else {
      return accu;
    }
  };
}

function fold_right2(f, l1, l2, accu) {
  if (l1) {
    if (l2) {
      return Curry._3(f, l1[0], l2[0], fold_right2(f, l1[1], l2[1], accu));
    }
    else {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.fold_right2"
          ];
    }
  }
  else if (l2) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "List.fold_right2"
        ];
  }
  else {
    return accu;
  }
}

function for_all(p, _param) {
  while(true) {
    var param = _param;
    if (param) {
      if (Curry._1(p, param[0])) {
        _param = param[1];
        continue ;
        
      }
      else {
        return /* false */0;
      }
    }
    else {
      return /* true */1;
    }
  };
}

function exists(p, _param) {
  while(true) {
    var param = _param;
    if (param) {
      if (Curry._1(p, param[0])) {
        return /* true */1;
      }
      else {
        _param = param[1];
        continue ;
        
      }
    }
    else {
      return /* false */0;
    }
  };
}

function for_all2(p, _l1, _l2) {
  while(true) {
    var l2 = _l2;
    var l1 = _l1;
    if (l1) {
      if (l2) {
        if (Curry._2(p, l1[0], l2[0])) {
          _l2 = l2[1];
          _l1 = l1[1];
          continue ;
          
        }
        else {
          return /* false */0;
        }
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "List.for_all2"
            ];
      }
    }
    else if (l2) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.for_all2"
          ];
    }
    else {
      return /* true */1;
    }
  };
}

function exists2(p, _l1, _l2) {
  while(true) {
    var l2 = _l2;
    var l1 = _l1;
    if (l1) {
      if (l2) {
        if (Curry._2(p, l1[0], l2[0])) {
          return /* true */1;
        }
        else {
          _l2 = l2[1];
          _l1 = l1[1];
          continue ;
          
        }
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "List.exists2"
            ];
      }
    }
    else if (l2) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.exists2"
          ];
    }
    else {
      return /* false */0;
    }
  };
}

function mem(x, _param) {
  while(true) {
    var param = _param;
    if (param) {
      if (Caml_obj.caml_compare(param[0], x)) {
        _param = param[1];
        continue ;
        
      }
      else {
        return /* true */1;
      }
    }
    else {
      return /* false */0;
    }
  };
}

function memq(x, _param) {
  while(true) {
    var param = _param;
    if (param) {
      if (param[0] === x) {
        return /* true */1;
      }
      else {
        _param = param[1];
        continue ;
        
      }
    }
    else {
      return /* false */0;
    }
  };
}

function assoc(x, _param) {
  while(true) {
    var param = _param;
    if (param) {
      var match = param[0];
      if (Caml_obj.caml_compare(match[0], x)) {
        _param = param[1];
        continue ;
        
      }
      else {
        return match[1];
      }
    }
    else {
      throw Caml_builtin_exceptions.not_found;
    }
  };
}

function assq(x, _param) {
  while(true) {
    var param = _param;
    if (param) {
      var match = param[0];
      if (match[0] === x) {
        return match[1];
      }
      else {
        _param = param[1];
        continue ;
        
      }
    }
    else {
      throw Caml_builtin_exceptions.not_found;
    }
  };
}

function mem_assoc(x, _param) {
  while(true) {
    var param = _param;
    if (param) {
      if (Caml_obj.caml_compare(param[0][0], x)) {
        _param = param[1];
        continue ;
        
      }
      else {
        return /* true */1;
      }
    }
    else {
      return /* false */0;
    }
  };
}

function mem_assq(x, _param) {
  while(true) {
    var param = _param;
    if (param) {
      if (param[0][0] === x) {
        return /* true */1;
      }
      else {
        _param = param[1];
        continue ;
        
      }
    }
    else {
      return /* false */0;
    }
  };
}

function remove_assoc(x, param) {
  if (param) {
    var l = param[1];
    var pair = param[0];
    if (Caml_obj.caml_compare(pair[0], x)) {
      return /* :: */[
              pair,
              remove_assoc(x, l)
            ];
    }
    else {
      return l;
    }
  }
  else {
    return /* [] */0;
  }
}

function remove_assq(x, param) {
  if (param) {
    var l = param[1];
    var pair = param[0];
    if (pair[0] === x) {
      return l;
    }
    else {
      return /* :: */[
              pair,
              remove_assq(x, l)
            ];
    }
  }
  else {
    return /* [] */0;
  }
}

function find(p, _param) {
  while(true) {
    var param = _param;
    if (param) {
      var x = param[0];
      if (Curry._1(p, x)) {
        return x;
      }
      else {
        _param = param[1];
        continue ;
        
      }
    }
    else {
      throw Caml_builtin_exceptions.not_found;
    }
  };
}

function find_all(p) {
  return function (param) {
    var _accu = /* [] */0;
    var _param = param;
    while(true) {
      var param$1 = _param;
      var accu = _accu;
      if (param$1) {
        var l = param$1[1];
        var x = param$1[0];
        if (Curry._1(p, x)) {
          _param = l;
          _accu = /* :: */[
            x,
            accu
          ];
          continue ;
          
        }
        else {
          _param = l;
          continue ;
          
        }
      }
      else {
        return rev_append(accu, /* [] */0);
      }
    };
  };
}

function partition(p, l) {
  var _yes = /* [] */0;
  var _no = /* [] */0;
  var _param = l;
  while(true) {
    var param = _param;
    var no = _no;
    var yes = _yes;
    if (param) {
      var l$1 = param[1];
      var x = param[0];
      if (Curry._1(p, x)) {
        _param = l$1;
        _yes = /* :: */[
          x,
          yes
        ];
        continue ;
        
      }
      else {
        _param = l$1;
        _no = /* :: */[
          x,
          no
        ];
        continue ;
        
      }
    }
    else {
      return /* tuple */[
              rev_append(yes, /* [] */0),
              rev_append(no, /* [] */0)
            ];
    }
  };
}

function split(param) {
  if (param) {
    var match = param[0];
    var match$1 = split(param[1]);
    return /* tuple */[
            /* :: */[
              match[0],
              match$1[0]
            ],
            /* :: */[
              match[1],
              match$1[1]
            ]
          ];
  }
  else {
    return /* tuple */[
            /* [] */0,
            /* [] */0
          ];
  }
}

function combine(l1, l2) {
  if (l1) {
    if (l2) {
      return /* :: */[
              /* tuple */[
                l1[0],
                l2[0]
              ],
              combine(l1[1], l2[1])
            ];
    }
    else {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "List.combine"
          ];
    }
  }
  else if (l2) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "List.combine"
        ];
  }
  else {
    return /* [] */0;
  }
}

function merge(cmp, l1, l2) {
  if (l1) {
    if (l2) {
      var h2 = l2[0];
      var h1 = l1[0];
      if (Curry._2(cmp, h1, h2) <= 0) {
        return /* :: */[
                h1,
                merge(cmp, l1[1], l2)
              ];
      }
      else {
        return /* :: */[
                h2,
                merge(cmp, l1, l2[1])
              ];
      }
    }
    else {
      return l1;
    }
  }
  else {
    return l2;
  }
}

function chop(_k, _l) {
  while(true) {
    var l = _l;
    var k = _k;
    if (k) {
      if (l) {
        _l = l[1];
        _k = k - 1 | 0;
        continue ;
        
      }
      else {
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "list.ml",
                223,
                11
              ]
            ];
      }
    }
    else {
      return l;
    }
  };
}

function stable_sort(cmp, l) {
  var sort = function (n, l) {
    var exit = 0;
    if (n !== 2) {
      if (n !== 3) {
        exit = 1;
      }
      else if (l) {
        var match = l[1];
        if (match) {
          var match$1 = match[1];
          if (match$1) {
            var x3 = match$1[0];
            var x2 = match[0];
            var x1 = l[0];
            if (Curry._2(cmp, x1, x2) <= 0) {
              if (Curry._2(cmp, x2, x3) <= 0) {
                return /* :: */[
                        x1,
                        /* :: */[
                          x2,
                          /* :: */[
                            x3,
                            /* [] */0
                          ]
                        ]
                      ];
              }
              else if (Curry._2(cmp, x1, x3) <= 0) {
                return /* :: */[
                        x1,
                        /* :: */[
                          x3,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ]
                      ];
              }
              else {
                return /* :: */[
                        x3,
                        /* :: */[
                          x1,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ]
                      ];
              }
            }
            else if (Curry._2(cmp, x1, x3) <= 0) {
              return /* :: */[
                      x2,
                      /* :: */[
                        x1,
                        /* :: */[
                          x3,
                          /* [] */0
                        ]
                      ]
                    ];
            }
            else if (Curry._2(cmp, x2, x3) <= 0) {
              return /* :: */[
                      x2,
                      /* :: */[
                        x3,
                        /* :: */[
                          x1,
                          /* [] */0
                        ]
                      ]
                    ];
            }
            else {
              return /* :: */[
                      x3,
                      /* :: */[
                        x2,
                        /* :: */[
                          x1,
                          /* [] */0
                        ]
                      ]
                    ];
            }
          }
          else {
            exit = 1;
          }
        }
        else {
          exit = 1;
        }
      }
      else {
        exit = 1;
      }
    }
    else if (l) {
      var match$2 = l[1];
      if (match$2) {
        var x2$1 = match$2[0];
        var x1$1 = l[0];
        if (Curry._2(cmp, x1$1, x2$1) <= 0) {
          return /* :: */[
                  x1$1,
                  /* :: */[
                    x2$1,
                    /* [] */0
                  ]
                ];
        }
        else {
          return /* :: */[
                  x2$1,
                  /* :: */[
                    x1$1,
                    /* [] */0
                  ]
                ];
        }
      }
      else {
        exit = 1;
      }
    }
    else {
      exit = 1;
    }
    if (exit === 1) {
      var n1 = (n >> 1);
      var n2 = n - n1 | 0;
      var l2 = chop(n1, l);
      var s1 = rev_sort(n1, l);
      var s2 = rev_sort(n2, l2);
      var _l1 = s1;
      var _l2 = s2;
      var _accu = /* [] */0;
      while(true) {
        var accu = _accu;
        var l2$1 = _l2;
        var l1 = _l1;
        if (l1) {
          if (l2$1) {
            var h2 = l2$1[0];
            var h1 = l1[0];
            if (Curry._2(cmp, h1, h2) > 0) {
              _accu = /* :: */[
                h1,
                accu
              ];
              _l1 = l1[1];
              continue ;
              
            }
            else {
              _accu = /* :: */[
                h2,
                accu
              ];
              _l2 = l2$1[1];
              continue ;
              
            }
          }
          else {
            return rev_append(l1, accu);
          }
        }
        else {
          return rev_append(l2$1, accu);
        }
      };
    }
    
  };
  var rev_sort = function (n, l) {
    var exit = 0;
    if (n !== 2) {
      if (n !== 3) {
        exit = 1;
      }
      else if (l) {
        var match = l[1];
        if (match) {
          var match$1 = match[1];
          if (match$1) {
            var x3 = match$1[0];
            var x2 = match[0];
            var x1 = l[0];
            if (Curry._2(cmp, x1, x2) > 0) {
              if (Curry._2(cmp, x2, x3) > 0) {
                return /* :: */[
                        x1,
                        /* :: */[
                          x2,
                          /* :: */[
                            x3,
                            /* [] */0
                          ]
                        ]
                      ];
              }
              else if (Curry._2(cmp, x1, x3) > 0) {
                return /* :: */[
                        x1,
                        /* :: */[
                          x3,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ]
                      ];
              }
              else {
                return /* :: */[
                        x3,
                        /* :: */[
                          x1,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ]
                      ];
              }
            }
            else if (Curry._2(cmp, x1, x3) > 0) {
              return /* :: */[
                      x2,
                      /* :: */[
                        x1,
                        /* :: */[
                          x3,
                          /* [] */0
                        ]
                      ]
                    ];
            }
            else if (Curry._2(cmp, x2, x3) > 0) {
              return /* :: */[
                      x2,
                      /* :: */[
                        x3,
                        /* :: */[
                          x1,
                          /* [] */0
                        ]
                      ]
                    ];
            }
            else {
              return /* :: */[
                      x3,
                      /* :: */[
                        x2,
                        /* :: */[
                          x1,
                          /* [] */0
                        ]
                      ]
                    ];
            }
          }
          else {
            exit = 1;
          }
        }
        else {
          exit = 1;
        }
      }
      else {
        exit = 1;
      }
    }
    else if (l) {
      var match$2 = l[1];
      if (match$2) {
        var x2$1 = match$2[0];
        var x1$1 = l[0];
        if (Curry._2(cmp, x1$1, x2$1) > 0) {
          return /* :: */[
                  x1$1,
                  /* :: */[
                    x2$1,
                    /* [] */0
                  ]
                ];
        }
        else {
          return /* :: */[
                  x2$1,
                  /* :: */[
                    x1$1,
                    /* [] */0
                  ]
                ];
        }
      }
      else {
        exit = 1;
      }
    }
    else {
      exit = 1;
    }
    if (exit === 1) {
      var n1 = (n >> 1);
      var n2 = n - n1 | 0;
      var l2 = chop(n1, l);
      var s1 = sort(n1, l);
      var s2 = sort(n2, l2);
      var _l1 = s1;
      var _l2 = s2;
      var _accu = /* [] */0;
      while(true) {
        var accu = _accu;
        var l2$1 = _l2;
        var l1 = _l1;
        if (l1) {
          if (l2$1) {
            var h2 = l2$1[0];
            var h1 = l1[0];
            if (Curry._2(cmp, h1, h2) <= 0) {
              _accu = /* :: */[
                h1,
                accu
              ];
              _l1 = l1[1];
              continue ;
              
            }
            else {
              _accu = /* :: */[
                h2,
                accu
              ];
              _l2 = l2$1[1];
              continue ;
              
            }
          }
          else {
            return rev_append(l1, accu);
          }
        }
        else {
          return rev_append(l2$1, accu);
        }
      };
    }
    
  };
  var len = length(l);
  if (len < 2) {
    return l;
  }
  else {
    return sort(len, l);
  }
}

function sort_uniq(cmp, l) {
  var sort = function (n, l) {
    var exit = 0;
    if (n !== 2) {
      if (n !== 3) {
        exit = 1;
      }
      else if (l) {
        var match = l[1];
        if (match) {
          var match$1 = match[1];
          if (match$1) {
            var x3 = match$1[0];
            var x2 = match[0];
            var x1 = l[0];
            var c = Curry._2(cmp, x1, x2);
            if (c) {
              if (c < 0) {
                var c$1 = Curry._2(cmp, x2, x3);
                if (c$1) {
                  if (c$1 < 0) {
                    return /* :: */[
                            x1,
                            /* :: */[
                              x2,
                              /* :: */[
                                x3,
                                /* [] */0
                              ]
                            ]
                          ];
                  }
                  else {
                    var c$2 = Curry._2(cmp, x1, x3);
                    if (c$2) {
                      if (c$2 < 0) {
                        return /* :: */[
                                x1,
                                /* :: */[
                                  x3,
                                  /* :: */[
                                    x2,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                      else {
                        return /* :: */[
                                x3,
                                /* :: */[
                                  x1,
                                  /* :: */[
                                    x2,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                    }
                    else {
                      return /* :: */[
                              x1,
                              /* :: */[
                                x2,
                                /* [] */0
                              ]
                            ];
                    }
                  }
                }
                else {
                  return /* :: */[
                          x1,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ];
                }
              }
              else {
                var c$3 = Curry._2(cmp, x1, x3);
                if (c$3) {
                  if (c$3 < 0) {
                    return /* :: */[
                            x2,
                            /* :: */[
                              x1,
                              /* :: */[
                                x3,
                                /* [] */0
                              ]
                            ]
                          ];
                  }
                  else {
                    var c$4 = Curry._2(cmp, x2, x3);
                    if (c$4) {
                      if (c$4 < 0) {
                        return /* :: */[
                                x2,
                                /* :: */[
                                  x3,
                                  /* :: */[
                                    x1,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                      else {
                        return /* :: */[
                                x3,
                                /* :: */[
                                  x2,
                                  /* :: */[
                                    x1,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                    }
                    else {
                      return /* :: */[
                              x2,
                              /* :: */[
                                x1,
                                /* [] */0
                              ]
                            ];
                    }
                  }
                }
                else {
                  return /* :: */[
                          x2,
                          /* :: */[
                            x1,
                            /* [] */0
                          ]
                        ];
                }
              }
            }
            else {
              var c$5 = Curry._2(cmp, x2, x3);
              if (c$5) {
                if (c$5 < 0) {
                  return /* :: */[
                          x2,
                          /* :: */[
                            x3,
                            /* [] */0
                          ]
                        ];
                }
                else {
                  return /* :: */[
                          x3,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ];
                }
              }
              else {
                return /* :: */[
                        x2,
                        /* [] */0
                      ];
              }
            }
          }
          else {
            exit = 1;
          }
        }
        else {
          exit = 1;
        }
      }
      else {
        exit = 1;
      }
    }
    else if (l) {
      var match$2 = l[1];
      if (match$2) {
        var x2$1 = match$2[0];
        var x1$1 = l[0];
        var c$6 = Curry._2(cmp, x1$1, x2$1);
        if (c$6) {
          if (c$6 < 0) {
            return /* :: */[
                    x1$1,
                    /* :: */[
                      x2$1,
                      /* [] */0
                    ]
                  ];
          }
          else {
            return /* :: */[
                    x2$1,
                    /* :: */[
                      x1$1,
                      /* [] */0
                    ]
                  ];
          }
        }
        else {
          return /* :: */[
                  x1$1,
                  /* [] */0
                ];
        }
      }
      else {
        exit = 1;
      }
    }
    else {
      exit = 1;
    }
    if (exit === 1) {
      var n1 = (n >> 1);
      var n2 = n - n1 | 0;
      var l2 = chop(n1, l);
      var s1 = rev_sort(n1, l);
      var s2 = rev_sort(n2, l2);
      var _l1 = s1;
      var _l2 = s2;
      var _accu = /* [] */0;
      while(true) {
        var accu = _accu;
        var l2$1 = _l2;
        var l1 = _l1;
        if (l1) {
          if (l2$1) {
            var t2 = l2$1[1];
            var h2 = l2$1[0];
            var t1 = l1[1];
            var h1 = l1[0];
            var c$7 = Curry._2(cmp, h1, h2);
            if (c$7) {
              if (c$7 > 0) {
                _accu = /* :: */[
                  h1,
                  accu
                ];
                _l1 = t1;
                continue ;
                
              }
              else {
                _accu = /* :: */[
                  h2,
                  accu
                ];
                _l2 = t2;
                continue ;
                
              }
            }
            else {
              _accu = /* :: */[
                h1,
                accu
              ];
              _l2 = t2;
              _l1 = t1;
              continue ;
              
            }
          }
          else {
            return rev_append(l1, accu);
          }
        }
        else {
          return rev_append(l2$1, accu);
        }
      };
    }
    
  };
  var rev_sort = function (n, l) {
    var exit = 0;
    if (n !== 2) {
      if (n !== 3) {
        exit = 1;
      }
      else if (l) {
        var match = l[1];
        if (match) {
          var match$1 = match[1];
          if (match$1) {
            var x3 = match$1[0];
            var x2 = match[0];
            var x1 = l[0];
            var c = Curry._2(cmp, x1, x2);
            if (c) {
              if (c > 0) {
                var c$1 = Curry._2(cmp, x2, x3);
                if (c$1) {
                  if (c$1 > 0) {
                    return /* :: */[
                            x1,
                            /* :: */[
                              x2,
                              /* :: */[
                                x3,
                                /* [] */0
                              ]
                            ]
                          ];
                  }
                  else {
                    var c$2 = Curry._2(cmp, x1, x3);
                    if (c$2) {
                      if (c$2 > 0) {
                        return /* :: */[
                                x1,
                                /* :: */[
                                  x3,
                                  /* :: */[
                                    x2,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                      else {
                        return /* :: */[
                                x3,
                                /* :: */[
                                  x1,
                                  /* :: */[
                                    x2,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                    }
                    else {
                      return /* :: */[
                              x1,
                              /* :: */[
                                x2,
                                /* [] */0
                              ]
                            ];
                    }
                  }
                }
                else {
                  return /* :: */[
                          x1,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ];
                }
              }
              else {
                var c$3 = Curry._2(cmp, x1, x3);
                if (c$3) {
                  if (c$3 > 0) {
                    return /* :: */[
                            x2,
                            /* :: */[
                              x1,
                              /* :: */[
                                x3,
                                /* [] */0
                              ]
                            ]
                          ];
                  }
                  else {
                    var c$4 = Curry._2(cmp, x2, x3);
                    if (c$4) {
                      if (c$4 > 0) {
                        return /* :: */[
                                x2,
                                /* :: */[
                                  x3,
                                  /* :: */[
                                    x1,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                      else {
                        return /* :: */[
                                x3,
                                /* :: */[
                                  x2,
                                  /* :: */[
                                    x1,
                                    /* [] */0
                                  ]
                                ]
                              ];
                      }
                    }
                    else {
                      return /* :: */[
                              x2,
                              /* :: */[
                                x1,
                                /* [] */0
                              ]
                            ];
                    }
                  }
                }
                else {
                  return /* :: */[
                          x2,
                          /* :: */[
                            x1,
                            /* [] */0
                          ]
                        ];
                }
              }
            }
            else {
              var c$5 = Curry._2(cmp, x2, x3);
              if (c$5) {
                if (c$5 > 0) {
                  return /* :: */[
                          x2,
                          /* :: */[
                            x3,
                            /* [] */0
                          ]
                        ];
                }
                else {
                  return /* :: */[
                          x3,
                          /* :: */[
                            x2,
                            /* [] */0
                          ]
                        ];
                }
              }
              else {
                return /* :: */[
                        x2,
                        /* [] */0
                      ];
              }
            }
          }
          else {
            exit = 1;
          }
        }
        else {
          exit = 1;
        }
      }
      else {
        exit = 1;
      }
    }
    else if (l) {
      var match$2 = l[1];
      if (match$2) {
        var x2$1 = match$2[0];
        var x1$1 = l[0];
        var c$6 = Curry._2(cmp, x1$1, x2$1);
        if (c$6) {
          if (c$6 > 0) {
            return /* :: */[
                    x1$1,
                    /* :: */[
                      x2$1,
                      /* [] */0
                    ]
                  ];
          }
          else {
            return /* :: */[
                    x2$1,
                    /* :: */[
                      x1$1,
                      /* [] */0
                    ]
                  ];
          }
        }
        else {
          return /* :: */[
                  x1$1,
                  /* [] */0
                ];
        }
      }
      else {
        exit = 1;
      }
    }
    else {
      exit = 1;
    }
    if (exit === 1) {
      var n1 = (n >> 1);
      var n2 = n - n1 | 0;
      var l2 = chop(n1, l);
      var s1 = sort(n1, l);
      var s2 = sort(n2, l2);
      var _l1 = s1;
      var _l2 = s2;
      var _accu = /* [] */0;
      while(true) {
        var accu = _accu;
        var l2$1 = _l2;
        var l1 = _l1;
        if (l1) {
          if (l2$1) {
            var t2 = l2$1[1];
            var h2 = l2$1[0];
            var t1 = l1[1];
            var h1 = l1[0];
            var c$7 = Curry._2(cmp, h1, h2);
            if (c$7) {
              if (c$7 < 0) {
                _accu = /* :: */[
                  h1,
                  accu
                ];
                _l1 = t1;
                continue ;
                
              }
              else {
                _accu = /* :: */[
                  h2,
                  accu
                ];
                _l2 = t2;
                continue ;
                
              }
            }
            else {
              _accu = /* :: */[
                h1,
                accu
              ];
              _l2 = t2;
              _l1 = t1;
              continue ;
              
            }
          }
          else {
            return rev_append(l1, accu);
          }
        }
        else {
          return rev_append(l2$1, accu);
        }
      };
    }
    
  };
  var len = length(l);
  if (len < 2) {
    return l;
  }
  else {
    return sort(len, l);
  }
}

var append = Pervasives.$at;

var concat = flatten;

var filter = find_all;

var sort = stable_sort;

var fast_sort = stable_sort;

exports.length       = length;
exports.hd           = hd;
exports.tl           = tl;
exports.nth          = nth;
exports.rev          = rev;
exports.append       = append;
exports.rev_append   = rev_append;
exports.concat       = concat;
exports.flatten      = flatten;
exports.iter         = iter;
exports.iteri        = iteri;
exports.map          = map;
exports.mapi         = mapi$1;
exports.rev_map      = rev_map;
exports.fold_left    = fold_left;
exports.fold_right   = fold_right;
exports.iter2        = iter2;
exports.map2         = map2;
exports.rev_map2     = rev_map2;
exports.fold_left2   = fold_left2;
exports.fold_right2  = fold_right2;
exports.for_all      = for_all;
exports.exists       = exists;
exports.for_all2     = for_all2;
exports.exists2      = exists2;
exports.mem          = mem;
exports.memq         = memq;
exports.find         = find;
exports.filter       = filter;
exports.find_all     = find_all;
exports.partition    = partition;
exports.assoc        = assoc;
exports.assq         = assq;
exports.mem_assoc    = mem_assoc;
exports.mem_assq     = mem_assq;
exports.remove_assoc = remove_assoc;
exports.remove_assq  = remove_assq;
exports.split        = split;
exports.combine      = combine;
exports.sort         = sort;
exports.stable_sort  = stable_sort;
exports.fast_sort    = fast_sort;
exports.sort_uniq    = sort_uniq;
exports.merge        = merge;
/* No side effect */
//////// end of list.js ////////
    return exports;
  };


  _registry['map'] = function() {
    let exports = {};
//////// start of map.js ////////
'use strict';

var Curry                   = require("./curry");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function Make(funarg) {
  var height = function (param) {
    if (param) {
      return param[4];
    }
    else {
      return 0;
    }
  };
  var create = function (l, x, d, r) {
    var hl = height(l);
    var hr = height(r);
    return /* Node */[
            l,
            x,
            d,
            r,
            hl >= hr ? hl + 1 | 0 : hr + 1 | 0
          ];
  };
  var singleton = function (x, d) {
    return /* Node */[
            /* Empty */0,
            x,
            d,
            /* Empty */0,
            1
          ];
  };
  var bal = function (l, x, d, r) {
    var hl = l ? l[4] : 0;
    var hr = r ? r[4] : 0;
    if (hl > (hr + 2 | 0)) {
      if (l) {
        var lr = l[3];
        var ld = l[2];
        var lv = l[1];
        var ll = l[0];
        if (height(ll) >= height(lr)) {
          return create(ll, lv, ld, create(lr, x, d, r));
        }
        else if (lr) {
          return create(create(ll, lv, ld, lr[0]), lr[1], lr[2], create(lr[3], x, d, r));
        }
        else {
          throw [
                Caml_builtin_exceptions.invalid_argument,
                "Map.bal"
              ];
        }
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "Map.bal"
            ];
      }
    }
    else if (hr > (hl + 2 | 0)) {
      if (r) {
        var rr = r[3];
        var rd = r[2];
        var rv = r[1];
        var rl = r[0];
        if (height(rr) >= height(rl)) {
          return create(create(l, x, d, rl), rv, rd, rr);
        }
        else if (rl) {
          return create(create(l, x, d, rl[0]), rl[1], rl[2], create(rl[3], rv, rd, rr));
        }
        else {
          throw [
                Caml_builtin_exceptions.invalid_argument,
                "Map.bal"
              ];
        }
      }
      else {
        throw [
              Caml_builtin_exceptions.invalid_argument,
              "Map.bal"
            ];
      }
    }
    else {
      return /* Node */[
              l,
              x,
              d,
              r,
              hl >= hr ? hl + 1 | 0 : hr + 1 | 0
            ];
    }
  };
  var is_empty = function (param) {
    if (param) {
      return /* false */0;
    }
    else {
      return /* true */1;
    }
  };
  var add = function (x, data, param) {
    if (param) {
      var r = param[3];
      var d = param[2];
      var v = param[1];
      var l = param[0];
      var c = Curry._2(funarg[/* compare */0], x, v);
      if (c) {
        if (c < 0) {
          return bal(add(x, data, l), v, d, r);
        }
        else {
          return bal(l, v, d, add(x, data, r));
        }
      }
      else {
        return /* Node */[
                l,
                x,
                data,
                r,
                param[4]
              ];
      }
    }
    else {
      return /* Node */[
              /* Empty */0,
              x,
              data,
              /* Empty */0,
              1
            ];
    }
  };
  var find = function (x, _param) {
    while(true) {
      var param = _param;
      if (param) {
        var c = Curry._2(funarg[/* compare */0], x, param[1]);
        if (c) {
          _param = c < 0 ? param[0] : param[3];
          continue ;
          
        }
        else {
          return param[2];
        }
      }
      else {
        throw Caml_builtin_exceptions.not_found;
      }
    };
  };
  var mem = function (x, _param) {
    while(true) {
      var param = _param;
      if (param) {
        var c = Curry._2(funarg[/* compare */0], x, param[1]);
        if (c) {
          _param = c < 0 ? param[0] : param[3];
          continue ;
          
        }
        else {
          return /* true */1;
        }
      }
      else {
        return /* false */0;
      }
    };
  };
  var min_binding = function (_param) {
    while(true) {
      var param = _param;
      if (param) {
        var l = param[0];
        if (l) {
          _param = l;
          continue ;
          
        }
        else {
          return /* tuple */[
                  param[1],
                  param[2]
                ];
        }
      }
      else {
        throw Caml_builtin_exceptions.not_found;
      }
    };
  };
  var max_binding = function (_param) {
    while(true) {
      var param = _param;
      if (param) {
        var r = param[3];
        if (r) {
          _param = r;
          continue ;
          
        }
        else {
          return /* tuple */[
                  param[1],
                  param[2]
                ];
        }
      }
      else {
        throw Caml_builtin_exceptions.not_found;
      }
    };
  };
  var remove_min_binding = function (param) {
    if (param) {
      var l = param[0];
      if (l) {
        return bal(remove_min_binding(l), param[1], param[2], param[3]);
      }
      else {
        return param[3];
      }
    }
    else {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Map.remove_min_elt"
          ];
    }
  };
  var remove = function (x, param) {
    if (param) {
      var r = param[3];
      var d = param[2];
      var v = param[1];
      var l = param[0];
      var c = Curry._2(funarg[/* compare */0], x, v);
      if (c) {
        if (c < 0) {
          return bal(remove(x, l), v, d, r);
        }
        else {
          return bal(l, v, d, remove(x, r));
        }
      }
      else {
        var t1 = l;
        var t2 = r;
        if (t1) {
          if (t2) {
            var match = min_binding(t2);
            return bal(t1, match[0], match[1], remove_min_binding(t2));
          }
          else {
            return t1;
          }
        }
        else {
          return t2;
        }
      }
    }
    else {
      return /* Empty */0;
    }
  };
  var iter = function (f, _param) {
    while(true) {
      var param = _param;
      if (param) {
        iter(f, param[0]);
        Curry._2(f, param[1], param[2]);
        _param = param[3];
        continue ;
        
      }
      else {
        return /* () */0;
      }
    };
  };
  var map = function (f, param) {
    if (param) {
      var l$prime = map(f, param[0]);
      var d$prime = Curry._1(f, param[2]);
      var r$prime = map(f, param[3]);
      return /* Node */[
              l$prime,
              param[1],
              d$prime,
              r$prime,
              param[4]
            ];
    }
    else {
      return /* Empty */0;
    }
  };
  var mapi = function (f, param) {
    if (param) {
      var v = param[1];
      var l$prime = mapi(f, param[0]);
      var d$prime = Curry._2(f, v, param[2]);
      var r$prime = mapi(f, param[3]);
      return /* Node */[
              l$prime,
              v,
              d$prime,
              r$prime,
              param[4]
            ];
    }
    else {
      return /* Empty */0;
    }
  };
  var fold = function (f, _m, _accu) {
    while(true) {
      var accu = _accu;
      var m = _m;
      if (m) {
        _accu = Curry._3(f, m[1], m[2], fold(f, m[0], accu));
        _m = m[3];
        continue ;
        
      }
      else {
        return accu;
      }
    };
  };
  var for_all = function (p, _param) {
    while(true) {
      var param = _param;
      if (param) {
        if (Curry._2(p, param[1], param[2])) {
          if (for_all(p, param[0])) {
            _param = param[3];
            continue ;
            
          }
          else {
            return /* false */0;
          }
        }
        else {
          return /* false */0;
        }
      }
      else {
        return /* true */1;
      }
    };
  };
  var exists = function (p, _param) {
    while(true) {
      var param = _param;
      if (param) {
        if (Curry._2(p, param[1], param[2])) {
          return /* true */1;
        }
        else if (exists(p, param[0])) {
          return /* true */1;
        }
        else {
          _param = param[3];
          continue ;
          
        }
      }
      else {
        return /* false */0;
      }
    };
  };
  var add_min_binding = function (k, v, param) {
    if (param) {
      return bal(add_min_binding(k, v, param[0]), param[1], param[2], param[3]);
    }
    else {
      return singleton(k, v);
    }
  };
  var add_max_binding = function (k, v, param) {
    if (param) {
      return bal(param[0], param[1], param[2], add_max_binding(k, v, param[3]));
    }
    else {
      return singleton(k, v);
    }
  };
  var join = function (l, v, d, r) {
    if (l) {
      if (r) {
        var rh = r[4];
        var lh = l[4];
        if (lh > (rh + 2 | 0)) {
          return bal(l[0], l[1], l[2], join(l[3], v, d, r));
        }
        else if (rh > (lh + 2 | 0)) {
          return bal(join(l, v, d, r[0]), r[1], r[2], r[3]);
        }
        else {
          return create(l, v, d, r);
        }
      }
      else {
        return add_max_binding(v, d, l);
      }
    }
    else {
      return add_min_binding(v, d, r);
    }
  };
  var concat = function (t1, t2) {
    if (t1) {
      if (t2) {
        var match = min_binding(t2);
        return join(t1, match[0], match[1], remove_min_binding(t2));
      }
      else {
        return t1;
      }
    }
    else {
      return t2;
    }
  };
  var concat_or_join = function (t1, v, d, t2) {
    if (d) {
      return join(t1, v, d[0], t2);
    }
    else {
      return concat(t1, t2);
    }
  };
  var split = function (x, param) {
    if (param) {
      var r = param[3];
      var d = param[2];
      var v = param[1];
      var l = param[0];
      var c = Curry._2(funarg[/* compare */0], x, v);
      if (c) {
        if (c < 0) {
          var match = split(x, l);
          return /* tuple */[
                  match[0],
                  match[1],
                  join(match[2], v, d, r)
                ];
        }
        else {
          var match$1 = split(x, r);
          return /* tuple */[
                  join(l, v, d, match$1[0]),
                  match$1[1],
                  match$1[2]
                ];
        }
      }
      else {
        return /* tuple */[
                l,
                /* Some */[d],
                r
              ];
      }
    }
    else {
      return /* tuple */[
              /* Empty */0,
              /* None */0,
              /* Empty */0
            ];
    }
  };
  var merge = function (f, s1, s2) {
    var exit = 0;
    if (s1) {
      var v1 = s1[1];
      if (s1[4] >= height(s2)) {
        var match = split(v1, s2);
        return concat_or_join(merge(f, s1[0], match[0]), v1, Curry._3(f, v1, /* Some */[s1[2]], match[1]), merge(f, s1[3], match[2]));
      }
      else {
        exit = 1;
      }
    }
    else if (s2) {
      exit = 1;
    }
    else {
      return /* Empty */0;
    }
    if (exit === 1) {
      if (s2) {
        var v2 = s2[1];
        var match$1 = split(v2, s1);
        return concat_or_join(merge(f, match$1[0], s2[0]), v2, Curry._3(f, v2, match$1[1], /* Some */[s2[2]]), merge(f, match$1[2], s2[3]));
      }
      else {
        throw [
              Caml_builtin_exceptions.assert_failure,
              [
                "map.ml",
                270,
                10
              ]
            ];
      }
    }
    
  };
  var filter = function (p, param) {
    if (param) {
      var d = param[2];
      var v = param[1];
      var l$prime = filter(p, param[0]);
      var pvd = Curry._2(p, v, d);
      var r$prime = filter(p, param[3]);
      if (pvd) {
        return join(l$prime, v, d, r$prime);
      }
      else {
        return concat(l$prime, r$prime);
      }
    }
    else {
      return /* Empty */0;
    }
  };
  var partition = function (p, param) {
    if (param) {
      var d = param[2];
      var v = param[1];
      var match = partition(p, param[0]);
      var lf = match[1];
      var lt = match[0];
      var pvd = Curry._2(p, v, d);
      var match$1 = partition(p, param[3]);
      var rf = match$1[1];
      var rt = match$1[0];
      if (pvd) {
        return /* tuple */[
                join(lt, v, d, rt),
                concat(lf, rf)
              ];
      }
      else {
        return /* tuple */[
                concat(lt, rt),
                join(lf, v, d, rf)
              ];
      }
    }
    else {
      return /* tuple */[
              /* Empty */0,
              /* Empty */0
            ];
    }
  };
  var cons_enum = function (_m, _e) {
    while(true) {
      var e = _e;
      var m = _m;
      if (m) {
        _e = /* More */[
          m[1],
          m[2],
          m[3],
          e
        ];
        _m = m[0];
        continue ;
        
      }
      else {
        return e;
      }
    };
  };
  var compare = function (cmp, m1, m2) {
    var _e1 = cons_enum(m1, /* End */0);
    var _e2 = cons_enum(m2, /* End */0);
    while(true) {
      var e2 = _e2;
      var e1 = _e1;
      if (e1) {
        if (e2) {
          var c = Curry._2(funarg[/* compare */0], e1[0], e2[0]);
          if (c !== 0) {
            return c;
          }
          else {
            var c$1 = Curry._2(cmp, e1[1], e2[1]);
            if (c$1 !== 0) {
              return c$1;
            }
            else {
              _e2 = cons_enum(e2[2], e2[3]);
              _e1 = cons_enum(e1[2], e1[3]);
              continue ;
              
            }
          }
        }
        else {
          return 1;
        }
      }
      else if (e2) {
        return -1;
      }
      else {
        return 0;
      }
    };
  };
  var equal = function (cmp, m1, m2) {
    var _e1 = cons_enum(m1, /* End */0);
    var _e2 = cons_enum(m2, /* End */0);
    while(true) {
      var e2 = _e2;
      var e1 = _e1;
      if (e1) {
        if (e2) {
          if (Curry._2(funarg[/* compare */0], e1[0], e2[0])) {
            return /* false */0;
          }
          else if (Curry._2(cmp, e1[1], e2[1])) {
            _e2 = cons_enum(e2[2], e2[3]);
            _e1 = cons_enum(e1[2], e1[3]);
            continue ;
            
          }
          else {
            return /* false */0;
          }
        }
        else {
          return /* false */0;
        }
      }
      else if (e2) {
        return /* false */0;
      }
      else {
        return /* true */1;
      }
    };
  };
  var cardinal = function (param) {
    if (param) {
      return (cardinal(param[0]) + 1 | 0) + cardinal(param[3]) | 0;
    }
    else {
      return 0;
    }
  };
  var bindings_aux = function (_accu, _param) {
    while(true) {
      var param = _param;
      var accu = _accu;
      if (param) {
        _param = param[0];
        _accu = /* :: */[
          /* tuple */[
            param[1],
            param[2]
          ],
          bindings_aux(accu, param[3])
        ];
        continue ;
        
      }
      else {
        return accu;
      }
    };
  };
  var bindings = function (s) {
    return bindings_aux(/* [] */0, s);
  };
  return [
          /* Empty */0,
          is_empty,
          mem,
          add,
          singleton,
          remove,
          merge,
          compare,
          equal,
          iter,
          fold,
          for_all,
          exists,
          filter,
          partition,
          cardinal,
          bindings,
          min_binding,
          max_binding,
          min_binding,
          split,
          find,
          map,
          mapi
        ];
}

exports.Make = Make;
/* No side effect */
//////// end of map.js ////////
    return exports;
  };


  _registry['numeric_error'] = function() {
    let exports = {};
//////// start of numeric_error.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Caml_exceptions = require("bs-platform/lib/js/caml_exceptions");

var IntegerOverflow = Caml_exceptions.create("Numeric_error.IntegerOverflow");

var IntegerDivideByZero = Caml_exceptions.create("Numeric_error.IntegerDivideByZero");

var InvalidConversionToInteger = Caml_exceptions.create("Numeric_error.InvalidConversionToInteger");

exports.IntegerOverflow            = IntegerOverflow;
exports.IntegerDivideByZero        = IntegerDivideByZero;
exports.InvalidConversionToInteger = InvalidConversionToInteger;
/* No side effect */
//////// end of numeric_error.js ////////
    return exports;
  };


  _registry['obj'] = function() {
    let exports = {};
//////// start of obj.js ////////
'use strict';

var Marshal                 = require("./marshal");
var Caml_builtin_exceptions = require("./caml_builtin_exceptions");

function double_field(x, i) {
  return x[i];
}

function set_double_field(x, i, v) {
  x[i] = v;
  return /* () */0;
}

function marshal() {
  return function () {
            throw "caml_output_value_to_string not implemented by bucklescript yet\n";
          }();
}

function unmarshal(str, pos) {
  return /* tuple */[
          Marshal.from_bytes(str, pos),
          pos + Marshal.total_size(str, pos) | 0
        ];
}

function extension_slot(x) {
  var slot = x.length !== undefined && (x.tag | 0) !== 248 && x.length >= 1 ? x[0] : x;
  var name;
  if (slot.length !== undefined && slot.tag === 248) {
    name = slot[0];
  }
  else {
    throw Caml_builtin_exceptions.not_found;
  }
  if (name.tag === 252) {
    return slot;
  }
  else {
    throw Caml_builtin_exceptions.not_found;
  }
}

function extension_name(x) {
  try {
    var slot = extension_slot(x);
    return slot[0];
  }
  catch (exn){
    if (exn === Caml_builtin_exceptions.not_found) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Obj.extension_name"
          ];
    }
    else {
      throw exn;
    }
  }
}

function extension_id(x) {
  try {
    var slot = extension_slot(x);
    return slot[1];
  }
  catch (exn){
    if (exn === Caml_builtin_exceptions.not_found) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Obj.extension_id"
          ];
    }
    else {
      throw exn;
    }
  }
}

function extension_slot$1(x) {
  try {
    return extension_slot(x);
  }
  catch (exn){
    if (exn === Caml_builtin_exceptions.not_found) {
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "Obj.extension_slot"
          ];
    }
    else {
      throw exn;
    }
  }
}

var first_non_constant_constructor_tag = 0;

var last_non_constant_constructor_tag = 245;

var lazy_tag = 246;

var closure_tag = 247;

var object_tag = 248;

var infix_tag = 249;

var forward_tag = 250;

var no_scan_tag = 251;

var abstract_tag = 251;

var string_tag = 252;

var double_tag = 253;

var double_array_tag = 254;

var custom_tag = 255;

var final_tag = 255;

var int_tag = 1000;

var out_of_heap_tag = 1001;

var unaligned_tag = 1002;

exports.double_field                       = double_field;
exports.set_double_field                   = set_double_field;
exports.first_non_constant_constructor_tag = first_non_constant_constructor_tag;
exports.last_non_constant_constructor_tag  = last_non_constant_constructor_tag;
exports.lazy_tag                           = lazy_tag;
exports.closure_tag                        = closure_tag;
exports.object_tag                         = object_tag;
exports.infix_tag                          = infix_tag;
exports.forward_tag                        = forward_tag;
exports.no_scan_tag                        = no_scan_tag;
exports.abstract_tag                       = abstract_tag;
exports.string_tag                         = string_tag;
exports.double_tag                         = double_tag;
exports.double_array_tag                   = double_array_tag;
exports.custom_tag                         = custom_tag;
exports.final_tag                          = final_tag;
exports.int_tag                            = int_tag;
exports.out_of_heap_tag                    = out_of_heap_tag;
exports.unaligned_tag                      = unaligned_tag;
exports.extension_name                     = extension_name;
exports.extension_id                       = extension_id;
exports.extension_slot                     = extension_slot$1;
exports.marshal                            = marshal;
exports.unmarshal                          = unmarshal;
/* No side effect */
//////// end of obj.js ////////
    return exports;
  };


  _registry['oo'] = function() {
    let exports = {};
//////// start of oo.js ////////
'use strict';

var CamlinternalOO = require("./camlinternalOO");

var copy = CamlinternalOO.copy;

var new_method = CamlinternalOO.public_method_label;

var public_method_label = CamlinternalOO.public_method_label;

exports.copy                = copy;
exports.new_method          = new_method;
exports.public_method_label = public_method_label;
/* No side effect */
//////// end of oo.js ////////
    return exports;
  };


  _registry['operators'] = function() {
    let exports = {};
//////// start of operators.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Block  = require("bs-platform/lib/js/block");
var Source = require("./source");

function i32_const(n) {
  return /* Const */Block.__(15, [Source.$at$at(/* I32 */Block.__(0, [n[/* it */1]]), n[/* at */0])]);
}

function i64_const(n) {
  return /* Const */Block.__(15, [Source.$at$at(/* I64 */Block.__(1, [n[/* it */1]]), n[/* at */0])]);
}

function f32_const(n) {
  return /* Const */Block.__(15, [Source.$at$at(/* F32 */Block.__(2, [n[/* it */1]]), n[/* at */0])]);
}

function f64_const(n) {
  return /* Const */Block.__(15, [Source.$at$at(/* F64 */Block.__(3, [n[/* it */1]]), n[/* at */0])]);
}

function block(ts, es) {
  return /* Block */Block.__(0, [
            ts,
            es
          ]);
}

function loop(ts, es) {
  return /* Loop */Block.__(1, [
            ts,
            es
          ]);
}

function br(x) {
  return /* Br */Block.__(3, [x]);
}

function br_if(x) {
  return /* BrIf */Block.__(4, [x]);
}

function br_table(xs, x) {
  return /* BrTable */Block.__(5, [
            xs,
            x
          ]);
}

function if_(ts, es1, es2) {
  return /* If */Block.__(2, [
            ts,
            es1,
            es2
          ]);
}

function call(x) {
  return /* Call */Block.__(6, [x]);
}

function call_indirect(x) {
  return /* CallIndirect */Block.__(7, [x]);
}

function get_local(x) {
  return /* GetLocal */Block.__(8, [x]);
}

function set_local(x) {
  return /* SetLocal */Block.__(9, [x]);
}

function tee_local(x) {
  return /* TeeLocal */Block.__(10, [x]);
}

function get_global(x) {
  return /* GetGlobal */Block.__(11, [x]);
}

function set_global(x) {
  return /* SetGlobal */Block.__(12, [x]);
}

function i32_load(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function i64_load(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function f32_load(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : F32Type */2,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function f64_load(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : F64Type */3,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function i32_load8_s(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem8 */0,
                  /* SX */0
                ]]
            ]]);
}

function i32_load8_u(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem8 */0,
                  /* ZX */1
                ]]
            ]]);
}

function i32_load16_s(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem16 */1,
                  /* SX */0
                ]]
            ]]);
}

function i32_load16_u(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem16 */1,
                  /* ZX */1
                ]]
            ]]);
}

function i64_load8_s(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem8 */0,
                  /* SX */0
                ]]
            ]]);
}

function i64_load8_u(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem8 */0,
                  /* ZX */1
                ]]
            ]]);
}

function i64_load16_s(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem16 */1,
                  /* SX */0
                ]]
            ]]);
}

function i64_load16_u(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem16 */1,
                  /* ZX */1
                ]]
            ]]);
}

function i64_load32_s(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem32 */2,
                  /* SX */0
                ]]
            ]]);
}

function i64_load32_u(align, offset) {
  return /* Load */Block.__(13, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* tuple */[
                  /* Mem32 */2,
                  /* ZX */1
                ]]
            ]]);
}

function i32_store(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function i64_store(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function f32_store(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : F32Type */2,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function f64_store(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : F64Type */3,
              /* align */align,
              /* offset */offset,
              /* sz : None */0
            ]]);
}

function i32_store8(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* Mem8 */0]
            ]]);
}

function i32_store16(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I32Type */0,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* Mem16 */1]
            ]]);
}

function i64_store8(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* Mem8 */0]
            ]]);
}

function i64_store16(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* Mem16 */1]
            ]]);
}

function i64_store32(align, offset) {
  return /* Store */Block.__(14, [/* record */[
              /* ty : I64Type */1,
              /* align */align,
              /* offset */offset,
              /* sz : Some */[/* Mem32 */2]
            ]]);
}

var unreachable = /* Unreachable */0;

var nop = /* Nop */1;

var drop = /* Drop */3;

var $$return = /* Return */2;

var select = /* Select */4;

var i32_clz = /* Unary */Block.__(18, [/* I32 */Block.__(0, [/* Clz */0])]);

var i32_ctz = /* Unary */Block.__(18, [/* I32 */Block.__(0, [/* Ctz */1])]);

var i32_popcnt = /* Unary */Block.__(18, [/* I32 */Block.__(0, [/* Popcnt */2])]);

var i64_clz = /* Unary */Block.__(18, [/* I64 */Block.__(1, [/* Clz */0])]);

var i64_ctz = /* Unary */Block.__(18, [/* I64 */Block.__(1, [/* Ctz */1])]);

var i64_popcnt = /* Unary */Block.__(18, [/* I64 */Block.__(1, [/* Popcnt */2])]);

var f32_neg = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Neg */0])]);

var f32_abs = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Abs */1])]);

var f32_sqrt = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Sqrt */6])]);

var f32_ceil = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Ceil */2])]);

var f32_floor = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Floor */3])]);

var f32_trunc = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Trunc */4])]);

var f32_nearest = /* Unary */Block.__(18, [/* F32 */Block.__(2, [/* Nearest */5])]);

var f64_neg = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Neg */0])]);

var f64_abs = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Abs */1])]);

var f64_sqrt = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Sqrt */6])]);

var f64_ceil = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Ceil */2])]);

var f64_floor = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Floor */3])]);

var f64_trunc = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Trunc */4])]);

var f64_nearest = /* Unary */Block.__(18, [/* F64 */Block.__(3, [/* Nearest */5])]);

var i32_add = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Add */0])]);

var i32_sub = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Sub */1])]);

var i32_mul = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Mul */2])]);

var i32_div_s = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* DivS */3])]);

var i32_div_u = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* DivU */4])]);

var i32_rem_s = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* RemS */5])]);

var i32_rem_u = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* RemU */6])]);

var i32_and = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* And */7])]);

var i32_or = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Or */8])]);

var i32_xor = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Xor */9])]);

var i32_shl = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Shl */10])]);

var i32_shr_s = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* ShrS */11])]);

var i32_shr_u = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* ShrU */12])]);

var i32_rotl = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Rotl */13])]);

var i32_rotr = /* Binary */Block.__(19, [/* I32 */Block.__(0, [/* Rotr */14])]);

var i64_add = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Add */0])]);

var i64_sub = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Sub */1])]);

var i64_mul = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Mul */2])]);

var i64_div_s = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* DivS */3])]);

var i64_div_u = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* DivU */4])]);

var i64_rem_s = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* RemS */5])]);

var i64_rem_u = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* RemU */6])]);

var i64_and = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* And */7])]);

var i64_or = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Or */8])]);

var i64_xor = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Xor */9])]);

var i64_shl = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Shl */10])]);

var i64_shr_s = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* ShrS */11])]);

var i64_shr_u = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* ShrU */12])]);

var i64_rotl = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Rotl */13])]);

var i64_rotr = /* Binary */Block.__(19, [/* I64 */Block.__(1, [/* Rotr */14])]);

var f32_add = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* Add */0])]);

var f32_sub = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* Sub */1])]);

var f32_mul = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* Mul */2])]);

var f32_div = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* Div */3])]);

var f32_min = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* Min */4])]);

var f32_max = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* Max */5])]);

var f32_copysign = /* Binary */Block.__(19, [/* F32 */Block.__(2, [/* CopySign */6])]);

var f64_add = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* Add */0])]);

var f64_sub = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* Sub */1])]);

var f64_mul = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* Mul */2])]);

var f64_div = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* Div */3])]);

var f64_min = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* Min */4])]);

var f64_max = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* Max */5])]);

var f64_copysign = /* Binary */Block.__(19, [/* F64 */Block.__(3, [/* CopySign */6])]);

var i32_eqz = /* Test */Block.__(16, [/* I32 */Block.__(0, [/* Eqz */0])]);

var i64_eqz = /* Test */Block.__(16, [/* I64 */Block.__(1, [/* Eqz */0])]);

var i32_eq = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* Eq */0])]);

var i32_ne = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* Ne */1])]);

var i32_lt_s = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* LtS */2])]);

var i32_lt_u = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* LtU */3])]);

var i32_le_s = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* LeS */6])]);

var i32_le_u = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* LeU */7])]);

var i32_gt_s = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* GtS */4])]);

var i32_gt_u = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* GtU */5])]);

var i32_ge_s = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* GeS */8])]);

var i32_ge_u = /* Compare */Block.__(17, [/* I32 */Block.__(0, [/* GeU */9])]);

var i64_eq = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* Eq */0])]);

var i64_ne = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* Ne */1])]);

var i64_lt_s = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* LtS */2])]);

var i64_lt_u = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* LtU */3])]);

var i64_le_s = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* LeS */6])]);

var i64_le_u = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* LeU */7])]);

var i64_gt_s = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* GtS */4])]);

var i64_gt_u = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* GtU */5])]);

var i64_ge_s = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* GeS */8])]);

var i64_ge_u = /* Compare */Block.__(17, [/* I64 */Block.__(1, [/* GeU */9])]);

var f32_eq = /* Compare */Block.__(17, [/* F32 */Block.__(2, [/* Eq */0])]);

var f32_ne = /* Compare */Block.__(17, [/* F32 */Block.__(2, [/* Ne */1])]);

var f32_lt = /* Compare */Block.__(17, [/* F32 */Block.__(2, [/* Lt */2])]);

var f32_le = /* Compare */Block.__(17, [/* F32 */Block.__(2, [/* Le */4])]);

var f32_gt = /* Compare */Block.__(17, [/* F32 */Block.__(2, [/* Gt */3])]);

var f32_ge = /* Compare */Block.__(17, [/* F32 */Block.__(2, [/* Ge */5])]);

var f64_eq = /* Compare */Block.__(17, [/* F64 */Block.__(3, [/* Eq */0])]);

var f64_ne = /* Compare */Block.__(17, [/* F64 */Block.__(3, [/* Ne */1])]);

var f64_lt = /* Compare */Block.__(17, [/* F64 */Block.__(3, [/* Lt */2])]);

var f64_le = /* Compare */Block.__(17, [/* F64 */Block.__(3, [/* Le */4])]);

var f64_gt = /* Compare */Block.__(17, [/* F64 */Block.__(3, [/* Gt */3])]);

var f64_ge = /* Compare */Block.__(17, [/* F64 */Block.__(3, [/* Ge */5])]);

var i32_wrap_i64 = /* Convert */Block.__(20, [/* I32 */Block.__(0, [/* WrapI64 */2])]);

var i32_trunc_s_f32 = /* Convert */Block.__(20, [/* I32 */Block.__(0, [/* TruncSF32 */3])]);

var i32_trunc_u_f32 = /* Convert */Block.__(20, [/* I32 */Block.__(0, [/* TruncUF32 */4])]);

var i32_trunc_s_f64 = /* Convert */Block.__(20, [/* I32 */Block.__(0, [/* TruncSF64 */5])]);

var i32_trunc_u_f64 = /* Convert */Block.__(20, [/* I32 */Block.__(0, [/* TruncUF64 */6])]);

var i64_extend_s_i32 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* ExtendSI32 */0])]);

var i64_extend_u_i32 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* ExtendUI32 */1])]);

var i64_trunc_s_f32 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* TruncSF32 */3])]);

var i64_trunc_u_f32 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* TruncUF32 */4])]);

var i64_trunc_s_f64 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* TruncSF64 */5])]);

var i64_trunc_u_f64 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* TruncUF64 */6])]);

var f32_convert_s_i32 = /* Convert */Block.__(20, [/* F32 */Block.__(2, [/* ConvertSI32 */0])]);

var f32_convert_u_i32 = /* Convert */Block.__(20, [/* F32 */Block.__(2, [/* ConvertUI32 */1])]);

var f32_convert_s_i64 = /* Convert */Block.__(20, [/* F32 */Block.__(2, [/* ConvertSI64 */2])]);

var f32_convert_u_i64 = /* Convert */Block.__(20, [/* F32 */Block.__(2, [/* ConvertUI64 */3])]);

var f32_demote_f64 = /* Convert */Block.__(20, [/* F32 */Block.__(2, [/* DemoteF64 */5])]);

var f64_convert_s_i32 = /* Convert */Block.__(20, [/* F64 */Block.__(3, [/* ConvertSI32 */0])]);

var f64_convert_u_i32 = /* Convert */Block.__(20, [/* F64 */Block.__(3, [/* ConvertUI32 */1])]);

var f64_convert_s_i64 = /* Convert */Block.__(20, [/* F64 */Block.__(3, [/* ConvertSI64 */2])]);

var f64_convert_u_i64 = /* Convert */Block.__(20, [/* F64 */Block.__(3, [/* ConvertUI64 */3])]);

var f64_promote_f32 = /* Convert */Block.__(20, [/* F64 */Block.__(3, [/* PromoteF32 */4])]);

var i32_reinterpret_f32 = /* Convert */Block.__(20, [/* I32 */Block.__(0, [/* ReinterpretFloat */7])]);

var i64_reinterpret_f64 = /* Convert */Block.__(20, [/* I64 */Block.__(1, [/* ReinterpretFloat */7])]);

var f32_reinterpret_i32 = /* Convert */Block.__(20, [/* F32 */Block.__(2, [/* ReinterpretInt */6])]);

var f64_reinterpret_i64 = /* Convert */Block.__(20, [/* F64 */Block.__(3, [/* ReinterpretInt */6])]);

var current_memory = /* CurrentMemory */5;

var grow_memory = /* GrowMemory */6;

exports.i32_const           = i32_const;
exports.i64_const           = i64_const;
exports.f32_const           = f32_const;
exports.f64_const           = f64_const;
exports.unreachable         = unreachable;
exports.nop                 = nop;
exports.drop                = drop;
exports.block               = block;
exports.loop                = loop;
exports.br                  = br;
exports.br_if               = br_if;
exports.br_table            = br_table;
exports.$$return            = $$return;
exports.if_                 = if_;
exports.select              = select;
exports.call                = call;
exports.call_indirect       = call_indirect;
exports.get_local           = get_local;
exports.set_local           = set_local;
exports.tee_local           = tee_local;
exports.get_global          = get_global;
exports.set_global          = set_global;
exports.i32_load            = i32_load;
exports.i64_load            = i64_load;
exports.f32_load            = f32_load;
exports.f64_load            = f64_load;
exports.i32_load8_s         = i32_load8_s;
exports.i32_load8_u         = i32_load8_u;
exports.i32_load16_s        = i32_load16_s;
exports.i32_load16_u        = i32_load16_u;
exports.i64_load8_s         = i64_load8_s;
exports.i64_load8_u         = i64_load8_u;
exports.i64_load16_s        = i64_load16_s;
exports.i64_load16_u        = i64_load16_u;
exports.i64_load32_s        = i64_load32_s;
exports.i64_load32_u        = i64_load32_u;
exports.i32_store           = i32_store;
exports.i64_store           = i64_store;
exports.f32_store           = f32_store;
exports.f64_store           = f64_store;
exports.i32_store8          = i32_store8;
exports.i32_store16         = i32_store16;
exports.i64_store8          = i64_store8;
exports.i64_store16         = i64_store16;
exports.i64_store32         = i64_store32;
exports.i32_clz             = i32_clz;
exports.i32_ctz             = i32_ctz;
exports.i32_popcnt          = i32_popcnt;
exports.i64_clz             = i64_clz;
exports.i64_ctz             = i64_ctz;
exports.i64_popcnt          = i64_popcnt;
exports.f32_neg             = f32_neg;
exports.f32_abs             = f32_abs;
exports.f32_sqrt            = f32_sqrt;
exports.f32_ceil            = f32_ceil;
exports.f32_floor           = f32_floor;
exports.f32_trunc           = f32_trunc;
exports.f32_nearest         = f32_nearest;
exports.f64_neg             = f64_neg;
exports.f64_abs             = f64_abs;
exports.f64_sqrt            = f64_sqrt;
exports.f64_ceil            = f64_ceil;
exports.f64_floor           = f64_floor;
exports.f64_trunc           = f64_trunc;
exports.f64_nearest         = f64_nearest;
exports.i32_add             = i32_add;
exports.i32_sub             = i32_sub;
exports.i32_mul             = i32_mul;
exports.i32_div_s           = i32_div_s;
exports.i32_div_u           = i32_div_u;
exports.i32_rem_s           = i32_rem_s;
exports.i32_rem_u           = i32_rem_u;
exports.i32_and             = i32_and;
exports.i32_or              = i32_or;
exports.i32_xor             = i32_xor;
exports.i32_shl             = i32_shl;
exports.i32_shr_s           = i32_shr_s;
exports.i32_shr_u           = i32_shr_u;
exports.i32_rotl            = i32_rotl;
exports.i32_rotr            = i32_rotr;
exports.i64_add             = i64_add;
exports.i64_sub             = i64_sub;
exports.i64_mul             = i64_mul;
exports.i64_div_s           = i64_div_s;
exports.i64_div_u           = i64_div_u;
exports.i64_rem_s           = i64_rem_s;
exports.i64_rem_u           = i64_rem_u;
exports.i64_and             = i64_and;
exports.i64_or              = i64_or;
exports.i64_xor             = i64_xor;
exports.i64_shl             = i64_shl;
exports.i64_shr_s           = i64_shr_s;
exports.i64_shr_u           = i64_shr_u;
exports.i64_rotl            = i64_rotl;
exports.i64_rotr            = i64_rotr;
exports.f32_add             = f32_add;
exports.f32_sub             = f32_sub;
exports.f32_mul             = f32_mul;
exports.f32_div             = f32_div;
exports.f32_min             = f32_min;
exports.f32_max             = f32_max;
exports.f32_copysign        = f32_copysign;
exports.f64_add             = f64_add;
exports.f64_sub             = f64_sub;
exports.f64_mul             = f64_mul;
exports.f64_div             = f64_div;
exports.f64_min             = f64_min;
exports.f64_max             = f64_max;
exports.f64_copysign        = f64_copysign;
exports.i32_eqz             = i32_eqz;
exports.i64_eqz             = i64_eqz;
exports.i32_eq              = i32_eq;
exports.i32_ne              = i32_ne;
exports.i32_lt_s            = i32_lt_s;
exports.i32_lt_u            = i32_lt_u;
exports.i32_le_s            = i32_le_s;
exports.i32_le_u            = i32_le_u;
exports.i32_gt_s            = i32_gt_s;
exports.i32_gt_u            = i32_gt_u;
exports.i32_ge_s            = i32_ge_s;
exports.i32_ge_u            = i32_ge_u;
exports.i64_eq              = i64_eq;
exports.i64_ne              = i64_ne;
exports.i64_lt_s            = i64_lt_s;
exports.i64_lt_u            = i64_lt_u;
exports.i64_le_s            = i64_le_s;
exports.i64_le_u            = i64_le_u;
exports.i64_gt_s            = i64_gt_s;
exports.i64_gt_u            = i64_gt_u;
exports.i64_ge_s            = i64_ge_s;
exports.i64_ge_u            = i64_ge_u;
exports.f32_eq              = f32_eq;
exports.f32_ne              = f32_ne;
exports.f32_lt              = f32_lt;
exports.f32_le              = f32_le;
exports.f32_gt              = f32_gt;
exports.f32_ge              = f32_ge;
exports.f64_eq              = f64_eq;
exports.f64_ne              = f64_ne;
exports.f64_lt              = f64_lt;
exports.f64_le              = f64_le;
exports.f64_gt              = f64_gt;
exports.f64_ge              = f64_ge;
exports.i32_wrap_i64        = i32_wrap_i64;
exports.i32_trunc_s_f32     = i32_trunc_s_f32;
exports.i32_trunc_u_f32     = i32_trunc_u_f32;
exports.i32_trunc_s_f64     = i32_trunc_s_f64;
exports.i32_trunc_u_f64     = i32_trunc_u_f64;
exports.i64_extend_s_i32    = i64_extend_s_i32;
exports.i64_extend_u_i32    = i64_extend_u_i32;
exports.i64_trunc_s_f32     = i64_trunc_s_f32;
exports.i64_trunc_u_f32     = i64_trunc_u_f32;
exports.i64_trunc_s_f64     = i64_trunc_s_f64;
exports.i64_trunc_u_f64     = i64_trunc_u_f64;
exports.f32_convert_s_i32   = f32_convert_s_i32;
exports.f32_convert_u_i32   = f32_convert_u_i32;
exports.f32_convert_s_i64   = f32_convert_s_i64;
exports.f32_convert_u_i64   = f32_convert_u_i64;
exports.f32_demote_f64      = f32_demote_f64;
exports.f64_convert_s_i32   = f64_convert_s_i32;
exports.f64_convert_u_i32   = f64_convert_u_i32;
exports.f64_convert_s_i64   = f64_convert_s_i64;
exports.f64_convert_u_i64   = f64_convert_u_i64;
exports.f64_promote_f32     = f64_promote_f32;
exports.i32_reinterpret_f32 = i32_reinterpret_f32;
exports.i64_reinterpret_f64 = i64_reinterpret_f64;
exports.f32_reinterpret_i32 = f32_reinterpret_i32;
exports.f64_reinterpret_i64 = f64_reinterpret_i64;
exports.current_memory      = current_memory;
exports.grow_memory         = grow_memory;
/* No side effect */
//////// end of operators.js ////////
    return exports;
  };


  _registry['parse'] = function() {
    let exports = {};
//////// start of parse.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Curry    = require("bs-platform/lib/js/curry");
var Lexer    = require("./lexer");
var Lexing   = require("bs-platform/lib/js/lexing");
var Parser   = require("./parser");
var Script   = require("./script");
var Source   = require("./source");
var Caml_obj = require("bs-platform/lib/js/caml_obj");

function parse$prime(name, lexbuf, start) {
  var init = lexbuf[/* lex_curr_p */11];
  lexbuf[/* lex_curr_p */11] = /* record */[
    /* pos_fname */name,
    /* pos_lnum */init[/* pos_lnum */1],
    /* pos_bol */init[/* pos_bol */2],
    /* pos_cnum */init[/* pos_cnum */3]
  ];
  try {
    return Curry._2(start, Lexer.token, lexbuf);
  }
  catch (exn){
    if (exn[0] === Script.Syntax) {
      var region = exn[1];
      var region$prime = Caml_obj.caml_notequal(region, Source.no_region) ? region : /* record */[
          /* left */Lexer.convert_pos(lexbuf[/* lex_start_p */10]),
          /* right */Lexer.convert_pos(lexbuf[/* lex_curr_p */11])
        ];
      throw [
            Script.Syntax,
            region$prime,
            exn[2]
          ];
    }
    else {
      throw exn;
    }
  }
}

function parse(name, lexbuf, param) {
  switch (param) {
    case 0 : 
        return parse$prime(name, lexbuf, Parser.module1);
    case 1 : 
        return parse$prime(name, lexbuf, Parser.script);
    case 2 : 
        return parse$prime(name, lexbuf, Parser.script1);
    
  }
}

function string_to(start, s) {
  var lexbuf = Lexing.from_string(s);
  return parse("string", lexbuf, start);
}

function string_to_script(s) {
  return string_to(/* Script */1, s);
}

function string_to_module(s) {
  return string_to(/* Module */0, s);
}

var Syntax = Script.Syntax;

exports.Syntax           = Syntax;
exports.parse            = parse;
exports.string_to_script = string_to_script;
exports.string_to_module = string_to_module;
/* Lexer Not a pure module */
//////// end of parse.js ////////
    return exports;
  };


  _registry['parser'] = function() {
    let exports = {};
//////// start of parser.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Ast                     = require("./ast");
var I32                     = require("./i32");
var Lib                     = require("./lib");
var $$Map                   = require("bs-platform/lib/js/map");
var List                    = require("bs-platform/lib/js/list");
var Block                   = require("bs-platform/lib/js/block");
var Curry                   = require("bs-platform/lib/js/curry");
var Script                  = require("./script");
var Source                  = require("./source");
var $$String                = require("bs-platform/lib/js/string");
var Parsing                 = require("bs-platform/lib/js/parsing");
var Caml_obj                = require("bs-platform/lib/js/caml_obj");
var Operators               = require("./operators");
var Pervasives              = require("bs-platform/lib/js/pervasives");
var Caml_format             = require("bs-platform/lib/js/caml_format");
var Caml_builtin_exceptions = require("bs-platform/lib/js/caml_builtin_exceptions");

function parse_error(msg) {
  var msg$1 = msg === "syntax error" ? "unexpected token" : msg;
  throw [
        Script.Syntax,
        Source.no_region,
        msg$1
      ];
}

function position_to_pos(position) {
  return /* record */[
          /* file */position[/* pos_fname */0],
          /* line */position[/* pos_lnum */1],
          /* column */position[/* pos_cnum */3] - position[/* pos_bol */2] | 0
        ];
}

function positions_to_region(position1, position2) {
  return /* record */[
          /* left */position_to_pos(position1),
          /* right */position_to_pos(position2)
        ];
}

function at() {
  return positions_to_region(Parsing.symbol_start_pos(/* () */0), Parsing.symbol_end_pos(/* () */0));
}

function ati(i) {
  return positions_to_region(Parsing.rhs_start_pos(i), Parsing.rhs_end_pos(i));
}

function literal(f, s) {
  try {
    return Curry._1(f, s);
  }
  catch (exn){
    if (exn[0] === Caml_builtin_exceptions.failure) {
      throw [
            Script.Syntax,
            s[/* at */0],
            "constant out of range"
          ];
    }
    else {
      throw exn;
    }
  }
}

function nat(s, at) {
  try {
    var n = Caml_format.caml_int_of_string(s);
    if (n >= 0) {
      return n;
    }
    else {
      throw [
            Caml_builtin_exceptions.failure,
            ""
          ];
    }
  }
  catch (exn){
    if (exn[0] === Caml_builtin_exceptions.failure) {
      throw [
            Script.Syntax,
            at,
            "integer constant out of range"
          ];
    }
    else {
      throw exn;
    }
  }
}

function nat32(s, at) {
  try {
    return Curry._1(I32.of_string_u, s);
  }
  catch (exn){
    if (exn[0] === Caml_builtin_exceptions.failure) {
      throw [
            Script.Syntax,
            at,
            "i32 constant out of range"
          ];
    }
    else {
      throw exn;
    }
  }
}

var VarMap = $$Map.Make([$$String.compare]);

function empty_context() {
  return /* record */[
          /* types : record */[
            /* tmap */VarMap[/* empty */0],
            /* tlist : [] */0
          ],
          /* tables : record */[
            /* map */VarMap[/* empty */0],
            /* count */0
          ],
          /* memories : record */[
            /* map */VarMap[/* empty */0],
            /* count */0
          ],
          /* funcs : record */[
            /* map */VarMap[/* empty */0],
            /* count */0
          ],
          /* locals : record */[
            /* map */VarMap[/* empty */0],
            /* count */0
          ],
          /* globals : record */[
            /* map */VarMap[/* empty */0],
            /* count */0
          ],
          /* labels */VarMap[/* empty */0]
        ];
}

function enter_func(c) {
  return /* record */[
          /* types */c[/* types */0],
          /* tables */c[/* tables */1],
          /* memories */c[/* memories */2],
          /* funcs */c[/* funcs */3],
          /* locals : record */[
            /* map */VarMap[/* empty */0],
            /* count */0
          ],
          /* globals */c[/* globals */5],
          /* labels */VarMap[/* empty */0]
        ];
}

function type_(c, x) {
  try {
    return Curry._2(VarMap[/* find */21], x[/* it */1], c[/* types */0][/* tmap */0]);
  }
  catch (exn){
    if (exn === Caml_builtin_exceptions.not_found) {
      throw [
            Script.Syntax,
            x[/* at */0],
            "unknown type " + x[/* it */1]
          ];
    }
    else {
      throw exn;
    }
  }
}

function lookup(category, space, x) {
  try {
    return Curry._2(VarMap[/* find */21], x[/* it */1], space[/* map */0]);
  }
  catch (exn){
    if (exn === Caml_builtin_exceptions.not_found) {
      throw [
            Script.Syntax,
            x[/* at */0],
            "unknown " + (category + (" " + x[/* it */1]))
          ];
    }
    else {
      throw exn;
    }
  }
}

function func(c, x) {
  return lookup("function", c[/* funcs */3], x);
}

function local(c, x) {
  return lookup("local", c[/* locals */4], x);
}

function global(c, x) {
  return lookup("global", c[/* globals */5], x);
}

function table(c, x) {
  return lookup("table", c[/* tables */1], x);
}

function memory(c, x) {
  return lookup("memory", c[/* memories */2], x);
}

function label(c, x) {
  try {
    return Curry._2(VarMap[/* find */21], x[/* it */1], c[/* labels */6]);
  }
  catch (exn){
    if (exn === Caml_builtin_exceptions.not_found) {
      throw [
            Script.Syntax,
            x[/* at */0],
            "unknown label " + x[/* it */1]
          ];
    }
    else {
      throw exn;
    }
  }
}

function anon_type(c, ty) {
  c[/* types */0][/* tlist */1] = Pervasives.$at(c[/* types */0][/* tlist */1], /* :: */[
        ty,
        /* [] */0
      ]);
  return /* () */0;
}

function bind(category, space, x) {
  if (Curry._2(VarMap[/* mem */2], x[/* it */1], space[/* map */0])) {
    throw [
          Script.Syntax,
          x[/* at */0],
          "duplicate " + (category + (" " + x[/* it */1]))
        ];
  }
  space[/* map */0] = Curry._3(VarMap[/* add */3], x[/* it */1], space[/* count */1], space[/* map */0]);
  space[/* count */1] = space[/* count */1] + 1 | 0;
  if (space[/* count */1]) {
    return 0;
  }
  else {
    throw [
          Script.Syntax,
          x[/* at */0],
          "too many " + (category + " bindings")
        ];
  }
}

function bind_func(c, x) {
  return bind("function", c[/* funcs */3], x);
}

function bind_local(c, x) {
  return bind("local", c[/* locals */4], x);
}

function bind_global(c, x) {
  return bind("global", c[/* globals */5], x);
}

function bind_table(c, x) {
  return bind("table", c[/* tables */1], x);
}

function bind_memory(c, x) {
  return bind("memory", c[/* memories */2], x);
}

function anon(category, space, n) {
  space[/* count */1] = space[/* count */1] + n | 0;
  if (Curry._2(I32.lt_u, space[/* count */1], n)) {
    throw [
          Script.Syntax,
          Source.no_region,
          "too many " + (category + " bindings")
        ];
  }
  else {
    return 0;
  }
}

function anon_func(c) {
  return anon("function", c[/* funcs */3], 1);
}

function anon_locals(c, ts) {
  return anon("local", c[/* locals */4], Curry._1(Lib.List32[/* length */0], ts));
}

function anon_global(c) {
  return anon("global", c[/* globals */5], 1);
}

function anon_table(c) {
  return anon("table", c[/* tables */1], 1);
}

function anon_memory(c) {
  return anon("memory", c[/* memories */2], 1);
}

function anon_label(c) {
  var newrecord = c.slice();
  newrecord[/* labels */6] = Curry._2(VarMap[/* map */22], function (param) {
        return 1 + param | 0;
      }, c[/* labels */6]);
  return newrecord;
}

var empty_type = /* FuncType */[
  /* [] */0,
  /* [] */0
];

function explicit_sig(c, var_sem, ty, at) {
  var x = Curry._2(var_sem, c, type_);
  if (x[/* it */1] < Curry._1(Lib.List32[/* length */0], c[/* types */0][/* tlist */1]) && Caml_obj.caml_notequal(ty, empty_type) && Caml_obj.caml_notequal(ty, Curry._2(Lib.List32[/* nth */1], c[/* types */0][/* tlist */1], x[/* it */1]))) {
    throw [
          Script.Syntax,
          at,
          "signature mismatch"
        ];
  }
  return x;
}

function inline_type(c, ty, at) {
  var match = Curry._2(Lib.List[/* index_of */6], ty, c[/* types */0][/* tlist */1]);
  if (match) {
    return Source.$at$at(match[0], at);
  }
  else {
    var i = Curry._1(Lib.List32[/* length */0], c[/* types */0][/* tlist */1]);
    anon_type(c, ty);
    return Source.$at$at(i, at);
  }
}

var yytransl_const = /* array */[
  263,
  264,
  265,
  266,
  267,
  268,
  269,
  270,
  271,
  272,
  273,
  274,
  275,
  276,
  277,
  278,
  279,
  280,
  281,
  282,
  283,
  284,
  285,
  286,
  296,
  297,
  298,
  299,
  300,
  301,
  302,
  303,
  304,
  305,
  306,
  307,
  308,
  309,
  310,
  311,
  312,
  313,
  314,
  315,
  316,
  317,
  318,
  319,
  320,
  321,
  322,
  323,
  324,
  325,
  326,
  327,
  0,
  0
];

var yytransl_block = /* array */[
  257,
  258,
  259,
  260,
  261,
  262,
  287,
  288,
  289,
  290,
  291,
  292,
  293,
  294,
  295,
  328,
  0
];

var yyact = /* array */[
  function () {
    return Pervasives.failwith("parser");
  },
  function () {
    return "";
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return _1 + _2;
  },
  function () {
    return /* [] */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return /* :: */[
            _1,
            _2
          ];
  },
  function () {
    return /* AnyFuncType */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* GlobalType */[
            _1,
            /* Immutable */0
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return /* GlobalType */[
            _3,
            /* Mutable */1
          ];
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 1);
  },
  function () {
    return /* FuncType */[
            /* [] */0,
            /* [] */0
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    var ins = _5[0];
    if (ins !== /* [] */0) {
      var at$1 = at(/* () */0);
      throw [
            Script.Syntax,
            at$1,
            "result before parameter"
          ];
    }
    return /* FuncType */[
            ins,
            Pervasives.$at(_3, _5[1])
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    return /* FuncType */[
            Pervasives.$at(_3, _5[0]),
            _5[1]
          ];
  },
  function (__caml_parser_env) {
    Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _6 = Parsing.peek_val(__caml_parser_env, 0);
    return /* FuncType */[
            /* :: */[
              _4,
              _6[0]
            ],
            _6[1]
          ];
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return /* TableType */[
            _1,
            _2
          ];
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* MemoryType */[_1];
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* record */[
            /* min */nat32(_1, ati(1)),
            /* max : None */0
          ];
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return /* record */[
            /* min */nat32(_1, ati(1)),
            /* max : Some */[nat32(_2, ati(2))]
          ];
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 1);
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(_1, at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(_1, at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(_1, at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var at$1 = at(/* () */0);
    return function (_, _$1) {
      return Source.$at$at(nat32(_1, at$1), at$1);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var at$1 = at(/* () */0);
    return function (c, lookup) {
      return Source.$at$at(Curry._2(lookup, c, Source.$at$at(_1, at$1)), at$1);
    };
  },
  function () {
    return function (_, _$1) {
      return /* [] */0;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c, lookup) {
      return /* :: */[
              Curry._2(_1, c, lookup),
              Curry._2(_2, c, lookup)
            ];
    };
  },
  function () {
    return function (c, anon, _) {
      return Curry._1(anon, c);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c, _, bind) {
      return Curry._2(bind, c, _1);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(_1, at(/* () */0));
  },
  function () {
    return function (c, xs) {
      List.iter(function (x) {
            throw [
                  Script.Syntax,
                  x[/* at */0],
                  "mismatching label"
                ];
          }, xs);
      return anon_label(c);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c, xs) {
      List.iter(function (x) {
            if (x[/* it */1] !== _1[/* it */1]) {
              throw [
                    Script.Syntax,
                    x[/* at */0],
                    "mismatching label"
                  ];
            }
            else {
              return 0;
            }
          }, xs);
      var c$1 = c;
      var x = _1;
      var newrecord = c$1.slice();
      newrecord[/* labels */6] = Curry._3(VarMap[/* add */3], x[/* it */1], 0, Curry._2(VarMap[/* map */22], function (param) {
                return 1 + param | 0;
              }, c$1[/* labels */6]));
      return newrecord;
    };
  },
  function () {
    return /* [] */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* :: */[
            _1,
            /* [] */0
          ];
  },
  function () {
    return 0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return nat32(_1, at(/* () */0));
  },
  function () {
    return /* None */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var n = nat(_1, at(/* () */0));
    if (!Curry._1(Lib.Int[/* is_power_of_two */1], n)) {
      var at$1 = at(/* () */0);
      throw [
            Script.Syntax,
            at$1,
            "alignment must be a power of two"
          ];
    }
    return /* Some */[Curry._1(Lib.Int[/* log2 */0], n)];
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var at$1 = at(/* () */0);
    return function (c) {
      return /* :: */[
              Source.$at$at(Curry._1(_1, c), at$1),
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var at$1 = at(/* () */0);
    return function (c) {
      return /* :: */[
              Source.$at$at(Curry._1(_1, c), at$1),
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 0);
  },
  function () {
    return function () {
      return Operators.unreachable;
    };
  },
  function () {
    return function () {
      return Operators.nop;
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.br(Curry._2(_2, c, label));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.br_if(Curry._2(_2, c, label));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var _3 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var match = Curry._1(Lib.List[/* split_last */5], /* :: */[
            Curry._2(_2, c, label),
            Curry._2(_3, c, label)
          ]);
      return Operators.br_table(match[0], match[1]);
    };
  },
  function () {
    return function () {
      return Operators.$$return;
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.call(Curry._2(_2, c, func));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.call_indirect(Curry._2(_2, c, type_));
    };
  },
  function () {
    return function () {
      return Operators.drop;
    };
  },
  function () {
    return function () {
      return Operators.select;
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.get_local(Curry._2(_2, c, local));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.set_local(Curry._2(_2, c, local));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.tee_local(Curry._2(_2, c, local));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.get_global(Curry._2(_2, c, global));
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Operators.set_global(Curry._2(_2, c, global));
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 2);
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var _3 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return Curry._2(_1, _3, _2);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 2);
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var _3 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return Curry._2(_1, _3, _2);
    };
  },
  function () {
    return function () {
      return Operators.current_memory;
    };
  },
  function () {
    return function () {
      return Operators.grow_memory;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return literal(_1, _2)[0];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return _1;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return _1;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return _1;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return _1;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return function () {
      return _1;
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 3);
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, _5);
      var match = Curry._1(_3, c$prime);
      return Operators.block(match[0], match[1]);
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 3);
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, _5);
      var match = Curry._1(_3, c$prime);
      return Operators.loop(match[0], match[1]);
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 3);
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, _5);
      var match = Curry._1(_3, c$prime);
      return Operators.if_(match[0], match[1], /* [] */0);
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 6);
    var _3 = Parsing.peek_val(__caml_parser_env, 5);
    var _5 = Parsing.peek_val(__caml_parser_env, 3);
    var _6 = Parsing.peek_val(__caml_parser_env, 2);
    var _8 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, Pervasives.$at(_5, _8));
      var match = Curry._1(_3, c$prime);
      return Operators.if_(match[0], match[1], Curry._1(_6, c$prime));
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return /* tuple */[
              _1,
              Curry._1(_2, c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      var match = Curry._1(_2, c);
      return Pervasives.$at(match[0], /* :: */[
                  Source.$at$at(match[1], at$1),
                  /* [] */0
                ]);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return /* tuple */[
              Curry._1(_2, c)[1],
              Curry._1(_1, c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var _3 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, /* [] */0);
      var match = Curry._1(_3, c$prime);
      return /* tuple */[
              /* [] */0,
              Operators.block(match[0], match[1])
            ];
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var _3 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, /* [] */0);
      var match = Curry._1(_3, c$prime);
      return /* tuple */[
              /* [] */0,
              Operators.loop(match[0], match[1])
            ];
    };
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 2);
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    var _4 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var c$prime = Curry._2(_2, c, /* [] */0);
      var match = Curry._2(_4, c, c$prime);
      return /* tuple */[
              match[0],
              Operators.if_(_3, match[1], match[2])
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 5);
    var _7 = Parsing.peek_val(__caml_parser_env, 1);
    return function (_, c$prime) {
      return /* tuple */[
              /* [] */0,
              Curry._1(_3, c$prime),
              Curry._1(_7, c$prime)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (_, c$prime) {
      return /* tuple */[
              /* [] */0,
              Curry._1(_3, c$prime),
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 8);
    var _4 = Parsing.peek_val(__caml_parser_env, 5);
    var _8 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c, c$prime) {
      return /* tuple */[
              Curry._1(_1, c),
              Curry._1(_4, c$prime),
              Curry._1(_8, c$prime)
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 4);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c, c$prime) {
      return /* tuple */[
              Curry._1(_1, c),
              Curry._1(_4, c$prime),
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 2);
    var _2 = Parsing.peek_val(__caml_parser_env, 1);
    var _3 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c, c$prime) {
      return /* tuple */[
              Curry._1(_1, c),
              Curry._1(_2, c$prime),
              Curry._1(_3, c$prime)
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c, c$prime) {
      return /* tuple */[
              Curry._1(_1, c),
              Curry._1(_2, c$prime),
              /* [] */0
            ];
    };
  },
  function () {
    return function () {
      return /* [] */0;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      return Pervasives.$at(Curry._1(_1, c), Curry._1(_2, c));
    };
  },
  function () {
    return function () {
      return /* tuple */[
              0,
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var es1 = Curry._1(_1, c);
      var match = Curry._1(_2, c);
      return /* tuple */[
              match[0] + 1 | 0,
              Pervasives.$at(es1, match[1])
            ];
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var at$1 = at(/* () */0);
    return function (c) {
      return Source.$at$at(Curry._1(_1, c), at$1);
    };
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 0);
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    var match = _5[0];
    return /* tuple */[
            /* FuncType */[
              match[0],
              Pervasives.$at(_3, match[1])
            ],
            function (c) {
              return Curry._1(_5[1], c);
            }
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    var match = _5[0];
    return /* tuple */[
            /* FuncType */[
              Pervasives.$at(_3, match[0]),
              match[1]
            ],
            function (c) {
              anon_locals(c, _3);
              return Curry._1(_5[1], c);
            }
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _6 = Parsing.peek_val(__caml_parser_env, 0);
    var match = _6[0];
    return /* tuple */[
            /* FuncType */[
              /* :: */[
                _4,
                match[0]
              ],
              match[1]
            ],
            function (c) {
              bind_local(c, _3);
              return Curry._1(_6[1], c);
            }
          ];
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* tuple */[
            empty_type,
            function (c) {
              var c$prime = anon_label(c);
              return /* record */[
                      /* ftype */Source.$at$at(-1, at(/* () */0)),
                      /* locals : [] */0,
                      /* body */Curry._1(_1, c$prime)
                    ];
            }
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 0);
    return /* tuple */[
            _5[0],
            function (c) {
              anon_locals(c, _3);
              var f = Curry._1(_5[1], c);
              return /* record */[
                      /* ftype */f[/* ftype */0],
                      /* locals */Pervasives.$at(_3, f[/* locals */1]),
                      /* body */f[/* body */2]
                    ];
            }
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _6 = Parsing.peek_val(__caml_parser_env, 0);
    return /* tuple */[
            _6[0],
            function (c) {
              bind_local(c, _3);
              var f = Curry._1(_6[1], c);
              return /* record */[
                      /* ftype */f[/* ftype */0],
                      /* locals : :: */[
                        _4,
                        f[/* locals */1]
                      ],
                      /* body */f[/* body */2]
                    ];
            }
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 4);
    var _4 = Parsing.peek_val(__caml_parser_env, 3);
    var _5 = Parsing.peek_val(__caml_parser_env, 2);
    var _6 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      var t = explicit_sig(c, _5, _6[0], at$1);
      return /* tuple */[
              function () {
                var init = Curry._1(_6[1], enter_func(c));
                return Source.$at$at(/* record */[
                            /* ftype */t,
                            /* locals */init[/* locals */1],
                            /* body */init[/* body */2]
                          ], at$1);
              },
              Curry._3(_4, /* FuncExport */0, c[/* funcs */3][/* count */1], c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      var t = explicit_sig(c, _4, _5[0], at$1);
      return /* tuple */[
              function () {
                var init = Curry._1(_5[1], enter_func(c));
                return Source.$at$at(/* record */[
                            /* ftype */t,
                            /* locals */init[/* locals */1],
                            /* body */init[/* body */2]
                          ], at$1);
              },
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      var t = inline_type(c, _5[0], at$1);
      return /* tuple */[
              function () {
                var init = Curry._1(_5[1], enter_func(c));
                return Source.$at$at(/* record */[
                            /* ftype */t,
                            /* locals */init[/* locals */1],
                            /* body */init[/* body */2]
                          ], at$1);
              },
              Curry._3(_4, /* FuncExport */0, c[/* funcs */3][/* count */1], c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      var t = inline_type(c, _4[0], at$1);
      return /* tuple */[
              function () {
                var init = Curry._1(_4[1], enter_func(c));
                return Source.$at$at(/* record */[
                            /* ftype */t,
                            /* locals */init[/* locals */1],
                            /* body */init[/* body */2]
                          ], at$1);
              },
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 1);
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    var at$1 = at(/* () */0);
    return function (c) {
      return Source.$at$at(Curry._1(_1, c), at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      return Source.$at$at(/* record */[
                  /* index */Curry._2(_3, c, table),
                  /* offset */Curry._1(_4, c),
                  /* init */Curry._2(_5, c, func)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      return Source.$at$at(/* record */[
                  /* index */Source.$at$at(0, at$1),
                  /* offset */Curry._1(_3, c),
                  /* init */Curry._2(_4, c, func)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_table, bind_table);
      return function () {
        return /* tuple */[
                Source.$at$at(/* record */[/* ttype */_5], at$1),
                /* [] */0,
                Curry._3(_4, /* TableExport */1, c[/* tables */1][/* count */1], c)
              ];
      };
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 7);
    var _4 = Parsing.peek_val(__caml_parser_env, 6);
    var _5 = Parsing.peek_val(__caml_parser_env, 5);
    var _8 = Parsing.peek_val(__caml_parser_env, 2);
    var at$1 = at(/* () */0);
    return function (c) {
      var i = c[/* tables */1][/* count */1];
      Curry._3(_3, c, anon_table, bind_table);
      return function () {
        var init = Curry._2(_8, c, func);
        var size = List.length(init);
        return /* tuple */[
                Source.$at$at(/* record */[/* ttype : TableType */[
                        /* record */[
                          /* min */size,
                          /* max : Some */[size]
                        ],
                        _5
                      ]], at$1),
                /* :: */[
                  Source.$at$at(/* record */[
                        /* index */Source.$at$at(i, at$1),
                        /* offset */Source.$at$at(/* :: */[
                              Source.$at$at(Operators.i32_const(Source.$at$at(0, at$1)), at$1),
                              /* [] */0
                            ], at$1),
                        /* init */init
                      ], at$1),
                  /* [] */0
                ],
                Curry._3(_4, /* TableExport */1, c[/* tables */1][/* count */1], c)
              ];
      };
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      return Source.$at$at(/* record */[
                  /* index */Curry._2(_3, c, memory),
                  /* offset */Curry._1(_4, c),
                  /* init */_5
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      return Source.$at$at(/* record */[
                  /* index */Source.$at$at(0, at$1),
                  /* offset */Curry._1(_3, c),
                  /* init */_4
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_memory, bind_memory);
      return /* tuple */[
              Source.$at$at(/* record */[/* mtype */_5], at$1),
              /* [] */0,
              Curry._3(_4, /* MemoryExport */2, c[/* memories */2][/* count */1], c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 6);
    var _4 = Parsing.peek_val(__caml_parser_env, 5);
    var _7 = Parsing.peek_val(__caml_parser_env, 2);
    var at$1 = at(/* () */0);
    return function (c) {
      var i = c[/* memories */2][/* count */1];
      Curry._3(_3, c, anon_memory, bind_memory);
      var size = (_7.length + 65535 | 0) / 65536 | 0;
      return /* tuple */[
              Source.$at$at(/* record */[/* mtype : MemoryType */[/* record */[
                        /* min */size,
                        /* max : Some */[size]
                      ]]], at$1),
              /* :: */[
                Source.$at$at(/* record */[
                      /* index */Source.$at$at(i, at$1),
                      /* offset */Source.$at$at(/* :: */[
                            Source.$at$at(Operators.i32_const(Source.$at$at(0, at$1)), at$1),
                            /* [] */0
                          ], at$1),
                      /* init */_7
                    ], at$1),
                /* [] */0
              ],
              Curry._3(_4, /* MemoryExport */2, c[/* memories */2][/* count */1], c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 5);
    var _6 = Parsing.peek_val(__caml_parser_env, 2);
    var at$1 = at(/* () */0);
    return function (c) {
      var i = c[/* memories */2][/* count */1];
      Curry._3(_3, c, anon_memory, bind_memory);
      var size = (_6.length + 65535 | 0) / 65536 | 0;
      return /* tuple */[
              Source.$at$at(/* record */[/* mtype : MemoryType */[/* record */[
                        /* min */size,
                        /* max : Some */[size]
                      ]]], at$1),
              /* :: */[
                Source.$at$at(/* record */[
                      /* index */Source.$at$at(i, at$1),
                      /* offset */Source.$at$at(/* :: */[
                            Source.$at$at(Operators.i32_const(Source.$at$at(0, at$1)), at$1),
                            /* [] */0
                          ], at$1),
                      /* init */_6
                    ], at$1),
                /* [] */0
              ],
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 4);
    var _4 = Parsing.peek_val(__caml_parser_env, 3);
    var _5 = Parsing.peek_val(__caml_parser_env, 2);
    var _6 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_global, bind_global);
      return /* tuple */[
              function () {
                return Source.$at$at(/* record */[
                            /* gtype */_5,
                            /* value */Curry._1(_6, c)
                          ], at$1);
              },
              Curry._3(_4, /* GlobalExport */3, c[/* globals */5][/* count */1], c)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_global, bind_global);
      return /* tuple */[
              function () {
                return Source.$at$at(/* record */[
                            /* gtype */_4,
                            /* value */Curry._1(_5, c)
                          ], at$1);
              },
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      return /* FuncImport */Block.__(0, [Curry._2(_4, c, type_)]);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    var at4 = ati(4);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      return /* FuncImport */Block.__(0, [inline_type(c, _4, at4)]);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      Curry._3(_3, c, anon_table, bind_table);
      return /* TableImport */Block.__(1, [_4]);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      Curry._3(_3, c, anon_memory, bind_memory);
      return /* MemoryImport */Block.__(2, [_4]);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      Curry._3(_3, c, anon_global, bind_global);
      return /* GlobalImport */Block.__(3, [_4]);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    var at5 = ati(5);
    return function (c) {
      return Source.$at$at(/* record */[
                  /* module_name */_3,
                  /* item_name */_4,
                  /* ikind */Source.$at$at(Curry._1(_5, c), at5)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      return Source.$at$at(/* record */[
                  /* module_name */_4[0],
                  /* item_name */_4[1],
                  /* ikind */Source.$at$at(/* FuncImport */Block.__(0, [Curry._2(_5, c, type_)]), at$1)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    var at5 = ati(5);
    return function (c) {
      Curry._3(_3, c, anon_func, bind_func);
      return Source.$at$at(/* record */[
                  /* module_name */_4[0],
                  /* item_name */_4[1],
                  /* ikind */Source.$at$at(/* FuncImport */Block.__(0, [inline_type(c, _5, at5)]), at$1)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_table, bind_table);
      return Source.$at$at(/* record */[
                  /* module_name */_4[0],
                  /* item_name */_4[1],
                  /* ikind */Source.$at$at(/* TableImport */Block.__(1, [_5]), at$1)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_memory, bind_memory);
      return Source.$at$at(/* record */[
                  /* module_name */_4[0],
                  /* item_name */_4[1],
                  /* ikind */Source.$at$at(/* MemoryImport */Block.__(2, [_5]), at$1)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (c) {
      Curry._3(_3, c, anon_global, bind_global);
      return Source.$at$at(/* record */[
                  /* module_name */_4[0],
                  /* item_name */_4[1],
                  /* ikind */Source.$at$at(/* GlobalImport */Block.__(3, [_5]), at$1)
                ], at$1);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return /* tuple */[
            _3,
            _4
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      return /* tuple */[
              /* FuncExport */0,
              Curry._2(_3, c, func)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      return /* tuple */[
              /* TableExport */1,
              Curry._2(_3, c, table)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      return /* tuple */[
              /* MemoryExport */2,
              Curry._2(_3, c, memory)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      return /* tuple */[
              /* GlobalExport */3,
              Curry._2(_3, c, global)
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    var at4 = ati(4);
    return function (c) {
      var match = Curry._1(_4, c);
      return Source.$at$at(/* record */[
                  /* name */_3,
                  /* ekind */Source.$at$at(match[0], at4),
                  /* item */match[1]
                ], at$1);
    };
  },
  function () {
    return function (_, _$1, _$2) {
      return /* [] */0;
    };
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 0);
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    var at$1 = at(/* () */0);
    return function (k, count, _) {
      return /* :: */[
              Source.$at$at(/* record */[
                    /* name */_3,
                    /* ekind */Source.$at$at(k, at$1),
                    /* item */Source.$at$at(count - 1 | 0, at$1)
                  ], at$1),
              /* [] */0
            ];
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      return anon_type(c, _3);
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      var c$1 = c;
      var x = _3;
      var ty = _4;
      if (Curry._2(VarMap[/* mem */2], x[/* it */1], c$1[/* types */0][/* tmap */0])) {
        throw [
              Script.Syntax,
              x[/* at */0],
              "duplicate type " + x[/* it */1]
            ];
      }
      c$1[/* types */0][/* tmap */0] = Curry._3(VarMap[/* add */3], x[/* it */1], Curry._1(Lib.List32[/* length */0], c$1[/* types */0][/* tlist */1]), c$1[/* types */0][/* tmap */0]);
      c$1[/* types */0][/* tlist */1] = Pervasives.$at(c$1[/* types */0][/* tlist */1], /* :: */[
            ty,
            /* [] */0
          ]);
      return /* () */0;
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return function (c) {
      return Curry._2(_3, c, func);
    };
  },
  function () {
    return function (c) {
      var newrecord = Ast.empty_module.slice();
      newrecord[/* types */0] = c[/* types */0][/* tlist */1];
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      Curry._1(_1, c);
      return Curry._1(_2, c);
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var match = Curry._1(_1, c);
      var m = Curry._1(_2, c);
      if (m[/* imports */8] !== /* [] */0) {
        var at = List.hd(m[/* imports */8])[/* at */0];
        throw [
              Script.Syntax,
              at,
              "import after global definition"
            ];
      }
      var newrecord = m.slice();
      newrecord[/* globals */1] = /* :: */[
        Curry._1(match[0], /* () */0),
        m[/* globals */1]
      ];
      newrecord[/* exports */9] = Pervasives.$at(match[1], m[/* exports */9]);
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var t = Curry._1(_1, c);
      var m = Curry._1(_2, c);
      var match = Curry._1(t, /* () */0);
      if (m[/* imports */8] !== /* [] */0) {
        var at = List.hd(m[/* imports */8])[/* at */0];
        throw [
              Script.Syntax,
              at,
              "import after table definition"
            ];
      }
      var newrecord = m.slice();
      newrecord[/* tables */2] = /* :: */[
        match[0],
        m[/* tables */2]
      ];
      newrecord[/* elems */6] = Pervasives.$at(match[1], m[/* elems */6]);
      newrecord[/* exports */9] = Pervasives.$at(match[2], m[/* exports */9]);
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var match = Curry._1(_1, c);
      var m = Curry._1(_2, c);
      if (m[/* imports */8] !== /* [] */0) {
        var at = List.hd(m[/* imports */8])[/* at */0];
        throw [
              Script.Syntax,
              at,
              "import after memory definition"
            ];
      }
      var newrecord = m.slice();
      newrecord[/* memories */3] = /* :: */[
        match[0],
        m[/* memories */3]
      ];
      newrecord[/* data */7] = Pervasives.$at(match[1], m[/* data */7]);
      newrecord[/* exports */9] = Pervasives.$at(match[2], m[/* exports */9]);
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var match = Curry._1(_1, c);
      var m = Curry._1(_2, c);
      var func = Curry._1(match[0], /* () */0);
      if (m[/* imports */8] !== /* [] */0) {
        var at = List.hd(m[/* imports */8])[/* at */0];
        throw [
              Script.Syntax,
              at,
              "import after function definition"
            ];
      }
      var newrecord = m.slice();
      newrecord[/* funcs */4] = /* :: */[
        func,
        m[/* funcs */4]
      ];
      newrecord[/* exports */9] = Pervasives.$at(match[1], m[/* exports */9]);
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var m = Curry._1(_2, c);
      var newrecord = m.slice();
      newrecord[/* elems */6] = /* :: */[
        Curry._1(_1, c),
        m[/* elems */6]
      ];
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var m = Curry._1(_2, c);
      var newrecord = m.slice();
      newrecord[/* data */7] = /* :: */[
        Curry._1(_1, c),
        m[/* data */7]
      ];
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var m = Curry._1(_2, c);
      var x = Curry._1(_1, c);
      var match = m[/* start */5];
      if (match) {
        throw [
              Script.Syntax,
              x[/* at */0],
              "multiple start sections"
            ];
      }
      else {
        var newrecord = m.slice();
        newrecord[/* start */5] = /* Some */[x];
        return newrecord;
      }
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var i = Curry._1(_1, c);
      var m = Curry._1(_2, c);
      var newrecord = m.slice();
      newrecord[/* imports */8] = /* :: */[
        i,
        m[/* imports */8]
      ];
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return function (c) {
      var m = Curry._1(_2, c);
      var newrecord = m.slice();
      newrecord[/* exports */9] = /* :: */[
        Curry._1(_1, c),
        m[/* exports */9]
      ];
      return newrecord;
    };
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return /* tuple */[
            _3,
            Source.$at$at(/* Textual */Block.__(0, [Source.$at$at(Curry._1(_4, empty_context(/* () */0)), at(/* () */0))]), at(/* () */0))
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    return /* tuple */[
            _3,
            Source.$at$at(/* Encoded */Block.__(1, [
                    "binary",
                    _4 + _5
                  ]), at(/* () */0))
          ];
  },
  function () {
    return /* None */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* Some */[Source.$at$at(_1, at(/* () */0))];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 3);
    var _4 = Parsing.peek_val(__caml_parser_env, 2);
    var _5 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Invoke */Block.__(0, [
                  _3,
                  _4,
                  _5
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Get */Block.__(1, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertMalformed */Block.__(0, [
                  _3[1],
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertInvalid */Block.__(1, [
                  _3[1],
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertSoftInvalid */Block.__(2, [
                  _3[1],
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertUnlinkable */Block.__(3, [
                  _3[1],
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertUninstantiable */Block.__(4, [
                  _3[1],
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertReturn */Block.__(5, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertReturnNaN */Block.__(6, [_3]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertTrap */Block.__(7, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* AssertExhaustion */Block.__(8, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(/* Action */Block.__(2, [_1]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(/* Assertion */Block.__(3, [_1]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(/* Module */Block.__(0, [
                  _1[0],
                  _1[1]
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Register */Block.__(1, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return Source.$at$at(/* Meta */Block.__(4, [_1]), at(/* () */0));
  },
  function () {
    return /* [] */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return /* :: */[
            _1,
            _2
          ];
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Script */Block.__(2, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Input */Block.__(0, [
                  _3,
                  _4
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 2);
    var _4 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Output */Block.__(1, [
                  _3,
                  /* Some */[_4]
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(/* Output */Block.__(1, [
                  _3,
                  /* None */0
                ]), at(/* () */0));
  },
  function (__caml_parser_env) {
    var _2 = Parsing.peek_val(__caml_parser_env, 2);
    var _3 = Parsing.peek_val(__caml_parser_env, 1);
    return Source.$at$at(literal(_2, _3)[1], ati(3));
  },
  function () {
    return /* [] */0;
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 1);
    var _2 = Parsing.peek_val(__caml_parser_env, 0);
    return /* :: */[
            _1,
            _2
          ];
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 1);
  },
  function (__caml_parser_env) {
    var _1 = Parsing.peek_val(__caml_parser_env, 0);
    return /* :: */[
            _1,
            /* [] */0
          ];
  },
  function (__caml_parser_env) {
    return Parsing.peek_val(__caml_parser_env, 1)[1];
  },
  function (__caml_parser_env) {
    throw [
          Parsing.YYexit,
          Parsing.peek_val(__caml_parser_env, 0)
        ];
  },
  function (__caml_parser_env) {
    throw [
          Parsing.YYexit,
          Parsing.peek_val(__caml_parser_env, 0)
        ];
  },
  function (__caml_parser_env) {
    throw [
          Parsing.YYexit,
          Parsing.peek_val(__caml_parser_env, 0)
        ];
  }
];

var yytables = /* record */[
  /* actions */yyact,
  /* transl_const */yytransl_const,
  /* transl_block */yytransl_block,
  /* lhs */'\xff\xff\x04\0\x04\0\x05\0\x05\0\x06\0\x07\0\x07\0\b\0\t\0\t\0\t\0\t\0\x0b\0\r\0\f\0\f\0\x0e\0\x10\0\x10\0\x10\0\x0f\0\x0f\0\x11\0\x11\0\x12\0\x12\0\n\0\x13\0\x13\0\x14\0\x14\0\x15\0\x15\0\x16\0\x16\0\x17\0\x17\0\x17\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x18\0\x19\0\x19\0\x19\0\x19\0\x1b\0\x1a\0\x1d\0\x1d\0\x1d\0\x1d\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1f\0\x1c\0\x1c\0\x1e\0\x1e\0 \0!\0!\0!\0!\0"\0"\0"\0#\0#\0#\0#\0%\0%\0&\0&\0\'\0\'\0)\0)\0*\0*\0*\0+\0+\0,\0,\0,\0,\0,\0-\0-\0-\0-\0-\0-\0.\0/\0/\0/\0/\x000\0(\0(\0$\x001\x001\x002\x003\x003\x003\x003\x003\x003\x003\x003\x003\x003\x003\x004\x004\x005\x005\x006\x006\x008\x008\x008\x008\x008\x008\x008\x008\x008\x009\x009\x009\x009\x009\0;\0;\0:\0:\0:\0:\0<\x007\x007\0\x01\0\x02\0\x03\0\0\0\0\0\0\0',
  /* len */"\x02\0\0\0\x02\0\0\0\x02\0\x01\0\x01\0\x04\0\x04\0\0\0\x05\0\x05\0\x06\0\x02\0\x01\0\x01\0\x02\0\x04\0\x01\0\x01\0\x01\0\x01\0\x01\0\0\0\x02\0\0\0\x01\0\x01\0\0\0\x01\0\0\0\x01\0\0\0\x01\0\0\0\x01\0\x01\0\x01\0\x01\0\x01\0\x01\0\x02\0\x02\0\x03\0\x01\0\x02\0\x02\0\x01\0\x01\0\x02\0\x02\0\x02\0\x02\0\x02\0\x03\0\x03\0\x01\0\x01\0\x02\0\x01\0\x01\0\x01\0\x01\0\x01\0\x05\0\x05\0\x05\0\b\0\x02\0\x03\0\x02\0\x03\0\x03\0\x04\0\b\0\x04\0\t\0\x05\0\x03\0\x02\0\0\0\x02\0\0\0\x02\0\x01\0\x01\0\x05\0\x05\0\x06\0\x01\0\x05\0\x06\0\x07\0\x06\0\x06\0\x05\0\x04\0\x01\0\x06\0\x05\0\x06\0\n\0\x06\0\x05\0\x06\0\t\0\b\0\x07\0\x06\0\x05\0\x05\0\x05\0\x05\0\x05\0\x06\0\x06\0\x06\0\x06\0\x06\0\x06\0\x05\0\x04\0\x04\0\x04\0\x04\0\x05\0\0\0\x01\0\x04\0\x04\0\x05\0\x04\0\0\0\x02\0\x02\0\x02\0\x02\0\x02\0\x02\0\x02\0\x02\0\x02\0\x02\0\x05\0\x06\0\0\0\x01\0\x06\0\x05\0\x05\0\x05\0\x05\0\x05\0\x05\0\x05\0\x04\0\x05\0\x05\0\x01\0\x01\0\x01\0\x05\0\x01\0\0\0\x02\0\x05\0\x05\0\x05\0\x04\0\x04\0\0\0\x02\0\x02\0\x01\0\x02\0\x02\0\x02\0\x02\0",
  /* defred */"\0\0\0\0\0\0\0\0\0\0\0\0\xaf\0\xa0\0\x9e\0\x9f\0\0\0\xa2\0\0\0\xb0\0\xad\0\0\0\xb1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa4\0\xac\0\xae\0\x92\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9b\0\0\0\0\0\0\0\0\0\0\0\xa8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x89\0\x8a\0\x87\0\x8b\0\x88\0\x86\0\x8d\0\x8e\0\x85\0\x8c\0\x8f\0\xa5\0\xa1\0\0\0\x94\0\x95\0\x96\0\x97\0\x98\0\0\0\x9a\0\xab\0\x99\0\x9c\0\x9d\0\xa6\0\xa7\0\x02\0\x90\0\x1b\0\x1a\0\0\0\x15\0\x16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0a\0\0\0\0\0\0\0\x01\0\0\0\0\0\x93\0\x12\0\x13\0\x14\0\0\0\0\0(\0/\0\0\0\0\x000\0\0\0\0\0\0\0\0\0\0\0\0\0,\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0=\0>\0<\0?\0'\x008\x009\0;\0\0\0\0\0$\0%\0&\0Y\0\0\0U\0\0\0\0\0\x83\0\0\0\x81\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\x7f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\xa9\0\0\0\0\0\0\0\0\0\0\0\0\0\x1d\0\0\0\0\0\0\0)\0*\0\0\0-\0.\x001\x002\x003\x004\x005\0!\0\0\0\0\0:\0\0\0\0\0\0\0Q\0_\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x82\0\0\0T\0\0\0\0\0\0\0\0\0\0\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0F\0E\0\0\0\x18\0c\0\x01\0\0\0\x0e\0\0\0\0\0\0\0g\0\0\0\0\0\0\0\0\0\0\0\0\0}\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0+\0#\x006\x007\0]\0\0\0^\0\0\0\0\0t\0s\0\b\0\0\0l\0\0\0w\0\x10\0\0\0d\0\r\0u\0G\0\0\0H\0`\0S\0b\0\0\0\x01\0h\0v\0f\0\0\0\0\0\0\0\0\0r\0\0\0\0\0\0\0\0\0\x11\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\0D\0\0\0\0\0\0\0\0\0\\\0\0\0\0\0\0\0\x07\0k\0\0\0\0\0\0\0I\0\0\0\0\0\0\0\0\0\0\0\0\0y\0|\0z\0{\0W\0\0\0\0\0V\0Z\0\0\0x\0\x1f\0@\0B\0\0\0A\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0j\0\0\0\0\0\0\0\0\0\0\0\0\0X\0[\0\0\0\x0b\0\0\0\n\0\0\0\0\0\0\0N\0i\0n\0m\0q\0o\0p\0\0\0\f\0e\0\0\0\0\0C\0\0\0\0\0\0\0\0\0\0\0\0\0J\0\0\0L\0",
  /* dgoto */'\x04\0\x06\0\r\0\x10\0V\x001\x01\f\x01\xc4\0\x85\0\xff\0\x7f\0\r\x01\x0e\x01\x1d\x01\xb4\0\xd2\0\x96\0\xd3\0\x80\0\xe5\0\x88\x01\xf3\x007\x01\xb5\0\xb6\0\xb7\0\xb8\x002\x01\xb9\0\xd0\0\x15\x01u\x01\x06\x01\xba\0\xbb\x009\0\xbc\0\x8c\0:\0;\0\xc9\0<\0=\0>\0"\x01?\0\xbd\0\xdc\0@\0A\0B\0C\0\x07\0%\0\b\0M\0\t\0\n\0\x0b\0\f\0N\0',
  /* sindex */'\xd4\0\x17\xff\x17\xff.\xff\0\0a\xff\0\0\0\0\0\0\0\0\x17\xff\0\0@\0\0\0\0\0"\xff\0\0l\0i\xffi\xffw\xffi\xffi\xff.\xff.\xff.\xff.\xffp\xffp\xff~\xffp\xffi\xffi\xff\0\0\0\0\0\0\0\0\xab\xff\x17\xffi\xff\x92\xff\xac\xff\xc9\xff\xd9\xff\xf6\xff\xf9\xff\f\xff\xa1\xff\xaf\xff\xfc\xfe\xfb\xff\xfe\xff\x15\0\x1c\x001\xff\0\0\x17\0\x1d\0\x1d\0\x1d\0\x1d\0\x1d\0\x1d\0\x1d\0\x1d\0\x1d\0\x1d\0\xb1\xff\xb6\xff\x11\0\xa1\xff-\x007\0=\0?\0D\0/\0J\0\xa1\xff\0\0K\0S\0d\0e\0n\0\0\0[\xffR\0\xb7\xff\xc6\xffR\0R\0\x8f\xffR\0\x8f\xffv\0w\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0y\0\0\0\0\0\0\0\0\0\0\0\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x16\x02\0\0\0\0z\0V\0\x8a\0\x95\0\xe9\xff\x97\0W\x03\x98\0\0\0\xb7\xff\x99\0\x98\0\0\0\x9b\0\xa1\0\0\0\0\0\0\0\0\0\xbb\0\xd4\x02\0\0\0\0R\0R\0\0\0R\0\xb7\xff\xb7\xff\xb7\xff\xb7\xff\xb7\xff\0\0\xb7\xff\xb7\xff\xb7\xff\xb7\xff\xb7\xff\xa5\0\xa5\0\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\x02b\x02\0\0\0\0\0\0\0\0\xbd\0\0\0\x88\x02\xbf\0\0\0\xc7\0\0\0\xd7\0\0\0\r\xffb\x02\xed\xff\xed\xff\xcd\xff\0\0u\xff\xea\0R\0R\0R\0b\x02\xe3\0\xe4\0\xb7\xff\xb7\xff\xec\0\x98\xff\xfe\0\xea\0\xea\0\0\0\x7f\xff\b\x01\xfe\xfe\t\x01\0\0\xb7\xff\x12\0\xe7\0\x12\0\x0e\x01\x10\x01\0\0\xe7\0\xe7\0\xe7\0\0\0\0\0\xb7\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xfa\0\xfa\0\0\x001\x03#\x01\xef\x03\0\0\0\0\x0b\x03<\x02-\x01\xe7\xff.\x01/\x01\x99\xff0\x01\0\0<\x01\0\0I\x01U\x01b\x02T\x01^\x01\0\0W\x01o\x01[\x01y\x01\xe7\0\xe7\0\xe7\0z\x01\xe3\0\0\0\0\0{\x01\0\0\0\0\0\0P\x01\0\0\x82\x01\x84\x01\xa9\xff\0\0d\xff\x85\x01\xb7\xff\xb7\xff\xb7\xff\xb7\xff\0\0\x95\x01\xe7\0\x9f\x01b\x01\xa0\x01\xa1\x01\xa6\x01\xaa\x01\xab\x01b\x02\xb7\x01\xe6\xff\xc1\x01\0\0\0\0\0\0\0\0\0\0\xc6\x01\0\0\x12\0\xe7\0\0\0\0\0\0\0\xc7\x01\0\0\xc8\x01\0\0\0\0\x80\x01\0\0\0\0\0\0\0\0\xcf\x01\0\0\0\0\0\0\0\0\xad\xff\0\0\0\0\0\0\0\0R\0R\0R\0R\0\0\0\xd0\x01\xd1\x01\xe1\x01\xeb\x01\0\0\0\0<\x02\xec\x01\xae\x02\xae\x02\xed\x01\xee\x01\0\0\0\0R\0R\0R\0R\0\0\0\xf6\x01\xf4\x01\xf7\x01\0\0\0\0\xb7\xff}\x03\b\x02\0\0\x11\x02\xbb\xff\xbf\0\xed\xff\xea\0\xea\0\0\0\0\0\0\0\0\0\0\0<\x02\xa3\x03\0\0\0\0\xae\x02\0\0\0\0\0\0\0\0b\x02\0\0\xc7\0\x12\x02\xc7\0\x13\x02b\x02\xc9\x03\xe3\0\0\0\x14\x02\x1a\x02\x1c\x02\x1d\x02-\x027\x02\0\0\0\x004\x02\0\0\xc7\0\0\x009\x02:\x02b\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0R\0\0\0\0\0\x17\x02@\x02\0\x005\x02C\x02b\x02L\x02]\x02b\x02\0\0^\x02\0\0',
  /* rindex */"\0\0M\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0O\xff\x14\0\0\0w\0w\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0w\0\xc2\xff\0\0\0\0\0\0\0\0_\x02`\x02f\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0h\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0_\x02_\x02_\x02_\x02_\x02_\x02_\x02_\x02_\x02_\x02\0\0\0\0\0\0h\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0h\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0~\x01\0\0\0\0\xf2\xffh\xff\0\0)\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0i\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x83\xff\0\0\0\0\0\0y\x02k\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0M\0\x16\0\0\0M\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9a\0\x9a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0i\x02t\xff\0\0\0\0\0\0\0\0\0\0\0\0i\x02\x83\x02\0\0\x83\x02\0\0\0\0\0\0\0\0i\x02\0\0\0\0\0\0\0\0\0\0\0\0s\0\xf3\xffs\0i\x02\x84\x02\0\0y\x02\xc0\0\0\0\0\0\x8e\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x86\x02\x86\x02\x86\x02\0\0\0\0\0\0\xa4\x01X\x01\xa4\x01\0\0\0\0\xc0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe6\0\xe6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0i\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0i\x02\0\0\xf7\xff\0\0\0\0\0\0\0\0\0\0\xca\x01\x89\x02\xca\x01\0\0\x84\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\f\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0t\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x86\x02\x86\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\xf2\xff\x95\x02\x95\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0i\x02\0\0i\x02i\x02\0\0\0\0\0\0\0\x002\x012\x01\xf0\x012\x01\0\0\0\0\0\0\0\0\0\0\0\0y\x02\0\0\0\0\0\0\0\0\0\0\x83\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0i\x02\0\0\0\0\0\0i\x02\0\0\0\0\0\0\0\0\x8a\x02\0\0\x83\x02\0\0\x83\x02\0\0i\x02\0\0\xaf\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x83\x02\0\0\0\0\0\0i\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\x002\x01\0\0\0\0\x8f\x02\0\0\0\0\0\0\x9f\x02i\x02\0\0\0\0i\x02\0\0\0\0\0\0",
  /* gindex */"\0\0\0\0\0\0\0\0x\xffD\xff\xa5\x02Q\xff.\x03F\xff\xa7\xffG\xffH\xff3\xffL\xff\xbc\xff\n\x03P\xff\xb2\xff\x80\xff\xbd\xfe\f\x03\xc4\x02\0\0\x82\xff\0\0\xa6\xffV\xffN\xff\0\0\xa8\x02\0\0B\xffR\xff\xca\xfe\0\0\xca\xff\xb5\xff\0\0\0\x002\x03\0\0\0\0\0\0\0\0\0\0\xe3\xff\0\0\0\0\0\0\0\0\xac\0t\0\x96\0\xbe\0\xf0\xff\0\0\xbc\x03\0\0!\0\0\0",
  /* tablesize */1335,
  /* table */'\x86\0\xa3\0\x8b\0\xf9\0\x8b\0\x02\x01\xf7\0\xd9\0\xfc\0\0\x01\x1e\x01\xcf\0\x87\0\x88\0\xfd\0\x8d\0\x13\x01\x0f\x01\x05\x01\x8f\0\x83\0\x04\x01\b\x01\t\x01\x8a\0\xcf\0\x8e\0\xe6\0\x05\x01\xe7\0\x1c\x01\x1c\x01\x05\0\x17\x01\x18\x01*\x01,\x01-\x01\x89\x01\x8a\x01\x8b\x01#\x01\x19\0!\0\x83\x01\x84\x01\x12\0$\x01\x8b\0%\x01\x19\0&\x01\x8b\0T\0n\0\x0f\0\x15\0\x16\x005\x01U\x003\x014\x01v\0\xd1\0"\0\xe4\0\xe4\0\xd8\0\xe4\0\xe2\0\xe3\0D\0\x15\0\x16\0C\x01\x10\x01\x11\x01\x12\x01:\x01\x9b\x01\x1f\x01\xc5\0\xc8\0\x91\0\x12\0K\x01\x05\x01\xd5\0\x91\0\x91\0\xe8\0\xe9\0\xea\0\xeb\0\xec\0|\0\xed\0\xee\0\xef\0\xf0\0\xf1\0}\0J\x01\xaf\x01L\x01\x19\0\xc6\0\xca\0#\0_\x01$\0\x19\0\xd7\0\x19\0\xe4\0\xe4\0\xe4\0\x14\x01\n\x01\x11\0\xcf\0.\0\xcf\0\'\0\x0b\x01\xcf\0P\0g\x01m\x01o\x01P\0|\0~\0P\0+\x011\0.\x01 \x01~\0*\0+\0,\0-\0U\x01\x81\x002\0P\x01\x12\0\x82\0V\x01F\0W\x01\x89\0X\x01(\x01\x13\0\x14\0\x15\0\x16\0\x17\0\x18\0\x19\0\x1a\0\x1b\0\x1c\0\x1d\0\x1e\0\x1f\0 \0&\0L\0(\0)\0|\0\x99\x017\0G\0|\0\x80\x01T\x018\x005\x006\0v\x01\x81\0O\0\x14\x01k\0\x82\0E\0\x95\x01|\0l\0\x98\x01\x8f\x01\x1c\x01\x96\x01\x94\x01\x91\0<\x01=\x01w\x01\x97\x01~\0\x91\0H\0\x1a\x01\x84\0\xe2\0\xe3\0\x9d\x01\x9a\x01\x9f\x01\x01\0\x02\0\x03\0\x9c\x01/\x000\x003\x004\0I\0\xa1\x01Z\x01[\x01\\\x01]\x01n\x01\xab\x01a\0b\0c\0d\0e\0f\0g\0h\0i\0j\0\xc2\0\xae\x01t\x01\xc3\0\xc2\0i\x01\xcf\0\x07\x01j\x01\x19\0\x1c\0J\0\x19\0\x1c\0K\0\x0f\0P\0\xb4\x01\x0f\0Q\0\xb7\x01\xcf\0\xe2\0\xe3\0x\x01y\x01z\x01{\x01\xa3\0\x93\0\x94\0\x95\0\x87\x01\x87\x01\x87\x01\x87\x01\xcf\0\xde\0<\x01=\x01~\0)\x01R\0\x92\x01m\0\x1c\0\x91\0\x91\0\x1c\0S\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\x008\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0o\0\xa3\x01\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0p\0W\0X\0Y\0\x19\0\x19\0q\0Z\0r\0[\0\\\0]\0^\0s\0_\0`\0\x87\x01t\0\x1c\0u\0w\0\x1c\0~\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0x\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0y\0z\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0{\0\x1c\0\x90\0\x91\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\xbf\0\x1c\0\x92\0\xbe\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\xc0\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x1c\0\x84\0\xda\0\xc7\0\x89\0\xd4\0 \0 \0 \0 \0 \0 \0 \0\xdb\0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0 \0\x1c\0 \0 \0 \0 \0 \0 \0 \0 \0 \0\xdd\0\xf2\0\xfa\0\xfe\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x01\x01\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x03\x01 \0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\x17\0\n\x01\xf8\0)\x01\x16\x01"\0"\0"\0"\0"\0"\0"\0\x19\x01"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0"\0\x1b\x01\x17\0"\0"\0"\0"\0"\0"\0"\0"\0!\x01/\x01\'\x010\x01\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\x006\x01\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\x009\x01"\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0;\x01>\x01?\x01@\x01\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0A\x01\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0B\x01\x03\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x04\x01D\x01E\x01F\x01\x03\0\x0b\x01\x03\0\x03\0\x03\0\x03\0\x03\0a\x01\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0G\x01\x1e\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0I\x01M\x01O\x01Q\x01\x19\0\x19\0\x19\0\x19\0\x19\0R\x01\x19\0S\x01Y\x01\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0^\x01\x03\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0\x19\0`\x01b\x01c\x01d\x01\x03\0e\x01\x03\0\x03\0\x03\0\x03\0\x03\0r\x01f\x01\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0h\x01\x19\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0k\x01l\x01p\x01q\x01\x03\0\x03\0\x03\0\x03\0\x03\0s\x01\x03\0|\x01}\x01\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0~\x01\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x03\0\x7f\x01\x81\x01\x85\x01\x86\x01\x1e\0\x8d\x01\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x8c\x01\x8e\x01\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x91\x01\x03\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x1e\0\x93\x01\x9e\x01\xa0\x01\xa4\x01\x97\0\xb0\x01\x98\0\x99\0\x9a\0\xa5\x01\x9b\0\xa6\x01\xa7\x01\x9c\0\x9d\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\xa8\x01\x1e\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\xa9\x01\xaa\x01\xac\x01\xad\x01\xf6\0\xb2\x01\x98\0\x99\0\x9a\0\xb1\x01\x9b\0\xb3\x01\xa3\0\x9c\0\x9d\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\xb5\x01\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\xb6\x01\xb8\x01\x84\0\xa3\0\xf8\0~\0\x98\0\x99\0\x9a\0\x91\0\x9b\0\xaa\0P\0\x9c\0\x9d\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\x17\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\t\0R\0\x7f\0\x03\0\xfb\0\x03\0\x98\0\x99\0\x9a\0\x19\0\x9b\0P\0K\0\x9c\0\x9d\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0M\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0H\x01\xc1\0\xf5\0\xf4\0\x82\x018\x01\x98\0\x99\0\x9a\0N\x01\x9b\0\x0e\0\xd6\0\x9c\0\x9d\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\0\x99\0\xcb\0\0\0\xcc\0\0\0\0\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\xde\0\xdf\0\xe0\0\xe1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe2\0\xe3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\0\x99\0\xcb\0\0\0\xcc\0\0\0\xb3\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\0\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\xde\0\xdf\0\xe0\0\xe1\0\x98\0\x99\0\xcb\0\0\0\xcc\0\0\0\0\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\xdf\0\xe0\0\xe1\0\x98\0\x99\0\xcb\0\0\0\xcc\0\0\0\0\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\0\x99\0\xcb\0\0\0\xcc\0\x90\x01\xce\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\0\x99\0\xcb\0\0\0\xcc\0\0\0\0\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\0\0\0\0\xe1\0\x98\0\x99\0\xcb\0\0\0\xcc\0\xa2\x01\0\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\0\0\0\0\0\0\x98\0\x99\0\xcb\0\0\0\xcc\0\0\0\0\0\x9c\0\xcd\0\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\xa3\0\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\xa9\0\xaa\0\0\0\xb3\0\xab\0\xac\0\xad\0\xae\0\xaf\0\xb0\0\xb1\0\xb2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb3\0',
  /* check */"Y\0\0\0\\\0\xb5\0^\0\xbf\0\xb4\0\x8f\0\xbc\0\xbd\0\xd7\0\x89\0Z\0[\0\xbc\0]\0\xce\0\xca\0\xc4\0^\0X\0\b\x01\xc5\0\xc6\0\\\0\x97\0^\0\x9b\0\xce\0\x9d\0\xd6\0\xd7\0\t\x01\xd1\0\xd2\0\xdf\0\xe0\0\xe1\0i\x01j\x01k\x01+\x01\x01\x01\n\0b\x01c\x012\x011\x01\x8a\x003\x01\t\x015\x01\x8e\0\x04\x01F\0\t\x01<\x01=\x01\xea\0\n\x01\xe6\0\xe7\0N\0\x8a\0\0\0\x9a\0\x9b\0\x8e\0\x9d\x008\x019\x01&\0<\x01=\x01\b\x01\xcb\0\xcc\0\xcd\0\xfc\0\x85\x01\xd8\0\x87\0\x88\0\x04\x012\x01\x11\x01\b\x01\x8d\0\t\x01\n\x01\x9e\0\x9f\0\xa0\0\xa1\0\xa2\0\x04\x01\xa4\0\xa5\0\xa6\0\xa7\0\xa8\0\n\x01\x10\x01\xaa\x01\x12\x01\x01\x01\x87\0\x88\0\0\0)\x01\x05\x01\x07\x01\x8d\0\t\x01\xcb\0\xcc\0\xcd\0\xcf\0\x01\x01\x03\0\xf6\0\t\x01\xf8\0\x04\x01\x07\x01\xfb\0\n\x011\x01<\x01=\x01\x0e\x01\x04\x01\x01\x01\x11\x01\xdf\0\t\x01\xe1\0\n\x01\x07\x01\x17\0\x18\0\x19\0\x1a\0+\x01\x01\x01\x1d\0\x1a\x012\x01\x05\x011\x01\x04\x013\x01\t\x015\x01\xde\0:\x01;\x01<\x01=\x01>\x01?\x01@\x01A\x01B\x01C\x01D\x01E\x01F\x01G\x01\x13\0\t\x01\x15\0\x16\0\x04\x01{\x01\x04\x01\x04\x01\x04\x01`\x01\n\x01\t\x01\x1f\0 \0\n\x01\x01\x01\n\x01\x14\x01\n\x01\x05\x01'\0x\x01\x04\x01\n\x01z\x01r\x01{\x01x\x01\n\x01\x04\x01.\x01/\x01Q\x01y\x01\x05\x01\n\x01\x04\x016\x01\t\x018\x019\x01\x8c\x01\x81\x01\x8e\x01\x01\0\x02\0\x03\0\x8a\x01\x1b\0\x1c\0\x1d\0\x1e\0\x04\x01\x90\x01#\x01$\x01%\x01&\x01<\x01\x9e\x019\0:\0;\0<\0=\0>\0?\0@\0A\0B\0\x06\x01\xa2\x01K\x01\t\x01\x06\x01\x0e\x01s\x01\t\x01\x11\x01\x06\x01\x06\x01\x04\x01\t\x01\t\x01\x04\x01\x07\x01\x04\x01\xb2\x01\n\x01\x04\x01\xb5\x01\x82\x018\x019\x01U\x01V\x01W\x01X\x01\n\x01\x01\x01\x02\x01\x03\x01h\x01i\x01j\x01k\x01\x91\x01-\x01.\x01/\x01\x05\x01\x06\x01\x04\x01t\x01\n\x01\x06\x01\t\x01\n\x01\t\x01\x04\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\t\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01\x92\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01+\x01,\x01-\x01\t\x01\n\x01\n\x011\x01\n\x013\x014\x015\x016\x01\n\x018\x019\x01\xaa\x01#\x01\x06\x01\n\x01\n\x01\t\x01\x05\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\n\x01H\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01\n\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\x06\x01\x04\x01\x04\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01+\x01\x0f\x01\n\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\t\x01\x04\x01\t\x01\t\x01\t\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\t\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01H\x01\"\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01!\x01\n\x01\t\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\t\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\x01\x01\t\x01\x06\x01\n\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\n\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\t\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\t\x01\x04\x01\n\x01\x04\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\"\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\n\x01\n\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\x06\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\b\x01\n\x01\x01\x01\t\x01\t\x01\x07\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\x06\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\n\x016\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\n\x01\x0f\x01\n\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\n\x01\x06\x01\t\x01\x04\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x014\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\x0e\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\x0e\x01\n\x01\n\x01\n\x01\t\x01\n\x01\x0b\x01\f\x01\r\x01\t\x01\x0f\x01\n\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\n\x01\n\x01\t\x01\x06\x01\x0b\x01\f\x01\r\x01\x0e\x01\x0f\x01\n\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\t\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\n\x01\n\x01\t\x01\t\x01\x0b\x01\f\x01\r\x01\n\x01\x0f\x01\n\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\x0e\x01\n\x01\n\x01\t\x01\x11\x01\x0b\x01\f\x01\r\x01\n\x01\x0f\x01\t\x01\0\0\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\x11\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\n\x01\n\x01\t\x01\x01\x01\x0b\x01\f\x01\r\x01\n\x01\x0f\x01\n\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\n\x01\n\x01\x01\x01\n\x01\t\x01\t\x01\x0b\x01\f\x01\r\x01\x01\x01\x0f\x01\x0e\x01\n\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\n\x01H\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\x0e\x01\x86\0\xab\0\xaa\0\t\x01\xf4\0\x0b\x01\f\x01\r\x01\x14\x01\x0f\x01\x02\0\x8d\0\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\xff\xff\xff\xff\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff-\x01.\x01/\x010\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff8\x019\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\xff\xffH\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xff\xff\xff#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff-\x01.\x01/\x010\x01\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\xff\xff\xff\xff\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff.\x01/\x010\x01\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\xff\xff\xff\xff\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\x10\x017\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\xff\xff\xff\xff\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff0\x01\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\x10\x01\xff\xff\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0b\x01\f\x01\r\x01\xff\xff\x0f\x01\xff\xff\xff\xff\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01 \x01\xff\xffH\x01#\x01$\x01%\x01&\x01'\x01(\x01)\x01*\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xffH\x01",
  /* error_function */parse_error,
  /* names_const */"ANYFUNC\0MUT\0LPAR\0RPAR\0NOP\0DROP\0BLOCK\0END\0IF\0THEN\0ELSE\0SELECT\0LOOP\0BR\0BR_IF\0BR_TABLE\0CALL\0CALL_INDIRECT\0RETURN\0GET_LOCAL\0SET_LOCAL\0TEE_LOCAL\0GET_GLOBAL\0SET_GLOBAL\0UNREACHABLE\0CURRENT_MEMORY\0GROW_MEMORY\0FUNC\0START\0TYPE\0PARAM\0RESULT\0LOCAL\0GLOBAL\0MODULE\0TABLE\0ELEM\0MEMORY\0DATA\0OFFSET\0IMPORT\0EXPORT\0SCRIPT\0REGISTER\0INVOKE\0GET\0ASSERT_MALFORMED\0ASSERT_INVALID\0ASSERT_SOFT_INVALID\0ASSERT_UNLINKABLE\0ASSERT_RETURN\0ASSERT_RETURN_NAN\0ASSERT_TRAP\0ASSERT_EXHAUSTION\0INPUT\0OUTPUT\0EOF\0",
  /* names_block */"NAT\0INT\0FLOAT\0TEXT\0VAR\0VALUE_TYPE\0LOAD\0STORE\0OFFSET_EQ_NAT\0ALIGN_EQ_NAT\0CONST\0UNARY\0BINARY\0COMPARE\0CONVERT\0TEST\0"
];

function script(lexfun, lexbuf) {
  return Parsing.yyparse(yytables, 1, lexfun, lexbuf);
}

function script1(lexfun, lexbuf) {
  return Parsing.yyparse(yytables, 2, lexfun, lexbuf);
}

function module1(lexfun, lexbuf) {
  return Parsing.yyparse(yytables, 3, lexfun, lexbuf);
}

exports.script  = script;
exports.script1 = script1;
exports.module1 = module1;
/* VarMap Not a pure module */
//////// end of parser.js ////////
    return exports;
  };


  _registry['parsing'] = function() {
    let exports = {};
//////// start of parsing.js ////////
'use strict';

var $$Array         = require("./array");
var Curry           = require("./curry");
var Lexing          = require("./lexing");
var Caml_obj        = require("./caml_obj");
var Caml_array      = require("./caml_array");
var Caml_parser     = require("./caml_parser");
var Caml_exceptions = require("./caml_exceptions");

var YYexit = Caml_exceptions.create("Parsing.YYexit");

var Parse_error = Caml_exceptions.create("Parsing.Parse_error");

var env = /* record */[
  /* s_stack */Caml_array.caml_make_vect(100, 0),
  /* v_stack */Caml_array.caml_make_vect(100, /* () */0),
  /* symb_start_stack */Caml_array.caml_make_vect(100, Lexing.dummy_pos),
  /* symb_end_stack */Caml_array.caml_make_vect(100, Lexing.dummy_pos),
  /* stacksize */100,
  /* stackbase */0,
  /* curr_char */0,
  /* lval : () */0,
  /* symb_start */Lexing.dummy_pos,
  /* symb_end */Lexing.dummy_pos,
  /* asp */0,
  /* rule_len */0,
  /* rule_number */0,
  /* sp */0,
  /* state */0,
  /* errflag */0
];

function grow_stacks() {
  var oldsize = env[/* stacksize */4];
  var newsize = (oldsize << 1);
  var new_s = Caml_array.caml_make_vect(newsize, 0);
  var new_v = Caml_array.caml_make_vect(newsize, /* () */0);
  var new_start = Caml_array.caml_make_vect(newsize, Lexing.dummy_pos);
  var new_end = Caml_array.caml_make_vect(newsize, Lexing.dummy_pos);
  $$Array.blit(env[/* s_stack */0], 0, new_s, 0, oldsize);
  env[/* s_stack */0] = new_s;
  $$Array.blit(env[/* v_stack */1], 0, new_v, 0, oldsize);
  env[/* v_stack */1] = new_v;
  $$Array.blit(env[/* symb_start_stack */2], 0, new_start, 0, oldsize);
  env[/* symb_start_stack */2] = new_start;
  $$Array.blit(env[/* symb_end_stack */3], 0, new_end, 0, oldsize);
  env[/* symb_end_stack */3] = new_end;
  env[/* stacksize */4] = newsize;
  return /* () */0;
}

function clear_parser() {
  $$Array.fill(env[/* v_stack */1], 0, env[/* stacksize */4], /* () */0);
  env[/* lval */7] = /* () */0;
  return /* () */0;
}

var current_lookahead_fun = [function () {
    return /* false */0;
  }];

function yyparse(tables, start, lexer, lexbuf) {
  var init_asp = env[/* asp */10];
  var init_sp = env[/* sp */13];
  var init_stackbase = env[/* stackbase */5];
  var init_state = env[/* state */14];
  var init_curr_char = env[/* curr_char */6];
  var init_lval = env[/* lval */7];
  var init_errflag = env[/* errflag */15];
  env[/* stackbase */5] = env[/* sp */13] + 1 | 0;
  env[/* curr_char */6] = start;
  env[/* symb_end */9] = lexbuf[/* lex_curr_p */11];
  try {
    var _cmd = /* Start */0;
    var _arg = /* () */0;
    while(true) {
      var arg = _arg;
      var cmd = _cmd;
      var match = Caml_parser.caml_parse_engine(tables, env, cmd, arg);
      switch (match) {
        case 0 : 
            var t = Curry._1(lexer, lexbuf);
            env[/* symb_start */8] = lexbuf[/* lex_start_p */10];
            env[/* symb_end */9] = lexbuf[/* lex_curr_p */11];
            _arg = t;
            _cmd = /* Token_read */1;
            continue ;
            case 1 : 
            throw Parse_error;
        case 2 : 
            grow_stacks(/* () */0);
            _arg = /* () */0;
            _cmd = /* Stacks_grown_1 */2;
            continue ;
            case 3 : 
            grow_stacks(/* () */0);
            _arg = /* () */0;
            _cmd = /* Stacks_grown_2 */3;
            continue ;
            case 4 : 
            var match$1;
            try {
              match$1 = /* tuple */[
                /* Semantic_action_computed */4,
                Curry._1(tables[/* actions */0][env[/* rule_number */12]], env)
              ];
            }
            catch (exn){
              if (exn === Parse_error) {
                match$1 = /* tuple */[
                  /* Error_detected */5,
                  /* () */0
                ];
              }
              else {
                throw exn;
              }
            }
            _arg = match$1[1];
            _cmd = match$1[0];
            continue ;
            case 5 : 
            Curry._1(tables[/* error_function */13], "syntax error");
            _arg = /* () */0;
            _cmd = /* Error_detected */5;
            continue ;
            
      }
    };
  }
  catch (exn$1){
    var curr_char = env[/* curr_char */6];
    env[/* asp */10] = init_asp;
    env[/* sp */13] = init_sp;
    env[/* stackbase */5] = init_stackbase;
    env[/* state */14] = init_state;
    env[/* curr_char */6] = init_curr_char;
    env[/* lval */7] = init_lval;
    env[/* errflag */15] = init_errflag;
    if (exn$1[0] === YYexit) {
      return exn$1[1];
    }
    else {
      current_lookahead_fun[0] = function (tok) {
        if (tok.length !== undefined) {
          return +(tables[/* transl_block */2][tok.tag | 0] === curr_char);
        }
        else {
          return +(tables[/* transl_const */1][tok] === curr_char);
        }
      };
      throw exn$1;
    }
  }
}

function peek_val(env, n) {
  return env[/* v_stack */1][env[/* asp */10] - n | 0];
}

function symbol_start_pos() {
  var _i = env[/* rule_len */11];
  while(true) {
    var i = _i;
    if (i <= 0) {
      return env[/* symb_end_stack */3][env[/* asp */10]];
    }
    else {
      var st = env[/* symb_start_stack */2][(env[/* asp */10] - i | 0) + 1 | 0];
      var en = env[/* symb_end_stack */3][(env[/* asp */10] - i | 0) + 1 | 0];
      if (Caml_obj.caml_notequal(st, en)) {
        return st;
      }
      else {
        _i = i - 1 | 0;
        continue ;
        
      }
    }
  };
}

function symbol_end_pos() {
  return env[/* symb_end_stack */3][env[/* asp */10]];
}

function rhs_start_pos(n) {
  return env[/* symb_start_stack */2][env[/* asp */10] - (env[/* rule_len */11] - n | 0) | 0];
}

function rhs_end_pos(n) {
  return env[/* symb_end_stack */3][env[/* asp */10] - (env[/* rule_len */11] - n | 0) | 0];
}

function symbol_start() {
  return symbol_start_pos(/* () */0)[/* pos_cnum */3];
}

function symbol_end() {
  return symbol_end_pos(/* () */0)[/* pos_cnum */3];
}

function rhs_start(n) {
  return rhs_start_pos(n)[/* pos_cnum */3];
}

function rhs_end(n) {
  return rhs_end_pos(n)[/* pos_cnum */3];
}

function is_current_lookahead(tok) {
  return Curry._1(current_lookahead_fun[0], tok);
}

function parse_error() {
  return /* () */0;
}

var set_trace = Caml_parser.caml_set_parser_trace;

exports.symbol_start         = symbol_start;
exports.symbol_end           = symbol_end;
exports.rhs_start            = rhs_start;
exports.rhs_end              = rhs_end;
exports.symbol_start_pos     = symbol_start_pos;
exports.symbol_end_pos       = symbol_end_pos;
exports.rhs_start_pos        = rhs_start_pos;
exports.rhs_end_pos          = rhs_end_pos;
exports.clear_parser         = clear_parser;
exports.Parse_error          = Parse_error;
exports.set_trace            = set_trace;
exports.YYexit               = YYexit;
exports.yyparse              = yyparse;
exports.peek_val             = peek_val;
exports.is_current_lookahead = is_current_lookahead;
exports.parse_error          = parse_error;
/* No side effect */
//////// end of parsing.js ////////
    return exports;
  };


  _registry['pervasives'] = function() {
    let exports = {};
//////// start of pervasives.js ////////
'use strict';

var Curry                    = require("./curry");
var Caml_io                  = require("./caml_io");
var Caml_obj                 = require("./caml_obj");
var Caml_format              = require("./caml_format");
var Caml_string              = require("./caml_string");
var Caml_exceptions          = require("./caml_exceptions");
var Caml_builtin_exceptions  = require("./caml_builtin_exceptions");
var CamlinternalFormatBasics = require("./camlinternalFormatBasics");

function failwith(s) {
  throw [
        Caml_builtin_exceptions.failure,
        s
      ];
}

function invalid_arg(s) {
  throw [
        Caml_builtin_exceptions.invalid_argument,
        s
      ];
}

var Exit = Caml_exceptions.create("Pervasives.Exit");

function min(x, y) {
  if (Caml_obj.caml_lessequal(x, y)) {
    return x;
  }
  else {
    return y;
  }
}

function max(x, y) {
  if (Caml_obj.caml_greaterequal(x, y)) {
    return x;
  }
  else {
    return y;
  }
}

function abs(x) {
  if (x >= 0) {
    return x;
  }
  else {
    return -x | 0;
  }
}

function lnot(x) {
  return x ^ -1;
}

var min_int = -2147483648;

function $caret(a, b) {
  return a + b;
}

function char_of_int(n) {
  if (n < 0 || n > 255) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "char_of_int"
        ];
  }
  else {
    return n;
  }
}

function string_of_bool(b) {
  if (b) {
    return "true";
  }
  else {
    return "false";
  }
}

function bool_of_string(param) {
  switch (param) {
    case "false" : 
        return /* false */0;
    case "true" : 
        return /* true */1;
    default:
      throw [
            Caml_builtin_exceptions.invalid_argument,
            "bool_of_string"
          ];
  }
}

function string_of_int(param) {
  return "" + param;
}

function valid_float_lexem(s) {
  var l = s.length;
  var _i = 0;
  while(true) {
    var i = _i;
    if (i >= l) {
      return $caret(s, ".");
    }
    else {
      var match = Caml_string.get(s, i);
      if (match >= 48) {
        if (match >= 58) {
          return s;
        }
        else {
          _i = i + 1 | 0;
          continue ;
          
        }
      }
      else if (match !== 45) {
        return s;
      }
      else {
        _i = i + 1 | 0;
        continue ;
        
      }
    }
  };
}

function string_of_float(f) {
  return valid_float_lexem(Caml_format.caml_format_float("%.12g", f));
}

function $at(l1, l2) {
  if (l1) {
    return /* :: */[
            l1[0],
            $at(l1[1], l2)
          ];
  }
  else {
    return l2;
  }
}

var stdin = Caml_io.stdin;

var stdout = Caml_io.stdout;

var stderr = Caml_io.stderr;

function open_out_gen(_, _$1, _$2) {
  return Caml_io.caml_ml_open_descriptor_out(function () {
                throw "caml_sys_open not implemented by bucklescript yet\n";
              }());
}

function open_out(name) {
  return open_out_gen(/* :: */[
              /* Open_wronly */1,
              /* :: */[
                /* Open_creat */3,
                /* :: */[
                  /* Open_trunc */4,
                  /* :: */[
                    /* Open_text */7,
                    /* [] */0
                  ]
                ]
              ]
            ], 438, name);
}

function open_out_bin(name) {
  return open_out_gen(/* :: */[
              /* Open_wronly */1,
              /* :: */[
                /* Open_creat */3,
                /* :: */[
                  /* Open_trunc */4,
                  /* :: */[
                    /* Open_binary */6,
                    /* [] */0
                  ]
                ]
              ]
            ], 438, name);
}

function flush_all() {
  var _param = Caml_io.caml_ml_out_channels_list(/* () */0);
  while(true) {
    var param = _param;
    if (param) {
      try {
        Caml_io.caml_ml_flush(param[0]);
      }
      catch (exn){
        
      }
      _param = param[1];
      continue ;
      
    }
    else {
      return /* () */0;
    }
  };
}

function output_bytes(oc, s) {
  return Caml_io.caml_ml_output(oc, s, 0, s.length);
}

function output_string(oc, s) {
  return Caml_io.caml_ml_output(oc, s, 0, s.length);
}

function output(oc, s, ofs, len) {
  if (ofs < 0 || len < 0 || ofs > (s.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "output"
        ];
  }
  else {
    return Caml_io.caml_ml_output(oc, s, ofs, len);
  }
}

function output_substring(oc, s, ofs, len) {
  if (ofs < 0 || len < 0 || ofs > (s.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "output_substring"
        ];
  }
  else {
    return Caml_io.caml_ml_output(oc, s, ofs, len);
  }
}

function output_value(_, _$1) {
  return function () {
            throw "caml_output_value not implemented by bucklescript yet\n";
          }();
}

function close_out(oc) {
  Caml_io.caml_ml_flush(oc);
  return function () {
            throw "caml_ml_close_channel not implemented by bucklescript yet\n";
          }();
}

function close_out_noerr(oc) {
  try {
    Caml_io.caml_ml_flush(oc);
  }
  catch (exn){
    
  }
  try {
    return function () {
              throw "caml_ml_close_channel not implemented by bucklescript yet\n";
            }();
  }
  catch (exn$1){
    return /* () */0;
  }
}

function open_in_gen(_, _$1, _$2) {
  return Caml_io.caml_ml_open_descriptor_in(function () {
                throw "caml_sys_open not implemented by bucklescript yet\n";
              }());
}

function open_in(name) {
  return open_in_gen(/* :: */[
              /* Open_rdonly */0,
              /* :: */[
                /* Open_text */7,
                /* [] */0
              ]
            ], 0, name);
}

function open_in_bin(name) {
  return open_in_gen(/* :: */[
              /* Open_rdonly */0,
              /* :: */[
                /* Open_binary */6,
                /* [] */0
              ]
            ], 0, name);
}

function input(_, s, ofs, len) {
  if (ofs < 0 || len < 0 || ofs > (s.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "input"
        ];
  }
  else {
    return function () {
              throw "caml_ml_input not implemented by bucklescript yet\n";
            }();
  }
}

function unsafe_really_input(_, _$1, _ofs, _len) {
  while(true) {
    var len = _len;
    var ofs = _ofs;
    if (len <= 0) {
      return /* () */0;
    }
    else {
      var r = function () {
          throw "caml_ml_input not implemented by bucklescript yet\n";
        }();
      if (r) {
        _len = len - r | 0;
        _ofs = ofs + r | 0;
        continue ;
        
      }
      else {
        throw Caml_builtin_exceptions.end_of_file;
      }
    }
  };
}

function really_input(ic, s, ofs, len) {
  if (ofs < 0 || len < 0 || ofs > (s.length - len | 0)) {
    throw [
          Caml_builtin_exceptions.invalid_argument,
          "really_input"
        ];
  }
  else {
    return unsafe_really_input(ic, s, ofs, len);
  }
}

function really_input_string(ic, len) {
  var s = Caml_string.caml_create_string(len);
  really_input(ic, s, 0, len);
  return Caml_string.bytes_to_string(s);
}

function input_line(chan) {
  var build_result = function (buf, _pos, _param) {
    while(true) {
      var param = _param;
      var pos = _pos;
      if (param) {
        var hd = param[0];
        var len = hd.length;
        Caml_string.caml_blit_bytes(hd, 0, buf, pos - len | 0, len);
        _param = param[1];
        _pos = pos - len | 0;
        continue ;
        
      }
      else {
        return buf;
      }
    };
  };
  var scan = function (_accu, _len) {
    while(true) {
      var len = _len;
      var accu = _accu;
      var n = function () {
          throw "caml_ml_input_scan_line not implemented by bucklescript yet\n";
        }();
      if (n) {
        if (n > 0) {
          var res = Caml_string.caml_create_string(n - 1 | 0);
          (function () {
                throw "caml_ml_input not implemented by bucklescript yet\n";
              }());
          Caml_io.caml_ml_input_char(chan);
          if (accu) {
            var len$1 = (len + n | 0) - 1 | 0;
            return build_result(Caml_string.caml_create_string(len$1), len$1, /* :: */[
                        res,
                        accu
                      ]);
          }
          else {
            return res;
          }
        }
        else {
          var beg = Caml_string.caml_create_string(-n | 0);
          (function () {
                throw "caml_ml_input not implemented by bucklescript yet\n";
              }());
          _len = len - n | 0;
          _accu = /* :: */[
            beg,
            accu
          ];
          continue ;
          
        }
      }
      else if (accu) {
        return build_result(Caml_string.caml_create_string(len), len, accu);
      }
      else {
        throw Caml_builtin_exceptions.end_of_file;
      }
    };
  };
  return Caml_string.bytes_to_string(scan(/* [] */0, 0));
}

function close_in_noerr() {
  try {
    return function () {
              throw "caml_ml_close_channel not implemented by bucklescript yet\n";
            }();
  }
  catch (exn){
    return /* () */0;
  }
}

function print_char(c) {
  return Caml_io.caml_ml_output_char(stdout, c);
}

function print_string(s) {
  return output_string(stdout, s);
}

function print_bytes(s) {
  return output_bytes(stdout, s);
}

function print_int(i) {
  return output_string(stdout, "" + i);
}

function print_float(f) {
  return output_string(stdout, valid_float_lexem(Caml_format.caml_format_float("%.12g", f)));
}

function print_endline(param) {
  console.log(param);
  return 0;
}

function print_newline() {
  Caml_io.caml_ml_output_char(stdout, /* "\n" */10);
  return Caml_io.caml_ml_flush(stdout);
}

function prerr_char(c) {
  return Caml_io.caml_ml_output_char(stderr, c);
}

function prerr_string(s) {
  return output_string(stderr, s);
}

function prerr_bytes(s) {
  return output_bytes(stderr, s);
}

function prerr_int(i) {
  return output_string(stderr, "" + i);
}

function prerr_float(f) {
  return output_string(stderr, valid_float_lexem(Caml_format.caml_format_float("%.12g", f)));
}

function prerr_endline(param) {
  console.error(param);
  return 0;
}

function prerr_newline() {
  Caml_io.caml_ml_output_char(stderr, /* "\n" */10);
  return Caml_io.caml_ml_flush(stderr);
}

function read_line() {
  Caml_io.caml_ml_flush(stdout);
  return input_line(stdin);
}

function read_int() {
  return Caml_format.caml_int_of_string((Caml_io.caml_ml_flush(stdout), input_line(stdin)));
}

function read_float() {
  return Caml_format.caml_float_of_string((Caml_io.caml_ml_flush(stdout), input_line(stdin)));
}

function string_of_format(param) {
  return param[1];
}

function $caret$caret(param, param$1) {
  return /* Format */[
          CamlinternalFormatBasics.concat_fmt(param[0], param$1[0]),
          $caret(param[1], $caret("%,", param$1[1]))
        ];
}

var exit_function = [flush_all];

function at_exit(f) {
  var g = exit_function[0];
  exit_function[0] = function () {
    Curry._1(f, /* () */0);
    return Curry._1(g, /* () */0);
  };
  return /* () */0;
}

function do_at_exit() {
  return Curry._1(exit_function[0], /* () */0);
}

function exit() {
  do_at_exit(/* () */0);
  return function () {
            throw "caml_sys_exit not implemented by bucklescript yet\n";
          }();
}

var max_int = 2147483647;

var infinity = Infinity;

var neg_infinity = -Infinity;

var nan = NaN;

var max_float = Number.MAX_VALUE;

var min_float = Number.MIN_VALUE;

var epsilon_float = 2.220446049250313e-16;

var flush = Caml_io.caml_ml_flush;

var output_char = Caml_io.caml_ml_output_char;

var output_byte = Caml_io.caml_ml_output_char;

function output_binary_int(_, _$1) {
  return function () {
            throw "caml_ml_output_int not implemented by bucklescript yet\n";
          }();
}

function seek_out(_, _$1) {
  return function () {
            throw "caml_ml_seek_out not implemented by bucklescript yet\n";
          }();
}

function pos_out() {
  return function () {
            throw "caml_ml_pos_out not implemented by bucklescript yet\n";
          }();
}

function out_channel_length() {
  return function () {
            throw "caml_ml_channel_size not implemented by bucklescript yet\n";
          }();
}

function set_binary_mode_out(_, _$1) {
  return function () {
            throw "caml_ml_set_binary_mode not implemented by bucklescript yet\n";
          }();
}

var input_char = Caml_io.caml_ml_input_char;

var input_byte = Caml_io.caml_ml_input_char;

function input_binary_int() {
  return function () {
            throw "caml_ml_input_int not implemented by bucklescript yet\n";
          }();
}

function input_value() {
  return function () {
            throw "caml_input_value not implemented by bucklescript yet\n";
          }();
}

function seek_in(_, _$1) {
  return function () {
            throw "caml_ml_seek_in not implemented by bucklescript yet\n";
          }();
}

function pos_in() {
  return function () {
            throw "caml_ml_pos_in not implemented by bucklescript yet\n";
          }();
}

function in_channel_length() {
  return function () {
            throw "caml_ml_channel_size not implemented by bucklescript yet\n";
          }();
}

function close_in() {
  return function () {
            throw "caml_ml_close_channel not implemented by bucklescript yet\n";
          }();
}

function set_binary_mode_in(_, _$1) {
  return function () {
            throw "caml_ml_set_binary_mode not implemented by bucklescript yet\n";
          }();
}

function LargeFile_000(_, _$1) {
  return function () {
            throw "caml_ml_seek_out_64 not implemented by bucklescript yet\n";
          }();
}

function LargeFile_001() {
  return function () {
            throw "caml_ml_pos_out_64 not implemented by bucklescript yet\n";
          }();
}

function LargeFile_002() {
  return function () {
            throw "caml_ml_channel_size_64 not implemented by bucklescript yet\n";
          }();
}

function LargeFile_003(_, _$1) {
  return function () {
            throw "caml_ml_seek_in_64 not implemented by bucklescript yet\n";
          }();
}

function LargeFile_004() {
  return function () {
            throw "caml_ml_pos_in_64 not implemented by bucklescript yet\n";
          }();
}

function LargeFile_005() {
  return function () {
            throw "caml_ml_channel_size_64 not implemented by bucklescript yet\n";
          }();
}

var LargeFile = [
  LargeFile_000,
  LargeFile_001,
  LargeFile_002,
  LargeFile_003,
  LargeFile_004,
  LargeFile_005
];

exports.invalid_arg         = invalid_arg;
exports.failwith            = failwith;
exports.Exit                = Exit;
exports.min                 = min;
exports.max                 = max;
exports.abs                 = abs;
exports.max_int             = max_int;
exports.min_int             = min_int;
exports.lnot                = lnot;
exports.infinity            = infinity;
exports.neg_infinity        = neg_infinity;
exports.nan                 = nan;
exports.max_float           = max_float;
exports.min_float           = min_float;
exports.epsilon_float       = epsilon_float;
exports.$caret              = $caret;
exports.char_of_int         = char_of_int;
exports.string_of_bool      = string_of_bool;
exports.bool_of_string      = bool_of_string;
exports.string_of_int       = string_of_int;
exports.string_of_float     = string_of_float;
exports.$at                 = $at;
exports.stdin               = stdin;
exports.stdout              = stdout;
exports.stderr              = stderr;
exports.print_char          = print_char;
exports.print_string        = print_string;
exports.print_bytes         = print_bytes;
exports.print_int           = print_int;
exports.print_float         = print_float;
exports.print_endline       = print_endline;
exports.print_newline       = print_newline;
exports.prerr_char          = prerr_char;
exports.prerr_string        = prerr_string;
exports.prerr_bytes         = prerr_bytes;
exports.prerr_int           = prerr_int;
exports.prerr_float         = prerr_float;
exports.prerr_endline       = prerr_endline;
exports.prerr_newline       = prerr_newline;
exports.read_line           = read_line;
exports.read_int            = read_int;
exports.read_float          = read_float;
exports.open_out            = open_out;
exports.open_out_bin        = open_out_bin;
exports.open_out_gen        = open_out_gen;
exports.flush               = flush;
exports.flush_all           = flush_all;
exports.output_char         = output_char;
exports.output_string       = output_string;
exports.output_bytes        = output_bytes;
exports.output              = output;
exports.output_substring    = output_substring;
exports.output_byte         = output_byte;
exports.output_binary_int   = output_binary_int;
exports.output_value        = output_value;
exports.seek_out            = seek_out;
exports.pos_out             = pos_out;
exports.out_channel_length  = out_channel_length;
exports.close_out           = close_out;
exports.close_out_noerr     = close_out_noerr;
exports.set_binary_mode_out = set_binary_mode_out;
exports.open_in             = open_in;
exports.open_in_bin         = open_in_bin;
exports.open_in_gen         = open_in_gen;
exports.input_char          = input_char;
exports.input_line          = input_line;
exports.input               = input;
exports.really_input        = really_input;
exports.really_input_string = really_input_string;
exports.input_byte          = input_byte;
exports.input_binary_int    = input_binary_int;
exports.input_value         = input_value;
exports.seek_in             = seek_in;
exports.pos_in              = pos_in;
exports.in_channel_length   = in_channel_length;
exports.close_in            = close_in;
exports.close_in_noerr      = close_in_noerr;
exports.set_binary_mode_in  = set_binary_mode_in;
exports.LargeFile           = LargeFile;
exports.string_of_format    = string_of_format;
exports.$caret$caret        = $caret$caret;
exports.exit                = exit;
exports.at_exit             = at_exit;
exports.valid_float_lexem   = valid_float_lexem;
exports.unsafe_really_input = unsafe_really_input;
exports.do_at_exit          = do_at_exit;
/* No side effect */
//////// end of pervasives.js ////////
    return exports;
  };


  _registry['printf'] = function() {
    let exports = {};
//////// start of printf.js ////////
'use strict';

var Curry              = require("./curry");
var Buffer             = require("./buffer");
var Pervasives         = require("./pervasives");
var CamlinternalFormat = require("./camlinternalFormat");

function kfprintf(k, o, param) {
  return CamlinternalFormat.make_printf(function (o, acc) {
              CamlinternalFormat.output_acc(o, acc);
              return Curry._1(k, o);
            }, o, /* End_of_acc */0, param[0]);
}

function kbprintf(k, b, param) {
  return CamlinternalFormat.make_printf(function (b, acc) {
              CamlinternalFormat.bufput_acc(b, acc);
              return Curry._1(k, b);
            }, b, /* End_of_acc */0, param[0]);
}

function ikfprintf(k, oc, param) {
  return CamlinternalFormat.make_printf(function (oc, _) {
              return Curry._1(k, oc);
            }, oc, /* End_of_acc */0, param[0]);
}

function fprintf(oc, fmt) {
  return kfprintf(function () {
              return /* () */0;
            }, oc, fmt);
}

function bprintf(b, fmt) {
  return kbprintf(function () {
              return /* () */0;
            }, b, fmt);
}

function ifprintf(oc, fmt) {
  return ikfprintf(function () {
              return /* () */0;
            }, oc, fmt);
}

function printf(fmt) {
  return fprintf(Pervasives.stdout, fmt);
}

function eprintf(fmt) {
  return fprintf(Pervasives.stderr, fmt);
}

function ksprintf(k, param) {
  var k$prime = function (_, acc) {
    var buf = Buffer.create(64);
    CamlinternalFormat.strput_acc(buf, acc);
    return Curry._1(k, Buffer.contents(buf));
  };
  return CamlinternalFormat.make_printf(k$prime, /* () */0, /* End_of_acc */0, param[0]);
}

function sprintf(fmt) {
  return ksprintf(function (s) {
              return s;
            }, fmt);
}

var kprintf = ksprintf;

exports.fprintf   = fprintf;
exports.printf    = printf;
exports.eprintf   = eprintf;
exports.sprintf   = sprintf;
exports.bprintf   = bprintf;
exports.ifprintf  = ifprintf;
exports.kfprintf  = kfprintf;
exports.ikfprintf = ikfprintf;
exports.ksprintf  = ksprintf;
exports.kbprintf  = kbprintf;
exports.kprintf   = kprintf;
/* No side effect */
//////// end of printf.js ////////
    return exports;
  };


  _registry['print'] = function() {
    let exports = {};
//////// start of print.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var List    = require("bs-platform/lib/js/list");
var Sexpr   = require("./sexpr");
var Arrange = require("./arrange");

function instr(oc, width, e) {
  return Sexpr.output(oc, width, Arrange.instr(e));
}

function func(oc, width, f) {
  return Sexpr.output(oc, width, Arrange.func(f));
}

function module_(oc, width, m) {
  return Sexpr.output(oc, width, Arrange.module_(m));
}

function script(oc, width, mode, s) {
  return List.iter(function (param) {
              return Sexpr.output(oc, width, param);
            }, Arrange.script(mode, s));
}

exports.instr   = instr;
exports.func    = func;
exports.module_ = module_;
exports.script  = script;
/* Arrange Not a pure module */
//////// end of print.js ////////
    return exports;
  };


  _registry['script'] = function() {
    let exports = {};
//////// start of script.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Caml_exceptions = require("bs-platform/lib/js/caml_exceptions");

var Syntax = Caml_exceptions.create("Script.Syntax");

exports.Syntax = Syntax;
/* No side effect */
//////// end of script.js ////////
    return exports;
  };


  _registry['sexpr'] = function() {
    let exports = {};
//////// start of sexpr.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var List       = require("bs-platform/lib/js/list");
var Block      = require("bs-platform/lib/js/block");
var Curry      = require("bs-platform/lib/js/curry");
var $$String   = require("bs-platform/lib/js/string");
var Pervasives = require("bs-platform/lib/js/pervasives");

function $caret$plus(s, r) {
  return /* Concat */Block.__(1, [/* :: */[
              /* Leaf */Block.__(0, [s]),
              /* :: */[
                r,
                /* [] */0
              ]
            ]]);
}

function $plus$caret(r, s) {
  return /* Concat */Block.__(1, [/* :: */[
              r,
              /* :: */[
                /* Leaf */Block.__(0, [s]),
                /* [] */0
              ]
            ]]);
}

function iter(f, param) {
  if (param.tag) {
    return List.iter(function (param) {
                return iter(f, param);
              }, param[0]);
  }
  else {
    return Curry._1(f, param[0]);
  }
}

function concat(param) {
  if (param.tag) {
    return $$String.concat("", List.map(concat, param[0]));
  }
  else {
    return param[0];
  }
}

function pp(off, width, param) {
  if (param.tag) {
    var s = param[0];
    var partial_arg = off + 2 | 0;
    var match = List.split(List.map(function (param) {
              return pp(partial_arg, width, param);
            }, param[1]));
    var rs = match[1];
    var len = (s.length + List.length(rs) | 0) + List.fold_left(function (prim, prim$1) {
          return prim + prim$1 | 0;
        }, 2, match[0]) | 0;
    var match$1;
    if ((off + len | 0) <= width) {
      match$1 = /* tuple */[
        " ",
        ""
      ];
    }
    else {
      var indent = $$String.make(off, /* " " */32);
      match$1 = /* tuple */[
        "\n  " + indent,
        "\n" + indent
      ];
    }
    var sep = match$1[0];
    return /* tuple */[
            len,
            $caret$plus("(", $caret$plus(s, $plus$caret($plus$caret(/* Concat */Block.__(1, [List.map(function (r) {
                                      return $caret$plus(sep, r);
                                    }, rs)]), match$1[1]), ")")))
          ];
  }
  else {
    var s$1 = param[0];
    return /* tuple */[
            s$1.length,
            /* Leaf */Block.__(0, [s$1])
          ];
  }
}

function output(oc, width, x) {
  iter(function (param) {
        return Pervasives.output_string(oc, param);
      }, pp(0, width, x)[1]);
  Pervasives.output_string(oc, "\n");
  return Curry._1(Pervasives.flush, oc);
}

function print(param, param$1) {
  return output(Pervasives.stdout, param, param$1);
}

function to_string(width, x) {
  return concat(pp(0, width, x)[1]) + "\n";
}

exports.output    = output;
exports.print     = print;
exports.to_string = to_string;
/* No side effect */
//////// end of sexpr.js ////////
    return exports;
  };


  _registry['source'] = function() {
    let exports = {};
//////// start of source.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Block      = require("bs-platform/lib/js/block");
var Curry      = require("bs-platform/lib/js/curry");
var Printf     = require("bs-platform/lib/js/printf");
var Caml_obj   = require("bs-platform/lib/js/caml_obj");
var Pervasives = require("bs-platform/lib/js/pervasives");

function $at$at(x, region) {
  return /* record */[
          /* at */region,
          /* it */x
        ];
}

var no_pos = /* record */[
  /* file */"",
  /* line */0,
  /* column */0
];

var no_region = /* record */[
  /* left */no_pos,
  /* right */no_pos
];

function string_of_pos(pos) {
  if (pos[/* line */1] === -1) {
    return Curry._1(Printf.sprintf(/* Format */[
                    /* String_literal */Block.__(11, [
                        "0x",
                        /* Int */Block.__(4, [
                            /* Int_x */6,
                            /* No_padding */0,
                            /* No_precision */0,
                            /* End_of_format */0
                          ])
                      ]),
                    "0x%x"
                  ]), pos[/* column */2]);
  }
  else {
    return Pervasives.string_of_int(pos[/* line */1]) + ("." + Pervasives.string_of_int(pos[/* column */2] + 1 | 0));
  }
}

function string_of_region(r) {
  return r[/* left */0][/* file */0] + (":" + (string_of_pos(r[/* left */0]) + (
              Caml_obj.caml_equal(r[/* right */1], r[/* left */0]) ? "" : "-" + string_of_pos(r[/* right */1])
            )));
}

exports.no_pos           = no_pos;
exports.no_region        = no_region;
exports.string_of_pos    = string_of_pos;
exports.string_of_region = string_of_region;
exports.$at$at           = $at$at;
/* No side effect */
//////// end of source.js ////////
    return exports;
  };


  _registry['string'] = function() {
    let exports = {};
//////// start of string.js ////////
'use strict';

var List        = require("./list");
var Bytes       = require("./bytes");
var Caml_int32  = require("./caml_int32");
var Caml_string = require("./caml_string");

function make(n, c) {
  return Caml_string.bytes_to_string(Bytes.make(n, c));
}

function init(n, f) {
  return Caml_string.bytes_to_string(Bytes.init(n, f));
}

function copy(s) {
  return Caml_string.bytes_to_string(Bytes.copy(Caml_string.bytes_of_string(s)));
}

function sub(s, ofs, len) {
  return Caml_string.bytes_to_string(Bytes.sub(Caml_string.bytes_of_string(s), ofs, len));
}

function concat(sep, l) {
  if (l) {
    var hd = l[0];
    var num = [0];
    var len = [0];
    List.iter(function (s) {
          num[0] = num[0] + 1 | 0;
          len[0] = len[0] + s.length | 0;
          return /* () */0;
        }, l);
    var r = Caml_string.caml_create_string(len[0] + Caml_int32.imul(sep.length, num[0] - 1 | 0) | 0);
    Caml_string.caml_blit_string(hd, 0, r, 0, hd.length);
    var pos = [hd.length];
    List.iter(function (s) {
          Caml_string.caml_blit_string(sep, 0, r, pos[0], sep.length);
          pos[0] = pos[0] + sep.length | 0;
          Caml_string.caml_blit_string(s, 0, r, pos[0], s.length);
          pos[0] = pos[0] + s.length | 0;
          return /* () */0;
        }, l[1]);
    return Caml_string.bytes_to_string(r);
  }
  else {
    return "";
  }
}

function iter(f, s) {
  return Bytes.iter(f, Caml_string.bytes_of_string(s));
}

function iteri(f, s) {
  return Bytes.iteri(f, Caml_string.bytes_of_string(s));
}

function map(f, s) {
  return Caml_string.bytes_to_string(Bytes.map(f, Caml_string.bytes_of_string(s)));
}

function mapi(f, s) {
  return Caml_string.bytes_to_string(Bytes.mapi(f, Caml_string.bytes_of_string(s)));
}

function is_space(param) {
  var switcher = param - 9 | 0;
  if (switcher > 4 || switcher < 0) {
    if (switcher !== 23) {
      return /* false */0;
    }
    else {
      return /* true */1;
    }
  }
  else if (switcher !== 2) {
    return /* true */1;
  }
  else {
    return /* false */0;
  }
}

function trim(s) {
  if (s === "" || !(is_space(s.charCodeAt(0)) || is_space(s.charCodeAt(s.length - 1 | 0)))) {
    return s;
  }
  else {
    return Caml_string.bytes_to_string(Bytes.trim(Caml_string.bytes_of_string(s)));
  }
}

function escaped(s) {
  var needs_escape = function (_i) {
    while(true) {
      var i = _i;
      if (i >= s.length) {
        return /* false */0;
      }
      else {
        var match = s.charCodeAt(i);
        if (match >= 32) {
          var switcher = match - 34 | 0;
          if (switcher > 58 || switcher < 0) {
            if (switcher >= 93) {
              return /* true */1;
            }
            else {
              _i = i + 1 | 0;
              continue ;
              
            }
          }
          else if (switcher > 57 || switcher < 1) {
            return /* true */1;
          }
          else {
            _i = i + 1 | 0;
            continue ;
            
          }
        }
        else {
          return /* true */1;
        }
      }
    };
  };
  if (needs_escape(0)) {
    return Caml_string.bytes_to_string(Bytes.escaped(Caml_string.bytes_of_string(s)));
  }
  else {
    return s;
  }
}

function index(s, c) {
  return Bytes.index(Caml_string.bytes_of_string(s), c);
}

function rindex(s, c) {
  return Bytes.rindex(Caml_string.bytes_of_string(s), c);
}

function index_from(s, i, c) {
  return Bytes.index_from(Caml_string.bytes_of_string(s), i, c);
}

function rindex_from(s, i, c) {
  return Bytes.rindex_from(Caml_string.bytes_of_string(s), i, c);
}

function contains(s, c) {
  return Bytes.contains(Caml_string.bytes_of_string(s), c);
}

function contains_from(s, i, c) {
  return Bytes.contains_from(Caml_string.bytes_of_string(s), i, c);
}

function rcontains_from(s, i, c) {
  return Bytes.rcontains_from(Caml_string.bytes_of_string(s), i, c);
}

function uppercase(s) {
  return Caml_string.bytes_to_string(Bytes.uppercase(Caml_string.bytes_of_string(s)));
}

function lowercase(s) {
  return Caml_string.bytes_to_string(Bytes.lowercase(Caml_string.bytes_of_string(s)));
}

function capitalize(s) {
  return Caml_string.bytes_to_string(Bytes.capitalize(Caml_string.bytes_of_string(s)));
}

function uncapitalize(s) {
  return Caml_string.bytes_to_string(Bytes.uncapitalize(Caml_string.bytes_of_string(s)));
}

var compare = Caml_string.caml_string_compare;

var fill = Bytes.fill;

var blit = Bytes.blit_string;

exports.make           = make;
exports.init           = init;
exports.copy           = copy;
exports.sub            = sub;
exports.fill           = fill;
exports.blit           = blit;
exports.concat         = concat;
exports.iter           = iter;
exports.iteri          = iteri;
exports.map            = map;
exports.mapi           = mapi;
exports.trim           = trim;
exports.escaped        = escaped;
exports.index          = index;
exports.rindex         = rindex;
exports.index_from     = index_from;
exports.rindex_from    = rindex_from;
exports.contains       = contains;
exports.contains_from  = contains_from;
exports.rcontains_from = rcontains_from;
exports.uppercase      = uppercase;
exports.lowercase      = lowercase;
exports.capitalize     = capitalize;
exports.uncapitalize   = uncapitalize;
exports.compare        = compare;
/* No side effect */
//////// end of string.js ////////
    return exports;
  };


  _registry['sys'] = function() {
    let exports = {};
//////// start of sys.js ////////
'use strict';

var Caml_exceptions = require("./caml_exceptions");

var is_js = /* true */1;

var match_001 = /* array */[];

var big_endian = /* false */0;

var unix = /* true */1;

var win32 = /* false */0;

var cygwin = /* false */0;

var max_array_length = 2147483647;

var max_string_length = 2147483647;

var interactive = [/* false */0];

function set_signal(_, _$1) {
  return /* () */0;
}

var Break = Caml_exceptions.create("Sys.Break");

function catch_break() {
  return /* () */0;
}

var argv = match_001;

var executable_name = "cmd";

var os_type = "Unix";

var word_size = 32;

var sigabrt = -1;

var sigalrm = -2;

var sigfpe = -3;

var sighup = -4;

var sigill = -5;

var sigint = -6;

var sigkill = -7;

var sigpipe = -8;

var sigquit = -9;

var sigsegv = -10;

var sigterm = -11;

var sigusr1 = -12;

var sigusr2 = -13;

var sigchld = -14;

var sigcont = -15;

var sigstop = -16;

var sigtstp = -17;

var sigttin = -18;

var sigttou = -19;

var sigvtalrm = -20;

var sigprof = -21;

var ocaml_version = "4.02.3+dev1-2015-07-10";

exports.argv              = argv;
exports.executable_name   = executable_name;
exports.interactive       = interactive;
exports.os_type           = os_type;
exports.unix              = unix;
exports.win32             = win32;
exports.cygwin            = cygwin;
exports.word_size         = word_size;
exports.big_endian        = big_endian;
exports.is_js             = is_js;
exports.max_string_length = max_string_length;
exports.max_array_length  = max_array_length;
exports.set_signal        = set_signal;
exports.sigabrt           = sigabrt;
exports.sigalrm           = sigalrm;
exports.sigfpe            = sigfpe;
exports.sighup            = sighup;
exports.sigill            = sigill;
exports.sigint            = sigint;
exports.sigkill           = sigkill;
exports.sigpipe           = sigpipe;
exports.sigquit           = sigquit;
exports.sigsegv           = sigsegv;
exports.sigterm           = sigterm;
exports.sigusr1           = sigusr1;
exports.sigusr2           = sigusr2;
exports.sigchld           = sigchld;
exports.sigcont           = sigcont;
exports.sigstop           = sigstop;
exports.sigtstp           = sigtstp;
exports.sigttin           = sigttin;
exports.sigttou           = sigttou;
exports.sigvtalrm         = sigvtalrm;
exports.sigprof           = sigprof;
exports.Break             = Break;
exports.catch_break       = catch_break;
exports.ocaml_version     = ocaml_version;
/* No side effect */
//////// end of sys.js ////////
    return exports;
  };


  _registry['types'] = function() {
    let exports = {};
//////// start of types.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var I32      = require("./i32");
var List     = require("bs-platform/lib/js/list");
var Curry    = require("bs-platform/lib/js/curry");
var $$String = require("bs-platform/lib/js/string");

function size(param) {
  if (param !== 1 && param < 3) {
    return 4;
  }
  else {
    return 8;
  }
}

function string_of_value_type(param) {
  switch (param) {
    case 0 : 
        return "i32";
    case 1 : 
        return "i64";
    case 2 : 
        return "f32";
    case 3 : 
        return "f64";
    
  }
}

function string_of_value_types(ts) {
  var exit = 0;
  if (ts) {
    if (ts[1]) {
      exit = 1;
    }
    else {
      return string_of_value_type(ts[0]);
    }
  }
  else {
    exit = 1;
  }
  if (exit === 1) {
    return "[" + ($$String.concat(" ", List.map(string_of_value_type, ts)) + "]");
  }
  
}

function string_of_elem_type() {
  return "anyfunc";
}

function string_of_limits(param) {
  var max = param[/* max */1];
  return Curry._1(I32.to_string_u, param[/* min */0]) + (
          max ? " " + Curry._1(I32.to_string_u, max[0]) : ""
        );
}

function string_of_memory_type(param) {
  return string_of_limits(param[0]);
}

function string_of_table_type(param) {
  return string_of_limits(param[0]) + " anyfunc";
}

function string_of_global_type(param) {
  var t = param[0];
  if (param[1] !== 0) {
    return "(mut " + (string_of_value_type(t) + ")");
  }
  else {
    return string_of_value_type(t);
  }
}

function string_of_stack_type(ts) {
  return "[" + ($$String.concat(" ", List.map(string_of_value_type, ts)) + "]");
}

function string_of_func_type(param) {
  return string_of_stack_type(param[0]) + (" -> " + string_of_stack_type(param[1]));
}

exports.size                  = size;
exports.string_of_value_type  = string_of_value_type;
exports.string_of_value_types = string_of_value_types;
exports.string_of_elem_type   = string_of_elem_type;
exports.string_of_limits      = string_of_limits;
exports.string_of_memory_type = string_of_memory_type;
exports.string_of_table_type  = string_of_table_type;
exports.string_of_global_type = string_of_global_type;
exports.string_of_stack_type  = string_of_stack_type;
exports.string_of_func_type   = string_of_func_type;
/* I32 Not a pure module */
//////// end of types.js ////////
    return exports;
  };


  _registry['values'] = function() {
    let exports = {};
//////// start of values.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var F32             = require("./f32");
var F64             = require("./f64");
var I32             = require("./i32");
var I64             = require("./i64");
var List            = require("bs-platform/lib/js/list");
var Block           = require("bs-platform/lib/js/block");
var Curry           = require("bs-platform/lib/js/curry");
var $$String        = require("bs-platform/lib/js/string");
var Caml_exceptions = require("bs-platform/lib/js/caml_exceptions");

function type_of(param) {
  switch (param.tag | 0) {
    case 0 : 
        return /* I32Type */0;
    case 1 : 
        return /* I64Type */1;
    case 2 : 
        return /* F32Type */2;
    case 3 : 
        return /* F64Type */3;
    
  }
}

function default_value(param) {
  switch (param) {
    case 0 : 
        return /* I32 */Block.__(0, [I32.zero]);
    case 1 : 
        return /* I64 */Block.__(1, [I64.zero]);
    case 2 : 
        return /* F32 */Block.__(2, [F32.zero]);
    case 3 : 
        return /* F64 */Block.__(3, [F64.zero]);
    
  }
}

function value_of_bool(b) {
  return /* I32 */Block.__(0, [b ? 1 : 0]);
}

function string_of_value(param) {
  switch (param.tag | 0) {
    case 0 : 
        return Curry._1(I32.to_string_s, param[0]);
    case 1 : 
        return Curry._1(I64.to_string_s, param[0]);
    case 2 : 
        return Curry._1(F32.to_string, param[0]);
    case 3 : 
        return Curry._1(F64.to_string, param[0]);
    
  }
}

function string_of_values(vs) {
  var exit = 0;
  if (vs) {
    if (vs[1]) {
      exit = 1;
    }
    else {
      return string_of_value(vs[0]);
    }
  }
  else {
    exit = 1;
  }
  if (exit === 1) {
    return "[" + ($$String.concat(" ", List.map(string_of_value, vs)) + "]");
  }
  
}

var Value = Caml_exceptions.create("Values.Value");

function to_value(i) {
  return /* I32 */Block.__(0, [i]);
}

function of_value(param) {
  if (param.tag) {
    throw [
          Value,
          /* I32Type */0
        ];
  }
  else {
    return param[0];
  }
}

var I32Value = /* module */[
  /* to_value */to_value,
  /* of_value */of_value
];

function to_value$1(i) {
  return /* I64 */Block.__(1, [i]);
}

function of_value$1(param) {
  if (param.tag === 1) {
    return param[0];
  }
  else {
    throw [
          Value,
          /* I64Type */1
        ];
  }
}

var I64Value = /* module */[
  /* to_value */to_value$1,
  /* of_value */of_value$1
];

function to_value$2(i) {
  return /* F32 */Block.__(2, [i]);
}

function of_value$2(param) {
  if (param.tag === 2) {
    return param[0];
  }
  else {
    throw [
          Value,
          /* F32Type */2
        ];
  }
}

var F32Value = /* module */[
  /* to_value */to_value$2,
  /* of_value */of_value$2
];

function to_value$3(i) {
  return /* F64 */Block.__(3, [i]);
}

function of_value$3(param) {
  if (param.tag === 3) {
    return param[0];
  }
  else {
    throw [
          Value,
          /* F64Type */3
        ];
  }
}

var F64Value = /* module */[
  /* to_value */to_value$3,
  /* of_value */of_value$3
];

exports.type_of          = type_of;
exports.default_value    = default_value;
exports.value_of_bool    = value_of_bool;
exports.string_of_value  = string_of_value;
exports.string_of_values = string_of_values;
exports.Value            = Value;
exports.I32Value         = I32Value;
exports.I64Value         = I64Value;
exports.F32Value         = F32Value;
exports.F64Value         = F64Value;
/* F32 Not a pure module */
//////// end of values.js ////////
    return exports;
  };


  _registry['wasm'] = function() {
    let exports = {};
//////// start of wasm.js ////////
// Generated by BUCKLESCRIPT VERSION 1.4.3 , PLEASE EDIT WITH CARE
'use strict';

var Parse      = require("./parse");
var Sexpr      = require("./sexpr");
var Decode     = require("./decode");
var Encode     = require("./encode");
var Arrange    = require("./arrange");
var Caml_int64 = require("bs-platform/lib/js/caml_int64");
var Pervasives = require("bs-platform/lib/js/pervasives");

function encode(s) {
  var def = Parse.string_to_module(s);
  var match = def[/* it */1];
  if (match.tag) {
    return match[1];
  }
  else {
    return Encode.encode(match[0]);
  }
}

function decode(s, width) {
  var m = Decode.decode("(decode)", s);
  return Sexpr.to_string(width, Arrange.module_(m));
}

function f(x) {
  Pervasives.print_string("f");
  return x;
}

function g(x) {
  return Caml_int64.or_(x, (Pervasives.print_string("f"), x));
}

exports.encode = encode;
exports.decode = decode;
exports.f      = f;
exports.g      = g;
/* Parse Not a pure module */
//////// end of wasm.js ////////
    return exports;
  };


  function binary(bytes) {
    let buffer = new ArrayBuffer(bytes.length);
    let view = new Uint8Array(buffer);
    for (let i = 0; i < bytes.length; ++i) {
      view[i] = bytes.charCodeAt(i);
    }
    return buffer;
  }
  function bytes(buffer) {
    let string = '';
    let view = new Uint8Array(buffer);
    for (let i = 0; i < view.length; ++i) {
      string += String.fromCodePoint(view[i]);
    }
    return string;
  }
  let Wasm = require('wasm');
  return {
    encode(s) { return binary(Wasm.encode(s)) },
    decode(b, w = 80) { return Wasm.decode(bytes(b), w) }
  };
})();


