/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#include <iostream>

#include "GeopExaminer.h"
#include "Metview.h"
#include "MvQService.h"
#include "MvQServiceApplication.h"

using namespace std;

// Globals
int          ac;
char       **av;

class Base : public MvQService
{
protected:
	Base(char* a) : MvQService(a) {};
};

class MvGeopExaminer : public Base
{	
public:
	MvGeopExaminer() : Base("GEOPOINTS") {};
	void serve(MvRequest&,MvRequest&);
};

void MvGeopExaminer::serve( MvRequest& in, MvRequest& )
{
cout << "--------------GeopExaminer::serve()--------------" << endl;
in.print();

	//Create the qt application
	MvQServiceApplication app(ac, av);

	//Initialise resorces from a static library (libMvQtGui)
	Q_INIT_RESOURCE(examiner);
	Q_INIT_RESOURCE(window);
	Q_INIT_RESOURCE(find);

	// Get Geopoints file name
	const char* name = in("PATH");

	//Create the geopoints browser, initialize it and show it
	GeopExaminer *browser = new GeopExaminer;
	browser->initMetaData(name);
	browser->show();

	//Listen to the mars event loop!
	setupSocketNotifier();

    // Send message to Desktop (but not to MvExamineManager)
    // to turn the icon green; otherwise, it will stay orange.
    if( strcmp( getenv("METVIEW_MODE"), "examine" ) != 0 )
    {
        acknowledgeGuiStartup();
    }

	//Enter the app loop
	app.exec();
}

int main( int argc, char **argv )
{
	ac = argc;
	av = argv;
	
	MvApplication theApp( argc, argv );

	MvGeopExaminer geo;
	
	theApp.run();
}
