/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QDebug>
#include <QSocketNotifier>

#include "MvQService.h"

MvQService::MvQService(const char* name) : 
	MvService(name)
{
}

MvQService::~MvQService()
{
}


void MvQService::setupSocketNotifier()
{
	// Create socket notifier
	// The dataReceived function will be called everytime
	// there is data available in the socket
	QSocketNotifier *sn = new QSocketNotifier( Id->s->soc, QSocketNotifier::Read);
	QObject::connect(sn, SIGNAL(activated(int)),
					this, SLOT(slotDataReceived(int)));
								
}  

void MvQService::slotDataReceived(int)
{
	//Process data from the socket
	process_service(Id->s);
}

