/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef CHARTP_H
#define CHARTP_H

#include <Xm/XmP.h>
#if (XmVersion >= 1002)
#include <Xm/PrimitiveP.h>
#endif

#include <gpixmap.h>

/*
** Auxiliary struct
*/

typedef struct _ChartPointerList
{

	Widget widget;
	struct _ChartPointerList *next;
} ChartPointerList;

/*
** Class Part
*/

/*
** Class Part
*/

typedef struct _ChartClassPart 
{
	struct _ChartPointerList *active_ws;
} ChartClassPart;

typedef struct _ChartClassRec
{
	CoreClassPart		core_class;
	XmPrimitiveClassPart	primitive_class;
	ChartClassPart		chart_class;
} ChartClassRec;

extern ChartClassRec chartClassRec;

/*
** Instance Part
*/

typedef struct _ChartPart
{
	int            worldx,		/* GKS world coord	*/
	               worldy;

	int            user_input;	/* input type		*/
	int            input;		/* input type		*/

	int            npoints;		/* number of input pts	*/

	XPoint         point[2];	/* list of points	*/
	XPoint         limit[2];	/* surrounding rectangle*/

	XtCallbackList exposecallback;
	XtCallbackList movecallback;
	XtCallbackList resizecallback;
	XtCallbackList dblcallback;
	XtCallbackList inputcallback;
	XtCallbackList sendcallback;
	XtCallbackList answercallback;

	Boolean        backing_store;
	Dimension      backst_width, backst_height;
	Boolean        keep_aratio;

	/* Private resources */
	
	int            empty;           /* TEMPO */
	
	GksPixmap*     gpixmap;         /* Gks Pixmap works	*/

	GC             gc_xor;          /* graphics context	*/
	GC             gc_copy;	        /* graphics context     */

	int            zoomed;          /* indicate if the window
	                                   was zoomed or not    */
	int            modif_input;     /* flag to indicated if
	                                   input is currently
	                                   being modified       */
	float          x0,y0,x1,y1;     /* zoom viewport	*/
	int            input_visible;   /* indicate if the echo
	                                   is visible or not	*/
	int            resized;         /* indicate for the
	                                   next expose method
	                                   if the window has
	                                   been resized		*/
	int            init;            /* indicate the
	                                   expose method to
	                                   initialize works	*/

	int            key;             /* indicate if any modifier
	                                   key was used         */
} ChartPart;

typedef struct _ChartRec
{
	CorePart	core;
	XmPrimitivePart	primitive;
	ChartPart	chart;
} ChartRec;

#endif
