/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QtGui>

#include "VerbFunctionHelp.h"


VerbFunctionHelp::VerbFunctionHelp(QString &path)
{

    // load up the XML file containing the Verb function/parameter/values details

//    QString xmlParamFilename = "/home/graphics/cgi/metview/Tests/Macro Editor/Verb-param-help/params.xml";

    QFile file(path);

    if (!file.open(QFile::ReadOnly | QFile::Text))  // try to open in read-only mode
    {
        QString app("App");
        //QMessageBox::warning(0, app, path);
        QMessageBox::warning(0, QObject::tr("Verb Function Help"),
                             QObject::tr("Cannot read file %1:\n%2.\nThe editor will still work, but some help functions will be disabled.\n"
                             "Please report this error message to your Metview administrator.")
                             .arg(path)
                             .arg(file.errorString()));
        return;
    }


    // create a new XML reader object to read the file

    QXmlStreamReader reader(&file);


     VerbFunctionHelpFunction *function = NULL;

     while (!reader.atEnd())
     {
         reader.readNext();

         if (reader.isStartElement())
         {
            QString functionName;
            QString paramName;
            QString values;
            VerbFunctionHelpParam *param = NULL;

            if (reader.name() == "function")
            {
                // if we're starting the second or subsequent function, then store the previous one
                
                if (function != NULL)
                {
                    addFunction (function);
                }

                //title = reader.readElementText();
                function = new VerbFunctionHelpFunction;
                functionName = reader.attributes().value("name").toString();
//                qDebug() << functionName;
                function->setName(functionName);

                //QTreeWidgetItem *item;

                //item = new QTreeWidgetItem(paramTree);  // create a new item for the tree
                //item->setText (0, functionName);        // set its label

            }
            else if(reader.name() == "param")
            {
                param = new VerbFunctionHelpParam;
                paramName = reader.attributes().value("name").toString();
                param->setName(paramName);
                
                values = reader.attributes().value("values").toString();

                if (!values.isEmpty())
                {
                    QStringList valueList = values.split("/");


                    for (int i = 0; i < valueList.size(); ++i)
                    {
                        param->addValue(new QString (valueList.at(i)));
                    }
                }
                
                function->addParameter(param);


//                qDebug() << "  " << paramName;
//                qDebug() << "    " << values;

                //links.append(reader.attributes().value("href").toString());
//            else if(reader.name() == "p")
//                ++paragraphCount;
            }
        }
    }
    

    // store the last function

    if (function != NULL)
    {
        addFunction (function);
    }


    // check for parsing errors

    if (reader.hasError())
    {
        qDebug() << "  The HTML file isn't well-formed: " << reader.errorString()
                 << endl << endl << endl;
        return;
    }

//    helpForFunction(fun);
}



bool VerbFunctionHelp::isHelpAvailableForFunction(const QString &function)
{
    // can we find the given function name in the map?
    
    VerbFunctionHelpFunction *foundFunction = functions[function];

    return (foundFunction != NULL);
}




