/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQRequestPanelWidget.h"

#include <QDebug>
#include <QDropEvent>
#include <QGridLayout>
#include <QPainter>
#include <QPalette>

#include "MvQIconMimeData.h"
#include "MvQTheme.h"

#include "IconClass.h"
#include "IconObject.h"

QBrush MvQRequestPanelWidget::bgBrushLeft_=Qt::red;
QBrush MvQRequestPanelWidget::bgBrushRight_;
QPen  MvQRequestPanelWidget::linePenHorizontal_;
QPen  MvQRequestPanelWidget::linePenVertical_;
QPen MvQRequestPanelWidget::linePenReset_;
	
MvQRequestPanelWidget::MvQRequestPanelWidget(const vector<string>& cls,QWidget* parent) : 
     QWidget(parent),
     classes_(cls)
{
	if(bgBrushLeft_.color() == Qt::red)
	{
	  	bgBrushLeft_=MvQTheme::brush("editor","line_item_brush_left");
	  	bgBrushRight_=MvQTheme::brush("editor","line_item_brush_right");
		linePenHorizontal_=QPen(MvQTheme::colour("editor","line_item_pen_horizontal"));
		linePenVertical_=QPen(MvQTheme::colour("editor","line_item_pen_vertical"));
		linePenReset_=MvQTheme::colour("editor","line_item_pen_reset");
	}
	setAcceptDrops(true);

}

void MvQRequestPanelWidget::paintEvent(QPaintEvent* event)
{
	QPainter painter(this);

	//paint bg
	QPalette pal=palette();	
	painter.fillRect(0, 0, this->width(), this->height(),pal.color(QPalette::Window));
	
	QGridLayout *grid=static_cast<QGridLayout*>(layout());
	if(!grid)
	{  
		QWidget::paintEvent(event);
		return;
	}
	
	painter.setPen(linePenHorizontal_);
	
	//int yPos=0;	
	int spacingV=grid->verticalSpacing();		
	int spacingH=grid->horizontalSpacing();
	
	int lastY=0;
	
	for(int i=0; i < grid->rowCount(); i++)
	{		
		QLayoutItem* item = grid->itemAtPosition(i,3);				
		if(item)
		{  
			QWidget* w=item->widget();
			if(w && w->isVisible())			
			{			  		  
		  		QRect r=item->geometry();
				
				int h=r.height()+spacingV;
				int y=r.y()-spacingV/2;
				
				//Left side
				painter.fillRect(0, y,r.x()-spacingH/2, h,bgBrushLeft_);
				
				//Right side
				painter.fillRect(r.x()-spacingH/2, y,
						 this->width()-r.x()+spacingH/2, h,bgBrushRight_);
				
				//Horizontal line
				painter.drawLine(0, y,this->width(),y);	
				
				lastY=y+h;
			}  
			
		}			
	}
	
	//Th last Horizontal line
	painter.drawLine(0, lastY,this->width(),lastY);	
	
	
	//Vertical lines
	if(grid->rowCount()>1)
	{  			
		QLayoutItem* item=grid->itemAtPosition(1,3);		
		if(item)
		{  		
			painter.setPen(linePenVertical_);
			QRect r=item->geometry();			
			painter.drawLine(r.x()-spacingH/2,0,r.x()-spacingH/2,this->height());
		}
	}	
	
	//Frame
	painter.setPen(Qt::black);
	painter.drawRect(0, 0, this->width(), this->height());
	
//QWidget::paintEvent(event); 
 
}

bool MvQRequestPanelWidget::isAccepted(const IconClass& kind) const
{
  	if(classes_.size()>0)
	{
  		for(vector<string>::const_iterator it =  classes_.begin(); it != classes_.end(); ++it)
		{	
			if(kind.canBecome(IconClass::find(*it)) )   
				return true;			
		}
		return false;
	}	
		
	return true;
}

//===========================
// Drop from the new Desktop
//===========================

void MvQRequestPanelWidget::dragEnterEvent(QDragEnterEvent *event)
{
        if((event->proposedAction() == Qt::CopyAction ||
            event->proposedAction() == Qt::MoveAction))
        {
                event->accept();
        }
}

void MvQRequestPanelWidget::dragMoveEvent(QDragMoveEvent *event)
{
        if((event->proposedAction() == Qt::CopyAction ||
            event->proposedAction() == Qt::MoveAction))
        {           
                event->accept();
        }
}

void MvQRequestPanelWidget::dropEvent(QDropEvent *event)
{
  	if(event->proposedAction() != Qt::CopyAction &&
           event->proposedAction() != Qt::MoveAction)
	{
	  	event->ignore();
		return;
	}	
   
      	if(event->mimeData()->hasFormat("metview/icon"))
        {                  
                const MvQIconMimeData* mimeData=qobject_cast<const MvQIconMimeData*>(event->mimeData());
				
		if(!mimeData)
		{
			event->ignore();
			return;
		}
		
		IconObject *obj=mimeData->dragObject();
		
		if(!obj || !isAccepted(obj->iconClass()))
		{
			event->ignore();
			return;
		}
			
		emit iconDropped(obj);
		
		event->accept();
		return;
        }
        
        event->ignore();
}




