// license:BSD-3-Clause
// copyright-holders:Ryan Holtz

//
// Netlist for Star Cruiser
//
// Derived from the schematics in the Star Cruiser manual.
//
// Known problems/issues:
//
//    * Uses HLE noise due to abusing a 2N4124 in breakdown as a noise source.
//

#include "netlist/devices/net_lib.h"

//
// Main netlist
//

NETLIST_START(starcrus)

	SOLVER(Solver, 48000)
	ANALOG_INPUT(V12, 12)
	ANALOG_INPUT(V5, 5)
	ANALOG_INPUT(VM5, -5)
	ALIAS(VCC, V5)

	TTL_INPUT(EXPLODE_1, 1) // active low
	TTL_INPUT(EXPLODE_2, 1) // active low
	TTL_INPUT(LAUNCH_1, 1)  // active low
	TTL_INPUT(LAUNCH_2, 1)  // active low
	TTL_INPUT(ENGINE_1, 1)  // active low
	TTL_INPUT(ENGINE_2, 1)  // active low

	NET_C(GND, EXPLODE_1.GND, EXPLODE_2.GND, LAUNCH_1.GND, LAUNCH_2.GND, ENGINE_1.GND, ENGINE_2.GND)
	NET_C(V5, EXPLODE_1.VCC, EXPLODE_2.VCC, LAUNCH_1.VCC, LAUNCH_2.VCC, ENGINE_1.VCC, ENGINE_2.VCC)

	RES(R22, 470)
	POT(R23, RES_K(2.5))
	RES(R24, RES_K(10))
	RES(R25, RES_K(15))
	RES(R26, RES_K(2.2))
	RES(R28, RES_K(100))
	RES(R29, RES_K(220))
	RES(R30, RES_K(220))
	RES(R31, RES_K(470))
	RES(R32, RES_K(100))
	RES(R33, RES_K(2.2))
	RES(R34, RES_K(2.2))
	RES(R35, RES_K(2.2))
	RES(R36, RES_K(2.2))
	RES(R37, 220)
	RES(R38, RES_K(10))
	RES(R39, RES_K(10))
	RES(R40, RES_K(56))
	RES(R41, RES_K(100))
	RES(R42, RES_K(1))
	RES(R43, RES_K(100))
	RES(R44, RES_K(2.2))
	RES(R45, RES_K(2.2))
	RES(R46, RES_K(10))
	RES(R47, RES_K(3))
	RES(R48, RES_K(10))
	RES(R49, 220)
	RES(R50, RES_K(150))
	RES(R51, RES_K(10))
	RES(R52, RES_K(10))
	RES(R53, RES_K(2.2))
	RES(R54, RES_K(10))
	RES(R55, 220)
	RES(R56, RES_K(2.2))
	RES(R57, RES_K(2.2))
	RES(R58, RES_K(2.2))
	RES(R59, RES_K(10))
	RES(R60, RES_K(3))
	RES(R61, RES_K(10))
	RES(R62, 220)
	RES(R63, RES_K(150))
	RES(R64, RES_K(10))
	RES(R65, RES_K(10))
	RES(R66, RES_K(2.2))
	RES(R67, RES_K(10))
	RES(R68, 220)
	RES(R69, RES_K(2.2))
	RES(R70, RES_K(47))
	RES(R71, RES_K(100))
	RES(R72, RES_K(6.8))
	RES(R73, RES_K(6.8))
	RES(R74, RES_K(3.3))
	POT(R75, RES_K(50))
	RES(R76, RES_K(22))
	RES(R77, 470)

	CAP(C12, CAP_U(0.1))
	//CAP(C13, CAP_U(3.3))
	CAP(C14, CAP_U(0.1))
	CAP(C16, CAP_U(1.0))
	CAP(C17, CAP_U(0.47))
	CAP(C18, CAP_U(39))
	CAP(C19, CAP_U(4.7))
	CAP(C20, CAP_U(22))
	CAP(C21, CAP_U(0.15))
	CAP(C22, CAP_U(0.047))
	CAP(C23, CAP_U(1.0))
	CAP(C24, CAP_U(22))
	CAP(C25, CAP_U(0.15))
	CAP(C26, CAP_U(0.047))
	CAP(C27, CAP_U(1.0))
	CAP(C28, CAP_P(470))
	CAP(C29, CAP_U(4.7))
	CAP(C30, CAP_U(4.7))
	CAP(C31, CAP_U(4.7))
	CAP(C32, CAP_U(0.1))

	QBJT_EB(Q6, "2N4124")
	//QBJT_EB(Q7, "2N4124")
	QBJT_EB(Q8, "2N4124")
	QBJT_EB(Q9, "2N4124")
	QBJT_EB(Q10, "2N4126")
	QBJT_EB(Q11, "2N4124")
	QBJT_EB(Q12, "2N4124")
	QBJT_EB(Q13, "2N4124")
	QBJT_EB(Q14, "2N4124")
	QBJT_EB(Q15, "2N4126")
	QBJT_EB(Q16, "2N4124")
	QBJT_EB(Q17, "2N4124")
	QBJT_EB(Q18, "2N4124")
	QBJT_EB(Q19, "2N4126")
	QBJT_EB(Q20, "2N4124")
	QBJT_EB(Q21, "2N4124")

	UA741_DIP8(U1)
	UA741_DIP8(U2)
	UA741_DIP8(U5)

	NE566_DIP(U3)
	NE566_DIP(U4)

	DIODE(CR29, "1N4154")
	DIODE(CR30, "1N4154")
	DIODE(CR31, "1N4154")
	DIODE(CR32, "1N4154")

	TTL_7408_DIP(H6)
	NET_C(H6.7, GND)
	NET_C(H6.14, V5)
	NET_C(ENGINE_1, H6.9)
	NET_C(ENGINE_2, H6.10)
	NET_C(EXPLODE_1, H6.4)
	NET_C(EXPLODE_2, H6.5)
	NET_C(LAUNCH_1, H6.1, H6.2)
	NET_C(LAUNCH_2, H6.12, H6.13)

	TTL_7404_INVERT(F8)
	NET_C(F8.GND, GND)
	NET_C(F8.VCC, V5)
	NET_C(H6.6, F8.A)

	// HLE Noise Gen
	CLOCK(NOISE_CLOCK, 10000)
	NET_C(NOISE_CLOCK.GND, GND)
	NET_C(NOISE_CLOCK.VCC, V5)

	SYS_NOISE_MT_N(NOISE, 0.05)
	NET_C(NOISE.I, NOISE_CLOCK.Q)
	NET_C(NOISE.1, R24.2)
	NET_C(NOISE.2, Q6.B)

	// Engine Sound
	NET_C(H6.8, R26.1)
	NET_C(R26.2, Q8.B)
	NET_C(Q8.E, GND)
	NET_C(Q8.C, R25.1, R70.1)
	NET_C(R25.2, C14.1)
	NET_C(C14.2, R23.2, C12.1)
	NET_C(R23.1, R22.1)
	NET_C(R22.2, V12)
	NET_C(R23.3, R24.1, Q6.C)
	//NET_C(R24.2, Q7.E, C13.1)
	//NET_C(C13.2, GND)
	//NET_C(Q7.B, Q7.C, Q6.B)
	NET_C(Q6.E, GND)
	NET_C(C12.2, U2.3, R28.1)
	NET_C(R28.2, GND)
	NET_C(U2.7, V5)
	NET_C(U2.4, VM5)
	NET_C(U2.2, R29.1)
	NET_C(R29.2, C16.1, R30.1)
	NET_C(C16.2, GND)
	NET_C(R30.2, U2.6, R31.1)
	NET_C(R31.2, C17.1, Q12.C, R32.1, U1.3)
	NET_C(C17.2, GND)
	NET_C(R32.2, GND)
	NET_C(U1.7, V5)
	NET_C(U1.4, VM5)
	NET_C(U1.2, R43.1, R42.1)
	NET_C(R43.2, U1.6, R71.1)
	NET_C(R42.2, C19.1)
	NET_C(C19.2, Q13.C)
	NET_C(Q13.E, GND)
	NET_C(Q13.B, R41.1, R40.1)
	NET_C(R41.2, GND)
	NET_C(R40.2, C18.1, R38.1, R37.1)
	NET_C(C18.2, GND)
	NET_C(R38.2, Q11.B)
	NET_C(Q11.E, GND)
	NET_C(Q12.E, GND)
	NET_C(Q11.C, R39.1, Q12.B)
	NET_C(R39.2, V5)
	NET_C(R37.2, Q10.C)
	NET_C(Q10.E, R35.1, V5)
	NET_C(R35.2, Q10.B, R36.1)
	NET_C(R36.2, Q9.C)
	NET_C(Q9.E, GND)
	NET_C(Q9.B, R34.1)
	NET_C(R34.2, R33.1, F8.Q)
	NET_C(R33.2, V5)

	// Launch Sound 1
	NET_C(H6.3, R44.1)
	NET_C(R44.2, Q14.B)
	NET_C(Q14.E, GND)
	NET_C(Q14.C, R46.1)
	NET_C(R46.2, Q15.B)
	NET_C(R46.2, R45.1)
	NET_C(R45.2, R47.1)
	NET_C(R45.2, Q15.E)
	NET_C(R47.2, R48.1)
	NET_C(R48.2, GND)
	NET_C(R48.1, Q16.B)
	NET_C(Q15.C, CR29.A)
	NET_C(CR29.K, R49.1)
	NET_C(R49.2, Q16.C)
	NET_C(Q16.E, R50.1)
	NET_C(R50.2, GND)
	NET_C(Q15.E, R51.1)
	NET_C(Q15.E, V12)
	NET_C(Q15.E, U3.8)
	NET_C(R51.2, U3.6)
	NET_C(Q16.C, C20.1)
	NET_C(C20.2, GND)
	NET_C(C20.1, U3.5)
	NET_C(U3.1, GND)
	NET_C(U3.7, C21.1)
	NET_C(C21.2, GND)
	NET_C(U3.3, C22.1)
	NET_C(C22.2, R52.1)
	NET_C(R52.2, GND)
	NET_C(R52.1, CR30.A)
	NET_C(CR30.K, R53.1)
	NET_C(R53.2, Q17.C)
	NET_C(Q17.E, GND)
	NET_C(Q17.B, R56.1)
	NET_C(R56.2, R44.1)
	NET_C(Q17.C, R54.1)
	NET_C(R54.2, R55.1)
	NET_C(R55.2, GND)
	NET_C(R55.1, C23.1)
	NET_C(C23.2, GND)
	NET_C(C23.1, R72.1)

	// Launch Sound 2
	NET_C(H6.11, R57.1)
	NET_C(R57.2, Q18.B)
	NET_C(Q18.E, GND)
	NET_C(Q18.C, R59.1)
	NET_C(R59.2, Q19.B)
	NET_C(R59.2, R58.1)
	NET_C(R58.2, R60.1)
	NET_C(R58.2, Q19.E)
	NET_C(R60.2, R61.1)
	NET_C(R61.2, GND)
	NET_C(R61.1, Q20.B)
	NET_C(Q19.C, CR31.A)
	NET_C(CR31.K, R62.1)
	NET_C(R62.2, Q20.C)
	NET_C(Q20.E, R63.1)
	NET_C(R63.2, GND)
	NET_C(Q19.E, R64.1)
	NET_C(Q19.E, V12)
	NET_C(Q19.E, U4.8)
	NET_C(R64.2, U4.6)
	NET_C(Q20.C, C24.1)
	NET_C(C24.2, GND)
	NET_C(C24.1, U4.5)
	NET_C(U4.1, GND)
	NET_C(U4.7, C25.1)
	NET_C(C25.2, GND)
	NET_C(U4.3, C26.1)
	NET_C(C26.2, R65.1)
	NET_C(R65.2, GND)
	NET_C(R65.1, CR32.A)
	NET_C(CR32.K, R66.1)
	NET_C(R66.2, Q21.C)
	NET_C(Q21.E, GND)
	NET_C(Q21.B, R69.1)
	NET_C(R69.2, R57.1)
	NET_C(Q21.C, R67.1)
	NET_C(R67.2, R68.1)
	NET_C(R68.2, GND)
	NET_C(R68.1, C27.1)
	NET_C(C27.2, GND)
	NET_C(C27.1, R73.1)

	NET_C(R70.2, R71.2, R72.2, R73.2, R74.1, U5.2, C28.1)

	NET_C(R74.2, R75.2, R75.3)
	NET_C(C28.2, R75.1, R77.1, U5.6)
	NET_C(C29.1, U5.7, V5)
	NET_C(C29.2, GND)
	NET_C(U5.3, C31.1, R76.1)
	NET_C(C31.2, GND)
	NET_C(R76.2, GND)
	NET_C(U5.4, C30.1, VM5)
	NET_C(C30.2, GND)
	NET_C(R77.2, C32.1)
	NET_C(C32.2, GND)

	// Separate each input into the summing network
	OPTIMIZE_FRONTIER(R70.1, RES_M(1), 50)
	OPTIMIZE_FRONTIER(R71.1, RES_M(1), 50)
	OPTIMIZE_FRONTIER(R72.1, RES_M(1), 50)
	OPTIMIZE_FRONTIER(R73.1, RES_M(1), 50)

NETLIST_END()
