#!/usr/bin/perl

# this program reads the POD documentation out of libwhisker and
# makes a structured HTML page

$|++;

@output=();
@subpackages=();
@functions=();

while(<>){
	next if(m/^#################/);
	my $t='';
	if(m/^=head1 \+\+ Sub package: (.+)/){
		($sp=$1)=~tr/ \r\n//d;
		push @subpackages,$sp;
		$t="<p><h3><a name=\"sp-$sp\">Sub package: $sp</a></h3><p>\n";

	} elsif(m/^=head1 - Function: (.+)/){
		($fn=$1)=~tr/ \r\n//d;
		$fn=~s/^LW:://; $int=0;
		$T='';
		$int=1 if($fn=~/\(INTERNAL\)/);
		push(@functions, $fn) if(!$int);
		$T="<p><li><b><a name=\"fn-$fn\">$fn</a></b><br>\n";
		my ($l,$p,$r)=('','','');
		do {
			($l=<>)=~tr/\r\n//d;
			$p=$1 if($l=~/Params: (.+)$/);
			$r=$1 if($l=~/Return: (.+)$/);
		} while($l=~/^[ \t]*$/ || $l=~m/(Params|Return):/);

		$T.="<font size=\"-1\"><i>Parameters: $p</i></font><br>\n";
		$T.="<font size=\"-1\"><i>Return values: $r</i></font><p>\n";
	
		$l.="\n";
		while($l!~/^=cut/){
			$l=~s/&/&amp;/g;
			$l=~s/</&lt;/g; $l=~s/>/&gt;/g;
			$l.='<p>' if($l=~m/^[\r\n]+$/);
			$T.=$l;
			$l=<>;
		} 

		if(!$int){ $t.=$T; }
	}

	push @output, $t;
}

print "<html><body><font face=\"verdana,arial,helvetica,sans-serif\">\n";

my $font='<font face="verdana,arial,helvetica,sans-serif" size="-1">';

print "<p><h2>Functions:</h2>\n";

print "<table width=90% cellpadding=1 cellspacing=1 border=0>\n";
$FLIP=0;
foreach $fn (@functions){
	if($FLIP==0){
		print "<tr><td>$font<a href=\"#fn-$fn\">$fn</a></td>\n";
		$FLIP++;
	} elsif($FLIP==1){
		print "<td>$font<a href=\"#fn-$fn\">$fn</a></td>\n";
		$FLIP++;
	} else {
		print "<td>$font<a href=\"#fn-$fn\">$fn</a></td></tr>\n";
		$FLIP=0;
	}
}
print "<td>&nbsp;</td>\n" if($FLIP++==1);
print "<td>&nbsp;</td></tr>\n" if($FLIP==2);

print "</table>\n";

print "<p>&nbsp;<p>", @output, "<p>\n";