#GPL
#GPL  libwhisker copyright 2000,2001,2002 by rfp.labs
#GPL
#GPL  This program is free software; you can redistribute it and/or
#GPL  modify it under the terms of the GNU General Public License
#GPL  as published by the Free Software Foundation; either version 2
#GPL  of the License, or (at your option) any later version.
#GPL
#GPL  This program is distributed in the hope that it will be useful,
#GPL  but WITHOUT ANY WARRANTY; without even the implied warranty of
#GPL  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GPL  GNU General Public License for more details.
#GPL

=pod

=head1 ++ Sub package: dump

The dump subpackage contains various utility functions which emulate
the basic functionality provided by Data::Dumper.

=cut

########################################################################

=pod

=head1 - Function: LW::dumper
  
Params: $name, \@array [, $name, \%hash, $name, \$scalar ]
Return: $code, 'ERROR' on error

The dumper function will take the given $name and data reference, and
will create an ASCII perl code representation suitable for eval'ing
later to recreate the same structure.  $name is the name of the variable
that it will be saved as.  Example:

	$output = LW::dumper('hin',\%hin);

=cut

sub dumper {
	my %what=@_;
	my ($final,$k,$v)=('');
	while( ($k,$v)=each %what){
		return 'ERROR' if(ref($k) || !ref($v));
		$final.="\$$k = "._dump(1,$v);
		$final=~s#,\n$##;
		$final.=";\n"; }
	return $final;
}

########################################################################

=pod

=head1 - Function: LW::dumper_writefile
  
Params: $file, $name, \@array [, $name, \%hash, $name, \@scalar ]
Return: 0 if success; 1 if error

This calls dumper() and saves the output to the specified $file.  

Note: LW does not checking on the validity of the file name, it's
creation, or anything of the sort.  Files are opened in overwrite
mode.

=cut

sub dumper_writefile {
	my $file=shift;
	my $output=dumper(@_);
	return 1 if(!open(OUT,">$file") || $output eq 'ERROR');
	print OUT $output;
	close(OUT);
}

########################################################################

=pod

=head1 - Function: LW::_dump (INTERNAL)
   
Params: $tabs, $ref
Return: $output

This is an internal function to dumper() which will dereference all
elements and produce the resulting code.

This function is not intended for external use.

=cut

sub _dump { # dereference and dump an element
	my ($t, $ref)=@_;
	my ($out,$k,$v)=('');
	if(ref($ref) eq 'HASH'){
		$out.="{\n";
		while( ($k,$v)=each %$ref){
			$out.= "\t"x$t;
			$out.=_dumpd($k).' => ';
			if(ref($v)){ $out.=_dump($t+1,$v); }
			else { $out.=_dumpd($v).",\n"; }}
		$out=~s#,\n$#\n#;
		$out.="\t"x$t;
		$out.="},\n";
	} elsif(ref($ref) eq 'ARRAY'){
		$out.="[\n";
		foreach $v (@$ref) {
			$out.= "\t"x$t;
			if(ref($v)){ $out.=_dump($t+1,$v); }
			else { $out.=_dumpd($v).",\n"; }}
		$out=~s#,\n$#\n#;
		$out.="\t"x$t;
		$out.="],\n";
	} elsif(ref($ref) eq 'SCALAR'){
		$out.=_dumpd($$ref);
	} elsif(ref($ref) eq 'REF'){
		$out.=_dump($t,$$ref);
	} elsif(ref($ref)){
		$out.='"" # unsupported reference type: ';
		$out.=ref($ref);	$out.="\n";
	} else { # normal scalar
		$out.=_dumpd($ref);
	}
	return $out;
}

########################################################################

=pod

=head1 - Function: LW::_dumpd (INTERNAL)
   
Params: $string
Return: $escaped_string

This is an internal function to dumper() which will escape the given
string to make it suitable for printing.

This function is not intended for external use.

=cut

sub _dumpd { # escape a scalar string
	my $v=shift;
	return "'$v'" if($v!~tr/!-~//c);
	$v=~s#\\#\\\\#g;	$v=~s#"#\\"#g;
	$v=~s#\r#\\r#g;		$v=~s#\n#\\n#g;
	$v=~s#\0#\\0#g;		$v=~s#\t#\\t#g;
	$v=~s#([^!-~])#sprintf('\\x%02x',ord($1))#eg;
	return "\"$v\"";
}

########################################################################