/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;


/**
  * Wrapper class for global methods and constants defined by libSBML.
  * <p>
  * <em style='color: #555'>
  * This class of objects is defined by libSBML only and has no direct
  * equivalent in terms of SBML components.  This class is not prescribed by
  * the SBML specifications, although it is used to implement features
  * defined in SBML.
  * </em>
  * <p>
  * In the C++ and C versions of libSBML, there exists a small number of
  * methods that are global in scope; in addition, libSBML uses a number
  * of enum's to define such things as error codes in a way that can be
  * used by both C++ and C.  This poses a problem in languages such as
  * Java, where there is no concept of global method or global constant.
  * SWIG wraps these global identifiers in the class whose documentation
  * you see before you.
  */
public class libsbml implements libsbmlConstants {

	
  /**
   * Downcast a package extension object to its specific package class.
   *
   * This method is used in the implementation of libSBML extensions to
   * support SBML Level&nbsp;3 packages.  It allows an object to be
   * downcast to the actual {@link SBMLExtension} object it is.
   *
   * @param cPtr the the pointer to the object
   * @param owner if <code>true</code>, it indicates the caller will "own"
   * the memory associated with the object and will be responsible for
   * freeing it.
   *
   * @return the {@link SBMLExtension} for the package
   *
   * @internal
   */
  public static SBMLExtension DowncastExtension(long cPtr, boolean owner)
  {		
    if (cPtr == 0) return null;
		
    SBMLExtension ext = new SBMLExtension(cPtr, false);
    String pkgName = ext.getName();


    return new SBMLExtension(cPtr,owner);
  }     
        
  /**
   * SBMLExtension derived classes must override this method
   * @internal
   */
  public static SBasePlugin DowncastSBasePlugin(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBasePlugin sbp = new SBasePlugin(cPtr,false);
    String pkgName = sbp.getPackageName();

    SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
    if (sbmlext != null)
    {
      return sbmlext.DowncastSBasePlugin(cPtr,owner);
    }
    return new SBasePlugin(cPtr,owner);
  }

  /**
   * @internal
   */
  public static SBMLNamespaces DowncastSBMLNamespaces(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;
                
    SBMLNamespaces sbn = new SBMLNamespaces(cPtr, false);
    if (sbn != null)
    {
      XMLNamespaces ns = sbn.getNamespaces();

                              
    }
    return new SBMLNamespaces(cPtr, owner);
  }     
  
  /**
   * Internal method.
   *
   * @internal
   */
  public static SBase DowncastSBase(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBase sb = new SBase(cPtr,false);
    String pkgName = sb.getPackageName();
    if (pkgName.equals("core"))
    {
      switch( sb.getTypeCode() )
      {
        case libsbmlConstants.SBML_COMPARTMENT:
          return new Compartment(cPtr, owner);
  
        case libsbmlConstants.SBML_COMPARTMENT_TYPE:
          return new CompartmentType(cPtr, owner);
  
        case libsbmlConstants.SBML_CONSTRAINT:
          return new Constraint(cPtr, owner);
  
        case libsbmlConstants.SBML_DOCUMENT:
          return new SBMLDocument(cPtr, owner);
  
        case libsbmlConstants.SBML_DELAY:
          return new Delay(cPtr, owner);
  
        case libsbmlConstants.SBML_EVENT:
          return new Event(cPtr, owner);

        case libsbmlConstants.SBML_EVENT_ASSIGNMENT:
          return new EventAssignment(cPtr, owner);

        case libsbmlConstants.SBML_FUNCTION_DEFINITION:
          return new FunctionDefinition(cPtr, owner);
  
        case libsbmlConstants.SBML_INITIAL_ASSIGNMENT:
          return new InitialAssignment(cPtr, owner);

        case libsbmlConstants.SBML_KINETIC_LAW:
          return new KineticLaw(cPtr, owner);

        case libsbmlConstants.SBML_LIST_OF:
          String name = sb.getElementName();
          if(name.equals("listOf")){
            return new ListOf(cPtr, owner);
          }
          else if(name.equals("listOfCompartments")){
            return new ListOfCompartments(cPtr, owner);
          }
          else if(name.equals("listOfCompartmentTypes")){
            return new ListOfCompartmentTypes(cPtr, owner);
          }
          else if(name.equals("listOfConstraints")){
            return new ListOfConstraints(cPtr, owner);
          }
          else if(name.equals("listOfEvents")){
            return new ListOfEvents(cPtr, owner);
          }
          else if(name.equals("listOfEventAssignments")){
            return new ListOfEventAssignments(cPtr, owner);
          }
          else if(name.equals("listOfFunctionDefinitions")){
            return new ListOfFunctionDefinitions(cPtr, owner);
          }
          else if(name.equals("listOfInitialAssignments")){
            return new ListOfInitialAssignments(cPtr, owner);
          }
          else if(name.equals("listOfParameters")){
            return new ListOfParameters(cPtr, owner);
          }
          else if(name.equals("listOfLocalParameters")){
            return new ListOfLocalParameters(cPtr, owner);
          }
          else if(name.equals("listOfReactions")){
            return new ListOfReactions(cPtr, owner);
          }
          else if(name.equals("listOfRules")){
            return new ListOfRules(cPtr, owner);
          }
          else if(name.equals("listOfSpecies")){
            return new ListOfSpecies(cPtr, owner);
          }
          else if(name.equals("listOfUnknowns")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfReactants")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfProducts")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfModifiers")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfSpeciesTypes")){
            return new ListOfSpeciesTypes(cPtr, owner);
          }
          else if(name.equals("listOfUnits")){
            return new ListOfUnits(cPtr, owner);
          }
          else if(name.equals("listOfUnitDefinitions")){
            return new ListOfUnitDefinitions(cPtr, owner);
          }
          return new ListOf(cPtr, owner);

        case libsbmlConstants.SBML_MODEL:
          return new Model(cPtr, owner);

        case libsbmlConstants.SBML_PARAMETER:
          return new Parameter(cPtr, owner);

      case libsbmlConstants.SBML_PRIORITY:
        return new Priority(cPtr, owner);

      case libsbmlConstants.SBML_LOCAL_PARAMETER:
        return new LocalParameter(cPtr, owner);

        case libsbmlConstants.SBML_REACTION:
          return new Reaction(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES:
          return new Species(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES_REFERENCE:
          return new SpeciesReference(cPtr, owner);

        case libsbmlConstants.SBML_MODIFIER_SPECIES_REFERENCE:
          return new ModifierSpeciesReference(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES_TYPE:
          return new SpeciesType(cPtr, owner);

        case libsbmlConstants.SBML_TRIGGER:
          return new Trigger(cPtr, owner);

        case libsbmlConstants.SBML_UNIT_DEFINITION:
          return new UnitDefinition(cPtr, owner);

        case libsbmlConstants.SBML_UNIT:
          return new Unit(cPtr, owner);

        case libsbmlConstants.SBML_ALGEBRAIC_RULE:
          return new AlgebraicRule(cPtr, owner);

        case libsbmlConstants.SBML_ASSIGNMENT_RULE:
          return new AssignmentRule(cPtr, owner);

        case libsbmlConstants.SBML_RATE_RULE:
          return new RateRule(cPtr, owner);

        case libsbmlConstants.SBML_STOICHIOMETRY_MATH:
          return new StoichiometryMath(cPtr, owner);

        default:
          return new SBase(cPtr, owner);
      }
    }
    else
    {
      SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
      if (sbmlext != null)
      {
        return sbmlext.DowncastSBase(cPtr,owner);
      }
    }
    return new SBase(cPtr, owner);
  }
  

 
  public static ASTBase DowncastASTBase(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    ASTBase ab = new ASTBase(cPtr,false);
	switch( ab.getTypeCode() )
    {
		default:
	    case libsbmlConstants.AST_TYPECODE_BASE:
          return new ASTBase(cPtr, owner);
		  /*
	    case libsbmlConstants.AST_TYPECODE_CN_BASE:
          return new ASTCnBase(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_BASE:
          return new ASTFunctionBase(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_NUMBER:
          return new ASTNumber(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CN_INTEGER:
          return new ASTCnIntegerNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CN_EXPONENTIAL:
          return new ASTCnExponentialNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CN_RATIONAL:
          return new ASTCnRationalNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CN_REAL:
          return new ASTCnRealNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CSYMBOL:
          return new ASTCSymbol(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CSYMBOL_AVOGADRO:
          return new ASTCSymbolAvogadroNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CSYMBOL_DELAY:
          return new ASTCSymbolDelayNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_CSYMBOL_TIME:
          return new ASTCSymbolTimeNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION:
          return new ASTFunction(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_UNARY:
          return new ASTUnaryFunctionNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_BINARY:
          return new ASTBinaryFunctionNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_NARY:
          return new ASTNaryFunctionNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_PIECEWISE:
          return new ASTPiecewiseFunctionNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_LAMBDA:
          return new ASTLambdaFunctionNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_CI:
          return new ASTCiFunctionNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_SEMANTIC:
          return new ASTSemanticsNode(cPtr, owner);
	    case libsbmlConstants.AST_TYPECODE_FUNCTION_QUALIFIER:
          return new ASTQualifierNode(cPtr, owner);*/
	    case libsbmlConstants.AST_TYPECODE_ASTNODE:
          return new ASTNode(cPtr, owner);

	}	
    //return new ASTBase(cPtr, owner);
  }
  


   static String getAbsolutePath(String filename)
   {
     java.io.File file = new java.io.File(filename);
     return file.getAbsolutePath();
   }


  /**
    * Stream handle for low-level C++ standard output stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (cout) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.cout);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    *
    * @see #cerr
    * @see #clog
    */
  public final static OStream cout;


  /**
    * Stream handle for low-level C++ standard error stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (cerr) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.cerr);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    * <p>
    * By default, most operating systems have have their standard error and
    * logging output streams directed to the console/terminal, and this is
    * where text messages will be shown.  This can usually be redirected
    * elsewhere, although how to do this depends on the specific environment
    * where the program is running.
    *
    * @see #cout
    * @see #clog
    */
  public final static OStream cerr;


  /**
    * Stream handle for low-level C++ standard logging stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (clog) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.clog);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    * <p>
    * By default, most operating systems have have their standard error and
    * logging output streams directed to the console/terminal, and this is
    * where text messages will be shown.  This can usually be redirected
    * elsewhere, although how to do this depends on the specific environment
    * where the program is running.
    *
    * @see #cout
    * @see #cerr
    */
  public final static OStream clog;

  static {
    cout = new OStream(OStream.COUT); 
    cerr = new OStream(OStream.CERR); 
    clog = new OStream(OStream.CLOG); 
  }

  /**
   * This private constructor does nothing and never invoked.
   * The purpose of this constuctor is to hide a default constructor of this 
   * class in javadoc documentation.
   */
  private libsbml() {}


  
/**
 * Returns the version number of this copy of libSBML as an integer.
 <p>
 * @return the libSBML version as an integer; version 1.2.3 becomes 10203.
 */ public
 static int getLibSBMLVersion() {
    return libsbmlJNI.getLibSBMLVersion();
  }

  
/**
 * Returns the version number of this copy of libSBML as a string.
 <p>
 * @return the libSBML version as a string; version 1.2.3 becomes
 * '1.2.3'.
 <p>
 * @see #getLibSBMLVersionString()
 */ public
 static String getLibSBMLDottedVersion() {
    return libsbmlJNI.getLibSBMLDottedVersion();
  }

  
/**
 * Returns the version number of this copy of libSBML as a string without
 * periods.
 <p>
 * @return the libSBML version as a string: version 1.2.3 becomes '10203'.
 <p>
 * @see #getLibSBMLDottedVersion()
 */ public
 static String getLibSBMLVersionString() {
    return libsbmlJNI.getLibSBMLVersionString();
  }

  
/**
 * Returns an indication whether libSBML has been compiled with
 * against a specific library. 
 <p>
 * @param option the library to test against, this can be one of
 *        'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'
 <p>
 * @return 0 in case the libSBML has not been compiled against 
 *         that library and non-zero otherwise (for libraries 
 *         that define an integer version number that number will 
 *         be returned).
 <p>
 * @see #getLibSBMLDependencyVersionOf(String option)
 */ public
 static int isLibSBMLCompiledWith(String option) {
    return libsbmlJNI.isLibSBMLCompiledWith(option);
  }

  
/**
 * Returns the version string for the dependency library used. 
 <p>
 * @param option the library for which the version
 *        should be retrieved, this can be one of
 *        'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'
 <p>
 * @return null in case libSBML has not been compiled against 
 *         that library and a version string otherwise.
 <p>
 * @see #isLibSBMLCompiledWith(String option)
 */ public
 static String getLibSBMLDependencyVersionOf(String option) {
    return libsbmlJNI.getLibSBMLDependencyVersionOf(option);
  }

  
/**
 * This method takes an SBML operation return value and returns a string representing
 * the code.
 <p>
 * @param returnValue the operation return value to convert to a string
 <p>
 * @return a human readable name for the given
 * operation return value .
 <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static String OperationReturnValue_toString(int returnValue) {
    return libsbmlJNI.OperationReturnValue_toString(returnValue);
  }

  
/**
 * Reads an SBML document from the given file <code>filename</code>.
 <p>
 * If <code>filename</code> does not exist, or it is not an SBML file, an error will
 * be logged in the error log of the {@link SBMLDocument} object returned by this
 * method.  Calling programs can inspect this error log to determine
 * the nature of the problem.  Please refer to the definition of
 * SBMLDocument_t for more information about the error reporting mechanism.
 <p>
 * <code>
 *   SBMLReader_t   *sr;

 *   SBMLDocument_t *d;
 <p>
 *   sr = SBMLReader_create();
 <p>
 *   d = SBMLReader_readSBML(reader, filename);
 <p>
 *   if (SBMLDocument_getNumErrors(d) > 0)

 *   {

 *     if (XMLError_getId(SBMLDocument_getError(d, 0))
 *                                           == SBML_READ_ERROR_FILE_NOT_FOUND)

 *     if (XMLError_getId(SBMLDocument_getError(d, 0))
 *                                           == SBML_READ_ERROR_NOT_SBML)

 *   }

 * </code>
 <p>
 * If the filename ends with @em .gz, the file will be read as a <em>gzip</em> file.
 * Similary, if the filename ends with @em .zip or @em .bz2, the file will be
 * read as a <em>zip</em> or <em>bzip2</em> file, respectively. Otherwise, the fill will be
 * read as an uncompressed file.
 * If the filename ends with @em .zip, only the first file in the archive will
 * be read if the zip archive contains two or more files.
 <p>
 * To read a gzip/zip file, underlying libSBML needs to be linked with zlib
 * at compile time. Also, underlying libSBML needs to be linked with bzip2 
 * to read a bzip2 file. File unreadable error will be logged if a compressed 
 * file name is given and underlying libSBML is not linked with the corresponding 
 * required library.
 * SBMLReader_hasZlib() and SBMLReader_hasBzip2() can be used to check 
 * whether libSBML is linked with each library.
 <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */ public
 static SBMLDocument readSBML(String filename) {
    long cPtr = libsbmlJNI.readSBML(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Reads an SBML document from the given file <code>filename</code>.
 <p>
 * If <code>filename</code> does not exist, or it is not an SBML file, an error will
 * be logged in the error log of the {@link SBMLDocument} object returned by this
 * method.  Calling programs can inspect this error log to determine
 * the nature of the problem.  Please refer to the definition of
 * SBMLDocument_t for more information about the error reporting mechanism.
 <p>
 <p>
 * <code>
 *   SBMLReader_t   *sr;

 *   SBMLDocument_t *d;
 <p>
 *   sr = SBMLReader_create();
 <p>
 *   d = SBMLReader_readSBML(reader, filename);
 <p>
 *   if (SBMLDocument_getNumErrors(d) > 0)

 *   {

 *     if (XMLError_getId(SBMLDocument_getError(d, 0))
 *                                           == SBML_READ_ERROR_FILE_NOT_FOUND)

 *     if (XMLError_getId(SBMLDocument_getError(d, 0))
 *                                           == SBML_READ_ERROR_NOT_SBML)

 *   }

 * </code>
 <p>
 * If the filename ends with @em .gz, the file will be read as a <em>gzip</em> file.
 * Similary, if the filename ends with @em .zip or @em .bz2, the file will be
 * read as a <em>zip</em> or <em>bzip2</em> file, respectively. Otherwise, the fill will be
 * read as an uncompressed file.
 * If the filename ends with @em .zip, only the first file in the archive will
 * be read if the zip archive contains two or more files.
 <p>
 * To read a gzip/zip file, underlying libSBML needs to be linked with zlib
 * at compile time. Also, underlying libSBML needs to be linked with bzip2 
 * to read a bzip2 file. File unreadable error will be logged if a compressed 
 * file name is given and underlying libSBML is not linked with the corresponding 
 * required library.
 * SBMLReader_hasZlib() and SBMLReader_hasBzip2() can be used to check 
 * whether libSBML is linked with each library.
 <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */ public
 static SBMLDocument readSBMLFromFile(String filename) {
    long cPtr = libsbmlJNI.readSBMLFromFile(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Reads an SBML document from the given XML string <code>xml</code>.
 <p>
 * If the string does not begin with XML declaration,
 *<div class='fragment'><pre class='fragment'>
&lt;?xml version='1.0' encoding='UTF-8'?&gt;
</pre></div>
 <p>
 * an XML declaration string will be prepended.
 <p>
 * This method will report an error if the given string <code>xml</code> is not SBML.
 * The error will be logged in the error log of the SBMLDocument_t structure
 * returned by this method.  Calling programs can inspect this error log to
 * determine the nature of the problem.  Please refer to the definition of
 * {@link SBMLDocument} for more information about the error reporting mechanism.
 <p>
 * @return a pointer to the SBMLDocument_t read.
 <p>
 * @note When using this method to read an {@link SBMLDocument} that uses 
 * the SBML L3 Hierarchical {@link Model} Composition package (comp) the
 * document location cannot be set automatically. Thus, if the model
 * contains references to ExternalModelDefinitions, it will be necessary
 * to manually set the document URI location (setLocationURI) in order 
 * to facilitate resolving these models.
 */ public
 static SBMLDocument readSBMLFromString(String xml) {
    long cPtr = libsbmlJNI.readSBMLFromString(xml);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Writes the given SBML document <code>d</code> to the file named by <code>filename</code>.
 * This convenience function is functionally equivalent to:
 <p>
 *   SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);
 <p>
 * If the given filename ends with the suffix <code>&quot;.gz&quot;</code>
(for example, <code>&quot;myfile.xml.gz&quot;</code>), libSBML assumes the
caller wants the file to be written compressed in <em>gzip</em> format.
Similarly, if the given filename ends with <code>&quot;.zip&quot;</code> or
<code>&quot;.bz2&quot;</code>, libSBML assumes the caller wants the file to
be compressed in <em>zip</em> or <em>bzip2</em> format (respectively).
Files whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given filename
ends with <code>&quot;.zip&quot;</code>, the file placed in the zip archive
will have the suffix <code>&quot;.xml&quot;</code> or
<code>&quot;.sbml&quot;</code>.  For example, the file in the zip archive
will be named <code>&quot;test.xml&quot;</code> if the given filename is
<code>&quot;test.xml.zip&quot;</code> or <code>&quot;test.zip&quot;</code>.
Similarly, the filename in the archive will be
<code>&quot;test.sbml&quot;</code> if the given filename is
<code>&quot;test.sbml.zip&quot;</code>.

 <p>
 * @param d the {@link SBMLDocument} object to be written out in XML format
 <p>
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 <p>
 * @return <code>1</code> on success and <code>0</code> (zero) if <code>filename</code> could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 <p>
 * @see SBMLWriter#hasZlib()
 * @see SBMLWriter#hasBzip2()
 */ public
 static int writeSBML(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBML(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * Writes the given SBML document <code>d</code> to an in-memory string and returns a
 * pointer to it.  The string is owned by the caller and should be freed
 * (with free()) when no longer needed.  This convenience function is
 * functionally equivalent to:
 <p>
 *   SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);
 <p>
 * but does not require the caller to create an {@link SBMLWriter} object first.
 <p>
 * @param d an {@link SBMLDocument} object to be written out in XML format
 <p>
 * @return the string on success and <code>null</code> if one of the underlying parser
 * components fail.
 */ public
 static String writeSBMLToString(SBMLDocument d) {
    return libsbmlJNI.writeSBMLToString(SBMLDocument.getCPtr(d), d);
  }

  
/**
 * Writes the given SBML document <code>d</code> to the file <code>filename</code>.
 * This convenience function is functionally equivalent to:
 <p>
 *   SBMLWriter_writeSBMLToFile(SBMLWriter_create(), d, filename);
 <p>
 * but that does not require the caller to create an {@link SBMLWriter} object first.
 <p>
 * If the given filename ends with the suffix <code>&quot;.gz&quot;</code>
(for example, <code>&quot;myfile.xml.gz&quot;</code>), libSBML assumes the
caller wants the file to be written compressed in <em>gzip</em> format.
Similarly, if the given filename ends with <code>&quot;.zip&quot;</code> or
<code>&quot;.bz2&quot;</code>, libSBML assumes the caller wants the file to
be compressed in <em>zip</em> or <em>bzip2</em> format (respectively).
Files whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given filename
ends with <code>&quot;.zip&quot;</code>, the file placed in the zip archive
will have the suffix <code>&quot;.xml&quot;</code> or
<code>&quot;.sbml&quot;</code>.  For example, the file in the zip archive
will be named <code>&quot;test.xml&quot;</code> if the given filename is
<code>&quot;test.xml.zip&quot;</code> or <code>&quot;test.zip&quot;</code>.
Similarly, the filename in the archive will be
<code>&quot;test.sbml&quot;</code> if the given filename is
<code>&quot;test.sbml.zip&quot;</code>.

 <p>
 * @param d an {@link SBMLDocument} object to be written out in XML format
 <p>
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 <p>
 * @return <code>1</code> on success and <code>0</code> (zero) if <code>filename</code> could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 <p>
 <p>
 <p>
 * @see SBMLWriter#hasZlib()
 * @see SBMLWriter#hasBzip2()
 */ public
 static int writeSBMLToFile(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBMLToFile(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * This method takes an SBML type code and returns a string representing
 * the code.
 <p>
 * LibSBML attaches an identifying code to every
 * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
 * other languages, the set of type codes is stored in an enumeration; in
 * the Java language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class {@link
 * libsbmlConstants}.  The names of the type codes all begin with the
 * characters <code>SBML_.</code> 
 <p>
 * @return a human readable name for the given
 * SBML type code.
 <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static String SBMLTypeCode_toString(int tc, String pkgName) {
    return libsbmlJNI.SBMLTypeCode_toString(tc, pkgName);
  }

  
/**
 * Tests for logical equality between two given <code>UNIT_KIND_</code>
 * code values.
 <p>
 * This function behaves exactly like C's <code>==</code> operator, except
 * for the following two cases:
 * <ul>
 * <li>{@link  libsbmlConstants#UNIT_KIND_LITER UNIT_KIND_LITER} <code>==</code> {@link  libsbmlConstants#UNIT_KIND_LITRE UNIT_KIND_LITRE}
 * <li>{@link  libsbmlConstants#UNIT_KIND_METER UNIT_KIND_METER} <code>==</code> {@link  libsbmlConstants#UNIT_KIND_METRE UNIT_KIND_METRE}
 * </ul>
 <p>
 * In the two cases above, C equality comparison would yield <code>false</code>
 * (because each of the above is a distinct enumeration value), but
 * this function returns <code>true.</code>
 <p>
 * @param uk1 a <code>UNIT_KIND_</code> value 
 * @param uk2 a second <code>UNIT_KIND_</code> value to compare to <code>uk1</code>
 <p>
 * @return nonzero (for <code>true</code>) if <code>uk1</code> is logically equivalent to 
 * <code>uk2</code>, zero (for <code>false</code>) otherwise.
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */ public
 static int UnitKind_equals(int uk1, int uk2) {
    return libsbmlJNI.UnitKind_equals(uk1, uk2);
  }

  
/**
 * Converts a text string naming a kind of unit to its corresponding
 * libSBML <code>UNIT_KIND_</code> constant/enumeration value.
 <p>
 * @param name a string, the name of a predefined base unit in SBML
 <p>
 * @return a value the set of <code>UNIT_KIND_</code> codes
 * defined in class {@link libsbmlConstants}, corresponding to the string
 * <code>name</code> (determined in a case-insensitive manner).
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */ public
 static int UnitKind_forName(String name) {
    return libsbmlJNI.UnitKind_forName(name);
  }

  
/**
 * Converts a unit code to a text string equivalent.
 <p>
 * @param uk a value from the set of <code>UNIT_KIND_</code> codes
 * defined in the class {@link libsbmlConstants}
 <p>
 <p>
 * @return the name corresponding to the given unit code.
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 <p>
 * @warning The string returned is a static data value.  The caller does not
 * own the returned string and is therefore not allowed to modify it.
 */ public
 static String UnitKind_toString(int uk) {
    return libsbmlJNI.UnitKind_toString(uk);
  }

  
/**
 * Predicate for testing whether a given string corresponds to a
 * predefined libSBML unit code.
 <p>
 * @param str a text string naming a base unit defined by SBML
 * @param level the Level of SBML
 * @param version the Version within the Level of SBML
 <p>
 * @return nonzero (for <code>true</code>) if string is the name of a valid
 * <code>UNIT_KIND_</code> value, zero (for <code>false</code>) otherwise.
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */ public
 static int UnitKind_isValidUnitKindString(String str, long level, long version) {
    return libsbmlJNI.UnitKind_isValidUnitKindString(str, level, version);
  }

  public static boolean representsNumber(int type) {
    return libsbmlJNI.representsNumber(type);
  }

  public static boolean representsFunction(int type, ASTBasePlugin plugin) {
    return libsbmlJNI.representsFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin), plugin);
  }

  public static boolean representsFunction(int type) {
    return libsbmlJNI.representsFunction__SWIG_1(type);
  }

  public static boolean representsUnaryFunction(int type, ASTBasePlugin plugin) {
    return libsbmlJNI.representsUnaryFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin), plugin);
  }

  public static boolean representsUnaryFunction(int type) {
    return libsbmlJNI.representsUnaryFunction__SWIG_1(type);
  }

  public static boolean representsBinaryFunction(int type, ASTBasePlugin plugin) {
    return libsbmlJNI.representsBinaryFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin), plugin);
  }

  public static boolean representsBinaryFunction(int type) {
    return libsbmlJNI.representsBinaryFunction__SWIG_1(type);
  }

  public static boolean representsNaryFunction(int type, ASTBasePlugin plugin) {
    return libsbmlJNI.representsNaryFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin), plugin);
  }

  public static boolean representsNaryFunction(int type) {
    return libsbmlJNI.representsNaryFunction__SWIG_1(type);
  }

  public static boolean representsQualifier(int type, ASTBasePlugin plugin) {
    return libsbmlJNI.representsQualifier__SWIG_0(type, ASTBasePlugin.getCPtr(plugin), plugin);
  }

  public static boolean representsQualifier(int type) {
    return libsbmlJNI.representsQualifier__SWIG_1(type);
  }

  public static boolean representsFunctionRequiringAtLeastTwoArguments(int type) {
    return libsbmlJNI.representsFunctionRequiringAtLeastTwoArguments(type);
  }

  public static int getCoreTypeFromName(String name) {
    return libsbmlJNI.getCoreTypeFromName(name);
  }

  public static String getNameFromCoreType(int type) {
    return libsbmlJNI.getNameFromCoreType(type);
  }

  public static boolean isCoreTopLevelMathMLFunctionNodeTag(String name) {
    return libsbmlJNI.isCoreTopLevelMathMLFunctionNodeTag(name);
  }

  public static boolean isCoreTopLevelMathMLNumberNodeTag(String name) {
    return libsbmlJNI.isCoreTopLevelMathMLNumberNodeTag(name);
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 <p>
 * @param xml a string containing a full MathML expression
 <p>
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise <code>null</code> is returned if the given string is <code>null</code>
 * or invalid.
 */ public
 static ASTNode readMathMLFromString(String xml) {
    long cPtr = libsbmlJNI.readMathMLFromString(xml);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 <p>
 * @param xml a string containing a full MathML expression
 * @param xmlns a XMLNamespaces_t object containing namespaces that
 * are considered active during the read e.g. an L3 package namespace
 <p>
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise <code>null</code> is returned if the given string is <code>null</code>
 * or invalid.
 */ public
 static ASTNode readMathMLFromStringWithNamespaces(String xml, XMLNamespaces xmlns) {
    long cPtr = libsbmlJNI.readMathMLFromStringWithNamespaces(xml, XMLNamespaces.getCPtr(xmlns), xmlns);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
 * Writes the given ASTNode_t (and its children) to a string as MathML, and
 * returns the string.
 <p>
 * @param node the root of an AST to write out to the stream.
 <p>
 * @return a string containing the written-out MathML representation
 * of the given AST.
 <p>
 * @note The string is owned by the caller and should be freed (with
 * free()) when no longer needed.  <code>null</code> is returned if the given
 * argument is <code>null.</code>
 */ public
 static String writeMathMLToString(ASTNode node) {
    return libsbmlJNI.writeMathMLToString(ASTNode.getCPtr(node), node);
  }

  
/**
 * Parses the given SBML formula and returns a representation of it as an
 * Abstract Syntax Tree (AST).
 <p>
 * <p>
 * The text-string form of mathematical formulas produced by
 * <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * and read by <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String formula)</a></code>
 * use a simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
 * formula in this text-string form therefore can be handed to a program
 * that understands SBML Level&nbsp;1 mathematical expressions, or used as
 * part of a formula translation system.  The syntax is described in detail
 * in the documentation for {@link ASTNode}. 
 <p>
 * Note that this facility is provided as a convenience by libSBML&mdash;the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors" style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Precedence</th>
     <th align="left">Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align="center">5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>
<caption class="top-caption">A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the <code>+</code> and <code>-</code>
 * operators are left-associative.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="35">Args</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="110">Argument Constraints</th>
     <th align="left" width="100">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td><td><em>x</em></td><td>absolute value of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>acos</code></td><td><em>x</em></td><td>arc cosine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>acos(x)</em> &le; &pi;</td></tr>
<tr><td><code>asin</code></td><td><em>x</em></td><td>arc sine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>asin(x)</em> &le; &pi;</td></tr>
<tr><td><code>atan</code></td><td><em>x</em></td><td>arc tangent of <em>x</em> in radians</td><td></td><td>0 &le; <em>atan(x)</em> &le; &pi;</td></tr>
<tr><td><code>ceil</code></td><td><em>x</em></td><td>smallest number not less than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>cos</code></td><td><em>x</em></td><td>cosine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>exp</code></td><td><em>x</em></td><td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm</td><td></td><td></td></tr>
<tr><td><code>floor</code></td><td><em>x</em></td><td>the largest number not greater than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>log</code></td><td><em>x</em></td><td>natural logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>log10</code></td><td><em>x</em></td><td>base 10 logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>pow</code></td><td><em>x, y</em></td><td><em>x</em><sup><em> y</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqr</code></td><td><em>x</em></td><td><em>x</em><sup><em>2</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqrt</code></td><td><em>x</em></td><td>&radic;<em>x</em></td><td><em>x</em> &gt; 0</td><td><em>sqrt(x)</em> &ge; 0</td></tr>
<tr><td><code>sin</code></td><td><em>x</em></td><td>sine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>tan</code></td><td><em>x</em></td><td>tangent of <em>x</em></td><td>x &ne; n*&pi;/2, for odd integer <em>n</em></td><td></td></tr>
<caption class="bottom-caption">The names of mathematical functions defined in the SBML
Level&nbsp;1 Version&nbsp;2 text-string formula syntax.</caption>
</table>


 <p>
 * @warning <span class='warning'>There are differences between the symbols
 * used to represent the common mathematical functions and the corresponding
 * MathML token names.  This is a potential source of incompatibilities.
 * Note in particular that in this text-string syntax, <code>log(x)</code>
 * represents the natural logarithm, whereas in MathML, the natural logarithm
 * is <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.</span> 
 <p>
 * <p>
 * @warning <span class='warning'>We urge developers to keep in mind that
 * the text-string formula syntax is specific to SBML Level&nbsp;1's C-like
 * mathematical formula syntax.  In particular, it is <em>not a
 * general-purpose mathematical expression syntax</em>.  LibSBML provides
 * methods for parsing and transforming text-string math formulas back and
 * forth from AST structures, but it is important to keep the system's
 * limitations in mind.</span>
 <p>
 * @param formula the text-string formula expression to be parsed
 <p>
 * @return the root node of the AST corresponding to the <code>formula</code>, or 
 * <code>null</code> if an error occurred in parsing the formula
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static ASTNode parseFormula(String formula) {
    long cPtr = libsbmlJNI.parseFormula(formula);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Converts an AST to a string representation of a formula using a syntax
 * basically derived from SBML Level&nbsp;1.
 <p>
 * <p>
 * The text-string form of mathematical formulas produced by
 * <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * and read by <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String formula)</a></code>
 * use a simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
 * formula in this text-string form therefore can be handed to a program
 * that understands SBML Level&nbsp;1 mathematical expressions, or used as
 * part of a formula translation system.  The syntax is described in detail
 * in the documentation for {@link ASTNode}. 
 <p>
 * Note that this facility is provided as a convenience by libSBML&mdash;the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors" style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Precedence</th>
     <th align="left">Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align="center">5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>
<caption class="top-caption">A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the <code>+</code> and <code>-</code>
 * operators are left-associative.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="35">Args</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="110">Argument Constraints</th>
     <th align="left" width="100">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td><td><em>x</em></td><td>absolute value of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>acos</code></td><td><em>x</em></td><td>arc cosine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>acos(x)</em> &le; &pi;</td></tr>
<tr><td><code>asin</code></td><td><em>x</em></td><td>arc sine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>asin(x)</em> &le; &pi;</td></tr>
<tr><td><code>atan</code></td><td><em>x</em></td><td>arc tangent of <em>x</em> in radians</td><td></td><td>0 &le; <em>atan(x)</em> &le; &pi;</td></tr>
<tr><td><code>ceil</code></td><td><em>x</em></td><td>smallest number not less than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>cos</code></td><td><em>x</em></td><td>cosine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>exp</code></td><td><em>x</em></td><td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm</td><td></td><td></td></tr>
<tr><td><code>floor</code></td><td><em>x</em></td><td>the largest number not greater than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>log</code></td><td><em>x</em></td><td>natural logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>log10</code></td><td><em>x</em></td><td>base 10 logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>pow</code></td><td><em>x, y</em></td><td><em>x</em><sup><em> y</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqr</code></td><td><em>x</em></td><td><em>x</em><sup><em>2</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqrt</code></td><td><em>x</em></td><td>&radic;<em>x</em></td><td><em>x</em> &gt; 0</td><td><em>sqrt(x)</em> &ge; 0</td></tr>
<tr><td><code>sin</code></td><td><em>x</em></td><td>sine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>tan</code></td><td><em>x</em></td><td>tangent of <em>x</em></td><td>x &ne; n*&pi;/2, for odd integer <em>n</em></td><td></td></tr>
<caption class="bottom-caption">The names of mathematical functions defined in the SBML
Level&nbsp;1 Version&nbsp;2 text-string formula syntax.</caption>
</table>


 <p>
 * @warning <span class='warning'>There are differences between the symbols
 * used to represent the common mathematical functions and the corresponding
 * MathML token names.  This is a potential source of incompatibilities.
 * Note in particular that in this text-string syntax, <code>log(x)</code>
 * represents the natural logarithm, whereas in MathML, the natural logarithm
 * is <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.</span> 
 <p>
 * <p>
 * @warning <span class='warning'>We urge developers to keep in mind that
 * the text-string formula syntax is specific to SBML Level&nbsp;1's C-like
 * mathematical formula syntax.  In particular, it is <em>not a
 * general-purpose mathematical expression syntax</em>.  LibSBML provides
 * methods for parsing and transforming text-string math formulas back and
 * forth from AST structures, but it is important to keep the system's
 * limitations in mind.</span> 
 <p>
 * @param tree the AST to be converted.
 <p>
 * @return the formula from the given AST as an SBML Level 1 text-string
 * mathematical formula.  The caller owns the returned string and is
 * responsible for freeing it when it is no longer needed.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static String formulaToString(ASTNode tree) {
    return libsbmlJNI.formulaToString(ASTNode.getCPtr(tree), tree);
  }

  
/**
 * Parses the given mathematical formula and returns a representation of it
 * as an Abstract Syntax Tree (AST).
 <p>
 * <p>
 * The text-string form of mathematical formulas read by the functions
 * <code><a
 * href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'>libsbml.formulaToL3String(ASTNode
 * tree)</a></code> and <code><a
 * href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String
 * formula)</a></code> are expanded versions of the formats produced
 * and read by <code><a
 * href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString(ASTNode
 * tree)</a></code> and * <code><a
 * href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String
 * formula)</a></code>, respectively.  The latter two libSBML
 * functions were originally developed to support conversion between SBML
 * Levels&nbsp;1 and&nbsp;2, and were focused on the syntax of mathematical
 * formulas used in SBML Level&nbsp;1.  With time, and the use of MathML in
 * SBML Levels&nbsp;2 and&nbsp;3, it became clear that supporting
 * Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be useful for
 * software developers.
 * To maintain backwards compatibility, the original
 * <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * and
 * <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String formula)</a></code>
 * have been left untouched, and instead, the new functionality is
 * provided in the form of
 * <cod
e><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * and <code><a
 * href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'>libsbml.formulaToL3String(ASTNode
 * tree)</a></code>.
 <p>
 * The following are the differences in the formula syntax supported by the
 * 'L3' versions of the formula parsers and formatters, compared to what is
 * supported by * <code><a
 * href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String
 * formula)</a></code> and <code><a
 * href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'>libsbml.formulaToL3String(ASTNode
 * tree)</a></code>:
 <p>
 * <ul>
 * <li> Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the 
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as <code>SId</code> in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 <p>
 * <li> The Boolean function symbols <code>&&</code>, <code>||</code>, <code>!</code>, and <code>!=</code> may be
 * used.
 <p>
 * <li> The <em>modulo</em> operation is allowed as the symbol <code>@%</code> and will
 * produce a piecewise function in the MathML.
 <p>
 * <li> All inverse trigonometric functions may be defined in the infix either
 * using <code>arc</code> as a prefix or simply <code>a</code>; in other words, both <code>arccsc</code>
 * and <code>acsc</code> are interpreted as the operator <em>arccosecant</em> defined in
 * MathML.  (Many functions in the SBML Level&nbsp;1 infix-notation parser
 * implemented by * <code><a
 * href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String
 * formula)</a></code> are defined this way as well, but not all.)
 <p>
 * <li> The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * No spaces are allowed in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; will be parsed into the MathML
 * <code>&lt;divide&gt;</code> construct rather than a rational number.  The 
 * general number syntax allows you to assign units to a rational number, e.g.,
 * &quot;<code>(3/4) ml</code>&quot;.  (If the string is a division, units
 * are not interpreted in this way.)
 <p>
 * <li> Various settings may be altered by using an {@link L3ParserSettings} object in
 * conjunction with the functions <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code> and <code><a
 * href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'>libsbml.formulaToL3String(ASTNode
 * tree)</a></code>, including the following:
 * <ul>
 * <li> The function <code>log</code> with a single argument (&quot;<code>log(x)</code>&quot;) 
 * can be parsed as <code>log10(x)</code>, <code>ln(x)</code>, or treated
 * as an error, as desired.
 * <li> Unary minus signs can be collapsed or preserved; that is,
 * sequential pairs of unary minuses (e.g., &quot;<code>- -3</code>&quot;)
 * can be removed from the input entirely and single unary minuses can be
 * incorporated into the number node, or all minuses can be preserved in
 * the AST node structure.
 * <li> Parsing of units embedded in the input string can be turned on and
 * off.
 * <li> The string <code>avogadro</code> can be parsed as a MathML <em>csymbol</em> or
 * as an identifier.
 * <li> A {@link Model} object may optionally be provided to the parser using the
 * variant function call
 * <code><a
 * href='libsbml.html#parseL3FormulaWithModel(java.lang.String,
 * org.sbml.libsbml.Model)'>libsbml.parseL3FormulaWithModel(String formula,
 * {@link Model} model)</a></code> or stored in a {@link L3ParserSettings} object
 * passed to the variant function <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code>.
 * When a {@link Model} object is provided, identifiers (values of type <code>SId</code>) from
 * that model are used in preference to pre-defined MathML definitions.  More
 * precisely, the {@link Model} entities whose identifiers will shadow identical
 * symbols in the mathematical formula are: {@link Species}, {@link Compartment}, {@link Parameter},
 * {@link Reaction}, and {@link SpeciesReference}.  For instance, if the parser is given a
 * {@link Model} containing a {@link Species} with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the construct
 * <code>&lt;pi/&gt;</code>.  <li> Similarly, when a {@link Model} object is
 * provided, <code>SId</code> values of user-defined functions present in the model
 * will be used preferentially over pre-defined MathML functions.  For
 * example, if the passed-in {@link Model} contains a {@link FunctionDefinition} with the
 * identifier &quot;<code>sin</code>&quot;, that function will be used
 * instead of the predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 * These configuration settings cannot be changed using the basic parser and
 * formatter functions, but can be changed on a per-call basis by using the
 * alternative functions <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code> and <code><a
 * href='libsbml.html#formulaToL3StringWithSettings(const ASTNode_t tree,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(ASTNode tree
 * {@link L3ParserSettings} settings)</a></code>.
 *
 * </ul> <p>
 * The parser function <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code>
 * returns the root node of the AST corresponding to the
 * formula given as the argument.  If the formula contains a syntax error,
 * the function will return <code>null</code> instead.  When <code>null</code> is returned, an
 * error is set; information about the error can be retrieved using
 * <code><a href='libsbml.html#getLastParseL3Error()'>libsbml.getLastParseL3Error()</a></code>.
 <p>
 * Note that this facility and the SBML Level&nbsp;1-based <code><a
 * href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String
 * formula)</a></code> are provided as a convenience by
 * libSBML&mdash;the MathML standard does not actually define a 'string-form'
 * equivalent to MathML expressions, so the choice of formula syntax is
 * arbitrary.  The approach taken by libSBML is to start with the syntax
 * defined by SBML Level&nbsp;1 (which in fact used a text-string
 * representation of formulas, and not MathML), and expand it to include the
 * above functionality.  This formula syntax is based mostly on C programming
 * syntax, and may contain operators, function calls, symbols, and white
 * space characters.  The following table provides the precedence rules for
 * the different entities that may appear in formula strings.
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors" style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Precedence</th>
     <th align="left">Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">8</td><td>left</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">7</td><td>left</td></tr>
<tr><td><code>-, !</code></td><td>negation and boolean 'not'</td><td>unary</td><td align="center">6</td><td>right</td></tr>
<tr><td><code>*, /, %</code></td><td>multiplication, division, and modulo</td><td>binary</td><td align="center">5</td><td>left</td></tr>
<tr><td><code>+, -</code></td><td>addition and subtraction</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>==, &lt;, &gt;, &lt=, &gt=, !=</code></td><td>boolean equality, inequality, and comparison</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>&&, ||</code></td><td>boolean 'and' and 'or'</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>
<caption class="top-caption">A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseL3Formula().
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code> 
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the <code>&&</code> and <code>||</code>
 * operators are left-associative and have the same precedence.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors">
 <tr>
     <th align="left" width="100">Name</th>
     <th align="left" width="100">Argument(s)</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="110">Argument Constraints</th>
     <th align="left" width="100">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td>   
    <td><em>x</em></td> 
    <td>Absolute value of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acos</code>, <code>arccos</code></td>
    <td><em>x</em></td>
    <td>Arccosine of <em>x</em> in radians.</td>
    <td>-1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>acos(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>acosh</code>, <code>arccosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosine of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acot</code>, <code>arccot</code></td>
    <td><em>x</em></td>
    <td>Arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acoth</code>, <code>arccoth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsc</code>, <code>arccsc</code></td>
    <td><em>x</em></td>
    <td>Arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsch</code>, <code>arccsch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asec</code>, <code>arcsec</code></td>
    <td><em>x</em></td>
    <td>Arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asech</code>, <code>arcsech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asin</code>, <code>arcsin</code></td>
    <td><em>x</em></td><td>Arcsine of <em>x</em> in radians.</td>
    <td>-1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>asin(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atan</code>, <code>arctan</code></td>
    <td><em>x</em></td>
    <td>Arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td>0 &le; <em>atan(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atanh</code>, <code>arctanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ceil</code>, <code>ceiling</code></td>
    <td><em>x</em></td>
    <td>Smallest number not less than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cos</code></td>
    <td><em>x</em></td>
    <td>Cosine of <em>x</em></td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cot</code></td>
    <td><em>x</em></td>
    <td>Cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>coth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csc</code></td>
    <td><em>x</em></td>
    <td>Cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>delay</code></td>
    <td><em>x, y</em></td>
    <td>The value of <em>x</em> at <em>y</em> time units in the past.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>factorial</code></td>
    <td><em>n</em></td>
    <td>The factorial of <em>n</em>. Factorials are defined by n! = n*(n-1)* ... * 1.</td>
    <td><em>n</em> must be an integer.</td>
    <td></td>
</tr>
<tr><td><code>exp</code></td>
    <td><em>x</em></td>
    <td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>floor</code></td>
    <td><em>x</em></td>
    <td>The largest number not greater than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ln</code></td>
    <td><em>x</em></td>
    <td>Natural logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x</em></td>
    <td>By default, the base 10 logarithm of <em>x</em>, but can be set to be the natural logarithm of <em>x</em>, or to be an illegal construct.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x, y</em></td>
    <td>The base <em>x</em> logarithm of <em>y</em>.</td>
    <td><em>y</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log10</code></td>
    <td><em>x</em></td>
    <td>Base 10 logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>piecewise</code></td>
    <td><em>x1, y1, [x2, y2,] [...] [z]</em></td>
    <td>A piecewise function: if (<em>y1</em>), <em>x1</em>.  Otherwise, if (<em>y2</em>), <em>x2</em>, etc.  Otherwise, z. </td>
    <td><em>y1, y2, y3 [etc]</em> must be boolean</td>
    <td></td>
</tr>
<tr><td><code>pow</code>, <code>power</code> </td>
    <td><em>x, y</em></td>
    <td><em>x</em><sup><em> y</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>root</code></td>
    <td><em>b, x</em></td>
    <td>The root base <em>b</em> of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sec</code></td>
    <td><em>x</em></td>
    <td>Secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqr</code></td>
    <td><em>x</em></td>
    <td><em>x</em><sup><em>2</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqrt</code></td>
    <td><em>x</em></td>
    <td>&radic;<em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td><em>sqrt(x)</em> &ge; 0</td>
</tr>
<tr><td><code>sin</code></td>
    <td><em>x</em></td>
    <td>Sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sinh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>tan</code></td>
    <td><em>x</em></td>
    <td>Tangent of <em>x</em>.</td>
    <td>x &ne; n*&pi;/2, for odd integer <em>n</em></td>
    <td></td>
</tr>
<tr><td><code>tanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic tangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>and</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean and(<em>x, y, z...</em>): returns true if all of its arguments are true.  Note that 'and' is an n-ary function, taking 0 or more arguments, and that and() returns 'true'.</td>
    <td>All arguments must be boolean</td>
    <td></td>
</tr>
<tr><td><code>not</code></td>
    <td><em>x</em></td>
    <td>Boolean not(<em>x</em>)</td>
    <td><em>x</em> must be boolean</td>
    <td></td>
</tr>
<tr><td><code>or</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean or(<em>x, y, z...</em>): returns true if at least one of its arguments is true.  Note that 'or' is an n-ary function, taking 0 or more arguments, and that or() returns 'false'.</td>
    <td>All arguments must be boolean</td>
    <td></td>
</tr>
<tr><td><code>xor</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean xor(<em>x, y, z...</em>): returns true if an odd number of its arguments is true.  Note that 'xor' is an n-ary function, taking 0 or more arguments, and that xor() returns 'false'.</td>
    <td>All arguments must be boolean</td>
    <td></td>
</tr>
<tr><td><code>eq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean eq(<em>x, y, z...</em>): returns true if all arguments are equal.  Note that 'eq' is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>geq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean geq(<em>x, y, z...</em>): returns true if each argument is greater than or equal to the argument following it.  Note that 'geq' is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>gt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean gt(<em>x, y, z...</em>): returns true if each argument is greater than the argument following it.  Note that 'gt' is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>leq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean leq(<em>x, y, z...</em>): returns true if each argument is less than or equal to the argument following it.  Note that 'leq' is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>lt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean lt(<em>x, y, z...</em>): returns true if each argument is less than the argument following it.  Note that 'lt' is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>neq</code></td>
    <td><em>x, y</em></td>
    <td>Boolean <em>x</em> != <em>y</em>: returns true unless x and y are equal.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>plus</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> + <em>y</em> + <em>z</em> + <em>...</em>: The sum of the arguments of the function.  Note that 'plus' is an n-ary function taking 0 or more arguments, and that 'plus()' returns 0.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>times</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> * <em>y</em> * <em>z</em> * <em>...</em>: The product of the arguments of the function.  Note that 'times' is an n-ary function taking 0 or more arguments, and that 'times()' returns 1.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>minus</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> - <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>divide</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> / <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>

<caption class="top-caption">The names of mathematical functions defined
in the text-string formula syntax understood by SBML_parseL3Formula() and
related functions.</caption>

</table>


 <p>
 * Note that the manner in which the 'L3' versions of the formula parser and
 * formatter interpret the function &quot;<code>log</code>&quot; can be
 * changed.  To do so, callers should use the function <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code> 
 * and pass it an appropriate {@link L3ParserSettings} object.  By default,
 * unlike the SBML Level&nbsp;1 parser implemented by <code><a
 * href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(String
 * formula)</a></code>, the string &quot;<code>log</code>&quot; is
 * interpreted as the base&nbsp;10 logarithm, and <em>not</em> as the natural
 * logarithm.  However, you can change the interpretation to be base-10 log,
 * natural log, or as an error; since the name 'log' by itself is ambiguous,
 * you require that the parser uses <code>log10</code> or <code>ln</code> instead, which are more
 * clear.  Please refer to <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code>.
 <p>
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same <code>SId</code> identifier string exists
 * in the {@link Model} object provided:
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="200">Meaning</th>
     <th align="left">MathML</th>
 </tr>
<tr><td><code>true</code></td>   
    <td>The boolean value <code>true</code></td>
    <td><code>&lt;true/&gt;</code></td>
</tr>
<tr><td><code>false</code></td>   
    <td>The boolean value <code>false</code></td>
    <td><code>&lt;false/&gt;</code></td>
</tr>
<tr><td><code>pi</code></td>   
    <td>The mathematical constant pi</td>
    <td><code>&lt;pi/&gt;</code></td>
</tr>
<tr><td><code>avogadro</code></td>   
    <td>The numerical value of Avogadro's constant, as defined in the SBML specification</td>
    <td><code>&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/avogadro"&gt; avogadro &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>time</code></td>   
    <td>Simulation time as defined in SBML</td>
    <td><code>&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/time"&gt; time &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>inf</code> or <code>infinity</code></td>   
    <td>The mathematical constant "infinity"</td>
    <td><code>&lt;infinity/&gt;</code></td>
</tr>
<tr><td><code>nan</code> or <code>notanumber</code></td>   
    <td>The mathematical concept "not a number"</td>
    <td><code>&lt;notanumber/&gt;</code></td>
</tr>

<caption class="top-caption">The names of mathematical symbols defined
in the text-string formula syntax understood by
SBML_parseL3Formula() and related functions.
</caption>
</table>

 <p>
 * Note that whether the string &quot;<code>avogadro</code>&quot; is parsed
 * as an AST node of type {@link  libsbmlConstants#AST_NAME_AVOGADRO
 * AST_NAME_AVOGADRO} or {@link  libsbmlConstants#AST_NAME AST_NAME}
 * is configurable; use the alternate version of this function, called <code><a
 * href='libsbml.html#parseL3FormulaWithSettings(java.lang.String,
 * org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String
 * formula, {@link L3ParserSettings} settings)</a></code>.  This
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * {@link  libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} AST nodes.
<p>
 * @param formula the text-string formula expression to be parsed
 <p>
 * @return the root node of an AST representing the mathematical formula,
 * or <code>null</code> if an error occurred while parsing the formula.  When <code>null</code>
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using 
 * <code><a href='libsbml.html#getLastParseL3Error()'>libsbml.getLastParseL3Error()</a></code>.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static ASTNode parseL3Formula(String formula) {
    long cPtr = libsbmlJNI.parseL3Formula(formula);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Parses the given mathematical formula using specific a specific {@link Model} to
 * resolve symbols, and returns an Abstract Syntax Tree (AST)
 * representation of the result.
 <p>
 * This is identical to
 * <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>,
 * except that this function uses the given model in the argument <code>model</code>
 * to check against identifiers that appear in the <code>formula</code>.
 <p>
 * For more details about the parser, please see the definition of
 * the function <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>.
 <p>
 * @param formula the mathematical formula expression to be parsed
 <p>
 * @param model the {@link Model} object to use for checking identifiers
 <p>
 * @return the root node of an AST representing the mathematical formula,
 * or <code>null</code> if an error occurred while parsing the formula.  When <code>null</code>
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using
 * <code><a href='libsbml.html#getLastParseL3Error()'>libsbml.getLastParseL3Error()</a></code>.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static ASTNode parseL3FormulaWithModel(String formula, Model model) {
    long cPtr = libsbmlJNI.parseL3FormulaWithModel(formula, Model.getCPtr(model), model);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Parses the given mathematical formula using specific parser settings and
 * returns an Abstract Syntax Tree (AST) representation of the result.
 <p>
 * This is identical to
 <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>,
 * except that this function uses the parser settings given in the argument
 * <code>settings</code>.  The settings override the default parsing behavior.
 <p>
 * The parameter <code>settings</code> allows callers to change the following parsing
 * behaviors:
 <p>
 * <ul>
 * <li> Use a specific {@link Model} object against which identifiers to compare
 * identifiers.  This causes the parser to search the {@link Model} for identifiers
 * that the parser encounters in the formula.  If a given symbol in the
 * formula matches the identifier of a {@link Species}, {@link Compartment}, {@link Parameter},
 * {@link Reaction}, {@link SpeciesReference} or {@link FunctionDefinition} in the {@link Model}, then the
 * symbol is assumed to refer to that model entity instead of any possible
 * mathematical terms with the same symbol.  For example, if the parser is
 * given a {@link Model} containing a {@link Species} with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the
 * construct <code>&lt;pi/&gt;</code>.
 * <li> Whether to parse &quot;<code>log(x)</code>&quot; with a single
 * argument as the base 10
 * logarithm of x, the natural logarithm of x, or treat the case as an
 * error.
 * <li> Whether to parse &quot;<code>number id</code>&quot; by interpreting
 * <code>id</code> as the identifier of a unit of measurement associated with the
 * number, or whether to treat the case as an error.
 * <li> Whether to parse &quot;<code>avogadro</code>&quot; as an {@link ASTNode} of
 * type {@link  libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} or
 * as type {@link  libsbmlConstants#AST_NAME AST_NAME}.
 * <li> Whether to always create explicit ASTNodes of type {@link 
 * libsbmlConstants#AST_MINUS AST_MINUS} for all unary minuses, or
 * collapse and remove minuses where possible.
 *
 * </ul> <p>
 * For more details about the parser, please see the definition of
 * {@link L3ParserSettings} and
 * <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>.
 <p>
 * @param formula the mathematical formula expression to be parsed
 <p>
 * @param settings the settings to be used for this parser invocation
 <p>
 * @return the root node of an AST representing the mathematical formula,
 * or <code>null</code> if an error occurred while parsing the formula.  When <code>null</code>
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using
 * <code><a href='libsbml.html#getLastParseL3Error()'>libsbml.getLastParseL3Error()</a></code>.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static ASTNode parseL3FormulaWithSettings(String formula, L3ParserSettings settings) {
    long cPtr = libsbmlJNI.parseL3FormulaWithSettings(formula, L3ParserSettings.getCPtr(settings), settings);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Returns a copy of the default parser settings used by <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>.
 <p>
 * The settings structure allows callers to change the following parsing
 * behaviors:
 <p>
 * <ul>
 * <li> Use a specific {@link Model} object against which identifiers to compare
 * identifiers.  This causes the parser to search the {@link Model} for identifiers
 * that the parser encounters in the formula.  If a given symbol in the
 * formula matches the identifier of a {@link Species}, {@link Compartment}, {@link Parameter},
 * {@link Reaction}, {@link SpeciesReference} or {@link FunctionDefinition} in the {@link Model}, then the
 * symbol is assumed to refer to that model entity instead of any possible
 * mathematical terms with the same symbol.  For example, if the parser is
 * given a {@link Model} containing a {@link Species} with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the
 * construct <code>&lt;pi/&gt;</code>.
 * <li> Whether to parse &quot;<code>log(x)</code>&quot; with a single
 * argument as the base 10
 * logarithm of x, the natural logarithm of x, or treat the case as an
 * error.
 * <li> Whether to parse &quot;<code>number id</code>&quot; by interpreting
 * <code>id</code> as the identifier of a unit of measurement associated with the
 * number, or whether to treat the case as an error.
 * <li> Whether to parse &quot;<code>avogadro</code>&quot; as an {@link ASTNode} of
 * type {@link  libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} or
 * as type {@link  libsbmlConstants#AST_NAME AST_NAME}.
 * <li> Whether to always create explicit ASTNodes of type {@link 
 * libsbmlConstants#AST_MINUS AST_MINUS} for all unary minuses, or
 * collapse and remove minuses where possible.
 *
 * </ul> <p>
 * For more details about the parser, please see the definition of
 * {@link L3ParserSettings} and
 * <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 */ public
 static L3ParserSettings getDefaultL3ParserSettings() {
    long cPtr = libsbmlJNI.getDefaultL3ParserSettings();
    return (cPtr == 0) ? null : new L3ParserSettings(cPtr, true);
  }

  
/**
 * Returns the last error reported by the parser.
 <p>
 * If <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>, 
 * <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, {@link L3ParserSettings} settings)</a></code>, or
 * <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>libsbml.parseL3FormulaWithModel(String formula, {@link Model} model)</a></code> return <code>null</code>, an error is set internally which is accessible
 * via this function. 
 <p>
 * @return a string describing the error that occurred.  This will contain
 * the string the parser was trying to parse, which character it had parsed
 * when it encountered the error, and a description of the error.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static String getLastParseL3Error() {
    return libsbmlJNI.getLastParseL3Error();
  }

}
