/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Representation of MIRIAM-compliant controlled vocabulary
 * annotation.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled vocabulary
 * terms and database identifiers that define and describe biological and
 * biochemical entities, and (b) describing the creator of a model and the
 * model's modification history.  This SBML format is a concrete syntax that
 * conforms to the guidelines of MIRIAM (<a target='_blank'
 * href='http://www.nature.com/nbt/journal/v23/n12/abs/nbt1156.html'>'Minimum
 * Information Requested in the Annotation of biochemical Models'</a>,
 * <i>Nature Biotechnology</i>, vol. 23, no. 12, Dec. 2005).  The format uses
 * a subset of W3C RDF (<a target='_blank'
 * href='http://www.w3.org/RDF/'>Resource Description Format</a>).  In order
 * to help application developers work with annotations in this format,
 * libSBML provides several helper classes that provide higher-level
 * interfaces to the data elements; these classes include CVTerm,
 * ModelCreator, ModelHistory, RDFAnnotationParser, and Date.
 *
 * @section annotation-parts Components of an SBML annotation
 *
 * The SBML annotation format consists of RDF-based content placed inside
 * an <code>&lt;annotation&gt;</code> element attached to an SBML component
 * such as Species, Compartment, etc.  The following template illustrates
 * the different parts of SBML annotations in XML form:
 * 
 <pre class='fragment'>
 &lt;<span style='background-color: #bbb'>SBML_ELEMENT</span> <span style='background-color: #d0eed0'>+++</span> metaid=&quot;<span style='border-bottom: 1px solid black'>meta id</span>&quot; <span style='background-color: #d0eed0'>+++</span>&gt;
   <span style='background-color: #d0eed0'>+++</span>
   &lt;annotation&gt;
     <span style='background-color: #d0eed0'>+++</span>
     &lt;rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
              xmlns:dc='http://purl.org/dc/elements/1.1/'
              xmlns:dcterm='http://purl.org/dc/terms/'
              xmlns:vcard='http://www.w3.org/2001/vcard-rdf/3.0#'
              xmlns:bqbiol='http://biomodels.net/biology-qualifiers/'
              xmlns:bqmodel='http://biomodels.net/model-qualifiers/' &gt;
       &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
         <span style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
         &lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
           &lt;rdf:Bag&gt;
             &lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>URI</span>&quot; /&gt;
             <span style='background-color: #edd'>...</span>
           &lt;/rdf:Bag&gt;
         &lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
         <span style='background-color: #edd'>...</span>
       &lt;/rdf:Description&gt;
       <span style='background-color: #d0eed0'>+++</span>
     &lt;/rdf:RDF&gt;
     <span style='background-color: #d0eed0'>+++</span>
   &lt;/annotation&gt;
   <span style='background-color: #d0eed0'>+++</span>
 &lt;/<span style='background-color: #bbb'>SBML_ELEMENT</span>&gt;
 </pre>
 * 
 * In the template above, the placeholder
 * <span class='code' style='background-color: #bbb'>SBML_ELEMENT</span> stands for
 * the XML tag name of an SBML model component (e.g., <code>model</code>,
 * <code>reaction</code>, etc.) and the placeholder 
 * <span class='code' style='border-bottom: 1px solid black'>meta id</span>
 * stands for the element's meta identifier, which is a field available
 * on all SBML components derived from the SBase base object class.
 * The <span style='border-bottom: 2px dotted #888'>dotted</span>
 * portions are optional, the symbol
 * <span class='code' style='background-color: #d0eed0'>+++</span> is a placeholder
 * for either no content or valid XML content that is not defined by
 * this annotation scheme, and the ellipses
 * <span class='code' style='background-color: #edd'>...</span>
 * are placeholders for zero or more elements of the same form as the
 * immediately preceding element.  The optional content
 * <span class='code' style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
 * is a creation and modification history; in libSBML, this is stored
 * using ModelHistory objects.
 *
 * The placeholder <span class='code' style='background-color:
 * #bbb'>RELATION_ELEMENT</span> refers to a BioModels.net qualifier element
 * name.  This is an element in either the XML namespace
 * <code>'http://biomodels.net/model-qualifiers'</code> (for model
 * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code> (for
 * biological qualifier).  Note that these namespace URIs are only labels,
 * and not actual Web locations, which means you cannot visit an address such
 * as <code>'http://biomodels.net/model-qualifiers'</code> in your browser or
 * try to have your application access it.  @if Refer instead to the enumerations
 * #ModelQualifierType_t and #BiolQualifierType_t for a list of the available
 * relationship elements that can be used for <span class='code'
 * style='background-color: #bbb'>RELATION_ELEMENT</span>.@endif
 *
 * The <span class='code' style='background-color: #d0d0ee'>URI</span> is a
 * required data value that uniquely identifies a resource and data within
 * that resource to which the annotation refers.  Again, being URIs, these do
 * not refer to physical Web locations; nevertheless, applications will often
 * want a means of finding the resource to which a given <span class='code'
 * style='background-color: #d0d0ee'>URI</span> refers.  Providing the
 * facilities for this task is the purpose of MIRIAM Resources, described in
 * detail online at <a target='_blank'
 * href='http://biomodels.net/miriam'>http://biomodels.net/miriam</a>) and
 * also in the paper <a target='_blank'
 * href='http://www.biomedcentral.com/1752-0509/1/58'>'MIRIAM Resources: tools to generate and
 * resolve robust cross-references in Systems Biology'</a>, <i>BMC Systems
 * Biology</i>, 58(1), 2007.
 *
 * The relation-resource pairs above are the 'controlled vocabulary' terms
 * that which CVTerm is designed to store and manipulate.  The next section
 * describes these parts in more detail.  For more information about
 * SBML annotations in general, please refer to Section&nbsp;6 in the
 * SBML Level&nbsp;2 (Versions 2&ndash;4) or Level&nbsp;3 specification
 * documents.
 * 
 *
 * @section cvterm-parts The parts of a CVTerm
 * 
 * Annotations that refer to controlled vocabularies are managed in libSBML
 * using CVTerm objects.  A set of RDF-based annotations attached to a
 * given SBML <code>&lt;annotation&gt;</code> element are read by
 * RDFAnnotationParser and converted into a list of these CVTerm objects.
 * Each CVTerm object instance stores the following components of an
 * annotation:
 * 
 * <ul>
 *
 * <li>The @em qualifier, which can be a BioModels.net 'biological
 * qualifier', a BioModels.net 'model qualifier', or an unknown qualifier
 * (as far as the CVTerm class is concerned).  Qualifiers are used in
 * MIRIAM to indicate the nature of the relationship between the object
 * being annotated and the resource.  In CVTerm, the qualifiers can be
 * manipulated using the methods CVTerm::getQualifierType(),
 * CVTerm::setQualifierType(@if java int type@endif), and related methods.
 * 
 * <li>The @em resource, represented by a URI (which, we must remind
 * developers, is not the same as a URL).  In the CVTerm class, the
 * resource component can be manipulated using the methods
 * CVTerm::addResource(@if java String resource@endif) and
 * CVTerm::removeResource(@if java String resource@endif).
 *
 * </ul>
 *
 * Note that a CVTerm contains a single qualifier, but possibly more than
 * one resource.  This corresponds to the possibility of an annotation that
 * points to multiple resources, all of which are qualified by the same
 * BioModels.net qualifier.  The CVTerm object class supports this by
 * supporting a list of resources.
 *
 * Detailed explanations of the qualifiers defined by BioModels.net can be
 * found at <a target='_blank'
 * href='http://biomodels.net/qualifiers'>http://biomodels.net/qualifiers</a>.
 */

public class CVTerm : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal CVTerm(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(CVTerm obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (CVTerm obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~CVTerm() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_CVTerm(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(CVTerm lhs, CVTerm rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(CVTerm lhs, CVTerm rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is CVTerm) )
    {
      return false;
    }

    return this == (CVTerm)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates an empty CVTerm, optionally with the given
   * @if clike #QualifierType_t value@else qualifier@endif @p type.
   *
   * *
 * 
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The CVTerm class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of CVTerm objects, and when
 * writing a model, it parses the CVTerm objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure.
 *
 * 
   *
   * This method creates an empty CVTerm object.  The possible qualifier
   * types usable as values of @p type are @link
   * libsbmlcs.libsbml.MODEL_QUALIFIER MODEL_QUALIFIER@endlink and @link
   * libsbmlcs.libsbml.BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER@endlink.  If
   * an explicit value for @p type is not given, this method defaults to
   * using @link libsbmlcs.libsbml.UNKNOWN_QUALIFIER
   * UNKNOWN_QUALIFIER@endlink.  The @if clike #QualifierType_t value@else qualifier type@endif 
   * can be set later using the
   * CVTerm::setQualifierType(@if java int type@endif) method.
   *
   * Different BioModels.net qualifier elements encode different types of
   * relationships.  Please refer to the SBML specification or the <a
   * target='_blank' href='http://biomodels.net/qualifiers/'>BioModels.net
   * qualifiers web page</a> for an explanation of the meaning of these
   * different qualifiers.
   *
   * @param type a @if clike #QualifierType_t value@else qualifier type@endif
   *
   * @if notcpp @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 CVTerm(int type) : this(libsbmlPINVOKE.new_CVTerm__SWIG_0(type), true) {
  }

  
/**
   * Creates an empty CVTerm, optionally with the given
   * @if clike #QualifierType_t value@else qualifier@endif @p type.
   *
   * *
 * 
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The CVTerm class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of CVTerm objects, and when
 * writing a model, it parses the CVTerm objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure.
 *
 * 
   *
   * This method creates an empty CVTerm object.  The possible qualifier
   * types usable as values of @p type are @link
   * libsbmlcs.libsbml.MODEL_QUALIFIER MODEL_QUALIFIER@endlink and @link
   * libsbmlcs.libsbml.BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER@endlink.  If
   * an explicit value for @p type is not given, this method defaults to
   * using @link libsbmlcs.libsbml.UNKNOWN_QUALIFIER
   * UNKNOWN_QUALIFIER@endlink.  The @if clike #QualifierType_t value@else qualifier type@endif 
   * can be set later using the
   * CVTerm::setQualifierType(@if java int type@endif) method.
   *
   * Different BioModels.net qualifier elements encode different types of
   * relationships.  Please refer to the SBML specification or the <a
   * target='_blank' href='http://biomodels.net/qualifiers/'>BioModels.net
   * qualifiers web page</a> for an explanation of the meaning of these
   * different qualifiers.
   *
   * @param type a @if clike #QualifierType_t value@else qualifier type@endif
   *
   * @if notcpp @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 CVTerm() : this(libsbmlPINVOKE.new_CVTerm__SWIG_1(), true) {
  }

  
/**
   * Creates a new CVTerm from the given XMLNode.
   *
   * *
 * 
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The CVTerm class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of CVTerm objects, and when
 * writing a model, it parses the CVTerm objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure.
 *
 * 
   * 
   * This method creates a CVTerm object from the given XMLNode object @p
   * node.  XMLNode is libSBML's representation of a node in an XML tree of
   * elements, and each such element can be placed in a namespace.  This
   * constructor looks for the element to be in the XML namespaces
   * <code>'http://biomodels.net/model-qualifiers'</code> (for
   * model qualifiers) and
   * <code>'http://biomodels.net/biology-qualifiers'</code> (for
   * biological qualifier), and if they are, creates CVTerm objects for
   * the result.
   *
   * @param node an %XMLNode representing a CVTerm.
   *
   * @note This method assumes that the given XMLNode object @p node is of
   * the correct structural form.
   */ public
 CVTerm(XMLNode node) : this(libsbmlPINVOKE.new_CVTerm__SWIG_2(XMLNode.getCPtr(node)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of a CVTerm object.
   * 
   * @param orig the CVTerm instance to copy.
   * 
   * @throws @if python ValueError @else SBMLConstructorException @endif
   * Thrown if the argument @p orig is @c null.
   */ public
 CVTerm(CVTerm orig) : this(libsbmlPINVOKE.new_CVTerm__SWIG_3(CVTerm.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this CVTerm object.
   * 
   * @return a (deep) copy of this CVTerm.
   */ public
 CVTerm clone() {
    IntPtr cPtr = libsbmlPINVOKE.CVTerm_clone(swigCPtr);
    CVTerm ret = (cPtr == IntPtr.Zero) ? null : new CVTerm(cPtr, true);
    return ret;
  }

  
/**
   * Returns the qualifier type of this CVTerm object.
   *
   * *
 * 
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the SBase base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
 *
   *
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier
   * element name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).  The present method returns a code
   * identifying which one of these two relationship namespaces is being
   * used; any other qualifier in libSBML is considered unknown (as far as
   * the CVTerm class is concerned).  Consequently, this method will return
   * one of the following values:
   * 
   * @li @link libsbmlcs.libsbml.MODEL_QUALIFIER MODEL_QUALIFIER@endlink
   * @li @link libsbmlcs.libsbml.BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER@endlink
   * @li @link libsbmlcs.libsbml.UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER@endlink
   *
   * The specific relationship of this CVTerm to the enclosing SBML object
   * can be determined using the CVTerm methods such as
   * getModelQualifierType() and getBiologicalQualifierType().  Callers
   * will typically want to use the present method to find out which one of
   * the @em other two methods to call to find out the specific
   * relationship.
   *
   * @return the @if clike #QualifierType_t value@else qualifier type@endif
   * of this object or @link libsbmlcs.libsbml.UNKNOWN_QUALIFIER UNKNOWN_QUALIFIER@endlink
   * (the default).
   *
   * @see getResources()
   * @see getModelQualifierType()
   * @see getBiologicalQualifierType()
   */ public
 int getQualifierType() {
    int ret = libsbmlPINVOKE.CVTerm_getQualifierType(swigCPtr);
    return ret;
  }

  
/**
   * Returns the model qualifier type of this CVTerm object.
   * 
   * *
 * 
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the SBase base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
 *
   *
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier
   * element name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).  Callers will typically use
   * getQualifierType() to find out the type of qualifier relevant to this
   * particular CVTerm object, then if it is a @em model qualifier, use the
   * present method to determine the specific qualifier.
   *
   * Annotations with model qualifiers express a relationship between an
   * annotation resource and the <em>modeling concept</em> represented by a
   * given object in the model.  The diagram below illustrates the
   * relationship in this case:
   *
   * @image html model-qualifiers.png 'Relationship expressed by model qualifiers'
   * @image latex model-qualifiers.png 'Relationship expressed by model qualifiers'
   *
   * <br> The set of known model qualifiers is, at the time of this libSBML
   * release, the following:
   *
   * @li @link libsbmlcs.libsbml.BQM_IS BQM_IS@endlink
   * @li @link libsbmlcs.libsbml.BQM_IS_DESCRIBED_BY BQM_IS_DESCRIBED_BY@endlink
   * @li @link libsbmlcs.libsbml.BQM_IS_DERIVED_FROM BQM_IS_DERIVED_FROM@endlink
   *
   * Any other BioModels.net qualifier found in the model is considered
   * unknown by libSBML and reported as
   * @link libsbmlcs.libsbml.BQM_UNKNOWN BQM_UNKNOWN@endlink.
   *
   * @return the @if clike #ModelQualifierType_t value@else model qualifier type@endif
   * of this object or @link libsbmlcs.libsbml.BQM_UNKNOWN BQM_UNKNOWN@endlink
   * (the default).
   */ public
 int getModelQualifierType() {
    int ret = libsbmlPINVOKE.CVTerm_getModelQualifierType(swigCPtr);
    return ret;
  }

  
/**
   * Returns the biological qualifier type of this CVTerm object.
   * 
   * *
 * 
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the SBase base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
 *
   *
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier
   * element name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).  Callers will typically use
   * getQualifierType() to find out the type of qualifier relevant to this
   * particular CVTerm object, then if it is a @em biological qualifier,
   * use the present method to determine the specific qualifier.
   *
   * Annotations with biological qualifiers express a relationship between an
   * annotation resource and the <em>biological concept</em> represented by a
   * given object in the model.    The diagram
   * below illustrates the relationship in this case:
   *
   * @image html biology-qualifiers.png 'Relationship expressed by biological qualifiers'
   * @image latex biology-qualifiers.png 'Relationship expressed by biological qualifiers'
   *
   * <br> The set of known biological qualifiers is, at the time of this
   * libSBML release, the following:
   *
   * @li @link libsbmlcs.libsbml.BQB_IS BQB_IS@endlink
   * @li @link libsbmlcs.libsbml.BQB_HAS_PART BQB_HAS_PART@endlink
   * @li @link libsbmlcs.libsbml.BQB_IS_PART_OF BQB_IS_PART_OF@endlink
   * @li @link libsbmlcs.libsbml.BQB_IS_VERSION_OF BQB_IS_VERSION_OF@endlink
   * @li @link libsbmlcs.libsbml.BQB_HAS_VERSION BQB_HAS_VERSION@endlink
   * @li @link libsbmlcs.libsbml.BQB_IS_HOMOLOG_TO BQB_IS_HOMOLOG_TO@endlink
   * @li @link libsbmlcs.libsbml.BQB_IS_DESCRIBED_BY BQB_IS_DESCRIBED_BY@endlink
   * @li @link libsbmlcs.libsbml.BQB_IS_ENCODED_BY BQB_IS_ENCODED_BY@endlink
   * @li @link libsbmlcs.libsbml.BQB_ENCODES BQB_ENCODES@endlink
   * @li @link libsbmlcs.libsbml.BQB_OCCURS_IN BQB_OCCURS_IN@endlink
   * @li @link libsbmlcs.libsbml.BQB_HAS_PROPERTY BQB_HAS_PROPERTY@endlink
   * @li @link libsbmlcs.libsbml.BQB_IS_PROPERTY_OF BQB_IS_PROPERTY_OF@endlink
   *
   * Any other BioModels.net qualifier found in the model is considered
   * unknown by libSBML and reported as
   * @link libsbmlcs.libsbml.BQB_UNKNOWN BQB_UNKNOWN@endlink.
   *
   * @return the @if clike #BiolQualifierType_t value@else biology qualifier type@endif
   * of this object or @link libsbmlcs.libsbml.BQB_UNKNOWN BQB_UNKNOWN@endlink
   * (the default).
   */ public
 int getBiologicalQualifierType() {
    int ret = libsbmlPINVOKE.CVTerm_getBiologicalQualifierType(swigCPtr);
    return ret;
  }

  
/**
   * Returns the resource references for this CVTerm object.
   *
   * *
 * 
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the SBase base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
 *
   *
   * The <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> values shown in the template above are stored internally in
   * CVTerm objects using an XMLAttributes object.  Each attribute stored
   * inside the XMLAttributes will have the same name (specifically,
   * &quot;<code>rdf:resource</code>&quot;) but a different value, and the
   * value will be a <span class='code' style='background-color: #d0d0ee'>
   * resource URI</span> shown in the XML template above.
   *
   * A valid CVTerm entity must always have at least one resource and
   * a value for the relationship qualifier.
   * 
   * @return the XMLAttributes that store the resources of this CVTerm.
   *
   * @see getQualifierType()
   * @see addResource(string resource)
   * @see getResourceURI(long n)
   */ public
 XMLAttributes getResources() {
    IntPtr cPtr = libsbmlPINVOKE.CVTerm_getResources__SWIG_0(swigCPtr);
    XMLAttributes ret = (cPtr == IntPtr.Zero) ? null : new XMLAttributes(cPtr, false);
    return ret;
  }

  
/**
   * Returns the number of resources for this CVTerm object.
   * 
   * *
 * 
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the SBase base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
 *
   *
   * The fragment above illustrates that there can be more than one
   * resource referenced by a given relationship annotation (i.e., the
   * <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> values associated with a particular <span class='code'
   * style='background-color: #bbb'>RELATION_ELEMENT</span>).  The present
   * method returns a count of the resources stored in this CVTerm object.
   *
   * @return the number of resources in the set of XMLAttributes
   * of this CVTerm.
   *
   * @see getResources()
   * @see getResourceURI(long n)
   */ public
 long getNumResources() { return (long)libsbmlPINVOKE.CVTerm_getNumResources(swigCPtr); }

  
/**
   * Returns the value of the <em>n</em>th resource for this CVTerm object.
   *
   * *
 * 
 * The RDF element used in the SBML format for referring to external entities
 * is <code>&lt;rdf:Description&gt;</code>, with a
 * <code>&lt;rdf:Bag&gt;</code> element inside of it containing one or more
 * <code>&lt;rdf:li&gt;</code> elements.  The following template illustrates
 * the structure:
 * <pre class='fragment'>
 * &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
 * &nbsp;&nbsp;<span style='background-color: #ddd; border-bottom: 2px dotted #888'>HISTORY</span>
 * &nbsp;&nbsp;&lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:Bag&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
 * &nbsp;&nbsp;&nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/rdf:Bag&gt;
 * &nbsp;&nbsp;&lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
 * &nbsp;&nbsp;<span style='background-color: #edd'>...</span>
 * &lt;/rdf:Description&gt;
 * </pre>
 * In the template above, the placeholder <span class='code'
 * style='border-bottom: 1px solid black'>meta id</span> stands for the
 * element's meta identifier, which is a field available on all SBML
 * components derived from the SBase base object class.  The <span
 * style='border-bottom: 2px dotted #888'>dotted</span> portions are
 * optional, and the ellipses <span class='code' style='background-color:
 * #edd'>...</span> are placeholders for zero or more elements of the same
 * form as the immediately preceding element.
 *
   *
   * The fragment above illustrates that there can be more than one
   * resource referenced by a given relationship annotation (i.e., the
   * <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> values associated with a particular <span class='code'
   * style='background-color: #bbb'>RELATION_ELEMENT</span>).  LibSBML
   * stores all resource URIs in a single CVTerm object for a given
   * relationship.  Callers can use getNumResources() to find out how many
   * resources are stored in this CVTerm object, then call this method to
   * retrieve the <em>n</em>th resource URI.
   * 
   * @param n the index of the resource to query
   *
   * @return string representing the value of the nth resource
   * in the set of XMLAttributes of this CVTerm.
   *
   * @see getNumResources()
   * @see getQualifierType()
   */ public
 string getResourceURI(long n) {
    string ret = libsbmlPINVOKE.CVTerm_getResourceURI(swigCPtr, n);
    return ret;
  }

  
/**
   * Sets the @if clike #QualifierType_t@else qualifier code@endif of this
   * CVTerm object.
   *
   * @param type the @if clike #QualifierType_t value@else qualifier type@endif.
   * The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see getQualifierType()
   */ public
 int setQualifierType(int type) {
    int ret = libsbmlPINVOKE.CVTerm_setQualifierType(swigCPtr, type);
    return ret;
  }

  
/**
   * Sets the @if clike #ModelQualifierType_t value@else model qualifier type@endif
   * of this CVTerm object.
   *
   * @param type the @if clike #ModelQualifierType_t value@else model qualifier type@endif
   *
   * @return integer value indicating success/failure of the
   * function. The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note If the Qualifier Type of this object is not
   * @link libsbmlcs.libsbml.MODEL_QUALIFIER MODEL_QUALIFIER@endlink, 
   * then the ModelQualifierType_t value will default to
   * @link libsbmlcs.libsbml.BQM_UNKNOWN BQM_UNKNOWN@endlink.
   *
   * @see getQualifierType()
   * @see setQualifierType(@if java int type@endif)
   */ public
 int setModelQualifierType(int type) {
    int ret = libsbmlPINVOKE.CVTerm_setModelQualifierType__SWIG_0(swigCPtr, type);
    return ret;
  }

  
/**
   * Sets the @if clike #BiolQualifierType_t value@else biology qualifier type@endif
   * of this CVTerm object.
   *
   * @param type the @if clike #BiolQualifierType_t value@else biology qualifier type@endif.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note If the Qualifier Type of this object is not
   * @link libsbmlcs.libsbml.BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER@endlink,
   * then the @if clike #BiolQualifierType_t value@else biology qualifier type@endif will default
   * to @link libsbmlcs.libsbml.BQB_UNKNOWN BQB_UNKNOWN@endlink.
   *
   * @see getQualifierType()
   * @see setQualifierType(@if java int type@endif)
   */ public
 int setBiologicalQualifierType(int type) {
    int ret = libsbmlPINVOKE.CVTerm_setBiologicalQualifierType__SWIG_0(swigCPtr, type);
    return ret;
  }

  
/**
   * Sets the @if clike #ModelQualifierType_t@endif@if java model qualifier type code@endif value of this CVTerm object.
   *
   * @param qualifier the string representing a model qualifier
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note If the Qualifier Type of this object is not
   * @link libsbmlcs.libsbml.MODEL_QUALIFIER MODEL_QUALIFIER@endlink, 
   * then the ModelQualifierType_t value will default to
   * @link libsbmlcs.libsbml.BQM_UNKNOWN BQM_UNKNOWN@endlink.
   *
   * @see getQualifierType()
   * @see setQualifierType(@if java int type@endif)
   */ public
 int setModelQualifierType(string qualifier) {
    int ret = libsbmlPINVOKE.CVTerm_setModelQualifierType__SWIG_1(swigCPtr, qualifier);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the @if clike #BiolQualifierType_t@endif@if java biology qualifier
   * type code@endif of this CVTerm object.
   *
   * @param qualifier the string representing a biology qualifier
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note If the Qualifier Type of this object is not
   * @link libsbmlcs.libsbml.BIOLOGICAL_QUALIFIER BIOLOGICAL_QUALIFIER@endlink,
   * then the @if clike #BiolQualifierType_t@endif@if java biology qualifier type code@endif value will default
   * to @link libsbmlcs.libsbml.BQB_UNKNOWN BQB_UNKNOWN@endlink.
   *
   * @see getQualifierType()
   * @see setQualifierType(@if java int type@endif)
   */ public
 int setBiologicalQualifierType(string qualifier) {
    int ret = libsbmlPINVOKE.CVTerm_setBiologicalQualifierType__SWIG_1(swigCPtr, qualifier);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Adds a resource reference to this CVTerm object.
   *
   * *
 * 
 * The SBML Level&nbsp;2 and Level&nbsp;3 specifications define a simple
 * format for annotating models when (a) referring to controlled
 * vocabulary terms and database identifiers that define and describe
 * biological and other entities, and (b) describing the creator of a
 * model and the model's modification history.  The annotation content is
 * stored in <code>&lt;annotation&gt;</code> elements attached to
 * individual SBML elements.  The format for storing the content inside
 * SBML <code>&lt;annotation&gt;</code> elements is a subset of W3C RDF
 * (<a target='_blank' href='http://www.w3.org/RDF/'>Resource Description
 * Format</a>) expressed in XML.  The CVTerm class provides a programming
 * interface for working directly with controlled vocabulary term ('CV
 * term') objects without having to deal directly with the XML form.
 * When libSBML reads in an SBML model containing RDF annotations, it
 * parses those annotations into a list of CVTerm objects, and when
 * writing a model, it parses the CVTerm objects back into the
 * appropriate SBML <code>&lt;annotation&gt;</code> structure.
 *
 * 
   *
   * The specific RDF element used in this SBML format for referring to
   * external entities is <code>&lt;rdf:Description&gt;</code>, with a
   * <code>&lt;rdf:Bag&gt;</code> element containing one or more
   * <code>&lt;rdf:li&gt;</code> elements.  Each such element refers to a
   * data item in an external resource; the resource and data item are
   * together identified uniquely using a URI.  The following template
   * illustrates the structure:
   *
   <pre class='fragment'>
   &lt;rdf:Description rdf:about=&quot;#<span style='border-bottom: 1px solid black'>meta id</span>&quot;&gt;
     <span style='background-color: #e0e0e0; border-bottom: 2px dotted #888'>HISTORY</span>
     &lt;<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
       &lt;rdf:Bag&gt;
         &lt;rdf:li rdf:resource=&quot;<span style='background-color: #d0d0ee'>resource URI</span>&quot; /&gt;
         <span style='background-color: #edd'>...</span>
       &lt;/rdf:Bag&gt;
     &lt;/<span style='background-color: #bbb'>RELATION_ELEMENT</span>&gt;
     <span style='background-color: #edd'>...</span>
   &lt;/rdf:Description&gt;
   </pre>
   *
   * In the template above, the placeholder <span class='code'
   * style='border-bottom: 1px solid black'>meta id</span> stands for the
   * element's meta identifier, which is a field available on all SBML
   * components derived from the SBase base object class.  The <span
   * style='border-bottom: 2px dotted #888'>dotted</span> portions are
   * optional, and the ellipses <span class='code'
   * style='background-color: #edd'>...</span> are placeholders for zero or
   * more elements of the same form as the immediately preceding element.
   * The placeholder <span class='code' style='background-color: #bbb'>
   * RELATION_ELEMENT</span> refers to a BioModels.net qualifier element
   * name.  This is an element in either the XML namespace
   * <code>'http://biomodels.net/model-qualifiers'</code> (for model
   * qualifiers) or <code>'http://biomodels.net/biology-qualifiers'</code>
   * (for biological qualifier).
   *
   * The <span class='code' style='background-color: #d0d0ee'>resource
   * URI</span> is a required data value that uniquely identifies a
   * resource and data within that resource to which the annotation refers.
   * The present method allows callers to add a reference to a resource URI
   * with the same relationship to the enclosing SBML object.  (In other
   * words, the argument to this method is a <span class='code'
   * style='background-color: #d0d0ee'>resource URI</span> as shown in the
   * XML fragment above.)  Resources are stored in this CVTerm object
   * within an XMLAttributes object.
   * 
   * The relationship of this CVTerm to the enclosing SBML object can be
   * determined using the CVTerm methods such as getModelQualifierType()
   * and getBiologicalQualifierType().
   *
   * @param resource a string representing the URI of the resource and data
   * item being referenced; e.g.,
   * <code>'http://www.geneontology.org/#GO:0005892'</code>.
   *
   * @return integer value indicating success/failure of the call. The
   * possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see getResources()
   * @see removeResource(string resource)
   * @see getQualifierType()
   * @see getModelQualifierType()
   * @see getBiologicalQualifierType()
   */ public
 int addResource(string resource) {
    int ret = libsbmlPINVOKE.CVTerm_addResource(swigCPtr, resource);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Removes a resource URI from the set of resources stored in this CVTerm
   * object.
   *
   * @param resource a string representing the resource URI to remove;
   * e.g., <code>'http://www.geneontology.org/#GO:0005892'</code>.
   *
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @see addResource(string resource)
   */ public
 int removeResource(string resource) {
    int ret = libsbmlPINVOKE.CVTerm_removeResource(swigCPtr, resource);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required elements for this
   * CVTerm object have been set.
   *
   * @note The required attributes for a CVTerm are:
   * @li a <em>qualifier type</em>, which can be either a model qualifier or a biological qualifier
   * @li at least one resource
   */ public
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.CVTerm_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool hasBeenModified() {
    bool ret = libsbmlPINVOKE.CVTerm_hasBeenModified(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void resetModifiedFlags() {
    libsbmlPINVOKE.CVTerm_resetModifiedFlags(swigCPtr);
  }

}

}
