// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/cxfa_encryptionmethods.h"

namespace {

const CXFA_Node::AttributeData kEncryptionMethodsAttributeData[] = {
    {XFA_Attribute::Id, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Use, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Type, XFA_AttributeType::Enum,
     (void*)XFA_AttributeEnum::Optional},
    {XFA_Attribute::Usehref, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Unknown, XFA_AttributeType::Integer, nullptr}};

constexpr wchar_t kEncryptionMethodsName[] = L"encryptionMethods";

}  // namespace

CXFA_EncryptionMethods::CXFA_EncryptionMethods(CXFA_Document* doc,
                                               XFA_PacketType packet)
    : CXFA_Node(doc,
                packet,
                (XFA_XDPPACKET_Template | XFA_XDPPACKET_Form),
                XFA_ObjectType::Node,
                XFA_Element::EncryptionMethods,
                nullptr,
                kEncryptionMethodsAttributeData,
                kEncryptionMethodsName) {}

CXFA_EncryptionMethods::~CXFA_EncryptionMethods() {}
