/*
    $Id: nss-shadow.h,v 1.1 2001/11/09 17:09:28 loic Exp $
    $Source: /cvsroot/nss-mysql/nss-mysql/nss-shadow.h,v $
    $Date: 2001/11/09 17:09:28 $
    $Author: loic $
*/

#ifndef _HAVE_NSS_MYSQL_SHADOW_H
#define _HAVE_NSS_MYSQL_SHADOW_H

#include <mysql/mysql.h>
#include <shadow.h>
#include <pthread.h>

struct shadowoptions {
    char * host; /* DB Host */
    char * where; /* additional WHERE clause */
    char * database; /* db name */
    char * dbuser;  /* connect to db as this user */
    char * dbpasswd; /* password of the user */
    char * table; /* table */
    char * usercolumn; /* user field */
    char * passwdcolumn; /* password field */
    char * useridcolumn; /* userid column */
	char * lastchange; /* Date of last change */
	char * min; /* Minimum number of days between changes */
	char * max; /* Maximum number of days between changes */
	char * warn; /*  Number of days to warn user to change the password */
	char * inact; /* Number of days the account may be inactive. */
	char * expire; /* * Number of days since 1970-01-01 until account expired */
};


enum nss_status _nss_mysql_shadow_fill_struct (const char * name, char * secure_name, int,struct spwd *spw, int * errnop,MYSQL *,struct shadowoptions *,pthread_mutex_t *);
#endif
