#include <sys/types.h>
#include <unistd.h>
#include <libnjb.h>
#include <stdlib.h>

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES];
	njb_t *njb;
	int n, opt, debug;
	extern char *optarg;
	u_int64_t total;
	u_int64_t free;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: handshake [ -D debuglvl ]\n");
			return 1;
		}
	}

	if ( debug ) NJB_Set_Debug(debug);

	if ( NJB_Discover(njbs, 0, &n) == -1 ) {
		njb_error_dump(stderr);
	}


	njb= &njbs[0];

       	if ( NJB_Open(njb) == -1 ) {
       		njb_error_dump(stderr);
       		return 1;
       	}

	if (NJB_Get_Disk_Usage(njb, &total, &free) == -1) {
       		njb_error_dump(stderr);
       		return 1;
	}

       	printf("Total bytes on jukebox: %llu (%llu MB)\n",
	       total, total/(1024*1024));
       	printf("Free bytes on jukebox: %llu (%llu MB)\n",
	       free, free/(1024*1024));

       	NJB_Close(njb);

	return 0;
}

