#include <string.h>
#include <libnjb.h>
#include <getopt.h>

extern int njb_error;

int main (int argc, char **argv)
{
	njb_t njbs[NJB_MAX_DEVICES], *njb;
	extern char *optarg;
	int opt;
	int n, debug, rc = 1;
	songid_t *songtag;
	char *lang;

	debug= 0;
	while ( (opt= getopt(argc, argv, "D:")) != -1 ) {
		switch (opt) {
		case 'D':
			debug= atoi(optarg);
			break;
		default:
			fprintf(stderr, "usage: tracks [ -D debuglvl ]\n");
			return 1;
		}
	}

	if ( debug ) NJB_Set_Debug(debug);

	/*
	 * Check environment variables $LANG and $LC_CTYPE
	 * to see if we want to support UTF-8 unicode
	 * $LANG = "xx_XX.UTF-8" or $LC_CTYPE = "?"
	 * trigger unicode support.
	 */
	lang = getenv("LANG");
	if (lang != NULL) {
	  if (strlen(lang) > 5) {
	    if (!strcmp(&lang[strlen(lang)-5], "UTF-8")) {
	       NJB_Set_Unicode(NJB_UC_UTF8);
	    }
	  }
	}

	if ( NJB_Discover(njbs, 0, &n) == -1 ) njb_error_dump(stderr);

	if ( n == 0 ) {
		fprintf(stderr, "no NJB devices found\n");
		return 0;
	} 

	njb= njbs;

	if ( NJB_Open(njb) == -1 ) {
		njb_error_dump(stderr);
		return 1;
	}

	if ( NJB_Capture(njb) == -1 ) {
		njb_error_dump(stderr);
		goto err1;
	}

	n = 0;
	NJB_Reset_Get_Track_Tag(njb);
	while ( (songtag= NJB_Get_Track_Tag(njb)) ) {
		songid_dump(songtag, stdout);
		songid_destroy(songtag);
		printf("----------------------------------\n");
		n ++;
	}
	if ( njb_error != EO_EOM ) njb_error_dump(stderr);
	printf("In total: %u tracks.\n", n);

	NJB_Release(njb);
	rc = 0;

err1:
	NJB_Close(njb);
	return rc;
}

