with Ada.Text_IO;              use Ada.Text_IO;
with GNATCOLL.Scripts;         use GNATCOLL.Scripts;
with GNATCOLL.Scripts.Python;  use GNATCOLL.Scripts.Python;
with GNATCOLL.Traces;          use GNATCOLL.Traces;
with TestConsole;              use TestConsole;
with Support;                  use Support;

procedure Leaks is
   procedure MyClass_Handler
      (Data : in out Callback_Data'Class; Command : String);
   procedure Cache_Handler
      (Data : in out Callback_Data'Class; Command : String);

   Class_MyClass, Class_Cache   : Class_Type;

   procedure MyClass_Handler
      (Data : in out Callback_Data'Class; Command : String)
   is
      CI : Class_Instance;
   begin
      if Command = Constructor_Method then
         Put_Line ("MyClass.__init__");
         Flush;
      elsif Command = Destructor_Method then
         Put_Line ("MyClass.__del__");
         Flush;
      elsif Command = "get" then
         CI := New_Instance (Get_Script (Data), Class_MyClass);
         Set_Return_Value (Data, CI);
      end if;
   end MyClass_Handler;

   procedure Cache_Handler
      (Data : in out Callback_Data'Class; Command : String)
   is
      CI  : Class_Instance;
      Tmp : Cache_Data_Access;
   begin
      if Command = Constructor_Method then
         raise Program_Error;
      elsif Command = Destructor_Method then
         Put_Line ("Cache.__del__");
         Flush;
      elsif Command = "value" then
         CI := Nth_Arg (Data, 1);
         Tmp := Get_Data (CI);
         if Tmp /= null then
            Set_Return_Value (Data, Tmp.Data);
         else
            Set_Return_Value (Data, -1);
         end if;
      elsif Command = "get" then
         Tmp := Lookup;
         CI := Get (Tmp.Inst.all, Get_Script (Data));
         if CI = No_Class_Instance then
            CI := New_Instance (Get_Script (Data), Class_Cache);
            Set_Data (CI, Tmp);
         end if;
         Set_Return_Value (Data, CI);
      elsif Command = "destroy" then
         Tmp := Lookup;
         Destroy (Tmp);
      end if;
   end Cache_Handler;

   Repo    : Scripts_Repository := new Scripts_Repository_Record;
   Console : aliased Test_Console;
   Errors  : Boolean;

begin
   GNATCOLL.Traces.Parse_Config_File;
   --  Set_Active (Create ("SCRIPTS"), True);
   --  Set_Active (Create ("PYTHON"), True);

   Register_Python_Scripting (Repo, "GPS");
   Set_Default_Console
      (Lookup_Scripting_Language (Repo, "python"), Console'Unchecked_Access);

   Class_MyClass := New_Class (Repo, "MyClass");
   Register_Command
      (Repo, Constructor_Method, Class => Class_MyClass,
       Handler => MyClass_Handler'Unrestricted_Access);
   Register_Command
      (Repo, Destructor_Method, Class => Class_MyClass,
       Handler => MyClass_Handler'Unrestricted_Access);
   Register_Command
      (Repo, "get", Class => Class_MyClass, Static_Method => True,
       Handler => MyClass_Handler'Unrestricted_Access);

   Class_Cache := New_Class (Repo, "Cache");
   Register_Command
      (Repo, Constructor_Method, Class => Class_Cache,
       Handler => Cache_Handler'Unrestricted_Access);
   Register_Command
      (Repo, Destructor_Method, Class => Class_Cache,
       Handler => Cache_Handler'Unrestricted_Access);
   Register_Command
      (Repo, "get", Class => Class_Cache, Static_Method => True,
       Handler => Cache_Handler'Unrestricted_Access);
   Register_Command
      (Repo, "value", Class => Class_Cache,
       Handler => Cache_Handler'Unrestricted_Access);
   Register_Command
      (Repo, "destroy", Class => Class_Cache,
       Handler => Cache_Handler'Unrestricted_Access);

   Execute_File
      (Script        => Lookup_Scripting_Language (Repo, "python"),
       Filename     => "test.py",
       Show_Command => True,
       Errors       => Errors);

   Free (Console);
   Destroy (Repo);
end Leaks;
