; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32d | FileCheck -check-prefixes=CHECKIFD,RV32IFD %s
; RUN: llc -mtriple=riscv64 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d | FileCheck -check-prefixes=CHECKIFD,RV64IFD %s
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

define float @fcvt_s_d(double %a) nounwind {
; CHECKIFD-LABEL: fcvt_s_d:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.s.d fa0, fa0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_s_d:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __truncdfsf2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_s_d:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __truncdfsf2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptrunc double %a to float
  ret float %1
}

define double @fcvt_d_s(float %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_s:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.s fa0, fa0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_s:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __extendsfdf2@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_s:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __extendsfdf2@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fpext float %a to double
  ret double %1
}

define i32 @fcvt_w_d(double %a) nounwind {
; CHECKIFD-LABEL: fcvt_w_d:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_d:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_d:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixdfsi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi double %a to i32
  ret i32 %1
}

define i32 @fcvt_w_d_sat(double %a) nounwind {
; CHECKIFD-LABEL: fcvt_w_d_sat:
; CHECKIFD:       # %bb.0: # %start
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECKIFD-NEXT:    feq.d a1, fa0, fa0
; CHECKIFD-NEXT:    seqz a1, a1
; CHECKIFD-NEXT:    addi a1, a1, -1
; CHECKIFD-NEXT:    and a0, a1, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_d_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a3, 269824
; RV32I-NEXT:    addi a3, a3, -1
; RV32I-NEXT:    lui a2, 1047552
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    lui a3, 794112
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s4, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    bgez s4, .LBB3_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s3, 524288
; RV32I-NEXT:  .LBB3_2: # %start
; RV32I-NEXT:    blez s2, .LBB3_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    addi s3, a0, -1
; RV32I-NEXT:  .LBB3_4: # %start
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __unorddf2@plt
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_d_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    li a1, -497
; RV64I-NEXT:    slli a1, a1, 53
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui s3, 524288
; RV64I-NEXT:    bgez s2, .LBB3_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    lui s1, 524288
; RV64I-NEXT:  .LBB3_2: # %start
; RV64I-NEXT:    li a0, 527
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    slli a1, a0, 22
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB3_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    addiw s1, s3, -1
; RV64I-NEXT:  .LBB3_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unorddf2@plt
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptosi.sat.i32.f64(double %a)
  ret i32 %0
}
declare i32 @llvm.fptosi.sat.i32.f64(double)

; For RV64D, fcvt.lu.d is semantically equivalent to fcvt.wu.d in this case
; because fptosi will produce poison if the result doesn't fit into an i32.
define i32 @fcvt_wu_d(double %a) nounwind {
; CHECKIFD-LABEL: fcvt_wu_d:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_d:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_d:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunsdfsi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui double %a to i32
  ret i32 %1
}

; Test where the fptoui has multiple uses, one of which causes a sext to be
; inserted on RV64.
define i32 @fcvt_wu_d_multiple_use(double %x, ptr %y) nounwind {
; CHECKIFD-LABEL: fcvt_wu_d_multiple_use:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; CHECKIFD-NEXT:    bnez a0, .LBB5_2
; CHECKIFD-NEXT:  # %bb.1:
; CHECKIFD-NEXT:    li a0, 1
; CHECKIFD-NEXT:  .LBB5_2:
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_d_multiple_use:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    bnez a0, .LBB5_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:  .LBB5_2:
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_d_multiple_use:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunsdfsi@plt
; RV64I-NEXT:    bnez a0, .LBB5_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:  .LBB5_2:
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %a = fptoui double %x to i32
  %b = icmp eq i32 %a, 0
  %c = select i1 %b, i32 1, i32 %a
  ret i32 %c
}

define i32 @fcvt_wu_d_sat(double %a) nounwind {
; RV32IFD-LABEL: fcvt_wu_d_sat:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV32IFD-NEXT:    feq.d a1, fa0, fa0
; RV32IFD-NEXT:    seqz a1, a1
; RV32IFD-NEXT:    addi a1, a1, -1
; RV32IFD-NEXT:    and a0, a1, a0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_wu_d_sat:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV64IFD-NEXT:    feq.d a1, fa0, fa0
; RV64IFD-NEXT:    seqz a1, a1
; RV64IFD-NEXT:    addiw a1, a1, -1
; RV64IFD-NEXT:    and a0, a0, a1
; RV64IFD-NEXT:    slli a0, a0, 32
; RV64IFD-NEXT:    srli a0, a0, 32
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_d_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a3, 270080
; RV32I-NEXT:    addi a3, a3, -1
; RV32I-NEXT:    lui a2, 1048064
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg s2, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi s3, a0, -1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    and a0, s3, a0
; RV32I-NEXT:    or a0, s2, a0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_d_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    li a0, 1055
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    slli a1, a0, 21
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB6_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    j .LBB6_3
; RV64I-NEXT:  .LBB6_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB6_3: # %start
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptoui.sat.i32.f64(double %a)
  ret i32 %0
}
declare i32 @llvm.fptoui.sat.i32.f64(double)

define double @fcvt_d_w(i32 %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_w:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.w fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_w:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_w:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    call __floatsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i32 %a to double
  ret double %1
}

define double @fcvt_d_w_load(ptr %p) nounwind {
; CHECKIFD-LABEL: fcvt_d_w_load:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    lw a0, 0(a0)
; CHECKIFD-NEXT:    fcvt.d.w fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_w_load:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    call __floatsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_w_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    call __floatsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %a = load i32, ptr %p
  %1 = sitofp i32 %a to double
  ret double %1
}

define double @fcvt_d_wu(i32 %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_wu:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.wu fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_wu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatunsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_wu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    call __floatunsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i32 %a to double
  ret double %1
}

define double @fcvt_d_wu_load(ptr %p) nounwind {
; RV32IFD-LABEL: fcvt_d_wu_load:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    lw a0, 0(a0)
; RV32IFD-NEXT:    fcvt.d.wu fa0, a0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_d_wu_load:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    lwu a0, 0(a0)
; RV64IFD-NEXT:    fcvt.d.wu fa0, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_wu_load:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    call __floatunsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_wu_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    call __floatunsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %a = load i32, ptr %p
  %1 = uitofp i32 %a to double
  ret double %1
}

define i64 @fcvt_l_d(double %a) nounwind {
; RV32IFD-LABEL: fcvt_l_d:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call __fixdfdi@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_l_d:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_l_d:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixdfdi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_l_d:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi double %a to i64
  ret i64 %1
}

define i64 @fcvt_l_d_sat(double %a) nounwind {
; RV32IFD-LABEL: fcvt_l_d_sat:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; RV32IFD-NEXT:    lui a0, %hi(.LCPI12_0)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI12_0)(a0)
; RV32IFD-NEXT:    fmv.d fs0, fa0
; RV32IFD-NEXT:    fle.d s0, ft0, fa0
; RV32IFD-NEXT:    call __fixdfdi@plt
; RV32IFD-NEXT:    lui a3, 524288
; RV32IFD-NEXT:    bnez s0, .LBB12_2
; RV32IFD-NEXT:  # %bb.1: # %start
; RV32IFD-NEXT:    lui a1, 524288
; RV32IFD-NEXT:  .LBB12_2: # %start
; RV32IFD-NEXT:    lui a2, %hi(.LCPI12_1)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI12_1)(a2)
; RV32IFD-NEXT:    flt.d a2, ft0, fs0
; RV32IFD-NEXT:    beqz a2, .LBB12_4
; RV32IFD-NEXT:  # %bb.3:
; RV32IFD-NEXT:    addi a1, a3, -1
; RV32IFD-NEXT:  .LBB12_4: # %start
; RV32IFD-NEXT:    feq.d a3, fs0, fs0
; RV32IFD-NEXT:    seqz a3, a3
; RV32IFD-NEXT:    addi a3, a3, -1
; RV32IFD-NEXT:    and a1, a3, a1
; RV32IFD-NEXT:    neg a2, a2
; RV32IFD-NEXT:    neg a4, s0
; RV32IFD-NEXT:    and a0, a4, a0
; RV32IFD-NEXT:    or a0, a2, a0
; RV32IFD-NEXT:    and a0, a3, a0
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_l_d_sat:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    feq.d a1, fa0, fa0
; RV64IFD-NEXT:    seqz a1, a1
; RV64IFD-NEXT:    addi a1, a1, -1
; RV64IFD-NEXT:    and a0, a1, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_l_d_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui s2, 278016
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    li a2, -1
; RV32I-NEXT:    mv a3, s2
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s4, a0
; RV32I-NEXT:    lui a3, 802304
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s6, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixdfdi@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv s5, a1
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    bgez s6, .LBB12_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s5, 524288
; RV32I-NEXT:  .LBB12_2: # %start
; RV32I-NEXT:    blez s4, .LBB12_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    addi s5, a0, -1
; RV32I-NEXT:  .LBB12_4: # %start
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __unorddf2@plt
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and s4, a0, s5
; RV32I-NEXT:    lui a3, 802304
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and s3, a0, s3
; RV32I-NEXT:    li a2, -1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a3, s2
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg a0, a0
; RV32I-NEXT:    or s2, a0, s3
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __unorddf2@plt
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s2
; RV32I-NEXT:    mv a1, s4
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_l_d_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    li a1, -481
; RV64I-NEXT:    slli a1, a1, 53
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    li s3, -1
; RV64I-NEXT:    bgez s2, .LBB12_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    slli s1, s3, 63
; RV64I-NEXT:  .LBB12_2: # %start
; RV64I-NEXT:    li a0, 543
; RV64I-NEXT:    slli a0, a0, 53
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB12_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    srli s1, s3, 1
; RV64I-NEXT:  .LBB12_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unorddf2@plt
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
start:
  %0 = tail call i64 @llvm.fptosi.sat.i64.f64(double %a)
  ret i64 %0
}
declare i64 @llvm.fptosi.sat.i64.f64(double)

define i64 @fcvt_lu_d(double %a) nounwind {
; RV32IFD-LABEL: fcvt_lu_d:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call __fixunsdfdi@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_lu_d:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_lu_d:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunsdfdi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_lu_d:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui double %a to i64
  ret i64 %1
}

define i64 @fcvt_lu_d_sat(double %a) nounwind {
; RV32IFD-LABEL: fcvt_lu_d_sat:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; RV32IFD-NEXT:    fmv.d fs0, fa0
; RV32IFD-NEXT:    fcvt.d.w ft0, zero
; RV32IFD-NEXT:    fle.d a0, ft0, fa0
; RV32IFD-NEXT:    neg s0, a0
; RV32IFD-NEXT:    call __fixunsdfdi@plt
; RV32IFD-NEXT:    lui a2, %hi(.LCPI14_0)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI14_0)(a2)
; RV32IFD-NEXT:    and a0, s0, a0
; RV32IFD-NEXT:    flt.d a2, ft0, fs0
; RV32IFD-NEXT:    neg a2, a2
; RV32IFD-NEXT:    or a0, a2, a0
; RV32IFD-NEXT:    and a1, s0, a1
; RV32IFD-NEXT:    or a1, a2, a1
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_lu_d_sat:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    feq.d a1, fa0, fa0
; RV64IFD-NEXT:    seqz a1, a1
; RV64IFD-NEXT:    addi a1, a1, -1
; RV64IFD-NEXT:    and a0, a1, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_lu_d_sat:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui s2, 278272
; RV32I-NEXT:    addi s2, s2, -1
; RV32I-NEXT:    li a2, -1
; RV32I-NEXT:    mv a3, s2
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg s4, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi s5, a0, -1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixunsdfdi@plt
; RV32I-NEXT:    mv s3, a1
; RV32I-NEXT:    and a0, s5, a0
; RV32I-NEXT:    or s4, s4, a0
; RV32I-NEXT:    li a2, -1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a3, s2
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg s2, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    or a1, s2, a0
; RV32I-NEXT:    mv a0, s4
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_lu_d_sat:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    slti a0, a0, 0
; RV64I-NEXT:    addi s1, a0, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    and s1, s1, a0
; RV64I-NEXT:    li a0, 1087
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    sgtz a0, a0
; RV64I-NEXT:    neg a0, a0
; RV64I-NEXT:    or a0, a0, s1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i64 @llvm.fptoui.sat.i64.f64(double %a)
  ret i64 %0
}
declare i64 @llvm.fptoui.sat.i64.f64(double)

define i64 @fmv_x_d(double %a, double %b) nounwind {
; RV32IFD-LABEL: fmv_x_d:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    fadd.d ft0, fa0, fa1
; RV32IFD-NEXT:    fsd ft0, 8(sp)
; RV32IFD-NEXT:    lw a0, 8(sp)
; RV32IFD-NEXT:    lw a1, 12(sp)
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fmv_x_d:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fadd.d ft0, fa0, fa1
; RV64IFD-NEXT:    fmv.x.d a0, ft0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fmv_x_d:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __adddf3@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmv_x_d:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __adddf3@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fadd double %a, %b
  %2 = bitcast double %1 to i64
  ret i64 %2
}

define double @fcvt_d_l(i64 %a) nounwind {
; RV32IFD-LABEL: fcvt_d_l:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call __floatdidf@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_d_l:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.d.l fa0, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_l:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatdidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_l:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatdidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i64 %a to double
  ret double %1
}

define double @fcvt_d_lu(i64 %a) nounwind {
; RV32IFD-LABEL: fcvt_d_lu:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call __floatundidf@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_d_lu:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.d.lu fa0, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_lu:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatundidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_lu:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatundidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i64 %a to double
  ret double %1
}

define double @fmv_d_x(i64 %a, i64 %b) nounwind {
; Ensure fmv.w.x is generated even for a soft double calling convention
; RV32IFD-LABEL: fmv_d_x:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw a3, 4(sp)
; RV32IFD-NEXT:    sw a2, 0(sp)
; RV32IFD-NEXT:    sw a1, 12(sp)
; RV32IFD-NEXT:    sw a0, 8(sp)
; RV32IFD-NEXT:    fld ft0, 0(sp)
; RV32IFD-NEXT:    fld ft1, 8(sp)
; RV32IFD-NEXT:    fadd.d fa0, ft1, ft0
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fmv_d_x:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fmv.d.x ft0, a0
; RV64IFD-NEXT:    fmv.d.x ft1, a1
; RV64IFD-NEXT:    fadd.d fa0, ft0, ft1
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fmv_d_x:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __adddf3@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmv_d_x:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __adddf3@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = bitcast i64 %a to double
  %2 = bitcast i64 %b to double
  %3 = fadd double %1, %2
  ret double %3
}

define double @fcvt_d_w_i8(i8 signext %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_w_i8:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.w fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_w_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_w_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i8 %a to double
  ret double %1
}

define double @fcvt_d_wu_i8(i8 zeroext %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_wu_i8:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.wu fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_wu_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatunsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_wu_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatunsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i8 %a to double
  ret double %1
}

define double @fcvt_d_w_i16(i16 signext %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_w_i16:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.w fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_w_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_w_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = sitofp i16 %a to double
  ret double %1
}

define double @fcvt_d_wu_i16(i16 zeroext %a) nounwind {
; CHECKIFD-LABEL: fcvt_d_wu_i16:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fcvt.d.wu fa0, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_wu_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __floatunsidf@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_wu_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __floatunsidf@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = uitofp i16 %a to double
  ret double %1
}

; Make sure we select W version of addi on RV64.
define signext i32 @fcvt_d_w_demanded_bits(i32 signext %0, ptr %1) nounwind {
; RV32IFD-LABEL: fcvt_d_w_demanded_bits:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a0, a0, 1
; RV32IFD-NEXT:    fcvt.d.w ft0, a0
; RV32IFD-NEXT:    fsd ft0, 0(a1)
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_d_w_demanded_bits:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addiw a0, a0, 1
; RV64IFD-NEXT:    fcvt.d.w ft0, a0
; RV64IFD-NEXT:    fsd ft0, 0(a1)
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_w_demanded_bits:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    addi s1, a0, 1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __floatsidf@plt
; RV32I-NEXT:    sw a1, 4(s0)
; RV32I-NEXT:    sw a0, 0(s0)
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_w_demanded_bits:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    addiw s1, a0, 1
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __floatsidf@plt
; RV64I-NEXT:    sd a0, 0(s0)
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %3 = add i32 %0, 1
  %4 = sitofp i32 %3 to double
  store double %4, ptr %1, align 8
  ret i32 %3
}

; Make sure we select W version of addi on RV64.
define signext i32 @fcvt_d_wu_demanded_bits(i32 signext %0, ptr %1) nounwind {
; RV32IFD-LABEL: fcvt_d_wu_demanded_bits:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi a0, a0, 1
; RV32IFD-NEXT:    fcvt.d.wu ft0, a0
; RV32IFD-NEXT:    fsd ft0, 0(a1)
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_d_wu_demanded_bits:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addiw a0, a0, 1
; RV64IFD-NEXT:    fcvt.d.wu ft0, a0
; RV64IFD-NEXT:    fsd ft0, 0(a1)
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_d_wu_demanded_bits:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    addi s1, a0, 1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    call __floatunsidf@plt
; RV32I-NEXT:    sw a1, 4(s0)
; RV32I-NEXT:    sw a0, 0(s0)
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_d_wu_demanded_bits:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a1
; RV64I-NEXT:    addiw s1, a0, 1
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __floatunsidf@plt
; RV64I-NEXT:    sd a0, 0(s0)
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %3 = add i32 %0, 1
  %4 = uitofp i32 %3 to double
  store double %4, ptr %1, align 8
  ret i32 %3
}

define signext i16 @fcvt_w_s_i16(double %a) nounwind {
; RV32IFD-LABEL: fcvt_w_s_i16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_w_s_i16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi double %a to i16
  ret i16 %1
}

define signext i16 @fcvt_w_s_sat_i16(double %a) nounwind {
; RV32IFD-LABEL: fcvt_w_s_sat_i16:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    lui a0, %hi(.LCPI26_0)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI26_0)(a0)
; RV32IFD-NEXT:    lui a0, %hi(.LCPI26_1)
; RV32IFD-NEXT:    fld ft1, %lo(.LCPI26_1)(a0)
; RV32IFD-NEXT:    fmax.d ft0, fa0, ft0
; RV32IFD-NEXT:    fmin.d ft0, ft0, ft1
; RV32IFD-NEXT:    fcvt.w.d a0, ft0, rtz
; RV32IFD-NEXT:    feq.d a1, fa0, fa0
; RV32IFD-NEXT:    seqz a1, a1
; RV32IFD-NEXT:    addi a1, a1, -1
; RV32IFD-NEXT:    and a0, a1, a0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_w_s_sat_i16:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    lui a0, %hi(.LCPI26_0)
; RV64IFD-NEXT:    fld ft0, %lo(.LCPI26_0)(a0)
; RV64IFD-NEXT:    lui a0, %hi(.LCPI26_1)
; RV64IFD-NEXT:    fld ft1, %lo(.LCPI26_1)(a0)
; RV64IFD-NEXT:    fmax.d ft0, fa0, ft0
; RV64IFD-NEXT:    fmin.d ft0, ft0, ft1
; RV64IFD-NEXT:    fcvt.l.d a0, ft0, rtz
; RV64IFD-NEXT:    feq.d a1, fa0, fa0
; RV64IFD-NEXT:    seqz a1, a1
; RV64IFD-NEXT:    addi a1, a1, -1
; RV64IFD-NEXT:    and a0, a1, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_sat_i16:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a0, 265728
; RV32I-NEXT:    addi a3, a0, -64
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    lui a3, 790016
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s4, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    bgez s4, .LBB26_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s3, 1048568
; RV32I-NEXT:  .LBB26_2: # %start
; RV32I-NEXT:    blez s2, .LBB26_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    lui s3, 8
; RV32I-NEXT:    addi s3, s3, -1
; RV32I-NEXT:  .LBB26_4: # %start
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __unorddf2@plt
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_sat_i16:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    li a1, -505
; RV64I-NEXT:    slli a1, a1, 53
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    bgez s2, .LBB26_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    lui s1, 1048568
; RV64I-NEXT:  .LBB26_2: # %start
; RV64I-NEXT:    lui a0, 4152
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    slli a1, a0, 38
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB26_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    lui s1, 8
; RV64I-NEXT:    addiw s1, s1, -1
; RV64I-NEXT:  .LBB26_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unorddf2@plt
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i16 @llvm.fptosi.sat.i16.f64(double %a)
  ret i16 %0
}
declare i16 @llvm.fptosi.sat.i16.f64(double)

define zeroext i16 @fcvt_wu_s_i16(double %a) nounwind {
; RV32IFD-LABEL: fcvt_wu_s_i16:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_wu_s_i16:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui double %a to i16
  ret i16 %1
}

define zeroext i16 @fcvt_wu_s_sat_i16(double %a) nounwind {
; RV32IFD-LABEL: fcvt_wu_s_sat_i16:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    lui a0, %hi(.LCPI28_0)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI28_0)(a0)
; RV32IFD-NEXT:    fcvt.d.w ft1, zero
; RV32IFD-NEXT:    fmax.d ft1, fa0, ft1
; RV32IFD-NEXT:    fmin.d ft0, ft1, ft0
; RV32IFD-NEXT:    fcvt.wu.d a0, ft0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_wu_s_sat_i16:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    lui a0, %hi(.LCPI28_0)
; RV64IFD-NEXT:    fld ft0, %lo(.LCPI28_0)(a0)
; RV64IFD-NEXT:    fmv.d.x ft1, zero
; RV64IFD-NEXT:    fmax.d ft1, fa0, ft1
; RV64IFD-NEXT:    fmin.d ft0, ft1, ft0
; RV64IFD-NEXT:    fcvt.lu.d a0, ft0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_sat_i16:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    lui a3, 265984
; RV32I-NEXT:    addi a3, a3, -32
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    blez s3, .LBB28_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    j .LBB28_3
; RV32I-NEXT:  .LBB28_2:
; RV32I-NEXT:    slti a2, s0, 0
; RV32I-NEXT:    addi a2, a2, -1
; RV32I-NEXT:    and a0, a2, a0
; RV32I-NEXT:  .LBB28_3: # %start
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_sat_i16:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui a0, 8312
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    slli a1, a0, 37
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    blez a0, .LBB28_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    j .LBB28_3
; RV64I-NEXT:  .LBB28_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB28_3: # %start
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i16 @llvm.fptoui.sat.i16.f64(double %a)
  ret i16 %0
}
declare i16 @llvm.fptoui.sat.i16.f64(double)

define signext i8 @fcvt_w_s_i8(double %a) nounwind {
; RV32IFD-LABEL: fcvt_w_s_i8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_w_s_i8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptosi double %a to i8
  ret i8 %1
}

define signext i8 @fcvt_w_s_sat_i8(double %a) nounwind {
; RV32IFD-LABEL: fcvt_w_s_sat_i8:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    lui a0, %hi(.LCPI30_0)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI30_0)(a0)
; RV32IFD-NEXT:    lui a0, %hi(.LCPI30_1)
; RV32IFD-NEXT:    fld ft1, %lo(.LCPI30_1)(a0)
; RV32IFD-NEXT:    fmax.d ft0, fa0, ft0
; RV32IFD-NEXT:    fmin.d ft0, ft0, ft1
; RV32IFD-NEXT:    fcvt.w.d a0, ft0, rtz
; RV32IFD-NEXT:    feq.d a1, fa0, fa0
; RV32IFD-NEXT:    seqz a1, a1
; RV32IFD-NEXT:    addi a1, a1, -1
; RV32IFD-NEXT:    and a0, a1, a0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_w_s_sat_i8:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    lui a0, %hi(.LCPI30_0)
; RV64IFD-NEXT:    fld ft0, %lo(.LCPI30_0)(a0)
; RV64IFD-NEXT:    lui a0, %hi(.LCPI30_1)
; RV64IFD-NEXT:    fld ft1, %lo(.LCPI30_1)(a0)
; RV64IFD-NEXT:    fmax.d ft0, fa0, ft0
; RV64IFD-NEXT:    fmin.d ft0, ft0, ft1
; RV64IFD-NEXT:    fcvt.l.d a0, ft0, rtz
; RV64IFD-NEXT:    feq.d a1, fa0, fa0
; RV64IFD-NEXT:    seqz a1, a1
; RV64IFD-NEXT:    addi a1, a1, -1
; RV64IFD-NEXT:    and a0, a1, a0
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_s_sat_i8:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a3, 263676
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    lui a3, 787968
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s4, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    bgez s4, .LBB30_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    li s3, -128
; RV32I-NEXT:  .LBB30_2: # %start
; RV32I-NEXT:    blez s2, .LBB30_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    li s3, 127
; RV32I-NEXT:  .LBB30_4: # %start
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __unorddf2@plt
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_s_sat_i8:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    li a1, -509
; RV64I-NEXT:    slli a1, a1, 53
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    bgez s2, .LBB30_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li s1, -128
; RV64I-NEXT:  .LBB30_2: # %start
; RV64I-NEXT:    lui a1, 65919
; RV64I-NEXT:    slli a1, a1, 34
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB30_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    li s1, 127
; RV64I-NEXT:  .LBB30_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unorddf2@plt
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i8 @llvm.fptosi.sat.i8.f64(double %a)
  ret i8 %0
}
declare i8 @llvm.fptosi.sat.i8.f64(double)

define zeroext i8 @fcvt_wu_s_i8(double %a) nounwind {
;
;
; RV32IFD-LABEL: fcvt_wu_s_i8:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_wu_s_i8:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.lu.d a0, fa0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = fptoui double %a to i8
  ret i8 %1
}

define zeroext i8 @fcvt_wu_s_sat_i8(double %a) nounwind {
;
;
; RV32IFD-LABEL: fcvt_wu_s_sat_i8:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    lui a0, %hi(.LCPI32_0)
; RV32IFD-NEXT:    fld ft0, %lo(.LCPI32_0)(a0)
; RV32IFD-NEXT:    fcvt.d.w ft1, zero
; RV32IFD-NEXT:    fmax.d ft1, fa0, ft1
; RV32IFD-NEXT:    fmin.d ft0, ft1, ft0
; RV32IFD-NEXT:    fcvt.wu.d a0, ft0, rtz
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_wu_s_sat_i8:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    lui a0, %hi(.LCPI32_0)
; RV64IFD-NEXT:    fld ft0, %lo(.LCPI32_0)(a0)
; RV64IFD-NEXT:    fmv.d.x ft1, zero
; RV64IFD-NEXT:    fmax.d ft1, fa0, ft1
; RV64IFD-NEXT:    fmin.d ft0, ft1, ft0
; RV64IFD-NEXT:    fcvt.lu.d a0, ft0, rtz
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_s_sat_i8:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s1, a1
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    lui a3, 263934
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s0, a0
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s1
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    blez s3, .LBB32_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    li a0, 255
; RV32I-NEXT:    j .LBB32_3
; RV32I-NEXT:  .LBB32_2:
; RV32I-NEXT:    slti a1, s0, 0
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:  .LBB32_3: # %start
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_s_sat_i8:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui a1, 131967
; RV64I-NEXT:    slli a1, a1, 33
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB32_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li a0, 255
; RV64I-NEXT:    j .LBB32_3
; RV64I-NEXT:  .LBB32_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB32_3: # %start
; RV64I-NEXT:    andi a0, a0, 255
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i8 @llvm.fptoui.sat.i8.f64(double %a)
  ret i8 %0
}
declare i8 @llvm.fptoui.sat.i8.f64(double)

define zeroext i32 @fcvt_wu_d_sat_zext(double %a) nounwind {
; RV32IFD-LABEL: fcvt_wu_d_sat_zext:
; RV32IFD:       # %bb.0: # %start
; RV32IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV32IFD-NEXT:    feq.d a1, fa0, fa0
; RV32IFD-NEXT:    seqz a1, a1
; RV32IFD-NEXT:    addi a1, a1, -1
; RV32IFD-NEXT:    and a0, a1, a0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: fcvt_wu_d_sat_zext:
; RV64IFD:       # %bb.0: # %start
; RV64IFD-NEXT:    fcvt.wu.d a0, fa0, rtz
; RV64IFD-NEXT:    feq.d a1, fa0, fa0
; RV64IFD-NEXT:    seqz a1, a1
; RV64IFD-NEXT:    addiw a1, a1, -1
; RV64IFD-NEXT:    and a0, a0, a1
; RV64IFD-NEXT:    slli a0, a0, 32
; RV64IFD-NEXT:    srli a0, a0, 32
; RV64IFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_wu_d_sat_zext:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a3, 270080
; RV32I-NEXT:    addi a3, a3, -1
; RV32I-NEXT:    lui a2, 1048064
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    sgtz a0, a0
; RV32I-NEXT:    neg s2, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    li a3, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    slti a0, a0, 0
; RV32I-NEXT:    addi s3, a0, -1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixunsdfsi@plt
; RV32I-NEXT:    and a0, s3, a0
; RV32I-NEXT:    or a0, s2, a0
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_wu_d_sat_zext:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    li a1, 0
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __fixunsdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    li a0, 1055
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    slli a1, a0, 21
; RV64I-NEXT:    mv a0, s2
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB33_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    li a0, -1
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    j .LBB33_3
; RV64I-NEXT:  .LBB33_2:
; RV64I-NEXT:    slti a0, s0, 0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:  .LBB33_3: # %start
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptoui.sat.i32.f64(double %a)
  ret i32 %0
}

define signext i32 @fcvt_w_d_sat_sext(double %a) nounwind {
; CHECKIFD-LABEL: fcvt_w_d_sat_sext:
; CHECKIFD:       # %bb.0: # %start
; CHECKIFD-NEXT:    fcvt.w.d a0, fa0, rtz
; CHECKIFD-NEXT:    feq.d a1, fa0, fa0
; CHECKIFD-NEXT:    seqz a1, a1
; CHECKIFD-NEXT:    addi a1, a1, -1
; CHECKIFD-NEXT:    and a0, a1, a0
; CHECKIFD-NEXT:    ret
;
; RV32I-LABEL: fcvt_w_d_sat_sext:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    lui a3, 269824
; RV32I-NEXT:    addi a3, a3, -1
; RV32I-NEXT:    lui a2, 1047552
; RV32I-NEXT:    call __gtdf2@plt
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    lui a3, 794112
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    li a2, 0
; RV32I-NEXT:    call __gedf2@plt
; RV32I-NEXT:    mv s4, a0
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call __fixdfsi@plt
; RV32I-NEXT:    mv s3, a0
; RV32I-NEXT:    lui a0, 524288
; RV32I-NEXT:    bgez s4, .LBB34_2
; RV32I-NEXT:  # %bb.1: # %start
; RV32I-NEXT:    lui s3, 524288
; RV32I-NEXT:  .LBB34_2: # %start
; RV32I-NEXT:    blez s2, .LBB34_4
; RV32I-NEXT:  # %bb.3: # %start
; RV32I-NEXT:    addi s3, a0, -1
; RV32I-NEXT:  .LBB34_4: # %start
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __unorddf2@plt
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a0, s3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fcvt_w_d_sat_sext:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    addi sp, sp, -48
; RV64I-NEXT:    sd ra, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    li a1, -497
; RV64I-NEXT:    slli a1, a1, 53
; RV64I-NEXT:    call __gedf2@plt
; RV64I-NEXT:    mv s2, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __fixdfdi@plt
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    lui s3, 524288
; RV64I-NEXT:    bgez s2, .LBB34_2
; RV64I-NEXT:  # %bb.1: # %start
; RV64I-NEXT:    lui s1, 524288
; RV64I-NEXT:  .LBB34_2: # %start
; RV64I-NEXT:    li a0, 527
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    slli a1, a0, 22
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call __gtdf2@plt
; RV64I-NEXT:    blez a0, .LBB34_4
; RV64I-NEXT:  # %bb.3: # %start
; RV64I-NEXT:    addiw s1, s3, -1
; RV64I-NEXT:  .LBB34_4: # %start
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __unorddf2@plt
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addiw a0, a0, -1
; RV64I-NEXT:    and a0, a0, s1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    ld ra, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 48
; RV64I-NEXT:    ret
start:
  %0 = tail call i32 @llvm.fptosi.sat.i32.f64(double %a)
  ret i32 %0
}
